/* dos emulator, Matthias Lautner */

#include <linux/vm86.h>

#define _regs	vm86s.regs

#define us unsigned short
#define SEG_ADR(type, seg, reg) type((int)(*(us *)&_regs.seg<<4)\
				 + *(us *)&_regs.e##reg)
#define SP_ADR (unsigned short *) (((_regs.ss<< 4) + _regs.esp) & 0xfffff)

#define LO(reg)		(int)(*(unsigned char *)&_regs.e##reg)
#define HI(reg)		(int)(*((unsigned char *)&_regs.e##reg +1))
#define CF 0x01
#define ZF 0x40
#define SF 0x80
#define TF 0x100
#define IF 0x200
#define VM 0x20000
#define CARRY	_regs.eflags|=CF;
#define NOCARRY	_regs.eflags&=~CF;
#define ISEG(i) ivecs[i].segment
#define IVEC(i) ((ISEG(i)<<4) + IOFF(i))
#define IOFF(i) ivecs[i].offset
#define WORD(i) (i&0xffff)
#define LWORD(reg)      (*( (unsigned short *)&(vm86s.regs.reg)  ))

extern struct vm86_struct vm86s;
extern int error, c_screen;

#include "disk.h"

void show_regs(void);
int ext_fs(int, char *, char *, int);
void char_out(unsigned char, int);
int outc(int c);
void termioInit();
void termioClose();
#define NOWAIT  0
#define WAIT    1
#define TEST    2
int ReadKeyboard(int *, int);
void ReadString(int, char *);
#define warn printf
#define h_printf printf
#define s_printf printf
#define g_printf printf
#define i_printf printf
#define k_printf printf
#define x_printf printf
#define v_printf printf
#define dbug_printf printf
#define W_printf printf
#define er_printf printf 
extern void d_printf();
