/* 
 * Network accounting
 * netacct.h - header file *
 * (C) 1994 Ulrich Callmeier
 */

#include <syslog.h>
#include <time.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/protocols.h>
#include <linux/if.h>
#include <linux/if_ether.h>
#include <linux/ip.h>
#include <linux/tcp.h>

#define DEF_ACCTTAB "/etc/naccttab"
#define PID_FILE "/var/run/nacctd.pid"

/* default settings for naccttab */
#define DEFAULT_IGNOREMASK "255.255.255.0"
#define DEFAULT_FLUSH 300
#define DEFAULT_ERR_DELAY 3
#define DEFAULT_FDELAY 60

#define FORCE_STAT_TIME 5

struct ipnetwork
{
    unsigned long netnumber, netmask;
    struct ipnetwork *next;
};

struct promisc_device
{
    char *name; /* name (e.g. eth0) */

    int reset; /* do we have to reset it on exit ? */
    struct ifreq oldifr; /* old settings */
    
    struct promisc_device *next;
};

struct config
{
    char *filename;
    char *dumpname;
    int flush; /* in seconds */
    int fdelay; /* in seconds */
    unsigned long int ignoremask;
    int err_delay; /* how many cycles to delay on error ? */
    struct ipnetwork *ignorenet;
    struct promisc_device *promisc;
};

struct dev2line
{
    char *netinterface;
    char *line;
    
    struct dev2line *next;
};

struct dynadat
{
    char *netinterface;
    time_t last_stat, mtime;

    char *user;

    struct dynadat *next;
};

struct statistics
{
    unsigned long int unenc;
    unsigned long int ignored, netignored, local, ip, dropped;		/* sum = total */
    unsigned long int ip_udp, ip_tcp, ip_icmp, ip_other;	/* sum = ip */
};

struct ipdata
{
    unsigned long int src, dst;
    unsigned char proto;
    unsigned short srcport, dstport;
    unsigned long int bytes;
    char *devname;
    char *user;
    
    time_t when;

    struct ipdata *next;
};

extern char *rcs_revision_config_c;
extern char *rcs_revision_daemon_c;
extern char *rcs_revision_capture_c;
extern char *rcs_revision_main_c;

extern char *progname;
extern struct config *cfg; 
extern volatile int debug_level;
extern int capture_sd;
extern struct dev2line *dev2line;

/* capture.c */
void init_capture(void);
void do_acct(void);
void exit_capture(void);
void write_log(int force);
void alarm_handler(int sig);
void child_finished(int sig);
void signal_debug(int sig);
void signal_ignore(int sig);

/* daemon.c */
int daemon_start(void);
void daemon_stop(int sig);

/* config.c */
struct config *read_config(char *fname);

/* utils.c */
char *ip_proto_name(unsigned char proto);
char *intoa(unsigned long addr);
char * etheraddr_string(unsigned char *ep);




