/* 
 * Network accounting
 * daemon.c - Utilities for a daemon process.
 * (C) 1994 Ulrich Callmeier
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/param.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <linux/time.h>
#include "netacct.h"

char *rcs_revision_daemon_c = "$Revision: 1.6 $";

int daemon_start(void)
{
    int i;
    pid_t pid;
    
    if( (pid = fork()) < 0)
        return(-1);
    else if (pid!=0)
        exit(0);

    closelog();

    for(i=0; i<FD_SETSIZE; i++)
        close(i);

    setsid();

    return 0;
}

void daemon_stop(int sig)
{
    write_log(1);
    
    unlink(PID_FILE);

    syslog(LOG_INFO, "net accounting daemon terminating (%d)\n",sig);
    
    exit_capture();

    closelog();
    exit(1);
}







