/*****************************************************************************
	      idled - idle login killer daemon for the Linux OS
       (C)opyright 1994-1995, B. Scott Burkett, All Rights Reserved
 ***************************************************************************** 
 $Header: /usr3/src/idled/RCS/init.c,v 1.1 1995/03/25 05:58:16 root Exp $
 ***************************************************************************** 
 $Log: init.c,v $
 * Revision 1.1  1995/03/25  05:58:16  root
 * Initial revision
 *
 *****************************************************************************
  
   Copyright (c), 1994-1995, by B. Scott Burkett
   All rights reserved.
  
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
  
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All modifications to the source code must be clearly marked as
      such.  Binary redistributions based on modified source code
      must be clearly marked as modified versions in the documentation
      and/or other materials provided with the distribution.
   4. All advertising materials mentioning features or use of this software
      must display the following acknowledgment:
        This product includes software developed by B. Scott Burkett and
        other unpaid contributors.
   5. The name of B. Scott Burkett may not be used to endorse or promote
      products derived from this software without specific prior
      written permission.
  
   THIS SOFTWARE IS PROVIDED BY B. SCOTT BURKETT AND CONTRIBUTORS "AS IS" AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL B. SCOTT BURKETT OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.
 
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <utmp.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <utime.h>
#include <errno.h>
#include <ctype.h>
#include <regex.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/syslog.h>
#include <sys/ioctl.h>
#include <sys/param.h>

#include "idled.h"

void idled_reset(int signum);

/***************************************************************************
 *                                                                         *
 * void Init( int ac );                                                    *
 *                                                                         *
 * Responsible for initialization.  Sets signal handlers and sets up for   *
 * daemon operation.                                                       *
 *                                                                         *
 ***************************************************************************/

void Init( int ac )
{
	if( ac == 1 )
		return;

	be_daemon();
	SetSignals();
	err_sys("-----------------------");
	sprintf(buf, "Initializing idler daemon (idled %s)", VERSION);
	err_sys( buf );
	err_sys( COPYRIGHT );

	ReadCFGFile();
}

void ReadCFGFile(void)
{
	FILE *cfgfile;
	int  ndx=0;

	highentry=0;

	if((cfgfile = fopen("/etc/idled.conf", "rt")) == NULL)
	{
		err_sys("Unable to open /etc/idled.conf");
		exit(0);
	}

	while (1)
	{
		fgets(buf, 80, cfgfile);
		if(feof(cfgfile)) break;

		if(buf[0] == '#') continue;
		if(buf[0] == ';') continue;
		if(buf[0] == '%') continue;
		if(buf[0] == '\r') continue;
		if(buf[0] == '\n') continue;
		if(buf[0] == ' ') continue;
		if(buf[0] == '\t') continue;

		sscanf(buf, "%s %s %d %d %c %d", tmpcfg._username,
						 tmpcfg._ttydevice,
						 &tmpcfg._idle,
						 &tmpcfg._grace,
						 &tmpcfg._notifybymail,
						 &tmpcfg._sessionlimit);

		tmpcfg._notifybymail = toupper(tmpcfg._notifybymail);
	
		if(ndx <= IDLED_TABLE_SIZE)
		{
			memcpy( &cfg[ndx], &tmpcfg, sizeof(_CFG));
			ndx++;
		}

	}

	highentry=ndx-1;
	memset(&cfg[ndx], '\0', sizeof(_CFG));
	fclose(cfgfile);

}

/***************************************************************************
 *                                                                         *
 * void SetSignals(void);                                                  *
 *                                                                         *
 * Sets up signal handlers for the daemon. 				   *
 *                                                                         *
 ***************************************************************************/

void SetSignals(void)
{
	signal(SIGHUP, idled_reset);
	signal(SIGTERM, cleanup);
	signal(SIGINT, cleanup);
	signal(SIGSEGV, cleanup);
	signal(SIGFPE, cleanup);
	signal(SIGQUIT, cleanup);
}

/***************************************************************************
 *                                                                         *
 * void cleanup(int signum);                                               *
 *                                                                         *
 * Generic signal handler                   			           *
 *                                                                         *
 ***************************************************************************/

void cleanup(int signum)
{
	char tmpbuf[80];

	sprintf(tmpbuf, "Received signal #%d - exiting!", signum);
	err_sys(tmpbuf);
	exit(0);
}

/***************************************************************************
 *                                                                         *
 * void be_daemon(void);                                                   *
 *                                                                         *
 * My version of Coherent's bedaemon() libmisc function.  This turns the   *
 * calling process into a daemon.                                          *
 *                                                                         *
 ***************************************************************************/

void be_daemon(void)
{
	int	childpid, fd;

	/* If we were started by init (process 1) from the /etc/inittab file
	   there's no need to detach. */

	if (getppid() != 1)
	{
		/* Ignore the terminal stop signals */

		signal(SIGTTOU, SIG_IGN);
		signal(SIGTTIN, SIG_IGN);
		signal(SIGTSTP, SIG_IGN);
	
		/* If we were not started in the background, fork and
	   	let the parent exit.  This also guarantees the first child
	   	is not a process group leader. */

		if ( (childpid = fork()) < 0)
			err_sys("can't fork first child");
		else if (childpid > 0)
			exit(0);	/* parent */

		/* First child process.
	   	   Disassociate from controlling terminal and process group.
	   	   Ensure the process can't reacquire a new controlling 
		   terminal. */
	
		if (setpgrp() == -1) 
			err_sys("can't change SID/PGID");

  		/* immune from pgrp leader death */
		signal(SIGHUP, SIG_IGN); 

		if ( (childpid = fork()) < 0)
			err_sys("can't fork second child");
		else if (childpid > 0)
			exit(0);	/* first child */

		/* second child
	 	   Close any open files descriptors. */

		for (fd = 0; fd < NOFILE; fd++)
			close(fd);

		/* probably got set to EBADF from a close */
		errno = 0;		

		/* Move the current directory to root, to make sure we
	 	   aren't on a mounted filesystem. */

		chdir("/");

		/* Clear any inherited file mode creation mask. */
		umask(0);

		/* Ignore the status of dead child processes */
	 	signal(SIGCHLD, SIG_IGN);
	}
}

void idled_reset(int signum)
{
	err_sys("Received SIGHUP - restarting");
	ReadCFGFile();
	signal(SIGHUP, idled_reset);
}

