/*****************************************************************************
	      idled - idle login killer daemon for the Linux OS
       (C)opyright 1994-1995, B. Scott Burkett, All Rights Reserved
 ***************************************************************************** 
 $Header: /usr3/src/idled/RCS/idled.c,v 1.2 1995/03/25 05:57:58 root Exp $
 ***************************************************************************** 
 $Log: idled.c,v $
 * Revision 1.2  1995/03/25  05:57:58  root
 * Split other functions into separate files
 *
 *****************************************************************************
  
   Copyright (c), 1994-1995, by B. Scott Burkett
   All rights reserved.
  
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
  
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All modifications to the source code must be clearly marked as
      such.  Binary redistributions based on modified source code
      must be clearly marked as modified versions in the documentation
      and/or other materials provided with the distribution.
   4. All advertising materials mentioning features or use of this software
      must display the following acknowledgment:
        This product includes software developed by B. Scott Burkett and
        other unpaid contributors.
   5. The name of B. Scott Burkett may not be used to endorse or promote
      products derived from this software without specific prior
      written permission.
  
   THIS SOFTWARE IS PROVIDED BY B. SCOTT BURKETT AND CONTRIBUTORS "AS IS" AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL B. SCOTT BURKETT OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.
 
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <utmp.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <utime.h>
#include <errno.h>
#include <ctype.h>
#include <regex.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/syslog.h>
#include <sys/ioctl.h>
#include <sys/param.h>

#include "idled.h"

struct utmp	*userrec;
FILE		*uf, *tty;
char		buf[80];
_WARNED 	warned[ IDLED_TABLE_SIZE ];  
_CFG    	cfg[ IDLED_TABLE_SIZE ];
_CFG		tmpcfg;
int		_maxidletime=300, _warnfirst, _debug, _sleepdelay=60;
int		highentry=0;

int main(int argc, char *argv[])
{
	Init( argc );
	ParseCmdLine(argc, argv);
	Report();
	Process();
	return(0);
}

/***************************************************************************
 *                                                                         *
 * void ParseCmdLine(int ac, char *av[]);                                  *
 *                                                                         *
 * This function is responsible for parsing the command line and      	   *
 * setting any parameters wihch are configurable from the command line.    *
 *                                                                         *
 ***************************************************************************/

void ParseCmdLine(int ac, char *av[])
{
	int i, j;
	char	*p;

	if(ac==1) {
		printf("\n\ridled " VERSION "\n\r");
		printf( COPYRIGHT "\n\r\n\r");

		printf("USAGE: ");
		printf("idled [options]\n\r");
		printf("             -s(leep delay between checks (default=60))\n\r");
		printf("             -w(arn first - no initial kill!)\n\r");
		printf("\n\rConsult the idled manual page for more information.\n\r\n\r");
		exit(255);
	}

	for(i = 1; i < ac; i++)
	{
		p = av[i];
		if(*p == '-' || *p == '/')
		{
			for(j = 1; *(p + j); j+=strlen(p + 1))
			{
				switch(tolower(*(p + j)))
				{

					case 's': _sleepdelay=atoi(p+2);
						  break;

					case 'd': _debug = TRUE;
						  break;
           					  
            				case 'w': _warnfirst = TRUE;
                      			  	  break;
						  
				}
			}
		}
		else			     /* unknown parameter	     */
			return;
	}

	return;
}

/***************************************************************************
 *                                                                         *
 * void Report(void);                                                      *
 *                                                                         *
 * Displays runtime parameters to syslog                                                                        *
 *                                                                         *
 ***************************************************************************/

void Report(void)
{
	sprintf(buf, "Sleep delay is %d\n", _sleepdelay);
	err_sys(buf);

	if(_warnfirst)
		err_sys("Warn-first mode");
			else
				err_sys("No-warn mode");

}
