#include "holecp.h"

/* copy infile to outfile */

int file2file (char const *inname, char const *outname)
{
    FILE
	*inf,
	*outf;
    int
	nzeros = 0,
	nholes = 0,
	nbigholes = 0,
	nbytesread = 0,
	nbyteswritten = 0,
	ch;
    struct stat
	statbuf;

    /* show what's going on */
    if (flags.verbose)
	printf ("%s -> %s\n", inname, outname);

    if (stat (inname, &statbuf))
	return (message ("can't stat %s", inname));

    /* we can assume here that inname is a normal file, see copyfile.c */
    if (! (inf = fopen (inname, "r")) )
	return (message ("cannot open %s for reading", inname));

    /* now we can safely overwrite output file, see copyfile.c */
    if (! (outf = fopen (outname, "w")) )
    {
	fclose (inf);
	return (message ("cannot open %s for writing", outname));
    }

    while (1)
    {
	ch = fgetc (inf);
	if (feof (inf))
	    break;

	nbytesread++;
	if (! ch)
	    nzeros++;
	else
	{
	    if (nzeros)
	    {
		if (nzeros >= 1024)
		    nbigholes++;
		nholes++;
		fseek (outf, nzeros, SEEK_CUR);
		nzeros = 0;
	    }
	    fputc (ch, outf);
	    nbyteswritten++;
	}
    }
    if (nzeros)
    {
	if (nzeros > 1024)
	    nbigholes++;
	nholes++;
	fseek (outf, nzeros, SEEK_CUR);
	fseek (outf, -1, SEEK_CUR);
	fputc (0, outf);
    }

    fchown (fileno (outf), statbuf.st_uid, statbuf.st_gid);
    fchmod (fileno (outf), statbuf.st_mode);

    fclose (inf);
    fclose (outf);

    if (flags.verbose)
	printf ("read: %d, written: %d, holes: %d, holes>1k: %d\n",
		nbytesread, nbyteswritten, nholes, nbigholes);

    return (0);
}
