SimpleSAMLphp Documentation
===========================

 * Installation and upgrading
  * [Installing SimpleSAMLphp](simplesamlphp-install)
  * [Upgrade notes](simplesamlphp-upgrade-notes)
  * [Installation from the repository](simplesamlphp-install-repo)
  * [Changelog](simplesamlphp-changelog)
 * Using SimpleSAMLphp as a SAML Service Provider
  * [Service Provider Quickstart](simplesamlphp-sp)
  * [Hosted SP Configuration Reference](./saml:sp)
  * [IdP remote reference](simplesamlphp-reference-idp-remote)
  * [Configuring HTTP-Artifact](./simplesamlphp-artifact-sp)
  * [Using scoping](./simplesamlphp-scoping)
  * [Holder-of-Key profile](simplesamlphp-hok-sp)
 * Using SimpleSAMLphp as a SAML Identity Provider
  * [Identity Provider QuickStart](simplesamlphp-idp)
  * [IdP hosted reference](simplesamlphp-reference-idp-hosted)
  * [SP remote reference](simplesamlphp-reference-sp-remote)
  * [Use case: Setting up an IdP for Google Workspace (G Suite / Google Apps)](simplesamlphp-googleapps)
  * [Configuring HTTP-Artifact](./simplesamlphp-artifact-idp)
  * [Identity Provider Advanced Topics](simplesamlphp-idp-more)
  * [Holder-of-Key profile](simplesamlphp-hok-idp)
 * [Automated Metadata Management](https://github.com/simplesamlphp/simplesamlphp-module-metarefresh/blob/master/docs/simplesamlphp-automated_metadata.md)
 * [Maintenance and configuration](simplesamlphp-maintenance) - covers session handling, php configuration etc.
 * [Authentication Processing Filters](simplesamlphp-authproc) - attribute filtering, attribute mapping, consent, group generation etc.
 * [Advanced features](simplesamlphp-advancedfeatures) - covers bridging protocols, attribute filtering, etc.
 * [State Information Lost](simplesamlphp-nostate) - more about this common error message
 * [SimpleSAMLphp Dictionaries and Translation](simplesamlphp-translation)
 * [Theming SimpleSAMLphp](simplesamlphp-theming)
 * [SimpleSAMLphp Modules](simplesamlphp-modules) - how to create own customized modules
 * [Key rollover](./saml:keyrollover)
 * [Creating authentication sources](./simplesamlphp-authsource)
  * [Implementing custom username/password authentication](./simplesamlphp-customauth)
 * [Storing sessions in Riak](./riak:simplesamlphp-riak)

Documentation on specific SimpleSAMLphp modules:
 
 * [Consent module](./consent:consent)
 * [Installing and configuring the consentAdmin module](./consentAdmin:consentAdmin)
 * [Authorization](./authorize:authorize)
 * [autotest Module](https://github.com/simplesamlphp/simplesamlphp-module-autotest/blob/v1.0/README.md)
 * [Statistics](./statistics:statistics)

Documentation for SimpleSAMLphp developers:

 * [Error handling in SimpleSAMLphp](simplesamlphp-errorhandling)
