# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class SettingsList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the SettingsList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.voice.v1.dialing_permissions.settings.SettingsList
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsList
        """
        super(SettingsList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self):
        """
        Constructs a SettingsContext

        :returns: twilio.rest.voice.v1.dialing_permissions.settings.SettingsContext
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsContext
        """
        return SettingsContext(self._version, )

    def __call__(self):
        """
        Constructs a SettingsContext

        :returns: twilio.rest.voice.v1.dialing_permissions.settings.SettingsContext
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsContext
        """
        return SettingsContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.SettingsList>'


class SettingsPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the SettingsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.voice.v1.dialing_permissions.settings.SettingsPage
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsPage
        """
        super(SettingsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SettingsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.voice.v1.dialing_permissions.settings.SettingsInstance
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsInstance
        """
        return SettingsInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.SettingsPage>'


class SettingsContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the SettingsContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.voice.v1.dialing_permissions.settings.SettingsContext
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsContext
        """
        super(SettingsContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Settings'.format(**self._solution)

    def fetch(self):
        """
        Fetch the SettingsInstance

        :returns: The fetched SettingsInstance
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return SettingsInstance(self._version, payload, )

    def update(self, dialing_permissions_inheritance=values.unset):
        """
        Update the SettingsInstance

        :param bool dialing_permissions_inheritance: `true` for the sub-account to inherit voice dialing permissions from the Master Project; otherwise `false`

        :returns: The updated SettingsInstance
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsInstance
        """
        data = values.of({'DialingPermissionsInheritance': dialing_permissions_inheritance, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return SettingsInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.SettingsContext {}>'.format(context)


class SettingsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the SettingsInstance

        :returns: twilio.rest.voice.v1.dialing_permissions.settings.SettingsInstance
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsInstance
        """
        super(SettingsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'dialing_permissions_inheritance': payload.get('dialing_permissions_inheritance'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: SettingsContext for this SettingsInstance
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsContext
        """
        if self._context is None:
            self._context = SettingsContext(self._version, )
        return self._context

    @property
    def dialing_permissions_inheritance(self):
        """
        :returns: `true` if the sub-account will inherit voice dialing permissions from the Master Project; otherwise `false`
        :rtype: bool
        """
        return self._properties['dialing_permissions_inheritance']

    @property
    def url(self):
        """
        :returns: The absolute URL of this resource
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the SettingsInstance

        :returns: The fetched SettingsInstance
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsInstance
        """
        return self._proxy.fetch()

    def update(self, dialing_permissions_inheritance=values.unset):
        """
        Update the SettingsInstance

        :param bool dialing_permissions_inheritance: `true` for the sub-account to inherit voice dialing permissions from the Master Project; otherwise `false`

        :returns: The updated SettingsInstance
        :rtype: twilio.rest.voice.v1.dialing_permissions.settings.SettingsInstance
        """
        return self._proxy.update(dialing_permissions_inheritance=dialing_permissions_inheritance, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Voice.V1.SettingsInstance {}>'.format(context)
