# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .factory_repo_configuration import FactoryRepoConfiguration


class FactoryVSTSConfiguration(FactoryRepoConfiguration):
    """Factory's VSTS repo information.

    All required parameters must be populated in order to send to Azure.

    :param account_name: Required. Account name.
    :type account_name: str
    :param repository_name: Required. Repository name.
    :type repository_name: str
    :param collaboration_branch: Required. Collaboration branch.
    :type collaboration_branch: str
    :param root_folder: Required. Root folder.
    :type root_folder: str
    :param last_commit_id: Last commit id.
    :type last_commit_id: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param project_name: Required. VSTS project name.
    :type project_name: str
    :param tenant_id: VSTS tenant id.
    :type tenant_id: str
    """

    _validation = {
        'account_name': {'required': True},
        'repository_name': {'required': True},
        'collaboration_branch': {'required': True},
        'root_folder': {'required': True},
        'type': {'required': True},
        'project_name': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'repository_name': {'key': 'repositoryName', 'type': 'str'},
        'collaboration_branch': {'key': 'collaborationBranch', 'type': 'str'},
        'root_folder': {'key': 'rootFolder', 'type': 'str'},
        'last_commit_id': {'key': 'lastCommitId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FactoryVSTSConfiguration, self).__init__(**kwargs)
        self.project_name = kwargs.get('project_name', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.type = 'FactoryVSTSConfiguration'
