/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.io.Writer;

/**
 * Used to copy unwanted information to the bit-bucket.
 * Implemented as a singleton, since only one
 * instance is ever needed.
 *
 * @author Elias Ross
 * @version 1.0
 */
public final class NullWriter
	extends Writer
{
	private static final NullWriter nw = new NullWriter();	

	/**
	 * Returns the only instance of a <code>NullWriter</code>.
	 * @return a null writer
	 */
	public static Writer getInstance() {
		return nw;
	}

	/**
	 * This method is private to keep this from being constructed outside
	 * the class.
	 */
	private NullWriter() {
	}

	/**
	 * Does nothing.
	 */
	public void flush() {
	}

	/**
	 * Does nothing.
	 */
	public void write(int c) {
	}

	/**
	 * Does nothing.
	 */
	public void write(char cbuf[]) {
	}

	/**
	 * Does nothing.
	 */
	public void write(char cbuf[], int off, int len) {
	}

	/**
	 * Does nothing.
	 */
	public void write(String str) {
	}

	/**
	 * Does nothing.
	 */
	public void write(String str, int off, int len) {
	}

	/**
	 * Does nothing.
	 */
	public void close() {
	}
}
