#!/usr/bin/python
# By John Goerzen
# GPL
# Copyright (C) 2002 John Goerzen
from sys import argv, stdin, stdout
import re

reverse = 0

if len(argv) >= 2 and argv[1] == '-r':
    reverse = 1

def printdef(entry, definition):
    entrylist = entry.split(';')
    definition = definition.strip()
    for item in entrylist:
        bracetype = re.search('[(\[{].+[)\]}]', item)
        if bracetype:
            bracetype = " " + bracetype.group(0)
            item = re.sub('[(\[{].+[)\]}]', '', item)
        else:
            bracetype = ""
        item = item.strip()
        if reverse:
            if item.startswith("to "):
                item = item[3:]
        print ":%s:%s" % (item, bracetype)
        print "   %s" % (definition)

while 1:
    line = stdin.readline()
    if not line:
        break
    line.strip()
    if line[0] == '#':
        stdout.write(line)
        continue

    if line.find("::") == -1:
        continue
    entry, definition = line.split("::")
    if not entry.strip() or not definition.strip():
        continue
    if not reverse:
        printdef(entry, definition)
    else:
        printdef(definition, entry)

