#!/bin/sh
#
# enumstr.sh - a tool generating a function mapping enumerator to its
# string representation
#
# Copyright (C) 2019 Masatake YAMATO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Usage:
#
#  ./enumstr.sh <input-file> <enum-name> <funname> [PREFIX_FOR_TRIMMING] [--use-lower-bits-as-is]
#
# Example:
#
#   bash ./misc/enumstr.sh parsers/jscript.c eTokenType tokenTypeName
#
column_width=20

INPUT_FILE=$1
ENUM_NAME=$2
FUNNAME=$3
shift 3

if [ "$1" = "--use-lower-bits-as-is" ]; then
	PREFIX_FOR_TRIMMING=
	USE_LOWER_BITS_AS_IS=$1
	shift 1
else
	PREFIX_FOR_TRIMMING=$1
	shift 1
	if [ "$1" = "--use-lower-bits-as-is" ]; then
		USE_LOWER_BITS_AS_IS=$1
		shift 1
	else
		USE_LOWER_BITS_AS_IS=
	fi
fi

echo 'static const char *'"$FUNAME"'(enum '$ENUM_NAME' e)'
printf '{ /* Generated by misc/enumstr.sh with cmdline:\n'
echo "     $0 $INPUT_FILE $ENUM_NAME $FUNNAME $PREFIX_FOR_TRIMMING $USE_LOWER_BITS_AS_IS */"
echo '	switch (e)'
echo '	{'
./ctags --quiet --options=NONE --sort=no -o - --languages=C --kinds-C=e --map-C=+.h -x --_xformat="%N enum:%s" $INPUT_FILE | grep $ENUM_NAME | while read N S; do
	n=$N
	if [ -n "$PREFIX_FOR_TRIMMING" ]; then
		n=${N#$PREFIX_FOR_TRIMMING}
	fi
	printf "		case %${column_width}s: return %s;\n" "$N" "\"$n\""
done

if [ -n "$USE_LOWER_BITS_AS_IS" ]; then
	printf '		default: %'"$((${column_width} + 3))s;\n" "break"
else
	printf '		default: %'"$((${column_width} - 3))s return %s;\n" ' ' "\"UNKNOWN\""
fi
echo '	}'
if [ -n "$USE_LOWER_BITS_AS_IS" ]; then
echo '	static char buf[3];'
echo '	if (isprint (e))'
echo '	{'
echo '		buf[0] = e;'
echo "		buf[1] = '\0';"
echo '	}'
echo "	else if (e == '\\n')"
echo '	{'
echo "		buf[0] = '\\\';"
echo "		buf[1] = 'n';"
echo "		buf[2] = '\0';"
echo '	}'
echo '	else'
echo '	{'
echo "		buf[0] = '\0';"
echo '	}'
echo '	return buf;'
fi
echo '}'
