/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SingletonNode;

public class Doc
extends SystemFunction {
    private String expressionBaseURI = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        Configuration config = visitor.getConfiguration();
        if (((Boolean)config.getConfigurationProperty("http://saxon.sf.net/feature/preEvaluateDocFunction")).booleanValue()) {
            try {
                AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(null);
                if (hrefVal == null) {
                    return null;
                }
                String href = hrefVal.getStringValue();
                if (href.indexOf(35) >= 0) {
                    return this;
                }
                NodeInfo item = Document.preLoadDoc(href, this.expressionBaseURI, config, this);
                if (item != null) {
                    return new Literal(new SingletonNode(item));
                }
            }
            catch (Exception err) {
                return this;
            }
        }
        return this;
    }

    public int computeCardinality() {
        return this.argument[0].getCardinality() & 0xFFFF7FFF;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addDocToPathMap(pathMap, pathMapNodeSet);
    }

    public Expression copy() {
        Doc d = (Doc)super.copy();
        d.expressionBaseURI = this.expressionBaseURI;
        return d;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.doc(context);
    }

    public int computeSpecialProperties() {
        return 0xCA0000;
    }

    private NodeInfo doc(XPathContext context) throws XPathException {
        AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(context);
        if (hrefVal == null) {
            return null;
        }
        String href = hrefVal.getStringValue();
        NodeInfo item = Document.makeDoc(href, this.expressionBaseURI, context, this);
        if (item == null) {
            this.dynamicError("Failed to load document " + href, "FODC0005", context);
            return null;
        }
        return item;
    }

    public void sendDocument(XPathContext context, Receiver out) throws XPathException {
        AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(context);
        if (hrefVal == null) {
            return;
        }
        String href = hrefVal.getStringValue();
        Document.sendDoc(href, this.expressionBaseURI, context, this, out);
    }
}

