/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntConsumer;
import org.jline.terminal.Cursor;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.CursorSupport;
import org.jline.terminal.impl.LineDisciplineTerminal;

public class ExternalTerminal
extends LineDisciplineTerminal {
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected final Thread pumpThread;
    protected final InputStream masterInput;

    public ExternalTerminal(String name, String type, InputStream masterInput, OutputStream masterOutput, String encoding) throws IOException {
        this(name, type, masterInput, masterOutput, encoding, Terminal.SignalHandler.SIG_DFL);
    }

    public ExternalTerminal(String name, String type, InputStream masterInput, OutputStream masterOutput, String encoding, Terminal.SignalHandler signalHandler) throws IOException {
        super(name, type, masterOutput, encoding, signalHandler);
        this.masterInput = masterInput;
        this.pumpThread = new Thread(this::pump, this.toString() + " input pump thread");
        this.pumpThread.start();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.pumpThread.interrupt();
            super.close();
        }
    }

    public void pump() {
        try {
            int c;
            while ((c = this.masterInput.read()) >= 0 && !this.closed.get()) {
                this.processInputByte((char)c);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Cursor getCursorPosition(IntConsumer discarded) {
        return CursorSupport.getCursorPosition(this, discarded);
    }
}

