    // by alternatives/add.cc
inline bool History::find(std::string const &path) const
{
    return findIter(path) != d_history.end();
}

    // by history.f (find), save.cc alternatives/add.cc
inline std::vector<History::HistoryInfo>::const_iterator 
                History::findIter(std::string const &path) const
{
    return
        find_if(
            d_history.begin(), d_history.end(),
            [&](HistoryInfo const &history)
            {
                return history.path == path;
            }
        );
}

    // by alternatives/separateat.cc
inline Position History::position() const
{
    return d_options.historyPosition();
}

    // by alternatives/order.cc
inline bool History::rotate() const
{
    return not d_historyFilename.empty() && 
           d_options.historyPosition() == BOTTOM;
}

    // by options/sethistory.cc
inline std::ostream &operator<<(std::ostream &out,
                                History::HistoryInfo const &hi)
{
    return out << hi.time << ' ' << hi.count << ' ' << hi.path;
}




