/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.util.ArrayList;
import java.util.logging.Level;
import spec.jbb.Company;
import spec.jbb.District;
import spec.jbb.JBBDataStorage;
import spec.jbb.JBButil;
import spec.jbb.Order;
import spec.jbb.Orderline;
import spec.jbb.Stock;
import spec.jbb.Transaction;
import spec.jbb.infra.Util.TransactionLogBuffer;
import spec.jbb.infra.Util.XMLTransactionLog;

class StockLevelTransaction
extends Transaction {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private Company company;
    private short warehouseId;
    private byte districtId;
    private District districtPtr;
    private JBBDataStorage orderTable;
    private int threshold;
    private int lowStock;
    private TransactionLogBuffer stockLog;
    private TransactionLogBuffer initLog;
    private XMLTransactionLog xmlStockLog;
    String[] validationLog = new String[]{"                                    Stock-Level", "Warehouse:    1  District:   9", "", "Stock Level Threshold: 15", "", "low stock:  14", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    boolean[] checkLine = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};

    public StockLevelTransaction(Company company, short s) {
        this.company = company;
        this.warehouseId = s;
        this.districtId = (byte)JBButil.random(1, (int)this.company.getMaxDistrictsPerWarehouse(), this.warehouseId);
        this.districtPtr = this.company.getWarehousePtr(this.warehouseId, false).getDistrictPtr(this.districtId, false);
        this.orderTable = this.districtPtr.getOrderTable();
        this.stockLog = new TransactionLogBuffer();
        this.setupStockLog();
        this.xmlStockLog = new XMLTransactionLog();
        this.initLog = new TransactionLogBuffer(this.stockLog);
        this.setupInitLog();
    }

    private void setupStockLog() {
        this.stockLog.putText("Stock-Level", 36, 0, 11);
        this.stockLog.putText("Warehouse:", 0, 1, 10);
        this.stockLog.putInt(this.warehouseId, 11, 1, 4);
        this.stockLog.putText("District:", 17, 1, 10);
        this.stockLog.putInt(this.districtId, 28, 1, 2);
        this.stockLog.putText("Stock Level Threshold:", 0, 3, 22);
        this.stockLog.putText("low stock:", 0, 5, 10);
    }

    private void setupInitLog() {
        this.initLog.putCharFill('9', 23, 3, 2);
        this.initLog.putCharFill('9', 11, 5, 3);
    }

    public void init() {
        JBButil.getLog().entering("spec.jbb.StockLevelTransaction", "init");
        this.threshold = JBButil.random(10, 20, this.warehouseId);
        this.lowStock = 0;
        JBButil.getLog().exiting("spec.jbb.StockLevelTransaction", "init");
    }

    public String getMenuName() {
        return "Stock-Level";
    }

    public synchronized void delete() {
    }

    public boolean process() {
        JBButil.getLog().entering("spec.jbb.StockLevelTransaction", "process");
        ArrayList<Stock> arrayList = new ArrayList<Stock>(200);
        int n = this.districtPtr.lastOrderId();
        int n2 = n <= 20 ? 1 : n - 20;
        for (int i = n2; i <= n; ++i) {
            Order object = (Order)this.orderTable.get(i);
            if (object == null) continue;
            Orderline[] orderlineArray = object.getOrderlineList();
            int n3 = object.getOrderlineCount();
            if (JBButil.getLog().isLoggable(Level.FINEST)) {
                JBButil.getLog().finest("StockLevelTransaction::process  orderlineList=" + orderlineArray + "  orderLineCount=" + n3);
            }
            for (int j = 0; j < n3; ++j) {
                Orderline orderline = orderlineArray[j];
                Stock stock = orderline.getStockPtr();
                arrayList.add(stock);
                if (!JBButil.getLog().isLoggable(Level.FINEST)) continue;
                JBButil.getLog().finest("  orderline#=" + j + "  orderline=" + orderline);
            }
        }
        for (Stock stock : arrayList) {
            if (JBButil.getLog().isLoggable(Level.FINEST)) {
                JBButil.getLog().finest("  stock#=" + stock.getId());
            }
            if (stock.getQuantity() >= this.threshold) continue;
            ++this.lowStock;
        }
        JBButil.getLog().exiting("spec.jbb.StockLevelTransaction", "process");
        return true;
    }

    public void initializeTransactionLog() {
        JBButil.getLog().entering("spec.jbb.StockLevelTransaction", "initializeTransactionLog");
        if (Transaction.enableLogWrite) {
            this.initLog.display();
        }
        JBButil.getLog().exiting("spec.jbb.StockLevelTransaction", "initializeTransactionLog");
    }

    public synchronized void processTransactionLog() {
        JBButil.getLog().entering("spec.jbb.StockLevelTransaction", "processTransactionLog");
        this.stockLog.clearBuffer();
        this.xmlStockLog.clear();
        this.setupStockLog();
        this.stockLog.putInt(this.threshold, 23, 3, 2);
        this.stockLog.putInt(this.lowStock, 11, 5, 3);
        this.xmlStockLog.populateXML(this.stockLog);
        if (Transaction.enableLogWrite) {
            this.stockLog.display();
        }
        if (Transaction.validationFlag) {
            String[] stringArray = this.stockLog.validate();
            if (stringArray.length != this.validationLog.length) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("VALIDATION ERROR:  mismatch in screen lengths for StockLevelTransaction");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Screen length should be:  " + this.validationLog.length);
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Screen length is:  " + stringArray.length);
                JBButil.getLog().warning(stringBuffer.toString());
                Transaction.invalidateRun();
            }
            for (int i = 0; i < this.validationLog.length; ++i) {
                if (!this.checkLine[i] || stringArray[i].equals(this.validationLog[i])) continue;
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("VALIDATION ERROR:  incorrect output for StockLevelTransaction");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Line " + (i + 1) + " should be:  |" + this.validationLog[i] + "|");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Line " + (i + 1) + " is:  |" + stringArray[i] + "|");
                JBButil.getLog().warning(stringBuffer.toString());
                Transaction.invalidateRun();
            }
        }
        JBButil.getLog().exiting("spec.jbb.StockLevelTransaction", "processTransactionLog");
    }
}

