/* scrot.h

Copyright 2021 Guilherme Janczak <guilherme.janczak@yandex.com>
Copyright 2022 Daniel T. Borelli <danieltborelli@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

/* Part of the code comes from the scrot.c file and maintains its authorship. */

#pragma once

#include <X11/Xlib.h>
#include <Imlib2.h>

Window scrotGetWindow(Display *, Window, int, int);
int scrotGetGeometry(Window, int *, int *, int *, int *);
void scrotNiceClip(int *, int *, int *, int *);
void scrotDoDelay(void);
void scrotGrabMousePointer(const Imlib_Image, const int, const int);
char *scrotGetWindowName(Window);
