// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, Message};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "SoupAuth")]
    pub struct Auth(Object<ffi::SoupAuth, ffi::SoupAuthClass>);

    match fn {
        type_ => || ffi::soup_auth_get_type(),
    }
}

impl Auth {
    pub const NONE: Option<&'static Auth> = None;

    #[doc(alias = "soup_auth_new")]
    pub fn new(type_: glib::types::Type, msg: &Message, auth_header: &str) -> Option<Auth> {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::soup_auth_new(
                type_.into_glib(),
                msg.to_glib_none().0,
                auth_header.to_glib_none().0,
            ))
        }
    }
}

pub trait AuthExt: IsA<Auth> + 'static {
    #[doc(alias = "soup_auth_authenticate")]
    fn authenticate(&self, username: &str, password: &str) {
        unsafe {
            ffi::soup_auth_authenticate(
                self.as_ref().to_glib_none().0,
                username.to_glib_none().0,
                password.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_auth_can_authenticate")]
    fn can_authenticate(&self) -> bool {
        unsafe {
            from_glib(ffi::soup_auth_can_authenticate(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_auth_cancel")]
    fn cancel(&self) {
        unsafe {
            ffi::soup_auth_cancel(self.as_ref().to_glib_none().0);
        }
    }

    //#[doc(alias = "soup_auth_free_protection_space")]
    //fn free_protection_space(&self, space: /*Unimplemented*/&[&Basic: Pointer]) {
    //    unsafe { TODO: call ffi:soup_auth_free_protection_space() }
    //}

    #[doc(alias = "soup_auth_get_authority")]
    #[doc(alias = "get_authority")]
    fn authority(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::soup_auth_get_authority(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "soup_auth_get_authorization")]
    #[doc(alias = "get_authorization")]
    fn authorization(&self, msg: &Message) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::soup_auth_get_authorization(
                self.as_ref().to_glib_none().0,
                msg.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_auth_get_info")]
    #[doc(alias = "get_info")]
    fn info(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::soup_auth_get_info(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "soup_auth_get_protection_space")]
    #[doc(alias = "get_protection_space")]
    fn protection_space(&self, source_uri: &glib::Uri) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::soup_auth_get_protection_space(
                self.as_ref().to_glib_none().0,
                source_uri.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_auth_get_realm")]
    #[doc(alias = "get_realm")]
    fn realm(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::soup_auth_get_realm(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "soup_auth_get_scheme_name")]
    #[doc(alias = "get_scheme_name")]
    #[doc(alias = "scheme-name")]
    fn scheme_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_auth_get_scheme_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_auth_is_authenticated")]
    #[doc(alias = "is-authenticated")]
    fn is_authenticated(&self) -> bool {
        unsafe {
            from_glib(ffi::soup_auth_is_authenticated(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_auth_is_cancelled")]
    #[doc(alias = "is-cancelled")]
    fn is_cancelled(&self) -> bool {
        unsafe { from_glib(ffi::soup_auth_is_cancelled(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "soup_auth_is_for_proxy")]
    #[doc(alias = "is-for-proxy")]
    fn is_for_proxy(&self) -> bool {
        unsafe { from_glib(ffi::soup_auth_is_for_proxy(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "soup_auth_is_ready")]
    fn is_ready(&self, msg: &Message) -> bool {
        unsafe {
            from_glib(ffi::soup_auth_is_ready(
                self.as_ref().to_glib_none().0,
                msg.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_auth_update")]
    fn update(&self, msg: &Message, auth_header: &str) -> bool {
        unsafe {
            from_glib(ffi::soup_auth_update(
                self.as_ref().to_glib_none().0,
                msg.to_glib_none().0,
                auth_header.to_glib_none().0,
            ))
        }
    }

    fn set_authority(&self, authority: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "authority", authority)
    }

    #[doc(alias = "is-for-proxy")]
    fn set_is_for_proxy(&self, is_for_proxy: bool) {
        ObjectExt::set_property(self.as_ref(), "is-for-proxy", is_for_proxy)
    }

    fn set_realm(&self, realm: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "realm", realm)
    }

    #[doc(alias = "authority")]
    fn connect_authority_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_authority_trampoline<P: IsA<Auth>, F: Fn(&P) + 'static>(
            this: *mut ffi::SoupAuth,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Auth::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::authority".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_authority_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "is-authenticated")]
    fn connect_is_authenticated_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_authenticated_trampoline<
            P: IsA<Auth>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SoupAuth,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Auth::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::is-authenticated".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_is_authenticated_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "is-cancelled")]
    fn connect_is_cancelled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_cancelled_trampoline<P: IsA<Auth>, F: Fn(&P) + 'static>(
            this: *mut ffi::SoupAuth,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Auth::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::is-cancelled".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_is_cancelled_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "is-for-proxy")]
    fn connect_is_for_proxy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_for_proxy_trampoline<P: IsA<Auth>, F: Fn(&P) + 'static>(
            this: *mut ffi::SoupAuth,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Auth::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::is-for-proxy".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_is_for_proxy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "realm")]
    fn connect_realm_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_realm_trampoline<P: IsA<Auth>, F: Fn(&P) + 'static>(
            this: *mut ffi::SoupAuth,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Auth::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::realm".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_realm_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "scheme-name")]
    fn connect_scheme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scheme_name_trampoline<P: IsA<Auth>, F: Fn(&P) + 'static>(
            this: *mut ffi::SoupAuth,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Auth::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::scheme-name".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_scheme_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Auth>> AuthExt for O {}
