% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{messagef}
\alias{messagef}
\alias{wnote}
\title{General Log Formating}
\usage{
messagef(fmt, ..., domain = NULL, appendLF = TRUE)

wnote(..., immediate. = TRUE)
}
\arguments{
\item{fmt}{a character vector of format strings, each of up to 8192 bytes.}

\item{...}{values to be passed into \code{fmt}.  Only logical,
    integer, real and character vectors are supported, but some coercion
    will be done: see the \sQuote{Details} section. Up to 100.}

\item{domain}{see \code{\link[base]{gettext}}.  If \code{NA}, messages will
    not be translated, see also the note in \code{\link[base]{stop}}.}

\item{appendLF}{logical: should messages given as a character string
    have a newline appended?}

\item{immediate.}{logical, indicating if the call should be output
    immediately, even if \code{\link[base]{getOption}("warn") <= 0}.}
}
\value{
Returns nothing. Used for their side effects of printing messages/warnings.
}
\description{
Generate a formatted diagnostic message.
This function is a shortcut for \code{message(sprintf(...))}.
}
\section{Functions}{
\itemize{
\item \code{wnote()}: throws a simple note as an immediate warning.
It is a shorcut for \code{warning(..., immediate. = TRUE, call. = FALSE)}.

}}
\examples{

messagef("Hello \%s number \%i", 'world', 4)

}
\seealso{
\code{\link{sprintf}}, \code{\link{message}}
}
