/* This module is generated by the maint/MultiStage2.py script.
Do not modify it by hand. Instead modify the script and run it
to regenerate this code.

As well as being part of the PCRE2 library, this module is #included
by the pcre2test program, which redefines the PRIV macro to change
table names from _pcre2_xxx to xxxx, thereby avoiding name clashes
with the library. At present, just one of these tables is actually
needed. */

#ifndef PCRE2_PCRE2TEST

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "pcre2_internal.h"

#endif /* PCRE2_PCRE2TEST */

/* Unicode character database. */
/* This file was autogenerated by the MultiStage2.py script. */
/* Total size: 102844 bytes, block size: 128. */

/* The tables herein are needed only when UCP support is built,
and in PCRE2 that happens automatically with UTF support.
This module should not be referenced otherwise, so
it should not matter whether it is compiled or not. However
a comment was received about space saving - maybe the guy linked
all the modules rather than using a library - so we include a
condition to cut out the tables when not needed. But don't leave
a totally empty module because some compilers barf at that.
Instead, just supply some small dummy tables. */

#ifndef SUPPORT_UNICODE
const ucd_record PRIV(ucd_records)[] = {{0,0,0,0,0,0,0 }};
const uint16_t PRIV(ucd_stage1)[] = {0};
const uint16_t PRIV(ucd_stage2)[] = {0};
const uint32_t PRIV(ucd_caseless_sets)[] = {0};
#else

const char *PRIV(unicode_version) = "14.0.0";

/* If the 32-bit library is run in non-32-bit mode, character values
greater than 0x10ffff may be encountered. For these we set up a
special record. */

#if PCRE2_CODE_UNIT_WIDTH == 32
const ucd_record PRIV(dummy_ucd_record)[] = {{
  ucp_Unknown,    /* script */
  ucp_Cn,         /* type unassigned */
  ucp_gbOther,    /* grapheme break property */
  0,              /* case set */
  0,              /* other case */
  ucp_Unknown,    /* script extension */
  0,              /* dummy filler */
  }};
#endif

/* When recompiling tables with a new Unicode version, please check the
types in this structure definition from pcre2_internal.h (the actual
field names will be different):

typedef struct {
uint8_t property_0;
uint8_t property_1;
uint8_t property_2;
uint8_t property_3;
pcre_int32 property_4;
pcre_int16 property_5;
uint16_t property_6;
} ucd_record;
*/

/* This table contains lists of characters that are caseless sets of
more than one character. Each list is terminated by NOTACHAR. */

const uint32_t PRIV(ucd_caseless_sets)[] = {
  NOTACHAR,
  0x0053,   0x0073,   0x017f,   NOTACHAR,
  0x01c4,   0x01c5,   0x01c6,   NOTACHAR,
  0x01c7,   0x01c8,   0x01c9,   NOTACHAR,
  0x01ca,   0x01cb,   0x01cc,   NOTACHAR,
  0x01f1,   0x01f2,   0x01f3,   NOTACHAR,
  0x0345,   0x0399,   0x03b9,   0x1fbe,   NOTACHAR,
  0x00b5,   0x039c,   0x03bc,   NOTACHAR,
  0x03a3,   0x03c2,   0x03c3,   NOTACHAR,
  0x0392,   0x03b2,   0x03d0,   NOTACHAR,
  0x0398,   0x03b8,   0x03d1,   0x03f4,   NOTACHAR,
  0x03a6,   0x03c6,   0x03d5,   NOTACHAR,
  0x03a0,   0x03c0,   0x03d6,   NOTACHAR,
  0x039a,   0x03ba,   0x03f0,   NOTACHAR,
  0x03a1,   0x03c1,   0x03f1,   NOTACHAR,
  0x0395,   0x03b5,   0x03f5,   NOTACHAR,
  0x0412,   0x0432,   0x1c80,   NOTACHAR,
  0x0414,   0x0434,   0x1c81,   NOTACHAR,
  0x041e,   0x043e,   0x1c82,   NOTACHAR,
  0x0421,   0x0441,   0x1c83,   NOTACHAR,
  0x0422,   0x0442,   0x1c84,   0x1c85,   NOTACHAR,
  0x042a,   0x044a,   0x1c86,   NOTACHAR,
  0x0462,   0x0463,   0x1c87,   NOTACHAR,
  0x1e60,   0x1e61,   0x1e9b,   NOTACHAR,
  0x03a9,   0x03c9,   0x2126,   NOTACHAR,
  0x004b,   0x006b,   0x212a,   NOTACHAR,
  0x00c5,   0x00e5,   0x212b,   NOTACHAR,
  0x1c88,   0xa64a,   0xa64b,   NOTACHAR,
};

/* When #included in pcre2test, we don't need the table of digit
sets, nor the the large main UCD tables. */

#ifndef PCRE2_PCRE2TEST

/* This table lists the code points for the '9' characters in each
set of decimal digits. It is used to ensure that all the digits in
a script run come from the same set. */

const uint32_t PRIV(ucd_digit_sets)[] = {
  66,  /* Number of subsequent values */
  0x00039, 0x00669, 0x006f9, 0x007c9, 0x0096f, 0x009ef, 0x00a6f, 0x00aef,
  0x00b6f, 0x00bef, 0x00c6f, 0x00cef, 0x00d6f, 0x00def, 0x00e59, 0x00ed9,
  0x00f29, 0x01049, 0x01099, 0x017e9, 0x01819, 0x0194f, 0x019d9, 0x01a89,
  0x01a99, 0x01b59, 0x01bb9, 0x01c49, 0x01c59, 0x0a629, 0x0a8d9, 0x0a909,
  0x0a9d9, 0x0a9f9, 0x0aa59, 0x0abf9, 0x0ff19, 0x104a9, 0x10d39, 0x1106f,
  0x110f9, 0x1113f, 0x111d9, 0x112f9, 0x11459, 0x114d9, 0x11659, 0x116c9,
  0x11739, 0x118e9, 0x11959, 0x11c59, 0x11d59, 0x11da9, 0x16a69, 0x16ac9,
  0x16b59, 0x1d7d7, 0x1d7e1, 0x1d7eb, 0x1d7f5, 0x1d7ff, 0x1e149, 0x1e2f9,
  0x1e959, 0x1fbf9,
};

/* This vector is a list of lists of scripts for the Script Extension
property. Each sublist is zero-terminated. */

const uint8_t PRIV(ucd_script_sets)[] = {
  /*   0 */   0,
  /*   1 */   1,  11,   0,
  /*   4 */   1, 144,   0,
  /*   7 */   1,  64,   0,
  /*  10 */   1,  50,   0,
  /*  13 */   1,  56,   0,
  /*  16 */   3,  15,   0,
  /*  19 */   4,  23,   0,
  /*  22 */   6,  84,   0,
  /*  25 */  12,  36,   0,
  /*  28 */  13,  18,   0,
  /*  31 */  13,  34,   0,
  /*  34 */  13, 118,   0,
  /*  37 */  13,  50,   0,
  /*  40 */  15, 107,   0,
  /*  43 */  15, 150,   0,
  /*  46 */  15, 100,   0,
  /*  49 */  15,  54,   0,
  /*  52 */  17,  34,   0,
  /*  55 */ 107,  54,   0,
  /*  58 */  21, 108,   0,
  /*  61 */  22, 129,   0,
  /*  64 */  23,  34,   0,
  /*  67 */  27,  30,   0,
  /*  70 */  29, 150,   0,
  /*  73 */  34,  38,   0,
  /*  76 */ 112, 158,   0,
  /*  79 */  38,  65,   0,
  /*  82 */   1,  50,  56,   0,
  /*  86 */   1,  56, 156,   0,
  /*  90 */   3,  96,  49,   0,
  /*  94 */  96,  39,  53,   0,
  /*  98 */ 157,  12,  36,   0,
  /* 102 */  12, 110,  36,   0,
  /* 106 */  15, 107,  29,   0,
  /* 110 */  15, 107,  34,   0,
  /* 114 */  23,  27,  30,   0,
  /* 118 */  69,  34,  39,   0,
  /* 122 */   3,  15, 107,  29,   0,
  /* 127 */   7,  25,  52,  51,   0,
  /* 132 */  15, 142,  85, 111,   0,
  /* 137 */   4,  24,  23,  27,  30,   0,
  /* 143 */   1,  64, 144,  50,  56, 156,   0,
  /* 150 */   4,  24,  23,  27,  30,  61,   0,
  /* 157 */  15,  29,  37,  44,  54,  55,   0,
  /* 164 */ 132,   1,  64, 144,  50,  56, 156,   0,
  /* 172 */   3,  15, 107,  29, 150,  44,  55, 124,   0,
  /* 181 */ 132,   1,  95, 112, 158, 121, 144, 148,  50,   0,
  /* 191 */  15, 142,  21,  22, 108,  85, 111, 114, 109, 102, 124,   0,
  /* 203 */   3,  15, 107,  21,  22,  29,  34,  37,  44,  54,  55, 124,   0,
  /* 216 */   3,  15, 107,  21,  22,  29,  34,  37,  44, 100,  54,  55, 124,   0,
  /* 230 */  15, 142,  21,  22, 108,  29,  85, 111, 114, 150, 109, 102, 124,   0,
  /* 244 */  15, 142,  21,  22, 108,  29,  85, 111,  37, 114, 150, 109, 102, 124,   0,
  /* 259 */   3,  15, 142, 143, 138, 107,  21,  22,  29, 111,  37, 150,  44, 109,  48,  49, 102,  54,  55, 124,   0,
  /* 280 */   3,  15, 142, 143, 138, 107,  21,  22,  29,  35, 111,  37, 150,  44, 109,  48,  49, 102,  54,  55, 124,   0,
  /* 302 */
};

/* These are the main two-stage UCD tables. The fields in each record are:
script (8 bits), character type (8 bits), grapheme break property (8 bits),
offset to multichar other cases or zero (8 bits), offset to other case
or zero (32 bits, signed), script extension (16 bits, signed), and a dummy
16-bit field to make the whole thing a multiple of 4 bytes. */

const ucd_record PRIV(ucd_records)[] = { /* 11964 bytes, record size 12 */
  {    10,      0,      2,      0,      0,     10,    256, }, /*   0 */
  {    10,      0,      2,      0,      0,     10,      0, }, /*   1 */
  {    10,      0,      1,      0,      0,     10,      0, }, /*   2 */
  {    10,      0,      0,      0,      0,     10,      0, }, /*   3 */
  {    10,     29,     12,      0,      0,     10,      0, }, /*   4 */
  {    10,     21,     12,      0,      0,     10,      0, }, /*   5 */
  {    10,     23,     12,      0,      0,     10,      0, }, /*   6 */
  {    10,     22,     12,      0,      0,     10,      0, }, /*   7 */
  {    10,     18,     12,      0,      0,     10,      0, }, /*   8 */
  {    10,     25,     12,      0,      0,     10,      0, }, /*   9 */
  {    10,     17,     12,      0,      0,     10,      0, }, /*  10 */
  {    10,     13,     12,      0,      0,     10,      0, }, /*  11 */
  {    34,      9,     12,      0,     32,     34,      0, }, /*  12 */
  {    34,      9,     12,    100,     32,     34,      0, }, /*  13 */
  {    34,      9,     12,      1,     32,     34,      0, }, /*  14 */
  {    10,     24,     12,      0,      0,     10,      0, }, /*  15 */
  {    10,     16,     12,      0,      0,     10,      0, }, /*  16 */
  {    34,      5,     12,      0,    -32,     34,      0, }, /*  17 */
  {    34,      5,     12,    100,    -32,     34,      0, }, /*  18 */
  {    34,      5,     12,      1,    -32,     34,      0, }, /*  19 */
  {    10,     26,     12,      0,      0,     10,      0, }, /*  20 */
  {    10,     26,     14,      0,      0,     10,      0, }, /*  21 */
  {    34,      7,     12,      0,      0,     34,      0, }, /*  22 */
  {    10,     20,     12,      0,      0,     10,      0, }, /*  23 */
  {    10,      1,      2,      0,      0,     10,      0, }, /*  24 */
  {    10,     15,     12,      0,      0,     10,      0, }, /*  25 */
  {    10,      5,     12,     26,    775,     10,      0, }, /*  26 */
  {    10,     19,     12,      0,      0,     10,      0, }, /*  27 */
  {    34,      9,     12,    104,     32,     34,      0, }, /*  28 */
  {    34,      5,     12,      0,   7615,     34,      0, }, /*  29 */
  {    34,      5,     12,    104,    -32,     34,      0, }, /*  30 */
  {    34,      5,     12,      0,    121,     34,      0, }, /*  31 */
  {    34,      9,     12,      0,      1,     34,      0, }, /*  32 */
  {    34,      5,     12,      0,     -1,     34,      0, }, /*  33 */
  {    34,      9,     12,      0,      0,     34,      0, }, /*  34 */
  {    34,      5,     12,      0,      0,     34,      0, }, /*  35 */
  {    34,      9,     12,      0,   -121,     34,      0, }, /*  36 */
  {    34,      5,     12,      1,   -268,     34,      0, }, /*  37 */
  {    34,      5,     12,      0,    195,     34,      0, }, /*  38 */
  {    34,      9,     12,      0,    210,     34,      0, }, /*  39 */
  {    34,      9,     12,      0,    206,     34,      0, }, /*  40 */
  {    34,      9,     12,      0,    205,     34,      0, }, /*  41 */
  {    34,      9,     12,      0,     79,     34,      0, }, /*  42 */
  {    34,      9,     12,      0,    202,     34,      0, }, /*  43 */
  {    34,      9,     12,      0,    203,     34,      0, }, /*  44 */
  {    34,      9,     12,      0,    207,     34,      0, }, /*  45 */
  {    34,      5,     12,      0,     97,     34,      0, }, /*  46 */
  {    34,      9,     12,      0,    211,     34,      0, }, /*  47 */
  {    34,      9,     12,      0,    209,     34,      0, }, /*  48 */
  {    34,      5,     12,      0,    163,     34,      0, }, /*  49 */
  {    34,      9,     12,      0,    213,     34,      0, }, /*  50 */
  {    34,      5,     12,      0,    130,     34,      0, }, /*  51 */
  {    34,      9,     12,      0,    214,     34,      0, }, /*  52 */
  {    34,      9,     12,      0,    218,     34,      0, }, /*  53 */
  {    34,      9,     12,      0,    217,     34,      0, }, /*  54 */
  {    34,      9,     12,      0,    219,     34,      0, }, /*  55 */
  {    34,      5,     12,      0,     56,     34,      0, }, /*  56 */
  {    34,      9,     12,      5,      2,     34,      0, }, /*  57 */
  {    34,      8,     12,      5,      1,     34,      0, }, /*  58 */
  {    34,      5,     12,      5,     -2,     34,      0, }, /*  59 */
  {    34,      9,     12,      9,      2,     34,      0, }, /*  60 */
  {    34,      8,     12,      9,      1,     34,      0, }, /*  61 */
  {    34,      5,     12,      9,     -2,     34,      0, }, /*  62 */
  {    34,      9,     12,     13,      2,     34,      0, }, /*  63 */
  {    34,      8,     12,     13,      1,     34,      0, }, /*  64 */
  {    34,      5,     12,     13,     -2,     34,      0, }, /*  65 */
  {    34,      5,     12,      0,    -79,     34,      0, }, /*  66 */
  {    34,      9,     12,     17,      2,     34,      0, }, /*  67 */
  {    34,      8,     12,     17,      1,     34,      0, }, /*  68 */
  {    34,      5,     12,     17,     -2,     34,      0, }, /*  69 */
  {    34,      9,     12,      0,    -97,     34,      0, }, /*  70 */
  {    34,      9,     12,      0,    -56,     34,      0, }, /*  71 */
  {    34,      9,     12,      0,   -130,     34,      0, }, /*  72 */
  {    34,      9,     12,      0,  10795,     34,      0, }, /*  73 */
  {    34,      9,     12,      0,   -163,     34,      0, }, /*  74 */
  {    34,      9,     12,      0,  10792,     34,      0, }, /*  75 */
  {    34,      5,     12,      0,  10815,     34,      0, }, /*  76 */
  {    34,      9,     12,      0,   -195,     34,      0, }, /*  77 */
  {    34,      9,     12,      0,     69,     34,      0, }, /*  78 */
  {    34,      9,     12,      0,     71,     34,      0, }, /*  79 */
  {    34,      5,     12,      0,  10783,     34,      0, }, /*  80 */
  {    34,      5,     12,      0,  10780,     34,      0, }, /*  81 */
  {    34,      5,     12,      0,  10782,     34,      0, }, /*  82 */
  {    34,      5,     12,      0,   -210,     34,      0, }, /*  83 */
  {    34,      5,     12,      0,   -206,     34,      0, }, /*  84 */
  {    34,      5,     12,      0,   -205,     34,      0, }, /*  85 */
  {    34,      5,     12,      0,   -202,     34,      0, }, /*  86 */
  {    34,      5,     12,      0,   -203,     34,      0, }, /*  87 */
  {    34,      5,     12,      0,  42319,     34,      0, }, /*  88 */
  {    34,      5,     12,      0,  42315,     34,      0, }, /*  89 */
  {    34,      5,     12,      0,   -207,     34,      0, }, /*  90 */
  {    34,      5,     12,      0,  42280,     34,      0, }, /*  91 */
  {    34,      5,     12,      0,  42308,     34,      0, }, /*  92 */
  {    34,      5,     12,      0,   -209,     34,      0, }, /*  93 */
  {    34,      5,     12,      0,   -211,     34,      0, }, /*  94 */
  {    34,      5,     12,      0,  10743,     34,      0, }, /*  95 */
  {    34,      5,     12,      0,  42305,     34,      0, }, /*  96 */
  {    34,      5,     12,      0,  10749,     34,      0, }, /*  97 */
  {    34,      5,     12,      0,   -213,     34,      0, }, /*  98 */
  {    34,      5,     12,      0,   -214,     34,      0, }, /*  99 */
  {    34,      5,     12,      0,  10727,     34,      0, }, /* 100 */
  {    34,      5,     12,      0,   -218,     34,      0, }, /* 101 */
  {    34,      5,     12,      0,  42307,     34,      0, }, /* 102 */
  {    34,      5,     12,      0,  42282,     34,      0, }, /* 103 */
  {    34,      5,     12,      0,    -69,     34,      0, }, /* 104 */
  {    34,      5,     12,      0,   -217,     34,      0, }, /* 105 */
  {    34,      5,     12,      0,    -71,     34,      0, }, /* 106 */
  {    34,      5,     12,      0,   -219,     34,      0, }, /* 107 */
  {    34,      5,     12,      0,  42261,     34,      0, }, /* 108 */
  {    34,      5,     12,      0,  42258,     34,      0, }, /* 109 */
  {    34,      6,     12,      0,      0,     34,      0, }, /* 110 */
  {    10,      6,     12,      0,      0,     10,      0, }, /* 111 */
  {     4,     24,     12,      0,      0,      4,      0, }, /* 112 */
  {    28,     12,      3,      0,      0,     28,      0, }, /* 113 */
  {    28,     12,      3,      0,      0,     20,      0, }, /* 114 */
  {    28,     12,      3,     21,    116,     20,      0, }, /* 115 */
  {    28,     12,      3,      0,      0,     34,      0, }, /* 116 */
  {    20,      9,     12,      0,      1,     20,      0, }, /* 117 */
  {    20,      5,     12,      0,     -1,     20,      0, }, /* 118 */
  {    20,     24,     12,      0,      0,     20,      0, }, /* 119 */
  {     0,      2,     12,      0,      0,      0,      0, }, /* 120 */
  {    20,      6,     12,      0,      0,     20,      0, }, /* 121 */
  {    20,      5,     12,      0,    130,     20,      0, }, /* 122 */
  {    20,      9,     12,      0,    116,     20,      0, }, /* 123 */
  {    20,      9,     12,      0,     38,     20,      0, }, /* 124 */
  {    20,      9,     12,      0,     37,     20,      0, }, /* 125 */
  {    20,      9,     12,      0,     64,     20,      0, }, /* 126 */
  {    20,      9,     12,      0,     63,     20,      0, }, /* 127 */
  {    20,      5,     12,      0,      0,     20,      0, }, /* 128 */
  {    20,      9,     12,      0,     32,     20,      0, }, /* 129 */
  {    20,      9,     12,     34,     32,     20,      0, }, /* 130 */
  {    20,      9,     12,     59,     32,     20,      0, }, /* 131 */
  {    20,      9,     12,     38,     32,     20,      0, }, /* 132 */
  {    20,      9,     12,     21,     32,     20,      0, }, /* 133 */
  {    20,      9,     12,     51,     32,     20,      0, }, /* 134 */
  {    20,      9,     12,     26,     32,     20,      0, }, /* 135 */
  {    20,      9,     12,     47,     32,     20,      0, }, /* 136 */
  {    20,      9,     12,     55,     32,     20,      0, }, /* 137 */
  {    20,      9,     12,     30,     32,     20,      0, }, /* 138 */
  {    20,      9,     12,     43,     32,     20,      0, }, /* 139 */
  {    20,      9,     12,     96,     32,     20,      0, }, /* 140 */
  {    20,      5,     12,      0,    -38,     20,      0, }, /* 141 */
  {    20,      5,     12,      0,    -37,     20,      0, }, /* 142 */
  {    20,      5,     12,      0,    -32,     20,      0, }, /* 143 */
  {    20,      5,     12,     34,    -32,     20,      0, }, /* 144 */
  {    20,      5,     12,     59,    -32,     20,      0, }, /* 145 */
  {    20,      5,     12,     38,    -32,     20,      0, }, /* 146 */
  {    20,      5,     12,     21,   -116,     20,      0, }, /* 147 */
  {    20,      5,     12,     51,    -32,     20,      0, }, /* 148 */
  {    20,      5,     12,     26,   -775,     20,      0, }, /* 149 */
  {    20,      5,     12,     47,    -32,     20,      0, }, /* 150 */
  {    20,      5,     12,     55,    -32,     20,      0, }, /* 151 */
  {    20,      5,     12,     30,      1,     20,      0, }, /* 152 */
  {    20,      5,     12,     30,    -32,     20,      0, }, /* 153 */
  {    20,      5,     12,     43,    -32,     20,      0, }, /* 154 */
  {    20,      5,     12,     96,    -32,     20,      0, }, /* 155 */
  {    20,      5,     12,      0,    -64,     20,      0, }, /* 156 */
  {    20,      5,     12,      0,    -63,     20,      0, }, /* 157 */
  {    20,      9,     12,      0,      8,     20,      0, }, /* 158 */
  {    20,      5,     12,     34,    -30,     20,      0, }, /* 159 */
  {    20,      5,     12,     38,    -25,     20,      0, }, /* 160 */
  {    20,      9,     12,      0,      0,     20,      0, }, /* 161 */
  {    20,      5,     12,     43,    -15,     20,      0, }, /* 162 */
  {    20,      5,     12,     47,    -22,     20,      0, }, /* 163 */
  {    20,      5,     12,      0,     -8,     20,      0, }, /* 164 */
  {    11,      9,     12,      0,      1,     11,      0, }, /* 165 */
  {    11,      5,     12,      0,     -1,     11,      0, }, /* 166 */
  {    20,      5,     12,     51,    -54,     20,      0, }, /* 167 */
  {    20,      5,     12,     55,    -48,     20,      0, }, /* 168 */
  {    20,      5,     12,      0,      7,     20,      0, }, /* 169 */
  {    20,      5,     12,      0,   -116,     20,      0, }, /* 170 */
  {    20,      9,     12,     38,    -60,     20,      0, }, /* 171 */
  {    20,      5,     12,     59,    -64,     20,      0, }, /* 172 */
  {    20,     25,     12,      0,      0,     20,      0, }, /* 173 */
  {    20,      9,     12,      0,     -7,     20,      0, }, /* 174 */
  {    20,      9,     12,      0,   -130,     20,      0, }, /* 175 */
  {    13,      9,     12,      0,     80,     13,      0, }, /* 176 */
  {    13,      9,     12,      0,     32,     13,      0, }, /* 177 */
  {    13,      9,     12,     63,     32,     13,      0, }, /* 178 */
  {    13,      9,     12,     67,     32,     13,      0, }, /* 179 */
  {    13,      9,     12,     71,     32,     13,      0, }, /* 180 */
  {    13,      9,     12,     75,     32,     13,      0, }, /* 181 */
  {    13,      9,     12,     79,     32,     13,      0, }, /* 182 */
  {    13,      9,     12,     84,     32,     13,      0, }, /* 183 */
  {    13,      5,     12,      0,    -32,     13,      0, }, /* 184 */
  {    13,      5,     12,     63,    -32,     13,      0, }, /* 185 */
  {    13,      5,     12,     67,    -32,     13,      0, }, /* 186 */
  {    13,      5,     12,     71,    -32,     13,      0, }, /* 187 */
  {    13,      5,     12,     75,    -32,     13,      0, }, /* 188 */
  {    13,      5,     12,     79,    -32,     13,      0, }, /* 189 */
  {    13,      5,     12,     84,    -32,     13,      0, }, /* 190 */
  {    13,      5,     12,      0,    -80,     13,      0, }, /* 191 */
  {    13,      9,     12,      0,      1,     13,      0, }, /* 192 */
  {    13,      5,     12,      0,     -1,     13,      0, }, /* 193 */
  {    13,      9,     12,     88,      1,     13,      0, }, /* 194 */
  {    13,      5,     12,     88,     -1,     13,      0, }, /* 195 */
  {    13,     26,     12,      0,      0,     13,      0, }, /* 196 */
  {    13,     12,      3,      0,      0,    -34,      0, }, /* 197 */
  {    13,     12,      3,      0,      0,    -28,      0, }, /* 198 */
  {    28,     12,      3,      0,      0,    -31,      0, }, /* 199 */
  {    13,     11,      3,      0,      0,     13,      0, }, /* 200 */
  {    13,      9,     12,      0,     15,     13,      0, }, /* 201 */
  {    13,      5,     12,      0,    -15,     13,      0, }, /* 202 */
  {     2,      9,     12,      0,     48,      2,      0, }, /* 203 */
  {     2,      6,     12,      0,      0,      2,      0, }, /* 204 */
  {     2,     21,     12,      0,      0,      2,      0, }, /* 205 */
  {     2,      5,     12,      0,      0,      2,      0, }, /* 206 */
  {     2,      5,     12,      0,    -48,      2,      0, }, /* 207 */
  {     2,     17,     12,      0,      0,      2,      0, }, /* 208 */
  {     2,     26,     12,      0,      0,      2,      0, }, /* 209 */
  {     2,     23,     12,      0,      0,      2,      0, }, /* 210 */
  {    26,     12,      3,      0,      0,     26,      0, }, /* 211 */
  {    26,     17,     12,      0,      0,     26,      0, }, /* 212 */
  {    26,     21,     12,      0,      0,     26,      0, }, /* 213 */
  {    26,      7,     12,      0,      0,     26,      0, }, /* 214 */
  {     1,      1,      4,      0,      0,      1,      0, }, /* 215 */
  {    10,      1,      4,      0,      0,     10,      0, }, /* 216 */
  {     1,     25,     12,      0,      0,      1,      0, }, /* 217 */
  {     1,     21,     12,      0,      0,      1,      0, }, /* 218 */
  {     1,     23,     12,      0,      0,      1,      0, }, /* 219 */
  {    10,     21,     12,      0,      0,   -143,      0, }, /* 220 */
  {     1,     26,     12,      0,      0,      1,      0, }, /* 221 */
  {     1,     12,      3,      0,      0,      1,      0, }, /* 222 */
  {     1,      1,      2,      0,      0,    -82,      0, }, /* 223 */
  {    10,     21,     12,      0,      0,   -164,      0, }, /* 224 */
  {     1,      7,     12,      0,      0,      1,      0, }, /* 225 */
  {    10,      6,     12,      0,      0,   -181,      0, }, /* 226 */
  {    28,     12,      3,      0,      0,    -10,      0, }, /* 227 */
  {     1,     13,     12,      0,      0,    -86,      0, }, /* 228 */
  {     1,     21,     12,      0,      0,     -4,      0, }, /* 229 */
  {     1,      6,     12,      0,      0,      1,      0, }, /* 230 */
  {     1,     13,     12,      0,      0,      1,      0, }, /* 231 */
  {    50,     21,     12,      0,      0,     50,      0, }, /* 232 */
  {    50,      1,      4,      0,      0,     50,      0, }, /* 233 */
  {    50,      7,     12,      0,      0,     50,      0, }, /* 234 */
  {    50,     12,      3,      0,      0,     50,      0, }, /* 235 */
  {    56,      7,     12,      0,      0,     56,      0, }, /* 236 */
  {    56,     12,      3,      0,      0,     56,      0, }, /* 237 */
  {    64,     13,     12,      0,      0,     64,      0, }, /* 238 */
  {    64,      7,     12,      0,      0,     64,      0, }, /* 239 */
  {    64,     12,      3,      0,      0,     64,      0, }, /* 240 */
  {    64,      6,     12,      0,      0,     64,      0, }, /* 241 */
  {    64,     26,     12,      0,      0,     64,      0, }, /* 242 */
  {    64,     21,     12,      0,      0,     64,      0, }, /* 243 */
  {    64,     23,     12,      0,      0,     64,      0, }, /* 244 */
  {    90,      7,     12,      0,      0,     90,      0, }, /* 245 */
  {    90,     12,      3,      0,      0,     90,      0, }, /* 246 */
  {    90,      6,     12,      0,      0,     90,      0, }, /* 247 */
  {    90,     21,     12,      0,      0,     90,      0, }, /* 248 */
  {    95,      7,     12,      0,      0,     95,      0, }, /* 249 */
  {    95,     12,      3,      0,      0,     95,      0, }, /* 250 */
  {    95,     21,     12,      0,      0,     95,      0, }, /* 251 */
  {     1,     24,     12,      0,      0,      1,      0, }, /* 252 */
  {    15,     12,      3,      0,      0,     15,      0, }, /* 253 */
  {    15,     10,      5,      0,      0,     15,      0, }, /* 254 */
  {    15,      7,     12,      0,      0,     15,      0, }, /* 255 */
  {    28,     12,      3,      0,      0,   -216,      0, }, /* 256 */
  {    28,     12,      3,      0,      0,   -203,      0, }, /* 257 */
  {    10,     21,     12,      0,      0,   -259,      0, }, /* 258 */
  {    10,     21,     12,      0,      0,   -280,      0, }, /* 259 */
  {    15,     13,     12,      0,      0,   -132,      0, }, /* 260 */
  {    15,     21,     12,      0,      0,     15,      0, }, /* 261 */
  {    15,      6,     12,      0,      0,     15,      0, }, /* 262 */
  {     3,      7,     12,      0,      0,      3,      0, }, /* 263 */
  {     3,     12,      3,      0,      0,      3,      0, }, /* 264 */
  {     3,     10,      5,      0,      0,      3,      0, }, /* 265 */
  {     3,     10,      3,      0,      0,      3,      0, }, /* 266 */
  {     3,     13,     12,      0,      0,    -90,      0, }, /* 267 */
  {     3,     23,     12,      0,      0,      3,      0, }, /* 268 */
  {     3,     15,     12,      0,      0,      3,      0, }, /* 269 */
  {     3,     26,     12,      0,      0,      3,      0, }, /* 270 */
  {     3,     21,     12,      0,      0,      3,      0, }, /* 271 */
  {    22,     12,      3,      0,      0,     22,      0, }, /* 272 */
  {    22,     10,      5,      0,      0,     22,      0, }, /* 273 */
  {    22,      7,     12,      0,      0,     22,      0, }, /* 274 */
  {    22,     13,     12,      0,      0,    -61,      0, }, /* 275 */
  {    22,     21,     12,      0,      0,     22,      0, }, /* 276 */
  {    21,     12,      3,      0,      0,     21,      0, }, /* 277 */
  {    21,     10,      5,      0,      0,     21,      0, }, /* 278 */
  {    21,      7,     12,      0,      0,     21,      0, }, /* 279 */
  {    21,     13,     12,      0,      0,    -58,      0, }, /* 280 */
  {    21,     21,     12,      0,      0,     21,      0, }, /* 281 */
  {    21,     23,     12,      0,      0,     21,      0, }, /* 282 */
  {    44,     12,      3,      0,      0,     44,      0, }, /* 283 */
  {    44,     10,      5,      0,      0,     44,      0, }, /* 284 */
  {    44,      7,     12,      0,      0,     44,      0, }, /* 285 */
  {    44,     10,      3,      0,      0,     44,      0, }, /* 286 */
  {    44,     13,     12,      0,      0,     44,      0, }, /* 287 */
  {    44,     26,     12,      0,      0,     44,      0, }, /* 288 */
  {    44,     15,     12,      0,      0,     44,      0, }, /* 289 */
  {    54,     12,      3,      0,      0,     54,      0, }, /* 290 */
  {    54,      7,     12,      0,      0,     54,      0, }, /* 291 */
  {    54,     10,      3,      0,      0,     54,      0, }, /* 292 */
  {    54,     10,      5,      0,      0,     54,      0, }, /* 293 */
  {    54,     13,     12,      0,      0,    -55,      0, }, /* 294 */
  {    54,     15,     12,      0,      0,    -55,      0, }, /* 295 */
  {    54,     26,     12,      0,      0,    -55,      0, }, /* 296 */
  {    54,     26,     12,      0,      0,     54,      0, }, /* 297 */
  {    54,     23,     12,      0,      0,     54,      0, }, /* 298 */
  {    55,     12,      3,      0,      0,     55,      0, }, /* 299 */
  {    55,     10,      5,      0,      0,     55,      0, }, /* 300 */
  {    55,      7,     12,      0,      0,     55,      0, }, /* 301 */
  {    55,     13,     12,      0,      0,     55,      0, }, /* 302 */
  {    55,     21,     12,      0,      0,     55,      0, }, /* 303 */
  {    55,     15,     12,      0,      0,     55,      0, }, /* 304 */
  {    55,     26,     12,      0,      0,     55,      0, }, /* 305 */
  {    29,      7,     12,      0,      0,     29,      0, }, /* 306 */
  {    29,     12,      3,      0,      0,     29,      0, }, /* 307 */
  {    29,     10,      5,      0,      0,     29,      0, }, /* 308 */
  {    29,     21,     12,      0,      0,     29,      0, }, /* 309 */
  {    29,     10,      3,      0,      0,     29,      0, }, /* 310 */
  {    29,     13,     12,      0,      0,    -70,      0, }, /* 311 */
  {    37,     12,      3,      0,      0,     37,      0, }, /* 312 */
  {    37,     10,      5,      0,      0,     37,      0, }, /* 313 */
  {    37,      7,     12,      0,      0,     37,      0, }, /* 314 */
  {    37,     10,      3,      0,      0,     37,      0, }, /* 315 */
  {    37,      7,      4,      0,      0,     37,      0, }, /* 316 */
  {    37,     26,     12,      0,      0,     37,      0, }, /* 317 */
  {    37,     15,     12,      0,      0,     37,      0, }, /* 318 */
  {    37,     13,     12,      0,      0,     37,      0, }, /* 319 */
  {    48,     12,      3,      0,      0,     48,      0, }, /* 320 */
  {    48,     10,      5,      0,      0,     48,      0, }, /* 321 */
  {    48,      7,     12,      0,      0,     48,      0, }, /* 322 */
  {    48,     10,      3,      0,      0,     48,      0, }, /* 323 */
  {    48,     13,     12,      0,      0,     48,      0, }, /* 324 */
  {    48,     21,     12,      0,      0,     48,      0, }, /* 325 */
  {    57,      7,     12,      0,      0,     57,      0, }, /* 326 */
  {    57,     12,      3,      0,      0,     57,      0, }, /* 327 */
  {    57,      7,      5,      0,      0,     57,      0, }, /* 328 */
  {    57,      6,     12,      0,      0,     57,      0, }, /* 329 */
  {    57,     21,     12,      0,      0,     57,      0, }, /* 330 */
  {    57,     13,     12,      0,      0,     57,      0, }, /* 331 */
  {    33,      7,     12,      0,      0,     33,      0, }, /* 332 */
  {    33,     12,      3,      0,      0,     33,      0, }, /* 333 */
  {    33,      7,      5,      0,      0,     33,      0, }, /* 334 */
  {    33,      6,     12,      0,      0,     33,      0, }, /* 335 */
  {    33,     13,     12,      0,      0,     33,      0, }, /* 336 */
  {    58,      7,     12,      0,      0,     58,      0, }, /* 337 */
  {    58,     26,     12,      0,      0,     58,      0, }, /* 338 */
  {    58,     21,     12,      0,      0,     58,      0, }, /* 339 */
  {    58,     12,      3,      0,      0,     58,      0, }, /* 340 */
  {    58,     13,     12,      0,      0,     58,      0, }, /* 341 */
  {    58,     15,     12,      0,      0,     58,      0, }, /* 342 */
  {    58,     22,     12,      0,      0,     58,      0, }, /* 343 */
  {    58,     18,     12,      0,      0,     58,      0, }, /* 344 */
  {    58,     10,      5,      0,      0,     58,      0, }, /* 345 */
  {    39,      7,     12,      0,      0,     39,      0, }, /* 346 */
  {    39,     10,     12,      0,      0,     39,      0, }, /* 347 */
  {    39,     12,      3,      0,      0,     39,      0, }, /* 348 */
  {    39,     10,      5,      0,      0,     39,      0, }, /* 349 */
  {    39,     13,     12,      0,      0,    -94,      0, }, /* 350 */
  {    39,     21,     12,      0,      0,     39,      0, }, /* 351 */
  {    39,     13,     12,      0,      0,     39,      0, }, /* 352 */
  {    39,     26,     12,      0,      0,     39,      0, }, /* 353 */
  {    17,      9,     12,      0,   7264,     17,      0, }, /* 354 */
  {    17,      5,     12,      0,   3008,     17,      0, }, /* 355 */
  {    10,     21,     12,      0,      0,    -52,      0, }, /* 356 */
  {    17,      6,     12,      0,      0,     17,      0, }, /* 357 */
  {    24,      7,      6,      0,      0,     24,      0, }, /* 358 */
  {    24,      7,      7,      0,      0,     24,      0, }, /* 359 */
  {    24,      7,      8,      0,      0,     24,      0, }, /* 360 */
  {    16,      7,     12,      0,      0,     16,      0, }, /* 361 */
  {    16,     12,      3,      0,      0,     16,      0, }, /* 362 */
  {    16,     21,     12,      0,      0,     16,      0, }, /* 363 */
  {    16,     15,     12,      0,      0,     16,      0, }, /* 364 */
  {    16,     26,     12,      0,      0,     16,      0, }, /* 365 */
  {     9,      9,     12,      0,  38864,      9,      0, }, /* 366 */
  {     9,      9,     12,      0,      8,      9,      0, }, /* 367 */
  {     9,      5,     12,      0,     -8,      9,      0, }, /* 368 */
  {     8,     17,     12,      0,      0,      8,      0, }, /* 369 */
  {     8,      7,     12,      0,      0,      8,      0, }, /* 370 */
  {     8,     26,     12,      0,      0,      8,      0, }, /* 371 */
  {     8,     21,     12,      0,      0,      8,      0, }, /* 372 */
  {    41,     29,     12,      0,      0,     41,      0, }, /* 373 */
  {    41,      7,     12,      0,      0,     41,      0, }, /* 374 */
  {    41,     22,     12,      0,      0,     41,      0, }, /* 375 */
  {    41,     18,     12,      0,      0,     41,      0, }, /* 376 */
  {    46,      7,     12,      0,      0,     46,      0, }, /* 377 */
  {    46,     14,     12,      0,      0,     46,      0, }, /* 378 */
  {    51,      7,     12,      0,      0,     51,      0, }, /* 379 */
  {    51,     12,      3,      0,      0,     51,      0, }, /* 380 */
  {    51,     10,      5,      0,      0,     51,      0, }, /* 381 */
  {    25,      7,     12,      0,      0,     25,      0, }, /* 382 */
  {    25,     12,      3,      0,      0,     25,      0, }, /* 383 */
  {    25,     10,      5,      0,      0,     25,      0, }, /* 384 */
  {    10,     21,     12,      0,      0,   -127,      0, }, /* 385 */
  {     7,      7,     12,      0,      0,      7,      0, }, /* 386 */
  {     7,     12,      3,      0,      0,      7,      0, }, /* 387 */
  {    52,      7,     12,      0,      0,     52,      0, }, /* 388 */
  {    52,     12,      3,      0,      0,     52,      0, }, /* 389 */
  {    32,      7,     12,      0,      0,     32,      0, }, /* 390 */
  {    32,     12,      3,      0,      0,     32,      0, }, /* 391 */
  {    32,     10,      5,      0,      0,     32,      0, }, /* 392 */
  {    32,     21,     12,      0,      0,     32,      0, }, /* 393 */
  {    32,      6,     12,      0,      0,     32,      0, }, /* 394 */
  {    32,     23,     12,      0,      0,     32,      0, }, /* 395 */
  {    32,     13,     12,      0,      0,     32,      0, }, /* 396 */
  {    32,     15,     12,      0,      0,     32,      0, }, /* 397 */
  {    38,     21,     12,      0,      0,     38,      0, }, /* 398 */
  {    10,     21,     12,      0,      0,    -79,      0, }, /* 399 */
  {    38,     17,     12,      0,      0,     38,      0, }, /* 400 */
  {    38,     12,      3,      0,      0,     38,      0, }, /* 401 */
  {    38,      1,      2,      0,      0,     38,      0, }, /* 402 */
  {    38,     13,     12,      0,      0,     38,      0, }, /* 403 */
  {    38,      7,     12,      0,      0,     38,      0, }, /* 404 */
  {    38,      6,     12,      0,      0,     38,      0, }, /* 405 */
  {    35,      7,     12,      0,      0,     35,      0, }, /* 406 */
  {    35,     12,      3,      0,      0,     35,      0, }, /* 407 */
  {    35,     10,      5,      0,      0,     35,      0, }, /* 408 */
  {    35,     26,     12,      0,      0,     35,      0, }, /* 409 */
  {    35,     21,     12,      0,      0,     35,      0, }, /* 410 */
  {    35,     13,     12,      0,      0,     35,      0, }, /* 411 */
  {    53,      7,     12,      0,      0,     53,      0, }, /* 412 */
  {    40,      7,     12,      0,      0,     40,      0, }, /* 413 */
  {    40,     13,     12,      0,      0,     40,      0, }, /* 414 */
  {    40,     15,     12,      0,      0,     40,      0, }, /* 415 */
  {    40,     26,     12,      0,      0,     40,      0, }, /* 416 */
  {    32,     26,     12,      0,      0,     32,      0, }, /* 417 */
  {     6,      7,     12,      0,      0,      6,      0, }, /* 418 */
  {     6,     12,      3,      0,      0,      6,      0, }, /* 419 */
  {     6,     10,      5,      0,      0,      6,      0, }, /* 420 */
  {     6,     21,     12,      0,      0,      6,      0, }, /* 421 */
  {    91,      7,     12,      0,      0,     91,      0, }, /* 422 */
  {    91,     10,      5,      0,      0,     91,      0, }, /* 423 */
  {    91,     12,      3,      0,      0,     91,      0, }, /* 424 */
  {    91,     10,     12,      0,      0,     91,      0, }, /* 425 */
  {    91,     13,     12,      0,      0,     91,      0, }, /* 426 */
  {    91,     21,     12,      0,      0,     91,      0, }, /* 427 */
  {    91,      6,     12,      0,      0,     91,      0, }, /* 428 */
  {    28,     11,      3,      0,      0,     28,      0, }, /* 429 */
  {    62,     12,      3,      0,      0,     62,      0, }, /* 430 */
  {    62,     10,      5,      0,      0,     62,      0, }, /* 431 */
  {    62,      7,     12,      0,      0,     62,      0, }, /* 432 */
  {    62,     10,      3,      0,      0,     62,      0, }, /* 433 */
  {    62,     13,     12,      0,      0,     62,      0, }, /* 434 */
  {    62,     21,     12,      0,      0,     62,      0, }, /* 435 */
  {    62,     26,     12,      0,      0,     62,      0, }, /* 436 */
  {    76,     12,      3,      0,      0,     76,      0, }, /* 437 */
  {    76,     10,      5,      0,      0,     76,      0, }, /* 438 */
  {    76,      7,     12,      0,      0,     76,      0, }, /* 439 */
  {    76,     13,     12,      0,      0,     76,      0, }, /* 440 */
  {    93,      7,     12,      0,      0,     93,      0, }, /* 441 */
  {    93,     12,      3,      0,      0,     93,      0, }, /* 442 */
  {    93,     10,      5,      0,      0,     93,      0, }, /* 443 */
  {    93,     21,     12,      0,      0,     93,      0, }, /* 444 */
  {    70,      7,     12,      0,      0,     70,      0, }, /* 445 */
  {    70,     10,      5,      0,      0,     70,      0, }, /* 446 */
  {    70,     12,      3,      0,      0,     70,      0, }, /* 447 */
  {    70,     21,     12,      0,      0,     70,      0, }, /* 448 */
  {    70,     13,     12,      0,      0,     70,      0, }, /* 449 */
  {    73,     13,     12,      0,      0,     73,      0, }, /* 450 */
  {    73,      7,     12,      0,      0,     73,      0, }, /* 451 */
  {    73,      6,     12,      0,      0,     73,      0, }, /* 452 */
  {    73,     21,     12,      0,      0,     73,      0, }, /* 453 */
  {    13,      5,     12,     63,  -6222,     13,      0, }, /* 454 */
  {    13,      5,     12,     67,  -6221,     13,      0, }, /* 455 */
  {    13,      5,     12,     71,  -6212,     13,      0, }, /* 456 */
  {    13,      5,     12,     75,  -6210,     13,      0, }, /* 457 */
  {    13,      5,     12,     79,  -6210,     13,      0, }, /* 458 */
  {    13,      5,     12,     79,  -6211,     13,      0, }, /* 459 */
  {    13,      5,     12,     84,  -6204,     13,      0, }, /* 460 */
  {    13,      5,     12,     88,  -6180,     13,      0, }, /* 461 */
  {    13,      5,     12,    108,  35267,     13,      0, }, /* 462 */
  {    17,      9,     12,      0,  -3008,     17,      0, }, /* 463 */
  {    76,     21,     12,      0,      0,     76,      0, }, /* 464 */
  {    28,     12,      3,      0,      0,   -122,      0, }, /* 465 */
  {    28,     12,      3,      0,      0,     15,      0, }, /* 466 */
  {    10,     21,     12,      0,      0,    -40,      0, }, /* 467 */
  {    28,     12,      3,      0,      0,    -16,      0, }, /* 468 */
  {    28,     12,      3,      0,      0,    -46,      0, }, /* 469 */
  {    28,     12,      3,      0,      0,   -157,      0, }, /* 470 */
  {    10,     10,      5,      0,      0,    -16,      0, }, /* 471 */
  {    10,      7,     12,      0,      0,    -43,      0, }, /* 472 */
  {    10,      7,     12,      0,      0,    -16,      0, }, /* 473 */
  {    10,      7,     12,      0,      0,     15,      0, }, /* 474 */
  {    10,      7,     12,      0,      0,   -172,      0, }, /* 475 */
  {    10,      7,     12,      0,      0,    -40,      0, }, /* 476 */
  {    28,     12,      3,      0,      0,   -106,      0, }, /* 477 */
  {    10,     10,      5,      0,      0,      3,      0, }, /* 478 */
  {    28,     12,      3,      0,      0,    -40,      0, }, /* 479 */
  {    10,      7,     12,      0,      0,    150,      0, }, /* 480 */
  {    13,      5,     12,      0,      0,     13,      0, }, /* 481 */
  {    13,      6,     12,      0,      0,     13,      0, }, /* 482 */
  {    34,      5,     12,      0,  35332,     34,      0, }, /* 483 */
  {    34,      5,     12,      0,   3814,     34,      0, }, /* 484 */
  {    34,      5,     12,      0,  35384,     34,      0, }, /* 485 */
  {    28,     12,      3,      0,      0,    -37,      0, }, /* 486 */
  {    28,     12,      3,      0,      0,     50,      0, }, /* 487 */
  {    34,      9,     12,     92,      1,     34,      0, }, /* 488 */
  {    34,      5,     12,     92,     -1,     34,      0, }, /* 489 */
  {    34,      5,     12,     92,    -58,     34,      0, }, /* 490 */
  {    34,      9,     12,      0,  -7615,     34,      0, }, /* 491 */
  {    20,      5,     12,      0,      8,     20,      0, }, /* 492 */
  {    20,      9,     12,      0,     -8,     20,      0, }, /* 493 */
  {    20,      5,     12,      0,     74,     20,      0, }, /* 494 */
  {    20,      5,     12,      0,     86,     20,      0, }, /* 495 */
  {    20,      5,     12,      0,    100,     20,      0, }, /* 496 */
  {    20,      5,     12,      0,    128,     20,      0, }, /* 497 */
  {    20,      5,     12,      0,    112,     20,      0, }, /* 498 */
  {    20,      5,     12,      0,    126,     20,      0, }, /* 499 */
  {    20,      8,     12,      0,     -8,     20,      0, }, /* 500 */
  {    20,      5,     12,      0,      9,     20,      0, }, /* 501 */
  {    20,      9,     12,      0,    -74,     20,      0, }, /* 502 */
  {    20,      8,     12,      0,     -9,     20,      0, }, /* 503 */
  {    20,      5,     12,     21,  -7173,     20,      0, }, /* 504 */
  {    20,      9,     12,      0,    -86,     20,      0, }, /* 505 */
  {    20,      9,     12,      0,   -100,     20,      0, }, /* 506 */
  {    20,      9,     12,      0,   -112,     20,      0, }, /* 507 */
  {    20,      9,     12,      0,   -128,     20,      0, }, /* 508 */
  {    20,      9,     12,      0,   -126,     20,      0, }, /* 509 */
  {    28,      1,      3,      0,      0,     28,      0, }, /* 510 */
  {    28,      1,     13,      0,      0,     28,      0, }, /* 511 */
  {    10,     27,      2,      0,      0,     10,      0, }, /* 512 */
  {    10,     28,      2,      0,      0,     10,      0, }, /* 513 */
  {    10,     29,     12,      0,      0,    -73,      0, }, /* 514 */
  {    10,     21,     14,      0,      0,     10,      0, }, /* 515 */
  {     0,      2,      2,      0,      0,      0,      0, }, /* 516 */
  {    28,     12,      3,      0,      0,   -110,      0, }, /* 517 */
  {    10,      9,     12,      0,      0,     10,      0, }, /* 518 */
  {    10,      5,     12,      0,      0,     10,      0, }, /* 519 */
  {    20,      9,     12,     96,  -7517,     20,      0, }, /* 520 */
  {    34,      9,     12,    100,  -8383,     34,      0, }, /* 521 */
  {    34,      9,     12,    104,  -8262,     34,      0, }, /* 522 */
  {    34,      9,     12,      0,     28,     34,      0, }, /* 523 */
  {    10,      7,     12,      0,      0,     10,      0, }, /* 524 */
  {    10,      5,     14,      0,      0,     10,      0, }, /* 525 */
  {    34,      5,     12,      0,    -28,     34,      0, }, /* 526 */
  {    34,     14,     12,      0,     16,     34,      0, }, /* 527 */
  {    34,     14,     12,      0,    -16,     34,      0, }, /* 528 */
  {    34,     14,     12,      0,      0,     34,      0, }, /* 529 */
  {    10,     25,     14,      0,      0,     10,      0, }, /* 530 */
  {    10,     26,     12,      0,     26,     10,      0, }, /* 531 */
  {    10,     26,     14,      0,     26,     10,      0, }, /* 532 */
  {    10,     26,     12,      0,    -26,     10,      0, }, /* 533 */
  {     5,     26,     12,      0,      0,      5,      0, }, /* 534 */
  {    18,      9,     12,      0,     48,     18,      0, }, /* 535 */
  {    18,      5,     12,      0,    -48,     18,      0, }, /* 536 */
  {    34,      9,     12,      0, -10743,     34,      0, }, /* 537 */
  {    34,      9,     12,      0,  -3814,     34,      0, }, /* 538 */
  {    34,      9,     12,      0, -10727,     34,      0, }, /* 539 */
  {    34,      5,     12,      0, -10795,     34,      0, }, /* 540 */
  {    34,      5,     12,      0, -10792,     34,      0, }, /* 541 */
  {    34,      9,     12,      0, -10780,     34,      0, }, /* 542 */
  {    34,      9,     12,      0, -10749,     34,      0, }, /* 543 */
  {    34,      9,     12,      0, -10783,     34,      0, }, /* 544 */
  {    34,      9,     12,      0, -10782,     34,      0, }, /* 545 */
  {    34,      9,     12,      0, -10815,     34,      0, }, /* 546 */
  {    11,      5,     12,      0,      0,     11,      0, }, /* 547 */
  {    11,     26,     12,      0,      0,     11,      0, }, /* 548 */
  {    11,     12,      3,      0,      0,     11,      0, }, /* 549 */
  {    11,     21,     12,      0,      0,     11,      0, }, /* 550 */
  {    11,     15,     12,      0,      0,     11,      0, }, /* 551 */
  {    17,      5,     12,      0,  -7264,     17,      0, }, /* 552 */
  {    59,      7,     12,      0,      0,     59,      0, }, /* 553 */
  {    59,      6,     12,      0,      0,     59,      0, }, /* 554 */
  {    59,     21,     12,      0,      0,     59,      0, }, /* 555 */
  {    59,     12,      3,      0,      0,     59,      0, }, /* 556 */
  {    13,     12,      3,      0,      0,     13,      0, }, /* 557 */
  {    10,     21,     12,      0,      0,    -28,      0, }, /* 558 */
  {    23,     26,     12,      0,      0,     23,      0, }, /* 559 */
  {    10,     21,     12,      0,      0,   -150,      0, }, /* 560 */
  {    10,     21,     12,      0,      0,   -137,      0, }, /* 561 */
  {    23,      6,     12,      0,      0,     23,      0, }, /* 562 */
  {    10,      7,     12,      0,      0,     23,      0, }, /* 563 */
  {    23,     14,     12,      0,      0,     23,      0, }, /* 564 */
  {    10,     22,     12,      0,      0,   -150,      0, }, /* 565 */
  {    10,     18,     12,      0,      0,   -150,      0, }, /* 566 */
  {    10,     26,     12,      0,      0,   -137,      0, }, /* 567 */
  {    10,     17,     12,      0,      0,   -137,      0, }, /* 568 */
  {    10,     22,     12,      0,      0,   -137,      0, }, /* 569 */
  {    10,     18,     12,      0,      0,   -137,      0, }, /* 570 */
  {    28,     12,      3,      0,      0,    -19,      0, }, /* 571 */
  {    24,     10,      3,      0,      0,     24,      0, }, /* 572 */
  {    10,     17,     14,      0,      0,   -137,      0, }, /* 573 */
  {    10,      6,     12,      0,      0,    -67,      0, }, /* 574 */
  {    10,      7,     12,      0,      0,   -114,      0, }, /* 575 */
  {    10,     21,     14,      0,      0,   -114,      0, }, /* 576 */
  {    10,     26,     12,      0,      0,     23,      0, }, /* 577 */
  {    27,      7,     12,      0,      0,     27,      0, }, /* 578 */
  {    28,     12,      3,      0,      0,    -67,      0, }, /* 579 */
  {    10,     24,     12,      0,      0,    -67,      0, }, /* 580 */
  {    27,      6,     12,      0,      0,     27,      0, }, /* 581 */
  {    10,     17,     12,      0,      0,    -67,      0, }, /* 582 */
  {    30,      7,     12,      0,      0,     30,      0, }, /* 583 */
  {    30,      6,     12,      0,      0,     30,      0, }, /* 584 */
  {     4,      7,     12,      0,      0,      4,      0, }, /* 585 */
  {    24,      7,     12,      0,      0,     24,      0, }, /* 586 */
  {    10,     15,     12,      0,      0,     23,      0, }, /* 587 */
  {    24,     26,     12,      0,      0,     24,      0, }, /* 588 */
  {    10,     26,     14,      0,      0,     23,      0, }, /* 589 */
  {    30,     26,     12,      0,      0,     30,      0, }, /* 590 */
  {    23,      7,     12,      0,      0,     23,      0, }, /* 591 */
  {    61,      7,     12,      0,      0,     61,      0, }, /* 592 */
  {    61,      6,     12,      0,      0,     61,      0, }, /* 593 */
  {    61,     26,     12,      0,      0,     61,      0, }, /* 594 */
  {    86,      7,     12,      0,      0,     86,      0, }, /* 595 */
  {    86,      6,     12,      0,      0,     86,      0, }, /* 596 */
  {    86,     21,     12,      0,      0,     86,      0, }, /* 597 */
  {    77,      7,     12,      0,      0,     77,      0, }, /* 598 */
  {    77,      6,     12,      0,      0,     77,      0, }, /* 599 */
  {    77,     21,     12,      0,      0,     77,      0, }, /* 600 */
  {    77,     13,     12,      0,      0,     77,      0, }, /* 601 */
  {    13,      9,     12,    108,      1,     13,      0, }, /* 602 */
  {    13,      5,     12,    108, -35267,     13,      0, }, /* 603 */
  {    13,      7,     12,      0,      0,     13,      0, }, /* 604 */
  {    13,     21,     12,      0,      0,     13,      0, }, /* 605 */
  {    79,      7,     12,      0,      0,     79,      0, }, /* 606 */
  {    79,     14,     12,      0,      0,     79,      0, }, /* 607 */
  {    79,     12,      3,      0,      0,     79,      0, }, /* 608 */
  {    79,     21,     12,      0,      0,     79,      0, }, /* 609 */
  {    10,     24,     12,      0,      0,    -64,      0, }, /* 610 */
  {    34,      9,     12,      0, -35332,     34,      0, }, /* 611 */
  {    34,      9,     12,      0, -42280,     34,      0, }, /* 612 */
  {    34,      5,     12,      0,     48,     34,      0, }, /* 613 */
  {    34,      9,     12,      0, -42308,     34,      0, }, /* 614 */
  {    34,      9,     12,      0, -42319,     34,      0, }, /* 615 */
  {    34,      9,     12,      0, -42315,     34,      0, }, /* 616 */
  {    34,      9,     12,      0, -42305,     34,      0, }, /* 617 */
  {    34,      9,     12,      0, -42258,     34,      0, }, /* 618 */
  {    34,      9,     12,      0, -42282,     34,      0, }, /* 619 */
  {    34,      9,     12,      0, -42261,     34,      0, }, /* 620 */
  {    34,      9,     12,      0,    928,     34,      0, }, /* 621 */
  {    34,      9,     12,      0,    -48,     34,      0, }, /* 622 */
  {    34,      9,     12,      0, -42307,     34,      0, }, /* 623 */
  {    34,      9,     12,      0, -35384,     34,      0, }, /* 624 */
  {    49,      7,     12,      0,      0,     49,      0, }, /* 625 */
  {    49,     12,      3,      0,      0,     49,      0, }, /* 626 */
  {    49,     10,      5,      0,      0,     49,      0, }, /* 627 */
  {    49,     26,     12,      0,      0,     49,      0, }, /* 628 */
  {    10,     15,     12,      0,      0,   -244,      0, }, /* 629 */
  {    10,     15,     12,      0,      0,   -230,      0, }, /* 630 */
  {    10,     26,     12,      0,      0,   -191,      0, }, /* 631 */
  {    10,     23,     12,      0,      0,   -191,      0, }, /* 632 */
  {    65,      7,     12,      0,      0,     65,      0, }, /* 633 */
  {    65,     21,     12,      0,      0,     65,      0, }, /* 634 */
  {    75,     10,      5,      0,      0,     75,      0, }, /* 635 */
  {    75,      7,     12,      0,      0,     75,      0, }, /* 636 */
  {    75,     12,      3,      0,      0,     75,      0, }, /* 637 */
  {    75,     21,     12,      0,      0,     75,      0, }, /* 638 */
  {    75,     13,     12,      0,      0,     75,      0, }, /* 639 */
  {    15,     12,      3,      0,      0,    -16,      0, }, /* 640 */
  {    15,      7,     12,      0,      0,    -49,      0, }, /* 641 */
  {    69,     13,     12,      0,      0,     69,      0, }, /* 642 */
  {    69,      7,     12,      0,      0,     69,      0, }, /* 643 */
  {    69,     12,      3,      0,      0,     69,      0, }, /* 644 */
  {    10,     21,     12,      0,      0,   -118,      0, }, /* 645 */
  {    69,     21,     12,      0,      0,     69,      0, }, /* 646 */
  {    74,      7,     12,      0,      0,     74,      0, }, /* 647 */
  {    74,     12,      3,      0,      0,     74,      0, }, /* 648 */
  {    74,     10,      5,      0,      0,     74,      0, }, /* 649 */
  {    74,     21,     12,      0,      0,     74,      0, }, /* 650 */
  {    84,     12,      3,      0,      0,     84,      0, }, /* 651 */
  {    84,     10,      5,      0,      0,     84,      0, }, /* 652 */
  {    84,      7,     12,      0,      0,     84,      0, }, /* 653 */
  {    84,     21,     12,      0,      0,     84,      0, }, /* 654 */
  {    10,      6,     12,      0,      0,    -22,      0, }, /* 655 */
  {    84,     13,     12,      0,      0,     84,      0, }, /* 656 */
  {    39,      6,     12,      0,      0,     39,      0, }, /* 657 */
  {    68,      7,     12,      0,      0,     68,      0, }, /* 658 */
  {    68,     12,      3,      0,      0,     68,      0, }, /* 659 */
  {    68,     10,      5,      0,      0,     68,      0, }, /* 660 */
  {    68,     13,     12,      0,      0,     68,      0, }, /* 661 */
  {    68,     21,     12,      0,      0,     68,      0, }, /* 662 */
  {    92,      7,     12,      0,      0,     92,      0, }, /* 663 */
  {    92,     12,      3,      0,      0,     92,      0, }, /* 664 */
  {    92,      6,     12,      0,      0,     92,      0, }, /* 665 */
  {    92,     21,     12,      0,      0,     92,      0, }, /* 666 */
  {    87,      7,     12,      0,      0,     87,      0, }, /* 667 */
  {    87,     10,      5,      0,      0,     87,      0, }, /* 668 */
  {    87,     12,      3,      0,      0,     87,      0, }, /* 669 */
  {    87,     21,     12,      0,      0,     87,      0, }, /* 670 */
  {    87,      6,     12,      0,      0,     87,      0, }, /* 671 */
  {    34,      5,     12,      0,   -928,     34,      0, }, /* 672 */
  {     9,      5,     12,      0, -38864,      9,      0, }, /* 673 */
  {    87,     13,     12,      0,      0,     87,      0, }, /* 674 */
  {    24,      7,      9,      0,      0,     24,      0, }, /* 675 */
  {    24,      7,     10,      0,      0,     24,      0, }, /* 676 */
  {     0,      4,     12,      0,      0,      0,      0, }, /* 677 */
  {     0,      3,     12,      0,      0,      0,      0, }, /* 678 */
  {    26,     25,     12,      0,      0,     26,      0, }, /* 679 */
  {    10,     18,     12,      0,      0,     -7,      0, }, /* 680 */
  {    10,     22,     12,      0,      0,     -7,      0, }, /* 681 */
  {     1,      7,     12,      0,      0,    -13,      0, }, /* 682 */
  {     1,     26,     12,      0,      0,    -13,      0, }, /* 683 */
  {    10,      6,      3,      0,      0,    -67,      0, }, /* 684 */
  {    36,      7,     12,      0,      0,     36,      0, }, /* 685 */
  {    10,     21,     12,      0,      0,    -98,      0, }, /* 686 */
  {    10,     21,     12,      0,      0,    -25,      0, }, /* 687 */
  {    10,     15,     12,      0,      0,   -102,      0, }, /* 688 */
  {    10,     26,     12,      0,      0,    -25,      0, }, /* 689 */
  {    20,     14,     12,      0,      0,     20,      0, }, /* 690 */
  {    20,     15,     12,      0,      0,     20,      0, }, /* 691 */
  {    20,     26,     12,      0,      0,     20,      0, }, /* 692 */
  {    71,      7,     12,      0,      0,     71,      0, }, /* 693 */
  {    67,      7,     12,      0,      0,     67,      0, }, /* 694 */
  {    28,     12,      3,      0,      0,     -1,      0, }, /* 695 */
  {    10,     15,     12,      0,      0,     -1,      0, }, /* 696 */
  {    42,      7,     12,      0,      0,     42,      0, }, /* 697 */
  {    42,     15,     12,      0,      0,     42,      0, }, /* 698 */
  {    19,      7,     12,      0,      0,     19,      0, }, /* 699 */
  {    19,     14,     12,      0,      0,     19,      0, }, /* 700 */
  {   118,      7,     12,      0,      0,    118,      0, }, /* 701 */
  {   118,     12,      3,      0,      0,    118,      0, }, /* 702 */
  {    60,      7,     12,      0,      0,     60,      0, }, /* 703 */
  {    60,     21,     12,      0,      0,     60,      0, }, /* 704 */
  {    43,      7,     12,      0,      0,     43,      0, }, /* 705 */
  {    43,     21,     12,      0,      0,     43,      0, }, /* 706 */
  {    43,     14,     12,      0,      0,     43,      0, }, /* 707 */
  {    14,      9,     12,      0,     40,     14,      0, }, /* 708 */
  {    14,      5,     12,      0,    -40,     14,      0, }, /* 709 */
  {    47,      7,     12,      0,      0,     47,      0, }, /* 710 */
  {    45,      7,     12,      0,      0,     45,      0, }, /* 711 */
  {    45,     13,     12,      0,      0,     45,      0, }, /* 712 */
  {   136,      9,     12,      0,     40,    136,      0, }, /* 713 */
  {   136,      5,     12,      0,    -40,    136,      0, }, /* 714 */
  {   106,      7,     12,      0,      0,    106,      0, }, /* 715 */
  {   104,      7,     12,      0,      0,    104,      0, }, /* 716 */
  {   104,     21,     12,      0,      0,    104,      0, }, /* 717 */
  {   161,      9,     12,      0,     39,    161,      0, }, /* 718 */
  {   161,      5,     12,      0,    -39,    161,      0, }, /* 719 */
  {   110,      7,     12,      0,      0,    110,      0, }, /* 720 */
  {    12,      7,     12,      0,      0,     12,      0, }, /* 721 */
  {    81,      7,     12,      0,      0,     81,      0, }, /* 722 */
  {    81,     21,     12,      0,      0,     81,      0, }, /* 723 */
  {    81,     15,     12,      0,      0,     81,      0, }, /* 724 */
  {   120,      7,     12,      0,      0,    120,      0, }, /* 725 */
  {   120,     26,     12,      0,      0,    120,      0, }, /* 726 */
  {   120,     15,     12,      0,      0,    120,      0, }, /* 727 */
  {   116,      7,     12,      0,      0,    116,      0, }, /* 728 */
  {   116,     15,     12,      0,      0,    116,      0, }, /* 729 */
  {   128,      7,     12,      0,      0,    128,      0, }, /* 730 */
  {   128,     15,     12,      0,      0,    128,      0, }, /* 731 */
  {    66,      7,     12,      0,      0,     66,      0, }, /* 732 */
  {    66,     15,     12,      0,      0,     66,      0, }, /* 733 */
  {    66,     21,     12,      0,      0,     66,      0, }, /* 734 */
  {    72,      7,     12,      0,      0,     72,      0, }, /* 735 */
  {    72,     21,     12,      0,      0,     72,      0, }, /* 736 */
  {    98,      7,     12,      0,      0,     98,      0, }, /* 737 */
  {    97,      7,     12,      0,      0,     97,      0, }, /* 738 */
  {    97,     15,     12,      0,      0,     97,      0, }, /* 739 */
  {    31,      7,     12,      0,      0,     31,      0, }, /* 740 */
  {    31,     12,      3,      0,      0,     31,      0, }, /* 741 */
  {    31,     15,     12,      0,      0,     31,      0, }, /* 742 */
  {    31,     21,     12,      0,      0,     31,      0, }, /* 743 */
  {    88,      7,     12,      0,      0,     88,      0, }, /* 744 */
  {    88,     15,     12,      0,      0,     88,      0, }, /* 745 */
  {    88,     21,     12,      0,      0,     88,      0, }, /* 746 */
  {   117,      7,     12,      0,      0,    117,      0, }, /* 747 */
  {   117,     15,     12,      0,      0,    117,      0, }, /* 748 */
  {   112,      7,     12,      0,      0,    112,      0, }, /* 749 */
  {   112,     26,     12,      0,      0,    112,      0, }, /* 750 */
  {   112,     12,      3,      0,      0,    112,      0, }, /* 751 */
  {   112,     15,     12,      0,      0,    112,      0, }, /* 752 */
  {   112,     21,     12,      0,      0,    112,      0, }, /* 753 */
  {   112,     21,     12,      0,      0,    -76,      0, }, /* 754 */
  {    78,      7,     12,      0,      0,     78,      0, }, /* 755 */
  {    78,     21,     12,      0,      0,     78,      0, }, /* 756 */
  {    83,      7,     12,      0,      0,     83,      0, }, /* 757 */
  {    83,     15,     12,      0,      0,     83,      0, }, /* 758 */
  {    82,      7,     12,      0,      0,     82,      0, }, /* 759 */
  {    82,     15,     12,      0,      0,     82,      0, }, /* 760 */
  {   121,      7,     12,      0,      0,    121,      0, }, /* 761 */
  {   121,     21,     12,      0,      0,    121,      0, }, /* 762 */
  {   121,     15,     12,      0,      0,    121,      0, }, /* 763 */
  {    89,      7,     12,      0,      0,     89,      0, }, /* 764 */
  {   130,      9,     12,      0,     64,    130,      0, }, /* 765 */
  {   130,      5,     12,      0,    -64,    130,      0, }, /* 766 */
  {   130,     15,     12,      0,      0,    130,      0, }, /* 767 */
  {   144,      7,     12,      0,      0,    144,      0, }, /* 768 */
  {   144,     12,      3,      0,      0,    144,      0, }, /* 769 */
  {   144,     13,     12,      0,      0,    144,      0, }, /* 770 */
  {     1,     15,     12,      0,      0,      1,      0, }, /* 771 */
  {   156,      7,     12,      0,      0,    156,      0, }, /* 772 */
  {   156,     12,      3,      0,      0,    156,      0, }, /* 773 */
  {   156,     17,     12,      0,      0,    156,      0, }, /* 774 */
  {   147,      7,     12,      0,      0,    147,      0, }, /* 775 */
  {   147,     15,     12,      0,      0,    147,      0, }, /* 776 */
  {   148,      7,     12,      0,      0,    148,      0, }, /* 777 */
  {   148,     12,      3,      0,      0,    148,      0, }, /* 778 */
  {   148,     15,     12,      0,      0,    148,      0, }, /* 779 */
  {   148,     21,     12,      0,      0,    148,      0, }, /* 780 */
  {   158,      7,     12,      0,      0,    158,      0, }, /* 781 */
  {   158,     12,      3,      0,      0,    158,      0, }, /* 782 */
  {   158,     21,     12,      0,      0,    158,      0, }, /* 783 */
  {   153,      7,     12,      0,      0,    153,      0, }, /* 784 */
  {   153,     15,     12,      0,      0,    153,      0, }, /* 785 */
  {   149,      7,     12,      0,      0,    149,      0, }, /* 786 */
  {    94,     10,      5,      0,      0,     94,      0, }, /* 787 */
  {    94,     12,      3,      0,      0,     94,      0, }, /* 788 */
  {    94,      7,     12,      0,      0,     94,      0, }, /* 789 */
  {    94,     21,     12,      0,      0,     94,      0, }, /* 790 */
  {    94,     15,     12,      0,      0,     94,      0, }, /* 791 */
  {    94,     13,     12,      0,      0,     94,      0, }, /* 792 */
  {    85,     12,      3,      0,      0,     85,      0, }, /* 793 */
  {    85,     10,      5,      0,      0,     85,      0, }, /* 794 */
  {    85,      7,     12,      0,      0,     85,      0, }, /* 795 */
  {    85,     21,     12,      0,      0,     85,      0, }, /* 796 */
  {    85,      1,      4,      0,      0,     85,      0, }, /* 797 */
  {   101,      7,     12,      0,      0,    101,      0, }, /* 798 */
  {   101,     13,     12,      0,      0,    101,      0, }, /* 799 */
  {    96,     12,      3,      0,      0,     96,      0, }, /* 800 */
  {    96,      7,     12,      0,      0,     96,      0, }, /* 801 */
  {    96,     10,      5,      0,      0,     96,      0, }, /* 802 */
  {    96,     13,     12,      0,      0,     96,      0, }, /* 803 */
  {    96,     21,     12,      0,      0,     96,      0, }, /* 804 */
  {   111,      7,     12,      0,      0,    111,      0, }, /* 805 */
  {   111,     12,      3,      0,      0,    111,      0, }, /* 806 */
  {   111,     21,     12,      0,      0,    111,      0, }, /* 807 */
  {   100,     12,      3,      0,      0,    100,      0, }, /* 808 */
  {   100,     10,      5,      0,      0,    100,      0, }, /* 809 */
  {   100,      7,     12,      0,      0,    100,      0, }, /* 810 */
  {   100,      7,      4,      0,      0,    100,      0, }, /* 811 */
  {   100,     21,     12,      0,      0,    100,      0, }, /* 812 */
  {   100,     13,     12,      0,      0,    100,      0, }, /* 813 */
  {    48,     15,     12,      0,      0,     48,      0, }, /* 814 */
  {   108,      7,     12,      0,      0,    108,      0, }, /* 815 */
  {   108,     10,      5,      0,      0,    108,      0, }, /* 816 */
  {   108,     12,      3,      0,      0,    108,      0, }, /* 817 */
  {   108,     21,     12,      0,      0,    108,      0, }, /* 818 */
  {   129,      7,     12,      0,      0,    129,      0, }, /* 819 */
  {   129,     21,     12,      0,      0,    129,      0, }, /* 820 */
  {   109,      7,     12,      0,      0,    109,      0, }, /* 821 */
  {   109,     12,      3,      0,      0,    109,      0, }, /* 822 */
  {   109,     10,      5,      0,      0,    109,      0, }, /* 823 */
  {   109,     13,     12,      0,      0,    109,      0, }, /* 824 */
  {   107,     12,      3,      0,      0,    107,      0, }, /* 825 */
  {   107,     12,      3,      0,      0,    -55,      0, }, /* 826 */
  {   107,     10,      5,      0,      0,    107,      0, }, /* 827 */
  {   107,     10,      5,      0,      0,    -55,      0, }, /* 828 */
  {   107,      7,     12,      0,      0,    107,      0, }, /* 829 */
  {    28,     12,      3,      0,      0,    -55,      0, }, /* 830 */
  {   107,     10,      3,      0,      0,    107,      0, }, /* 831 */
  {   135,      7,     12,      0,      0,    135,      0, }, /* 832 */
  {   135,     10,      5,      0,      0,    135,      0, }, /* 833 */
  {   135,     12,      3,      0,      0,    135,      0, }, /* 834 */
  {   135,     21,     12,      0,      0,    135,      0, }, /* 835 */
  {   135,     13,     12,      0,      0,    135,      0, }, /* 836 */
  {   124,      7,     12,      0,      0,    124,      0, }, /* 837 */
  {   124,     10,      3,      0,      0,    124,      0, }, /* 838 */
  {   124,     10,      5,      0,      0,    124,      0, }, /* 839 */
  {   124,     12,      3,      0,      0,    124,      0, }, /* 840 */
  {   124,     21,     12,      0,      0,    124,      0, }, /* 841 */
  {   124,     13,     12,      0,      0,    124,      0, }, /* 842 */
  {   123,      7,     12,      0,      0,    123,      0, }, /* 843 */
  {   123,     10,      3,      0,      0,    123,      0, }, /* 844 */
  {   123,     10,      5,      0,      0,    123,      0, }, /* 845 */
  {   123,     12,      3,      0,      0,    123,      0, }, /* 846 */
  {   123,     21,     12,      0,      0,    123,      0, }, /* 847 */
  {   114,      7,     12,      0,      0,    114,      0, }, /* 848 */
  {   114,     10,      5,      0,      0,    114,      0, }, /* 849 */
  {   114,     12,      3,      0,      0,    114,      0, }, /* 850 */
  {   114,     21,     12,      0,      0,    114,      0, }, /* 851 */
  {   114,     13,     12,      0,      0,    114,      0, }, /* 852 */
  {   102,      7,     12,      0,      0,    102,      0, }, /* 853 */
  {   102,     12,      3,      0,      0,    102,      0, }, /* 854 */
  {   102,     10,      5,      0,      0,    102,      0, }, /* 855 */
  {   102,     21,     12,      0,      0,    102,      0, }, /* 856 */
  {   102,     13,     12,      0,      0,    102,      0, }, /* 857 */
  {   126,      7,     12,      0,      0,    126,      0, }, /* 858 */
  {   126,     12,      3,      0,      0,    126,      0, }, /* 859 */
  {   126,     10,     12,      0,      0,    126,      0, }, /* 860 */
  {   126,     10,      5,      0,      0,    126,      0, }, /* 861 */
  {   126,     13,     12,      0,      0,    126,      0, }, /* 862 */
  {   126,     15,     12,      0,      0,    126,      0, }, /* 863 */
  {   126,     21,     12,      0,      0,    126,      0, }, /* 864 */
  {   126,     26,     12,      0,      0,    126,      0, }, /* 865 */
  {   142,      7,     12,      0,      0,    142,      0, }, /* 866 */
  {   142,     10,      5,      0,      0,    142,      0, }, /* 867 */
  {   142,     12,      3,      0,      0,    142,      0, }, /* 868 */
  {   142,     21,     12,      0,      0,    142,      0, }, /* 869 */
  {   125,      9,     12,      0,     32,    125,      0, }, /* 870 */
  {   125,      5,     12,      0,    -32,    125,      0, }, /* 871 */
  {   125,     13,     12,      0,      0,    125,      0, }, /* 872 */
  {   125,     15,     12,      0,      0,    125,      0, }, /* 873 */
  {   125,      7,     12,      0,      0,    125,      0, }, /* 874 */
  {   154,      7,     12,      0,      0,    154,      0, }, /* 875 */
  {   154,     10,      3,      0,      0,    154,      0, }, /* 876 */
  {   154,     10,      5,      0,      0,    154,      0, }, /* 877 */
  {   154,     12,      3,      0,      0,    154,      0, }, /* 878 */
  {   154,      7,      4,      0,      0,    154,      0, }, /* 879 */
  {   154,     21,     12,      0,      0,    154,      0, }, /* 880 */
  {   154,     13,     12,      0,      0,    154,      0, }, /* 881 */
  {   150,      7,     12,      0,      0,    150,      0, }, /* 882 */
  {   150,     10,      5,      0,      0,    150,      0, }, /* 883 */
  {   150,     12,      3,      0,      0,    150,      0, }, /* 884 */
  {   150,     21,     12,      0,      0,    150,      0, }, /* 885 */
  {   141,      7,     12,      0,      0,    141,      0, }, /* 886 */
  {   141,     12,      3,      0,      0,    141,      0, }, /* 887 */
  {   141,     10,      5,      0,      0,    141,      0, }, /* 888 */
  {   141,      7,      4,      0,      0,    141,      0, }, /* 889 */
  {   141,     21,     12,      0,      0,    141,      0, }, /* 890 */
  {   140,      7,     12,      0,      0,    140,      0, }, /* 891 */
  {   140,     12,      3,      0,      0,    140,      0, }, /* 892 */
  {   140,     10,      5,      0,      0,    140,      0, }, /* 893 */
  {   140,      7,      4,      0,      0,    140,      0, }, /* 894 */
  {   140,     21,     12,      0,      0,    140,      0, }, /* 895 */
  {   122,      7,     12,      0,      0,    122,      0, }, /* 896 */
  {   133,      7,     12,      0,      0,    133,      0, }, /* 897 */
  {   133,     10,      5,      0,      0,    133,      0, }, /* 898 */
  {   133,     12,      3,      0,      0,    133,      0, }, /* 899 */
  {   133,     21,     12,      0,      0,    133,      0, }, /* 900 */
  {   133,     13,     12,      0,      0,    133,      0, }, /* 901 */
  {   133,     15,     12,      0,      0,    133,      0, }, /* 902 */
  {   134,     21,     12,      0,      0,    134,      0, }, /* 903 */
  {   134,      7,     12,      0,      0,    134,      0, }, /* 904 */
  {   134,     12,      3,      0,      0,    134,      0, }, /* 905 */
  {   134,     10,      5,      0,      0,    134,      0, }, /* 906 */
  {   138,      7,     12,      0,      0,    138,      0, }, /* 907 */
  {   138,     12,      3,      0,      0,    138,      0, }, /* 908 */
  {   138,      7,      4,      0,      0,    138,      0, }, /* 909 */
  {   138,     13,     12,      0,      0,    138,      0, }, /* 910 */
  {   143,      7,     12,      0,      0,    143,      0, }, /* 911 */
  {   143,     10,      5,      0,      0,    143,      0, }, /* 912 */
  {   143,     12,      3,      0,      0,    143,      0, }, /* 913 */
  {   143,     13,     12,      0,      0,    143,      0, }, /* 914 */
  {   145,      7,     12,      0,      0,    145,      0, }, /* 915 */
  {   145,     12,      3,      0,      0,    145,      0, }, /* 916 */
  {   145,     10,      5,      0,      0,    145,      0, }, /* 917 */
  {   145,     21,     12,      0,      0,    145,      0, }, /* 918 */
  {    54,     15,     12,      0,      0,     54,      0, }, /* 919 */
  {    54,     21,     12,      0,      0,     54,      0, }, /* 920 */
  {    63,      7,     12,      0,      0,     63,      0, }, /* 921 */
  {    63,     14,     12,      0,      0,     63,      0, }, /* 922 */
  {    63,     21,     12,      0,      0,     63,      0, }, /* 923 */
  {   157,      7,     12,      0,      0,    157,      0, }, /* 924 */
  {   157,     21,     12,      0,      0,    157,      0, }, /* 925 */
  {    80,      7,     12,      0,      0,     80,      0, }, /* 926 */
  {    80,      1,      2,      0,      0,     80,      0, }, /* 927 */
  {   127,      7,     12,      0,      0,    127,      0, }, /* 928 */
  {   115,      7,     12,      0,      0,    115,      0, }, /* 929 */
  {   115,     13,     12,      0,      0,    115,      0, }, /* 930 */
  {   115,     21,     12,      0,      0,    115,      0, }, /* 931 */
  {   159,      7,     12,      0,      0,    159,      0, }, /* 932 */
  {   159,     13,     12,      0,      0,    159,      0, }, /* 933 */
  {   103,      7,     12,      0,      0,    103,      0, }, /* 934 */
  {   103,     12,      3,      0,      0,    103,      0, }, /* 935 */
  {   103,     21,     12,      0,      0,    103,      0, }, /* 936 */
  {   119,      7,     12,      0,      0,    119,      0, }, /* 937 */
  {   119,     12,      3,      0,      0,    119,      0, }, /* 938 */
  {   119,     21,     12,      0,      0,    119,      0, }, /* 939 */
  {   119,     26,     12,      0,      0,    119,      0, }, /* 940 */
  {   119,      6,     12,      0,      0,    119,      0, }, /* 941 */
  {   119,     13,     12,      0,      0,    119,      0, }, /* 942 */
  {   119,     15,     12,      0,      0,    119,      0, }, /* 943 */
  {   146,      9,     12,      0,     32,    146,      0, }, /* 944 */
  {   146,      5,     12,      0,    -32,    146,      0, }, /* 945 */
  {   146,     15,     12,      0,      0,    146,      0, }, /* 946 */
  {   146,     21,     12,      0,      0,    146,      0, }, /* 947 */
  {    99,      7,     12,      0,      0,     99,      0, }, /* 948 */
  {    99,     12,      3,      0,      0,     99,      0, }, /* 949 */
  {    99,     10,      5,      0,      0,     99,      0, }, /* 950 */
  {    99,      6,     12,      0,      0,     99,      0, }, /* 951 */
  {   137,      6,     12,      0,      0,    137,      0, }, /* 952 */
  {   139,      6,     12,      0,      0,    139,      0, }, /* 953 */
  {    23,     21,     12,      0,      0,     23,      0, }, /* 954 */
  {   155,     12,      3,      0,      0,    155,      0, }, /* 955 */
  {    23,     10,      5,      0,      0,     23,      0, }, /* 956 */
  {   137,      7,     12,      0,      0,    137,      0, }, /* 957 */
  {   155,      7,     12,      0,      0,    155,      0, }, /* 958 */
  {   139,      7,     12,      0,      0,    139,      0, }, /* 959 */
  {   105,      7,     12,      0,      0,    105,      0, }, /* 960 */
  {   105,     26,     12,      0,      0,    105,      0, }, /* 961 */
  {   105,     12,      3,      0,      0,    105,      0, }, /* 962 */
  {   105,     21,     12,      0,      0,    105,      0, }, /* 963 */
  {    10,      1,      2,      0,      0,    105,      0, }, /* 964 */
  {    10,     10,      3,      0,      0,     10,      0, }, /* 965 */
  {    10,     10,      5,      0,      0,     10,      0, }, /* 966 */
  {    20,     12,      3,      0,      0,     20,      0, }, /* 967 */
  {   131,     26,     12,      0,      0,    131,      0, }, /* 968 */
  {   131,     12,      3,      0,      0,    131,      0, }, /* 969 */
  {   131,     21,     12,      0,      0,    131,      0, }, /* 970 */
  {    18,     12,      3,      0,      0,     18,      0, }, /* 971 */
  {   151,      7,     12,      0,      0,    151,      0, }, /* 972 */
  {   151,     12,      3,      0,      0,    151,      0, }, /* 973 */
  {   151,      6,     12,      0,      0,    151,      0, }, /* 974 */
  {   151,     13,     12,      0,      0,    151,      0, }, /* 975 */
  {   151,     26,     12,      0,      0,    151,      0, }, /* 976 */
  {   160,      7,     12,      0,      0,    160,      0, }, /* 977 */
  {   160,     12,      3,      0,      0,    160,      0, }, /* 978 */
  {   152,      7,     12,      0,      0,    152,      0, }, /* 979 */
  {   152,     12,      3,      0,      0,    152,      0, }, /* 980 */
  {   152,     13,     12,      0,      0,    152,      0, }, /* 981 */
  {   152,     23,     12,      0,      0,    152,      0, }, /* 982 */
  {   113,      7,     12,      0,      0,    113,      0, }, /* 983 */
  {   113,     15,     12,      0,      0,    113,      0, }, /* 984 */
  {   113,     12,      3,      0,      0,    113,      0, }, /* 985 */
  {   132,      9,     12,      0,     34,    132,      0, }, /* 986 */
  {   132,      5,     12,      0,    -34,    132,      0, }, /* 987 */
  {   132,     12,      3,      0,      0,    132,      0, }, /* 988 */
  {   132,      6,     12,      0,      0,    132,      0, }, /* 989 */
  {   132,     13,     12,      0,      0,    132,      0, }, /* 990 */
  {   132,     21,     12,      0,      0,    132,      0, }, /* 991 */
  {     0,      2,     14,      0,      0,      0,      0, }, /* 992 */
  {    10,     26,     11,      0,      0,     10,      0, }, /* 993 */
  {    27,     26,     12,      0,      0,     27,      0, }, /* 994 */
  {    10,     24,      3,      0,      0,     10,      0, }, /* 995 */
  {    10,      1,      3,      0,      0,     10,      0, }, /* 996 */
};

const uint16_t PRIV(ucd_stage1)[] = { /* 17408 bytes */
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, /* U+0000 */
 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, /* U+0800 */
 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 41, 41, 42, 43, 44, 45, /* U+1000 */
 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, /* U+1800 */
 62, 63, 64, 65, 66, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, /* U+2000 */
 77, 77, 78, 79, 66, 66, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, /* U+2800 */
 90, 91, 92, 93, 94, 95, 96, 97, 98, 98, 98, 98, 98, 98, 98, 98, /* U+3000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+3800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+4000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 98, 98, 98, 98, /* U+4800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+5000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+5800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+6000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+6800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+7000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+7800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+8000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+8800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+9000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+9800 */
100,101,101,101,101,101,101,101,101,102,103,103,104,105,106,107, /* U+A000 */
108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,116, /* U+A800 */
117,118,119,120,121,122,116,117,118,119,120,121,122,116,117,118, /* U+B000 */
119,120,121,122,116,117,118,119,120,121,122,116,117,118,119,120, /* U+B800 */
121,122,116,117,118,119,120,121,122,116,117,118,119,120,121,122, /* U+C000 */
116,117,118,119,120,121,122,116,117,118,119,120,121,122,116,117, /* U+C800 */
118,119,120,121,122,116,117,118,119,120,121,122,116,117,118,123, /* U+D000 */
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124, /* U+D800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+E000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+E800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F000 */
125,125, 98, 98,126,127,128,129,130,130,131,132,133,134,135,136, /* U+F800 */
137,138,139,140,141,142,143,144,145,146,147,148,149,149,150,151, /* U+10000 */
152,153,154,155,156,157,158,159,160,161,162,141,163,164,165,166, /* U+10800 */
167,168,169,170,171,172,173,141,174,175,141,176,177,178,179,141, /* U+11000 */
180,181,182,183,184,185,141,141,186,187,188,189,141,190,141,191, /* U+11800 */
192,192,192,192,192,192,192,193,194,192,195,141,141,141,141,141, /* U+12000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,196, /* U+12800 */
197,197,197,197,197,197,197,197,198,141,141,141,141,141,141,141, /* U+13000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+13800 */
141,141,141,141,141,141,141,141,199,199,199,199,200,141,141,141, /* U+14000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+14800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+15000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+15800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+16000 */
201,201,201,201,202,203,204,205,141,141,141,141,206,207,208,209, /* U+16800 */
210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210, /* U+17000 */
210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210, /* U+17800 */
210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,211, /* U+18000 */
210,210,210,210,210,210,212,212,212,213,214,141,141,141,141,141, /* U+18800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+19000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+19800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+1A000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,215, /* U+1A800 */
216,217,218,219,219,220,141,141,141,141,141,141,141,141,141,141, /* U+1B000 */
141,141,141,141,141,141,141,141,221,222,141,141,141,141,141,141, /* U+1B800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+1C000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,223,224, /* U+1C800 */
 71,225,226,227,228,229,230,141,231,232,233,234,235,236,237,238, /* U+1D000 */
239,239,239,239,240,241,141,141,141,141,141,141,141,141,242,141, /* U+1D800 */
243,141,244,141,141,245,141,141,141,141,141,141,141,141,141,246, /* U+1E000 */
247,248,249,141,141,141,141,141,250,251,252,141,253,254,141,141, /* U+1E800 */
255,256,257,258,259,260,261,262,261,261,263,261,264,265,266,267, /* U+1F000 */
268,269,270,261,271,272, 71,273,260,260,260,260,260,260,260,274, /* U+1F800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+20000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+20800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+21000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+21800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+22000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+22800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+23000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+23800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+24000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+24800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+25000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+25800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+26000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+26800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+27000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+27800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+28000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+28800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+29000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+29800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,275, 98, 98, /* U+2A000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2A800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,276, 98, /* U+2B000 */
277, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2B800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2C000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,278, 98, 98, /* U+2C800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2D000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2D800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+2E000 */
 98, 98, 98, 98, 98, 98, 98,279,141,141,141,141,141,141,141,141, /* U+2E800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+2F000 */
 98, 98, 98, 98,280,141,141,141,141,141,141,141,141,141,141,141, /* U+2F800 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+30000 */
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, /* U+30800 */
 98, 98, 98, 98, 98, 98,281,141,141,141,141,141,141,141,141,141, /* U+31000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+31800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+32000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+32800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+33000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+33800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+34000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+34800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+35000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+35800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+36000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+36800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+37000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+37800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+38000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+38800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+39000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+39800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3A000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3A800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3B000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3B800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3C000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3C800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3D000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3D800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3E000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3E800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3F000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+3F800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+40000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+40800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+41000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+41800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+42000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+42800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+43000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+43800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+44000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+44800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+45000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+45800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+46000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+46800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+47000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+47800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+48000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+48800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+49000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+49800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4A000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4A800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4B000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4B800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4C000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4C800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4D000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4D800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4E000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4E800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4F000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+4F800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+50000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+50800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+51000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+51800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+52000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+52800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+53000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+53800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+54000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+54800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+55000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+55800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+56000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+56800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+57000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+57800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+58000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+58800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+59000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+59800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5A000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5A800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5B000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5B800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5C000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5C800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5D000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5D800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5E000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5E800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5F000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+5F800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+60000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+60800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+61000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+61800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+62000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+62800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+63000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+63800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+64000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+64800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+65000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+65800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+66000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+66800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+67000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+67800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+68000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+68800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+69000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+69800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6A000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6A800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6B000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6B800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6C000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6C800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6D000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6D800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6E000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6E800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6F000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+6F800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+70000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+70800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+71000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+71800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+72000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+72800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+73000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+73800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+74000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+74800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+75000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+75800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+76000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+76800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+77000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+77800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+78000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+78800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+79000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+79800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7A000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7A800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7B000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7B800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7C000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7C800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7D000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7D800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7E000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7E800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7F000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+7F800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+80000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+80800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+81000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+81800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+82000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+82800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+83000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+83800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+84000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+84800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+85000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+85800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+86000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+86800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+87000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+87800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+88000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+88800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+89000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+89800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8A000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8A800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8B000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8B800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8C000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8C800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8D000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8D800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8E000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8E800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8F000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+8F800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+90000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+90800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+91000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+91800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+92000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+92800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+93000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+93800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+94000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+94800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+95000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+95800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+96000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+96800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+97000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+97800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+98000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+98800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+99000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+99800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9A000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9A800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9B000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9B800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9C000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9C800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9D000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9D800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9E000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9E800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9F000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+9F800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A0000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A0800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A1000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A1800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A2000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A2800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A3000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A3800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A4000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A4800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A5000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A5800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A6000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A6800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A7000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A7800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A8000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A8800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A9000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+A9800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AA000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AA800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AB000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AB800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AC000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AC800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AD000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AD800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AE000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AE800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AF000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+AF800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B0000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B0800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B1000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B1800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B2000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B2800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B3000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B3800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B4000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B4800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B5000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B5800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B6000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B6800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B7000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B7800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B8000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B8800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B9000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+B9800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BA000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BA800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BB000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BB800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BC000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BC800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BD000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BD800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BE000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BE800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BF000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+BF800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C0000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C0800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C1000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C1800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C2000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C2800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C3000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C3800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C4000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C4800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C5000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C5800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C6000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C6800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C7000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C7800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C8000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C8800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C9000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+C9800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CA000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CA800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CB000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CB800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CC000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CC800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CD000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CD800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CE000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CE800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CF000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+CF800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D0000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D0800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D1000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D1800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D2000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D2800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D3000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D3800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D4000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D4800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D5000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D5800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D6000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D6800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D7000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D7800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D8000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D8800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D9000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+D9800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DA000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DA800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DB000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DB800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DC000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DC800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DD000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DD800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DE000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DE800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DF000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+DF800 */
282,283,284,285,283,283,283,283,283,283,283,283,283,283,283,283, /* U+E0000 */
283,283,283,283,283,283,283,283,283,283,283,283,283,283,283,283, /* U+E0800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E1000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E1800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E2000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E2800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E3000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E3800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E4000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E4800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E5000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E5800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E6000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E6800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E7000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E7800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E8000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E8800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E9000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+E9800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+EA000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+EA800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+EB000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+EB800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+EC000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+EC800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+ED000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+ED800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+EE000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+EE800 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+EF000 */
141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141, /* U+EF800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F0000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F0800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F1000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F1800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F2000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F2800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F3000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F3800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F4000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F4800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F5000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F5800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F6000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F6800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F7000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F7800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F8000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F8800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F9000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+F9800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+FA000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+FA800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+FB000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+FB800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+FC000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+FC800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+FD000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+FD800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+FE000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+FE800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+FF000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,286, /* U+FF800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+100000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+100800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+101000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+101800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+102000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+102800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+103000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+103800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+104000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+104800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+105000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+105800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+106000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+106800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+107000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+107800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+108000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+108800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+109000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+109800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+10A000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+10A800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+10B000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+10B800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+10C000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+10C800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+10D000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+10D800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+10E000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+10E800 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125, /* U+10F000 */
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,286, /* U+10F800 */
};

const uint16_t PRIV(ucd_stage2)[] = { /* 73472 bytes, block = 128 */
/* block 0 */
  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  1,  1,  3,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  4,  5,  5,  5,  6,  5,  5,  5,  7,  8,  5,  9,  5, 10,  5,  5,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  5,  5,  9,  9,  9,  5,
  5, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 12, 12, 12, 12,
 12, 12, 12, 14, 12, 12, 12, 12, 12, 12, 12,  7,  5,  8, 15, 16,
 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 17, 17, 17, 17,
 17, 17, 17, 19, 17, 17, 17, 17, 17, 17, 17,  7,  9,  8,  9,  1,

/* block 1 */
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  4,  5,  6,  6,  6,  6, 20,  5, 15, 21, 22, 23,  9, 24, 21, 15,
 20,  9, 25, 25, 15, 26,  5,  5, 15, 25, 22, 27, 25, 25, 25,  5,
 12, 12, 12, 12, 12, 28, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12,  9, 12, 12, 12, 12, 12, 12, 12, 29,
 17, 17, 17, 17, 17, 30, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17,  9, 17, 17, 17, 17, 17, 17, 17, 31,

/* block 2 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 34, 35, 32, 33, 32, 33, 32, 33, 35, 32, 33, 32, 33, 32, 33, 32,
 33, 32, 33, 32, 33, 32, 33, 32, 33, 35, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 36, 32, 33, 32, 33, 32, 33, 37,

/* block 3 */
 38, 39, 32, 33, 32, 33, 40, 32, 33, 41, 41, 32, 33, 35, 42, 43,
 44, 32, 33, 41, 45, 46, 47, 48, 32, 33, 49, 35, 47, 50, 51, 52,
 32, 33, 32, 33, 32, 33, 53, 32, 33, 53, 35, 35, 32, 33, 53, 32,
 33, 54, 54, 32, 33, 32, 33, 55, 32, 33, 35, 22, 32, 33, 35, 56,
 22, 22, 22, 22, 57, 58, 59, 60, 61, 62, 63, 64, 65, 32, 33, 32,
 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 66, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 35, 67, 68, 69, 32, 33, 70, 71, 32, 33, 32, 33, 32, 33, 32, 33,

/* block 4 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 72, 35, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 35, 35, 35, 35, 35, 35, 73, 32, 33, 74, 75, 76,
 76, 32, 33, 77, 78, 79, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 80, 81, 82, 83, 84, 35, 85, 85, 35, 86, 35, 87, 88, 35, 35, 35,
 85, 89, 35, 90, 35, 91, 92, 35, 93, 94, 92, 95, 96, 35, 35, 94,
 35, 97, 98, 35, 35, 99, 35, 35, 35, 35, 35, 35, 35,100, 35, 35,

/* block 5 */
101, 35,102,101, 35, 35, 35,103,101,104,105,105,106, 35, 35, 35,
 35, 35,107, 35, 22, 35, 35, 35, 35, 35, 35, 35, 35,108,109, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
110,110,110,110,110,110,110,110,110,111,111,111,111,111,111,111,
111,111, 15, 15, 15, 15,111,111,111,111,111,111,111,111,111,111,
111,111, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
110,110,110,110,110, 15, 15, 15, 15, 15,112,112,111, 15,111, 15,
 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,

/* block 6 */
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,114,113,113,115,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,116,116,116,116,116,116,116,116,116,116,116,116,116,
117,118,117,118,111,119,117,118,120,120,121,122,122,122,  5,123,

/* block 7 */
120,120,120,120,119, 15,124,  5,125,125,125,120,126,120,127,127,
128,129,130,129,129,131,129,129,132,133,134,129,135,129,129,129,
136,137,120,138,129,129,139,129,129,140,129,129,141,142,142,142,
128,143,144,143,143,145,143,143,146,147,148,143,149,143,143,143,
150,151,152,153,143,143,154,143,143,155,143,143,156,157,157,158,
159,160,161,161,161,162,163,164,117,118,117,118,117,118,117,118,
117,118,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
167,168,169,170,171,172,173,117,118,174,117,118,128,175,175,175,

/* block 8 */
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
177,177,178,177,179,177,177,177,177,177,177,177,177,177,180,177,
177,181,182,177,177,177,177,177,177,177,183,177,177,177,177,177,
184,184,185,184,186,184,184,184,184,184,184,184,184,184,187,184,
184,188,189,184,184,184,184,184,184,184,190,184,184,184,184,184,
191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,
192,193,194,195,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,

/* block 9 */
192,193,196,197,198,199,199,198,200,200,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
201,192,193,192,193,192,193,192,193,192,193,192,193,192,193,202,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,

/* block 10 */
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
120,203,203,203,203,203,203,203,203,203,203,203,203,203,203,203,
203,203,203,203,203,203,203,203,203,203,203,203,203,203,203,203,
203,203,203,203,203,203,203,120,120,204,205,205,205,205,205,205,
206,207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,
207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,

/* block 11 */
207,207,207,207,207,207,207,206,206,205,208,120,120,209,209,210,
120,211,211,211,211,211,211,211,211,211,211,211,211,211,211,211,
211,211,211,211,211,211,211,211,211,211,211,211,211,211,211,211,
211,211,211,211,211,211,211,211,211,211,211,211,211,211,212,211,
213,211,211,213,211,211,213,211,120,120,120,120,120,120,120,120,
214,214,214,214,214,214,214,214,214,214,214,214,214,214,214,214,
214,214,214,214,214,214,214,214,214,214,214,120,120,120,120,214,
214,214,214,213,213,120,120,120,120,120,120,120,120,120,120,120,

/* block 12 */
215,215,215,215,215,216,217,217,217,218,218,219,220,218,221,221,
222,222,222,222,222,222,222,222,222,222,222,220,223,218,218,224,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
226,225,225,225,225,225,225,225,225,225,225,227,227,227,227,227,
227,227,227,227,227,227,222,222,222,222,222,222,222,222,222,222,
228,228,228,228,228,228,228,228,228,228,218,218,218,218,225,225,
227,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 13 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,229,225,222,222,222,222,222,222,222,216,221,222,
222,222,222,222,222,230,230,222,222,221,222,222,222,222,225,225,
231,231,231,231,231,231,231,231,231,231,225,225,225,221,221,225,

/* block 14 */
232,232,232,232,232,232,232,232,232,232,232,232,232,232,120,233,
234,235,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,234,
235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,
235,235,235,235,235,235,235,235,235,235,235,120,120,234,234,234,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 15 */
236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,
236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,236,
236,236,236,236,236,236,237,237,237,237,237,237,237,237,237,237,
237,236,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
238,238,238,238,238,238,238,238,238,238,239,239,239,239,239,239,
239,239,239,239,239,239,239,239,239,239,239,239,239,239,239,239,
239,239,239,239,239,239,239,239,239,239,239,240,240,240,240,240,
240,240,240,240,241,241,242,243,243,243,241,120,120,240,244,244,

/* block 16 */
245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,245,
245,245,245,245,245,245,246,246,246,246,247,246,246,246,246,246,
246,246,246,246,247,246,246,246,247,246,246,246,246,246,120,120,
248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,120,
249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,249,
249,249,249,249,249,249,249,249,249,250,250,250,120,120,251,120,
234,234,234,234,234,234,234,234,234,234,234,120,120,120,120,120,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 17 */
225,225,225,225,225,225,225,225,252,225,225,225,225,225,225,120,
215,215,120,120,120,120,120,120,222,222,222,222,222,222,222,222,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,230,222,222,222,222,222,222,
222,222,222,222,222,222,222,222,222,222,222,222,222,222,222,222,
222,222,216,222,222,222,222,222,222,222,222,222,222,222,222,222,
222,222,222,222,222,222,222,222,222,222,222,222,222,222,222,222,

/* block 18 */
253,253,253,254,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,253,254,253,255,254,254,
254,253,253,253,253,253,253,253,253,254,254,254,254,253,254,254,
255,256,257,113,113,253,253,253,255,255,255,255,255,255,255,255,
255,255,253,253,258,259,260,260,260,260,260,260,260,260,260,260,
261,262,255,255,255,255,255,255,255,255,255,255,255,255,255,255,

/* block 19 */
263,264,265,265,120,263,263,263,263,263,263,263,263,120,120,263,
263,120,120,263,263,263,263,263,263,263,263,263,263,263,263,263,
263,263,263,263,263,263,263,263,263,120,263,263,263,263,263,263,
263,120,263,120,120,120,263,263,263,263,120,120,264,263,266,265,
265,264,264,264,264,120,120,265,265,120,120,265,265,264,263,120,
120,120,120,120,120,120,120,266,120,120,120,120,263,263,120,263,
263,263,264,264,120,120,267,267,267,267,267,267,267,267,267,267,
263,263,268,268,269,269,269,269,269,269,270,268,263,271,264,120,

/* block 20 */
120,272,272,273,120,274,274,274,274,274,274,120,120,120,120,274,
274,120,120,274,274,274,274,274,274,274,274,274,274,274,274,274,
274,274,274,274,274,274,274,274,274,120,274,274,274,274,274,274,
274,120,274,274,120,274,274,120,274,274,120,120,272,120,273,273,
273,272,272,120,120,120,120,272,272,120,120,272,272,272,120,120,
120,272,120,120,120,120,120,120,120,274,274,274,274,120,274,120,
120,120,120,120,120,120,275,275,275,275,275,275,275,275,275,275,
272,272,274,274,274,272,276,120,120,120,120,120,120,120,120,120,

/* block 21 */
120,277,277,278,120,279,279,279,279,279,279,279,279,279,120,279,
279,279,120,279,279,279,279,279,279,279,279,279,279,279,279,279,
279,279,279,279,279,279,279,279,279,120,279,279,279,279,279,279,
279,120,279,279,120,279,279,279,279,279,120,120,277,279,278,278,
278,277,277,277,277,277,120,277,277,278,120,278,278,277,120,120,
279,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
279,279,277,277,120,120,280,280,280,280,280,280,280,280,280,280,
281,282,120,120,120,120,120,120,120,279,277,277,277,277,277,277,

/* block 22 */
120,283,284,284,120,285,285,285,285,285,285,285,285,120,120,285,
285,120,120,285,285,285,285,285,285,285,285,285,285,285,285,285,
285,285,285,285,285,285,285,285,285,120,285,285,285,285,285,285,
285,120,285,285,120,285,285,285,285,285,120,120,283,285,286,283,
284,283,283,283,283,120,120,284,284,120,120,284,284,283,120,120,
120,120,120,120,120,283,283,286,120,120,120,120,285,285,120,285,
285,285,283,283,120,120,287,287,287,287,287,287,287,287,287,287,
288,285,289,289,289,289,289,289,120,120,120,120,120,120,120,120,

/* block 23 */
120,120,290,291,120,291,291,291,291,291,291,120,120,120,291,291,
291,120,291,291,291,291,120,120,120,291,291,120,291,120,291,291,
120,120,120,291,291,120,120,120,291,291,291,120,120,120,291,291,
291,291,291,291,291,291,291,291,291,291,120,120,120,120,292,293,
290,293,293,120,120,120,293,293,293,120,293,293,293,290,120,120,
291,120,120,120,120,120,120,292,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,294,294,294,294,294,294,294,294,294,294,
295,295,295,296,297,297,297,297,297,298,297,120,120,120,120,120,

/* block 24 */
299,300,300,300,299,301,301,301,301,301,301,301,301,120,301,301,
301,120,301,301,301,301,301,301,301,301,301,301,301,301,301,301,
301,301,301,301,301,301,301,301,301,120,301,301,301,301,301,301,
301,301,301,301,301,301,301,301,301,301,120,120,299,301,299,299,
299,300,300,300,300,120,299,299,299,120,299,299,299,299,120,120,
120,120,120,120,120,299,299,120,301,301,301,120,120,301,120,120,
301,301,299,299,120,120,302,302,302,302,302,302,302,302,302,302,
120,120,120,120,120,120,120,303,304,304,304,304,304,304,304,305,

/* block 25 */
306,307,308,308,309,306,306,306,306,306,306,306,306,120,306,306,
306,120,306,306,306,306,306,306,306,306,306,306,306,306,306,306,
306,306,306,306,306,306,306,306,306,120,306,306,306,306,306,306,
306,306,306,306,120,306,306,306,306,306,120,120,307,306,308,307,
308,308,310,308,308,120,307,308,308,120,308,308,307,307,120,120,
120,120,120,120,120,310,310,120,120,120,120,120,120,306,306,120,
306,306,307,307,120,120,311,311,311,311,311,311,311,311,311,311,
120,306,306,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 26 */
312,312,313,313,314,314,314,314,314,314,314,314,314,120,314,314,
314,120,314,314,314,314,314,314,314,314,314,314,314,314,314,314,
314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,314,
314,314,314,314,314,314,314,314,314,314,314,312,312,314,315,313,
313,312,312,312,312,120,313,313,313,120,313,313,313,312,316,317,
120,120,120,120,314,314,314,315,318,318,318,318,318,318,318,314,
314,314,312,312,120,120,319,319,319,319,319,319,319,319,319,319,
318,318,318,318,318,318,318,318,318,317,314,314,314,314,314,314,

/* block 27 */
120,320,321,321,120,322,322,322,322,322,322,322,322,322,322,322,
322,322,322,322,322,322,322,120,120,120,322,322,322,322,322,322,
322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,322,
322,322,120,322,322,322,322,322,322,322,322,322,120,322,120,120,
322,322,322,322,322,322,322,120,120,120,320,120,120,120,120,323,
321,321,320,320,320,120,320,120,321,321,321,321,321,321,321,323,
120,120,120,120,120,120,324,324,324,324,324,324,324,324,324,324,
120,120,321,321,325,120,120,120,120,120,120,120,120,120,120,120,

/* block 28 */
120,326,326,326,326,326,326,326,326,326,326,326,326,326,326,326,
326,326,326,326,326,326,326,326,326,326,326,326,326,326,326,326,
326,326,326,326,326,326,326,326,326,326,326,326,326,326,326,326,
326,327,326,328,327,327,327,327,327,327,327,120,120,120,120,  6,
326,326,326,326,326,326,329,327,327,327,327,327,327,327,327,330,
331,331,331,331,331,331,331,331,331,331,330,330,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 29 */
120,332,332,120,332,120,332,332,332,332,332,120,332,332,332,332,
332,332,332,332,332,332,332,332,332,332,332,332,332,332,332,332,
332,332,332,332,120,332,120,332,332,332,332,332,332,332,332,332,
332,333,332,334,333,333,333,333,333,333,333,333,333,332,120,120,
332,332,332,332,332,120,335,120,333,333,333,333,333,333,120,120,
336,336,336,336,336,336,336,336,336,336,120,120,332,332,332,332,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 30 */
337,338,338,338,339,339,339,339,339,339,339,339,339,339,339,339,
339,339,339,338,339,338,338,338,340,340,338,338,338,338,338,338,
341,341,341,341,341,341,341,341,341,341,342,342,342,342,342,342,
342,342,342,342,338,340,338,340,338,340,343,344,343,344,345,345,
337,337,337,337,337,337,337,337,120,337,337,337,337,337,337,337,
337,337,337,337,337,337,337,337,337,337,337,337,337,337,337,337,
337,337,337,337,337,337,337,337,337,337,337,337,337,120,120,120,
120,340,340,340,340,340,340,340,340,340,340,340,340,340,340,345,

/* block 31 */
340,340,340,340,340,339,340,340,337,337,337,337,337,340,340,340,
340,340,340,340,340,340,340,340,120,340,340,340,340,340,340,340,
340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,
340,340,340,340,340,340,340,340,340,340,340,340,340,120,338,338,
338,338,338,338,338,338,340,338,338,338,338,338,338,120,338,338,
339,339,339,339,339, 20, 20, 20, 20,339,339,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 32 */
346,346,346,346,346,346,346,346,346,346,346,346,346,346,346,346,
346,346,346,346,346,346,346,346,346,346,346,346,346,346,346,346,
346,346,346,346,346,346,346,346,346,346,346,347,347,348,348,348,
348,349,348,348,348,348,348,348,347,348,348,349,349,348,348,346,
350,350,350,350,350,350,350,350,350,350,351,351,351,351,351,351,
346,346,346,346,346,346,349,349,348,348,346,346,346,346,348,348,
348,346,347,347,347,346,346,347,347,347,347,347,347,347,346,346,
346,348,348,348,348,346,346,346,346,346,346,346,346,346,346,346,

/* block 33 */
346,346,348,347,349,348,348,347,347,347,347,347,347,348,346,347,
352,352,352,352,352,352,352,352,352,352,347,347,347,348,353,353,
354,354,354,354,354,354,354,354,354,354,354,354,354,354,354,354,
354,354,354,354,354,354,354,354,354,354,354,354,354,354,354,354,
354,354,354,354,354,354,120,354,120,120,120,120,120,354,120,120,
355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,
355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,355,
355,355,355,355,355,355,355,355,355,355,355,356,357,355,355,355,

/* block 34 */
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,

/* block 35 */
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,359,359,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,

/* block 36 */
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,120,361,361,361,361,120,120,
361,361,361,361,361,361,361,120,361,120,361,361,361,361,120,120,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,

/* block 37 */
361,361,361,361,361,361,361,361,361,120,361,361,361,361,120,120,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,120,361,361,361,361,120,120,361,361,361,361,361,361,361,120,
361,120,361,361,361,361,120,120,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,120,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,

/* block 38 */
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,120,361,361,361,361,120,120,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,361,361,361,361,120,120,362,362,362,
363,363,363,363,363,363,363,363,363,364,364,364,364,364,364,364,
364,364,364,364,364,364,364,364,364,364,364,364,364,120,120,120,

/* block 39 */
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
365,365,365,365,365,365,365,365,365,365,120,120,120,120,120,120,
366,366,366,366,366,366,366,366,366,366,366,366,366,366,366,366,
366,366,366,366,366,366,366,366,366,366,366,366,366,366,366,366,
366,366,366,366,366,366,366,366,366,366,366,366,366,366,366,366,
366,366,366,366,366,366,366,366,366,366,366,366,366,366,366,366,
366,366,366,366,366,366,366,366,366,366,366,366,366,366,366,366,
367,367,367,367,367,367,120,120,368,368,368,368,368,368,120,120,

/* block 40 */
369,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,

/* block 41 */
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,

/* block 42 */
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,371,372,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,

/* block 43 */
373,374,374,374,374,374,374,374,374,374,374,374,374,374,374,374,
374,374,374,374,374,374,374,374,374,374,374,375,376,120,120,120,
377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,
377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,
377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,
377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,
377,377,377,377,377,377,377,377,377,377,377,  5,  5,  5,378,378,
378,377,377,377,377,377,377,377,377,120,120,120,120,120,120,120,

/* block 44 */
379,379,379,379,379,379,379,379,379,379,379,379,379,379,379,379,
379,379,380,380,380,381,120,120,120,120,120,120,120,120,120,379,
382,382,382,382,382,382,382,382,382,382,382,382,382,382,382,382,
382,382,383,383,384,385,385,120,120,120,120,120,120,120,120,120,
386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,
386,386,387,387,120,120,120,120,120,120,120,120,120,120,120,120,
388,388,388,388,388,388,388,388,388,388,388,388,388,120,388,388,
388,120,389,389,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 45 */
390,390,390,390,390,390,390,390,390,390,390,390,390,390,390,390,
390,390,390,390,390,390,390,390,390,390,390,390,390,390,390,390,
390,390,390,390,390,390,390,390,390,390,390,390,390,390,390,390,
390,390,390,390,391,391,392,391,391,391,391,391,391,391,392,392,
392,392,392,392,392,392,391,392,392,391,391,391,391,391,391,391,
391,391,391,391,393,393,393,394,393,393,393,395,390,391,120,120,
396,396,396,396,396,396,396,396,396,396,120,120,120,120,120,120,
397,397,397,397,397,397,397,397,397,397,120,120,120,120,120,120,

/* block 46 */
398,398,399,399,398,399,400,398,398,398,398,401,401,401,402,401,
403,403,403,403,403,403,403,403,403,403,120,120,120,120,120,120,
404,404,404,404,404,404,404,404,404,404,404,404,404,404,404,404,
404,404,404,404,404,404,404,404,404,404,404,404,404,404,404,404,
404,404,404,405,404,404,404,404,404,404,404,404,404,404,404,404,
404,404,404,404,404,404,404,404,404,404,404,404,404,404,404,404,
404,404,404,404,404,404,404,404,404,404,404,404,404,404,404,404,
404,404,404,404,404,404,404,404,404,120,120,120,120,120,120,120,

/* block 47 */
404,404,404,404,404,401,401,404,404,404,404,404,404,404,404,404,
404,404,404,404,404,404,404,404,404,404,404,404,404,404,404,404,
404,404,404,404,404,404,404,404,404,401,404,120,120,120,120,120,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,370,370,370,120,120,120,120,120,120,120,120,120,120,

/* block 48 */
406,406,406,406,406,406,406,406,406,406,406,406,406,406,406,406,
406,406,406,406,406,406,406,406,406,406,406,406,406,406,406,120,
407,407,407,408,408,408,408,407,407,408,408,408,120,120,120,120,
408,408,407,408,408,408,408,408,408,407,407,407,120,120,120,120,
409,120,120,120,410,410,411,411,411,411,411,411,411,411,411,411,
412,412,412,412,412,412,412,412,412,412,412,412,412,412,412,412,
412,412,412,412,412,412,412,412,412,412,412,412,412,412,120,120,
412,412,412,412,412,120,120,120,120,120,120,120,120,120,120,120,

/* block 49 */
413,413,413,413,413,413,413,413,413,413,413,413,413,413,413,413,
413,413,413,413,413,413,413,413,413,413,413,413,413,413,413,413,
413,413,413,413,413,413,413,413,413,413,413,413,120,120,120,120,
413,413,413,413,413,413,413,413,413,413,413,413,413,413,413,413,
413,413,413,413,413,413,413,413,413,413,120,120,120,120,120,120,
414,414,414,414,414,414,414,414,414,414,415,120,120,120,416,416,
417,417,417,417,417,417,417,417,417,417,417,417,417,417,417,417,
417,417,417,417,417,417,417,417,417,417,417,417,417,417,417,417,

/* block 50 */
418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,
418,418,418,418,418,418,418,419,419,420,420,419,120,120,421,421,
422,422,422,422,422,422,422,422,422,422,422,422,422,422,422,422,
422,422,422,422,422,422,422,422,422,422,422,422,422,422,422,422,
422,422,422,422,422,422,422,422,422,422,422,422,422,422,422,422,
422,422,422,422,422,423,424,423,424,424,424,424,424,424,424,120,
424,425,424,425,425,424,424,424,424,424,424,424,424,423,423,423,
423,423,423,424,424,424,424,424,424,424,424,424,424,120,120,424,

/* block 51 */
426,426,426,426,426,426,426,426,426,426,120,120,120,120,120,120,
426,426,426,426,426,426,426,426,426,426,120,120,120,120,120,120,
427,427,427,427,427,427,427,428,427,427,427,427,427,427,120,120,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,429,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 52 */
430,430,430,430,431,432,432,432,432,432,432,432,432,432,432,432,
432,432,432,432,432,432,432,432,432,432,432,432,432,432,432,432,
432,432,432,432,432,432,432,432,432,432,432,432,432,432,432,432,
432,432,432,432,430,433,430,430,430,430,430,431,430,431,431,431,
431,431,430,431,431,432,432,432,432,432,432,432,432,120,120,120,
434,434,434,434,434,434,434,434,434,434,435,435,435,435,435,435,
435,436,436,436,436,436,436,436,436,436,436,430,430,430,430,430,
430,430,430,430,436,436,436,436,436,436,436,436,436,435,435,120,

/* block 53 */
437,437,438,439,439,439,439,439,439,439,439,439,439,439,439,439,
439,439,439,439,439,439,439,439,439,439,439,439,439,439,439,439,
439,438,437,437,437,437,438,438,437,437,438,437,437,437,439,439,
440,440,440,440,440,440,440,440,440,440,439,439,439,439,439,439,
441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,
441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,441,
441,441,441,441,441,441,442,443,442,442,443,443,443,442,443,442,
442,442,443,443,120,120,120,120,120,120,120,120,444,444,444,444,

/* block 54 */
445,445,445,445,445,445,445,445,445,445,445,445,445,445,445,445,
445,445,445,445,445,445,445,445,445,445,445,445,445,445,445,445,
445,445,445,445,446,446,446,446,446,446,446,446,447,447,447,447,
447,447,447,447,446,446,447,447,120,120,120,448,448,448,448,448,
449,449,449,449,449,449,449,449,449,449,120,120,120,445,445,445,
450,450,450,450,450,450,450,450,450,450,451,451,451,451,451,451,
451,451,451,451,451,451,451,451,451,451,451,451,451,451,451,451,
451,451,451,451,451,451,451,451,452,452,452,452,452,452,453,453,

/* block 55 */
454,455,456,457,458,459,460,461,462,120,120,120,120,120,120,120,
463,463,463,463,463,463,463,463,463,463,463,463,463,463,463,463,
463,463,463,463,463,463,463,463,463,463,463,463,463,463,463,463,
463,463,463,463,463,463,463,463,463,463,463,120,120,463,463,463,
464,464,464,464,464,464,464,464,120,120,120,120,120,120,120,120,
465,466,465,467,466,468,468,469,468,469,470,466,469,469,466,466,
469,471,466,466,466,466,466,466,466,472,473,474,474,468,474,474,
474,474,475,476,477,473,473,478,479,479,480,120,120,120,120,120,

/* block 56 */
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35,128,128,128,128,128,481,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,121,121,121,
121,121,110,110,110,110,121,121,121,121,121, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35,482,483, 35, 35, 35,484, 35, 35,

/* block 57 */
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,485, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,121,
114,114,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,486,113,487,113,113,113,113,113,

/* block 58 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
488,489, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,

/* block 59 */
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 35, 35, 35, 35, 35,490, 35, 35,491, 35,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,

/* block 60 */
492,492,492,492,492,492,492,492,493,493,493,493,493,493,493,493,
492,492,492,492,492,492,120,120,493,493,493,493,493,493,120,120,
492,492,492,492,492,492,492,492,493,493,493,493,493,493,493,493,
492,492,492,492,492,492,492,492,493,493,493,493,493,493,493,493,
492,492,492,492,492,492,120,120,493,493,493,493,493,493,120,120,
128,492,128,492,128,492,128,492,120,493,120,493,120,493,120,493,
492,492,492,492,492,492,492,492,493,493,493,493,493,493,493,493,
494,494,495,495,495,495,496,496,497,497,498,498,499,499,120,120,

/* block 61 */
492,492,492,492,492,492,492,492,500,500,500,500,500,500,500,500,
492,492,492,492,492,492,492,492,500,500,500,500,500,500,500,500,
492,492,492,492,492,492,492,492,500,500,500,500,500,500,500,500,
492,492,128,501,128,120,128,128,493,493,502,502,503,119,504,119,
119,119,128,501,128,120,128,128,505,505,505,505,503,119,119,119,
492,492,128,128,120,120,128,128,493,493,506,506,120,119,119,119,
492,492,128,128,128,169,128,128,493,493,507,507,174,119,119,119,
120,120,128,501,128,120,128,128,508,508,509,509,503,119,119,120,

/* block 62 */
  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4, 24,510,511, 24, 24,
 10, 10, 10, 10, 10, 10,  5,  5, 23, 27,  7, 23, 23, 27,  7, 23,
  5,  5,  5,  5,  5,  5,  5,  5,512,513, 24, 24, 24, 24, 24,514,
  5,  5,  5,  5,  5,  5,  5,  5,  5, 23, 27,  5,515,  5,  5, 16,
 16,  5,  5,  5,  9,  7,  8,  5,  5,515,  5,  5,  5,  5,  5,  5,
  5,  5,  9,  5, 16,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  4,
 24, 24, 24, 24, 24,516, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
 25,110,120,120, 25, 25, 25, 25, 25, 25,  9,  9,  9,  7,  8,110,

/* block 63 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,  9,  9,  9,  7,  8,120,
110,110,110,110,110,110,110,110,110,110,110,110,110,120,120,120,
  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
  6,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
113,113,113,113,113,113,113,113,113,113,113,113,113,429,429,429,
429,113,429,429,429,113,113,113,113,113,113,113,113,113,113,113,
517,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 64 */
 20, 20,518, 20, 20, 20, 20,518, 20, 20,519,518,518,518,519,519,
518,518,518,519, 20,518, 20, 20,  9,518,518,518,518,518, 20, 20,
 20, 20, 21, 20,518, 20,520, 20,518, 20,521,522,518,518, 20,519,
518,518,523,518,519,524,524,524,524,525, 20, 20,519,519,518,518,
  9,  9,  9,  9,  9,518,519,519,519,519, 20,  9, 20, 20,526, 20,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
527,527,527,527,527,527,527,527,527,527,527,527,527,527,527,527,
528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,

/* block 65 */
529,529,529, 32, 33,529,529,529,529, 25, 20, 20,120,120,120,120,
  9,  9,  9,  9,530, 21, 21, 21, 21, 21,  9,  9, 20, 20, 20, 20,
  9, 20, 20,  9, 20, 20,  9, 20, 20, 21, 21, 20, 20, 20,  9, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,
 20, 20,  9, 20,  9, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 66 */
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 67 */
 20, 20, 20, 20, 20, 20, 20, 20,  7,  8,  7,  8, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 20, 20, 20, 20,
  9,  9, 20, 20, 20, 20, 20, 20, 21,  7,  8, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9, 20, 20, 20,

/* block 68 */
 20, 20, 20, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,  9,  9,
  9,  9, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 20, 20, 20, 20, 21, 21, 21, 20, 20, 20, 20, 20,

/* block 69 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 70 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20,531,531,531,531,531,531,531,531,531,531,
531,531,532,531,531,531,531,531,531,531,531,531,531,531,531,531,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 71 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 72 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 21,  9, 20, 20, 20, 20, 20, 20, 20, 20,
 21,  9, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20,  9,  9,  9,530,530,530,530,  9,

/* block 73 */
 21, 21, 21, 21, 21, 21, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,530,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 74 */
 21, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 75 */
 21, 21, 21, 21, 21, 21, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 20, 21, 20, 21, 20, 20, 20, 20, 20, 20, 21, 20, 20,
 20, 21, 20, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 21, 20, 20, 21, 20, 20, 20, 20, 21, 20, 21, 20,
 20, 20, 20, 21, 21, 21, 20, 21, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 21, 21, 21, 21, 21,  7,  8,  7,  8,  7,  8,  7,  8,
  7,  8,  7,  8,  7,  8, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 76 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 20, 21, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
  9,  9,  9,  9,  9,  7,  8,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 77 */
534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,
534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,
534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,
534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,
534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,
534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,
534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,
534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,534,

/* block 78 */
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,530,530,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,

/* block 79 */
  9,  9,  9,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,  7,
  8,  7,  8,  7,  8,  7,  8,  7,  8,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  7,  8,  7,  8,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  7,  8,  9,  9,

/* block 80 */
 20, 20, 20, 20, 20, 21, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,  9,
  9,  9,  9,  9,  9, 20, 20,  9,  9,  9,  9,  9,  9, 20, 20, 20,
 21, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20,120,120, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 81 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20,120, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 82 */
535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,
535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,
535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,535,
536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,
536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,
536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,
 32, 33,537,538,539,540,541, 32, 33, 32, 33, 32, 33,542,543,544,
545, 35, 32, 33, 35, 32, 33, 35, 35, 35, 35, 35,110,110,546,546,

/* block 83 */
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,165,166,165,166,165,166,165,166,165,166,165,166,
165,166,165,166,547,548,548,548,548,548,548,165,166,165,166,549,
549,549,165,166,120,120,120,120,120,550,550,550,550,551,550,550,

/* block 84 */
552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,
552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,
552,552,552,552,552,552,120,552,120,120,120,120,120,552,120,120,
553,553,553,553,553,553,553,553,553,553,553,553,553,553,553,553,
553,553,553,553,553,553,553,553,553,553,553,553,553,553,553,553,
553,553,553,553,553,553,553,553,553,553,553,553,553,553,553,553,
553,553,553,553,553,553,553,553,120,120,120,120,120,120,120,554,
555,120,120,120,120,120,120,120,120,120,120,120,120,120,120,556,

/* block 85 */
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,
361,361,361,361,361,361,361,120,120,120,120,120,120,120,120,120,
361,361,361,361,361,361,361,120,361,361,361,361,361,361,361,120,
361,361,361,361,361,361,361,120,361,361,361,361,361,361,361,120,
361,361,361,361,361,361,361,120,361,361,361,361,361,361,361,120,
361,361,361,361,361,361,361,120,361,361,361,361,361,361,361,120,
557,557,557,557,557,557,557,557,557,557,557,557,557,557,557,557,
557,557,557,557,557,557,557,557,557,557,557,557,557,557,557,557,

/* block 86 */
  5,  5, 23, 27, 23, 27,  5,  5,  5, 23, 27,  5, 23, 27,  5,  5,
  5,  5,  5,  5,  5,  5,  5, 10,  5,  5, 10,  5, 23, 27,  5,  5,
 23, 27,  7,  8,  7,  8,  7,  8,  7,  8,  5,  5,  5,  5,  5,111,
  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 10, 10,  5,  5,  5,  5,
 10,  5,  7,558,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,
 20, 20,  5,  5,  5,  7,  8,  7,  8,  7,  8,  7,  8, 10,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 87 */
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,120,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 88 */
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,

/* block 89 */
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,559,559,559,559,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,120,120,120,120,

/* block 90 */
  4,560,560,561, 20,562,563,564,565,566,565,566,565,566,565,566,
565,566, 20,567,565,566,565,566,565,566,565,566,568,569,570,570,
 20,564,564,564,564,564,564,564,564,564,571,571,571,571,572,572,
573,574,574,574,574,574, 20,567,564,564,564,562,575,576,577,577,
120,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,

/* block 91 */
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,120,120,579,579,580,580,581,581,578,
582,583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,
583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,
583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,
583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,
583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,
583,583,583,583,583,583,583,583,583,583,583,560,574,584,584,583,

/* block 92 */
120,120,120,120,120,585,585,585,585,585,585,585,585,585,585,585,
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,
120,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,

/* block 93 */
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,120,
577,577,587,587,587,587,577,577,577,577,577,577,577,577,577,577,
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,
585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,585,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,120,120,120,120,120,120,120,120,120,120,120,120,
583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,

/* block 94 */
588,588,588,588,588,588,588,588,588,588,588,588,588,588,588,588,
588,588,588,588,588,588,588,588,588,588,588,588,588,588,588,120,
587,587,587,587,587,587,587,587,587,587,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577, 25, 25, 25, 25, 25, 25, 25, 25,
 20, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
588,588,588,588,588,588,588,588,588,588,588,588,588,588,588,588,
588,588,588,588,588,588,588,588,588,588,588,588,588,588,588, 20,

/* block 95 */
587,587,587,587,587,587,587,587,587,587,577,577,577,577,577,577,
577,577,577,577,577,577,577,589,577,589,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
577,577,577,577,577,577,577,577,577,577,577,577, 20, 20, 20, 20,
590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,
590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,
590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,577,

/* block 96 */
590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,
590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,
590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,
590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,
590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,590,
590,590,590,590,590,590,590,590,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,577,577,577,577,577,

/* block 97 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,577,
577,577,577,577,577,577,577,577,577,577,577,577,577,577,577, 20,

/* block 98 */
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,

/* block 99 */
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 100 */
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,593,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,

/* block 101 */
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,
592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,592,

/* block 102 */
592,592,592,592,592,592,592,592,592,592,592,592,592,120,120,120,
594,594,594,594,594,594,594,594,594,594,594,594,594,594,594,594,
594,594,594,594,594,594,594,594,594,594,594,594,594,594,594,594,
594,594,594,594,594,594,594,594,594,594,594,594,594,594,594,594,
594,594,594,594,594,594,594,120,120,120,120,120,120,120,120,120,
595,595,595,595,595,595,595,595,595,595,595,595,595,595,595,595,
595,595,595,595,595,595,595,595,595,595,595,595,595,595,595,595,
595,595,595,595,595,595,595,595,596,596,596,596,596,596,597,597,

/* block 103 */
598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,
598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,
598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,
598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,
598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,
598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,
598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,
598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,

/* block 104 */
598,598,598,598,598,598,598,598,598,598,598,598,599,600,600,600,
598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,598,
601,601,601,601,601,601,601,601,601,601,598,598,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
192,193,192,193,192,193,192,193,192,193,602,603,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,192,193,604,198,
200,200,200,605,557,557,557,557,557,557,557,557,557,557,605,482,

/* block 105 */
192,193,192,193,192,193,192,193,192,193,192,193,192,193,192,193,
192,193,192,193,192,193,192,193,192,193,192,193,482,482,557,557,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,607,607,607,607,607,607,607,607,607,607,
608,608,609,609,609,609,609,609,120,120,120,120,120,120,120,120,

/* block 106 */
610,610,610,610,610,610,610,610, 15, 15, 15, 15, 15, 15, 15, 15,
 15, 15, 15, 15, 15, 15, 15,111,111,111,111,111,111,111,111,111,
 15, 15, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 35, 35, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
110, 35, 35, 35, 35, 35, 35, 35, 35, 32, 33, 32, 33,611, 32, 33,

/* block 107 */
 32, 33, 32, 33, 32, 33, 32, 33,111, 15, 15, 32, 33,612, 35, 22,
 32, 33, 32, 33,613, 35, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,614,615,616,617,614, 35,
618,619,620,621, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33, 32, 33,
 32, 33, 32, 33,622,623,624, 32, 33, 32, 33,120,120,120,120,120,
 32, 33,120, 35,120, 35, 32, 33, 32, 33,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,110,110,110, 32, 33, 22,110,110, 35, 22, 22, 22, 22, 22,

/* block 108 */
625,625,626,625,625,625,626,625,625,625,625,626,625,625,625,625,
625,625,625,625,625,625,625,625,625,625,625,625,625,625,625,625,
625,625,625,627,627,626,626,627,628,628,628,628,626,120,120,120,
629,629,629,630,630,630,631,631,632,631,120,120,120,120,120,120,
633,633,633,633,633,633,633,633,633,633,633,633,633,633,633,633,
633,633,633,633,633,633,633,633,633,633,633,633,633,633,633,633,
633,633,633,633,633,633,633,633,633,633,633,633,633,633,633,633,
633,633,633,633,634,634,634,634,120,120,120,120,120,120,120,120,

/* block 109 */
635,635,636,636,636,636,636,636,636,636,636,636,636,636,636,636,
636,636,636,636,636,636,636,636,636,636,636,636,636,636,636,636,
636,636,636,636,636,636,636,636,636,636,636,636,636,636,636,636,
636,636,636,636,635,635,635,635,635,635,635,635,635,635,635,635,
635,635,635,635,637,637,120,120,120,120,120,120,120,120,638,638,
639,639,639,639,639,639,639,639,639,639,120,120,120,120,120,120,
253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,253,
253,640,255,641,255,255,255,255,261,261,261,255,261,255,255,253,

/* block 110 */
642,642,642,642,642,642,642,642,642,642,643,643,643,643,643,643,
643,643,643,643,643,643,643,643,643,643,643,643,643,643,643,643,
643,643,643,643,643,643,644,644,644,644,644,644,644,644,645,646,
647,647,647,647,647,647,647,647,647,647,647,647,647,647,647,647,
647,647,647,647,647,647,647,648,648,648,648,648,648,648,648,648,
648,648,649,649,120,120,120,120,120,120,120,120,120,120,120,650,
358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,358,
358,358,358,358,358,358,358,358,358,358,358,358,358,120,120,120,

/* block 111 */
651,651,651,652,653,653,653,653,653,653,653,653,653,653,653,653,
653,653,653,653,653,653,653,653,653,653,653,653,653,653,653,653,
653,653,653,653,653,653,653,653,653,653,653,653,653,653,653,653,
653,653,653,651,652,652,651,651,651,651,652,652,651,651,652,652,
652,654,654,654,654,654,654,654,654,654,654,654,654,654,120,655,
656,656,656,656,656,656,656,656,656,656,120,120,120,120,654,654,
346,346,346,346,346,348,657,346,346,346,346,346,346,346,346,346,
352,352,352,352,352,352,352,352,352,352,346,346,346,346,346,120,

/* block 112 */
658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,
658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,658,
658,658,658,658,658,658,658,658,658,659,659,659,659,659,659,660,
660,659,659,660,660,659,659,120,120,120,120,120,120,120,120,120,
658,658,658,659,658,658,658,658,658,658,658,658,659,660,120,120,
661,661,661,661,661,661,661,661,661,661,120,120,662,662,662,662,
346,346,346,346,346,346,346,346,346,346,346,346,346,346,346,346,
657,346,346,346,346,346,346,353,353,353,346,347,348,347,346,346,

/* block 113 */
663,663,663,663,663,663,663,663,663,663,663,663,663,663,663,663,
663,663,663,663,663,663,663,663,663,663,663,663,663,663,663,663,
663,663,663,663,663,663,663,663,663,663,663,663,663,663,663,663,
664,663,664,664,664,663,663,664,664,663,663,663,663,663,664,664,
663,664,663,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,663,663,665,666,666,
667,667,667,667,667,667,667,667,667,667,667,668,669,669,668,668,
670,670,667,671,671,668,669,120,120,120,120,120,120,120,120,120,

/* block 114 */
120,361,361,361,361,361,361,120,120,361,361,361,361,361,361,120,
120,361,361,361,361,361,361,120,120,120,120,120,120,120,120,120,
361,361,361,361,361,361,361,120,361,361,361,361,361,361,361,120,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
 35, 35, 35,672, 35, 35, 35, 35, 35, 35, 35, 15,110,110,110,110,
 35, 35, 35, 35, 35,128, 35, 35, 35,110, 15, 15,120,120,120,120,
673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,

/* block 115 */
673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,
673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,
673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,
673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,673,
667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,
667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,667,
667,667,667,668,668,669,668,668,669,668,668,670,668,669,120,120,
674,674,674,674,674,674,674,674,674,674,120,120,120,120,120,120,

/* block 116 */
675,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,675,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,675,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,675,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
675,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,

/* block 117 */
676,676,676,676,676,676,676,676,676,676,676,676,675,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,675,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,675,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
675,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,675,676,676,676,

/* block 118 */
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,675,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,675,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
675,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,675,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,

/* block 119 */
676,676,676,676,676,676,676,676,675,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,675,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
675,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,675,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,675,676,676,676,676,676,676,676,

/* block 120 */
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,675,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
675,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,675,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,675,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,

/* block 121 */
676,676,676,676,675,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
675,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,675,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,675,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,675,676,676,676,676,676,676,676,676,676,676,676,

/* block 122 */
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
675,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,675,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,675,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,675,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,

/* block 123 */
676,676,676,676,676,676,676,676,675,676,676,676,676,676,676,676,
676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,676,
676,676,676,676,120,120,120,120,120,120,120,120,120,120,120,120,
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,359,120,120,120,120,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,360,
360,360,360,360,360,360,360,360,360,360,360,360,120,120,120,120,

/* block 124 */
677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,
677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,
677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,
677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,
677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,
677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,
677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,
677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,677,

/* block 125 */
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,

/* block 126 */
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,120,120,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,

/* block 127 */
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 128 */
 35, 35, 35, 35, 35, 35, 35,120,120,120,120,120,120,120,120,120,
120,120,120,206,206,206,206,206,120,120,120,120,120,214,211,214,
214,214,214,214,214,214,214,214,214,679,214,214,214,214,214,214,
214,214,214,214,214,214,214,120,214,214,214,214,214,120,214,120,
214,214,120,214,214,120,214,214,214,214,214,214,214,214,214,214,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 129 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
252,252,252,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 130 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 131 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,680,681,
221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,

/* block 132 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
120,120,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,120,120,120,120,120,120,120,221,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
225,225,682,225,225,225,225,225,225,225,225,225,219,683,221,221,

/* block 133 */
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
  5,  5,  5,  5,  5,  5,  5,  7,  8,  5,120,120,120,120,120,120,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,557,557,
  5, 10, 10, 16, 16,  7,  8,  7,  8,  7,  8,  7,  8,  7,  8,  7,
  8,  7,  8,  7,  8,561,561,  7,  8,  5,  5,  5,  5, 16, 16, 16,
  5,  5,  5,120,  5,  5,  5,  5, 10,  7,  8,  7,  8,  7,  8,  5,
  5,  5,  9, 10,  9,  9,  9,120,  5,  6,  5,  5,120,120,120,120,
225,225,225,225,225,120,225,225,225,225,225,225,225,225,225,225,

/* block 134 */
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,120,120, 24,

/* block 135 */
120,  5,  5,  5,  6,  5,  5,  5,  7,  8,  5,  9,  5, 10,  5,  5,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,  5,  5,  9,  9,  9,  5,
  5, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,  7,  5,  8, 15, 16,
 15, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,  7,  9,  8,  9,  7,
  8,560,565,566,560,560,583,583,583,583,583,583,583,583,583,583,
574,583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,

/* block 136 */
583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,583,
583,583,583,583,583,583,583,583,583,583,583,583,583,583,684,684,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,
586,586,586,586,586,586,586,586,586,586,586,586,586,586,586,120,
120,120,586,586,586,586,586,586,120,120,586,586,586,586,586,586,
120,120,586,586,586,586,586,586,120,120,586,586,586,120,120,120,
  6,  6,  9, 15, 20,  6,  6,120, 20,  9,  9,  9,  9, 20, 20,120,
516,516,516,516,516,516,516,516,516, 24, 24, 24, 20, 20,120,120,

/* block 137 */
685,685,685,685,685,685,685,685,685,685,685,685,120,685,685,685,
685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,
685,685,685,685,685,685,685,120,685,685,685,685,685,685,685,685,
685,685,685,685,685,685,685,685,685,685,685,120,685,685,120,685,
685,685,685,685,685,685,685,685,685,685,685,685,685,685,120,120,
685,685,685,685,685,685,685,685,685,685,685,685,685,685,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 138 */
685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,
685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,
685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,
685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,
685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,
685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,
685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,685,
685,685,685,685,685,685,685,685,685,685,685,120,120,120,120,120,

/* block 139 */
686,686,687,120,120,120,120,688,688,688,688,688,688,688,688,688,
688,688,688,688,688,688,688,688,688,688,688,688,688,688,688,688,
688,688,688,688,688,688,688,688,688,688,688,688,688,688,688,688,
688,688,688,688,120,120,120,689,689,689,689,689,689,689,689,689,
690,690,690,690,690,690,690,690,690,690,690,690,690,690,690,690,
690,690,690,690,690,690,690,690,690,690,690,690,690,690,690,690,
690,690,690,690,690,690,690,690,690,690,690,690,690,690,690,690,
690,690,690,690,690,691,691,691,691,692,692,692,692,692,692,692,

/* block 140 */
692,692,692,692,692,692,692,692,692,692,691,691,692,692,692,120,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,120,120,120,
692,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,113,120,120,

/* block 141 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 142 */
693,693,693,693,693,693,693,693,693,693,693,693,693,693,693,693,
693,693,693,693,693,693,693,693,693,693,693,693,693,120,120,120,
694,694,694,694,694,694,694,694,694,694,694,694,694,694,694,694,
694,694,694,694,694,694,694,694,694,694,694,694,694,694,694,694,
694,694,694,694,694,694,694,694,694,694,694,694,694,694,694,694,
694,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
695,696,696,696,696,696,696,696,696,696,696,696,696,696,696,696,
696,696,696,696,696,696,696,696,696,696,696,696,120,120,120,120,

/* block 143 */
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,697,
698,698,698,698,120,120,120,120,120,120,120,120,120,697,697,697,
699,699,699,699,699,699,699,699,699,699,699,699,699,699,699,699,
699,700,699,699,699,699,699,699,699,699,700,120,120,120,120,120,
701,701,701,701,701,701,701,701,701,701,701,701,701,701,701,701,
701,701,701,701,701,701,701,701,701,701,701,701,701,701,701,701,
701,701,701,701,701,701,702,702,702,702,702,120,120,120,120,120,

/* block 144 */
703,703,703,703,703,703,703,703,703,703,703,703,703,703,703,703,
703,703,703,703,703,703,703,703,703,703,703,703,703,703,120,704,
705,705,705,705,705,705,705,705,705,705,705,705,705,705,705,705,
705,705,705,705,705,705,705,705,705,705,705,705,705,705,705,705,
705,705,705,705,120,120,120,120,705,705,705,705,705,705,705,705,
706,707,707,707,707,707,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 145 */
708,708,708,708,708,708,708,708,708,708,708,708,708,708,708,708,
708,708,708,708,708,708,708,708,708,708,708,708,708,708,708,708,
708,708,708,708,708,708,708,708,709,709,709,709,709,709,709,709,
709,709,709,709,709,709,709,709,709,709,709,709,709,709,709,709,
709,709,709,709,709,709,709,709,709,709,709,709,709,709,709,709,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,
710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,

/* block 146 */
711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,
711,711,711,711,711,711,711,711,711,711,711,711,711,711,120,120,
712,712,712,712,712,712,712,712,712,712,120,120,120,120,120,120,
713,713,713,713,713,713,713,713,713,713,713,713,713,713,713,713,
713,713,713,713,713,713,713,713,713,713,713,713,713,713,713,713,
713,713,713,713,120,120,120,120,714,714,714,714,714,714,714,714,
714,714,714,714,714,714,714,714,714,714,714,714,714,714,714,714,
714,714,714,714,714,714,714,714,714,714,714,714,120,120,120,120,

/* block 147 */
715,715,715,715,715,715,715,715,715,715,715,715,715,715,715,715,
715,715,715,715,715,715,715,715,715,715,715,715,715,715,715,715,
715,715,715,715,715,715,715,715,120,120,120,120,120,120,120,120,
716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,
716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,
716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,716,
716,716,716,716,120,120,120,120,120,120,120,120,120,120,120,717,
718,718,718,718,718,718,718,718,718,718,718,120,718,718,718,718,

/* block 148 */
718,718,718,718,718,718,718,718,718,718,718,120,718,718,718,718,
718,718,718,120,718,718,120,719,719,719,719,719,719,719,719,719,
719,719,120,719,719,719,719,719,719,719,719,719,719,719,719,719,
719,719,120,719,719,719,719,719,719,719,120,719,719,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 149 */
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,

/* block 150 */
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,720,720,720,720,120,120,120,120,120,120,120,120,120,
720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,720,
720,720,720,720,720,720,120,120,120,120,120,120,120,120,120,120,
720,720,720,720,720,720,720,720,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 151 */
110,110,110,110,110,110,120,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,120,110,110,110,110,110,110,110,110,110,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 152 */
721,721,721,721,721,721,120,120,721,120,721,721,721,721,721,721,
721,721,721,721,721,721,721,721,721,721,721,721,721,721,721,721,
721,721,721,721,721,721,721,721,721,721,721,721,721,721,721,721,
721,721,721,721,721,721,120,721,721,120,120,120,721,120,120,721,
722,722,722,722,722,722,722,722,722,722,722,722,722,722,722,722,
722,722,722,722,722,722,120,723,724,724,724,724,724,724,724,724,
725,725,725,725,725,725,725,725,725,725,725,725,725,725,725,725,
725,725,725,725,725,725,725,726,726,727,727,727,727,727,727,727,

/* block 153 */
728,728,728,728,728,728,728,728,728,728,728,728,728,728,728,728,
728,728,728,728,728,728,728,728,728,728,728,728,728,728,728,120,
120,120,120,120,120,120,120,729,729,729,729,729,729,729,729,729,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
730,730,730,730,730,730,730,730,730,730,730,730,730,730,730,730,
730,730,730,120,730,730,120,120,120,120,120,731,731,731,731,731,

/* block 154 */
732,732,732,732,732,732,732,732,732,732,732,732,732,732,732,732,
732,732,732,732,732,732,733,733,733,733,733,733,120,120,120,734,
735,735,735,735,735,735,735,735,735,735,735,735,735,735,735,735,
735,735,735,735,735,735,735,735,735,735,120,120,120,120,120,736,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 155 */
737,737,737,737,737,737,737,737,737,737,737,737,737,737,737,737,
737,737,737,737,737,737,737,737,737,737,737,737,737,737,737,737,
738,738,738,738,738,738,738,738,738,738,738,738,738,738,738,738,
738,738,738,738,738,738,738,738,120,120,120,120,739,739,738,738,
739,739,739,739,739,739,739,739,739,739,739,739,739,739,739,739,
120,120,739,739,739,739,739,739,739,739,739,739,739,739,739,739,
739,739,739,739,739,739,739,739,739,739,739,739,739,739,739,739,
739,739,739,739,739,739,739,739,739,739,739,739,739,739,739,739,

/* block 156 */
740,741,741,741,120,741,741,120,120,120,120,120,741,741,741,741,
740,740,740,740,120,740,740,740,120,740,740,740,740,740,740,740,
740,740,740,740,740,740,740,740,740,740,740,740,740,740,740,740,
740,740,740,740,740,740,120,120,741,741,741,120,120,120,120,741,
742,742,742,742,742,742,742,742,742,120,120,120,120,120,120,120,
743,743,743,743,743,743,743,743,743,120,120,120,120,120,120,120,
744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,744,
744,744,744,744,744,744,744,744,744,744,744,744,744,745,745,746,

/* block 157 */
747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,
747,747,747,747,747,747,747,747,747,747,747,747,747,748,748,748,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
749,749,749,749,749,749,749,749,750,749,749,749,749,749,749,749,
749,749,749,749,749,749,749,749,749,749,749,749,749,749,749,749,
749,749,749,749,749,751,751,120,120,120,120,752,752,752,752,752,
753,753,754,753,753,753,753,120,120,120,120,120,120,120,120,120,

/* block 158 */
755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,
755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,
755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,755,
755,755,755,755,755,755,120,120,120,756,756,756,756,756,756,756,
757,757,757,757,757,757,757,757,757,757,757,757,757,757,757,757,
757,757,757,757,757,757,120,120,758,758,758,758,758,758,758,758,
759,759,759,759,759,759,759,759,759,759,759,759,759,759,759,759,
759,759,759,120,120,120,120,120,760,760,760,760,760,760,760,760,

/* block 159 */
761,761,761,761,761,761,761,761,761,761,761,761,761,761,761,761,
761,761,120,120,120,120,120,120,120,762,762,762,762,120,120,120,
120,120,120,120,120,120,120,120,120,763,763,763,763,763,763,763,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 160 */
764,764,764,764,764,764,764,764,764,764,764,764,764,764,764,764,
764,764,764,764,764,764,764,764,764,764,764,764,764,764,764,764,
764,764,764,764,764,764,764,764,764,764,764,764,764,764,764,764,
764,764,764,764,764,764,764,764,764,764,764,764,764,764,764,764,
764,764,764,764,764,764,764,764,764,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 161 */
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,120,120,120,120,120,120,120,120,120,120,120,120,120,
766,766,766,766,766,766,766,766,766,766,766,766,766,766,766,766,
766,766,766,766,766,766,766,766,766,766,766,766,766,766,766,766,
766,766,766,766,766,766,766,766,766,766,766,766,766,766,766,766,
766,766,766,120,120,120,120,120,120,120,767,767,767,767,767,767,

/* block 162 */
768,768,768,768,768,768,768,768,768,768,768,768,768,768,768,768,
768,768,768,768,768,768,768,768,768,768,768,768,768,768,768,768,
768,768,768,768,769,769,769,769,120,120,120,120,120,120,120,120,
770,770,770,770,770,770,770,770,770,770,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 163 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
771,771,771,771,771,771,771,771,771,771,771,771,771,771,771,771,
771,771,771,771,771,771,771,771,771,771,771,771,771,771,771,120,

/* block 164 */
772,772,772,772,772,772,772,772,772,772,772,772,772,772,772,772,
772,772,772,772,772,772,772,772,772,772,772,772,772,772,772,772,
772,772,772,772,772,772,772,772,772,772,120,773,773,774,120,120,
772,772,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 165 */
775,775,775,775,775,775,775,775,775,775,775,775,775,775,775,775,
775,775,775,775,775,775,775,775,775,775,775,775,775,776,776,776,
776,776,776,776,776,776,776,775,120,120,120,120,120,120,120,120,
777,777,777,777,777,777,777,777,777,777,777,777,777,777,777,777,
777,777,777,777,777,777,778,778,778,778,778,778,778,778,778,778,
778,779,779,779,779,780,780,780,780,780,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,

/* block 166 */
781,781,782,782,782,782,783,783,783,783,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
784,784,784,784,784,784,784,784,784,784,784,784,784,784,784,784,
784,784,784,784,784,785,785,785,785,785,785,785,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
786,786,786,786,786,786,786,786,786,786,786,786,786,786,786,786,
786,786,786,786,786,786,786,120,120,120,120,120,120,120,120,120,

/* block 167 */
787,788,787,789,789,789,789,789,789,789,789,789,789,789,789,789,
789,789,789,789,789,789,789,789,789,789,789,789,789,789,789,789,
789,789,789,789,789,789,789,789,789,789,789,789,789,789,789,789,
789,789,789,789,789,789,789,789,788,788,788,788,788,788,788,788,
788,788,788,788,788,788,788,790,790,790,790,790,790,790,120,120,
120,120,791,791,791,791,791,791,791,791,791,791,791,791,791,791,
791,791,791,791,791,791,792,792,792,792,792,792,792,792,792,792,
788,789,789,788,788,789,120,120,120,120,120,120,120,120,120,788,

/* block 168 */
793,793,794,795,795,795,795,795,795,795,795,795,795,795,795,795,
795,795,795,795,795,795,795,795,795,795,795,795,795,795,795,795,
795,795,795,795,795,795,795,795,795,795,795,795,795,795,795,795,
794,794,794,793,793,793,793,794,794,793,793,796,796,797,796,796,
796,796,793,120,120,120,120,120,120,120,120,120,120,797,120,120,
798,798,798,798,798,798,798,798,798,798,798,798,798,798,798,798,
798,798,798,798,798,798,798,798,798,120,120,120,120,120,120,120,
799,799,799,799,799,799,799,799,799,799,120,120,120,120,120,120,

/* block 169 */
800,800,800,801,801,801,801,801,801,801,801,801,801,801,801,801,
801,801,801,801,801,801,801,801,801,801,801,801,801,801,801,801,
801,801,801,801,801,801,801,800,800,800,800,800,802,800,800,800,
800,800,800,800,800,120,803,803,803,803,803,803,803,803,803,803,
804,804,804,804,801,802,802,801,120,120,120,120,120,120,120,120,
805,805,805,805,805,805,805,805,805,805,805,805,805,805,805,805,
805,805,805,805,805,805,805,805,805,805,805,805,805,805,805,805,
805,805,805,806,807,807,805,120,120,120,120,120,120,120,120,120,

/* block 170 */
808,808,809,810,810,810,810,810,810,810,810,810,810,810,810,810,
810,810,810,810,810,810,810,810,810,810,810,810,810,810,810,810,
810,810,810,810,810,810,810,810,810,810,810,810,810,810,810,810,
810,810,810,809,809,809,808,808,808,808,808,808,808,808,808,809,
809,810,811,811,810,812,812,812,812,808,808,808,808,812,809,808,
813,813,813,813,813,813,813,813,813,813,810,812,810,812,812,812,
120,814,814,814,814,814,814,814,814,814,814,814,814,814,814,814,
814,814,814,814,814,120,120,120,120,120,120,120,120,120,120,120,

/* block 171 */
815,815,815,815,815,815,815,815,815,815,815,815,815,815,815,815,
815,815,120,815,815,815,815,815,815,815,815,815,815,815,815,815,
815,815,815,815,815,815,815,815,815,815,815,815,816,816,816,817,
817,817,816,816,817,816,817,817,818,818,818,818,818,818,817,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 172 */
819,819,819,819,819,819,819,120,819,120,819,819,819,819,120,819,
819,819,819,819,819,819,819,819,819,819,819,819,819,819,120,819,
819,819,819,819,819,819,819,819,819,820,120,120,120,120,120,120,
821,821,821,821,821,821,821,821,821,821,821,821,821,821,821,821,
821,821,821,821,821,821,821,821,821,821,821,821,821,821,821,821,
821,821,821,821,821,821,821,821,821,821,821,821,821,821,821,822,
823,823,823,822,822,822,822,822,822,822,822,120,120,120,120,120,
824,824,824,824,824,824,824,824,824,824,120,120,120,120,120,120,

/* block 173 */
825,826,827,828,120,829,829,829,829,829,829,829,829,120,120,829,
829,120,120,829,829,829,829,829,829,829,829,829,829,829,829,829,
829,829,829,829,829,829,829,829,829,120,829,829,829,829,829,829,
829,120,829,829,120,829,829,829,829,829,120,830,826,829,831,827,
825,827,827,827,827,120,120,827,827,120,120,827,827,827,120,120,
829,120,120,120,120,120,120,831,120,120,120,120,120,829,829,829,
829,829,827,827,120,120,825,825,825,825,825,825,825,120,120,120,
825,825,825,825,825,120,120,120,120,120,120,120,120,120,120,120,

/* block 174 */
832,832,832,832,832,832,832,832,832,832,832,832,832,832,832,832,
832,832,832,832,832,832,832,832,832,832,832,832,832,832,832,832,
832,832,832,832,832,832,832,832,832,832,832,832,832,832,832,832,
832,832,832,832,832,833,833,833,834,834,834,834,834,834,834,834,
833,833,834,834,834,833,834,832,832,832,832,835,835,835,835,835,
836,836,836,836,836,836,836,836,836,836,835,835,120,835,834,832,
832,832,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 175 */
837,837,837,837,837,837,837,837,837,837,837,837,837,837,837,837,
837,837,837,837,837,837,837,837,837,837,837,837,837,837,837,837,
837,837,837,837,837,837,837,837,837,837,837,837,837,837,837,837,
838,839,839,840,840,840,840,840,840,839,840,839,839,838,839,840,
840,839,840,840,837,837,841,837,120,120,120,120,120,120,120,120,
842,842,842,842,842,842,842,842,842,842,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 176 */
843,843,843,843,843,843,843,843,843,843,843,843,843,843,843,843,
843,843,843,843,843,843,843,843,843,843,843,843,843,843,843,843,
843,843,843,843,843,843,843,843,843,843,843,843,843,843,843,844,
845,845,846,846,846,846,120,120,845,845,845,845,846,846,845,846,
846,847,847,847,847,847,847,847,847,847,847,847,847,847,847,847,
847,847,847,847,847,847,847,847,843,843,843,843,846,846,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 177 */
848,848,848,848,848,848,848,848,848,848,848,848,848,848,848,848,
848,848,848,848,848,848,848,848,848,848,848,848,848,848,848,848,
848,848,848,848,848,848,848,848,848,848,848,848,848,848,848,848,
849,849,849,850,850,850,850,850,850,850,850,849,849,850,849,850,
850,851,851,851,848,120,120,120,120,120,120,120,120,120,120,120,
852,852,852,852,852,852,852,852,852,852,120,120,120,120,120,120,
398,398,398,398,398,398,398,398,398,398,398,398,398,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 178 */
853,853,853,853,853,853,853,853,853,853,853,853,853,853,853,853,
853,853,853,853,853,853,853,853,853,853,853,853,853,853,853,853,
853,853,853,853,853,853,853,853,853,853,853,854,855,854,855,855,
854,854,854,854,854,854,855,854,853,856,120,120,120,120,120,120,
857,857,857,857,857,857,857,857,857,857,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 179 */
858,858,858,858,858,858,858,858,858,858,858,858,858,858,858,858,
858,858,858,858,858,858,858,858,858,858,858,120,120,859,859,859,
860,860,859,859,859,859,861,859,859,859,859,859,120,120,120,120,
862,862,862,862,862,862,862,862,862,862,863,863,864,864,864,865,
858,858,858,858,858,858,858,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 180 */
866,866,866,866,866,866,866,866,866,866,866,866,866,866,866,866,
866,866,866,866,866,866,866,866,866,866,866,866,866,866,866,866,
866,866,866,866,866,866,866,866,866,866,866,866,867,867,867,868,
868,868,868,868,868,868,868,868,867,868,868,869,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 181 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
870,870,870,870,870,870,870,870,870,870,870,870,870,870,870,870,
870,870,870,870,870,870,870,870,870,870,870,870,870,870,870,870,
871,871,871,871,871,871,871,871,871,871,871,871,871,871,871,871,
871,871,871,871,871,871,871,871,871,871,871,871,871,871,871,871,
872,872,872,872,872,872,872,872,872,872,873,873,873,873,873,873,
873,873,873,120,120,120,120,120,120,120,120,120,120,120,120,874,

/* block 182 */
875,875,875,875,875,875,875,120,120,875,120,120,875,875,875,875,
875,875,875,875,120,875,875,120,875,875,875,875,875,875,875,875,
875,875,875,875,875,875,875,875,875,875,875,875,875,875,875,875,
876,877,877,877,877,877,120,877,877,120,120,878,878,877,878,879,
877,879,877,878,880,880,880,120,120,120,120,120,120,120,120,120,
881,881,881,881,881,881,881,881,881,881,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 183 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
882,882,882,882,882,882,882,882,120,120,882,882,882,882,882,882,
882,882,882,882,882,882,882,882,882,882,882,882,882,882,882,882,
882,882,882,882,882,882,882,882,882,882,882,882,882,882,882,882,
882,883,883,883,884,884,884,884,120,120,884,884,883,883,883,883,
884,882,885,882,883,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 184 */
886,887,887,887,887,887,887,887,887,887,887,886,886,886,886,886,
886,886,886,886,886,886,886,886,886,886,886,886,886,886,886,886,
886,886,886,886,886,886,886,886,886,886,886,886,886,886,886,886,
886,886,886,887,887,887,887,887,887,888,889,887,887,887,887,890,
890,890,890,890,890,890,890,887,120,120,120,120,120,120,120,120,
891,892,892,892,892,892,892,893,893,892,892,892,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,

/* block 185 */
891,891,891,891,894,894,894,894,894,894,892,892,892,892,892,892,
892,892,892,892,892,892,892,893,892,892,895,895,895,891,895,895,
895,895,895,120,120,120,120,120,120,120,120,120,120,120,120,120,
370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,120,120,120,120,120,120,120,

/* block 186 */
897,897,897,897,897,897,897,897,897,120,897,897,897,897,897,897,
897,897,897,897,897,897,897,897,897,897,897,897,897,897,897,897,
897,897,897,897,897,897,897,897,897,897,897,897,897,897,897,898,
899,899,899,899,899,899,899,120,899,899,899,899,899,899,898,899,
897,900,900,900,900,900,120,120,120,120,120,120,120,120,120,120,
901,901,901,901,901,901,901,901,901,901,902,902,902,902,902,902,
902,902,902,902,902,902,902,902,902,902,902,902,902,120,120,120,
903,903,904,904,904,904,904,904,904,904,904,904,904,904,904,904,

/* block 187 */
904,904,904,904,904,904,904,904,904,904,904,904,904,904,904,904,
120,120,905,905,905,905,905,905,905,905,905,905,905,905,905,905,
905,905,905,905,905,905,905,905,120,906,905,905,905,905,905,905,
905,906,905,905,906,905,905,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 188 */
907,907,907,907,907,907,907,120,907,907,120,907,907,907,907,907,
907,907,907,907,907,907,907,907,907,907,907,907,907,907,907,907,
907,907,907,907,907,907,907,907,907,907,907,907,907,907,907,907,
907,908,908,908,908,908,908,120,120,120,908,120,908,908,120,908,
908,908,908,908,908,908,909,908,120,120,120,120,120,120,120,120,
910,910,910,910,910,910,910,910,910,910,120,120,120,120,120,120,
911,911,911,911,911,911,120,911,911,120,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,

/* block 189 */
911,911,911,911,911,911,911,911,911,911,912,912,912,912,912,120,
913,913,120,912,912,913,912,913,911,120,120,120,120,120,120,120,
914,914,914,914,914,914,914,914,914,914,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 190 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,915,
915,915,915,916,916,917,917,918,918,120,120,120,120,120,120,120,

/* block 191 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
595,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
919,919,919,919,919,919,919,919,919,919,919,919,919,919,919,919,
295,295,919,295,919,297,297,297,297,297,297,297,297,298,298,298,
298,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,120,120,120,120,120,120,120,120,120,120,120,120,120,920,

/* block 192 */
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,

/* block 193 */
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,921,921,921,921,921,921,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 194 */
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,
922,922,922,922,922,922,922,922,922,922,922,922,922,922,922,120,
923,923,923,923,923,120,120,120,120,120,120,120,120,120,120,120,

/* block 195 */
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,921,
921,921,921,921,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 196 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,924,
924,925,925,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 197 */
926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,
926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,
926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,
926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,
926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,
926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,
926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,
926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,

/* block 198 */
926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,
926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,
926,926,926,926,926,926,926,926,926,926,926,926,926,926,926,120,
927,927,927,927,927,927,927,927,927,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 199 */
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,

/* block 200 */
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,
928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,928,
928,928,928,928,928,928,928,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 201 */
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,

/* block 202 */
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,606,
606,606,606,606,606,606,606,606,606,120,120,120,120,120,120,120,
929,929,929,929,929,929,929,929,929,929,929,929,929,929,929,929,
929,929,929,929,929,929,929,929,929,929,929,929,929,929,929,120,
930,930,930,930,930,930,930,930,930,930,120,120,120,120,931,931,
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,

/* block 203 */
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,
932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,120,
933,933,933,933,933,933,933,933,933,933,120,120,120,120,120,120,
934,934,934,934,934,934,934,934,934,934,934,934,934,934,934,934,
934,934,934,934,934,934,934,934,934,934,934,934,934,934,120,120,
935,935,935,935,935,936,120,120,120,120,120,120,120,120,120,120,

/* block 204 */
937,937,937,937,937,937,937,937,937,937,937,937,937,937,937,937,
937,937,937,937,937,937,937,937,937,937,937,937,937,937,937,937,
937,937,937,937,937,937,937,937,937,937,937,937,937,937,937,937,
938,938,938,938,938,938,938,939,939,939,939,939,940,940,940,940,
941,941,941,941,939,940,120,120,120,120,120,120,120,120,120,120,
942,942,942,942,942,942,942,942,942,942,120,943,943,943,943,943,
943,943,120,937,937,937,937,937,937,937,937,937,937,937,937,937,
937,937,937,937,937,937,937,937,120,120,120,120,120,937,937,937,

/* block 205 */
937,937,937,937,937,937,937,937,937,937,937,937,937,937,937,937,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 206 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
944,944,944,944,944,944,944,944,944,944,944,944,944,944,944,944,
944,944,944,944,944,944,944,944,944,944,944,944,944,944,944,944,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,
945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,945,

/* block 207 */
946,946,946,946,946,946,946,946,946,946,946,946,946,946,946,946,
946,946,946,946,946,946,946,947,947,947,947,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 208 */
948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,
948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,
948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,
948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,948,
948,948,948,948,948,948,948,948,948,948,948,120,120,120,120,949,
948,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,
950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,
950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,950,

/* block 209 */
950,950,950,950,950,950,950,950,120,120,120,120,120,120,120,949,
949,949,949,951,951,951,951,951,951,951,951,951,951,951,951,951,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
952,953,954,562,955,120,120,120,120,120,120,120,120,120,120,120,
956,956,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 210 */
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,

/* block 211 */
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,957,
957,957,957,957,957,957,957,957,120,120,120,120,120,120,120,120,

/* block 212 */
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,

/* block 213 */
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,958,
958,958,958,958,958,958,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 214 */
957,957,957,957,957,957,957,957,957,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 215 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
584,584,584,584,120,584,584,584,584,584,584,584,120,584,584,120,

/* block 216 */
583,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,

/* block 217 */
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,

/* block 218 */
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,578,
583,583,583,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
578,578,578,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,583,583,583,583,120,120,120,120,120,120,120,120,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,

/* block 219 */
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,

/* block 220 */
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,959,
959,959,959,959,959,959,959,959,959,959,959,959,120,120,120,120,

/* block 221 */
960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,
960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,
960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,
960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,
960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,
960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,
960,960,960,960,960,960,960,960,960,960,960,120,120,120,120,120,
960,960,960,960,960,960,960,960,960,960,960,960,960,120,120,120,

/* block 222 */
960,960,960,960,960,960,960,960,960,120,120,120,120,120,120,120,
960,960,960,960,960,960,960,960,960,960,120,120,961,962,962,963,
964,964,964,964,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 223 */
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,120,120,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,120,120,120,120,120,120,120,120,120,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 224 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 225 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20,120,120,120,120,120,120,120,120,120,120,

/* block 226 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20,120,120, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20,965,966,113,113,113, 20, 20, 20,966,965,965,
965,965,965, 24, 24, 24, 24, 24, 24, 24, 24,113,113,113,113,113,

/* block 227 */
113,113,113, 20, 20,113,113,113,113,113,113,113, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,113,113,113,113, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 228 */
692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,
692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,
692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,
692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,692,
692,692,967,967,967,692,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 229 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 230 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20,120,120,120,120,120,120,120,120,120,
587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,587,
587,587, 25, 25, 25, 25, 25, 25, 25,120,120,120,120,120,120,120,

/* block 231 */
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,518,518,518,518,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,519,519,
519,519,519,519,519,120,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,

/* block 232 */
518,518,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,518,120,518,518,
120,120,518,120,120,518,518,120,120,518,518,518,518,120,518,518,
518,518,518,518,518,518,519,519,519,519,120,519,120,519,519,519,
519,519,519,519,120,519,519,519,519,519,519,519,519,519,519,519,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,

/* block 233 */
519,519,519,519,518,518,120,518,518,518,518,120,120,518,518,518,
518,518,518,518,518,120,518,518,518,518,518,518,518,120,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,518,518,120,518,518,518,518,120,
518,518,518,518,518,120,518,120,120,120,518,518,518,518,518,518,
518,120,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,

/* block 234 */
518,518,518,518,518,518,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,518,518,518,518,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,

/* block 235 */
519,519,519,519,519,519,519,519,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,
518,518,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,

/* block 236 */
518,518,518,518,518,518,518,518,518,518,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,519,120,120,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,
518,  9,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,  9,519,519,519,519,
519,519,518,518,518,518,518,518,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,518,  9,519,519,519,519,

/* block 237 */
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,  9,519,519,519,519,519,519,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,
518,518,518,518,518,  9,519,519,519,519,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,  9,
519,519,519,519,519,519,518,518,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,  9,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,

/* block 238 */
519,519,519,519,519,519,519,519,519,  9,519,519,519,519,519,519,
518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,518,
518,518,518,518,518,518,518,518,518,  9,519,519,519,519,519,519,
519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,519,
519,519,519,  9,519,519,519,519,519,519,518,519,120,120, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,

/* block 239 */
968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,
968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,
968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,
968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,
968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,
968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,
968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,
968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,

/* block 240 */
969,969,969,969,969,969,969,969,969,969,969,969,969,969,969,969,
969,969,969,969,969,969,969,969,969,969,969,969,969,969,969,969,
969,969,969,969,969,969,969,969,969,969,969,969,969,969,969,969,
969,969,969,969,969,969,969,968,968,968,968,969,969,969,969,969,
969,969,969,969,969,969,969,969,969,969,969,969,969,969,969,969,
969,969,969,969,969,969,969,969,969,969,969,969,969,969,969,969,
969,969,969,969,969,969,969,969,969,969,969,969,969,968,968,968,
968,968,968,968,968,969,968,968,968,968,968,968,968,968,968,968,

/* block 241 */
968,968,968,968,969,968,968,970,970,970,970,970,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,969,969,969,969,969,
120,969,969,969,969,969,969,969,969,969,969,969,969,969,969,969,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 242 */
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 22, 35, 35, 35, 35, 35,
 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 243 */
971,971,971,971,971,971,971,120,971,971,971,971,971,971,971,971,
971,971,971,971,971,971,971,971,971,120,120,971,971,971,971,971,
971,971,120,971,971,120,971,971,971,971,971,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 244 */
972,972,972,972,972,972,972,972,972,972,972,972,972,972,972,972,
972,972,972,972,972,972,972,972,972,972,972,972,972,972,972,972,
972,972,972,972,972,972,972,972,972,972,972,972,972,120,120,120,
973,973,973,973,973,973,973,974,974,974,974,974,974,974,120,120,
975,975,975,975,975,975,975,975,975,975,120,120,120,120,972,976,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 245 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
977,977,977,977,977,977,977,977,977,977,977,977,977,977,977,977,
977,977,977,977,977,977,977,977,977,977,977,977,977,977,978,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
979,979,979,979,979,979,979,979,979,979,979,979,979,979,979,979,
979,979,979,979,979,979,979,979,979,979,979,979,979,979,979,979,
979,979,979,979,979,979,979,979,979,979,979,979,980,980,980,980,
981,981,981,981,981,981,981,981,981,981,120,120,120,120,120,982,

/* block 246 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
361,361,361,361,361,361,361,120,361,361,361,361,120,361,361,120,
361,361,361,361,361,361,361,361,361,361,361,361,361,361,361,120,

/* block 247 */
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,

/* block 248 */
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,
983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,983,
983,983,983,983,983,120,120,984,984,984,984,984,984,984,984,984,
985,985,985,985,985,985,985,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 249 */
986,986,986,986,986,986,986,986,986,986,986,986,986,986,986,986,
986,986,986,986,986,986,986,986,986,986,986,986,986,986,986,986,
986,986,987,987,987,987,987,987,987,987,987,987,987,987,987,987,
987,987,987,987,987,987,987,987,987,987,987,987,987,987,987,987,
987,987,987,987,988,988,988,988,988,988,988,989,120,120,120,120,
990,990,990,990,990,990,990,990,990,990,120,120,120,120,991,991,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 250 */
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,

/* block 251 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 25, 25, 25,
  6, 25, 25, 25, 25,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 252 */
120, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 25,
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 253 */
225,225,225,225,120,225,225,225,225,225,225,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,225,
120,225,225,120,225,120,120,225,120,225,225,225,225,225,225,225,
225,225,225,120,225,225,225,225,120,225,120,225,120,120,120,120,
120,120,225,120,120,120,120,225,120,225,120,225,120,225,225,225,
120,225,225,120,225,120,120,225,120,225,120,225,120,225,120,225,
120,225,225,120,225,120,120,225,225,225,225,120,225,225,225,225,
225,225,225,120,225,225,225,225,120,225,225,225,225,120,225,120,

/* block 254 */
225,225,225,225,225,225,225,225,225,225,120,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,120,120,120,120,
120,225,225,225,120,225,225,225,225,225,120,225,225,225,225,225,
225,225,225,225,225,225,225,225,225,225,225,225,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
217,217,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 255 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,992,992,992,992,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 256 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21,992,992,992,992,992,992,992,992,992,992,992,992,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,992,
992, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
992, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
992, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21,992,992,992,992,992,992,992,992,992,992,

/* block 257 */
 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 21, 21, 21,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21,
 21, 21, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21,

/* block 258 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 20,
 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,993,993,993,993,993,993,993,993,993,993,
993,993,993,993,993,993,993,993,993,993,993,993,993,993,993,993,

/* block 259 */
994, 21, 21,992,992,992,992,992,992,992,992,992,992,992,992,992,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21,
 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20,992,992,992,992,
 20, 20, 20, 20, 20, 20, 20, 20, 20,992,992,992,992,992,992,992,
589,589,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
 21, 21, 21, 21, 21, 21,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,

/* block 260 */
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,

/* block 261 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 262 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,995,995,995,995,995,

/* block 263 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20,
 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 264 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 265 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21,992,992,992,992,992, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,992,992,992,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,992,992,992,

/* block 266 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20,992,992,992,992,992,992,992,992,992,992,992,992,

/* block 267 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 21, 21, 21, 21,992,992,992,992,992,992,992,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,992,992,992,992,
 21,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,

/* block 268 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,992,992,992,992,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20,992,992,992,992,992,992,992,992,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,992,992,992,992,992,992,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,

/* block 269 */
 20, 20, 20, 20, 20, 20, 20, 20,992,992,992,992,992,992,992,992,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,992,992,
 21, 21,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,

/* block 270 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,

/* block 271 */
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21,992,992,992,992,992,992,992,992,992,992,992,992,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,992,992,
 21, 21, 21, 21, 21,992,992,992, 21, 21, 21, 21, 21,992,992,992,

/* block 272 */
 21, 21, 21, 21, 21, 21, 21,992,992,992,992,992,992,992,992,992,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,992,992,992,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,992,992,992,992,992,
 21, 21, 21, 21, 21, 21,992,992,992,992,992,992,992,992,992,992,
 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,992,992,992,992,992,992,
 21, 21, 21, 21, 21, 21, 21, 21,992,992,992,992,992,992,992,992,
 21, 21, 21, 21, 21, 21, 21,992,992,992,992,992,992,992,992,992,

/* block 273 */
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20,120, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,120,120,120,120,120,120,

/* block 274 */
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,992,
992,992,992,992,992,992,992,992,992,992,992,992,992,992,120,120,

/* block 275 */
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 276 */
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,120,120,120,120,120,120,120,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,

/* block 277 */
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,120,120,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,

/* block 278 */
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,

/* block 279 */
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 280 */
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 281 */
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,

/* block 282 */
516, 24,516,516,516,516,516,516,516,516,516,516,516,516,516,516,
516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,
996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,
996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,
996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,
996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,
996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,
996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,996,

/* block 283 */
516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,
516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,
516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,
516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,
516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,
516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,
516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,
516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,

/* block 284 */
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,

/* block 285 */
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,516,

/* block 286 */
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,678,
678,678,678,678,678,678,678,678,678,678,678,678,678,678,120,120,

};

#if UCD_BLOCK_SIZE != 128
#error Please correct UCD_BLOCK_SIZE in pcre2_internal.h
#endif
#endif  /* SUPPORT_UNICODE */

#endif  /* PCRE2_PCRE2TEST */
