# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from azure.profiles import KnownProfiles, ProfileDefinition
from azure.profiles.multiapiclient import MultiApiClientMixin

from ._configuration import ComputeManagementClientConfiguration
from ._serialization import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential

class _SDKClient(object):
    def __init__(self, *args, **kwargs):
        """This is a fake class to support current implemetation of MultiApiClientMixin."
        Will be removed in final version of multiapi azure-core based client
        """
        pass

class ComputeManagementClient(MultiApiClientMixin, _SDKClient):
    """Compute Client.

    This ready contains multiple API versions, to help you deal with all of the Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, it uses the latest API version available on public Azure.
    For production, you should stick to a particular api-version and/or profile.
    The profile sets a mapping between an operation group and its API version.
    The api-version parameter sets the default API version if the operation
    group is not described in the profile.

    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: Subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms part of the URI for every service call. Required.
    :type subscription_id: str
    :param api_version: API version to use if no profile is provided, or if missing in profile.
    :type api_version: str
    :param base_url: Service URL
    :type base_url: str
    :param profile: A profile definition, from KnownProfiles to dict.
    :type profile: azure.profiles.KnownProfiles
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    DEFAULT_API_VERSION = '2022-08-01'
    _PROFILE_TAG = "azure.mgmt.compute.ComputeManagementClient"
    LATEST_PROFILE = ProfileDefinition({
        _PROFILE_TAG: {
            None: DEFAULT_API_VERSION,
            'cloud_service_operating_systems': '2022-04-04',
            'cloud_service_role_instances': '2022-04-04',
            'cloud_service_roles': '2022-04-04',
            'cloud_services': '2022-04-04',
            'cloud_services_update_domain': '2022-04-04',
            'community_galleries': '2022-03-03',
            'community_gallery_image_versions': '2022-03-03',
            'community_gallery_images': '2022-03-03',
            'disk_accesses': '2022-07-02',
            'disk_encryption_sets': '2022-07-02',
            'disk_restore_point': '2022-07-02',
            'disks': '2022-07-02',
            'galleries': '2022-03-03',
            'gallery_application_versions': '2022-03-03',
            'gallery_applications': '2022-03-03',
            'gallery_image_versions': '2022-03-03',
            'gallery_images': '2022-03-03',
            'gallery_sharing_profile': '2022-03-03',
            'resource_skus': '2021-07-01',
            'shared_galleries': '2022-03-03',
            'shared_gallery_image_versions': '2022-03-03',
            'shared_gallery_images': '2022-03-03',
            'snapshots': '2022-07-02',
        }},
        _PROFILE_TAG + " latest"
    )

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        api_version=None, # type: Optional[str]
        base_url: str = "https://management.azure.com",
        profile=KnownProfiles.default, # type: KnownProfiles
        **kwargs  # type: Any
    ):
        self._config = ComputeManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)
        super(ComputeManagementClient, self).__init__(
            api_version=api_version,
            profile=profile
        )

    @classmethod
    def _models_dict(cls, api_version):
        return {k: v for k, v in cls.models(api_version).__dict__.items() if isinstance(v, type)}

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2015-06-15: :mod:`v2015_06_15.models<azure.mgmt.compute.v2015_06_15.models>`
           * 2016-03-30: :mod:`v2016_03_30.models<azure.mgmt.compute.v2016_03_30.models>`
           * 2016-04-30-preview: :mod:`v2016_04_30_preview.models<azure.mgmt.compute.v2016_04_30_preview.models>`
           * 2017-03-30: :mod:`v2017_03_30.models<azure.mgmt.compute.v2017_03_30.models>`
           * 2017-09-01: :mod:`v2017_09_01.models<azure.mgmt.compute.v2017_09_01.models>`
           * 2017-12-01: :mod:`v2017_12_01.models<azure.mgmt.compute.v2017_12_01.models>`
           * 2018-04-01: :mod:`v2018_04_01.models<azure.mgmt.compute.v2018_04_01.models>`
           * 2018-06-01: :mod:`v2018_06_01.models<azure.mgmt.compute.v2018_06_01.models>`
           * 2018-09-30: :mod:`v2018_09_30.models<azure.mgmt.compute.v2018_09_30.models>`
           * 2018-10-01: :mod:`v2018_10_01.models<azure.mgmt.compute.v2018_10_01.models>`
           * 2019-03-01: :mod:`v2019_03_01.models<azure.mgmt.compute.v2019_03_01.models>`
           * 2019-04-01: :mod:`v2019_04_01.models<azure.mgmt.compute.v2019_04_01.models>`
           * 2019-07-01: :mod:`v2019_07_01.models<azure.mgmt.compute.v2019_07_01.models>`
           * 2019-11-01: :mod:`v2019_11_01.models<azure.mgmt.compute.v2019_11_01.models>`
           * 2019-12-01: :mod:`v2019_12_01.models<azure.mgmt.compute.v2019_12_01.models>`
           * 2020-05-01: :mod:`v2020_05_01.models<azure.mgmt.compute.v2020_05_01.models>`
           * 2020-06-01: :mod:`v2020_06_01.models<azure.mgmt.compute.v2020_06_01.models>`
           * 2020-06-30: :mod:`v2020_06_30.models<azure.mgmt.compute.v2020_06_30.models>`
           * 2020-09-30: :mod:`v2020_09_30.models<azure.mgmt.compute.v2020_09_30.models>`
           * 2020-10-01-preview: :mod:`v2020_10_01_preview.models<azure.mgmt.compute.v2020_10_01_preview.models>`
           * 2020-12-01: :mod:`v2020_12_01.models<azure.mgmt.compute.v2020_12_01.models>`
           * 2021-03-01: :mod:`v2021_03_01.models<azure.mgmt.compute.v2021_03_01.models>`
           * 2021-04-01: :mod:`v2021_04_01.models<azure.mgmt.compute.v2021_04_01.models>`
           * 2021-07-01: :mod:`v2021_07_01.models<azure.mgmt.compute.v2021_07_01.models>`
           * 2021-08-01: :mod:`v2021_08_01.models<azure.mgmt.compute.v2021_08_01.models>`
           * 2021-10-01: :mod:`v2021_10_01.models<azure.mgmt.compute.v2021_10_01.models>`
           * 2021-11-01: :mod:`v2021_11_01.models<azure.mgmt.compute.v2021_11_01.models>`
           * 2021-12-01: :mod:`v2021_12_01.models<azure.mgmt.compute.v2021_12_01.models>`
           * 2022-01-03: :mod:`v2022_01_03.models<azure.mgmt.compute.v2022_01_03.models>`
           * 2022-03-01: :mod:`v2022_03_01.models<azure.mgmt.compute.v2022_03_01.models>`
           * 2022-03-02: :mod:`v2022_03_02.models<azure.mgmt.compute.v2022_03_02.models>`
           * 2022-03-03: :mod:`v2022_03_03.models<azure.mgmt.compute.v2022_03_03.models>`
           * 2022-04-04: :mod:`v2022_04_04.models<azure.mgmt.compute.v2022_04_04.models>`
           * 2022-07-02: :mod:`v2022_07_02.models<azure.mgmt.compute.v2022_07_02.models>`
           * 2022-08-01: :mod:`v2022_08_01.models<azure.mgmt.compute.v2022_08_01.models>`
        """
        if api_version == '2015-06-15':
            from .v2015_06_15 import models
            return models
        elif api_version == '2016-03-30':
            from .v2016_03_30 import models
            return models
        elif api_version == '2016-04-30-preview':
            from .v2016_04_30_preview import models
            return models
        elif api_version == '2017-03-30':
            from .v2017_03_30 import models
            return models
        elif api_version == '2017-09-01':
            from .v2017_09_01 import models
            return models
        elif api_version == '2017-12-01':
            from .v2017_12_01 import models
            return models
        elif api_version == '2018-04-01':
            from .v2018_04_01 import models
            return models
        elif api_version == '2018-06-01':
            from .v2018_06_01 import models
            return models
        elif api_version == '2018-09-30':
            from .v2018_09_30 import models
            return models
        elif api_version == '2018-10-01':
            from .v2018_10_01 import models
            return models
        elif api_version == '2019-03-01':
            from .v2019_03_01 import models
            return models
        elif api_version == '2019-04-01':
            from .v2019_04_01 import models
            return models
        elif api_version == '2019-07-01':
            from .v2019_07_01 import models
            return models
        elif api_version == '2019-11-01':
            from .v2019_11_01 import models
            return models
        elif api_version == '2019-12-01':
            from .v2019_12_01 import models
            return models
        elif api_version == '2020-05-01':
            from .v2020_05_01 import models
            return models
        elif api_version == '2020-06-01':
            from .v2020_06_01 import models
            return models
        elif api_version == '2020-06-30':
            from .v2020_06_30 import models
            return models
        elif api_version == '2020-09-30':
            from .v2020_09_30 import models
            return models
        elif api_version == '2020-10-01-preview':
            from .v2020_10_01_preview import models
            return models
        elif api_version == '2020-12-01':
            from .v2020_12_01 import models
            return models
        elif api_version == '2021-03-01':
            from .v2021_03_01 import models
            return models
        elif api_version == '2021-04-01':
            from .v2021_04_01 import models
            return models
        elif api_version == '2021-07-01':
            from .v2021_07_01 import models
            return models
        elif api_version == '2021-08-01':
            from .v2021_08_01 import models
            return models
        elif api_version == '2021-10-01':
            from .v2021_10_01 import models
            return models
        elif api_version == '2021-11-01':
            from .v2021_11_01 import models
            return models
        elif api_version == '2021-12-01':
            from .v2021_12_01 import models
            return models
        elif api_version == '2022-01-03':
            from .v2022_01_03 import models
            return models
        elif api_version == '2022-03-01':
            from .v2022_03_01 import models
            return models
        elif api_version == '2022-03-02':
            from .v2022_03_02 import models
            return models
        elif api_version == '2022-03-03':
            from .v2022_03_03 import models
            return models
        elif api_version == '2022-04-04':
            from .v2022_04_04 import models
            return models
        elif api_version == '2022-07-02':
            from .v2022_07_02 import models
            return models
        elif api_version == '2022-08-01':
            from .v2022_08_01 import models
            return models
        raise ValueError("API version {} is not available".format(api_version))

    @property
    def availability_sets(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2015_06_15.operations.AvailabilitySetsOperations>`
           * 2016-03-30: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2016_03_30.operations.AvailabilitySetsOperations>`
           * 2016-04-30-preview: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2016_04_30_preview.operations.AvailabilitySetsOperations>`
           * 2017-03-30: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2017_03_30.operations.AvailabilitySetsOperations>`
           * 2017-12-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2017_12_01.operations.AvailabilitySetsOperations>`
           * 2018-04-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2018_04_01.operations.AvailabilitySetsOperations>`
           * 2018-06-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2018_06_01.operations.AvailabilitySetsOperations>`
           * 2018-10-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2018_10_01.operations.AvailabilitySetsOperations>`
           * 2019-03-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2019_03_01.operations.AvailabilitySetsOperations>`
           * 2019-07-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2019_07_01.operations.AvailabilitySetsOperations>`
           * 2019-12-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2019_12_01.operations.AvailabilitySetsOperations>`
           * 2020-06-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2020_06_01.operations.AvailabilitySetsOperations>`
           * 2020-12-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2020_12_01.operations.AvailabilitySetsOperations>`
           * 2021-03-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2021_03_01.operations.AvailabilitySetsOperations>`
           * 2021-04-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2021_04_01.operations.AvailabilitySetsOperations>`
           * 2021-07-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2021_07_01.operations.AvailabilitySetsOperations>`
           * 2021-11-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2021_11_01.operations.AvailabilitySetsOperations>`
           * 2022-03-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2022_03_01.operations.AvailabilitySetsOperations>`
           * 2022-08-01: :class:`AvailabilitySetsOperations<azure.mgmt.compute.v2022_08_01.operations.AvailabilitySetsOperations>`
        """
        api_version = self._get_api_version('availability_sets')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2016-03-30':
            from .v2016_03_30.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import AvailabilitySetsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import AvailabilitySetsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'availability_sets'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def capacity_reservation_groups(self):
        """Instance depends on the API version:

           * 2021-04-01: :class:`CapacityReservationGroupsOperations<azure.mgmt.compute.v2021_04_01.operations.CapacityReservationGroupsOperations>`
           * 2021-07-01: :class:`CapacityReservationGroupsOperations<azure.mgmt.compute.v2021_07_01.operations.CapacityReservationGroupsOperations>`
           * 2021-11-01: :class:`CapacityReservationGroupsOperations<azure.mgmt.compute.v2021_11_01.operations.CapacityReservationGroupsOperations>`
           * 2022-03-01: :class:`CapacityReservationGroupsOperations<azure.mgmt.compute.v2022_03_01.operations.CapacityReservationGroupsOperations>`
           * 2022-08-01: :class:`CapacityReservationGroupsOperations<azure.mgmt.compute.v2022_08_01.operations.CapacityReservationGroupsOperations>`
        """
        api_version = self._get_api_version('capacity_reservation_groups')
        if api_version == '2021-04-01':
            from .v2021_04_01.operations import CapacityReservationGroupsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import CapacityReservationGroupsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import CapacityReservationGroupsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import CapacityReservationGroupsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import CapacityReservationGroupsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'capacity_reservation_groups'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def capacity_reservations(self):
        """Instance depends on the API version:

           * 2021-04-01: :class:`CapacityReservationsOperations<azure.mgmt.compute.v2021_04_01.operations.CapacityReservationsOperations>`
           * 2021-07-01: :class:`CapacityReservationsOperations<azure.mgmt.compute.v2021_07_01.operations.CapacityReservationsOperations>`
           * 2021-11-01: :class:`CapacityReservationsOperations<azure.mgmt.compute.v2021_11_01.operations.CapacityReservationsOperations>`
           * 2022-03-01: :class:`CapacityReservationsOperations<azure.mgmt.compute.v2022_03_01.operations.CapacityReservationsOperations>`
           * 2022-08-01: :class:`CapacityReservationsOperations<azure.mgmt.compute.v2022_08_01.operations.CapacityReservationsOperations>`
        """
        api_version = self._get_api_version('capacity_reservations')
        if api_version == '2021-04-01':
            from .v2021_04_01.operations import CapacityReservationsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import CapacityReservationsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import CapacityReservationsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import CapacityReservationsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import CapacityReservationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'capacity_reservations'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def cloud_service_operating_systems(self):
        """Instance depends on the API version:

           * 2021-03-01: :class:`CloudServiceOperatingSystemsOperations<azure.mgmt.compute.v2021_03_01.operations.CloudServiceOperatingSystemsOperations>`
           * 2022-04-04: :class:`CloudServiceOperatingSystemsOperations<azure.mgmt.compute.v2022_04_04.operations.CloudServiceOperatingSystemsOperations>`
        """
        api_version = self._get_api_version('cloud_service_operating_systems')
        if api_version == '2021-03-01':
            from .v2021_03_01.operations import CloudServiceOperatingSystemsOperations as OperationClass
        elif api_version == '2022-04-04':
            from .v2022_04_04.operations import CloudServiceOperatingSystemsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'cloud_service_operating_systems'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def cloud_service_role_instances(self):
        """Instance depends on the API version:

           * 2020-10-01-preview: :class:`CloudServiceRoleInstancesOperations<azure.mgmt.compute.v2020_10_01_preview.operations.CloudServiceRoleInstancesOperations>`
           * 2021-03-01: :class:`CloudServiceRoleInstancesOperations<azure.mgmt.compute.v2021_03_01.operations.CloudServiceRoleInstancesOperations>`
           * 2022-04-04: :class:`CloudServiceRoleInstancesOperations<azure.mgmt.compute.v2022_04_04.operations.CloudServiceRoleInstancesOperations>`
        """
        api_version = self._get_api_version('cloud_service_role_instances')
        if api_version == '2020-10-01-preview':
            from .v2020_10_01_preview.operations import CloudServiceRoleInstancesOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import CloudServiceRoleInstancesOperations as OperationClass
        elif api_version == '2022-04-04':
            from .v2022_04_04.operations import CloudServiceRoleInstancesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'cloud_service_role_instances'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def cloud_service_roles(self):
        """Instance depends on the API version:

           * 2020-10-01-preview: :class:`CloudServiceRolesOperations<azure.mgmt.compute.v2020_10_01_preview.operations.CloudServiceRolesOperations>`
           * 2021-03-01: :class:`CloudServiceRolesOperations<azure.mgmt.compute.v2021_03_01.operations.CloudServiceRolesOperations>`
           * 2022-04-04: :class:`CloudServiceRolesOperations<azure.mgmt.compute.v2022_04_04.operations.CloudServiceRolesOperations>`
        """
        api_version = self._get_api_version('cloud_service_roles')
        if api_version == '2020-10-01-preview':
            from .v2020_10_01_preview.operations import CloudServiceRolesOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import CloudServiceRolesOperations as OperationClass
        elif api_version == '2022-04-04':
            from .v2022_04_04.operations import CloudServiceRolesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'cloud_service_roles'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def cloud_services(self):
        """Instance depends on the API version:

           * 2020-10-01-preview: :class:`CloudServicesOperations<azure.mgmt.compute.v2020_10_01_preview.operations.CloudServicesOperations>`
           * 2021-03-01: :class:`CloudServicesOperations<azure.mgmt.compute.v2021_03_01.operations.CloudServicesOperations>`
           * 2022-04-04: :class:`CloudServicesOperations<azure.mgmt.compute.v2022_04_04.operations.CloudServicesOperations>`
        """
        api_version = self._get_api_version('cloud_services')
        if api_version == '2020-10-01-preview':
            from .v2020_10_01_preview.operations import CloudServicesOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import CloudServicesOperations as OperationClass
        elif api_version == '2022-04-04':
            from .v2022_04_04.operations import CloudServicesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'cloud_services'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def cloud_services_update_domain(self):
        """Instance depends on the API version:

           * 2020-10-01-preview: :class:`CloudServicesUpdateDomainOperations<azure.mgmt.compute.v2020_10_01_preview.operations.CloudServicesUpdateDomainOperations>`
           * 2021-03-01: :class:`CloudServicesUpdateDomainOperations<azure.mgmt.compute.v2021_03_01.operations.CloudServicesUpdateDomainOperations>`
           * 2022-04-04: :class:`CloudServicesUpdateDomainOperations<azure.mgmt.compute.v2022_04_04.operations.CloudServicesUpdateDomainOperations>`
        """
        api_version = self._get_api_version('cloud_services_update_domain')
        if api_version == '2020-10-01-preview':
            from .v2020_10_01_preview.operations import CloudServicesUpdateDomainOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import CloudServicesUpdateDomainOperations as OperationClass
        elif api_version == '2022-04-04':
            from .v2022_04_04.operations import CloudServicesUpdateDomainOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'cloud_services_update_domain'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def community_galleries(self):
        """Instance depends on the API version:

           * 2021-07-01: :class:`CommunityGalleriesOperations<azure.mgmt.compute.v2021_07_01.operations.CommunityGalleriesOperations>`
           * 2022-01-03: :class:`CommunityGalleriesOperations<azure.mgmt.compute.v2022_01_03.operations.CommunityGalleriesOperations>`
           * 2022-03-03: :class:`CommunityGalleriesOperations<azure.mgmt.compute.v2022_03_03.operations.CommunityGalleriesOperations>`
        """
        api_version = self._get_api_version('community_galleries')
        if api_version == '2021-07-01':
            from .v2021_07_01.operations import CommunityGalleriesOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import CommunityGalleriesOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import CommunityGalleriesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'community_galleries'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def community_gallery_image_versions(self):
        """Instance depends on the API version:

           * 2021-07-01: :class:`CommunityGalleryImageVersionsOperations<azure.mgmt.compute.v2021_07_01.operations.CommunityGalleryImageVersionsOperations>`
           * 2022-01-03: :class:`CommunityGalleryImageVersionsOperations<azure.mgmt.compute.v2022_01_03.operations.CommunityGalleryImageVersionsOperations>`
           * 2022-03-03: :class:`CommunityGalleryImageVersionsOperations<azure.mgmt.compute.v2022_03_03.operations.CommunityGalleryImageVersionsOperations>`
        """
        api_version = self._get_api_version('community_gallery_image_versions')
        if api_version == '2021-07-01':
            from .v2021_07_01.operations import CommunityGalleryImageVersionsOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import CommunityGalleryImageVersionsOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import CommunityGalleryImageVersionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'community_gallery_image_versions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def community_gallery_images(self):
        """Instance depends on the API version:

           * 2021-07-01: :class:`CommunityGalleryImagesOperations<azure.mgmt.compute.v2021_07_01.operations.CommunityGalleryImagesOperations>`
           * 2022-01-03: :class:`CommunityGalleryImagesOperations<azure.mgmt.compute.v2022_01_03.operations.CommunityGalleryImagesOperations>`
           * 2022-03-03: :class:`CommunityGalleryImagesOperations<azure.mgmt.compute.v2022_03_03.operations.CommunityGalleryImagesOperations>`
        """
        api_version = self._get_api_version('community_gallery_images')
        if api_version == '2021-07-01':
            from .v2021_07_01.operations import CommunityGalleryImagesOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import CommunityGalleryImagesOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import CommunityGalleryImagesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'community_gallery_images'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def dedicated_host_groups(self):
        """Instance depends on the API version:

           * 2019-03-01: :class:`DedicatedHostGroupsOperations<azure.mgmt.compute.v2019_03_01.operations.DedicatedHostGroupsOperations>`
           * 2019-07-01: :class:`DedicatedHostGroupsOperations<azure.mgmt.compute.v2019_07_01.operations.DedicatedHostGroupsOperations>`
           * 2019-12-01: :class:`DedicatedHostGroupsOperations<azure.mgmt.compute.v2019_12_01.operations.DedicatedHostGroupsOperations>`
           * 2020-06-01: :class:`DedicatedHostGroupsOperations<azure.mgmt.compute.v2020_06_01.operations.DedicatedHostGroupsOperations>`
           * 2020-12-01: :class:`DedicatedHostGroupsOperations<azure.mgmt.compute.v2020_12_01.operations.DedicatedHostGroupsOperations>`
           * 2021-03-01: :class:`DedicatedHostGroupsOperations<azure.mgmt.compute.v2021_03_01.operations.DedicatedHostGroupsOperations>`
           * 2021-04-01: :class:`DedicatedHostGroupsOperations<azure.mgmt.compute.v2021_04_01.operations.DedicatedHostGroupsOperations>`
           * 2021-07-01: :class:`DedicatedHostGroupsOperations<azure.mgmt.compute.v2021_07_01.operations.DedicatedHostGroupsOperations>`
           * 2021-11-01: :class:`DedicatedHostGroupsOperations<azure.mgmt.compute.v2021_11_01.operations.DedicatedHostGroupsOperations>`
           * 2022-03-01: :class:`DedicatedHostGroupsOperations<azure.mgmt.compute.v2022_03_01.operations.DedicatedHostGroupsOperations>`
           * 2022-08-01: :class:`DedicatedHostGroupsOperations<azure.mgmt.compute.v2022_08_01.operations.DedicatedHostGroupsOperations>`
        """
        api_version = self._get_api_version('dedicated_host_groups')
        if api_version == '2019-03-01':
            from .v2019_03_01.operations import DedicatedHostGroupsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import DedicatedHostGroupsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import DedicatedHostGroupsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import DedicatedHostGroupsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import DedicatedHostGroupsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import DedicatedHostGroupsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import DedicatedHostGroupsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import DedicatedHostGroupsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import DedicatedHostGroupsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import DedicatedHostGroupsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import DedicatedHostGroupsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'dedicated_host_groups'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def dedicated_hosts(self):
        """Instance depends on the API version:

           * 2019-03-01: :class:`DedicatedHostsOperations<azure.mgmt.compute.v2019_03_01.operations.DedicatedHostsOperations>`
           * 2019-07-01: :class:`DedicatedHostsOperations<azure.mgmt.compute.v2019_07_01.operations.DedicatedHostsOperations>`
           * 2019-12-01: :class:`DedicatedHostsOperations<azure.mgmt.compute.v2019_12_01.operations.DedicatedHostsOperations>`
           * 2020-06-01: :class:`DedicatedHostsOperations<azure.mgmt.compute.v2020_06_01.operations.DedicatedHostsOperations>`
           * 2020-12-01: :class:`DedicatedHostsOperations<azure.mgmt.compute.v2020_12_01.operations.DedicatedHostsOperations>`
           * 2021-03-01: :class:`DedicatedHostsOperations<azure.mgmt.compute.v2021_03_01.operations.DedicatedHostsOperations>`
           * 2021-04-01: :class:`DedicatedHostsOperations<azure.mgmt.compute.v2021_04_01.operations.DedicatedHostsOperations>`
           * 2021-07-01: :class:`DedicatedHostsOperations<azure.mgmt.compute.v2021_07_01.operations.DedicatedHostsOperations>`
           * 2021-11-01: :class:`DedicatedHostsOperations<azure.mgmt.compute.v2021_11_01.operations.DedicatedHostsOperations>`
           * 2022-03-01: :class:`DedicatedHostsOperations<azure.mgmt.compute.v2022_03_01.operations.DedicatedHostsOperations>`
           * 2022-08-01: :class:`DedicatedHostsOperations<azure.mgmt.compute.v2022_08_01.operations.DedicatedHostsOperations>`
        """
        api_version = self._get_api_version('dedicated_hosts')
        if api_version == '2019-03-01':
            from .v2019_03_01.operations import DedicatedHostsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import DedicatedHostsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import DedicatedHostsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import DedicatedHostsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import DedicatedHostsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import DedicatedHostsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import DedicatedHostsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import DedicatedHostsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import DedicatedHostsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import DedicatedHostsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import DedicatedHostsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'dedicated_hosts'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def disk_accesses(self):
        """Instance depends on the API version:

           * 2020-05-01: :class:`DiskAccessesOperations<azure.mgmt.compute.v2020_05_01.operations.DiskAccessesOperations>`
           * 2020-06-30: :class:`DiskAccessesOperations<azure.mgmt.compute.v2020_06_30.operations.DiskAccessesOperations>`
           * 2020-09-30: :class:`DiskAccessesOperations<azure.mgmt.compute.v2020_09_30.operations.DiskAccessesOperations>`
           * 2020-12-01: :class:`DiskAccessesOperations<azure.mgmt.compute.v2020_12_01.operations.DiskAccessesOperations>`
           * 2021-04-01: :class:`DiskAccessesOperations<azure.mgmt.compute.v2021_04_01.operations.DiskAccessesOperations>`
           * 2021-08-01: :class:`DiskAccessesOperations<azure.mgmt.compute.v2021_08_01.operations.DiskAccessesOperations>`
           * 2021-12-01: :class:`DiskAccessesOperations<azure.mgmt.compute.v2021_12_01.operations.DiskAccessesOperations>`
           * 2022-03-02: :class:`DiskAccessesOperations<azure.mgmt.compute.v2022_03_02.operations.DiskAccessesOperations>`
           * 2022-07-02: :class:`DiskAccessesOperations<azure.mgmt.compute.v2022_07_02.operations.DiskAccessesOperations>`
        """
        api_version = self._get_api_version('disk_accesses')
        if api_version == '2020-05-01':
            from .v2020_05_01.operations import DiskAccessesOperations as OperationClass
        elif api_version == '2020-06-30':
            from .v2020_06_30.operations import DiskAccessesOperations as OperationClass
        elif api_version == '2020-09-30':
            from .v2020_09_30.operations import DiskAccessesOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import DiskAccessesOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import DiskAccessesOperations as OperationClass
        elif api_version == '2021-08-01':
            from .v2021_08_01.operations import DiskAccessesOperations as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import DiskAccessesOperations as OperationClass
        elif api_version == '2022-03-02':
            from .v2022_03_02.operations import DiskAccessesOperations as OperationClass
        elif api_version == '2022-07-02':
            from .v2022_07_02.operations import DiskAccessesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'disk_accesses'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def disk_encryption_sets(self):
        """Instance depends on the API version:

           * 2019-07-01: :class:`DiskEncryptionSetsOperations<azure.mgmt.compute.v2019_07_01.operations.DiskEncryptionSetsOperations>`
           * 2019-11-01: :class:`DiskEncryptionSetsOperations<azure.mgmt.compute.v2019_11_01.operations.DiskEncryptionSetsOperations>`
           * 2020-05-01: :class:`DiskEncryptionSetsOperations<azure.mgmt.compute.v2020_05_01.operations.DiskEncryptionSetsOperations>`
           * 2020-06-30: :class:`DiskEncryptionSetsOperations<azure.mgmt.compute.v2020_06_30.operations.DiskEncryptionSetsOperations>`
           * 2020-09-30: :class:`DiskEncryptionSetsOperations<azure.mgmt.compute.v2020_09_30.operations.DiskEncryptionSetsOperations>`
           * 2020-12-01: :class:`DiskEncryptionSetsOperations<azure.mgmt.compute.v2020_12_01.operations.DiskEncryptionSetsOperations>`
           * 2021-04-01: :class:`DiskEncryptionSetsOperations<azure.mgmt.compute.v2021_04_01.operations.DiskEncryptionSetsOperations>`
           * 2021-08-01: :class:`DiskEncryptionSetsOperations<azure.mgmt.compute.v2021_08_01.operations.DiskEncryptionSetsOperations>`
           * 2021-12-01: :class:`DiskEncryptionSetsOperations<azure.mgmt.compute.v2021_12_01.operations.DiskEncryptionSetsOperations>`
           * 2022-03-02: :class:`DiskEncryptionSetsOperations<azure.mgmt.compute.v2022_03_02.operations.DiskEncryptionSetsOperations>`
           * 2022-07-02: :class:`DiskEncryptionSetsOperations<azure.mgmt.compute.v2022_07_02.operations.DiskEncryptionSetsOperations>`
        """
        api_version = self._get_api_version('disk_encryption_sets')
        if api_version == '2019-07-01':
            from .v2019_07_01.operations import DiskEncryptionSetsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import DiskEncryptionSetsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import DiskEncryptionSetsOperations as OperationClass
        elif api_version == '2020-06-30':
            from .v2020_06_30.operations import DiskEncryptionSetsOperations as OperationClass
        elif api_version == '2020-09-30':
            from .v2020_09_30.operations import DiskEncryptionSetsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import DiskEncryptionSetsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import DiskEncryptionSetsOperations as OperationClass
        elif api_version == '2021-08-01':
            from .v2021_08_01.operations import DiskEncryptionSetsOperations as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import DiskEncryptionSetsOperations as OperationClass
        elif api_version == '2022-03-02':
            from .v2022_03_02.operations import DiskEncryptionSetsOperations as OperationClass
        elif api_version == '2022-07-02':
            from .v2022_07_02.operations import DiskEncryptionSetsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'disk_encryption_sets'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def disk_restore_point(self):
        """Instance depends on the API version:

           * 2020-09-30: :class:`DiskRestorePointOperations<azure.mgmt.compute.v2020_09_30.operations.DiskRestorePointOperations>`
           * 2020-12-01: :class:`DiskRestorePointOperations<azure.mgmt.compute.v2020_12_01.operations.DiskRestorePointOperations>`
           * 2021-04-01: :class:`DiskRestorePointOperations<azure.mgmt.compute.v2021_04_01.operations.DiskRestorePointOperations>`
           * 2021-08-01: :class:`DiskRestorePointOperations<azure.mgmt.compute.v2021_08_01.operations.DiskRestorePointOperations>`
           * 2021-12-01: :class:`DiskRestorePointOperations<azure.mgmt.compute.v2021_12_01.operations.DiskRestorePointOperations>`
           * 2022-03-02: :class:`DiskRestorePointOperations<azure.mgmt.compute.v2022_03_02.operations.DiskRestorePointOperations>`
           * 2022-07-02: :class:`DiskRestorePointOperations<azure.mgmt.compute.v2022_07_02.operations.DiskRestorePointOperations>`
        """
        api_version = self._get_api_version('disk_restore_point')
        if api_version == '2020-09-30':
            from .v2020_09_30.operations import DiskRestorePointOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import DiskRestorePointOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import DiskRestorePointOperations as OperationClass
        elif api_version == '2021-08-01':
            from .v2021_08_01.operations import DiskRestorePointOperations as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import DiskRestorePointOperations as OperationClass
        elif api_version == '2022-03-02':
            from .v2022_03_02.operations import DiskRestorePointOperations as OperationClass
        elif api_version == '2022-07-02':
            from .v2022_07_02.operations import DiskRestorePointOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'disk_restore_point'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def disks(self):
        """Instance depends on the API version:

           * 2016-04-30-preview: :class:`DisksOperations<azure.mgmt.compute.v2016_04_30_preview.operations.DisksOperations>`
           * 2017-03-30: :class:`DisksOperations<azure.mgmt.compute.v2017_03_30.operations.DisksOperations>`
           * 2018-04-01: :class:`DisksOperations<azure.mgmt.compute.v2018_04_01.operations.DisksOperations>`
           * 2018-06-01: :class:`DisksOperations<azure.mgmt.compute.v2018_06_01.operations.DisksOperations>`
           * 2018-09-30: :class:`DisksOperations<azure.mgmt.compute.v2018_09_30.operations.DisksOperations>`
           * 2019-03-01: :class:`DisksOperations<azure.mgmt.compute.v2019_03_01.operations.DisksOperations>`
           * 2019-07-01: :class:`DisksOperations<azure.mgmt.compute.v2019_07_01.operations.DisksOperations>`
           * 2019-11-01: :class:`DisksOperations<azure.mgmt.compute.v2019_11_01.operations.DisksOperations>`
           * 2020-05-01: :class:`DisksOperations<azure.mgmt.compute.v2020_05_01.operations.DisksOperations>`
           * 2020-06-30: :class:`DisksOperations<azure.mgmt.compute.v2020_06_30.operations.DisksOperations>`
           * 2020-09-30: :class:`DisksOperations<azure.mgmt.compute.v2020_09_30.operations.DisksOperations>`
           * 2020-12-01: :class:`DisksOperations<azure.mgmt.compute.v2020_12_01.operations.DisksOperations>`
           * 2021-04-01: :class:`DisksOperations<azure.mgmt.compute.v2021_04_01.operations.DisksOperations>`
           * 2021-08-01: :class:`DisksOperations<azure.mgmt.compute.v2021_08_01.operations.DisksOperations>`
           * 2021-12-01: :class:`DisksOperations<azure.mgmt.compute.v2021_12_01.operations.DisksOperations>`
           * 2022-03-02: :class:`DisksOperations<azure.mgmt.compute.v2022_03_02.operations.DisksOperations>`
           * 2022-07-02: :class:`DisksOperations<azure.mgmt.compute.v2022_07_02.operations.DisksOperations>`
        """
        api_version = self._get_api_version('disks')
        if api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import DisksOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import DisksOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import DisksOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import DisksOperations as OperationClass
        elif api_version == '2018-09-30':
            from .v2018_09_30.operations import DisksOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import DisksOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import DisksOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import DisksOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import DisksOperations as OperationClass
        elif api_version == '2020-06-30':
            from .v2020_06_30.operations import DisksOperations as OperationClass
        elif api_version == '2020-09-30':
            from .v2020_09_30.operations import DisksOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import DisksOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import DisksOperations as OperationClass
        elif api_version == '2021-08-01':
            from .v2021_08_01.operations import DisksOperations as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import DisksOperations as OperationClass
        elif api_version == '2022-03-02':
            from .v2022_03_02.operations import DisksOperations as OperationClass
        elif api_version == '2022-07-02':
            from .v2022_07_02.operations import DisksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'disks'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def galleries(self):
        """Instance depends on the API version:

           * 2018-06-01: :class:`GalleriesOperations<azure.mgmt.compute.v2018_06_01.operations.GalleriesOperations>`
           * 2019-03-01: :class:`GalleriesOperations<azure.mgmt.compute.v2019_03_01.operations.GalleriesOperations>`
           * 2019-07-01: :class:`GalleriesOperations<azure.mgmt.compute.v2019_07_01.operations.GalleriesOperations>`
           * 2019-12-01: :class:`GalleriesOperations<azure.mgmt.compute.v2019_12_01.operations.GalleriesOperations>`
           * 2020-09-30: :class:`GalleriesOperations<azure.mgmt.compute.v2020_09_30.operations.GalleriesOperations>`
           * 2021-07-01: :class:`GalleriesOperations<azure.mgmt.compute.v2021_07_01.operations.GalleriesOperations>`
           * 2021-10-01: :class:`GalleriesOperations<azure.mgmt.compute.v2021_10_01.operations.GalleriesOperations>`
           * 2022-01-03: :class:`GalleriesOperations<azure.mgmt.compute.v2022_01_03.operations.GalleriesOperations>`
           * 2022-03-03: :class:`GalleriesOperations<azure.mgmt.compute.v2022_03_03.operations.GalleriesOperations>`
        """
        api_version = self._get_api_version('galleries')
        if api_version == '2018-06-01':
            from .v2018_06_01.operations import GalleriesOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import GalleriesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import GalleriesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import GalleriesOperations as OperationClass
        elif api_version == '2020-09-30':
            from .v2020_09_30.operations import GalleriesOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import GalleriesOperations as OperationClass
        elif api_version == '2021-10-01':
            from .v2021_10_01.operations import GalleriesOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import GalleriesOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import GalleriesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'galleries'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def gallery_application_versions(self):
        """Instance depends on the API version:

           * 2019-03-01: :class:`GalleryApplicationVersionsOperations<azure.mgmt.compute.v2019_03_01.operations.GalleryApplicationVersionsOperations>`
           * 2019-07-01: :class:`GalleryApplicationVersionsOperations<azure.mgmt.compute.v2019_07_01.operations.GalleryApplicationVersionsOperations>`
           * 2019-12-01: :class:`GalleryApplicationVersionsOperations<azure.mgmt.compute.v2019_12_01.operations.GalleryApplicationVersionsOperations>`
           * 2020-09-30: :class:`GalleryApplicationVersionsOperations<azure.mgmt.compute.v2020_09_30.operations.GalleryApplicationVersionsOperations>`
           * 2021-07-01: :class:`GalleryApplicationVersionsOperations<azure.mgmt.compute.v2021_07_01.operations.GalleryApplicationVersionsOperations>`
           * 2021-10-01: :class:`GalleryApplicationVersionsOperations<azure.mgmt.compute.v2021_10_01.operations.GalleryApplicationVersionsOperations>`
           * 2022-01-03: :class:`GalleryApplicationVersionsOperations<azure.mgmt.compute.v2022_01_03.operations.GalleryApplicationVersionsOperations>`
           * 2022-03-03: :class:`GalleryApplicationVersionsOperations<azure.mgmt.compute.v2022_03_03.operations.GalleryApplicationVersionsOperations>`
        """
        api_version = self._get_api_version('gallery_application_versions')
        if api_version == '2019-03-01':
            from .v2019_03_01.operations import GalleryApplicationVersionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import GalleryApplicationVersionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import GalleryApplicationVersionsOperations as OperationClass
        elif api_version == '2020-09-30':
            from .v2020_09_30.operations import GalleryApplicationVersionsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import GalleryApplicationVersionsOperations as OperationClass
        elif api_version == '2021-10-01':
            from .v2021_10_01.operations import GalleryApplicationVersionsOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import GalleryApplicationVersionsOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import GalleryApplicationVersionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'gallery_application_versions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def gallery_applications(self):
        """Instance depends on the API version:

           * 2019-03-01: :class:`GalleryApplicationsOperations<azure.mgmt.compute.v2019_03_01.operations.GalleryApplicationsOperations>`
           * 2019-07-01: :class:`GalleryApplicationsOperations<azure.mgmt.compute.v2019_07_01.operations.GalleryApplicationsOperations>`
           * 2019-12-01: :class:`GalleryApplicationsOperations<azure.mgmt.compute.v2019_12_01.operations.GalleryApplicationsOperations>`
           * 2020-09-30: :class:`GalleryApplicationsOperations<azure.mgmt.compute.v2020_09_30.operations.GalleryApplicationsOperations>`
           * 2021-07-01: :class:`GalleryApplicationsOperations<azure.mgmt.compute.v2021_07_01.operations.GalleryApplicationsOperations>`
           * 2021-10-01: :class:`GalleryApplicationsOperations<azure.mgmt.compute.v2021_10_01.operations.GalleryApplicationsOperations>`
           * 2022-01-03: :class:`GalleryApplicationsOperations<azure.mgmt.compute.v2022_01_03.operations.GalleryApplicationsOperations>`
           * 2022-03-03: :class:`GalleryApplicationsOperations<azure.mgmt.compute.v2022_03_03.operations.GalleryApplicationsOperations>`
        """
        api_version = self._get_api_version('gallery_applications')
        if api_version == '2019-03-01':
            from .v2019_03_01.operations import GalleryApplicationsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import GalleryApplicationsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import GalleryApplicationsOperations as OperationClass
        elif api_version == '2020-09-30':
            from .v2020_09_30.operations import GalleryApplicationsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import GalleryApplicationsOperations as OperationClass
        elif api_version == '2021-10-01':
            from .v2021_10_01.operations import GalleryApplicationsOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import GalleryApplicationsOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import GalleryApplicationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'gallery_applications'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def gallery_image_versions(self):
        """Instance depends on the API version:

           * 2018-06-01: :class:`GalleryImageVersionsOperations<azure.mgmt.compute.v2018_06_01.operations.GalleryImageVersionsOperations>`
           * 2019-03-01: :class:`GalleryImageVersionsOperations<azure.mgmt.compute.v2019_03_01.operations.GalleryImageVersionsOperations>`
           * 2019-07-01: :class:`GalleryImageVersionsOperations<azure.mgmt.compute.v2019_07_01.operations.GalleryImageVersionsOperations>`
           * 2019-12-01: :class:`GalleryImageVersionsOperations<azure.mgmt.compute.v2019_12_01.operations.GalleryImageVersionsOperations>`
           * 2020-09-30: :class:`GalleryImageVersionsOperations<azure.mgmt.compute.v2020_09_30.operations.GalleryImageVersionsOperations>`
           * 2021-07-01: :class:`GalleryImageVersionsOperations<azure.mgmt.compute.v2021_07_01.operations.GalleryImageVersionsOperations>`
           * 2021-10-01: :class:`GalleryImageVersionsOperations<azure.mgmt.compute.v2021_10_01.operations.GalleryImageVersionsOperations>`
           * 2022-01-03: :class:`GalleryImageVersionsOperations<azure.mgmt.compute.v2022_01_03.operations.GalleryImageVersionsOperations>`
           * 2022-03-03: :class:`GalleryImageVersionsOperations<azure.mgmt.compute.v2022_03_03.operations.GalleryImageVersionsOperations>`
        """
        api_version = self._get_api_version('gallery_image_versions')
        if api_version == '2018-06-01':
            from .v2018_06_01.operations import GalleryImageVersionsOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import GalleryImageVersionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import GalleryImageVersionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import GalleryImageVersionsOperations as OperationClass
        elif api_version == '2020-09-30':
            from .v2020_09_30.operations import GalleryImageVersionsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import GalleryImageVersionsOperations as OperationClass
        elif api_version == '2021-10-01':
            from .v2021_10_01.operations import GalleryImageVersionsOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import GalleryImageVersionsOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import GalleryImageVersionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'gallery_image_versions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def gallery_images(self):
        """Instance depends on the API version:

           * 2018-06-01: :class:`GalleryImagesOperations<azure.mgmt.compute.v2018_06_01.operations.GalleryImagesOperations>`
           * 2019-03-01: :class:`GalleryImagesOperations<azure.mgmt.compute.v2019_03_01.operations.GalleryImagesOperations>`
           * 2019-07-01: :class:`GalleryImagesOperations<azure.mgmt.compute.v2019_07_01.operations.GalleryImagesOperations>`
           * 2019-12-01: :class:`GalleryImagesOperations<azure.mgmt.compute.v2019_12_01.operations.GalleryImagesOperations>`
           * 2020-09-30: :class:`GalleryImagesOperations<azure.mgmt.compute.v2020_09_30.operations.GalleryImagesOperations>`
           * 2021-07-01: :class:`GalleryImagesOperations<azure.mgmt.compute.v2021_07_01.operations.GalleryImagesOperations>`
           * 2021-10-01: :class:`GalleryImagesOperations<azure.mgmt.compute.v2021_10_01.operations.GalleryImagesOperations>`
           * 2022-01-03: :class:`GalleryImagesOperations<azure.mgmt.compute.v2022_01_03.operations.GalleryImagesOperations>`
           * 2022-03-03: :class:`GalleryImagesOperations<azure.mgmt.compute.v2022_03_03.operations.GalleryImagesOperations>`
        """
        api_version = self._get_api_version('gallery_images')
        if api_version == '2018-06-01':
            from .v2018_06_01.operations import GalleryImagesOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import GalleryImagesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import GalleryImagesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import GalleryImagesOperations as OperationClass
        elif api_version == '2020-09-30':
            from .v2020_09_30.operations import GalleryImagesOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import GalleryImagesOperations as OperationClass
        elif api_version == '2021-10-01':
            from .v2021_10_01.operations import GalleryImagesOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import GalleryImagesOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import GalleryImagesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'gallery_images'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def gallery_sharing_profile(self):
        """Instance depends on the API version:

           * 2020-09-30: :class:`GallerySharingProfileOperations<azure.mgmt.compute.v2020_09_30.operations.GallerySharingProfileOperations>`
           * 2021-07-01: :class:`GallerySharingProfileOperations<azure.mgmt.compute.v2021_07_01.operations.GallerySharingProfileOperations>`
           * 2021-10-01: :class:`GallerySharingProfileOperations<azure.mgmt.compute.v2021_10_01.operations.GallerySharingProfileOperations>`
           * 2022-01-03: :class:`GallerySharingProfileOperations<azure.mgmt.compute.v2022_01_03.operations.GallerySharingProfileOperations>`
           * 2022-03-03: :class:`GallerySharingProfileOperations<azure.mgmt.compute.v2022_03_03.operations.GallerySharingProfileOperations>`
        """
        api_version = self._get_api_version('gallery_sharing_profile')
        if api_version == '2020-09-30':
            from .v2020_09_30.operations import GallerySharingProfileOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import GallerySharingProfileOperations as OperationClass
        elif api_version == '2021-10-01':
            from .v2021_10_01.operations import GallerySharingProfileOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import GallerySharingProfileOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import GallerySharingProfileOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'gallery_sharing_profile'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def images(self):
        """Instance depends on the API version:

           * 2016-04-30-preview: :class:`ImagesOperations<azure.mgmt.compute.v2016_04_30_preview.operations.ImagesOperations>`
           * 2017-03-30: :class:`ImagesOperations<azure.mgmt.compute.v2017_03_30.operations.ImagesOperations>`
           * 2017-12-01: :class:`ImagesOperations<azure.mgmt.compute.v2017_12_01.operations.ImagesOperations>`
           * 2018-04-01: :class:`ImagesOperations<azure.mgmt.compute.v2018_04_01.operations.ImagesOperations>`
           * 2018-06-01: :class:`ImagesOperations<azure.mgmt.compute.v2018_06_01.operations.ImagesOperations>`
           * 2018-10-01: :class:`ImagesOperations<azure.mgmt.compute.v2018_10_01.operations.ImagesOperations>`
           * 2019-03-01: :class:`ImagesOperations<azure.mgmt.compute.v2019_03_01.operations.ImagesOperations>`
           * 2019-07-01: :class:`ImagesOperations<azure.mgmt.compute.v2019_07_01.operations.ImagesOperations>`
           * 2019-12-01: :class:`ImagesOperations<azure.mgmt.compute.v2019_12_01.operations.ImagesOperations>`
           * 2020-06-01: :class:`ImagesOperations<azure.mgmt.compute.v2020_06_01.operations.ImagesOperations>`
           * 2020-12-01: :class:`ImagesOperations<azure.mgmt.compute.v2020_12_01.operations.ImagesOperations>`
           * 2021-03-01: :class:`ImagesOperations<azure.mgmt.compute.v2021_03_01.operations.ImagesOperations>`
           * 2021-04-01: :class:`ImagesOperations<azure.mgmt.compute.v2021_04_01.operations.ImagesOperations>`
           * 2021-07-01: :class:`ImagesOperations<azure.mgmt.compute.v2021_07_01.operations.ImagesOperations>`
           * 2021-11-01: :class:`ImagesOperations<azure.mgmt.compute.v2021_11_01.operations.ImagesOperations>`
           * 2022-03-01: :class:`ImagesOperations<azure.mgmt.compute.v2022_03_01.operations.ImagesOperations>`
           * 2022-08-01: :class:`ImagesOperations<azure.mgmt.compute.v2022_08_01.operations.ImagesOperations>`
        """
        api_version = self._get_api_version('images')
        if api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import ImagesOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import ImagesOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import ImagesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import ImagesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ImagesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ImagesOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import ImagesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ImagesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ImagesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ImagesOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import ImagesOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import ImagesOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import ImagesOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import ImagesOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import ImagesOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import ImagesOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import ImagesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'images'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def log_analytics(self):
        """Instance depends on the API version:

           * 2017-12-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2017_12_01.operations.LogAnalyticsOperations>`
           * 2018-04-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2018_04_01.operations.LogAnalyticsOperations>`
           * 2018-06-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2018_06_01.operations.LogAnalyticsOperations>`
           * 2018-10-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2018_10_01.operations.LogAnalyticsOperations>`
           * 2019-03-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2019_03_01.operations.LogAnalyticsOperations>`
           * 2019-07-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2019_07_01.operations.LogAnalyticsOperations>`
           * 2019-12-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2019_12_01.operations.LogAnalyticsOperations>`
           * 2020-06-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2020_06_01.operations.LogAnalyticsOperations>`
           * 2020-12-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2020_12_01.operations.LogAnalyticsOperations>`
           * 2021-03-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2021_03_01.operations.LogAnalyticsOperations>`
           * 2021-04-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2021_04_01.operations.LogAnalyticsOperations>`
           * 2021-07-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2021_07_01.operations.LogAnalyticsOperations>`
           * 2021-11-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2021_11_01.operations.LogAnalyticsOperations>`
           * 2022-03-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2022_03_01.operations.LogAnalyticsOperations>`
           * 2022-08-01: :class:`LogAnalyticsOperations<azure.mgmt.compute.v2022_08_01.operations.LogAnalyticsOperations>`
        """
        api_version = self._get_api_version('log_analytics')
        if api_version == '2017-12-01':
            from .v2017_12_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import LogAnalyticsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import LogAnalyticsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'log_analytics'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def operations(self):
        """Instance depends on the API version:

           * 2017-12-01: :class:`Operations<azure.mgmt.compute.v2017_12_01.operations.Operations>`
           * 2018-04-01: :class:`Operations<azure.mgmt.compute.v2018_04_01.operations.Operations>`
           * 2018-06-01: :class:`Operations<azure.mgmt.compute.v2018_06_01.operations.Operations>`
           * 2018-10-01: :class:`Operations<azure.mgmt.compute.v2018_10_01.operations.Operations>`
           * 2019-03-01: :class:`Operations<azure.mgmt.compute.v2019_03_01.operations.Operations>`
           * 2019-07-01: :class:`Operations<azure.mgmt.compute.v2019_07_01.operations.Operations>`
           * 2019-12-01: :class:`Operations<azure.mgmt.compute.v2019_12_01.operations.Operations>`
           * 2020-06-01: :class:`Operations<azure.mgmt.compute.v2020_06_01.operations.Operations>`
           * 2020-12-01: :class:`Operations<azure.mgmt.compute.v2020_12_01.operations.Operations>`
           * 2021-03-01: :class:`Operations<azure.mgmt.compute.v2021_03_01.operations.Operations>`
           * 2021-04-01: :class:`Operations<azure.mgmt.compute.v2021_04_01.operations.Operations>`
           * 2021-07-01: :class:`Operations<azure.mgmt.compute.v2021_07_01.operations.Operations>`
           * 2021-11-01: :class:`Operations<azure.mgmt.compute.v2021_11_01.operations.Operations>`
           * 2022-03-01: :class:`Operations<azure.mgmt.compute.v2022_03_01.operations.Operations>`
           * 2022-08-01: :class:`Operations<azure.mgmt.compute.v2022_08_01.operations.Operations>`
        """
        api_version = self._get_api_version('operations')
        if api_version == '2017-12-01':
            from .v2017_12_01.operations import Operations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import Operations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import Operations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import Operations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import Operations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import Operations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import Operations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import Operations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import Operations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import Operations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import Operations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import Operations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import Operations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import Operations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import Operations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'operations'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def proximity_placement_groups(self):
        """Instance depends on the API version:

           * 2018-04-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2018_04_01.operations.ProximityPlacementGroupsOperations>`
           * 2018-06-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2018_06_01.operations.ProximityPlacementGroupsOperations>`
           * 2018-10-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2018_10_01.operations.ProximityPlacementGroupsOperations>`
           * 2019-03-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2019_03_01.operations.ProximityPlacementGroupsOperations>`
           * 2019-07-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2019_07_01.operations.ProximityPlacementGroupsOperations>`
           * 2019-12-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2019_12_01.operations.ProximityPlacementGroupsOperations>`
           * 2020-06-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2020_06_01.operations.ProximityPlacementGroupsOperations>`
           * 2020-12-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2020_12_01.operations.ProximityPlacementGroupsOperations>`
           * 2021-03-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2021_03_01.operations.ProximityPlacementGroupsOperations>`
           * 2021-04-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2021_04_01.operations.ProximityPlacementGroupsOperations>`
           * 2021-07-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2021_07_01.operations.ProximityPlacementGroupsOperations>`
           * 2021-11-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2021_11_01.operations.ProximityPlacementGroupsOperations>`
           * 2022-03-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2022_03_01.operations.ProximityPlacementGroupsOperations>`
           * 2022-08-01: :class:`ProximityPlacementGroupsOperations<azure.mgmt.compute.v2022_08_01.operations.ProximityPlacementGroupsOperations>`
        """
        api_version = self._get_api_version('proximity_placement_groups')
        if api_version == '2018-04-01':
            from .v2018_04_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import ProximityPlacementGroupsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import ProximityPlacementGroupsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'proximity_placement_groups'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def resource_skus(self):
        """Instance depends on the API version:

           * 2017-03-30: :class:`ResourceSkusOperations<azure.mgmt.compute.v2017_03_30.operations.ResourceSkusOperations>`
           * 2017-09-01: :class:`ResourceSkusOperations<azure.mgmt.compute.v2017_09_01.operations.ResourceSkusOperations>`
           * 2019-04-01: :class:`ResourceSkusOperations<azure.mgmt.compute.v2019_04_01.operations.ResourceSkusOperations>`
           * 2021-07-01: :class:`ResourceSkusOperations<azure.mgmt.compute.v2021_07_01.operations.ResourceSkusOperations>`
        """
        api_version = self._get_api_version('resource_skus')
        if api_version == '2017-03-30':
            from .v2017_03_30.operations import ResourceSkusOperations as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import ResourceSkusOperations as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import ResourceSkusOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import ResourceSkusOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'resource_skus'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def restore_point_collections(self):
        """Instance depends on the API version:

           * 2021-03-01: :class:`RestorePointCollectionsOperations<azure.mgmt.compute.v2021_03_01.operations.RestorePointCollectionsOperations>`
           * 2021-04-01: :class:`RestorePointCollectionsOperations<azure.mgmt.compute.v2021_04_01.operations.RestorePointCollectionsOperations>`
           * 2021-07-01: :class:`RestorePointCollectionsOperations<azure.mgmt.compute.v2021_07_01.operations.RestorePointCollectionsOperations>`
           * 2021-11-01: :class:`RestorePointCollectionsOperations<azure.mgmt.compute.v2021_11_01.operations.RestorePointCollectionsOperations>`
           * 2022-03-01: :class:`RestorePointCollectionsOperations<azure.mgmt.compute.v2022_03_01.operations.RestorePointCollectionsOperations>`
           * 2022-08-01: :class:`RestorePointCollectionsOperations<azure.mgmt.compute.v2022_08_01.operations.RestorePointCollectionsOperations>`
        """
        api_version = self._get_api_version('restore_point_collections')
        if api_version == '2021-03-01':
            from .v2021_03_01.operations import RestorePointCollectionsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import RestorePointCollectionsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import RestorePointCollectionsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import RestorePointCollectionsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import RestorePointCollectionsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import RestorePointCollectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'restore_point_collections'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def restore_points(self):
        """Instance depends on the API version:

           * 2021-03-01: :class:`RestorePointsOperations<azure.mgmt.compute.v2021_03_01.operations.RestorePointsOperations>`
           * 2021-04-01: :class:`RestorePointsOperations<azure.mgmt.compute.v2021_04_01.operations.RestorePointsOperations>`
           * 2021-07-01: :class:`RestorePointsOperations<azure.mgmt.compute.v2021_07_01.operations.RestorePointsOperations>`
           * 2021-11-01: :class:`RestorePointsOperations<azure.mgmt.compute.v2021_11_01.operations.RestorePointsOperations>`
           * 2022-03-01: :class:`RestorePointsOperations<azure.mgmt.compute.v2022_03_01.operations.RestorePointsOperations>`
           * 2022-08-01: :class:`RestorePointsOperations<azure.mgmt.compute.v2022_08_01.operations.RestorePointsOperations>`
        """
        api_version = self._get_api_version('restore_points')
        if api_version == '2021-03-01':
            from .v2021_03_01.operations import RestorePointsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import RestorePointsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import RestorePointsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import RestorePointsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import RestorePointsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import RestorePointsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'restore_points'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def shared_galleries(self):
        """Instance depends on the API version:

           * 2020-09-30: :class:`SharedGalleriesOperations<azure.mgmt.compute.v2020_09_30.operations.SharedGalleriesOperations>`
           * 2021-07-01: :class:`SharedGalleriesOperations<azure.mgmt.compute.v2021_07_01.operations.SharedGalleriesOperations>`
           * 2022-01-03: :class:`SharedGalleriesOperations<azure.mgmt.compute.v2022_01_03.operations.SharedGalleriesOperations>`
           * 2022-03-03: :class:`SharedGalleriesOperations<azure.mgmt.compute.v2022_03_03.operations.SharedGalleriesOperations>`
        """
        api_version = self._get_api_version('shared_galleries')
        if api_version == '2020-09-30':
            from .v2020_09_30.operations import SharedGalleriesOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import SharedGalleriesOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import SharedGalleriesOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import SharedGalleriesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'shared_galleries'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def shared_gallery_image_versions(self):
        """Instance depends on the API version:

           * 2020-09-30: :class:`SharedGalleryImageVersionsOperations<azure.mgmt.compute.v2020_09_30.operations.SharedGalleryImageVersionsOperations>`
           * 2021-07-01: :class:`SharedGalleryImageVersionsOperations<azure.mgmt.compute.v2021_07_01.operations.SharedGalleryImageVersionsOperations>`
           * 2022-01-03: :class:`SharedGalleryImageVersionsOperations<azure.mgmt.compute.v2022_01_03.operations.SharedGalleryImageVersionsOperations>`
           * 2022-03-03: :class:`SharedGalleryImageVersionsOperations<azure.mgmt.compute.v2022_03_03.operations.SharedGalleryImageVersionsOperations>`
        """
        api_version = self._get_api_version('shared_gallery_image_versions')
        if api_version == '2020-09-30':
            from .v2020_09_30.operations import SharedGalleryImageVersionsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import SharedGalleryImageVersionsOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import SharedGalleryImageVersionsOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import SharedGalleryImageVersionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'shared_gallery_image_versions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def shared_gallery_images(self):
        """Instance depends on the API version:

           * 2020-09-30: :class:`SharedGalleryImagesOperations<azure.mgmt.compute.v2020_09_30.operations.SharedGalleryImagesOperations>`
           * 2021-07-01: :class:`SharedGalleryImagesOperations<azure.mgmt.compute.v2021_07_01.operations.SharedGalleryImagesOperations>`
           * 2022-01-03: :class:`SharedGalleryImagesOperations<azure.mgmt.compute.v2022_01_03.operations.SharedGalleryImagesOperations>`
           * 2022-03-03: :class:`SharedGalleryImagesOperations<azure.mgmt.compute.v2022_03_03.operations.SharedGalleryImagesOperations>`
        """
        api_version = self._get_api_version('shared_gallery_images')
        if api_version == '2020-09-30':
            from .v2020_09_30.operations import SharedGalleryImagesOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import SharedGalleryImagesOperations as OperationClass
        elif api_version == '2022-01-03':
            from .v2022_01_03.operations import SharedGalleryImagesOperations as OperationClass
        elif api_version == '2022-03-03':
            from .v2022_03_03.operations import SharedGalleryImagesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'shared_gallery_images'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def snapshots(self):
        """Instance depends on the API version:

           * 2016-04-30-preview: :class:`SnapshotsOperations<azure.mgmt.compute.v2016_04_30_preview.operations.SnapshotsOperations>`
           * 2017-03-30: :class:`SnapshotsOperations<azure.mgmt.compute.v2017_03_30.operations.SnapshotsOperations>`
           * 2018-04-01: :class:`SnapshotsOperations<azure.mgmt.compute.v2018_04_01.operations.SnapshotsOperations>`
           * 2018-06-01: :class:`SnapshotsOperations<azure.mgmt.compute.v2018_06_01.operations.SnapshotsOperations>`
           * 2018-09-30: :class:`SnapshotsOperations<azure.mgmt.compute.v2018_09_30.operations.SnapshotsOperations>`
           * 2019-03-01: :class:`SnapshotsOperations<azure.mgmt.compute.v2019_03_01.operations.SnapshotsOperations>`
           * 2019-07-01: :class:`SnapshotsOperations<azure.mgmt.compute.v2019_07_01.operations.SnapshotsOperations>`
           * 2019-11-01: :class:`SnapshotsOperations<azure.mgmt.compute.v2019_11_01.operations.SnapshotsOperations>`
           * 2020-05-01: :class:`SnapshotsOperations<azure.mgmt.compute.v2020_05_01.operations.SnapshotsOperations>`
           * 2020-06-30: :class:`SnapshotsOperations<azure.mgmt.compute.v2020_06_30.operations.SnapshotsOperations>`
           * 2020-09-30: :class:`SnapshotsOperations<azure.mgmt.compute.v2020_09_30.operations.SnapshotsOperations>`
           * 2020-12-01: :class:`SnapshotsOperations<azure.mgmt.compute.v2020_12_01.operations.SnapshotsOperations>`
           * 2021-04-01: :class:`SnapshotsOperations<azure.mgmt.compute.v2021_04_01.operations.SnapshotsOperations>`
           * 2021-08-01: :class:`SnapshotsOperations<azure.mgmt.compute.v2021_08_01.operations.SnapshotsOperations>`
           * 2021-12-01: :class:`SnapshotsOperations<azure.mgmt.compute.v2021_12_01.operations.SnapshotsOperations>`
           * 2022-03-02: :class:`SnapshotsOperations<azure.mgmt.compute.v2022_03_02.operations.SnapshotsOperations>`
           * 2022-07-02: :class:`SnapshotsOperations<azure.mgmt.compute.v2022_07_02.operations.SnapshotsOperations>`
        """
        api_version = self._get_api_version('snapshots')
        if api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import SnapshotsOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import SnapshotsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import SnapshotsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import SnapshotsOperations as OperationClass
        elif api_version == '2018-09-30':
            from .v2018_09_30.operations import SnapshotsOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import SnapshotsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import SnapshotsOperations as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import SnapshotsOperations as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import SnapshotsOperations as OperationClass
        elif api_version == '2020-06-30':
            from .v2020_06_30.operations import SnapshotsOperations as OperationClass
        elif api_version == '2020-09-30':
            from .v2020_09_30.operations import SnapshotsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import SnapshotsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import SnapshotsOperations as OperationClass
        elif api_version == '2021-08-01':
            from .v2021_08_01.operations import SnapshotsOperations as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import SnapshotsOperations as OperationClass
        elif api_version == '2022-03-02':
            from .v2022_03_02.operations import SnapshotsOperations as OperationClass
        elif api_version == '2022-07-02':
            from .v2022_07_02.operations import SnapshotsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'snapshots'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def ssh_public_keys(self):
        """Instance depends on the API version:

           * 2019-12-01: :class:`SshPublicKeysOperations<azure.mgmt.compute.v2019_12_01.operations.SshPublicKeysOperations>`
           * 2020-06-01: :class:`SshPublicKeysOperations<azure.mgmt.compute.v2020_06_01.operations.SshPublicKeysOperations>`
           * 2020-12-01: :class:`SshPublicKeysOperations<azure.mgmt.compute.v2020_12_01.operations.SshPublicKeysOperations>`
           * 2021-03-01: :class:`SshPublicKeysOperations<azure.mgmt.compute.v2021_03_01.operations.SshPublicKeysOperations>`
           * 2021-04-01: :class:`SshPublicKeysOperations<azure.mgmt.compute.v2021_04_01.operations.SshPublicKeysOperations>`
           * 2021-07-01: :class:`SshPublicKeysOperations<azure.mgmt.compute.v2021_07_01.operations.SshPublicKeysOperations>`
           * 2021-11-01: :class:`SshPublicKeysOperations<azure.mgmt.compute.v2021_11_01.operations.SshPublicKeysOperations>`
           * 2022-03-01: :class:`SshPublicKeysOperations<azure.mgmt.compute.v2022_03_01.operations.SshPublicKeysOperations>`
           * 2022-08-01: :class:`SshPublicKeysOperations<azure.mgmt.compute.v2022_08_01.operations.SshPublicKeysOperations>`
        """
        api_version = self._get_api_version('ssh_public_keys')
        if api_version == '2019-12-01':
            from .v2019_12_01.operations import SshPublicKeysOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import SshPublicKeysOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import SshPublicKeysOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import SshPublicKeysOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import SshPublicKeysOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import SshPublicKeysOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import SshPublicKeysOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import SshPublicKeysOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import SshPublicKeysOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'ssh_public_keys'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def usage(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`UsageOperations<azure.mgmt.compute.v2015_06_15.operations.UsageOperations>`
           * 2016-03-30: :class:`UsageOperations<azure.mgmt.compute.v2016_03_30.operations.UsageOperations>`
           * 2016-04-30-preview: :class:`UsageOperations<azure.mgmt.compute.v2016_04_30_preview.operations.UsageOperations>`
           * 2017-03-30: :class:`UsageOperations<azure.mgmt.compute.v2017_03_30.operations.UsageOperations>`
           * 2017-12-01: :class:`UsageOperations<azure.mgmt.compute.v2017_12_01.operations.UsageOperations>`
           * 2018-04-01: :class:`UsageOperations<azure.mgmt.compute.v2018_04_01.operations.UsageOperations>`
           * 2018-06-01: :class:`UsageOperations<azure.mgmt.compute.v2018_06_01.operations.UsageOperations>`
           * 2018-10-01: :class:`UsageOperations<azure.mgmt.compute.v2018_10_01.operations.UsageOperations>`
           * 2019-03-01: :class:`UsageOperations<azure.mgmt.compute.v2019_03_01.operations.UsageOperations>`
           * 2019-07-01: :class:`UsageOperations<azure.mgmt.compute.v2019_07_01.operations.UsageOperations>`
           * 2019-12-01: :class:`UsageOperations<azure.mgmt.compute.v2019_12_01.operations.UsageOperations>`
           * 2020-06-01: :class:`UsageOperations<azure.mgmt.compute.v2020_06_01.operations.UsageOperations>`
           * 2020-12-01: :class:`UsageOperations<azure.mgmt.compute.v2020_12_01.operations.UsageOperations>`
           * 2021-03-01: :class:`UsageOperations<azure.mgmt.compute.v2021_03_01.operations.UsageOperations>`
           * 2021-04-01: :class:`UsageOperations<azure.mgmt.compute.v2021_04_01.operations.UsageOperations>`
           * 2021-07-01: :class:`UsageOperations<azure.mgmt.compute.v2021_07_01.operations.UsageOperations>`
           * 2021-11-01: :class:`UsageOperations<azure.mgmt.compute.v2021_11_01.operations.UsageOperations>`
           * 2022-03-01: :class:`UsageOperations<azure.mgmt.compute.v2022_03_01.operations.UsageOperations>`
           * 2022-08-01: :class:`UsageOperations<azure.mgmt.compute.v2022_08_01.operations.UsageOperations>`
        """
        api_version = self._get_api_version('usage')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import UsageOperations as OperationClass
        elif api_version == '2016-03-30':
            from .v2016_03_30.operations import UsageOperations as OperationClass
        elif api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import UsageOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import UsageOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import UsageOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import UsageOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import UsageOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import UsageOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import UsageOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import UsageOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import UsageOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import UsageOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import UsageOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import UsageOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import UsageOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import UsageOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import UsageOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import UsageOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import UsageOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'usage'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_extension_images(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2015_06_15.operations.VirtualMachineExtensionImagesOperations>`
           * 2016-03-30: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2016_03_30.operations.VirtualMachineExtensionImagesOperations>`
           * 2016-04-30-preview: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2016_04_30_preview.operations.VirtualMachineExtensionImagesOperations>`
           * 2017-03-30: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2017_03_30.operations.VirtualMachineExtensionImagesOperations>`
           * 2017-12-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2017_12_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2018-04-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2018_04_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2018-06-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2018_06_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2018-10-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2018_10_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2019-03-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2019_03_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2019-07-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2019_07_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2019-12-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2019_12_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2020-06-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2020-12-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2021-03-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2021-04-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2021-07-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2021-11-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2022-03-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineExtensionImagesOperations>`
           * 2022-08-01: :class:`VirtualMachineExtensionImagesOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineExtensionImagesOperations>`
        """
        api_version = self._get_api_version('virtual_machine_extension_images')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2016-03-30':
            from .v2016_03_30.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineExtensionImagesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_extension_images'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_extensions(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2015_06_15.operations.VirtualMachineExtensionsOperations>`
           * 2016-03-30: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2016_03_30.operations.VirtualMachineExtensionsOperations>`
           * 2016-04-30-preview: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2016_04_30_preview.operations.VirtualMachineExtensionsOperations>`
           * 2017-03-30: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2017_03_30.operations.VirtualMachineExtensionsOperations>`
           * 2017-12-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2017_12_01.operations.VirtualMachineExtensionsOperations>`
           * 2018-04-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2018_04_01.operations.VirtualMachineExtensionsOperations>`
           * 2018-06-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2018_06_01.operations.VirtualMachineExtensionsOperations>`
           * 2018-10-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2018_10_01.operations.VirtualMachineExtensionsOperations>`
           * 2019-03-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2019_03_01.operations.VirtualMachineExtensionsOperations>`
           * 2019-07-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2019_07_01.operations.VirtualMachineExtensionsOperations>`
           * 2019-12-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2019_12_01.operations.VirtualMachineExtensionsOperations>`
           * 2020-06-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachineExtensionsOperations>`
           * 2020-12-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineExtensionsOperations>`
           * 2021-03-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineExtensionsOperations>`
           * 2021-04-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineExtensionsOperations>`
           * 2021-07-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineExtensionsOperations>`
           * 2021-11-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineExtensionsOperations>`
           * 2022-03-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineExtensionsOperations>`
           * 2022-08-01: :class:`VirtualMachineExtensionsOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineExtensionsOperations>`
        """
        api_version = self._get_api_version('virtual_machine_extensions')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2016-03-30':
            from .v2016_03_30.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineExtensionsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineExtensionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_extensions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_images(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2015_06_15.operations.VirtualMachineImagesOperations>`
           * 2016-03-30: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2016_03_30.operations.VirtualMachineImagesOperations>`
           * 2016-04-30-preview: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2016_04_30_preview.operations.VirtualMachineImagesOperations>`
           * 2017-03-30: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2017_03_30.operations.VirtualMachineImagesOperations>`
           * 2017-12-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2017_12_01.operations.VirtualMachineImagesOperations>`
           * 2018-04-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2018_04_01.operations.VirtualMachineImagesOperations>`
           * 2018-06-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2018_06_01.operations.VirtualMachineImagesOperations>`
           * 2018-10-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2018_10_01.operations.VirtualMachineImagesOperations>`
           * 2019-03-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2019_03_01.operations.VirtualMachineImagesOperations>`
           * 2019-07-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2019_07_01.operations.VirtualMachineImagesOperations>`
           * 2019-12-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2019_12_01.operations.VirtualMachineImagesOperations>`
           * 2020-06-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachineImagesOperations>`
           * 2020-12-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineImagesOperations>`
           * 2021-03-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineImagesOperations>`
           * 2021-04-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineImagesOperations>`
           * 2021-07-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineImagesOperations>`
           * 2021-11-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineImagesOperations>`
           * 2022-03-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineImagesOperations>`
           * 2022-08-01: :class:`VirtualMachineImagesOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineImagesOperations>`
        """
        api_version = self._get_api_version('virtual_machine_images')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2016-03-30':
            from .v2016_03_30.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineImagesOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineImagesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_images'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_images_edge_zone(self):
        """Instance depends on the API version:

           * 2020-12-01: :class:`VirtualMachineImagesEdgeZoneOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineImagesEdgeZoneOperations>`
           * 2021-03-01: :class:`VirtualMachineImagesEdgeZoneOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineImagesEdgeZoneOperations>`
           * 2021-04-01: :class:`VirtualMachineImagesEdgeZoneOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineImagesEdgeZoneOperations>`
           * 2021-07-01: :class:`VirtualMachineImagesEdgeZoneOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineImagesEdgeZoneOperations>`
           * 2021-11-01: :class:`VirtualMachineImagesEdgeZoneOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineImagesEdgeZoneOperations>`
           * 2022-03-01: :class:`VirtualMachineImagesEdgeZoneOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineImagesEdgeZoneOperations>`
           * 2022-08-01: :class:`VirtualMachineImagesEdgeZoneOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineImagesEdgeZoneOperations>`
        """
        api_version = self._get_api_version('virtual_machine_images_edge_zone')
        if api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineImagesEdgeZoneOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineImagesEdgeZoneOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineImagesEdgeZoneOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineImagesEdgeZoneOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineImagesEdgeZoneOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineImagesEdgeZoneOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineImagesEdgeZoneOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_images_edge_zone'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_run_commands(self):
        """Instance depends on the API version:

           * 2017-03-30: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2017_03_30.operations.VirtualMachineRunCommandsOperations>`
           * 2017-12-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2017_12_01.operations.VirtualMachineRunCommandsOperations>`
           * 2018-04-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2018_04_01.operations.VirtualMachineRunCommandsOperations>`
           * 2018-06-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2018_06_01.operations.VirtualMachineRunCommandsOperations>`
           * 2018-10-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2018_10_01.operations.VirtualMachineRunCommandsOperations>`
           * 2019-03-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2019_03_01.operations.VirtualMachineRunCommandsOperations>`
           * 2019-07-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2019_07_01.operations.VirtualMachineRunCommandsOperations>`
           * 2019-12-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2019_12_01.operations.VirtualMachineRunCommandsOperations>`
           * 2020-06-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachineRunCommandsOperations>`
           * 2020-12-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineRunCommandsOperations>`
           * 2021-03-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineRunCommandsOperations>`
           * 2021-04-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineRunCommandsOperations>`
           * 2021-07-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineRunCommandsOperations>`
           * 2021-11-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineRunCommandsOperations>`
           * 2022-03-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineRunCommandsOperations>`
           * 2022-08-01: :class:`VirtualMachineRunCommandsOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineRunCommandsOperations>`
        """
        api_version = self._get_api_version('virtual_machine_run_commands')
        if api_version == '2017-03-30':
            from .v2017_03_30.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineRunCommandsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_run_commands'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_scale_set_extensions(self):
        """Instance depends on the API version:

           * 2017-03-30: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2017_03_30.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2017-12-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2017_12_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2018-04-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2018_04_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2018-06-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2018_06_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2018-10-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2018_10_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2019-03-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2019_03_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2019-07-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2019_07_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2019-12-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2019_12_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2020-06-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2020-12-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2021-03-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2021-04-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2021-07-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2021-11-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2022-03-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineScaleSetExtensionsOperations>`
           * 2022-08-01: :class:`VirtualMachineScaleSetExtensionsOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineScaleSetExtensionsOperations>`
        """
        api_version = self._get_api_version('virtual_machine_scale_set_extensions')
        if api_version == '2017-03-30':
            from .v2017_03_30.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineScaleSetExtensionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_scale_set_extensions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_scale_set_rolling_upgrades(self):
        """Instance depends on the API version:

           * 2017-03-30: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2017_03_30.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2017-12-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2017_12_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2018-04-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2018_04_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2018-06-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2018_06_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2018-10-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2018_10_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2019-03-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2019_03_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2019-07-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2019_07_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2019-12-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2019_12_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2020-06-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2020-12-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2021-03-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2021-04-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2021-07-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2021-11-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2022-03-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
           * 2022-08-01: :class:`VirtualMachineScaleSetRollingUpgradesOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineScaleSetRollingUpgradesOperations>`
        """
        api_version = self._get_api_version('virtual_machine_scale_set_rolling_upgrades')
        if api_version == '2017-03-30':
            from .v2017_03_30.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineScaleSetRollingUpgradesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_scale_set_rolling_upgrades'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_scale_set_vm_extensions(self):
        """Instance depends on the API version:

           * 2019-07-01: :class:`VirtualMachineScaleSetVMExtensionsOperations<azure.mgmt.compute.v2019_07_01.operations.VirtualMachineScaleSetVMExtensionsOperations>`
           * 2019-12-01: :class:`VirtualMachineScaleSetVMExtensionsOperations<azure.mgmt.compute.v2019_12_01.operations.VirtualMachineScaleSetVMExtensionsOperations>`
           * 2020-06-01: :class:`VirtualMachineScaleSetVMExtensionsOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachineScaleSetVMExtensionsOperations>`
           * 2020-12-01: :class:`VirtualMachineScaleSetVMExtensionsOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineScaleSetVMExtensionsOperations>`
           * 2021-03-01: :class:`VirtualMachineScaleSetVMExtensionsOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineScaleSetVMExtensionsOperations>`
           * 2021-04-01: :class:`VirtualMachineScaleSetVMExtensionsOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineScaleSetVMExtensionsOperations>`
           * 2021-07-01: :class:`VirtualMachineScaleSetVMExtensionsOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineScaleSetVMExtensionsOperations>`
           * 2021-11-01: :class:`VirtualMachineScaleSetVMExtensionsOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineScaleSetVMExtensionsOperations>`
           * 2022-03-01: :class:`VirtualMachineScaleSetVMExtensionsOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineScaleSetVMExtensionsOperations>`
           * 2022-08-01: :class:`VirtualMachineScaleSetVMExtensionsOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineScaleSetVMExtensionsOperations>`
        """
        api_version = self._get_api_version('virtual_machine_scale_set_vm_extensions')
        if api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualMachineScaleSetVMExtensionsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualMachineScaleSetVMExtensionsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachineScaleSetVMExtensionsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineScaleSetVMExtensionsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineScaleSetVMExtensionsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineScaleSetVMExtensionsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineScaleSetVMExtensionsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineScaleSetVMExtensionsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineScaleSetVMExtensionsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineScaleSetVMExtensionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_scale_set_vm_extensions'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_scale_set_vm_run_commands(self):
        """Instance depends on the API version:

           * 2020-06-01: :class:`VirtualMachineScaleSetVMRunCommandsOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachineScaleSetVMRunCommandsOperations>`
           * 2020-12-01: :class:`VirtualMachineScaleSetVMRunCommandsOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineScaleSetVMRunCommandsOperations>`
           * 2021-03-01: :class:`VirtualMachineScaleSetVMRunCommandsOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineScaleSetVMRunCommandsOperations>`
           * 2021-04-01: :class:`VirtualMachineScaleSetVMRunCommandsOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineScaleSetVMRunCommandsOperations>`
           * 2021-07-01: :class:`VirtualMachineScaleSetVMRunCommandsOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineScaleSetVMRunCommandsOperations>`
           * 2021-11-01: :class:`VirtualMachineScaleSetVMRunCommandsOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineScaleSetVMRunCommandsOperations>`
           * 2022-03-01: :class:`VirtualMachineScaleSetVMRunCommandsOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineScaleSetVMRunCommandsOperations>`
           * 2022-08-01: :class:`VirtualMachineScaleSetVMRunCommandsOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineScaleSetVMRunCommandsOperations>`
        """
        api_version = self._get_api_version('virtual_machine_scale_set_vm_run_commands')
        if api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachineScaleSetVMRunCommandsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineScaleSetVMRunCommandsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineScaleSetVMRunCommandsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineScaleSetVMRunCommandsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineScaleSetVMRunCommandsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineScaleSetVMRunCommandsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineScaleSetVMRunCommandsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineScaleSetVMRunCommandsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_scale_set_vm_run_commands'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_scale_set_vms(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2015_06_15.operations.VirtualMachineScaleSetVMsOperations>`
           * 2016-03-30: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2016_03_30.operations.VirtualMachineScaleSetVMsOperations>`
           * 2016-04-30-preview: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2016_04_30_preview.operations.VirtualMachineScaleSetVMsOperations>`
           * 2017-03-30: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2017_03_30.operations.VirtualMachineScaleSetVMsOperations>`
           * 2017-12-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2017_12_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2018-04-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2018_04_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2018-06-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2018_06_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2018-10-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2018_10_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2019-03-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2019_03_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2019-07-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2019_07_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2019-12-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2019_12_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2020-06-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2020-12-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2021-03-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2021-04-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2021-07-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2021-11-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2022-03-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineScaleSetVMsOperations>`
           * 2022-08-01: :class:`VirtualMachineScaleSetVMsOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineScaleSetVMsOperations>`
        """
        api_version = self._get_api_version('virtual_machine_scale_set_vms')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2016-03-30':
            from .v2016_03_30.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_scale_set_vms'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_scale_sets(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2015_06_15.operations.VirtualMachineScaleSetsOperations>`
           * 2016-03-30: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2016_03_30.operations.VirtualMachineScaleSetsOperations>`
           * 2016-04-30-preview: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2016_04_30_preview.operations.VirtualMachineScaleSetsOperations>`
           * 2017-03-30: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2017_03_30.operations.VirtualMachineScaleSetsOperations>`
           * 2017-12-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2017_12_01.operations.VirtualMachineScaleSetsOperations>`
           * 2018-04-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2018_04_01.operations.VirtualMachineScaleSetsOperations>`
           * 2018-06-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2018_06_01.operations.VirtualMachineScaleSetsOperations>`
           * 2018-10-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2018_10_01.operations.VirtualMachineScaleSetsOperations>`
           * 2019-03-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2019_03_01.operations.VirtualMachineScaleSetsOperations>`
           * 2019-07-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2019_07_01.operations.VirtualMachineScaleSetsOperations>`
           * 2019-12-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2019_12_01.operations.VirtualMachineScaleSetsOperations>`
           * 2020-06-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachineScaleSetsOperations>`
           * 2020-12-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineScaleSetsOperations>`
           * 2021-03-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineScaleSetsOperations>`
           * 2021-04-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineScaleSetsOperations>`
           * 2021-07-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineScaleSetsOperations>`
           * 2021-11-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineScaleSetsOperations>`
           * 2022-03-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineScaleSetsOperations>`
           * 2022-08-01: :class:`VirtualMachineScaleSetsOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineScaleSetsOperations>`
        """
        api_version = self._get_api_version('virtual_machine_scale_sets')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2016-03-30':
            from .v2016_03_30.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineScaleSetsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_scale_sets'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machine_sizes(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2015_06_15.operations.VirtualMachineSizesOperations>`
           * 2016-03-30: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2016_03_30.operations.VirtualMachineSizesOperations>`
           * 2016-04-30-preview: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2016_04_30_preview.operations.VirtualMachineSizesOperations>`
           * 2017-03-30: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2017_03_30.operations.VirtualMachineSizesOperations>`
           * 2017-12-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2017_12_01.operations.VirtualMachineSizesOperations>`
           * 2018-04-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2018_04_01.operations.VirtualMachineSizesOperations>`
           * 2018-06-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2018_06_01.operations.VirtualMachineSizesOperations>`
           * 2018-10-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2018_10_01.operations.VirtualMachineSizesOperations>`
           * 2019-03-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2019_03_01.operations.VirtualMachineSizesOperations>`
           * 2019-07-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2019_07_01.operations.VirtualMachineSizesOperations>`
           * 2019-12-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2019_12_01.operations.VirtualMachineSizesOperations>`
           * 2020-06-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachineSizesOperations>`
           * 2020-12-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachineSizesOperations>`
           * 2021-03-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachineSizesOperations>`
           * 2021-04-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachineSizesOperations>`
           * 2021-07-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachineSizesOperations>`
           * 2021-11-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachineSizesOperations>`
           * 2022-03-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachineSizesOperations>`
           * 2022-08-01: :class:`VirtualMachineSizesOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachineSizesOperations>`
        """
        api_version = self._get_api_version('virtual_machine_sizes')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2016-03-30':
            from .v2016_03_30.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachineSizesOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachineSizesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machine_sizes'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def virtual_machines(self):
        """Instance depends on the API version:

           * 2015-06-15: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2015_06_15.operations.VirtualMachinesOperations>`
           * 2016-03-30: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2016_03_30.operations.VirtualMachinesOperations>`
           * 2016-04-30-preview: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2016_04_30_preview.operations.VirtualMachinesOperations>`
           * 2017-03-30: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2017_03_30.operations.VirtualMachinesOperations>`
           * 2017-12-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2017_12_01.operations.VirtualMachinesOperations>`
           * 2018-04-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2018_04_01.operations.VirtualMachinesOperations>`
           * 2018-06-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2018_06_01.operations.VirtualMachinesOperations>`
           * 2018-10-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2018_10_01.operations.VirtualMachinesOperations>`
           * 2019-03-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2019_03_01.operations.VirtualMachinesOperations>`
           * 2019-07-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2019_07_01.operations.VirtualMachinesOperations>`
           * 2019-12-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2019_12_01.operations.VirtualMachinesOperations>`
           * 2020-06-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2020_06_01.operations.VirtualMachinesOperations>`
           * 2020-12-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2020_12_01.operations.VirtualMachinesOperations>`
           * 2021-03-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2021_03_01.operations.VirtualMachinesOperations>`
           * 2021-04-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2021_04_01.operations.VirtualMachinesOperations>`
           * 2021-07-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2021_07_01.operations.VirtualMachinesOperations>`
           * 2021-11-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2021_11_01.operations.VirtualMachinesOperations>`
           * 2022-03-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2022_03_01.operations.VirtualMachinesOperations>`
           * 2022-08-01: :class:`VirtualMachinesOperations<azure.mgmt.compute.v2022_08_01.operations.VirtualMachinesOperations>`
        """
        api_version = self._get_api_version('virtual_machines')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2016-03-30':
            from .v2016_03_30.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2017-03-30':
            from .v2017_03_30.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2017-12-01':
            from .v2017_12_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2019-03-01':
            from .v2019_03_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2020-12-01':
            from .v2020_12_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2021-03-01':
            from .v2021_03_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2021-04-01':
            from .v2021_04_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2021-07-01':
            from .v2021_07_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2021-11-01':
            from .v2021_11_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2022-03-01':
            from .v2022_03_01.operations import VirtualMachinesOperations as OperationClass
        elif api_version == '2022-08-01':
            from .v2022_08_01.operations import VirtualMachinesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'virtual_machines'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    def close(self):
        self._client.close()
    def __enter__(self):
        self._client.__enter__()
        return self
    def __exit__(self, *exc_details):
        self._client.__exit__(*exc_details)
