# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for an Azure Resource Manager resource with an etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.etag = None


class Account(AzureEntityResource):  # pylint: disable=too-many-instance-attributes
    """Cognitive Services account is an Azure resource representing the provisioned account, it's type, location and SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar kind: The Kind of the resource.
    :vartype kind: str
    :ivar sku: The resource model definition representing SKU.
    :vartype sku: ~azure.mgmt.cognitiveservices.models.Sku
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.cognitiveservices.models.Identity
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.cognitiveservices.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Properties of Cognitive Services account.
    :vartype properties: ~azure.mgmt.cognitiveservices.models.AccountProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "AccountProperties"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        properties: Optional["_models.AccountProperties"] = None,
        **kwargs
    ):
        """
        :keyword kind: The Kind of the resource.
        :paramtype kind: str
        :keyword sku: The resource model definition representing SKU.
        :paramtype sku: ~azure.mgmt.cognitiveservices.models.Sku
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.cognitiveservices.models.Identity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Properties of Cognitive Services account.
        :paramtype properties: ~azure.mgmt.cognitiveservices.models.AccountProperties
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.sku = sku
        self.identity = identity
        self.system_data = None
        self.tags = tags
        self.location = location
        self.properties = properties


class AccountListResult(_serialization.Model):
    """The list of cognitive services accounts operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The link used to get the next page of accounts.
    :vartype next_link: str
    :ivar value: Gets the list of Cognitive Services accounts and their properties.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.Account]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Account]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The link used to get the next page of accounts.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class DeploymentModel(_serialization.Model):
    """Properties of Cognitive Services account deployment model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar format: Deployment model format.
    :vartype format: str
    :ivar name: Deployment model name.
    :vartype name: str
    :ivar version: Deployment model version.
    :vartype version: str
    :ivar call_rate_limit: The call rate limit Cognitive Services account.
    :vartype call_rate_limit: ~azure.mgmt.cognitiveservices.models.CallRateLimit
    """

    _validation = {
        "call_rate_limit": {"readonly": True},
    }

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "call_rate_limit": {"key": "callRateLimit", "type": "CallRateLimit"},
    }

    def __init__(
        self, *, format: Optional[str] = None, name: Optional[str] = None, version: Optional[str] = None, **kwargs
    ):
        """
        :keyword format: Deployment model format.
        :paramtype format: str
        :keyword name: Deployment model name.
        :paramtype name: str
        :keyword version: Deployment model version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.format = format
        self.name = name
        self.version = version
        self.call_rate_limit = None


class AccountModel(DeploymentModel):  # pylint: disable=too-many-instance-attributes
    """Cognitive Services account Model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar format: Deployment model format.
    :vartype format: str
    :ivar name: Deployment model name.
    :vartype name: str
    :ivar version: Deployment model version.
    :vartype version: str
    :ivar call_rate_limit: The call rate limit Cognitive Services account.
    :vartype call_rate_limit: ~azure.mgmt.cognitiveservices.models.CallRateLimit
    :ivar base_model: Base Model Identifier.
    :vartype base_model: ~azure.mgmt.cognitiveservices.models.DeploymentModel
    :ivar max_capacity: The max capacity.
    :vartype max_capacity: int
    :ivar capabilities: The capabilities.
    :vartype capabilities: dict[str, str]
    :ivar finetune_capabilities: The capabilities for finetune models.
    :vartype finetune_capabilities: dict[str, str]
    :ivar deprecation: Cognitive Services account ModelDeprecationInfo.
    :vartype deprecation: ~azure.mgmt.cognitiveservices.models.ModelDeprecationInfo
    :ivar lifecycle_status: Model lifecycle status. Known values are: "GenerallyAvailable" and
     "Preview".
    :vartype lifecycle_status: str or ~azure.mgmt.cognitiveservices.models.ModelLifecycleStatus
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.cognitiveservices.models.SystemData
    """

    _validation = {
        "call_rate_limit": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "call_rate_limit": {"key": "callRateLimit", "type": "CallRateLimit"},
        "base_model": {"key": "baseModel", "type": "DeploymentModel"},
        "max_capacity": {"key": "maxCapacity", "type": "int"},
        "capabilities": {"key": "capabilities", "type": "{str}"},
        "finetune_capabilities": {"key": "finetuneCapabilities", "type": "{str}"},
        "deprecation": {"key": "deprecation", "type": "ModelDeprecationInfo"},
        "lifecycle_status": {"key": "lifecycleStatus", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        format: Optional[str] = None,
        name: Optional[str] = None,
        version: Optional[str] = None,
        base_model: Optional["_models.DeploymentModel"] = None,
        max_capacity: Optional[int] = None,
        capabilities: Optional[Dict[str, str]] = None,
        finetune_capabilities: Optional[Dict[str, str]] = None,
        deprecation: Optional["_models.ModelDeprecationInfo"] = None,
        lifecycle_status: Optional[Union[str, "_models.ModelLifecycleStatus"]] = None,
        **kwargs
    ):
        """
        :keyword format: Deployment model format.
        :paramtype format: str
        :keyword name: Deployment model name.
        :paramtype name: str
        :keyword version: Deployment model version.
        :paramtype version: str
        :keyword base_model: Base Model Identifier.
        :paramtype base_model: ~azure.mgmt.cognitiveservices.models.DeploymentModel
        :keyword max_capacity: The max capacity.
        :paramtype max_capacity: int
        :keyword capabilities: The capabilities.
        :paramtype capabilities: dict[str, str]
        :keyword finetune_capabilities: The capabilities for finetune models.
        :paramtype finetune_capabilities: dict[str, str]
        :keyword deprecation: Cognitive Services account ModelDeprecationInfo.
        :paramtype deprecation: ~azure.mgmt.cognitiveservices.models.ModelDeprecationInfo
        :keyword lifecycle_status: Model lifecycle status. Known values are: "GenerallyAvailable" and
         "Preview".
        :paramtype lifecycle_status: str or ~azure.mgmt.cognitiveservices.models.ModelLifecycleStatus
        """
        super().__init__(format=format, name=name, version=version, **kwargs)
        self.base_model = base_model
        self.max_capacity = max_capacity
        self.capabilities = capabilities
        self.finetune_capabilities = finetune_capabilities
        self.deprecation = deprecation
        self.lifecycle_status = lifecycle_status
        self.system_data = None


class AccountModelListResult(_serialization.Model):
    """The list of cognitive services accounts operation response.

    :ivar next_link: The link used to get the next page of Model.
    :vartype next_link: str
    :ivar value: Gets the list of Cognitive Services accounts Model and their properties.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.AccountModel]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[AccountModel]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.AccountModel"]] = None, **kwargs
    ):
        """
        :keyword next_link: The link used to get the next page of Model.
        :paramtype next_link: str
        :keyword value: Gets the list of Cognitive Services accounts Model and their properties.
        :paramtype value: list[~azure.mgmt.cognitiveservices.models.AccountModel]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class AccountProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties of Cognitive Services account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Gets the status of the cognitive services account at the time the
     operation was called. Known values are: "Accepted", "Creating", "Deleting", "Moving", "Failed",
     "Succeeded", and "ResolvingDNS".
    :vartype provisioning_state: str or ~azure.mgmt.cognitiveservices.models.ProvisioningState
    :ivar endpoint: Endpoint of the created account.
    :vartype endpoint: str
    :ivar internal_id: The internal identifier (deprecated, do not use this property).
    :vartype internal_id: str
    :ivar capabilities: Gets the capabilities of the cognitive services account. Each item
     indicates the capability of a specific feature. The values are read-only and for reference
     only.
    :vartype capabilities: list[~azure.mgmt.cognitiveservices.models.SkuCapability]
    :ivar is_migrated: If the resource is migrated from an existing key.
    :vartype is_migrated: bool
    :ivar migration_token: Resource migration token.
    :vartype migration_token: str
    :ivar sku_change_info: Sku change info of account.
    :vartype sku_change_info: ~azure.mgmt.cognitiveservices.models.SkuChangeInfo
    :ivar custom_sub_domain_name: Optional subdomain name used for token-based authentication.
    :vartype custom_sub_domain_name: str
    :ivar network_acls: A collection of rules governing the accessibility from specific network
     locations.
    :vartype network_acls: ~azure.mgmt.cognitiveservices.models.NetworkRuleSet
    :ivar encryption: The encryption properties for this resource.
    :vartype encryption: ~azure.mgmt.cognitiveservices.models.Encryption
    :ivar user_owned_storage: The storage accounts for this resource.
    :vartype user_owned_storage: list[~azure.mgmt.cognitiveservices.models.UserOwnedStorage]
    :ivar private_endpoint_connections: The private endpoint connection associated with the
     Cognitive Services account.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.cognitiveservices.models.PrivateEndpointConnection]
    :ivar public_network_access: Whether or not public endpoint access is allowed for this account.
     Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.cognitiveservices.models.PublicNetworkAccess
    :ivar api_properties: The api properties for special APIs.
    :vartype api_properties: ~azure.mgmt.cognitiveservices.models.ApiProperties
    :ivar date_created: Gets the date of cognitive services account creation.
    :vartype date_created: str
    :ivar call_rate_limit: The call rate limit Cognitive Services account.
    :vartype call_rate_limit: ~azure.mgmt.cognitiveservices.models.CallRateLimit
    :ivar dynamic_throttling_enabled: The flag to enable dynamic throttling.
    :vartype dynamic_throttling_enabled: bool
    :ivar quota_limit:
    :vartype quota_limit: ~azure.mgmt.cognitiveservices.models.QuotaLimit
    :ivar restrict_outbound_network_access:
    :vartype restrict_outbound_network_access: bool
    :ivar allowed_fqdn_list:
    :vartype allowed_fqdn_list: list[str]
    :ivar disable_local_auth:
    :vartype disable_local_auth: bool
    :ivar endpoints: Dictionary of :code:`<string>`.
    :vartype endpoints: dict[str, str]
    :ivar restore:
    :vartype restore: bool
    :ivar deletion_date: The deletion date, only available for deleted account.
    :vartype deletion_date: str
    :ivar scheduled_purge_date: The scheduled purge date, only available for deleted account.
    :vartype scheduled_purge_date: str
    :ivar locations: The multiregion settings of Cognitive Services account.
    :vartype locations: ~azure.mgmt.cognitiveservices.models.MultiRegionSettings
    :ivar commitment_plan_associations: The commitment plan associations of Cognitive Services
     account.
    :vartype commitment_plan_associations:
     list[~azure.mgmt.cognitiveservices.models.CommitmentPlanAssociation]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "endpoint": {"readonly": True},
        "internal_id": {"readonly": True},
        "capabilities": {"readonly": True},
        "is_migrated": {"readonly": True},
        "sku_change_info": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "date_created": {"readonly": True},
        "call_rate_limit": {"readonly": True},
        "quota_limit": {"readonly": True},
        "endpoints": {"readonly": True},
        "deletion_date": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "commitment_plan_associations": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "endpoint": {"key": "endpoint", "type": "str"},
        "internal_id": {"key": "internalId", "type": "str"},
        "capabilities": {"key": "capabilities", "type": "[SkuCapability]"},
        "is_migrated": {"key": "isMigrated", "type": "bool"},
        "migration_token": {"key": "migrationToken", "type": "str"},
        "sku_change_info": {"key": "skuChangeInfo", "type": "SkuChangeInfo"},
        "custom_sub_domain_name": {"key": "customSubDomainName", "type": "str"},
        "network_acls": {"key": "networkAcls", "type": "NetworkRuleSet"},
        "encryption": {"key": "encryption", "type": "Encryption"},
        "user_owned_storage": {"key": "userOwnedStorage", "type": "[UserOwnedStorage]"},
        "private_endpoint_connections": {"key": "privateEndpointConnections", "type": "[PrivateEndpointConnection]"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "api_properties": {"key": "apiProperties", "type": "ApiProperties"},
        "date_created": {"key": "dateCreated", "type": "str"},
        "call_rate_limit": {"key": "callRateLimit", "type": "CallRateLimit"},
        "dynamic_throttling_enabled": {"key": "dynamicThrottlingEnabled", "type": "bool"},
        "quota_limit": {"key": "quotaLimit", "type": "QuotaLimit"},
        "restrict_outbound_network_access": {"key": "restrictOutboundNetworkAccess", "type": "bool"},
        "allowed_fqdn_list": {"key": "allowedFqdnList", "type": "[str]"},
        "disable_local_auth": {"key": "disableLocalAuth", "type": "bool"},
        "endpoints": {"key": "endpoints", "type": "{str}"},
        "restore": {"key": "restore", "type": "bool"},
        "deletion_date": {"key": "deletionDate", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "str"},
        "locations": {"key": "locations", "type": "MultiRegionSettings"},
        "commitment_plan_associations": {"key": "commitmentPlanAssociations", "type": "[CommitmentPlanAssociation]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        migration_token: Optional[str] = None,
        custom_sub_domain_name: Optional[str] = None,
        network_acls: Optional["_models.NetworkRuleSet"] = None,
        encryption: Optional["_models.Encryption"] = None,
        user_owned_storage: Optional[List["_models.UserOwnedStorage"]] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        api_properties: Optional["_models.ApiProperties"] = None,
        dynamic_throttling_enabled: Optional[bool] = None,
        restrict_outbound_network_access: Optional[bool] = None,
        allowed_fqdn_list: Optional[List[str]] = None,
        disable_local_auth: Optional[bool] = None,
        restore: Optional[bool] = None,
        locations: Optional["_models.MultiRegionSettings"] = None,
        **kwargs
    ):
        """
        :keyword migration_token: Resource migration token.
        :paramtype migration_token: str
        :keyword custom_sub_domain_name: Optional subdomain name used for token-based authentication.
        :paramtype custom_sub_domain_name: str
        :keyword network_acls: A collection of rules governing the accessibility from specific network
         locations.
        :paramtype network_acls: ~azure.mgmt.cognitiveservices.models.NetworkRuleSet
        :keyword encryption: The encryption properties for this resource.
        :paramtype encryption: ~azure.mgmt.cognitiveservices.models.Encryption
        :keyword user_owned_storage: The storage accounts for this resource.
        :paramtype user_owned_storage: list[~azure.mgmt.cognitiveservices.models.UserOwnedStorage]
        :keyword public_network_access: Whether or not public endpoint access is allowed for this
         account. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.cognitiveservices.models.PublicNetworkAccess
        :keyword api_properties: The api properties for special APIs.
        :paramtype api_properties: ~azure.mgmt.cognitiveservices.models.ApiProperties
        :keyword dynamic_throttling_enabled: The flag to enable dynamic throttling.
        :paramtype dynamic_throttling_enabled: bool
        :keyword restrict_outbound_network_access:
        :paramtype restrict_outbound_network_access: bool
        :keyword allowed_fqdn_list:
        :paramtype allowed_fqdn_list: list[str]
        :keyword disable_local_auth:
        :paramtype disable_local_auth: bool
        :keyword restore:
        :paramtype restore: bool
        :keyword locations: The multiregion settings of Cognitive Services account.
        :paramtype locations: ~azure.mgmt.cognitiveservices.models.MultiRegionSettings
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.endpoint = None
        self.internal_id = None
        self.capabilities = None
        self.is_migrated = None
        self.migration_token = migration_token
        self.sku_change_info = None
        self.custom_sub_domain_name = custom_sub_domain_name
        self.network_acls = network_acls
        self.encryption = encryption
        self.user_owned_storage = user_owned_storage
        self.private_endpoint_connections = None
        self.public_network_access = public_network_access
        self.api_properties = api_properties
        self.date_created = None
        self.call_rate_limit = None
        self.dynamic_throttling_enabled = dynamic_throttling_enabled
        self.quota_limit = None
        self.restrict_outbound_network_access = restrict_outbound_network_access
        self.allowed_fqdn_list = allowed_fqdn_list
        self.disable_local_auth = disable_local_auth
        self.endpoints = None
        self.restore = restore
        self.deletion_date = None
        self.scheduled_purge_date = None
        self.locations = locations
        self.commitment_plan_associations = None


class AccountSku(_serialization.Model):
    """Cognitive Services resource type and SKU.

    :ivar resource_type: Resource Namespace and Type.
    :vartype resource_type: str
    :ivar sku: The SKU of Cognitive Services account.
    :vartype sku: ~azure.mgmt.cognitiveservices.models.Sku
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(self, *, resource_type: Optional[str] = None, sku: Optional["_models.Sku"] = None, **kwargs):
        """
        :keyword resource_type: Resource Namespace and Type.
        :paramtype resource_type: str
        :keyword sku: The SKU of Cognitive Services account.
        :paramtype sku: ~azure.mgmt.cognitiveservices.models.Sku
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.sku = sku


class AccountSkuListResult(_serialization.Model):
    """The list of cognitive services accounts operation response.

    :ivar value: Gets the list of Cognitive Services accounts and their properties.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.AccountSku]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AccountSku]"},
    }

    def __init__(self, *, value: Optional[List["_models.AccountSku"]] = None, **kwargs):
        """
        :keyword value: Gets the list of Cognitive Services accounts and their properties.
        :paramtype value: list[~azure.mgmt.cognitiveservices.models.AccountSku]
        """
        super().__init__(**kwargs)
        self.value = value


class ApiKeys(_serialization.Model):
    """The access keys for the cognitive services account.

    :ivar key1: Gets the value of key 1.
    :vartype key1: str
    :ivar key2: Gets the value of key 2.
    :vartype key2: str
    """

    _attribute_map = {
        "key1": {"key": "key1", "type": "str"},
        "key2": {"key": "key2", "type": "str"},
    }

    def __init__(self, *, key1: Optional[str] = None, key2: Optional[str] = None, **kwargs):
        """
        :keyword key1: Gets the value of key 1.
        :paramtype key1: str
        :keyword key2: Gets the value of key 2.
        :paramtype key2: str
        """
        super().__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class ApiProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The api properties for special APIs.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar qna_runtime_endpoint: (QnAMaker Only) The runtime endpoint of QnAMaker.
    :vartype qna_runtime_endpoint: str
    :ivar qna_azure_search_endpoint_key: (QnAMaker Only) The Azure Search endpoint key of QnAMaker.
    :vartype qna_azure_search_endpoint_key: str
    :ivar qna_azure_search_endpoint_id: (QnAMaker Only) The Azure Search endpoint id of QnAMaker.
    :vartype qna_azure_search_endpoint_id: str
    :ivar statistics_enabled: (Bing Search Only) The flag to enable statistics of Bing Search.
    :vartype statistics_enabled: bool
    :ivar event_hub_connection_string: (Personalization Only) The flag to enable statistics of Bing
     Search.
    :vartype event_hub_connection_string: str
    :ivar storage_account_connection_string: (Personalization Only) The storage account connection
     string.
    :vartype storage_account_connection_string: str
    :ivar aad_client_id: (Metrics Advisor Only) The Azure AD Client Id (Application Id).
    :vartype aad_client_id: str
    :ivar aad_tenant_id: (Metrics Advisor Only) The Azure AD Tenant Id.
    :vartype aad_tenant_id: str
    :ivar super_user: (Metrics Advisor Only) The super user of Metrics Advisor.
    :vartype super_user: str
    :ivar website_name: (Metrics Advisor Only) The website name of Metrics Advisor.
    :vartype website_name: str
    """

    _validation = {
        "event_hub_connection_string": {
            "max_length": 1000,
            "pattern": r"^( *)Endpoint=sb://(.*);( *)SharedAccessKeyName=(.*);( *)SharedAccessKey=(.*)$",
        },
        "storage_account_connection_string": {
            "max_length": 1000,
            "pattern": r"^(( *)DefaultEndpointsProtocol=(http|https)( *);( *))?AccountName=(.*)AccountKey=(.*)EndpointSuffix=(.*)$",
        },
        "aad_client_id": {"max_length": 500},
        "aad_tenant_id": {"max_length": 500},
        "super_user": {"max_length": 500},
        "website_name": {"max_length": 500},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "qna_runtime_endpoint": {"key": "qnaRuntimeEndpoint", "type": "str"},
        "qna_azure_search_endpoint_key": {"key": "qnaAzureSearchEndpointKey", "type": "str"},
        "qna_azure_search_endpoint_id": {"key": "qnaAzureSearchEndpointId", "type": "str"},
        "statistics_enabled": {"key": "statisticsEnabled", "type": "bool"},
        "event_hub_connection_string": {"key": "eventHubConnectionString", "type": "str"},
        "storage_account_connection_string": {"key": "storageAccountConnectionString", "type": "str"},
        "aad_client_id": {"key": "aadClientId", "type": "str"},
        "aad_tenant_id": {"key": "aadTenantId", "type": "str"},
        "super_user": {"key": "superUser", "type": "str"},
        "website_name": {"key": "websiteName", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        qna_runtime_endpoint: Optional[str] = None,
        qna_azure_search_endpoint_key: Optional[str] = None,
        qna_azure_search_endpoint_id: Optional[str] = None,
        statistics_enabled: Optional[bool] = None,
        event_hub_connection_string: Optional[str] = None,
        storage_account_connection_string: Optional[str] = None,
        aad_client_id: Optional[str] = None,
        aad_tenant_id: Optional[str] = None,
        super_user: Optional[str] = None,
        website_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword qna_runtime_endpoint: (QnAMaker Only) The runtime endpoint of QnAMaker.
        :paramtype qna_runtime_endpoint: str
        :keyword qna_azure_search_endpoint_key: (QnAMaker Only) The Azure Search endpoint key of
         QnAMaker.
        :paramtype qna_azure_search_endpoint_key: str
        :keyword qna_azure_search_endpoint_id: (QnAMaker Only) The Azure Search endpoint id of
         QnAMaker.
        :paramtype qna_azure_search_endpoint_id: str
        :keyword statistics_enabled: (Bing Search Only) The flag to enable statistics of Bing Search.
        :paramtype statistics_enabled: bool
        :keyword event_hub_connection_string: (Personalization Only) The flag to enable statistics of
         Bing Search.
        :paramtype event_hub_connection_string: str
        :keyword storage_account_connection_string: (Personalization Only) The storage account
         connection string.
        :paramtype storage_account_connection_string: str
        :keyword aad_client_id: (Metrics Advisor Only) The Azure AD Client Id (Application Id).
        :paramtype aad_client_id: str
        :keyword aad_tenant_id: (Metrics Advisor Only) The Azure AD Tenant Id.
        :paramtype aad_tenant_id: str
        :keyword super_user: (Metrics Advisor Only) The super user of Metrics Advisor.
        :paramtype super_user: str
        :keyword website_name: (Metrics Advisor Only) The website name of Metrics Advisor.
        :paramtype website_name: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.qna_runtime_endpoint = qna_runtime_endpoint
        self.qna_azure_search_endpoint_key = qna_azure_search_endpoint_key
        self.qna_azure_search_endpoint_id = qna_azure_search_endpoint_id
        self.statistics_enabled = statistics_enabled
        self.event_hub_connection_string = event_hub_connection_string
        self.storage_account_connection_string = storage_account_connection_string
        self.aad_client_id = aad_client_id
        self.aad_tenant_id = aad_tenant_id
        self.super_user = super_user
        self.website_name = website_name


class CallRateLimit(_serialization.Model):
    """The call rate limit Cognitive Services account.

    :ivar count: The count value of Call Rate Limit.
    :vartype count: float
    :ivar renewal_period: The renewal period in seconds of Call Rate Limit.
    :vartype renewal_period: float
    :ivar rules:
    :vartype rules: list[~azure.mgmt.cognitiveservices.models.ThrottlingRule]
    """

    _attribute_map = {
        "count": {"key": "count", "type": "float"},
        "renewal_period": {"key": "renewalPeriod", "type": "float"},
        "rules": {"key": "rules", "type": "[ThrottlingRule]"},
    }

    def __init__(
        self,
        *,
        count: Optional[float] = None,
        renewal_period: Optional[float] = None,
        rules: Optional[List["_models.ThrottlingRule"]] = None,
        **kwargs
    ):
        """
        :keyword count: The count value of Call Rate Limit.
        :paramtype count: float
        :keyword renewal_period: The renewal period in seconds of Call Rate Limit.
        :paramtype renewal_period: float
        :keyword rules:
        :paramtype rules: list[~azure.mgmt.cognitiveservices.models.ThrottlingRule]
        """
        super().__init__(**kwargs)
        self.count = count
        self.renewal_period = renewal_period
        self.rules = rules


class CheckDomainAvailabilityParameter(_serialization.Model):
    """Check Domain availability parameter.

    All required parameters must be populated in order to send to Azure.

    :ivar subdomain_name: The subdomain name to use. Required.
    :vartype subdomain_name: str
    :ivar type: The Type of the resource. Required.
    :vartype type: str
    :ivar kind: The Kind of the resource.
    :vartype kind: str
    """

    _validation = {
        "subdomain_name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "subdomain_name": {"key": "subdomainName", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, *, subdomain_name: str, type: str, kind: Optional[str] = None, **kwargs):
        """
        :keyword subdomain_name: The subdomain name to use. Required.
        :paramtype subdomain_name: str
        :keyword type: The Type of the resource. Required.
        :paramtype type: str
        :keyword kind: The Kind of the resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.subdomain_name = subdomain_name
        self.type = type
        self.kind = kind


class CheckSkuAvailabilityParameter(_serialization.Model):
    """Check SKU availability parameter.

    All required parameters must be populated in order to send to Azure.

    :ivar skus: The SKU of the resource. Required.
    :vartype skus: list[str]
    :ivar kind: The Kind of the resource. Required.
    :vartype kind: str
    :ivar type: The Type of the resource. Required.
    :vartype type: str
    """

    _validation = {
        "skus": {"required": True},
        "kind": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "skus": {"key": "skus", "type": "[str]"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, skus: List[str], kind: str, type: str, **kwargs):
        """
        :keyword skus: The SKU of the resource. Required.
        :paramtype skus: list[str]
        :keyword kind: The Kind of the resource. Required.
        :paramtype kind: str
        :keyword type: The Type of the resource. Required.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.skus = skus
        self.kind = kind
        self.type = type


class CommitmentCost(_serialization.Model):
    """Cognitive Services account commitment cost.

    :ivar commitment_meter_id: Commitment meter Id.
    :vartype commitment_meter_id: str
    :ivar overage_meter_id: Overage meter Id.
    :vartype overage_meter_id: str
    """

    _attribute_map = {
        "commitment_meter_id": {"key": "commitmentMeterId", "type": "str"},
        "overage_meter_id": {"key": "overageMeterId", "type": "str"},
    }

    def __init__(self, *, commitment_meter_id: Optional[str] = None, overage_meter_id: Optional[str] = None, **kwargs):
        """
        :keyword commitment_meter_id: Commitment meter Id.
        :paramtype commitment_meter_id: str
        :keyword overage_meter_id: Overage meter Id.
        :paramtype overage_meter_id: str
        """
        super().__init__(**kwargs)
        self.commitment_meter_id = commitment_meter_id
        self.overage_meter_id = overage_meter_id


class CommitmentPeriod(_serialization.Model):
    """Cognitive Services account commitment period.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tier: Commitment period commitment tier.
    :vartype tier: str
    :ivar count: Commitment period commitment count.
    :vartype count: int
    :ivar quota: Cognitive Services account commitment quota.
    :vartype quota: ~azure.mgmt.cognitiveservices.models.CommitmentQuota
    :ivar start_date: Commitment period start date.
    :vartype start_date: str
    :ivar end_date: Commitment period end date.
    :vartype end_date: str
    """

    _validation = {
        "quota": {"readonly": True},
        "start_date": {"readonly": True},
        "end_date": {"readonly": True},
    }

    _attribute_map = {
        "tier": {"key": "tier", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "quota": {"key": "quota", "type": "CommitmentQuota"},
        "start_date": {"key": "startDate", "type": "str"},
        "end_date": {"key": "endDate", "type": "str"},
    }

    def __init__(self, *, tier: Optional[str] = None, count: Optional[int] = None, **kwargs):
        """
        :keyword tier: Commitment period commitment tier.
        :paramtype tier: str
        :keyword count: Commitment period commitment count.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.tier = tier
        self.count = count
        self.quota = None
        self.start_date = None
        self.end_date = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class CommitmentPlan(ProxyResource):
    """Cognitive Services account commitment plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.cognitiveservices.models.SystemData
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar kind: The Kind of the resource.
    :vartype kind: str
    :ivar sku: The resource model definition representing SKU.
    :vartype sku: ~azure.mgmt.cognitiveservices.models.Sku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Properties of Cognitive Services account commitment plan.
    :vartype properties: ~azure.mgmt.cognitiveservices.models.CommitmentPlanProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "CommitmentPlanProperties"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        properties: Optional["_models.CommitmentPlanProperties"] = None,
        **kwargs
    ):
        """
        :keyword kind: The Kind of the resource.
        :paramtype kind: str
        :keyword sku: The resource model definition representing SKU.
        :paramtype sku: ~azure.mgmt.cognitiveservices.models.Sku
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Properties of Cognitive Services account commitment plan.
        :paramtype properties: ~azure.mgmt.cognitiveservices.models.CommitmentPlanProperties
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.etag = None
        self.kind = kind
        self.sku = sku
        self.tags = tags
        self.location = location
        self.properties = properties


class CommitmentPlanAccountAssociation(ProxyResource):
    """The commitment plan association.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.cognitiveservices.models.SystemData
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar account_id: The Azure resource id of the account.
    :vartype account_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "account_id": {"key": "properties.accountId", "type": "str"},
    }

    def __init__(self, *, account_id: Optional[str] = None, **kwargs):
        """
        :keyword account_id: The Azure resource id of the account.
        :paramtype account_id: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.etag = None
        self.account_id = account_id


class CommitmentPlanAccountAssociationListResult(_serialization.Model):
    """The list of cognitive services Commitment Plan Account Association operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The link used to get the next page of Commitment Plan Account Association.
    :vartype next_link: str
    :ivar value: Gets the list of Cognitive Services Commitment Plan Account Association and their
     properties.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.CommitmentPlanAccountAssociation]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[CommitmentPlanAccountAssociation]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The link used to get the next page of Commitment Plan Account Association.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class CommitmentPlanAssociation(_serialization.Model):
    """The commitment plan association.

    :ivar commitment_plan_id: The Azure resource id of the commitment plan.
    :vartype commitment_plan_id: str
    :ivar commitment_plan_location: The location of of the commitment plan.
    :vartype commitment_plan_location: str
    """

    _attribute_map = {
        "commitment_plan_id": {"key": "commitmentPlanId", "type": "str"},
        "commitment_plan_location": {"key": "commitmentPlanLocation", "type": "str"},
    }

    def __init__(
        self, *, commitment_plan_id: Optional[str] = None, commitment_plan_location: Optional[str] = None, **kwargs
    ):
        """
        :keyword commitment_plan_id: The Azure resource id of the commitment plan.
        :paramtype commitment_plan_id: str
        :keyword commitment_plan_location: The location of of the commitment plan.
        :paramtype commitment_plan_location: str
        """
        super().__init__(**kwargs)
        self.commitment_plan_id = commitment_plan_id
        self.commitment_plan_location = commitment_plan_location


class CommitmentPlanListResult(_serialization.Model):
    """The list of cognitive services accounts operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The link used to get the next page of CommitmentPlan.
    :vartype next_link: str
    :ivar value: Gets the list of Cognitive Services accounts CommitmentPlan and their properties.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.CommitmentPlan]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[CommitmentPlan]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The link used to get the next page of CommitmentPlan.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class CommitmentPlanProperties(_serialization.Model):
    """Properties of Cognitive Services account commitment plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Gets the status of the resource at the time the operation was called.
     Known values are: "Accepted", "Creating", "Deleting", "Moving", "Failed", "Succeeded", and
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.cognitiveservices.models.CommitmentPlanProvisioningState
    :ivar commitment_plan_guid: Commitment plan guid.
    :vartype commitment_plan_guid: str
    :ivar hosting_model: Account hosting model. Known values are: "Web", "ConnectedContainer", and
     "DisconnectedContainer".
    :vartype hosting_model: str or ~azure.mgmt.cognitiveservices.models.HostingModel
    :ivar plan_type: Commitment plan type.
    :vartype plan_type: str
    :ivar current: Cognitive Services account commitment period.
    :vartype current: ~azure.mgmt.cognitiveservices.models.CommitmentPeriod
    :ivar auto_renew: AutoRenew commitment plan.
    :vartype auto_renew: bool
    :ivar next: Cognitive Services account commitment period.
    :vartype next: ~azure.mgmt.cognitiveservices.models.CommitmentPeriod
    :ivar last: Cognitive Services account commitment period.
    :vartype last: ~azure.mgmt.cognitiveservices.models.CommitmentPeriod
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "last": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "commitment_plan_guid": {"key": "commitmentPlanGuid", "type": "str"},
        "hosting_model": {"key": "hostingModel", "type": "str"},
        "plan_type": {"key": "planType", "type": "str"},
        "current": {"key": "current", "type": "CommitmentPeriod"},
        "auto_renew": {"key": "autoRenew", "type": "bool"},
        "next": {"key": "next", "type": "CommitmentPeriod"},
        "last": {"key": "last", "type": "CommitmentPeriod"},
    }

    def __init__(
        self,
        *,
        commitment_plan_guid: Optional[str] = None,
        hosting_model: Optional[Union[str, "_models.HostingModel"]] = None,
        plan_type: Optional[str] = None,
        current: Optional["_models.CommitmentPeriod"] = None,
        auto_renew: Optional[bool] = None,
        next: Optional["_models.CommitmentPeriod"] = None,
        **kwargs
    ):
        """
        :keyword commitment_plan_guid: Commitment plan guid.
        :paramtype commitment_plan_guid: str
        :keyword hosting_model: Account hosting model. Known values are: "Web", "ConnectedContainer",
         and "DisconnectedContainer".
        :paramtype hosting_model: str or ~azure.mgmt.cognitiveservices.models.HostingModel
        :keyword plan_type: Commitment plan type.
        :paramtype plan_type: str
        :keyword current: Cognitive Services account commitment period.
        :paramtype current: ~azure.mgmt.cognitiveservices.models.CommitmentPeriod
        :keyword auto_renew: AutoRenew commitment plan.
        :paramtype auto_renew: bool
        :keyword next: Cognitive Services account commitment period.
        :paramtype next: ~azure.mgmt.cognitiveservices.models.CommitmentPeriod
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.commitment_plan_guid = commitment_plan_guid
        self.hosting_model = hosting_model
        self.plan_type = plan_type
        self.current = current
        self.auto_renew = auto_renew
        self.next = next
        self.last = None


class CommitmentQuota(_serialization.Model):
    """Cognitive Services account commitment quota.

    :ivar quantity: Commitment quota quantity.
    :vartype quantity: int
    :ivar unit: Commitment quota unit.
    :vartype unit: str
    """

    _attribute_map = {
        "quantity": {"key": "quantity", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(self, *, quantity: Optional[int] = None, unit: Optional[str] = None, **kwargs):
        """
        :keyword quantity: Commitment quota quantity.
        :paramtype quantity: int
        :keyword unit: Commitment quota unit.
        :paramtype unit: str
        """
        super().__init__(**kwargs)
        self.quantity = quantity
        self.unit = unit


class CommitmentTier(_serialization.Model):
    """Cognitive Services account commitment tier.

    :ivar kind: The Kind of the resource.
    :vartype kind: str
    :ivar sku_name: The name of the SKU. Ex - P3. It is typically a letter+number code.
    :vartype sku_name: str
    :ivar hosting_model: Account hosting model. Known values are: "Web", "ConnectedContainer", and
     "DisconnectedContainer".
    :vartype hosting_model: str or ~azure.mgmt.cognitiveservices.models.HostingModel
    :ivar plan_type: Commitment plan type.
    :vartype plan_type: str
    :ivar tier: Commitment period commitment tier.
    :vartype tier: str
    :ivar max_count: Commitment period commitment max count.
    :vartype max_count: int
    :ivar quota: Cognitive Services account commitment quota.
    :vartype quota: ~azure.mgmt.cognitiveservices.models.CommitmentQuota
    :ivar cost: Cognitive Services account commitment cost.
    :vartype cost: ~azure.mgmt.cognitiveservices.models.CommitmentCost
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "sku_name": {"key": "skuName", "type": "str"},
        "hosting_model": {"key": "hostingModel", "type": "str"},
        "plan_type": {"key": "planType", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "max_count": {"key": "maxCount", "type": "int"},
        "quota": {"key": "quota", "type": "CommitmentQuota"},
        "cost": {"key": "cost", "type": "CommitmentCost"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku_name: Optional[str] = None,
        hosting_model: Optional[Union[str, "_models.HostingModel"]] = None,
        plan_type: Optional[str] = None,
        tier: Optional[str] = None,
        max_count: Optional[int] = None,
        quota: Optional["_models.CommitmentQuota"] = None,
        cost: Optional["_models.CommitmentCost"] = None,
        **kwargs
    ):
        """
        :keyword kind: The Kind of the resource.
        :paramtype kind: str
        :keyword sku_name: The name of the SKU. Ex - P3. It is typically a letter+number code.
        :paramtype sku_name: str
        :keyword hosting_model: Account hosting model. Known values are: "Web", "ConnectedContainer",
         and "DisconnectedContainer".
        :paramtype hosting_model: str or ~azure.mgmt.cognitiveservices.models.HostingModel
        :keyword plan_type: Commitment plan type.
        :paramtype plan_type: str
        :keyword tier: Commitment period commitment tier.
        :paramtype tier: str
        :keyword max_count: Commitment period commitment max count.
        :paramtype max_count: int
        :keyword quota: Cognitive Services account commitment quota.
        :paramtype quota: ~azure.mgmt.cognitiveservices.models.CommitmentQuota
        :keyword cost: Cognitive Services account commitment cost.
        :paramtype cost: ~azure.mgmt.cognitiveservices.models.CommitmentCost
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.sku_name = sku_name
        self.hosting_model = hosting_model
        self.plan_type = plan_type
        self.tier = tier
        self.max_count = max_count
        self.quota = quota
        self.cost = cost


class CommitmentTierListResult(_serialization.Model):
    """The list of cognitive services accounts operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The link used to get the next page of CommitmentTier.
    :vartype next_link: str
    :ivar value: Gets the list of Cognitive Services accounts CommitmentTier and their properties.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.CommitmentTier]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[CommitmentTier]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The link used to get the next page of CommitmentTier.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class Deployment(ProxyResource):
    """Cognitive Services account deployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.cognitiveservices.models.SystemData
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar properties: Properties of Cognitive Services account deployment.
    :vartype properties: ~azure.mgmt.cognitiveservices.models.DeploymentProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "etag", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DeploymentProperties"] = None, **kwargs):
        """
        :keyword properties: Properties of Cognitive Services account deployment.
        :paramtype properties: ~azure.mgmt.cognitiveservices.models.DeploymentProperties
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.etag = None
        self.properties = properties


class DeploymentListResult(_serialization.Model):
    """The list of cognitive services accounts operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The link used to get the next page of Deployment.
    :vartype next_link: str
    :ivar value: Gets the list of Cognitive Services accounts Deployment and their properties.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.Deployment]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Deployment]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The link used to get the next page of Deployment.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class DeploymentProperties(_serialization.Model):
    """Properties of Cognitive Services account deployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Gets the status of the resource at the time the operation was called.
     Known values are: "Accepted", "Creating", "Deleting", "Moving", "Failed", and "Succeeded".
    :vartype provisioning_state: str or
     ~azure.mgmt.cognitiveservices.models.DeploymentProvisioningState
    :ivar model: Properties of Cognitive Services account deployment model.
    :vartype model: ~azure.mgmt.cognitiveservices.models.DeploymentModel
    :ivar scale_settings: Properties of Cognitive Services account deployment model.
    :vartype scale_settings: ~azure.mgmt.cognitiveservices.models.DeploymentScaleSettings
    :ivar capabilities: The capabilities.
    :vartype capabilities: dict[str, str]
    :ivar rai_policy_name: The name of RAI policy.
    :vartype rai_policy_name: str
    :ivar call_rate_limit: The call rate limit Cognitive Services account.
    :vartype call_rate_limit: ~azure.mgmt.cognitiveservices.models.CallRateLimit
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "capabilities": {"readonly": True},
        "call_rate_limit": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "model": {"key": "model", "type": "DeploymentModel"},
        "scale_settings": {"key": "scaleSettings", "type": "DeploymentScaleSettings"},
        "capabilities": {"key": "capabilities", "type": "{str}"},
        "rai_policy_name": {"key": "raiPolicyName", "type": "str"},
        "call_rate_limit": {"key": "callRateLimit", "type": "CallRateLimit"},
    }

    def __init__(
        self,
        *,
        model: Optional["_models.DeploymentModel"] = None,
        scale_settings: Optional["_models.DeploymentScaleSettings"] = None,
        rai_policy_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword model: Properties of Cognitive Services account deployment model.
        :paramtype model: ~azure.mgmt.cognitiveservices.models.DeploymentModel
        :keyword scale_settings: Properties of Cognitive Services account deployment model.
        :paramtype scale_settings: ~azure.mgmt.cognitiveservices.models.DeploymentScaleSettings
        :keyword rai_policy_name: The name of RAI policy.
        :paramtype rai_policy_name: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.model = model
        self.scale_settings = scale_settings
        self.capabilities = None
        self.rai_policy_name = rai_policy_name
        self.call_rate_limit = None


class DeploymentScaleSettings(_serialization.Model):
    """Properties of Cognitive Services account deployment model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar scale_type: Deployment scale type. Known values are: "Standard" and "Manual".
    :vartype scale_type: str or ~azure.mgmt.cognitiveservices.models.DeploymentScaleType
    :ivar capacity: Deployment capacity.
    :vartype capacity: int
    :ivar active_capacity: Deployment active capacity. This value might be different from
     ``capacity`` if customer recently updated ``capacity``.
    :vartype active_capacity: int
    """

    _validation = {
        "active_capacity": {"readonly": True},
    }

    _attribute_map = {
        "scale_type": {"key": "scaleType", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
        "active_capacity": {"key": "activeCapacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        scale_type: Optional[Union[str, "_models.DeploymentScaleType"]] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword scale_type: Deployment scale type. Known values are: "Standard" and "Manual".
        :paramtype scale_type: str or ~azure.mgmt.cognitiveservices.models.DeploymentScaleType
        :keyword capacity: Deployment capacity.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.scale_type = scale_type
        self.capacity = capacity
        self.active_capacity = None


class DomainAvailability(_serialization.Model):
    """Domain availability.

    :ivar is_subdomain_available: Indicates the given SKU is available or not.
    :vartype is_subdomain_available: bool
    :ivar reason: Reason why the SKU is not available.
    :vartype reason: str
    :ivar subdomain_name: The subdomain name to use.
    :vartype subdomain_name: str
    :ivar type: The Type of the resource.
    :vartype type: str
    :ivar kind: The Kind of the resource.
    :vartype kind: str
    """

    _attribute_map = {
        "is_subdomain_available": {"key": "isSubdomainAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "subdomain_name": {"key": "subdomainName", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(
        self,
        *,
        is_subdomain_available: Optional[bool] = None,
        reason: Optional[str] = None,
        subdomain_name: Optional[str] = None,
        type: Optional[str] = None,
        kind: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword is_subdomain_available: Indicates the given SKU is available or not.
        :paramtype is_subdomain_available: bool
        :keyword reason: Reason why the SKU is not available.
        :paramtype reason: str
        :keyword subdomain_name: The subdomain name to use.
        :paramtype subdomain_name: str
        :keyword type: The Type of the resource.
        :paramtype type: str
        :keyword kind: The Kind of the resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.is_subdomain_available = is_subdomain_available
        self.reason = reason
        self.subdomain_name = subdomain_name
        self.type = type
        self.kind = kind


class Encryption(_serialization.Model):
    """Properties to configure Encryption.

    :ivar key_vault_properties: Properties of KeyVault.
    :vartype key_vault_properties: ~azure.mgmt.cognitiveservices.models.KeyVaultProperties
    :ivar key_source: Enumerates the possible value of keySource for Encryption. Known values are:
     "Microsoft.CognitiveServices" and "Microsoft.KeyVault".
    :vartype key_source: str or ~azure.mgmt.cognitiveservices.models.KeySource
    """

    _attribute_map = {
        "key_vault_properties": {"key": "keyVaultProperties", "type": "KeyVaultProperties"},
        "key_source": {"key": "keySource", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
        key_source: Union[str, "_models.KeySource"] = "Microsoft.KeyVault",
        **kwargs
    ):
        """
        :keyword key_vault_properties: Properties of KeyVault.
        :paramtype key_vault_properties: ~azure.mgmt.cognitiveservices.models.KeyVaultProperties
        :keyword key_source: Enumerates the possible value of keySource for Encryption. Known values
         are: "Microsoft.CognitiveServices" and "Microsoft.KeyVault".
        :paramtype key_source: str or ~azure.mgmt.cognitiveservices.models.KeySource
        """
        super().__init__(**kwargs)
        self.key_vault_properties = key_vault_properties
        self.key_source = key_source


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.cognitiveservices.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.cognitiveservices.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.cognitiveservices.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.cognitiveservices.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The identity type. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.cognitiveservices.models.ResourceIdentityType
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar user_assigned_identities: The list of user assigned identities associated with the
     resource. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.cognitiveservices.models.UserAssignedIdentity]
    """

    _validation = {
        "tenant_id": {"readonly": True},
        "principal_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: The identity type. Known values are: "None", "SystemAssigned", "UserAssigned",
         and "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.cognitiveservices.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user assigned identities associated with the
         resource. The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.cognitiveservices.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.tenant_id = None
        self.principal_id = None
        self.user_assigned_identities = user_assigned_identities


class IpRule(_serialization.Model):
    """A rule governing the accessibility from a specific ip address or ip range.

    All required parameters must be populated in order to send to Azure.

    :ivar value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address)
     or '124.56.78.0/24' (all addresses that start with 124.56.78). Required.
    :vartype value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: str, **kwargs):
        """
        :keyword value: An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP
         address) or '124.56.78.0/24' (all addresses that start with 124.56.78). Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value


class KeyVaultProperties(_serialization.Model):
    """Properties to configure keyVault Properties.

    :ivar key_name: Name of the Key from KeyVault.
    :vartype key_name: str
    :ivar key_version: Version of the Key from KeyVault.
    :vartype key_version: str
    :ivar key_vault_uri: Uri of KeyVault.
    :vartype key_vault_uri: str
    :ivar identity_client_id:
    :vartype identity_client_id: str
    """

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
        "key_version": {"key": "keyVersion", "type": "str"},
        "key_vault_uri": {"key": "keyVaultUri", "type": "str"},
        "identity_client_id": {"key": "identityClientId", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_name: Optional[str] = None,
        key_version: Optional[str] = None,
        key_vault_uri: Optional[str] = None,
        identity_client_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_name: Name of the Key from KeyVault.
        :paramtype key_name: str
        :keyword key_version: Version of the Key from KeyVault.
        :paramtype key_version: str
        :keyword key_vault_uri: Uri of KeyVault.
        :paramtype key_vault_uri: str
        :keyword identity_client_id:
        :paramtype identity_client_id: str
        """
        super().__init__(**kwargs)
        self.key_name = key_name
        self.key_version = key_version
        self.key_vault_uri = key_vault_uri
        self.identity_client_id = identity_client_id


class MetricName(_serialization.Model):
    """A metric name.

    :ivar value: The name of the metric.
    :vartype value: str
    :ivar localized_value: The friendly name of the metric.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs):
        """
        :keyword value: The name of the metric.
        :paramtype value: str
        :keyword localized_value: The friendly name of the metric.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class ModelDeprecationInfo(_serialization.Model):
    """Cognitive Services account ModelDeprecationInfo.

    :ivar fine_tune: The datetime of deprecation of the fineTune Model.
    :vartype fine_tune: str
    :ivar inference: The datetime of deprecation of the inference Model.
    :vartype inference: str
    """

    _attribute_map = {
        "fine_tune": {"key": "fineTune", "type": "str"},
        "inference": {"key": "inference", "type": "str"},
    }

    def __init__(self, *, fine_tune: Optional[str] = None, inference: Optional[str] = None, **kwargs):
        """
        :keyword fine_tune: The datetime of deprecation of the fineTune Model.
        :paramtype fine_tune: str
        :keyword inference: The datetime of deprecation of the inference Model.
        :paramtype inference: str
        """
        super().__init__(**kwargs)
        self.fine_tune = fine_tune
        self.inference = inference


class MultiRegionSettings(_serialization.Model):
    """The multiregion settings Cognitive Services account.

    :ivar routing_method: Multiregion routing methods. Known values are: "Priority", "Weighted",
     and "Performance".
    :vartype routing_method: str or ~azure.mgmt.cognitiveservices.models.RoutingMethods
    :ivar regions:
    :vartype regions: list[~azure.mgmt.cognitiveservices.models.RegionSetting]
    """

    _attribute_map = {
        "routing_method": {"key": "routingMethod", "type": "str"},
        "regions": {"key": "regions", "type": "[RegionSetting]"},
    }

    def __init__(
        self,
        *,
        routing_method: Optional[Union[str, "_models.RoutingMethods"]] = None,
        regions: Optional[List["_models.RegionSetting"]] = None,
        **kwargs
    ):
        """
        :keyword routing_method: Multiregion routing methods. Known values are: "Priority", "Weighted",
         and "Performance".
        :paramtype routing_method: str or ~azure.mgmt.cognitiveservices.models.RoutingMethods
        :keyword regions:
        :paramtype regions: list[~azure.mgmt.cognitiveservices.models.RegionSetting]
        """
        super().__init__(**kwargs)
        self.routing_method = routing_method
        self.regions = regions


class NetworkRuleSet(_serialization.Model):
    """A set of rules governing the network accessibility.

    :ivar default_action: The default action when no rule from ipRules and from virtualNetworkRules
     match. This is only used after the bypass property has been evaluated. Known values are:
     "Allow" and "Deny".
    :vartype default_action: str or ~azure.mgmt.cognitiveservices.models.NetworkRuleAction
    :ivar ip_rules: The list of IP address rules.
    :vartype ip_rules: list[~azure.mgmt.cognitiveservices.models.IpRule]
    :ivar virtual_network_rules: The list of virtual network rules.
    :vartype virtual_network_rules: list[~azure.mgmt.cognitiveservices.models.VirtualNetworkRule]
    """

    _attribute_map = {
        "default_action": {"key": "defaultAction", "type": "str"},
        "ip_rules": {"key": "ipRules", "type": "[IpRule]"},
        "virtual_network_rules": {"key": "virtualNetworkRules", "type": "[VirtualNetworkRule]"},
    }

    def __init__(
        self,
        *,
        default_action: Optional[Union[str, "_models.NetworkRuleAction"]] = None,
        ip_rules: Optional[List["_models.IpRule"]] = None,
        virtual_network_rules: Optional[List["_models.VirtualNetworkRule"]] = None,
        **kwargs
    ):
        """
        :keyword default_action: The default action when no rule from ipRules and from
         virtualNetworkRules match. This is only used after the bypass property has been evaluated.
         Known values are: "Allow" and "Deny".
        :paramtype default_action: str or ~azure.mgmt.cognitiveservices.models.NetworkRuleAction
        :keyword ip_rules: The list of IP address rules.
        :paramtype ip_rules: list[~azure.mgmt.cognitiveservices.models.IpRule]
        :keyword virtual_network_rules: The list of virtual network rules.
        :paramtype virtual_network_rules: list[~azure.mgmt.cognitiveservices.models.VirtualNetworkRule]
        """
        super().__init__(**kwargs)
        self.default_action = default_action
        self.ip_rules = ip_rules
        self.virtual_network_rules = virtual_network_rules


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.cognitiveservices.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.cognitiveservices.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.cognitiveservices.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.cognitiveservices.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PatchResourceTags(_serialization.Model):
    """The object being used to update tags of a resource, in general used for PATCH operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class PatchResourceTagsAndSku(PatchResourceTags):
    """The object being used to update tags and sku of a resource, in general used for PATCH operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The resource model definition representing SKU.
    :vartype sku: ~azure.mgmt.cognitiveservices.models.Sku
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, sku: Optional["_models.Sku"] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The resource model definition representing SKU.
        :paramtype sku: ~azure.mgmt.cognitiveservices.models.Sku
        """
        super().__init__(tags=tags, **kwargs)
        self.sku = sku


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(AzureEntityResource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.cognitiveservices.models.PrivateEndpointConnectionProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.cognitiveservices.models.SystemData
    :ivar location: The location of the private endpoint connection.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnectionProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword properties: Resource properties.
        :paramtype properties: ~azure.mgmt.cognitiveservices.models.PrivateEndpointConnectionProperties
        :keyword location: The location of the private endpoint connection.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.system_data = None
        self.location = location


class PrivateEndpointConnectionListResult(_serialization.Model):
    """A list of private endpoint connections.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs):
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.cognitiveservices.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateEndpointConnectionProperties(_serialization.Model):
    """Properties of the PrivateEndpointConnectProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.cognitiveservices.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.cognitiveservices.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.cognitiveservices.models.PrivateEndpointConnectionProvisioningState
    :ivar group_ids: The private link resource group ids.
    :vartype group_ids: list[str]
    """

    _validation = {
        "private_link_service_connection_state": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "private_endpoint": {"key": "privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "group_ids": {"key": "groupIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        group_ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.cognitiveservices.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider. Required.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.cognitiveservices.models.PrivateLinkServiceConnectionState
        :keyword group_ids: The private link resource group ids.
        :paramtype group_ids: list[str]
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None
        self.group_ids = group_ids


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.cognitiveservices.models.PrivateLinkResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateLinkResourceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.PrivateLinkResourceProperties"] = None, **kwargs):
        """
        :keyword properties: Resource properties.
        :paramtype properties: ~azure.mgmt.cognitiveservices.models.PrivateLinkResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs):
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.cognitiveservices.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkResourceProperties(_serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    :ivar display_name: The private link resource display name.
    :vartype display_name: str
    """

    _validation = {
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
        "display_name": {"readonly": True},
    }

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs):
        """
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names
        self.display_name = None


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.cognitiveservices.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or
         ~azure.mgmt.cognitiveservices.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class QuotaLimit(_serialization.Model):
    """QuotaLimit.

    :ivar count:
    :vartype count: float
    :ivar renewal_period:
    :vartype renewal_period: float
    :ivar rules:
    :vartype rules: list[~azure.mgmt.cognitiveservices.models.ThrottlingRule]
    """

    _attribute_map = {
        "count": {"key": "count", "type": "float"},
        "renewal_period": {"key": "renewalPeriod", "type": "float"},
        "rules": {"key": "rules", "type": "[ThrottlingRule]"},
    }

    def __init__(
        self,
        *,
        count: Optional[float] = None,
        renewal_period: Optional[float] = None,
        rules: Optional[List["_models.ThrottlingRule"]] = None,
        **kwargs
    ):
        """
        :keyword count:
        :paramtype count: float
        :keyword renewal_period:
        :paramtype renewal_period: float
        :keyword rules:
        :paramtype rules: list[~azure.mgmt.cognitiveservices.models.ThrottlingRule]
        """
        super().__init__(**kwargs)
        self.count = count
        self.renewal_period = renewal_period
        self.rules = rules


class RegenerateKeyParameters(_serialization.Model):
    """Regenerate key parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: key name to generate (Key1|Key2). Required. Known values are: "Key1" and
     "Key2".
    :vartype key_name: str or ~azure.mgmt.cognitiveservices.models.KeyName
    """

    _validation = {
        "key_name": {"required": True},
    }

    _attribute_map = {
        "key_name": {"key": "keyName", "type": "str"},
    }

    def __init__(self, *, key_name: Union[str, "_models.KeyName"], **kwargs):
        """
        :keyword key_name: key name to generate (Key1|Key2). Required. Known values are: "Key1" and
         "Key2".
        :paramtype key_name: str or ~azure.mgmt.cognitiveservices.models.KeyName
        """
        super().__init__(**kwargs)
        self.key_name = key_name


class RegionSetting(_serialization.Model):
    """The call rate limit Cognitive Services account.

    :ivar name: Name of the region.
    :vartype name: str
    :ivar value: A value for priority or weighted routing methods.
    :vartype value: float
    :ivar customsubdomain: Maps the region to the regional custom subdomain.
    :vartype customsubdomain: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "float"},
        "customsubdomain": {"key": "customsubdomain", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[float] = None,
        customsubdomain: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the region.
        :paramtype name: str
        :keyword value: A value for priority or weighted routing methods.
        :paramtype value: float
        :keyword customsubdomain: Maps the region to the regional custom subdomain.
        :paramtype customsubdomain: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.customsubdomain = customsubdomain


class RequestMatchPattern(_serialization.Model):
    """RequestMatchPattern.

    :ivar path:
    :vartype path: str
    :ivar method:
    :vartype method: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "method": {"key": "method", "type": "str"},
    }

    def __init__(self, *, path: Optional[str] = None, method: Optional[str] = None, **kwargs):
        """
        :keyword path:
        :paramtype path: str
        :keyword method:
        :paramtype method: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.method = method


class ResourceSku(_serialization.Model):
    """Describes an available Cognitive Services SKU.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU.
    :vartype name: str
    :ivar tier: Specifies the tier of Cognitive Services account.
    :vartype tier: str
    :ivar kind: The Kind of resources that are supported in this SKU.
    :vartype kind: str
    :ivar locations: The set of locations that the SKU is available.
    :vartype locations: list[str]
    :ivar restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :vartype restrictions: list[~azure.mgmt.cognitiveservices.models.ResourceSkuRestrictions]
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "restrictions": {"key": "restrictions", "type": "[ResourceSkuRestrictions]"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        kind: Optional[str] = None,
        locations: Optional[List[str]] = None,
        restrictions: Optional[List["_models.ResourceSkuRestrictions"]] = None,
        **kwargs
    ):
        """
        :keyword resource_type: The type of resource the SKU applies to.
        :paramtype resource_type: str
        :keyword name: The name of SKU.
        :paramtype name: str
        :keyword tier: Specifies the tier of Cognitive Services account.
        :paramtype tier: str
        :keyword kind: The Kind of resources that are supported in this SKU.
        :paramtype kind: str
        :keyword locations: The set of locations that the SKU is available.
        :paramtype locations: list[str]
        :keyword restrictions: The restrictions because of which SKU cannot be used. This is empty if
         there are no restrictions.
        :paramtype restrictions: list[~azure.mgmt.cognitiveservices.models.ResourceSkuRestrictions]
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.name = name
        self.tier = tier
        self.kind = kind
        self.locations = locations
        self.restrictions = restrictions


class ResourceSkuListResult(_serialization.Model):
    """The Get Skus operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of skus available for the subscription. Required.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.ResourceSku]
    :ivar next_link: The uri to fetch the next page of Skus.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceSku"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of skus available for the subscription. Required.
        :paramtype value: list[~azure.mgmt.cognitiveservices.models.ResourceSku]
        :keyword next_link: The uri to fetch the next page of Skus.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceSkuRestrictionInfo(_serialization.Model):
    """ResourceSkuRestrictionInfo.

    :ivar locations: Locations where the SKU is restricted.
    :vartype locations: list[str]
    :ivar zones: List of availability zones where the SKU is restricted.
    :vartype zones: list[str]
    """

    _attribute_map = {
        "locations": {"key": "locations", "type": "[str]"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(self, *, locations: Optional[List[str]] = None, zones: Optional[List[str]] = None, **kwargs):
        """
        :keyword locations: Locations where the SKU is restricted.
        :paramtype locations: list[str]
        :keyword zones: List of availability zones where the SKU is restricted.
        :paramtype zones: list[str]
        """
        super().__init__(**kwargs)
        self.locations = locations
        self.zones = zones


class ResourceSkuRestrictions(_serialization.Model):
    """Describes restrictions of a SKU.

    :ivar type: The type of restrictions. Known values are: "Location" and "Zone".
    :vartype type: str or ~azure.mgmt.cognitiveservices.models.ResourceSkuRestrictionsType
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar restriction_info: The information about the restriction where the SKU cannot be used.
    :vartype restriction_info: ~azure.mgmt.cognitiveservices.models.ResourceSkuRestrictionInfo
    :ivar reason_code: The reason for restriction. Known values are: "QuotaId" and
     "NotAvailableForSubscription".
    :vartype reason_code: str or
     ~azure.mgmt.cognitiveservices.models.ResourceSkuRestrictionsReasonCode
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "restriction_info": {"key": "restrictionInfo", "type": "ResourceSkuRestrictionInfo"},
        "reason_code": {"key": "reasonCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceSkuRestrictionsType"]] = None,
        values: Optional[List[str]] = None,
        restriction_info: Optional["_models.ResourceSkuRestrictionInfo"] = None,
        reason_code: Optional[Union[str, "_models.ResourceSkuRestrictionsReasonCode"]] = None,
        **kwargs
    ):
        """
        :keyword type: The type of restrictions. Known values are: "Location" and "Zone".
        :paramtype type: str or ~azure.mgmt.cognitiveservices.models.ResourceSkuRestrictionsType
        :keyword values: The value of restrictions. If the restriction type is set to location. This
         would be different locations where the SKU is restricted.
        :paramtype values: list[str]
        :keyword restriction_info: The information about the restriction where the SKU cannot be used.
        :paramtype restriction_info: ~azure.mgmt.cognitiveservices.models.ResourceSkuRestrictionInfo
        :keyword reason_code: The reason for restriction. Known values are: "QuotaId" and
         "NotAvailableForSubscription".
        :paramtype reason_code: str or
         ~azure.mgmt.cognitiveservices.models.ResourceSkuRestrictionsReasonCode
        """
        super().__init__(**kwargs)
        self.type = type
        self.values = values
        self.restriction_info = restriction_info
        self.reason_code = reason_code


class Sku(_serialization.Model):
    """The resource model definition representing SKU.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the SKU. Ex - P3. It is typically a letter+number code. Required.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
     "Standard", "Premium", and "Enterprise".
    :vartype tier: str or ~azure.mgmt.cognitiveservices.models.SkuTier
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the SKU. Ex - P3. It is typically a letter+number code. Required.
        :paramtype name: str
        :keyword tier: This field is required to be implemented by the Resource Provider if the service
         has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
         "Standard", "Premium", and "Enterprise".
        :paramtype tier: str or ~azure.mgmt.cognitiveservices.models.SkuTier
        :keyword size: The SKU size. When the name field is the combination of tier and some other
         value, this would be the standalone code.
        :paramtype size: str
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword capacity: If the SKU supports scale out/in then the capacity integer should be
         included. If scale out/in is not possible for the resource this may be omitted.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity


class SkuAvailability(_serialization.Model):
    """SKU availability.

    :ivar kind: The Kind of the resource.
    :vartype kind: str
    :ivar type: The Type of the resource.
    :vartype type: str
    :ivar sku_name: The SKU of Cognitive Services account.
    :vartype sku_name: str
    :ivar sku_available: Indicates the given SKU is available or not.
    :vartype sku_available: bool
    :ivar reason: Reason why the SKU is not available.
    :vartype reason: str
    :ivar message: Additional error message.
    :vartype message: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku_name": {"key": "skuName", "type": "str"},
        "sku_available": {"key": "skuAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        type: Optional[str] = None,
        sku_name: Optional[str] = None,
        sku_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword kind: The Kind of the resource.
        :paramtype kind: str
        :keyword type: The Type of the resource.
        :paramtype type: str
        :keyword sku_name: The SKU of Cognitive Services account.
        :paramtype sku_name: str
        :keyword sku_available: Indicates the given SKU is available or not.
        :paramtype sku_available: bool
        :keyword reason: Reason why the SKU is not available.
        :paramtype reason: str
        :keyword message: Additional error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.type = type
        self.sku_name = sku_name
        self.sku_available = sku_available
        self.reason = reason
        self.message = message


class SkuAvailabilityListResult(_serialization.Model):
    """Check SKU availability result list.

    :ivar value: Check SKU availability result list.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.SkuAvailability]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SkuAvailability]"},
    }

    def __init__(self, *, value: Optional[List["_models.SkuAvailability"]] = None, **kwargs):
        """
        :keyword value: Check SKU availability result list.
        :paramtype value: list[~azure.mgmt.cognitiveservices.models.SkuAvailability]
        """
        super().__init__(**kwargs)
        self.value = value


class SkuCapability(_serialization.Model):
    """SkuCapability indicates the capability of a certain feature.

    :ivar name: The name of the SkuCapability.
    :vartype name: str
    :ivar value: The value of the SkuCapability.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs):
        """
        :keyword name: The name of the SkuCapability.
        :paramtype name: str
        :keyword value: The value of the SkuCapability.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class SkuChangeInfo(_serialization.Model):
    """Sku change info of account.

    :ivar count_of_downgrades: Gets the count of downgrades.
    :vartype count_of_downgrades: float
    :ivar count_of_upgrades_after_downgrades: Gets the count of upgrades after downgrades.
    :vartype count_of_upgrades_after_downgrades: float
    :ivar last_change_date: Gets the last change date.
    :vartype last_change_date: str
    """

    _attribute_map = {
        "count_of_downgrades": {"key": "countOfDowngrades", "type": "float"},
        "count_of_upgrades_after_downgrades": {"key": "countOfUpgradesAfterDowngrades", "type": "float"},
        "last_change_date": {"key": "lastChangeDate", "type": "str"},
    }

    def __init__(
        self,
        *,
        count_of_downgrades: Optional[float] = None,
        count_of_upgrades_after_downgrades: Optional[float] = None,
        last_change_date: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword count_of_downgrades: Gets the count of downgrades.
        :paramtype count_of_downgrades: float
        :keyword count_of_upgrades_after_downgrades: Gets the count of upgrades after downgrades.
        :paramtype count_of_upgrades_after_downgrades: float
        :keyword last_change_date: Gets the last change date.
        :paramtype last_change_date: str
        """
        super().__init__(**kwargs)
        self.count_of_downgrades = count_of_downgrades
        self.count_of_upgrades_after_downgrades = count_of_upgrades_after_downgrades
        self.last_change_date = last_change_date


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.cognitiveservices.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.cognitiveservices.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.cognitiveservices.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.cognitiveservices.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class ThrottlingRule(_serialization.Model):
    """ThrottlingRule.

    :ivar key:
    :vartype key: str
    :ivar renewal_period:
    :vartype renewal_period: float
    :ivar count:
    :vartype count: float
    :ivar min_count:
    :vartype min_count: float
    :ivar dynamic_throttling_enabled:
    :vartype dynamic_throttling_enabled: bool
    :ivar match_patterns:
    :vartype match_patterns: list[~azure.mgmt.cognitiveservices.models.RequestMatchPattern]
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "renewal_period": {"key": "renewalPeriod", "type": "float"},
        "count": {"key": "count", "type": "float"},
        "min_count": {"key": "minCount", "type": "float"},
        "dynamic_throttling_enabled": {"key": "dynamicThrottlingEnabled", "type": "bool"},
        "match_patterns": {"key": "matchPatterns", "type": "[RequestMatchPattern]"},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        renewal_period: Optional[float] = None,
        count: Optional[float] = None,
        min_count: Optional[float] = None,
        dynamic_throttling_enabled: Optional[bool] = None,
        match_patterns: Optional[List["_models.RequestMatchPattern"]] = None,
        **kwargs
    ):
        """
        :keyword key:
        :paramtype key: str
        :keyword renewal_period:
        :paramtype renewal_period: float
        :keyword count:
        :paramtype count: float
        :keyword min_count:
        :paramtype min_count: float
        :keyword dynamic_throttling_enabled:
        :paramtype dynamic_throttling_enabled: bool
        :keyword match_patterns:
        :paramtype match_patterns: list[~azure.mgmt.cognitiveservices.models.RequestMatchPattern]
        """
        super().__init__(**kwargs)
        self.key = key
        self.renewal_period = renewal_period
        self.count = count
        self.min_count = min_count
        self.dynamic_throttling_enabled = dynamic_throttling_enabled
        self.match_patterns = match_patterns


class Usage(_serialization.Model):
    """The usage data for a usage request.

    :ivar unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds", "Percent",
     "CountPerSecond", "BytesPerSecond", and "Milliseconds".
    :vartype unit: str or ~azure.mgmt.cognitiveservices.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.cognitiveservices.models.MetricName
    :ivar quota_period: The quota period used to summarize the usage values.
    :vartype quota_period: str
    :ivar limit: Maximum value for this metric.
    :vartype limit: float
    :ivar current_value: Current value for this metric.
    :vartype current_value: float
    :ivar next_reset_time: Next reset time for current quota.
    :vartype next_reset_time: str
    :ivar status: Cognitive Services account quota usage status. Known values are: "Included",
     "Blocked", "InOverage", and "Unknown".
    :vartype status: str or ~azure.mgmt.cognitiveservices.models.QuotaUsageStatus
    """

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "name": {"key": "name", "type": "MetricName"},
        "quota_period": {"key": "quotaPeriod", "type": "str"},
        "limit": {"key": "limit", "type": "float"},
        "current_value": {"key": "currentValue", "type": "float"},
        "next_reset_time": {"key": "nextResetTime", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        unit: Optional[Union[str, "_models.UnitType"]] = None,
        name: Optional["_models.MetricName"] = None,
        quota_period: Optional[str] = None,
        limit: Optional[float] = None,
        current_value: Optional[float] = None,
        next_reset_time: Optional[str] = None,
        status: Optional[Union[str, "_models.QuotaUsageStatus"]] = None,
        **kwargs
    ):
        """
        :keyword unit: The unit of the metric. Known values are: "Count", "Bytes", "Seconds",
         "Percent", "CountPerSecond", "BytesPerSecond", and "Milliseconds".
        :paramtype unit: str or ~azure.mgmt.cognitiveservices.models.UnitType
        :keyword name: The name information for the metric.
        :paramtype name: ~azure.mgmt.cognitiveservices.models.MetricName
        :keyword quota_period: The quota period used to summarize the usage values.
        :paramtype quota_period: str
        :keyword limit: Maximum value for this metric.
        :paramtype limit: float
        :keyword current_value: Current value for this metric.
        :paramtype current_value: float
        :keyword next_reset_time: Next reset time for current quota.
        :paramtype next_reset_time: str
        :keyword status: Cognitive Services account quota usage status. Known values are: "Included",
         "Blocked", "InOverage", and "Unknown".
        :paramtype status: str or ~azure.mgmt.cognitiveservices.models.QuotaUsageStatus
        """
        super().__init__(**kwargs)
        self.unit = unit
        self.name = name
        self.quota_period = quota_period
        self.limit = limit
        self.current_value = current_value
        self.next_reset_time = next_reset_time
        self.status = status


class UsageListResult(_serialization.Model):
    """The response to a list usage request.

    :ivar value: The list of usages for Cognitive Service account.
    :vartype value: list[~azure.mgmt.cognitiveservices.models.Usage]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
    }

    def __init__(self, *, value: Optional[List["_models.Usage"]] = None, **kwargs):
        """
        :keyword value: The list of usages for Cognitive Service account.
        :paramtype value: list[~azure.mgmt.cognitiveservices.models.Usage]
        """
        super().__init__(**kwargs)
        self.value = value


class UserAssignedIdentity(_serialization.Model):
    """User-assigned managed identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Azure Active Directory principal ID associated with this Identity.
    :vartype principal_id: str
    :ivar client_id: Client App Id associated with this identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserOwnedStorage(_serialization.Model):
    """The user owned storage for Cognitive Services account.

    :ivar resource_id: Full resource id of a Microsoft.Storage resource.
    :vartype resource_id: str
    :ivar identity_client_id:
    :vartype identity_client_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "identity_client_id": {"key": "identityClientId", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, identity_client_id: Optional[str] = None, **kwargs):
        """
        :keyword resource_id: Full resource id of a Microsoft.Storage resource.
        :paramtype resource_id: str
        :keyword identity_client_id:
        :paramtype identity_client_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.identity_client_id = identity_client_id


class VirtualNetworkRule(_serialization.Model):
    """A rule governing the accessibility from a specific virtual network.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Full resource id of a vnet subnet, such as
     '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     Required.
    :vartype id: str
    :ivar state: Gets the state of virtual network rule.
    :vartype state: str
    :ivar ignore_missing_vnet_service_endpoint: Ignore missing vnet service endpoint or not.
    :vartype ignore_missing_vnet_service_endpoint: bool
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "ignore_missing_vnet_service_endpoint": {"key": "ignoreMissingVnetServiceEndpoint", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        state: Optional[str] = None,
        ignore_missing_vnet_service_endpoint: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword id: Full resource id of a vnet subnet, such as
         '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
         Required.
        :paramtype id: str
        :keyword state: Gets the state of virtual network rule.
        :paramtype state: str
        :keyword ignore_missing_vnet_service_endpoint: Ignore missing vnet service endpoint or not.
        :paramtype ignore_missing_vnet_service_endpoint: bool
        """
        super().__init__(**kwargs)
        self.id = id
        self.state = state
        self.ignore_missing_vnet_service_endpoint = ignore_missing_vnet_service_endpoint
