************************************************************************
* This file is part of OpenMolcas.                                     *
*                                                                      *
* OpenMolcas is free software; you can redistribute it and/or modify   *
* it under the terms of the GNU Lesser General Public License, v. 2.1. *
* OpenMolcas is distributed in the hope that it will be useful, but it *
* is provided "as is" and without any express or implied warranties.   *
* For more details see the full text of the license in the file        *
* LICENSE or in <http://www.gnu.org/licenses/>.                        *
*                                                                      *
* Copyright (C) 1992, Per-Olof Widmark                                 *
*               1992, Markus P. Fuelscher                              *
*               1992, Piotr Borowski                                   *
************************************************************************
      SubRoutine Start0x(CMO,mBB,nD,EOr,mmB)
************************************************************************
*                                                                      *
* This routine reads start orbitals generated by guessorb.             *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
* Author:  Per-Olof Widmark                                            *
*                                                                      *
*                                                                      *
*     written by:                                                      *
*     P.O. Widmark, M.P. Fuelscher and P. Borowski                     *
*     University of Lund, Sweden, 1992                                 *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*     history: none                                                    *
*                                                                      *
************************************************************************
      Implicit Real*8 (a-h,o-z)
#include "mxdm.fh"
#include "infscf.fh"
*
      Real*8 CMO(mBB,nD), EOr(mmB,nD)
      Logical Found
*
*----------------------------------------------------------------------*
* Get start orbitals.                                                  *
*----------------------------------------------------------------------*
*
      iRC=0
      Call qpg_darray('Guessorb',Found,ndata)
      If (Found) Then
         If (nData.ne.mBB) Then
            Write (6,*) 'Start0x: nData.ne.mBB'
            Write (6,*) '         nData=',nData
            Write (6,*) '         mBB  =',mBB
            Call Abend()
         End If
         Call get_darray('Guessorb',CMO(1,1),ndata)
      Else
         iRC=-1
      End If
      If (iRC.ne.0) Then
         Write (6,*) 'Start0x: no orbitals found!'
         Call Abend()
      End If
*
      iRC=0
      Call qpg_darray('Guessorb energies',found,ndata)
      If (Found) Then
         If (nData.ne.mmB) Then
            Write (6,*) 'Start0x: nData.ne.mmB'
            Write (6,*) '         nData=',nData
            Write (6,*) '         mmB  =',mmB
            Call Abend()
         End If
         Call get_darray('Guessorb energies',EOr(1,1),ndata)
      Else
         iRC=-1
      End If
      If (iRC.ne.0) Then
         Write (6,*) 'Start0x: no energies found!'
         Call Abend()
      End If
*
      If (nD.eq.2) Then
         Call dCopy_(mBB,CMO(1,1),1,CMO(1,2),1)
         Call dCopy_(mmB,EOr(1,1),1,EOr(1,2),1)
      End If
*
      Call qpg_iarray('nDel_go',Found,ndata)
      nSum=0
      If (Found) Then
         Call Get_iArray('nDel_go',nDel,ndata)
         Call Put_iArray('nDel',nDel,ndata)
         Do iSym=1,nSym
            nSum=nSum+nDel(iSym)
         End Do
      End If
*
      If (nSum.gt.0) Then
         Do iSym=1,nSym
            nOrb(iSym)=nBas(iSym)-nDel(iSym)
         End Do
         Do iD = 1, nD
            Call TrimCMO(CMO(1,iD),CMO(1,iD),nSym,nBas,nOrb)
            Call TrimEor(EOr(1,iD),EOr(1,iD),nSym,nBas,nOrb)
         End Do
      End If
*
*----------------------------------------------------------------------*
* Done                                                                 *
*----------------------------------------------------------------------*
      Return
      End
