// Mgmt
// Copyright (C) 2013-2024+ James Shubin and the project contributors
// Written by James Shubin <james@shubin.ca> and the project contributors
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.
//
// Additional permission under GNU GPL version 3 section 7
//
// If you modify this program, or any covered work, by linking or combining it
// with embedded mcl code and modules (and that the embedded mcl code and
// modules which link with this program, contain a copy of their source code in
// the authoritative form) containing parts covered by the terms of any other
// license, the licensors of this program grant you additional permission to
// convey the resulting work. Furthermore, the licensors of this program grant
// the original author, James Shubin, additional permission to update this
// additional permission if he deems it necessary to achieve the goals of this
// additional permission.

package fuzz

import (
	"bytes"

	"github.com/purpleidea/mgmt/lang/parser"
)

// Fuzz is repeatedly called by go-fuzz with semi-random inputs in an attempt to
// make the Lexer/Parser crash. From the go-fuzz docs: Data is a random input
// generated by go-fuzz, note that in most cases it is invalid. The function
// must return 1 if the fuzzer should increase priority of the given input
// during subsequent fuzzing (for example, the input is lexically correct and
// was parsed successfully); -1 if the input must not be added to corpus even if
// gives new coverage; and 0 otherwise; other values are reserved for future
// use.
func Fuzz(data []byte) int {
	ast, err := parser.LexParse(bytes.NewReader(data))
	if err != nil {
		if ast != nil {
			panic("ast != nil on error")
		}
		return 0
	}
	return 1
}
