/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_x_ol2.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t24, t26, t27, t30, t31, t33, t38;
  double t39, t40, t42, t46, tzk0;

  gga_x_ol2_params *params;

  assert(p->params != NULL);
  params = (gga_x_ol2_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = params->bb * sigma[0];
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = rho[0] * rho[0];
  t24 = t18 * t18;
  t26 = 0.1e1 / t24 / t23;
  t27 = t22 * t26;
  t30 = sqrt(sigma[0]);
  t31 = params->cc * t30;
  t33 = 0.1e1 / t18 / rho[0];
  t38 = 0.4e1 * t30 * t21 * t33 + t21;
  t39 = 0.1e1 / t38;
  t40 = t21 * t33 * t39;
  t42 = params->aa + 0.13888888888888888889e-1 * t20 * t27 + t31 * t40;
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t24, t26, t27, t30, t31, t33, t38;
  double t39, t40, t42, t46, tzk0;

  double t48, t52, t54, t55, t61, t64, t65, t66;
  double t67, t70, t75, tvrho0, t78, t81, t82, t85;
  double t89, t93, tvsigma0;

  gga_x_ol2_params *params;

  assert(p->params != NULL);
  params = (gga_x_ol2_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = params->bb * sigma[0];
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = rho[0] * rho[0];
  t24 = t18 * t18;
  t26 = 0.1e1 / t24 / t23;
  t27 = t22 * t26;
  t30 = sqrt(sigma[0]);
  t31 = params->cc * t30;
  t33 = 0.1e1 / t18 / rho[0];
  t38 = 0.4e1 * t30 * t21 * t33 + t21;
  t39 = 0.1e1 / t38;
  t40 = t21 * t33 * t39;
  t42 = params->aa + 0.13888888888888888889e-1 * t20 * t27 + t31 * t40;
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = t17 / t24;
  t52 = t23 * rho[0];
  t54 = 0.1e1 / t24 / t52;
  t55 = t22 * t54;
  t61 = t21 / t18 / t23 * t39;
  t64 = params->cc * sigma[0];
  t65 = t38 * t38;
  t66 = 0.1e1 / t65;
  t67 = t55 * t66;
  t70 = -0.37037037037037037037e-1 * t20 * t55 - 0.4e1 / 0.3e1 * t31 * t61 + 0.16e2 / 0.3e1 * t64 * t67;
  t75 = my_piecewise3(t2, 0, -t6 * t48 * t42 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t70);
  tvrho0 = 0.2e1 * rho[0] * t75 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t78 = params->bb * t22;
  t81 = 0.1e1 / t30;
  t82 = params->cc * t81;
  t85 = params->cc * t22;
  t89 = 0.13888888888888888889e-1 * t78 * t26 + t82 * t40 / 0.2e1 - 0.2e1 * t85 * t26 * t66;
  t93 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t89);
  tvsigma0 = 0.2e1 * rho[0] * t93;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t24, t26, t27, t30, t31, t33, t38;
  double t39, t40, t42, t46, tzk0;

  double t48, t52, t54, t55, t61, t64, t65, t66;
  double t67, t70, t75, tvrho0, t78, t81, t82, t85;
  double t89, t93, tvsigma0;

  double t98, t105, t107, t108, t114, t117, t120, t121;
  double t122, t123, t125, t126, t129, t134, tv2rho20, t147;
  double t148, t150, t153, t158, tv2rhosigma0, t161, t162, t165;
  double t166, t167, t169, t174, t178, tv2sigma20;

  gga_x_ol2_params *params;

  assert(p->params != NULL);
  params = (gga_x_ol2_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = params->bb * sigma[0];
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = rho[0] * rho[0];
  t24 = t18 * t18;
  t26 = 0.1e1 / t24 / t23;
  t27 = t22 * t26;
  t30 = sqrt(sigma[0]);
  t31 = params->cc * t30;
  t33 = 0.1e1 / t18 / rho[0];
  t38 = 0.4e1 * t30 * t21 * t33 + t21;
  t39 = 0.1e1 / t38;
  t40 = t21 * t33 * t39;
  t42 = params->aa + 0.13888888888888888889e-1 * t20 * t27 + t31 * t40;
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = t17 / t24;
  t52 = t23 * rho[0];
  t54 = 0.1e1 / t24 / t52;
  t55 = t22 * t54;
  t61 = t21 / t18 / t23 * t39;
  t64 = params->cc * sigma[0];
  t65 = t38 * t38;
  t66 = 0.1e1 / t65;
  t67 = t55 * t66;
  t70 = -0.37037037037037037037e-1 * t20 * t55 - 0.4e1 / 0.3e1 * t31 * t61 + 0.16e2 / 0.3e1 * t64 * t67;
  t75 = my_piecewise3(t2, 0, -t6 * t48 * t42 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t70);
  tvrho0 = 0.2e1 * rho[0] * t75 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t78 = params->bb * t22;
  t81 = 0.1e1 / t30;
  t82 = params->cc * t81;
  t85 = params->cc * t22;
  t89 = 0.13888888888888888889e-1 * t78 * t26 + t82 * t40 / 0.2e1 - 0.2e1 * t85 * t26 * t66;
  t93 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t89);
  tvsigma0 = 0.2e1 * rho[0] * t93;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t98 = t17 / t24 / rho[0];
  t105 = t23 * t23;
  t107 = 0.1e1 / t24 / t105;
  t108 = t22 * t107;
  t114 = t21 / t18 / t52 * t39;
  t117 = t108 * t66;
  t120 = t30 * sigma[0];
  t121 = params->cc * t120;
  t122 = t105 * t23;
  t123 = 0.1e1 / t122;
  t125 = 0.1e1 / t65 / t38;
  t126 = t123 * t125;
  t129 = 0.13580246913580246914e0 * t20 * t108 + 0.28e2 / 0.9e1 * t31 * t114 - 0.8e2 / 0.3e1 * t64 * t117 + 0.1024e4 / 0.9e1 * t121 * t126;
  t134 = my_piecewise3(t2, 0, t6 * t98 * t42 / 0.12e2 - t6 * t48 * t70 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t129);
  tv2rho20 = 0.2e1 * rho[0] * t134 + 0.4e1 * t75;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t147 = t105 * rho[0];
  t148 = 0.1e1 / t147;
  t150 = t125 * t30;
  t153 = -0.37037037037037037037e-1 * t78 * t54 - 0.2e1 / 0.3e1 * t82 * t61 + 0.8e1 * t85 * t54 * t66 - 0.128e3 / 0.3e1 * params->cc * t148 * t150;
  t158 = my_piecewise3(t2, 0, -t6 * t48 * t89 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t153);
  tv2rhosigma0 = 0.2e1 * rho[0] * t158 + 0.2e1 * t93;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t161 = 0.1e1 / t120;
  t162 = params->cc * t161;
  t165 = 0.1e1 / sigma[0];
  t166 = params->cc * t165;
  t167 = t27 * t66;
  t169 = 0.1e1 / t105;
  t174 = -t162 * t40 / 0.4e1 - t166 * t167 + 0.16e2 * params->cc * t169 * t125 * t81;
  t178 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t174);
  tv2sigma20 = 0.2e1 * rho[0] * t178;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t24, t26, t27, t30, t31, t33, t38;
  double t39, t40, t42, t46, tzk0;

  double t48, t52, t54, t55, t61, t64, t65, t66;
  double t67, t70, t75, tvrho0, t78, t81, t82, t85;
  double t89, t93, tvsigma0;

  double t98, t105, t107, t108, t114, t117, t120, t121;
  double t122, t123, t125, t126, t129, t134, tv2rho20, t147;
  double t148, t150, t153, t158, tv2rhosigma0, t161, t162, t165;
  double t166, t167, t169, t174, t178, tv2sigma20;

  double t181, t192, t193, t199, t205, t206, t210, t211;
  double t212, t214, t215, t216, t221, t226, tv3rho30, t248;
  double t250, t253, t258, tv3rho2sigma0, t268, t273, t274, t277;
  double t282, tv3rhosigma20, t285, t287, t290, t291, t295, t296;
  double t298, t301, t305, tv3sigma30;

  gga_x_ol2_params *params;

  assert(p->params != NULL);
  params = (gga_x_ol2_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = params->bb * sigma[0];
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = rho[0] * rho[0];
  t24 = t18 * t18;
  t26 = 0.1e1 / t24 / t23;
  t27 = t22 * t26;
  t30 = sqrt(sigma[0]);
  t31 = params->cc * t30;
  t33 = 0.1e1 / t18 / rho[0];
  t38 = 0.4e1 * t30 * t21 * t33 + t21;
  t39 = 0.1e1 / t38;
  t40 = t21 * t33 * t39;
  t42 = params->aa + 0.13888888888888888889e-1 * t20 * t27 + t31 * t40;
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = t17 / t24;
  t52 = t23 * rho[0];
  t54 = 0.1e1 / t24 / t52;
  t55 = t22 * t54;
  t61 = t21 / t18 / t23 * t39;
  t64 = params->cc * sigma[0];
  t65 = t38 * t38;
  t66 = 0.1e1 / t65;
  t67 = t55 * t66;
  t70 = -0.37037037037037037037e-1 * t20 * t55 - 0.4e1 / 0.3e1 * t31 * t61 + 0.16e2 / 0.3e1 * t64 * t67;
  t75 = my_piecewise3(t2, 0, -t6 * t48 * t42 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t70);
  tvrho0 = 0.2e1 * rho[0] * t75 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t78 = params->bb * t22;
  t81 = 0.1e1 / t30;
  t82 = params->cc * t81;
  t85 = params->cc * t22;
  t89 = 0.13888888888888888889e-1 * t78 * t26 + t82 * t40 / 0.2e1 - 0.2e1 * t85 * t26 * t66;
  t93 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t89);
  tvsigma0 = 0.2e1 * rho[0] * t93;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t98 = t17 / t24 / rho[0];
  t105 = t23 * t23;
  t107 = 0.1e1 / t24 / t105;
  t108 = t22 * t107;
  t114 = t21 / t18 / t52 * t39;
  t117 = t108 * t66;
  t120 = t30 * sigma[0];
  t121 = params->cc * t120;
  t122 = t105 * t23;
  t123 = 0.1e1 / t122;
  t125 = 0.1e1 / t65 / t38;
  t126 = t123 * t125;
  t129 = 0.13580246913580246914e0 * t20 * t108 + 0.28e2 / 0.9e1 * t31 * t114 - 0.8e2 / 0.3e1 * t64 * t117 + 0.1024e4 / 0.9e1 * t121 * t126;
  t134 = my_piecewise3(t2, 0, t6 * t98 * t42 / 0.12e2 - t6 * t48 * t70 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t129);
  tv2rho20 = 0.2e1 * rho[0] * t134 + 0.4e1 * t75;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t147 = t105 * rho[0];
  t148 = 0.1e1 / t147;
  t150 = t125 * t30;
  t153 = -0.37037037037037037037e-1 * t78 * t54 - 0.2e1 / 0.3e1 * t82 * t61 + 0.8e1 * t85 * t54 * t66 - 0.128e3 / 0.3e1 * params->cc * t148 * t150;
  t158 = my_piecewise3(t2, 0, -t6 * t48 * t89 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t153);
  tv2rhosigma0 = 0.2e1 * rho[0] * t158 + 0.2e1 * t93;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t161 = 0.1e1 / t120;
  t162 = params->cc * t161;
  t165 = 0.1e1 / sigma[0];
  t166 = params->cc * t165;
  t167 = t27 * t66;
  t169 = 0.1e1 / t105;
  t174 = -t162 * t40 / 0.4e1 - t166 * t167 + 0.16e2 * params->cc * t169 * t125 * t81;
  t178 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t174);
  tv2sigma20 = 0.2e1 * rho[0] * t178;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t181 = t17 * t26;
  t192 = 0.1e1 / t24 / t147;
  t193 = t22 * t192;
  t199 = t21 / t18 / t105 * t39;
  t205 = t105 * t52;
  t206 = 0.1e1 / t205;
  t210 = sigma[0] * sigma[0];
  t211 = params->cc * t210;
  t212 = t105 * t105;
  t214 = 0.1e1 / t18 / t212;
  t215 = t65 * t65;
  t216 = 0.1e1 / t215;
  t221 = -0.63374485596707818932e0 * t20 * t193 - 0.28e3 / 0.27e2 * t31 * t199 + 0.3808e4 / 0.27e2 * t64 * t193 * t66 - 0.11264e5 / 0.9e1 * t121 * t206 * t125 + 0.16384e5 / 0.9e1 * t211 * t214 * t216 * t21;
  t226 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t181 * t42 + t6 * t98 * t70 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t48 * t129 - 0.3e1 / 0.8e1 * t6 * t19 * t221);
  tv3rho30 = 0.2e1 * rho[0] * t226 + 0.6e1 * t134;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t248 = params->cc / t18 / t205;
  t250 = t216 * sigma[0] * t21;
  t253 = 0.13580246913580246914e0 * t78 * t107 + 0.14e2 / 0.9e1 * t82 * t114 - 0.296e3 / 0.9e1 * t85 * t107 * t66 + 0.384e3 * params->cc * t123 * t150 - 0.2048e4 / 0.3e1 * t248 * t250;
  t258 = my_piecewise3(t2, 0, t6 * t98 * t89 / 0.12e2 - t6 * t48 * t153 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t253);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t258 + 0.4e1 * t158;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t268 = t148 * t125;
  t273 = params->cc / t18 / t122;
  t274 = t216 * t21;
  t277 = t162 * t61 / 0.3e1 + 0.4e1 / 0.3e1 * t166 * t67 - 0.256e3 / 0.3e1 * t82 * t268 + 0.256e3 * t273 * t274;
  t282 = my_piecewise3(t2, 0, -t6 * t48 * t174 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t277);
  tv3rhosigma20 = 0.2e1 * rho[0] * t282 + 0.2e1 * t178;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t285 = t30 * t210;
  t287 = params->cc / t285;
  t290 = 0.1e1 / t210;
  t291 = params->cc * t290;
  t295 = 0.1e1 / t18 / t147;
  t296 = params->cc * t295;
  t298 = t216 * t165 * t21;
  t301 = 0.3e1 / 0.8e1 * t287 * t40 + 0.3e1 / 0.2e1 * t291 * t167 - 0.96e2 * t296 * t298;
  t305 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t301);
  tv3sigma30 = 0.2e1 * rho[0] * t305;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t22;
  double t23, t24, t26, t27, t30, t31, t33, t38;
  double t39, t40, t42, t46, tzk0;

  double t48, t52, t54, t55, t61, t64, t65, t66;
  double t67, t70, t75, tvrho0, t78, t81, t82, t85;
  double t89, t93, tvsigma0;

  double t98, t105, t107, t108, t114, t117, t120, t121;
  double t122, t123, t125, t126, t129, t134, tv2rho20, t147;
  double t148, t150, t153, t158, tv2rhosigma0, t161, t162, t165;
  double t166, t167, t169, t174, t178, tv2sigma20;

  double t181, t192, t193, t199, t205, t206, t210, t211;
  double t212, t214, t215, t216, t221, t226, tv3rho30, t248;
  double t250, t253, t258, tv3rho2sigma0, t268, t273, t274, t277;
  double t282, tv3rhosigma20, t285, t287, t290, t291, t295, t296;
  double t298, t301, t305, tv3sigma30;

  double t322, t323, t337, t349, t359, tv4rho40, t397, tv4rho3sigma0;
  double t427, tv4rho2sigma20, t453, tv4rhosigma30, t456, t482, tv4sigma40;

  gga_x_ol2_params *params;

  assert(p->params != NULL);
  params = (gga_x_ol2_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = params->bb * sigma[0];
  t21 = M_CBRT2;
  t22 = t21 * t21;
  t23 = rho[0] * rho[0];
  t24 = t18 * t18;
  t26 = 0.1e1 / t24 / t23;
  t27 = t22 * t26;
  t30 = sqrt(sigma[0]);
  t31 = params->cc * t30;
  t33 = 0.1e1 / t18 / rho[0];
  t38 = 0.4e1 * t30 * t21 * t33 + t21;
  t39 = 0.1e1 / t38;
  t40 = t21 * t33 * t39;
  t42 = params->aa + 0.13888888888888888889e-1 * t20 * t27 + t31 * t40;
  t46 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t42);
  tzk0 = 0.2e1 * t46;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t48 = t17 / t24;
  t52 = t23 * rho[0];
  t54 = 0.1e1 / t24 / t52;
  t55 = t22 * t54;
  t61 = t21 / t18 / t23 * t39;
  t64 = params->cc * sigma[0];
  t65 = t38 * t38;
  t66 = 0.1e1 / t65;
  t67 = t55 * t66;
  t70 = -0.37037037037037037037e-1 * t20 * t55 - 0.4e1 / 0.3e1 * t31 * t61 + 0.16e2 / 0.3e1 * t64 * t67;
  t75 = my_piecewise3(t2, 0, -t6 * t48 * t42 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t70);
  tvrho0 = 0.2e1 * rho[0] * t75 + 0.2e1 * t46;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t78 = params->bb * t22;
  t81 = 0.1e1 / t30;
  t82 = params->cc * t81;
  t85 = params->cc * t22;
  t89 = 0.13888888888888888889e-1 * t78 * t26 + t82 * t40 / 0.2e1 - 0.2e1 * t85 * t26 * t66;
  t93 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t89);
  tvsigma0 = 0.2e1 * rho[0] * t93;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t98 = t17 / t24 / rho[0];
  t105 = t23 * t23;
  t107 = 0.1e1 / t24 / t105;
  t108 = t22 * t107;
  t114 = t21 / t18 / t52 * t39;
  t117 = t108 * t66;
  t120 = t30 * sigma[0];
  t121 = params->cc * t120;
  t122 = t105 * t23;
  t123 = 0.1e1 / t122;
  t125 = 0.1e1 / t65 / t38;
  t126 = t123 * t125;
  t129 = 0.13580246913580246914e0 * t20 * t108 + 0.28e2 / 0.9e1 * t31 * t114 - 0.8e2 / 0.3e1 * t64 * t117 + 0.1024e4 / 0.9e1 * t121 * t126;
  t134 = my_piecewise3(t2, 0, t6 * t98 * t42 / 0.12e2 - t6 * t48 * t70 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t129);
  tv2rho20 = 0.2e1 * rho[0] * t134 + 0.4e1 * t75;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t147 = t105 * rho[0];
  t148 = 0.1e1 / t147;
  t150 = t125 * t30;
  t153 = -0.37037037037037037037e-1 * t78 * t54 - 0.2e1 / 0.3e1 * t82 * t61 + 0.8e1 * t85 * t54 * t66 - 0.128e3 / 0.3e1 * params->cc * t148 * t150;
  t158 = my_piecewise3(t2, 0, -t6 * t48 * t89 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t153);
  tv2rhosigma0 = 0.2e1 * rho[0] * t158 + 0.2e1 * t93;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t161 = 0.1e1 / t120;
  t162 = params->cc * t161;
  t165 = 0.1e1 / sigma[0];
  t166 = params->cc * t165;
  t167 = t27 * t66;
  t169 = 0.1e1 / t105;
  t174 = -t162 * t40 / 0.4e1 - t166 * t167 + 0.16e2 * params->cc * t169 * t125 * t81;
  t178 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t174);
  tv2sigma20 = 0.2e1 * rho[0] * t178;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t181 = t17 * t26;
  t192 = 0.1e1 / t24 / t147;
  t193 = t22 * t192;
  t199 = t21 / t18 / t105 * t39;
  t205 = t105 * t52;
  t206 = 0.1e1 / t205;
  t210 = sigma[0] * sigma[0];
  t211 = params->cc * t210;
  t212 = t105 * t105;
  t214 = 0.1e1 / t18 / t212;
  t215 = t65 * t65;
  t216 = 0.1e1 / t215;
  t221 = -0.63374485596707818932e0 * t20 * t193 - 0.28e3 / 0.27e2 * t31 * t199 + 0.3808e4 / 0.27e2 * t64 * t193 * t66 - 0.11264e5 / 0.9e1 * t121 * t206 * t125 + 0.16384e5 / 0.9e1 * t211 * t214 * t216 * t21;
  t226 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t181 * t42 + t6 * t98 * t70 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t48 * t129 - 0.3e1 / 0.8e1 * t6 * t19 * t221);
  tv3rho30 = 0.2e1 * rho[0] * t226 + 0.6e1 * t134;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t248 = params->cc / t18 / t205;
  t250 = t216 * sigma[0] * t21;
  t253 = 0.13580246913580246914e0 * t78 * t107 + 0.14e2 / 0.9e1 * t82 * t114 - 0.296e3 / 0.9e1 * t85 * t107 * t66 + 0.384e3 * params->cc * t123 * t150 - 0.2048e4 / 0.3e1 * t248 * t250;
  t258 = my_piecewise3(t2, 0, t6 * t98 * t89 / 0.12e2 - t6 * t48 * t153 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t253);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t258 + 0.4e1 * t158;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t268 = t148 * t125;
  t273 = params->cc / t18 / t122;
  t274 = t216 * t21;
  t277 = t162 * t61 / 0.3e1 + 0.4e1 / 0.3e1 * t166 * t67 - 0.256e3 / 0.3e1 * t82 * t268 + 0.256e3 * t273 * t274;
  t282 = my_piecewise3(t2, 0, -t6 * t48 * t174 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t277);
  tv3rhosigma20 = 0.2e1 * rho[0] * t282 + 0.2e1 * t178;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t285 = t30 * t210;
  t287 = params->cc / t285;
  t290 = 0.1e1 / t210;
  t291 = params->cc * t290;
  t295 = 0.1e1 / t18 / t147;
  t296 = params->cc * t295;
  t298 = t216 * t165 * t21;
  t301 = 0.3e1 / 0.8e1 * t287 * t40 + 0.3e1 / 0.2e1 * t291 * t167 - 0.96e2 * t296 * t298;
  t305 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t301);
  tv3sigma30 = 0.2e1 * rho[0] * t305;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t322 = 0.1e1 / t24 / t122;
  t323 = t22 * t322;
  t337 = t212 * rho[0];
  t349 = 0.1e1 / t215 / t38;
  t359 = my_piecewise3(t2, 0, 0.1e2 / 0.27e2 * t6 * t17 * t54 * t42 - 0.5e1 / 0.9e1 * t6 * t181 * t70 + t6 * t98 * t129 / 0.2e1 - t6 * t48 * t221 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t19 * (0.35912208504801097395e1 * t20 * t323 + 0.364e4 / 0.81e2 * t31 * t21 * t295 * t39 - 0.23072e5 / 0.27e2 * t64 * t323 * t66 + 0.953344e6 / 0.81e2 * t121 / t212 * t125 - 0.950272e6 / 0.27e2 * t211 / t18 / t337 * t216 * t21 + 0.1048576e7 / 0.27e2 * params->cc * t285 / t24 / t212 / t23 * t349 * t22));
  tv4rho40 = 0.2e1 * rho[0] * t359 + 0.8e1 * t226;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t397 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t181 * t89 + t6 * t98 * t153 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t48 * t253 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.63374485596707818932e0 * t78 * t192 - 0.14e3 / 0.27e2 * t82 * t199 + 0.1456e4 / 0.9e1 * t85 * t192 * t66 - 0.81152e5 / 0.27e2 * params->cc * t206 * t150 + 0.100352e6 / 0.9e1 * params->cc * t214 * t250 - 0.131072e6 / 0.9e1 * params->cc / t24 / t337 * t349 * t120 * t22));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t397 + 0.6e1 * t258;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t427 = my_piecewise3(t2, 0, t6 * t98 * t174 / 0.12e2 - t6 * t48 * t277 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.7e1 / 0.9e1 * t162 * t114 - 0.28e2 / 0.9e1 * t166 * t117 + 0.4096e4 / 0.9e1 * t82 * t126 - 0.896e4 / 0.3e1 * t248 * t274 + 0.16384e5 / 0.3e1 * params->cc / t24 / t212 * t349 * t22 * t30));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t427 + 0.4e1 * t282;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t453 = my_piecewise3(t2, 0, -t6 * t48 * t301 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-t287 * t61 / 0.2e1 - 0.2e1 * t291 * t67 + 0.32e2 * t162 * t268 + 0.512e3 * t273 * t298 - 0.2048e4 * params->cc / t24 / t205 * t349 * t81 * t22));
  tv4rhosigma30 = 0.2e1 * rho[0] * t453 + 0.2e1 * t305;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t456 = t210 * sigma[0];
  t482 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (-0.15e2 / 0.16e2 * params->cc / t30 / t456 * t40 - 0.15e2 / 0.4e1 * params->cc / t456 * t167 - 0.12e2 * t287 * t169 * t125 + 0.768e3 * params->cc * t322 * t349 * t161 * t22 + 0.96e2 * t296 * t216 * t290 * t21));
  tv4sigma40 = 0.2e1 * rho[0] * t482;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t33, t36, t37, t39, t40, t43, t44, t45;
  double t47, t51, t52, t53, t55, t56, t57, t58;
  double t60, t61, t62, t63, t64, t65, t67, t70;
  double t71, t73, t76, t77, t78, t80, t84, tzk0;

  gga_x_ol2_params *params;

  assert(p->params != NULL);
  params = (gga_x_ol2_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = params->bb * sigma[0];
  t29 = rho[0] * rho[0];
  t30 = POW_1_3(rho[0]);
  t31 = t30 * t30;
  t33 = 0.1e1 / t31 / t29;
  t36 = sqrt(sigma[0]);
  t37 = params->cc * t36;
  t39 = 0.1e1 / t30 / rho[0];
  t40 = M_CBRT2;
  t43 = 0.4e1 * t36 * t39 + t40;
  t44 = 0.1e1 / t43;
  t45 = t39 * t44;
  t47 = params->aa + 0.13888888888888888889e-1 * t28 * t33 + t37 * t45;
  t51 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t47);
  t52 = rho[1] <= p->dens_threshold;
  t53 = -t16;
  t55 = my_piecewise5(t14, t11, t10, t15, t53 * t7);
  t56 = 0.1e1 + t55;
  t57 = t56 <= p->zeta_threshold;
  t58 = POW_1_3(t56);
  t60 = my_piecewise3(t57, t22, t58 * t56);
  t61 = t60 * t26;
  t62 = params->bb * sigma[2];
  t63 = rho[1] * rho[1];
  t64 = POW_1_3(rho[1]);
  t65 = t64 * t64;
  t67 = 0.1e1 / t65 / t63;
  t70 = sqrt(sigma[2]);
  t71 = params->cc * t70;
  t73 = 0.1e1 / t64 / rho[1];
  t76 = 0.4e1 * t70 * t73 + t40;
  t77 = 0.1e1 / t76;
  t78 = t73 * t77;
  t80 = params->aa + 0.13888888888888888889e-1 * t62 * t67 + t71 * t78;
  t84 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t80);
  tzk0 = t51 + t84;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t33, t36, t37, t39, t40, t43, t44, t45;
  double t47, t51, t52, t53, t55, t56, t57, t58;
  double t60, t61, t62, t63, t64, t65, t67, t70;
  double t71, t73, t76, t77, t78, t80, t84, tzk0;

  double t85, t86, t87, t89, t92, t93, t97, t98;
  double t99, t102, t103, t105, t110, t113, t114, t115;
  double t116, t119, t124, t125, t127, t130, t131, t135;
  double t138, t140, tvrho0, t144, t147, t148, t153, t155;
  double t158, t159, t163, t165, t170, t173, t174, t175;
  double t176, t179, t184, tvrho1, t189, t190, t196, t200;
  double tvsigma0, tvsigma1, t203, t204, t210, t214, tvsigma2;

  gga_x_ol2_params *params;

  assert(p->params != NULL);
  params = (gga_x_ol2_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = params->bb * sigma[0];
  t29 = rho[0] * rho[0];
  t30 = POW_1_3(rho[0]);
  t31 = t30 * t30;
  t33 = 0.1e1 / t31 / t29;
  t36 = sqrt(sigma[0]);
  t37 = params->cc * t36;
  t39 = 0.1e1 / t30 / rho[0];
  t40 = M_CBRT2;
  t43 = 0.4e1 * t36 * t39 + t40;
  t44 = 0.1e1 / t43;
  t45 = t39 * t44;
  t47 = params->aa + 0.13888888888888888889e-1 * t28 * t33 + t37 * t45;
  t51 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t47);
  t52 = rho[1] <= p->dens_threshold;
  t53 = -t16;
  t55 = my_piecewise5(t14, t11, t10, t15, t53 * t7);
  t56 = 0.1e1 + t55;
  t57 = t56 <= p->zeta_threshold;
  t58 = POW_1_3(t56);
  t60 = my_piecewise3(t57, t22, t58 * t56);
  t61 = t60 * t26;
  t62 = params->bb * sigma[2];
  t63 = rho[1] * rho[1];
  t64 = POW_1_3(rho[1]);
  t65 = t64 * t64;
  t67 = 0.1e1 / t65 / t63;
  t70 = sqrt(sigma[2]);
  t71 = params->cc * t70;
  t73 = 0.1e1 / t64 / rho[1];
  t76 = 0.4e1 * t70 * t73 + t40;
  t77 = 0.1e1 / t76;
  t78 = t73 * t77;
  t80 = params->aa + 0.13888888888888888889e-1 * t62 * t67 + t71 * t78;
  t84 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t80);
  tzk0 = t51 + t84;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t85 = t6 * t6;
  t86 = 0.1e1 / t85;
  t87 = t16 * t86;
  t89 = my_piecewise5(t10, 0, t14, 0, t7 - t87);
  t92 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t89);
  t93 = t92 * t26;
  t97 = t26 * t26;
  t98 = 0.1e1 / t97;
  t99 = t25 * t98;
  t102 = t5 * t99 * t47 / 0.8e1;
  t103 = t29 * rho[0];
  t105 = 0.1e1 / t31 / t103;
  t110 = 0.1e1 / t30 / t29 * t44;
  t113 = params->cc * sigma[0];
  t114 = t43 * t43;
  t115 = 0.1e1 / t114;
  t116 = t105 * t115;
  t119 = -0.37037037037037037037e-1 * t28 * t105 - 0.4e1 / 0.3e1 * t37 * t110 + 0.16e2 / 0.3e1 * t113 * t116;
  t124 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t93 * t47 - t102 - 0.3e1 / 0.8e1 * t5 * t27 * t119);
  t125 = t53 * t86;
  t127 = my_piecewise5(t14, 0, t10, 0, -t7 - t125);
  t130 = my_piecewise3(t57, 0, 0.4e1 / 0.3e1 * t58 * t127);
  t131 = t130 * t26;
  t135 = t60 * t98;
  t138 = t5 * t135 * t80 / 0.8e1;
  t140 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t131 * t80 - t138);
  tvrho0 = t51 + t84 + t6 * (t124 + t140);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t144 = my_piecewise5(t10, 0, t14, 0, -t7 - t87);
  t147 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t144);
  t148 = t147 * t26;
  t153 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t148 * t47 - t102);
  t155 = my_piecewise5(t14, 0, t10, 0, t7 - t125);
  t158 = my_piecewise3(t57, 0, 0.4e1 / 0.3e1 * t58 * t155);
  t159 = t158 * t26;
  t163 = t63 * rho[1];
  t165 = 0.1e1 / t65 / t163;
  t170 = 0.1e1 / t64 / t63 * t77;
  t173 = params->cc * sigma[2];
  t174 = t76 * t76;
  t175 = 0.1e1 / t174;
  t176 = t165 * t175;
  t179 = -0.37037037037037037037e-1 * t62 * t165 - 0.4e1 / 0.3e1 * t71 * t170 + 0.16e2 / 0.3e1 * t173 * t176;
  t184 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t159 * t80 - t138 - 0.3e1 / 0.8e1 * t5 * t61 * t179);
  tvrho1 = t51 + t84 + t6 * (t153 + t184);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t189 = 0.1e1 / t36;
  t190 = params->cc * t189;
  t196 = 0.13888888888888888889e-1 * params->bb * t33 + t190 * t45 / 0.2e1 - 0.2e1 * params->cc * t33 * t115;
  t200 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t196);
  tvsigma0 = t6 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t203 = 0.1e1 / t70;
  t204 = params->cc * t203;
  t210 = 0.13888888888888888889e-1 * params->bb * t67 + t204 * t78 / 0.2e1 - 0.2e1 * params->cc * t67 * t175;
  t214 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t210);
  tvsigma2 = t6 * t214;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t33, t36, t37, t39, t40, t43, t44, t45;
  double t47, t51, t52, t53, t55, t56, t57, t58;
  double t60, t61, t62, t63, t64, t65, t67, t70;
  double t71, t73, t76, t77, t78, t80, t84, tzk0;

  double t85, t86, t87, t89, t92, t93, t97, t98;
  double t99, t102, t103, t105, t110, t113, t114, t115;
  double t116, t119, t124, t125, t127, t130, t131, t135;
  double t138, t140, tvrho0, t144, t147, t148, t153, t155;
  double t158, t159, t163, t165, t170, t173, t174, t175;
  double t176, t179, t184, tvrho1, t189, t190, t196, t200;
  double tvsigma0, tvsigma1, t203, t204, t210, t214, tvsigma2;

  double t217, t218, t219, t222, t223, t224, t227, t231;
  double t232, t236, t238, t244, t245, t248, t250, t252;
  double t254, t259, t262, t265, t266, t267, t268, t270;
  double t271, t274, t279, t280, t281, t282, t285, t288;
  double t292, t293, t297, t299, t301, t304, t306, tv2rho20;
  double t309, t313, t317, t318, t322, t324, t332, t333;
  double t337, t341, t342, t346, t348, t355, t358, tv2rho21;
  double t363, t368, t372, t373, t379, t380, t385, t389;
  double t390, t399, t401, t406, t409, t412, t413, t414;
  double t415, t417, t418, t421, t426, tv2rho22, t434, t442;
  double t443, t445, t448, t453, tv2rhosigma0, tv2rhosigma1, t460, t462;
  double tv2rhosigma2, t468, tv2rhosigma3, tv2rhosigma4, t480, t481, t483, t486;
  double t491, tv2rhosigma5, t493, t494, t497, t498, t499, t501;
  double t506, t510, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t511;
  double t512, t515, t516, t517, t519, t524, t528, tv2sigma25;

  gga_x_ol2_params *params;

  assert(p->params != NULL);
  params = (gga_x_ol2_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = params->bb * sigma[0];
  t29 = rho[0] * rho[0];
  t30 = POW_1_3(rho[0]);
  t31 = t30 * t30;
  t33 = 0.1e1 / t31 / t29;
  t36 = sqrt(sigma[0]);
  t37 = params->cc * t36;
  t39 = 0.1e1 / t30 / rho[0];
  t40 = M_CBRT2;
  t43 = 0.4e1 * t36 * t39 + t40;
  t44 = 0.1e1 / t43;
  t45 = t39 * t44;
  t47 = params->aa + 0.13888888888888888889e-1 * t28 * t33 + t37 * t45;
  t51 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t47);
  t52 = rho[1] <= p->dens_threshold;
  t53 = -t16;
  t55 = my_piecewise5(t14, t11, t10, t15, t53 * t7);
  t56 = 0.1e1 + t55;
  t57 = t56 <= p->zeta_threshold;
  t58 = POW_1_3(t56);
  t60 = my_piecewise3(t57, t22, t58 * t56);
  t61 = t60 * t26;
  t62 = params->bb * sigma[2];
  t63 = rho[1] * rho[1];
  t64 = POW_1_3(rho[1]);
  t65 = t64 * t64;
  t67 = 0.1e1 / t65 / t63;
  t70 = sqrt(sigma[2]);
  t71 = params->cc * t70;
  t73 = 0.1e1 / t64 / rho[1];
  t76 = 0.4e1 * t70 * t73 + t40;
  t77 = 0.1e1 / t76;
  t78 = t73 * t77;
  t80 = params->aa + 0.13888888888888888889e-1 * t62 * t67 + t71 * t78;
  t84 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t80);
  tzk0 = t51 + t84;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t85 = t6 * t6;
  t86 = 0.1e1 / t85;
  t87 = t16 * t86;
  t89 = my_piecewise5(t10, 0, t14, 0, t7 - t87);
  t92 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t89);
  t93 = t92 * t26;
  t97 = t26 * t26;
  t98 = 0.1e1 / t97;
  t99 = t25 * t98;
  t102 = t5 * t99 * t47 / 0.8e1;
  t103 = t29 * rho[0];
  t105 = 0.1e1 / t31 / t103;
  t110 = 0.1e1 / t30 / t29 * t44;
  t113 = params->cc * sigma[0];
  t114 = t43 * t43;
  t115 = 0.1e1 / t114;
  t116 = t105 * t115;
  t119 = -0.37037037037037037037e-1 * t28 * t105 - 0.4e1 / 0.3e1 * t37 * t110 + 0.16e2 / 0.3e1 * t113 * t116;
  t124 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t93 * t47 - t102 - 0.3e1 / 0.8e1 * t5 * t27 * t119);
  t125 = t53 * t86;
  t127 = my_piecewise5(t14, 0, t10, 0, -t7 - t125);
  t130 = my_piecewise3(t57, 0, 0.4e1 / 0.3e1 * t58 * t127);
  t131 = t130 * t26;
  t135 = t60 * t98;
  t138 = t5 * t135 * t80 / 0.8e1;
  t140 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t131 * t80 - t138);
  tvrho0 = t51 + t84 + t6 * (t124 + t140);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t144 = my_piecewise5(t10, 0, t14, 0, -t7 - t87);
  t147 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t144);
  t148 = t147 * t26;
  t153 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t148 * t47 - t102);
  t155 = my_piecewise5(t14, 0, t10, 0, t7 - t125);
  t158 = my_piecewise3(t57, 0, 0.4e1 / 0.3e1 * t58 * t155);
  t159 = t158 * t26;
  t163 = t63 * rho[1];
  t165 = 0.1e1 / t65 / t163;
  t170 = 0.1e1 / t64 / t63 * t77;
  t173 = params->cc * sigma[2];
  t174 = t76 * t76;
  t175 = 0.1e1 / t174;
  t176 = t165 * t175;
  t179 = -0.37037037037037037037e-1 * t62 * t165 - 0.4e1 / 0.3e1 * t71 * t170 + 0.16e2 / 0.3e1 * t173 * t176;
  t184 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t159 * t80 - t138 - 0.3e1 / 0.8e1 * t5 * t61 * t179);
  tvrho1 = t51 + t84 + t6 * (t153 + t184);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t189 = 0.1e1 / t36;
  t190 = params->cc * t189;
  t196 = 0.13888888888888888889e-1 * params->bb * t33 + t190 * t45 / 0.2e1 - 0.2e1 * params->cc * t33 * t115;
  t200 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t196);
  tvsigma0 = t6 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t203 = 0.1e1 / t70;
  t204 = params->cc * t203;
  t210 = 0.13888888888888888889e-1 * params->bb * t67 + t204 * t78 / 0.2e1 - 0.2e1 * params->cc * t67 * t175;
  t214 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t210);
  tvsigma2 = t6 * t214;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t217 = t23 * t23;
  t218 = 0.1e1 / t217;
  t219 = t89 * t89;
  t222 = t85 * t6;
  t223 = 0.1e1 / t222;
  t224 = t16 * t223;
  t227 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t86 + 0.2e1 * t224);
  t231 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t218 * t219 + 0.4e1 / 0.3e1 * t23 * t227);
  t232 = t231 * t26;
  t236 = t92 * t98;
  t238 = t5 * t236 * t47;
  t244 = 0.1e1 / t97 / t6;
  t245 = t25 * t244;
  t248 = t5 * t245 * t47 / 0.12e2;
  t250 = t5 * t99 * t119;
  t252 = t29 * t29;
  t254 = 0.1e1 / t31 / t252;
  t259 = 0.1e1 / t30 / t103 * t44;
  t262 = t254 * t115;
  t265 = t36 * sigma[0];
  t266 = params->cc * t265;
  t267 = t252 * t29;
  t268 = 0.1e1 / t267;
  t270 = 0.1e1 / t114 / t43;
  t271 = t268 * t270;
  t274 = 0.13580246913580246914e0 * t28 * t254 + 0.28e2 / 0.9e1 * t37 * t259 - 0.8e2 / 0.3e1 * t113 * t262 + 0.512e3 / 0.9e1 * t266 * t271;
  t279 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t232 * t47 - t238 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t93 * t119 + t248 - t250 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t274);
  t280 = t58 * t58;
  t281 = 0.1e1 / t280;
  t282 = t127 * t127;
  t285 = t53 * t223;
  t288 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t86 + 0.2e1 * t285);
  t292 = my_piecewise3(t57, 0, 0.4e1 / 0.9e1 * t281 * t282 + 0.4e1 / 0.3e1 * t58 * t288);
  t293 = t292 * t26;
  t297 = t130 * t98;
  t299 = t5 * t297 * t80;
  t301 = t60 * t244;
  t304 = t5 * t301 * t80 / 0.12e2;
  t306 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t293 * t80 - t299 / 0.4e1 + t304);
  tv2rho20 = 0.2e1 * t124 + 0.2e1 * t140 + t6 * (t279 + t306);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t309 = t218 * t144;
  t313 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t224);
  t317 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t309 * t89 + 0.4e1 / 0.3e1 * t23 * t313);
  t318 = t317 * t26;
  t322 = t147 * t98;
  t324 = t5 * t322 * t47;
  t332 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t318 * t47 - t324 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t148 * t119 - t238 / 0.8e1 + t248 - t250 / 0.8e1);
  t333 = t281 * t155;
  t337 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t285);
  t341 = my_piecewise3(t57, 0, 0.4e1 / 0.9e1 * t333 * t127 + 0.4e1 / 0.3e1 * t58 * t337);
  t342 = t341 * t26;
  t346 = t158 * t98;
  t348 = t5 * t346 * t80;
  t355 = t5 * t135 * t179;
  t358 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t342 * t80 - t348 / 0.8e1 - t299 / 0.8e1 + t304 - 0.3e1 / 0.8e1 * t5 * t131 * t179 - t355 / 0.8e1);
  tv2rho21 = t124 + t140 + t153 + t184 + t6 * (t332 + t358);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t363 = t144 * t144;
  t368 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t86 + 0.2e1 * t224);
  t372 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t218 * t363 + 0.4e1 / 0.3e1 * t23 * t368);
  t373 = t372 * t26;
  t379 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t373 * t47 - t324 / 0.4e1 + t248);
  t380 = t155 * t155;
  t385 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t86 + 0.2e1 * t285);
  t389 = my_piecewise3(t57, 0, 0.4e1 / 0.9e1 * t281 * t380 + 0.4e1 / 0.3e1 * t58 * t385);
  t390 = t389 * t26;
  t399 = t63 * t63;
  t401 = 0.1e1 / t65 / t399;
  t406 = 0.1e1 / t64 / t163 * t77;
  t409 = t401 * t175;
  t412 = t70 * sigma[2];
  t413 = params->cc * t412;
  t414 = t399 * t63;
  t415 = 0.1e1 / t414;
  t417 = 0.1e1 / t174 / t76;
  t418 = t415 * t417;
  t421 = 0.13580246913580246914e0 * t62 * t401 + 0.28e2 / 0.9e1 * t71 * t406 - 0.8e2 / 0.3e1 * t173 * t409 + 0.512e3 / 0.9e1 * t413 * t418;
  t426 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t390 * t80 - t348 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t159 * t179 + t304 - t355 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t61 * t421);
  tv2rho22 = 0.2e1 * t153 + 0.2e1 * t184 + t6 * (t379 + t426);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t434 = t5 * t99 * t196 / 0.8e1;
  t442 = t252 * rho[0];
  t443 = 0.1e1 / t442;
  t445 = t270 * t36;
  t448 = -0.37037037037037037037e-1 * params->bb * t105 - 0.2e1 / 0.3e1 * t190 * t110 + 0.8e1 * params->cc * t105 * t115 - 0.64e2 / 0.3e1 * params->cc * t443 * t445;
  t453 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t93 * t196 - t434 - 0.3e1 / 0.8e1 * t5 * t27 * t448);
  tv2rhosigma0 = t6 * t453 + t200;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t460 = t5 * t135 * t210 / 0.8e1;
  t462 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t131 * t210 - t460);
  tv2rhosigma2 = t6 * t462 + t214;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t468 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t148 * t196 - t434);
  tv2rhosigma3 = t6 * t468 + t200;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t480 = t399 * rho[1];
  t481 = 0.1e1 / t480;
  t483 = t417 * t70;
  t486 = -0.37037037037037037037e-1 * params->bb * t165 - 0.2e1 / 0.3e1 * t204 * t170 + 0.8e1 * params->cc * t165 * t175 - 0.64e2 / 0.3e1 * params->cc * t481 * t483;
  t491 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t159 * t210 - t460 - 0.3e1 / 0.8e1 * t5 * t61 * t486);
  tv2rhosigma5 = t6 * t491 + t214;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t493 = 0.1e1 / t265;
  t494 = params->cc * t493;
  t497 = 0.1e1 / sigma[0];
  t498 = params->cc * t497;
  t499 = t33 * t115;
  t501 = 0.1e1 / t252;
  t506 = -t494 * t45 / 0.4e1 - t498 * t499 + 0.8e1 * params->cc * t501 * t270 * t189;
  t510 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t506);
  tv2sigma20 = t6 * t510;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t511 = 0.1e1 / t412;
  t512 = params->cc * t511;
  t515 = 0.1e1 / sigma[2];
  t516 = params->cc * t515;
  t517 = t67 * t175;
  t519 = 0.1e1 / t399;
  t524 = -t512 * t78 / 0.4e1 - t516 * t517 + 0.8e1 * params->cc * t519 * t417 * t203;
  t528 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t524);
  tv2sigma25 = t6 * t528;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t33, t36, t37, t39, t40, t43, t44, t45;
  double t47, t51, t52, t53, t55, t56, t57, t58;
  double t60, t61, t62, t63, t64, t65, t67, t70;
  double t71, t73, t76, t77, t78, t80, t84, tzk0;

  double t85, t86, t87, t89, t92, t93, t97, t98;
  double t99, t102, t103, t105, t110, t113, t114, t115;
  double t116, t119, t124, t125, t127, t130, t131, t135;
  double t138, t140, tvrho0, t144, t147, t148, t153, t155;
  double t158, t159, t163, t165, t170, t173, t174, t175;
  double t176, t179, t184, tvrho1, t189, t190, t196, t200;
  double tvsigma0, tvsigma1, t203, t204, t210, t214, tvsigma2;

  double t217, t218, t219, t222, t223, t224, t227, t231;
  double t232, t236, t238, t244, t245, t248, t250, t252;
  double t254, t259, t262, t265, t266, t267, t268, t270;
  double t271, t274, t279, t280, t281, t282, t285, t288;
  double t292, t293, t297, t299, t301, t304, t306, tv2rho20;
  double t309, t313, t317, t318, t322, t324, t332, t333;
  double t337, t341, t342, t346, t348, t355, t358, tv2rho21;
  double t363, t368, t372, t373, t379, t380, t385, t389;
  double t390, t399, t401, t406, t409, t412, t413, t414;
  double t415, t417, t418, t421, t426, tv2rho22, t434, t442;
  double t443, t445, t448, t453, tv2rhosigma0, tv2rhosigma1, t460, t462;
  double tv2rhosigma2, t468, tv2rhosigma3, tv2rhosigma4, t480, t481, t483, t486;
  double t491, tv2rhosigma5, t493, t494, t497, t498, t499, t501;
  double t506, t510, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t511;
  double t512, t515, t516, t517, t519, t524, t528, tv2sigma25;

  double t532, t533, t536, t539, t540, t541, t544, t548;
  double t549, t553, t555, t560, t562, t565, t571, t572;
  double t575, t577, t580, t583, t588, t594, t595, t599;
  double t600, t601, t603, t604, t605, t609, t614, t616;
  double t617, t620, t623, t626, t630, t631, t635, t637;
  double t639, t641, t643, t646, t648, tv3rho30, t651, t652;
  double t653, t656, t661, t662, t664, t668, t669, t673;
  double t676, t680, t682, t686, t695, t696, t697, t700;
  double t705, t707, t711, t712, t716, t719, t720, t722;
  double t731, t733, t736, tv3rho31, t739, t744, t748, t752;
  double t753, t757, t759, t768, t769, t774, t778, t782;
  double t783, t787, t789, t796, t804, t806, t807, tv3rho32;
  double t812, t819, t823, t824, t831, t832, t839, t843;
  double t844, t860, t865, t871, t872, t876, t877, t878;
  double t880, t881, t882, t886, t891, tv3rho33, t899, t906;
  double t908, t922, t923, t926, t931, tv3rho2sigma0, tv3rho2sigma1, t938;
  double t942, t944, tv3rho2sigma2, t950, t958, tv3rho2sigma3, tv3rho2sigma4, t964;
  double t971, t974, tv3rho2sigma5, t982, tv3rho2sigma6, tv3rho2sigma7, t1005, t1006;
  double t1009, t1014, tv3rho2sigma8, t1021, t1026, t1031, t1034, t1039;
  double tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1046, t1048, tv3rhosigma25;
  double t1054, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1063, t1068;
  double t1071, t1076, tv3rhosigma211, t1078, t1080, t1083, t1084, t1088;
  double t1089, t1090, t1093, t1097, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33;
  double tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t1098, t1100, t1103;
  double t1104, t1108, t1109, t1110, t1113, t1117, tv3sigma39;

  gga_x_ol2_params *params;

  assert(p->params != NULL);
  params = (gga_x_ol2_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = params->bb * sigma[0];
  t29 = rho[0] * rho[0];
  t30 = POW_1_3(rho[0]);
  t31 = t30 * t30;
  t33 = 0.1e1 / t31 / t29;
  t36 = sqrt(sigma[0]);
  t37 = params->cc * t36;
  t39 = 0.1e1 / t30 / rho[0];
  t40 = M_CBRT2;
  t43 = 0.4e1 * t36 * t39 + t40;
  t44 = 0.1e1 / t43;
  t45 = t39 * t44;
  t47 = params->aa + 0.13888888888888888889e-1 * t28 * t33 + t37 * t45;
  t51 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t47);
  t52 = rho[1] <= p->dens_threshold;
  t53 = -t16;
  t55 = my_piecewise5(t14, t11, t10, t15, t53 * t7);
  t56 = 0.1e1 + t55;
  t57 = t56 <= p->zeta_threshold;
  t58 = POW_1_3(t56);
  t60 = my_piecewise3(t57, t22, t58 * t56);
  t61 = t60 * t26;
  t62 = params->bb * sigma[2];
  t63 = rho[1] * rho[1];
  t64 = POW_1_3(rho[1]);
  t65 = t64 * t64;
  t67 = 0.1e1 / t65 / t63;
  t70 = sqrt(sigma[2]);
  t71 = params->cc * t70;
  t73 = 0.1e1 / t64 / rho[1];
  t76 = 0.4e1 * t70 * t73 + t40;
  t77 = 0.1e1 / t76;
  t78 = t73 * t77;
  t80 = params->aa + 0.13888888888888888889e-1 * t62 * t67 + t71 * t78;
  t84 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t80);
  tzk0 = t51 + t84;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t85 = t6 * t6;
  t86 = 0.1e1 / t85;
  t87 = t16 * t86;
  t89 = my_piecewise5(t10, 0, t14, 0, t7 - t87);
  t92 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t89);
  t93 = t92 * t26;
  t97 = t26 * t26;
  t98 = 0.1e1 / t97;
  t99 = t25 * t98;
  t102 = t5 * t99 * t47 / 0.8e1;
  t103 = t29 * rho[0];
  t105 = 0.1e1 / t31 / t103;
  t110 = 0.1e1 / t30 / t29 * t44;
  t113 = params->cc * sigma[0];
  t114 = t43 * t43;
  t115 = 0.1e1 / t114;
  t116 = t105 * t115;
  t119 = -0.37037037037037037037e-1 * t28 * t105 - 0.4e1 / 0.3e1 * t37 * t110 + 0.16e2 / 0.3e1 * t113 * t116;
  t124 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t93 * t47 - t102 - 0.3e1 / 0.8e1 * t5 * t27 * t119);
  t125 = t53 * t86;
  t127 = my_piecewise5(t14, 0, t10, 0, -t7 - t125);
  t130 = my_piecewise3(t57, 0, 0.4e1 / 0.3e1 * t58 * t127);
  t131 = t130 * t26;
  t135 = t60 * t98;
  t138 = t5 * t135 * t80 / 0.8e1;
  t140 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t131 * t80 - t138);
  tvrho0 = t51 + t84 + t6 * (t124 + t140);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t144 = my_piecewise5(t10, 0, t14, 0, -t7 - t87);
  t147 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t144);
  t148 = t147 * t26;
  t153 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t148 * t47 - t102);
  t155 = my_piecewise5(t14, 0, t10, 0, t7 - t125);
  t158 = my_piecewise3(t57, 0, 0.4e1 / 0.3e1 * t58 * t155);
  t159 = t158 * t26;
  t163 = t63 * rho[1];
  t165 = 0.1e1 / t65 / t163;
  t170 = 0.1e1 / t64 / t63 * t77;
  t173 = params->cc * sigma[2];
  t174 = t76 * t76;
  t175 = 0.1e1 / t174;
  t176 = t165 * t175;
  t179 = -0.37037037037037037037e-1 * t62 * t165 - 0.4e1 / 0.3e1 * t71 * t170 + 0.16e2 / 0.3e1 * t173 * t176;
  t184 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t159 * t80 - t138 - 0.3e1 / 0.8e1 * t5 * t61 * t179);
  tvrho1 = t51 + t84 + t6 * (t153 + t184);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t189 = 0.1e1 / t36;
  t190 = params->cc * t189;
  t196 = 0.13888888888888888889e-1 * params->bb * t33 + t190 * t45 / 0.2e1 - 0.2e1 * params->cc * t33 * t115;
  t200 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t196);
  tvsigma0 = t6 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t203 = 0.1e1 / t70;
  t204 = params->cc * t203;
  t210 = 0.13888888888888888889e-1 * params->bb * t67 + t204 * t78 / 0.2e1 - 0.2e1 * params->cc * t67 * t175;
  t214 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t210);
  tvsigma2 = t6 * t214;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t217 = t23 * t23;
  t218 = 0.1e1 / t217;
  t219 = t89 * t89;
  t222 = t85 * t6;
  t223 = 0.1e1 / t222;
  t224 = t16 * t223;
  t227 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t86 + 0.2e1 * t224);
  t231 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t218 * t219 + 0.4e1 / 0.3e1 * t23 * t227);
  t232 = t231 * t26;
  t236 = t92 * t98;
  t238 = t5 * t236 * t47;
  t244 = 0.1e1 / t97 / t6;
  t245 = t25 * t244;
  t248 = t5 * t245 * t47 / 0.12e2;
  t250 = t5 * t99 * t119;
  t252 = t29 * t29;
  t254 = 0.1e1 / t31 / t252;
  t259 = 0.1e1 / t30 / t103 * t44;
  t262 = t254 * t115;
  t265 = t36 * sigma[0];
  t266 = params->cc * t265;
  t267 = t252 * t29;
  t268 = 0.1e1 / t267;
  t270 = 0.1e1 / t114 / t43;
  t271 = t268 * t270;
  t274 = 0.13580246913580246914e0 * t28 * t254 + 0.28e2 / 0.9e1 * t37 * t259 - 0.8e2 / 0.3e1 * t113 * t262 + 0.512e3 / 0.9e1 * t266 * t271;
  t279 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t232 * t47 - t238 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t93 * t119 + t248 - t250 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t274);
  t280 = t58 * t58;
  t281 = 0.1e1 / t280;
  t282 = t127 * t127;
  t285 = t53 * t223;
  t288 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t86 + 0.2e1 * t285);
  t292 = my_piecewise3(t57, 0, 0.4e1 / 0.9e1 * t281 * t282 + 0.4e1 / 0.3e1 * t58 * t288);
  t293 = t292 * t26;
  t297 = t130 * t98;
  t299 = t5 * t297 * t80;
  t301 = t60 * t244;
  t304 = t5 * t301 * t80 / 0.12e2;
  t306 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t293 * t80 - t299 / 0.4e1 + t304);
  tv2rho20 = 0.2e1 * t124 + 0.2e1 * t140 + t6 * (t279 + t306);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t309 = t218 * t144;
  t313 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t224);
  t317 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t309 * t89 + 0.4e1 / 0.3e1 * t23 * t313);
  t318 = t317 * t26;
  t322 = t147 * t98;
  t324 = t5 * t322 * t47;
  t332 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t318 * t47 - t324 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t148 * t119 - t238 / 0.8e1 + t248 - t250 / 0.8e1);
  t333 = t281 * t155;
  t337 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t285);
  t341 = my_piecewise3(t57, 0, 0.4e1 / 0.9e1 * t333 * t127 + 0.4e1 / 0.3e1 * t58 * t337);
  t342 = t341 * t26;
  t346 = t158 * t98;
  t348 = t5 * t346 * t80;
  t355 = t5 * t135 * t179;
  t358 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t342 * t80 - t348 / 0.8e1 - t299 / 0.8e1 + t304 - 0.3e1 / 0.8e1 * t5 * t131 * t179 - t355 / 0.8e1);
  tv2rho21 = t124 + t140 + t153 + t184 + t6 * (t332 + t358);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t363 = t144 * t144;
  t368 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t86 + 0.2e1 * t224);
  t372 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t218 * t363 + 0.4e1 / 0.3e1 * t23 * t368);
  t373 = t372 * t26;
  t379 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t373 * t47 - t324 / 0.4e1 + t248);
  t380 = t155 * t155;
  t385 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t86 + 0.2e1 * t285);
  t389 = my_piecewise3(t57, 0, 0.4e1 / 0.9e1 * t281 * t380 + 0.4e1 / 0.3e1 * t58 * t385);
  t390 = t389 * t26;
  t399 = t63 * t63;
  t401 = 0.1e1 / t65 / t399;
  t406 = 0.1e1 / t64 / t163 * t77;
  t409 = t401 * t175;
  t412 = t70 * sigma[2];
  t413 = params->cc * t412;
  t414 = t399 * t63;
  t415 = 0.1e1 / t414;
  t417 = 0.1e1 / t174 / t76;
  t418 = t415 * t417;
  t421 = 0.13580246913580246914e0 * t62 * t401 + 0.28e2 / 0.9e1 * t71 * t406 - 0.8e2 / 0.3e1 * t173 * t409 + 0.512e3 / 0.9e1 * t413 * t418;
  t426 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t390 * t80 - t348 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t159 * t179 + t304 - t355 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t61 * t421);
  tv2rho22 = 0.2e1 * t153 + 0.2e1 * t184 + t6 * (t379 + t426);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t434 = t5 * t99 * t196 / 0.8e1;
  t442 = t252 * rho[0];
  t443 = 0.1e1 / t442;
  t445 = t270 * t36;
  t448 = -0.37037037037037037037e-1 * params->bb * t105 - 0.2e1 / 0.3e1 * t190 * t110 + 0.8e1 * params->cc * t105 * t115 - 0.64e2 / 0.3e1 * params->cc * t443 * t445;
  t453 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t93 * t196 - t434 - 0.3e1 / 0.8e1 * t5 * t27 * t448);
  tv2rhosigma0 = t6 * t453 + t200;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t460 = t5 * t135 * t210 / 0.8e1;
  t462 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t131 * t210 - t460);
  tv2rhosigma2 = t6 * t462 + t214;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t468 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t148 * t196 - t434);
  tv2rhosigma3 = t6 * t468 + t200;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t480 = t399 * rho[1];
  t481 = 0.1e1 / t480;
  t483 = t417 * t70;
  t486 = -0.37037037037037037037e-1 * params->bb * t165 - 0.2e1 / 0.3e1 * t204 * t170 + 0.8e1 * params->cc * t165 * t175 - 0.64e2 / 0.3e1 * params->cc * t481 * t483;
  t491 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t159 * t210 - t460 - 0.3e1 / 0.8e1 * t5 * t61 * t486);
  tv2rhosigma5 = t6 * t491 + t214;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t493 = 0.1e1 / t265;
  t494 = params->cc * t493;
  t497 = 0.1e1 / sigma[0];
  t498 = params->cc * t497;
  t499 = t33 * t115;
  t501 = 0.1e1 / t252;
  t506 = -t494 * t45 / 0.4e1 - t498 * t499 + 0.8e1 * params->cc * t501 * t270 * t189;
  t510 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t506);
  tv2sigma20 = t6 * t510;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t511 = 0.1e1 / t412;
  t512 = params->cc * t511;
  t515 = 0.1e1 / sigma[2];
  t516 = params->cc * t515;
  t517 = t67 * t175;
  t519 = 0.1e1 / t399;
  t524 = -t512 * t78 / 0.4e1 - t516 * t517 + 0.8e1 * params->cc * t519 * t417 * t203;
  t528 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t524);
  tv2sigma25 = t6 * t528;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t532 = 0.1e1 / t217 / t19;
  t533 = t219 * t89;
  t536 = t218 * t89;
  t539 = t85 * t85;
  t540 = 0.1e1 / t539;
  t541 = t16 * t540;
  t544 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t223 - 0.6e1 * t541);
  t548 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t532 * t533 + 0.4e1 / 0.3e1 * t536 * t227 + 0.4e1 / 0.3e1 * t23 * t544);
  t549 = t548 * t26;
  t553 = t231 * t98;
  t555 = t5 * t553 * t47;
  t560 = t92 * t244;
  t562 = t5 * t560 * t47;
  t565 = t5 * t236 * t119;
  t571 = 0.1e1 / t97 / t85;
  t572 = t25 * t571;
  t575 = 0.5e1 / 0.36e2 * t5 * t572 * t47;
  t577 = t5 * t245 * t119;
  t580 = t5 * t99 * t274;
  t583 = 0.1e1 / t31 / t442;
  t588 = 0.1e1 / t30 / t252 * t44;
  t594 = t252 * t103;
  t595 = 0.1e1 / t594;
  t599 = sigma[0] * sigma[0];
  t600 = params->cc * t599;
  t601 = t252 * t252;
  t603 = 0.1e1 / t30 / t601;
  t604 = t114 * t114;
  t605 = 0.1e1 / t604;
  t609 = -0.63374485596707818932e0 * t28 * t583 - 0.28e3 / 0.27e2 * t37 * t588 + 0.3808e4 / 0.27e2 * t113 * t583 * t115 - 0.5632e4 / 0.9e1 * t266 * t595 * t270 + 0.8192e4 / 0.9e1 * t600 * t603 * t605;
  t614 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t549 * t47 - 0.3e1 / 0.8e1 * t555 - 0.9e1 / 0.8e1 * t5 * t232 * t119 + t562 / 0.4e1 - 0.3e1 / 0.4e1 * t565 - 0.9e1 / 0.8e1 * t5 * t93 * t274 - t575 + t577 / 0.4e1 - 0.3e1 / 0.8e1 * t580 - 0.3e1 / 0.8e1 * t5 * t27 * t609);
  t616 = 0.1e1 / t280 / t56;
  t617 = t282 * t127;
  t620 = t281 * t127;
  t623 = t53 * t540;
  t626 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t223 - 0.6e1 * t623);
  t630 = my_piecewise3(t57, 0, -0.8e1 / 0.27e2 * t616 * t617 + 0.4e1 / 0.3e1 * t620 * t288 + 0.4e1 / 0.3e1 * t58 * t626);
  t631 = t630 * t26;
  t635 = t292 * t98;
  t637 = t5 * t635 * t80;
  t639 = t130 * t244;
  t641 = t5 * t639 * t80;
  t643 = t60 * t571;
  t646 = 0.5e1 / 0.36e2 * t5 * t643 * t80;
  t648 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t631 * t80 - 0.3e1 / 0.8e1 * t637 + t641 / 0.4e1 - t646);
  tv3rho30 = 0.3e1 * t279 + 0.3e1 * t306 + t6 * (t614 + t648);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t651 = 0.2e1 * t332;
  t652 = 0.2e1 * t358;
  t653 = t532 * t144;
  t656 = t218 * t313;
  t661 = 0.2e1 * t223;
  t662 = 0.6e1 * t541;
  t664 = my_piecewise5(t10, 0, t14, 0, t661 - t662);
  t668 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t653 * t219 + 0.8e1 / 0.9e1 * t656 * t89 + 0.4e1 / 0.9e1 * t309 * t227 + 0.4e1 / 0.3e1 * t23 * t664);
  t669 = t668 * t26;
  t673 = t317 * t98;
  t676 = t5 * t673 * t47 / 0.4e1;
  t680 = t147 * t244;
  t682 = t5 * t680 * t47;
  t686 = t5 * t322 * t119 / 0.4e1;
  t695 = -0.3e1 / 0.8e1 * t5 * t669 * t47 - t676 - 0.3e1 / 0.4e1 * t5 * t318 * t119 + t682 / 0.12e2 - t686 - 0.3e1 / 0.8e1 * t5 * t148 * t274 - t555 / 0.8e1 + t562 / 0.6e1 - t565 / 0.4e1 - t575 + t577 / 0.6e1 - t580 / 0.8e1;
  t696 = my_piecewise3(t1, 0, t695);
  t697 = t616 * t155;
  t700 = t281 * t337;
  t705 = 0.6e1 * t623;
  t707 = my_piecewise5(t14, 0, t10, 0, -t661 - t705);
  t711 = my_piecewise3(t57, 0, -0.8e1 / 0.27e2 * t697 * t282 + 0.8e1 / 0.9e1 * t700 * t127 + 0.4e1 / 0.9e1 * t333 * t288 + 0.4e1 / 0.3e1 * t58 * t707);
  t712 = t711 * t26;
  t716 = t341 * t98;
  t719 = t5 * t716 * t80 / 0.4e1;
  t720 = t158 * t244;
  t722 = t5 * t720 * t80;
  t731 = t5 * t297 * t179 / 0.4e1;
  t733 = t5 * t301 * t179;
  t736 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t712 * t80 - t719 + t722 / 0.12e2 - t637 / 0.8e1 + t641 / 0.6e1 - t646 - 0.3e1 / 0.8e1 * t5 * t293 * t179 - t731 + t733 / 0.12e2);
  tv3rho31 = t279 + t306 + t651 + t652 + t6 * (t696 + t736);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t739 = t532 * t363;
  t744 = t218 * t368;
  t748 = my_piecewise5(t10, 0, t14, 0, -t661 - t662);
  t752 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t739 * t89 + 0.8e1 / 0.9e1 * t309 * t313 + 0.4e1 / 0.9e1 * t744 * t89 + 0.4e1 / 0.3e1 * t23 * t748);
  t753 = t752 * t26;
  t757 = t372 * t98;
  t759 = t5 * t757 * t47;
  t768 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t753 * t47 - t759 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t373 * t119 - t676 + t682 / 0.6e1 - t686 + t562 / 0.12e2 - t575 + t577 / 0.12e2);
  t769 = t616 * t380;
  t774 = t281 * t385;
  t778 = my_piecewise5(t14, 0, t10, 0, t661 - t705);
  t782 = my_piecewise3(t57, 0, -0.8e1 / 0.27e2 * t769 * t127 + 0.8e1 / 0.9e1 * t333 * t337 + 0.4e1 / 0.9e1 * t774 * t127 + 0.4e1 / 0.3e1 * t58 * t778);
  t783 = t782 * t26;
  t787 = t389 * t98;
  t789 = t5 * t787 * t80;
  t796 = t5 * t346 * t179;
  t804 = t5 * t135 * t421;
  t806 = -0.3e1 / 0.8e1 * t5 * t783 * t80 - t789 / 0.8e1 - t719 + t722 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t342 * t179 - t796 / 0.4e1 + t641 / 0.12e2 - t646 - t731 + t733 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t131 * t421 - t804 / 0.8e1;
  t807 = my_piecewise3(t52, 0, t806);
  tv3rho32 = t651 + t652 + t379 + t426 + t6 * (t768 + t807);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t812 = t363 * t144;
  t819 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t223 - 0.6e1 * t541);
  t823 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t532 * t812 + 0.4e1 / 0.3e1 * t309 * t368 + 0.4e1 / 0.3e1 * t23 * t819);
  t824 = t823 * t26;
  t831 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t824 * t47 - 0.3e1 / 0.8e1 * t759 + t682 / 0.4e1 - t575);
  t832 = t380 * t155;
  t839 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t223 - 0.6e1 * t623);
  t843 = my_piecewise3(t57, 0, -0.8e1 / 0.27e2 * t616 * t832 + 0.4e1 / 0.3e1 * t333 * t385 + 0.4e1 / 0.3e1 * t58 * t839);
  t844 = t843 * t26;
  t860 = 0.1e1 / t65 / t480;
  t865 = 0.1e1 / t64 / t399 * t77;
  t871 = t399 * t163;
  t872 = 0.1e1 / t871;
  t876 = sigma[2] * sigma[2];
  t877 = params->cc * t876;
  t878 = t399 * t399;
  t880 = 0.1e1 / t64 / t878;
  t881 = t174 * t174;
  t882 = 0.1e1 / t881;
  t886 = -0.63374485596707818932e0 * t62 * t860 - 0.28e3 / 0.27e2 * t71 * t865 + 0.3808e4 / 0.27e2 * t173 * t860 * t175 - 0.5632e4 / 0.9e1 * t413 * t872 * t417 + 0.8192e4 / 0.9e1 * t877 * t880 * t882;
  t891 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t844 * t80 - 0.3e1 / 0.8e1 * t789 - 0.9e1 / 0.8e1 * t5 * t390 * t179 + t722 / 0.4e1 - 0.3e1 / 0.4e1 * t796 - 0.9e1 / 0.8e1 * t5 * t159 * t421 - t646 + t733 / 0.4e1 - 0.3e1 / 0.8e1 * t804 - 0.3e1 / 0.8e1 * t5 * t61 * t886);
  tv3rho33 = 0.3e1 * t379 + 0.3e1 * t426 + t6 * (t831 + t891);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t899 = t5 * t236 * t196;
  t906 = t5 * t245 * t196 / 0.12e2;
  t908 = t5 * t99 * t448;
  t922 = params->cc / t30 / t594;
  t923 = t605 * sigma[0];
  t926 = 0.13580246913580246914e0 * params->bb * t254 + 0.14e2 / 0.9e1 * t190 * t259 - 0.296e3 / 0.9e1 * params->cc * t254 * t115 + 0.192e3 * params->cc * t268 * t445 - 0.1024e4 / 0.3e1 * t922 * t923;
  t931 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t232 * t196 - t899 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t93 * t448 + t906 - t908 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t926);
  tv3rho2sigma0 = t6 * t931 + 0.2e1 * t453;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t938 = t5 * t297 * t210;
  t942 = t5 * t301 * t210 / 0.12e2;
  t944 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t293 * t210 - t938 / 0.4e1 + t942);
  tv3rho2sigma2 = t6 * t944 + 0.2e1 * t462;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t950 = t5 * t322 * t196;
  t958 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t318 * t196 - t950 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t148 * t448 - t899 / 0.8e1 + t906 - t908 / 0.8e1);
  tv3rho2sigma3 = t6 * t958 + t453 + t468;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t964 = t5 * t346 * t210;
  t971 = t5 * t135 * t486;
  t974 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t342 * t210 - t964 / 0.8e1 - t938 / 0.8e1 + t942 - 0.3e1 / 0.8e1 * t5 * t131 * t486 - t971 / 0.8e1);
  tv3rho2sigma5 = t6 * t974 + t462 + t491;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t982 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t373 * t196 - t950 / 0.4e1 + t906);
  tv3rho2sigma6 = t6 * t982 + 0.2e1 * t468;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1005 = params->cc / t64 / t871;
  t1006 = t882 * sigma[2];
  t1009 = 0.13580246913580246914e0 * params->bb * t401 + 0.14e2 / 0.9e1 * t204 * t406 - 0.296e3 / 0.9e1 * params->cc * t401 * t175 + 0.192e3 * params->cc * t415 * t483 - 0.1024e4 / 0.3e1 * t1005 * t1006;
  t1014 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t390 * t210 - t964 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t159 * t486 + t942 - t971 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t61 * t1009);
  tv3rho2sigma8 = t6 * t1014 + 0.2e1 * t491;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1021 = t5 * t99 * t506 / 0.8e1;
  t1026 = t443 * t270;
  t1031 = params->cc / t30 / t267;
  t1034 = t494 * t110 / 0.3e1 + 0.4e1 / 0.3e1 * t498 * t116 - 0.128e3 / 0.3e1 * t190 * t1026 + 0.128e3 * t1031 * t605;
  t1039 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t93 * t506 - t1021 - 0.3e1 / 0.8e1 * t5 * t27 * t1034);
  tv3rhosigma20 = t6 * t1039 + t510;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1046 = t5 * t135 * t524 / 0.8e1;
  t1048 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t131 * t524 - t1046);
  tv3rhosigma25 = t6 * t1048 + t528;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1054 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t148 * t506 - t1021);
  tv3rhosigma26 = t6 * t1054 + t510;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1063 = t481 * t417;
  t1068 = params->cc / t64 / t414;
  t1071 = t512 * t170 / 0.3e1 + 0.4e1 / 0.3e1 * t516 * t176 - 0.128e3 / 0.3e1 * t204 * t1063 + 0.128e3 * t1068 * t882;
  t1076 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t159 * t524 - t1046 - 0.3e1 / 0.8e1 * t5 * t61 * t1071);
  tv3rhosigma211 = t6 * t1076 + t528;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1078 = t36 * t599;
  t1080 = params->cc / t1078;
  t1083 = 0.1e1 / t599;
  t1084 = params->cc * t1083;
  t1088 = 0.1e1 / t30 / t442;
  t1089 = params->cc * t1088;
  t1090 = t605 * t497;
  t1093 = 0.3e1 / 0.8e1 * t1080 * t45 + 0.3e1 / 0.2e1 * t1084 * t499 - 0.48e2 * t1089 * t1090;
  t1097 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1093);
  tv3sigma30 = t6 * t1097;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1098 = t70 * t876;
  t1100 = params->cc / t1098;
  t1103 = 0.1e1 / t876;
  t1104 = params->cc * t1103;
  t1108 = 0.1e1 / t64 / t480;
  t1109 = params->cc * t1108;
  t1110 = t882 * t515;
  t1113 = 0.3e1 / 0.8e1 * t1100 * t78 + 0.3e1 / 0.2e1 * t1104 * t517 - 0.48e2 * t1109 * t1110;
  t1117 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t1113);
  tv3sigma39 = t6 * t1117;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t30, t31;
  double t33, t36, t37, t39, t40, t43, t44, t45;
  double t47, t51, t52, t53, t55, t56, t57, t58;
  double t60, t61, t62, t63, t64, t65, t67, t70;
  double t71, t73, t76, t77, t78, t80, t84, tzk0;

  double t85, t86, t87, t89, t92, t93, t97, t98;
  double t99, t102, t103, t105, t110, t113, t114, t115;
  double t116, t119, t124, t125, t127, t130, t131, t135;
  double t138, t140, tvrho0, t144, t147, t148, t153, t155;
  double t158, t159, t163, t165, t170, t173, t174, t175;
  double t176, t179, t184, tvrho1, t189, t190, t196, t200;
  double tvsigma0, tvsigma1, t203, t204, t210, t214, tvsigma2;

  double t217, t218, t219, t222, t223, t224, t227, t231;
  double t232, t236, t238, t244, t245, t248, t250, t252;
  double t254, t259, t262, t265, t266, t267, t268, t270;
  double t271, t274, t279, t280, t281, t282, t285, t288;
  double t292, t293, t297, t299, t301, t304, t306, tv2rho20;
  double t309, t313, t317, t318, t322, t324, t332, t333;
  double t337, t341, t342, t346, t348, t355, t358, tv2rho21;
  double t363, t368, t372, t373, t379, t380, t385, t389;
  double t390, t399, t401, t406, t409, t412, t413, t414;
  double t415, t417, t418, t421, t426, tv2rho22, t434, t442;
  double t443, t445, t448, t453, tv2rhosigma0, tv2rhosigma1, t460, t462;
  double tv2rhosigma2, t468, tv2rhosigma3, tv2rhosigma4, t480, t481, t483, t486;
  double t491, tv2rhosigma5, t493, t494, t497, t498, t499, t501;
  double t506, t510, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t511;
  double t512, t515, t516, t517, t519, t524, t528, tv2sigma25;

  double t532, t533, t536, t539, t540, t541, t544, t548;
  double t549, t553, t555, t560, t562, t565, t571, t572;
  double t575, t577, t580, t583, t588, t594, t595, t599;
  double t600, t601, t603, t604, t605, t609, t614, t616;
  double t617, t620, t623, t626, t630, t631, t635, t637;
  double t639, t641, t643, t646, t648, tv3rho30, t651, t652;
  double t653, t656, t661, t662, t664, t668, t669, t673;
  double t676, t680, t682, t686, t695, t696, t697, t700;
  double t705, t707, t711, t712, t716, t719, t720, t722;
  double t731, t733, t736, tv3rho31, t739, t744, t748, t752;
  double t753, t757, t759, t768, t769, t774, t778, t782;
  double t783, t787, t789, t796, t804, t806, t807, tv3rho32;
  double t812, t819, t823, t824, t831, t832, t839, t843;
  double t844, t860, t865, t871, t872, t876, t877, t878;
  double t880, t881, t882, t886, t891, tv3rho33, t899, t906;
  double t908, t922, t923, t926, t931, tv3rho2sigma0, tv3rho2sigma1, t938;
  double t942, t944, tv3rho2sigma2, t950, t958, tv3rho2sigma3, tv3rho2sigma4, t964;
  double t971, t974, tv3rho2sigma5, t982, tv3rho2sigma6, tv3rho2sigma7, t1005, t1006;
  double t1009, t1014, tv3rho2sigma8, t1021, t1026, t1031, t1034, t1039;
  double tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1046, t1048, tv3rhosigma25;
  double t1054, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1063, t1068;
  double t1071, t1076, tv3rhosigma211, t1078, t1080, t1083, t1084, t1088;
  double t1089, t1090, t1093, t1097, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33;
  double tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t1098, t1100, t1103;
  double t1104, t1108, t1109, t1110, t1113, t1117, tv3sigma39;

  double t1124, t1127, t1130, t1133, t1146, t1157, t1165, t1167;
  double t1168, t1174, t1180, t1181, t1184, t1188, t1197, t1203;
  double t1205, t1209, t1213, t1216, t1220, t1223, t1225, t1226;
  double t1227, t1229, t1230, t1236, t1241, t1244, t1248, t1255;
  double t1259, t1263, t1268, t1270, tv4rho40, t1277, t1281, t1282;
  double t1285, t1288, t1309, t1310, t1312, t1316, t1325, t1331;
  double t1332, t1342, t1343, t1360, t1362, t1366, t1373, t1377;
  double t1378, t1381, t1390, t1393, t1394, t1396, t1398, t1399;
  double tv4rho41, t1414, t1427, t1431, t1440, t1447, t1451, t1464;
  double t1465, t1474, t1487, t1491, t1498, t1502, t1511, t1514;
  double t1525, t1528, t1530, t1531, tv4rho42, t1552, t1556, t1563;
  double t1574, t1575, t1592, t1596, t1603, t1611, t1620, t1630;
  double t1632, t1633, tv4rho43, t1638, t1643, t1650, t1654, t1663;
  double t1668, t1681, t1692, t1700, t1705, t1712, t1716, t1735;
  double t1736, tv4rho44, t1744, t1750, t1753, t1760, t1762, t1765;
  double t1791, tv4rho3sigma0, tv4rho3sigma1, t1798, t1801, t1805, t1807, tv4rho3sigma2;
  double t1809, t1815, t1820, t1824, t1833, t1834, tv4rho3sigma3, tv4rho3sigma4;
  double t1836, t1842, t1844, t1853, t1855, t1858, tv4rho3sigma5, t1864;
  double t1873, tv4rho3sigma6, tv4rho3sigma7, t1879, t1886, t1894, t1896, t1897;
  double tv4rho3sigma8, t1906, tv4rho3sigma9, tv4rho3sigma10, t1947, tv4rho3sigma11, t1954, t1961;
  double t1963, t1984, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t1991;
  double t1995, t1997, tv4rho2sigma25, t2003, t2011, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28;
  double tv4rho2sigma29, tv4rho2sigma210, t2017, t2024, t2027, tv4rho2sigma211, t2035, tv4rho2sigma212;
  double tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t2065, tv4rho2sigma217, t2072, t2092;
  double tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37;
  double tv4rhosigma38, t2099, t2101, tv4rhosigma39, t2107, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312;
  double tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t2131, tv4rhosigma319;
  double t2133, t2157, tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45;
  double tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413;
  double t2158, t2182, tv4sigma414;

  gga_x_ol2_params *params;

  assert(p->params != NULL);
  params = (gga_x_ol2_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = params->bb * sigma[0];
  t29 = rho[0] * rho[0];
  t30 = POW_1_3(rho[0]);
  t31 = t30 * t30;
  t33 = 0.1e1 / t31 / t29;
  t36 = sqrt(sigma[0]);
  t37 = params->cc * t36;
  t39 = 0.1e1 / t30 / rho[0];
  t40 = M_CBRT2;
  t43 = 0.4e1 * t36 * t39 + t40;
  t44 = 0.1e1 / t43;
  t45 = t39 * t44;
  t47 = params->aa + 0.13888888888888888889e-1 * t28 * t33 + t37 * t45;
  t51 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t47);
  t52 = rho[1] <= p->dens_threshold;
  t53 = -t16;
  t55 = my_piecewise5(t14, t11, t10, t15, t53 * t7);
  t56 = 0.1e1 + t55;
  t57 = t56 <= p->zeta_threshold;
  t58 = POW_1_3(t56);
  t60 = my_piecewise3(t57, t22, t58 * t56);
  t61 = t60 * t26;
  t62 = params->bb * sigma[2];
  t63 = rho[1] * rho[1];
  t64 = POW_1_3(rho[1]);
  t65 = t64 * t64;
  t67 = 0.1e1 / t65 / t63;
  t70 = sqrt(sigma[2]);
  t71 = params->cc * t70;
  t73 = 0.1e1 / t64 / rho[1];
  t76 = 0.4e1 * t70 * t73 + t40;
  t77 = 0.1e1 / t76;
  t78 = t73 * t77;
  t80 = params->aa + 0.13888888888888888889e-1 * t62 * t67 + t71 * t78;
  t84 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t80);
  tzk0 = t51 + t84;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t85 = t6 * t6;
  t86 = 0.1e1 / t85;
  t87 = t16 * t86;
  t89 = my_piecewise5(t10, 0, t14, 0, t7 - t87);
  t92 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t89);
  t93 = t92 * t26;
  t97 = t26 * t26;
  t98 = 0.1e1 / t97;
  t99 = t25 * t98;
  t102 = t5 * t99 * t47 / 0.8e1;
  t103 = t29 * rho[0];
  t105 = 0.1e1 / t31 / t103;
  t110 = 0.1e1 / t30 / t29 * t44;
  t113 = params->cc * sigma[0];
  t114 = t43 * t43;
  t115 = 0.1e1 / t114;
  t116 = t105 * t115;
  t119 = -0.37037037037037037037e-1 * t28 * t105 - 0.4e1 / 0.3e1 * t37 * t110 + 0.16e2 / 0.3e1 * t113 * t116;
  t124 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t93 * t47 - t102 - 0.3e1 / 0.8e1 * t5 * t27 * t119);
  t125 = t53 * t86;
  t127 = my_piecewise5(t14, 0, t10, 0, -t7 - t125);
  t130 = my_piecewise3(t57, 0, 0.4e1 / 0.3e1 * t58 * t127);
  t131 = t130 * t26;
  t135 = t60 * t98;
  t138 = t5 * t135 * t80 / 0.8e1;
  t140 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t131 * t80 - t138);
  tvrho0 = t51 + t84 + t6 * (t124 + t140);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t144 = my_piecewise5(t10, 0, t14, 0, -t7 - t87);
  t147 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t144);
  t148 = t147 * t26;
  t153 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t148 * t47 - t102);
  t155 = my_piecewise5(t14, 0, t10, 0, t7 - t125);
  t158 = my_piecewise3(t57, 0, 0.4e1 / 0.3e1 * t58 * t155);
  t159 = t158 * t26;
  t163 = t63 * rho[1];
  t165 = 0.1e1 / t65 / t163;
  t170 = 0.1e1 / t64 / t63 * t77;
  t173 = params->cc * sigma[2];
  t174 = t76 * t76;
  t175 = 0.1e1 / t174;
  t176 = t165 * t175;
  t179 = -0.37037037037037037037e-1 * t62 * t165 - 0.4e1 / 0.3e1 * t71 * t170 + 0.16e2 / 0.3e1 * t173 * t176;
  t184 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t159 * t80 - t138 - 0.3e1 / 0.8e1 * t5 * t61 * t179);
  tvrho1 = t51 + t84 + t6 * (t153 + t184);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t189 = 0.1e1 / t36;
  t190 = params->cc * t189;
  t196 = 0.13888888888888888889e-1 * params->bb * t33 + t190 * t45 / 0.2e1 - 0.2e1 * params->cc * t33 * t115;
  t200 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t196);
  tvsigma0 = t6 * t200;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t203 = 0.1e1 / t70;
  t204 = params->cc * t203;
  t210 = 0.13888888888888888889e-1 * params->bb * t67 + t204 * t78 / 0.2e1 - 0.2e1 * params->cc * t67 * t175;
  t214 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t210);
  tvsigma2 = t6 * t214;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t217 = t23 * t23;
  t218 = 0.1e1 / t217;
  t219 = t89 * t89;
  t222 = t85 * t6;
  t223 = 0.1e1 / t222;
  t224 = t16 * t223;
  t227 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t86 + 0.2e1 * t224);
  t231 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t218 * t219 + 0.4e1 / 0.3e1 * t23 * t227);
  t232 = t231 * t26;
  t236 = t92 * t98;
  t238 = t5 * t236 * t47;
  t244 = 0.1e1 / t97 / t6;
  t245 = t25 * t244;
  t248 = t5 * t245 * t47 / 0.12e2;
  t250 = t5 * t99 * t119;
  t252 = t29 * t29;
  t254 = 0.1e1 / t31 / t252;
  t259 = 0.1e1 / t30 / t103 * t44;
  t262 = t254 * t115;
  t265 = t36 * sigma[0];
  t266 = params->cc * t265;
  t267 = t252 * t29;
  t268 = 0.1e1 / t267;
  t270 = 0.1e1 / t114 / t43;
  t271 = t268 * t270;
  t274 = 0.13580246913580246914e0 * t28 * t254 + 0.28e2 / 0.9e1 * t37 * t259 - 0.8e2 / 0.3e1 * t113 * t262 + 0.512e3 / 0.9e1 * t266 * t271;
  t279 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t232 * t47 - t238 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t93 * t119 + t248 - t250 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t274);
  t280 = t58 * t58;
  t281 = 0.1e1 / t280;
  t282 = t127 * t127;
  t285 = t53 * t223;
  t288 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t86 + 0.2e1 * t285);
  t292 = my_piecewise3(t57, 0, 0.4e1 / 0.9e1 * t281 * t282 + 0.4e1 / 0.3e1 * t58 * t288);
  t293 = t292 * t26;
  t297 = t130 * t98;
  t299 = t5 * t297 * t80;
  t301 = t60 * t244;
  t304 = t5 * t301 * t80 / 0.12e2;
  t306 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t293 * t80 - t299 / 0.4e1 + t304);
  tv2rho20 = 0.2e1 * t124 + 0.2e1 * t140 + t6 * (t279 + t306);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t309 = t218 * t144;
  t313 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t224);
  t317 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t309 * t89 + 0.4e1 / 0.3e1 * t23 * t313);
  t318 = t317 * t26;
  t322 = t147 * t98;
  t324 = t5 * t322 * t47;
  t332 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t318 * t47 - t324 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t148 * t119 - t238 / 0.8e1 + t248 - t250 / 0.8e1);
  t333 = t281 * t155;
  t337 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t285);
  t341 = my_piecewise3(t57, 0, 0.4e1 / 0.9e1 * t333 * t127 + 0.4e1 / 0.3e1 * t58 * t337);
  t342 = t341 * t26;
  t346 = t158 * t98;
  t348 = t5 * t346 * t80;
  t355 = t5 * t135 * t179;
  t358 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t342 * t80 - t348 / 0.8e1 - t299 / 0.8e1 + t304 - 0.3e1 / 0.8e1 * t5 * t131 * t179 - t355 / 0.8e1);
  tv2rho21 = t124 + t140 + t153 + t184 + t6 * (t332 + t358);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t363 = t144 * t144;
  t368 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t86 + 0.2e1 * t224);
  t372 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t218 * t363 + 0.4e1 / 0.3e1 * t23 * t368);
  t373 = t372 * t26;
  t379 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t373 * t47 - t324 / 0.4e1 + t248);
  t380 = t155 * t155;
  t385 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t86 + 0.2e1 * t285);
  t389 = my_piecewise3(t57, 0, 0.4e1 / 0.9e1 * t281 * t380 + 0.4e1 / 0.3e1 * t58 * t385);
  t390 = t389 * t26;
  t399 = t63 * t63;
  t401 = 0.1e1 / t65 / t399;
  t406 = 0.1e1 / t64 / t163 * t77;
  t409 = t401 * t175;
  t412 = t70 * sigma[2];
  t413 = params->cc * t412;
  t414 = t399 * t63;
  t415 = 0.1e1 / t414;
  t417 = 0.1e1 / t174 / t76;
  t418 = t415 * t417;
  t421 = 0.13580246913580246914e0 * t62 * t401 + 0.28e2 / 0.9e1 * t71 * t406 - 0.8e2 / 0.3e1 * t173 * t409 + 0.512e3 / 0.9e1 * t413 * t418;
  t426 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t390 * t80 - t348 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t159 * t179 + t304 - t355 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t61 * t421);
  tv2rho22 = 0.2e1 * t153 + 0.2e1 * t184 + t6 * (t379 + t426);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t434 = t5 * t99 * t196 / 0.8e1;
  t442 = t252 * rho[0];
  t443 = 0.1e1 / t442;
  t445 = t270 * t36;
  t448 = -0.37037037037037037037e-1 * params->bb * t105 - 0.2e1 / 0.3e1 * t190 * t110 + 0.8e1 * params->cc * t105 * t115 - 0.64e2 / 0.3e1 * params->cc * t443 * t445;
  t453 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t93 * t196 - t434 - 0.3e1 / 0.8e1 * t5 * t27 * t448);
  tv2rhosigma0 = t6 * t453 + t200;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t460 = t5 * t135 * t210 / 0.8e1;
  t462 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t131 * t210 - t460);
  tv2rhosigma2 = t6 * t462 + t214;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t468 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t148 * t196 - t434);
  tv2rhosigma3 = t6 * t468 + t200;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t480 = t399 * rho[1];
  t481 = 0.1e1 / t480;
  t483 = t417 * t70;
  t486 = -0.37037037037037037037e-1 * params->bb * t165 - 0.2e1 / 0.3e1 * t204 * t170 + 0.8e1 * params->cc * t165 * t175 - 0.64e2 / 0.3e1 * params->cc * t481 * t483;
  t491 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t159 * t210 - t460 - 0.3e1 / 0.8e1 * t5 * t61 * t486);
  tv2rhosigma5 = t6 * t491 + t214;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t493 = 0.1e1 / t265;
  t494 = params->cc * t493;
  t497 = 0.1e1 / sigma[0];
  t498 = params->cc * t497;
  t499 = t33 * t115;
  t501 = 0.1e1 / t252;
  t506 = -t494 * t45 / 0.4e1 - t498 * t499 + 0.8e1 * params->cc * t501 * t270 * t189;
  t510 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t506);
  tv2sigma20 = t6 * t510;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t511 = 0.1e1 / t412;
  t512 = params->cc * t511;
  t515 = 0.1e1 / sigma[2];
  t516 = params->cc * t515;
  t517 = t67 * t175;
  t519 = 0.1e1 / t399;
  t524 = -t512 * t78 / 0.4e1 - t516 * t517 + 0.8e1 * params->cc * t519 * t417 * t203;
  t528 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t524);
  tv2sigma25 = t6 * t528;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t532 = 0.1e1 / t217 / t19;
  t533 = t219 * t89;
  t536 = t218 * t89;
  t539 = t85 * t85;
  t540 = 0.1e1 / t539;
  t541 = t16 * t540;
  t544 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t223 - 0.6e1 * t541);
  t548 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t532 * t533 + 0.4e1 / 0.3e1 * t536 * t227 + 0.4e1 / 0.3e1 * t23 * t544);
  t549 = t548 * t26;
  t553 = t231 * t98;
  t555 = t5 * t553 * t47;
  t560 = t92 * t244;
  t562 = t5 * t560 * t47;
  t565 = t5 * t236 * t119;
  t571 = 0.1e1 / t97 / t85;
  t572 = t25 * t571;
  t575 = 0.5e1 / 0.36e2 * t5 * t572 * t47;
  t577 = t5 * t245 * t119;
  t580 = t5 * t99 * t274;
  t583 = 0.1e1 / t31 / t442;
  t588 = 0.1e1 / t30 / t252 * t44;
  t594 = t252 * t103;
  t595 = 0.1e1 / t594;
  t599 = sigma[0] * sigma[0];
  t600 = params->cc * t599;
  t601 = t252 * t252;
  t603 = 0.1e1 / t30 / t601;
  t604 = t114 * t114;
  t605 = 0.1e1 / t604;
  t609 = -0.63374485596707818932e0 * t28 * t583 - 0.28e3 / 0.27e2 * t37 * t588 + 0.3808e4 / 0.27e2 * t113 * t583 * t115 - 0.5632e4 / 0.9e1 * t266 * t595 * t270 + 0.8192e4 / 0.9e1 * t600 * t603 * t605;
  t614 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t549 * t47 - 0.3e1 / 0.8e1 * t555 - 0.9e1 / 0.8e1 * t5 * t232 * t119 + t562 / 0.4e1 - 0.3e1 / 0.4e1 * t565 - 0.9e1 / 0.8e1 * t5 * t93 * t274 - t575 + t577 / 0.4e1 - 0.3e1 / 0.8e1 * t580 - 0.3e1 / 0.8e1 * t5 * t27 * t609);
  t616 = 0.1e1 / t280 / t56;
  t617 = t282 * t127;
  t620 = t281 * t127;
  t623 = t53 * t540;
  t626 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t223 - 0.6e1 * t623);
  t630 = my_piecewise3(t57, 0, -0.8e1 / 0.27e2 * t616 * t617 + 0.4e1 / 0.3e1 * t620 * t288 + 0.4e1 / 0.3e1 * t58 * t626);
  t631 = t630 * t26;
  t635 = t292 * t98;
  t637 = t5 * t635 * t80;
  t639 = t130 * t244;
  t641 = t5 * t639 * t80;
  t643 = t60 * t571;
  t646 = 0.5e1 / 0.36e2 * t5 * t643 * t80;
  t648 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t631 * t80 - 0.3e1 / 0.8e1 * t637 + t641 / 0.4e1 - t646);
  tv3rho30 = 0.3e1 * t279 + 0.3e1 * t306 + t6 * (t614 + t648);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t651 = 0.2e1 * t332;
  t652 = 0.2e1 * t358;
  t653 = t532 * t144;
  t656 = t218 * t313;
  t661 = 0.2e1 * t223;
  t662 = 0.6e1 * t541;
  t664 = my_piecewise5(t10, 0, t14, 0, t661 - t662);
  t668 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t653 * t219 + 0.8e1 / 0.9e1 * t656 * t89 + 0.4e1 / 0.9e1 * t309 * t227 + 0.4e1 / 0.3e1 * t23 * t664);
  t669 = t668 * t26;
  t673 = t317 * t98;
  t676 = t5 * t673 * t47 / 0.4e1;
  t680 = t147 * t244;
  t682 = t5 * t680 * t47;
  t686 = t5 * t322 * t119 / 0.4e1;
  t695 = -0.3e1 / 0.8e1 * t5 * t669 * t47 - t676 - 0.3e1 / 0.4e1 * t5 * t318 * t119 + t682 / 0.12e2 - t686 - 0.3e1 / 0.8e1 * t5 * t148 * t274 - t555 / 0.8e1 + t562 / 0.6e1 - t565 / 0.4e1 - t575 + t577 / 0.6e1 - t580 / 0.8e1;
  t696 = my_piecewise3(t1, 0, t695);
  t697 = t616 * t155;
  t700 = t281 * t337;
  t705 = 0.6e1 * t623;
  t707 = my_piecewise5(t14, 0, t10, 0, -t661 - t705);
  t711 = my_piecewise3(t57, 0, -0.8e1 / 0.27e2 * t697 * t282 + 0.8e1 / 0.9e1 * t700 * t127 + 0.4e1 / 0.9e1 * t333 * t288 + 0.4e1 / 0.3e1 * t58 * t707);
  t712 = t711 * t26;
  t716 = t341 * t98;
  t719 = t5 * t716 * t80 / 0.4e1;
  t720 = t158 * t244;
  t722 = t5 * t720 * t80;
  t731 = t5 * t297 * t179 / 0.4e1;
  t733 = t5 * t301 * t179;
  t736 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t712 * t80 - t719 + t722 / 0.12e2 - t637 / 0.8e1 + t641 / 0.6e1 - t646 - 0.3e1 / 0.8e1 * t5 * t293 * t179 - t731 + t733 / 0.12e2);
  tv3rho31 = t279 + t306 + t651 + t652 + t6 * (t696 + t736);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t739 = t532 * t363;
  t744 = t218 * t368;
  t748 = my_piecewise5(t10, 0, t14, 0, -t661 - t662);
  t752 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t739 * t89 + 0.8e1 / 0.9e1 * t309 * t313 + 0.4e1 / 0.9e1 * t744 * t89 + 0.4e1 / 0.3e1 * t23 * t748);
  t753 = t752 * t26;
  t757 = t372 * t98;
  t759 = t5 * t757 * t47;
  t768 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t753 * t47 - t759 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t373 * t119 - t676 + t682 / 0.6e1 - t686 + t562 / 0.12e2 - t575 + t577 / 0.12e2);
  t769 = t616 * t380;
  t774 = t281 * t385;
  t778 = my_piecewise5(t14, 0, t10, 0, t661 - t705);
  t782 = my_piecewise3(t57, 0, -0.8e1 / 0.27e2 * t769 * t127 + 0.8e1 / 0.9e1 * t333 * t337 + 0.4e1 / 0.9e1 * t774 * t127 + 0.4e1 / 0.3e1 * t58 * t778);
  t783 = t782 * t26;
  t787 = t389 * t98;
  t789 = t5 * t787 * t80;
  t796 = t5 * t346 * t179;
  t804 = t5 * t135 * t421;
  t806 = -0.3e1 / 0.8e1 * t5 * t783 * t80 - t789 / 0.8e1 - t719 + t722 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t342 * t179 - t796 / 0.4e1 + t641 / 0.12e2 - t646 - t731 + t733 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t131 * t421 - t804 / 0.8e1;
  t807 = my_piecewise3(t52, 0, t806);
  tv3rho32 = t651 + t652 + t379 + t426 + t6 * (t768 + t807);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t812 = t363 * t144;
  t819 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t223 - 0.6e1 * t541);
  t823 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t532 * t812 + 0.4e1 / 0.3e1 * t309 * t368 + 0.4e1 / 0.3e1 * t23 * t819);
  t824 = t823 * t26;
  t831 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t824 * t47 - 0.3e1 / 0.8e1 * t759 + t682 / 0.4e1 - t575);
  t832 = t380 * t155;
  t839 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t223 - 0.6e1 * t623);
  t843 = my_piecewise3(t57, 0, -0.8e1 / 0.27e2 * t616 * t832 + 0.4e1 / 0.3e1 * t333 * t385 + 0.4e1 / 0.3e1 * t58 * t839);
  t844 = t843 * t26;
  t860 = 0.1e1 / t65 / t480;
  t865 = 0.1e1 / t64 / t399 * t77;
  t871 = t399 * t163;
  t872 = 0.1e1 / t871;
  t876 = sigma[2] * sigma[2];
  t877 = params->cc * t876;
  t878 = t399 * t399;
  t880 = 0.1e1 / t64 / t878;
  t881 = t174 * t174;
  t882 = 0.1e1 / t881;
  t886 = -0.63374485596707818932e0 * t62 * t860 - 0.28e3 / 0.27e2 * t71 * t865 + 0.3808e4 / 0.27e2 * t173 * t860 * t175 - 0.5632e4 / 0.9e1 * t413 * t872 * t417 + 0.8192e4 / 0.9e1 * t877 * t880 * t882;
  t891 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t844 * t80 - 0.3e1 / 0.8e1 * t789 - 0.9e1 / 0.8e1 * t5 * t390 * t179 + t722 / 0.4e1 - 0.3e1 / 0.4e1 * t796 - 0.9e1 / 0.8e1 * t5 * t159 * t421 - t646 + t733 / 0.4e1 - 0.3e1 / 0.8e1 * t804 - 0.3e1 / 0.8e1 * t5 * t61 * t886);
  tv3rho33 = 0.3e1 * t379 + 0.3e1 * t426 + t6 * (t831 + t891);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t899 = t5 * t236 * t196;
  t906 = t5 * t245 * t196 / 0.12e2;
  t908 = t5 * t99 * t448;
  t922 = params->cc / t30 / t594;
  t923 = t605 * sigma[0];
  t926 = 0.13580246913580246914e0 * params->bb * t254 + 0.14e2 / 0.9e1 * t190 * t259 - 0.296e3 / 0.9e1 * params->cc * t254 * t115 + 0.192e3 * params->cc * t268 * t445 - 0.1024e4 / 0.3e1 * t922 * t923;
  t931 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t232 * t196 - t899 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t93 * t448 + t906 - t908 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t926);
  tv3rho2sigma0 = t6 * t931 + 0.2e1 * t453;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t938 = t5 * t297 * t210;
  t942 = t5 * t301 * t210 / 0.12e2;
  t944 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t293 * t210 - t938 / 0.4e1 + t942);
  tv3rho2sigma2 = t6 * t944 + 0.2e1 * t462;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t950 = t5 * t322 * t196;
  t958 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t318 * t196 - t950 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t148 * t448 - t899 / 0.8e1 + t906 - t908 / 0.8e1);
  tv3rho2sigma3 = t6 * t958 + t453 + t468;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t964 = t5 * t346 * t210;
  t971 = t5 * t135 * t486;
  t974 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t342 * t210 - t964 / 0.8e1 - t938 / 0.8e1 + t942 - 0.3e1 / 0.8e1 * t5 * t131 * t486 - t971 / 0.8e1);
  tv3rho2sigma5 = t6 * t974 + t462 + t491;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t982 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t373 * t196 - t950 / 0.4e1 + t906);
  tv3rho2sigma6 = t6 * t982 + 0.2e1 * t468;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1005 = params->cc / t64 / t871;
  t1006 = t882 * sigma[2];
  t1009 = 0.13580246913580246914e0 * params->bb * t401 + 0.14e2 / 0.9e1 * t204 * t406 - 0.296e3 / 0.9e1 * params->cc * t401 * t175 + 0.192e3 * params->cc * t415 * t483 - 0.1024e4 / 0.3e1 * t1005 * t1006;
  t1014 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t390 * t210 - t964 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t159 * t486 + t942 - t971 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t61 * t1009);
  tv3rho2sigma8 = t6 * t1014 + 0.2e1 * t491;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1021 = t5 * t99 * t506 / 0.8e1;
  t1026 = t443 * t270;
  t1031 = params->cc / t30 / t267;
  t1034 = t494 * t110 / 0.3e1 + 0.4e1 / 0.3e1 * t498 * t116 - 0.128e3 / 0.3e1 * t190 * t1026 + 0.128e3 * t1031 * t605;
  t1039 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t93 * t506 - t1021 - 0.3e1 / 0.8e1 * t5 * t27 * t1034);
  tv3rhosigma20 = t6 * t1039 + t510;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1046 = t5 * t135 * t524 / 0.8e1;
  t1048 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t131 * t524 - t1046);
  tv3rhosigma25 = t6 * t1048 + t528;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1054 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t148 * t506 - t1021);
  tv3rhosigma26 = t6 * t1054 + t510;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1063 = t481 * t417;
  t1068 = params->cc / t64 / t414;
  t1071 = t512 * t170 / 0.3e1 + 0.4e1 / 0.3e1 * t516 * t176 - 0.128e3 / 0.3e1 * t204 * t1063 + 0.128e3 * t1068 * t882;
  t1076 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t159 * t524 - t1046 - 0.3e1 / 0.8e1 * t5 * t61 * t1071);
  tv3rhosigma211 = t6 * t1076 + t528;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1078 = t36 * t599;
  t1080 = params->cc / t1078;
  t1083 = 0.1e1 / t599;
  t1084 = params->cc * t1083;
  t1088 = 0.1e1 / t30 / t442;
  t1089 = params->cc * t1088;
  t1090 = t605 * t497;
  t1093 = 0.3e1 / 0.8e1 * t1080 * t45 + 0.3e1 / 0.2e1 * t1084 * t499 - 0.48e2 * t1089 * t1090;
  t1097 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1093);
  tv3sigma30 = t6 * t1097;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1098 = t70 * t876;
  t1100 = params->cc / t1098;
  t1103 = 0.1e1 / t876;
  t1104 = params->cc * t1103;
  t1108 = 0.1e1 / t64 / t480;
  t1109 = params->cc * t1108;
  t1110 = t882 * t515;
  t1113 = 0.3e1 / 0.8e1 * t1100 * t78 + 0.3e1 / 0.2e1 * t1104 * t517 - 0.48e2 * t1109 * t1110;
  t1117 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * t1113);
  tv3sigma39 = t6 * t1117;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1124 = t5 * t572 * t119;
  t1127 = t5 * t245 * t274;
  t1130 = t5 * t99 * t609;
  t1133 = 0.1e1 / t31 / t267;
  t1146 = t601 * rho[0];
  t1157 = 0.1e1 / t604 / t43;
  t1165 = t19 * t19;
  t1167 = 0.1e1 / t217 / t1165;
  t1168 = t219 * t219;
  t1174 = t227 * t227;
  t1180 = 0.1e1 / t539 / t6;
  t1181 = t16 * t1180;
  t1184 = my_piecewise5(t10, 0, t14, 0, -0.24e2 * t540 + 0.24e2 * t1181);
  t1188 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1167 * t1168 - 0.16e2 / 0.9e1 * t532 * t219 * t227 + 0.4e1 / 0.3e1 * t218 * t1174 + 0.16e2 / 0.9e1 * t536 * t544 + 0.4e1 / 0.3e1 * t23 * t1184);
  t1197 = t5 * t553 * t119;
  t1203 = t5 * t560 * t119;
  t1205 = t5 * t236 * t274;
  t1209 = t5 * t231 * t244 * t47;
  t1213 = t5 * t92 * t571 * t47;
  t1216 = 0.1e1 / t97 / t222;
  t1220 = 0.1e2 / 0.27e2 * t5 * t25 * t1216 * t47;
  t1223 = t5 * t548 * t98 * t47;
  t1225 = -0.3e1 / 0.2e1 * t5 * t93 * t609 - 0.5e1 / 0.9e1 * t1124 + t1127 / 0.2e1 - t1130 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t27 * (0.35912208504801097395e1 * t28 * t1133 + 0.364e4 / 0.81e2 * t37 * t1088 * t44 - 0.23072e5 / 0.27e2 * t113 * t1133 * t115 + 0.476672e6 / 0.81e2 * t266 / t601 * t270 - 0.475136e6 / 0.27e2 * t600 / t30 / t1146 * t605 + 0.524288e6 / 0.27e2 * params->cc * t1078 / t31 / t601 / t29 * t1157) - 0.3e1 / 0.8e1 * t5 * t1188 * t26 * t47 - 0.3e1 / 0.2e1 * t5 * t549 * t119 - 0.3e1 / 0.2e1 * t1197 - 0.9e1 / 0.4e1 * t5 * t232 * t274 + t1203 - 0.3e1 / 0.2e1 * t1205 + t1209 / 0.2e1 - 0.5e1 / 0.9e1 * t1213 + t1220 - t1223 / 0.2e1;
  t1226 = my_piecewise3(t1, 0, t1225);
  t1227 = t56 * t56;
  t1229 = 0.1e1 / t280 / t1227;
  t1230 = t282 * t282;
  t1236 = t288 * t288;
  t1241 = t53 * t1180;
  t1244 = my_piecewise5(t14, 0, t10, 0, 0.24e2 * t540 + 0.24e2 * t1241);
  t1248 = my_piecewise3(t57, 0, 0.4e2 / 0.81e2 * t1229 * t1230 - 0.16e2 / 0.9e1 * t616 * t282 * t288 + 0.4e1 / 0.3e1 * t281 * t1236 + 0.16e2 / 0.9e1 * t620 * t626 + 0.4e1 / 0.3e1 * t58 * t1244);
  t1255 = t5 * t630 * t98 * t80;
  t1259 = t5 * t292 * t244 * t80;
  t1263 = t5 * t130 * t571 * t80;
  t1268 = 0.1e2 / 0.27e2 * t5 * t60 * t1216 * t80;
  t1270 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t1248 * t26 * t80 - t1255 / 0.2e1 + t1259 / 0.2e1 - 0.5e1 / 0.9e1 * t1263 + t1268);
  tv4rho40 = 0.4e1 * t614 + 0.4e1 * t648 + t6 * (t1226 + t1270);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1277 = t5 * t668 * t98 * t47;
  t1281 = t5 * t317 * t244 * t47;
  t1282 = t1281 / 0.4e1;
  t1285 = t5 * t147 * t571 * t47;
  t1288 = t5 * t322 * t274;
  t1309 = 0.12e2 * t540;
  t1310 = 0.24e2 * t1181;
  t1312 = my_piecewise5(t10, 0, t14, 0, -t1309 + t1310);
  t1316 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1167 * t144 * t533 - 0.8e1 / 0.9e1 * t532 * t313 * t219 - 0.8e1 / 0.9e1 * t653 * t89 * t227 + 0.4e1 / 0.3e1 * t218 * t664 * t89 + 0.4e1 / 0.3e1 * t656 * t227 + 0.4e1 / 0.9e1 * t309 * t544 + 0.4e1 / 0.3e1 * t23 * t1312);
  t1325 = t5 * t673 * t119;
  t1331 = t5 * t680 * t119;
  t1332 = t1331 / 0.4e1;
  t1342 = -0.3e1 / 0.8e1 * t1277 + t1282 - 0.5e1 / 0.36e2 * t1285 - 0.3e1 / 0.8e1 * t1288 - 0.3e1 / 0.8e1 * t5 * t148 * t609 - 0.3e1 / 0.8e1 * t5 * t1316 * t26 * t47 - 0.9e1 / 0.8e1 * t5 * t669 * t119 - 0.3e1 / 0.4e1 * t1325 - 0.9e1 / 0.8e1 * t5 * t318 * t274 + t1332 - 0.5e1 / 0.12e2 * t1124 + t1127 / 0.4e1 - t1130 / 0.8e1 - 0.3e1 / 0.8e1 * t1197 + t1203 / 0.2e1 - 0.3e1 / 0.8e1 * t1205 + t1209 / 0.4e1 - 0.5e1 / 0.12e2 * t1213 + t1220 - t1223 / 0.8e1;
  t1343 = my_piecewise3(t1, 0, t1342);
  t1360 = 0.24e2 * t1241;
  t1362 = my_piecewise5(t14, 0, t10, 0, t1309 + t1360);
  t1366 = my_piecewise3(t57, 0, 0.4e2 / 0.81e2 * t1229 * t155 * t617 - 0.8e1 / 0.9e1 * t616 * t337 * t282 - 0.8e1 / 0.9e1 * t697 * t127 * t288 + 0.4e1 / 0.3e1 * t281 * t707 * t127 + 0.4e1 / 0.3e1 * t700 * t288 + 0.4e1 / 0.9e1 * t333 * t626 + 0.4e1 / 0.3e1 * t58 * t1362);
  t1373 = t5 * t711 * t98 * t80;
  t1377 = t5 * t341 * t244 * t80;
  t1378 = t1377 / 0.4e1;
  t1381 = t5 * t158 * t571 * t80;
  t1390 = t5 * t635 * t179;
  t1393 = t5 * t639 * t179;
  t1394 = t1393 / 0.4e1;
  t1396 = t5 * t643 * t179;
  t1398 = -0.3e1 / 0.8e1 * t5 * t1366 * t26 * t80 - 0.3e1 / 0.8e1 * t1373 + t1378 - 0.5e1 / 0.36e2 * t1381 - t1255 / 0.8e1 + t1259 / 0.4e1 - 0.5e1 / 0.12e2 * t1263 + t1268 - 0.3e1 / 0.8e1 * t5 * t631 * t179 - 0.3e1 / 0.8e1 * t1390 + t1394 - 0.5e1 / 0.36e2 * t1396;
  t1399 = my_piecewise3(t52, 0, t1398);
  tv4rho41 = t614 + t648 + 0.3e1 * t696 + 0.3e1 * t736 + t6 * (t1343 + t1399);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1414 = t313 * t313;
  t1427 = my_piecewise5(t10, 0, t14, 0, t1310);
  t1431 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1167 * t363 * t219 - 0.32e2 / 0.27e2 * t653 * t89 * t313 - 0.8e1 / 0.27e2 * t739 * t227 + 0.8e1 / 0.9e1 * t218 * t1414 + 0.8e1 / 0.9e1 * t309 * t664 - 0.8e1 / 0.27e2 * t532 * t368 * t219 + 0.8e1 / 0.9e1 * t218 * t748 * t89 + 0.4e1 / 0.9e1 * t744 * t227 + 0.4e1 / 0.3e1 * t23 * t1427);
  t1440 = t5 * t757 * t119;
  t1447 = t5 * t752 * t98 * t47;
  t1451 = t5 * t372 * t244 * t47;
  t1464 = -0.3e1 / 0.8e1 * t5 * t1431 * t26 * t47 - 0.3e1 / 0.4e1 * t5 * t753 * t119 - t1440 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t373 * t274 - t1447 / 0.4e1 + t1451 / 0.12e2 - t1277 / 0.4e1 + t1281 / 0.3e1 - 0.5e1 / 0.18e2 * t1285 - t1288 / 0.4e1 - t1325 / 0.2e1 + t1331 / 0.3e1 - 0.5e1 / 0.18e2 * t1124 + t1127 / 0.12e2 + t1203 / 0.6e1 + t1209 / 0.12e2 - 0.5e1 / 0.18e2 * t1213 + t1220;
  t1465 = my_piecewise3(t1, 0, t1464);
  t1474 = t337 * t337;
  t1487 = my_piecewise5(t14, 0, t10, 0, t1360);
  t1491 = my_piecewise3(t57, 0, 0.4e2 / 0.81e2 * t1229 * t380 * t282 - 0.32e2 / 0.27e2 * t697 * t127 * t337 - 0.8e1 / 0.27e2 * t769 * t288 + 0.8e1 / 0.9e1 * t281 * t1474 + 0.8e1 / 0.9e1 * t333 * t707 - 0.8e1 / 0.27e2 * t616 * t385 * t282 + 0.8e1 / 0.9e1 * t281 * t778 * t127 + 0.4e1 / 0.9e1 * t774 * t288 + 0.4e1 / 0.3e1 * t58 * t1487);
  t1498 = t5 * t782 * t98 * t80;
  t1502 = t5 * t389 * t244 * t80;
  t1511 = t5 * t716 * t179;
  t1514 = t5 * t720 * t179;
  t1525 = t5 * t297 * t421;
  t1528 = t5 * t301 * t421;
  t1530 = -0.3e1 / 0.8e1 * t5 * t1491 * t26 * t80 - t1498 / 0.4e1 + t1502 / 0.12e2 - t1373 / 0.4e1 + t1377 / 0.3e1 - 0.5e1 / 0.18e2 * t1381 - 0.3e1 / 0.4e1 * t5 * t712 * t179 - t1511 / 0.2e1 + t1514 / 0.6e1 + t1259 / 0.12e2 - 0.5e1 / 0.18e2 * t1263 + t1268 - t1390 / 0.4e1 + t1393 / 0.3e1 - 0.5e1 / 0.18e2 * t1396 - 0.3e1 / 0.8e1 * t5 * t293 * t421 - t1525 / 0.4e1 + t1528 / 0.12e2;
  t1531 = my_piecewise3(t52, 0, t1530);
  tv4rho42 = 0.2e1 * t696 + 0.2e1 * t736 + 0.2e1 * t768 + 0.2e1 * t807 + t6 * (t1465 + t1531);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1552 = my_piecewise5(t10, 0, t14, 0, t1309 + t1310);
  t1556 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1167 * t812 * t89 - 0.8e1 / 0.9e1 * t739 * t313 - 0.8e1 / 0.9e1 * t653 * t368 * t89 + 0.4e1 / 0.3e1 * t656 * t368 + 0.4e1 / 0.3e1 * t309 * t748 + 0.4e1 / 0.9e1 * t218 * t819 * t89 + 0.4e1 / 0.3e1 * t23 * t1552);
  t1563 = t5 * t823 * t98 * t47;
  t1574 = -0.3e1 / 0.8e1 * t5 * t1556 * t26 * t47 - t1563 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t824 * t119 - 0.3e1 / 0.8e1 * t1447 + t1451 / 0.4e1 - 0.3e1 / 0.8e1 * t1440 + t1282 - 0.5e1 / 0.12e2 * t1285 + t1332 - 0.5e1 / 0.36e2 * t1213 + t1220 - 0.5e1 / 0.36e2 * t1124;
  t1575 = my_piecewise3(t1, 0, t1574);
  t1592 = my_piecewise5(t14, 0, t10, 0, -t1309 + t1360);
  t1596 = my_piecewise3(t57, 0, 0.4e2 / 0.81e2 * t1229 * t832 * t127 - 0.8e1 / 0.9e1 * t769 * t337 - 0.8e1 / 0.9e1 * t697 * t385 * t127 + 0.4e1 / 0.3e1 * t700 * t385 + 0.4e1 / 0.3e1 * t333 * t778 + 0.4e1 / 0.9e1 * t281 * t839 * t127 + 0.4e1 / 0.3e1 * t58 * t1592);
  t1603 = t5 * t843 * t98 * t80;
  t1611 = t5 * t787 * t179;
  t1620 = t5 * t346 * t421;
  t1630 = t5 * t135 * t886;
  t1632 = -0.3e1 / 0.8e1 * t5 * t1596 * t26 * t80 - t1603 / 0.8e1 - 0.3e1 / 0.8e1 * t1498 + t1502 / 0.4e1 - 0.9e1 / 0.8e1 * t5 * t783 * t179 - 0.3e1 / 0.8e1 * t1611 + t1378 - 0.5e1 / 0.12e2 * t1381 - 0.3e1 / 0.4e1 * t1511 + t1514 / 0.2e1 - 0.9e1 / 0.8e1 * t5 * t342 * t421 - 0.3e1 / 0.8e1 * t1620 - 0.5e1 / 0.36e2 * t1263 + t1268 + t1394 - 0.5e1 / 0.12e2 * t1396 - 0.3e1 / 0.8e1 * t1525 + t1528 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t131 * t886 - t1630 / 0.8e1;
  t1633 = my_piecewise3(t52, 0, t1632);
  tv4rho43 = 0.3e1 * t768 + 0.3e1 * t807 + t831 + t891 + t6 * (t1575 + t1633);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1638 = t363 * t363;
  t1643 = t368 * t368;
  t1650 = my_piecewise5(t10, 0, t14, 0, 0.24e2 * t540 + 0.24e2 * t1181);
  t1654 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1167 * t1638 - 0.16e2 / 0.9e1 * t739 * t368 + 0.4e1 / 0.3e1 * t218 * t1643 + 0.16e2 / 0.9e1 * t309 * t819 + 0.4e1 / 0.3e1 * t23 * t1650);
  t1663 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1654 * t26 * t47 - t1563 / 0.2e1 + t1451 / 0.2e1 - 0.5e1 / 0.9e1 * t1285 + t1220);
  t1668 = 0.1e1 / t65 / t414;
  t1681 = t878 * rho[1];
  t1692 = 0.1e1 / t881 / t76;
  t1700 = t380 * t380;
  t1705 = t385 * t385;
  t1712 = my_piecewise5(t14, 0, t10, 0, -0.24e2 * t540 + 0.24e2 * t1241);
  t1716 = my_piecewise3(t57, 0, 0.4e2 / 0.81e2 * t1229 * t1700 - 0.16e2 / 0.9e1 * t769 * t385 + 0.4e1 / 0.3e1 * t281 * t1705 + 0.16e2 / 0.9e1 * t333 * t839 + 0.4e1 / 0.3e1 * t58 * t1712);
  t1735 = -0.3e1 / 0.2e1 * t5 * t159 * t886 - 0.3e1 / 0.8e1 * t5 * t61 * (0.35912208504801097395e1 * t62 * t1668 + 0.364e4 / 0.81e2 * t71 * t1108 * t77 - 0.23072e5 / 0.27e2 * t173 * t1668 * t175 + 0.476672e6 / 0.81e2 * t413 / t878 * t417 - 0.475136e6 / 0.27e2 * t877 / t64 / t1681 * t882 + 0.524288e6 / 0.27e2 * params->cc * t1098 / t65 / t878 / t63 * t1692) - 0.3e1 / 0.8e1 * t5 * t1716 * t26 * t80 - 0.3e1 / 0.2e1 * t5 * t844 * t179 - 0.9e1 / 0.4e1 * t5 * t390 * t421 - t1630 / 0.2e1 - t1603 / 0.2e1 - 0.3e1 / 0.2e1 * t1611 - 0.3e1 / 0.2e1 * t1620 + t1528 / 0.2e1 + t1502 / 0.2e1 + t1514 - 0.5e1 / 0.9e1 * t1396 - 0.5e1 / 0.9e1 * t1381 + t1268;
  t1736 = my_piecewise3(t52, 0, t1735);
  tv4rho44 = 0.4e1 * t831 + 0.4e1 * t891 + t6 * (t1663 + t1736);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t1744 = t5 * t553 * t196;
  t1750 = t5 * t560 * t196;
  t1753 = t5 * t236 * t448;
  t1760 = 0.5e1 / 0.36e2 * t5 * t572 * t196;
  t1762 = t5 * t245 * t448;
  t1765 = t5 * t99 * t926;
  t1791 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t549 * t196 - 0.3e1 / 0.8e1 * t1744 - 0.9e1 / 0.8e1 * t5 * t232 * t448 + t1750 / 0.4e1 - 0.3e1 / 0.4e1 * t1753 - 0.9e1 / 0.8e1 * t5 * t93 * t926 - t1760 + t1762 / 0.4e1 - 0.3e1 / 0.8e1 * t1765 - 0.3e1 / 0.8e1 * t5 * t27 * (-0.63374485596707818932e0 * params->bb * t583 - 0.14e3 / 0.27e2 * t190 * t588 + 0.1456e4 / 0.9e1 * params->cc * t583 * t115 - 0.40576e5 / 0.27e2 * params->cc * t595 * t445 + 0.50176e5 / 0.9e1 * params->cc * t603 * t923 - 0.65536e5 / 0.9e1 * params->cc / t31 / t1146 * t1157 * t265));
  tv4rho3sigma0 = t6 * t1791 + 0.3e1 * t931;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t1798 = t5 * t635 * t210;
  t1801 = t5 * t639 * t210;
  t1805 = 0.5e1 / 0.36e2 * t5 * t643 * t210;
  t1807 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t631 * t210 - 0.3e1 / 0.8e1 * t1798 + t1801 / 0.4e1 - t1805);
  tv4rho3sigma2 = t6 * t1807 + 0.3e1 * t944;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t1809 = 0.2e1 * t958;
  t1815 = t5 * t673 * t196 / 0.4e1;
  t1820 = t5 * t680 * t196;
  t1824 = t5 * t322 * t448 / 0.4e1;
  t1833 = -0.3e1 / 0.8e1 * t5 * t669 * t196 - t1815 - 0.3e1 / 0.4e1 * t5 * t318 * t448 + t1820 / 0.12e2 - t1824 - 0.3e1 / 0.8e1 * t5 * t148 * t926 - t1744 / 0.8e1 + t1750 / 0.6e1 - t1753 / 0.4e1 - t1760 + t1762 / 0.6e1 - t1765 / 0.8e1;
  t1834 = my_piecewise3(t1, 0, t1833);
  tv4rho3sigma3 = t6 * t1834 + t1809 + t931;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t1836 = 0.2e1 * t974;
  t1842 = t5 * t716 * t210 / 0.4e1;
  t1844 = t5 * t720 * t210;
  t1853 = t5 * t297 * t486 / 0.4e1;
  t1855 = t5 * t301 * t486;
  t1858 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t712 * t210 - t1842 + t1844 / 0.12e2 - t1798 / 0.8e1 + t1801 / 0.6e1 - t1805 - 0.3e1 / 0.8e1 * t5 * t293 * t486 - t1853 + t1855 / 0.12e2);
  tv4rho3sigma5 = t6 * t1858 + t1836 + t944;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t1864 = t5 * t757 * t196;
  t1873 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t753 * t196 - t1864 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t373 * t448 - t1815 + t1820 / 0.6e1 - t1824 + t1750 / 0.12e2 - t1760 + t1762 / 0.12e2);
  tv4rho3sigma6 = t6 * t1873 + t1809 + t982;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t1879 = t5 * t787 * t210;
  t1886 = t5 * t346 * t486;
  t1894 = t5 * t135 * t1009;
  t1896 = -0.3e1 / 0.8e1 * t5 * t783 * t210 - t1879 / 0.8e1 - t1842 + t1844 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t342 * t486 - t1886 / 0.4e1 + t1801 / 0.12e2 - t1805 - t1853 + t1855 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t131 * t1009 - t1894 / 0.8e1;
  t1897 = my_piecewise3(t52, 0, t1896);
  tv4rho3sigma8 = t6 * t1897 + t1014 + t1836;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t1906 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t824 * t196 - 0.3e1 / 0.8e1 * t1864 + t1820 / 0.4e1 - t1760);
  tv4rho3sigma9 = t6 * t1906 + 0.3e1 * t982;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t1947 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t844 * t210 - 0.3e1 / 0.8e1 * t1879 - 0.9e1 / 0.8e1 * t5 * t390 * t486 + t1844 / 0.4e1 - 0.3e1 / 0.4e1 * t1886 - 0.9e1 / 0.8e1 * t5 * t159 * t1009 - t1805 + t1855 / 0.4e1 - 0.3e1 / 0.8e1 * t1894 - 0.3e1 / 0.8e1 * t5 * t61 * (-0.63374485596707818932e0 * params->bb * t860 - 0.14e3 / 0.27e2 * t204 * t865 + 0.1456e4 / 0.9e1 * params->cc * t860 * t175 - 0.40576e5 / 0.27e2 * params->cc * t872 * t483 + 0.50176e5 / 0.9e1 * params->cc * t880 * t1006 - 0.65536e5 / 0.9e1 * params->cc / t65 / t1681 * t1692 * t412));
  tv4rho3sigma11 = t6 * t1947 + 0.3e1 * t1014;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t1954 = t5 * t236 * t506;
  t1961 = t5 * t245 * t506 / 0.12e2;
  t1963 = t5 * t99 * t1034;
  t1984 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t232 * t506 - t1954 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t93 * t1034 + t1961 - t1963 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * (-0.7e1 / 0.9e1 * t494 * t259 - 0.28e2 / 0.9e1 * t498 * t262 + 0.2048e4 / 0.9e1 * t190 * t271 - 0.448e4 / 0.3e1 * t922 * t605 + 0.8192e4 / 0.3e1 * params->cc / t31 / t601 * t1157 * t36));
  tv4rho2sigma20 = t6 * t1984 + 0.2e1 * t1039;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t1991 = t5 * t297 * t524;
  t1995 = t5 * t301 * t524 / 0.12e2;
  t1997 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t293 * t524 - t1991 / 0.4e1 + t1995);
  tv4rho2sigma25 = t6 * t1997 + 0.2e1 * t1048;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2003 = t5 * t322 * t506;
  t2011 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t318 * t506 - t2003 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t148 * t1034 - t1954 / 0.8e1 + t1961 - t1963 / 0.8e1);
  tv4rho2sigma26 = t6 * t2011 + t1039 + t1054;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t2017 = t5 * t346 * t524;
  t2024 = t5 * t135 * t1071;
  t2027 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t342 * t524 - t2017 / 0.8e1 - t1991 / 0.8e1 + t1995 - 0.3e1 / 0.8e1 * t5 * t131 * t1071 - t2024 / 0.8e1);
  tv4rho2sigma211 = t6 * t2027 + t1048 + t1076;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2035 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t373 * t506 - t2003 / 0.4e1 + t1961);
  tv4rho2sigma212 = t6 * t2035 + 0.2e1 * t1054;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t2065 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t390 * t524 - t2017 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t159 * t1071 + t1995 - t2024 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t61 * (-0.7e1 / 0.9e1 * t512 * t406 - 0.28e2 / 0.9e1 * t516 * t409 + 0.2048e4 / 0.9e1 * t204 * t418 - 0.448e4 / 0.3e1 * t1005 * t882 + 0.8192e4 / 0.3e1 * params->cc / t65 / t878 * t1692 * t70));
  tv4rho2sigma217 = t6 * t2065 + 0.2e1 * t1076;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2072 = t5 * t99 * t1093 / 0.8e1;
  t2092 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t93 * t1093 - t2072 - 0.3e1 / 0.8e1 * t5 * t27 * (-t1080 * t110 / 0.2e1 - 0.2e1 * t1084 * t116 + 0.16e2 * t494 * t1026 + 0.256e3 * t1031 * t1090 - 0.1024e4 * params->cc / t31 / t594 * t1157 * t189));
  tv4rhosigma30 = t6 * t2092 + t1097;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t2099 = t5 * t135 * t1113 / 0.8e1;
  t2101 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t131 * t1113 - t2099);
  tv4rhosigma39 = t6 * t2101 + t1117;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t2107 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t148 * t1093 - t2072);
  tv4rhosigma310 = t6 * t2107 + t1097;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t2131 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t159 * t1113 - t2099 - 0.3e1 / 0.8e1 * t5 * t61 * (-t1100 * t170 / 0.2e1 - 0.2e1 * t1104 * t176 + 0.16e2 * t512 * t1063 + 0.256e3 * t1068 * t1110 - 0.1024e4 * params->cc / t65 / t871 * t1692 * t203));
  tv4rhosigma319 = t6 * t2131 + t1117;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t2133 = t599 * sigma[0];
  t2157 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (-0.15e2 / 0.16e2 * params->cc / t36 / t2133 * t45 - 0.15e2 / 0.4e1 * params->cc / t2133 * t499 - 0.6e1 * t1080 * t501 * t270 + 0.384e3 * params->cc * t1133 * t1157 * t493 + 0.48e2 * t1089 * t605 * t1083));
  tv4sigma40 = t6 * t2157;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t2158 = t876 * sigma[2];
  t2182 = my_piecewise3(t52, 0, -0.3e1 / 0.8e1 * t5 * t61 * (-0.15e2 / 0.16e2 * params->cc / t70 / t2158 * t78 - 0.15e2 / 0.4e1 * params->cc / t2158 * t517 - 0.6e1 * t1100 * t519 * t417 + 0.384e3 * params->cc * t1668 * t1692 * t511 + 0.48e2 * t1109 * t882 * t1103));
  tv4sigma414 = t6 * t2182;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

