# Locate Luabind library

FIND_PATH(LUABIND_INCLUDE_DIRS luabind/luabind.hpp
  HINTS $ENV{LUABIND_DIR}
  PATH_SUFFIXES include/luabind09 include/luabind include
)

FIND_LIBRARY(_LUABIND_LIBRARY_RELEASE
  NAMES luabind09 luabind-0.9 luabind
  HINTS $ENV{LUABIND_DIR}
  PATH_SUFFIXES lib64 lib
)

FIND_LIBRARY(_LUABIND_LIBRARY_DEBUG
  NAMES luabind09-d luabind-0.9-d luabind-d
  HINTS $ENV{LUABIND_DIR}
  PATH_SUFFIXES lib64 lib
)

IF(_LUABIND_LIBRARY_RELEASE OR _LUABIND_LIBRARY_DEBUG)
    IF(_LUABIND_LIBRARY_RELEASE AND _LUABIND_LIBRARY_DEBUG)
        SET(_LUABIND_LIBRARY optimized ${_LUABIND_LIBRARY_RELEASE}
                             debug     ${_LUABIND_LIBRARY_DEBUG})
    ELSEIF(_LUABIND_LIBRARY_RELEASE)
        SET(_LUABIND_LIBRARY ${_LUABIND_LIBRARY_RELEASE})
    ELSE()
        SET(_LUABIND_LIBRARY ${_LUABIND_LIBRARY_DEBUG})
    ENDIF()
ENDIF()

IF(_LUABIND_LIBRARY)
    SET(LUABIND_LIBRARIES
        "${_LUABIND_LIBRARY}" CACHE STRING "Luabind Libraries")
ENDIF(_LUABIND_LIBRARY)

INCLUDE(${CMAKE_ROOT}/Modules/FindPackageHandleStandardArgs.cmake)
# handle the QUIETLY and REQUIRED arguments and set LUABIND_FOUND to TRUE if
# all listed variables are TRUE
FIND_PACKAGE_HANDLE_STANDARD_ARGS(Luabind
    REQUIRED_VARS LUABIND_INCLUDE_DIRS LUABIND_LIBRARIES)

MARK_AS_ADVANCED(LUABIND_INCLUDE_DIRS LUABIND_LIBRARIES)
