---
layout: post
title: Announcing Leaflet 1.0-rc1
description: Leaflet 1.0 Release Candidate 1 ready
author: Iván Sánchez
authorsite: http://ivan.sanchezortega.es
---

The road to Leaflet 1.0 continues - we're proud to get the first release candidate for 1.0 into the wild.

Leaflet 1.0-rc1 closes down on edge cases and API inconsistencies that were present in beta2. The full list of changes is in the [1.0.0-rc1 changelog](https://github.com/Leaflet/Leaflet/blob/master/CHANGELOG.md#10-rc1-april-18-2016)) as usual, with about 50 bugfixes and a dozen improvements and minor API changes.


### Notable changes

* Fractional zoom controls: In beta2, developers could set a fractional zoom level only by code, running e.g. `map.setZoom(8.5)`. Now the map has options (`zoomSnap` and `zoomDelta`) to let the user navigate through fractional zoom levels.

* Better handling of vector layers when using the `<canvas>` renderer, when layers are non-interactive and lines are dashed.

* The first ever Microsoft Edge hack (handle inconsistent `dblclick` behaviour on Win10 touchscreens)

* Unit tests with `prosthetic-hand`, letting us be sure that touch interactions behave consistently. This has its [own blog post](https://leafletjs.com/2016/03/20/debugging-touch-interactions.html).


### Changes in the API documentation

The API documentation is now generated from docstrings, thanks to a new tool dubbed [🍂doc](https://github.com/Leaflet/Leafdoc) (or "leafdoc").

Previously, the API documentation was edited manually. This involved a lot of copy-pasting and - over time - bits of code started not to match the documentation.

Most complex software projects use some form of [docstrings](https://en.wikipedia.org/wiki/Docstring) and tools like [JavaDoc](https://en.wikipedia.org/wiki/Javadoc), [NaturalDocs](http://www.naturaldocs.org/) or [JSdoc](http://usejsdoc.org/) to convert the docstrings into webpages.

But the documentation for Leaflet requires a few special bits - docstrings cover methods and properties, but they do not cover options nor events, and we wanted to maintain the current look and feel of the documentation. 🍂doc was then born to overcome these limitations.

Leaflet uses class inheritance quite extensively, and the old documentation was sometimes not clear about it. Some users struggled to find the available methods for some of the classes, and inherited options were sometimes mentioned, sometimes not. 🍂doc fixes this by including the documentation of all inherited methods/options/events/properties, collapsed by default:

![Collapsed inheritances for L.Polygon](/docs/images/2016-04-18-inheritances.gif)

The [build system](https://github.com/Leaflet/Leaflet/blob/master/CONTRIBUTING.md#setting-up-the-build-system) now builds a HTML file with the API docs alongside the minified `leaflet.js` file. Documentation will be updated on every release based on that file, and pull requests to the `gh-pages` branch to fix the documentation will be automatically rejected.

### Get the release candidate

As with previous releases, you can use our CDN:

    <link rel="stylesheet" href="http://cdn.leafletjs.com/leaflet/v1.0.0-rc.1/leaflet.css" />
    <script src="http://cdn.leafletjs.com/leaflet/v1.0.0-rc.1/leaflet.js"></script>

A non-minified version of the javascript file is also available as:

    <script src="http://cdn.leafletjs.com/leaflet/v1.0.0-rc.1/leaflet-src.js"></script>

The release is also available through NPM (`npm install leaflet@rc`), [GitHub download](https://github.com/Leaflet/Leaflet/archive/v1.0.0-rc.1.zip), and [CDN download](http://cdn.leafletjs.com/leaflet/v1.0.0-rc.1/leaflet.zip). We discourage using Bower.


### The team in person

This Release Candidate leapt forward when most of the Leaflet team met in Madrid for a weekend to fix bugs and discuss architectural decisions, and whether some big features should make it to 1.0 or be postponed.

<table class="image">
<caption align="bottom"><small>This photograph <em>might</em> have been digitally altered to include somebody who couldn't come to Madrid that weekend.</small></caption>
<tr><td style='text-align:center'><img src="/docs/images/2016-04-18-madrid-leaflet-864px.jpg" alt="The Leaflet team in Madrid"/></td></tr>
</table>


<table class="image">
<caption align="bottom"><small>Iván and Yohan want to extend a special thanks to the roll of toilet paper.</small></caption>
<tr><td style='text-align:center'><img src="/docs/images/2016-04-18-leaflet-toilet-paper.jpeg" alt="The Leaflet team in Madrid" width="864"/></td></tr>
</table>


We enjoyed meeting in person and fighting bugs together. It proved to be a very productive thing to do, as about 20 issues were closed that day. Hopefully another in-person meeting will happen soon, with another release!


We hope you enjoy Leaflet 1.0-rc1 as much as we did coding it!


Best,
Iván & Vladimir & Yohan & Per & Zsolt.
