
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQWindow.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QWindow>
#include <QScreen>
#include <QAccessibleInterface>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QWindow

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QWindow::staticMetaObject);
}


// QAccessibleInterface *QWindow::accessibleRoot()


static void _init_f_accessibleRoot_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_f_accessibleRoot_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QWindow *)cls)->accessibleRoot ());
}


// void QWindow::alert(int msec)


static void _init_f_alert_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_alert_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->alert (arg1);
}


// QSize QWindow::baseSize()


static void _init_f_baseSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_baseSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWindow *)cls)->baseSize ());
}


// bool QWindow::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWindow *)cls)->close ());
}


// Qt::ScreenOrientation QWindow::contentOrientation()


static void _init_f_contentOrientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ScreenOrientation>::target_type > ();
}

static void _call_f_contentOrientation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::ScreenOrientation>::target_type > ((qt_gsi::Converter<Qt::ScreenOrientation>::target_type)qt_gsi::CppToQtAdaptor<Qt::ScreenOrientation>(((QWindow *)cls)->contentOrientation ()));
}


// void QWindow::create()


static void _init_f_create_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_create_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->create ();
}


// QCursor QWindow::cursor()


static void _init_f_cursor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCursor > ();
}

static void _call_f_cursor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCursor > ((QCursor)((QWindow *)cls)->cursor ());
}


// void QWindow::destroy()


static void _init_f_destroy_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_destroy_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->destroy ();
}


// double QWindow::devicePixelRatio()


static void _init_f_devicePixelRatio_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_devicePixelRatio_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QWindow *)cls)->devicePixelRatio ());
}


// QString QWindow::filePath()


static void _init_f_filePath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_filePath_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWindow *)cls)->filePath ());
}


// QFlags<Qt::WindowType> QWindow::flags()


static void _init_f_flags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::WindowType> > ();
}

static void _call_f_flags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::WindowType> > ((QFlags<Qt::WindowType>)((QWindow *)cls)->flags ());
}


// QObject *QWindow::focusObject()


static void _init_f_focusObject_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_f_focusObject_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QWindow *)cls)->focusObject ());
}


// QSurfaceFormat QWindow::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSurfaceFormat > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSurfaceFormat > ((QSurfaceFormat)((QWindow *)cls)->format ());
}


// QRect QWindow::frameGeometry()


static void _init_f_frameGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_frameGeometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QWindow *)cls)->frameGeometry ());
}


// QMargins QWindow::frameMargins()


static void _init_f_frameMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_f_frameMargins_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMargins > ((QMargins)((QWindow *)cls)->frameMargins ());
}


// QPoint QWindow::framePosition()


static void _init_f_framePosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_framePosition_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QWindow *)cls)->framePosition ());
}


// QRect QWindow::geometry()


static void _init_f_geometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_geometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QWindow *)cls)->geometry ());
}


// int QWindow::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWindow *)cls)->height ());
}


// void QWindow::hide()


static void _init_f_hide_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_hide_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->hide ();
}


// QIcon QWindow::icon()


static void _init_f_icon_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_icon_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIcon > ((QIcon)((QWindow *)cls)->icon ());
}


// bool QWindow::isActive()


static void _init_f_isActive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWindow *)cls)->isActive ());
}


// bool QWindow::isAncestorOf(const QWindow *child, QWindow::AncestorMode mode)


static void _init_f_isAncestorOf_c4407 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<const QWindow * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QWindow::IncludeTransients");
  decl->add_arg<const qt_gsi::Converter<QWindow::AncestorMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isAncestorOf_c4407 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWindow *arg1 = gsi::arg_reader<const QWindow * >() (args, heap);
  const qt_gsi::Converter<QWindow::AncestorMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QWindow::AncestorMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QWindow::AncestorMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QWindow::AncestorMode>(heap, QWindow::IncludeTransients), heap);
  ret.write<bool > ((bool)((QWindow *)cls)->isAncestorOf (arg1, qt_gsi::QtToCppAdaptor<QWindow::AncestorMode>(arg2).cref()));
}


// bool QWindow::isExposed()


static void _init_f_isExposed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isExposed_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWindow *)cls)->isExposed ());
}


// bool QWindow::isModal()


static void _init_f_isModal_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isModal_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWindow *)cls)->isModal ());
}


// bool QWindow::isTopLevel()


static void _init_f_isTopLevel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTopLevel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWindow *)cls)->isTopLevel ());
}


// bool QWindow::isVisible()


static void _init_f_isVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isVisible_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QWindow *)cls)->isVisible ());
}


// void QWindow::lower()


static void _init_f_lower_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_lower_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->lower ();
}


// QPoint QWindow::mapFromGlobal(const QPoint &pos)


static void _init_f_mapFromGlobal_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapFromGlobal_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QPoint > ((QPoint)((QWindow *)cls)->mapFromGlobal (arg1));
}


// QPoint QWindow::mapToGlobal(const QPoint &pos)


static void _init_f_mapToGlobal_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapToGlobal_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QPoint > ((QPoint)((QWindow *)cls)->mapToGlobal (arg1));
}


// QRegion QWindow::mask()


static void _init_f_mask_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_mask_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRegion > ((QRegion)((QWindow *)cls)->mask ());
}


// int QWindow::maximumHeight()


static void _init_f_maximumHeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumHeight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWindow *)cls)->maximumHeight ());
}


// QSize QWindow::maximumSize()


static void _init_f_maximumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_maximumSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWindow *)cls)->maximumSize ());
}


// int QWindow::maximumWidth()


static void _init_f_maximumWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWindow *)cls)->maximumWidth ());
}


// int QWindow::minimumHeight()


static void _init_f_minimumHeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumHeight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWindow *)cls)->minimumHeight ());
}


// QSize QWindow::minimumSize()


static void _init_f_minimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWindow *)cls)->minimumSize ());
}


// int QWindow::minimumWidth()


static void _init_f_minimumWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWindow *)cls)->minimumWidth ());
}


// Qt::WindowModality QWindow::modality()


static void _init_f_modality_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::WindowModality>::target_type > ();
}

static void _call_f_modality_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::WindowModality>::target_type > ((qt_gsi::Converter<Qt::WindowModality>::target_type)qt_gsi::CppToQtAdaptor<Qt::WindowModality>(((QWindow *)cls)->modality ()));
}


// double QWindow::opacity()


static void _init_f_opacity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_opacity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QWindow *)cls)->opacity ());
}


// QWindow *QWindow::parent(QWindow::AncestorMode mode)


static void _init_f_parent_c2485 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QWindow::AncestorMode>::target_type & > (argspec_0);
  decl->set_return<QWindow * > ();
}

static void _call_f_parent_c2485 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWindow::AncestorMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWindow::AncestorMode>::target_type & >() (args, heap);
  ret.write<QWindow * > ((QWindow *)((QWindow *)cls)->parent (qt_gsi::QtToCppAdaptor<QWindow::AncestorMode>(arg1).cref()));
}


// QWindow *QWindow::parent()


static void _init_f_parent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWindow * > ();
}

static void _call_f_parent_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWindow * > ((QWindow *)((QWindow *)cls)->parent ());
}


// QPoint QWindow::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QWindow *)cls)->position ());
}


// void QWindow::raise()


static void _init_f_raise_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_raise_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->raise ();
}


// void QWindow::reportContentOrientationChange(Qt::ScreenOrientation orientation)


static void _init_f_reportContentOrientationChange_2521 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_reportContentOrientationChange_2521 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->reportContentOrientationChange (qt_gsi::QtToCppAdaptor<Qt::ScreenOrientation>(arg1).cref());
}


// void QWindow::requestActivate()


static void _init_f_requestActivate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_requestActivate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->requestActivate ();
}


// void QWindow::requestUpdate()


static void _init_f_requestUpdate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_requestUpdate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->requestUpdate ();
}


// QSurfaceFormat QWindow::requestedFormat()


static void _init_f_requestedFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSurfaceFormat > ();
}

static void _call_f_requestedFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSurfaceFormat > ((QSurfaceFormat)((QWindow *)cls)->requestedFormat ());
}


// void QWindow::resize(const QSize &newSize)


static void _init_f_resize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newSize");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_resize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->resize (arg1);
}


// void QWindow::resize(int w, int h)


static void _init_f_resize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_resize_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->resize (arg1, arg2);
}


// QScreen *QWindow::screen()


static void _init_f_screen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QScreen * > ();
}

static void _call_f_screen_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QScreen * > ((QScreen *)((QWindow *)cls)->screen ());
}


// void QWindow::setBaseSize(const QSize &size)


static void _init_f_setBaseSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBaseSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setBaseSize (arg1);
}


// void QWindow::setCursor(const QCursor &)


static void _init_f_setCursor_2032 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursor_2032 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QCursor &arg1 = gsi::arg_reader<const QCursor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setCursor (arg1);
}


// void QWindow::setFilePath(const QString &filePath)


static void _init_f_setFilePath_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filePath");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFilePath_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setFilePath (arg1);
}


// void QWindow::setFlag(Qt::WindowType, bool on)


static void _init_f_setFlag_2555 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFlag_2555 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WindowType>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setFlag (qt_gsi::QtToCppAdaptor<Qt::WindowType>(arg1).cref(), arg2);
}


// void QWindow::setFlags(QFlags<Qt::WindowType> flags)


static void _init_f_setFlags_2495 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFlags_2495 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::WindowType> arg1 = gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setFlags (arg1);
}


// void QWindow::setFormat(const QSurfaceFormat &format)


static void _init_f_setFormat_2724 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QSurfaceFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2724 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSurfaceFormat &arg1 = gsi::arg_reader<const QSurfaceFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setFormat (arg1);
}


// void QWindow::setFramePosition(const QPoint &point)


static void _init_f_setFramePosition_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFramePosition_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setFramePosition (arg1);
}


// void QWindow::setGeometry(int posx, int posy, int w, int h)


static void _init_f_setGeometry_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("posx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("posy");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setGeometry (arg1, arg2, arg3, arg4);
}


// void QWindow::setGeometry(const QRect &rect)


static void _init_f_setGeometry_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setGeometry (arg1);
}


// void QWindow::setHeight(int arg)


static void _init_f_setHeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setHeight (arg1);
}


// void QWindow::setIcon(const QIcon &icon)


static void _init_f_setIcon_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIcon_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setIcon (arg1);
}


// bool QWindow::setKeyboardGrabEnabled(bool grab)


static void _init_f_setKeyboardGrabEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("grab");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setKeyboardGrabEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ret.write<bool > ((bool)((QWindow *)cls)->setKeyboardGrabEnabled (arg1));
}


// void QWindow::setMask(const QRegion &region)


static void _init_f_setMask_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMask_2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setMask (arg1);
}


// void QWindow::setMaximumHeight(int h)


static void _init_f_setMaximumHeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumHeight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setMaximumHeight (arg1);
}


// void QWindow::setMaximumSize(const QSize &size)


static void _init_f_setMaximumSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setMaximumSize (arg1);
}


// void QWindow::setMaximumWidth(int w)


static void _init_f_setMaximumWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setMaximumWidth (arg1);
}


// void QWindow::setMinimumHeight(int h)


static void _init_f_setMinimumHeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumHeight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setMinimumHeight (arg1);
}


// void QWindow::setMinimumSize(const QSize &size)


static void _init_f_setMinimumSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setMinimumSize (arg1);
}


// void QWindow::setMinimumWidth(int w)


static void _init_f_setMinimumWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setMinimumWidth (arg1);
}


// void QWindow::setModality(Qt::WindowModality modality)


static void _init_f_setModality_2216 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modality");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowModality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModality_2216 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowModality>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WindowModality>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setModality (qt_gsi::QtToCppAdaptor<Qt::WindowModality>(arg1).cref());
}


// bool QWindow::setMouseGrabEnabled(bool grab)


static void _init_f_setMouseGrabEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("grab");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setMouseGrabEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ret.write<bool > ((bool)((QWindow *)cls)->setMouseGrabEnabled (arg1));
}


// void QWindow::setOpacity(double level)


static void _init_f_setOpacity_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("level");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpacity_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setOpacity (arg1);
}


// void QWindow::setParent(QWindow *parent)


static void _init_f_setParent_1335 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWindow * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setParent_1335 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWindow *arg1 = gsi::arg_reader<QWindow * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setParent (arg1);
}


// void QWindow::setPosition(const QPoint &pt)


static void _init_f_setPosition_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPosition_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setPosition (arg1);
}


// void QWindow::setPosition(int posx, int posy)


static void _init_f_setPosition_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("posx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("posy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPosition_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setPosition (arg1, arg2);
}


// void QWindow::setScreen(QScreen *screen)


static void _init_f_setScreen_1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("screen");
  decl->add_arg<QScreen * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScreen_1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScreen *arg1 = gsi::arg_reader<QScreen * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setScreen (arg1);
}


// void QWindow::setSizeIncrement(const QSize &size)


static void _init_f_setSizeIncrement_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSizeIncrement_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setSizeIncrement (arg1);
}


// void QWindow::setSurfaceType(QSurface::SurfaceType surfaceType)


static void _init_f_setSurfaceType_2477 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("surfaceType");
  decl->add_arg<const qt_gsi::Converter<QSurface::SurfaceType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSurfaceType_2477 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSurface::SurfaceType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSurface::SurfaceType>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setSurfaceType (qt_gsi::QtToCppAdaptor<QSurface::SurfaceType>(arg1).cref());
}


// void QWindow::setTitle(const QString &)


static void _init_f_setTitle_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTitle_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setTitle (arg1);
}


// void QWindow::setTransientParent(QWindow *parent)


static void _init_f_setTransientParent_1335 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWindow * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTransientParent_1335 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWindow *arg1 = gsi::arg_reader<QWindow * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setTransientParent (arg1);
}


// void QWindow::setVisibility(QWindow::Visibility v)


static void _init_f_setVisibility_2329 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("v");
  decl->add_arg<const qt_gsi::Converter<QWindow::Visibility>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisibility_2329 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWindow::Visibility>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWindow::Visibility>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setVisibility (qt_gsi::QtToCppAdaptor<QWindow::Visibility>(arg1).cref());
}


// void QWindow::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setVisible (arg1);
}


// void QWindow::setWidth(int arg)


static void _init_f_setWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setWidth (arg1);
}


// void QWindow::setWindowState(Qt::WindowState state)


static void _init_f_setWindowState_1894 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowState_1894 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowState>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WindowState>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setWindowState (qt_gsi::QtToCppAdaptor<Qt::WindowState>(arg1).cref());
}


// void QWindow::setWindowStates(QFlags<Qt::WindowState> states)


static void _init_f_setWindowStates_2590 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("states");
  decl->add_arg<QFlags<Qt::WindowState> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowStates_2590 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::WindowState> arg1 = gsi::arg_reader<QFlags<Qt::WindowState> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setWindowStates (arg1);
}


// void QWindow::setX(int arg)


static void _init_f_setX_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setX_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setX (arg1);
}


// void QWindow::setY(int arg)


static void _init_f_setY_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setY_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->setY (arg1);
}


// void QWindow::show()


static void _init_f_show_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_show_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->show ();
}


// void QWindow::showFullScreen()


static void _init_f_showFullScreen_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showFullScreen_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->showFullScreen ();
}


// void QWindow::showMaximized()


static void _init_f_showMaximized_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showMaximized_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->showMaximized ();
}


// void QWindow::showMinimized()


static void _init_f_showMinimized_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showMinimized_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->showMinimized ();
}


// void QWindow::showNormal()


static void _init_f_showNormal_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showNormal_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->showNormal ();
}


// QSize QWindow::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWindow *)cls)->size ());
}


// QSize QWindow::sizeIncrement()


static void _init_f_sizeIncrement_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeIncrement_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWindow *)cls)->sizeIncrement ());
}


// QSurface::SurfaceType QWindow::surfaceType()


static void _init_f_surfaceType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSurface::SurfaceType>::target_type > ();
}

static void _call_f_surfaceType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSurface::SurfaceType>::target_type > ((qt_gsi::Converter<QSurface::SurfaceType>::target_type)qt_gsi::CppToQtAdaptor<QSurface::SurfaceType>(((QWindow *)cls)->surfaceType ()));
}


// QString QWindow::title()


static void _init_f_title_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_title_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QWindow *)cls)->title ());
}


// QWindow *QWindow::transientParent()


static void _init_f_transientParent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWindow * > ();
}

static void _call_f_transientParent_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWindow * > ((QWindow *)((QWindow *)cls)->transientParent ());
}


// Qt::WindowType QWindow::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::WindowType>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::WindowType>::target_type > ((qt_gsi::Converter<Qt::WindowType>::target_type)qt_gsi::CppToQtAdaptor<Qt::WindowType>(((QWindow *)cls)->type ()));
}


// void QWindow::unsetCursor()


static void _init_f_unsetCursor_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetCursor_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow *)cls)->unsetCursor ();
}


// QWindow::Visibility QWindow::visibility()


static void _init_f_visibility_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QWindow::Visibility>::target_type > ();
}

static void _call_f_visibility_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QWindow::Visibility>::target_type > ((qt_gsi::Converter<QWindow::Visibility>::target_type)qt_gsi::CppToQtAdaptor<QWindow::Visibility>(((QWindow *)cls)->visibility ()));
}


// int QWindow::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWindow *)cls)->width ());
}


// WId QWindow::winId()


static void _init_f_winId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<WId>::target_type > ();
}

static void _call_f_winId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<WId>::target_type > ((qt_gsi::Converter<WId>::target_type)qt_gsi::CppToQtAdaptor<WId>(((QWindow *)cls)->winId ()));
}


// Qt::WindowState QWindow::windowState()


static void _init_f_windowState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::WindowState>::target_type > ();
}

static void _call_f_windowState_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::WindowState>::target_type > ((qt_gsi::Converter<Qt::WindowState>::target_type)qt_gsi::CppToQtAdaptor<Qt::WindowState>(((QWindow *)cls)->windowState ()));
}


// QFlags<Qt::WindowState> QWindow::windowStates()


static void _init_f_windowStates_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::WindowState> > ();
}

static void _call_f_windowStates_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::WindowState> > ((QFlags<Qt::WindowState>)((QWindow *)cls)->windowStates ());
}


// int QWindow::x()


static void _init_f_x_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_x_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWindow *)cls)->x ());
}


// int QWindow::y()


static void _init_f_y_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_y_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWindow *)cls)->y ());
}


// static QWindow *QWindow::fromWinId(WId id)


static void _init_f_fromWinId_696 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  decl->set_return<QWindow * > ();
}

static void _call_f_fromWinId_696 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap);
  ret.write<QWindow * > ((QWindow *)QWindow::fromWinId (qt_gsi::QtToCppAdaptor<WId>(arg1).cref()));
}


// static QString QWindow::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QWindow::tr (arg1, arg2, arg3));
}


// static QString QWindow::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QWindow::trUtf8 (arg1, arg2, arg3));
}


//  base class cast for QObject

static void _init_f_QWindow_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QWindow_as_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QWindow *)cls);
}

static void _init_f_QWindow_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QWindow_as_const_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QWindow *)cls);
}

//  base class cast for QSurface

static void _init_f_QWindow_as_QSurface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSurface *> ();
}

static void _call_f_QWindow_as_QSurface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QSurface *> ((QSurface *)(QWindow *)cls);
}

static void _init_f_QWindow_as_const_QSurface (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QSurface *> ();
}

static void _call_f_QWindow_as_const_QSurface (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QSurface *> ((const QSurface *)(const QWindow *)cls);
}


namespace gsi
{

static gsi::Methods methods_QWindow () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("accessibleRoot", "@brief Method QAccessibleInterface *QWindow::accessibleRoot()\n", true, &_init_f_accessibleRoot_c0, &_call_f_accessibleRoot_c0);
  methods += new qt_gsi::GenericMethod ("alert", "@brief Method void QWindow::alert(int msec)\n", false, &_init_f_alert_767, &_call_f_alert_767);
  methods += new qt_gsi::GenericMethod (":baseSize", "@brief Method QSize QWindow::baseSize()\n", true, &_init_f_baseSize_c0, &_call_f_baseSize_c0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method bool QWindow::close()\n", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod (":contentOrientation", "@brief Method Qt::ScreenOrientation QWindow::contentOrientation()\n", true, &_init_f_contentOrientation_c0, &_call_f_contentOrientation_c0);
  methods += new qt_gsi::GenericMethod ("create|qt_create", "@brief Method void QWindow::create()\n", false, &_init_f_create_0, &_call_f_create_0);
  methods += new qt_gsi::GenericMethod (":cursor", "@brief Method QCursor QWindow::cursor()\n", true, &_init_f_cursor_c0, &_call_f_cursor_c0);
  methods += new qt_gsi::GenericMethod ("destroy|qt_destroy", "@brief Method void QWindow::destroy()\n", false, &_init_f_destroy_0, &_call_f_destroy_0);
  methods += new qt_gsi::GenericMethod ("devicePixelRatio", "@brief Method double QWindow::devicePixelRatio()\n", true, &_init_f_devicePixelRatio_c0, &_call_f_devicePixelRatio_c0);
  methods += new qt_gsi::GenericMethod (":filePath", "@brief Method QString QWindow::filePath()\n", true, &_init_f_filePath_c0, &_call_f_filePath_c0);
  methods += new qt_gsi::GenericMethod (":flags", "@brief Method QFlags<Qt::WindowType> QWindow::flags()\n", true, &_init_f_flags_c0, &_call_f_flags_c0);
  methods += new qt_gsi::GenericMethod ("focusObject", "@brief Method QObject *QWindow::focusObject()\n", true, &_init_f_focusObject_c0, &_call_f_focusObject_c0);
  methods += new qt_gsi::GenericMethod (":format", "@brief Method QSurfaceFormat QWindow::format()\nThis is a reimplementation of QSurface::format", true, &_init_f_format_c0, &_call_f_format_c0);
  methods += new qt_gsi::GenericMethod ("frameGeometry", "@brief Method QRect QWindow::frameGeometry()\n", true, &_init_f_frameGeometry_c0, &_call_f_frameGeometry_c0);
  methods += new qt_gsi::GenericMethod ("frameMargins", "@brief Method QMargins QWindow::frameMargins()\n", true, &_init_f_frameMargins_c0, &_call_f_frameMargins_c0);
  methods += new qt_gsi::GenericMethod (":framePosition", "@brief Method QPoint QWindow::framePosition()\n", true, &_init_f_framePosition_c0, &_call_f_framePosition_c0);
  methods += new qt_gsi::GenericMethod (":geometry", "@brief Method QRect QWindow::geometry()\n", true, &_init_f_geometry_c0, &_call_f_geometry_c0);
  methods += new qt_gsi::GenericMethod (":height", "@brief Method int QWindow::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
  methods += new qt_gsi::GenericMethod ("hide", "@brief Method void QWindow::hide()\n", false, &_init_f_hide_0, &_call_f_hide_0);
  methods += new qt_gsi::GenericMethod (":icon", "@brief Method QIcon QWindow::icon()\n", true, &_init_f_icon_c0, &_call_f_icon_c0);
  methods += new qt_gsi::GenericMethod ("isActive?|:active", "@brief Method bool QWindow::isActive()\n", true, &_init_f_isActive_c0, &_call_f_isActive_c0);
  methods += new qt_gsi::GenericMethod ("isAncestorOf?", "@brief Method bool QWindow::isAncestorOf(const QWindow *child, QWindow::AncestorMode mode)\n", true, &_init_f_isAncestorOf_c4407, &_call_f_isAncestorOf_c4407);
  methods += new qt_gsi::GenericMethod ("isExposed?", "@brief Method bool QWindow::isExposed()\n", true, &_init_f_isExposed_c0, &_call_f_isExposed_c0);
  methods += new qt_gsi::GenericMethod ("isModal?", "@brief Method bool QWindow::isModal()\n", true, &_init_f_isModal_c0, &_call_f_isModal_c0);
  methods += new qt_gsi::GenericMethod ("isTopLevel?", "@brief Method bool QWindow::isTopLevel()\n", true, &_init_f_isTopLevel_c0, &_call_f_isTopLevel_c0);
  methods += new qt_gsi::GenericMethod ("isVisible?|:visible", "@brief Method bool QWindow::isVisible()\n", true, &_init_f_isVisible_c0, &_call_f_isVisible_c0);
  methods += new qt_gsi::GenericMethod ("lower", "@brief Method void QWindow::lower()\n", false, &_init_f_lower_0, &_call_f_lower_0);
  methods += new qt_gsi::GenericMethod ("mapFromGlobal", "@brief Method QPoint QWindow::mapFromGlobal(const QPoint &pos)\n", true, &_init_f_mapFromGlobal_c1916, &_call_f_mapFromGlobal_c1916);
  methods += new qt_gsi::GenericMethod ("mapToGlobal", "@brief Method QPoint QWindow::mapToGlobal(const QPoint &pos)\n", true, &_init_f_mapToGlobal_c1916, &_call_f_mapToGlobal_c1916);
  methods += new qt_gsi::GenericMethod (":mask", "@brief Method QRegion QWindow::mask()\n", true, &_init_f_mask_c0, &_call_f_mask_c0);
  methods += new qt_gsi::GenericMethod (":maximumHeight", "@brief Method int QWindow::maximumHeight()\n", true, &_init_f_maximumHeight_c0, &_call_f_maximumHeight_c0);
  methods += new qt_gsi::GenericMethod (":maximumSize", "@brief Method QSize QWindow::maximumSize()\n", true, &_init_f_maximumSize_c0, &_call_f_maximumSize_c0);
  methods += new qt_gsi::GenericMethod (":maximumWidth", "@brief Method int QWindow::maximumWidth()\n", true, &_init_f_maximumWidth_c0, &_call_f_maximumWidth_c0);
  methods += new qt_gsi::GenericMethod (":minimumHeight", "@brief Method int QWindow::minimumHeight()\n", true, &_init_f_minimumHeight_c0, &_call_f_minimumHeight_c0);
  methods += new qt_gsi::GenericMethod (":minimumSize", "@brief Method QSize QWindow::minimumSize()\n", true, &_init_f_minimumSize_c0, &_call_f_minimumSize_c0);
  methods += new qt_gsi::GenericMethod (":minimumWidth", "@brief Method int QWindow::minimumWidth()\n", true, &_init_f_minimumWidth_c0, &_call_f_minimumWidth_c0);
  methods += new qt_gsi::GenericMethod (":modality", "@brief Method Qt::WindowModality QWindow::modality()\n", true, &_init_f_modality_c0, &_call_f_modality_c0);
  methods += new qt_gsi::GenericMethod (":opacity", "@brief Method double QWindow::opacity()\n", true, &_init_f_opacity_c0, &_call_f_opacity_c0);
  methods += new qt_gsi::GenericMethod ("parent", "@brief Method QWindow *QWindow::parent(QWindow::AncestorMode mode)\n", true, &_init_f_parent_c2485, &_call_f_parent_c2485);
  methods += new qt_gsi::GenericMethod (":parent", "@brief Method QWindow *QWindow::parent()\n", true, &_init_f_parent_c0, &_call_f_parent_c0);
  methods += new qt_gsi::GenericMethod (":position", "@brief Method QPoint QWindow::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
  methods += new qt_gsi::GenericMethod ("raise|qt_raise", "@brief Method void QWindow::raise()\n", false, &_init_f_raise_0, &_call_f_raise_0);
  methods += new qt_gsi::GenericMethod ("reportContentOrientationChange", "@brief Method void QWindow::reportContentOrientationChange(Qt::ScreenOrientation orientation)\n", false, &_init_f_reportContentOrientationChange_2521, &_call_f_reportContentOrientationChange_2521);
  methods += new qt_gsi::GenericMethod ("requestActivate", "@brief Method void QWindow::requestActivate()\n", false, &_init_f_requestActivate_0, &_call_f_requestActivate_0);
  methods += new qt_gsi::GenericMethod ("requestUpdate", "@brief Method void QWindow::requestUpdate()\n", false, &_init_f_requestUpdate_0, &_call_f_requestUpdate_0);
  methods += new qt_gsi::GenericMethod ("requestedFormat", "@brief Method QSurfaceFormat QWindow::requestedFormat()\n", true, &_init_f_requestedFormat_c0, &_call_f_requestedFormat_c0);
  methods += new qt_gsi::GenericMethod ("resize", "@brief Method void QWindow::resize(const QSize &newSize)\n", false, &_init_f_resize_1805, &_call_f_resize_1805);
  methods += new qt_gsi::GenericMethod ("resize", "@brief Method void QWindow::resize(int w, int h)\n", false, &_init_f_resize_1426, &_call_f_resize_1426);
  methods += new qt_gsi::GenericMethod (":screen", "@brief Method QScreen *QWindow::screen()\n", true, &_init_f_screen_c0, &_call_f_screen_c0);
  methods += new qt_gsi::GenericMethod ("setBaseSize|baseSize=", "@brief Method void QWindow::setBaseSize(const QSize &size)\n", false, &_init_f_setBaseSize_1805, &_call_f_setBaseSize_1805);
  methods += new qt_gsi::GenericMethod ("setCursor|cursor=", "@brief Method void QWindow::setCursor(const QCursor &)\n", false, &_init_f_setCursor_2032, &_call_f_setCursor_2032);
  methods += new qt_gsi::GenericMethod ("setFilePath|filePath=", "@brief Method void QWindow::setFilePath(const QString &filePath)\n", false, &_init_f_setFilePath_2025, &_call_f_setFilePath_2025);
  methods += new qt_gsi::GenericMethod ("setFlag", "@brief Method void QWindow::setFlag(Qt::WindowType, bool on)\n", false, &_init_f_setFlag_2555, &_call_f_setFlag_2555);
  methods += new qt_gsi::GenericMethod ("setFlags|flags=", "@brief Method void QWindow::setFlags(QFlags<Qt::WindowType> flags)\n", false, &_init_f_setFlags_2495, &_call_f_setFlags_2495);
  methods += new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QWindow::setFormat(const QSurfaceFormat &format)\n", false, &_init_f_setFormat_2724, &_call_f_setFormat_2724);
  methods += new qt_gsi::GenericMethod ("setFramePosition|framePosition=", "@brief Method void QWindow::setFramePosition(const QPoint &point)\n", false, &_init_f_setFramePosition_1916, &_call_f_setFramePosition_1916);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Method void QWindow::setGeometry(int posx, int posy, int w, int h)\n", false, &_init_f_setGeometry_2744, &_call_f_setGeometry_2744);
  methods += new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QWindow::setGeometry(const QRect &rect)\n", false, &_init_f_setGeometry_1792, &_call_f_setGeometry_1792);
  methods += new qt_gsi::GenericMethod ("setHeight|height=", "@brief Method void QWindow::setHeight(int arg)\n", false, &_init_f_setHeight_767, &_call_f_setHeight_767);
  methods += new qt_gsi::GenericMethod ("setIcon|icon=", "@brief Method void QWindow::setIcon(const QIcon &icon)\n", false, &_init_f_setIcon_1787, &_call_f_setIcon_1787);
  methods += new qt_gsi::GenericMethod ("setKeyboardGrabEnabled", "@brief Method bool QWindow::setKeyboardGrabEnabled(bool grab)\n", false, &_init_f_setKeyboardGrabEnabled_864, &_call_f_setKeyboardGrabEnabled_864);
  methods += new qt_gsi::GenericMethod ("setMask|mask=", "@brief Method void QWindow::setMask(const QRegion &region)\n", false, &_init_f_setMask_2006, &_call_f_setMask_2006);
  methods += new qt_gsi::GenericMethod ("setMaximumHeight|maximumHeight=", "@brief Method void QWindow::setMaximumHeight(int h)\n", false, &_init_f_setMaximumHeight_767, &_call_f_setMaximumHeight_767);
  methods += new qt_gsi::GenericMethod ("setMaximumSize|maximumSize=", "@brief Method void QWindow::setMaximumSize(const QSize &size)\n", false, &_init_f_setMaximumSize_1805, &_call_f_setMaximumSize_1805);
  methods += new qt_gsi::GenericMethod ("setMaximumWidth|maximumWidth=", "@brief Method void QWindow::setMaximumWidth(int w)\n", false, &_init_f_setMaximumWidth_767, &_call_f_setMaximumWidth_767);
  methods += new qt_gsi::GenericMethod ("setMinimumHeight|minimumHeight=", "@brief Method void QWindow::setMinimumHeight(int h)\n", false, &_init_f_setMinimumHeight_767, &_call_f_setMinimumHeight_767);
  methods += new qt_gsi::GenericMethod ("setMinimumSize|minimumSize=", "@brief Method void QWindow::setMinimumSize(const QSize &size)\n", false, &_init_f_setMinimumSize_1805, &_call_f_setMinimumSize_1805);
  methods += new qt_gsi::GenericMethod ("setMinimumWidth|minimumWidth=", "@brief Method void QWindow::setMinimumWidth(int w)\n", false, &_init_f_setMinimumWidth_767, &_call_f_setMinimumWidth_767);
  methods += new qt_gsi::GenericMethod ("setModality|modality=", "@brief Method void QWindow::setModality(Qt::WindowModality modality)\n", false, &_init_f_setModality_2216, &_call_f_setModality_2216);
  methods += new qt_gsi::GenericMethod ("setMouseGrabEnabled", "@brief Method bool QWindow::setMouseGrabEnabled(bool grab)\n", false, &_init_f_setMouseGrabEnabled_864, &_call_f_setMouseGrabEnabled_864);
  methods += new qt_gsi::GenericMethod ("setOpacity|opacity=", "@brief Method void QWindow::setOpacity(double level)\n", false, &_init_f_setOpacity_1071, &_call_f_setOpacity_1071);
  methods += new qt_gsi::GenericMethod ("setParent|parent=", "@brief Method void QWindow::setParent(QWindow *parent)\n", false, &_init_f_setParent_1335, &_call_f_setParent_1335);
  methods += new qt_gsi::GenericMethod ("setPosition|position=", "@brief Method void QWindow::setPosition(const QPoint &pt)\n", false, &_init_f_setPosition_1916, &_call_f_setPosition_1916);
  methods += new qt_gsi::GenericMethod ("setPosition", "@brief Method void QWindow::setPosition(int posx, int posy)\n", false, &_init_f_setPosition_1426, &_call_f_setPosition_1426);
  methods += new qt_gsi::GenericMethod ("setScreen|screen=", "@brief Method void QWindow::setScreen(QScreen *screen)\n", false, &_init_f_setScreen_1311, &_call_f_setScreen_1311);
  methods += new qt_gsi::GenericMethod ("setSizeIncrement|sizeIncrement=", "@brief Method void QWindow::setSizeIncrement(const QSize &size)\n", false, &_init_f_setSizeIncrement_1805, &_call_f_setSizeIncrement_1805);
  methods += new qt_gsi::GenericMethod ("setSurfaceType|surfaceType=", "@brief Method void QWindow::setSurfaceType(QSurface::SurfaceType surfaceType)\n", false, &_init_f_setSurfaceType_2477, &_call_f_setSurfaceType_2477);
  methods += new qt_gsi::GenericMethod ("setTitle|title=", "@brief Method void QWindow::setTitle(const QString &)\n", false, &_init_f_setTitle_2025, &_call_f_setTitle_2025);
  methods += new qt_gsi::GenericMethod ("setTransientParent|transientParent=", "@brief Method void QWindow::setTransientParent(QWindow *parent)\n", false, &_init_f_setTransientParent_1335, &_call_f_setTransientParent_1335);
  methods += new qt_gsi::GenericMethod ("setVisibility|visibility=", "@brief Method void QWindow::setVisibility(QWindow::Visibility v)\n", false, &_init_f_setVisibility_2329, &_call_f_setVisibility_2329);
  methods += new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QWindow::setVisible(bool visible)\n", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
  methods += new qt_gsi::GenericMethod ("setWidth|width=", "@brief Method void QWindow::setWidth(int arg)\n", false, &_init_f_setWidth_767, &_call_f_setWidth_767);
  methods += new qt_gsi::GenericMethod ("setWindowState|windowState=", "@brief Method void QWindow::setWindowState(Qt::WindowState state)\n", false, &_init_f_setWindowState_1894, &_call_f_setWindowState_1894);
  methods += new qt_gsi::GenericMethod ("setWindowStates|windowStates=", "@brief Method void QWindow::setWindowStates(QFlags<Qt::WindowState> states)\n", false, &_init_f_setWindowStates_2590, &_call_f_setWindowStates_2590);
  methods += new qt_gsi::GenericMethod ("setX|x=", "@brief Method void QWindow::setX(int arg)\n", false, &_init_f_setX_767, &_call_f_setX_767);
  methods += new qt_gsi::GenericMethod ("setY|y=", "@brief Method void QWindow::setY(int arg)\n", false, &_init_f_setY_767, &_call_f_setY_767);
  methods += new qt_gsi::GenericMethod ("show", "@brief Method void QWindow::show()\n", false, &_init_f_show_0, &_call_f_show_0);
  methods += new qt_gsi::GenericMethod ("showFullScreen", "@brief Method void QWindow::showFullScreen()\n", false, &_init_f_showFullScreen_0, &_call_f_showFullScreen_0);
  methods += new qt_gsi::GenericMethod ("showMaximized", "@brief Method void QWindow::showMaximized()\n", false, &_init_f_showMaximized_0, &_call_f_showMaximized_0);
  methods += new qt_gsi::GenericMethod ("showMinimized", "@brief Method void QWindow::showMinimized()\n", false, &_init_f_showMinimized_0, &_call_f_showMinimized_0);
  methods += new qt_gsi::GenericMethod ("showNormal", "@brief Method void QWindow::showNormal()\n", false, &_init_f_showNormal_0, &_call_f_showNormal_0);
  methods += new qt_gsi::GenericMethod ("size", "@brief Method QSize QWindow::size()\nThis is a reimplementation of QSurface::size", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericMethod (":sizeIncrement", "@brief Method QSize QWindow::sizeIncrement()\n", true, &_init_f_sizeIncrement_c0, &_call_f_sizeIncrement_c0);
  methods += new qt_gsi::GenericMethod (":surfaceType", "@brief Method QSurface::SurfaceType QWindow::surfaceType()\nThis is a reimplementation of QSurface::surfaceType", true, &_init_f_surfaceType_c0, &_call_f_surfaceType_c0);
  methods += new qt_gsi::GenericMethod (":title", "@brief Method QString QWindow::title()\n", true, &_init_f_title_c0, &_call_f_title_c0);
  methods += new qt_gsi::GenericMethod (":transientParent", "@brief Method QWindow *QWindow::transientParent()\n", true, &_init_f_transientParent_c0, &_call_f_transientParent_c0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Method Qt::WindowType QWindow::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += new qt_gsi::GenericMethod ("unsetCursor", "@brief Method void QWindow::unsetCursor()\n", false, &_init_f_unsetCursor_0, &_call_f_unsetCursor_0);
  methods += new qt_gsi::GenericMethod (":visibility", "@brief Method QWindow::Visibility QWindow::visibility()\n", true, &_init_f_visibility_c0, &_call_f_visibility_c0);
  methods += new qt_gsi::GenericMethod (":width", "@brief Method int QWindow::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
  methods += new qt_gsi::GenericMethod ("winId", "@brief Method WId QWindow::winId()\n", true, &_init_f_winId_c0, &_call_f_winId_c0);
  methods += new qt_gsi::GenericMethod (":windowState", "@brief Method Qt::WindowState QWindow::windowState()\n", true, &_init_f_windowState_c0, &_call_f_windowState_c0);
  methods += new qt_gsi::GenericMethod (":windowStates", "@brief Method QFlags<Qt::WindowState> QWindow::windowStates()\n", true, &_init_f_windowStates_c0, &_call_f_windowStates_c0);
  methods += new qt_gsi::GenericMethod (":x", "@brief Method int QWindow::x()\n", true, &_init_f_x_c0, &_call_f_x_c0);
  methods += new qt_gsi::GenericMethod (":y", "@brief Method int QWindow::y()\n", true, &_init_f_y_c0, &_call_f_y_c0);
  methods += gsi::qt_signal ("activeChanged()", "activeChanged", "@brief Signal declaration for QWindow::activeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > ("contentOrientationChanged(Qt::ScreenOrientation)", "contentOrientationChanged", gsi::arg("orientation"), "@brief Signal declaration for QWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QWindow::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("focusObjectChanged(QObject *)", "focusObjectChanged", gsi::arg("object"), "@brief Signal declaration for QWindow::focusObjectChanged(QObject *object)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("heightChanged(int)", "heightChanged", gsi::arg("arg"), "@brief Signal declaration for QWindow::heightChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("maximumHeightChanged(int)", "maximumHeightChanged", gsi::arg("arg"), "@brief Signal declaration for QWindow::maximumHeightChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("maximumWidthChanged(int)", "maximumWidthChanged", gsi::arg("arg"), "@brief Signal declaration for QWindow::maximumWidthChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("minimumHeightChanged(int)", "minimumHeightChanged", gsi::arg("arg"), "@brief Signal declaration for QWindow::minimumHeightChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("minimumWidthChanged(int)", "minimumWidthChanged", gsi::arg("arg"), "@brief Signal declaration for QWindow::minimumWidthChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::WindowModality>::target_type & > ("modalityChanged(Qt::WindowModality)", "modalityChanged", gsi::arg("modality"), "@brief Signal declaration for QWindow::modalityChanged(Qt::WindowModality modality)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QWindow::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("opacityChanged(double)", "opacityChanged", gsi::arg("opacity"), "@brief Signal declaration for QWindow::opacityChanged(double opacity)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QScreen * > ("screenChanged(QScreen *)", "screenChanged", gsi::arg("screen"), "@brief Signal declaration for QWindow::screenChanged(QScreen *screen)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QWindow::Visibility>::target_type & > ("visibilityChanged(QWindow::Visibility)", "visibilityChanged", gsi::arg("visibility"), "@brief Signal declaration for QWindow::visibilityChanged(QWindow::Visibility visibility)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("visibleChanged(bool)", "visibleChanged", gsi::arg("arg"), "@brief Signal declaration for QWindow::visibleChanged(bool arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("widthChanged(int)", "widthChanged", gsi::arg("arg"), "@brief Signal declaration for QWindow::widthChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::WindowState>::target_type & > ("windowStateChanged(Qt::WindowState)", "windowStateChanged", gsi::arg("windowState"), "@brief Signal declaration for QWindow::windowStateChanged(Qt::WindowState windowState)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QWindow::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("xChanged(int)", "xChanged", gsi::arg("arg"), "@brief Signal declaration for QWindow::xChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("yChanged(int)", "yChanged", gsi::arg("arg"), "@brief Signal declaration for QWindow::yChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("fromWinId", "@brief Static method QWindow *QWindow::fromWinId(WId id)\nThis method is static and can be called without an instance.", &_init_f_fromWinId_696, &_call_f_fromWinId_696);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QWindow::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QWindow::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QWindow\nClass QWindow is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QWindow_as_QObject, &_call_f_QWindow_as_QObject);
  methods += new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QWindow\nClass QWindow is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QWindow_as_const_QObject, &_call_f_QWindow_as_const_QObject);
  methods += new qt_gsi::GenericMethod ("asQSurface", "@brief Delivers the base class interface QSurface of QWindow\nClass QWindow is derived from multiple base classes. This method delivers the QSurface base class aspect.", false, &_init_f_QWindow_as_QSurface, &_call_f_QWindow_as_QSurface);
  methods += new qt_gsi::GenericMethod ("asConstQSurface", "@brief Delivers the base class interface QSurface of QWindow\nClass QWindow is derived from multiple base classes. This method delivers the QSurface base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QWindow_as_const_QSurface, &_call_f_QWindow_as_const_QSurface);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QWindow> decl_QWindow (qtdecl_QObject (), "QtGui", "QWindow_Native",
  methods_QWindow (),
  "@hide\n@alias QWindow");

//  Additional base classes

gsi::Class<QSurface> &qtdecl_QSurface ();

gsi::ClassExt<QWindow> base_class_QSurface_in_QWindow (qtdecl_QSurface ());

GSI_QTGUI_PUBLIC gsi::Class<QWindow> &qtdecl_QWindow () { return decl_QWindow; }

}


class QWindow_Adaptor : public QWindow, public qt_gsi::QtObjectBase
{
public:

  virtual ~QWindow_Adaptor();

  //  [adaptor ctor] QWindow::QWindow(QScreen *screen)
  QWindow_Adaptor() : QWindow()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QWindow::QWindow(QScreen *screen)
  QWindow_Adaptor(QScreen *screen) : QWindow(screen)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QWindow::QWindow(QWindow *parent)
  QWindow_Adaptor(QWindow *parent) : QWindow(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QWindow::isSignalConnected(const QMetaMethod &signal)
  bool fp_QWindow_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QWindow::isSignalConnected(signal);
  }

  //  [expose] int QWindow::receivers(const char *signal)
  int fp_QWindow_receivers_c1731 (const char *signal) const {
    return QWindow::receivers(signal);
  }

  //  [expose] QObject *QWindow::sender()
  QObject * fp_QWindow_sender_c0 () const {
    return QWindow::sender();
  }

  //  [expose] int QWindow::senderSignalIndex()
  int fp_QWindow_senderSignalIndex_c0 () const {
    return QWindow::senderSignalIndex();
  }

  //  [adaptor impl] QAccessibleInterface *QWindow::accessibleRoot()
  QAccessibleInterface * cbs_accessibleRoot_c0_0() const
  {
    return QWindow::accessibleRoot();
  }

  virtual QAccessibleInterface * accessibleRoot() const
  {
    if (cb_accessibleRoot_c0_0.can_issue()) {
      return cb_accessibleRoot_c0_0.issue<QWindow_Adaptor, QAccessibleInterface *>(&QWindow_Adaptor::cbs_accessibleRoot_c0_0);
    } else {
      return QWindow::accessibleRoot();
    }
  }

  //  [emitter impl] void QWindow::activeChanged()
  void emitter_QWindow_activeChanged_0()
  {
    emit QWindow::activeChanged();
  }

  //  [emitter impl] void QWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)
  void emitter_QWindow_contentOrientationChanged_2521(Qt::ScreenOrientation orientation)
  {
    emit QWindow::contentOrientationChanged(orientation);
  }

  //  [emitter impl] void QWindow::destroyed(QObject *)
  void emitter_QWindow_destroyed_1302(QObject *arg1)
  {
    emit QWindow::destroyed(arg1);
  }

  //  [adaptor impl] bool QWindow::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QWindow::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QWindow_Adaptor, bool, QObject *, QEvent *>(&QWindow_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QWindow::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] QObject *QWindow::focusObject()
  QObject * cbs_focusObject_c0_0() const
  {
    return QWindow::focusObject();
  }

  virtual QObject * focusObject() const
  {
    if (cb_focusObject_c0_0.can_issue()) {
      return cb_focusObject_c0_0.issue<QWindow_Adaptor, QObject *>(&QWindow_Adaptor::cbs_focusObject_c0_0);
    } else {
      return QWindow::focusObject();
    }
  }

  //  [emitter impl] void QWindow::focusObjectChanged(QObject *object)
  void emitter_QWindow_focusObjectChanged_1302(QObject *object)
  {
    emit QWindow::focusObjectChanged(object);
  }

  //  [adaptor impl] QSurfaceFormat QWindow::format()
  QSurfaceFormat cbs_format_c0_0() const
  {
    return QWindow::format();
  }

  virtual QSurfaceFormat format() const
  {
    if (cb_format_c0_0.can_issue()) {
      return cb_format_c0_0.issue<QWindow_Adaptor, QSurfaceFormat>(&QWindow_Adaptor::cbs_format_c0_0);
    } else {
      return QWindow::format();
    }
  }

  //  [emitter impl] void QWindow::heightChanged(int arg)
  void emitter_QWindow_heightChanged_767(int arg)
  {
    emit QWindow::heightChanged(arg);
  }

  //  [emitter impl] void QWindow::maximumHeightChanged(int arg)
  void emitter_QWindow_maximumHeightChanged_767(int arg)
  {
    emit QWindow::maximumHeightChanged(arg);
  }

  //  [emitter impl] void QWindow::maximumWidthChanged(int arg)
  void emitter_QWindow_maximumWidthChanged_767(int arg)
  {
    emit QWindow::maximumWidthChanged(arg);
  }

  //  [emitter impl] void QWindow::minimumHeightChanged(int arg)
  void emitter_QWindow_minimumHeightChanged_767(int arg)
  {
    emit QWindow::minimumHeightChanged(arg);
  }

  //  [emitter impl] void QWindow::minimumWidthChanged(int arg)
  void emitter_QWindow_minimumWidthChanged_767(int arg)
  {
    emit QWindow::minimumWidthChanged(arg);
  }

  //  [emitter impl] void QWindow::modalityChanged(Qt::WindowModality modality)
  void emitter_QWindow_modalityChanged_2216(Qt::WindowModality modality)
  {
    emit QWindow::modalityChanged(modality);
  }

  //  [emitter impl] void QWindow::objectNameChanged(const QString &objectName)
  void emitter_QWindow_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QWindow::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QWindow::opacityChanged(double opacity)
  void emitter_QWindow_opacityChanged_1071(double opacity)
  {
    emit QWindow::opacityChanged(opacity);
  }

  //  [emitter impl] void QWindow::screenChanged(QScreen *screen)
  void emitter_QWindow_screenChanged_1311(QScreen *screen)
  {
    emit QWindow::screenChanged(screen);
  }

  //  [adaptor impl] QSize QWindow::size()
  QSize cbs_size_c0_0() const
  {
    return QWindow::size();
  }

  virtual QSize size() const
  {
    if (cb_size_c0_0.can_issue()) {
      return cb_size_c0_0.issue<QWindow_Adaptor, QSize>(&QWindow_Adaptor::cbs_size_c0_0);
    } else {
      return QWindow::size();
    }
  }

  //  [adaptor impl] QSurface::SurfaceType QWindow::surfaceType()
  qt_gsi::Converter<QSurface::SurfaceType>::target_type cbs_surfaceType_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QSurface::SurfaceType>(QWindow::surfaceType());
  }

  virtual QSurface::SurfaceType surfaceType() const
  {
    if (cb_surfaceType_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QSurface::SurfaceType>(cb_surfaceType_c0_0.issue<QWindow_Adaptor, qt_gsi::Converter<QSurface::SurfaceType>::target_type>(&QWindow_Adaptor::cbs_surfaceType_c0_0)).cref();
    } else {
      return QWindow::surfaceType();
    }
  }

  //  [emitter impl] void QWindow::visibilityChanged(QWindow::Visibility visibility)
  void emitter_QWindow_visibilityChanged_2329(QWindow::Visibility visibility)
  {
    emit QWindow::visibilityChanged(visibility);
  }

  //  [emitter impl] void QWindow::visibleChanged(bool arg)
  void emitter_QWindow_visibleChanged_864(bool arg)
  {
    emit QWindow::visibleChanged(arg);
  }

  //  [emitter impl] void QWindow::widthChanged(int arg)
  void emitter_QWindow_widthChanged_767(int arg)
  {
    emit QWindow::widthChanged(arg);
  }

  //  [emitter impl] void QWindow::windowStateChanged(Qt::WindowState windowState)
  void emitter_QWindow_windowStateChanged_1894(Qt::WindowState windowState)
  {
    emit QWindow::windowStateChanged(windowState);
  }

  //  [emitter impl] void QWindow::windowTitleChanged(const QString &title)
  void emitter_QWindow_windowTitleChanged_2025(const QString &title)
  {
    emit QWindow::windowTitleChanged(title);
  }

  //  [emitter impl] void QWindow::xChanged(int arg)
  void emitter_QWindow_xChanged_767(int arg)
  {
    emit QWindow::xChanged(arg);
  }

  //  [emitter impl] void QWindow::yChanged(int arg)
  void emitter_QWindow_yChanged_767(int arg)
  {
    emit QWindow::yChanged(arg);
  }

  //  [adaptor impl] void QWindow::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QWindow::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QWindow_Adaptor, QChildEvent *>(&QWindow_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QWindow::childEvent(event);
    }
  }

  //  [adaptor impl] void QWindow::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QWindow::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QWindow_Adaptor, QEvent *>(&QWindow_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QWindow::customEvent(event);
    }
  }

  //  [adaptor impl] void QWindow::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QWindow::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QWindow_Adaptor, const QMetaMethod &>(&QWindow_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QWindow::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QWindow::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QWindow::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QWindow_Adaptor, bool, QEvent *>(&QWindow_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QWindow::event(arg1);
    }
  }

  //  [adaptor impl] void QWindow::exposeEvent(QExposeEvent *)
  void cbs_exposeEvent_1845_0(QExposeEvent *arg1)
  {
    QWindow::exposeEvent(arg1);
  }

  virtual void exposeEvent(QExposeEvent *arg1)
  {
    if (cb_exposeEvent_1845_0.can_issue()) {
      cb_exposeEvent_1845_0.issue<QWindow_Adaptor, QExposeEvent *>(&QWindow_Adaptor::cbs_exposeEvent_1845_0, arg1);
    } else {
      QWindow::exposeEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QWindow::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QWindow_Adaptor, QFocusEvent *>(&QWindow_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QWindow::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QWindow::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QWindow_Adaptor, QFocusEvent *>(&QWindow_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QWindow::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QWindow::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QWindow_Adaptor, QHideEvent *>(&QWindow_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QWindow::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QWindow::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QWindow_Adaptor, QKeyEvent *>(&QWindow_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QWindow::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QWindow::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QWindow_Adaptor, QKeyEvent *>(&QWindow_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QWindow::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QWindow::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QWindow_Adaptor, QMouseEvent *>(&QWindow_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QWindow::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QWindow::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QWindow_Adaptor, QMouseEvent *>(&QWindow_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QWindow::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QWindow::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QWindow_Adaptor, QMouseEvent *>(&QWindow_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QWindow::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QWindow::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QWindow_Adaptor, QMouseEvent *>(&QWindow_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QWindow::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QWindow::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QWindow_Adaptor, QMoveEvent *>(&QWindow_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QWindow::moveEvent(arg1);
    }
  }

  //  [adaptor impl] bool QWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)
  bool cbs_nativeEvent_4678_0(const QByteArray &eventType, void *message, long int *result)
  {
    return QWindow::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, long int *result)
  {
    if (cb_nativeEvent_4678_0.can_issue()) {
      return cb_nativeEvent_4678_0.issue<QWindow_Adaptor, bool, const QByteArray &, void *, long int *>(&QWindow_Adaptor::cbs_nativeEvent_4678_0, eventType, message, result);
    } else {
      return QWindow::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QWindow::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QWindow::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QWindow_Adaptor, QResizeEvent *>(&QWindow_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QWindow::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QWindow::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QWindow_Adaptor, QShowEvent *>(&QWindow_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QWindow::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QWindow::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QWindow_Adaptor, QTabletEvent *>(&QWindow_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QWindow::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QWindow::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QWindow_Adaptor, QTimerEvent *>(&QWindow_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QWindow::timerEvent(event);
    }
  }

  //  [adaptor impl] void QWindow::touchEvent(QTouchEvent *)
  void cbs_touchEvent_1732_0(QTouchEvent *arg1)
  {
    QWindow::touchEvent(arg1);
  }

  virtual void touchEvent(QTouchEvent *arg1)
  {
    if (cb_touchEvent_1732_0.can_issue()) {
      cb_touchEvent_1732_0.issue<QWindow_Adaptor, QTouchEvent *>(&QWindow_Adaptor::cbs_touchEvent_1732_0, arg1);
    } else {
      QWindow::touchEvent(arg1);
    }
  }

  //  [adaptor impl] void QWindow::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QWindow::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QWindow_Adaptor, QWheelEvent *>(&QWindow_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QWindow::wheelEvent(arg1);
    }
  }

  gsi::Callback cb_accessibleRoot_c0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusObject_c0_0;
  gsi::Callback cb_format_c0_0;
  gsi::Callback cb_size_c0_0;
  gsi::Callback cb_surfaceType_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_exposeEvent_1845_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_4678_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_touchEvent_1732_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QWindow_Adaptor::~QWindow_Adaptor() { }

//  Constructor QWindow::QWindow(QScreen *screen) (adaptor class)

static void _init_ctor_QWindow_Adaptor_1311 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("screen", true, "nullptr");
  decl->add_arg<QScreen * > (argspec_0);
  decl->set_return_new<QWindow_Adaptor> ();
}

static void _call_ctor_QWindow_Adaptor_1311 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScreen *arg1 = args ? gsi::arg_reader<QScreen * >() (args, heap) : gsi::arg_maker<QScreen * >() (nullptr, heap);
  ret.write<QWindow_Adaptor *> (new QWindow_Adaptor (arg1));
}


//  Constructor QWindow::QWindow(QWindow *parent) (adaptor class)

static void _init_ctor_QWindow_Adaptor_1335 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWindow * > (argspec_0);
  decl->set_return_new<QWindow_Adaptor> ();
}

static void _call_ctor_QWindow_Adaptor_1335 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWindow *arg1 = gsi::arg_reader<QWindow * >() (args, heap);
  ret.write<QWindow_Adaptor *> (new QWindow_Adaptor (arg1));
}


// QAccessibleInterface *QWindow::accessibleRoot()

static void _init_cbs_accessibleRoot_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_cbs_accessibleRoot_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QWindow_Adaptor *)cls)->cbs_accessibleRoot_c0_0 ());
}

static void _set_callback_cbs_accessibleRoot_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_accessibleRoot_c0_0 = cb;
}


// emitter void QWindow::activeChanged()

static void _init_emitter_activeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_activeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_activeChanged_0 ();
}


// void QWindow::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)

static void _init_emitter_contentOrientationChanged_2521 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_contentOrientationChanged_2521 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_contentOrientationChanged_2521 (arg1);
}


// void QWindow::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QWindow::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_destroyed_1302 (arg1);
}


// void QWindow::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QWindow::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QWindow_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QWindow::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QWindow_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QWindow::exposeEvent(QExposeEvent *)

static void _init_cbs_exposeEvent_1845_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QExposeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_exposeEvent_1845_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QExposeEvent *arg1 = args.read<QExposeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_exposeEvent_1845_0 (arg1);
}

static void _set_callback_cbs_exposeEvent_1845_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_exposeEvent_1845_0 = cb;
}


// void QWindow::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// QObject *QWindow::focusObject()

static void _init_cbs_focusObject_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_cbs_focusObject_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QWindow_Adaptor *)cls)->cbs_focusObject_c0_0 ());
}

static void _set_callback_cbs_focusObject_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_focusObject_c0_0 = cb;
}


// emitter void QWindow::focusObjectChanged(QObject *object)

static void _init_emitter_focusObjectChanged_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_focusObjectChanged_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_focusObjectChanged_1302 (arg1);
}


// void QWindow::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// QSurfaceFormat QWindow::format()

static void _init_cbs_format_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSurfaceFormat > ();
}

static void _call_cbs_format_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSurfaceFormat > ((QSurfaceFormat)((QWindow_Adaptor *)cls)->cbs_format_c0_0 ());
}

static void _set_callback_cbs_format_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_format_c0_0 = cb;
}


// emitter void QWindow::heightChanged(int arg)

static void _init_emitter_heightChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_heightChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_heightChanged_767 (arg1);
}


// void QWindow::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// exposed bool QWindow::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QWindow_Adaptor *)cls)->fp_QWindow_isSignalConnected_c2394 (arg1));
}


// void QWindow::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QWindow::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// emitter void QWindow::maximumHeightChanged(int arg)

static void _init_emitter_maximumHeightChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_maximumHeightChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_maximumHeightChanged_767 (arg1);
}


// emitter void QWindow::maximumWidthChanged(int arg)

static void _init_emitter_maximumWidthChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_maximumWidthChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_maximumWidthChanged_767 (arg1);
}


// emitter void QWindow::minimumHeightChanged(int arg)

static void _init_emitter_minimumHeightChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_minimumHeightChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_minimumHeightChanged_767 (arg1);
}


// emitter void QWindow::minimumWidthChanged(int arg)

static void _init_emitter_minimumWidthChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_minimumWidthChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_minimumWidthChanged_767 (arg1);
}


// emitter void QWindow::modalityChanged(Qt::WindowModality modality)

static void _init_emitter_modalityChanged_2216 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modality");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowModality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_modalityChanged_2216 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowModality>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WindowModality>::target_type & >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_modalityChanged_2216 (arg1);
}


// void QWindow::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QWindow::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QWindow::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QWindow::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QWindow::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)

static void _init_cbs_nativeEvent_4678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<long int * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_4678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  long int *arg3 = args.read<long int * > (heap);
  ret.write<bool > ((bool)((QWindow_Adaptor *)cls)->cbs_nativeEvent_4678_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_4678_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_nativeEvent_4678_0 = cb;
}


// emitter void QWindow::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_objectNameChanged_4567 (arg1);
}


// emitter void QWindow::opacityChanged(double opacity)

static void _init_emitter_opacityChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opacity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_opacityChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_opacityChanged_1071 (arg1);
}


// exposed int QWindow::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QWindow_Adaptor *)cls)->fp_QWindow_receivers_c1731 (arg1));
}


// void QWindow::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// emitter void QWindow::screenChanged(QScreen *screen)

static void _init_emitter_screenChanged_1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("screen");
  decl->add_arg<QScreen * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_screenChanged_1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScreen *arg1 = gsi::arg_reader<QScreen * >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_screenChanged_1311 (arg1);
}


// exposed QObject *QWindow::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QWindow_Adaptor *)cls)->fp_QWindow_sender_c0 ());
}


// exposed int QWindow::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QWindow_Adaptor *)cls)->fp_QWindow_senderSignalIndex_c0 ());
}


// void QWindow::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QWindow::size()

static void _init_cbs_size_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_size_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QWindow_Adaptor *)cls)->cbs_size_c0_0 ());
}

static void _set_callback_cbs_size_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_size_c0_0 = cb;
}


// QSurface::SurfaceType QWindow::surfaceType()

static void _init_cbs_surfaceType_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSurface::SurfaceType>::target_type > ();
}

static void _call_cbs_surfaceType_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSurface::SurfaceType>::target_type > ((qt_gsi::Converter<QSurface::SurfaceType>::target_type)((QWindow_Adaptor *)cls)->cbs_surfaceType_c0_0 ());
}

static void _set_callback_cbs_surfaceType_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_surfaceType_c0_0 = cb;
}


// void QWindow::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QWindow::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QWindow::touchEvent(QTouchEvent *)

static void _init_cbs_touchEvent_1732_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTouchEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_touchEvent_1732_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTouchEvent *arg1 = args.read<QTouchEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_touchEvent_1732_0 (arg1);
}

static void _set_callback_cbs_touchEvent_1732_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_touchEvent_1732_0 = cb;
}


// emitter void QWindow::visibilityChanged(QWindow::Visibility visibility)

static void _init_emitter_visibilityChanged_2329 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visibility");
  decl->add_arg<const qt_gsi::Converter<QWindow::Visibility>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_visibilityChanged_2329 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWindow::Visibility>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QWindow::Visibility>::target_type & >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_visibilityChanged_2329 (arg1);
}


// emitter void QWindow::visibleChanged(bool arg)

static void _init_emitter_visibleChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_visibleChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_visibleChanged_864 (arg1);
}


// void QWindow::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QWindow_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QWindow_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QWindow::widthChanged(int arg)

static void _init_emitter_widthChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_widthChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_widthChanged_767 (arg1);
}


// emitter void QWindow::windowStateChanged(Qt::WindowState windowState)

static void _init_emitter_windowStateChanged_1894 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowState");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowStateChanged_1894 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowState>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::WindowState>::target_type & >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_windowStateChanged_1894 (arg1);
}


// emitter void QWindow::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_windowTitleChanged_2025 (arg1);
}


// emitter void QWindow::xChanged(int arg)

static void _init_emitter_xChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_xChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_xChanged_767 (arg1);
}


// emitter void QWindow::yChanged(int arg)

static void _init_emitter_yChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_yChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QWindow_Adaptor *)cls)->emitter_QWindow_yChanged_767 (arg1);
}


namespace gsi
{

gsi::Class<QWindow> &qtdecl_QWindow ();

static gsi::Methods methods_QWindow_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QWindow::QWindow(QScreen *screen)\nThis method creates an object of class QWindow.", &_init_ctor_QWindow_Adaptor_1311, &_call_ctor_QWindow_Adaptor_1311);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QWindow::QWindow(QWindow *parent)\nThis method creates an object of class QWindow.", &_init_ctor_QWindow_Adaptor_1335, &_call_ctor_QWindow_Adaptor_1335);
  methods += new qt_gsi::GenericMethod ("accessibleRoot", "@brief Virtual method QAccessibleInterface *QWindow::accessibleRoot()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_accessibleRoot_c0_0, &_call_cbs_accessibleRoot_c0_0);
  methods += new qt_gsi::GenericMethod ("accessibleRoot", "@hide", true, &_init_cbs_accessibleRoot_c0_0, &_call_cbs_accessibleRoot_c0_0, &_set_callback_cbs_accessibleRoot_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_activeChanged", "@brief Emitter for signal void QWindow::activeChanged()\nCall this method to emit this signal.", false, &_init_emitter_activeChanged_0, &_call_emitter_activeChanged_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QWindow::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_contentOrientationChanged", "@brief Emitter for signal void QWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)\nCall this method to emit this signal.", false, &_init_emitter_contentOrientationChanged_2521, &_call_emitter_contentOrientationChanged_2521);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QWindow::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QWindow::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QWindow::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QWindow::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QWindow::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*exposeEvent", "@brief Virtual method void QWindow::exposeEvent(QExposeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_exposeEvent_1845_0, &_call_cbs_exposeEvent_1845_0);
  methods += new qt_gsi::GenericMethod ("*exposeEvent", "@hide", false, &_init_cbs_exposeEvent_1845_0, &_call_cbs_exposeEvent_1845_0, &_set_callback_cbs_exposeEvent_1845_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QWindow::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("focusObject", "@brief Virtual method QObject *QWindow::focusObject()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_focusObject_c0_0, &_call_cbs_focusObject_c0_0);
  methods += new qt_gsi::GenericMethod ("focusObject", "@hide", true, &_init_cbs_focusObject_c0_0, &_call_cbs_focusObject_c0_0, &_set_callback_cbs_focusObject_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_focusObjectChanged", "@brief Emitter for signal void QWindow::focusObjectChanged(QObject *object)\nCall this method to emit this signal.", false, &_init_emitter_focusObjectChanged_1302, &_call_emitter_focusObjectChanged_1302);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QWindow::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("format", "@brief Virtual method QSurfaceFormat QWindow::format()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_format_c0_0, &_call_cbs_format_c0_0);
  methods += new qt_gsi::GenericMethod ("format", "@hide", true, &_init_cbs_format_c0_0, &_call_cbs_format_c0_0, &_set_callback_cbs_format_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_heightChanged", "@brief Emitter for signal void QWindow::heightChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_heightChanged_767, &_call_emitter_heightChanged_767);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QWindow::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QWindow::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QWindow::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QWindow::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("emit_maximumHeightChanged", "@brief Emitter for signal void QWindow::maximumHeightChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_maximumHeightChanged_767, &_call_emitter_maximumHeightChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_maximumWidthChanged", "@brief Emitter for signal void QWindow::maximumWidthChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_maximumWidthChanged_767, &_call_emitter_maximumWidthChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_minimumHeightChanged", "@brief Emitter for signal void QWindow::minimumHeightChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_minimumHeightChanged_767, &_call_emitter_minimumHeightChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_minimumWidthChanged", "@brief Emitter for signal void QWindow::minimumWidthChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_minimumWidthChanged_767, &_call_emitter_minimumWidthChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_modalityChanged", "@brief Emitter for signal void QWindow::modalityChanged(Qt::WindowModality modality)\nCall this method to emit this signal.", false, &_init_emitter_modalityChanged_2216, &_call_emitter_modalityChanged_2216);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QWindow::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QWindow::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QWindow::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QWindow::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QWindow::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0, &_set_callback_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QWindow::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_opacityChanged", "@brief Emitter for signal void QWindow::opacityChanged(double opacity)\nCall this method to emit this signal.", false, &_init_emitter_opacityChanged_1071, &_call_emitter_opacityChanged_1071);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QWindow::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QWindow::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("emit_screenChanged", "@brief Emitter for signal void QWindow::screenChanged(QScreen *screen)\nCall this method to emit this signal.", false, &_init_emitter_screenChanged_1311, &_call_emitter_screenChanged_1311);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QWindow::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QWindow::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QWindow::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("size", "@brief Virtual method QSize QWindow::size()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_size_c0_0, &_call_cbs_size_c0_0);
  methods += new qt_gsi::GenericMethod ("size", "@hide", true, &_init_cbs_size_c0_0, &_call_cbs_size_c0_0, &_set_callback_cbs_size_c0_0);
  methods += new qt_gsi::GenericMethod ("surfaceType", "@brief Virtual method QSurface::SurfaceType QWindow::surfaceType()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_surfaceType_c0_0, &_call_cbs_surfaceType_c0_0);
  methods += new qt_gsi::GenericMethod ("surfaceType", "@hide", true, &_init_cbs_surfaceType_c0_0, &_call_cbs_surfaceType_c0_0, &_set_callback_cbs_surfaceType_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QWindow::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QWindow::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*touchEvent", "@brief Virtual method void QWindow::touchEvent(QTouchEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_touchEvent_1732_0, &_call_cbs_touchEvent_1732_0);
  methods += new qt_gsi::GenericMethod ("*touchEvent", "@hide", false, &_init_cbs_touchEvent_1732_0, &_call_cbs_touchEvent_1732_0, &_set_callback_cbs_touchEvent_1732_0);
  methods += new qt_gsi::GenericMethod ("emit_visibilityChanged", "@brief Emitter for signal void QWindow::visibilityChanged(QWindow::Visibility visibility)\nCall this method to emit this signal.", false, &_init_emitter_visibilityChanged_2329, &_call_emitter_visibilityChanged_2329);
  methods += new qt_gsi::GenericMethod ("emit_visibleChanged", "@brief Emitter for signal void QWindow::visibleChanged(bool arg)\nCall this method to emit this signal.", false, &_init_emitter_visibleChanged_864, &_call_emitter_visibleChanged_864);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QWindow::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_widthChanged", "@brief Emitter for signal void QWindow::widthChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_widthChanged_767, &_call_emitter_widthChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_windowStateChanged", "@brief Emitter for signal void QWindow::windowStateChanged(Qt::WindowState windowState)\nCall this method to emit this signal.", false, &_init_emitter_windowStateChanged_1894, &_call_emitter_windowStateChanged_1894);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QWindow::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_xChanged", "@brief Emitter for signal void QWindow::xChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_xChanged_767, &_call_emitter_xChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_yChanged", "@brief Emitter for signal void QWindow::yChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_yChanged_767, &_call_emitter_yChanged_767);
  return methods;
}

gsi::Class<QWindow_Adaptor> decl_QWindow_Adaptor (qtdecl_QWindow (), "QtGui", "QWindow",
  methods_QWindow_Adaptor (),
  "@qt\n@brief Binding of QWindow");

}


//  Implementation of the enum wrapper class for QWindow::AncestorMode
namespace qt_gsi
{

static gsi::Enum<QWindow::AncestorMode> decl_QWindow_AncestorMode_Enum ("QtGui", "QWindow_AncestorMode",
    gsi::enum_const ("ExcludeTransients", QWindow::ExcludeTransients, "@brief Enum constant QWindow::ExcludeTransients") +
    gsi::enum_const ("IncludeTransients", QWindow::IncludeTransients, "@brief Enum constant QWindow::IncludeTransients"),
  "@qt\n@brief This class represents the QWindow::AncestorMode enum");

static gsi::QFlagsClass<QWindow::AncestorMode > decl_QWindow_AncestorMode_Enums ("QtGui", "QWindow_QFlags_AncestorMode",
  "@qt\n@brief This class represents the QFlags<QWindow::AncestorMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QWindow> inject_QWindow_AncestorMode_Enum_in_parent (decl_QWindow_AncestorMode_Enum.defs ());
static gsi::ClassExt<QWindow> decl_QWindow_AncestorMode_Enum_as_child (decl_QWindow_AncestorMode_Enum, "AncestorMode");
static gsi::ClassExt<QWindow> decl_QWindow_AncestorMode_Enums_as_child (decl_QWindow_AncestorMode_Enums, "QFlags_AncestorMode");

}


//  Implementation of the enum wrapper class for QWindow::Visibility
namespace qt_gsi
{

static gsi::Enum<QWindow::Visibility> decl_QWindow_Visibility_Enum ("QtGui", "QWindow_Visibility",
    gsi::enum_const ("Hidden", QWindow::Hidden, "@brief Enum constant QWindow::Hidden") +
    gsi::enum_const ("AutomaticVisibility", QWindow::AutomaticVisibility, "@brief Enum constant QWindow::AutomaticVisibility") +
    gsi::enum_const ("Windowed", QWindow::Windowed, "@brief Enum constant QWindow::Windowed") +
    gsi::enum_const ("Minimized", QWindow::Minimized, "@brief Enum constant QWindow::Minimized") +
    gsi::enum_const ("Maximized", QWindow::Maximized, "@brief Enum constant QWindow::Maximized") +
    gsi::enum_const ("FullScreen", QWindow::FullScreen, "@brief Enum constant QWindow::FullScreen"),
  "@qt\n@brief This class represents the QWindow::Visibility enum");

static gsi::QFlagsClass<QWindow::Visibility > decl_QWindow_Visibility_Enums ("QtGui", "QWindow_QFlags_Visibility",
  "@qt\n@brief This class represents the QFlags<QWindow::Visibility> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QWindow> inject_QWindow_Visibility_Enum_in_parent (decl_QWindow_Visibility_Enum.defs ());
static gsi::ClassExt<QWindow> decl_QWindow_Visibility_Enum_as_child (decl_QWindow_Visibility_Enum, "Visibility");
static gsi::ClassExt<QWindow> decl_QWindow_Visibility_Enums_as_child (decl_QWindow_Visibility_Enums, "QFlags_Visibility");

}

