// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddAssociation = "AddAssociation"

// AddAssociationRequest generates a "aws/request.Request" representing the
// client's request for the AddAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddAssociation for more information on using the AddAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddAssociationRequest method.
//    req, resp := client.AddAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddAssociation
func (c *SageMaker) AddAssociationRequest(input *AddAssociationInput) (req *request.Request, output *AddAssociationOutput) {
	op := &request.Operation{
		Name:       opAddAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddAssociationInput{}
	}

	output = &AddAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddAssociation API operation for Amazon SageMaker Service.
//
// Creates an association between the source and the destination. A source can
// be associated with multiple destinations, and a destination can be associated
// with multiple sources. An association is a lineage tracking entity. For more
// information, see Amazon SageMaker ML Lineage Tracking (https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation AddAssociation for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddAssociation
func (c *SageMaker) AddAssociation(input *AddAssociationInput) (*AddAssociationOutput, error) {
	req, out := c.AddAssociationRequest(input)
	return out, req.Send()
}

// AddAssociationWithContext is the same as AddAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See AddAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) AddAssociationWithContext(ctx aws.Context, input *AddAssociationInput, opts ...request.Option) (*AddAssociationOutput, error) {
	req, out := c.AddAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags
func (c *SageMaker) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddTags API operation for Amazon SageMaker Service.
//
// Adds or overwrites one or more tags for the specified Amazon SageMaker resource.
// You can add tags to notebook instances, training jobs, hyperparameter tuning
// jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations,
// and endpoints.
//
// Each tag consists of a key and an optional value. Tag keys must be unique
// per resource. For more information about tags, see For more information,
// see AWS Tagging Strategies (https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
//
// Tags that you add to a hyperparameter tuning job by calling this API are
// also added to any training jobs that the hyperparameter tuning job launches
// after you call this API, but not to training jobs that the hyperparameter
// tuning job launched before you called this API. To make sure that the tags
// associated with a hyperparameter tuning job are also added to all training
// jobs that the hyperparameter tuning job launches, add the tags when you first
// create the tuning job by specifying them in the Tags parameter of CreateHyperParameterTuningJob
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation AddTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags
func (c *SageMaker) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTrialComponent = "AssociateTrialComponent"

// AssociateTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTrialComponent for more information on using the AssociateTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateTrialComponentRequest method.
//    req, resp := client.AssociateTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AssociateTrialComponent
func (c *SageMaker) AssociateTrialComponentRequest(input *AssociateTrialComponentInput) (req *request.Request, output *AssociateTrialComponentOutput) {
	op := &request.Operation{
		Name:       opAssociateTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateTrialComponentInput{}
	}

	output = &AssociateTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTrialComponent API operation for Amazon SageMaker Service.
//
// Associates a trial component with a trial. A trial component can be associated
// with multiple trials. To disassociate a trial component from a trial, call
// the DisassociateTrialComponent API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation AssociateTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AssociateTrialComponent
func (c *SageMaker) AssociateTrialComponent(input *AssociateTrialComponentInput) (*AssociateTrialComponentOutput, error) {
	req, out := c.AssociateTrialComponentRequest(input)
	return out, req.Send()
}

// AssociateTrialComponentWithContext is the same as AssociateTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) AssociateTrialComponentWithContext(ctx aws.Context, input *AssociateTrialComponentInput, opts ...request.Option) (*AssociateTrialComponentOutput, error) {
	req, out := c.AssociateTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAction = "CreateAction"

// CreateActionRequest generates a "aws/request.Request" representing the
// client's request for the CreateAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAction for more information on using the CreateAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateActionRequest method.
//    req, resp := client.CreateActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAction
func (c *SageMaker) CreateActionRequest(input *CreateActionInput) (req *request.Request, output *CreateActionOutput) {
	op := &request.Operation{
		Name:       opCreateAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateActionInput{}
	}

	output = &CreateActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAction API operation for Amazon SageMaker Service.
//
// Creates an action. An action is a lineage tracking entity that represents
// an action or activity. For example, a model deployment or an HPO job. Generally,
// an action involves at least one input or output artifact. For more information,
// see Amazon SageMaker ML Lineage Tracking (https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateAction for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAction
func (c *SageMaker) CreateAction(input *CreateActionInput) (*CreateActionOutput, error) {
	req, out := c.CreateActionRequest(input)
	return out, req.Send()
}

// CreateActionWithContext is the same as CreateAction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateActionWithContext(ctx aws.Context, input *CreateActionInput, opts ...request.Option) (*CreateActionOutput, error) {
	req, out := c.CreateActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAlgorithm = "CreateAlgorithm"

// CreateAlgorithmRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlgorithm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlgorithm for more information on using the CreateAlgorithm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAlgorithmRequest method.
//    req, resp := client.CreateAlgorithmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm
func (c *SageMaker) CreateAlgorithmRequest(input *CreateAlgorithmInput) (req *request.Request, output *CreateAlgorithmOutput) {
	op := &request.Operation{
		Name:       opCreateAlgorithm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAlgorithmInput{}
	}

	output = &CreateAlgorithmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlgorithm API operation for Amazon SageMaker Service.
//
// Create a machine learning algorithm that you can use in Amazon SageMaker
// and list in the AWS Marketplace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateAlgorithm for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm
func (c *SageMaker) CreateAlgorithm(input *CreateAlgorithmInput) (*CreateAlgorithmOutput, error) {
	req, out := c.CreateAlgorithmRequest(input)
	return out, req.Send()
}

// CreateAlgorithmWithContext is the same as CreateAlgorithm with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlgorithm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateAlgorithmWithContext(ctx aws.Context, input *CreateAlgorithmInput, opts ...request.Option) (*CreateAlgorithmOutput, error) {
	req, out := c.CreateAlgorithmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApp = "CreateApp"

// CreateAppRequest generates a "aws/request.Request" representing the
// client's request for the CreateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApp for more information on using the CreateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppRequest method.
//    req, resp := client.CreateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateApp
func (c *SageMaker) CreateAppRequest(input *CreateAppInput) (req *request.Request, output *CreateAppOutput) {
	op := &request.Operation{
		Name:       opCreateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAppInput{}
	}

	output = &CreateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApp API operation for Amazon SageMaker Service.
//
// Creates a running App for the specified UserProfile. Supported Apps are JupyterServer
// and KernelGateway. This operation is automatically invoked by Amazon SageMaker
// Studio upon access to the associated Domain, and when new kernel configurations
// are selected by the user. A user may have multiple Apps active simultaneously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateApp for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateApp
func (c *SageMaker) CreateApp(input *CreateAppInput) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	return out, req.Send()
}

// CreateAppWithContext is the same as CreateApp with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateAppWithContext(ctx aws.Context, input *CreateAppInput, opts ...request.Option) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAppImageConfig = "CreateAppImageConfig"

// CreateAppImageConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateAppImageConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAppImageConfig for more information on using the CreateAppImageConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppImageConfigRequest method.
//    req, resp := client.CreateAppImageConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAppImageConfig
func (c *SageMaker) CreateAppImageConfigRequest(input *CreateAppImageConfigInput) (req *request.Request, output *CreateAppImageConfigOutput) {
	op := &request.Operation{
		Name:       opCreateAppImageConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAppImageConfigInput{}
	}

	output = &CreateAppImageConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAppImageConfig API operation for Amazon SageMaker Service.
//
// Creates a configuration for running a SageMaker image as a KernelGateway
// app. The configuration specifies the Amazon Elastic File System (EFS) storage
// volume on the image, and a list of the kernels in the image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateAppImageConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAppImageConfig
func (c *SageMaker) CreateAppImageConfig(input *CreateAppImageConfigInput) (*CreateAppImageConfigOutput, error) {
	req, out := c.CreateAppImageConfigRequest(input)
	return out, req.Send()
}

// CreateAppImageConfigWithContext is the same as CreateAppImageConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAppImageConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateAppImageConfigWithContext(ctx aws.Context, input *CreateAppImageConfigInput, opts ...request.Option) (*CreateAppImageConfigOutput, error) {
	req, out := c.CreateAppImageConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateArtifact = "CreateArtifact"

// CreateArtifactRequest generates a "aws/request.Request" representing the
// client's request for the CreateArtifact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateArtifact for more information on using the CreateArtifact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateArtifactRequest method.
//    req, resp := client.CreateArtifactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateArtifact
func (c *SageMaker) CreateArtifactRequest(input *CreateArtifactInput) (req *request.Request, output *CreateArtifactOutput) {
	op := &request.Operation{
		Name:       opCreateArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateArtifactInput{}
	}

	output = &CreateArtifactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateArtifact API operation for Amazon SageMaker Service.
//
// Creates an artifact. An artifact is a lineage tracking entity that represents
// a URI addressable object or data. Some examples are the S3 URI of a dataset
// and the ECR registry path of an image. For more information, see Amazon SageMaker
// ML Lineage Tracking (https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateArtifact for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateArtifact
func (c *SageMaker) CreateArtifact(input *CreateArtifactInput) (*CreateArtifactOutput, error) {
	req, out := c.CreateArtifactRequest(input)
	return out, req.Send()
}

// CreateArtifactWithContext is the same as CreateArtifact with the addition of
// the ability to pass a context and additional request options.
//
// See CreateArtifact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateArtifactWithContext(ctx aws.Context, input *CreateArtifactInput, opts ...request.Option) (*CreateArtifactOutput, error) {
	req, out := c.CreateArtifactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAutoMLJob = "CreateAutoMLJob"

// CreateAutoMLJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateAutoMLJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAutoMLJob for more information on using the CreateAutoMLJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAutoMLJobRequest method.
//    req, resp := client.CreateAutoMLJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob
func (c *SageMaker) CreateAutoMLJobRequest(input *CreateAutoMLJobInput) (req *request.Request, output *CreateAutoMLJobOutput) {
	op := &request.Operation{
		Name:       opCreateAutoMLJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAutoMLJobInput{}
	}

	output = &CreateAutoMLJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAutoMLJob API operation for Amazon SageMaker Service.
//
// Creates an Autopilot job.
//
// Find the best performing model after you run an Autopilot job by calling
// . Deploy that model by following the steps described in Step 6.1: Deploy
// the Model to Amazon SageMaker Hosting Services (https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html).
//
// For information about how to use Autopilot, see Automate Model Development
// with Amazon SageMaker Autopilot (https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateAutoMLJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob
func (c *SageMaker) CreateAutoMLJob(input *CreateAutoMLJobInput) (*CreateAutoMLJobOutput, error) {
	req, out := c.CreateAutoMLJobRequest(input)
	return out, req.Send()
}

// CreateAutoMLJobWithContext is the same as CreateAutoMLJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAutoMLJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateAutoMLJobWithContext(ctx aws.Context, input *CreateAutoMLJobInput, opts ...request.Option) (*CreateAutoMLJobOutput, error) {
	req, out := c.CreateAutoMLJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCodeRepository = "CreateCodeRepository"

// CreateCodeRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateCodeRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCodeRepository for more information on using the CreateCodeRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCodeRepositoryRequest method.
//    req, resp := client.CreateCodeRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository
func (c *SageMaker) CreateCodeRepositoryRequest(input *CreateCodeRepositoryInput) (req *request.Request, output *CreateCodeRepositoryOutput) {
	op := &request.Operation{
		Name:       opCreateCodeRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCodeRepositoryInput{}
	}

	output = &CreateCodeRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCodeRepository API operation for Amazon SageMaker Service.
//
// Creates a Git repository as a resource in your Amazon SageMaker account.
// You can associate the repository with notebook instances so that you can
// use Git source control for the notebooks you create. The Git repository is
// a resource in your Amazon SageMaker account, so it can be associated with
// more than one notebook instance, and it persists independently from the lifecycle
// of any notebook instances it is associated with.
//
// The repository can be hosted either in AWS CodeCommit (https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
// or in any other Git repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateCodeRepository for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository
func (c *SageMaker) CreateCodeRepository(input *CreateCodeRepositoryInput) (*CreateCodeRepositoryOutput, error) {
	req, out := c.CreateCodeRepositoryRequest(input)
	return out, req.Send()
}

// CreateCodeRepositoryWithContext is the same as CreateCodeRepository with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCodeRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateCodeRepositoryWithContext(ctx aws.Context, input *CreateCodeRepositoryInput, opts ...request.Option) (*CreateCodeRepositoryOutput, error) {
	req, out := c.CreateCodeRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCompilationJob = "CreateCompilationJob"

// CreateCompilationJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateCompilationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCompilationJob for more information on using the CreateCompilationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCompilationJobRequest method.
//    req, resp := client.CreateCompilationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob
func (c *SageMaker) CreateCompilationJobRequest(input *CreateCompilationJobInput) (req *request.Request, output *CreateCompilationJobOutput) {
	op := &request.Operation{
		Name:       opCreateCompilationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCompilationJobInput{}
	}

	output = &CreateCompilationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCompilationJob API operation for Amazon SageMaker Service.
//
// Starts a model compilation job. After the model has been compiled, Amazon
// SageMaker saves the resulting model artifacts to an Amazon Simple Storage
// Service (Amazon S3) bucket that you specify.
//
// If you choose to host your model using Amazon SageMaker hosting services,
// you can use the resulting model artifacts as part of the model. You can also
// use the artifacts with AWS IoT Greengrass. In that case, deploy them as an
// ML resource.
//
// In the request body, you provide the following:
//
//    * A name for the compilation job
//
//    * Information about the input model artifacts
//
//    * The output location for the compiled model and the device (target) that
//    the model runs on
//
//    * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker
//    assumes to perform the model compilation job.
//
// You can also provide a Tag to track the model compilation job's resource
// use and costs. The response body contains the CompilationJobArn for the compiled
// job.
//
// To stop a model compilation job, use StopCompilationJob. To get information
// about a particular model compilation job, use DescribeCompilationJob. To
// get information about multiple model compilation jobs, use ListCompilationJobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateCompilationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob
func (c *SageMaker) CreateCompilationJob(input *CreateCompilationJobInput) (*CreateCompilationJobOutput, error) {
	req, out := c.CreateCompilationJobRequest(input)
	return out, req.Send()
}

// CreateCompilationJobWithContext is the same as CreateCompilationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCompilationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateCompilationJobWithContext(ctx aws.Context, input *CreateCompilationJobInput, opts ...request.Option) (*CreateCompilationJobOutput, error) {
	req, out := c.CreateCompilationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContext = "CreateContext"

// CreateContextRequest generates a "aws/request.Request" representing the
// client's request for the CreateContext operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContext for more information on using the CreateContext
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateContextRequest method.
//    req, resp := client.CreateContextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateContext
func (c *SageMaker) CreateContextRequest(input *CreateContextInput) (req *request.Request, output *CreateContextOutput) {
	op := &request.Operation{
		Name:       opCreateContext,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateContextInput{}
	}

	output = &CreateContextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContext API operation for Amazon SageMaker Service.
//
// Creates a context. A context is a lineage tracking entity that represents
// a logical grouping of other tracking or experiment entities. Some examples
// are an endpoint and a model package. For more information, see Amazon SageMaker
// ML Lineage Tracking (https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateContext for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateContext
func (c *SageMaker) CreateContext(input *CreateContextInput) (*CreateContextOutput, error) {
	req, out := c.CreateContextRequest(input)
	return out, req.Send()
}

// CreateContextWithContext is the same as CreateContext with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContext for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateContextWithContext(ctx aws.Context, input *CreateContextInput, opts ...request.Option) (*CreateContextOutput, error) {
	req, out := c.CreateContextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataQualityJobDefinition = "CreateDataQualityJobDefinition"

// CreateDataQualityJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataQualityJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataQualityJobDefinition for more information on using the CreateDataQualityJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataQualityJobDefinitionRequest method.
//    req, resp := client.CreateDataQualityJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDataQualityJobDefinition
func (c *SageMaker) CreateDataQualityJobDefinitionRequest(input *CreateDataQualityJobDefinitionInput) (req *request.Request, output *CreateDataQualityJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateDataQualityJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataQualityJobDefinitionInput{}
	}

	output = &CreateDataQualityJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataQualityJobDefinition API operation for Amazon SageMaker Service.
//
// Creates a definition for a job that monitors data quality and drift. For
// information about model monitor, see Amazon SageMaker Model Monitor (https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateDataQualityJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDataQualityJobDefinition
func (c *SageMaker) CreateDataQualityJobDefinition(input *CreateDataQualityJobDefinitionInput) (*CreateDataQualityJobDefinitionOutput, error) {
	req, out := c.CreateDataQualityJobDefinitionRequest(input)
	return out, req.Send()
}

// CreateDataQualityJobDefinitionWithContext is the same as CreateDataQualityJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataQualityJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateDataQualityJobDefinitionWithContext(ctx aws.Context, input *CreateDataQualityJobDefinitionInput, opts ...request.Option) (*CreateDataQualityJobDefinitionOutput, error) {
	req, out := c.CreateDataQualityJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeviceFleet = "CreateDeviceFleet"

// CreateDeviceFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeviceFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeviceFleet for more information on using the CreateDeviceFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeviceFleetRequest method.
//    req, resp := client.CreateDeviceFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDeviceFleet
func (c *SageMaker) CreateDeviceFleetRequest(input *CreateDeviceFleetInput) (req *request.Request, output *CreateDeviceFleetOutput) {
	op := &request.Operation{
		Name:       opCreateDeviceFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeviceFleetInput{}
	}

	output = &CreateDeviceFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDeviceFleet API operation for Amazon SageMaker Service.
//
// Creates a device fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateDeviceFleet for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDeviceFleet
func (c *SageMaker) CreateDeviceFleet(input *CreateDeviceFleetInput) (*CreateDeviceFleetOutput, error) {
	req, out := c.CreateDeviceFleetRequest(input)
	return out, req.Send()
}

// CreateDeviceFleetWithContext is the same as CreateDeviceFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeviceFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateDeviceFleetWithContext(ctx aws.Context, input *CreateDeviceFleetInput, opts ...request.Option) (*CreateDeviceFleetOutput, error) {
	req, out := c.CreateDeviceFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainRequest method.
//    req, resp := client.CreateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain
func (c *SageMaker) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon SageMaker Service.
//
// Creates a Domain used by Amazon SageMaker Studio. A domain consists of an
// associated Amazon Elastic File System (EFS) volume, a list of authorized
// users, and a variety of security, application, policy, and Amazon Virtual
// Private Cloud (VPC) configurations. An AWS account is limited to one domain
// per region. Users within a domain can share notebook files and other artifacts
// with each other.
//
// EFS storage
//
// When a domain is created, an EFS volume is created for use by all of the
// users within the domain. Each user receives a private home directory within
// the EFS volume for notebooks, Git repositories, and data files.
//
// SageMaker uses the AWS Key Management Service (AWS KMS) to encrypt the EFS
// volume attached to the domain with an AWS managed customer master key (CMK)
// by default. For more control, you can specify a customer managed CMK. For
// more information, see Protect Data at Rest Using Encryption (https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html).
//
// VPC configuration
//
// All SageMaker Studio traffic between the domain and the EFS volume is through
// the specified VPC and subnets. For other Studio traffic, you can specify
// the AppNetworkAccessType parameter. AppNetworkAccessType corresponds to the
// network access type that you choose when you onboard to Studio. The following
// options are available:
//
//    * PublicInternetOnly - Non-EFS traffic goes through a VPC managed by Amazon
//    SageMaker, which allows internet access. This is the default value.
//
//    * VpcOnly - All Studio traffic is through the specified VPC and subnets.
//    Internet access is disabled by default. To allow internet access, you
//    must specify a NAT gateway. When internet access is disabled, you won't
//    be able to run a Studio notebook or to train or host models unless your
//    VPC has an interface endpoint to the SageMaker API and runtime or a NAT
//    gateway and your security groups allow outbound connections.
//
// For more information, see Connect SageMaker Studio Notebooks to Resources
// in a VPC (https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateDomain for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain
func (c *SageMaker) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEdgePackagingJob = "CreateEdgePackagingJob"

// CreateEdgePackagingJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateEdgePackagingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEdgePackagingJob for more information on using the CreateEdgePackagingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEdgePackagingJobRequest method.
//    req, resp := client.CreateEdgePackagingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgePackagingJob
func (c *SageMaker) CreateEdgePackagingJobRequest(input *CreateEdgePackagingJobInput) (req *request.Request, output *CreateEdgePackagingJobOutput) {
	op := &request.Operation{
		Name:       opCreateEdgePackagingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEdgePackagingJobInput{}
	}

	output = &CreateEdgePackagingJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateEdgePackagingJob API operation for Amazon SageMaker Service.
//
// Starts a SageMaker Edge Manager model packaging job. Edge Manager will use
// the model artifacts from the Amazon Simple Storage Service bucket that you
// specify. After the model has been packaged, Amazon SageMaker saves the resulting
// artifacts to an S3 bucket that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateEdgePackagingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgePackagingJob
func (c *SageMaker) CreateEdgePackagingJob(input *CreateEdgePackagingJobInput) (*CreateEdgePackagingJobOutput, error) {
	req, out := c.CreateEdgePackagingJobRequest(input)
	return out, req.Send()
}

// CreateEdgePackagingJobWithContext is the same as CreateEdgePackagingJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEdgePackagingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateEdgePackagingJobWithContext(ctx aws.Context, input *CreateEdgePackagingJobInput, opts ...request.Option) (*CreateEdgePackagingJobOutput, error) {
	req, out := c.CreateEdgePackagingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEndpointRequest method.
//    req, resp := client.CreateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint
func (c *SageMaker) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpoint API operation for Amazon SageMaker Service.
//
// Creates an endpoint using the endpoint configuration specified in the request.
// Amazon SageMaker uses the endpoint to provision resources and deploy models.
// You create the endpoint configuration with the CreateEndpointConfig API.
//
// Use this API to deploy models using Amazon SageMaker hosting services.
//
// For an example that calls this method when deploying a model to Amazon SageMaker
// hosting services, see Deploy the Model to Amazon SageMaker Hosting Services
// (AWS SDK for Python (Boto 3)). (https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
//
// You must not delete an EndpointConfig that is in use by an endpoint that
// is live or while the UpdateEndpoint or CreateEndpoint operations are being
// performed on the endpoint. To update an endpoint, you must create a new EndpointConfig.
//
// The endpoint name must be unique within an AWS Region in your AWS account.
//
// When it receives the request, Amazon SageMaker creates the endpoint, launches
// the resources (ML compute instances), and deploys the model(s) on them.
//
// When you call CreateEndpoint, a load call is made to DynamoDB to verify that
// your endpoint configuration exists. When you read data from a DynamoDB table
// supporting Eventually Consistent Reads (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html),
// the response might not reflect the results of a recently completed write
// operation. The response might include some stale data. If the dependent entities
// are not yet in DynamoDB, this causes a validation error. If you repeat your
// read request after a short time, the response should return the latest data.
// So retry logic is recommended to handle these possible issues. We also recommend
// that customers call DescribeEndpointConfig before calling CreateEndpoint
// to minimize the potential impact of a DynamoDB eventually consistent read.
//
// When Amazon SageMaker receives the request, it sets the endpoint status to
// Creating. After it creates the endpoint, it sets the status to InService.
// Amazon SageMaker can then process incoming requests for inferences. To check
// the status of an endpoint, use the DescribeEndpoint API.
//
// If any of the models hosted at this endpoint get model data from an Amazon
// S3 location, Amazon SageMaker uses AWS Security Token Service to download
// model artifacts from the S3 path you provided. AWS STS is activated in your
// IAM user account by default. If you previously deactivated AWS STS for a
// region, you need to reactivate AWS STS for that region. For more information,
// see Activating and Deactivating AWS STS in an AWS Region (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
// in the AWS Identity and Access Management User Guide.
//
// To add the IAM role policies for using this API operation, go to the IAM
// console (https://console.aws.amazon.com/iam/), and choose Roles in the left
// navigation pane. Search the IAM role that you want to grant access to use
// the CreateEndpoint and CreateEndpointConfig API operations, add the following
// policies to the role.
//
//    * Option 1: For a full Amazon SageMaker access, search and attach the
//    AmazonSageMakerFullAccess policy.
//
//    * Option 2: For granting a limited access to an IAM role, paste the following
//    Action elements manually into the JSON file of the IAM role: "Action":
//    ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"] "Resource":
//    [ "arn:aws:sagemaker:region:account-id:endpoint/endpointName" "arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"
//    ] For more information, see Amazon SageMaker API Permissions: Actions,
//    Permissions, and Resources Reference (https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint
func (c *SageMaker) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateEndpointWithContext(ctx aws.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpointConfig = "CreateEndpointConfig"

// CreateEndpointConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpointConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpointConfig for more information on using the CreateEndpointConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEndpointConfigRequest method.
//    req, resp := client.CreateEndpointConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig
func (c *SageMaker) CreateEndpointConfigRequest(input *CreateEndpointConfigInput) (req *request.Request, output *CreateEndpointConfigOutput) {
	op := &request.Operation{
		Name:       opCreateEndpointConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointConfigInput{}
	}

	output = &CreateEndpointConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpointConfig API operation for Amazon SageMaker Service.
//
// Creates an endpoint configuration that Amazon SageMaker hosting services
// uses to deploy models. In the configuration, you identify one or more models,
// created using the CreateModel API, to deploy and the resources that you want
// Amazon SageMaker to provision. Then you call the CreateEndpoint API.
//
// Use this API if you want to use Amazon SageMaker hosting services to deploy
// models into production.
//
// In the request, you define a ProductionVariant, for each model that you want
// to deploy. Each ProductionVariant parameter also describes the resources
// that you want Amazon SageMaker to provision. This includes the number and
// type of ML compute instances to deploy.
//
// If you are hosting multiple models, you also assign a VariantWeight to specify
// how much traffic you want to allocate to each model. For example, suppose
// that you want to host two models, A and B, and you assign traffic weight
// 2 for model A and 1 for model B. Amazon SageMaker distributes two-thirds
// of the traffic to Model A, and one-third to model B.
//
// For an example that calls this method when deploying a model to Amazon SageMaker
// hosting services, see Deploy the Model to Amazon SageMaker Hosting Services
// (AWS SDK for Python (Boto 3)). (https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
//
// When you call CreateEndpoint, a load call is made to DynamoDB to verify that
// your endpoint configuration exists. When you read data from a DynamoDB table
// supporting Eventually Consistent Reads (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html),
// the response might not reflect the results of a recently completed write
// operation. The response might include some stale data. If the dependent entities
// are not yet in DynamoDB, this causes a validation error. If you repeat your
// read request after a short time, the response should return the latest data.
// So retry logic is recommended to handle these possible issues. We also recommend
// that customers call DescribeEndpointConfig before calling CreateEndpoint
// to minimize the potential impact of a DynamoDB eventually consistent read.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateEndpointConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig
func (c *SageMaker) CreateEndpointConfig(input *CreateEndpointConfigInput) (*CreateEndpointConfigOutput, error) {
	req, out := c.CreateEndpointConfigRequest(input)
	return out, req.Send()
}

// CreateEndpointConfigWithContext is the same as CreateEndpointConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpointConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateEndpointConfigWithContext(ctx aws.Context, input *CreateEndpointConfigInput, opts ...request.Option) (*CreateEndpointConfigOutput, error) {
	req, out := c.CreateEndpointConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExperiment = "CreateExperiment"

// CreateExperimentRequest generates a "aws/request.Request" representing the
// client's request for the CreateExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExperiment for more information on using the CreateExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateExperimentRequest method.
//    req, resp := client.CreateExperimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment
func (c *SageMaker) CreateExperimentRequest(input *CreateExperimentInput) (req *request.Request, output *CreateExperimentOutput) {
	op := &request.Operation{
		Name:       opCreateExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateExperimentInput{}
	}

	output = &CreateExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExperiment API operation for Amazon SageMaker Service.
//
// Creates an SageMaker experiment. An experiment is a collection of trials
// that are observed, compared and evaluated as a group. A trial is a set of
// steps, called trial components, that produce a machine learning model.
//
// The goal of an experiment is to determine the components that produce the
// best model. Multiple trials are performed, each one isolating and measuring
// the impact of a change to one or more inputs, while keeping the remaining
// inputs constant.
//
// When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
// all experiments, trials, and trial components are automatically tracked,
// logged, and indexed. When you use the AWS SDK for Python (Boto), you must
// use the logging APIs provided by the SDK.
//
// You can add tags to experiments, trials, trial components and then use the
// Search API to search for the tags.
//
// To add a description to an experiment, specify the optional Description parameter.
// To add a description later, or to change the description, call the UpdateExperiment
// API.
//
// To get a list of all your experiments, call the ListExperiments API. To view
// an experiment's properties, call the DescribeExperiment API. To get a list
// of all the trials associated with an experiment, call the ListTrials API.
// To create a trial call the CreateTrial API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateExperiment for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment
func (c *SageMaker) CreateExperiment(input *CreateExperimentInput) (*CreateExperimentOutput, error) {
	req, out := c.CreateExperimentRequest(input)
	return out, req.Send()
}

// CreateExperimentWithContext is the same as CreateExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateExperimentWithContext(ctx aws.Context, input *CreateExperimentInput, opts ...request.Option) (*CreateExperimentOutput, error) {
	req, out := c.CreateExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFeatureGroup = "CreateFeatureGroup"

// CreateFeatureGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateFeatureGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFeatureGroup for more information on using the CreateFeatureGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFeatureGroupRequest method.
//    req, resp := client.CreateFeatureGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFeatureGroup
func (c *SageMaker) CreateFeatureGroupRequest(input *CreateFeatureGroupInput) (req *request.Request, output *CreateFeatureGroupOutput) {
	op := &request.Operation{
		Name:       opCreateFeatureGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFeatureGroupInput{}
	}

	output = &CreateFeatureGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFeatureGroup API operation for Amazon SageMaker Service.
//
// Create a new FeatureGroup. A FeatureGroup is a group of Features defined
// in the FeatureStore to describe a Record.
//
// The FeatureGroup defines the schema and features contained in the FeatureGroup.
// A FeatureGroup definition is composed of a list of Features, a RecordIdentifierFeatureName,
// an EventTimeFeatureName and configurations for its OnlineStore and OfflineStore.
// Check AWS service quotas (https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html)
// to see the FeatureGroups quota for your AWS account.
//
// You must include at least one of OnlineStoreConfig and OfflineStoreConfig
// to create a FeatureGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateFeatureGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFeatureGroup
func (c *SageMaker) CreateFeatureGroup(input *CreateFeatureGroupInput) (*CreateFeatureGroupOutput, error) {
	req, out := c.CreateFeatureGroupRequest(input)
	return out, req.Send()
}

// CreateFeatureGroupWithContext is the same as CreateFeatureGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFeatureGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateFeatureGroupWithContext(ctx aws.Context, input *CreateFeatureGroupInput, opts ...request.Option) (*CreateFeatureGroupOutput, error) {
	req, out := c.CreateFeatureGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlowDefinition = "CreateFlowDefinition"

// CreateFlowDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlowDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlowDefinition for more information on using the CreateFlowDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFlowDefinitionRequest method.
//    req, resp := client.CreateFlowDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition
func (c *SageMaker) CreateFlowDefinitionRequest(input *CreateFlowDefinitionInput) (req *request.Request, output *CreateFlowDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateFlowDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFlowDefinitionInput{}
	}

	output = &CreateFlowDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlowDefinition API operation for Amazon SageMaker Service.
//
// Creates a flow definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateFlowDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition
func (c *SageMaker) CreateFlowDefinition(input *CreateFlowDefinitionInput) (*CreateFlowDefinitionOutput, error) {
	req, out := c.CreateFlowDefinitionRequest(input)
	return out, req.Send()
}

// CreateFlowDefinitionWithContext is the same as CreateFlowDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlowDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateFlowDefinitionWithContext(ctx aws.Context, input *CreateFlowDefinitionInput, opts ...request.Option) (*CreateFlowDefinitionOutput, error) {
	req, out := c.CreateFlowDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHumanTaskUi = "CreateHumanTaskUi"

// CreateHumanTaskUiRequest generates a "aws/request.Request" representing the
// client's request for the CreateHumanTaskUi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHumanTaskUi for more information on using the CreateHumanTaskUi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHumanTaskUiRequest method.
//    req, resp := client.CreateHumanTaskUiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi
func (c *SageMaker) CreateHumanTaskUiRequest(input *CreateHumanTaskUiInput) (req *request.Request, output *CreateHumanTaskUiOutput) {
	op := &request.Operation{
		Name:       opCreateHumanTaskUi,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHumanTaskUiInput{}
	}

	output = &CreateHumanTaskUiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHumanTaskUi API operation for Amazon SageMaker Service.
//
// Defines the settings you will use for the human review workflow user interface.
// Reviewers will see a three-panel interface with an instruction area, the
// item to review, and an input area.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateHumanTaskUi for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi
func (c *SageMaker) CreateHumanTaskUi(input *CreateHumanTaskUiInput) (*CreateHumanTaskUiOutput, error) {
	req, out := c.CreateHumanTaskUiRequest(input)
	return out, req.Send()
}

// CreateHumanTaskUiWithContext is the same as CreateHumanTaskUi with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHumanTaskUi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateHumanTaskUiWithContext(ctx aws.Context, input *CreateHumanTaskUiInput, opts ...request.Option) (*CreateHumanTaskUiOutput, error) {
	req, out := c.CreateHumanTaskUiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHyperParameterTuningJob = "CreateHyperParameterTuningJob"

// CreateHyperParameterTuningJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateHyperParameterTuningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHyperParameterTuningJob for more information on using the CreateHyperParameterTuningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHyperParameterTuningJobRequest method.
//    req, resp := client.CreateHyperParameterTuningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob
func (c *SageMaker) CreateHyperParameterTuningJobRequest(input *CreateHyperParameterTuningJobInput) (req *request.Request, output *CreateHyperParameterTuningJobOutput) {
	op := &request.Operation{
		Name:       opCreateHyperParameterTuningJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHyperParameterTuningJobInput{}
	}

	output = &CreateHyperParameterTuningJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHyperParameterTuningJob API operation for Amazon SageMaker Service.
//
// Starts a hyperparameter tuning job. A hyperparameter tuning job finds the
// best version of a model by running many training jobs on your dataset using
// the algorithm you choose and values for hyperparameters within ranges that
// you specify. It then chooses the hyperparameter values that result in a model
// that performs the best, as measured by an objective metric that you choose.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateHyperParameterTuningJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob
func (c *SageMaker) CreateHyperParameterTuningJob(input *CreateHyperParameterTuningJobInput) (*CreateHyperParameterTuningJobOutput, error) {
	req, out := c.CreateHyperParameterTuningJobRequest(input)
	return out, req.Send()
}

// CreateHyperParameterTuningJobWithContext is the same as CreateHyperParameterTuningJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHyperParameterTuningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateHyperParameterTuningJobWithContext(ctx aws.Context, input *CreateHyperParameterTuningJobInput, opts ...request.Option) (*CreateHyperParameterTuningJobOutput, error) {
	req, out := c.CreateHyperParameterTuningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImage = "CreateImage"

// CreateImageRequest generates a "aws/request.Request" representing the
// client's request for the CreateImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImage for more information on using the CreateImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateImageRequest method.
//    req, resp := client.CreateImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImage
func (c *SageMaker) CreateImageRequest(input *CreateImageInput) (req *request.Request, output *CreateImageOutput) {
	op := &request.Operation{
		Name:       opCreateImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageInput{}
	}

	output = &CreateImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImage API operation for Amazon SageMaker Service.
//
// Creates a custom SageMaker image. A SageMaker image is a set of image versions.
// Each image version represents a container image stored in Amazon Container
// Registry (ECR). For more information, see Bring your own SageMaker image
// (https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateImage for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImage
func (c *SageMaker) CreateImage(input *CreateImageInput) (*CreateImageOutput, error) {
	req, out := c.CreateImageRequest(input)
	return out, req.Send()
}

// CreateImageWithContext is the same as CreateImage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateImageWithContext(ctx aws.Context, input *CreateImageInput, opts ...request.Option) (*CreateImageOutput, error) {
	req, out := c.CreateImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImageVersion = "CreateImageVersion"

// CreateImageVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateImageVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImageVersion for more information on using the CreateImageVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateImageVersionRequest method.
//    req, resp := client.CreateImageVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImageVersion
func (c *SageMaker) CreateImageVersionRequest(input *CreateImageVersionInput) (req *request.Request, output *CreateImageVersionOutput) {
	op := &request.Operation{
		Name:       opCreateImageVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageVersionInput{}
	}

	output = &CreateImageVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImageVersion API operation for Amazon SageMaker Service.
//
// Creates a version of the SageMaker image specified by ImageName. The version
// represents the Amazon Container Registry (ECR) container image specified
// by BaseImage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateImageVersion for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImageVersion
func (c *SageMaker) CreateImageVersion(input *CreateImageVersionInput) (*CreateImageVersionOutput, error) {
	req, out := c.CreateImageVersionRequest(input)
	return out, req.Send()
}

// CreateImageVersionWithContext is the same as CreateImageVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImageVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateImageVersionWithContext(ctx aws.Context, input *CreateImageVersionInput, opts ...request.Option) (*CreateImageVersionOutput, error) {
	req, out := c.CreateImageVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLabelingJob = "CreateLabelingJob"

// CreateLabelingJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateLabelingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLabelingJob for more information on using the CreateLabelingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLabelingJobRequest method.
//    req, resp := client.CreateLabelingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob
func (c *SageMaker) CreateLabelingJobRequest(input *CreateLabelingJobInput) (req *request.Request, output *CreateLabelingJobOutput) {
	op := &request.Operation{
		Name:       opCreateLabelingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLabelingJobInput{}
	}

	output = &CreateLabelingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLabelingJob API operation for Amazon SageMaker Service.
//
// Creates a job that uses workers to label the data objects in your input dataset.
// You can use the labeled data to train machine learning models.
//
// You can select your workforce from one of three providers:
//
//    * A private workforce that you create. It can include employees, contractors,
//    and outside experts. Use a private workforce when want the data to stay
//    within your organization or when a specific set of skills is required.
//
//    * One or more vendors that you select from the AWS Marketplace. Vendors
//    provide expertise in specific areas.
//
//    * The Amazon Mechanical Turk workforce. This is the largest workforce,
//    but it should only be used for public data or data that has been stripped
//    of any personally identifiable information.
//
// You can also use automated data labeling to reduce the number of data objects
// that need to be labeled by a human. Automated data labeling uses active learning
// to determine if a data object can be labeled by machine or if it needs to
// be sent to a human worker. For more information, see Using Automated Data
// Labeling (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html).
//
// The data objects to be labeled are contained in an Amazon S3 bucket. You
// create a manifest file that describes the location of each object. For more
// information, see Using Input and Output Data (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html).
//
// The output can be used as the manifest file for another labeling job or as
// training data for your machine learning models.
//
// You can use this operation to create a static labeling job or a streaming
// labeling job. A static labeling job stops if all data objects in the input
// manifest file identified in ManifestS3Uri have been labeled. A streaming
// labeling job runs perpetually until it is manually stopped, or remains idle
// for 10 days. You can send new data objects to an active (InProgress) streaming
// labeling job in real time. To learn how to create a static labeling job,
// see Create a Labeling Job (API) (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html)
// in the Amazon SageMaker Developer Guide. To learn how to create a streaming
// labeling job, see Create a Streaming Labeling Job (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateLabelingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob
func (c *SageMaker) CreateLabelingJob(input *CreateLabelingJobInput) (*CreateLabelingJobOutput, error) {
	req, out := c.CreateLabelingJobRequest(input)
	return out, req.Send()
}

// CreateLabelingJobWithContext is the same as CreateLabelingJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLabelingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateLabelingJobWithContext(ctx aws.Context, input *CreateLabelingJobInput, opts ...request.Option) (*CreateLabelingJobOutput, error) {
	req, out := c.CreateLabelingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModel = "CreateModel"

// CreateModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModel for more information on using the CreateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelRequest method.
//    req, resp := client.CreateModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel
func (c *SageMaker) CreateModelRequest(input *CreateModelInput) (req *request.Request, output *CreateModelOutput) {
	op := &request.Operation{
		Name:       opCreateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelInput{}
	}

	output = &CreateModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModel API operation for Amazon SageMaker Service.
//
// Creates a model in Amazon SageMaker. In the request, you name the model and
// describe a primary container. For the primary container, you specify the
// Docker image that contains inference code, artifacts (from prior training),
// and a custom environment map that the inference code uses when you deploy
// the model for predictions.
//
// Use this API to create a model if you want to use Amazon SageMaker hosting
// services or run a batch transform job.
//
// To host your model, you create an endpoint configuration with the CreateEndpointConfig
// API, and then create an endpoint with the CreateEndpoint API. Amazon SageMaker
// then deploys all of the containers that you defined for the model in the
// hosting environment.
//
// For an example that calls this method when deploying a model to Amazon SageMaker
// hosting services, see Deploy the Model to Amazon SageMaker Hosting Services
// (AWS SDK for Python (Boto 3)). (https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
//
// To run a batch transform using your model, you start a job with the CreateTransformJob
// API. Amazon SageMaker uses your model and your dataset to get inferences
// which are then saved to a specified S3 location.
//
// In the CreateModel request, you must define a container with the PrimaryContainer
// parameter.
//
// In the request, you also provide an IAM role that Amazon SageMaker can assume
// to access model artifacts and docker image for deployment on ML compute hosting
// instances or for batch transform jobs. In addition, you also use the IAM
// role to manage permissions the inference code needs. For example, if the
// inference code access any other AWS resources, you grant necessary permissions
// via this role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateModel for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel
func (c *SageMaker) CreateModel(input *CreateModelInput) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	return out, req.Send()
}

// CreateModelWithContext is the same as CreateModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateModelWithContext(ctx aws.Context, input *CreateModelInput, opts ...request.Option) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelBiasJobDefinition = "CreateModelBiasJobDefinition"

// CreateModelBiasJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelBiasJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelBiasJobDefinition for more information on using the CreateModelBiasJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelBiasJobDefinitionRequest method.
//    req, resp := client.CreateModelBiasJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelBiasJobDefinition
func (c *SageMaker) CreateModelBiasJobDefinitionRequest(input *CreateModelBiasJobDefinitionInput) (req *request.Request, output *CreateModelBiasJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateModelBiasJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelBiasJobDefinitionInput{}
	}

	output = &CreateModelBiasJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelBiasJobDefinition API operation for Amazon SageMaker Service.
//
// Creates the definition for a model bias job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateModelBiasJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelBiasJobDefinition
func (c *SageMaker) CreateModelBiasJobDefinition(input *CreateModelBiasJobDefinitionInput) (*CreateModelBiasJobDefinitionOutput, error) {
	req, out := c.CreateModelBiasJobDefinitionRequest(input)
	return out, req.Send()
}

// CreateModelBiasJobDefinitionWithContext is the same as CreateModelBiasJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelBiasJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateModelBiasJobDefinitionWithContext(ctx aws.Context, input *CreateModelBiasJobDefinitionInput, opts ...request.Option) (*CreateModelBiasJobDefinitionOutput, error) {
	req, out := c.CreateModelBiasJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelExplainabilityJobDefinition = "CreateModelExplainabilityJobDefinition"

// CreateModelExplainabilityJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelExplainabilityJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelExplainabilityJobDefinition for more information on using the CreateModelExplainabilityJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelExplainabilityJobDefinitionRequest method.
//    req, resp := client.CreateModelExplainabilityJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelExplainabilityJobDefinition
func (c *SageMaker) CreateModelExplainabilityJobDefinitionRequest(input *CreateModelExplainabilityJobDefinitionInput) (req *request.Request, output *CreateModelExplainabilityJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateModelExplainabilityJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelExplainabilityJobDefinitionInput{}
	}

	output = &CreateModelExplainabilityJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelExplainabilityJobDefinition API operation for Amazon SageMaker Service.
//
// Creates the definition for a model explainability job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateModelExplainabilityJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelExplainabilityJobDefinition
func (c *SageMaker) CreateModelExplainabilityJobDefinition(input *CreateModelExplainabilityJobDefinitionInput) (*CreateModelExplainabilityJobDefinitionOutput, error) {
	req, out := c.CreateModelExplainabilityJobDefinitionRequest(input)
	return out, req.Send()
}

// CreateModelExplainabilityJobDefinitionWithContext is the same as CreateModelExplainabilityJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelExplainabilityJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateModelExplainabilityJobDefinitionWithContext(ctx aws.Context, input *CreateModelExplainabilityJobDefinitionInput, opts ...request.Option) (*CreateModelExplainabilityJobDefinitionOutput, error) {
	req, out := c.CreateModelExplainabilityJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelPackage = "CreateModelPackage"

// CreateModelPackageRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelPackage for more information on using the CreateModelPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelPackageRequest method.
//    req, resp := client.CreateModelPackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage
func (c *SageMaker) CreateModelPackageRequest(input *CreateModelPackageInput) (req *request.Request, output *CreateModelPackageOutput) {
	op := &request.Operation{
		Name:       opCreateModelPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelPackageInput{}
	}

	output = &CreateModelPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelPackage API operation for Amazon SageMaker Service.
//
// Creates a model package that you can use to create Amazon SageMaker models
// or list on AWS Marketplace, or a versioned model that is part of a model
// group. Buyers can subscribe to model packages listed on AWS Marketplace to
// create models in Amazon SageMaker.
//
// To create a model package by specifying a Docker container that contains
// your inference code and the Amazon S3 location of your model artifacts, provide
// values for InferenceSpecification. To create a model from an algorithm resource
// that you created or subscribed to in AWS Marketplace, provide a value for
// SourceAlgorithmSpecification.
//
// There are two types of model packages:
//
//    * Versioned - a model that is part of a model group in the model registry.
//
//    * Unversioned - a model package that is not part of a model group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateModelPackage for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when you attempted to modify an experiment, trial, or
//   trial component.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage
func (c *SageMaker) CreateModelPackage(input *CreateModelPackageInput) (*CreateModelPackageOutput, error) {
	req, out := c.CreateModelPackageRequest(input)
	return out, req.Send()
}

// CreateModelPackageWithContext is the same as CreateModelPackage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateModelPackageWithContext(ctx aws.Context, input *CreateModelPackageInput, opts ...request.Option) (*CreateModelPackageOutput, error) {
	req, out := c.CreateModelPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelPackageGroup = "CreateModelPackageGroup"

// CreateModelPackageGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelPackageGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelPackageGroup for more information on using the CreateModelPackageGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelPackageGroupRequest method.
//    req, resp := client.CreateModelPackageGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackageGroup
func (c *SageMaker) CreateModelPackageGroupRequest(input *CreateModelPackageGroupInput) (req *request.Request, output *CreateModelPackageGroupOutput) {
	op := &request.Operation{
		Name:       opCreateModelPackageGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelPackageGroupInput{}
	}

	output = &CreateModelPackageGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelPackageGroup API operation for Amazon SageMaker Service.
//
// Creates a model group. A model group contains a group of model versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateModelPackageGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackageGroup
func (c *SageMaker) CreateModelPackageGroup(input *CreateModelPackageGroupInput) (*CreateModelPackageGroupOutput, error) {
	req, out := c.CreateModelPackageGroupRequest(input)
	return out, req.Send()
}

// CreateModelPackageGroupWithContext is the same as CreateModelPackageGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelPackageGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateModelPackageGroupWithContext(ctx aws.Context, input *CreateModelPackageGroupInput, opts ...request.Option) (*CreateModelPackageGroupOutput, error) {
	req, out := c.CreateModelPackageGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelQualityJobDefinition = "CreateModelQualityJobDefinition"

// CreateModelQualityJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelQualityJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelQualityJobDefinition for more information on using the CreateModelQualityJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelQualityJobDefinitionRequest method.
//    req, resp := client.CreateModelQualityJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelQualityJobDefinition
func (c *SageMaker) CreateModelQualityJobDefinitionRequest(input *CreateModelQualityJobDefinitionInput) (req *request.Request, output *CreateModelQualityJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateModelQualityJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelQualityJobDefinitionInput{}
	}

	output = &CreateModelQualityJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelQualityJobDefinition API operation for Amazon SageMaker Service.
//
// Creates a definition for a job that monitors model quality and drift. For
// information about model monitor, see Amazon SageMaker Model Monitor (https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateModelQualityJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelQualityJobDefinition
func (c *SageMaker) CreateModelQualityJobDefinition(input *CreateModelQualityJobDefinitionInput) (*CreateModelQualityJobDefinitionOutput, error) {
	req, out := c.CreateModelQualityJobDefinitionRequest(input)
	return out, req.Send()
}

// CreateModelQualityJobDefinitionWithContext is the same as CreateModelQualityJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelQualityJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateModelQualityJobDefinitionWithContext(ctx aws.Context, input *CreateModelQualityJobDefinitionInput, opts ...request.Option) (*CreateModelQualityJobDefinitionOutput, error) {
	req, out := c.CreateModelQualityJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMonitoringSchedule = "CreateMonitoringSchedule"

// CreateMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the CreateMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMonitoringSchedule for more information on using the CreateMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMonitoringScheduleRequest method.
//    req, resp := client.CreateMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule
func (c *SageMaker) CreateMonitoringScheduleRequest(input *CreateMonitoringScheduleInput) (req *request.Request, output *CreateMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opCreateMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMonitoringScheduleInput{}
	}

	output = &CreateMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Creates a schedule that regularly starts Amazon SageMaker Processing Jobs
// to monitor the data captured for an Amazon SageMaker Endoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule
func (c *SageMaker) CreateMonitoringSchedule(input *CreateMonitoringScheduleInput) (*CreateMonitoringScheduleOutput, error) {
	req, out := c.CreateMonitoringScheduleRequest(input)
	return out, req.Send()
}

// CreateMonitoringScheduleWithContext is the same as CreateMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateMonitoringScheduleWithContext(ctx aws.Context, input *CreateMonitoringScheduleInput, opts ...request.Option) (*CreateMonitoringScheduleOutput, error) {
	req, out := c.CreateMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNotebookInstance = "CreateNotebookInstance"

// CreateNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNotebookInstance for more information on using the CreateNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNotebookInstanceRequest method.
//    req, resp := client.CreateNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance
func (c *SageMaker) CreateNotebookInstanceRequest(input *CreateNotebookInstanceInput) (req *request.Request, output *CreateNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNotebookInstanceInput{}
	}

	output = &CreateNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNotebookInstance API operation for Amazon SageMaker Service.
//
// Creates an Amazon SageMaker notebook instance. A notebook instance is a machine
// learning (ML) compute instance running on a Jupyter notebook.
//
// In a CreateNotebookInstance request, specify the type of ML compute instance
// that you want to run. Amazon SageMaker launches the instance, installs common
// libraries that you can use to explore datasets for model training, and attaches
// an ML storage volume to the notebook instance.
//
// Amazon SageMaker also provides a set of example notebooks. Each notebook
// demonstrates how to use Amazon SageMaker with a specific algorithm or with
// a machine learning framework.
//
// After receiving the request, Amazon SageMaker does the following:
//
// Creates a network interface in the Amazon SageMaker VPC.
//
// (Option) If you specified SubnetId, Amazon SageMaker creates a network interface
// in your own VPC, which is inferred from the subnet ID that you provide in
// the input. When creating this network interface, Amazon SageMaker attaches
// the security group that you specified in the request to the network interface
// that it creates in your VPC.
//
// Launches an EC2 instance of the type specified in the request in the Amazon
// SageMaker VPC. If you specified SubnetId of your VPC, Amazon SageMaker specifies
// both network interfaces when launching this instance. This enables inbound
// traffic from your own VPC to the notebook instance, assuming that the security
// groups allow it.
//
// After creating the notebook instance, Amazon SageMaker returns its Amazon
// Resource Name (ARN). You can't change the name of a notebook instance after
// you create it.
//
// After Amazon SageMaker creates the notebook instance, you can connect to
// the Jupyter server and work in Jupyter notebooks. For example, you can write
// code to explore a dataset that you can use for model training, train a model,
// host models by creating Amazon SageMaker endpoints, and validate hosted models.
//
// For more information, see How It Works (https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateNotebookInstance for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance
func (c *SageMaker) CreateNotebookInstance(input *CreateNotebookInstanceInput) (*CreateNotebookInstanceOutput, error) {
	req, out := c.CreateNotebookInstanceRequest(input)
	return out, req.Send()
}

// CreateNotebookInstanceWithContext is the same as CreateNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateNotebookInstanceWithContext(ctx aws.Context, input *CreateNotebookInstanceInput, opts ...request.Option) (*CreateNotebookInstanceOutput, error) {
	req, out := c.CreateNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNotebookInstanceLifecycleConfig = "CreateNotebookInstanceLifecycleConfig"

// CreateNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNotebookInstanceLifecycleConfig for more information on using the CreateNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.CreateNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig
func (c *SageMaker) CreateNotebookInstanceLifecycleConfigRequest(input *CreateNotebookInstanceLifecycleConfigInput) (req *request.Request, output *CreateNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opCreateNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNotebookInstanceLifecycleConfigInput{}
	}

	output = &CreateNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Creates a lifecycle configuration that you can associate with a notebook
// instance. A lifecycle configuration is a collection of shell scripts that
// run when you create or start a notebook instance.
//
// Each lifecycle configuration script has a limit of 16384 characters.
//
// The value of the $PATH environment variable that is available to both scripts
// is /sbin:bin:/usr/sbin:/usr/bin.
//
// View CloudWatch Logs for notebook instance lifecycle configurations in log
// group /aws/sagemaker/NotebookInstances in log stream [notebook-instance-name]/[LifecycleConfigHook].
//
// Lifecycle configuration scripts cannot run for longer than 5 minutes. If
// a script runs for longer than 5 minutes, it fails and the notebook instance
// is not created or started.
//
// For information about notebook instance lifestyle configurations, see Step
// 2.1: (Optional) Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateNotebookInstanceLifecycleConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig
func (c *SageMaker) CreateNotebookInstanceLifecycleConfig(input *CreateNotebookInstanceLifecycleConfigInput) (*CreateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.CreateNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// CreateNotebookInstanceLifecycleConfigWithContext is the same as CreateNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *CreateNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*CreateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.CreateNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePipeline = "CreatePipeline"

// CreatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreatePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePipeline for more information on using the CreatePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePipelineRequest method.
//    req, resp := client.CreatePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePipeline
func (c *SageMaker) CreatePipelineRequest(input *CreatePipelineInput) (req *request.Request, output *CreatePipelineOutput) {
	op := &request.Operation{
		Name:       opCreatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePipelineInput{}
	}

	output = &CreatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePipeline API operation for Amazon SageMaker Service.
//
// Creates a pipeline using a JSON pipeline definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreatePipeline for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePipeline
func (c *SageMaker) CreatePipeline(input *CreatePipelineInput) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	return out, req.Send()
}

// CreatePipelineWithContext is the same as CreatePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreatePipelineWithContext(ctx aws.Context, input *CreatePipelineInput, opts ...request.Option) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePresignedDomainUrl = "CreatePresignedDomainUrl"

// CreatePresignedDomainUrlRequest generates a "aws/request.Request" representing the
// client's request for the CreatePresignedDomainUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePresignedDomainUrl for more information on using the CreatePresignedDomainUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePresignedDomainUrlRequest method.
//    req, resp := client.CreatePresignedDomainUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedDomainUrl
func (c *SageMaker) CreatePresignedDomainUrlRequest(input *CreatePresignedDomainUrlInput) (req *request.Request, output *CreatePresignedDomainUrlOutput) {
	op := &request.Operation{
		Name:       opCreatePresignedDomainUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePresignedDomainUrlInput{}
	}

	output = &CreatePresignedDomainUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePresignedDomainUrl API operation for Amazon SageMaker Service.
//
// Creates a URL for a specified UserProfile in a Domain. When accessed in a
// web browser, the user will be automatically signed in to Amazon SageMaker
// Studio, and granted access to all of the Apps and files associated with the
// Domain's Amazon Elastic File System (EFS) volume. This operation can only
// be called when the authentication mode equals IAM.
//
// The URL that you get from a call to CreatePresignedDomainUrl is valid only
// for 5 minutes. If you try to use the URL after the 5-minute limit expires,
// you are directed to the AWS console sign-in page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreatePresignedDomainUrl for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedDomainUrl
func (c *SageMaker) CreatePresignedDomainUrl(input *CreatePresignedDomainUrlInput) (*CreatePresignedDomainUrlOutput, error) {
	req, out := c.CreatePresignedDomainUrlRequest(input)
	return out, req.Send()
}

// CreatePresignedDomainUrlWithContext is the same as CreatePresignedDomainUrl with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePresignedDomainUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreatePresignedDomainUrlWithContext(ctx aws.Context, input *CreatePresignedDomainUrlInput, opts ...request.Option) (*CreatePresignedDomainUrlOutput, error) {
	req, out := c.CreatePresignedDomainUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePresignedNotebookInstanceUrl = "CreatePresignedNotebookInstanceUrl"

// CreatePresignedNotebookInstanceUrlRequest generates a "aws/request.Request" representing the
// client's request for the CreatePresignedNotebookInstanceUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePresignedNotebookInstanceUrl for more information on using the CreatePresignedNotebookInstanceUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePresignedNotebookInstanceUrlRequest method.
//    req, resp := client.CreatePresignedNotebookInstanceUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl
func (c *SageMaker) CreatePresignedNotebookInstanceUrlRequest(input *CreatePresignedNotebookInstanceUrlInput) (req *request.Request, output *CreatePresignedNotebookInstanceUrlOutput) {
	op := &request.Operation{
		Name:       opCreatePresignedNotebookInstanceUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePresignedNotebookInstanceUrlInput{}
	}

	output = &CreatePresignedNotebookInstanceUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePresignedNotebookInstanceUrl API operation for Amazon SageMaker Service.
//
// Returns a URL that you can use to connect to the Jupyter server from a notebook
// instance. In the Amazon SageMaker console, when you choose Open next to a
// notebook instance, Amazon SageMaker opens a new tab showing the Jupyter server
// home page from the notebook instance. The console uses this API to get the
// URL and show the page.
//
// The IAM role or user used to call this API defines the permissions to access
// the notebook instance. Once the presigned URL is created, no additional permission
// is required to access this URL. IAM authorization policies for this API are
// also enforced for every HTTP request and WebSocket frame that attempts to
// connect to the notebook instance.
//
// You can restrict access to this API and to the URL that it returns to a list
// of IP addresses that you specify. Use the NotIpAddress condition operator
// and the aws:SourceIP condition context key to specify the list of IP addresses
// that you want to have access to the notebook instance. For more information,
// see Limit Access to a Notebook Instance by IP Address (https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter).
//
// The URL that you get from a call to CreatePresignedNotebookInstanceUrl is
// valid only for 5 minutes. If you try to use the URL after the 5-minute limit
// expires, you are directed to the AWS console sign-in page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreatePresignedNotebookInstanceUrl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl
func (c *SageMaker) CreatePresignedNotebookInstanceUrl(input *CreatePresignedNotebookInstanceUrlInput) (*CreatePresignedNotebookInstanceUrlOutput, error) {
	req, out := c.CreatePresignedNotebookInstanceUrlRequest(input)
	return out, req.Send()
}

// CreatePresignedNotebookInstanceUrlWithContext is the same as CreatePresignedNotebookInstanceUrl with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePresignedNotebookInstanceUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreatePresignedNotebookInstanceUrlWithContext(ctx aws.Context, input *CreatePresignedNotebookInstanceUrlInput, opts ...request.Option) (*CreatePresignedNotebookInstanceUrlOutput, error) {
	req, out := c.CreatePresignedNotebookInstanceUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProcessingJob = "CreateProcessingJob"

// CreateProcessingJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateProcessingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProcessingJob for more information on using the CreateProcessingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProcessingJobRequest method.
//    req, resp := client.CreateProcessingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProcessingJob
func (c *SageMaker) CreateProcessingJobRequest(input *CreateProcessingJobInput) (req *request.Request, output *CreateProcessingJobOutput) {
	op := &request.Operation{
		Name:       opCreateProcessingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProcessingJobInput{}
	}

	output = &CreateProcessingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProcessingJob API operation for Amazon SageMaker Service.
//
// Creates a processing job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateProcessingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProcessingJob
func (c *SageMaker) CreateProcessingJob(input *CreateProcessingJobInput) (*CreateProcessingJobOutput, error) {
	req, out := c.CreateProcessingJobRequest(input)
	return out, req.Send()
}

// CreateProcessingJobWithContext is the same as CreateProcessingJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProcessingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateProcessingJobWithContext(ctx aws.Context, input *CreateProcessingJobInput, opts ...request.Option) (*CreateProcessingJobOutput, error) {
	req, out := c.CreateProcessingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProject
func (c *SageMaker) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for Amazon SageMaker Service.
//
// Creates a machine learning (ML) project that can contain one or more templates
// that set up an ML pipeline from training to deploying an approved model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProject
func (c *SageMaker) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrainingJob = "CreateTrainingJob"

// CreateTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrainingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrainingJob for more information on using the CreateTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrainingJobRequest method.
//    req, resp := client.CreateTrainingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob
func (c *SageMaker) CreateTrainingJobRequest(input *CreateTrainingJobInput) (req *request.Request, output *CreateTrainingJobOutput) {
	op := &request.Operation{
		Name:       opCreateTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrainingJobInput{}
	}

	output = &CreateTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrainingJob API operation for Amazon SageMaker Service.
//
// Starts a model training job. After training completes, Amazon SageMaker saves
// the resulting model artifacts to an Amazon S3 location that you specify.
//
// If you choose to host your model using Amazon SageMaker hosting services,
// you can use the resulting model artifacts as part of the model. You can also
// use the artifacts in a machine learning service other than Amazon SageMaker,
// provided that you know how to use them for inference.
//
// In the request body, you provide the following:
//
//    * AlgorithmSpecification - Identifies the training algorithm to use.
//
//    * HyperParameters - Specify these algorithm-specific parameters to enable
//    the estimation of model parameters during training. Hyperparameters can
//    be tuned to optimize this learning process. For a list of hyperparameters
//    for each training algorithm provided by Amazon SageMaker, see Algorithms
//    (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
//
//    * InputDataConfig - Describes the training dataset and the Amazon S3,
//    EFS, or FSx location where it is stored.
//
//    * OutputDataConfig - Identifies the Amazon S3 bucket where you want Amazon
//    SageMaker to save the results of model training.
//
//    * ResourceConfig - Identifies the resources, ML compute instances, and
//    ML storage volumes to deploy for model training. In distributed training,
//    you specify more than one instance.
//
//    * EnableManagedSpotTraining - Optimize the cost of training machine learning
//    models by up to 80% by using Amazon EC2 Spot instances. For more information,
//    see Managed Spot Training (https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html).
//
//    * RoleArn - The Amazon Resource Name (ARN) that Amazon SageMaker assumes
//    to perform tasks on your behalf during model training. You must grant
//    this role the necessary permissions so that Amazon SageMaker can successfully
//    complete model training.
//
//    * StoppingCondition - To help cap training costs, use MaxRuntimeInSeconds
//    to set a time limit for training. Use MaxWaitTimeInSeconds to specify
//    how long you are willing to wait for a managed spot training job to complete.
//
// For more information about Amazon SageMaker, see How It Works (https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateTrainingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob
func (c *SageMaker) CreateTrainingJob(input *CreateTrainingJobInput) (*CreateTrainingJobOutput, error) {
	req, out := c.CreateTrainingJobRequest(input)
	return out, req.Send()
}

// CreateTrainingJobWithContext is the same as CreateTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateTrainingJobWithContext(ctx aws.Context, input *CreateTrainingJobInput, opts ...request.Option) (*CreateTrainingJobOutput, error) {
	req, out := c.CreateTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransformJob = "CreateTransformJob"

// CreateTransformJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransformJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransformJob for more information on using the CreateTransformJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTransformJobRequest method.
//    req, resp := client.CreateTransformJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob
func (c *SageMaker) CreateTransformJobRequest(input *CreateTransformJobInput) (req *request.Request, output *CreateTransformJobOutput) {
	op := &request.Operation{
		Name:       opCreateTransformJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransformJobInput{}
	}

	output = &CreateTransformJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransformJob API operation for Amazon SageMaker Service.
//
// Starts a transform job. A transform job uses a trained model to get inferences
// on a dataset and saves these results to an Amazon S3 location that you specify.
//
// To perform batch transformations, you create a transform job and use the
// data that you have readily available.
//
// In the request body, you provide the following:
//
//    * TransformJobName - Identifies the transform job. The name must be unique
//    within an AWS Region in an AWS account.
//
//    * ModelName - Identifies the model to use. ModelName must be the name
//    of an existing Amazon SageMaker model in the same AWS Region and AWS account.
//    For information on creating a model, see CreateModel.
//
//    * TransformInput - Describes the dataset to be transformed and the Amazon
//    S3 location where it is stored.
//
//    * TransformOutput - Identifies the Amazon S3 location where you want Amazon
//    SageMaker to save the results from the transform job.
//
//    * TransformResources - Identifies the ML compute instances for the transform
//    job.
//
// For more information about how batch transformation works, see Batch Transform
// (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateTransformJob for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob
func (c *SageMaker) CreateTransformJob(input *CreateTransformJobInput) (*CreateTransformJobOutput, error) {
	req, out := c.CreateTransformJobRequest(input)
	return out, req.Send()
}

// CreateTransformJobWithContext is the same as CreateTransformJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransformJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateTransformJobWithContext(ctx aws.Context, input *CreateTransformJobInput, opts ...request.Option) (*CreateTransformJobOutput, error) {
	req, out := c.CreateTransformJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrial = "CreateTrial"

// CreateTrialRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrial operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrial for more information on using the CreateTrial
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrialRequest method.
//    req, resp := client.CreateTrialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial
func (c *SageMaker) CreateTrialRequest(input *CreateTrialInput) (req *request.Request, output *CreateTrialOutput) {
	op := &request.Operation{
		Name:       opCreateTrial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrialInput{}
	}

	output = &CreateTrialOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrial API operation for Amazon SageMaker Service.
//
// Creates an Amazon SageMaker trial. A trial is a set of steps called trial
// components that produce a machine learning model. A trial is part of a single
// Amazon SageMaker experiment.
//
// When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
// all experiments, trials, and trial components are automatically tracked,
// logged, and indexed. When you use the AWS SDK for Python (Boto), you must
// use the logging APIs provided by the SDK.
//
// You can add tags to a trial and then use the Search API to search for the
// tags.
//
// To get a list of all your trials, call the ListTrials API. To view a trial's
// properties, call the DescribeTrial API. To create a trial component, call
// the CreateTrialComponent API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateTrial for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial
func (c *SageMaker) CreateTrial(input *CreateTrialInput) (*CreateTrialOutput, error) {
	req, out := c.CreateTrialRequest(input)
	return out, req.Send()
}

// CreateTrialWithContext is the same as CreateTrial with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrial for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateTrialWithContext(ctx aws.Context, input *CreateTrialInput, opts ...request.Option) (*CreateTrialOutput, error) {
	req, out := c.CreateTrialRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrialComponent = "CreateTrialComponent"

// CreateTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrialComponent for more information on using the CreateTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrialComponentRequest method.
//    req, resp := client.CreateTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrialComponent
func (c *SageMaker) CreateTrialComponentRequest(input *CreateTrialComponentInput) (req *request.Request, output *CreateTrialComponentOutput) {
	op := &request.Operation{
		Name:       opCreateTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrialComponentInput{}
	}

	output = &CreateTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrialComponent API operation for Amazon SageMaker Service.
//
// Creates a trial component, which is a stage of a machine learning trial.
// A trial is composed of one or more trial components. A trial component can
// be used in multiple trials.
//
// Trial components include pre-processing jobs, training jobs, and batch transform
// jobs.
//
// When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
// all experiments, trials, and trial components are automatically tracked,
// logged, and indexed. When you use the AWS SDK for Python (Boto), you must
// use the logging APIs provided by the SDK.
//
// You can add tags to a trial component and then use the Search API to search
// for the tags.
//
// CreateTrialComponent can only be invoked from within an Amazon SageMaker
// managed environment. This includes Amazon SageMaker training jobs, processing
// jobs, transform jobs, and Amazon SageMaker notebooks. A call to CreateTrialComponent
// from outside one of these environments results in an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrialComponent
func (c *SageMaker) CreateTrialComponent(input *CreateTrialComponentInput) (*CreateTrialComponentOutput, error) {
	req, out := c.CreateTrialComponentRequest(input)
	return out, req.Send()
}

// CreateTrialComponentWithContext is the same as CreateTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateTrialComponentWithContext(ctx aws.Context, input *CreateTrialComponentInput, opts ...request.Option) (*CreateTrialComponentOutput, error) {
	req, out := c.CreateTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserProfile = "CreateUserProfile"

// CreateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserProfile for more information on using the CreateUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserProfileRequest method.
//    req, resp := client.CreateUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateUserProfile
func (c *SageMaker) CreateUserProfileRequest(input *CreateUserProfileInput) (req *request.Request, output *CreateUserProfileOutput) {
	op := &request.Operation{
		Name:       opCreateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserProfileInput{}
	}

	output = &CreateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserProfile API operation for Amazon SageMaker Service.
//
// Creates a user profile. A user profile represents a single user within a
// domain, and is the main way to reference a "person" for the purposes of sharing,
// reporting, and other user-oriented features. This entity is created when
// a user onboards to Amazon SageMaker Studio. If an administrator invites a
// person by email or imports them from SSO, a user profile is automatically
// created. A user profile is the primary holder of settings for an individual
// user and has a reference to the user's private Amazon Elastic File System
// (EFS) home directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateUserProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateUserProfile
func (c *SageMaker) CreateUserProfile(input *CreateUserProfileInput) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	return out, req.Send()
}

// CreateUserProfileWithContext is the same as CreateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateUserProfileWithContext(ctx aws.Context, input *CreateUserProfileInput, opts ...request.Option) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkforce = "CreateWorkforce"

// CreateWorkforceRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkforce operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkforce for more information on using the CreateWorkforce
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkforceRequest method.
//    req, resp := client.CreateWorkforceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkforce
func (c *SageMaker) CreateWorkforceRequest(input *CreateWorkforceInput) (req *request.Request, output *CreateWorkforceOutput) {
	op := &request.Operation{
		Name:       opCreateWorkforce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkforceInput{}
	}

	output = &CreateWorkforceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkforce API operation for Amazon SageMaker Service.
//
// Use this operation to create a workforce. This operation will return an error
// if a workforce already exists in the AWS Region that you specify. You can
// only create one workforce in each AWS Region per AWS account.
//
// If you want to create a new workforce in an AWS Region where a workforce
// already exists, use the API operation to delete the existing workforce and
// then use CreateWorkforce to create a new workforce.
//
// To create a private workforce using Amazon Cognito, you must specify a Cognito
// user pool in CognitoConfig. You can also create an Amazon Cognito workforce
// using the Amazon SageMaker console. For more information, see Create a Private
// Workforce (Amazon Cognito) (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html).
//
// To create a private workforce using your own OIDC Identity Provider (IdP),
// specify your IdP configuration in OidcConfig. Your OIDC IdP must support
// groups because groups are used by Ground Truth and Amazon A2I to create work
// teams. For more information, see Create a Private Workforce (OIDC IdP) (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateWorkforce for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkforce
func (c *SageMaker) CreateWorkforce(input *CreateWorkforceInput) (*CreateWorkforceOutput, error) {
	req, out := c.CreateWorkforceRequest(input)
	return out, req.Send()
}

// CreateWorkforceWithContext is the same as CreateWorkforce with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkforce for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateWorkforceWithContext(ctx aws.Context, input *CreateWorkforceInput, opts ...request.Option) (*CreateWorkforceOutput, error) {
	req, out := c.CreateWorkforceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkteam = "CreateWorkteam"

// CreateWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkteam for more information on using the CreateWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkteamRequest method.
//    req, resp := client.CreateWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam
func (c *SageMaker) CreateWorkteamRequest(input *CreateWorkteamInput) (req *request.Request, output *CreateWorkteamOutput) {
	op := &request.Operation{
		Name:       opCreateWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkteamInput{}
	}

	output = &CreateWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkteam API operation for Amazon SageMaker Service.
//
// Creates a new work team for labeling your data. A work team is defined by
// one or more Amazon Cognito user pools. You must first create the user pools
// before you can create a work team.
//
// You cannot create more than 25 work teams in an account and region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation CreateWorkteam for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam
func (c *SageMaker) CreateWorkteam(input *CreateWorkteamInput) (*CreateWorkteamOutput, error) {
	req, out := c.CreateWorkteamRequest(input)
	return out, req.Send()
}

// CreateWorkteamWithContext is the same as CreateWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) CreateWorkteamWithContext(ctx aws.Context, input *CreateWorkteamInput, opts ...request.Option) (*CreateWorkteamOutput, error) {
	req, out := c.CreateWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAction = "DeleteAction"

// DeleteActionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAction for more information on using the DeleteAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteActionRequest method.
//    req, resp := client.DeleteActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAction
func (c *SageMaker) DeleteActionRequest(input *DeleteActionInput) (req *request.Request, output *DeleteActionOutput) {
	op := &request.Operation{
		Name:       opDeleteAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteActionInput{}
	}

	output = &DeleteActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAction API operation for Amazon SageMaker Service.
//
// Deletes an action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteAction for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAction
func (c *SageMaker) DeleteAction(input *DeleteActionInput) (*DeleteActionOutput, error) {
	req, out := c.DeleteActionRequest(input)
	return out, req.Send()
}

// DeleteActionWithContext is the same as DeleteAction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteActionWithContext(ctx aws.Context, input *DeleteActionInput, opts ...request.Option) (*DeleteActionOutput, error) {
	req, out := c.DeleteActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlgorithm = "DeleteAlgorithm"

// DeleteAlgorithmRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlgorithm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlgorithm for more information on using the DeleteAlgorithm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAlgorithmRequest method.
//    req, resp := client.DeleteAlgorithmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm
func (c *SageMaker) DeleteAlgorithmRequest(input *DeleteAlgorithmInput) (req *request.Request, output *DeleteAlgorithmOutput) {
	op := &request.Operation{
		Name:       opDeleteAlgorithm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAlgorithmInput{}
	}

	output = &DeleteAlgorithmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlgorithm API operation for Amazon SageMaker Service.
//
// Removes the specified algorithm from your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteAlgorithm for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm
func (c *SageMaker) DeleteAlgorithm(input *DeleteAlgorithmInput) (*DeleteAlgorithmOutput, error) {
	req, out := c.DeleteAlgorithmRequest(input)
	return out, req.Send()
}

// DeleteAlgorithmWithContext is the same as DeleteAlgorithm with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlgorithm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteAlgorithmWithContext(ctx aws.Context, input *DeleteAlgorithmInput, opts ...request.Option) (*DeleteAlgorithmOutput, error) {
	req, out := c.DeleteAlgorithmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApp for more information on using the DeleteApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppRequest method.
//    req, resp := client.DeleteAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteApp
func (c *SageMaker) DeleteAppRequest(input *DeleteAppInput) (req *request.Request, output *DeleteAppOutput) {
	op := &request.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	output = &DeleteAppOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApp API operation for Amazon SageMaker Service.
//
// Used to stop and delete an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteApp for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteApp
func (c *SageMaker) DeleteApp(input *DeleteAppInput) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	return out, req.Send()
}

// DeleteAppWithContext is the same as DeleteApp with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteAppWithContext(ctx aws.Context, input *DeleteAppInput, opts ...request.Option) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAppImageConfig = "DeleteAppImageConfig"

// DeleteAppImageConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAppImageConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAppImageConfig for more information on using the DeleteAppImageConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppImageConfigRequest method.
//    req, resp := client.DeleteAppImageConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAppImageConfig
func (c *SageMaker) DeleteAppImageConfigRequest(input *DeleteAppImageConfigInput) (req *request.Request, output *DeleteAppImageConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteAppImageConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppImageConfigInput{}
	}

	output = &DeleteAppImageConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAppImageConfig API operation for Amazon SageMaker Service.
//
// Deletes an AppImageConfig.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteAppImageConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAppImageConfig
func (c *SageMaker) DeleteAppImageConfig(input *DeleteAppImageConfigInput) (*DeleteAppImageConfigOutput, error) {
	req, out := c.DeleteAppImageConfigRequest(input)
	return out, req.Send()
}

// DeleteAppImageConfigWithContext is the same as DeleteAppImageConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAppImageConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteAppImageConfigWithContext(ctx aws.Context, input *DeleteAppImageConfigInput, opts ...request.Option) (*DeleteAppImageConfigOutput, error) {
	req, out := c.DeleteAppImageConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteArtifact = "DeleteArtifact"

// DeleteArtifactRequest generates a "aws/request.Request" representing the
// client's request for the DeleteArtifact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteArtifact for more information on using the DeleteArtifact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteArtifactRequest method.
//    req, resp := client.DeleteArtifactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteArtifact
func (c *SageMaker) DeleteArtifactRequest(input *DeleteArtifactInput) (req *request.Request, output *DeleteArtifactOutput) {
	op := &request.Operation{
		Name:       opDeleteArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteArtifactInput{}
	}

	output = &DeleteArtifactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteArtifact API operation for Amazon SageMaker Service.
//
// Deletes an artifact. Either ArtifactArn or Source must be specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteArtifact for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteArtifact
func (c *SageMaker) DeleteArtifact(input *DeleteArtifactInput) (*DeleteArtifactOutput, error) {
	req, out := c.DeleteArtifactRequest(input)
	return out, req.Send()
}

// DeleteArtifactWithContext is the same as DeleteArtifact with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteArtifact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteArtifactWithContext(ctx aws.Context, input *DeleteArtifactInput, opts ...request.Option) (*DeleteArtifactOutput, error) {
	req, out := c.DeleteArtifactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssociation = "DeleteAssociation"

// DeleteAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssociation for more information on using the DeleteAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssociationRequest method.
//    req, resp := client.DeleteAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAssociation
func (c *SageMaker) DeleteAssociationRequest(input *DeleteAssociationInput) (req *request.Request, output *DeleteAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssociationInput{}
	}

	output = &DeleteAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAssociation API operation for Amazon SageMaker Service.
//
// Deletes an association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteAssociation for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAssociation
func (c *SageMaker) DeleteAssociation(input *DeleteAssociationInput) (*DeleteAssociationOutput, error) {
	req, out := c.DeleteAssociationRequest(input)
	return out, req.Send()
}

// DeleteAssociationWithContext is the same as DeleteAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteAssociationWithContext(ctx aws.Context, input *DeleteAssociationInput, opts ...request.Option) (*DeleteAssociationOutput, error) {
	req, out := c.DeleteAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCodeRepository = "DeleteCodeRepository"

// DeleteCodeRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCodeRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCodeRepository for more information on using the DeleteCodeRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCodeRepositoryRequest method.
//    req, resp := client.DeleteCodeRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository
func (c *SageMaker) DeleteCodeRepositoryRequest(input *DeleteCodeRepositoryInput) (req *request.Request, output *DeleteCodeRepositoryOutput) {
	op := &request.Operation{
		Name:       opDeleteCodeRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCodeRepositoryInput{}
	}

	output = &DeleteCodeRepositoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCodeRepository API operation for Amazon SageMaker Service.
//
// Deletes the specified Git repository from your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteCodeRepository for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository
func (c *SageMaker) DeleteCodeRepository(input *DeleteCodeRepositoryInput) (*DeleteCodeRepositoryOutput, error) {
	req, out := c.DeleteCodeRepositoryRequest(input)
	return out, req.Send()
}

// DeleteCodeRepositoryWithContext is the same as DeleteCodeRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCodeRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteCodeRepositoryWithContext(ctx aws.Context, input *DeleteCodeRepositoryInput, opts ...request.Option) (*DeleteCodeRepositoryOutput, error) {
	req, out := c.DeleteCodeRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContext = "DeleteContext"

// DeleteContextRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContext operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContext for more information on using the DeleteContext
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteContextRequest method.
//    req, resp := client.DeleteContextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteContext
func (c *SageMaker) DeleteContextRequest(input *DeleteContextInput) (req *request.Request, output *DeleteContextOutput) {
	op := &request.Operation{
		Name:       opDeleteContext,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContextInput{}
	}

	output = &DeleteContextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteContext API operation for Amazon SageMaker Service.
//
// Deletes an context.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteContext for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteContext
func (c *SageMaker) DeleteContext(input *DeleteContextInput) (*DeleteContextOutput, error) {
	req, out := c.DeleteContextRequest(input)
	return out, req.Send()
}

// DeleteContextWithContext is the same as DeleteContext with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContext for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteContextWithContext(ctx aws.Context, input *DeleteContextInput, opts ...request.Option) (*DeleteContextOutput, error) {
	req, out := c.DeleteContextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataQualityJobDefinition = "DeleteDataQualityJobDefinition"

// DeleteDataQualityJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataQualityJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataQualityJobDefinition for more information on using the DeleteDataQualityJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataQualityJobDefinitionRequest method.
//    req, resp := client.DeleteDataQualityJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDataQualityJobDefinition
func (c *SageMaker) DeleteDataQualityJobDefinitionRequest(input *DeleteDataQualityJobDefinitionInput) (req *request.Request, output *DeleteDataQualityJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteDataQualityJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDataQualityJobDefinitionInput{}
	}

	output = &DeleteDataQualityJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataQualityJobDefinition API operation for Amazon SageMaker Service.
//
// Deletes a data quality monitoring job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteDataQualityJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDataQualityJobDefinition
func (c *SageMaker) DeleteDataQualityJobDefinition(input *DeleteDataQualityJobDefinitionInput) (*DeleteDataQualityJobDefinitionOutput, error) {
	req, out := c.DeleteDataQualityJobDefinitionRequest(input)
	return out, req.Send()
}

// DeleteDataQualityJobDefinitionWithContext is the same as DeleteDataQualityJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataQualityJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteDataQualityJobDefinitionWithContext(ctx aws.Context, input *DeleteDataQualityJobDefinitionInput, opts ...request.Option) (*DeleteDataQualityJobDefinitionOutput, error) {
	req, out := c.DeleteDataQualityJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeviceFleet = "DeleteDeviceFleet"

// DeleteDeviceFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeviceFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeviceFleet for more information on using the DeleteDeviceFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeviceFleetRequest method.
//    req, resp := client.DeleteDeviceFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDeviceFleet
func (c *SageMaker) DeleteDeviceFleetRequest(input *DeleteDeviceFleetInput) (req *request.Request, output *DeleteDeviceFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteDeviceFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeviceFleetInput{}
	}

	output = &DeleteDeviceFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeviceFleet API operation for Amazon SageMaker Service.
//
// Deletes a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteDeviceFleet for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDeviceFleet
func (c *SageMaker) DeleteDeviceFleet(input *DeleteDeviceFleetInput) (*DeleteDeviceFleetOutput, error) {
	req, out := c.DeleteDeviceFleetRequest(input)
	return out, req.Send()
}

// DeleteDeviceFleetWithContext is the same as DeleteDeviceFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeviceFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteDeviceFleetWithContext(ctx aws.Context, input *DeleteDeviceFleetInput, opts ...request.Option) (*DeleteDeviceFleetOutput, error) {
	req, out := c.DeleteDeviceFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainRequest method.
//    req, resp := client.DeleteDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDomain
func (c *SageMaker) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDomain API operation for Amazon SageMaker Service.
//
// Used to delete a domain. If you onboarded with IAM mode, you will need to
// delete your domain to onboard again using SSO. Use with caution. All of the
// members of the domain will lose access to their EFS volume, including data,
// notebooks, and other artifacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDomain
func (c *SageMaker) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint
func (c *SageMaker) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpoint API operation for Amazon SageMaker Service.
//
// Deletes an endpoint. Amazon SageMaker frees up all of the resources that
// were deployed when the endpoint was created.
//
// Amazon SageMaker retires any custom KMS key grants associated with the endpoint,
// meaning you don't need to use the RevokeGrant (http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html)
// API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint
func (c *SageMaker) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpointConfig = "DeleteEndpointConfig"

// DeleteEndpointConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpointConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpointConfig for more information on using the DeleteEndpointConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointConfigRequest method.
//    req, resp := client.DeleteEndpointConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig
func (c *SageMaker) DeleteEndpointConfigRequest(input *DeleteEndpointConfigInput) (req *request.Request, output *DeleteEndpointConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpointConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointConfigInput{}
	}

	output = &DeleteEndpointConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpointConfig API operation for Amazon SageMaker Service.
//
// Deletes an endpoint configuration. The DeleteEndpointConfig API deletes only
// the specified configuration. It does not delete endpoints created using the
// configuration.
//
// You must not delete an EndpointConfig in use by an endpoint that is live
// or while the UpdateEndpoint or CreateEndpoint operations are being performed
// on the endpoint. If you delete the EndpointConfig of an endpoint that is
// active or being created or updated you may lose visibility into the instance
// type the endpoint is using. The endpoint must be deleted in order to stop
// incurring charges.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteEndpointConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig
func (c *SageMaker) DeleteEndpointConfig(input *DeleteEndpointConfigInput) (*DeleteEndpointConfigOutput, error) {
	req, out := c.DeleteEndpointConfigRequest(input)
	return out, req.Send()
}

// DeleteEndpointConfigWithContext is the same as DeleteEndpointConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpointConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteEndpointConfigWithContext(ctx aws.Context, input *DeleteEndpointConfigInput, opts ...request.Option) (*DeleteEndpointConfigOutput, error) {
	req, out := c.DeleteEndpointConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteExperiment = "DeleteExperiment"

// DeleteExperimentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteExperiment for more information on using the DeleteExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteExperimentRequest method.
//    req, resp := client.DeleteExperimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment
func (c *SageMaker) DeleteExperimentRequest(input *DeleteExperimentInput) (req *request.Request, output *DeleteExperimentOutput) {
	op := &request.Operation{
		Name:       opDeleteExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteExperimentInput{}
	}

	output = &DeleteExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteExperiment API operation for Amazon SageMaker Service.
//
// Deletes an Amazon SageMaker experiment. All trials associated with the experiment
// must be deleted first. Use the ListTrials API to get a list of the trials
// associated with the experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteExperiment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment
func (c *SageMaker) DeleteExperiment(input *DeleteExperimentInput) (*DeleteExperimentOutput, error) {
	req, out := c.DeleteExperimentRequest(input)
	return out, req.Send()
}

// DeleteExperimentWithContext is the same as DeleteExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteExperimentWithContext(ctx aws.Context, input *DeleteExperimentInput, opts ...request.Option) (*DeleteExperimentOutput, error) {
	req, out := c.DeleteExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFeatureGroup = "DeleteFeatureGroup"

// DeleteFeatureGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFeatureGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFeatureGroup for more information on using the DeleteFeatureGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFeatureGroupRequest method.
//    req, resp := client.DeleteFeatureGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFeatureGroup
func (c *SageMaker) DeleteFeatureGroupRequest(input *DeleteFeatureGroupInput) (req *request.Request, output *DeleteFeatureGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteFeatureGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFeatureGroupInput{}
	}

	output = &DeleteFeatureGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFeatureGroup API operation for Amazon SageMaker Service.
//
// Delete the FeatureGroup and any data that was written to the OnlineStore
// of the FeatureGroup. Data cannot be accessed from the OnlineStore immediately
// after DeleteFeatureGroup is called.
//
// Data written into the OfflineStore will not be deleted. The AWS Glue database
// and tables that are automatically created for your OfflineStore are not deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteFeatureGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFeatureGroup
func (c *SageMaker) DeleteFeatureGroup(input *DeleteFeatureGroupInput) (*DeleteFeatureGroupOutput, error) {
	req, out := c.DeleteFeatureGroupRequest(input)
	return out, req.Send()
}

// DeleteFeatureGroupWithContext is the same as DeleteFeatureGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFeatureGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteFeatureGroupWithContext(ctx aws.Context, input *DeleteFeatureGroupInput, opts ...request.Option) (*DeleteFeatureGroupOutput, error) {
	req, out := c.DeleteFeatureGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlowDefinition = "DeleteFlowDefinition"

// DeleteFlowDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlowDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlowDefinition for more information on using the DeleteFlowDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFlowDefinitionRequest method.
//    req, resp := client.DeleteFlowDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFlowDefinition
func (c *SageMaker) DeleteFlowDefinitionRequest(input *DeleteFlowDefinitionInput) (req *request.Request, output *DeleteFlowDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteFlowDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFlowDefinitionInput{}
	}

	output = &DeleteFlowDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFlowDefinition API operation for Amazon SageMaker Service.
//
// Deletes the specified flow definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteFlowDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFlowDefinition
func (c *SageMaker) DeleteFlowDefinition(input *DeleteFlowDefinitionInput) (*DeleteFlowDefinitionOutput, error) {
	req, out := c.DeleteFlowDefinitionRequest(input)
	return out, req.Send()
}

// DeleteFlowDefinitionWithContext is the same as DeleteFlowDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlowDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteFlowDefinitionWithContext(ctx aws.Context, input *DeleteFlowDefinitionInput, opts ...request.Option) (*DeleteFlowDefinitionOutput, error) {
	req, out := c.DeleteFlowDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHumanTaskUi = "DeleteHumanTaskUi"

// DeleteHumanTaskUiRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHumanTaskUi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHumanTaskUi for more information on using the DeleteHumanTaskUi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteHumanTaskUiRequest method.
//    req, resp := client.DeleteHumanTaskUiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHumanTaskUi
func (c *SageMaker) DeleteHumanTaskUiRequest(input *DeleteHumanTaskUiInput) (req *request.Request, output *DeleteHumanTaskUiOutput) {
	op := &request.Operation{
		Name:       opDeleteHumanTaskUi,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHumanTaskUiInput{}
	}

	output = &DeleteHumanTaskUiOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHumanTaskUi API operation for Amazon SageMaker Service.
//
// Use this operation to delete a human task user interface (worker task template).
//
// To see a list of human task user interfaces (work task templates) in your
// account, use . When you delete a worker task template, it no longer appears
// when you call ListHumanTaskUis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteHumanTaskUi for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHumanTaskUi
func (c *SageMaker) DeleteHumanTaskUi(input *DeleteHumanTaskUiInput) (*DeleteHumanTaskUiOutput, error) {
	req, out := c.DeleteHumanTaskUiRequest(input)
	return out, req.Send()
}

// DeleteHumanTaskUiWithContext is the same as DeleteHumanTaskUi with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHumanTaskUi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteHumanTaskUiWithContext(ctx aws.Context, input *DeleteHumanTaskUiInput, opts ...request.Option) (*DeleteHumanTaskUiOutput, error) {
	req, out := c.DeleteHumanTaskUiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImage = "DeleteImage"

// DeleteImageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImage for more information on using the DeleteImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteImageRequest method.
//    req, resp := client.DeleteImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImage
func (c *SageMaker) DeleteImageRequest(input *DeleteImageInput) (req *request.Request, output *DeleteImageOutput) {
	op := &request.Operation{
		Name:       opDeleteImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteImageInput{}
	}

	output = &DeleteImageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteImage API operation for Amazon SageMaker Service.
//
// Deletes a SageMaker image and all versions of the image. The container images
// aren't deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteImage for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImage
func (c *SageMaker) DeleteImage(input *DeleteImageInput) (*DeleteImageOutput, error) {
	req, out := c.DeleteImageRequest(input)
	return out, req.Send()
}

// DeleteImageWithContext is the same as DeleteImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteImageWithContext(ctx aws.Context, input *DeleteImageInput, opts ...request.Option) (*DeleteImageOutput, error) {
	req, out := c.DeleteImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImageVersion = "DeleteImageVersion"

// DeleteImageVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImageVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImageVersion for more information on using the DeleteImageVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteImageVersionRequest method.
//    req, resp := client.DeleteImageVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImageVersion
func (c *SageMaker) DeleteImageVersionRequest(input *DeleteImageVersionInput) (req *request.Request, output *DeleteImageVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteImageVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteImageVersionInput{}
	}

	output = &DeleteImageVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteImageVersion API operation for Amazon SageMaker Service.
//
// Deletes a version of a SageMaker image. The container image the version represents
// isn't deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteImageVersion for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImageVersion
func (c *SageMaker) DeleteImageVersion(input *DeleteImageVersionInput) (*DeleteImageVersionOutput, error) {
	req, out := c.DeleteImageVersionRequest(input)
	return out, req.Send()
}

// DeleteImageVersionWithContext is the same as DeleteImageVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImageVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteImageVersionWithContext(ctx aws.Context, input *DeleteImageVersionInput, opts ...request.Option) (*DeleteImageVersionOutput, error) {
	req, out := c.DeleteImageVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModel = "DeleteModel"

// DeleteModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModel for more information on using the DeleteModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelRequest method.
//    req, resp := client.DeleteModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel
func (c *SageMaker) DeleteModelRequest(input *DeleteModelInput) (req *request.Request, output *DeleteModelOutput) {
	op := &request.Operation{
		Name:       opDeleteModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelInput{}
	}

	output = &DeleteModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModel API operation for Amazon SageMaker Service.
//
// Deletes a model. The DeleteModel API deletes only the model entry that was
// created in Amazon SageMaker when you called the CreateModel API. It does
// not delete model artifacts, inference code, or the IAM role that you specified
// when creating the model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteModel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel
func (c *SageMaker) DeleteModel(input *DeleteModelInput) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	return out, req.Send()
}

// DeleteModelWithContext is the same as DeleteModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteModelWithContext(ctx aws.Context, input *DeleteModelInput, opts ...request.Option) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModelBiasJobDefinition = "DeleteModelBiasJobDefinition"

// DeleteModelBiasJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModelBiasJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModelBiasJobDefinition for more information on using the DeleteModelBiasJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelBiasJobDefinitionRequest method.
//    req, resp := client.DeleteModelBiasJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelBiasJobDefinition
func (c *SageMaker) DeleteModelBiasJobDefinitionRequest(input *DeleteModelBiasJobDefinitionInput) (req *request.Request, output *DeleteModelBiasJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteModelBiasJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelBiasJobDefinitionInput{}
	}

	output = &DeleteModelBiasJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModelBiasJobDefinition API operation for Amazon SageMaker Service.
//
// Deletes an Amazon SageMaker model bias job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteModelBiasJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelBiasJobDefinition
func (c *SageMaker) DeleteModelBiasJobDefinition(input *DeleteModelBiasJobDefinitionInput) (*DeleteModelBiasJobDefinitionOutput, error) {
	req, out := c.DeleteModelBiasJobDefinitionRequest(input)
	return out, req.Send()
}

// DeleteModelBiasJobDefinitionWithContext is the same as DeleteModelBiasJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModelBiasJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteModelBiasJobDefinitionWithContext(ctx aws.Context, input *DeleteModelBiasJobDefinitionInput, opts ...request.Option) (*DeleteModelBiasJobDefinitionOutput, error) {
	req, out := c.DeleteModelBiasJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModelExplainabilityJobDefinition = "DeleteModelExplainabilityJobDefinition"

// DeleteModelExplainabilityJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModelExplainabilityJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModelExplainabilityJobDefinition for more information on using the DeleteModelExplainabilityJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelExplainabilityJobDefinitionRequest method.
//    req, resp := client.DeleteModelExplainabilityJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelExplainabilityJobDefinition
func (c *SageMaker) DeleteModelExplainabilityJobDefinitionRequest(input *DeleteModelExplainabilityJobDefinitionInput) (req *request.Request, output *DeleteModelExplainabilityJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteModelExplainabilityJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelExplainabilityJobDefinitionInput{}
	}

	output = &DeleteModelExplainabilityJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModelExplainabilityJobDefinition API operation for Amazon SageMaker Service.
//
// Deletes an Amazon SageMaker model explainability job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteModelExplainabilityJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelExplainabilityJobDefinition
func (c *SageMaker) DeleteModelExplainabilityJobDefinition(input *DeleteModelExplainabilityJobDefinitionInput) (*DeleteModelExplainabilityJobDefinitionOutput, error) {
	req, out := c.DeleteModelExplainabilityJobDefinitionRequest(input)
	return out, req.Send()
}

// DeleteModelExplainabilityJobDefinitionWithContext is the same as DeleteModelExplainabilityJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModelExplainabilityJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteModelExplainabilityJobDefinitionWithContext(ctx aws.Context, input *DeleteModelExplainabilityJobDefinitionInput, opts ...request.Option) (*DeleteModelExplainabilityJobDefinitionOutput, error) {
	req, out := c.DeleteModelExplainabilityJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModelPackage = "DeleteModelPackage"

// DeleteModelPackageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModelPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModelPackage for more information on using the DeleteModelPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelPackageRequest method.
//    req, resp := client.DeleteModelPackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage
func (c *SageMaker) DeleteModelPackageRequest(input *DeleteModelPackageInput) (req *request.Request, output *DeleteModelPackageOutput) {
	op := &request.Operation{
		Name:       opDeleteModelPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelPackageInput{}
	}

	output = &DeleteModelPackageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModelPackage API operation for Amazon SageMaker Service.
//
// Deletes a model package.
//
// A model package is used to create Amazon SageMaker models or list on AWS
// Marketplace. Buyers can subscribe to model packages listed on AWS Marketplace
// to create models in Amazon SageMaker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteModelPackage for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when you attempted to modify an experiment, trial, or
//   trial component.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage
func (c *SageMaker) DeleteModelPackage(input *DeleteModelPackageInput) (*DeleteModelPackageOutput, error) {
	req, out := c.DeleteModelPackageRequest(input)
	return out, req.Send()
}

// DeleteModelPackageWithContext is the same as DeleteModelPackage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModelPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteModelPackageWithContext(ctx aws.Context, input *DeleteModelPackageInput, opts ...request.Option) (*DeleteModelPackageOutput, error) {
	req, out := c.DeleteModelPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModelPackageGroup = "DeleteModelPackageGroup"

// DeleteModelPackageGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModelPackageGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModelPackageGroup for more information on using the DeleteModelPackageGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelPackageGroupRequest method.
//    req, resp := client.DeleteModelPackageGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroup
func (c *SageMaker) DeleteModelPackageGroupRequest(input *DeleteModelPackageGroupInput) (req *request.Request, output *DeleteModelPackageGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteModelPackageGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelPackageGroupInput{}
	}

	output = &DeleteModelPackageGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModelPackageGroup API operation for Amazon SageMaker Service.
//
// Deletes the specified model group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteModelPackageGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroup
func (c *SageMaker) DeleteModelPackageGroup(input *DeleteModelPackageGroupInput) (*DeleteModelPackageGroupOutput, error) {
	req, out := c.DeleteModelPackageGroupRequest(input)
	return out, req.Send()
}

// DeleteModelPackageGroupWithContext is the same as DeleteModelPackageGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModelPackageGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteModelPackageGroupWithContext(ctx aws.Context, input *DeleteModelPackageGroupInput, opts ...request.Option) (*DeleteModelPackageGroupOutput, error) {
	req, out := c.DeleteModelPackageGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModelPackageGroupPolicy = "DeleteModelPackageGroupPolicy"

// DeleteModelPackageGroupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModelPackageGroupPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModelPackageGroupPolicy for more information on using the DeleteModelPackageGroupPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelPackageGroupPolicyRequest method.
//    req, resp := client.DeleteModelPackageGroupPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroupPolicy
func (c *SageMaker) DeleteModelPackageGroupPolicyRequest(input *DeleteModelPackageGroupPolicyInput) (req *request.Request, output *DeleteModelPackageGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteModelPackageGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelPackageGroupPolicyInput{}
	}

	output = &DeleteModelPackageGroupPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModelPackageGroupPolicy API operation for Amazon SageMaker Service.
//
// Deletes a model group resource policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteModelPackageGroupPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroupPolicy
func (c *SageMaker) DeleteModelPackageGroupPolicy(input *DeleteModelPackageGroupPolicyInput) (*DeleteModelPackageGroupPolicyOutput, error) {
	req, out := c.DeleteModelPackageGroupPolicyRequest(input)
	return out, req.Send()
}

// DeleteModelPackageGroupPolicyWithContext is the same as DeleteModelPackageGroupPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModelPackageGroupPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteModelPackageGroupPolicyWithContext(ctx aws.Context, input *DeleteModelPackageGroupPolicyInput, opts ...request.Option) (*DeleteModelPackageGroupPolicyOutput, error) {
	req, out := c.DeleteModelPackageGroupPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModelQualityJobDefinition = "DeleteModelQualityJobDefinition"

// DeleteModelQualityJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModelQualityJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModelQualityJobDefinition for more information on using the DeleteModelQualityJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelQualityJobDefinitionRequest method.
//    req, resp := client.DeleteModelQualityJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelQualityJobDefinition
func (c *SageMaker) DeleteModelQualityJobDefinitionRequest(input *DeleteModelQualityJobDefinitionInput) (req *request.Request, output *DeleteModelQualityJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteModelQualityJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteModelQualityJobDefinitionInput{}
	}

	output = &DeleteModelQualityJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModelQualityJobDefinition API operation for Amazon SageMaker Service.
//
// Deletes the secified model quality monitoring job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteModelQualityJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelQualityJobDefinition
func (c *SageMaker) DeleteModelQualityJobDefinition(input *DeleteModelQualityJobDefinitionInput) (*DeleteModelQualityJobDefinitionOutput, error) {
	req, out := c.DeleteModelQualityJobDefinitionRequest(input)
	return out, req.Send()
}

// DeleteModelQualityJobDefinitionWithContext is the same as DeleteModelQualityJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModelQualityJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteModelQualityJobDefinitionWithContext(ctx aws.Context, input *DeleteModelQualityJobDefinitionInput, opts ...request.Option) (*DeleteModelQualityJobDefinitionOutput, error) {
	req, out := c.DeleteModelQualityJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMonitoringSchedule = "DeleteMonitoringSchedule"

// DeleteMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMonitoringSchedule for more information on using the DeleteMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMonitoringScheduleRequest method.
//    req, resp := client.DeleteMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule
func (c *SageMaker) DeleteMonitoringScheduleRequest(input *DeleteMonitoringScheduleInput) (req *request.Request, output *DeleteMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMonitoringScheduleInput{}
	}

	output = &DeleteMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Deletes a monitoring schedule. Also stops the schedule had not already been
// stopped. This does not delete the job execution history of the monitoring
// schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule
func (c *SageMaker) DeleteMonitoringSchedule(input *DeleteMonitoringScheduleInput) (*DeleteMonitoringScheduleOutput, error) {
	req, out := c.DeleteMonitoringScheduleRequest(input)
	return out, req.Send()
}

// DeleteMonitoringScheduleWithContext is the same as DeleteMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteMonitoringScheduleWithContext(ctx aws.Context, input *DeleteMonitoringScheduleInput, opts ...request.Option) (*DeleteMonitoringScheduleOutput, error) {
	req, out := c.DeleteMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotebookInstance = "DeleteNotebookInstance"

// DeleteNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotebookInstance for more information on using the DeleteNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNotebookInstanceRequest method.
//    req, resp := client.DeleteNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance
func (c *SageMaker) DeleteNotebookInstanceRequest(input *DeleteNotebookInstanceInput) (req *request.Request, output *DeleteNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotebookInstanceInput{}
	}

	output = &DeleteNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNotebookInstance API operation for Amazon SageMaker Service.
//
// Deletes an Amazon SageMaker notebook instance. Before you can delete a notebook
// instance, you must call the StopNotebookInstance API.
//
// When you delete a notebook instance, you lose all of your data. Amazon SageMaker
// removes the ML compute instance, and deletes the ML storage volume and the
// network interface associated with the notebook instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteNotebookInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance
func (c *SageMaker) DeleteNotebookInstance(input *DeleteNotebookInstanceInput) (*DeleteNotebookInstanceOutput, error) {
	req, out := c.DeleteNotebookInstanceRequest(input)
	return out, req.Send()
}

// DeleteNotebookInstanceWithContext is the same as DeleteNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteNotebookInstanceWithContext(ctx aws.Context, input *DeleteNotebookInstanceInput, opts ...request.Option) (*DeleteNotebookInstanceOutput, error) {
	req, out := c.DeleteNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNotebookInstanceLifecycleConfig = "DeleteNotebookInstanceLifecycleConfig"

// DeleteNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNotebookInstanceLifecycleConfig for more information on using the DeleteNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.DeleteNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig
func (c *SageMaker) DeleteNotebookInstanceLifecycleConfigRequest(input *DeleteNotebookInstanceLifecycleConfigInput) (req *request.Request, output *DeleteNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotebookInstanceLifecycleConfigInput{}
	}

	output = &DeleteNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Deletes a notebook instance lifecycle configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteNotebookInstanceLifecycleConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig
func (c *SageMaker) DeleteNotebookInstanceLifecycleConfig(input *DeleteNotebookInstanceLifecycleConfigInput) (*DeleteNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DeleteNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// DeleteNotebookInstanceLifecycleConfigWithContext is the same as DeleteNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *DeleteNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*DeleteNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DeleteNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePipeline = "DeletePipeline"

// DeletePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeletePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePipeline for more information on using the DeletePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePipelineRequest method.
//    req, resp := client.DeletePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePipeline
func (c *SageMaker) DeletePipelineRequest(input *DeletePipelineInput) (req *request.Request, output *DeletePipelineOutput) {
	op := &request.Operation{
		Name:       opDeletePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePipelineInput{}
	}

	output = &DeletePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePipeline API operation for Amazon SageMaker Service.
//
// Deletes a pipeline if there are no in-progress executions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeletePipeline for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePipeline
func (c *SageMaker) DeletePipeline(input *DeletePipelineInput) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	return out, req.Send()
}

// DeletePipelineWithContext is the same as DeletePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeletePipelineWithContext(ctx aws.Context, input *DeletePipelineInput, opts ...request.Option) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteProject
func (c *SageMaker) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProject API operation for Amazon SageMaker Service.
//
// Delete the specified project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteProject for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteProject
func (c *SageMaker) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags
func (c *SageMaker) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Amazon SageMaker Service.
//
// Deletes the specified tags from an Amazon SageMaker resource.
//
// To list a resource's tags, use the ListTags API.
//
// When you call this API to delete tags from a hyperparameter tuning job, the
// deleted tags are not removed from training jobs that the hyperparameter tuning
// job launched before you called this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags
func (c *SageMaker) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrial = "DeleteTrial"

// DeleteTrialRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrial operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrial for more information on using the DeleteTrial
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrialRequest method.
//    req, resp := client.DeleteTrialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial
func (c *SageMaker) DeleteTrialRequest(input *DeleteTrialInput) (req *request.Request, output *DeleteTrialOutput) {
	op := &request.Operation{
		Name:       opDeleteTrial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrialInput{}
	}

	output = &DeleteTrialOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrial API operation for Amazon SageMaker Service.
//
// Deletes the specified trial. All trial components that make up the trial
// must be deleted first. Use the DescribeTrialComponent API to get the list
// of trial components.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteTrial for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial
func (c *SageMaker) DeleteTrial(input *DeleteTrialInput) (*DeleteTrialOutput, error) {
	req, out := c.DeleteTrialRequest(input)
	return out, req.Send()
}

// DeleteTrialWithContext is the same as DeleteTrial with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrial for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteTrialWithContext(ctx aws.Context, input *DeleteTrialInput, opts ...request.Option) (*DeleteTrialOutput, error) {
	req, out := c.DeleteTrialRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrialComponent = "DeleteTrialComponent"

// DeleteTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrialComponent for more information on using the DeleteTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrialComponentRequest method.
//    req, resp := client.DeleteTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrialComponent
func (c *SageMaker) DeleteTrialComponentRequest(input *DeleteTrialComponentInput) (req *request.Request, output *DeleteTrialComponentOutput) {
	op := &request.Operation{
		Name:       opDeleteTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrialComponentInput{}
	}

	output = &DeleteTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrialComponent API operation for Amazon SageMaker Service.
//
// Deletes the specified trial component. A trial component must be disassociated
// from all trials before the trial component can be deleted. To disassociate
// a trial component from a trial, call the DisassociateTrialComponent API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrialComponent
func (c *SageMaker) DeleteTrialComponent(input *DeleteTrialComponentInput) (*DeleteTrialComponentOutput, error) {
	req, out := c.DeleteTrialComponentRequest(input)
	return out, req.Send()
}

// DeleteTrialComponentWithContext is the same as DeleteTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteTrialComponentWithContext(ctx aws.Context, input *DeleteTrialComponentInput, opts ...request.Option) (*DeleteTrialComponentOutput, error) {
	req, out := c.DeleteTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserProfile = "DeleteUserProfile"

// DeleteUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserProfile for more information on using the DeleteUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserProfileRequest method.
//    req, resp := client.DeleteUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile
func (c *SageMaker) DeleteUserProfileRequest(input *DeleteUserProfileInput) (req *request.Request, output *DeleteUserProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserProfileInput{}
	}

	output = &DeleteUserProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserProfile API operation for Amazon SageMaker Service.
//
// Deletes a user profile. When a user profile is deleted, the user loses access
// to their EFS volume, including data, notebooks, and other artifacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteUserProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile
func (c *SageMaker) DeleteUserProfile(input *DeleteUserProfileInput) (*DeleteUserProfileOutput, error) {
	req, out := c.DeleteUserProfileRequest(input)
	return out, req.Send()
}

// DeleteUserProfileWithContext is the same as DeleteUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteUserProfileWithContext(ctx aws.Context, input *DeleteUserProfileInput, opts ...request.Option) (*DeleteUserProfileOutput, error) {
	req, out := c.DeleteUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkforce = "DeleteWorkforce"

// DeleteWorkforceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkforce operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkforce for more information on using the DeleteWorkforce
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkforceRequest method.
//    req, resp := client.DeleteWorkforceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkforce
func (c *SageMaker) DeleteWorkforceRequest(input *DeleteWorkforceInput) (req *request.Request, output *DeleteWorkforceOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkforce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkforceInput{}
	}

	output = &DeleteWorkforceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkforce API operation for Amazon SageMaker Service.
//
// Use this operation to delete a workforce.
//
// If you want to create a new workforce in an AWS Region where a workforce
// already exists, use this operation to delete the existing workforce and then
// use to create a new workforce.
//
// If a private workforce contains one or more work teams, you must use the
// operation to delete all work teams before you delete the workforce. If you
// try to delete a workforce that contains one or more work teams, you will
// recieve a ResourceInUse error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteWorkforce for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkforce
func (c *SageMaker) DeleteWorkforce(input *DeleteWorkforceInput) (*DeleteWorkforceOutput, error) {
	req, out := c.DeleteWorkforceRequest(input)
	return out, req.Send()
}

// DeleteWorkforceWithContext is the same as DeleteWorkforce with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkforce for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteWorkforceWithContext(ctx aws.Context, input *DeleteWorkforceInput, opts ...request.Option) (*DeleteWorkforceOutput, error) {
	req, out := c.DeleteWorkforceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkteam = "DeleteWorkteam"

// DeleteWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkteam for more information on using the DeleteWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkteamRequest method.
//    req, resp := client.DeleteWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam
func (c *SageMaker) DeleteWorkteamRequest(input *DeleteWorkteamInput) (req *request.Request, output *DeleteWorkteamOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkteamInput{}
	}

	output = &DeleteWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteWorkteam API operation for Amazon SageMaker Service.
//
// Deletes an existing work team. This operation can't be undone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeleteWorkteam for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam
func (c *SageMaker) DeleteWorkteam(input *DeleteWorkteamInput) (*DeleteWorkteamOutput, error) {
	req, out := c.DeleteWorkteamRequest(input)
	return out, req.Send()
}

// DeleteWorkteamWithContext is the same as DeleteWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeleteWorkteamWithContext(ctx aws.Context, input *DeleteWorkteamInput, opts ...request.Option) (*DeleteWorkteamOutput, error) {
	req, out := c.DeleteWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterDevices = "DeregisterDevices"

// DeregisterDevicesRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterDevices for more information on using the DeregisterDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterDevicesRequest method.
//    req, resp := client.DeregisterDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeregisterDevices
func (c *SageMaker) DeregisterDevicesRequest(input *DeregisterDevicesInput) (req *request.Request, output *DeregisterDevicesOutput) {
	op := &request.Operation{
		Name:       opDeregisterDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterDevicesInput{}
	}

	output = &DeregisterDevicesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterDevices API operation for Amazon SageMaker Service.
//
// Deregisters the specified devices. After you deregister a device, you will
// need to re-register the devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DeregisterDevices for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeregisterDevices
func (c *SageMaker) DeregisterDevices(input *DeregisterDevicesInput) (*DeregisterDevicesOutput, error) {
	req, out := c.DeregisterDevicesRequest(input)
	return out, req.Send()
}

// DeregisterDevicesWithContext is the same as DeregisterDevices with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DeregisterDevicesWithContext(ctx aws.Context, input *DeregisterDevicesInput, opts ...request.Option) (*DeregisterDevicesOutput, error) {
	req, out := c.DeregisterDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAction = "DescribeAction"

// DescribeActionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAction for more information on using the DescribeAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeActionRequest method.
//    req, resp := client.DescribeActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAction
func (c *SageMaker) DescribeActionRequest(input *DescribeActionInput) (req *request.Request, output *DescribeActionOutput) {
	op := &request.Operation{
		Name:       opDescribeAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeActionInput{}
	}

	output = &DescribeActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAction API operation for Amazon SageMaker Service.
//
// Describes an action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeAction for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAction
func (c *SageMaker) DescribeAction(input *DescribeActionInput) (*DescribeActionOutput, error) {
	req, out := c.DescribeActionRequest(input)
	return out, req.Send()
}

// DescribeActionWithContext is the same as DescribeAction with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeActionWithContext(ctx aws.Context, input *DescribeActionInput, opts ...request.Option) (*DescribeActionOutput, error) {
	req, out := c.DescribeActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlgorithm = "DescribeAlgorithm"

// DescribeAlgorithmRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlgorithm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlgorithm for more information on using the DescribeAlgorithm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAlgorithmRequest method.
//    req, resp := client.DescribeAlgorithmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm
func (c *SageMaker) DescribeAlgorithmRequest(input *DescribeAlgorithmInput) (req *request.Request, output *DescribeAlgorithmOutput) {
	op := &request.Operation{
		Name:       opDescribeAlgorithm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAlgorithmInput{}
	}

	output = &DescribeAlgorithmOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlgorithm API operation for Amazon SageMaker Service.
//
// Returns a description of the specified algorithm that is in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeAlgorithm for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm
func (c *SageMaker) DescribeAlgorithm(input *DescribeAlgorithmInput) (*DescribeAlgorithmOutput, error) {
	req, out := c.DescribeAlgorithmRequest(input)
	return out, req.Send()
}

// DescribeAlgorithmWithContext is the same as DescribeAlgorithm with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlgorithm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeAlgorithmWithContext(ctx aws.Context, input *DescribeAlgorithmInput, opts ...request.Option) (*DescribeAlgorithmOutput, error) {
	req, out := c.DescribeAlgorithmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApp = "DescribeApp"

// DescribeAppRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApp for more information on using the DescribeApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAppRequest method.
//    req, resp := client.DescribeAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp
func (c *SageMaker) DescribeAppRequest(input *DescribeAppInput) (req *request.Request, output *DescribeAppOutput) {
	op := &request.Operation{
		Name:       opDescribeApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAppInput{}
	}

	output = &DescribeAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApp API operation for Amazon SageMaker Service.
//
// Describes the app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeApp for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp
func (c *SageMaker) DescribeApp(input *DescribeAppInput) (*DescribeAppOutput, error) {
	req, out := c.DescribeAppRequest(input)
	return out, req.Send()
}

// DescribeAppWithContext is the same as DescribeApp with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeAppWithContext(ctx aws.Context, input *DescribeAppInput, opts ...request.Option) (*DescribeAppOutput, error) {
	req, out := c.DescribeAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAppImageConfig = "DescribeAppImageConfig"

// DescribeAppImageConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAppImageConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAppImageConfig for more information on using the DescribeAppImageConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAppImageConfigRequest method.
//    req, resp := client.DescribeAppImageConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAppImageConfig
func (c *SageMaker) DescribeAppImageConfigRequest(input *DescribeAppImageConfigInput) (req *request.Request, output *DescribeAppImageConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeAppImageConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAppImageConfigInput{}
	}

	output = &DescribeAppImageConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAppImageConfig API operation for Amazon SageMaker Service.
//
// Describes an AppImageConfig.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeAppImageConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAppImageConfig
func (c *SageMaker) DescribeAppImageConfig(input *DescribeAppImageConfigInput) (*DescribeAppImageConfigOutput, error) {
	req, out := c.DescribeAppImageConfigRequest(input)
	return out, req.Send()
}

// DescribeAppImageConfigWithContext is the same as DescribeAppImageConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAppImageConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeAppImageConfigWithContext(ctx aws.Context, input *DescribeAppImageConfigInput, opts ...request.Option) (*DescribeAppImageConfigOutput, error) {
	req, out := c.DescribeAppImageConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeArtifact = "DescribeArtifact"

// DescribeArtifactRequest generates a "aws/request.Request" representing the
// client's request for the DescribeArtifact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeArtifact for more information on using the DescribeArtifact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeArtifactRequest method.
//    req, resp := client.DescribeArtifactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeArtifact
func (c *SageMaker) DescribeArtifactRequest(input *DescribeArtifactInput) (req *request.Request, output *DescribeArtifactOutput) {
	op := &request.Operation{
		Name:       opDescribeArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeArtifactInput{}
	}

	output = &DescribeArtifactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeArtifact API operation for Amazon SageMaker Service.
//
// Describes an artifact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeArtifact for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeArtifact
func (c *SageMaker) DescribeArtifact(input *DescribeArtifactInput) (*DescribeArtifactOutput, error) {
	req, out := c.DescribeArtifactRequest(input)
	return out, req.Send()
}

// DescribeArtifactWithContext is the same as DescribeArtifact with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeArtifact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeArtifactWithContext(ctx aws.Context, input *DescribeArtifactInput, opts ...request.Option) (*DescribeArtifactOutput, error) {
	req, out := c.DescribeArtifactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAutoMLJob = "DescribeAutoMLJob"

// DescribeAutoMLJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutoMLJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutoMLJob for more information on using the DescribeAutoMLJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAutoMLJobRequest method.
//    req, resp := client.DescribeAutoMLJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob
func (c *SageMaker) DescribeAutoMLJobRequest(input *DescribeAutoMLJobInput) (req *request.Request, output *DescribeAutoMLJobOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoMLJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutoMLJobInput{}
	}

	output = &DescribeAutoMLJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutoMLJob API operation for Amazon SageMaker Service.
//
// Returns information about an Amazon SageMaker job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeAutoMLJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob
func (c *SageMaker) DescribeAutoMLJob(input *DescribeAutoMLJobInput) (*DescribeAutoMLJobOutput, error) {
	req, out := c.DescribeAutoMLJobRequest(input)
	return out, req.Send()
}

// DescribeAutoMLJobWithContext is the same as DescribeAutoMLJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutoMLJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeAutoMLJobWithContext(ctx aws.Context, input *DescribeAutoMLJobInput, opts ...request.Option) (*DescribeAutoMLJobOutput, error) {
	req, out := c.DescribeAutoMLJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCodeRepository = "DescribeCodeRepository"

// DescribeCodeRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCodeRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCodeRepository for more information on using the DescribeCodeRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCodeRepositoryRequest method.
//    req, resp := client.DescribeCodeRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository
func (c *SageMaker) DescribeCodeRepositoryRequest(input *DescribeCodeRepositoryInput) (req *request.Request, output *DescribeCodeRepositoryOutput) {
	op := &request.Operation{
		Name:       opDescribeCodeRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCodeRepositoryInput{}
	}

	output = &DescribeCodeRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCodeRepository API operation for Amazon SageMaker Service.
//
// Gets details about the specified Git repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeCodeRepository for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository
func (c *SageMaker) DescribeCodeRepository(input *DescribeCodeRepositoryInput) (*DescribeCodeRepositoryOutput, error) {
	req, out := c.DescribeCodeRepositoryRequest(input)
	return out, req.Send()
}

// DescribeCodeRepositoryWithContext is the same as DescribeCodeRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCodeRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeCodeRepositoryWithContext(ctx aws.Context, input *DescribeCodeRepositoryInput, opts ...request.Option) (*DescribeCodeRepositoryOutput, error) {
	req, out := c.DescribeCodeRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCompilationJob = "DescribeCompilationJob"

// DescribeCompilationJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCompilationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCompilationJob for more information on using the DescribeCompilationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCompilationJobRequest method.
//    req, resp := client.DescribeCompilationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob
func (c *SageMaker) DescribeCompilationJobRequest(input *DescribeCompilationJobInput) (req *request.Request, output *DescribeCompilationJobOutput) {
	op := &request.Operation{
		Name:       opDescribeCompilationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCompilationJobInput{}
	}

	output = &DescribeCompilationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCompilationJob API operation for Amazon SageMaker Service.
//
// Returns information about a model compilation job.
//
// To create a model compilation job, use CreateCompilationJob. To get information
// about multiple model compilation jobs, use ListCompilationJobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeCompilationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob
func (c *SageMaker) DescribeCompilationJob(input *DescribeCompilationJobInput) (*DescribeCompilationJobOutput, error) {
	req, out := c.DescribeCompilationJobRequest(input)
	return out, req.Send()
}

// DescribeCompilationJobWithContext is the same as DescribeCompilationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCompilationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeCompilationJobWithContext(ctx aws.Context, input *DescribeCompilationJobInput, opts ...request.Option) (*DescribeCompilationJobOutput, error) {
	req, out := c.DescribeCompilationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContext = "DescribeContext"

// DescribeContextRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContext operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContext for more information on using the DescribeContext
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeContextRequest method.
//    req, resp := client.DescribeContextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeContext
func (c *SageMaker) DescribeContextRequest(input *DescribeContextInput) (req *request.Request, output *DescribeContextOutput) {
	op := &request.Operation{
		Name:       opDescribeContext,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeContextInput{}
	}

	output = &DescribeContextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeContext API operation for Amazon SageMaker Service.
//
// Describes a context.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeContext for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeContext
func (c *SageMaker) DescribeContext(input *DescribeContextInput) (*DescribeContextOutput, error) {
	req, out := c.DescribeContextRequest(input)
	return out, req.Send()
}

// DescribeContextWithContext is the same as DescribeContext with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContext for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeContextWithContext(ctx aws.Context, input *DescribeContextInput, opts ...request.Option) (*DescribeContextOutput, error) {
	req, out := c.DescribeContextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataQualityJobDefinition = "DescribeDataQualityJobDefinition"

// DescribeDataQualityJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataQualityJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataQualityJobDefinition for more information on using the DescribeDataQualityJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDataQualityJobDefinitionRequest method.
//    req, resp := client.DescribeDataQualityJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDataQualityJobDefinition
func (c *SageMaker) DescribeDataQualityJobDefinitionRequest(input *DescribeDataQualityJobDefinitionInput) (req *request.Request, output *DescribeDataQualityJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeDataQualityJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDataQualityJobDefinitionInput{}
	}

	output = &DescribeDataQualityJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataQualityJobDefinition API operation for Amazon SageMaker Service.
//
// Gets the details of a data quality monitoring job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeDataQualityJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDataQualityJobDefinition
func (c *SageMaker) DescribeDataQualityJobDefinition(input *DescribeDataQualityJobDefinitionInput) (*DescribeDataQualityJobDefinitionOutput, error) {
	req, out := c.DescribeDataQualityJobDefinitionRequest(input)
	return out, req.Send()
}

// DescribeDataQualityJobDefinitionWithContext is the same as DescribeDataQualityJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataQualityJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeDataQualityJobDefinitionWithContext(ctx aws.Context, input *DescribeDataQualityJobDefinitionInput, opts ...request.Option) (*DescribeDataQualityJobDefinitionOutput, error) {
	req, out := c.DescribeDataQualityJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDevice = "DescribeDevice"

// DescribeDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDevice for more information on using the DescribeDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeviceRequest method.
//    req, resp := client.DescribeDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDevice
func (c *SageMaker) DescribeDeviceRequest(input *DescribeDeviceInput) (req *request.Request, output *DescribeDeviceOutput) {
	op := &request.Operation{
		Name:       opDescribeDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeviceInput{}
	}

	output = &DescribeDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDevice API operation for Amazon SageMaker Service.
//
// Describes the device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeDevice for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDevice
func (c *SageMaker) DescribeDevice(input *DescribeDeviceInput) (*DescribeDeviceOutput, error) {
	req, out := c.DescribeDeviceRequest(input)
	return out, req.Send()
}

// DescribeDeviceWithContext is the same as DescribeDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeDeviceWithContext(ctx aws.Context, input *DescribeDeviceInput, opts ...request.Option) (*DescribeDeviceOutput, error) {
	req, out := c.DescribeDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeviceFleet = "DescribeDeviceFleet"

// DescribeDeviceFleetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeviceFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeviceFleet for more information on using the DescribeDeviceFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeviceFleetRequest method.
//    req, resp := client.DescribeDeviceFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDeviceFleet
func (c *SageMaker) DescribeDeviceFleetRequest(input *DescribeDeviceFleetInput) (req *request.Request, output *DescribeDeviceFleetOutput) {
	op := &request.Operation{
		Name:       opDescribeDeviceFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeviceFleetInput{}
	}

	output = &DescribeDeviceFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeviceFleet API operation for Amazon SageMaker Service.
//
// A description of the fleet the device belongs to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeDeviceFleet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDeviceFleet
func (c *SageMaker) DescribeDeviceFleet(input *DescribeDeviceFleetInput) (*DescribeDeviceFleetOutput, error) {
	req, out := c.DescribeDeviceFleetRequest(input)
	return out, req.Send()
}

// DescribeDeviceFleetWithContext is the same as DescribeDeviceFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeviceFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeDeviceFleetWithContext(ctx aws.Context, input *DescribeDeviceFleetInput, opts ...request.Option) (*DescribeDeviceFleetOutput, error) {
	req, out := c.DescribeDeviceFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomain = "DescribeDomain"

// DescribeDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomain for more information on using the DescribeDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDomainRequest method.
//    req, resp := client.DescribeDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain
func (c *SageMaker) DescribeDomainRequest(input *DescribeDomainInput) (req *request.Request, output *DescribeDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDomainInput{}
	}

	output = &DescribeDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomain API operation for Amazon SageMaker Service.
//
// The description of the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeDomain for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain
func (c *SageMaker) DescribeDomain(input *DescribeDomainInput) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	return out, req.Send()
}

// DescribeDomainWithContext is the same as DescribeDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeDomainWithContext(ctx aws.Context, input *DescribeDomainInput, opts ...request.Option) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEdgePackagingJob = "DescribeEdgePackagingJob"

// DescribeEdgePackagingJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEdgePackagingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEdgePackagingJob for more information on using the DescribeEdgePackagingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEdgePackagingJobRequest method.
//    req, resp := client.DescribeEdgePackagingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgePackagingJob
func (c *SageMaker) DescribeEdgePackagingJobRequest(input *DescribeEdgePackagingJobInput) (req *request.Request, output *DescribeEdgePackagingJobOutput) {
	op := &request.Operation{
		Name:       opDescribeEdgePackagingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEdgePackagingJobInput{}
	}

	output = &DescribeEdgePackagingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEdgePackagingJob API operation for Amazon SageMaker Service.
//
// A description of edge packaging jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeEdgePackagingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgePackagingJob
func (c *SageMaker) DescribeEdgePackagingJob(input *DescribeEdgePackagingJobInput) (*DescribeEdgePackagingJobOutput, error) {
	req, out := c.DescribeEdgePackagingJobRequest(input)
	return out, req.Send()
}

// DescribeEdgePackagingJobWithContext is the same as DescribeEdgePackagingJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEdgePackagingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeEdgePackagingJobWithContext(ctx aws.Context, input *DescribeEdgePackagingJobInput, opts ...request.Option) (*DescribeEdgePackagingJobOutput, error) {
	req, out := c.DescribeEdgePackagingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoint = "DescribeEndpoint"

// DescribeEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoint for more information on using the DescribeEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointRequest method.
//    req, resp := client.DescribeEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint
func (c *SageMaker) DescribeEndpointRequest(input *DescribeEndpointInput) (req *request.Request, output *DescribeEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointInput{}
	}

	output = &DescribeEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoint API operation for Amazon SageMaker Service.
//
// Returns the description of an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint
func (c *SageMaker) DescribeEndpoint(input *DescribeEndpointInput) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	return out, req.Send()
}

// DescribeEndpointWithContext is the same as DescribeEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeEndpointWithContext(ctx aws.Context, input *DescribeEndpointInput, opts ...request.Option) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpointConfig = "DescribeEndpointConfig"

// DescribeEndpointConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpointConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpointConfig for more information on using the DescribeEndpointConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointConfigRequest method.
//    req, resp := client.DescribeEndpointConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig
func (c *SageMaker) DescribeEndpointConfigRequest(input *DescribeEndpointConfigInput) (req *request.Request, output *DescribeEndpointConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpointConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointConfigInput{}
	}

	output = &DescribeEndpointConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpointConfig API operation for Amazon SageMaker Service.
//
// Returns the description of an endpoint configuration created using the CreateEndpointConfig
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeEndpointConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig
func (c *SageMaker) DescribeEndpointConfig(input *DescribeEndpointConfigInput) (*DescribeEndpointConfigOutput, error) {
	req, out := c.DescribeEndpointConfigRequest(input)
	return out, req.Send()
}

// DescribeEndpointConfigWithContext is the same as DescribeEndpointConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpointConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeEndpointConfigWithContext(ctx aws.Context, input *DescribeEndpointConfigInput, opts ...request.Option) (*DescribeEndpointConfigOutput, error) {
	req, out := c.DescribeEndpointConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExperiment = "DescribeExperiment"

// DescribeExperimentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExperiment for more information on using the DescribeExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeExperimentRequest method.
//    req, resp := client.DescribeExperimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment
func (c *SageMaker) DescribeExperimentRequest(input *DescribeExperimentInput) (req *request.Request, output *DescribeExperimentOutput) {
	op := &request.Operation{
		Name:       opDescribeExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExperimentInput{}
	}

	output = &DescribeExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExperiment API operation for Amazon SageMaker Service.
//
// Provides a list of an experiment's properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeExperiment for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment
func (c *SageMaker) DescribeExperiment(input *DescribeExperimentInput) (*DescribeExperimentOutput, error) {
	req, out := c.DescribeExperimentRequest(input)
	return out, req.Send()
}

// DescribeExperimentWithContext is the same as DescribeExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeExperimentWithContext(ctx aws.Context, input *DescribeExperimentInput, opts ...request.Option) (*DescribeExperimentOutput, error) {
	req, out := c.DescribeExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFeatureGroup = "DescribeFeatureGroup"

// DescribeFeatureGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFeatureGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFeatureGroup for more information on using the DescribeFeatureGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFeatureGroupRequest method.
//    req, resp := client.DescribeFeatureGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureGroup
func (c *SageMaker) DescribeFeatureGroupRequest(input *DescribeFeatureGroupInput) (req *request.Request, output *DescribeFeatureGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeFeatureGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFeatureGroupInput{}
	}

	output = &DescribeFeatureGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFeatureGroup API operation for Amazon SageMaker Service.
//
// Use this operation to describe a FeatureGroup. The response includes information
// on the creation time, FeatureGroup name, the unique identifier for each FeatureGroup,
// and more.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeFeatureGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureGroup
func (c *SageMaker) DescribeFeatureGroup(input *DescribeFeatureGroupInput) (*DescribeFeatureGroupOutput, error) {
	req, out := c.DescribeFeatureGroupRequest(input)
	return out, req.Send()
}

// DescribeFeatureGroupWithContext is the same as DescribeFeatureGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFeatureGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeFeatureGroupWithContext(ctx aws.Context, input *DescribeFeatureGroupInput, opts ...request.Option) (*DescribeFeatureGroupOutput, error) {
	req, out := c.DescribeFeatureGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFlowDefinition = "DescribeFlowDefinition"

// DescribeFlowDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlowDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlowDefinition for more information on using the DescribeFlowDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFlowDefinitionRequest method.
//    req, resp := client.DescribeFlowDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFlowDefinition
func (c *SageMaker) DescribeFlowDefinitionRequest(input *DescribeFlowDefinitionInput) (req *request.Request, output *DescribeFlowDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeFlowDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFlowDefinitionInput{}
	}

	output = &DescribeFlowDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlowDefinition API operation for Amazon SageMaker Service.
//
// Returns information about the specified flow definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeFlowDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFlowDefinition
func (c *SageMaker) DescribeFlowDefinition(input *DescribeFlowDefinitionInput) (*DescribeFlowDefinitionOutput, error) {
	req, out := c.DescribeFlowDefinitionRequest(input)
	return out, req.Send()
}

// DescribeFlowDefinitionWithContext is the same as DescribeFlowDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlowDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeFlowDefinitionWithContext(ctx aws.Context, input *DescribeFlowDefinitionInput, opts ...request.Option) (*DescribeFlowDefinitionOutput, error) {
	req, out := c.DescribeFlowDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHumanTaskUi = "DescribeHumanTaskUi"

// DescribeHumanTaskUiRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHumanTaskUi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHumanTaskUi for more information on using the DescribeHumanTaskUi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHumanTaskUiRequest method.
//    req, resp := client.DescribeHumanTaskUiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi
func (c *SageMaker) DescribeHumanTaskUiRequest(input *DescribeHumanTaskUiInput) (req *request.Request, output *DescribeHumanTaskUiOutput) {
	op := &request.Operation{
		Name:       opDescribeHumanTaskUi,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHumanTaskUiInput{}
	}

	output = &DescribeHumanTaskUiOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHumanTaskUi API operation for Amazon SageMaker Service.
//
// Returns information about the requested human task user interface (worker
// task template).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeHumanTaskUi for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi
func (c *SageMaker) DescribeHumanTaskUi(input *DescribeHumanTaskUiInput) (*DescribeHumanTaskUiOutput, error) {
	req, out := c.DescribeHumanTaskUiRequest(input)
	return out, req.Send()
}

// DescribeHumanTaskUiWithContext is the same as DescribeHumanTaskUi with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHumanTaskUi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeHumanTaskUiWithContext(ctx aws.Context, input *DescribeHumanTaskUiInput, opts ...request.Option) (*DescribeHumanTaskUiOutput, error) {
	req, out := c.DescribeHumanTaskUiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHyperParameterTuningJob = "DescribeHyperParameterTuningJob"

// DescribeHyperParameterTuningJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHyperParameterTuningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHyperParameterTuningJob for more information on using the DescribeHyperParameterTuningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeHyperParameterTuningJobRequest method.
//    req, resp := client.DescribeHyperParameterTuningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob
func (c *SageMaker) DescribeHyperParameterTuningJobRequest(input *DescribeHyperParameterTuningJobInput) (req *request.Request, output *DescribeHyperParameterTuningJobOutput) {
	op := &request.Operation{
		Name:       opDescribeHyperParameterTuningJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHyperParameterTuningJobInput{}
	}

	output = &DescribeHyperParameterTuningJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHyperParameterTuningJob API operation for Amazon SageMaker Service.
//
// Gets a description of a hyperparameter tuning job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeHyperParameterTuningJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob
func (c *SageMaker) DescribeHyperParameterTuningJob(input *DescribeHyperParameterTuningJobInput) (*DescribeHyperParameterTuningJobOutput, error) {
	req, out := c.DescribeHyperParameterTuningJobRequest(input)
	return out, req.Send()
}

// DescribeHyperParameterTuningJobWithContext is the same as DescribeHyperParameterTuningJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHyperParameterTuningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeHyperParameterTuningJobWithContext(ctx aws.Context, input *DescribeHyperParameterTuningJobInput, opts ...request.Option) (*DescribeHyperParameterTuningJobOutput, error) {
	req, out := c.DescribeHyperParameterTuningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImage = "DescribeImage"

// DescribeImageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImage for more information on using the DescribeImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImageRequest method.
//    req, resp := client.DescribeImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImage
func (c *SageMaker) DescribeImageRequest(input *DescribeImageInput) (req *request.Request, output *DescribeImageOutput) {
	op := &request.Operation{
		Name:       opDescribeImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImageInput{}
	}

	output = &DescribeImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImage API operation for Amazon SageMaker Service.
//
// Describes a SageMaker image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeImage for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImage
func (c *SageMaker) DescribeImage(input *DescribeImageInput) (*DescribeImageOutput, error) {
	req, out := c.DescribeImageRequest(input)
	return out, req.Send()
}

// DescribeImageWithContext is the same as DescribeImage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeImageWithContext(ctx aws.Context, input *DescribeImageInput, opts ...request.Option) (*DescribeImageOutput, error) {
	req, out := c.DescribeImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImageVersion = "DescribeImageVersion"

// DescribeImageVersionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImageVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImageVersion for more information on using the DescribeImageVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImageVersionRequest method.
//    req, resp := client.DescribeImageVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImageVersion
func (c *SageMaker) DescribeImageVersionRequest(input *DescribeImageVersionInput) (req *request.Request, output *DescribeImageVersionOutput) {
	op := &request.Operation{
		Name:       opDescribeImageVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImageVersionInput{}
	}

	output = &DescribeImageVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImageVersion API operation for Amazon SageMaker Service.
//
// Describes a version of a SageMaker image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeImageVersion for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImageVersion
func (c *SageMaker) DescribeImageVersion(input *DescribeImageVersionInput) (*DescribeImageVersionOutput, error) {
	req, out := c.DescribeImageVersionRequest(input)
	return out, req.Send()
}

// DescribeImageVersionWithContext is the same as DescribeImageVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImageVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeImageVersionWithContext(ctx aws.Context, input *DescribeImageVersionInput, opts ...request.Option) (*DescribeImageVersionOutput, error) {
	req, out := c.DescribeImageVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLabelingJob = "DescribeLabelingJob"

// DescribeLabelingJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLabelingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLabelingJob for more information on using the DescribeLabelingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLabelingJobRequest method.
//    req, resp := client.DescribeLabelingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob
func (c *SageMaker) DescribeLabelingJobRequest(input *DescribeLabelingJobInput) (req *request.Request, output *DescribeLabelingJobOutput) {
	op := &request.Operation{
		Name:       opDescribeLabelingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLabelingJobInput{}
	}

	output = &DescribeLabelingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLabelingJob API operation for Amazon SageMaker Service.
//
// Gets information about a labeling job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeLabelingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob
func (c *SageMaker) DescribeLabelingJob(input *DescribeLabelingJobInput) (*DescribeLabelingJobOutput, error) {
	req, out := c.DescribeLabelingJobRequest(input)
	return out, req.Send()
}

// DescribeLabelingJobWithContext is the same as DescribeLabelingJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLabelingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeLabelingJobWithContext(ctx aws.Context, input *DescribeLabelingJobInput, opts ...request.Option) (*DescribeLabelingJobOutput, error) {
	req, out := c.DescribeLabelingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModel = "DescribeModel"

// DescribeModelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModel for more information on using the DescribeModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelRequest method.
//    req, resp := client.DescribeModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel
func (c *SageMaker) DescribeModelRequest(input *DescribeModelInput) (req *request.Request, output *DescribeModelOutput) {
	op := &request.Operation{
		Name:       opDescribeModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeModelInput{}
	}

	output = &DescribeModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModel API operation for Amazon SageMaker Service.
//
// Describes a model that you created using the CreateModel API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeModel for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel
func (c *SageMaker) DescribeModel(input *DescribeModelInput) (*DescribeModelOutput, error) {
	req, out := c.DescribeModelRequest(input)
	return out, req.Send()
}

// DescribeModelWithContext is the same as DescribeModel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeModelWithContext(ctx aws.Context, input *DescribeModelInput, opts ...request.Option) (*DescribeModelOutput, error) {
	req, out := c.DescribeModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModelBiasJobDefinition = "DescribeModelBiasJobDefinition"

// DescribeModelBiasJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModelBiasJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModelBiasJobDefinition for more information on using the DescribeModelBiasJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelBiasJobDefinitionRequest method.
//    req, resp := client.DescribeModelBiasJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelBiasJobDefinition
func (c *SageMaker) DescribeModelBiasJobDefinitionRequest(input *DescribeModelBiasJobDefinitionInput) (req *request.Request, output *DescribeModelBiasJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeModelBiasJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeModelBiasJobDefinitionInput{}
	}

	output = &DescribeModelBiasJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModelBiasJobDefinition API operation for Amazon SageMaker Service.
//
// Returns a description of a model bias job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeModelBiasJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelBiasJobDefinition
func (c *SageMaker) DescribeModelBiasJobDefinition(input *DescribeModelBiasJobDefinitionInput) (*DescribeModelBiasJobDefinitionOutput, error) {
	req, out := c.DescribeModelBiasJobDefinitionRequest(input)
	return out, req.Send()
}

// DescribeModelBiasJobDefinitionWithContext is the same as DescribeModelBiasJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModelBiasJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeModelBiasJobDefinitionWithContext(ctx aws.Context, input *DescribeModelBiasJobDefinitionInput, opts ...request.Option) (*DescribeModelBiasJobDefinitionOutput, error) {
	req, out := c.DescribeModelBiasJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModelExplainabilityJobDefinition = "DescribeModelExplainabilityJobDefinition"

// DescribeModelExplainabilityJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModelExplainabilityJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModelExplainabilityJobDefinition for more information on using the DescribeModelExplainabilityJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelExplainabilityJobDefinitionRequest method.
//    req, resp := client.DescribeModelExplainabilityJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelExplainabilityJobDefinition
func (c *SageMaker) DescribeModelExplainabilityJobDefinitionRequest(input *DescribeModelExplainabilityJobDefinitionInput) (req *request.Request, output *DescribeModelExplainabilityJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeModelExplainabilityJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeModelExplainabilityJobDefinitionInput{}
	}

	output = &DescribeModelExplainabilityJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModelExplainabilityJobDefinition API operation for Amazon SageMaker Service.
//
// Returns a description of a model explainability job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeModelExplainabilityJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelExplainabilityJobDefinition
func (c *SageMaker) DescribeModelExplainabilityJobDefinition(input *DescribeModelExplainabilityJobDefinitionInput) (*DescribeModelExplainabilityJobDefinitionOutput, error) {
	req, out := c.DescribeModelExplainabilityJobDefinitionRequest(input)
	return out, req.Send()
}

// DescribeModelExplainabilityJobDefinitionWithContext is the same as DescribeModelExplainabilityJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModelExplainabilityJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeModelExplainabilityJobDefinitionWithContext(ctx aws.Context, input *DescribeModelExplainabilityJobDefinitionInput, opts ...request.Option) (*DescribeModelExplainabilityJobDefinitionOutput, error) {
	req, out := c.DescribeModelExplainabilityJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModelPackage = "DescribeModelPackage"

// DescribeModelPackageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModelPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModelPackage for more information on using the DescribeModelPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelPackageRequest method.
//    req, resp := client.DescribeModelPackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage
func (c *SageMaker) DescribeModelPackageRequest(input *DescribeModelPackageInput) (req *request.Request, output *DescribeModelPackageOutput) {
	op := &request.Operation{
		Name:       opDescribeModelPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeModelPackageInput{}
	}

	output = &DescribeModelPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModelPackage API operation for Amazon SageMaker Service.
//
// Returns a description of the specified model package, which is used to create
// Amazon SageMaker models or list them on AWS Marketplace.
//
// To create models in Amazon SageMaker, buyers can subscribe to model packages
// listed on AWS Marketplace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeModelPackage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage
func (c *SageMaker) DescribeModelPackage(input *DescribeModelPackageInput) (*DescribeModelPackageOutput, error) {
	req, out := c.DescribeModelPackageRequest(input)
	return out, req.Send()
}

// DescribeModelPackageWithContext is the same as DescribeModelPackage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModelPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeModelPackageWithContext(ctx aws.Context, input *DescribeModelPackageInput, opts ...request.Option) (*DescribeModelPackageOutput, error) {
	req, out := c.DescribeModelPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModelPackageGroup = "DescribeModelPackageGroup"

// DescribeModelPackageGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModelPackageGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModelPackageGroup for more information on using the DescribeModelPackageGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelPackageGroupRequest method.
//    req, resp := client.DescribeModelPackageGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackageGroup
func (c *SageMaker) DescribeModelPackageGroupRequest(input *DescribeModelPackageGroupInput) (req *request.Request, output *DescribeModelPackageGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeModelPackageGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeModelPackageGroupInput{}
	}

	output = &DescribeModelPackageGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModelPackageGroup API operation for Amazon SageMaker Service.
//
// Gets a description for the specified model group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeModelPackageGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackageGroup
func (c *SageMaker) DescribeModelPackageGroup(input *DescribeModelPackageGroupInput) (*DescribeModelPackageGroupOutput, error) {
	req, out := c.DescribeModelPackageGroupRequest(input)
	return out, req.Send()
}

// DescribeModelPackageGroupWithContext is the same as DescribeModelPackageGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModelPackageGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeModelPackageGroupWithContext(ctx aws.Context, input *DescribeModelPackageGroupInput, opts ...request.Option) (*DescribeModelPackageGroupOutput, error) {
	req, out := c.DescribeModelPackageGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModelQualityJobDefinition = "DescribeModelQualityJobDefinition"

// DescribeModelQualityJobDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModelQualityJobDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModelQualityJobDefinition for more information on using the DescribeModelQualityJobDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelQualityJobDefinitionRequest method.
//    req, resp := client.DescribeModelQualityJobDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelQualityJobDefinition
func (c *SageMaker) DescribeModelQualityJobDefinitionRequest(input *DescribeModelQualityJobDefinitionInput) (req *request.Request, output *DescribeModelQualityJobDefinitionOutput) {
	op := &request.Operation{
		Name:       opDescribeModelQualityJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeModelQualityJobDefinitionInput{}
	}

	output = &DescribeModelQualityJobDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModelQualityJobDefinition API operation for Amazon SageMaker Service.
//
// Returns a description of a model quality job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeModelQualityJobDefinition for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelQualityJobDefinition
func (c *SageMaker) DescribeModelQualityJobDefinition(input *DescribeModelQualityJobDefinitionInput) (*DescribeModelQualityJobDefinitionOutput, error) {
	req, out := c.DescribeModelQualityJobDefinitionRequest(input)
	return out, req.Send()
}

// DescribeModelQualityJobDefinitionWithContext is the same as DescribeModelQualityJobDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModelQualityJobDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeModelQualityJobDefinitionWithContext(ctx aws.Context, input *DescribeModelQualityJobDefinitionInput, opts ...request.Option) (*DescribeModelQualityJobDefinitionOutput, error) {
	req, out := c.DescribeModelQualityJobDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMonitoringSchedule = "DescribeMonitoringSchedule"

// DescribeMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMonitoringSchedule for more information on using the DescribeMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMonitoringScheduleRequest method.
//    req, resp := client.DescribeMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule
func (c *SageMaker) DescribeMonitoringScheduleRequest(input *DescribeMonitoringScheduleInput) (req *request.Request, output *DescribeMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMonitoringScheduleInput{}
	}

	output = &DescribeMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Describes the schedule for a monitoring job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule
func (c *SageMaker) DescribeMonitoringSchedule(input *DescribeMonitoringScheduleInput) (*DescribeMonitoringScheduleOutput, error) {
	req, out := c.DescribeMonitoringScheduleRequest(input)
	return out, req.Send()
}

// DescribeMonitoringScheduleWithContext is the same as DescribeMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeMonitoringScheduleWithContext(ctx aws.Context, input *DescribeMonitoringScheduleInput, opts ...request.Option) (*DescribeMonitoringScheduleOutput, error) {
	req, out := c.DescribeMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNotebookInstance = "DescribeNotebookInstance"

// DescribeNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNotebookInstance for more information on using the DescribeNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNotebookInstanceRequest method.
//    req, resp := client.DescribeNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance
func (c *SageMaker) DescribeNotebookInstanceRequest(input *DescribeNotebookInstanceInput) (req *request.Request, output *DescribeNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNotebookInstanceInput{}
	}

	output = &DescribeNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNotebookInstance API operation for Amazon SageMaker Service.
//
// Returns information about a notebook instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeNotebookInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance
func (c *SageMaker) DescribeNotebookInstance(input *DescribeNotebookInstanceInput) (*DescribeNotebookInstanceOutput, error) {
	req, out := c.DescribeNotebookInstanceRequest(input)
	return out, req.Send()
}

// DescribeNotebookInstanceWithContext is the same as DescribeNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeNotebookInstanceWithContext(ctx aws.Context, input *DescribeNotebookInstanceInput, opts ...request.Option) (*DescribeNotebookInstanceOutput, error) {
	req, out := c.DescribeNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNotebookInstanceLifecycleConfig = "DescribeNotebookInstanceLifecycleConfig"

// DescribeNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNotebookInstanceLifecycleConfig for more information on using the DescribeNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.DescribeNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig
func (c *SageMaker) DescribeNotebookInstanceLifecycleConfigRequest(input *DescribeNotebookInstanceLifecycleConfigInput) (req *request.Request, output *DescribeNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNotebookInstanceLifecycleConfigInput{}
	}

	output = &DescribeNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Returns a description of a notebook instance lifecycle configuration.
//
// For information about notebook instance lifestyle configurations, see Step
// 2.1: (Optional) Customize a Notebook Instance (https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeNotebookInstanceLifecycleConfig for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig
func (c *SageMaker) DescribeNotebookInstanceLifecycleConfig(input *DescribeNotebookInstanceLifecycleConfigInput) (*DescribeNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DescribeNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// DescribeNotebookInstanceLifecycleConfigWithContext is the same as DescribeNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *DescribeNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*DescribeNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.DescribeNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePipeline = "DescribePipeline"

// DescribePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DescribePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePipeline for more information on using the DescribePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePipelineRequest method.
//    req, resp := client.DescribePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipeline
func (c *SageMaker) DescribePipelineRequest(input *DescribePipelineInput) (req *request.Request, output *DescribePipelineOutput) {
	op := &request.Operation{
		Name:       opDescribePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePipelineInput{}
	}

	output = &DescribePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePipeline API operation for Amazon SageMaker Service.
//
// Describes the details of a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribePipeline for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipeline
func (c *SageMaker) DescribePipeline(input *DescribePipelineInput) (*DescribePipelineOutput, error) {
	req, out := c.DescribePipelineRequest(input)
	return out, req.Send()
}

// DescribePipelineWithContext is the same as DescribePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribePipelineWithContext(ctx aws.Context, input *DescribePipelineInput, opts ...request.Option) (*DescribePipelineOutput, error) {
	req, out := c.DescribePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePipelineDefinitionForExecution = "DescribePipelineDefinitionForExecution"

// DescribePipelineDefinitionForExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribePipelineDefinitionForExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePipelineDefinitionForExecution for more information on using the DescribePipelineDefinitionForExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePipelineDefinitionForExecutionRequest method.
//    req, resp := client.DescribePipelineDefinitionForExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineDefinitionForExecution
func (c *SageMaker) DescribePipelineDefinitionForExecutionRequest(input *DescribePipelineDefinitionForExecutionInput) (req *request.Request, output *DescribePipelineDefinitionForExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribePipelineDefinitionForExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePipelineDefinitionForExecutionInput{}
	}

	output = &DescribePipelineDefinitionForExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePipelineDefinitionForExecution API operation for Amazon SageMaker Service.
//
// Describes the details of an execution's pipeline definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribePipelineDefinitionForExecution for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineDefinitionForExecution
func (c *SageMaker) DescribePipelineDefinitionForExecution(input *DescribePipelineDefinitionForExecutionInput) (*DescribePipelineDefinitionForExecutionOutput, error) {
	req, out := c.DescribePipelineDefinitionForExecutionRequest(input)
	return out, req.Send()
}

// DescribePipelineDefinitionForExecutionWithContext is the same as DescribePipelineDefinitionForExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePipelineDefinitionForExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribePipelineDefinitionForExecutionWithContext(ctx aws.Context, input *DescribePipelineDefinitionForExecutionInput, opts ...request.Option) (*DescribePipelineDefinitionForExecutionOutput, error) {
	req, out := c.DescribePipelineDefinitionForExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePipelineExecution = "DescribePipelineExecution"

// DescribePipelineExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribePipelineExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePipelineExecution for more information on using the DescribePipelineExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePipelineExecutionRequest method.
//    req, resp := client.DescribePipelineExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineExecution
func (c *SageMaker) DescribePipelineExecutionRequest(input *DescribePipelineExecutionInput) (req *request.Request, output *DescribePipelineExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribePipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePipelineExecutionInput{}
	}

	output = &DescribePipelineExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePipelineExecution API operation for Amazon SageMaker Service.
//
// Describes the details of a pipeline execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribePipelineExecution for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineExecution
func (c *SageMaker) DescribePipelineExecution(input *DescribePipelineExecutionInput) (*DescribePipelineExecutionOutput, error) {
	req, out := c.DescribePipelineExecutionRequest(input)
	return out, req.Send()
}

// DescribePipelineExecutionWithContext is the same as DescribePipelineExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePipelineExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribePipelineExecutionWithContext(ctx aws.Context, input *DescribePipelineExecutionInput, opts ...request.Option) (*DescribePipelineExecutionOutput, error) {
	req, out := c.DescribePipelineExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProcessingJob = "DescribeProcessingJob"

// DescribeProcessingJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProcessingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProcessingJob for more information on using the DescribeProcessingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProcessingJobRequest method.
//    req, resp := client.DescribeProcessingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob
func (c *SageMaker) DescribeProcessingJobRequest(input *DescribeProcessingJobInput) (req *request.Request, output *DescribeProcessingJobOutput) {
	op := &request.Operation{
		Name:       opDescribeProcessingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProcessingJobInput{}
	}

	output = &DescribeProcessingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProcessingJob API operation for Amazon SageMaker Service.
//
// Returns a description of a processing job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeProcessingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob
func (c *SageMaker) DescribeProcessingJob(input *DescribeProcessingJobInput) (*DescribeProcessingJobOutput, error) {
	req, out := c.DescribeProcessingJobRequest(input)
	return out, req.Send()
}

// DescribeProcessingJobWithContext is the same as DescribeProcessingJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProcessingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeProcessingJobWithContext(ctx aws.Context, input *DescribeProcessingJobInput, opts ...request.Option) (*DescribeProcessingJobOutput, error) {
	req, out := c.DescribeProcessingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProject for more information on using the DescribeProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProjectRequest method.
//    req, resp := client.DescribeProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProject
func (c *SageMaker) DescribeProjectRequest(input *DescribeProjectInput) (req *request.Request, output *DescribeProjectOutput) {
	op := &request.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	output = &DescribeProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProject API operation for Amazon SageMaker Service.
//
// Describes the details of a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeProject for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProject
func (c *SageMaker) DescribeProject(input *DescribeProjectInput) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	return out, req.Send()
}

// DescribeProjectWithContext is the same as DescribeProject with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeProjectWithContext(ctx aws.Context, input *DescribeProjectInput, opts ...request.Option) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSubscribedWorkteam = "DescribeSubscribedWorkteam"

// DescribeSubscribedWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSubscribedWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSubscribedWorkteam for more information on using the DescribeSubscribedWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSubscribedWorkteamRequest method.
//    req, resp := client.DescribeSubscribedWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam
func (c *SageMaker) DescribeSubscribedWorkteamRequest(input *DescribeSubscribedWorkteamInput) (req *request.Request, output *DescribeSubscribedWorkteamOutput) {
	op := &request.Operation{
		Name:       opDescribeSubscribedWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSubscribedWorkteamInput{}
	}

	output = &DescribeSubscribedWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSubscribedWorkteam API operation for Amazon SageMaker Service.
//
// Gets information about a work team provided by a vendor. It returns details
// about the subscription with a vendor in the AWS Marketplace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeSubscribedWorkteam for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam
func (c *SageMaker) DescribeSubscribedWorkteam(input *DescribeSubscribedWorkteamInput) (*DescribeSubscribedWorkteamOutput, error) {
	req, out := c.DescribeSubscribedWorkteamRequest(input)
	return out, req.Send()
}

// DescribeSubscribedWorkteamWithContext is the same as DescribeSubscribedWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSubscribedWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeSubscribedWorkteamWithContext(ctx aws.Context, input *DescribeSubscribedWorkteamInput, opts ...request.Option) (*DescribeSubscribedWorkteamOutput, error) {
	req, out := c.DescribeSubscribedWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrainingJob = "DescribeTrainingJob"

// DescribeTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrainingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrainingJob for more information on using the DescribeTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrainingJobRequest method.
//    req, resp := client.DescribeTrainingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob
func (c *SageMaker) DescribeTrainingJobRequest(input *DescribeTrainingJobInput) (req *request.Request, output *DescribeTrainingJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrainingJobInput{}
	}

	output = &DescribeTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrainingJob API operation for Amazon SageMaker Service.
//
// Returns information about a training job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeTrainingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob
func (c *SageMaker) DescribeTrainingJob(input *DescribeTrainingJobInput) (*DescribeTrainingJobOutput, error) {
	req, out := c.DescribeTrainingJobRequest(input)
	return out, req.Send()
}

// DescribeTrainingJobWithContext is the same as DescribeTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeTrainingJobWithContext(ctx aws.Context, input *DescribeTrainingJobInput, opts ...request.Option) (*DescribeTrainingJobOutput, error) {
	req, out := c.DescribeTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTransformJob = "DescribeTransformJob"

// DescribeTransformJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTransformJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTransformJob for more information on using the DescribeTransformJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTransformJobRequest method.
//    req, resp := client.DescribeTransformJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob
func (c *SageMaker) DescribeTransformJobRequest(input *DescribeTransformJobInput) (req *request.Request, output *DescribeTransformJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTransformJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTransformJobInput{}
	}

	output = &DescribeTransformJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTransformJob API operation for Amazon SageMaker Service.
//
// Returns information about a transform job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeTransformJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob
func (c *SageMaker) DescribeTransformJob(input *DescribeTransformJobInput) (*DescribeTransformJobOutput, error) {
	req, out := c.DescribeTransformJobRequest(input)
	return out, req.Send()
}

// DescribeTransformJobWithContext is the same as DescribeTransformJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTransformJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeTransformJobWithContext(ctx aws.Context, input *DescribeTransformJobInput, opts ...request.Option) (*DescribeTransformJobOutput, error) {
	req, out := c.DescribeTransformJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrial = "DescribeTrial"

// DescribeTrialRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrial operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrial for more information on using the DescribeTrial
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrialRequest method.
//    req, resp := client.DescribeTrialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrial
func (c *SageMaker) DescribeTrialRequest(input *DescribeTrialInput) (req *request.Request, output *DescribeTrialOutput) {
	op := &request.Operation{
		Name:       opDescribeTrial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrialInput{}
	}

	output = &DescribeTrialOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrial API operation for Amazon SageMaker Service.
//
// Provides a list of a trial's properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeTrial for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrial
func (c *SageMaker) DescribeTrial(input *DescribeTrialInput) (*DescribeTrialOutput, error) {
	req, out := c.DescribeTrialRequest(input)
	return out, req.Send()
}

// DescribeTrialWithContext is the same as DescribeTrial with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrial for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeTrialWithContext(ctx aws.Context, input *DescribeTrialInput, opts ...request.Option) (*DescribeTrialOutput, error) {
	req, out := c.DescribeTrialRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrialComponent = "DescribeTrialComponent"

// DescribeTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrialComponent for more information on using the DescribeTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrialComponentRequest method.
//    req, resp := client.DescribeTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent
func (c *SageMaker) DescribeTrialComponentRequest(input *DescribeTrialComponentInput) (req *request.Request, output *DescribeTrialComponentOutput) {
	op := &request.Operation{
		Name:       opDescribeTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrialComponentInput{}
	}

	output = &DescribeTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrialComponent API operation for Amazon SageMaker Service.
//
// Provides a list of a trials component's properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent
func (c *SageMaker) DescribeTrialComponent(input *DescribeTrialComponentInput) (*DescribeTrialComponentOutput, error) {
	req, out := c.DescribeTrialComponentRequest(input)
	return out, req.Send()
}

// DescribeTrialComponentWithContext is the same as DescribeTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeTrialComponentWithContext(ctx aws.Context, input *DescribeTrialComponentInput, opts ...request.Option) (*DescribeTrialComponentOutput, error) {
	req, out := c.DescribeTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserProfile = "DescribeUserProfile"

// DescribeUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserProfile for more information on using the DescribeUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserProfileRequest method.
//    req, resp := client.DescribeUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeUserProfile
func (c *SageMaker) DescribeUserProfileRequest(input *DescribeUserProfileInput) (req *request.Request, output *DescribeUserProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserProfileInput{}
	}

	output = &DescribeUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserProfile API operation for Amazon SageMaker Service.
//
// Describes a user profile. For more information, see CreateUserProfile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeUserProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeUserProfile
func (c *SageMaker) DescribeUserProfile(input *DescribeUserProfileInput) (*DescribeUserProfileOutput, error) {
	req, out := c.DescribeUserProfileRequest(input)
	return out, req.Send()
}

// DescribeUserProfileWithContext is the same as DescribeUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeUserProfileWithContext(ctx aws.Context, input *DescribeUserProfileInput, opts ...request.Option) (*DescribeUserProfileOutput, error) {
	req, out := c.DescribeUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkforce = "DescribeWorkforce"

// DescribeWorkforceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkforce operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkforce for more information on using the DescribeWorkforce
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkforceRequest method.
//    req, resp := client.DescribeWorkforceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkforce
func (c *SageMaker) DescribeWorkforceRequest(input *DescribeWorkforceInput) (req *request.Request, output *DescribeWorkforceOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkforce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkforceInput{}
	}

	output = &DescribeWorkforceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkforce API operation for Amazon SageMaker Service.
//
// Lists private workforce information, including workforce name, Amazon Resource
// Name (ARN), and, if applicable, allowed IP address ranges (CIDRs (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)).
// Allowable IP address ranges are the IP addresses that workers can use to
// access tasks.
//
// This operation applies only to private workforces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeWorkforce for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkforce
func (c *SageMaker) DescribeWorkforce(input *DescribeWorkforceInput) (*DescribeWorkforceOutput, error) {
	req, out := c.DescribeWorkforceRequest(input)
	return out, req.Send()
}

// DescribeWorkforceWithContext is the same as DescribeWorkforce with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkforce for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeWorkforceWithContext(ctx aws.Context, input *DescribeWorkforceInput, opts ...request.Option) (*DescribeWorkforceOutput, error) {
	req, out := c.DescribeWorkforceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkteam = "DescribeWorkteam"

// DescribeWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkteam for more information on using the DescribeWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkteamRequest method.
//    req, resp := client.DescribeWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam
func (c *SageMaker) DescribeWorkteamRequest(input *DescribeWorkteamInput) (req *request.Request, output *DescribeWorkteamOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkteamInput{}
	}

	output = &DescribeWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkteam API operation for Amazon SageMaker Service.
//
// Gets information about a specific work team. You can see information such
// as the create date, the last updated date, membership information, and the
// work team's Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DescribeWorkteam for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam
func (c *SageMaker) DescribeWorkteam(input *DescribeWorkteamInput) (*DescribeWorkteamOutput, error) {
	req, out := c.DescribeWorkteamRequest(input)
	return out, req.Send()
}

// DescribeWorkteamWithContext is the same as DescribeWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DescribeWorkteamWithContext(ctx aws.Context, input *DescribeWorkteamInput, opts ...request.Option) (*DescribeWorkteamOutput, error) {
	req, out := c.DescribeWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableSagemakerServicecatalogPortfolio = "DisableSagemakerServicecatalogPortfolio"

// DisableSagemakerServicecatalogPortfolioRequest generates a "aws/request.Request" representing the
// client's request for the DisableSagemakerServicecatalogPortfolio operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableSagemakerServicecatalogPortfolio for more information on using the DisableSagemakerServicecatalogPortfolio
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableSagemakerServicecatalogPortfolioRequest method.
//    req, resp := client.DisableSagemakerServicecatalogPortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisableSagemakerServicecatalogPortfolio
func (c *SageMaker) DisableSagemakerServicecatalogPortfolioRequest(input *DisableSagemakerServicecatalogPortfolioInput) (req *request.Request, output *DisableSagemakerServicecatalogPortfolioOutput) {
	op := &request.Operation{
		Name:       opDisableSagemakerServicecatalogPortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableSagemakerServicecatalogPortfolioInput{}
	}

	output = &DisableSagemakerServicecatalogPortfolioOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableSagemakerServicecatalogPortfolio API operation for Amazon SageMaker Service.
//
// Disables using Service Catalog in SageMaker. Service Catalog is used to create
// SageMaker projects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DisableSagemakerServicecatalogPortfolio for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisableSagemakerServicecatalogPortfolio
func (c *SageMaker) DisableSagemakerServicecatalogPortfolio(input *DisableSagemakerServicecatalogPortfolioInput) (*DisableSagemakerServicecatalogPortfolioOutput, error) {
	req, out := c.DisableSagemakerServicecatalogPortfolioRequest(input)
	return out, req.Send()
}

// DisableSagemakerServicecatalogPortfolioWithContext is the same as DisableSagemakerServicecatalogPortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See DisableSagemakerServicecatalogPortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DisableSagemakerServicecatalogPortfolioWithContext(ctx aws.Context, input *DisableSagemakerServicecatalogPortfolioInput, opts ...request.Option) (*DisableSagemakerServicecatalogPortfolioOutput, error) {
	req, out := c.DisableSagemakerServicecatalogPortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateTrialComponent = "DisassociateTrialComponent"

// DisassociateTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateTrialComponent for more information on using the DisassociateTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateTrialComponentRequest method.
//    req, resp := client.DisassociateTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisassociateTrialComponent
func (c *SageMaker) DisassociateTrialComponentRequest(input *DisassociateTrialComponentInput) (req *request.Request, output *DisassociateTrialComponentOutput) {
	op := &request.Operation{
		Name:       opDisassociateTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateTrialComponentInput{}
	}

	output = &DisassociateTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateTrialComponent API operation for Amazon SageMaker Service.
//
// Disassociates a trial component from a trial. This doesn't effect other trials
// the component is associated with. Before you can delete a component, you
// must disassociate the component from all trials it is associated with. To
// associate a trial component with a trial, call the AssociateTrialComponent
// API.
//
// To get a list of the trials a component is associated with, use the Search
// API. Specify ExperimentTrialComponent for the Resource parameter. The list
// appears in the response under Results.TrialComponent.Parents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation DisassociateTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisassociateTrialComponent
func (c *SageMaker) DisassociateTrialComponent(input *DisassociateTrialComponentInput) (*DisassociateTrialComponentOutput, error) {
	req, out := c.DisassociateTrialComponentRequest(input)
	return out, req.Send()
}

// DisassociateTrialComponentWithContext is the same as DisassociateTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) DisassociateTrialComponentWithContext(ctx aws.Context, input *DisassociateTrialComponentInput, opts ...request.Option) (*DisassociateTrialComponentOutput, error) {
	req, out := c.DisassociateTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableSagemakerServicecatalogPortfolio = "EnableSagemakerServicecatalogPortfolio"

// EnableSagemakerServicecatalogPortfolioRequest generates a "aws/request.Request" representing the
// client's request for the EnableSagemakerServicecatalogPortfolio operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableSagemakerServicecatalogPortfolio for more information on using the EnableSagemakerServicecatalogPortfolio
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableSagemakerServicecatalogPortfolioRequest method.
//    req, resp := client.EnableSagemakerServicecatalogPortfolioRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/EnableSagemakerServicecatalogPortfolio
func (c *SageMaker) EnableSagemakerServicecatalogPortfolioRequest(input *EnableSagemakerServicecatalogPortfolioInput) (req *request.Request, output *EnableSagemakerServicecatalogPortfolioOutput) {
	op := &request.Operation{
		Name:       opEnableSagemakerServicecatalogPortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableSagemakerServicecatalogPortfolioInput{}
	}

	output = &EnableSagemakerServicecatalogPortfolioOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableSagemakerServicecatalogPortfolio API operation for Amazon SageMaker Service.
//
// Enables using Service Catalog in SageMaker. Service Catalog is used to create
// SageMaker projects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation EnableSagemakerServicecatalogPortfolio for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/EnableSagemakerServicecatalogPortfolio
func (c *SageMaker) EnableSagemakerServicecatalogPortfolio(input *EnableSagemakerServicecatalogPortfolioInput) (*EnableSagemakerServicecatalogPortfolioOutput, error) {
	req, out := c.EnableSagemakerServicecatalogPortfolioRequest(input)
	return out, req.Send()
}

// EnableSagemakerServicecatalogPortfolioWithContext is the same as EnableSagemakerServicecatalogPortfolio with the addition of
// the ability to pass a context and additional request options.
//
// See EnableSagemakerServicecatalogPortfolio for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) EnableSagemakerServicecatalogPortfolioWithContext(ctx aws.Context, input *EnableSagemakerServicecatalogPortfolioInput, opts ...request.Option) (*EnableSagemakerServicecatalogPortfolioOutput, error) {
	req, out := c.EnableSagemakerServicecatalogPortfolioRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeviceFleetReport = "GetDeviceFleetReport"

// GetDeviceFleetReportRequest generates a "aws/request.Request" representing the
// client's request for the GetDeviceFleetReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeviceFleetReport for more information on using the GetDeviceFleetReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeviceFleetReportRequest method.
//    req, resp := client.GetDeviceFleetReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetDeviceFleetReport
func (c *SageMaker) GetDeviceFleetReportRequest(input *GetDeviceFleetReportInput) (req *request.Request, output *GetDeviceFleetReportOutput) {
	op := &request.Operation{
		Name:       opGetDeviceFleetReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeviceFleetReportInput{}
	}

	output = &GetDeviceFleetReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeviceFleetReport API operation for Amazon SageMaker Service.
//
// Describes a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation GetDeviceFleetReport for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetDeviceFleetReport
func (c *SageMaker) GetDeviceFleetReport(input *GetDeviceFleetReportInput) (*GetDeviceFleetReportOutput, error) {
	req, out := c.GetDeviceFleetReportRequest(input)
	return out, req.Send()
}

// GetDeviceFleetReportWithContext is the same as GetDeviceFleetReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeviceFleetReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) GetDeviceFleetReportWithContext(ctx aws.Context, input *GetDeviceFleetReportInput, opts ...request.Option) (*GetDeviceFleetReportOutput, error) {
	req, out := c.GetDeviceFleetReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModelPackageGroupPolicy = "GetModelPackageGroupPolicy"

// GetModelPackageGroupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetModelPackageGroupPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModelPackageGroupPolicy for more information on using the GetModelPackageGroupPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetModelPackageGroupPolicyRequest method.
//    req, resp := client.GetModelPackageGroupPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetModelPackageGroupPolicy
func (c *SageMaker) GetModelPackageGroupPolicyRequest(input *GetModelPackageGroupPolicyInput) (req *request.Request, output *GetModelPackageGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opGetModelPackageGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetModelPackageGroupPolicyInput{}
	}

	output = &GetModelPackageGroupPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModelPackageGroupPolicy API operation for Amazon SageMaker Service.
//
// Gets a resource policy that manages access for a model group. For information
// about resource policies, see Identity-based policies and resource-based policies
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html)
// in the AWS Identity and Access Management User Guide..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation GetModelPackageGroupPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetModelPackageGroupPolicy
func (c *SageMaker) GetModelPackageGroupPolicy(input *GetModelPackageGroupPolicyInput) (*GetModelPackageGroupPolicyOutput, error) {
	req, out := c.GetModelPackageGroupPolicyRequest(input)
	return out, req.Send()
}

// GetModelPackageGroupPolicyWithContext is the same as GetModelPackageGroupPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetModelPackageGroupPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) GetModelPackageGroupPolicyWithContext(ctx aws.Context, input *GetModelPackageGroupPolicyInput, opts ...request.Option) (*GetModelPackageGroupPolicyOutput, error) {
	req, out := c.GetModelPackageGroupPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSagemakerServicecatalogPortfolioStatus = "GetSagemakerServicecatalogPortfolioStatus"

// GetSagemakerServicecatalogPortfolioStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetSagemakerServicecatalogPortfolioStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSagemakerServicecatalogPortfolioStatus for more information on using the GetSagemakerServicecatalogPortfolioStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSagemakerServicecatalogPortfolioStatusRequest method.
//    req, resp := client.GetSagemakerServicecatalogPortfolioStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSagemakerServicecatalogPortfolioStatus
func (c *SageMaker) GetSagemakerServicecatalogPortfolioStatusRequest(input *GetSagemakerServicecatalogPortfolioStatusInput) (req *request.Request, output *GetSagemakerServicecatalogPortfolioStatusOutput) {
	op := &request.Operation{
		Name:       opGetSagemakerServicecatalogPortfolioStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSagemakerServicecatalogPortfolioStatusInput{}
	}

	output = &GetSagemakerServicecatalogPortfolioStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSagemakerServicecatalogPortfolioStatus API operation for Amazon SageMaker Service.
//
// Gets the status of Service Catalog in SageMaker. Service Catalog is used
// to create SageMaker projects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation GetSagemakerServicecatalogPortfolioStatus for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSagemakerServicecatalogPortfolioStatus
func (c *SageMaker) GetSagemakerServicecatalogPortfolioStatus(input *GetSagemakerServicecatalogPortfolioStatusInput) (*GetSagemakerServicecatalogPortfolioStatusOutput, error) {
	req, out := c.GetSagemakerServicecatalogPortfolioStatusRequest(input)
	return out, req.Send()
}

// GetSagemakerServicecatalogPortfolioStatusWithContext is the same as GetSagemakerServicecatalogPortfolioStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetSagemakerServicecatalogPortfolioStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) GetSagemakerServicecatalogPortfolioStatusWithContext(ctx aws.Context, input *GetSagemakerServicecatalogPortfolioStatusInput, opts ...request.Option) (*GetSagemakerServicecatalogPortfolioStatusOutput, error) {
	req, out := c.GetSagemakerServicecatalogPortfolioStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSearchSuggestions = "GetSearchSuggestions"

// GetSearchSuggestionsRequest generates a "aws/request.Request" representing the
// client's request for the GetSearchSuggestions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSearchSuggestions for more information on using the GetSearchSuggestions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSearchSuggestionsRequest method.
//    req, resp := client.GetSearchSuggestionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestions
func (c *SageMaker) GetSearchSuggestionsRequest(input *GetSearchSuggestionsInput) (req *request.Request, output *GetSearchSuggestionsOutput) {
	op := &request.Operation{
		Name:       opGetSearchSuggestions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSearchSuggestionsInput{}
	}

	output = &GetSearchSuggestionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSearchSuggestions API operation for Amazon SageMaker Service.
//
// An auto-complete API for the search functionality in the Amazon SageMaker
// console. It returns suggestions of possible matches for the property name
// to use in Search queries. Provides suggestions for HyperParameters, Tags,
// and Metrics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation GetSearchSuggestions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestions
func (c *SageMaker) GetSearchSuggestions(input *GetSearchSuggestionsInput) (*GetSearchSuggestionsOutput, error) {
	req, out := c.GetSearchSuggestionsRequest(input)
	return out, req.Send()
}

// GetSearchSuggestionsWithContext is the same as GetSearchSuggestions with the addition of
// the ability to pass a context and additional request options.
//
// See GetSearchSuggestions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) GetSearchSuggestionsWithContext(ctx aws.Context, input *GetSearchSuggestionsInput, opts ...request.Option) (*GetSearchSuggestionsOutput, error) {
	req, out := c.GetSearchSuggestionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListActions = "ListActions"

// ListActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActions for more information on using the ListActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListActionsRequest method.
//    req, resp := client.ListActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListActions
func (c *SageMaker) ListActionsRequest(input *ListActionsInput) (req *request.Request, output *ListActionsOutput) {
	op := &request.Operation{
		Name:       opListActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListActionsInput{}
	}

	output = &ListActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActions API operation for Amazon SageMaker Service.
//
// Lists the actions in your account and their properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListActions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListActions
func (c *SageMaker) ListActions(input *ListActionsInput) (*ListActionsOutput, error) {
	req, out := c.ListActionsRequest(input)
	return out, req.Send()
}

// ListActionsWithContext is the same as ListActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListActionsWithContext(ctx aws.Context, input *ListActionsInput, opts ...request.Option) (*ListActionsOutput, error) {
	req, out := c.ListActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListActionsPages iterates over the pages of a ListActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListActions operation.
//    pageNum := 0
//    err := client.ListActionsPages(params,
//        func(page *sagemaker.ListActionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListActionsPages(input *ListActionsInput, fn func(*ListActionsOutput, bool) bool) error {
	return c.ListActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListActionsPagesWithContext same as ListActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListActionsPagesWithContext(ctx aws.Context, input *ListActionsInput, fn func(*ListActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAlgorithms = "ListAlgorithms"

// ListAlgorithmsRequest generates a "aws/request.Request" representing the
// client's request for the ListAlgorithms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAlgorithms for more information on using the ListAlgorithms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAlgorithmsRequest method.
//    req, resp := client.ListAlgorithmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms
func (c *SageMaker) ListAlgorithmsRequest(input *ListAlgorithmsInput) (req *request.Request, output *ListAlgorithmsOutput) {
	op := &request.Operation{
		Name:       opListAlgorithms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAlgorithmsInput{}
	}

	output = &ListAlgorithmsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAlgorithms API operation for Amazon SageMaker Service.
//
// Lists the machine learning algorithms that have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListAlgorithms for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAlgorithms
func (c *SageMaker) ListAlgorithms(input *ListAlgorithmsInput) (*ListAlgorithmsOutput, error) {
	req, out := c.ListAlgorithmsRequest(input)
	return out, req.Send()
}

// ListAlgorithmsWithContext is the same as ListAlgorithms with the addition of
// the ability to pass a context and additional request options.
//
// See ListAlgorithms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAlgorithmsWithContext(ctx aws.Context, input *ListAlgorithmsInput, opts ...request.Option) (*ListAlgorithmsOutput, error) {
	req, out := c.ListAlgorithmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAlgorithmsPages iterates over the pages of a ListAlgorithms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAlgorithms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAlgorithms operation.
//    pageNum := 0
//    err := client.ListAlgorithmsPages(params,
//        func(page *sagemaker.ListAlgorithmsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListAlgorithmsPages(input *ListAlgorithmsInput, fn func(*ListAlgorithmsOutput, bool) bool) error {
	return c.ListAlgorithmsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAlgorithmsPagesWithContext same as ListAlgorithmsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAlgorithmsPagesWithContext(ctx aws.Context, input *ListAlgorithmsInput, fn func(*ListAlgorithmsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAlgorithmsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAlgorithmsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAlgorithmsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAppImageConfigs = "ListAppImageConfigs"

// ListAppImageConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListAppImageConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAppImageConfigs for more information on using the ListAppImageConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAppImageConfigsRequest method.
//    req, resp := client.ListAppImageConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAppImageConfigs
func (c *SageMaker) ListAppImageConfigsRequest(input *ListAppImageConfigsInput) (req *request.Request, output *ListAppImageConfigsOutput) {
	op := &request.Operation{
		Name:       opListAppImageConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppImageConfigsInput{}
	}

	output = &ListAppImageConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAppImageConfigs API operation for Amazon SageMaker Service.
//
// Lists the AppImageConfigs in your account and their properties. The list
// can be filtered by creation time or modified time, and whether the AppImageConfig
// name contains a specified string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListAppImageConfigs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAppImageConfigs
func (c *SageMaker) ListAppImageConfigs(input *ListAppImageConfigsInput) (*ListAppImageConfigsOutput, error) {
	req, out := c.ListAppImageConfigsRequest(input)
	return out, req.Send()
}

// ListAppImageConfigsWithContext is the same as ListAppImageConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListAppImageConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAppImageConfigsWithContext(ctx aws.Context, input *ListAppImageConfigsInput, opts ...request.Option) (*ListAppImageConfigsOutput, error) {
	req, out := c.ListAppImageConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppImageConfigsPages iterates over the pages of a ListAppImageConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAppImageConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAppImageConfigs operation.
//    pageNum := 0
//    err := client.ListAppImageConfigsPages(params,
//        func(page *sagemaker.ListAppImageConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListAppImageConfigsPages(input *ListAppImageConfigsInput, fn func(*ListAppImageConfigsOutput, bool) bool) error {
	return c.ListAppImageConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppImageConfigsPagesWithContext same as ListAppImageConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAppImageConfigsPagesWithContext(ctx aws.Context, input *ListAppImageConfigsInput, fn func(*ListAppImageConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppImageConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppImageConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppImageConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApps = "ListApps"

// ListAppsRequest generates a "aws/request.Request" representing the
// client's request for the ListApps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApps for more information on using the ListApps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAppsRequest method.
//    req, resp := client.ListAppsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps
func (c *SageMaker) ListAppsRequest(input *ListAppsInput) (req *request.Request, output *ListAppsOutput) {
	op := &request.Operation{
		Name:       opListApps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAppsInput{}
	}

	output = &ListAppsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApps API operation for Amazon SageMaker Service.
//
// Lists apps.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListApps for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListApps
func (c *SageMaker) ListApps(input *ListAppsInput) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	return out, req.Send()
}

// ListAppsWithContext is the same as ListApps with the addition of
// the ability to pass a context and additional request options.
//
// See ListApps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAppsWithContext(ctx aws.Context, input *ListAppsInput, opts ...request.Option) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAppsPages iterates over the pages of a ListApps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApps operation.
//    pageNum := 0
//    err := client.ListAppsPages(params,
//        func(page *sagemaker.ListAppsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListAppsPages(input *ListAppsInput, fn func(*ListAppsOutput, bool) bool) error {
	return c.ListAppsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAppsPagesWithContext same as ListAppsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAppsPagesWithContext(ctx aws.Context, input *ListAppsInput, fn func(*ListAppsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAppsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAppsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAppsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListArtifacts = "ListArtifacts"

// ListArtifactsRequest generates a "aws/request.Request" representing the
// client's request for the ListArtifacts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListArtifacts for more information on using the ListArtifacts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListArtifactsRequest method.
//    req, resp := client.ListArtifactsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListArtifacts
func (c *SageMaker) ListArtifactsRequest(input *ListArtifactsInput) (req *request.Request, output *ListArtifactsOutput) {
	op := &request.Operation{
		Name:       opListArtifacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListArtifactsInput{}
	}

	output = &ListArtifactsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListArtifacts API operation for Amazon SageMaker Service.
//
// Lists the artifacts in your account and their properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListArtifacts for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListArtifacts
func (c *SageMaker) ListArtifacts(input *ListArtifactsInput) (*ListArtifactsOutput, error) {
	req, out := c.ListArtifactsRequest(input)
	return out, req.Send()
}

// ListArtifactsWithContext is the same as ListArtifacts with the addition of
// the ability to pass a context and additional request options.
//
// See ListArtifacts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListArtifactsWithContext(ctx aws.Context, input *ListArtifactsInput, opts ...request.Option) (*ListArtifactsOutput, error) {
	req, out := c.ListArtifactsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListArtifactsPages iterates over the pages of a ListArtifacts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListArtifacts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListArtifacts operation.
//    pageNum := 0
//    err := client.ListArtifactsPages(params,
//        func(page *sagemaker.ListArtifactsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListArtifactsPages(input *ListArtifactsInput, fn func(*ListArtifactsOutput, bool) bool) error {
	return c.ListArtifactsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListArtifactsPagesWithContext same as ListArtifactsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListArtifactsPagesWithContext(ctx aws.Context, input *ListArtifactsInput, fn func(*ListArtifactsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListArtifactsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListArtifactsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListArtifactsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssociations = "ListAssociations"

// ListAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociations for more information on using the ListAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociationsRequest method.
//    req, resp := client.ListAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAssociations
func (c *SageMaker) ListAssociationsRequest(input *ListAssociationsInput) (req *request.Request, output *ListAssociationsOutput) {
	op := &request.Operation{
		Name:       opListAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociationsInput{}
	}

	output = &ListAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociations API operation for Amazon SageMaker Service.
//
// Lists the associations in your account and their properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListAssociations for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAssociations
func (c *SageMaker) ListAssociations(input *ListAssociationsInput) (*ListAssociationsOutput, error) {
	req, out := c.ListAssociationsRequest(input)
	return out, req.Send()
}

// ListAssociationsWithContext is the same as ListAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAssociationsWithContext(ctx aws.Context, input *ListAssociationsInput, opts ...request.Option) (*ListAssociationsOutput, error) {
	req, out := c.ListAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssociationsPages iterates over the pages of a ListAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssociations operation.
//    pageNum := 0
//    err := client.ListAssociationsPages(params,
//        func(page *sagemaker.ListAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListAssociationsPages(input *ListAssociationsInput, fn func(*ListAssociationsOutput, bool) bool) error {
	return c.ListAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssociationsPagesWithContext same as ListAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAssociationsPagesWithContext(ctx aws.Context, input *ListAssociationsInput, fn func(*ListAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAutoMLJobs = "ListAutoMLJobs"

// ListAutoMLJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListAutoMLJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAutoMLJobs for more information on using the ListAutoMLJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAutoMLJobsRequest method.
//    req, resp := client.ListAutoMLJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs
func (c *SageMaker) ListAutoMLJobsRequest(input *ListAutoMLJobsInput) (req *request.Request, output *ListAutoMLJobsOutput) {
	op := &request.Operation{
		Name:       opListAutoMLJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAutoMLJobsInput{}
	}

	output = &ListAutoMLJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAutoMLJobs API operation for Amazon SageMaker Service.
//
// Request a list of jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListAutoMLJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs
func (c *SageMaker) ListAutoMLJobs(input *ListAutoMLJobsInput) (*ListAutoMLJobsOutput, error) {
	req, out := c.ListAutoMLJobsRequest(input)
	return out, req.Send()
}

// ListAutoMLJobsWithContext is the same as ListAutoMLJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListAutoMLJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAutoMLJobsWithContext(ctx aws.Context, input *ListAutoMLJobsInput, opts ...request.Option) (*ListAutoMLJobsOutput, error) {
	req, out := c.ListAutoMLJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAutoMLJobsPages iterates over the pages of a ListAutoMLJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAutoMLJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAutoMLJobs operation.
//    pageNum := 0
//    err := client.ListAutoMLJobsPages(params,
//        func(page *sagemaker.ListAutoMLJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListAutoMLJobsPages(input *ListAutoMLJobsInput, fn func(*ListAutoMLJobsOutput, bool) bool) error {
	return c.ListAutoMLJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAutoMLJobsPagesWithContext same as ListAutoMLJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListAutoMLJobsPagesWithContext(ctx aws.Context, input *ListAutoMLJobsInput, fn func(*ListAutoMLJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAutoMLJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAutoMLJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAutoMLJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCandidatesForAutoMLJob = "ListCandidatesForAutoMLJob"

// ListCandidatesForAutoMLJobRequest generates a "aws/request.Request" representing the
// client's request for the ListCandidatesForAutoMLJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCandidatesForAutoMLJob for more information on using the ListCandidatesForAutoMLJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCandidatesForAutoMLJobRequest method.
//    req, resp := client.ListCandidatesForAutoMLJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob
func (c *SageMaker) ListCandidatesForAutoMLJobRequest(input *ListCandidatesForAutoMLJobInput) (req *request.Request, output *ListCandidatesForAutoMLJobOutput) {
	op := &request.Operation{
		Name:       opListCandidatesForAutoMLJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCandidatesForAutoMLJobInput{}
	}

	output = &ListCandidatesForAutoMLJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCandidatesForAutoMLJob API operation for Amazon SageMaker Service.
//
// List the Candidates created for the job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListCandidatesForAutoMLJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCandidatesForAutoMLJob
func (c *SageMaker) ListCandidatesForAutoMLJob(input *ListCandidatesForAutoMLJobInput) (*ListCandidatesForAutoMLJobOutput, error) {
	req, out := c.ListCandidatesForAutoMLJobRequest(input)
	return out, req.Send()
}

// ListCandidatesForAutoMLJobWithContext is the same as ListCandidatesForAutoMLJob with the addition of
// the ability to pass a context and additional request options.
//
// See ListCandidatesForAutoMLJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCandidatesForAutoMLJobWithContext(ctx aws.Context, input *ListCandidatesForAutoMLJobInput, opts ...request.Option) (*ListCandidatesForAutoMLJobOutput, error) {
	req, out := c.ListCandidatesForAutoMLJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCandidatesForAutoMLJobPages iterates over the pages of a ListCandidatesForAutoMLJob operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCandidatesForAutoMLJob method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCandidatesForAutoMLJob operation.
//    pageNum := 0
//    err := client.ListCandidatesForAutoMLJobPages(params,
//        func(page *sagemaker.ListCandidatesForAutoMLJobOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListCandidatesForAutoMLJobPages(input *ListCandidatesForAutoMLJobInput, fn func(*ListCandidatesForAutoMLJobOutput, bool) bool) error {
	return c.ListCandidatesForAutoMLJobPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCandidatesForAutoMLJobPagesWithContext same as ListCandidatesForAutoMLJobPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCandidatesForAutoMLJobPagesWithContext(ctx aws.Context, input *ListCandidatesForAutoMLJobInput, fn func(*ListCandidatesForAutoMLJobOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCandidatesForAutoMLJobInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCandidatesForAutoMLJobRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCandidatesForAutoMLJobOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCodeRepositories = "ListCodeRepositories"

// ListCodeRepositoriesRequest generates a "aws/request.Request" representing the
// client's request for the ListCodeRepositories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCodeRepositories for more information on using the ListCodeRepositories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCodeRepositoriesRequest method.
//    req, resp := client.ListCodeRepositoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories
func (c *SageMaker) ListCodeRepositoriesRequest(input *ListCodeRepositoriesInput) (req *request.Request, output *ListCodeRepositoriesOutput) {
	op := &request.Operation{
		Name:       opListCodeRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCodeRepositoriesInput{}
	}

	output = &ListCodeRepositoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCodeRepositories API operation for Amazon SageMaker Service.
//
// Gets a list of the Git repositories in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListCodeRepositories for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCodeRepositories
func (c *SageMaker) ListCodeRepositories(input *ListCodeRepositoriesInput) (*ListCodeRepositoriesOutput, error) {
	req, out := c.ListCodeRepositoriesRequest(input)
	return out, req.Send()
}

// ListCodeRepositoriesWithContext is the same as ListCodeRepositories with the addition of
// the ability to pass a context and additional request options.
//
// See ListCodeRepositories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCodeRepositoriesWithContext(ctx aws.Context, input *ListCodeRepositoriesInput, opts ...request.Option) (*ListCodeRepositoriesOutput, error) {
	req, out := c.ListCodeRepositoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCodeRepositoriesPages iterates over the pages of a ListCodeRepositories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCodeRepositories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCodeRepositories operation.
//    pageNum := 0
//    err := client.ListCodeRepositoriesPages(params,
//        func(page *sagemaker.ListCodeRepositoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListCodeRepositoriesPages(input *ListCodeRepositoriesInput, fn func(*ListCodeRepositoriesOutput, bool) bool) error {
	return c.ListCodeRepositoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCodeRepositoriesPagesWithContext same as ListCodeRepositoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCodeRepositoriesPagesWithContext(ctx aws.Context, input *ListCodeRepositoriesInput, fn func(*ListCodeRepositoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCodeRepositoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCodeRepositoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCodeRepositoriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCompilationJobs = "ListCompilationJobs"

// ListCompilationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListCompilationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCompilationJobs for more information on using the ListCompilationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCompilationJobsRequest method.
//    req, resp := client.ListCompilationJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs
func (c *SageMaker) ListCompilationJobsRequest(input *ListCompilationJobsInput) (req *request.Request, output *ListCompilationJobsOutput) {
	op := &request.Operation{
		Name:       opListCompilationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCompilationJobsInput{}
	}

	output = &ListCompilationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCompilationJobs API operation for Amazon SageMaker Service.
//
// Lists model compilation jobs that satisfy various filters.
//
// To create a model compilation job, use CreateCompilationJob. To get information
// about a particular model compilation job you have created, use DescribeCompilationJob.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListCompilationJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListCompilationJobs
func (c *SageMaker) ListCompilationJobs(input *ListCompilationJobsInput) (*ListCompilationJobsOutput, error) {
	req, out := c.ListCompilationJobsRequest(input)
	return out, req.Send()
}

// ListCompilationJobsWithContext is the same as ListCompilationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListCompilationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCompilationJobsWithContext(ctx aws.Context, input *ListCompilationJobsInput, opts ...request.Option) (*ListCompilationJobsOutput, error) {
	req, out := c.ListCompilationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCompilationJobsPages iterates over the pages of a ListCompilationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCompilationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCompilationJobs operation.
//    pageNum := 0
//    err := client.ListCompilationJobsPages(params,
//        func(page *sagemaker.ListCompilationJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListCompilationJobsPages(input *ListCompilationJobsInput, fn func(*ListCompilationJobsOutput, bool) bool) error {
	return c.ListCompilationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCompilationJobsPagesWithContext same as ListCompilationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListCompilationJobsPagesWithContext(ctx aws.Context, input *ListCompilationJobsInput, fn func(*ListCompilationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCompilationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCompilationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCompilationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContexts = "ListContexts"

// ListContextsRequest generates a "aws/request.Request" representing the
// client's request for the ListContexts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContexts for more information on using the ListContexts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListContextsRequest method.
//    req, resp := client.ListContextsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListContexts
func (c *SageMaker) ListContextsRequest(input *ListContextsInput) (req *request.Request, output *ListContextsOutput) {
	op := &request.Operation{
		Name:       opListContexts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContextsInput{}
	}

	output = &ListContextsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContexts API operation for Amazon SageMaker Service.
//
// Lists the contexts in your account and their properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListContexts for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListContexts
func (c *SageMaker) ListContexts(input *ListContextsInput) (*ListContextsOutput, error) {
	req, out := c.ListContextsRequest(input)
	return out, req.Send()
}

// ListContextsWithContext is the same as ListContexts with the addition of
// the ability to pass a context and additional request options.
//
// See ListContexts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListContextsWithContext(ctx aws.Context, input *ListContextsInput, opts ...request.Option) (*ListContextsOutput, error) {
	req, out := c.ListContextsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContextsPages iterates over the pages of a ListContexts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContexts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListContexts operation.
//    pageNum := 0
//    err := client.ListContextsPages(params,
//        func(page *sagemaker.ListContextsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListContextsPages(input *ListContextsInput, fn func(*ListContextsOutput, bool) bool) error {
	return c.ListContextsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContextsPagesWithContext same as ListContextsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListContextsPagesWithContext(ctx aws.Context, input *ListContextsInput, fn func(*ListContextsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContextsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContextsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContextsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataQualityJobDefinitions = "ListDataQualityJobDefinitions"

// ListDataQualityJobDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataQualityJobDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataQualityJobDefinitions for more information on using the ListDataQualityJobDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataQualityJobDefinitionsRequest method.
//    req, resp := client.ListDataQualityJobDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDataQualityJobDefinitions
func (c *SageMaker) ListDataQualityJobDefinitionsRequest(input *ListDataQualityJobDefinitionsInput) (req *request.Request, output *ListDataQualityJobDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListDataQualityJobDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataQualityJobDefinitionsInput{}
	}

	output = &ListDataQualityJobDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataQualityJobDefinitions API operation for Amazon SageMaker Service.
//
// Lists the data quality job definitions in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListDataQualityJobDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDataQualityJobDefinitions
func (c *SageMaker) ListDataQualityJobDefinitions(input *ListDataQualityJobDefinitionsInput) (*ListDataQualityJobDefinitionsOutput, error) {
	req, out := c.ListDataQualityJobDefinitionsRequest(input)
	return out, req.Send()
}

// ListDataQualityJobDefinitionsWithContext is the same as ListDataQualityJobDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataQualityJobDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListDataQualityJobDefinitionsWithContext(ctx aws.Context, input *ListDataQualityJobDefinitionsInput, opts ...request.Option) (*ListDataQualityJobDefinitionsOutput, error) {
	req, out := c.ListDataQualityJobDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataQualityJobDefinitionsPages iterates over the pages of a ListDataQualityJobDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataQualityJobDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataQualityJobDefinitions operation.
//    pageNum := 0
//    err := client.ListDataQualityJobDefinitionsPages(params,
//        func(page *sagemaker.ListDataQualityJobDefinitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListDataQualityJobDefinitionsPages(input *ListDataQualityJobDefinitionsInput, fn func(*ListDataQualityJobDefinitionsOutput, bool) bool) error {
	return c.ListDataQualityJobDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataQualityJobDefinitionsPagesWithContext same as ListDataQualityJobDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListDataQualityJobDefinitionsPagesWithContext(ctx aws.Context, input *ListDataQualityJobDefinitionsInput, fn func(*ListDataQualityJobDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataQualityJobDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataQualityJobDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataQualityJobDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeviceFleets = "ListDeviceFleets"

// ListDeviceFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeviceFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeviceFleets for more information on using the ListDeviceFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeviceFleetsRequest method.
//    req, resp := client.ListDeviceFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDeviceFleets
func (c *SageMaker) ListDeviceFleetsRequest(input *ListDeviceFleetsInput) (req *request.Request, output *ListDeviceFleetsOutput) {
	op := &request.Operation{
		Name:       opListDeviceFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeviceFleetsInput{}
	}

	output = &ListDeviceFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeviceFleets API operation for Amazon SageMaker Service.
//
// Returns a list of devices in the fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListDeviceFleets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDeviceFleets
func (c *SageMaker) ListDeviceFleets(input *ListDeviceFleetsInput) (*ListDeviceFleetsOutput, error) {
	req, out := c.ListDeviceFleetsRequest(input)
	return out, req.Send()
}

// ListDeviceFleetsWithContext is the same as ListDeviceFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeviceFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListDeviceFleetsWithContext(ctx aws.Context, input *ListDeviceFleetsInput, opts ...request.Option) (*ListDeviceFleetsOutput, error) {
	req, out := c.ListDeviceFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeviceFleetsPages iterates over the pages of a ListDeviceFleets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeviceFleets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeviceFleets operation.
//    pageNum := 0
//    err := client.ListDeviceFleetsPages(params,
//        func(page *sagemaker.ListDeviceFleetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListDeviceFleetsPages(input *ListDeviceFleetsInput, fn func(*ListDeviceFleetsOutput, bool) bool) error {
	return c.ListDeviceFleetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeviceFleetsPagesWithContext same as ListDeviceFleetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListDeviceFleetsPagesWithContext(ctx aws.Context, input *ListDeviceFleetsInput, fn func(*ListDeviceFleetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeviceFleetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeviceFleetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeviceFleetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevices for more information on using the ListDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDevicesRequest method.
//    req, resp := client.ListDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDevices
func (c *SageMaker) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	output = &ListDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevices API operation for Amazon SageMaker Service.
//
// A list of devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListDevices for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDevices
func (c *SageMaker) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	return out, req.Send()
}

// ListDevicesWithContext is the same as ListDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListDevicesWithContext(ctx aws.Context, input *ListDevicesInput, opts ...request.Option) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDevicesPages iterates over the pages of a ListDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDevices operation.
//    pageNum := 0
//    err := client.ListDevicesPages(params,
//        func(page *sagemaker.ListDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListDevicesPages(input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool) error {
	return c.ListDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDevicesPagesWithContext same as ListDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListDevicesPagesWithContext(ctx aws.Context, input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomains for more information on using the ListDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainsRequest method.
//    req, resp := client.ListDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDomains
func (c *SageMaker) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for Amazon SageMaker Service.
//
// Lists the domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListDomains for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListDomains
func (c *SageMaker) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsPages iterates over the pages of a ListDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDomains operation.
//    pageNum := 0
//    err := client.ListDomainsPages(params,
//        func(page *sagemaker.ListDomainsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListDomainsPages(input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool) error {
	return c.ListDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsPagesWithContext same as ListDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListDomainsPagesWithContext(ctx aws.Context, input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEdgePackagingJobs = "ListEdgePackagingJobs"

// ListEdgePackagingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListEdgePackagingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEdgePackagingJobs for more information on using the ListEdgePackagingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEdgePackagingJobsRequest method.
//    req, resp := client.ListEdgePackagingJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEdgePackagingJobs
func (c *SageMaker) ListEdgePackagingJobsRequest(input *ListEdgePackagingJobsInput) (req *request.Request, output *ListEdgePackagingJobsOutput) {
	op := &request.Operation{
		Name:       opListEdgePackagingJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEdgePackagingJobsInput{}
	}

	output = &ListEdgePackagingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEdgePackagingJobs API operation for Amazon SageMaker Service.
//
// Returns a list of edge packaging jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListEdgePackagingJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEdgePackagingJobs
func (c *SageMaker) ListEdgePackagingJobs(input *ListEdgePackagingJobsInput) (*ListEdgePackagingJobsOutput, error) {
	req, out := c.ListEdgePackagingJobsRequest(input)
	return out, req.Send()
}

// ListEdgePackagingJobsWithContext is the same as ListEdgePackagingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEdgePackagingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEdgePackagingJobsWithContext(ctx aws.Context, input *ListEdgePackagingJobsInput, opts ...request.Option) (*ListEdgePackagingJobsOutput, error) {
	req, out := c.ListEdgePackagingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEdgePackagingJobsPages iterates over the pages of a ListEdgePackagingJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEdgePackagingJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEdgePackagingJobs operation.
//    pageNum := 0
//    err := client.ListEdgePackagingJobsPages(params,
//        func(page *sagemaker.ListEdgePackagingJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListEdgePackagingJobsPages(input *ListEdgePackagingJobsInput, fn func(*ListEdgePackagingJobsOutput, bool) bool) error {
	return c.ListEdgePackagingJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEdgePackagingJobsPagesWithContext same as ListEdgePackagingJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEdgePackagingJobsPagesWithContext(ctx aws.Context, input *ListEdgePackagingJobsInput, fn func(*ListEdgePackagingJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEdgePackagingJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEdgePackagingJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEdgePackagingJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEndpointConfigs = "ListEndpointConfigs"

// ListEndpointConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpointConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpointConfigs for more information on using the ListEndpointConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEndpointConfigsRequest method.
//    req, resp := client.ListEndpointConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs
func (c *SageMaker) ListEndpointConfigsRequest(input *ListEndpointConfigsInput) (req *request.Request, output *ListEndpointConfigsOutput) {
	op := &request.Operation{
		Name:       opListEndpointConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointConfigsInput{}
	}

	output = &ListEndpointConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpointConfigs API operation for Amazon SageMaker Service.
//
// Lists endpoint configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListEndpointConfigs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpointConfigs
func (c *SageMaker) ListEndpointConfigs(input *ListEndpointConfigsInput) (*ListEndpointConfigsOutput, error) {
	req, out := c.ListEndpointConfigsRequest(input)
	return out, req.Send()
}

// ListEndpointConfigsWithContext is the same as ListEndpointConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpointConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointConfigsWithContext(ctx aws.Context, input *ListEndpointConfigsInput, opts ...request.Option) (*ListEndpointConfigsOutput, error) {
	req, out := c.ListEndpointConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEndpointConfigsPages iterates over the pages of a ListEndpointConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpointConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEndpointConfigs operation.
//    pageNum := 0
//    err := client.ListEndpointConfigsPages(params,
//        func(page *sagemaker.ListEndpointConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListEndpointConfigsPages(input *ListEndpointConfigsInput, fn func(*ListEndpointConfigsOutput, bool) bool) error {
	return c.ListEndpointConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEndpointConfigsPagesWithContext same as ListEndpointConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointConfigsPagesWithContext(ctx aws.Context, input *ListEndpointConfigsInput, fn func(*ListEndpointConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEndpointConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEndpointConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEndpointConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEndpoints = "ListEndpoints"

// ListEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpoints for more information on using the ListEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEndpointsRequest method.
//    req, resp := client.ListEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints
func (c *SageMaker) ListEndpointsRequest(input *ListEndpointsInput) (req *request.Request, output *ListEndpointsOutput) {
	op := &request.Operation{
		Name:       opListEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointsInput{}
	}

	output = &ListEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpoints API operation for Amazon SageMaker Service.
//
// Lists endpoints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListEndpoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListEndpoints
func (c *SageMaker) ListEndpoints(input *ListEndpointsInput) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	return out, req.Send()
}

// ListEndpointsWithContext is the same as ListEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointsWithContext(ctx aws.Context, input *ListEndpointsInput, opts ...request.Option) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEndpointsPages iterates over the pages of a ListEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEndpoints operation.
//    pageNum := 0
//    err := client.ListEndpointsPages(params,
//        func(page *sagemaker.ListEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListEndpointsPages(input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool) error {
	return c.ListEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEndpointsPagesWithContext same as ListEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListEndpointsPagesWithContext(ctx aws.Context, input *ListEndpointsInput, fn func(*ListEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListExperiments = "ListExperiments"

// ListExperimentsRequest generates a "aws/request.Request" representing the
// client's request for the ListExperiments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListExperiments for more information on using the ListExperiments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListExperimentsRequest method.
//    req, resp := client.ListExperimentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListExperiments
func (c *SageMaker) ListExperimentsRequest(input *ListExperimentsInput) (req *request.Request, output *ListExperimentsOutput) {
	op := &request.Operation{
		Name:       opListExperiments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListExperimentsInput{}
	}

	output = &ListExperimentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListExperiments API operation for Amazon SageMaker Service.
//
// Lists all the experiments in your account. The list can be filtered to show
// only experiments that were created in a specific time range. The list can
// be sorted by experiment name or creation time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListExperiments for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListExperiments
func (c *SageMaker) ListExperiments(input *ListExperimentsInput) (*ListExperimentsOutput, error) {
	req, out := c.ListExperimentsRequest(input)
	return out, req.Send()
}

// ListExperimentsWithContext is the same as ListExperiments with the addition of
// the ability to pass a context and additional request options.
//
// See ListExperiments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListExperimentsWithContext(ctx aws.Context, input *ListExperimentsInput, opts ...request.Option) (*ListExperimentsOutput, error) {
	req, out := c.ListExperimentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListExperimentsPages iterates over the pages of a ListExperiments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListExperiments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListExperiments operation.
//    pageNum := 0
//    err := client.ListExperimentsPages(params,
//        func(page *sagemaker.ListExperimentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListExperimentsPages(input *ListExperimentsInput, fn func(*ListExperimentsOutput, bool) bool) error {
	return c.ListExperimentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListExperimentsPagesWithContext same as ListExperimentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListExperimentsPagesWithContext(ctx aws.Context, input *ListExperimentsInput, fn func(*ListExperimentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListExperimentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListExperimentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListExperimentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFeatureGroups = "ListFeatureGroups"

// ListFeatureGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListFeatureGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFeatureGroups for more information on using the ListFeatureGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFeatureGroupsRequest method.
//    req, resp := client.ListFeatureGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFeatureGroups
func (c *SageMaker) ListFeatureGroupsRequest(input *ListFeatureGroupsInput) (req *request.Request, output *ListFeatureGroupsOutput) {
	op := &request.Operation{
		Name:       opListFeatureGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFeatureGroupsInput{}
	}

	output = &ListFeatureGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFeatureGroups API operation for Amazon SageMaker Service.
//
// List FeatureGroups based on given filter and order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListFeatureGroups for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFeatureGroups
func (c *SageMaker) ListFeatureGroups(input *ListFeatureGroupsInput) (*ListFeatureGroupsOutput, error) {
	req, out := c.ListFeatureGroupsRequest(input)
	return out, req.Send()
}

// ListFeatureGroupsWithContext is the same as ListFeatureGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListFeatureGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListFeatureGroupsWithContext(ctx aws.Context, input *ListFeatureGroupsInput, opts ...request.Option) (*ListFeatureGroupsOutput, error) {
	req, out := c.ListFeatureGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFeatureGroupsPages iterates over the pages of a ListFeatureGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFeatureGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFeatureGroups operation.
//    pageNum := 0
//    err := client.ListFeatureGroupsPages(params,
//        func(page *sagemaker.ListFeatureGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListFeatureGroupsPages(input *ListFeatureGroupsInput, fn func(*ListFeatureGroupsOutput, bool) bool) error {
	return c.ListFeatureGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFeatureGroupsPagesWithContext same as ListFeatureGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListFeatureGroupsPagesWithContext(ctx aws.Context, input *ListFeatureGroupsInput, fn func(*ListFeatureGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFeatureGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFeatureGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFeatureGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFlowDefinitions = "ListFlowDefinitions"

// ListFlowDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFlowDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlowDefinitions for more information on using the ListFlowDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFlowDefinitionsRequest method.
//    req, resp := client.ListFlowDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFlowDefinitions
func (c *SageMaker) ListFlowDefinitionsRequest(input *ListFlowDefinitionsInput) (req *request.Request, output *ListFlowDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListFlowDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlowDefinitionsInput{}
	}

	output = &ListFlowDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlowDefinitions API operation for Amazon SageMaker Service.
//
// Returns information about the flow definitions in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListFlowDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListFlowDefinitions
func (c *SageMaker) ListFlowDefinitions(input *ListFlowDefinitionsInput) (*ListFlowDefinitionsOutput, error) {
	req, out := c.ListFlowDefinitionsRequest(input)
	return out, req.Send()
}

// ListFlowDefinitionsWithContext is the same as ListFlowDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlowDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListFlowDefinitionsWithContext(ctx aws.Context, input *ListFlowDefinitionsInput, opts ...request.Option) (*ListFlowDefinitionsOutput, error) {
	req, out := c.ListFlowDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlowDefinitionsPages iterates over the pages of a ListFlowDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlowDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFlowDefinitions operation.
//    pageNum := 0
//    err := client.ListFlowDefinitionsPages(params,
//        func(page *sagemaker.ListFlowDefinitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListFlowDefinitionsPages(input *ListFlowDefinitionsInput, fn func(*ListFlowDefinitionsOutput, bool) bool) error {
	return c.ListFlowDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlowDefinitionsPagesWithContext same as ListFlowDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListFlowDefinitionsPagesWithContext(ctx aws.Context, input *ListFlowDefinitionsInput, fn func(*ListFlowDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlowDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlowDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFlowDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHumanTaskUis = "ListHumanTaskUis"

// ListHumanTaskUisRequest generates a "aws/request.Request" representing the
// client's request for the ListHumanTaskUis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHumanTaskUis for more information on using the ListHumanTaskUis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHumanTaskUisRequest method.
//    req, resp := client.ListHumanTaskUisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHumanTaskUis
func (c *SageMaker) ListHumanTaskUisRequest(input *ListHumanTaskUisInput) (req *request.Request, output *ListHumanTaskUisOutput) {
	op := &request.Operation{
		Name:       opListHumanTaskUis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHumanTaskUisInput{}
	}

	output = &ListHumanTaskUisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHumanTaskUis API operation for Amazon SageMaker Service.
//
// Returns information about the human task user interfaces in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListHumanTaskUis for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHumanTaskUis
func (c *SageMaker) ListHumanTaskUis(input *ListHumanTaskUisInput) (*ListHumanTaskUisOutput, error) {
	req, out := c.ListHumanTaskUisRequest(input)
	return out, req.Send()
}

// ListHumanTaskUisWithContext is the same as ListHumanTaskUis with the addition of
// the ability to pass a context and additional request options.
//
// See ListHumanTaskUis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListHumanTaskUisWithContext(ctx aws.Context, input *ListHumanTaskUisInput, opts ...request.Option) (*ListHumanTaskUisOutput, error) {
	req, out := c.ListHumanTaskUisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHumanTaskUisPages iterates over the pages of a ListHumanTaskUis operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHumanTaskUis method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHumanTaskUis operation.
//    pageNum := 0
//    err := client.ListHumanTaskUisPages(params,
//        func(page *sagemaker.ListHumanTaskUisOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListHumanTaskUisPages(input *ListHumanTaskUisInput, fn func(*ListHumanTaskUisOutput, bool) bool) error {
	return c.ListHumanTaskUisPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHumanTaskUisPagesWithContext same as ListHumanTaskUisPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListHumanTaskUisPagesWithContext(ctx aws.Context, input *ListHumanTaskUisInput, fn func(*ListHumanTaskUisOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHumanTaskUisInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHumanTaskUisRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHumanTaskUisOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHyperParameterTuningJobs = "ListHyperParameterTuningJobs"

// ListHyperParameterTuningJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListHyperParameterTuningJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHyperParameterTuningJobs for more information on using the ListHyperParameterTuningJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHyperParameterTuningJobsRequest method.
//    req, resp := client.ListHyperParameterTuningJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs
func (c *SageMaker) ListHyperParameterTuningJobsRequest(input *ListHyperParameterTuningJobsInput) (req *request.Request, output *ListHyperParameterTuningJobsOutput) {
	op := &request.Operation{
		Name:       opListHyperParameterTuningJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHyperParameterTuningJobsInput{}
	}

	output = &ListHyperParameterTuningJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHyperParameterTuningJobs API operation for Amazon SageMaker Service.
//
// Gets a list of HyperParameterTuningJobSummary objects that describe the hyperparameter
// tuning jobs launched in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListHyperParameterTuningJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListHyperParameterTuningJobs
func (c *SageMaker) ListHyperParameterTuningJobs(input *ListHyperParameterTuningJobsInput) (*ListHyperParameterTuningJobsOutput, error) {
	req, out := c.ListHyperParameterTuningJobsRequest(input)
	return out, req.Send()
}

// ListHyperParameterTuningJobsWithContext is the same as ListHyperParameterTuningJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListHyperParameterTuningJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListHyperParameterTuningJobsWithContext(ctx aws.Context, input *ListHyperParameterTuningJobsInput, opts ...request.Option) (*ListHyperParameterTuningJobsOutput, error) {
	req, out := c.ListHyperParameterTuningJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHyperParameterTuningJobsPages iterates over the pages of a ListHyperParameterTuningJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHyperParameterTuningJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHyperParameterTuningJobs operation.
//    pageNum := 0
//    err := client.ListHyperParameterTuningJobsPages(params,
//        func(page *sagemaker.ListHyperParameterTuningJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListHyperParameterTuningJobsPages(input *ListHyperParameterTuningJobsInput, fn func(*ListHyperParameterTuningJobsOutput, bool) bool) error {
	return c.ListHyperParameterTuningJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHyperParameterTuningJobsPagesWithContext same as ListHyperParameterTuningJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListHyperParameterTuningJobsPagesWithContext(ctx aws.Context, input *ListHyperParameterTuningJobsInput, fn func(*ListHyperParameterTuningJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHyperParameterTuningJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHyperParameterTuningJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHyperParameterTuningJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImageVersions = "ListImageVersions"

// ListImageVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListImageVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImageVersions for more information on using the ListImageVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListImageVersionsRequest method.
//    req, resp := client.ListImageVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImageVersions
func (c *SageMaker) ListImageVersionsRequest(input *ListImageVersionsInput) (req *request.Request, output *ListImageVersionsOutput) {
	op := &request.Operation{
		Name:       opListImageVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImageVersionsInput{}
	}

	output = &ListImageVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImageVersions API operation for Amazon SageMaker Service.
//
// Lists the versions of a specified image and their properties. The list can
// be filtered by creation time or modified time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListImageVersions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImageVersions
func (c *SageMaker) ListImageVersions(input *ListImageVersionsInput) (*ListImageVersionsOutput, error) {
	req, out := c.ListImageVersionsRequest(input)
	return out, req.Send()
}

// ListImageVersionsWithContext is the same as ListImageVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListImageVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListImageVersionsWithContext(ctx aws.Context, input *ListImageVersionsInput, opts ...request.Option) (*ListImageVersionsOutput, error) {
	req, out := c.ListImageVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImageVersionsPages iterates over the pages of a ListImageVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImageVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListImageVersions operation.
//    pageNum := 0
//    err := client.ListImageVersionsPages(params,
//        func(page *sagemaker.ListImageVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListImageVersionsPages(input *ListImageVersionsInput, fn func(*ListImageVersionsOutput, bool) bool) error {
	return c.ListImageVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImageVersionsPagesWithContext same as ListImageVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListImageVersionsPagesWithContext(ctx aws.Context, input *ListImageVersionsInput, fn func(*ListImageVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImageVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImageVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImageVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImages = "ListImages"

// ListImagesRequest generates a "aws/request.Request" representing the
// client's request for the ListImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImages for more information on using the ListImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListImagesRequest method.
//    req, resp := client.ListImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImages
func (c *SageMaker) ListImagesRequest(input *ListImagesInput) (req *request.Request, output *ListImagesOutput) {
	op := &request.Operation{
		Name:       opListImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImagesInput{}
	}

	output = &ListImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImages API operation for Amazon SageMaker Service.
//
// Lists the images in your account and their properties. The list can be filtered
// by creation time or modified time, and whether the image name contains a
// specified string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListImages for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListImages
func (c *SageMaker) ListImages(input *ListImagesInput) (*ListImagesOutput, error) {
	req, out := c.ListImagesRequest(input)
	return out, req.Send()
}

// ListImagesWithContext is the same as ListImages with the addition of
// the ability to pass a context and additional request options.
//
// See ListImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListImagesWithContext(ctx aws.Context, input *ListImagesInput, opts ...request.Option) (*ListImagesOutput, error) {
	req, out := c.ListImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImagesPages iterates over the pages of a ListImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListImages operation.
//    pageNum := 0
//    err := client.ListImagesPages(params,
//        func(page *sagemaker.ListImagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListImagesPages(input *ListImagesInput, fn func(*ListImagesOutput, bool) bool) error {
	return c.ListImagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImagesPagesWithContext same as ListImagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListImagesPagesWithContext(ctx aws.Context, input *ListImagesInput, fn func(*ListImagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLabelingJobs = "ListLabelingJobs"

// ListLabelingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListLabelingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLabelingJobs for more information on using the ListLabelingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLabelingJobsRequest method.
//    req, resp := client.ListLabelingJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs
func (c *SageMaker) ListLabelingJobsRequest(input *ListLabelingJobsInput) (req *request.Request, output *ListLabelingJobsOutput) {
	op := &request.Operation{
		Name:       opListLabelingJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLabelingJobsInput{}
	}

	output = &ListLabelingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLabelingJobs API operation for Amazon SageMaker Service.
//
// Gets a list of labeling jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListLabelingJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobs
func (c *SageMaker) ListLabelingJobs(input *ListLabelingJobsInput) (*ListLabelingJobsOutput, error) {
	req, out := c.ListLabelingJobsRequest(input)
	return out, req.Send()
}

// ListLabelingJobsWithContext is the same as ListLabelingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListLabelingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListLabelingJobsWithContext(ctx aws.Context, input *ListLabelingJobsInput, opts ...request.Option) (*ListLabelingJobsOutput, error) {
	req, out := c.ListLabelingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLabelingJobsPages iterates over the pages of a ListLabelingJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLabelingJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLabelingJobs operation.
//    pageNum := 0
//    err := client.ListLabelingJobsPages(params,
//        func(page *sagemaker.ListLabelingJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListLabelingJobsPages(input *ListLabelingJobsInput, fn func(*ListLabelingJobsOutput, bool) bool) error {
	return c.ListLabelingJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLabelingJobsPagesWithContext same as ListLabelingJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListLabelingJobsPagesWithContext(ctx aws.Context, input *ListLabelingJobsInput, fn func(*ListLabelingJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLabelingJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLabelingJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLabelingJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLabelingJobsForWorkteam = "ListLabelingJobsForWorkteam"

// ListLabelingJobsForWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the ListLabelingJobsForWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLabelingJobsForWorkteam for more information on using the ListLabelingJobsForWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLabelingJobsForWorkteamRequest method.
//    req, resp := client.ListLabelingJobsForWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam
func (c *SageMaker) ListLabelingJobsForWorkteamRequest(input *ListLabelingJobsForWorkteamInput) (req *request.Request, output *ListLabelingJobsForWorkteamOutput) {
	op := &request.Operation{
		Name:       opListLabelingJobsForWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLabelingJobsForWorkteamInput{}
	}

	output = &ListLabelingJobsForWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLabelingJobsForWorkteam API operation for Amazon SageMaker Service.
//
// Gets a list of labeling jobs assigned to a specified work team.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListLabelingJobsForWorkteam for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam
func (c *SageMaker) ListLabelingJobsForWorkteam(input *ListLabelingJobsForWorkteamInput) (*ListLabelingJobsForWorkteamOutput, error) {
	req, out := c.ListLabelingJobsForWorkteamRequest(input)
	return out, req.Send()
}

// ListLabelingJobsForWorkteamWithContext is the same as ListLabelingJobsForWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See ListLabelingJobsForWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListLabelingJobsForWorkteamWithContext(ctx aws.Context, input *ListLabelingJobsForWorkteamInput, opts ...request.Option) (*ListLabelingJobsForWorkteamOutput, error) {
	req, out := c.ListLabelingJobsForWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLabelingJobsForWorkteamPages iterates over the pages of a ListLabelingJobsForWorkteam operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLabelingJobsForWorkteam method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLabelingJobsForWorkteam operation.
//    pageNum := 0
//    err := client.ListLabelingJobsForWorkteamPages(params,
//        func(page *sagemaker.ListLabelingJobsForWorkteamOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListLabelingJobsForWorkteamPages(input *ListLabelingJobsForWorkteamInput, fn func(*ListLabelingJobsForWorkteamOutput, bool) bool) error {
	return c.ListLabelingJobsForWorkteamPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLabelingJobsForWorkteamPagesWithContext same as ListLabelingJobsForWorkteamPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListLabelingJobsForWorkteamPagesWithContext(ctx aws.Context, input *ListLabelingJobsForWorkteamInput, fn func(*ListLabelingJobsForWorkteamOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLabelingJobsForWorkteamInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLabelingJobsForWorkteamRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLabelingJobsForWorkteamOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModelBiasJobDefinitions = "ListModelBiasJobDefinitions"

// ListModelBiasJobDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListModelBiasJobDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModelBiasJobDefinitions for more information on using the ListModelBiasJobDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListModelBiasJobDefinitionsRequest method.
//    req, resp := client.ListModelBiasJobDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelBiasJobDefinitions
func (c *SageMaker) ListModelBiasJobDefinitionsRequest(input *ListModelBiasJobDefinitionsInput) (req *request.Request, output *ListModelBiasJobDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListModelBiasJobDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelBiasJobDefinitionsInput{}
	}

	output = &ListModelBiasJobDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModelBiasJobDefinitions API operation for Amazon SageMaker Service.
//
// Lists model bias jobs definitions that satisfy various filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListModelBiasJobDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelBiasJobDefinitions
func (c *SageMaker) ListModelBiasJobDefinitions(input *ListModelBiasJobDefinitionsInput) (*ListModelBiasJobDefinitionsOutput, error) {
	req, out := c.ListModelBiasJobDefinitionsRequest(input)
	return out, req.Send()
}

// ListModelBiasJobDefinitionsWithContext is the same as ListModelBiasJobDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelBiasJobDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelBiasJobDefinitionsWithContext(ctx aws.Context, input *ListModelBiasJobDefinitionsInput, opts ...request.Option) (*ListModelBiasJobDefinitionsOutput, error) {
	req, out := c.ListModelBiasJobDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelBiasJobDefinitionsPages iterates over the pages of a ListModelBiasJobDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModelBiasJobDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListModelBiasJobDefinitions operation.
//    pageNum := 0
//    err := client.ListModelBiasJobDefinitionsPages(params,
//        func(page *sagemaker.ListModelBiasJobDefinitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListModelBiasJobDefinitionsPages(input *ListModelBiasJobDefinitionsInput, fn func(*ListModelBiasJobDefinitionsOutput, bool) bool) error {
	return c.ListModelBiasJobDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelBiasJobDefinitionsPagesWithContext same as ListModelBiasJobDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelBiasJobDefinitionsPagesWithContext(ctx aws.Context, input *ListModelBiasJobDefinitionsInput, fn func(*ListModelBiasJobDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelBiasJobDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelBiasJobDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelBiasJobDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModelExplainabilityJobDefinitions = "ListModelExplainabilityJobDefinitions"

// ListModelExplainabilityJobDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListModelExplainabilityJobDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModelExplainabilityJobDefinitions for more information on using the ListModelExplainabilityJobDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListModelExplainabilityJobDefinitionsRequest method.
//    req, resp := client.ListModelExplainabilityJobDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelExplainabilityJobDefinitions
func (c *SageMaker) ListModelExplainabilityJobDefinitionsRequest(input *ListModelExplainabilityJobDefinitionsInput) (req *request.Request, output *ListModelExplainabilityJobDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListModelExplainabilityJobDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelExplainabilityJobDefinitionsInput{}
	}

	output = &ListModelExplainabilityJobDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModelExplainabilityJobDefinitions API operation for Amazon SageMaker Service.
//
// Lists model explainability job definitions that satisfy various filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListModelExplainabilityJobDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelExplainabilityJobDefinitions
func (c *SageMaker) ListModelExplainabilityJobDefinitions(input *ListModelExplainabilityJobDefinitionsInput) (*ListModelExplainabilityJobDefinitionsOutput, error) {
	req, out := c.ListModelExplainabilityJobDefinitionsRequest(input)
	return out, req.Send()
}

// ListModelExplainabilityJobDefinitionsWithContext is the same as ListModelExplainabilityJobDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelExplainabilityJobDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelExplainabilityJobDefinitionsWithContext(ctx aws.Context, input *ListModelExplainabilityJobDefinitionsInput, opts ...request.Option) (*ListModelExplainabilityJobDefinitionsOutput, error) {
	req, out := c.ListModelExplainabilityJobDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelExplainabilityJobDefinitionsPages iterates over the pages of a ListModelExplainabilityJobDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModelExplainabilityJobDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListModelExplainabilityJobDefinitions operation.
//    pageNum := 0
//    err := client.ListModelExplainabilityJobDefinitionsPages(params,
//        func(page *sagemaker.ListModelExplainabilityJobDefinitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListModelExplainabilityJobDefinitionsPages(input *ListModelExplainabilityJobDefinitionsInput, fn func(*ListModelExplainabilityJobDefinitionsOutput, bool) bool) error {
	return c.ListModelExplainabilityJobDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelExplainabilityJobDefinitionsPagesWithContext same as ListModelExplainabilityJobDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelExplainabilityJobDefinitionsPagesWithContext(ctx aws.Context, input *ListModelExplainabilityJobDefinitionsInput, fn func(*ListModelExplainabilityJobDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelExplainabilityJobDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelExplainabilityJobDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelExplainabilityJobDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModelPackageGroups = "ListModelPackageGroups"

// ListModelPackageGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListModelPackageGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModelPackageGroups for more information on using the ListModelPackageGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListModelPackageGroupsRequest method.
//    req, resp := client.ListModelPackageGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackageGroups
func (c *SageMaker) ListModelPackageGroupsRequest(input *ListModelPackageGroupsInput) (req *request.Request, output *ListModelPackageGroupsOutput) {
	op := &request.Operation{
		Name:       opListModelPackageGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelPackageGroupsInput{}
	}

	output = &ListModelPackageGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModelPackageGroups API operation for Amazon SageMaker Service.
//
// Gets a list of the model groups in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListModelPackageGroups for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackageGroups
func (c *SageMaker) ListModelPackageGroups(input *ListModelPackageGroupsInput) (*ListModelPackageGroupsOutput, error) {
	req, out := c.ListModelPackageGroupsRequest(input)
	return out, req.Send()
}

// ListModelPackageGroupsWithContext is the same as ListModelPackageGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelPackageGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelPackageGroupsWithContext(ctx aws.Context, input *ListModelPackageGroupsInput, opts ...request.Option) (*ListModelPackageGroupsOutput, error) {
	req, out := c.ListModelPackageGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelPackageGroupsPages iterates over the pages of a ListModelPackageGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModelPackageGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListModelPackageGroups operation.
//    pageNum := 0
//    err := client.ListModelPackageGroupsPages(params,
//        func(page *sagemaker.ListModelPackageGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListModelPackageGroupsPages(input *ListModelPackageGroupsInput, fn func(*ListModelPackageGroupsOutput, bool) bool) error {
	return c.ListModelPackageGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelPackageGroupsPagesWithContext same as ListModelPackageGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelPackageGroupsPagesWithContext(ctx aws.Context, input *ListModelPackageGroupsInput, fn func(*ListModelPackageGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelPackageGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelPackageGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelPackageGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModelPackages = "ListModelPackages"

// ListModelPackagesRequest generates a "aws/request.Request" representing the
// client's request for the ListModelPackages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModelPackages for more information on using the ListModelPackages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListModelPackagesRequest method.
//    req, resp := client.ListModelPackagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages
func (c *SageMaker) ListModelPackagesRequest(input *ListModelPackagesInput) (req *request.Request, output *ListModelPackagesOutput) {
	op := &request.Operation{
		Name:       opListModelPackages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelPackagesInput{}
	}

	output = &ListModelPackagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModelPackages API operation for Amazon SageMaker Service.
//
// Lists the model packages that have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListModelPackages for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages
func (c *SageMaker) ListModelPackages(input *ListModelPackagesInput) (*ListModelPackagesOutput, error) {
	req, out := c.ListModelPackagesRequest(input)
	return out, req.Send()
}

// ListModelPackagesWithContext is the same as ListModelPackages with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelPackages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelPackagesWithContext(ctx aws.Context, input *ListModelPackagesInput, opts ...request.Option) (*ListModelPackagesOutput, error) {
	req, out := c.ListModelPackagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelPackagesPages iterates over the pages of a ListModelPackages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModelPackages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListModelPackages operation.
//    pageNum := 0
//    err := client.ListModelPackagesPages(params,
//        func(page *sagemaker.ListModelPackagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListModelPackagesPages(input *ListModelPackagesInput, fn func(*ListModelPackagesOutput, bool) bool) error {
	return c.ListModelPackagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelPackagesPagesWithContext same as ListModelPackagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelPackagesPagesWithContext(ctx aws.Context, input *ListModelPackagesInput, fn func(*ListModelPackagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelPackagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelPackagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelPackagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModelQualityJobDefinitions = "ListModelQualityJobDefinitions"

// ListModelQualityJobDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListModelQualityJobDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModelQualityJobDefinitions for more information on using the ListModelQualityJobDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListModelQualityJobDefinitionsRequest method.
//    req, resp := client.ListModelQualityJobDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelQualityJobDefinitions
func (c *SageMaker) ListModelQualityJobDefinitionsRequest(input *ListModelQualityJobDefinitionsInput) (req *request.Request, output *ListModelQualityJobDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListModelQualityJobDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelQualityJobDefinitionsInput{}
	}

	output = &ListModelQualityJobDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModelQualityJobDefinitions API operation for Amazon SageMaker Service.
//
// Gets a list of model quality monitoring job definitions in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListModelQualityJobDefinitions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelQualityJobDefinitions
func (c *SageMaker) ListModelQualityJobDefinitions(input *ListModelQualityJobDefinitionsInput) (*ListModelQualityJobDefinitionsOutput, error) {
	req, out := c.ListModelQualityJobDefinitionsRequest(input)
	return out, req.Send()
}

// ListModelQualityJobDefinitionsWithContext is the same as ListModelQualityJobDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelQualityJobDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelQualityJobDefinitionsWithContext(ctx aws.Context, input *ListModelQualityJobDefinitionsInput, opts ...request.Option) (*ListModelQualityJobDefinitionsOutput, error) {
	req, out := c.ListModelQualityJobDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelQualityJobDefinitionsPages iterates over the pages of a ListModelQualityJobDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModelQualityJobDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListModelQualityJobDefinitions operation.
//    pageNum := 0
//    err := client.ListModelQualityJobDefinitionsPages(params,
//        func(page *sagemaker.ListModelQualityJobDefinitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListModelQualityJobDefinitionsPages(input *ListModelQualityJobDefinitionsInput, fn func(*ListModelQualityJobDefinitionsOutput, bool) bool) error {
	return c.ListModelQualityJobDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelQualityJobDefinitionsPagesWithContext same as ListModelQualityJobDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelQualityJobDefinitionsPagesWithContext(ctx aws.Context, input *ListModelQualityJobDefinitionsInput, fn func(*ListModelQualityJobDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelQualityJobDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelQualityJobDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelQualityJobDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModels = "ListModels"

// ListModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModels for more information on using the ListModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListModelsRequest method.
//    req, resp := client.ListModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels
func (c *SageMaker) ListModelsRequest(input *ListModelsInput) (req *request.Request, output *ListModelsOutput) {
	op := &request.Operation{
		Name:       opListModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelsInput{}
	}

	output = &ListModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModels API operation for Amazon SageMaker Service.
//
// Lists models created with the CreateModel API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListModels for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModels
func (c *SageMaker) ListModels(input *ListModelsInput) (*ListModelsOutput, error) {
	req, out := c.ListModelsRequest(input)
	return out, req.Send()
}

// ListModelsWithContext is the same as ListModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelsWithContext(ctx aws.Context, input *ListModelsInput, opts ...request.Option) (*ListModelsOutput, error) {
	req, out := c.ListModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelsPages iterates over the pages of a ListModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListModels operation.
//    pageNum := 0
//    err := client.ListModelsPages(params,
//        func(page *sagemaker.ListModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListModelsPages(input *ListModelsInput, fn func(*ListModelsOutput, bool) bool) error {
	return c.ListModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelsPagesWithContext same as ListModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListModelsPagesWithContext(ctx aws.Context, input *ListModelsInput, fn func(*ListModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMonitoringExecutions = "ListMonitoringExecutions"

// ListMonitoringExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListMonitoringExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMonitoringExecutions for more information on using the ListMonitoringExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMonitoringExecutionsRequest method.
//    req, resp := client.ListMonitoringExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringExecutions
func (c *SageMaker) ListMonitoringExecutionsRequest(input *ListMonitoringExecutionsInput) (req *request.Request, output *ListMonitoringExecutionsOutput) {
	op := &request.Operation{
		Name:       opListMonitoringExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMonitoringExecutionsInput{}
	}

	output = &ListMonitoringExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMonitoringExecutions API operation for Amazon SageMaker Service.
//
// Returns list of all monitoring job executions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListMonitoringExecutions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringExecutions
func (c *SageMaker) ListMonitoringExecutions(input *ListMonitoringExecutionsInput) (*ListMonitoringExecutionsOutput, error) {
	req, out := c.ListMonitoringExecutionsRequest(input)
	return out, req.Send()
}

// ListMonitoringExecutionsWithContext is the same as ListMonitoringExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListMonitoringExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListMonitoringExecutionsWithContext(ctx aws.Context, input *ListMonitoringExecutionsInput, opts ...request.Option) (*ListMonitoringExecutionsOutput, error) {
	req, out := c.ListMonitoringExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMonitoringExecutionsPages iterates over the pages of a ListMonitoringExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMonitoringExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMonitoringExecutions operation.
//    pageNum := 0
//    err := client.ListMonitoringExecutionsPages(params,
//        func(page *sagemaker.ListMonitoringExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListMonitoringExecutionsPages(input *ListMonitoringExecutionsInput, fn func(*ListMonitoringExecutionsOutput, bool) bool) error {
	return c.ListMonitoringExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMonitoringExecutionsPagesWithContext same as ListMonitoringExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListMonitoringExecutionsPagesWithContext(ctx aws.Context, input *ListMonitoringExecutionsInput, fn func(*ListMonitoringExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMonitoringExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMonitoringExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMonitoringExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMonitoringSchedules = "ListMonitoringSchedules"

// ListMonitoringSchedulesRequest generates a "aws/request.Request" representing the
// client's request for the ListMonitoringSchedules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMonitoringSchedules for more information on using the ListMonitoringSchedules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMonitoringSchedulesRequest method.
//    req, resp := client.ListMonitoringSchedulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringSchedules
func (c *SageMaker) ListMonitoringSchedulesRequest(input *ListMonitoringSchedulesInput) (req *request.Request, output *ListMonitoringSchedulesOutput) {
	op := &request.Operation{
		Name:       opListMonitoringSchedules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMonitoringSchedulesInput{}
	}

	output = &ListMonitoringSchedulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMonitoringSchedules API operation for Amazon SageMaker Service.
//
// Returns list of all monitoring schedules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListMonitoringSchedules for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringSchedules
func (c *SageMaker) ListMonitoringSchedules(input *ListMonitoringSchedulesInput) (*ListMonitoringSchedulesOutput, error) {
	req, out := c.ListMonitoringSchedulesRequest(input)
	return out, req.Send()
}

// ListMonitoringSchedulesWithContext is the same as ListMonitoringSchedules with the addition of
// the ability to pass a context and additional request options.
//
// See ListMonitoringSchedules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListMonitoringSchedulesWithContext(ctx aws.Context, input *ListMonitoringSchedulesInput, opts ...request.Option) (*ListMonitoringSchedulesOutput, error) {
	req, out := c.ListMonitoringSchedulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMonitoringSchedulesPages iterates over the pages of a ListMonitoringSchedules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMonitoringSchedules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMonitoringSchedules operation.
//    pageNum := 0
//    err := client.ListMonitoringSchedulesPages(params,
//        func(page *sagemaker.ListMonitoringSchedulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListMonitoringSchedulesPages(input *ListMonitoringSchedulesInput, fn func(*ListMonitoringSchedulesOutput, bool) bool) error {
	return c.ListMonitoringSchedulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMonitoringSchedulesPagesWithContext same as ListMonitoringSchedulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListMonitoringSchedulesPagesWithContext(ctx aws.Context, input *ListMonitoringSchedulesInput, fn func(*ListMonitoringSchedulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMonitoringSchedulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMonitoringSchedulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMonitoringSchedulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotebookInstanceLifecycleConfigs = "ListNotebookInstanceLifecycleConfigs"

// ListNotebookInstanceLifecycleConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListNotebookInstanceLifecycleConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotebookInstanceLifecycleConfigs for more information on using the ListNotebookInstanceLifecycleConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotebookInstanceLifecycleConfigsRequest method.
//    req, resp := client.ListNotebookInstanceLifecycleConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsRequest(input *ListNotebookInstanceLifecycleConfigsInput) (req *request.Request, output *ListNotebookInstanceLifecycleConfigsOutput) {
	op := &request.Operation{
		Name:       opListNotebookInstanceLifecycleConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotebookInstanceLifecycleConfigsInput{}
	}

	output = &ListNotebookInstanceLifecycleConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotebookInstanceLifecycleConfigs API operation for Amazon SageMaker Service.
//
// Lists notebook instance lifestyle configurations created with the CreateNotebookInstanceLifecycleConfig
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListNotebookInstanceLifecycleConfigs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstanceLifecycleConfigs
func (c *SageMaker) ListNotebookInstanceLifecycleConfigs(input *ListNotebookInstanceLifecycleConfigsInput) (*ListNotebookInstanceLifecycleConfigsOutput, error) {
	req, out := c.ListNotebookInstanceLifecycleConfigsRequest(input)
	return out, req.Send()
}

// ListNotebookInstanceLifecycleConfigsWithContext is the same as ListNotebookInstanceLifecycleConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotebookInstanceLifecycleConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsWithContext(ctx aws.Context, input *ListNotebookInstanceLifecycleConfigsInput, opts ...request.Option) (*ListNotebookInstanceLifecycleConfigsOutput, error) {
	req, out := c.ListNotebookInstanceLifecycleConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotebookInstanceLifecycleConfigsPages iterates over the pages of a ListNotebookInstanceLifecycleConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotebookInstanceLifecycleConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotebookInstanceLifecycleConfigs operation.
//    pageNum := 0
//    err := client.ListNotebookInstanceLifecycleConfigsPages(params,
//        func(page *sagemaker.ListNotebookInstanceLifecycleConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsPages(input *ListNotebookInstanceLifecycleConfigsInput, fn func(*ListNotebookInstanceLifecycleConfigsOutput, bool) bool) error {
	return c.ListNotebookInstanceLifecycleConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotebookInstanceLifecycleConfigsPagesWithContext same as ListNotebookInstanceLifecycleConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstanceLifecycleConfigsPagesWithContext(ctx aws.Context, input *ListNotebookInstanceLifecycleConfigsInput, fn func(*ListNotebookInstanceLifecycleConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotebookInstanceLifecycleConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotebookInstanceLifecycleConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotebookInstanceLifecycleConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotebookInstances = "ListNotebookInstances"

// ListNotebookInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListNotebookInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotebookInstances for more information on using the ListNotebookInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotebookInstancesRequest method.
//    req, resp := client.ListNotebookInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances
func (c *SageMaker) ListNotebookInstancesRequest(input *ListNotebookInstancesInput) (req *request.Request, output *ListNotebookInstancesOutput) {
	op := &request.Operation{
		Name:       opListNotebookInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotebookInstancesInput{}
	}

	output = &ListNotebookInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotebookInstances API operation for Amazon SageMaker Service.
//
// Returns a list of the Amazon SageMaker notebook instances in the requester's
// account in an AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListNotebookInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListNotebookInstances
func (c *SageMaker) ListNotebookInstances(input *ListNotebookInstancesInput) (*ListNotebookInstancesOutput, error) {
	req, out := c.ListNotebookInstancesRequest(input)
	return out, req.Send()
}

// ListNotebookInstancesWithContext is the same as ListNotebookInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotebookInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstancesWithContext(ctx aws.Context, input *ListNotebookInstancesInput, opts ...request.Option) (*ListNotebookInstancesOutput, error) {
	req, out := c.ListNotebookInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotebookInstancesPages iterates over the pages of a ListNotebookInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotebookInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotebookInstances operation.
//    pageNum := 0
//    err := client.ListNotebookInstancesPages(params,
//        func(page *sagemaker.ListNotebookInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListNotebookInstancesPages(input *ListNotebookInstancesInput, fn func(*ListNotebookInstancesOutput, bool) bool) error {
	return c.ListNotebookInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotebookInstancesPagesWithContext same as ListNotebookInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListNotebookInstancesPagesWithContext(ctx aws.Context, input *ListNotebookInstancesInput, fn func(*ListNotebookInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotebookInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotebookInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotebookInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPipelineExecutionSteps = "ListPipelineExecutionSteps"

// ListPipelineExecutionStepsRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelineExecutionSteps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipelineExecutionSteps for more information on using the ListPipelineExecutionSteps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPipelineExecutionStepsRequest method.
//    req, resp := client.ListPipelineExecutionStepsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineExecutionSteps
func (c *SageMaker) ListPipelineExecutionStepsRequest(input *ListPipelineExecutionStepsInput) (req *request.Request, output *ListPipelineExecutionStepsOutput) {
	op := &request.Operation{
		Name:       opListPipelineExecutionSteps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelineExecutionStepsInput{}
	}

	output = &ListPipelineExecutionStepsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelineExecutionSteps API operation for Amazon SageMaker Service.
//
// Gets a list of PipeLineExecutionStep objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListPipelineExecutionSteps for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineExecutionSteps
func (c *SageMaker) ListPipelineExecutionSteps(input *ListPipelineExecutionStepsInput) (*ListPipelineExecutionStepsOutput, error) {
	req, out := c.ListPipelineExecutionStepsRequest(input)
	return out, req.Send()
}

// ListPipelineExecutionStepsWithContext is the same as ListPipelineExecutionSteps with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipelineExecutionSteps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListPipelineExecutionStepsWithContext(ctx aws.Context, input *ListPipelineExecutionStepsInput, opts ...request.Option) (*ListPipelineExecutionStepsOutput, error) {
	req, out := c.ListPipelineExecutionStepsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPipelineExecutionStepsPages iterates over the pages of a ListPipelineExecutionSteps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPipelineExecutionSteps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPipelineExecutionSteps operation.
//    pageNum := 0
//    err := client.ListPipelineExecutionStepsPages(params,
//        func(page *sagemaker.ListPipelineExecutionStepsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListPipelineExecutionStepsPages(input *ListPipelineExecutionStepsInput, fn func(*ListPipelineExecutionStepsOutput, bool) bool) error {
	return c.ListPipelineExecutionStepsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPipelineExecutionStepsPagesWithContext same as ListPipelineExecutionStepsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListPipelineExecutionStepsPagesWithContext(ctx aws.Context, input *ListPipelineExecutionStepsInput, fn func(*ListPipelineExecutionStepsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPipelineExecutionStepsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPipelineExecutionStepsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPipelineExecutionStepsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPipelineExecutions = "ListPipelineExecutions"

// ListPipelineExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelineExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipelineExecutions for more information on using the ListPipelineExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPipelineExecutionsRequest method.
//    req, resp := client.ListPipelineExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineExecutions
func (c *SageMaker) ListPipelineExecutionsRequest(input *ListPipelineExecutionsInput) (req *request.Request, output *ListPipelineExecutionsOutput) {
	op := &request.Operation{
		Name:       opListPipelineExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelineExecutionsInput{}
	}

	output = &ListPipelineExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelineExecutions API operation for Amazon SageMaker Service.
//
// Gets a list of the pipeline executions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListPipelineExecutions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineExecutions
func (c *SageMaker) ListPipelineExecutions(input *ListPipelineExecutionsInput) (*ListPipelineExecutionsOutput, error) {
	req, out := c.ListPipelineExecutionsRequest(input)
	return out, req.Send()
}

// ListPipelineExecutionsWithContext is the same as ListPipelineExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipelineExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListPipelineExecutionsWithContext(ctx aws.Context, input *ListPipelineExecutionsInput, opts ...request.Option) (*ListPipelineExecutionsOutput, error) {
	req, out := c.ListPipelineExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPipelineExecutionsPages iterates over the pages of a ListPipelineExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPipelineExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPipelineExecutions operation.
//    pageNum := 0
//    err := client.ListPipelineExecutionsPages(params,
//        func(page *sagemaker.ListPipelineExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListPipelineExecutionsPages(input *ListPipelineExecutionsInput, fn func(*ListPipelineExecutionsOutput, bool) bool) error {
	return c.ListPipelineExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPipelineExecutionsPagesWithContext same as ListPipelineExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListPipelineExecutionsPagesWithContext(ctx aws.Context, input *ListPipelineExecutionsInput, fn func(*ListPipelineExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPipelineExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPipelineExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPipelineExecutionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPipelineParametersForExecution = "ListPipelineParametersForExecution"

// ListPipelineParametersForExecutionRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelineParametersForExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipelineParametersForExecution for more information on using the ListPipelineParametersForExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPipelineParametersForExecutionRequest method.
//    req, resp := client.ListPipelineParametersForExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineParametersForExecution
func (c *SageMaker) ListPipelineParametersForExecutionRequest(input *ListPipelineParametersForExecutionInput) (req *request.Request, output *ListPipelineParametersForExecutionOutput) {
	op := &request.Operation{
		Name:       opListPipelineParametersForExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelineParametersForExecutionInput{}
	}

	output = &ListPipelineParametersForExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelineParametersForExecution API operation for Amazon SageMaker Service.
//
// Gets a list of parameters for a pipeline execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListPipelineParametersForExecution for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelineParametersForExecution
func (c *SageMaker) ListPipelineParametersForExecution(input *ListPipelineParametersForExecutionInput) (*ListPipelineParametersForExecutionOutput, error) {
	req, out := c.ListPipelineParametersForExecutionRequest(input)
	return out, req.Send()
}

// ListPipelineParametersForExecutionWithContext is the same as ListPipelineParametersForExecution with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipelineParametersForExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListPipelineParametersForExecutionWithContext(ctx aws.Context, input *ListPipelineParametersForExecutionInput, opts ...request.Option) (*ListPipelineParametersForExecutionOutput, error) {
	req, out := c.ListPipelineParametersForExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPipelineParametersForExecutionPages iterates over the pages of a ListPipelineParametersForExecution operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPipelineParametersForExecution method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPipelineParametersForExecution operation.
//    pageNum := 0
//    err := client.ListPipelineParametersForExecutionPages(params,
//        func(page *sagemaker.ListPipelineParametersForExecutionOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListPipelineParametersForExecutionPages(input *ListPipelineParametersForExecutionInput, fn func(*ListPipelineParametersForExecutionOutput, bool) bool) error {
	return c.ListPipelineParametersForExecutionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPipelineParametersForExecutionPagesWithContext same as ListPipelineParametersForExecutionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListPipelineParametersForExecutionPagesWithContext(ctx aws.Context, input *ListPipelineParametersForExecutionInput, fn func(*ListPipelineParametersForExecutionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPipelineParametersForExecutionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPipelineParametersForExecutionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPipelineParametersForExecutionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPipelines = "ListPipelines"

// ListPipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipelines for more information on using the ListPipelines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPipelinesRequest method.
//    req, resp := client.ListPipelinesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelines
func (c *SageMaker) ListPipelinesRequest(input *ListPipelinesInput) (req *request.Request, output *ListPipelinesOutput) {
	op := &request.Operation{
		Name:       opListPipelines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelinesInput{}
	}

	output = &ListPipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelines API operation for Amazon SageMaker Service.
//
// Gets a list of pipelines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListPipelines for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListPipelines
func (c *SageMaker) ListPipelines(input *ListPipelinesInput) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	return out, req.Send()
}

// ListPipelinesWithContext is the same as ListPipelines with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipelines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListPipelinesWithContext(ctx aws.Context, input *ListPipelinesInput, opts ...request.Option) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPipelinesPages iterates over the pages of a ListPipelines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPipelines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPipelines operation.
//    pageNum := 0
//    err := client.ListPipelinesPages(params,
//        func(page *sagemaker.ListPipelinesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListPipelinesPages(input *ListPipelinesInput, fn func(*ListPipelinesOutput, bool) bool) error {
	return c.ListPipelinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPipelinesPagesWithContext same as ListPipelinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListPipelinesPagesWithContext(ctx aws.Context, input *ListPipelinesInput, fn func(*ListPipelinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPipelinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPipelinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPipelinesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProcessingJobs = "ListProcessingJobs"

// ListProcessingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListProcessingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProcessingJobs for more information on using the ListProcessingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProcessingJobsRequest method.
//    req, resp := client.ListProcessingJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListProcessingJobs
func (c *SageMaker) ListProcessingJobsRequest(input *ListProcessingJobsInput) (req *request.Request, output *ListProcessingJobsOutput) {
	op := &request.Operation{
		Name:       opListProcessingJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProcessingJobsInput{}
	}

	output = &ListProcessingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProcessingJobs API operation for Amazon SageMaker Service.
//
// Lists processing jobs that satisfy various filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListProcessingJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListProcessingJobs
func (c *SageMaker) ListProcessingJobs(input *ListProcessingJobsInput) (*ListProcessingJobsOutput, error) {
	req, out := c.ListProcessingJobsRequest(input)
	return out, req.Send()
}

// ListProcessingJobsWithContext is the same as ListProcessingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListProcessingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListProcessingJobsWithContext(ctx aws.Context, input *ListProcessingJobsInput, opts ...request.Option) (*ListProcessingJobsOutput, error) {
	req, out := c.ListProcessingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProcessingJobsPages iterates over the pages of a ListProcessingJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProcessingJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProcessingJobs operation.
//    pageNum := 0
//    err := client.ListProcessingJobsPages(params,
//        func(page *sagemaker.ListProcessingJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListProcessingJobsPages(input *ListProcessingJobsInput, fn func(*ListProcessingJobsOutput, bool) bool) error {
	return c.ListProcessingJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProcessingJobsPagesWithContext same as ListProcessingJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListProcessingJobsPagesWithContext(ctx aws.Context, input *ListProcessingJobsInput, fn func(*ListProcessingJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProcessingJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProcessingJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProcessingJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListProjects
func (c *SageMaker) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for Amazon SageMaker Service.
//
// Gets a list of the projects in an AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListProjects for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListProjects
func (c *SageMaker) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectsPages iterates over the pages of a ListProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProjects operation.
//    pageNum := 0
//    err := client.ListProjectsPages(params,
//        func(page *sagemaker.ListProjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListProjectsPages(input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool) error {
	return c.ListProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectsPagesWithContext same as ListProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListProjectsPagesWithContext(ctx aws.Context, input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSubscribedWorkteams = "ListSubscribedWorkteams"

// ListSubscribedWorkteamsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscribedWorkteams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscribedWorkteams for more information on using the ListSubscribedWorkteams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSubscribedWorkteamsRequest method.
//    req, resp := client.ListSubscribedWorkteamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams
func (c *SageMaker) ListSubscribedWorkteamsRequest(input *ListSubscribedWorkteamsInput) (req *request.Request, output *ListSubscribedWorkteamsOutput) {
	op := &request.Operation{
		Name:       opListSubscribedWorkteams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscribedWorkteamsInput{}
	}

	output = &ListSubscribedWorkteamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscribedWorkteams API operation for Amazon SageMaker Service.
//
// Gets a list of the work teams that you are subscribed to in the AWS Marketplace.
// The list may be empty if no work team satisfies the filter specified in the
// NameContains parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListSubscribedWorkteams for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListSubscribedWorkteams
func (c *SageMaker) ListSubscribedWorkteams(input *ListSubscribedWorkteamsInput) (*ListSubscribedWorkteamsOutput, error) {
	req, out := c.ListSubscribedWorkteamsRequest(input)
	return out, req.Send()
}

// ListSubscribedWorkteamsWithContext is the same as ListSubscribedWorkteams with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscribedWorkteams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListSubscribedWorkteamsWithContext(ctx aws.Context, input *ListSubscribedWorkteamsInput, opts ...request.Option) (*ListSubscribedWorkteamsOutput, error) {
	req, out := c.ListSubscribedWorkteamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSubscribedWorkteamsPages iterates over the pages of a ListSubscribedWorkteams operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubscribedWorkteams method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSubscribedWorkteams operation.
//    pageNum := 0
//    err := client.ListSubscribedWorkteamsPages(params,
//        func(page *sagemaker.ListSubscribedWorkteamsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListSubscribedWorkteamsPages(input *ListSubscribedWorkteamsInput, fn func(*ListSubscribedWorkteamsOutput, bool) bool) error {
	return c.ListSubscribedWorkteamsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSubscribedWorkteamsPagesWithContext same as ListSubscribedWorkteamsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListSubscribedWorkteamsPagesWithContext(ctx aws.Context, input *ListSubscribedWorkteamsInput, fn func(*ListSubscribedWorkteamsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSubscribedWorkteamsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSubscribedWorkteamsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSubscribedWorkteamsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags
func (c *SageMaker) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Amazon SageMaker Service.
//
// Returns the tags for the specified Amazon SageMaker resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTags
func (c *SageMaker) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsPages iterates over the pages of a ListTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTags operation.
//    pageNum := 0
//    err := client.ListTagsPages(params,
//        func(page *sagemaker.ListTagsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTagsPages(input *ListTagsInput, fn func(*ListTagsOutput, bool) bool) error {
	return c.ListTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsPagesWithContext same as ListTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTagsPagesWithContext(ctx aws.Context, input *ListTagsInput, fn func(*ListTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrainingJobs = "ListTrainingJobs"

// ListTrainingJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrainingJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrainingJobs for more information on using the ListTrainingJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrainingJobsRequest method.
//    req, resp := client.ListTrainingJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs
func (c *SageMaker) ListTrainingJobsRequest(input *ListTrainingJobsInput) (req *request.Request, output *ListTrainingJobsOutput) {
	op := &request.Operation{
		Name:       opListTrainingJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrainingJobsInput{}
	}

	output = &ListTrainingJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrainingJobs API operation for Amazon SageMaker Service.
//
// Lists training jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTrainingJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobs
func (c *SageMaker) ListTrainingJobs(input *ListTrainingJobsInput) (*ListTrainingJobsOutput, error) {
	req, out := c.ListTrainingJobsRequest(input)
	return out, req.Send()
}

// ListTrainingJobsWithContext is the same as ListTrainingJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrainingJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrainingJobsWithContext(ctx aws.Context, input *ListTrainingJobsInput, opts ...request.Option) (*ListTrainingJobsOutput, error) {
	req, out := c.ListTrainingJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrainingJobsPages iterates over the pages of a ListTrainingJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrainingJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrainingJobs operation.
//    pageNum := 0
//    err := client.ListTrainingJobsPages(params,
//        func(page *sagemaker.ListTrainingJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTrainingJobsPages(input *ListTrainingJobsInput, fn func(*ListTrainingJobsOutput, bool) bool) error {
	return c.ListTrainingJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrainingJobsPagesWithContext same as ListTrainingJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrainingJobsPagesWithContext(ctx aws.Context, input *ListTrainingJobsInput, fn func(*ListTrainingJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrainingJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrainingJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrainingJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrainingJobsForHyperParameterTuningJob = "ListTrainingJobsForHyperParameterTuningJob"

// ListTrainingJobsForHyperParameterTuningJobRequest generates a "aws/request.Request" representing the
// client's request for the ListTrainingJobsForHyperParameterTuningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrainingJobsForHyperParameterTuningJob for more information on using the ListTrainingJobsForHyperParameterTuningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrainingJobsForHyperParameterTuningJobRequest method.
//    req, resp := client.ListTrainingJobsForHyperParameterTuningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobsForHyperParameterTuningJob
func (c *SageMaker) ListTrainingJobsForHyperParameterTuningJobRequest(input *ListTrainingJobsForHyperParameterTuningJobInput) (req *request.Request, output *ListTrainingJobsForHyperParameterTuningJobOutput) {
	op := &request.Operation{
		Name:       opListTrainingJobsForHyperParameterTuningJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrainingJobsForHyperParameterTuningJobInput{}
	}

	output = &ListTrainingJobsForHyperParameterTuningJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrainingJobsForHyperParameterTuningJob API operation for Amazon SageMaker Service.
//
// Gets a list of TrainingJobSummary objects that describe the training jobs
// that a hyperparameter tuning job launched.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTrainingJobsForHyperParameterTuningJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrainingJobsForHyperParameterTuningJob
func (c *SageMaker) ListTrainingJobsForHyperParameterTuningJob(input *ListTrainingJobsForHyperParameterTuningJobInput) (*ListTrainingJobsForHyperParameterTuningJobOutput, error) {
	req, out := c.ListTrainingJobsForHyperParameterTuningJobRequest(input)
	return out, req.Send()
}

// ListTrainingJobsForHyperParameterTuningJobWithContext is the same as ListTrainingJobsForHyperParameterTuningJob with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrainingJobsForHyperParameterTuningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrainingJobsForHyperParameterTuningJobWithContext(ctx aws.Context, input *ListTrainingJobsForHyperParameterTuningJobInput, opts ...request.Option) (*ListTrainingJobsForHyperParameterTuningJobOutput, error) {
	req, out := c.ListTrainingJobsForHyperParameterTuningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrainingJobsForHyperParameterTuningJobPages iterates over the pages of a ListTrainingJobsForHyperParameterTuningJob operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrainingJobsForHyperParameterTuningJob method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrainingJobsForHyperParameterTuningJob operation.
//    pageNum := 0
//    err := client.ListTrainingJobsForHyperParameterTuningJobPages(params,
//        func(page *sagemaker.ListTrainingJobsForHyperParameterTuningJobOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTrainingJobsForHyperParameterTuningJobPages(input *ListTrainingJobsForHyperParameterTuningJobInput, fn func(*ListTrainingJobsForHyperParameterTuningJobOutput, bool) bool) error {
	return c.ListTrainingJobsForHyperParameterTuningJobPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrainingJobsForHyperParameterTuningJobPagesWithContext same as ListTrainingJobsForHyperParameterTuningJobPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrainingJobsForHyperParameterTuningJobPagesWithContext(ctx aws.Context, input *ListTrainingJobsForHyperParameterTuningJobInput, fn func(*ListTrainingJobsForHyperParameterTuningJobOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrainingJobsForHyperParameterTuningJobInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrainingJobsForHyperParameterTuningJobRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrainingJobsForHyperParameterTuningJobOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTransformJobs = "ListTransformJobs"

// ListTransformJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTransformJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTransformJobs for more information on using the ListTransformJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTransformJobsRequest method.
//    req, resp := client.ListTransformJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs
func (c *SageMaker) ListTransformJobsRequest(input *ListTransformJobsInput) (req *request.Request, output *ListTransformJobsOutput) {
	op := &request.Operation{
		Name:       opListTransformJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTransformJobsInput{}
	}

	output = &ListTransformJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTransformJobs API operation for Amazon SageMaker Service.
//
// Lists transform jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTransformJobs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTransformJobs
func (c *SageMaker) ListTransformJobs(input *ListTransformJobsInput) (*ListTransformJobsOutput, error) {
	req, out := c.ListTransformJobsRequest(input)
	return out, req.Send()
}

// ListTransformJobsWithContext is the same as ListTransformJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTransformJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTransformJobsWithContext(ctx aws.Context, input *ListTransformJobsInput, opts ...request.Option) (*ListTransformJobsOutput, error) {
	req, out := c.ListTransformJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTransformJobsPages iterates over the pages of a ListTransformJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTransformJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTransformJobs operation.
//    pageNum := 0
//    err := client.ListTransformJobsPages(params,
//        func(page *sagemaker.ListTransformJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTransformJobsPages(input *ListTransformJobsInput, fn func(*ListTransformJobsOutput, bool) bool) error {
	return c.ListTransformJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTransformJobsPagesWithContext same as ListTransformJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTransformJobsPagesWithContext(ctx aws.Context, input *ListTransformJobsInput, fn func(*ListTransformJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTransformJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTransformJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTransformJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrialComponents = "ListTrialComponents"

// ListTrialComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrialComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrialComponents for more information on using the ListTrialComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrialComponentsRequest method.
//    req, resp := client.ListTrialComponentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrialComponents
func (c *SageMaker) ListTrialComponentsRequest(input *ListTrialComponentsInput) (req *request.Request, output *ListTrialComponentsOutput) {
	op := &request.Operation{
		Name:       opListTrialComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrialComponentsInput{}
	}

	output = &ListTrialComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrialComponents API operation for Amazon SageMaker Service.
//
// Lists the trial components in your account. You can sort the list by trial
// component name or creation time. You can filter the list to show only components
// that were created in a specific time range. You can also filter on one of
// the following:
//
//    * ExperimentName
//
//    * SourceArn
//
//    * TrialName
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTrialComponents for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrialComponents
func (c *SageMaker) ListTrialComponents(input *ListTrialComponentsInput) (*ListTrialComponentsOutput, error) {
	req, out := c.ListTrialComponentsRequest(input)
	return out, req.Send()
}

// ListTrialComponentsWithContext is the same as ListTrialComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrialComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrialComponentsWithContext(ctx aws.Context, input *ListTrialComponentsInput, opts ...request.Option) (*ListTrialComponentsOutput, error) {
	req, out := c.ListTrialComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrialComponentsPages iterates over the pages of a ListTrialComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrialComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrialComponents operation.
//    pageNum := 0
//    err := client.ListTrialComponentsPages(params,
//        func(page *sagemaker.ListTrialComponentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTrialComponentsPages(input *ListTrialComponentsInput, fn func(*ListTrialComponentsOutput, bool) bool) error {
	return c.ListTrialComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrialComponentsPagesWithContext same as ListTrialComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrialComponentsPagesWithContext(ctx aws.Context, input *ListTrialComponentsInput, fn func(*ListTrialComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrialComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrialComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrialComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrials = "ListTrials"

// ListTrialsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrials for more information on using the ListTrials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrialsRequest method.
//    req, resp := client.ListTrialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrials
func (c *SageMaker) ListTrialsRequest(input *ListTrialsInput) (req *request.Request, output *ListTrialsOutput) {
	op := &request.Operation{
		Name:       opListTrials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrialsInput{}
	}

	output = &ListTrialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrials API operation for Amazon SageMaker Service.
//
// Lists the trials in your account. Specify an experiment name to limit the
// list to the trials that are part of that experiment. Specify a trial component
// name to limit the list to the trials that associated with that trial component.
// The list can be filtered to show only trials that were created in a specific
// time range. The list can be sorted by trial name or creation time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListTrials for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListTrials
func (c *SageMaker) ListTrials(input *ListTrialsInput) (*ListTrialsOutput, error) {
	req, out := c.ListTrialsRequest(input)
	return out, req.Send()
}

// ListTrialsWithContext is the same as ListTrials with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrialsWithContext(ctx aws.Context, input *ListTrialsInput, opts ...request.Option) (*ListTrialsOutput, error) {
	req, out := c.ListTrialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrialsPages iterates over the pages of a ListTrials operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrials method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrials operation.
//    pageNum := 0
//    err := client.ListTrialsPages(params,
//        func(page *sagemaker.ListTrialsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListTrialsPages(input *ListTrialsInput, fn func(*ListTrialsOutput, bool) bool) error {
	return c.ListTrialsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrialsPagesWithContext same as ListTrialsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListTrialsPagesWithContext(ctx aws.Context, input *ListTrialsInput, fn func(*ListTrialsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrialsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrialsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrialsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUserProfiles = "ListUserProfiles"

// ListUserProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListUserProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserProfiles for more information on using the ListUserProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserProfilesRequest method.
//    req, resp := client.ListUserProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListUserProfiles
func (c *SageMaker) ListUserProfilesRequest(input *ListUserProfilesInput) (req *request.Request, output *ListUserProfilesOutput) {
	op := &request.Operation{
		Name:       opListUserProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserProfilesInput{}
	}

	output = &ListUserProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserProfiles API operation for Amazon SageMaker Service.
//
// Lists user profiles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListUserProfiles for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListUserProfiles
func (c *SageMaker) ListUserProfiles(input *ListUserProfilesInput) (*ListUserProfilesOutput, error) {
	req, out := c.ListUserProfilesRequest(input)
	return out, req.Send()
}

// ListUserProfilesWithContext is the same as ListUserProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListUserProfilesWithContext(ctx aws.Context, input *ListUserProfilesInput, opts ...request.Option) (*ListUserProfilesOutput, error) {
	req, out := c.ListUserProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUserProfilesPages iterates over the pages of a ListUserProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUserProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUserProfiles operation.
//    pageNum := 0
//    err := client.ListUserProfilesPages(params,
//        func(page *sagemaker.ListUserProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListUserProfilesPages(input *ListUserProfilesInput, fn func(*ListUserProfilesOutput, bool) bool) error {
	return c.ListUserProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUserProfilesPagesWithContext same as ListUserProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListUserProfilesPagesWithContext(ctx aws.Context, input *ListUserProfilesInput, fn func(*ListUserProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUserProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUserProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUserProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkforces = "ListWorkforces"

// ListWorkforcesRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkforces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkforces for more information on using the ListWorkforces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkforcesRequest method.
//    req, resp := client.ListWorkforcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkforces
func (c *SageMaker) ListWorkforcesRequest(input *ListWorkforcesInput) (req *request.Request, output *ListWorkforcesOutput) {
	op := &request.Operation{
		Name:       opListWorkforces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkforcesInput{}
	}

	output = &ListWorkforcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkforces API operation for Amazon SageMaker Service.
//
// Use this operation to list all private and vendor workforces in an AWS Region.
// Note that you can only have one private workforce per AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListWorkforces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkforces
func (c *SageMaker) ListWorkforces(input *ListWorkforcesInput) (*ListWorkforcesOutput, error) {
	req, out := c.ListWorkforcesRequest(input)
	return out, req.Send()
}

// ListWorkforcesWithContext is the same as ListWorkforces with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkforces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListWorkforcesWithContext(ctx aws.Context, input *ListWorkforcesInput, opts ...request.Option) (*ListWorkforcesOutput, error) {
	req, out := c.ListWorkforcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkforcesPages iterates over the pages of a ListWorkforces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkforces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkforces operation.
//    pageNum := 0
//    err := client.ListWorkforcesPages(params,
//        func(page *sagemaker.ListWorkforcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListWorkforcesPages(input *ListWorkforcesInput, fn func(*ListWorkforcesOutput, bool) bool) error {
	return c.ListWorkforcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkforcesPagesWithContext same as ListWorkforcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListWorkforcesPagesWithContext(ctx aws.Context, input *ListWorkforcesInput, fn func(*ListWorkforcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkforcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkforcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkforcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkteams = "ListWorkteams"

// ListWorkteamsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkteams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkteams for more information on using the ListWorkteams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkteamsRequest method.
//    req, resp := client.ListWorkteamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams
func (c *SageMaker) ListWorkteamsRequest(input *ListWorkteamsInput) (req *request.Request, output *ListWorkteamsOutput) {
	op := &request.Operation{
		Name:       opListWorkteams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkteamsInput{}
	}

	output = &ListWorkteamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkteams API operation for Amazon SageMaker Service.
//
// Gets a list of private work teams that you have defined in a region. The
// list may be empty if no work team satisfies the filter specified in the NameContains
// parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation ListWorkteams for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListWorkteams
func (c *SageMaker) ListWorkteams(input *ListWorkteamsInput) (*ListWorkteamsOutput, error) {
	req, out := c.ListWorkteamsRequest(input)
	return out, req.Send()
}

// ListWorkteamsWithContext is the same as ListWorkteams with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkteams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListWorkteamsWithContext(ctx aws.Context, input *ListWorkteamsInput, opts ...request.Option) (*ListWorkteamsOutput, error) {
	req, out := c.ListWorkteamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkteamsPages iterates over the pages of a ListWorkteams operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkteams method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkteams operation.
//    pageNum := 0
//    err := client.ListWorkteamsPages(params,
//        func(page *sagemaker.ListWorkteamsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) ListWorkteamsPages(input *ListWorkteamsInput, fn func(*ListWorkteamsOutput, bool) bool) error {
	return c.ListWorkteamsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkteamsPagesWithContext same as ListWorkteamsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) ListWorkteamsPagesWithContext(ctx aws.Context, input *ListWorkteamsInput, fn func(*ListWorkteamsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkteamsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkteamsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkteamsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutModelPackageGroupPolicy = "PutModelPackageGroupPolicy"

// PutModelPackageGroupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutModelPackageGroupPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutModelPackageGroupPolicy for more information on using the PutModelPackageGroupPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutModelPackageGroupPolicyRequest method.
//    req, resp := client.PutModelPackageGroupPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/PutModelPackageGroupPolicy
func (c *SageMaker) PutModelPackageGroupPolicyRequest(input *PutModelPackageGroupPolicyInput) (req *request.Request, output *PutModelPackageGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opPutModelPackageGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutModelPackageGroupPolicyInput{}
	}

	output = &PutModelPackageGroupPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutModelPackageGroupPolicy API operation for Amazon SageMaker Service.
//
// Adds a resouce policy to control access to a model group. For information
// about resoure policies, see Identity-based policies and resource-based policies
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html)
// in the AWS Identity and Access Management User Guide..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation PutModelPackageGroupPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/PutModelPackageGroupPolicy
func (c *SageMaker) PutModelPackageGroupPolicy(input *PutModelPackageGroupPolicyInput) (*PutModelPackageGroupPolicyOutput, error) {
	req, out := c.PutModelPackageGroupPolicyRequest(input)
	return out, req.Send()
}

// PutModelPackageGroupPolicyWithContext is the same as PutModelPackageGroupPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutModelPackageGroupPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) PutModelPackageGroupPolicyWithContext(ctx aws.Context, input *PutModelPackageGroupPolicyInput, opts ...request.Option) (*PutModelPackageGroupPolicyOutput, error) {
	req, out := c.PutModelPackageGroupPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterDevices = "RegisterDevices"

// RegisterDevicesRequest generates a "aws/request.Request" representing the
// client's request for the RegisterDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterDevices for more information on using the RegisterDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterDevicesRequest method.
//    req, resp := client.RegisterDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RegisterDevices
func (c *SageMaker) RegisterDevicesRequest(input *RegisterDevicesInput) (req *request.Request, output *RegisterDevicesOutput) {
	op := &request.Operation{
		Name:       opRegisterDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDevicesInput{}
	}

	output = &RegisterDevicesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterDevices API operation for Amazon SageMaker Service.
//
// Register devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation RegisterDevices for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RegisterDevices
func (c *SageMaker) RegisterDevices(input *RegisterDevicesInput) (*RegisterDevicesOutput, error) {
	req, out := c.RegisterDevicesRequest(input)
	return out, req.Send()
}

// RegisterDevicesWithContext is the same as RegisterDevices with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) RegisterDevicesWithContext(ctx aws.Context, input *RegisterDevicesInput, opts ...request.Option) (*RegisterDevicesOutput, error) {
	req, out := c.RegisterDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRenderUiTemplate = "RenderUiTemplate"

// RenderUiTemplateRequest generates a "aws/request.Request" representing the
// client's request for the RenderUiTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RenderUiTemplate for more information on using the RenderUiTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RenderUiTemplateRequest method.
//    req, resp := client.RenderUiTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RenderUiTemplate
func (c *SageMaker) RenderUiTemplateRequest(input *RenderUiTemplateInput) (req *request.Request, output *RenderUiTemplateOutput) {
	op := &request.Operation{
		Name:       opRenderUiTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RenderUiTemplateInput{}
	}

	output = &RenderUiTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RenderUiTemplate API operation for Amazon SageMaker Service.
//
// Renders the UI template so that you can preview the worker's experience.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation RenderUiTemplate for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/RenderUiTemplate
func (c *SageMaker) RenderUiTemplate(input *RenderUiTemplateInput) (*RenderUiTemplateOutput, error) {
	req, out := c.RenderUiTemplateRequest(input)
	return out, req.Send()
}

// RenderUiTemplateWithContext is the same as RenderUiTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See RenderUiTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) RenderUiTemplateWithContext(ctx aws.Context, input *RenderUiTemplateInput, opts ...request.Option) (*RenderUiTemplateOutput, error) {
	req, out := c.RenderUiTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearch = "Search"

// SearchRequest generates a "aws/request.Request" representing the
// client's request for the Search operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Search for more information on using the Search
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchRequest method.
//    req, resp := client.SearchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Search
func (c *SageMaker) SearchRequest(input *SearchInput) (req *request.Request, output *SearchOutput) {
	op := &request.Operation{
		Name:       opSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchInput{}
	}

	output = &SearchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Search API operation for Amazon SageMaker Service.
//
// Finds Amazon SageMaker resources that match a search query. Matching resources
// are returned as a list of SearchRecord objects in the response. You can sort
// the search results by any resource property in a ascending or descending
// order.
//
// You can query against the following value types: numeric, text, Boolean,
// and timestamp.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation Search for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Search
func (c *SageMaker) Search(input *SearchInput) (*SearchOutput, error) {
	req, out := c.SearchRequest(input)
	return out, req.Send()
}

// SearchWithContext is the same as Search with the addition of
// the ability to pass a context and additional request options.
//
// See Search for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) SearchWithContext(ctx aws.Context, input *SearchInput, opts ...request.Option) (*SearchOutput, error) {
	req, out := c.SearchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchPages iterates over the pages of a Search operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Search method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a Search operation.
//    pageNum := 0
//    err := client.SearchPages(params,
//        func(page *sagemaker.SearchOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SageMaker) SearchPages(input *SearchInput, fn func(*SearchOutput, bool) bool) error {
	return c.SearchPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchPagesWithContext same as SearchPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) SearchPagesWithContext(ctx aws.Context, input *SearchInput, fn func(*SearchOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartMonitoringSchedule = "StartMonitoringSchedule"

// StartMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the StartMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMonitoringSchedule for more information on using the StartMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMonitoringScheduleRequest method.
//    req, resp := client.StartMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartMonitoringSchedule
func (c *SageMaker) StartMonitoringScheduleRequest(input *StartMonitoringScheduleInput) (req *request.Request, output *StartMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opStartMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMonitoringScheduleInput{}
	}

	output = &StartMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Starts a previously stopped monitoring schedule.
//
// By default, when you successfully create a new schedule, the status of a
// monitoring schedule is scheduled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StartMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartMonitoringSchedule
func (c *SageMaker) StartMonitoringSchedule(input *StartMonitoringScheduleInput) (*StartMonitoringScheduleOutput, error) {
	req, out := c.StartMonitoringScheduleRequest(input)
	return out, req.Send()
}

// StartMonitoringScheduleWithContext is the same as StartMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See StartMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StartMonitoringScheduleWithContext(ctx aws.Context, input *StartMonitoringScheduleInput, opts ...request.Option) (*StartMonitoringScheduleOutput, error) {
	req, out := c.StartMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartNotebookInstance = "StartNotebookInstance"

// StartNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StartNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartNotebookInstance for more information on using the StartNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartNotebookInstanceRequest method.
//    req, resp := client.StartNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartNotebookInstance
func (c *SageMaker) StartNotebookInstanceRequest(input *StartNotebookInstanceInput) (req *request.Request, output *StartNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opStartNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartNotebookInstanceInput{}
	}

	output = &StartNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartNotebookInstance API operation for Amazon SageMaker Service.
//
// Launches an ML compute instance with the latest version of the libraries
// and attaches your ML storage volume. After configuring the notebook instance,
// Amazon SageMaker sets the notebook instance status to InService. A notebook
// instance's status must be InService before you can connect to your Jupyter
// notebook.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StartNotebookInstance for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartNotebookInstance
func (c *SageMaker) StartNotebookInstance(input *StartNotebookInstanceInput) (*StartNotebookInstanceOutput, error) {
	req, out := c.StartNotebookInstanceRequest(input)
	return out, req.Send()
}

// StartNotebookInstanceWithContext is the same as StartNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StartNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StartNotebookInstanceWithContext(ctx aws.Context, input *StartNotebookInstanceInput, opts ...request.Option) (*StartNotebookInstanceOutput, error) {
	req, out := c.StartNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPipelineExecution = "StartPipelineExecution"

// StartPipelineExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartPipelineExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPipelineExecution for more information on using the StartPipelineExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartPipelineExecutionRequest method.
//    req, resp := client.StartPipelineExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartPipelineExecution
func (c *SageMaker) StartPipelineExecutionRequest(input *StartPipelineExecutionInput) (req *request.Request, output *StartPipelineExecutionOutput) {
	op := &request.Operation{
		Name:       opStartPipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartPipelineExecutionInput{}
	}

	output = &StartPipelineExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPipelineExecution API operation for Amazon SageMaker Service.
//
// Starts a pipeline execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StartPipelineExecution for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StartPipelineExecution
func (c *SageMaker) StartPipelineExecution(input *StartPipelineExecutionInput) (*StartPipelineExecutionOutput, error) {
	req, out := c.StartPipelineExecutionRequest(input)
	return out, req.Send()
}

// StartPipelineExecutionWithContext is the same as StartPipelineExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartPipelineExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StartPipelineExecutionWithContext(ctx aws.Context, input *StartPipelineExecutionInput, opts ...request.Option) (*StartPipelineExecutionOutput, error) {
	req, out := c.StartPipelineExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopAutoMLJob = "StopAutoMLJob"

// StopAutoMLJobRequest generates a "aws/request.Request" representing the
// client's request for the StopAutoMLJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopAutoMLJob for more information on using the StopAutoMLJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopAutoMLJobRequest method.
//    req, resp := client.StopAutoMLJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopAutoMLJob
func (c *SageMaker) StopAutoMLJobRequest(input *StopAutoMLJobInput) (req *request.Request, output *StopAutoMLJobOutput) {
	op := &request.Operation{
		Name:       opStopAutoMLJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopAutoMLJobInput{}
	}

	output = &StopAutoMLJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopAutoMLJob API operation for Amazon SageMaker Service.
//
// A method for forcing the termination of a running job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopAutoMLJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopAutoMLJob
func (c *SageMaker) StopAutoMLJob(input *StopAutoMLJobInput) (*StopAutoMLJobOutput, error) {
	req, out := c.StopAutoMLJobRequest(input)
	return out, req.Send()
}

// StopAutoMLJobWithContext is the same as StopAutoMLJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopAutoMLJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopAutoMLJobWithContext(ctx aws.Context, input *StopAutoMLJobInput, opts ...request.Option) (*StopAutoMLJobOutput, error) {
	req, out := c.StopAutoMLJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopCompilationJob = "StopCompilationJob"

// StopCompilationJobRequest generates a "aws/request.Request" representing the
// client's request for the StopCompilationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopCompilationJob for more information on using the StopCompilationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopCompilationJobRequest method.
//    req, resp := client.StopCompilationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopCompilationJob
func (c *SageMaker) StopCompilationJobRequest(input *StopCompilationJobInput) (req *request.Request, output *StopCompilationJobOutput) {
	op := &request.Operation{
		Name:       opStopCompilationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopCompilationJobInput{}
	}

	output = &StopCompilationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopCompilationJob API operation for Amazon SageMaker Service.
//
// Stops a model compilation job.
//
// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This
// gracefully shuts the job down. If the job hasn't stopped, it sends the SIGKILL
// signal.
//
// When it receives a StopCompilationJob request, Amazon SageMaker changes the
// CompilationJobSummary$CompilationJobStatus of the job to Stopping. After
// Amazon SageMaker stops the job, it sets the CompilationJobSummary$CompilationJobStatus
// to Stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopCompilationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopCompilationJob
func (c *SageMaker) StopCompilationJob(input *StopCompilationJobInput) (*StopCompilationJobOutput, error) {
	req, out := c.StopCompilationJobRequest(input)
	return out, req.Send()
}

// StopCompilationJobWithContext is the same as StopCompilationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopCompilationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopCompilationJobWithContext(ctx aws.Context, input *StopCompilationJobInput, opts ...request.Option) (*StopCompilationJobOutput, error) {
	req, out := c.StopCompilationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopEdgePackagingJob = "StopEdgePackagingJob"

// StopEdgePackagingJobRequest generates a "aws/request.Request" representing the
// client's request for the StopEdgePackagingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopEdgePackagingJob for more information on using the StopEdgePackagingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopEdgePackagingJobRequest method.
//    req, resp := client.StopEdgePackagingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopEdgePackagingJob
func (c *SageMaker) StopEdgePackagingJobRequest(input *StopEdgePackagingJobInput) (req *request.Request, output *StopEdgePackagingJobOutput) {
	op := &request.Operation{
		Name:       opStopEdgePackagingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopEdgePackagingJobInput{}
	}

	output = &StopEdgePackagingJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopEdgePackagingJob API operation for Amazon SageMaker Service.
//
// Request to stop an edge packaging job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopEdgePackagingJob for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopEdgePackagingJob
func (c *SageMaker) StopEdgePackagingJob(input *StopEdgePackagingJobInput) (*StopEdgePackagingJobOutput, error) {
	req, out := c.StopEdgePackagingJobRequest(input)
	return out, req.Send()
}

// StopEdgePackagingJobWithContext is the same as StopEdgePackagingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopEdgePackagingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopEdgePackagingJobWithContext(ctx aws.Context, input *StopEdgePackagingJobInput, opts ...request.Option) (*StopEdgePackagingJobOutput, error) {
	req, out := c.StopEdgePackagingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopHyperParameterTuningJob = "StopHyperParameterTuningJob"

// StopHyperParameterTuningJobRequest generates a "aws/request.Request" representing the
// client's request for the StopHyperParameterTuningJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopHyperParameterTuningJob for more information on using the StopHyperParameterTuningJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopHyperParameterTuningJobRequest method.
//    req, resp := client.StopHyperParameterTuningJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopHyperParameterTuningJob
func (c *SageMaker) StopHyperParameterTuningJobRequest(input *StopHyperParameterTuningJobInput) (req *request.Request, output *StopHyperParameterTuningJobOutput) {
	op := &request.Operation{
		Name:       opStopHyperParameterTuningJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopHyperParameterTuningJobInput{}
	}

	output = &StopHyperParameterTuningJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopHyperParameterTuningJob API operation for Amazon SageMaker Service.
//
// Stops a running hyperparameter tuning job and all running training jobs that
// the tuning job launched.
//
// All model artifacts output from the training jobs are stored in Amazon Simple
// Storage Service (Amazon S3). All data that the training jobs write to Amazon
// CloudWatch Logs are still available in CloudWatch. After the tuning job moves
// to the Stopped state, it releases all reserved resources for the tuning job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopHyperParameterTuningJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopHyperParameterTuningJob
func (c *SageMaker) StopHyperParameterTuningJob(input *StopHyperParameterTuningJobInput) (*StopHyperParameterTuningJobOutput, error) {
	req, out := c.StopHyperParameterTuningJobRequest(input)
	return out, req.Send()
}

// StopHyperParameterTuningJobWithContext is the same as StopHyperParameterTuningJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopHyperParameterTuningJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopHyperParameterTuningJobWithContext(ctx aws.Context, input *StopHyperParameterTuningJobInput, opts ...request.Option) (*StopHyperParameterTuningJobOutput, error) {
	req, out := c.StopHyperParameterTuningJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopLabelingJob = "StopLabelingJob"

// StopLabelingJobRequest generates a "aws/request.Request" representing the
// client's request for the StopLabelingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopLabelingJob for more information on using the StopLabelingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopLabelingJobRequest method.
//    req, resp := client.StopLabelingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopLabelingJob
func (c *SageMaker) StopLabelingJobRequest(input *StopLabelingJobInput) (req *request.Request, output *StopLabelingJobOutput) {
	op := &request.Operation{
		Name:       opStopLabelingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopLabelingJobInput{}
	}

	output = &StopLabelingJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopLabelingJob API operation for Amazon SageMaker Service.
//
// Stops a running labeling job. A job that is stopped cannot be restarted.
// Any results obtained before the job is stopped are placed in the Amazon S3
// output bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopLabelingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopLabelingJob
func (c *SageMaker) StopLabelingJob(input *StopLabelingJobInput) (*StopLabelingJobOutput, error) {
	req, out := c.StopLabelingJobRequest(input)
	return out, req.Send()
}

// StopLabelingJobWithContext is the same as StopLabelingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopLabelingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopLabelingJobWithContext(ctx aws.Context, input *StopLabelingJobInput, opts ...request.Option) (*StopLabelingJobOutput, error) {
	req, out := c.StopLabelingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMonitoringSchedule = "StopMonitoringSchedule"

// StopMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the StopMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMonitoringSchedule for more information on using the StopMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopMonitoringScheduleRequest method.
//    req, resp := client.StopMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopMonitoringSchedule
func (c *SageMaker) StopMonitoringScheduleRequest(input *StopMonitoringScheduleInput) (req *request.Request, output *StopMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opStopMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopMonitoringScheduleInput{}
	}

	output = &StopMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Stops a previously started monitoring schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopMonitoringSchedule
func (c *SageMaker) StopMonitoringSchedule(input *StopMonitoringScheduleInput) (*StopMonitoringScheduleOutput, error) {
	req, out := c.StopMonitoringScheduleRequest(input)
	return out, req.Send()
}

// StopMonitoringScheduleWithContext is the same as StopMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See StopMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopMonitoringScheduleWithContext(ctx aws.Context, input *StopMonitoringScheduleInput, opts ...request.Option) (*StopMonitoringScheduleOutput, error) {
	req, out := c.StopMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopNotebookInstance = "StopNotebookInstance"

// StopNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StopNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopNotebookInstance for more information on using the StopNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopNotebookInstanceRequest method.
//    req, resp := client.StopNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopNotebookInstance
func (c *SageMaker) StopNotebookInstanceRequest(input *StopNotebookInstanceInput) (req *request.Request, output *StopNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opStopNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopNotebookInstanceInput{}
	}

	output = &StopNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopNotebookInstance API operation for Amazon SageMaker Service.
//
// Terminates the ML compute instance. Before terminating the instance, Amazon
// SageMaker disconnects the ML storage volume from it. Amazon SageMaker preserves
// the ML storage volume. Amazon SageMaker stops charging you for the ML compute
// instance when you call StopNotebookInstance.
//
// To access data on the ML storage volume for a notebook instance that has
// been terminated, call the StartNotebookInstance API. StartNotebookInstance
// launches another ML compute instance, configures it, and attaches the preserved
// ML storage volume so you can continue your work.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopNotebookInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopNotebookInstance
func (c *SageMaker) StopNotebookInstance(input *StopNotebookInstanceInput) (*StopNotebookInstanceOutput, error) {
	req, out := c.StopNotebookInstanceRequest(input)
	return out, req.Send()
}

// StopNotebookInstanceWithContext is the same as StopNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StopNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopNotebookInstanceWithContext(ctx aws.Context, input *StopNotebookInstanceInput, opts ...request.Option) (*StopNotebookInstanceOutput, error) {
	req, out := c.StopNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopPipelineExecution = "StopPipelineExecution"

// StopPipelineExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StopPipelineExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopPipelineExecution for more information on using the StopPipelineExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopPipelineExecutionRequest method.
//    req, resp := client.StopPipelineExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopPipelineExecution
func (c *SageMaker) StopPipelineExecutionRequest(input *StopPipelineExecutionInput) (req *request.Request, output *StopPipelineExecutionOutput) {
	op := &request.Operation{
		Name:       opStopPipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopPipelineExecutionInput{}
	}

	output = &StopPipelineExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopPipelineExecution API operation for Amazon SageMaker Service.
//
// Stops a pipeline execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopPipelineExecution for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopPipelineExecution
func (c *SageMaker) StopPipelineExecution(input *StopPipelineExecutionInput) (*StopPipelineExecutionOutput, error) {
	req, out := c.StopPipelineExecutionRequest(input)
	return out, req.Send()
}

// StopPipelineExecutionWithContext is the same as StopPipelineExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StopPipelineExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopPipelineExecutionWithContext(ctx aws.Context, input *StopPipelineExecutionInput, opts ...request.Option) (*StopPipelineExecutionOutput, error) {
	req, out := c.StopPipelineExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopProcessingJob = "StopProcessingJob"

// StopProcessingJobRequest generates a "aws/request.Request" representing the
// client's request for the StopProcessingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopProcessingJob for more information on using the StopProcessingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopProcessingJobRequest method.
//    req, resp := client.StopProcessingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopProcessingJob
func (c *SageMaker) StopProcessingJobRequest(input *StopProcessingJobInput) (req *request.Request, output *StopProcessingJobOutput) {
	op := &request.Operation{
		Name:       opStopProcessingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopProcessingJobInput{}
	}

	output = &StopProcessingJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopProcessingJob API operation for Amazon SageMaker Service.
//
// Stops a processing job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopProcessingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopProcessingJob
func (c *SageMaker) StopProcessingJob(input *StopProcessingJobInput) (*StopProcessingJobOutput, error) {
	req, out := c.StopProcessingJobRequest(input)
	return out, req.Send()
}

// StopProcessingJobWithContext is the same as StopProcessingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopProcessingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopProcessingJobWithContext(ctx aws.Context, input *StopProcessingJobInput, opts ...request.Option) (*StopProcessingJobOutput, error) {
	req, out := c.StopProcessingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTrainingJob = "StopTrainingJob"

// StopTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the StopTrainingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTrainingJob for more information on using the StopTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopTrainingJobRequest method.
//    req, resp := client.StopTrainingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTrainingJob
func (c *SageMaker) StopTrainingJobRequest(input *StopTrainingJobInput) (req *request.Request, output *StopTrainingJobOutput) {
	op := &request.Operation{
		Name:       opStopTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTrainingJobInput{}
	}

	output = &StopTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopTrainingJob API operation for Amazon SageMaker Service.
//
// Stops a training job. To stop a job, Amazon SageMaker sends the algorithm
// the SIGTERM signal, which delays job termination for 120 seconds. Algorithms
// might use this 120-second window to save the model artifacts, so the results
// of the training is not lost.
//
// When it receives a StopTrainingJob request, Amazon SageMaker changes the
// status of the job to Stopping. After Amazon SageMaker stops the job, it sets
// the status to Stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopTrainingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTrainingJob
func (c *SageMaker) StopTrainingJob(input *StopTrainingJobInput) (*StopTrainingJobOutput, error) {
	req, out := c.StopTrainingJobRequest(input)
	return out, req.Send()
}

// StopTrainingJobWithContext is the same as StopTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopTrainingJobWithContext(ctx aws.Context, input *StopTrainingJobInput, opts ...request.Option) (*StopTrainingJobOutput, error) {
	req, out := c.StopTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTransformJob = "StopTransformJob"

// StopTransformJobRequest generates a "aws/request.Request" representing the
// client's request for the StopTransformJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTransformJob for more information on using the StopTransformJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopTransformJobRequest method.
//    req, resp := client.StopTransformJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTransformJob
func (c *SageMaker) StopTransformJobRequest(input *StopTransformJobInput) (req *request.Request, output *StopTransformJobOutput) {
	op := &request.Operation{
		Name:       opStopTransformJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTransformJobInput{}
	}

	output = &StopTransformJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopTransformJob API operation for Amazon SageMaker Service.
//
// Stops a transform job.
//
// When Amazon SageMaker receives a StopTransformJob request, the status of
// the job changes to Stopping. After Amazon SageMaker stops the job, the status
// is set to Stopped. When you stop a transform job before it is completed,
// Amazon SageMaker doesn't store the job's output in Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation StopTransformJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopTransformJob
func (c *SageMaker) StopTransformJob(input *StopTransformJobInput) (*StopTransformJobOutput, error) {
	req, out := c.StopTransformJobRequest(input)
	return out, req.Send()
}

// StopTransformJobWithContext is the same as StopTransformJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopTransformJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) StopTransformJobWithContext(ctx aws.Context, input *StopTransformJobInput, opts ...request.Option) (*StopTransformJobOutput, error) {
	req, out := c.StopTransformJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAction = "UpdateAction"

// UpdateActionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAction for more information on using the UpdateAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateActionRequest method.
//    req, resp := client.UpdateActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateAction
func (c *SageMaker) UpdateActionRequest(input *UpdateActionInput) (req *request.Request, output *UpdateActionOutput) {
	op := &request.Operation{
		Name:       opUpdateAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateActionInput{}
	}

	output = &UpdateActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAction API operation for Amazon SageMaker Service.
//
// Updates an action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateAction for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when you attempted to modify an experiment, trial, or
//   trial component.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateAction
func (c *SageMaker) UpdateAction(input *UpdateActionInput) (*UpdateActionOutput, error) {
	req, out := c.UpdateActionRequest(input)
	return out, req.Send()
}

// UpdateActionWithContext is the same as UpdateAction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateActionWithContext(ctx aws.Context, input *UpdateActionInput, opts ...request.Option) (*UpdateActionOutput, error) {
	req, out := c.UpdateActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAppImageConfig = "UpdateAppImageConfig"

// UpdateAppImageConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAppImageConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAppImageConfig for more information on using the UpdateAppImageConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAppImageConfigRequest method.
//    req, resp := client.UpdateAppImageConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateAppImageConfig
func (c *SageMaker) UpdateAppImageConfigRequest(input *UpdateAppImageConfigInput) (req *request.Request, output *UpdateAppImageConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateAppImageConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAppImageConfigInput{}
	}

	output = &UpdateAppImageConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAppImageConfig API operation for Amazon SageMaker Service.
//
// Updates the properties of an AppImageConfig.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateAppImageConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateAppImageConfig
func (c *SageMaker) UpdateAppImageConfig(input *UpdateAppImageConfigInput) (*UpdateAppImageConfigOutput, error) {
	req, out := c.UpdateAppImageConfigRequest(input)
	return out, req.Send()
}

// UpdateAppImageConfigWithContext is the same as UpdateAppImageConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAppImageConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateAppImageConfigWithContext(ctx aws.Context, input *UpdateAppImageConfigInput, opts ...request.Option) (*UpdateAppImageConfigOutput, error) {
	req, out := c.UpdateAppImageConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateArtifact = "UpdateArtifact"

// UpdateArtifactRequest generates a "aws/request.Request" representing the
// client's request for the UpdateArtifact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateArtifact for more information on using the UpdateArtifact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateArtifactRequest method.
//    req, resp := client.UpdateArtifactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateArtifact
func (c *SageMaker) UpdateArtifactRequest(input *UpdateArtifactInput) (req *request.Request, output *UpdateArtifactOutput) {
	op := &request.Operation{
		Name:       opUpdateArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateArtifactInput{}
	}

	output = &UpdateArtifactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateArtifact API operation for Amazon SageMaker Service.
//
// Updates an artifact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateArtifact for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when you attempted to modify an experiment, trial, or
//   trial component.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateArtifact
func (c *SageMaker) UpdateArtifact(input *UpdateArtifactInput) (*UpdateArtifactOutput, error) {
	req, out := c.UpdateArtifactRequest(input)
	return out, req.Send()
}

// UpdateArtifactWithContext is the same as UpdateArtifact with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateArtifact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateArtifactWithContext(ctx aws.Context, input *UpdateArtifactInput, opts ...request.Option) (*UpdateArtifactOutput, error) {
	req, out := c.UpdateArtifactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCodeRepository = "UpdateCodeRepository"

// UpdateCodeRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCodeRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCodeRepository for more information on using the UpdateCodeRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCodeRepositoryRequest method.
//    req, resp := client.UpdateCodeRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateCodeRepository
func (c *SageMaker) UpdateCodeRepositoryRequest(input *UpdateCodeRepositoryInput) (req *request.Request, output *UpdateCodeRepositoryOutput) {
	op := &request.Operation{
		Name:       opUpdateCodeRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCodeRepositoryInput{}
	}

	output = &UpdateCodeRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCodeRepository API operation for Amazon SageMaker Service.
//
// Updates the specified Git repository with the specified values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateCodeRepository for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateCodeRepository
func (c *SageMaker) UpdateCodeRepository(input *UpdateCodeRepositoryInput) (*UpdateCodeRepositoryOutput, error) {
	req, out := c.UpdateCodeRepositoryRequest(input)
	return out, req.Send()
}

// UpdateCodeRepositoryWithContext is the same as UpdateCodeRepository with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCodeRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateCodeRepositoryWithContext(ctx aws.Context, input *UpdateCodeRepositoryInput, opts ...request.Option) (*UpdateCodeRepositoryOutput, error) {
	req, out := c.UpdateCodeRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContext = "UpdateContext"

// UpdateContextRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContext operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContext for more information on using the UpdateContext
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateContextRequest method.
//    req, resp := client.UpdateContextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateContext
func (c *SageMaker) UpdateContextRequest(input *UpdateContextInput) (req *request.Request, output *UpdateContextOutput) {
	op := &request.Operation{
		Name:       opUpdateContext,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateContextInput{}
	}

	output = &UpdateContextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateContext API operation for Amazon SageMaker Service.
//
// Updates a context.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateContext for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when you attempted to modify an experiment, trial, or
//   trial component.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateContext
func (c *SageMaker) UpdateContext(input *UpdateContextInput) (*UpdateContextOutput, error) {
	req, out := c.UpdateContextRequest(input)
	return out, req.Send()
}

// UpdateContextWithContext is the same as UpdateContext with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContext for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateContextWithContext(ctx aws.Context, input *UpdateContextInput, opts ...request.Option) (*UpdateContextOutput, error) {
	req, out := c.UpdateContextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeviceFleet = "UpdateDeviceFleet"

// UpdateDeviceFleetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeviceFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeviceFleet for more information on using the UpdateDeviceFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeviceFleetRequest method.
//    req, resp := client.UpdateDeviceFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateDeviceFleet
func (c *SageMaker) UpdateDeviceFleetRequest(input *UpdateDeviceFleetInput) (req *request.Request, output *UpdateDeviceFleetOutput) {
	op := &request.Operation{
		Name:       opUpdateDeviceFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeviceFleetInput{}
	}

	output = &UpdateDeviceFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDeviceFleet API operation for Amazon SageMaker Service.
//
// Updates a fleet of devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateDeviceFleet for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateDeviceFleet
func (c *SageMaker) UpdateDeviceFleet(input *UpdateDeviceFleetInput) (*UpdateDeviceFleetOutput, error) {
	req, out := c.UpdateDeviceFleetRequest(input)
	return out, req.Send()
}

// UpdateDeviceFleetWithContext is the same as UpdateDeviceFleet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeviceFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateDeviceFleetWithContext(ctx aws.Context, input *UpdateDeviceFleetInput, opts ...request.Option) (*UpdateDeviceFleetOutput, error) {
	req, out := c.UpdateDeviceFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDevices = "UpdateDevices"

// UpdateDevicesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDevices for more information on using the UpdateDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDevicesRequest method.
//    req, resp := client.UpdateDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateDevices
func (c *SageMaker) UpdateDevicesRequest(input *UpdateDevicesInput) (req *request.Request, output *UpdateDevicesOutput) {
	op := &request.Operation{
		Name:       opUpdateDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDevicesInput{}
	}

	output = &UpdateDevicesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDevices API operation for Amazon SageMaker Service.
//
// Updates one or more devices in a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateDevices for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateDevices
func (c *SageMaker) UpdateDevices(input *UpdateDevicesInput) (*UpdateDevicesOutput, error) {
	req, out := c.UpdateDevicesRequest(input)
	return out, req.Send()
}

// UpdateDevicesWithContext is the same as UpdateDevices with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateDevicesWithContext(ctx aws.Context, input *UpdateDevicesInput, opts ...request.Option) (*UpdateDevicesOutput, error) {
	req, out := c.UpdateDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomain = "UpdateDomain"

// UpdateDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomain for more information on using the UpdateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainRequest method.
//    req, resp := client.UpdateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateDomain
func (c *SageMaker) UpdateDomainRequest(input *UpdateDomainInput) (req *request.Request, output *UpdateDomainOutput) {
	op := &request.Operation{
		Name:       opUpdateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainInput{}
	}

	output = &UpdateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomain API operation for Amazon SageMaker Service.
//
// Updates the default settings for new user profiles in the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateDomain for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateDomain
func (c *SageMaker) UpdateDomain(input *UpdateDomainInput) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	return out, req.Send()
}

// UpdateDomainWithContext is the same as UpdateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateDomainWithContext(ctx aws.Context, input *UpdateDomainInput, opts ...request.Option) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpoint = "UpdateEndpoint"

// UpdateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpoint for more information on using the UpdateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointRequest method.
//    req, resp := client.UpdateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpoint
func (c *SageMaker) UpdateEndpointRequest(input *UpdateEndpointInput) (req *request.Request, output *UpdateEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointInput{}
	}

	output = &UpdateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpoint API operation for Amazon SageMaker Service.
//
// Deploys the new EndpointConfig specified in the request, switches to using
// newly created endpoint, and then deletes resources provisioned for the endpoint
// using the previous EndpointConfig (there is no availability loss).
//
// When Amazon SageMaker receives the request, it sets the endpoint status to
// Updating. After updating the endpoint, it sets the status to InService. To
// check the status of an endpoint, use the DescribeEndpoint API.
//
// You must not delete an EndpointConfig in use by an endpoint that is live
// or while the UpdateEndpoint or CreateEndpoint operations are being performed
// on the endpoint. To update an endpoint, you must create a new EndpointConfig.
//
// If you delete the EndpointConfig of an endpoint that is active or being created
// or updated you may lose visibility into the instance type the endpoint is
// using. The endpoint must be deleted in order to stop incurring charges.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateEndpoint for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpoint
func (c *SageMaker) UpdateEndpoint(input *UpdateEndpointInput) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	return out, req.Send()
}

// UpdateEndpointWithContext is the same as UpdateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateEndpointWithContext(ctx aws.Context, input *UpdateEndpointInput, opts ...request.Option) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpointWeightsAndCapacities = "UpdateEndpointWeightsAndCapacities"

// UpdateEndpointWeightsAndCapacitiesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpointWeightsAndCapacities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpointWeightsAndCapacities for more information on using the UpdateEndpointWeightsAndCapacities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointWeightsAndCapacitiesRequest method.
//    req, resp := client.UpdateEndpointWeightsAndCapacitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpointWeightsAndCapacities
func (c *SageMaker) UpdateEndpointWeightsAndCapacitiesRequest(input *UpdateEndpointWeightsAndCapacitiesInput) (req *request.Request, output *UpdateEndpointWeightsAndCapacitiesOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpointWeightsAndCapacities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointWeightsAndCapacitiesInput{}
	}

	output = &UpdateEndpointWeightsAndCapacitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpointWeightsAndCapacities API operation for Amazon SageMaker Service.
//
// Updates variant weight of one or more variants associated with an existing
// endpoint, or capacity of one variant associated with an existing endpoint.
// When it receives the request, Amazon SageMaker sets the endpoint status to
// Updating. After updating the endpoint, it sets the status to InService. To
// check the status of an endpoint, use the DescribeEndpoint API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateEndpointWeightsAndCapacities for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpointWeightsAndCapacities
func (c *SageMaker) UpdateEndpointWeightsAndCapacities(input *UpdateEndpointWeightsAndCapacitiesInput) (*UpdateEndpointWeightsAndCapacitiesOutput, error) {
	req, out := c.UpdateEndpointWeightsAndCapacitiesRequest(input)
	return out, req.Send()
}

// UpdateEndpointWeightsAndCapacitiesWithContext is the same as UpdateEndpointWeightsAndCapacities with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpointWeightsAndCapacities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateEndpointWeightsAndCapacitiesWithContext(ctx aws.Context, input *UpdateEndpointWeightsAndCapacitiesInput, opts ...request.Option) (*UpdateEndpointWeightsAndCapacitiesOutput, error) {
	req, out := c.UpdateEndpointWeightsAndCapacitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateExperiment = "UpdateExperiment"

// UpdateExperimentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateExperiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateExperiment for more information on using the UpdateExperiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateExperimentRequest method.
//    req, resp := client.UpdateExperimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateExperiment
func (c *SageMaker) UpdateExperimentRequest(input *UpdateExperimentInput) (req *request.Request, output *UpdateExperimentOutput) {
	op := &request.Operation{
		Name:       opUpdateExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateExperimentInput{}
	}

	output = &UpdateExperimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateExperiment API operation for Amazon SageMaker Service.
//
// Adds, updates, or removes the description of an experiment. Updates the display
// name of an experiment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateExperiment for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when you attempted to modify an experiment, trial, or
//   trial component.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateExperiment
func (c *SageMaker) UpdateExperiment(input *UpdateExperimentInput) (*UpdateExperimentOutput, error) {
	req, out := c.UpdateExperimentRequest(input)
	return out, req.Send()
}

// UpdateExperimentWithContext is the same as UpdateExperiment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateExperiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateExperimentWithContext(ctx aws.Context, input *UpdateExperimentInput, opts ...request.Option) (*UpdateExperimentOutput, error) {
	req, out := c.UpdateExperimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateImage = "UpdateImage"

// UpdateImageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateImage for more information on using the UpdateImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateImageRequest method.
//    req, resp := client.UpdateImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateImage
func (c *SageMaker) UpdateImageRequest(input *UpdateImageInput) (req *request.Request, output *UpdateImageOutput) {
	op := &request.Operation{
		Name:       opUpdateImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateImageInput{}
	}

	output = &UpdateImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateImage API operation for Amazon SageMaker Service.
//
// Updates the properties of a SageMaker image. To change the image's tags,
// use the AddTags and DeleteTags APIs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateImage for usage and error information.
//
// Returned Error Types:
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateImage
func (c *SageMaker) UpdateImage(input *UpdateImageInput) (*UpdateImageOutput, error) {
	req, out := c.UpdateImageRequest(input)
	return out, req.Send()
}

// UpdateImageWithContext is the same as UpdateImage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateImageWithContext(ctx aws.Context, input *UpdateImageInput, opts ...request.Option) (*UpdateImageOutput, error) {
	req, out := c.UpdateImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateModelPackage = "UpdateModelPackage"

// UpdateModelPackageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateModelPackage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateModelPackage for more information on using the UpdateModelPackage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateModelPackageRequest method.
//    req, resp := client.UpdateModelPackageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateModelPackage
func (c *SageMaker) UpdateModelPackageRequest(input *UpdateModelPackageInput) (req *request.Request, output *UpdateModelPackageOutput) {
	op := &request.Operation{
		Name:       opUpdateModelPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelPackageInput{}
	}

	output = &UpdateModelPackageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateModelPackage API operation for Amazon SageMaker Service.
//
// Updates a versioned model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateModelPackage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateModelPackage
func (c *SageMaker) UpdateModelPackage(input *UpdateModelPackageInput) (*UpdateModelPackageOutput, error) {
	req, out := c.UpdateModelPackageRequest(input)
	return out, req.Send()
}

// UpdateModelPackageWithContext is the same as UpdateModelPackage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateModelPackage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateModelPackageWithContext(ctx aws.Context, input *UpdateModelPackageInput, opts ...request.Option) (*UpdateModelPackageOutput, error) {
	req, out := c.UpdateModelPackageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMonitoringSchedule = "UpdateMonitoringSchedule"

// UpdateMonitoringScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMonitoringSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMonitoringSchedule for more information on using the UpdateMonitoringSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMonitoringScheduleRequest method.
//    req, resp := client.UpdateMonitoringScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateMonitoringSchedule
func (c *SageMaker) UpdateMonitoringScheduleRequest(input *UpdateMonitoringScheduleInput) (req *request.Request, output *UpdateMonitoringScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateMonitoringSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMonitoringScheduleInput{}
	}

	output = &UpdateMonitoringScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMonitoringSchedule API operation for Amazon SageMaker Service.
//
// Updates a previously created schedule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateMonitoringSchedule for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateMonitoringSchedule
func (c *SageMaker) UpdateMonitoringSchedule(input *UpdateMonitoringScheduleInput) (*UpdateMonitoringScheduleOutput, error) {
	req, out := c.UpdateMonitoringScheduleRequest(input)
	return out, req.Send()
}

// UpdateMonitoringScheduleWithContext is the same as UpdateMonitoringSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMonitoringSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateMonitoringScheduleWithContext(ctx aws.Context, input *UpdateMonitoringScheduleInput, opts ...request.Option) (*UpdateMonitoringScheduleOutput, error) {
	req, out := c.UpdateMonitoringScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNotebookInstance = "UpdateNotebookInstance"

// UpdateNotebookInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNotebookInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNotebookInstance for more information on using the UpdateNotebookInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNotebookInstanceRequest method.
//    req, resp := client.UpdateNotebookInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstance
func (c *SageMaker) UpdateNotebookInstanceRequest(input *UpdateNotebookInstanceInput) (req *request.Request, output *UpdateNotebookInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateNotebookInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNotebookInstanceInput{}
	}

	output = &UpdateNotebookInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateNotebookInstance API operation for Amazon SageMaker Service.
//
// Updates a notebook instance. NotebookInstance updates include upgrading or
// downgrading the ML compute instance used for your notebook instance to accommodate
// changes in your workload requirements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateNotebookInstance for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstance
func (c *SageMaker) UpdateNotebookInstance(input *UpdateNotebookInstanceInput) (*UpdateNotebookInstanceOutput, error) {
	req, out := c.UpdateNotebookInstanceRequest(input)
	return out, req.Send()
}

// UpdateNotebookInstanceWithContext is the same as UpdateNotebookInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNotebookInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateNotebookInstanceWithContext(ctx aws.Context, input *UpdateNotebookInstanceInput, opts ...request.Option) (*UpdateNotebookInstanceOutput, error) {
	req, out := c.UpdateNotebookInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNotebookInstanceLifecycleConfig = "UpdateNotebookInstanceLifecycleConfig"

// UpdateNotebookInstanceLifecycleConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNotebookInstanceLifecycleConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNotebookInstanceLifecycleConfig for more information on using the UpdateNotebookInstanceLifecycleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNotebookInstanceLifecycleConfigRequest method.
//    req, resp := client.UpdateNotebookInstanceLifecycleConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstanceLifecycleConfig
func (c *SageMaker) UpdateNotebookInstanceLifecycleConfigRequest(input *UpdateNotebookInstanceLifecycleConfigInput) (req *request.Request, output *UpdateNotebookInstanceLifecycleConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNotebookInstanceLifecycleConfigInput{}
	}

	output = &UpdateNotebookInstanceLifecycleConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateNotebookInstanceLifecycleConfig API operation for Amazon SageMaker Service.
//
// Updates a notebook instance lifecycle configuration created with the CreateNotebookInstanceLifecycleConfig
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateNotebookInstanceLifecycleConfig for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateNotebookInstanceLifecycleConfig
func (c *SageMaker) UpdateNotebookInstanceLifecycleConfig(input *UpdateNotebookInstanceLifecycleConfigInput) (*UpdateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.UpdateNotebookInstanceLifecycleConfigRequest(input)
	return out, req.Send()
}

// UpdateNotebookInstanceLifecycleConfigWithContext is the same as UpdateNotebookInstanceLifecycleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNotebookInstanceLifecycleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateNotebookInstanceLifecycleConfigWithContext(ctx aws.Context, input *UpdateNotebookInstanceLifecycleConfigInput, opts ...request.Option) (*UpdateNotebookInstanceLifecycleConfigOutput, error) {
	req, out := c.UpdateNotebookInstanceLifecycleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePipeline = "UpdatePipeline"

// UpdatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePipeline for more information on using the UpdatePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePipelineRequest method.
//    req, resp := client.UpdatePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdatePipeline
func (c *SageMaker) UpdatePipelineRequest(input *UpdatePipelineInput) (req *request.Request, output *UpdatePipelineOutput) {
	op := &request.Operation{
		Name:       opUpdatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePipelineInput{}
	}

	output = &UpdatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePipeline API operation for Amazon SageMaker Service.
//
// Updates a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdatePipeline for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdatePipeline
func (c *SageMaker) UpdatePipeline(input *UpdatePipelineInput) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	return out, req.Send()
}

// UpdatePipelineWithContext is the same as UpdatePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdatePipelineWithContext(ctx aws.Context, input *UpdatePipelineInput, opts ...request.Option) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePipelineExecution = "UpdatePipelineExecution"

// UpdatePipelineExecutionRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePipelineExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePipelineExecution for more information on using the UpdatePipelineExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePipelineExecutionRequest method.
//    req, resp := client.UpdatePipelineExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdatePipelineExecution
func (c *SageMaker) UpdatePipelineExecutionRequest(input *UpdatePipelineExecutionInput) (req *request.Request, output *UpdatePipelineExecutionOutput) {
	op := &request.Operation{
		Name:       opUpdatePipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePipelineExecutionInput{}
	}

	output = &UpdatePipelineExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePipelineExecution API operation for Amazon SageMaker Service.
//
// Updates a pipeline execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdatePipelineExecution for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdatePipelineExecution
func (c *SageMaker) UpdatePipelineExecution(input *UpdatePipelineExecutionInput) (*UpdatePipelineExecutionOutput, error) {
	req, out := c.UpdatePipelineExecutionRequest(input)
	return out, req.Send()
}

// UpdatePipelineExecutionWithContext is the same as UpdatePipelineExecution with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePipelineExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdatePipelineExecutionWithContext(ctx aws.Context, input *UpdatePipelineExecutionInput, opts ...request.Option) (*UpdatePipelineExecutionOutput, error) {
	req, out := c.UpdatePipelineExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrainingJob = "UpdateTrainingJob"

// UpdateTrainingJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrainingJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrainingJob for more information on using the UpdateTrainingJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTrainingJobRequest method.
//    req, resp := client.UpdateTrainingJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateTrainingJob
func (c *SageMaker) UpdateTrainingJobRequest(input *UpdateTrainingJobInput) (req *request.Request, output *UpdateTrainingJobOutput) {
	op := &request.Operation{
		Name:       opUpdateTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrainingJobInput{}
	}

	output = &UpdateTrainingJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrainingJob API operation for Amazon SageMaker Service.
//
// Update a model training job to request a new Debugger profiling configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateTrainingJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateTrainingJob
func (c *SageMaker) UpdateTrainingJob(input *UpdateTrainingJobInput) (*UpdateTrainingJobOutput, error) {
	req, out := c.UpdateTrainingJobRequest(input)
	return out, req.Send()
}

// UpdateTrainingJobWithContext is the same as UpdateTrainingJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrainingJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateTrainingJobWithContext(ctx aws.Context, input *UpdateTrainingJobInput, opts ...request.Option) (*UpdateTrainingJobOutput, error) {
	req, out := c.UpdateTrainingJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrial = "UpdateTrial"

// UpdateTrialRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrial operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrial for more information on using the UpdateTrial
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTrialRequest method.
//    req, resp := client.UpdateTrialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateTrial
func (c *SageMaker) UpdateTrialRequest(input *UpdateTrialInput) (req *request.Request, output *UpdateTrialOutput) {
	op := &request.Operation{
		Name:       opUpdateTrial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrialInput{}
	}

	output = &UpdateTrialOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrial API operation for Amazon SageMaker Service.
//
// Updates the display name of a trial.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateTrial for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when you attempted to modify an experiment, trial, or
//   trial component.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateTrial
func (c *SageMaker) UpdateTrial(input *UpdateTrialInput) (*UpdateTrialOutput, error) {
	req, out := c.UpdateTrialRequest(input)
	return out, req.Send()
}

// UpdateTrialWithContext is the same as UpdateTrial with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrial for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateTrialWithContext(ctx aws.Context, input *UpdateTrialInput, opts ...request.Option) (*UpdateTrialOutput, error) {
	req, out := c.UpdateTrialRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrialComponent = "UpdateTrialComponent"

// UpdateTrialComponentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrialComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrialComponent for more information on using the UpdateTrialComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTrialComponentRequest method.
//    req, resp := client.UpdateTrialComponentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateTrialComponent
func (c *SageMaker) UpdateTrialComponentRequest(input *UpdateTrialComponentInput) (req *request.Request, output *UpdateTrialComponentOutput) {
	op := &request.Operation{
		Name:       opUpdateTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrialComponentInput{}
	}

	output = &UpdateTrialComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrialComponent API operation for Amazon SageMaker Service.
//
// Updates one or more properties of a trial component.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateTrialComponent for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   There was a conflict when you attempted to modify an experiment, trial, or
//   trial component.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateTrialComponent
func (c *SageMaker) UpdateTrialComponent(input *UpdateTrialComponentInput) (*UpdateTrialComponentOutput, error) {
	req, out := c.UpdateTrialComponentRequest(input)
	return out, req.Send()
}

// UpdateTrialComponentWithContext is the same as UpdateTrialComponent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrialComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateTrialComponentWithContext(ctx aws.Context, input *UpdateTrialComponentInput, opts ...request.Option) (*UpdateTrialComponentOutput, error) {
	req, out := c.UpdateTrialComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserProfile = "UpdateUserProfile"

// UpdateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserProfile for more information on using the UpdateUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserProfileRequest method.
//    req, resp := client.UpdateUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateUserProfile
func (c *SageMaker) UpdateUserProfileRequest(input *UpdateUserProfileInput) (req *request.Request, output *UpdateUserProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserProfileInput{}
	}

	output = &UpdateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserProfile API operation for Amazon SageMaker Service.
//
// Updates a user profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateUserProfile for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
//   * ResourceInUse
//   Resource being accessed is in use.
//
//   * ResourceNotFound
//   Resource being access is not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateUserProfile
func (c *SageMaker) UpdateUserProfile(input *UpdateUserProfileInput) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	return out, req.Send()
}

// UpdateUserProfileWithContext is the same as UpdateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateUserProfileWithContext(ctx aws.Context, input *UpdateUserProfileInput, opts ...request.Option) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkforce = "UpdateWorkforce"

// UpdateWorkforceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkforce operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkforce for more information on using the UpdateWorkforce
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkforceRequest method.
//    req, resp := client.UpdateWorkforceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateWorkforce
func (c *SageMaker) UpdateWorkforceRequest(input *UpdateWorkforceInput) (req *request.Request, output *UpdateWorkforceOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkforce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkforceInput{}
	}

	output = &UpdateWorkforceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkforce API operation for Amazon SageMaker Service.
//
// Use this operation to update your workforce. You can use this operation to
// require that workers use specific IP addresses to work on tasks and to update
// your OpenID Connect (OIDC) Identity Provider (IdP) workforce configuration.
//
// Use SourceIpConfig to restrict worker access to tasks to a specific range
// of IP addresses. You specify allowed IP addresses by creating a list of up
// to ten CIDRs (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html).
// By default, a workforce isn't restricted to specific IP addresses. If you
// specify a range of IP addresses, workers who attempt to access tasks using
// any IP address outside the specified range are denied and get a Not Found
// error message on the worker portal.
//
// Use OidcConfig to update the configuration of a workforce created using your
// own OIDC IdP.
//
// You can only update your OIDC IdP configuration when there are no work teams
// associated with your workforce. You can delete work teams using the operation.
//
// After restricting access to a range of IP addresses or updating your OIDC
// IdP configuration with this operation, you can view details about your update
// workforce using the operation.
//
// This operation only applies to private workforces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateWorkforce for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateWorkforce
func (c *SageMaker) UpdateWorkforce(input *UpdateWorkforceInput) (*UpdateWorkforceOutput, error) {
	req, out := c.UpdateWorkforceRequest(input)
	return out, req.Send()
}

// UpdateWorkforceWithContext is the same as UpdateWorkforce with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkforce for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateWorkforceWithContext(ctx aws.Context, input *UpdateWorkforceInput, opts ...request.Option) (*UpdateWorkforceOutput, error) {
	req, out := c.UpdateWorkforceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkteam = "UpdateWorkteam"

// UpdateWorkteamRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkteam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkteam for more information on using the UpdateWorkteam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkteamRequest method.
//    req, resp := client.UpdateWorkteamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateWorkteam
func (c *SageMaker) UpdateWorkteamRequest(input *UpdateWorkteamInput) (req *request.Request, output *UpdateWorkteamOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkteamInput{}
	}

	output = &UpdateWorkteamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkteam API operation for Amazon SageMaker Service.
//
// Updates an existing work team with new member definitions or description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Service's
// API operation UpdateWorkteam for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceeded
//   You have exceeded an Amazon SageMaker resource limit. For example, you might
//   have too many training jobs created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateWorkteam
func (c *SageMaker) UpdateWorkteam(input *UpdateWorkteamInput) (*UpdateWorkteamOutput, error) {
	req, out := c.UpdateWorkteamRequest(input)
	return out, req.Send()
}

// UpdateWorkteamWithContext is the same as UpdateWorkteam with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkteam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMaker) UpdateWorkteamWithContext(ctx aws.Context, input *UpdateWorkteamInput, opts ...request.Option) (*UpdateWorkteamOutput, error) {
	req, out := c.UpdateWorkteamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A structure describing the source of an action.
type ActionSource struct {
	_ struct{} `type:"structure"`

	// The ID of the source.
	SourceId *string `type:"string"`

	// The type of the source.
	SourceType *string `type:"string"`

	// The URI of the source.
	//
	// SourceUri is a required field
	SourceUri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ActionSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionSource"}
	if s.SourceUri == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceId sets the SourceId field's value.
func (s *ActionSource) SetSourceId(v string) *ActionSource {
	s.SourceId = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ActionSource) SetSourceType(v string) *ActionSource {
	s.SourceType = &v
	return s
}

// SetSourceUri sets the SourceUri field's value.
func (s *ActionSource) SetSourceUri(v string) *ActionSource {
	s.SourceUri = &v
	return s
}

// Lists the properties of an action. An action represents an action or activity.
// Some examples are a workflow step and a model deployment. Generally, an action
// involves at least one input artifact or output artifact.
type ActionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the action.
	ActionArn *string `type:"string"`

	// The name of the action.
	ActionName *string `min:"1" type:"string"`

	// The type of the action.
	ActionType *string `type:"string"`

	// When the action was created.
	CreationTime *time.Time `type:"timestamp"`

	// When the action was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The source of the action.
	Source *ActionSource `type:"structure"`

	// The status of the action.
	Status *string `type:"string" enum:"ActionStatus"`
}

// String returns the string representation
func (s ActionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionSummary) GoString() string {
	return s.String()
}

// SetActionArn sets the ActionArn field's value.
func (s *ActionSummary) SetActionArn(v string) *ActionSummary {
	s.ActionArn = &v
	return s
}

// SetActionName sets the ActionName field's value.
func (s *ActionSummary) SetActionName(v string) *ActionSummary {
	s.ActionName = &v
	return s
}

// SetActionType sets the ActionType field's value.
func (s *ActionSummary) SetActionType(v string) *ActionSummary {
	s.ActionType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ActionSummary) SetCreationTime(v time.Time) *ActionSummary {
	s.CreationTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *ActionSummary) SetLastModifiedTime(v time.Time) *ActionSummary {
	s.LastModifiedTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ActionSummary) SetSource(v *ActionSource) *ActionSummary {
	s.Source = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ActionSummary) SetStatus(v string) *ActionSummary {
	s.Status = &v
	return s
}

type AddAssociationInput struct {
	_ struct{} `type:"structure"`

	// The type of association. The following are suggested uses for each type.
	// Amazon SageMaker places no restrictions on their use.
	//
	//    * ContributedTo - The source contributed to the destination or had a part
	//    in enabling the destination. For example, the training data contributed
	//    to the training job.
	//
	//    * AssociatedWith - The source is connected to the destination. For example,
	//    an approval workflow is associated with a model deployment.
	//
	//    * DerivedFrom - The destination is a modification of the source. For example,
	//    a digest output of a channel input for a processing job is derived from
	//    the original inputs.
	//
	//    * Produced - The source generated the destination. For example, a training
	//    job produced a model artifact.
	AssociationType *string `type:"string" enum:"AssociationEdgeType"`

	// The Amazon Resource Name (ARN) of the destination.
	//
	// DestinationArn is a required field
	DestinationArn *string `type:"string" required:"true"`

	// The ARN of the source.
	//
	// SourceArn is a required field
	SourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddAssociationInput"}
	if s.DestinationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationArn"))
	}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationType sets the AssociationType field's value.
func (s *AddAssociationInput) SetAssociationType(v string) *AddAssociationInput {
	s.AssociationType = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *AddAssociationInput) SetDestinationArn(v string) *AddAssociationInput {
	s.DestinationArn = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *AddAssociationInput) SetSourceArn(v string) *AddAssociationInput {
	s.SourceArn = &v
	return s
}

type AddAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination.
	DestinationArn *string `type:"string"`

	// The ARN of the source.
	SourceArn *string `type:"string"`
}

// String returns the string representation
func (s AddAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAssociationOutput) GoString() string {
	return s.String()
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *AddAssociationOutput) SetDestinationArn(v string) *AddAssociationOutput {
	s.DestinationArn = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *AddAssociationOutput) SetSourceArn(v string) *AddAssociationOutput {
	s.SourceArn = &v
	return s
}

type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// An array of key-value pairs. You can use tags to categorize your AWS resources
	// in different ways, for example, by purpose, owner, or environment. For more
	// information, see Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AddTagsInput) SetResourceArn(v string) *AddTagsInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsInput) SetTags(v []*Tag) *AddTagsInput {
	s.Tags = v
	return s
}

type AddTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags associated with the Amazon SageMaker resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *AddTagsOutput) SetTags(v []*Tag) *AddTagsOutput {
	s.Tags = v
	return s
}

// Edge Manager agent version.
type AgentVersion struct {
	_ struct{} `type:"structure"`

	// The number of Edge Manager agents.
	//
	// AgentCount is a required field
	AgentCount *int64 `type:"long" required:"true"`

	// Version of the agent.
	//
	// Version is a required field
	Version *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AgentVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentVersion) GoString() string {
	return s.String()
}

// SetAgentCount sets the AgentCount field's value.
func (s *AgentVersion) SetAgentCount(v int64) *AgentVersion {
	s.AgentCount = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AgentVersion) SetVersion(v string) *AgentVersion {
	s.Version = &v
	return s
}

// This API is not supported.
type Alarm struct {
	_ struct{} `type:"structure"`

	AlarmName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alarm) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Alarm) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Alarm"}
	if s.AlarmName != nil && len(*s.AlarmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlarmName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmName sets the AlarmName field's value.
func (s *Alarm) SetAlarmName(v string) *Alarm {
	s.AlarmName = &v
	return s
}

// Specifies the training algorithm to use in a CreateTrainingJob request.
//
// For more information about algorithms provided by Amazon SageMaker, see Algorithms
// (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). For information
// about using your own algorithms, see Using Your Own Algorithms with Amazon
// SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
type AlgorithmSpecification struct {
	_ struct{} `type:"structure"`

	// The name of the algorithm resource to use for the training job. This must
	// be an algorithm resource that you created or subscribe to on AWS Marketplace.
	// If you specify a value for this parameter, you can't specify a value for
	// TrainingImage.
	AlgorithmName *string `min:"1" type:"string"`

	// To generate and save time-series metrics during training, set to true. The
	// default is false and time-series metrics aren't generated except in the following
	// cases:
	//
	//    * You use one of the Amazon SageMaker built-in algorithms
	//
	//    * You use one of the following Prebuilt Amazon SageMaker Docker Images
	//    (https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html):
	//    Tensorflow (version >= 1.15) MXNet (version >= 1.6) PyTorch (version >=
	//    1.3)
	//
	//    * You specify at least one MetricDefinition
	EnableSageMakerMetricsTimeSeries *bool `type:"boolean"`

	// A list of metric definition objects. Each object specifies the metric name
	// and regular expressions used to parse algorithm logs. Amazon SageMaker publishes
	// each metric to Amazon CloudWatch.
	MetricDefinitions []*MetricDefinition `type:"list"`

	// The registry path of the Docker image that contains the training algorithm.
	// For information about docker registry paths for built-in algorithms, see
	// Algorithms Provided by Amazon SageMaker: Common Parameters (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html).
	// Amazon SageMaker supports both registry/repository[:tag] and registry/repository[@digest]
	// image path formats. For more information, see Using Your Own Algorithms with
	// Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	TrainingImage *string `type:"string"`

	// The input mode that the algorithm supports. For the input modes that Amazon
	// SageMaker algorithms support, see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	// If an algorithm supports the File input mode, Amazon SageMaker downloads
	// the training data from S3 to the provisioned ML storage Volume, and mounts
	// the directory to docker volume for training container. If an algorithm supports
	// the Pipe input mode, Amazon SageMaker streams data directly from S3 to the
	// container.
	//
	// In File mode, make sure you provision ML storage volume with sufficient capacity
	// to accommodate the data download from S3. In addition to the training data,
	// the ML storage volume also stores the output model. The algorithm container
	// use ML storage volume to also store intermediate information, if any.
	//
	// For distributed algorithms using File mode, training data is distributed
	// uniformly, and your training duration is predictable if the input data objects
	// size is approximately same. Amazon SageMaker does not split the files any
	// further for model training. If the object sizes are skewed, training won't
	// be optimal as the data distribution is also skewed where one host in a training
	// cluster is overloaded, thus becoming bottleneck in training.
	//
	// TrainingInputMode is a required field
	TrainingInputMode *string `type:"string" required:"true" enum:"TrainingInputMode"`
}

// String returns the string representation
func (s AlgorithmSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlgorithmSpecification"}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AlgorithmName", 1))
	}
	if s.TrainingInputMode == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingInputMode"))
	}
	if s.MetricDefinitions != nil {
		for i, v := range s.MetricDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MetricDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithmName sets the AlgorithmName field's value.
func (s *AlgorithmSpecification) SetAlgorithmName(v string) *AlgorithmSpecification {
	s.AlgorithmName = &v
	return s
}

// SetEnableSageMakerMetricsTimeSeries sets the EnableSageMakerMetricsTimeSeries field's value.
func (s *AlgorithmSpecification) SetEnableSageMakerMetricsTimeSeries(v bool) *AlgorithmSpecification {
	s.EnableSageMakerMetricsTimeSeries = &v
	return s
}

// SetMetricDefinitions sets the MetricDefinitions field's value.
func (s *AlgorithmSpecification) SetMetricDefinitions(v []*MetricDefinition) *AlgorithmSpecification {
	s.MetricDefinitions = v
	return s
}

// SetTrainingImage sets the TrainingImage field's value.
func (s *AlgorithmSpecification) SetTrainingImage(v string) *AlgorithmSpecification {
	s.TrainingImage = &v
	return s
}

// SetTrainingInputMode sets the TrainingInputMode field's value.
func (s *AlgorithmSpecification) SetTrainingInputMode(v string) *AlgorithmSpecification {
	s.TrainingInputMode = &v
	return s
}

// Specifies the validation and image scan statuses of the algorithm.
type AlgorithmStatusDetails struct {
	_ struct{} `type:"structure"`

	// The status of the scan of the algorithm's Docker image container.
	ImageScanStatuses []*AlgorithmStatusItem `type:"list"`

	// The status of algorithm validation.
	ValidationStatuses []*AlgorithmStatusItem `type:"list"`
}

// String returns the string representation
func (s AlgorithmStatusDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmStatusDetails) GoString() string {
	return s.String()
}

// SetImageScanStatuses sets the ImageScanStatuses field's value.
func (s *AlgorithmStatusDetails) SetImageScanStatuses(v []*AlgorithmStatusItem) *AlgorithmStatusDetails {
	s.ImageScanStatuses = v
	return s
}

// SetValidationStatuses sets the ValidationStatuses field's value.
func (s *AlgorithmStatusDetails) SetValidationStatuses(v []*AlgorithmStatusItem) *AlgorithmStatusDetails {
	s.ValidationStatuses = v
	return s
}

// Represents the overall status of an algorithm.
type AlgorithmStatusItem struct {
	_ struct{} `type:"structure"`

	// if the overall status is Failed, the reason for the failure.
	FailureReason *string `type:"string"`

	// The name of the algorithm for which the overall status is being reported.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The current status.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"DetailedAlgorithmStatus"`
}

// String returns the string representation
func (s AlgorithmStatusItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmStatusItem) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *AlgorithmStatusItem) SetFailureReason(v string) *AlgorithmStatusItem {
	s.FailureReason = &v
	return s
}

// SetName sets the Name field's value.
func (s *AlgorithmStatusItem) SetName(v string) *AlgorithmStatusItem {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AlgorithmStatusItem) SetStatus(v string) *AlgorithmStatusItem {
	s.Status = &v
	return s
}

// Provides summary information about an algorithm.
type AlgorithmSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm.
	//
	// AlgorithmArn is a required field
	AlgorithmArn *string `min:"1" type:"string" required:"true"`

	// A brief description of the algorithm.
	AlgorithmDescription *string `type:"string"`

	// The name of the algorithm that is described by the summary.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`

	// The overall status of the algorithm.
	//
	// AlgorithmStatus is a required field
	AlgorithmStatus *string `type:"string" required:"true" enum:"AlgorithmStatus"`

	// A timestamp that shows when the algorithm was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s AlgorithmSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmSummary) GoString() string {
	return s.String()
}

// SetAlgorithmArn sets the AlgorithmArn field's value.
func (s *AlgorithmSummary) SetAlgorithmArn(v string) *AlgorithmSummary {
	s.AlgorithmArn = &v
	return s
}

// SetAlgorithmDescription sets the AlgorithmDescription field's value.
func (s *AlgorithmSummary) SetAlgorithmDescription(v string) *AlgorithmSummary {
	s.AlgorithmDescription = &v
	return s
}

// SetAlgorithmName sets the AlgorithmName field's value.
func (s *AlgorithmSummary) SetAlgorithmName(v string) *AlgorithmSummary {
	s.AlgorithmName = &v
	return s
}

// SetAlgorithmStatus sets the AlgorithmStatus field's value.
func (s *AlgorithmSummary) SetAlgorithmStatus(v string) *AlgorithmSummary {
	s.AlgorithmStatus = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AlgorithmSummary) SetCreationTime(v time.Time) *AlgorithmSummary {
	s.CreationTime = &v
	return s
}

// Defines a training job and a batch transform job that Amazon SageMaker runs
// to validate your algorithm.
//
// The data provided in the validation profile is made available to your buyers
// on AWS Marketplace.
type AlgorithmValidationProfile struct {
	_ struct{} `type:"structure"`

	// The name of the profile for the algorithm. The name must have 1 to 63 characters.
	// Valid characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// ProfileName is a required field
	ProfileName *string `min:"1" type:"string" required:"true"`

	// The TrainingJobDefinition object that describes the training job that Amazon
	// SageMaker runs to validate your algorithm.
	//
	// TrainingJobDefinition is a required field
	TrainingJobDefinition *TrainingJobDefinition `type:"structure" required:"true"`

	// The TransformJobDefinition object that describes the transform job that Amazon
	// SageMaker runs to validate your algorithm.
	TransformJobDefinition *TransformJobDefinition `type:"structure"`
}

// String returns the string representation
func (s AlgorithmValidationProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmValidationProfile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmValidationProfile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlgorithmValidationProfile"}
	if s.ProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileName"))
	}
	if s.ProfileName != nil && len(*s.ProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileName", 1))
	}
	if s.TrainingJobDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingJobDefinition"))
	}
	if s.TrainingJobDefinition != nil {
		if err := s.TrainingJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("TrainingJobDefinition", err.(request.ErrInvalidParams))
		}
	}
	if s.TransformJobDefinition != nil {
		if err := s.TransformJobDefinition.Validate(); err != nil {
			invalidParams.AddNested("TransformJobDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileName sets the ProfileName field's value.
func (s *AlgorithmValidationProfile) SetProfileName(v string) *AlgorithmValidationProfile {
	s.ProfileName = &v
	return s
}

// SetTrainingJobDefinition sets the TrainingJobDefinition field's value.
func (s *AlgorithmValidationProfile) SetTrainingJobDefinition(v *TrainingJobDefinition) *AlgorithmValidationProfile {
	s.TrainingJobDefinition = v
	return s
}

// SetTransformJobDefinition sets the TransformJobDefinition field's value.
func (s *AlgorithmValidationProfile) SetTransformJobDefinition(v *TransformJobDefinition) *AlgorithmValidationProfile {
	s.TransformJobDefinition = v
	return s
}

// Specifies configurations for one or more training jobs that Amazon SageMaker
// runs to test the algorithm.
type AlgorithmValidationSpecification struct {
	_ struct{} `type:"structure"`

	// An array of AlgorithmValidationProfile objects, each of which specifies a
	// training job and batch transform job that Amazon SageMaker runs to validate
	// your algorithm.
	//
	// ValidationProfiles is a required field
	ValidationProfiles []*AlgorithmValidationProfile `min:"1" type:"list" required:"true"`

	// The IAM roles that Amazon SageMaker uses to run the training jobs.
	//
	// ValidationRole is a required field
	ValidationRole *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AlgorithmValidationSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlgorithmValidationSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlgorithmValidationSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AlgorithmValidationSpecification"}
	if s.ValidationProfiles == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationProfiles"))
	}
	if s.ValidationProfiles != nil && len(s.ValidationProfiles) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationProfiles", 1))
	}
	if s.ValidationRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationRole"))
	}
	if s.ValidationRole != nil && len(*s.ValidationRole) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationRole", 20))
	}
	if s.ValidationProfiles != nil {
		for i, v := range s.ValidationProfiles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ValidationProfiles", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValidationProfiles sets the ValidationProfiles field's value.
func (s *AlgorithmValidationSpecification) SetValidationProfiles(v []*AlgorithmValidationProfile) *AlgorithmValidationSpecification {
	s.ValidationProfiles = v
	return s
}

// SetValidationRole sets the ValidationRole field's value.
func (s *AlgorithmValidationSpecification) SetValidationRole(v string) *AlgorithmValidationSpecification {
	s.ValidationRole = &v
	return s
}

// Configures how labels are consolidated across human workers and processes
// output data.
type AnnotationConsolidationConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a Lambda function implements the logic
	// for annotation consolidation (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html)
	// and to process output data.
	//
	// This parameter is required for all labeling jobs. For built-in task types
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html), use
	// one of the following Amazon SageMaker Ground Truth Lambda function ARNs for
	// AnnotationConsolidationLambdaArn. For custom labeling workflows, see Post-annotation
	// Lambda (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-postlambda).
	//
	// Bounding box - Finds the most similar boxes from different workers based
	// on the Jaccard index of the boxes.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-BoundingBox
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-BoundingBox
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-BoundingBox
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-BoundingBox
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-BoundingBox
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-BoundingBox
	//
	// Image classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true class of an image based on annotations from individual
	// workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClass
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClass
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClass
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClass
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClass
	//
	// Multi-label image classification - Uses a variant of the Expectation Maximization
	// approach to estimate the true classes of an image based on annotations from
	// individual workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClassMultiLabel
	//
	// Semantic segmentation - Treats each pixel in an image as a multi-class classification
	// and treats pixel annotations from workers as "votes" for the correct label.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-SemanticSegmentation
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-SemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-SemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-SemanticSegmentation
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-SemanticSegmentation
	//
	// Text classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true class of text based on annotations from individual workers.
	//
	//    * rn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClass
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClass
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClass
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClass
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClass
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClass
	//
	// Multi-label text classification - Uses a variant of the Expectation Maximization
	// approach to estimate the true classes of text based on annotations from individual
	// workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClassMultiLabel
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClassMultiLabel
	//
	// Named entity recognition - Groups similar selections and calculates aggregate
	// boundaries, resolving to most-assigned label.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition
	//
	// Video Classification - Use this task type when you need workers to classify
	// videos using predefined labels that you specify. Workers are shown videos
	// and are asked to choose one label for each video.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoMultiClass
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoMultiClass
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoMultiClass
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoMultiClass
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoMultiClass
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoMultiClass
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoMultiClass
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoMultiClass
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoMultiClass
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoMultiClass
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoMultiClass
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoMultiClass
	//
	// Video Frame Object Detection - Use this task type to have workers identify
	// and locate objects in a sequence of video frames (images extracted from a
	// video) using bounding boxes. For example, you can use this task to ask workers
	// to identify and localize various objects in a series of video frames, such
	// as cars, bikes, and pedestrians.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectDetection
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectDetection
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectDetection
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectDetection
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectDetection
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectDetection
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectDetection
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectDetection
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectDetection
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectDetection
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectDetection
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectDetection
	//
	// Video Frame Object Tracking - Use this task type to have workers track the
	// movement of objects in a sequence of video frames (images extracted from
	// a video) using bounding boxes. For example, you can use this task to ask
	// workers to track the movement of objects, such as cars, bikes, and pedestrians.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectTracking
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectTracking
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectTracking
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectTracking
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectTracking
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectTracking
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectTracking
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectTracking
	//
	// 3D Point Cloud Object Detection - Use this task type when you want workers
	// to classify objects in a 3D point cloud by drawing 3D cuboids around objects.
	// For example, you can use this task type to ask workers to identify different
	// types of objects in a point cloud, such as cars, bikes, and pedestrians.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectDetection
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectDetection
	//
	// 3D Point Cloud Object Tracking - Use this task type when you want workers
	// to draw 3D cuboids around objects that appear in a sequence of 3D point cloud
	// frames. For example, you can use this task type to ask workers to track the
	// movement of vehicles across multiple point cloud frames.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectTracking
	//
	// 3D Point Cloud Semantic Segmentation - Use this task type when you want workers
	// to create a point-level semantic segmentation masks by painting objects in
	// a 3D point cloud using different colors where each color is assigned to one
	// of the classes you specify.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudSemanticSegmentation
	//
	// Use the following ARNs for Label Verification and Adjustment Jobs
	//
	// Use label verification and adjustment jobs to review and adjust labels. To
	// learn more, see Verify and Adjust Labels (https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html).
	//
	// Semantic Segmentation Adjustment - Treats each pixel in an image as a multi-class
	// classification and treats pixel adjusted annotations from workers as "votes"
	// for the correct label.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentSemanticSegmentation
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentSemanticSegmentation
	//
	// Semantic Segmentation Verification - Uses a variant of the Expectation Maximization
	// approach to estimate the true class of verification judgment for semantic
	// segmentation labels based on annotations from individual workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationSemanticSegmentation
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationSemanticSegmentation
	//
	// Bounding Box Adjustment - Finds the most similar boxes from different workers
	// based on the Jaccard index of the adjusted annotations.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentBoundingBox
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentBoundingBox
	//
	// Bounding Box Verification - Uses a variant of the Expectation Maximization
	// approach to estimate the true class of verification judgement for bounding
	// box labels based on annotations from individual workers.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationBoundingBox
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationBoundingBox
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationBoundingBox
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationBoundingBox
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationBoundingBox
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationBoundingBox
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationBoundingBox
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationBoundingBox
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationBoundingBox
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationBoundingBox
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationBoundingBox
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationBoundingBox
	//
	// Video Frame Object Detection Adjustment - Use this task type when you want
	// workers to adjust bounding boxes that workers have added to video frames
	// to classify and localize objects in a sequence of video frames.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectDetection
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectDetection
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectDetection
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectDetection
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectDetection
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectDetection
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectDetection
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectDetection
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectDetection
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectDetection
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectDetection
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectDetection
	//
	// Video Frame Object Tracking Adjustment - Use this task type when you want
	// workers to adjust bounding boxes that workers have added to video frames
	// to track object movement across a sequence of video frames.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectTracking
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectTracking
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectTracking
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectTracking
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectTracking
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectTracking
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectTracking
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectTracking
	//
	// 3D Point Cloud Object Detection Adjustment - Use this task type when you
	// want workers to adjust 3D cuboids around objects in a 3D point cloud.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectDetection
	//    arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// 3D Point Cloud Object Tracking Adjustment - Use this task type when you want
	// workers to adjust 3D cuboids around objects that appear in a sequence of
	// 3D point cloud frames.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// 3D Point Cloud Semantic Segmentation Adjustment - Use this task type when
	// you want workers to adjust a point-level semantic segmentation masks using
	// a paint tool.
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//    * arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// AnnotationConsolidationLambdaArn is a required field
	AnnotationConsolidationLambdaArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AnnotationConsolidationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnnotationConsolidationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnnotationConsolidationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnnotationConsolidationConfig"}
	if s.AnnotationConsolidationLambdaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AnnotationConsolidationLambdaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotationConsolidationLambdaArn sets the AnnotationConsolidationLambdaArn field's value.
func (s *AnnotationConsolidationConfig) SetAnnotationConsolidationLambdaArn(v string) *AnnotationConsolidationConfig {
	s.AnnotationConsolidationLambdaArn = &v
	return s
}

// Details about an Amazon SageMaker app.
type AppDetails struct {
	_ struct{} `type:"structure"`

	// The name of the app.
	AppName *string `type:"string"`

	// The type of app.
	AppType *string `type:"string" enum:"AppType"`

	// The creation time.
	CreationTime *time.Time `type:"timestamp"`

	// The domain ID.
	DomainId *string `type:"string"`

	// The status.
	Status *string `type:"string" enum:"AppStatus"`

	// The user profile name.
	UserProfileName *string `type:"string"`
}

// String returns the string representation
func (s AppDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppDetails) GoString() string {
	return s.String()
}

// SetAppName sets the AppName field's value.
func (s *AppDetails) SetAppName(v string) *AppDetails {
	s.AppName = &v
	return s
}

// SetAppType sets the AppType field's value.
func (s *AppDetails) SetAppType(v string) *AppDetails {
	s.AppType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AppDetails) SetCreationTime(v time.Time) *AppDetails {
	s.CreationTime = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *AppDetails) SetDomainId(v string) *AppDetails {
	s.DomainId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AppDetails) SetStatus(v string) *AppDetails {
	s.Status = &v
	return s
}

// SetUserProfileName sets the UserProfileName field's value.
func (s *AppDetails) SetUserProfileName(v string) *AppDetails {
	s.UserProfileName = &v
	return s
}

// The configuration for running a SageMaker image as a KernelGateway app.
type AppImageConfigDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AppImageConfig.
	AppImageConfigArn *string `type:"string"`

	// The name of the AppImageConfig. Must be unique to your account.
	AppImageConfigName *string `type:"string"`

	// When the AppImageConfig was created.
	CreationTime *time.Time `type:"timestamp"`

	// The configuration for the file system and kernels in the SageMaker image.
	KernelGatewayImageConfig *KernelGatewayImageConfig `type:"structure"`

	// When the AppImageConfig was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s AppImageConfigDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppImageConfigDetails) GoString() string {
	return s.String()
}

// SetAppImageConfigArn sets the AppImageConfigArn field's value.
func (s *AppImageConfigDetails) SetAppImageConfigArn(v string) *AppImageConfigDetails {
	s.AppImageConfigArn = &v
	return s
}

// SetAppImageConfigName sets the AppImageConfigName field's value.
func (s *AppImageConfigDetails) SetAppImageConfigName(v string) *AppImageConfigDetails {
	s.AppImageConfigName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AppImageConfigDetails) SetCreationTime(v time.Time) *AppImageConfigDetails {
	s.CreationTime = &v
	return s
}

// SetKernelGatewayImageConfig sets the KernelGatewayImageConfig field's value.
func (s *AppImageConfigDetails) SetKernelGatewayImageConfig(v *KernelGatewayImageConfig) *AppImageConfigDetails {
	s.KernelGatewayImageConfig = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *AppImageConfigDetails) SetLastModifiedTime(v time.Time) *AppImageConfigDetails {
	s.LastModifiedTime = &v
	return s
}

// Configuration to run a processing job in a specified container image.
type AppSpecification struct {
	_ struct{} `type:"structure"`

	// The arguments for a container used to run a processing job.
	ContainerArguments []*string `min:"1" type:"list"`

	// The entrypoint for a container used to run a processing job.
	ContainerEntrypoint []*string `min:"1" type:"list"`

	// The container image to be run by the processing job.
	//
	// ImageUri is a required field
	ImageUri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AppSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppSpecification"}
	if s.ContainerArguments != nil && len(s.ContainerArguments) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerArguments", 1))
	}
	if s.ContainerEntrypoint != nil && len(s.ContainerEntrypoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainerEntrypoint", 1))
	}
	if s.ImageUri == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerArguments sets the ContainerArguments field's value.
func (s *AppSpecification) SetContainerArguments(v []*string) *AppSpecification {
	s.ContainerArguments = v
	return s
}

// SetContainerEntrypoint sets the ContainerEntrypoint field's value.
func (s *AppSpecification) SetContainerEntrypoint(v []*string) *AppSpecification {
	s.ContainerEntrypoint = v
	return s
}

// SetImageUri sets the ImageUri field's value.
func (s *AppSpecification) SetImageUri(v string) *AppSpecification {
	s.ImageUri = &v
	return s
}

// A structure describing the source of an artifact.
type ArtifactSource struct {
	_ struct{} `type:"structure"`

	// A list of source types.
	SourceTypes []*ArtifactSourceType `type:"list"`

	// The URI of the source.
	//
	// SourceUri is a required field
	SourceUri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ArtifactSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArtifactSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArtifactSource"}
	if s.SourceUri == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceUri"))
	}
	if s.SourceTypes != nil {
		for i, v := range s.SourceTypes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SourceTypes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceTypes sets the SourceTypes field's value.
func (s *ArtifactSource) SetSourceTypes(v []*ArtifactSourceType) *ArtifactSource {
	s.SourceTypes = v
	return s
}

// SetSourceUri sets the SourceUri field's value.
func (s *ArtifactSource) SetSourceUri(v string) *ArtifactSource {
	s.SourceUri = &v
	return s
}

// The ID and ID type of an artifact source.
type ArtifactSourceType struct {
	_ struct{} `type:"structure"`

	// The type of ID.
	//
	// SourceIdType is a required field
	SourceIdType *string `type:"string" required:"true" enum:"ArtifactSourceIdType"`

	// The ID.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ArtifactSourceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArtifactSourceType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactSourceType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArtifactSourceType"}
	if s.SourceIdType == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceIdType"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceIdType sets the SourceIdType field's value.
func (s *ArtifactSourceType) SetSourceIdType(v string) *ArtifactSourceType {
	s.SourceIdType = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ArtifactSourceType) SetValue(v string) *ArtifactSourceType {
	s.Value = &v
	return s
}

// Lists a summary of the properties of an artifact. An artifact represents
// a URI addressable object or data. Some examples are a dataset and a model.
type ArtifactSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the artifact.
	ArtifactArn *string `type:"string"`

	// The name of the artifact.
	ArtifactName *string `min:"1" type:"string"`

	// The type of the artifact.
	ArtifactType *string `type:"string"`

	// When the artifact was created.
	CreationTime *time.Time `type:"timestamp"`

	// When the artifact was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The source of the artifact.
	Source *ArtifactSource `type:"structure"`
}

// String returns the string representation
func (s ArtifactSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArtifactSummary) GoString() string {
	return s.String()
}

// SetArtifactArn sets the ArtifactArn field's value.
func (s *ArtifactSummary) SetArtifactArn(v string) *ArtifactSummary {
	s.ArtifactArn = &v
	return s
}

// SetArtifactName sets the ArtifactName field's value.
func (s *ArtifactSummary) SetArtifactName(v string) *ArtifactSummary {
	s.ArtifactName = &v
	return s
}

// SetArtifactType sets the ArtifactType field's value.
func (s *ArtifactSummary) SetArtifactType(v string) *ArtifactSummary {
	s.ArtifactType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ArtifactSummary) SetCreationTime(v time.Time) *ArtifactSummary {
	s.CreationTime = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *ArtifactSummary) SetLastModifiedTime(v time.Time) *ArtifactSummary {
	s.LastModifiedTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ArtifactSummary) SetSource(v *ArtifactSource) *ArtifactSummary {
	s.Source = v
	return s
}

type AssociateTrialComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component to associated with the trial.
	//
	// TrialComponentName is a required field
	TrialComponentName *string `min:"1" type:"string" required:"true"`

	// The name of the trial to associate with.
	//
	// TrialName is a required field
	TrialName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateTrialComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTrialComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateTrialComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateTrialComponentInput"}
	if s.TrialComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialComponentName"))
	}
	if s.TrialComponentName != nil && len(*s.TrialComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialComponentName", 1))
	}
	if s.TrialName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrialName"))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrialName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrialComponentName sets the TrialComponentName field's value.
func (s *AssociateTrialComponentInput) SetTrialComponentName(v string) *AssociateTrialComponentInput {
	s.TrialComponentName = &v
	return s
}

// SetTrialName sets the TrialName field's value.
func (s *AssociateTrialComponentInput) SetTrialName(v string) *AssociateTrialComponentInput {
	s.TrialName = &v
	return s
}

type AssociateTrialComponentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string `type:"string"`

	// The ARN of the trial component.
	TrialComponentArn *string `type:"string"`
}

// String returns the string representation
func (s AssociateTrialComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTrialComponentOutput) GoString() string {
	return s.String()
}

// SetTrialArn sets the TrialArn field's value.
func (s *AssociateTrialComponentOutput) SetTrialArn(v string) *AssociateTrialComponentOutput {
	s.TrialArn = &v
	return s
}

// SetTrialComponentArn sets the TrialComponentArn field's value.
func (s *AssociateTrialComponentOutput) SetTrialComponentArn(v string) *AssociateTrialComponentOutput {
	s.TrialComponentArn = &v
	return s
}

// Lists a summary of the properties of an association. An association is an
// entity that links other lineage or experiment entities. An example would
// be an association between a training job and a model.
type AssociationSummary struct {
	_ struct{} `type:"structure"`

	// The type of the association.
	AssociationType *string `type:"string" enum:"AssociationEdgeType"`

	// Information about the user who created or modified an experiment, trial,
	// or trial component.
	CreatedBy *UserContext `type:"structure"`

	// When the association was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the destination.
	DestinationArn *string `type:"string"`

	// The name of the destination.
	DestinationName *string `min:"1" type:"string"`

	// The destination type.
	DestinationType *string `type:"string"`

	// The ARN of the source.
	SourceArn *string `type:"string"`

	// The name of the source.
	SourceName *string `min:"1" type:"string"`

	// The source type.
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s AssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationSummary) GoString() string {
	return s.String()
}

// SetAssociationType sets the AssociationType field's value.
func (s *AssociationSummary) SetAssociationType(v string) *AssociationSummary {
	s.AssociationType = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *AssociationSummary) SetCreatedBy(v *UserContext) *AssociationSummary {
	s.CreatedBy = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AssociationSummary) SetCreationTime(v time.Time) *AssociationSummary {
	s.CreationTime = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *AssociationSummary) SetDestinationArn(v string) *AssociationSummary {
	s.DestinationArn = &v
	return s
}

// SetDestinationName sets the DestinationName field's value.
func (s *AssociationSummary) SetDestinationName(v string) *AssociationSummary {
	s.DestinationName = &v
	return s
}

// SetDestinationType sets the DestinationType field's value.
func (s *AssociationSummary) SetDestinationType(v string) *AssociationSummary {
	s.DestinationType = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *AssociationSummary) SetSourceArn(v string) *AssociationSummary {
	s.SourceArn = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *AssociationSummary) SetSourceName(v string) *AssociationSummary {
	s.SourceName = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *AssociationSummary) SetSourceType(v string) *AssociationSummary {
	s.SourceType = &v
	return s
}

// Configuration for Athena Dataset Definition input.
type AthenaDatasetDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog used in Athena query execution.
	//
	// Catalog is a required field
	Catalog *string `min:"1" type:"string" required:"true"`

	// The name of the database used in the Athena query execution.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true"`

	// The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to
	// encrypt data generated from an Athena query execution.
	KmsKeyId *string `type:"string"`

	// The compression used for Athena query results.
	OutputCompression *string `type:"string" enum:"AthenaResultCompressionType"`

	// The data storage format for Athena query results.
	//
	// OutputFormat is a required field
	OutputFormat *string `type:"string" required:"true" enum:"AthenaResultFormat"`

	// The location in Amazon S3 where Athena query results are stored.
	//
	// OutputS3Uri is a required field
	OutputS3Uri *string `type:"string" required:"true"`

	// The SQL query statements, to be executed.
	//
	// QueryString is a required field
	QueryString *string `min:"1" type:"string" required:"true"`

	// The name of the workgroup in which the Athena query is being started.
	WorkGroup *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AthenaDatasetDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AthenaDatasetDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AthenaDatasetDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AthenaDatasetDefinition"}
	if s.Catalog == nil {
		invalidParams.Add(request.NewErrParamRequired("Catalog"))
	}
	if s.Catalog != nil && len(*s.Catalog) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Catalog", 1))
	}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.OutputFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputFormat"))
	}
	if s.OutputS3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputS3Uri"))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.QueryString != nil && len(*s.QueryString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueryString", 1))
	}
	if s.WorkGroup != nil && len(*s.WorkGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalog sets the Catalog field's value.
func (s *AthenaDatasetDefinition) SetCatalog(v string) *AthenaDatasetDefinition {
	s.Catalog = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *AthenaDatasetDefinition) SetDatabase(v string) *AthenaDatasetDefinition {
	s.Database = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AthenaDatasetDefinition) SetKmsKeyId(v string) *AthenaDatasetDefinition {
	s.KmsKeyId = &v
	return s
}

// SetOutputCompression sets the OutputCompression field's value.
func (s *AthenaDatasetDefinition) SetOutputCompression(v string) *AthenaDatasetDefinition {
	s.OutputCompression = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *AthenaDatasetDefinition) SetOutputFormat(v string) *AthenaDatasetDefinition {
	s.OutputFormat = &v
	return s
}

// SetOutputS3Uri sets the OutputS3Uri field's value.
func (s *AthenaDatasetDefinition) SetOutputS3Uri(v string) *AthenaDatasetDefinition {
	s.OutputS3Uri = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *AthenaDatasetDefinition) SetQueryString(v string) *AthenaDatasetDefinition {
	s.QueryString = &v
	return s
}

// SetWorkGroup sets the WorkGroup field's value.
func (s *AthenaDatasetDefinition) SetWorkGroup(v string) *AthenaDatasetDefinition {
	s.WorkGroup = &v
	return s
}

// An Autopilot job returns recommendations, or candidates. Each candidate has
// futher details about the steps involed, and the status.
type AutoMLCandidate struct {
	_ struct{} `type:"structure"`

	// The candidate name.
	//
	// CandidateName is a required field
	CandidateName *string `min:"1" type:"string" required:"true"`

	// The candidate's status.
	//
	// CandidateStatus is a required field
	CandidateStatus *string `type:"string" required:"true" enum:"CandidateStatus"`

	// The candidate's steps.
	//
	// CandidateSteps is a required field
	CandidateSteps []*AutoMLCandidateStep `type:"list" required:"true"`

	// The creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The end time.
	EndTime *time.Time `type:"timestamp"`

	// The failure reason.
	FailureReason *string `type:"string"`

	// The best candidate result from an AutoML training job.
	FinalAutoMLJobObjectiveMetric *FinalAutoMLJobObjectiveMetric `type:"structure"`

	// The inference containers.
	InferenceContainers []*AutoMLContainerDefinition `type:"list"`

	// The last modified time.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// The objective status.
	//
	// ObjectiveStatus is a required field
	ObjectiveStatus *string `type:"string" required:"true" enum:"ObjectiveStatus"`
}

// String returns the string representation
func (s AutoMLCandidate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLCandidate) GoString() string {
	return s.String()
}

// SetCandidateName sets the CandidateName field's value.
func (s *AutoMLCandidate) SetCandidateName(v string) *AutoMLCandidate {
	s.CandidateName = &v
	return s
}

// SetCandidateStatus sets the CandidateStatus field's value.
func (s *AutoMLCandidate) SetCandidateStatus(v string) *AutoMLCandidate {
	s.CandidateStatus = &v
	return s
}

// SetCandidateSteps sets the CandidateSteps field's value.
func (s *AutoMLCandidate) SetCandidateSteps(v []*AutoMLCandidateStep) *AutoMLCandidate {
	s.CandidateSteps = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AutoMLCandidate) SetCreationTime(v time.Time) *AutoMLCandidate {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AutoMLCandidate) SetEndTime(v time.Time) *AutoMLCandidate {
	s.EndTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *AutoMLCandidate) SetFailureReason(v string) *AutoMLCandidate {
	s.FailureReason = &v
	return s
}

// SetFinalAutoMLJobObjectiveMetric sets the FinalAutoMLJobObjectiveMetric field's value.
func (s *AutoMLCandidate) SetFinalAutoMLJobObjectiveMetric(v *FinalAutoMLJobObjectiveMetric) *AutoMLCandidate {
	s.FinalAutoMLJobObjectiveMetric = v
	return s
}

// SetInferenceContainers sets the InferenceContainers field's value.
func (s *AutoMLCandidate) SetInferenceContainers(v []*AutoMLContainerDefinition) *AutoMLCandidate {
	s.InferenceContainers = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *AutoMLCandidate) SetLastModifiedTime(v time.Time) *AutoMLCandidate {
	s.LastModifiedTime = &v
	return s
}

// SetObjectiveStatus sets the ObjectiveStatus field's value.
func (s *AutoMLCandidate) SetObjectiveStatus(v string) *AutoMLCandidate {
	s.ObjectiveStatus = &v
	return s
}

// Information about the steps for a Candidate, and what step it is working
// on.
type AutoMLCandidateStep struct {
	_ struct{} `type:"structure"`

	// The ARN for the Candidate's step.
	//
	// CandidateStepArn is a required field
	CandidateStepArn *string `min:"1" type:"string" required:"true"`

	// The name for the Candidate's step.
	//
	// CandidateStepName is a required field
	CandidateStepName *string `min:"1" type:"string" required:"true"`

	// Whether the Candidate is at the transform, training, or processing step.
	//
	// CandidateStepType is a required field
	CandidateStepType *string `type:"string" required:"true" enum:"CandidateStepType"`
}

// String returns the string representation
func (s AutoMLCandidateStep) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLCandidateStep) GoString() string {
	return s.String()
}

// SetCandidateStepArn sets the CandidateStepArn field's value.
func (s *AutoMLCandidateStep) SetCandidateStepArn(v string) *AutoMLCandidateStep {
	s.CandidateStepArn = &v
	return s
}

// SetCandidateStepName sets the CandidateStepName field's value.
func (s *AutoMLCandidateStep) SetCandidateStepName(v string) *AutoMLCandidateStep {
	s.CandidateStepName = &v
	return s
}

// SetCandidateStepType sets the CandidateStepType field's value.
func (s *AutoMLCandidateStep) SetCandidateStepType(v string) *AutoMLCandidateStep {
	s.CandidateStepType = &v
	return s
}

// Similar to Channel. A channel is a named input source that training algorithms
// can consume. Refer to Channel for detailed descriptions.
type AutoMLChannel struct {
	_ struct{} `type:"structure"`

	// You can use Gzip or None. The default value is None.
	CompressionType *string `type:"string" enum:"CompressionType"`

	// The data source.
	//
	// DataSource is a required field
	DataSource *AutoMLDataSource `type:"structure" required:"true"`

	// The name of the target variable in supervised learning, a.k.a. 'y'.
	//
	// TargetAttributeName is a required field
	TargetAttributeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLChannel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLChannel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLChannel"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.TargetAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetAttributeName"))
	}
	if s.TargetAttributeName != nil && len(*s.TargetAttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetAttributeName", 1))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompressionType sets the CompressionType field's value.
func (s *AutoMLChannel) SetCompressionType(v string) *AutoMLChannel {
	s.CompressionType = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *AutoMLChannel) SetDataSource(v *AutoMLDataSource) *AutoMLChannel {
	s.DataSource = v
	return s
}

// SetTargetAttributeName sets the TargetAttributeName field's value.
func (s *AutoMLChannel) SetTargetAttributeName(v string) *AutoMLChannel {
	s.TargetAttributeName = &v
	return s
}

// A list of container definitions that describe the different containers that
// make up one AutoML candidate. Refer to ContainerDefinition for more details.
type AutoMLContainerDefinition struct {
	_ struct{} `type:"structure"`

	// Environment variables to set in the container. Refer to ContainerDefinition
	// for more details.
	Environment map[string]*string `type:"map"`

	// The ECR path of the container. Refer to ContainerDefinition for more details.
	//
	// Image is a required field
	Image *string `type:"string" required:"true"`

	// The location of the model artifacts. Refer to ContainerDefinition for more
	// details.
	//
	// ModelDataUrl is a required field
	ModelDataUrl *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLContainerDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLContainerDefinition) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *AutoMLContainerDefinition) SetEnvironment(v map[string]*string) *AutoMLContainerDefinition {
	s.Environment = v
	return s
}

// SetImage sets the Image field's value.
func (s *AutoMLContainerDefinition) SetImage(v string) *AutoMLContainerDefinition {
	s.Image = &v
	return s
}

// SetModelDataUrl sets the ModelDataUrl field's value.
func (s *AutoMLContainerDefinition) SetModelDataUrl(v string) *AutoMLContainerDefinition {
	s.ModelDataUrl = &v
	return s
}

// The data source for the Autopilot job.
type AutoMLDataSource struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of the input data.
	//
	// The input data must be in CSV format and contain at least 500 rows.
	//
	// S3DataSource is a required field
	S3DataSource *AutoMLS3DataSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s AutoMLDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLDataSource"}
	if s.S3DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DataSource"))
	}
	if s.S3DataSource != nil {
		if err := s.S3DataSource.Validate(); err != nil {
			invalidParams.AddNested("S3DataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3DataSource sets the S3DataSource field's value.
func (s *AutoMLDataSource) SetS3DataSource(v *AutoMLS3DataSource) *AutoMLDataSource {
	s.S3DataSource = v
	return s
}

// Artifacts that are generation during a job.
type AutoMLJobArtifacts struct {
	_ struct{} `type:"structure"`

	// The URL to the notebook location.
	CandidateDefinitionNotebookLocation *string `min:"1" type:"string"`

	// The URL to the notebook location.
	DataExplorationNotebookLocation *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AutoMLJobArtifacts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLJobArtifacts) GoString() string {
	return s.String()
}

// SetCandidateDefinitionNotebookLocation sets the CandidateDefinitionNotebookLocation field's value.
func (s *AutoMLJobArtifacts) SetCandidateDefinitionNotebookLocation(v string) *AutoMLJobArtifacts {
	s.CandidateDefinitionNotebookLocation = &v
	return s
}

// SetDataExplorationNotebookLocation sets the DataExplorationNotebookLocation field's value.
func (s *AutoMLJobArtifacts) SetDataExplorationNotebookLocation(v string) *AutoMLJobArtifacts {
	s.DataExplorationNotebookLocation = &v
	return s
}

// How long a job is allowed to run, or how many candidates a job is allowed
// to generate.
type AutoMLJobCompletionCriteria struct {
	_ struct{} `type:"structure"`

	// The maximum time, in seconds, an AutoML job is allowed to wait for a trial
	// to complete. It must be equal to or greater than MaxRuntimePerTrainingJobInSeconds.
	MaxAutoMLJobRuntimeInSeconds *int64 `min:"1" type:"integer"`

	// The maximum number of times a training job is allowed to run.
	MaxCandidates *int64 `min:"1" type:"integer"`

	// The maximum time, in seconds, a job is allowed to run.
	MaxRuntimePerTrainingJobInSeconds *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s AutoMLJobCompletionCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLJobCompletionCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLJobCompletionCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLJobCompletionCriteria"}
	if s.MaxAutoMLJobRuntimeInSeconds != nil && *s.MaxAutoMLJobRuntimeInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxAutoMLJobRuntimeInSeconds", 1))
	}
	if s.MaxCandidates != nil && *s.MaxCandidates < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxCandidates", 1))
	}
	if s.MaxRuntimePerTrainingJobInSeconds != nil && *s.MaxRuntimePerTrainingJobInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxRuntimePerTrainingJobInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxAutoMLJobRuntimeInSeconds sets the MaxAutoMLJobRuntimeInSeconds field's value.
func (s *AutoMLJobCompletionCriteria) SetMaxAutoMLJobRuntimeInSeconds(v int64) *AutoMLJobCompletionCriteria {
	s.MaxAutoMLJobRuntimeInSeconds = &v
	return s
}

// SetMaxCandidates sets the MaxCandidates field's value.
func (s *AutoMLJobCompletionCriteria) SetMaxCandidates(v int64) *AutoMLJobCompletionCriteria {
	s.MaxCandidates = &v
	return s
}

// SetMaxRuntimePerTrainingJobInSeconds sets the MaxRuntimePerTrainingJobInSeconds field's value.
func (s *AutoMLJobCompletionCriteria) SetMaxRuntimePerTrainingJobInSeconds(v int64) *AutoMLJobCompletionCriteria {
	s.MaxRuntimePerTrainingJobInSeconds = &v
	return s
}

// A collection of settings used for a job.
type AutoMLJobConfig struct {
	_ struct{} `type:"structure"`

	// How long a job is allowed to run, or how many candidates a job is allowed
	// to generate.
	CompletionCriteria *AutoMLJobCompletionCriteria `type:"structure"`

	// Security configuration for traffic encryption or Amazon VPC settings.
	SecurityConfig *AutoMLSecurityConfig `type:"structure"`
}

// String returns the string representation
func (s AutoMLJobConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLJobConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLJobConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLJobConfig"}
	if s.CompletionCriteria != nil {
		if err := s.CompletionCriteria.Validate(); err != nil {
			invalidParams.AddNested("CompletionCriteria", err.(request.ErrInvalidParams))
		}
	}
	if s.SecurityConfig != nil {
		if err := s.SecurityConfig.Validate(); err != nil {
			invalidParams.AddNested("SecurityConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompletionCriteria sets the CompletionCriteria field's value.
func (s *AutoMLJobConfig) SetCompletionCriteria(v *AutoMLJobCompletionCriteria) *AutoMLJobConfig {
	s.CompletionCriteria = v
	return s
}

// SetSecurityConfig sets the SecurityConfig field's value.
func (s *AutoMLJobConfig) SetSecurityConfig(v *AutoMLSecurityConfig) *AutoMLJobConfig {
	s.SecurityConfig = v
	return s
}

// Specifies a metric to minimize or maximize as the objective of a job.
type AutoMLJobObjective struct {
	_ struct{} `type:"structure"`

	// The name of the objective metric used to measure the predictive quality of
	// a machine learning system. This metric is optimized during training to provide
	// the best estimate for model parameter values from data.
	//
	// Here are the options:
	//
	//    * MSE: The mean squared error (MSE) is the average of the squared differences
	//    between the predicted and actual values. It is used for regression. MSE
	//    values are always positive, the better a model is at predicting the actual
	//    values the smaller the MSE value. When the data contains outliers, they
	//    tend to dominate the MSE which might cause subpar prediction performance.
	//
	//    * Accuracy: The ratio of the number correctly classified items to the
	//    total number (correctly and incorrectly) classified. It is used for binary
	//    and multiclass classification. Measures how close the predicted class
	//    values are to the actual values. Accuracy values vary between zero and
	//    one, one being perfect accuracy and zero perfect inaccuracy.
	//
	//    * F1: The F1 score is the harmonic mean of the precision and recall. It
	//    is used for binary classification into classes traditionally referred
	//    to as positive and negative. Predictions are said to be true when they
	//    match their actual (correct) class; false when they do not. Precision
	//    is the ratio of the true positive predictions to all positive predictions
	//    (including the false positives) in a data set and measures the quality
	//    of the prediction when it predicts the positive class. Recall (or sensitivity)
	//    is the ratio of the true positive predictions to all actual positive instances
	//    and measures how completely a model predicts the actual class members
	//    in a data set. The standard F1 score weighs precision and recall equally.
	//    But which metric is paramount typically depends on specific aspects of
	//    a problem. F1 scores vary between zero and one, one being the best possible
	//    performance and zero the worst.
	//
	//    * AUC: The area under the curve (AUC) metric is used to compare and evaluate
	//    binary classification by algorithms such as logistic regression that return
	//    probabilities. A threshold is needed to map the probabilities into classifications.
	//    The relevant curve is the receiver operating characteristic curve that
	//    plots the true positive rate (TPR) of predictions (or recall) against
	//    the false positive rate (FPR) as a function of the threshold value, above
	//    which a prediction is considered positive. Increasing the threshold results
	//    in fewer false positives but more false negatives. AUC is the area under
	//    this receiver operating characteristic curve and so provides an aggregated
	//    measure of the model performance across all possible classification thresholds.
	//    The AUC score can also be interpreted as the probability that a randomly
	//    selected positive data point is more likely to be predicted positive than
	//    a randomly selected negative example. AUC scores vary between zero and
	//    one, one being perfect accuracy and one half not better than a random
	//    classifier. Values less that one half predict worse than a random predictor
	//    and such consistently bad predictors can be inverted to obtain better
	//    than random predictors.
	//
	//    * F1macro: The F1macro score applies F1 scoring to multiclass classification.
	//    In this context, you have multiple classes to predict. You just calculate
	//    the precision and recall for each class as you did for the positive class
	//    in binary classification. Then used these values to calculate the F1 score
	//    for each class and average them to obtain the F1macro score. F1macro scores
	//    vary between zero and one, one being the best possible performance and
	//    zero the worst.
	//
	// If you do not specify a metric explicitly, the default behavior is to automatically
	// use:
	//
	//    * MSE: for regression.
	//
	//    * F1: for binary classification
	//
	//    * Accuracy: for multiclass classification.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true" enum:"AutoMLMetricEnum"`
}

// String returns the string representation
func (s AutoMLJobObjective) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLJobObjective) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLJobObjective) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLJobObjective"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetricName sets the MetricName field's value.
func (s *AutoMLJobObjective) SetMetricName(v string) *AutoMLJobObjective {
	s.MetricName = &v
	return s
}

// Provides a summary about a job.
type AutoMLJobSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the job.
	//
	// AutoMLJobArn is a required field
	AutoMLJobArn *string `min:"1" type:"string" required:"true"`

	// The name of the object you are requesting.
	//
	// AutoMLJobName is a required field
	AutoMLJobName *string `min:"1" type:"string" required:"true"`

	// The job's secondary status.
	//
	// AutoMLJobSecondaryStatus is a required field
	AutoMLJobSecondaryStatus *string `type:"string" required:"true" enum:"AutoMLJobSecondaryStatus"`

	// The job's status.
	//
	// AutoMLJobStatus is a required field
	AutoMLJobStatus *string `type:"string" required:"true" enum:"AutoMLJobStatus"`

	// When the job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The end time of an AutoML job.
	EndTime *time.Time `type:"timestamp"`

	// The failure reason of a job.
	FailureReason *string `type:"string"`

	// When the job was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s AutoMLJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLJobSummary) GoString() string {
	return s.String()
}

// SetAutoMLJobArn sets the AutoMLJobArn field's value.
func (s *AutoMLJobSummary) SetAutoMLJobArn(v string) *AutoMLJobSummary {
	s.AutoMLJobArn = &v
	return s
}

// SetAutoMLJobName sets the AutoMLJobName field's value.
func (s *AutoMLJobSummary) SetAutoMLJobName(v string) *AutoMLJobSummary {
	s.AutoMLJobName = &v
	return s
}

// SetAutoMLJobSecondaryStatus sets the AutoMLJobSecondaryStatus field's value.
func (s *AutoMLJobSummary) SetAutoMLJobSecondaryStatus(v string) *AutoMLJobSummary {
	s.AutoMLJobSecondaryStatus = &v
	return s
}

// SetAutoMLJobStatus sets the AutoMLJobStatus field's value.
func (s *AutoMLJobSummary) SetAutoMLJobStatus(v string) *AutoMLJobSummary {
	s.AutoMLJobStatus = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AutoMLJobSummary) SetCreationTime(v time.Time) *AutoMLJobSummary {
	s.CreationTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *AutoMLJobSummary) SetEndTime(v time.Time) *AutoMLJobSummary {
	s.EndTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *AutoMLJobSummary) SetFailureReason(v string) *AutoMLJobSummary {
	s.FailureReason = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *AutoMLJobSummary) SetLastModifiedTime(v time.Time) *AutoMLJobSummary {
	s.LastModifiedTime = &v
	return s
}

// The output data configuration.
type AutoMLOutputDataConfig struct {
	_ struct{} `type:"structure"`

	// The AWS KMS encryption key ID.
	KmsKeyId *string `type:"string"`

	// The Amazon S3 output path. Must be 128 characters or less.
	//
	// S3OutputPath is a required field
	S3OutputPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLOutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLOutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLOutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLOutputDataConfig"}
	if s.S3OutputPath == nil {
		invalidParams.Add(request.NewErrParamRequired("S3OutputPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AutoMLOutputDataConfig) SetKmsKeyId(v string) *AutoMLOutputDataConfig {
	s.KmsKeyId = &v
	return s
}

// SetS3OutputPath sets the S3OutputPath field's value.
func (s *AutoMLOutputDataConfig) SetS3OutputPath(v string) *AutoMLOutputDataConfig {
	s.S3OutputPath = &v
	return s
}

// The Amazon S3 data source.
type AutoMLS3DataSource struct {
	_ struct{} `type:"structure"`

	// The data type.
	//
	// S3DataType is a required field
	S3DataType *string `type:"string" required:"true" enum:"AutoMLS3DataType"`

	// The URL to the Amazon S3 data source.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AutoMLS3DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLS3DataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoMLS3DataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoMLS3DataSource"}
	if s.S3DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DataType"))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3DataType sets the S3DataType field's value.
func (s *AutoMLS3DataSource) SetS3DataType(v string) *AutoMLS3DataSource {
	s.S3DataType = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *AutoMLS3DataSource) SetS3Uri(v string) *AutoMLS3DataSource {
	s.S3Uri = &v
	return s
}

// Security options.
type AutoMLSecurityConfig struct {
	_ struct{} `type:"structure"`

	// Whether to use traffic encryption between the container layers.
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// The key used to encrypt stored data.
	VolumeKmsKeyId *string `type:"string"`

	// VPC configuration.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s AutoMLSecurityConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoMLSecurityConfig) GoString