// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kafka

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterRequest method.
//    req, resp := client.CreateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateCluster
func (c *Kafka) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/clusters",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Managed Streaming for Kafka.
//
// Creates a new MSK cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation CreateCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Returns information about an error.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Returns information about an error.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Returns information about an error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Returns information about an error.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Returns information about an error.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Returns information about an error.
//
//   * ErrCodeConflictException "ConflictException"
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateCluster
func (c *Kafka) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClusterRequest method.
//    req, resp := client.DeleteClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteCluster
func (c *Kafka) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/clusters/{clusterArn}",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Managed Streaming for Kafka.
//
// Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   Returns information about an error.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Returns information about an error.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Returns information about an error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DeleteCluster
func (c *Kafka) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCluster for more information on using the DescribeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterRequest method.
//    req, resp := client.DescribeClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeCluster
func (c *Kafka) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	output = &DescribeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCluster API operation for Managed Streaming for Kafka.
//
// Returns a description of the MSK cluster whose Amazon Resource Name (ARN)
// is specified in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation DescribeCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   Returns information about an error.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Returns information about an error.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Returns information about an error.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Returns information about an error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeCluster
func (c *Kafka) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	return out, req.Send()
}

// DescribeClusterWithContext is the same as DescribeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) DescribeClusterWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.Option) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBootstrapBrokers = "GetBootstrapBrokers"

// GetBootstrapBrokersRequest generates a "aws/request.Request" representing the
// client's request for the GetBootstrapBrokers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBootstrapBrokers for more information on using the GetBootstrapBrokers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBootstrapBrokersRequest method.
//    req, resp := client.GetBootstrapBrokersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetBootstrapBrokers
func (c *Kafka) GetBootstrapBrokersRequest(input *GetBootstrapBrokersInput) (req *request.Request, output *GetBootstrapBrokersOutput) {
	op := &request.Operation{
		Name:       opGetBootstrapBrokers,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}/bootstrap-brokers",
	}

	if input == nil {
		input = &GetBootstrapBrokersInput{}
	}

	output = &GetBootstrapBrokersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBootstrapBrokers API operation for Managed Streaming for Kafka.
//
// A list of brokers that a client application can use to bootstrap.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation GetBootstrapBrokers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Returns information about an error.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Returns information about an error.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Returns information about an error.
//
//   * ErrCodeConflictException "ConflictException"
//   Returns information about an error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/GetBootstrapBrokers
func (c *Kafka) GetBootstrapBrokers(input *GetBootstrapBrokersInput) (*GetBootstrapBrokersOutput, error) {
	req, out := c.GetBootstrapBrokersRequest(input)
	return out, req.Send()
}

// GetBootstrapBrokersWithContext is the same as GetBootstrapBrokers with the addition of
// the ability to pass a context and additional request options.
//
// See GetBootstrapBrokers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) GetBootstrapBrokersWithContext(ctx aws.Context, input *GetBootstrapBrokersInput, opts ...request.Option) (*GetBootstrapBrokersOutput, error) {
	req, out := c.GetBootstrapBrokersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClustersRequest method.
//    req, resp := client.ListClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters
func (c *Kafka) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters",
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for Managed Streaming for Kafka.
//
// Returns a list of clusters in an account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListClusters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Returns information about an error.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Returns information about an error.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Returns information about an error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListClusters
func (c *Kafka) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListNodes = "ListNodes"

// ListNodesRequest generates a "aws/request.Request" representing the
// client's request for the ListNodes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNodes for more information on using the ListNodes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNodesRequest method.
//    req, resp := client.ListNodesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes
func (c *Kafka) ListNodesRequest(input *ListNodesInput) (req *request.Request, output *ListNodesOutput) {
	op := &request.Operation{
		Name:       opListNodes,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/clusters/{clusterArn}/nodes",
	}

	if input == nil {
		input = &ListNodesInput{}
	}

	output = &ListNodesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNodes API operation for Managed Streaming for Kafka.
//
// Returns a list of the broker nodes in the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Managed Streaming for Kafka's
// API operation ListNodes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   Returns information about an error.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Returns information about an error.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   Returns information about an error.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   Returns information about an error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListNodes
func (c *Kafka) ListNodes(input *ListNodesInput) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	return out, req.Send()
}

// ListNodesWithContext is the same as ListNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Kafka) ListNodesWithContext(ctx aws.Context, input *ListNodesInput, opts ...request.Option) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes the setup to be used for Kafka broker nodes in the cluster.
type BrokerNodeGroupInfo struct {
	_ struct{} `type:"structure"`

	// The distribution of broker nodes across Availability Zones.
	BrokerAZDistribution *string `locationName:"brokerAZDistribution" type:"string" enum:"BrokerAZDistribution"`

	// The list of subnets to connect to in the client virtual private cloud (VPC).
	// AWS creates elastic network interfaces inside these subnets. Client applications
	// use elastic network interfaces to produce and consume data. Client subnets
	// can't be in Availability Zone us-east-1e.
	//
	// ClientSubnets is a required field
	ClientSubnets []*string `locationName:"clientSubnets" type:"list" required:"true"`

	// The type of Amazon EC2 instances to use for Kafka brokers. The following
	// instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge,kafka.m5.4xlarge,
	// kafka.m5.12xlarge, and kafka.m5.24xlarge.
	//
	// InstanceType is a required field
	InstanceType *string `locationName:"instanceType" min:"5" type:"string" required:"true"`

	// The AWS security groups to associate with the elastic network interfaces
	// in order to specify who can connect to and communicate with the Amazon MSK
	// cluster.
	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// Contains information about storage volumes attached to MSK broker nodes.
	StorageInfo *StorageInfo `locationName:"storageInfo" type:"structure"`
}

// String returns the string representation
func (s BrokerNodeGroupInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerNodeGroupInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BrokerNodeGroupInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BrokerNodeGroupInfo"}
	if s.ClientSubnets == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientSubnets"))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 5))
	}
	if s.StorageInfo != nil {
		if err := s.StorageInfo.Validate(); err != nil {
			invalidParams.AddNested("StorageInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerAZDistribution sets the BrokerAZDistribution field's value.
func (s *BrokerNodeGroupInfo) SetBrokerAZDistribution(v string) *BrokerNodeGroupInfo {
	s.BrokerAZDistribution = &v
	return s
}

// SetClientSubnets sets the ClientSubnets field's value.
func (s *BrokerNodeGroupInfo) SetClientSubnets(v []*string) *BrokerNodeGroupInfo {
	s.ClientSubnets = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *BrokerNodeGroupInfo) SetInstanceType(v string) *BrokerNodeGroupInfo {
	s.InstanceType = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *BrokerNodeGroupInfo) SetSecurityGroups(v []*string) *BrokerNodeGroupInfo {
	s.SecurityGroups = v
	return s
}

// SetStorageInfo sets the StorageInfo field's value.
func (s *BrokerNodeGroupInfo) SetStorageInfo(v *StorageInfo) *BrokerNodeGroupInfo {
	s.StorageInfo = v
	return s
}

// BrokerNodeInfo
type BrokerNodeInfo struct {
	_ struct{} `type:"structure"`

	// The attached elastic network interface of the broker.
	AttachedENIId *string `locationName:"attachedENIId" type:"string"`

	// The ID of the broker.
	BrokerId *float64 `locationName:"brokerId" type:"double"`

	// The client subnet to which this broker node belongs.
	ClientSubnet *string `locationName:"clientSubnet" type:"string"`

	// The virtual private cloud (VPC) of the client.
	ClientVpcIpAddress *string `locationName:"clientVpcIpAddress" type:"string"`

	// Information about the version of software currently deployed on the Kafka
	// brokers in the cluster.
	CurrentBrokerSoftwareInfo *BrokerSoftwareInfo `locationName:"currentBrokerSoftwareInfo" type:"structure"`
}

// String returns the string representation
func (s BrokerNodeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerNodeInfo) GoString() string {
	return s.String()
}

// SetAttachedENIId sets the AttachedENIId field's value.
func (s *BrokerNodeInfo) SetAttachedENIId(v string) *BrokerNodeInfo {
	s.AttachedENIId = &v
	return s
}

// SetBrokerId sets the BrokerId field's value.
func (s *BrokerNodeInfo) SetBrokerId(v float64) *BrokerNodeInfo {
	s.BrokerId = &v
	return s
}

// SetClientSubnet sets the ClientSubnet field's value.
func (s *BrokerNodeInfo) SetClientSubnet(v string) *BrokerNodeInfo {
	s.ClientSubnet = &v
	return s
}

// SetClientVpcIpAddress sets the ClientVpcIpAddress field's value.
func (s *BrokerNodeInfo) SetClientVpcIpAddress(v string) *BrokerNodeInfo {
	s.ClientVpcIpAddress = &v
	return s
}

// SetCurrentBrokerSoftwareInfo sets the CurrentBrokerSoftwareInfo field's value.
func (s *BrokerNodeInfo) SetCurrentBrokerSoftwareInfo(v *BrokerSoftwareInfo) *BrokerNodeInfo {
	s.CurrentBrokerSoftwareInfo = v
	return s
}

// Information about the current software installed on the cluster.
type BrokerSoftwareInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration used for the cluster.
	ConfigurationArn *string `locationName:"configurationArn" type:"string"`

	// The revision of the configuration to use.
	ConfigurationRevision *string `locationName:"configurationRevision" type:"string"`

	// The version of Apache Kafka.
	KafkaVersion *string `locationName:"kafkaVersion" type:"string"`
}

// String returns the string representation
func (s BrokerSoftwareInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BrokerSoftwareInfo) GoString() string {
	return s.String()
}

// SetConfigurationArn sets the ConfigurationArn field's value.
func (s *BrokerSoftwareInfo) SetConfigurationArn(v string) *BrokerSoftwareInfo {
	s.ConfigurationArn = &v
	return s
}

// SetConfigurationRevision sets the ConfigurationRevision field's value.
func (s *BrokerSoftwareInfo) SetConfigurationRevision(v string) *BrokerSoftwareInfo {
	s.ConfigurationRevision = &v
	return s
}

// SetKafkaVersion sets the KafkaVersion field's value.
func (s *BrokerSoftwareInfo) SetKafkaVersion(v string) *BrokerSoftwareInfo {
	s.KafkaVersion = &v
	return s
}

// Returns information about a cluster.
type ClusterInfo struct {
	_ struct{} `type:"structure"`

	// Information about the broker nodes.
	BrokerNodeGroupInfo *BrokerNodeGroupInfo `locationName:"brokerNodeGroupInfo" type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The name of the cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The time when the cluster was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Information about the version of software currently deployed on the Kafka
	// brokers in the cluster.
	CurrentBrokerSoftwareInfo *BrokerSoftwareInfo `locationName:"currentBrokerSoftwareInfo" type:"structure"`

	// The current version of the MSK cluster.
	CurrentVersion *string `locationName:"currentVersion" type:"string"`

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo `locationName:"encryptionInfo" type:"structure"`

	// Specifies which metrics are gathered for the MSK cluster. This property has
	// three possible values: DEFAULT, PER_BROKER, and PER_TOPIC_PER_BROKER.
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	// The number of Kafka broker nodes in the cluster.
	NumberOfBrokerNodes *int64 `locationName:"numberOfBrokerNodes" type:"integer"`

	// The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
	State *string `locationName:"state" type:"string" enum:"ClusterState"`

	// The connection string to use to connect to the Apache ZooKeeper cluster.
	ZookeeperConnectString *string `locationName:"zookeeperConnectString" type:"string"`
}

// String returns the string representation
func (s ClusterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterInfo) GoString() string {
	return s.String()
}

// SetBrokerNodeGroupInfo sets the BrokerNodeGroupInfo field's value.
func (s *ClusterInfo) SetBrokerNodeGroupInfo(v *BrokerNodeGroupInfo) *ClusterInfo {
	s.BrokerNodeGroupInfo = v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ClusterInfo) SetClusterArn(v string) *ClusterInfo {
	s.ClusterArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *ClusterInfo) SetClusterName(v string) *ClusterInfo {
	s.ClusterName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ClusterInfo) SetCreationTime(v time.Time) *ClusterInfo {
	s.CreationTime = &v
	return s
}

// SetCurrentBrokerSoftwareInfo sets the CurrentBrokerSoftwareInfo field's value.
func (s *ClusterInfo) SetCurrentBrokerSoftwareInfo(v *BrokerSoftwareInfo) *ClusterInfo {
	s.CurrentBrokerSoftwareInfo = v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *ClusterInfo) SetCurrentVersion(v string) *ClusterInfo {
	s.CurrentVersion = &v
	return s
}

// SetEncryptionInfo sets the EncryptionInfo field's value.
func (s *ClusterInfo) SetEncryptionInfo(v *EncryptionInfo) *ClusterInfo {
	s.EncryptionInfo = v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *ClusterInfo) SetEnhancedMonitoring(v string) *ClusterInfo {
	s.EnhancedMonitoring = &v
	return s
}

// SetNumberOfBrokerNodes sets the NumberOfBrokerNodes field's value.
func (s *ClusterInfo) SetNumberOfBrokerNodes(v int64) *ClusterInfo {
	s.NumberOfBrokerNodes = &v
	return s
}

// SetState sets the State field's value.
func (s *ClusterInfo) SetState(v string) *ClusterInfo {
	s.State = &v
	return s
}

// SetZookeeperConnectString sets the ZookeeperConnectString field's value.
func (s *ClusterInfo) SetZookeeperConnectString(v string) *ClusterInfo {
	s.ZookeeperConnectString = &v
	return s
}

// Creates a cluster.
type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// Information about the broker nodes in the cluster.
	//
	// BrokerNodeGroupInfo is a required field
	BrokerNodeGroupInfo *BrokerNodeGroupInfo `locationName:"brokerNodeGroupInfo" type:"structure" required:"true"`

	// The name of the cluster.
	//
	// ClusterName is a required field
	ClusterName *string `locationName:"clusterName" min:"1" type:"string" required:"true"`

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo `locationName:"encryptionInfo" type:"structure"`

	// Specifies the level of monitoring for the MSK cluster. The possible values
	// are DEFAULT, PER_BROKER, and PER_TOPIC_PER_BROKER.
	EnhancedMonitoring *string `locationName:"enhancedMonitoring" type:"string" enum:"EnhancedMonitoring"`

	// The version of Apache Kafka.
	//
	// KafkaVersion is a required field
	KafkaVersion *string `locationName:"kafkaVersion" min:"1" type:"string" required:"true"`

	// The number of Kafka broker nodes in the Amazon MSK cluster.
	//
	// NumberOfBrokerNodes is a required field
	NumberOfBrokerNodes *int64 `locationName:"numberOfBrokerNodes" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.BrokerNodeGroupInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("BrokerNodeGroupInfo"))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.KafkaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("KafkaVersion"))
	}
	if s.KafkaVersion != nil && len(*s.KafkaVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KafkaVersion", 1))
	}
	if s.NumberOfBrokerNodes == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfBrokerNodes"))
	}
	if s.NumberOfBrokerNodes != nil && *s.NumberOfBrokerNodes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfBrokerNodes", 1))
	}
	if s.BrokerNodeGroupInfo != nil {
		if err := s.BrokerNodeGroupInfo.Validate(); err != nil {
			invalidParams.AddNested("BrokerNodeGroupInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionInfo != nil {
		if err := s.EncryptionInfo.Validate(); err != nil {
			invalidParams.AddNested("EncryptionInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBrokerNodeGroupInfo sets the BrokerNodeGroupInfo field's value.
func (s *CreateClusterInput) SetBrokerNodeGroupInfo(v *BrokerNodeGroupInfo) *CreateClusterInput {
	s.BrokerNodeGroupInfo = v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterInput) SetClusterName(v string) *CreateClusterInput {
	s.ClusterName = &v
	return s
}

// SetEncryptionInfo sets the EncryptionInfo field's value.
func (s *CreateClusterInput) SetEncryptionInfo(v *EncryptionInfo) *CreateClusterInput {
	s.EncryptionInfo = v
	return s
}

// SetEnhancedMonitoring sets the EnhancedMonitoring field's value.
func (s *CreateClusterInput) SetEnhancedMonitoring(v string) *CreateClusterInput {
	s.EnhancedMonitoring = &v
	return s
}

// SetKafkaVersion sets the KafkaVersion field's value.
func (s *CreateClusterInput) SetKafkaVersion(v string) *CreateClusterInput {
	s.KafkaVersion = &v
	return s
}

// SetNumberOfBrokerNodes sets the NumberOfBrokerNodes field's value.
func (s *CreateClusterInput) SetNumberOfBrokerNodes(v int64) *CreateClusterInput {
	s.NumberOfBrokerNodes = &v
	return s
}

// Returns information about the created cluster.
type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The name of the MSK cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
	State *string `locationName:"state" type:"string" enum:"ClusterState"`
}

// String returns the string representation
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *CreateClusterOutput) SetClusterArn(v string) *CreateClusterOutput {
	s.ClusterArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterOutput) SetClusterName(v string) *CreateClusterOutput {
	s.ClusterName = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateClusterOutput) SetState(v string) *CreateClusterOutput {
	s.State = &v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	CurrentVersion *string `location:"querystring" locationName:"currentVersion" type:"string"`
}

// String returns the string representation
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DeleteClusterInput) SetClusterArn(v string) *DeleteClusterInput {
	s.ClusterArn = &v
	return s
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *DeleteClusterInput) SetCurrentVersion(v string) *DeleteClusterInput {
	s.CurrentVersion = &v
	return s
}

// Returns information about the deleted cluster.
type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	ClusterArn *string `locationName:"clusterArn" type:"string"`

	// The state of the cluster. The possible states are CREATING, ACTIVE, and FAILED.
	State *string `locationName:"state" type:"string" enum:"ClusterState"`
}

// String returns the string representation
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DeleteClusterOutput) SetClusterArn(v string) *DeleteClusterOutput {
	s.ClusterArn = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteClusterOutput) SetState(v string) *DeleteClusterOutput {
	s.State = &v
	return s
}

type DescribeClusterInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DescribeClusterInput) SetClusterArn(v string) *DescribeClusterInput {
	s.ClusterArn = &v
	return s
}

// Returns information about a cluster.
type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// The cluster information.
	ClusterInfo *ClusterInfo `locationName:"clusterInfo" type:"structure"`
}

// String returns the string representation
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// SetClusterInfo sets the ClusterInfo field's value.
func (s *DescribeClusterOutput) SetClusterInfo(v *ClusterInfo) *DescribeClusterOutput {
	s.ClusterInfo = v
	return s
}

// Contains information about the EBS storage volumes attached to Kafka broker
// nodes.
type EBSStorageInfo struct {
	_ struct{} `type:"structure"`

	// The size in GiB of the EBS volume for the data drive on each broker node.
	VolumeSize *int64 `locationName:"volumeSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s EBSStorageInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EBSStorageInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EBSStorageInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EBSStorageInfo"}
	if s.VolumeSize != nil && *s.VolumeSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VolumeSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *EBSStorageInfo) SetVolumeSize(v int64) *EBSStorageInfo {
	s.VolumeSize = &v
	return s
}

// The data volume encryption details.
type EncryptionAtRest struct {
	_ struct{} `type:"structure"`

	// The AWS KMS key used for data encryption.
	//
	// DataVolumeKMSKeyId is a required field
	DataVolumeKMSKeyId *string `locationName:"dataVolumeKMSKeyId" type:"string" required:"true"`
}

// String returns the string representation
func (s EncryptionAtRest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionAtRest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionAtRest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionAtRest"}
	if s.DataVolumeKMSKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataVolumeKMSKeyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataVolumeKMSKeyId sets the DataVolumeKMSKeyId field's value.
func (s *EncryptionAtRest) SetDataVolumeKMSKeyId(v string) *EncryptionAtRest {
	s.DataVolumeKMSKeyId = &v
	return s
}

// Includes encryption-related information, such as the AWS KMS key used for
// encrypting data at rest.
type EncryptionInfo struct {
	_ struct{} `type:"structure"`

	// The data volume encryption details.
	EncryptionAtRest *EncryptionAtRest `locationName:"encryptionAtRest" type:"structure"`
}

// String returns the string representation
func (s EncryptionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionInfo"}
	if s.EncryptionAtRest != nil {
		if err := s.EncryptionAtRest.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionAtRest sets the EncryptionAtRest field's value.
func (s *EncryptionInfo) SetEncryptionAtRest(v *EncryptionAtRest) *EncryptionInfo {
	s.EncryptionAtRest = v
	return s
}

type GetBootstrapBrokersInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBootstrapBrokersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBootstrapBrokersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBootstrapBrokersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBootstrapBrokersInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *GetBootstrapBrokersInput) SetClusterArn(v string) *GetBootstrapBrokersInput {
	s.ClusterArn = &v
	return s
}

// Returns a string containing one or more hostname:port pairs.
type GetBootstrapBrokersOutput struct {
	_ struct{} `type:"structure"`

	// A string containing one or more hostname:port pairs.
	BootstrapBrokerString *string `locationName:"bootstrapBrokerString" type:"string"`
}

// String returns the string representation
func (s GetBootstrapBrokersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBootstrapBrokersOutput) GoString() string {
	return s.String()
}

// SetBootstrapBrokerString sets the BootstrapBrokerString field's value.
func (s *GetBootstrapBrokersOutput) SetBootstrapBrokerString(v string) *GetBootstrapBrokersOutput {
	s.BootstrapBrokerString = &v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure"`

	ClusterNameFilter *string `location:"querystring" locationName:"clusterNameFilter" type:"string"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterNameFilter sets the ClusterNameFilter field's value.
func (s *ListClustersInput) SetClusterNameFilter(v string) *ListClustersInput {
	s.ClusterNameFilter = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersInput) SetMaxResults(v int64) *ListClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersInput) SetNextToken(v string) *ListClustersInput {
	s.NextToken = &v
	return s
}

// The response contains an array containing cluster information and a next
// token if the response is truncated.
type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// Information on each of the MSK clusters in the response.
	ClusterInfoList []*ClusterInfo `locationName:"clusterInfoList" type:"list"`

	// The paginated results marker. When the result of a ListClusters operation
	// is truncated, the call returns NextToken in the response. To get another
	// batch of clusters, provide this token in your next request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusterInfoList sets the ClusterInfoList field's value.
func (s *ListClustersOutput) SetClusterInfoList(v []*ClusterInfo) *ListClustersOutput {
	s.ClusterInfoList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersOutput) SetNextToken(v string) *ListClustersOutput {
	s.NextToken = &v
	return s
}

type ListNodesInput struct {
	_ struct{} `type:"structure"`

	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNodesInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ListNodesInput) SetClusterArn(v string) *ListNodesInput {
	s.ClusterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNodesInput) SetMaxResults(v int64) *ListNodesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesInput) SetNextToken(v string) *ListNodesInput {
	s.NextToken = &v
	return s
}

// Information about nodes in the cluster.
type ListNodesOutput struct {
	_ struct{} `type:"structure"`

	// The paginated results marker. When the result of a ListNodes operation is
	// truncated, the call returns NextToken in the response. To get another batch
	// of nodes, provide this token in your next request.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List containing a NodeInfo object.
	NodeInfoList []*NodeInfo `locationName:"nodeInfoList" type:"list"`
}

// String returns the string representation
func (s ListNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesOutput) SetNextToken(v string) *ListNodesOutput {
	s.NextToken = &v
	return s
}

// SetNodeInfoList sets the NodeInfoList field's value.
func (s *ListNodesOutput) SetNodeInfoList(v []*NodeInfo) *ListNodesOutput {
	s.NodeInfoList = v
	return s
}

// The node information object.
type NodeInfo struct {
	_ struct{} `type:"structure"`

	// The start time.
	AddedToClusterTime *string `locationName:"addedToClusterTime" type:"string"`

	// The broker node info.
	BrokerNodeInfo *BrokerNodeInfo `locationName:"brokerNodeInfo" type:"structure"`

	// The instance type.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The Amazon Resource Name (ARN) of the node.
	NodeARN *string `locationName:"nodeARN" type:"string"`

	// The node type.
	NodeType *string `locationName:"nodeType" type:"string" enum:"NodeType"`

	// The ZookeeperNodeInfo.
	ZookeeperNodeInfo *ZookeeperNodeInfo `locationName:"zookeeperNodeInfo" type:"structure"`
}

// String returns the string representation
func (s NodeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeInfo) GoString() string {
	return s.String()
}

// SetAddedToClusterTime sets the AddedToClusterTime field's value.
func (s *NodeInfo) SetAddedToClusterTime(v string) *NodeInfo {
	s.AddedToClusterTime = &v
	return s
}

// SetBrokerNodeInfo sets the BrokerNodeInfo field's value.
func (s *NodeInfo) SetBrokerNodeInfo(v *BrokerNodeInfo) *NodeInfo {
	s.BrokerNodeInfo = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *NodeInfo) SetInstanceType(v string) *NodeInfo {
	s.InstanceType = &v
	return s
}

// SetNodeARN sets the NodeARN field's value.
func (s *NodeInfo) SetNodeARN(v string) *NodeInfo {
	s.NodeARN = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *NodeInfo) SetNodeType(v string) *NodeInfo {
	s.NodeType = &v
	return s
}

// SetZookeeperNodeInfo sets the ZookeeperNodeInfo field's value.
func (s *NodeInfo) SetZookeeperNodeInfo(v *ZookeeperNodeInfo) *NodeInfo {
	s.ZookeeperNodeInfo = v
	return s
}

// Contains information about storage volumes attached to MSK broker nodes.
type StorageInfo struct {
	_ struct{} `type:"structure"`

	// EBS volume information.
	EbsStorageInfo *EBSStorageInfo `locationName:"ebsStorageInfo" type:"structure"`
}

// String returns the string representation
func (s StorageInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageInfo"}
	if s.EbsStorageInfo != nil {
		if err := s.EbsStorageInfo.Validate(); err != nil {
			invalidParams.AddNested("EbsStorageInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEbsStorageInfo sets the EbsStorageInfo field's value.
func (s *StorageInfo) SetEbsStorageInfo(v *EBSStorageInfo) *StorageInfo {
	s.EbsStorageInfo = v
	return s
}

// Zookeeper node information.
type ZookeeperNodeInfo struct {
	_ struct{} `type:"structure"`

	// The attached elastic network interface of the broker.
	AttachedENIId *string `locationName:"attachedENIId" type:"string"`

	// The virtual private cloud (VPC) IP address of the client.
	ClientVpcIpAddress *string `locationName:"clientVpcIpAddress" type:"string"`

	// The role-specific ID for Zookeeper.
	ZookeeperId *float64 `locationName:"zookeeperId" type:"double"`

	// The version of Zookeeper.
	ZookeeperVersion *string `locationName:"zookeeperVersion" type:"string"`
}

// String returns the string representation
func (s ZookeeperNodeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ZookeeperNodeInfo) GoString() string {
	return s.String()
}

// SetAttachedENIId sets the AttachedENIId field's value.
func (s *ZookeeperNodeInfo) SetAttachedENIId(v string) *ZookeeperNodeInfo {
	s.AttachedENIId = &v
	return s
}

// SetClientVpcIpAddress sets the ClientVpcIpAddress field's value.
func (s *ZookeeperNodeInfo) SetClientVpcIpAddress(v string) *ZookeeperNodeInfo {
	s.ClientVpcIpAddress = &v
	return s
}

// SetZookeeperId sets the ZookeeperId field's value.
func (s *ZookeeperNodeInfo) SetZookeeperId(v float64) *ZookeeperNodeInfo {
	s.ZookeeperId = &v
	return s
}

// SetZookeeperVersion sets the ZookeeperVersion field's value.
func (s *ZookeeperNodeInfo) SetZookeeperVersion(v string) *ZookeeperNodeInfo {
	s.ZookeeperVersion = &v
	return s
}

// The distribution of broker nodes across Availability Zones. By default, broker
// nodes are distributed among three Availability Zones. Currently, the only
// supported value is DEFAULT. You can either specify this value explicitly
// or leave it out.
const (
	// BrokerAZDistributionDefault is a BrokerAZDistribution enum value
	BrokerAZDistributionDefault = "DEFAULT"
)

// The state of a Kafka cluster.
const (
	// ClusterStateActive is a ClusterState enum value
	ClusterStateActive = "ACTIVE"

	// ClusterStateCreating is a ClusterState enum value
	ClusterStateCreating = "CREATING"

	// ClusterStateDeleting is a ClusterState enum value
	ClusterStateDeleting = "DELETING"

	// ClusterStateFailed is a ClusterState enum value
	ClusterStateFailed = "FAILED"
)

// Specifies which metrics are gathered for the MSK cluster. This property has
// three possible values: DEFAULT, PER_BROKER, and PER_TOPIC_PER_BROKER.
const (
	// EnhancedMonitoringDefault is a EnhancedMonitoring enum value
	EnhancedMonitoringDefault = "DEFAULT"

	// EnhancedMonitoringPerBroker is a EnhancedMonitoring enum value
	EnhancedMonitoringPerBroker = "PER_BROKER"

	// EnhancedMonitoringPerTopicPerBroker is a EnhancedMonitoring enum value
	EnhancedMonitoringPerTopicPerBroker = "PER_TOPIC_PER_BROKER"
)

// The broker or Zookeeper node.
const (
	// NodeTypeBroker is a NodeType enum value
	NodeTypeBroker = "BROKER"
)
