// Code generated by smithy-go-codegen DO NOT EDIT.

package codecommit

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the Key Management Service encryption key used to encrypt and decrypt a
// CodeCommit repository.
func (c *Client) UpdateRepositoryEncryptionKey(ctx context.Context, params *UpdateRepositoryEncryptionKeyInput, optFns ...func(*Options)) (*UpdateRepositoryEncryptionKeyOutput, error) {
	if params == nil {
		params = &UpdateRepositoryEncryptionKeyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateRepositoryEncryptionKey", params, optFns, c.addOperationUpdateRepositoryEncryptionKeyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateRepositoryEncryptionKeyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateRepositoryEncryptionKeyInput struct {

	// The ID of the encryption key. You can view the ID of an encryption key in the
	// KMS console, or use the KMS APIs to programmatically retrieve a key ID. For more
	// information about acceptable values for keyID, see KeyId (https://docs.aws.amazon.com/APIReference/API_Decrypt.html#KMS-Decrypt-request-KeyId)
	// in the Decrypt API description in the Key Management Service API Reference.
	//
	// This member is required.
	KmsKeyId *string

	// The name of the repository for which you want to update the KMS encryption key
	// used to encrypt and decrypt the repository.
	//
	// This member is required.
	RepositoryName *string

	noSmithyDocumentSerde
}

type UpdateRepositoryEncryptionKeyOutput struct {

	// The ID of the encryption key.
	KmsKeyId *string

	// The ID of the encryption key formerly used to encrypt and decrypt the
	// repository.
	OriginalKmsKeyId *string

	// The ID of the repository.
	RepositoryId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateRepositoryEncryptionKeyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateRepositoryEncryptionKey{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateRepositoryEncryptionKey{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateRepositoryEncryptionKey"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateRepositoryEncryptionKeyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateRepositoryEncryptionKey(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateRepositoryEncryptionKey(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateRepositoryEncryptionKey",
	}
}
