// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// ABP device object for LoRaWAN specification v1.0.x
type AbpV1_0_x struct {

	// The DevAddr value.
	DevAddr *string

	// The FCnt init value.
	FCntStart *int32

	// Session keys for ABP v1.0.x
	SessionKeys *SessionKeysAbpV1_0_x

	noSmithyDocumentSerde
}

// ABP device object for LoRaWAN specification v1.1
type AbpV1_1 struct {

	// The DevAddr value.
	DevAddr *string

	// The FCnt init value.
	FCntStart *int32

	// Session keys for ABP v1.1
	SessionKeys *SessionKeysAbpV1_1

	noSmithyDocumentSerde
}

// The accuracy of the estimated position in meters. An empty value indicates that
// no position data is available. A value of ‘0.0’ value indicates that position
// data is available. This data corresponds to the position information that you
// specified instead of the position computed by solver.
type Accuracy struct {

	// The horizontal accuracy of the estimated position in meters.
	HorizontalAccuracy *float32

	// The vertical accuracy of the estimated position in meters.
	VerticalAccuracy *float32

	noSmithyDocumentSerde
}

// Beaconing parameters for configuring the wireless gateways.
type Beaconing struct {

	// The data rate for gateways that are sending the beacons.
	DataRate *int32

	// The frequency list for the gateways to send the beacons.
	Frequencies []int32

	noSmithyDocumentSerde
}

// List of sidewalk certificates.
type CertificateList struct {

	// The certificate chain algorithm provided by sidewalk.
	//
	// This member is required.
	SigningAlg SigningAlg

	// The value of the chosen sidewalk certificate.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Connection status event configuration object for enabling or disabling topic.
type ConnectionStatusEventConfiguration struct {

	// Connection status event configuration object for enabling or disabling LoRaWAN
	// related event topics.
	LoRaWAN *LoRaWANConnectionStatusEventNotificationConfigurations

	// Denotes whether the wireless gateway ID connection status event topic is enabled
	// or disabled.
	WirelessGatewayIdEventTopic EventNotificationTopicStatus

	noSmithyDocumentSerde
}

// Connection status resource type event configuration object for enabling or
// disabling topic.
type ConnectionStatusResourceTypeEventConfiguration struct {

	// Connection status resource type event configuration object for enabling or
	// disabling LoRaWAN related event topics.
	LoRaWAN *LoRaWANConnectionStatusResourceTypeEventConfiguration

	noSmithyDocumentSerde
}

// Describes a destination.
type Destinations struct {

	// The Amazon Resource Name of the resource.
	Arn *string

	// The description of the resource.
	Description *string

	// The rule name or topic rule to send messages to.
	Expression *string

	// The type of value in Expression.
	ExpressionType ExpressionType

	// The name of the resource.
	Name *string

	// The ARN of the IAM Role that authorizes the destination.
	RoleArn *string

	noSmithyDocumentSerde
}

// Describes a device profile.
type DeviceProfile struct {

	// The Amazon Resource Name of the resource.
	Arn *string

	// The ID of the device profile.
	Id *string

	// The name of the resource.
	Name *string

	noSmithyDocumentSerde
}

// Device registration state event configuration object for enabling and disabling
// relevant topics.
type DeviceRegistrationStateEventConfiguration struct {

	// Device registration state event configuration object for enabling or disabling
	// Sidewalk related event topics.
	Sidewalk *SidewalkEventNotificationConfigurations

	// Denotes whether the wireless device ID device registration state event topic is
	// enabled or disabled.
	WirelessDeviceIdEventTopic EventNotificationTopicStatus

	noSmithyDocumentSerde
}

// Device registration state resource type event configuration object for enabling
// or disabling topic.
type DeviceRegistrationStateResourceTypeEventConfiguration struct {

	// Device registration resource type state event configuration object for enabling
	// or disabling Sidewalk related event topics.
	Sidewalk *SidewalkResourceTypeEventConfiguration

	noSmithyDocumentSerde
}

// The message in the downlink queue.
type DownlinkQueueMessage struct {

	// LoRaWAN router info.
	LoRaWAN *LoRaWANSendDataToDevice

	// The message ID assigned by IoT Wireless to each downlink message, which helps
	// identify the message.
	MessageId *string

	// The time at which Iot Wireless received the downlink message.
	ReceivedAt *string

	// The transmit mode to use for sending data to the wireless device. This can be 0
	// for UM (unacknowledge mode) or 1 for AM (acknowledge mode).
	TransmitMode *int32

	noSmithyDocumentSerde
}

// Event configuration object for a single resource.
type EventConfigurationItem struct {

	// Object of all event configurations and the status of the event topics.
	Events *EventNotificationItemConfigurations

	// Resource identifier opted in for event messaging.
	Identifier *string

	// Identifier type of the particular resource identifier for event configuration.
	IdentifierType IdentifierType

	// Partner type of the resource if the identifier type is PartnerAccountId.
	PartnerType EventNotificationPartnerType

	noSmithyDocumentSerde
}

// Object of all event configurations and the status of the event topics.
type EventNotificationItemConfigurations struct {

	// Connection status event configuration for an event configuration item.
	ConnectionStatus *ConnectionStatusEventConfiguration

	// Device registration state event configuration for an event configuration item.
	DeviceRegistrationState *DeviceRegistrationStateEventConfiguration

	// Join event configuration for an event configuration item.
	Join *JoinEventConfiguration

	// Message delivery status event configuration for an event configuration item.
	MessageDeliveryStatus *MessageDeliveryStatusEventConfiguration

	// Proximity event configuration for an event configuration item.
	Proximity *ProximityEventConfiguration

	noSmithyDocumentSerde
}

// List of FPort assigned for different LoRaWAN application packages to use
type FPorts struct {

	// The Fport value.
	ClockSync *int32

	// The Fport value.
	Fuota *int32

	// The Fport value.
	Multicast *int32

	// FPort values for the GNSS, stream, and ClockSync functions of the positioning
	// information.
	Positioning *Positioning

	noSmithyDocumentSerde
}

// A FUOTA task.
type FuotaTask struct {

	// The arn of a FUOTA task.
	Arn *string

	// The ID of a FUOTA task.
	Id *string

	// The name of a FUOTA task.
	Name *string

	noSmithyDocumentSerde
}

// Gateway list item object that specifies the frequency and list of gateways for
// which the downlink message should be sent.
type GatewayListItem struct {

	// The frequency to use for the gateways when sending a downlink message to the
	// wireless device.
	//
	// This member is required.
	DownlinkFrequency *int32

	// The ID of the wireless gateways that you want to add to the list of gateways
	// when sending downlink messages.
	//
	// This member is required.
	GatewayId *string

	noSmithyDocumentSerde
}

// Join event configuration object for enabling or disabling topic.
type JoinEventConfiguration struct {

	// Join event configuration object for enabling or disabling LoRaWAN related event
	// topics.
	LoRaWAN *LoRaWANJoinEventNotificationConfigurations

	// Denotes whether the wireless device ID join event topic is enabled or disabled.
	WirelessDeviceIdEventTopic EventNotificationTopicStatus

	noSmithyDocumentSerde
}

// Join resource type event configuration object for enabling or disabling topic.
type JoinResourceTypeEventConfiguration struct {

	// Join resource type event configuration object for enabling or disabling LoRaWAN
	// related event topics.
	LoRaWAN *LoRaWANJoinResourceTypeEventConfiguration

	noSmithyDocumentSerde
}

// Object for LoRaWAN connection status resource type event configuration.
type LoRaWANConnectionStatusEventNotificationConfigurations struct {

	// Denotes whether the gateway EUI connection status event topic is enabled or
	// disabled.
	GatewayEuiEventTopic EventNotificationTopicStatus

	noSmithyDocumentSerde
}

// Object for LoRaWAN connection status resource type event configuration.
type LoRaWANConnectionStatusResourceTypeEventConfiguration struct {

	// Denotes whether the wireless gateway connection status event topic is enabled or
	// disabled.
	WirelessGatewayEventTopic EventNotificationTopicStatus

	noSmithyDocumentSerde
}

// LoRaWAN object for create functions.
type LoRaWANDevice struct {

	// LoRaWAN object for create APIs
	AbpV1_0_x *AbpV1_0_x

	// ABP device object for create APIs for v1.1
	AbpV1_1 *AbpV1_1

	// The DevEUI value.
	DevEui *string

	// The ID of the device profile for the new wireless device.
	DeviceProfileId *string

	// List of FPort assigned for different LoRaWAN application packages to use
	FPorts *FPorts

	// OTAA device object for create APIs for v1.0.x
	OtaaV1_0_x *OtaaV1_0_x

	// OTAA device object for v1.1 for create APIs
	OtaaV1_1 *OtaaV1_1

	// The ID of the service profile.
	ServiceProfileId *string

	noSmithyDocumentSerde
}

// LoRaWAN device metatdata.
type LoRaWANDeviceMetadata struct {

	// The DataRate value.
	DataRate *int32

	// The DevEUI value.
	DevEui *string

	// The FPort value.
	FPort *int32

	// The device's channel frequency in Hz.
	Frequency *int32

	// Information about the gateways accessed by the device.
	Gateways []LoRaWANGatewayMetadata

	// The date and time of the metadata.
	Timestamp *string

	noSmithyDocumentSerde
}

// LoRaWANDeviceProfile object.
type LoRaWANDeviceProfile struct {

	// The ClassBTimeout value.
	ClassBTimeout *int32

	// The ClassCTimeout value.
	ClassCTimeout *int32

	// The list of values that make up the FactoryPresetFreqs value.
	FactoryPresetFreqsList []int32

	// The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device
	// profile.
	MacVersion *string

	// The MaxDutyCycle value.
	MaxDutyCycle *int32

	// The MaxEIRP value.
	MaxEirp *int32

	// The PingSlotDR value.
	PingSlotDr *int32

	// The PingSlotFreq value.
	PingSlotFreq *int32

	// The PingSlotPeriod value.
	PingSlotPeriod *int32

	// The version of regional parameters.
	RegParamsRevision *string

	// The frequency band (RFRegion) value.
	RfRegion *string

	// The RXDataRate2 value.
	RxDataRate2 *int32

	// The RXDelay1 value.
	RxDelay1 *int32

	// The RXDROffset1 value.
	RxDrOffset1 *int32

	// The RXFreq2 value.
	RxFreq2 *int32

	// The Supports32BitFCnt value.
	Supports32BitFCnt bool

	// The SupportsClassB value.
	SupportsClassB bool

	// The SupportsClassC value.
	SupportsClassC bool

	// The SupportsJoin value.
	SupportsJoin *bool

	noSmithyDocumentSerde
}

// The LoRaWAN information used with a FUOTA task.
type LoRaWANFuotaTask struct {

	// Supported RfRegions
	RfRegion SupportedRfRegion

	noSmithyDocumentSerde
}

// The LoRaWAN information returned from getting a FUOTA task.
type LoRaWANFuotaTaskGetInfo struct {

	// The frequency band (RFRegion) value.
	RfRegion *string

	// Start time of a FUOTA task.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// LoRaWANGateway object.
type LoRaWANGateway struct {

	// Beaconing object information, which consists of the data rate and frequency
	// parameters.
	Beaconing *Beaconing

	// The gateway's EUI value.
	GatewayEui *string

	// A list of JoinEuiRange used by LoRa gateways to filter LoRa frames.
	JoinEuiFilters [][]string

	// A list of NetId values that are used by LoRa gateways to filter the uplink
	// frames.
	NetIdFilters []string

	// The frequency band (RFRegion) value.
	RfRegion *string

	// A list of integer indicating which sub bands are supported by LoRa gateway.
	SubBands []int32

	noSmithyDocumentSerde
}

// LoRaWANGatewayCurrentVersion object.
type LoRaWANGatewayCurrentVersion struct {

	// The version of the gateways that should receive the update.
	CurrentVersion *LoRaWANGatewayVersion

	noSmithyDocumentSerde
}

// LoRaWAN gateway metatdata.
type LoRaWANGatewayMetadata struct {

	// The gateway's EUI value.
	GatewayEui *string

	// The RSSI value.
	Rssi *float64

	// The SNR value.
	Snr *float64

	noSmithyDocumentSerde
}

// LoRaWANGatewayVersion object.
type LoRaWANGatewayVersion struct {

	// The model number of the wireless gateway.
	Model *string

	// The version of the wireless gateway firmware.
	PackageVersion *string

	// The basic station version of the wireless gateway.
	Station *string

	noSmithyDocumentSerde
}

// LoRaWANGetServiceProfileInfo object.
type LoRaWANGetServiceProfileInfo struct {

	// The AddGWMetaData value.
	AddGwMetadata bool

	// The ChannelMask value.
	ChannelMask *string

	// The DevStatusReqFreq value.
	DevStatusReqFreq *int32

	// The DLBucketSize value.
	DlBucketSize *int32

	// The DLRate value.
	DlRate *int32

	// The DLRatePolicy value.
	DlRatePolicy *string

	// The DRMax value.
	DrMax int32

	// The DRMin value.
	DrMin int32

	// The HRAllowed value that describes whether handover roaming is allowed.
	HrAllowed bool

	// The MinGwDiversity value.
	MinGwDiversity *int32

	// The NwkGeoLoc value.
	NwkGeoLoc bool

	// The PRAllowed value that describes whether passive roaming is allowed.
	PrAllowed bool

	// The RAAllowed value that describes whether roaming activation is allowed.
	RaAllowed bool

	// The ReportDevStatusBattery value.
	ReportDevStatusBattery bool

	// The ReportDevStatusMargin value.
	ReportDevStatusMargin bool

	// The TargetPER value.
	TargetPer int32

	// The ULBucketSize value.
	UlBucketSize *int32

	// The ULRate value.
	UlRate *int32

	// The ULRatePolicy value.
	UlRatePolicy *string

	noSmithyDocumentSerde
}

// Object for LoRaWAN join resource type event configuration.
type LoRaWANJoinEventNotificationConfigurations struct {

	// Denotes whether the Dev EUI join event topic is enabled or disabled.
	DevEuiEventTopic EventNotificationTopicStatus

	noSmithyDocumentSerde
}

// Object for LoRaWAN join resource type event configuration.
type LoRaWANJoinResourceTypeEventConfiguration struct {

	// Denotes whether the wireless device join event topic is enabled or disabled.
	WirelessDeviceEventTopic EventNotificationTopicStatus

	noSmithyDocumentSerde
}

// LoRaWAN object for list functions.
type LoRaWANListDevice struct {

	// The DevEUI value.
	DevEui *string

	noSmithyDocumentSerde
}

// The LoRaWAN information that is to be used with the multicast group.
type LoRaWANMulticast struct {

	// DlClass for LoRaWAM, valid values are ClassB and ClassC.
	DlClass DlClass

	// Supported RfRegions
	RfRegion SupportedRfRegion

	noSmithyDocumentSerde
}

// The LoRaWAN information that is to be returned from getting multicast group
// information.
type LoRaWANMulticastGet struct {

	// DlClass for LoRaWAM, valid values are ClassB and ClassC.
	DlClass DlClass

	// Number of devices that are associated to the multicast group.
	NumberOfDevicesInGroup *int32

	// Number of devices that are requested to be associated with the multicast group.
	NumberOfDevicesRequested *int32

	// Supported RfRegions
	RfRegion SupportedRfRegion

	noSmithyDocumentSerde
}

// The metadata information of the LoRaWAN multicast group.
type LoRaWANMulticastMetadata struct {

	// The Fport value.
	FPort *int32

	noSmithyDocumentSerde
}

// The LoRaWAN information used with the multicast session.
type LoRaWANMulticastSession struct {

	// Downlink data rate.
	DlDr *int32

	// Downlink frequency.
	DlFreq *int32

	// Timestamp of when the multicast group session is to start.
	SessionStartTime *time.Time

	// How long before a multicast group session is to timeout.
	SessionTimeout *int32

	noSmithyDocumentSerde
}

// LoRaWAN router info.
type LoRaWANSendDataToDevice struct {

	// The Fport value.
	FPort *int32

	// Choose the gateways that you want to use for the downlink data traffic when the
	// wireless device is running in class B or class C mode.
	ParticipatingGateways *ParticipatingGateways

	noSmithyDocumentSerde
}

// LoRaWANServiceProfile object.
type LoRaWANServiceProfile struct {

	// The AddGWMetaData value.
	AddGwMetadata bool

	// The DrMax value.
	DrMax *int32

	// The DrMin value.
	DrMin *int32

	noSmithyDocumentSerde
}

// The LoRaWAN information used to start a FUOTA task.
type LoRaWANStartFuotaTask struct {

	// Start time of a FUOTA task.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// LoRaWAN object for update functions.
type LoRaWANUpdateDevice struct {

	// ABP device object for update APIs for v1.0.x
	AbpV1_0_x *UpdateAbpV1_0_x

	// ABP device object for update APIs for v1.1
	AbpV1_1 *UpdateAbpV1_1

	// The ID of the device profile for the wireless device.
	DeviceProfileId *string

	// FPorts object for the positioning information of the device.
	FPorts *UpdateFPorts

	// The ID of the service profile.
	ServiceProfileId *string

	noSmithyDocumentSerde
}

// LoRaWANUpdateGatewayTaskCreate object.
type LoRaWANUpdateGatewayTaskCreate struct {

	// The version of the gateways that should receive the update.
	CurrentVersion *LoRaWANGatewayVersion

	// The CRC of the signature private key to check.
	SigKeyCrc *int64

	// The signature used to verify the update firmware.
	UpdateSignature *string

	// The firmware version to update the gateway to.
	UpdateVersion *LoRaWANGatewayVersion

	noSmithyDocumentSerde
}

// LoRaWANUpdateGatewayTaskEntry object.
type LoRaWANUpdateGatewayTaskEntry struct {

	// The version of the gateways that should receive the update.
	CurrentVersion *LoRaWANGatewayVersion

	// The firmware version to update the gateway to.
	UpdateVersion *LoRaWANGatewayVersion

	noSmithyDocumentSerde
}

// Message delivery status event configuration object for enabling and disabling
// relevant topics.
type MessageDeliveryStatusEventConfiguration struct {

	// SidewalkEventNotificationConfigurations object, which is the event configuration
	// object for Sidewalk-related event topics.
	Sidewalk *SidewalkEventNotificationConfigurations

	// Denotes whether the wireless device ID device registration state event topic is
	// enabled or disabled.
	WirelessDeviceIdEventTopic EventNotificationTopicStatus

	noSmithyDocumentSerde
}

// Message delivery status resource type event configuration object for enabling or
// disabling relevant topic.
type MessageDeliveryStatusResourceTypeEventConfiguration struct {

	// Sidewalk resource type event configuration object for enabling or disabling
	// topic.
	Sidewalk *SidewalkResourceTypeEventConfiguration

	noSmithyDocumentSerde
}

// A multicast group.
type MulticastGroup struct {

	// The arn of the multicast group.
	Arn *string

	// The ID of the multicast group.
	Id *string

	// The name of the multicast group.
	Name *string

	noSmithyDocumentSerde
}

// A multicast group that is associated with a FUOTA task.
type MulticastGroupByFuotaTask struct {

	// The ID of the multicast group.
	Id *string

	noSmithyDocumentSerde
}

// Wireless metadata that is to be sent to multicast group.
type MulticastWirelessMetadata struct {

	// The metadata information of the LoRaWAN multicast group.
	LoRaWAN *LoRaWANMulticastMetadata

	noSmithyDocumentSerde
}

// Network analyzer configurations.
type NetworkAnalyzerConfigurations struct {

	// The Amazon Resource Name of the new resource.
	Arn *string

	// Name of the network analyzer configuration.
	Name *string

	noSmithyDocumentSerde
}

// OTAA device object for v1.0.x
type OtaaV1_0_x struct {

	// The AppEUI value.
	AppEui *string

	// The AppKey value.
	AppKey *string

	// The GenAppKey value.
	GenAppKey *string

	noSmithyDocumentSerde
}

// OTAA device object for v1.1
type OtaaV1_1 struct {

	// The AppKey value.
	AppKey *string

	// The JoinEUI value.
	JoinEui *string

	// The NwkKey value.
	NwkKey *string

	noSmithyDocumentSerde
}

// Specify the list of gateways to which you want to send downlink data traffic
// when the wireless device is running in class B or class C mode.
type ParticipatingGateways struct {

	// Indicates whether to send the downlink message in sequential mode or concurrent
	// mode, or to use only the chosen gateways from the previous uplink message
	// transmission.
	//
	// This member is required.
	DownlinkMode DownlinkMode

	// The list of gateways that you want to use for sending the downlink data traffic.
	//
	// This member is required.
	GatewayList []GatewayListItem

	// The duration of time for which AWS IoT Core for LoRaWAN will wait before
	// transmitting the payload to the next gateway.
	//
	// This member is required.
	TransmissionInterval *int32

	noSmithyDocumentSerde
}

// The wrapper for a position configuration.
type PositionConfigurationItem struct {

	// The position data destination that describes the AWS IoT rule that processes the
	// device's position data for use by AWS IoT Core for LoRaWAN.
	Destination *string

	// Resource identifier for the position configuration.
	ResourceIdentifier *string

	// Resource type of the resource for the position configuration.
	ResourceType PositionResourceType

	// The details of the positioning solver object used to compute the location.
	Solvers *PositionSolverDetails

	noSmithyDocumentSerde
}

// The FPorts for the position information.
type Positioning struct {

	// The Fport value.
	ClockSync *int32

	// The Fport value.
	Gnss *int32

	// The Fport value.
	Stream *int32

	noSmithyDocumentSerde
}

// The wrapper for position solver configurations.
type PositionSolverConfigurations struct {

	// The Semtech GNSS solver configuration object.
	SemtechGnss *SemtechGnssConfiguration

	noSmithyDocumentSerde
}

// The wrapper for position solver details.
type PositionSolverDetails struct {

	// The Semtech GNSS solver object details.
	SemtechGnss *SemtechGnssDetail

	noSmithyDocumentSerde
}

// Proximity event configuration object for enabling and disabling relevant topics.
type ProximityEventConfiguration struct {

	// Proximity event configuration object for enabling or disabling Sidewalk related
	// event topics.
	Sidewalk *SidewalkEventNotificationConfigurations

	// Denotes whether the wireless device ID proximity event topic is enabled or
	// disabled.
	WirelessDeviceIdEventTopic EventNotificationTopicStatus

	noSmithyDocumentSerde
}

// Proximity resource type event configuration object for enabling or disabling
// topic.
type ProximityResourceTypeEventConfiguration struct {

	// Proximity resource type event configuration object for enabling and disabling
	// wireless device topic.
	Sidewalk *SidewalkResourceTypeEventConfiguration

	noSmithyDocumentSerde
}

// Information about the Semtech GNSS solver configuration.
type SemtechGnssConfiguration struct {

	// Whether forward error correction is enabled.
	//
	// This member is required.
	Fec PositionConfigurationFec

	// The status indicating whether the solver is enabled.
	//
	// This member is required.
	Status PositionConfigurationStatus

	noSmithyDocumentSerde
}

// Details of the Semtech GNSS solver object.
type SemtechGnssDetail struct {

	// Whether forward error correction is enabled.
	Fec PositionConfigurationFec

	// The vendor of the solver object.
	Provider PositionSolverProvider

	// The status indicating whether the solver is enabled.
	Status PositionConfigurationStatus

	// The type of positioning solver used.
	Type PositionSolverType

	noSmithyDocumentSerde
}

// Information about a service profile.
type ServiceProfile struct {

	// The Amazon Resource Name of the resource.
	Arn *string

	// The ID of the service profile.
	Id *string

	// The name of the resource.
	Name *string

	noSmithyDocumentSerde
}

// Session keys for ABP v1.1
type SessionKeysAbpV1_0_x struct {

	// The AppSKey value.
	AppSKey *string

	// The NwkSKey value.
	NwkSKey *string

	noSmithyDocumentSerde
}

// Session keys for ABP v1.1
type SessionKeysAbpV1_1 struct {

	// The AppSKey value.
	AppSKey *string

	// The FNwkSIntKey value.
	FNwkSIntKey *string

	// The NwkSEncKey value.
	NwkSEncKey *string

	// The SNwkSIntKey value.
	SNwkSIntKey *string

	noSmithyDocumentSerde
}

// Information about a Sidewalk account.
type SidewalkAccountInfo struct {

	// The Sidewalk Amazon ID.
	AmazonId *string

	// The Sidewalk application server private key.
	AppServerPrivateKey *string

	noSmithyDocumentSerde
}

// Information about a Sidewalk account.
type SidewalkAccountInfoWithFingerprint struct {

	// The Sidewalk Amazon ID.
	AmazonId *string

	// The Amazon Resource Name of the resource.
	Arn *string

	// The fingerprint of the Sidewalk application server private key.
	Fingerprint *string

	noSmithyDocumentSerde
}

// Sidewalk device object.
type SidewalkDevice struct {

	// The Sidewalk Amazon ID.
	AmazonId *string

	// The sidewalk device certificates for Ed25519 and P256r1.
	DeviceCertificates []CertificateList

	// The sidewalk device identification.
	SidewalkId *string

	// The Sidewalk manufacturing series number.
	SidewalkManufacturingSn *string

	noSmithyDocumentSerde
}

// MetaData for Sidewalk device.
type SidewalkDeviceMetadata struct {

	// Sidewalk device battery level.
	BatteryLevel BatteryLevel

	// Device state defines the device status of sidewalk device.
	DeviceState DeviceState

	// Sidewalk device status notification.
	Event Event

	// The RSSI value.
	Rssi *int32

	noSmithyDocumentSerde
}

// SidewalkEventNotificationConfigurations object, which is the event configuration
// object for Sidewalk-related event topics.
type SidewalkEventNotificationConfigurations struct {

	// Denotes whether the Amazon ID event topic is enabled or disabled.
	AmazonIdEventTopic EventNotificationTopicStatus

	noSmithyDocumentSerde
}

// Sidewalk object used by list functions.
type SidewalkListDevice struct {

	// The Sidewalk Amazon ID.
	AmazonId *string

	// The sidewalk device certificates for Ed25519 and P256r1.
	DeviceCertificates []CertificateList

	// The sidewalk device identification.
	SidewalkId *string

	// The Sidewalk manufacturing series number.
	SidewalkManufacturingSn *string

	noSmithyDocumentSerde
}

// Sidewalk resource type event configuration object for enabling or disabling
// topic.
type SidewalkResourceTypeEventConfiguration struct {

	// Denotes whether the wireless device join event topic is enabled or disabled.
	WirelessDeviceEventTopic EventNotificationTopicStatus

	noSmithyDocumentSerde
}

// Information about a Sidewalk router.
type SidewalkSendDataToDevice struct {

	// The duration of time in seconds for which you want to retry sending the ACK.
	AckModeRetryDurationSecs *int32

	// Sidewalk device message type. Default value is CUSTOM_COMMAND_ID_NOTIFY.
	MessageType MessageType

	// The sequence number.
	Seq *int32

	noSmithyDocumentSerde
}

// Sidewalk update.
type SidewalkUpdateAccount struct {

	// The new Sidewalk application server private key.
	AppServerPrivateKey *string

	noSmithyDocumentSerde
}

// A simple label consisting of a customer-defined key-value pair
type Tag struct {

	// The tag's key value.
	//
	// This member is required.
	Key *string

	// The tag's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Trace content for your wireless gateway and wireless device resources.
type TraceContent struct {

	// The log level for a log message. The log levels can be disabled, or set to ERROR
	// to display less verbose logs containing only error information, or to INFO for
	// more detailed logs.
	LogLevel LogLevel

	// FrameInfo of your wireless device resources for the trace content. Use FrameInfo
	// to debug the communication between your LoRaWAN end devices and the network
	// server.
	WirelessDeviceFrameInfo WirelessDeviceFrameInfo

	noSmithyDocumentSerde
}

// ABP device object for LoRaWAN specification v1.0.x
type UpdateAbpV1_0_x struct {

	// The FCnt init value.
	FCntStart *int32

	noSmithyDocumentSerde
}

// ABP device object for LoRaWAN specification v1.1
type UpdateAbpV1_1 struct {

	// The FCnt init value.
	FCntStart *int32

	noSmithyDocumentSerde
}

// Object for updating the FPorts information.
type UpdateFPorts struct {

	// Positioning FPorts for the ClockSync, Stream, and GNSS functions.
	Positioning *Positioning

	noSmithyDocumentSerde
}

// UpdateWirelessGatewayTaskCreate object.
type UpdateWirelessGatewayTaskCreate struct {

	// The properties that relate to the LoRaWAN wireless gateway.
	LoRaWAN *LoRaWANUpdateGatewayTaskCreate

	// The IAM role used to read data from the S3 bucket.
	UpdateDataRole *string

	// The link to the S3 bucket.
	UpdateDataSource *string

	noSmithyDocumentSerde
}

// UpdateWirelessGatewayTaskEntry object.
type UpdateWirelessGatewayTaskEntry struct {

	// The Amazon Resource Name of the resource.
	Arn *string

	// The ID of the new wireless gateway task entry.
	Id *string

	// The properties that relate to the LoRaWAN wireless gateway.
	LoRaWAN *LoRaWANUpdateGatewayTaskEntry

	noSmithyDocumentSerde
}

// The log options for a wireless device event and can be used to set log levels
// for a specific wireless device event. For a LoRaWAN device, possible events for
// a log messsage are: Join, Rejoin, Downlink_Data, and Uplink_Data. For a Sidewalk
// device, possible events for a log message are Registration, Downlink_Data, and
// Uplink_Data.
type WirelessDeviceEventLogOption struct {

	// The event for a log message, if the log message is tied to a wireless device.
	//
	// This member is required.
	Event WirelessDeviceEvent

	// The log level for a log message. The log levels can be disabled, or set to ERROR
	// to display less verbose logs containing only error information, or to INFO for
	// more detailed logs.
	//
	// This member is required.
	LogLevel LogLevel

	noSmithyDocumentSerde
}

// The log options for wireless devices and can be used to set log levels for a
// specific type of wireless device.
type WirelessDeviceLogOption struct {

	// The log level for a log message. The log levels can be disabled, or set to ERROR
	// to display less verbose logs containing only error information, or to INFO for
	// more detailed logs.
	//
	// This member is required.
	LogLevel LogLevel

	// The wireless device type.
	//
	// This member is required.
	Type WirelessDeviceType

	// The list of wireless device event log options.
	Events []WirelessDeviceEventLogOption

	noSmithyDocumentSerde
}

// Information about a wireless device's operation.
type WirelessDeviceStatistics struct {

	// The Amazon Resource Name of the resource.
	Arn *string

	// The name of the destination to which the device is assigned.
	DestinationName *string

	// The status of a wireless device in a FUOTA task.
	FuotaDeviceStatus FuotaDeviceStatus

	// The ID of the wireless device reporting the data.
	Id *string

	// The date and time when the most recent uplink was received.
	LastUplinkReceivedAt *string

	// LoRaWAN device info.
	LoRaWAN *LoRaWANListDevice

	// Id of the multicast group.
	McGroupId *int32

	// The status of the wireless device in the multicast group.
	MulticastDeviceStatus *string

	// The name of the resource.
	Name *string

	// The Sidewalk account credentials.
	Sidewalk *SidewalkListDevice

	// The wireless device type.
	Type WirelessDeviceType

	noSmithyDocumentSerde
}

// The log options for a wireless gateway event and can be used to set log levels
// for a specific wireless gateway event. For a LoRaWAN gateway, possible events
// for a log message are CUPS_Request and Certificate.
type WirelessGatewayEventLogOption struct {

	// The event for a log message, if the log message is tied to a wireless gateway.
	//
	// This member is required.
	Event WirelessGatewayEvent

	// The log level for a log message. The log levels can be disabled, or set to ERROR
	// to display less verbose logs containing only error information, or to INFO for
	// more detailed logs.
	//
	// This member is required.
	LogLevel LogLevel

	noSmithyDocumentSerde
}

// The log options for wireless gateways and can be used to set log levels for a
// specific type of wireless gateway.
type WirelessGatewayLogOption struct {

	// The log level for a log message. The log levels can be disabled, or set to ERROR
	// to display less verbose logs containing only error information, or to INFO for
	// more detailed logs.
	//
	// This member is required.
	LogLevel LogLevel

	// The wireless gateway type.
	//
	// This member is required.
	Type WirelessGatewayType

	// The list of wireless gateway event log options.
	Events []WirelessGatewayEventLogOption

	noSmithyDocumentSerde
}

// Information about a wireless gateway's operation.
type WirelessGatewayStatistics struct {

	// The Amazon Resource Name of the resource.
	Arn *string

	// The description of the resource.
	Description *string

	// The ID of the wireless gateway reporting the data.
	Id *string

	// The date and time when the most recent uplink was received.
	LastUplinkReceivedAt *string

	// LoRaWAN gateway info.
	LoRaWAN *LoRaWANGateway

	// The name of the resource.
	Name *string

	noSmithyDocumentSerde
}

// WirelessMetadata object.
type WirelessMetadata struct {

	// LoRaWAN device info.
	LoRaWAN *LoRaWANSendDataToDevice

	// The Sidewalk account credentials.
	Sidewalk *SidewalkSendDataToDevice

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
