// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information of a test device. A thing ARN or a certificate ARN is required.
type DeviceUnderTest struct {

	// Lists devices certificate ARN.
	CertificateArn *string

	// Lists devices thing ARN.
	ThingArn *string

	noSmithyDocumentSerde
}

// Show Group Result.
type GroupResult struct {

	// Group result ID.
	GroupId *string

	// Group Result Name.
	GroupName *string

	// Tests under Group Result.
	Tests []TestCaseRun

	noSmithyDocumentSerde
}

// Gets Suite Definition Configuration.
type SuiteDefinitionConfiguration struct {

	// Gets the device permission ARN.
	DevicePermissionRoleArn *string

	// Gets the devices configured.
	Devices []DeviceUnderTest

	// Gets the tests intended for qualification in a suite.
	IntendedForQualification bool

	// Verifies if the test suite is a long duration test.
	IsLongDurationTest bool

	// Gets the MQTT protocol that is configured in the suite definition.
	Protocol Protocol

	// Gets test suite root group.
	RootGroup *string

	// Gets Suite Definition Configuration name.
	SuiteDefinitionName *string

	noSmithyDocumentSerde
}

// Information about the suite definition.
type SuiteDefinitionInformation struct {

	// Date (in Unix epoch time) when the test suite was created.
	CreatedAt *time.Time

	// Specifies the devices that are under test for the test suite.
	DefaultDevices []DeviceUnderTest

	// Specifies if the test suite is intended for qualification.
	IntendedForQualification bool

	// Verifies if the test suite is a long duration test.
	IsLongDurationTest bool

	// Gets the MQTT protocol that is configured in the suite definition.
	Protocol Protocol

	// Suite definition ID of the test suite.
	SuiteDefinitionId *string

	// Suite name of the test suite.
	SuiteDefinitionName *string

	noSmithyDocumentSerde
}

// Gets suite run configuration.
type SuiteRunConfiguration struct {

	// TRUE if multiple test suites run in parallel.
	ParallelRun bool

	// Gets the primary device for suite run.
	PrimaryDevice *DeviceUnderTest

	// Gets test case list.
	SelectedTestList []string

	noSmithyDocumentSerde
}

// Information about the suite run. Requires permission to access the
// SuiteRunInformation
// (https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions)
// action.
type SuiteRunInformation struct {

	// Date (in Unix epoch time) when the suite run was created.
	CreatedAt *time.Time

	// Date (in Unix epoch time) when the suite run ended.
	EndAt *time.Time

	// Number of test cases that failed in the suite run.
	Failed int32

	// Number of test cases that passed in the suite run.
	Passed int32

	// Date (in Unix epoch time) when the suite run was started.
	StartedAt *time.Time

	// Status of the suite run.
	Status SuiteRunStatus

	// Suite definition ID of the suite run.
	SuiteDefinitionId *string

	// Suite definition name of the suite run.
	SuiteDefinitionName *string

	// Suite definition version of the suite run.
	SuiteDefinitionVersion *string

	// Suite run ID of the suite run.
	SuiteRunId *string

	noSmithyDocumentSerde
}

// Provides the test case run.
type TestCaseRun struct {

	// Provides test case run end time.
	EndTime *time.Time

	// Provides test case run failure result.
	Failure *string

	// Provides test case run log URL.
	LogUrl *string

	// Provides test case run start time.
	StartTime *time.Time

	// Provides the test case run status. Status is one of the following:
	//
	// * PASS: Test
	// passed.
	//
	// * FAIL: Test failed.
	//
	// * PENDING: Test has not started running but is
	// scheduled.
	//
	// * RUNNING: Test is running.
	//
	// * STOPPING: Test is performing cleanup
	// steps. You will see this status only if you stop a suite run.
	//
	// * STOPPED Test is
	// stopped. You will see this status only if you stop a suite run.
	//
	// *
	// PASS_WITH_WARNINGS: Test passed with warnings.
	//
	// * ERORR: Test faced an error
	// when running due to an internal issue.
	Status Status

	// Provides the test case run definition ID.
	TestCaseDefinitionId *string

	// Provides the test case run definition name.
	TestCaseDefinitionName *string

	// Provides the test case run ID.
	TestCaseRunId *string

	// Provides the test scenarios for the test case run.
	TestScenarios []TestCaseScenario

	// Provides test case run warnings.
	Warnings *string

	noSmithyDocumentSerde
}

// Provides test case scenario.
type TestCaseScenario struct {

	// Provides test case scenario failure result.
	Failure *string

	// Provides the test case scenario status. Status is one of the following:
	//
	// * PASS:
	// Test passed.
	//
	// * FAIL: Test failed.
	//
	// * PENDING: Test has not started running but
	// is scheduled.
	//
	// * RUNNING: Test is running.
	//
	// * STOPPING: Test is performing
	// cleanup steps. You will see this status only if you stop a suite run.
	//
	// * STOPPED
	// Test is stopped. You will see this status only if you stop a suite run.
	//
	// *
	// PASS_WITH_WARNINGS: Test passed with warnings.
	//
	// * ERORR: Test faced an error
	// when running due to an internal issue.
	Status TestCaseScenarioStatus

	//
	SystemMessage *string

	// Provides test case scenario ID.
	TestCaseScenarioId *string

	// Provides test case scenario type. Type is one of the following:
	//
	// * Advanced
	//
	// *
	// Basic
	TestCaseScenarioType TestCaseScenarioType

	noSmithyDocumentSerde
}

// Show each group result.
type TestResult struct {

	// Show each group of test results.
	Groups []GroupResult

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
