// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticloadbalancing

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/query"
	"github.com/aws/aws-sdk-go-v2/service/elasticloadbalancing/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsquery_serializeOpAddTags struct {
}

func (*awsAwsquery_serializeOpAddTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAddTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AddTags")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentAddTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpApplySecurityGroupsToLoadBalancer struct {
}

func (*awsAwsquery_serializeOpApplySecurityGroupsToLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpApplySecurityGroupsToLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ApplySecurityGroupsToLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ApplySecurityGroupsToLoadBalancer")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentApplySecurityGroupsToLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpAttachLoadBalancerToSubnets struct {
}

func (*awsAwsquery_serializeOpAttachLoadBalancerToSubnets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAttachLoadBalancerToSubnets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachLoadBalancerToSubnetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachLoadBalancerToSubnets")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentAttachLoadBalancerToSubnetsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpConfigureHealthCheck struct {
}

func (*awsAwsquery_serializeOpConfigureHealthCheck) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpConfigureHealthCheck) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConfigureHealthCheckInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ConfigureHealthCheck")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentConfigureHealthCheckInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateAppCookieStickinessPolicy struct {
}

func (*awsAwsquery_serializeOpCreateAppCookieStickinessPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateAppCookieStickinessPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAppCookieStickinessPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateAppCookieStickinessPolicy")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentCreateAppCookieStickinessPolicyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateLBCookieStickinessPolicy struct {
}

func (*awsAwsquery_serializeOpCreateLBCookieStickinessPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateLBCookieStickinessPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLBCookieStickinessPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateLBCookieStickinessPolicy")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentCreateLBCookieStickinessPolicyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateLoadBalancer struct {
}

func (*awsAwsquery_serializeOpCreateLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateLoadBalancer")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentCreateLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateLoadBalancerListeners struct {
}

func (*awsAwsquery_serializeOpCreateLoadBalancerListeners) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateLoadBalancerListeners) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLoadBalancerListenersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateLoadBalancerListeners")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentCreateLoadBalancerListenersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateLoadBalancerPolicy struct {
}

func (*awsAwsquery_serializeOpCreateLoadBalancerPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateLoadBalancerPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLoadBalancerPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateLoadBalancerPolicy")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentCreateLoadBalancerPolicyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteLoadBalancer struct {
}

func (*awsAwsquery_serializeOpDeleteLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteLoadBalancer")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDeleteLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteLoadBalancerListeners struct {
}

func (*awsAwsquery_serializeOpDeleteLoadBalancerListeners) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteLoadBalancerListeners) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLoadBalancerListenersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteLoadBalancerListeners")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDeleteLoadBalancerListenersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteLoadBalancerPolicy struct {
}

func (*awsAwsquery_serializeOpDeleteLoadBalancerPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteLoadBalancerPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLoadBalancerPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteLoadBalancerPolicy")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDeleteLoadBalancerPolicyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeregisterInstancesFromLoadBalancer struct {
}

func (*awsAwsquery_serializeOpDeregisterInstancesFromLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeregisterInstancesFromLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterInstancesFromLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeregisterInstancesFromLoadBalancer")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDeregisterInstancesFromLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeAccountLimits struct {
}

func (*awsAwsquery_serializeOpDescribeAccountLimits) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeAccountLimits) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountLimitsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAccountLimits")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDescribeAccountLimitsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeInstanceHealth struct {
}

func (*awsAwsquery_serializeOpDescribeInstanceHealth) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeInstanceHealth) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceHealthInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceHealth")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDescribeInstanceHealthInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLoadBalancerAttributes struct {
}

func (*awsAwsquery_serializeOpDescribeLoadBalancerAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLoadBalancerAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoadBalancerAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLoadBalancerAttributes")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDescribeLoadBalancerAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLoadBalancerPolicies struct {
}

func (*awsAwsquery_serializeOpDescribeLoadBalancerPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLoadBalancerPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoadBalancerPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLoadBalancerPolicies")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDescribeLoadBalancerPoliciesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLoadBalancerPolicyTypes struct {
}

func (*awsAwsquery_serializeOpDescribeLoadBalancerPolicyTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLoadBalancerPolicyTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoadBalancerPolicyTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLoadBalancerPolicyTypes")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDescribeLoadBalancerPolicyTypesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeLoadBalancers struct {
}

func (*awsAwsquery_serializeOpDescribeLoadBalancers) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeLoadBalancers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoadBalancersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLoadBalancers")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDescribeLoadBalancersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDescribeTags struct {
}

func (*awsAwsquery_serializeOpDescribeTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDescribeTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTags")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDescribeTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDetachLoadBalancerFromSubnets struct {
}

func (*awsAwsquery_serializeOpDetachLoadBalancerFromSubnets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDetachLoadBalancerFromSubnets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachLoadBalancerFromSubnetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachLoadBalancerFromSubnets")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDetachLoadBalancerFromSubnetsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDisableAvailabilityZonesForLoadBalancer struct {
}

func (*awsAwsquery_serializeOpDisableAvailabilityZonesForLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDisableAvailabilityZonesForLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableAvailabilityZonesForLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableAvailabilityZonesForLoadBalancer")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentDisableAvailabilityZonesForLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpEnableAvailabilityZonesForLoadBalancer struct {
}

func (*awsAwsquery_serializeOpEnableAvailabilityZonesForLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpEnableAvailabilityZonesForLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableAvailabilityZonesForLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableAvailabilityZonesForLoadBalancer")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentEnableAvailabilityZonesForLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpModifyLoadBalancerAttributes struct {
}

func (*awsAwsquery_serializeOpModifyLoadBalancerAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpModifyLoadBalancerAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyLoadBalancerAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyLoadBalancerAttributes")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentModifyLoadBalancerAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRegisterInstancesWithLoadBalancer struct {
}

func (*awsAwsquery_serializeOpRegisterInstancesWithLoadBalancer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRegisterInstancesWithLoadBalancer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterInstancesWithLoadBalancerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RegisterInstancesWithLoadBalancer")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentRegisterInstancesWithLoadBalancerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRemoveTags struct {
}

func (*awsAwsquery_serializeOpRemoveTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRemoveTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemoveTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RemoveTags")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentRemoveTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetLoadBalancerListenerSSLCertificate struct {
}

func (*awsAwsquery_serializeOpSetLoadBalancerListenerSSLCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetLoadBalancerListenerSSLCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetLoadBalancerListenerSSLCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetLoadBalancerListenerSSLCertificate")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentSetLoadBalancerListenerSSLCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetLoadBalancerPoliciesForBackendServer struct {
}

func (*awsAwsquery_serializeOpSetLoadBalancerPoliciesForBackendServer) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetLoadBalancerPoliciesForBackendServer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetLoadBalancerPoliciesForBackendServerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetLoadBalancerPoliciesForBackendServer")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentSetLoadBalancerPoliciesForBackendServerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetLoadBalancerPoliciesOfListener struct {
}

func (*awsAwsquery_serializeOpSetLoadBalancerPoliciesOfListener) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetLoadBalancerPoliciesOfListener) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetLoadBalancerPoliciesOfListenerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetLoadBalancerPoliciesOfListener")
	body.Key("Version").String("2012-06-01")

	if err := awsAwsquery_serializeOpDocumentSetLoadBalancerPoliciesOfListenerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsquery_serializeDocumentAccessLog(v *types.AccessLog, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EmitInterval != nil {
		objectKey := object.Key("EmitInterval")
		objectKey.Integer(*v.EmitInterval)
	}

	{
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	if v.S3BucketName != nil {
		objectKey := object.Key("S3BucketName")
		objectKey.String(*v.S3BucketName)
	}

	if v.S3BucketPrefix != nil {
		objectKey := object.Key("S3BucketPrefix")
		objectKey.String(*v.S3BucketPrefix)
	}

	return nil
}

func awsAwsquery_serializeDocumentAdditionalAttribute(v *types.AdditionalAttribute, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentAdditionalAttributes(v []types.AdditionalAttribute, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentAdditionalAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentAvailabilityZones(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentConnectionDraining(v *types.ConnectionDraining, value query.Value) error {
	object := value.Object()
	_ = object

	{
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	if v.Timeout != nil {
		objectKey := object.Key("Timeout")
		objectKey.Integer(*v.Timeout)
	}

	return nil
}

func awsAwsquery_serializeDocumentConnectionSettings(v *types.ConnectionSettings, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IdleTimeout != nil {
		objectKey := object.Key("IdleTimeout")
		objectKey.Integer(*v.IdleTimeout)
	}

	return nil
}

func awsAwsquery_serializeDocumentCrossZoneLoadBalancing(v *types.CrossZoneLoadBalancing, value query.Value) error {
	object := value.Object()
	_ = object

	{
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsAwsquery_serializeDocumentHealthCheck(v *types.HealthCheck, value query.Value) error {
	object := value.Object()
	_ = object

	{
		objectKey := object.Key("HealthyThreshold")
		objectKey.Integer(v.HealthyThreshold)
	}

	{
		objectKey := object.Key("Interval")
		objectKey.Integer(v.Interval)
	}

	if v.Target != nil {
		objectKey := object.Key("Target")
		objectKey.String(*v.Target)
	}

	{
		objectKey := object.Key("Timeout")
		objectKey.Integer(v.Timeout)
	}

	{
		objectKey := object.Key("UnhealthyThreshold")
		objectKey.Integer(v.UnhealthyThreshold)
	}

	return nil
}

func awsAwsquery_serializeDocumentInstance(v *types.Instance, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	return nil
}

func awsAwsquery_serializeDocumentInstances(v []types.Instance, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentInstance(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentListener(v *types.Listener, value query.Value) error {
	object := value.Object()
	_ = object

	{
		objectKey := object.Key("InstancePort")
		objectKey.Integer(v.InstancePort)
	}

	if v.InstanceProtocol != nil {
		objectKey := object.Key("InstanceProtocol")
		objectKey.String(*v.InstanceProtocol)
	}

	{
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(v.LoadBalancerPort)
	}

	if v.Protocol != nil {
		objectKey := object.Key("Protocol")
		objectKey.String(*v.Protocol)
	}

	if v.SSLCertificateId != nil {
		objectKey := object.Key("SSLCertificateId")
		objectKey.String(*v.SSLCertificateId)
	}

	return nil
}

func awsAwsquery_serializeDocumentListeners(v []types.Listener, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentListener(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentLoadBalancerAttributes(v *types.LoadBalancerAttributes, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AccessLog != nil {
		objectKey := object.Key("AccessLog")
		if err := awsAwsquery_serializeDocumentAccessLog(v.AccessLog, objectKey); err != nil {
			return err
		}
	}

	if v.AdditionalAttributes != nil {
		objectKey := object.Key("AdditionalAttributes")
		if err := awsAwsquery_serializeDocumentAdditionalAttributes(v.AdditionalAttributes, objectKey); err != nil {
			return err
		}
	}

	if v.ConnectionDraining != nil {
		objectKey := object.Key("ConnectionDraining")
		if err := awsAwsquery_serializeDocumentConnectionDraining(v.ConnectionDraining, objectKey); err != nil {
			return err
		}
	}

	if v.ConnectionSettings != nil {
		objectKey := object.Key("ConnectionSettings")
		if err := awsAwsquery_serializeDocumentConnectionSettings(v.ConnectionSettings, objectKey); err != nil {
			return err
		}
	}

	if v.CrossZoneLoadBalancing != nil {
		objectKey := object.Key("CrossZoneLoadBalancing")
		if err := awsAwsquery_serializeDocumentCrossZoneLoadBalancing(v.CrossZoneLoadBalancing, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentLoadBalancerNames(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentLoadBalancerNamesMax20(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentPolicyAttribute(v *types.PolicyAttribute, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AttributeName != nil {
		objectKey := object.Key("AttributeName")
		objectKey.String(*v.AttributeName)
	}

	if v.AttributeValue != nil {
		objectKey := object.Key("AttributeValue")
		objectKey.String(*v.AttributeValue)
	}

	return nil
}

func awsAwsquery_serializeDocumentPolicyAttributes(v []types.PolicyAttribute, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentPolicyAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentPolicyNames(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentPolicyTypeNames(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentPorts(v []int32, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentSecurityGroups(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentSubnets(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTag(v *types.Tag, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsAwsquery_serializeDocumentTagKeyList(v []types.TagKeyOnly, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentTagKeyOnly(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentTagKeyOnly(v *types.TagKeyOnly, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	return nil
}

func awsAwsquery_serializeDocumentTagList(v []types.Tag, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeOpDocumentAddTagsInput(v *AddTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerNames != nil {
		objectKey := object.Key("LoadBalancerNames")
		if err := awsAwsquery_serializeDocumentLoadBalancerNames(v.LoadBalancerNames, objectKey); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentApplySecurityGroupsToLoadBalancerInput(v *ApplySecurityGroupsToLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.SecurityGroups != nil {
		objectKey := object.Key("SecurityGroups")
		if err := awsAwsquery_serializeDocumentSecurityGroups(v.SecurityGroups, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentAttachLoadBalancerToSubnetsInput(v *AttachLoadBalancerToSubnetsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.Subnets != nil {
		objectKey := object.Key("Subnets")
		if err := awsAwsquery_serializeDocumentSubnets(v.Subnets, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentConfigureHealthCheckInput(v *ConfigureHealthCheckInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.HealthCheck != nil {
		objectKey := object.Key("HealthCheck")
		if err := awsAwsquery_serializeDocumentHealthCheck(v.HealthCheck, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateAppCookieStickinessPolicyInput(v *CreateAppCookieStickinessPolicyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CookieName != nil {
		objectKey := object.Key("CookieName")
		objectKey.String(*v.CookieName)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.PolicyName != nil {
		objectKey := object.Key("PolicyName")
		objectKey.String(*v.PolicyName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateLBCookieStickinessPolicyInput(v *CreateLBCookieStickinessPolicyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CookieExpirationPeriod != nil {
		objectKey := object.Key("CookieExpirationPeriod")
		objectKey.Long(*v.CookieExpirationPeriod)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.PolicyName != nil {
		objectKey := object.Key("PolicyName")
		objectKey.String(*v.PolicyName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateLoadBalancerInput(v *CreateLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZones != nil {
		objectKey := object.Key("AvailabilityZones")
		if err := awsAwsquery_serializeDocumentAvailabilityZones(v.AvailabilityZones, objectKey); err != nil {
			return err
		}
	}

	if v.Listeners != nil {
		objectKey := object.Key("Listeners")
		if err := awsAwsquery_serializeDocumentListeners(v.Listeners, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.Scheme != nil {
		objectKey := object.Key("Scheme")
		objectKey.String(*v.Scheme)
	}

	if v.SecurityGroups != nil {
		objectKey := object.Key("SecurityGroups")
		if err := awsAwsquery_serializeDocumentSecurityGroups(v.SecurityGroups, objectKey); err != nil {
			return err
		}
	}

	if v.Subnets != nil {
		objectKey := object.Key("Subnets")
		if err := awsAwsquery_serializeDocumentSubnets(v.Subnets, objectKey); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateLoadBalancerListenersInput(v *CreateLoadBalancerListenersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Listeners != nil {
		objectKey := object.Key("Listeners")
		if err := awsAwsquery_serializeDocumentListeners(v.Listeners, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateLoadBalancerPolicyInput(v *CreateLoadBalancerPolicyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.PolicyAttributes != nil {
		objectKey := object.Key("PolicyAttributes")
		if err := awsAwsquery_serializeDocumentPolicyAttributes(v.PolicyAttributes, objectKey); err != nil {
			return err
		}
	}

	if v.PolicyName != nil {
		objectKey := object.Key("PolicyName")
		objectKey.String(*v.PolicyName)
	}

	if v.PolicyTypeName != nil {
		objectKey := object.Key("PolicyTypeName")
		objectKey.String(*v.PolicyTypeName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteLoadBalancerInput(v *DeleteLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteLoadBalancerListenersInput(v *DeleteLoadBalancerListenersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.LoadBalancerPorts != nil {
		objectKey := object.Key("LoadBalancerPorts")
		if err := awsAwsquery_serializeDocumentPorts(v.LoadBalancerPorts, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteLoadBalancerPolicyInput(v *DeleteLoadBalancerPolicyInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.PolicyName != nil {
		objectKey := object.Key("PolicyName")
		objectKey.String(*v.PolicyName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeregisterInstancesFromLoadBalancerInput(v *DeregisterInstancesFromLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Instances != nil {
		objectKey := object.Key("Instances")
		if err := awsAwsquery_serializeDocumentInstances(v.Instances, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeAccountLimitsInput(v *DescribeAccountLimitsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.PageSize != nil {
		objectKey := object.Key("PageSize")
		objectKey.Integer(*v.PageSize)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeInstanceHealthInput(v *DescribeInstanceHealthInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Instances != nil {
		objectKey := object.Key("Instances")
		if err := awsAwsquery_serializeDocumentInstances(v.Instances, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeLoadBalancerAttributesInput(v *DescribeLoadBalancerAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeLoadBalancerPoliciesInput(v *DescribeLoadBalancerPoliciesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.PolicyNames != nil {
		objectKey := object.Key("PolicyNames")
		if err := awsAwsquery_serializeDocumentPolicyNames(v.PolicyNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeLoadBalancerPolicyTypesInput(v *DescribeLoadBalancerPolicyTypesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.PolicyTypeNames != nil {
		objectKey := object.Key("PolicyTypeNames")
		if err := awsAwsquery_serializeDocumentPolicyTypeNames(v.PolicyTypeNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeLoadBalancersInput(v *DescribeLoadBalancersInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerNames != nil {
		objectKey := object.Key("LoadBalancerNames")
		if err := awsAwsquery_serializeDocumentLoadBalancerNames(v.LoadBalancerNames, objectKey); err != nil {
			return err
		}
	}

	if v.Marker != nil {
		objectKey := object.Key("Marker")
		objectKey.String(*v.Marker)
	}

	if v.PageSize != nil {
		objectKey := object.Key("PageSize")
		objectKey.Integer(*v.PageSize)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDescribeTagsInput(v *DescribeTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerNames != nil {
		objectKey := object.Key("LoadBalancerNames")
		if err := awsAwsquery_serializeDocumentLoadBalancerNamesMax20(v.LoadBalancerNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDetachLoadBalancerFromSubnetsInput(v *DetachLoadBalancerFromSubnetsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.Subnets != nil {
		objectKey := object.Key("Subnets")
		if err := awsAwsquery_serializeDocumentSubnets(v.Subnets, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDisableAvailabilityZonesForLoadBalancerInput(v *DisableAvailabilityZonesForLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZones != nil {
		objectKey := object.Key("AvailabilityZones")
		if err := awsAwsquery_serializeDocumentAvailabilityZones(v.AvailabilityZones, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentEnableAvailabilityZonesForLoadBalancerInput(v *EnableAvailabilityZonesForLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZones != nil {
		objectKey := object.Key("AvailabilityZones")
		if err := awsAwsquery_serializeDocumentAvailabilityZones(v.AvailabilityZones, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentModifyLoadBalancerAttributesInput(v *ModifyLoadBalancerAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerAttributes != nil {
		objectKey := object.Key("LoadBalancerAttributes")
		if err := awsAwsquery_serializeDocumentLoadBalancerAttributes(v.LoadBalancerAttributes, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRegisterInstancesWithLoadBalancerInput(v *RegisterInstancesWithLoadBalancerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Instances != nil {
		objectKey := object.Key("Instances")
		if err := awsAwsquery_serializeDocumentInstances(v.Instances, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRemoveTagsInput(v *RemoveTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerNames != nil {
		objectKey := object.Key("LoadBalancerNames")
		if err := awsAwsquery_serializeDocumentLoadBalancerNames(v.LoadBalancerNames, objectKey); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		objectKey := object.Key("Tags")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetLoadBalancerListenerSSLCertificateInput(v *SetLoadBalancerListenerSSLCertificateInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	{
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(v.LoadBalancerPort)
	}

	if v.SSLCertificateId != nil {
		objectKey := object.Key("SSLCertificateId")
		objectKey.String(*v.SSLCertificateId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetLoadBalancerPoliciesForBackendServerInput(v *SetLoadBalancerPoliciesForBackendServerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstancePort != nil {
		objectKey := object.Key("InstancePort")
		objectKey.Integer(*v.InstancePort)
	}

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	if v.PolicyNames != nil {
		objectKey := object.Key("PolicyNames")
		if err := awsAwsquery_serializeDocumentPolicyNames(v.PolicyNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetLoadBalancerPoliciesOfListenerInput(v *SetLoadBalancerPoliciesOfListenerInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LoadBalancerName != nil {
		objectKey := object.Key("LoadBalancerName")
		objectKey.String(*v.LoadBalancerName)
	}

	{
		objectKey := object.Key("LoadBalancerPort")
		objectKey.Integer(v.LoadBalancerPort)
	}

	if v.PolicyNames != nil {
		objectKey := object.Key("PolicyNames")
		if err := awsAwsquery_serializeDocumentPolicyNames(v.PolicyNames, objectKey); err != nil {
			return err
		}
	}

	return nil
}
