// Code generated by smithy-go-codegen DO NOT EDIT.

package alexaforbusiness

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/alexaforbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Resets a device and its account to the known default settings. This clears all
// information and settings set by previous users in the following ways:
//
// *
// Bluetooth - This unpairs all bluetooth devices paired with your echo device.
//
// *
// Volume - This resets the echo device's volume to the default value.
//
// *
// Notifications - This clears all notifications from your echo device.
//
// * Lists -
// This clears all to-do items from your echo device.
//
// * Settings - This internally
// syncs the room's profile (if the device is assigned to a room), contacts,
// address books, delegation access for account linking, and communications (if
// enabled on the room profile).
func (c *Client) StartDeviceSync(ctx context.Context, params *StartDeviceSyncInput, optFns ...func(*Options)) (*StartDeviceSyncOutput, error) {
	if params == nil {
		params = &StartDeviceSyncInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartDeviceSync", params, optFns, c.addOperationStartDeviceSyncMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartDeviceSyncOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartDeviceSyncInput struct {

	// Request structure to start the device sync. Required.
	//
	// This member is required.
	Features []types.Feature

	// The ARN of the device to sync. Required.
	DeviceArn *string

	// The ARN of the room with which the device to sync is associated. Required.
	RoomArn *string

	noSmithyDocumentSerde
}

type StartDeviceSyncOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartDeviceSyncMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartDeviceSync{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartDeviceSync{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartDeviceSyncValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartDeviceSync(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartDeviceSync(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "a4b",
		OperationName: "StartDeviceSync",
	}
}
