.TH "Funções ZZ" 1 "" ""


.SH zzajuda

.nf
Mostra uma tela de ajuda com explicação e sintaxe de todas as funções.
Opções: --lista  lista de todas as funções, com sua descrição
      --uso    resumo de todas as funções, com a sintaxe de uso
Uso: zzajuda [--lista|--uso]
Ex.: zzajuda
   zzajuda --lista

.fi


.SH zzaleatorio

.nf
Gera um número aleatório.
Sem argumentos, comporta-se igual a $RANDOM.
Apenas um argumento, número entre 0 e o valor fornecido.
Com dois argumentos, número entre esses limites informados.

Uso: zzaleatorio [número] [número]
Ex.: zzaleatorio 10
   zzaleatorio 5 15
   zzaleatorio

.fi


.SH zzalfabeto

.nf
Central de alfabetos (romano, militar, radiotelefônico, OTAN, RAF, etc).
Obs.: Sem argumentos mostra a tabela completa, senão traduz uma palavra.

Tipos reconhecidos:

 --militar | --radio | --fone | --otan | --icao | --ansi
                                Radiotelefônico internacional
 --romano | --latino            A B C D E F...
 --royal-navy | --royal         Marinha Real - Reino Unido, 1914-1918
 --signalese | --western-front  Primeira Guerra, 1914-1918
 --raf24                        Força Aérea Real - Reino Unido, 1924-1942
 --raf42                        Força Aérea Real - Reino Unido, 1942-1943
 --raf | --raf43                Força Aérea Real - Reino Unido, 1943-1956
 --us | --us41                  Militar norte-americano, 1941-1956
 --portugal | --pt              Lugares de Portugal
 --name | --names               Nomes de pessoas, em inglês
 --lapd                         Polícia de Los Angeles (EUA)
 --morse                        Código Morse
 --german                       Nomes de pessoas, em alemão
 --all | --todos                Todos os códigos lado a lado

Uso: zzalfabeto [--TIPO] [palavra]
Ex.: zzalfabeto --militar
   zzalfabeto --militar cambio
   zzalfabeto --us --german prossiga

.fi


.SH zzalinhar

.nf
Alinha um texto a esquerda, direita, centro ou justificado.

As opções -l, --left, -e, --esquerda alinham as colunas a esquerda (padrão).
As opções -r, --right, -d, --direita alinham as colunas a direita.
As opções -c, --center, --centro centralizam as colunas.
A opção -j, --justify, --justificar faz o texto ocupar toda a linha.

As opções -w, --width, --largura seguido de um número,
determinam o tamanho da largura como base ao alinhamento.
Obs.: Onde a largura é maior do que a informada não é aplicado alinhamento.

Uso: zzalinhar [-l|-e|-r|-d|-c|-j] [-w <largura>] arquivo
Ex.: zzalinhar arquivo.txt
   zzalinhar -c -w 20 arquivo.txt
   zzalinhar -j arquivo.txt
   cat arquivo.txt | zzalinhar -r

.fi


.SH zzansi2html

.nf
Converte para HTML o texto colorido do terminal (códigos ANSI).
Útil para mostrar a saída do terminal em sites e blogs, sem perder as cores.
Obs.: Exemplos de texto ANSI estão na saída das funções zzcores e zzecho.
Obs.: Use o comando script para guardar a saída do terminal em um arquivo.
Uso: zzansi2html [arquivo]
Ex.: zzecho --letra verde -s -p -N testando | zzansi2html
   ls --color /etc | zzansi2html > ls.html
   zzcores | zzansi2html > cores.html

.fi


.SH zzarrumacidade

.nf
Arruma o nome da cidade informada: maiúsculas, abreviações, acentos, etc.

Uso: zzarrumacidade [cidade]
Ex.: zzarrumacidade SAO PAULO                     # São Paulo
   zzarrumacidade rj                            # Rio de Janeiro
   zzarrumacidade Floripa                       # Florianópolis
   echo Floripa | zzarrumacidade                # Florianópolis
   cat cidades.txt | zzarrumacidade             # [uma cidade por linha]

.fi


.SH zzarrumanome

.nf
Renomeia arquivos do diretório atual, arrumando nomes estranhos.
Obs.: Ele deixa tudo em minúsculas, retira acentuação e troca espaços em
    branco, símbolos e pontuação pelo sublinhado _.
Opções: -n  apenas mostra o que será feito, não executa
      -d  também renomeia diretórios
      -r  funcionamento recursivo (entra nos diretórios)
Uso: zzarrumanome [-n] [-d] [-r] arquivo(s)
Ex.: zzarrumanome *
   zzarrumanome -n -d -r .                   # tire o -n para renomear!
   zzarrumanome "DOCUMENTO MALÃO!.DOC"       # fica documento_malao.doc
   zzarrumanome "RAMONES - Don't Go.mp3"     # fica ramones-dont_go.mp3

.fi


.SH zzascii

.nf
Mostra a tabela ASCII com todos os caracteres imprimíveis (32-126,161-255).
O formato utilizando é: <decimal> <hexa> <octal> <caractere>.
O número de colunas e a largura da tabela são configuráveis.
Uso: zzascii [colunas] [largura]
Ex.: zzascii
   zzascii 4
   zzascii 7 100

.fi


.SH zzbeep

.nf
Aguarda N minutos e dispara uma sirene usando o 'speaker'.
Útil para lembrar de eventos próximos no mesmo dia.
Sem argumentos, restaura o 'beep' para o seu tom e duração originais.
Obs.: A sirene tem 4 toques, sendo 2 tons no modo texto e apenas 1 no Xterm.
Uso: zzbeep [números]
Ex.: zzbeep 0
   zzbeep 1 5 15    # espere 1 minuto, depois mais 5, e depois 15

.fi


.SH zzbicho

.nf
Jogo do bicho.
Com um número como argumento indica o bicho e o grupo.
Se o for um número entre 1 e 25 seguido de "g", lista os números do grupo.
Sem argumento ou com apenas "g" lista todos os grupos de bichos.

Uso: zzbicho [numero] [g]
Ex.: zzbicho 123456
   zzbicho 14 g
   zzbicho g

.fi


.SH zzbissexto

.nf
Diz se o ano informado é bissexto ou não.
Obs.: Se o ano não for informado, usa o atual.
Uso: zzbissexto [ano]
Ex.: zzbissexto
   zzbissexto 2000

.fi


.SH zzblist

.nf
Mostra se o IP informado está em alguma blacklist.
Uso: zzblist IP
Ex.: zzblist 200.199.198.197

.fi


.SH zzbraille

.nf
Grafia Braille.
A estrutura básica do alfabeto braille é composta por 2 colunas e 3 linhas.
Essa estrutura é chamada de célula Braille
E a sequência numérica padronizada é como segue:
 1 4
 2 5
 3 6
Assim fica como um guia, para quem desejar implantar essa acessibilidade.

Com a opção --s1 muda o símbolo ● (relevo, em destaque, cheio)
Com a opção --s2 muda o símbolo ○ (plano, sem destaque, vazio)

Abaixo de cada célula Braille, aparece o caractere correspondente.
Incluindo especiais de maiúscula, numérico, espaço, multi-células.
+++++ : Maiúsculo
+-    : Capitalize
__    : Espaço
##    : Número
-( X ): Caractere especial que ocupa mais de uma célula Braille

Atenção: Prefira usar ! em texto dentro de aspas simples (')

Uso: zzbraille <texto> [texto]
Ex.: zzbraille 'Olá mundo!'
   echo 'Good Morning, Vietnam!' | zzbraille --s2 ' '
   zzbraille --s1 O --s2 'X' 'Um texto qualquer'
   zzbraille --s1 . --s2 ' ' Mensagem

.fi


.SH zzbrasileirao

.nf
http://esporte.uol.com.br/
Mostra a tabela atualizada do Campeonato Brasileiro - Série A, B, C ou D.
Se for fornecido um numero mostra os jogos da rodada, com resultados.

Nomenclatura:
PG  - Pontos Ganhos
J   - Jogos
V   - Vitórias
E   - Empates
D   - Derrotas
GP  - Gols Pró
GC  - Gols Contra
SG  - Saldo de Gols
(%) - Aproveitamento (pontos)

Uso: zzbrasileirao [a|b|c|d] [numero rodada]
Ex.: zzbrasileirao
   zzbrasileirao a
   zzbrasileirao b
   zzbrasileirao c
   zzbrasileirao 27
   zzbrasileirao b 12

.fi


.SH zzbyte

.nf
Conversão entre grandezas de bytes (mega, giga, tera, etc).
Uso: zzbyte N [unidade-entrada] [unidade-saida]  # BKMGTPEZY
Ex.: zzbyte 2048                    # Quanto é 2048 bytes?  -- 2K
   zzbyte 2048 K                  # Quanto é 2048KB?      -- 2M
   zzbyte 7 K M                   # Quantos megas em 7KB? -- 0.006M
   zzbyte 7 G B                   # Quantos bytes em 7GB? -- 7516192768B
   for u in b k m g t p e z y; do zzbyte 2 t $u; done

.fi


.SH zzcalcula

.nf
Calculadora.
Wrapper para o comando bc, que funciona no formato brasileiro: 1.234,56.
Obs.: Números fracionados podem vir com vírgulas ou pontos: 1,5 ou 1.5.
Use a opção --soma para somar uma lista de números vindos da STDIN.

Uso: zzcalcula operação|--soma
Ex.: zzcalcula 2,20 + 3.30          # vírgulas ou pontos, tanto faz
   zzcalcula '2^2*(4-1)'          # 2 ao quadrado vezes 4 menos 1
   echo 2 + 2 | zzcalcula         # lendo da entrada padrão (STDIN)
   zzseq 5 | zzcalcula --soma     # soma números da STDIN

.fi


.SH zzcalculaip

.nf
Calcula os endereços de rede e broadcast à partir do IP e máscara da rede.
Obs.: Se não especificada, será usada a máscara padrão (RFC 1918) ou 24.
Uso: zzcalculaip ip [netmask]
Ex.: zzcalculaip 127.0.0.1 24
   zzcalculaip 10.0.0.0/8
   zzcalculaip 192.168.10.0 255.255.255.240
   zzcalculaip 10.10.10.0

.fi


.SH zzcapitalize

.nf
Altera Um Texto Para Deixar Todas As Iniciais De Palavras Em Maiúsculas.
Use a opção -1 para converter somente a primeira letra de cada linha.
Use a opção -w para adicionar caracteres de palavra (Padrão: A-Za-z0-9áéí…)

Uso: zzcapitalize [texto]
Ex.: zzcapitalize root                             # Root
   zzcapitalize kung fu panda                    # Kung Fu Panda
   zzcapitalize -1 kung fu panda                 # Kung fu panda
   zzcapitalize quero-quero                      # Quero-Quero
   zzcapitalize água ênfase último               # Água Ênfase Último
   echo eu_uso_camel_case | zzcapitalize         # Eu_Uso_Camel_Case
   echo "i don't care" | zzcapitalize            # I Don'T Care
   echo "i don't care" | zzcapitalize -w \e'      # I Don't Care
   cat arquivo.txt | zzcapitalize

.fi


.SH zzcaracoroa

.nf
Exibe 'cara' ou 'coroa' aleatoriamente.
Uso: zzcaracoroa
Ex.: zzcaracoroa

.fi


.SH zzcarnaval

.nf
Mostra a data da terça-feira de Carnaval para qualquer ano.
Obs.: Se o ano não for informado, usa o atual.
Regra: 47 dias antes do domingo de Páscoa.
Uso: zzcarnaval [ano]
Ex.: zzcarnaval
   zzcarnaval 1999

.fi


.SH zzcep

.nf
http://www.achecep.com.br
Busca o CEP de qualquer rua de qualquer cidade do país ou vice-versa.
Pode-se fornecer apenas o CEP, ou o endereço com estado.
Uso: zzcep <endereço estado| CEP>
Ex.: zzcep Rua Santa Ifigênia, São Paulo, SP
   zzcep 01310-000

.fi


.SH zzchavepgp

.nf
http://pgp.mit.edu
Busca a identificação da chave PGP, fornecido o nome ou e-mail da pessoa.
Uso: zzchavepgp nome|e-mail
Ex.: zzchavepgp Carlos Oliveira da Silva
   zzchavepgp carlos@dominio.com.br

.fi


.SH zzchecamd5

.nf
Checa o md5sum de arquivos baixados da net.
Nota: A função checa o arquivo no diretório corrente (./)
Uso: zzchecamd5 arquivo md5sum
Ex.: zzchecamd5 ./ubuntu-8.10.iso f9e0494e91abb2de4929ef6e957f7753

.fi


.SH zzcidade

.nf
Lista completa com todas as 5.500+ cidades do Brasil, com busca.
Obs.: Sem argumentos, mostra uma cidade aleatória.

Uso: zzcidade [palavra|regex]
Ex.: zzcidade              # mostra uma cidade qualquer
   zzcidade campos       # mostra as cidades com "Campos" no nome
   zzcidade '(SE)'       # mostra todas as cidades de Sergipe
   zzcidade ^X           # mostra as cidades que começam com X

.fi


.SH zzcinclude

.nf
Acha as funções de uma biblioteca da linguagem C (arquivos .h).
Obs.: O diretório padrão de procura é o /usr/include.
Uso: zzcinclude nome-biblioteca
Ex.: zzcinclude stdio
   zzcinclude /minha/rota/alternativa/stdio.h

.fi


.SH zzcinemais

.nf
http://www.cinemais.com.br
Busca horários das sessões dos filmes no site do Cinemais.
Sem argumento lista as cidades com os códigos dos cinemas.

Uso: zzcinemais [código cidade]
Ex.: zzcinemais 9

.fi


.SH zzcineuci

.nf
http://www.ucicinemas.com.br
Exibe a programação dos cinemas UCI de sua cidade.
Se não for passado nenhum parâmetro, são listadas as cidades e cinemas.
Uso: zzcineuci [codigo_cinema]
Ex.: zzcineuci 14

.fi


.SH zzcnpj

.nf
Cria, valida ou formata um número de CNPJ.
Obs.: O CNPJ informado pode estar formatado (pontos e hífen) ou não.
Uso: zzcnpj [-f] [cnpj]
Ex.: zzcnpj 12.345.678/0001-95      # valida o CNPJ informado
   zzcnpj 12345678000195          # com ou sem pontuação
   zzcnpj                         # gera um CNPJ válido (aleatório)
   zzcnpj -f 12345678000195       # formata, adicionando pontuação

.fi


.SH zzcodchar

.nf
Codifica caracteres como entidades HTML e XML (&lt; &#62; ...).
Entende entidades (&gt;), códigos decimais (&#62;) e hexadecimais (&#x3E;).

Opções: --html/--xml  Codifica caracteres em códigos HTML/XML
      --hex         Codifica caracteres em códigos hexadecimais
      --dec         Codifica caracteres em códigos decimais
      -s            Com essa opção também codifica os espaços
      --listar      Mostra a listagem completa de codificação
                    Ou só a listagem da codificação escolhida

Uso: zzcodchar [-s] [--listar cod] [--html|--xml|--dec|--hex] [arquivo(s)]
Ex.: zzcodchar --html arquivo.xml
   zzcodchar --hex  arquivo.html
   cat arquivo.html | zzcodchar --dec
   zzcodchar --listar html     #  Listagem dos caracteres e códigos html

.fi


.SH zzcoin

.nf
Retorna a cotação de criptomoedas em Reais (Bitcoin, Litecoins ou BCash).
Opções: btc ou bitecoin (padrão) / ltc ou litecoin / bch ou bcash.

Uso: zzcoin [btc|bitcoin|ltc|litecoin|bch|bcash|-a|--all]
Ex.: zzcoin
   zzcoin btc
   zzcoin litecoin
   zzcoin bch

.fi


.SH zzcolunar

.nf
Transforma uma lista simples, em uma lista de múltiplas colunas.
É necessário informar a quantidade de colunas como argumento.

Mas opcionalmente pode informar o formato da distribuição das colunas:
-z:
1  2  3
4  5  6
7  8  9
10

-n: (padrão)
1  5  9
2  6  10
3  7
4  8

As opções -l, --left, -e, --esquerda alinham as colunas a esquerda (padrão).
As opções -r, --right, -d, --direita alinham as colunas a direita.
As opções -c, --center, --centro centralizam as colunas.
A opção -j justifica as colunas.

As opções -H ou --header usa a primeira linha como cabeçalho,
repetindo-a no início de cada coluna.

As opções -w, --width, --largura seguido de um número,
determinam a largura que as colunas terão.

A opção -s seguida de um TEXTO determina o separador de colunas,
se não for declarado assume por padrão um espaço simples.

Uso: zzcolunar [-n|-z] [-H] [-l|-r|-c|-j] [-w <largura>] <colunas> arquivo
Ex.: zzcolunar 3 arquivo.txt
   zzcolunar -c -w 20 5 arquivo.txt
   cat arquivo.txt | zzcolunar -z 4
   zzcolunar --header 3 arquivo.txt

.fi


.SH zzconjugar

.nf
Conjuga verbo em todos os modos.
E pode-se filtrar pelo modo no segundo argumento:
 ind => Indicativo
 sub => Subjuntivo
 imp => Imperativo
 inf => Infinitivo

Ou apenas a definição do verbo se o segundo argumento for: def

Uso: zzconjugar verbo [ ind | sub | imp | inf | def ]
Ex.: zzconjugar correr
   zzconjugar comer sub

.fi


.SH zzcontapalavra

.nf
Conta o número de vezes que uma palavra aparece num arquivo.
Obs.: É diferente do grep -c, que não conta várias palavras na mesma linha.
Opções: -i  ignora a diferença de maiúsculas/minúsculas
      -p  busca parcial, conta trechos de palavras
Uso: zzcontapalavra [-i|-p] palavra arquivo(s)
Ex.: zzcontapalavra root /etc/passwd
   zzcontapalavra -i -p a /etc/passwd      # Compare com grep -ci a
   cat /etc/passwd | zzcontapalavra root

.fi


.SH zzcontapalavras

.nf
Conta o número de vezes que cada palavra aparece em um texto.

Opções: -i       Trata maiúsculas e minúsculas como iguais, FOO = Foo = foo
      -n NÚM   Mostra apenas as NÚM palavras mais frequentes

Uso: zzcontapalavras [-i] [-n N] [arquivo(s)]
Ex.: zzcontapalavras arquivo.txt
   zzcontapalavras -i arquivo.txt
   zzcontapalavras -i -n 10 /etc/passwd
   cat arquivo.txt | zzcontapalavras

.fi


.SH zzconverte

.nf
Conversões de caracteres, temperatura, distância, ângulo, grandeza e escala.
 Opções:
-p seguido de um número sem espaço:
   define a precisão dos resultados (casas decimais), o padrão é 2
-e: Resposta expandida, mais explicativa.
   Obs: sem essa opção a resposta é curta, apenas o número convertivo.

Temperatura:
 cf = (C)elsius      => (F)ahrenheit  | fc = (F)ahrenheit  => (C)elsius
 ck = (C)elsius      => (K)elvin      | kc = (K)elvin      => (C)elsius
 fk = (F)ahrenheit   => (K)elvin      | kf = (K)elvin      => (F)ahrenheit

Distância:
 km = (K)Quilômetros => (M)ilhas      | mk = (M)ilhas      => (K)Quilômetros
 mj = (M)etros       => (J)ardas      | jm = (J)ardas      => (M)etros
 mp = (M)etros       => (P)és         | pm = (P)és         => (M)etros
 jp = (J)ardas       => (P)és         | pj = (P)és         => (J)ardas

Ângulo:
 gr = (G)raus        => (R)adianos    | rg = (R)adianos    => (G)raus
 ga = (G)raus        => Gr(A)dos      | ag = Gr(A)dos      => (G)raus
 ra = (R)adianos     => Gr(A)dos      | ar = Gr(A)dos      => (R)adianos

Número:
 db = (D)ecimal      => (B)inário     | bd = (B)inário     => (D)ecimal
 dc = (D)ecimal      => (C)aractere   | cd = (C)aractere   => (D)ecimal
 do = (D)ecimal      => (O)ctal       | od = (O)ctal       => (D)ecimal
 dh = (D)ecimal      => (H)exadecimal | hd = (H)exadecimal => (D)ecimal
 hc = (H)exadecimal  => (C)aractere   | ch = (C)aractere   => (H)exadecimal
 ho = (H)exadecimal  => (O)ctal       | oh = (O)ctal       => (H)exadecimal
 hb = (H)exadecimal  => (B)inário     | bh = (B)inário     => (H)exadecimal
 ob = (O)ctal        => (B)inário     | bo = (B)inário     => (O)ctal

Escala:
 Y => yotta      G => giga       d => deci       p => pico
 Z => zetta      M => mega       c => centi      f => femto
 E => exa        K => quilo      m => mili       a => atto
 P => peta       H => hecto      u => micro      z => zepto
 T => tera       D => deca       n => nano       y => yocto
 un => unidade

Uso: zzconverte [-p<número>] [-e] <código(s)> [<código>] número [número ...]
Ex.: zzconverte cf 5
   zzconverte dc 65
   zzconverte db 32 47 28
   zzconverte -p9 mp 3  # Converte metros em pés com 9 casas decimais
   zzconverte G u 32    # Converte 32 gigas em 32000000000000000 micros
   zzconverte f H 7     # Converte 7 femtos em 0.00000000000000007 hecto
   zzconverte T 4       # Converte 4 teras em 4000000000000 unidades
   zzconverte un M 3    # Converte 3 unidades em 0.000003 megas

.fi


.SH zzcores

.nf
Mostra todas as combinações de cores possíveis no console.
Também mostra os códigos ANSI para obter tais combinações.
Uso: zzcores
Ex.: zzcores

.fi


.SH zzcorpuschristi

.nf
Mostra a data de Corpus Christi para qualquer ano.
Obs.: Se o ano não for informado, usa o atual.
Regra: 60 dias depois do domingo de Páscoa.
Uso: zzcorpuschristi [ano]
Ex.: zzcorpuschristi
   zzcorpuschristi 2009

.fi


.SH zzcotacao

.nf
http://www.infomoney.com.br
Busca cotações do dia de algumas moedas em relação ao Real (compra e venda).
Uso: zzcotacao
Ex.: zzcotacao

.fi


.SH zzcpf

.nf
Cria, valida, formata ou retorna o(s) estado(s) de um número de CPF.
Obs.: O CPF informado pode estar formatado (pontos e hífen) ou não.
Uso: zzcpf [-f|-F|-e|-q] [cpf]
Ex.: zzcpf 123.456.789-09      # valida o CPF informado
   zzcpf 12345678909         # com ou sem pontuação
   zzcpf                     # gera um CPF válido (aleatório)
   zzcpf -f 12345678909      # formata, adicionando pontuação
   zzcpf -F 12345678909      # desformata, tirando pontuação
   zzcpf -e 12345678909      # estado(s) de um CPF Válido
   zzcpf -q 12345678909      # apenas código de retorno, sem mensagens

.fi


.SH zzcut

.nf
Exibe partes selecionadas de linhas de cada ARQUIVO/STDIN na saída padrão.
É uma emulação do comando cut, com recursos adicionais.

Opções:
 -c LISTA    seleciona apenas estes caracteres.

 -d DELIM    usa DELIM em vez de TAB (padrão) como delimitador de campo.

 -f LISTA    seleciona somente estes campos; também exibe qualquer
           linha que não contenha o caractere delimitador.

 -s          não emite linhas que não contenham delimitadores.

 -D TEXTO    usa TEXTO como delimitador da saída
           o padrão é usar o delimitador de entrada.

 -v          Inverter o sentido, apagando as partes selecionadas.

 Obs.:  1) Se o delimitador da entrada for uma Expressão Regular,
         é recomendando declarar o delimitador de saída.
      2) Se o delimitador de entrada for ou possuir:
          - '\e' (contra-barra), use '\e\e' (1 escape) para cada '\e'.
          - '/' (barra), use '[/]' (lista em ER) para cada '/'.
      3) Se o delimitador de saída for ou possuir:
          - '\e' (contra-barra), use '\e\e\e\e' (3 escapes) para cada '\e'.
          - '/' (barra), use '\e/' (1 escape) para cada '/'.

 Use uma, e somente uma, das opções -c ou -f.
 Cada LISTA é feita de um ou vários intervalos separados por vírgulas.
 Cada intervalo da lista exibe seu trecho, mesmo se for repetido.

 Cada intervalo pode ser:
 N     caractere ou campo na posição N, começando por 1.
 N-    Do caractere ou campo na posição N até o fim da linha.
 N-M   Do caractere ou campo na posição N até a posição M.
 -M    Do primeiro caractere ou campo até a posição M.
 -     Do primeiro caractere ou campo até ao fim da linha.
 N~M   Do caractere ou campo na posição N até o final indo em M saltos.
 ~M    Do começo até o fim da linha em M saltos de caracteres ou campos.
 d     Caractere "d", posicionar o delimitador na saida de caracteres.

Uso: zzcut <-c|-f> <número[s]|range> [-d <delimitador>] [-v]
Ex.: zzcut -c 5,2 arq.txt     # 5º caractere, seguido pelo 2º caractere
   zzcut -c 7-4,9- arq.txt  # 7º ao 4º e depois do 9º ao fim da linha
   zzcut -v -c 3-8 arq.txt  # Exclui do 3º ao 8º caractere
   zzcut -f 1,-,3  arq.txt  # 1º campo, toda linha e 3º campo
   zzcut -v -f 6-  arq.txt  # Exclui a partir do 6º campo
   zzcut -f 8,8,8 -d ";" arq.txt   # 8º campo 3 vezes. Delimitador ";"
   zzcut -f 10,6 -d: -D _ arq.txt  # 10º e 6º campos, novo delimitador _
   zzcut -c 1,d,10 -D: arq.txt     # 1º e 10º caracteres. Delimitador :

.fi


.SH zzdado

.nf
Dado virtual.
Sem argumento, exibe um número aleatório entre 1 e 6.
Com o argumento -f ou --faces, pode mudar a quantidade de lados do dado.

Uso: zzdado
Ex.: zzdado
   zzdado -f 20
   zzdado --faces 12

.fi


.SH zzdata

.nf
Calculadora de datas, trata corretamente os anos bissextos.
Você pode somar ou subtrair dias, meses e anos de uma data qualquer.
Você pode informar a data dd/mm/aaaa ou usar palavras como: hoje, ontem.
Usar a palavra dias informa número de dias desde o começo do ano corrente.
Ou os dias da semana como: domingo, seg, ter, qua, qui, sex, sab, dom.
Na diferença entre duas datas, o resultado é o número de dias entre elas.
Se informar somente uma data, converte para número de dias (01/01/1970 = 0).
Se informar somente um número (de dias), converte de volta para a data.
Esta função também pode ser usada para validar uma data.

Uso: zzdata [data [+|- data|número<d|m|a>]]
Ex.: zzdata                           # que dia é hoje?
   zzdata anteontem                 # que dia foi anteontem?
   zzdata dom                       # que dia será o próximo domingo?
   zzdata hoje + 15d                # que dia será daqui 15 dias?
   zzdata hoje - 40d                # e 40 dias atrás, foi quando?
   zzdata 31/12/2010 + 100d         # 100 dias após a data informada
   zzdata 29/02/2001                # data inválida, ano não-bissexto
   zzdata 29/02/2000 + 1a           # 28/02/2001 <- respeita bissextos
   zzdata 01/03/2000 - 11/11/1999   # quantos dias há entre as duas?
   zzdata hoje - 07/10/1977         # quantos dias desde meu nascimento?
   zzdata 21/12/2012 - hoje         # quantos dias para o fim do mundo?

.fi


.SH zzdataestelar

.nf
http://scifibrasil.com.br/data/
Calcula a data estelar, a partir de uma data e horário.

Sem argumentos calcula com a data e hora atual.

Com um argumento, calcula conforme descrito:
Se for uma data válida, usa 0h 0min 0seg do dia.
Se for um horário, usa a data atual.

Com dois argumentos sendo data seguida da hora.

Uso: zzdataestelar [[data|hora] | data hora]
Ex.: zzdataestelar
   zzdataestelar hoje
   zzdataestelar 25/01/2000
   zzdataestelar 13:47:26
   zzdataestelar 08/03/2010 14:25

.fi


.SH zzdatafmt

.nf
Muda o formato de uma data, com várias opções de personalização.
Reconhece datas em vários formatos, como aaaa-mm-dd, dd.mm.aaaa e dd/mm.
Obs.: Se você não informar o ano, será usado o ano corrente.

Use a opção -f para mudar o formato de saída (o padrão é DD/MM/AAAA):

   Código   Exemplo     Descrição
   --------------------------------------------------------------
   AAAA     2003        Ano com 4 dígitos
   AA       03          Ano com 2 dígitos
   A        3           Ano sem zeros à esquerda (1 ou 2 dígitos)
   MM       02          Mês com 2 dígitos
   M        2           Mês sem zeros à esquerda
   DD       01          Dia com 2 dígitos
   D        1           Dia sem zeros à esquerda
   --------------------------------------------------------------
   ANO      dois mil    Ano por extenso
   MES      fevereiro   Nome do mês
   MMM      fev         Nome do mês com três letras
   DIA      vinte um    Dia por extenso
   SEMANA   Domingo     Dia da semana por extenso
   SSS      Dom         Dia da semana com três letras

Use as opções de idioma para alterar os nomes dos meses. Estas opções também
mudam o formato padrão da data de saída, caso a opção -f não seja informada.
  --pt para português     --de para alemão
  --en para inglês        --fr para francês
  --es para espanhol      --it para italiano
  --ptt português textual incluindo os números
  --iso formato AAAA-MM-DD

Uso: zzdatafmt [-f formato] [data]
Ex.: zzdatafmt 2011-12-31                 # 31/12/2011
   zzdatafmt 31.12.11                   # 31/12/2011
   zzdatafmt 31/12                      # 31/12/2011     (ano atual)
   zzdatafmt -f MES hoje                # maio           (mês atual)
   zzdatafmt -f MES --en hoje           # May            (em inglês)
   zzdatafmt -f AAAA 31/12/11           # 2011
   zzdatafmt -f MM/DD/AA 31/12/2011     # 12/31/11       (BR -> US)
   zzdatafmt -f D/M/A 01/02/2003        # 1/2/3
   zzdatafmt -f "D de MES" 01/05/95     # 1 de maio
   echo 31/12/2011 | zzdatafmt -f MM    # 12             (via STDIN)
   zzdatafmt 31 de jan de 2013          # 31/01/2013     (entrada textual)
   zzdatafmt --de 19/03/2012            # 19. März 2012  (Das ist gut!)

.fi


.SH zzdefinr

.nf
http://definr.com
Busca o significado de um termo, palavra ou expressão no site Definr.
Uso: zzdefinr termo
Ex.: zzdefinr headphone
   zzdefinr in force

.fi


.SH zzdiadasemana

.nf
Mostra qual o dia da semana de uma data qualquer.
Com a opção -n mostra o resultado em forma numérica (domingo=1).
Obs.: Se a data não for informada, usa a data atual.
Uso: zzdiadasemana [-n] [data]
Ex.: zzdiadasemana
   zzdiadasemana 31/12/2010          # sexta-feira
   zzdiadasemana -n 31/12/2010       # 6

.fi


.SH zzdiasuteis

.nf
Calcula o número de dias úteis entre duas datas, inclusive ambas.
Chamada sem argumentos, mostra os total de dias úteis no mês atual.
Obs.: Não leva em conta feriados.

Uso: zzdiasuteis [data-inicial data-final]
Ex.: zzdiasuteis                          # Fevereiro de 2013 tem 20 dias …
   zzdiasuteis 01/01/2011 31/01/2011    # 21

.fi


.SH zzdicantonimos

.nf
http://www.antonimos.com.br/
Procura antônimos para uma palavra.
Uso: zzdicantonimos palavra
Ex.: zzdicantonimos bom

.fi


.SH zzdicasl

.nf
http://www.dicas-l.unicamp.br
Procura por dicas sobre determinado assunto na lista Dicas-L.
Obs.: As opções do grep podem ser usadas (-i já é padrão).
Uso: zzdicasl [opção-grep] palavra(s)
Ex.: zzdicasl ssh
   zzdicasl -w vi
   zzdicasl -vEw 'windows|unix|emacs'

.fi


.SH zzdicbabylon

.nf
http://www.babylon.com
Tradução de uma palavra em inglês para vários idiomas.
Francês, alemão, italiano, hebreu, espanhol, holandês e português.
Se nenhum idioma for informado, o padrão é o português.
Uso: zzdicbabylon [idioma] palavra   #idiomas: nl fr de he it pt es
Ex.: zzdicbabylon hardcore
   zzdicbabylon he tree

.fi


.SH zzdicesperanto

.nf
http://glosbe.com
Dicionário de Esperanto em inglês, português e alemão.
Possui busca por palavra nas duas direções. O padrão é português-esperanto.

Uso: zzdicesperanto [-d pt|en|de|eo] [-p pt|en|de|eo] palavra
Ex.: zzdicesperanto esperança
   zzdicesperanto -d en job
   zzdicesperanto -d eo laboro
   zzdicesperanto -p en trabalho

.fi


.SH zzdicjargon

.nf
http://catb.org/jargon/
Dicionário de jargões de informática, em inglês.
Uso: zzdicjargon palavra(s)
Ex.: zzdicjargon vi
   zzdicjargon all your base are belong to us

.fi


.SH zzdicportugues

.nf
http://www.dicio.com.br
Dicionário de português.
Fornecendo uma "palavra" como argumento retorna seu significado e sinônimo.
Se for seguida do termo "def", retorna suas definições.

Uso: zzdicportugues palavra [def]
Ex.: zzdicportugues bolacha
   zzdicportugues comer def

.fi


.SH zzdicsinonimos

.nf
http://www.sinonimos.com.br/
Procura sinônimos para um termo.
Uso: zzdicsinonimos termo
Ex.: zzdicsinonimos deste modo

.fi


.SH zzdiffpalavra

.nf
Mostra a diferença entre dois textos, palavra por palavra.
Útil para conferir revisões ortográficas ou mudanças pequenas em frases.
Obs.: Se tiver muitas *linhas* diferentes, use o comando diff.
Uso: zzdiffpalavra arquivo1 arquivo2
Ex.: zzdiffpalavra texto-orig.txt texto-novo.txt

.fi


.SH zzdistro

.nf
Lista o ranking das distribuições no DistroWatch.
Sem argumentos lista dos últimos 6 meses
Se o argumento for 1, 3, 6 ou 12 é a ranking nos meses correspondente.
Se o argumento for 2002 até o ano passado, é a ranking final desse ano.
Se o primeiro argumento for -l, lista os links da distribuição no site.

Uso: zzdistro [-l] [meses|ano]
Ex.: zzdistro
   zzdistro 2010  # Ranking em 2010
   zzdistro 3     # Ranking dos últimos 3 meses.
   zzdistro       # Ranking dos últimos 6 meses, com os links.

.fi


.SH zzdividirtexto

.nf
Divide um texto por uma quantidade máxima de palavras por linha.
Sem argumento a quantidade padrão é 15

Uso: zzdividirtexto [número]
Ex.: zzdividirtexto 10
   zzdividirtexto 3 Um texto para servir de exemplo no teste.
   cat arquivo.txt | zzdividirtexto

.fi


.SH zzdivisores

.nf
Lista todos os divisores de um número inteiro e positivo, maior que 2.

Uso: zzdivisores <número>
Ex.: zzdivisores 1400

.fi


.SH zzdolar

.nf
http://economia.uol.com.br/cotacoes
Busca a cotação do dia do dólar (comercial, turismo).
Uso: zzdolar
Ex.: zzdolar

.fi


.SH zzdominiopais

.nf
http://www.ietf.org/timezones/data/iso3166.tab
Busca a descrição de um código de país da internet (.br, .ca etc).
Uso: zzdominiopais [.]código|texto
Ex.: zzdominiopais .br
   zzdominiopais br
   zzdominiopais republic

.fi


.SH zzdos2unix

.nf
Converte arquivos texto no formato Windows/DOS (CR+LF) para o Unix (LF).
Obs.: Também remove a permissão de execução do arquivo, caso presente.
Uso: zzdos2unix arquivo(s)
Ex.: zzdos2unix frases.txt
   cat arquivo.txt | zzdos2unix

.fi


.SH zzecho

.nf
Mostra textos coloridos, sublinhados e piscantes no terminal (códigos ANSI).
Opções: -f, --fundo       escolhe a cor de fundo
      -l, --letra       escolhe a cor da letra
      -p, --pisca       texto piscante
      -s, --sublinhado  texto sublinhado
      -N, --negrito     texto em negrito (brilhante em alguns terminais)
      -n, --nao-quebra  não quebra a linha no final, igual ao echo -n
Cores: preto vermelho verde amarelo azul roxo ciano branco
Obs.: \et, \en e amigos são sempre interpretados (igual ao echo -e).
Uso: zzecho [-f cor] [-l cor] [-p] [-s] [-N] [-n] [texto]
Ex.: zzecho -l amarelo Texto em amarelo
   zzecho -f azul -l branco -N Texto branco em negrito, com fundo azul
   zzecho -p -s Texto piscante e sublinhado

.fi


.SH zzencoding

.nf
Informa qual a codificação de um arquivo (ou texto via STDIN).

Uso: zzencoding [arquivo]
Ex.: zzencoding /etc/passwd          # us-ascii
   zzencoding index-iso.html       # iso-8859-1
   echo FooBar | zzencoding        # us-ascii
   echo Bênção | zzencoding        # utf-8

.fi


.SH zzenglish

.nf
http://www.dict.org
Busca definições em inglês de palavras da língua inglesa em DICT.org.
Uso: zzenglish palavra-em-inglês
Ex.: zzenglish momentum

.fi


.SH zzestado

.nf
Lista os estados do Brasil e suas capitais.
Obs.: Sem argumentos, mostra a lista completa.

Opções: --sigla        Mostra somente as siglas
      --nome         Mostra somente os nomes
      --capital      Mostra somente as capitais
      --slug         Mostra somente os slugs (nome simplificado)
      --formato FMT  Você escolhe o formato de saída, use os tokens:
                     {sigla}, {nome}, {capital}, {slug}, \en , \et
      --python       Formata como listas/dicionários do Python
      --javascript   Formata como arrays do JavaScript
      --php          Formata como arrays do PHP
      --html         Formata usando a tag <SELECT> do HTML
      --xml          Formata como arquivo XML
      --url,--url2   Exemplos simples de uso da opção --formato

Uso: zzestado [opção]
Ex.: zzestado                      # [mostra a lista completa]
   zzestado --sigla              # AC AL AP AM BA …
   zzestado --html               # <option value="AC">AC - Acre</option> …
   zzestado --python             # siglas = ['AC', 'AL', 'AP', …
   zzestado --formato '{sigla},'             # AC,AL,AP,AM,BA,…
   zzestado --formato '{sigla} - {nome}\en'   # AC - Acre …
   zzestado --formato '{capital}-{sigla}\en'  # Rio Branco-AC …

.fi


.SH zzexcuse

.nf
Da uma desculpa comum de desenvolvedor ( em ingles ).
Com a opção -t ou --traduzir mostra as desculpas traduzidas.

Uso: zzexcuse [-t|--traduzir]
Ex.: zzexcuse

.fi


.SH zzextensao

.nf
Informa a extensão de um arquivo.
Obs.: Caso o arquivo não possua extensão, retorna vazio "".
Uso: zzextensao arquivo
Ex.: zzextensao /tmp/arquivo.txt       # resulta em "txt"
   zzextensao /tmp/arquivo           # resulta em ""

.fi


.SH zzfatorar

.nf
Fatora um número em fatores primos.
Com as opções:
--bc: saída apenas da expressão, que pode ser usado no bc, awk ou etc.
--no-bc: saída apenas do fatoramento.
 por padrão exibe tanto o fatoramento como a expressão.

Se o número for primo, é exibido a mensagem apenas.

Uso: zzfatorar [--bc | --no-bc] <número>
Ex.: zzfatorar 1458
   zzfatorar --bc 1296

.fi


.SH zzfeed

.nf
Leitor de Feeds RSS, RDF e Atom.
Se informar a URL de um feed, são mostradas suas últimas notícias.
Se informar a URL de um site, mostra a URL do(s) Feed(s).

Opções:
 -n para limitar o número de resultados (Padrão é 10).
 -u para simular navegador Mozilla/Firefox (alguns sites precisam disso).

Para uso via pipe digite dessa forma: "zzfeed -", mesma forma que o cat.

Uso: zzfeed [-n número] URL...
Ex.: zzfeed http://aurelio.net/feed/
   zzfeed -n 5 aurelio.net/feed/          # O http:// é opcional
   zzfeed aurelio.net funcoeszz.net       # Mostra URL dos feeds
   zzfeed -u funcoeszz.net                # UserAgent do lynx diferente
   cat arquivo.rss | zzfeed -             # Para uso via pipe

.fi


.SH zzferiado

.nf
Verifica se a data passada por parâmetro é um feriado ou não.
Caso não seja passado nenhuma data é pego a data atual.
Pode-se configurar a variável ZZFERIADO para os feriados regionais.
O formato é o dd/mm:descrição, por exemplo: 20/11:Consciência negra.
Uso: zzferiado -l [ano] | [data]
Ex.: zzferiado 25/12/2008
   zzferiado -l
   zzferiado -l 2010

.fi


.SH zzfoneletra

.nf
Conversão de telefones contendo letras para apenas números.
Uso: zzfoneletra telefone
Ex.: zzfoneletra 2345-LINUX              # Retorna 2345-54689
   echo 5555-HELP | zzfoneletra        # Retorna 5555-4357

.fi


.SH zzfrenteverso2pdf

.nf
Combina 2 arquivos, frentes.pdf e versos.pdf, em um único frenteverso.pdf.
Opções:
-rf, --frentesreversas  informa ordem reversa no arquivo frentes.pdf.
-rv, --versosreversos   informa ordem reversa no arquivo versos.pdf.
 -d, --diretorio        informa o diretório de entrada/saída. Padrão=".".
 -v, --verbose          exibe informações de debug durante a execução.
Uso: zzfrenteverso2pdf [-rf] [-rv] [-d diretorio]
Ex.: zzfrenteverso2pdf
   zzfrenteverso2pdf -rf
   zzfrenteverso2pdf -rv -d "/tmp/dir_teste"

.fi


.SH zzfutebol

.nf
http://esporte.uol.com.br/futebol/agenda-de-jogos
Mostra todos os jogos de futebol marcados para os próximos dias.
Ou os resultados de jogos recentes.
Além de mostrar os times que jogam, o script também mostra o dia,
o horário e por qual campeonato será ou foi o jogo.

Suporta um argumento que pode ser um dos dias da semana, como:
 hoje, amanhã, segunda, terça, quarta, quinta, sexta, sábado, domingo.

Ou um ou dois argumentos para ver resultados do jogos:
resultado ou placar, que pode ser acompanhado de hoje, ontem, anteontem.

Nos casos dos dias, podem ser usadas datas no formato DD/MM/AAAA.

Um filtro com nome do campeonato, nome do time, ou horário de uma partida.

Uso: zzfutebol [resultado | placar ] [ argumento ]
Ex.: zzfutebol                 # Todas as partidas nos próximos dias.
   zzfutebol hoje            # Partidas que acontecem hoje.
   zzfutebol sabado          # Partidas que acontecem no sábado.
   zzfutebol libertadores    # Próximas partidas da Libertadores.
   zzfutebol 21h             # Partidas que começam entre 21 e 22h.
   zzfutebol resultado       # Placar dos jogos já ocorridos.
   zzfutebol placar ontem    # Placar dos jogos de ontem.
   zzfutebol placar espanhol # Placar dos jogos do Campeonato Espanhol.

.fi


.SH zzgeoip

.nf
Localiza geograficamente seu IP de Internet ou um que seja informado.
Uso: zzgeoip [ip]
Ex.: zzgeoip
   zzgeoip 187.75.22.192

.fi


.SH zzglobo

.nf
Mostra a programação da Rede Globo do dia.
Uso: zzglobo
Ex.: zzglobo

.fi


.SH zzgravatar

.nf
http://www.gravatar.com
Monta a URL completa para o Gravatar do email informado.

Opções: -t, --tamanho N      Tamanho do avatar (padrão 80, máx 512)
      -d, --default TIPO   Tipo do avatar substituto, se não encontrado

Se não houver um avatar para o email, a opção --default informa que tipo
de avatar substituto será usado em seu lugar:
  mm          Mistery Man, a silhueta de uma pessoa (não muda)
  identicon   Padrão geométrico, muda conforme o email
  monsterid   Monstros, muda cores e rostos
  wavatar     Rostos, muda características e cores
  retro       Rostos pixelados, tipo videogame antigo 8-bits
Veja exemplos em http://gravatar.com/site/implement/images/

Uso: zzgravatar [--tamanho N] [--default tipo] email
Ex.: zzgravatar fulano@dominio.com.br
   zzgravatar -t 128 -d mm fulano@dominio.com.br
   zzgravatar --tamanho 256 --default retro fulano@dominio.com.br

.fi


.SH zzhexa2str

.nf
Converte os bytes em hexadecimal para a string equivalente.
Uso: zzhexa2str [bytes]
Ex.: zzhexa2str 40 4d 65 6e 74 65 42 69 6e 61 72 69 61   # sem prefixo
   zzhexa2str 0x42 0x69 0x6E                           # com prefixo 0x
   echo 0x42 0x69 0x6E | zzhexa2str

.fi


.SH zzhoracerta

.nf
http://www.worldtimeserver.com
Mostra a hora certa de um determinado local.
Se nenhum parâmetro for passado, são listados as localidades disponíveis.
O parâmetro pode ser tanto a sigla quando o nome da localidade.
A opção -s realiza a busca somente na sigla.
Uso: zzhoracerta [-s] local
Ex.: zzhoracerta rio grande do sul
   zzhoracerta -s br
   zzhoracerta rio
   zzhoracerta us-ny

.fi


.SH zzhora

.nf
Faz cálculos com horários.
A opção -r torna o cálculo relativo à primeira data, por exemplo:
02:00 - 03:30 = -01:30 (sem -r) e 22:30 (com -r)

Uso: zzhora [-r] hh:mm [+|- hh:mm] ...
Ex.: zzhora 8:30 + 17:25        # preciso somar dois horários
   zzhora 12:00 - agora       # quando falta para o almoço?
   zzhora -12:00 + -5:00      # horas negativas!
   zzhora 1000                # quanto é 1000 minutos?
   zzhora -r 5:30 - 8:00      # que horas ir dormir para acordar às 5:30?
   zzhora -r agora + 57:00    # e daqui 57 horas, será quando?
   zzhora 1:00 + 2:00 + 3:00 - 4:00 - 0:30   # cálculos múltiplos

.fi


.SH zzhoramin

.nf
Converte horas em minutos.
Obs.: Se não informada a hora, usa o horário atual para o cálculo.
Uso: zzhoramin [hh:mm]
Ex.: zzhoramin
   zzhoramin 10:53       # Retorna 653
   zzhoramin -10:53      # Retorna -653

.fi


.SH zzhorariodeverao

.nf
Mostra as datas de início e fim do horário de verão.
Obs.: Ano de 2008 em diante. Se o ano não for informado, usa o atual.
Regra: 3º domingo de outubro/fevereiro, exceto carnaval (4º domingo).
Uso: zzhorariodeverao [ano]
Ex.: zzhorariodeverao
   zzhorariodeverao 2009

.fi


.SH zzhoroscopo

.nf
http://m.horoscopovirtual.bol.uol.com.br/horoscopo/
Consulta o horóscopo do dia.
Deve ser informado o signo que se deseja obter a previsão.

Signos: aquário, peixes, áries, touro, gêmeos, câncer, leão,
      virgem, libra, escorpião, sagitário, capricórnio

Uso: zzhoroscopo <signo>
Ex.: zzhoroscopo sagitário    # exibe a previsão para o signo de sagitário

.fi


.SH zzhowto

.nf
http://www.ibiblio.org
Procura documentos do tipo HOWTO.
Uso: zzhowto [--atualiza] palavra
Ex.: zzhowto apache
   zzhowto --atualiza

.fi


.SH zzhsort

.nf
Ordenar palavras ou números horizontalmente.
Opções:
-r                              define o sentido da ordenação reversa.
-d <sep>                        define o separador de campos na entrada.
-D, --output-delimiter <sep>  define o separador de campos na saída.

O separador na entrada pode ser 1 ou mais caracteres ou uma ER.
Se não for declarado assume-se espaços em branco como separador.
Conforme padrão do awk, o default seria FS = "[ \et]+".

Se o separador de saída não for declarado, assume o mesmo da entrada.
Caso a entrada também não seja declarada assume-se como um espaço.
Conforme padrão do awk, o default é OFS = " ".

Se o separador da entrada é uma ER, é bom declarar o separador de saída.

Uso: zzhsort [-d <sep>] [-D | --output-delimiter <sep>] <Texto>
Ex.: zzhsort "isso está desordenado"            # desordenado está isso
   zzhsort -r -d ":" -D "-" "1:a:z:x:5:o"  # z-x-o-a-5-1
   cat num.txt | zzhsort -d '[\et:]' --output-delimiter '\et'

.fi


.SH zzimc

.nf
Calcula o valor do IMC correspodente a sua estrutura corporal.

Uso: zzimc <peso_em_KG> <altura_em_metros>
Ex.: zzimc 108.5 1.73

.fi


.SH zziostat

.nf
Monitora a utilização dos discos no Linux.

Opções:
-n [número]    Quantidade de medições (padrão = 10; contínuo = 0)
-t [número]    Mostra apenas os discos mais utilizados
-i [segundos]  Intervalo em segundos entre as coletas
-d [discos]    Mostra apenas os discos que começam com a string passada
               O padrão é 'sd'
-o [trwT]      Ordena os discos por:
                   t (tps)
                   r (read/s)
                   w (write/s)
                   T (total/s = read/s+write/s)

Obs.: Se não for usada a opção -t, é mostrada a soma da utilização
    de todos os discos.

Uso: zziostat [-t número] [-i segundos] [-d discos] [-o trwT]
Ex.: zziostat
   zziostat -n 15
   zziostat -t 10
   zziostat -i 5 -o T
   zziostat -d emcpower

.fi


.SH zzipinternet

.nf
Mostra o seu número IP (externo) na Internet.
Uso: zzipinternet
Ex.: zzipinternet

.fi


.SH zzit

.nf
Uma forma de ler o site Inovação Tecnológica.
Sem opção mostra o resumo da página principal.

Opções podem ser (ano)sub-temas e/ou número:

Sub-temas podem ser:
eletronica, energia, espaco, informatica, materiais,
mecanica, meioambiente, nanotecnologia, robotica, plantao.
 Que podem ser precedido do ano ao qual se quer listar

Se a opção for um número mostra a matéria selecionada,
seja da página principal ou de um sub-tema.

Uso: zzit [[ano] sub-tema] [número]
Ex.: zzit                 # Um resumo da página principal
   zzit espaco          # Um resumo do sub-tem espaço
   zzit 3               # Exibe a terceira matéria da página principal
   zzit mecanica 7      # Exibe a sétima matéria do sub-tema mecânica
   zzit 2003 energia    # Um resumo do sub-tema energia em 2003
   zzit 2012 plantao 2  # Exibe a 2ª matéria de 2012 no sub-tema plantao

.fi


.SH zzjoin

.nf
Junta as linhas de 2 ou mais arquivos, mantendo a sequência.
Opções:
 -o <arquivo> - Define o arquivo de saída.
 -m - Toma como base o arquivo com menos linhas.
 -M - Toma como base o arquivo com mais linhas.
 -<numero> - Toma como base o arquivo na posição especificada.
 -d - Define o separador entre as linhas dos arquivos juntados (padrão TAB).

Sem opção, toma como base o primeiro arquivo declarado.

Uso: zzjoin [-m | -M | -<numero>] [-o <arq>] [-d <sep>] arq1 arq2 [arqN] ...
Ex.: zzjoin -m arq1 arq2 arq3      # Base no arquivo com menos linhas
   zzjoin -2 arq1 arq2 arq3      # Base no segundo arquivo
   zzjoin -o out.txt arq1 arq2   # Juntando para o arquivo out.txt
   zzjoin -d ":" arq1 arq2       # Juntando linhas separadas por ":"

.fi


.SH zzjquery

.nf
Exibe a descrição da função jQuery informada.

Opções:
--categoria[s]: Lista as Categorias da funções.
--lista: Lista todas as funções.
--lista <categoria>: Listas as funções dentro da categoria informada.

Caso não seja passado o nome, serão exibidas informações acerca do $().
Se usado o argumento -s, será exibida somente a sintaxe.
Uso: zzjquery [-s] função
Ex.: zzjquery gt
   zzjquery -s gt

.fi


.SH zzjuntalinhas

.nf
Junta várias linhas em uma só, podendo escolher o início, fim e separador.

Melhorias em relação ao comando paste -s:
- Trata corretamente arquivos no formato Windows (CR+LF)
- Lê arquivos ISO-8859-1 sem erros no Mac (o paste dá o mesmo erro do tr)
- O separador pode ser uma string, não está limitado a um caractere
- Opções -i e -f para delimitar somente um trecho a ser juntado

Opções: -d sep        Separador a ser colocado entre as linhas (padrão: Tab)
      -i, --inicio  Início do trecho a ser juntado (número ou regex)
      -f, --fim     Fim do trecho a ser juntado (número ou regex)

Uso: zzjuntalinhas [-d separador] [-i texto] [-f texto] arquivo(s)
Ex.: zzjuntalinhas arquivo.txt
   zzjuntalinhas -d @@@ arquivo.txt             # junta toda as linhas
   zzjuntalinhas -d : -i 10 -f 20 arquivo.txt   # junta linhas 10 a 20
   zzjuntalinhas -d : -i 10 arquivo.txt         # junta linha 10 em diante
   cat /etc/named.conf | zzjuntalinhas -d '' -i '^[a-z]' -f '^}'

.fi


.SH zzlblank

.nf
Elimina espaços excedentes no início, mantendo alinhamento.
por padrão transforma todos os TABs em 4 espaços para uniformização.
Um número como argumento especifica a quantidade de espaços para cada TAB.
Caso use a opção -s, apenas espaços iniciais serão considerados.
Caso use a opção -t, apenas TABs iniciais serão considerados.
 Obs.: Com as opções -s e -t não há a conversão de tabs para espaço.

Uso: zzlblank [-s|-t|<número>] arquivo.txt
Ex.: zzlblank arq.txt     # Espaços e tabs iniciais
   zzlblank -s arq.txt  # Apenas espaços iniciais
   zzlblank -t arq.txt  # Apenas tabs iniciais
   zzlblank 12 arq.txt  # Tabs são convertidos em 12 espaços
   cat arq.txt | zzlblank

.fi


.SH zzlembrete

.nf
Sistema simples de lembretes: cria, apaga e mostra.
Uso: zzlembrete [texto]|[número [d]]
Ex.: zzlembrete                      # Mostra todos
   zzlembrete 5                    # Mostra o 5º lembrete
   zzlembrete 5d                   # Deleta o 5º lembrete
   zzlembrete Almoço com a sogra   # Adiciona lembrete

.fi


.SH zzlibertadores

.nf
Mostra a classificação e jogos do torneio Libertadores da América.
Opções:
 <número> | <fase>: Mostra jogos da fase selecionada
 fases: pre ou primeira, grupos ou segunda, oitavas
 -g <número>: Jogos da segunda fase do grupo selecionado
 -c [número]: Mostra a classificação, nos grupos da segunda fase
 -cg <número> ou -gc <número>: Classificação e jogos do grupo selecionado.

As fases podem ser:
 pré, pre, primeira ou 1, para a fase pré-libertadores
 grupos, segunda ou 2, para a fase de grupos da libertadores
 oitavas ou 3
 quartas ou 4
 semi, semi-final ou 5
 final ou 6

Nomenclatura:
 PG  - Pontos Ganhos
 J   - Jogos
 V   - Vitórias
 E   - Empates
 D   - Derrotas
 GP  - Gols Pró
 GC  - Gols Contra
 SG  - Saldo de Gols
 (%) - Aproveitamento (pontos)

Obs.: Se a opção for --atualiza, o cache usado é renovado

Uso: zzlibertadores [ fase | -c [número] | -g <número> ]
Ex.: zzlibertadores 2     # Jogos da Fase 2 (Grupos)
   zzlibertadores -g 5  # Jogos do grupo 5 da fase 2
   zzlibertadores -c    # Classificação de todos os grupos
   zzlibertadores -c 3  # Classificação no grupo 3
   zzlibertadores -cg 7 # Classificação e jogos do grupo 7

.fi


.SH zzlimpalixo

.nf
Retira linhas em branco e comentários.
Para ver rapidamente quais opções estão ativas num arquivo de configuração.
Além do tradicional #, reconhece comentários de vários tipos de arquivos.
 vim, asp, asm, ada, sql, e, bat, tex, c, css, html, cc, d, js, php, scala.
E inclui os comentários multilinhas (/* ... */), usando opção --multi.
Obs.: Aceita dados vindos da entrada padrão (STDIN).
Uso: zzlimpalixo [--multi] [arquivos]
Ex.: zzlimpalixo ~/.vimrc
   cat /etc/inittab | zzlimpalixo

.fi


.SH zzlinha

.nf
Mostra uma linha de um texto, aleatória ou informada pelo número.
Obs.: Se passado um argumento, restringe o sorteio às linhas com o padrão.
Uso: zzlinha [número | -t texto] [arquivo(s)]
Ex.: zzlinha /etc/passwd           # mostra uma linha qualquer, aleatória
   zzlinha 9 /etc/passwd         # mostra a linha 9 do arquivo
   zzlinha -2 /etc/passwd        # mostra a penúltima linha do arquivo
   zzlinha -t root /etc/passwd   # mostra uma das linhas com "root"
   cat /etc/passwd | zzlinha     # o arquivo pode vir da entrada padrão

.fi


.SH zzlinux

.nf
http://www.kernel.org/kdist/finger_banner
Mostra as versões disponíveis do Kernel Linux.
Uso: zzlinux
Ex.: zzlinux

.fi


.SH zzlinuxnews

.nf
Busca as últimas notícias sobre Linux em sites em inglês.
Obs.: Cada site tem uma letra identificadora que pode ser passada como
    parâmetro, para informar quais sites você quer pesquisar:

       S)lashDot            Linux T)oday
       O)S News             Linux W)eekly News
       Linux I)nsider       Linux N)ews
       Linux J)ournal       X) LXer Linux News

Uso: zzlinuxnews [sites]
Ex.: zzlinuxnews
   zzlinuxnews ts

.fi


.SH zzlocale

.nf
Busca o código do idioma (locale) - por exemplo, português é pt_BR.
Com a opção -c, pesquisa somente nos códigos e não em sua descrição.
Uso: zzlocale [-c] código|texto
Ex.: zzlocale chinese
   zzlocale -c pt

.fi


.SH zzlorem

.nf
Gerador de texto de teste, em latim (Lorem ipsum...).
Texto obtido em http://br.lipsum.com/

Uso: zzlorem [número-de-palavras]
Ex.: zzlorem 10

.fi


.SH zzloteria

.nf
Resultados da quina, megasena, duplasena, lotomania, lotofácil, federal, timemania e loteca.

Se o 2º argumento for um número, pesquisa o resultado filtrando o concurso.
Se o 2º argumento for a palavra "quantidade" ou "qtde" mostra quantas vezes
 um número foi sorteado. ( Não se aplica para federal e loteca )
Se nenhum argumento for passado, todas as loterias são mostradas.

Uso: zzloteria [[loterias suportadas] [concurso|[quantidade|qtde]]
Ex.: zzloteria
   zzloteria quina megasena
   zzloteria loteca 550
   zzloteria quina qtde

.fi


.SH zzlua

.nf
http://www.lua.org/manual/5.1/pt/manual.html
Lista de funções da linguagem Lua.
com a opção -d ou --detalhe busca mais informação da função
com a opção --atualiza força a atualização do cache local

Uso: zzlua <palavra|regex>
Ex.: zzlua --atualiza        # Força atualização do cache
   zzlua file              # mostra as funções com "file" no nome
   zzlua -d debug.debug    # mostra descrição da função debug.debug
   zzlua ^d                # mostra as funções que começam com d

.fi


.SH zzmacvendor

.nf
Mostra o fabricante do equipamento utilizando o endereço MAC.

Uso: zzmacvendor <MAC Address>
Ex.: zzmacvendor 88:5A:92:C7:41:40
   zzmacvendor 88-5A-92-C7-41-40

.fi


.SH zzmaiores

.nf
Acha os maiores arquivos/diretórios do diretório atual (ou outros).
Opções: -r  busca recursiva nos subdiretórios
      -f  busca somente os arquivos e não diretórios
      -n  número de resultados (o padrão é 10)
Uso: zzmaiores [-r] [-f] [-n <número>] [dir1 dir2 ...]
Ex.: zzmaiores
   zzmaiores /etc /tmp
   zzmaiores -r -n 5 ~

.fi


.SH zzmaiusculas

.nf
Converte todas as letras para MAIÚSCULAS, inclusive acentuadas.
Uso: zzmaiusculas [texto]
Ex.: zzmaiusculas eu quero gritar                # via argumentos
   echo eu quero gritar | zzmaiusculas         # via STDIN

.fi


.SH zzmariadb

.nf
Lista alguns dos comandos já traduzidos do banco MariaDB, numerando-os.
Pesquisa detalhe dos comando, ao fornecer o número na listagem a esquerda.
E filtra a busca se fornecer um texto.

Uso: zzmariadb [ código | filtro ]
Ex.: zzmariadb        # Lista os comandos disponíveis
   zzmariadb 18     # Consulta o comando DROP USER
   zzmariadb alter  # Filtra os comandos que possuam alter na declaração

.fi


.SH zzmat

.nf
Uma coletânea de funções matemáticas simples.
Se o primeiro argumento for um '-p' seguido de número sem espaço
define a precisão dos resultados ( casas decimais ), o padrão é 6
Em cada função foi colocado um pequeno help um pouco mais detalhado,
pois ficou muito extenso colocar no help do zzmat apenas.

Funções matemáticas disponíveis.
Aritméticas:               | Trigonométricas:
 mmc    mdc                |  sen   cos   tan
 media  soma  produto      |  csc   sec   cot
 log    ln    raiz         |  asen  acos  atan
 somatoria    produtoria
 pow, potencia ou elevado

Combinatória:        | Sequências:          | Funções:
 fat                 |  pa  pa2  pg  lucas  |  area  volume  r3
 arranjo  arranjo_r  |  fibonacci  ou fib   |  det   vetor   d2p
 combinacao          |  tribonacci ou trib
 combinacao_r        |  mersenne  recaman  collatz

Equações:                  | Auxiliares:
 eq2g  egr    err          |  abs  int
 egc   egc3p  ege          |  sem_zeros
 newton ou binomio_newton  |  aleatorio  random
 conf_eq                   |  compara_num

Mais detalhes: zzmat função

Uso: zzmat [-pnumero] funções [número] [número]
Ex.: zzmat mmc 8 12
   zzmat media 5[2] 7 4[3]
   zzmat somatoria 3 9 2x+3
   zzmat -p3 sen 60g

.fi


.SH zzmcd

.nf
Cria diretórios e subdiretórios, e muda diretório de trabalho (primeiro).

Opções:
   -n: Cria os diretórios, mas não muda o diretório de trabalho atual.
   -s: Apenas simula o comando mkdir com os argumentos

Uso: zzmcd [-n|-s] <dir[/subdir]> [dir[/subdir]]
Ex.: zzmcd tmp1/tmp2

.fi


.SH zzmd5

.nf
Calcula o código MD5 dos arquivos informados, ou de um texto via STDIN.
Obs.: Wrapper portável para os comandos md5 (Mac) e md5sum (Linux).

Uso: zzmd5 [arquivo(s)]
Ex.: zzmd5 arquivo.txt
   cat arquivo.txt | zzmd5

.fi


.SH zzminiurl

.nf
Encurta uma URL utilizando o google ("https://goo.gl/").
Caso a URL já seja encurtada, será exibida a URL completa.
Obs.: Se a URL não tiver protocolo no início, será colocado http://
Uso: zzminiurl URL
Ex.: zzminiurl http://www.funcoeszz.net
   zzminiurl www.funcoeszz.net         # O http:// no início é opcional
   zzminiurl https://goo.gl/yz4cb9

.fi


.SH zzminusculas

.nf
Converte todas as letras para minúsculas, inclusive acentuadas.
Uso: zzminusculas [texto]
Ex.: zzminusculas NÃO ESTOU GRITANDO             # via argumentos
   echo NÃO ESTOU GRITANDOO | zzminusculas     # via STDIN

.fi


.SH zzmix

.nf
Mistura linha a linha 2 ou mais arquivos, mantendo a sequência.
Opções:
 -o <arquivo> - Define o arquivo de saída.
 -m - Toma como base o arquivo com menos linhas.
 -M - Toma como base o arquivo com mais linhas.
 -<numero> - Toma como base o arquivo na posição especificada.
 -p <relação de linhas> - numero de linhas de cada arquivo de origem.
 Obs1.: A relação são números de linhas de cada arquivo correspondente na
        sequência, justapostos separados por vírgula (,).
 Obs2.: Se a quantidade de linhas na relação for menor que a quantidade de
        arquivos, os arquivos excedentes adotam a último valor na relação.

Sem opção, toma como base o primeiro arquivo declarado.

Uso: zzmix [-m | -M | -<num>] [-o <arq>] [-p <relação>] arq1 arq2 [arqN] ...
Ex.: zzmix -m arquivo1 arquivo2 arquivo3  # Base no arquivo com menos linhas
   zzmix -2 arquivo1 arquivo2 arquivo3  # Base no segundo arquivo
   zzmix -o out.txt arquivo1 arquivo2   # Mixando para o arquivo out.txt
   zzmix -p 2,5,6 arq1 arq2 arq3
   # 2 linhas do arq1, 5 linhas do arq2 e 6 linhas do arq3,
   # e repete a sequência até o final.

.fi


.SH zzmoneylog

.nf
Consulta lançamentos do Moneylog, com pesquisa avançada e saldo total.
Obs.: Chamado sem argumentos, pesquisa o mês corrente.
Obs.: Não expande lançamentos recorrentes e parcelados.

Uso: zzmoneylog [-d data] [-v valor] [-t tag] [--total] [texto]
Ex.: zzmoneylog                       # Todos os lançamentos deste mês
   zzmoneylog mercado               # Procure por mercado
   zzmoneylog -t mercado            # Lançamentos com a tag mercado
   zzmoneylog -t mercado -d 2011    # Tag mercado em 2011
   zzmoneylog -t mercado --total    # Saldo total da tag mercado
   zzmoneylog -d 31/01/2011         # Todos os lançamentos desta data
   zzmoneylog -d 2011               # Todos os lançamentos de 2011
   zzmoneylog -d ontem              # Todos os lançamentos de ontem
   zzmoneylog -d mes                # Todos os lançamentos deste mês
   zzmoneylog -d mes --total        # Saldo total deste mês
   zzmoneylog -d 2011-0[123]        # Regex: que casa Jan/Fev/Mar de 2011
   zzmoneylog -v /                  # Todos os pagamentos parcelados

.fi


.SH zzmudaprefixo

.nf
Move os arquivos que tem um prefixo comum para um novo prefixo.
Opções:
-a, --antigo informa o prefixo antigo a ser trocado.
-n, --novo   informa o prefixo novo a ser trocado.
Uso: zzmudaprefixo -a antigo -n novo
Ex.: zzmudaprefixo -a "antigo_prefixo" -n "novo_prefixo"
   zzmudaprefixo -a "/tmp/antigo_prefixo" -n "/tmp/novo_prefixo"

.fi


.SH zznatal

.nf
http://www.ibb.org.br/vidanet
A mensagem "Feliz Natal" em vários idiomas.
Uso: zznatal [palavra]
Ex.: zznatal                   # busca um idioma aleatório
   zznatal russo             # Feliz Natal em russo

.fi


.SH zznerdcast

.nf
Lista os episódios do podcast NerdCast.

Opções para a listagem:
-n <número> - Quantidade de resultados retornados (padrão = 15)
-d <data>   - Filtra por uma data específica.
-m <mês>    - Filtra por um mês específico. Sem o ano seleciona atual.
-a <ano>    - Filtra por um ano em específico.

Obs.: No lugar de -d, -m, -a pode usar --data, --mês ou --mes, --ano.
      Na opção -d, <data> pode ser "hoje", "ontem" e "anteontem".
      Na opção -n, <número> se for igual a 0, não limita a quantidade.

Opções adicionais são consideradas termos a serem filtrados na consulta.

Uso: zznerdcast [-n <número>| -d <data> | -m <mês>| -a <ano>] [texto]
Ex.: zznerdcast
   zznerdcast -n 30
   zznerdcast -d 28.10.16
   zznerdcast -m 5/2014
   zznerdcast -a 2014 Empreendedor
   zznerdcast Terra

.fi


.SH zznomealeatorio

.nf
Gera um nome aleatório de N caracteres, alternando consoantes e vogais.
Obs.: Se nenhum parâmetro for passado, gera um nome de 6 caracteres.
Uso: zznomealeatorio [N]
Ex.: zznomealeatorio
   zznomealeatorio 8

.fi


.SH zznome

.nf
http://www.significado.origem.nom.br/
Dicionário de nomes, com sua origem, numerologia e arcanos do tarot.
Pode-se filtrar por significado, origem, letra (primeira letra), tarot
marca (no mundo), numerologia ou tudo - como segundo argumento (opcional).
Por padrão lista origem e significado.

Uso: zznome nome [significado|origem|letra|marca|numerologia|tarot|tudo]
Ex.: zznome maria
   zznome josé origem

.fi


.SH zznomefoto

.nf
Renomeia arquivos do diretório atual, arrumando a seqüência numérica.
Obs.: Útil para passar em arquivos de fotos baixadas de uma câmera.
Opções: -n  apenas mostra o que será feito, não executa
      -i  define a contagem inicial
      -d  número de dígitos para o número
      -p  prefixo padrão para os arquivos
      --dropbox  renomeia para data+hora da foto, padrão Dropbox
Uso: zznomefoto [-n] [-i N] [-d N] [-p TXT] arquivo(s)
Ex.: zznomefoto -n *                        # tire o -n para renomear!
   zznomefoto -n -p churrasco- *.JPG      # tire o -n para renomear!
   zznomefoto -n -d 4 -i 500 *.JPG        # tire o -n para renomear!
   zznomefoto -n --dropbox *.JPG          # tire o -n para renomear!

.fi


.SH zznoticiaslinux

.nf
Busca as últimas notícias sobre Linux em sites nacionais.
Obs.: Cada site tem uma letra identificadora que pode ser passada como
    parâmetro, para informar quais sites você quer pesquisar:

      B) Br-Linux             C) Canal Tech
      D) Diolinux             L) Linux Descomplicado
      Z) Linuxbuzz

Uso: zznoticiaslinux [sites]
Ex.: zznoticiaslinux
   zznoticiaslinux bv

.fi


.SH zznoticiassec

.nf
Busca as últimas notícias em sites especializados em segurança.
Obs.: Cada site tem uma letra identificadora que pode ser passada como
    parâmetro, para informar quais sites você quer pesquisar:

    C)ERT/CC            Linux T)oday - Security
    Linux S)ecurity     Security F)ocus

Uso: zznoticiassec [sites]
Ex.: zznoticiassec
   zznoticiassec cft

.fi


.SH zznumero

.nf
Formata um número como: inteiro, moeda, por extenso, entre outros.
Nota: Por extenso suporta 81 dígitos inteiros e até 26 casas decimais.

Opções:
-f <padrão|número>  Padrão de formatação do printf, incluindo %'d e %'.f
                    ou precisão se apenas informado um número
-p <prefixo>        Um prefixo para o número, se for R$ igual a opção -m
-s <sufixo>         Um sufixo para o número
-m | --moeda        Trata valor monetário, sobrepondo as configurações de
                    -p, -s e -f
-t                  Número parcialmente por extenso, ex: 2 milhões 350 mil
--texto             Número inteiramente por extenso, ex: quatro mil e cem
-l                  Uma classe numérica por linha, quando optar no número
                    por extenso
--de <formato>      Formato de entrada
--para <formato>    Formato de saída
--int               Parte inteira do número, sem arredondamento
--frac              Parte fracionária do número

Formatos para as opções --de e --para:
pt ou pt-br => português (brasil)
en          => inglês (americano)

Uso: zznumero [opções] <número>
Ex.: zznumero 12445.78                      # 12.445,78
   zznumero --texto 4567890,213           # quatro milhões, quinhentos...
   zznumero -m 85,345                     # R$ 85,34
   echo 748 | zznumero -f "%'.3f"         # 748,000

.fi


.SH zzora

.nf
http://ora-code.com
Retorna a descrição do erro Oracle (AAA-99999).
Uso: zzora numero_erro
Ex.: zzora 1234

.fi


.SH zzpad

.nf
Preenche um texto para um certo tamanho com outra string.

Opções:
-d, -r     Preenche à direita (padrão)
-e, -l     Preenche à esquerda
-a, -b     Preenche em ambos os lados
-x STRING  String de preenchimento (padrão=" ")

Uso: zzpad [-d | -e | -a] [-x STRING] <tamanho> [texto]
Ex.: zzpad -x 'NO' 21 foo     # fooNONONONONONONONONO
   zzpad -a -x '_' 9 foo    # ___foo___
   zzpad -d -x '♥' 9 foo    # foo♥♥♥♥♥♥
   zzpad -e -x '0' 9 123    # 000000123
   cat arquivo.txt | zzpad -x '_' 99

.fi


.SH zzpais

.nf
Lista os países.
Opções:
 -a: Todos os países
 -i: Informa o(s) idioma(s)
 -o: Exibe o nome do país e capital no idioma nativo
Outra opção qualquer é usado como filtro para pesquisar entre os países.
Obs.: Sem argumentos, mostra um país qualquer.

Uso: zzpais [palavra|regex]
Ex.: zzpais              # mostra um pais qualquer
   zzpais unidos       # mostra os países com "unidos" no nome
   zzpais -o nova      # mostra o nome original de países com "nova".
   zzpais ^Z           # mostra os países que começam com Z

.fi


.SH zzpalpite

.nf
Palpites de jogos para várias loterias: quina, megasena, lotomania, etc.
Aqui está a lista completa de todas as loterias suportadas:
quina, megasena, duplasena, lotomania, lotofácil, timemania, federal, loteca

Uso: zzpalpite [quina|megasena|duplasena|lotomania|lotofacil|federal|timemania|loteca]
Ex.: zzpalpite
   zzpalpite megasena
   zzpalpite megasena federal lotofacil

.fi


.SH zzpascoa

.nf
Mostra a data do domingo de Páscoa para qualquer ano.
Obs.: Se o ano não for informado, usa o atual.
Regra: Primeiro domingo após a primeira lua cheia a partir de 21 de março.
Uso: zzpascoa [ano]
Ex.: zzpascoa
   zzpascoa 1999

.fi


.SH zzpgsql

.nf
Lista os comandos SQL no PostgreSQL, numerando-os.
Pesquisa detalhe dos comando, ao fornecer o número na listagem a esquerda.
E filtra a busca se fornecer um texto.

Uso: zzpgsql [ código | filtro ]
Ex.: zzpgsql        # Lista os comandos disponíveis
   zzpgsql 20     # Consulta o comando ALTER SCHEMA
   zzpgsql alter  # Filtra os comandos que possuam alter na declaração

.fi


.SH zzphp

.nf
http://www.php.net/manual/pt_BR/indexes.functions.php
Lista completa com funções do PHP.
com a opção -d ou --detalhe busca mais informação da função
com a opção --atualiza força a atualização co cache local

Uso: zzphp <palavra|regex>
Ex.: zzphp --atualiza              # Força atualização do cache
   zzphp array                   # mostra as funções com "array" no nome
   zzphp -d mysql_fetch_object   # mostra descrição do  mysql_fetch_object
   zzphp ^X                      # mostra as funções que começam com X

.fi


.SH zzplay

.nf
Toca o arquivo de áudio, escolhendo o player mais adequado instalado.
Também pode tocar lista de reprodução (playlist).
Pode-se escolher o player principal passando-o como segundo argumento.
- Os players possíveis para cada tipo são:
wav, au, aiff        afplay, play, mplayer, cvlc, avplay, ffplay
mp2, mp3             afplay, mpg321, mpg123, mplayer, cvlc, avplay, ffplay
ogg                  ogg123, mplayer, cvlc, avplay, ffplay
aac, wma, mka        mplayer, cvlc, avplay, ffplay
pls, m3u, xspf, asx  mplayer, cvlc

Uso: zzplay <arquivo-de-áudio> [player]
Ex.: zzplay os_seminovos_escolha_ja_seu_nerd.mp3
   zzplay os_seminovos_eu_nao_tenho_iphone.mp3 cvlc   # priorizando o cvlc

.fi


.SH zzporcento

.nf
Calcula porcentagens.
Se informado um número, mostra sua tabela de porcentagens.
Se informados dois números, mostra a porcentagem relativa entre eles.
Se informados um número e uma porcentagem, mostra o valor da porcentagem.
Se informados um número e uma porcentagem com sinal, calcula o novo valor.

Uso: zzporcento valor [valor|[+|-]porcentagem%]
Ex.: zzporcento 500           # Tabela de porcentagens de 500
   zzporcento 500.0000      # Tabela para número fracionário (.)
   zzporcento 500,0000      # Tabela para número fracionário (,)
   zzporcento 5.000,00      # Tabela para valor monetário
   zzporcento 500 25        # Mostra a porcentagem de 25 para 500 (5%)
   zzporcento 500 1000      # Mostra a porcentagem de 1000 para 500 (200%)
   zzporcento 500,00 2,5%   # Mostra quanto é 2,5% de 500,00
   zzporcento 500,00 +2,5%  # Mostra quanto é 500,00 + 2,5%

.fi


.SH zzporta

.nf
http://pt.wikipedia.org/wiki/Lista_de_portas_de_protocolos
Mostra uma lista das portas de protocolos usados na internet.
Se houver um número como argumento, a listagem é filtrada pelo mesmo.

Uso: zzporta [porta]
Ex.: zzporta
   zzporta 513

.fi


.SH zzpronuncia

.nf
Fala a pronúncia correta de uma palavra em inglês.
Uso: zzpronuncia palavra
Ex.: zzpronuncia apple

.fi


.SH zzquimica

.nf
Exibe a relação dos elementos químicos.
Pesquisa na Wikipédia se informado o número atômico ou símbolo do elemento.

Uso: zzquimica [número|símbolo]
Ex.: zzquimica       # Lista de todos os elementos químicos
   zzquimica He    # Pesquisa o Hélio na Wikipédia
   zzquimica 12    # Pesquisa o Magnésio na Wikipédia

.fi


.SH zzramones

.nf
http://aurelio.net/doc/ramones.txt
Mostra uma frase aleatória, das letras de músicas da banda punk Ramones.
Obs.: Informe uma palavra se quiser frases sobre algum assunto especifico.
Uso: zzramones [palavra]
Ex.: zzramones punk
   zzramones

.fi


.SH zzrastreamento

.nf
http://www.correios.com.br
Acompanha encomendas via rastreamento dos Correios.
Uso: zzrastreamento <código_da_encomenda> ...
Ex.: zzrastreamento RK995267899BR
   zzrastreamento RK995267899BR RA995267899CN

.fi


.SH zzrepete

.nf
Repete um dado texto na quantidade de vezes solicitada.
Com a opção -l ou --linha cada repetição é uma nova linha.

Uso: zzrepete [-l | --linha] <repetições> <texto>
Ex.: zzrepete 15 Foo     # FooFooFooFooFooFooFooFooFooFooFooFooFooFooFoo

.fi


.SH zzromanos

.nf
Conversor de números romanos para hindu-arábicos e vice-versa.
Converte corretamente para romanos números até 3999999.
Converte corretamente para hindu-arábicos números até 4000.

Uso: zzromanos número
Ex.: zzromanos 1987                # Retorna: MCMLXXXVII
   zzromanos XLIII               # Retorna: 43

.fi


.SH zzrot13

.nf
Codifica/decodifica um texto utilizando a cifra ROT13.
Uso: zzrot13 texto
Ex.: zzrot13 texto secreto               # Retorna: grkgb frpergb
   zzrot13 grkgb frpergb               # Retorna: texto secreto
   echo texto secreto | zzrot13        # Retorna: grkgb frpergb

.fi


.SH zzrot47

.nf
Codifica/decodifica um texto utilizando a cifra ROT47.
Uso: zzrot47 texto
Ex.: zzrot47 texto secreto               # Retorna: E6IE@ D64C6E@
   zzrot47 E6IE@ D64C6E@               # Retorna: texto secreto
   echo texto secreto | zzrot47        # Retorna: E6IE@ D64C6E@

.fi


.SH zzrpmfind

.nf
http://rpmfind.net/linux
Procura por pacotes RPM em várias distribuições de Linux.
Obs.: A arquitetura padrão de procura é a i586.
Uso: zzrpmfind pacote [distro] [arquitetura]
Ex.: zzrpmfind sed
   zzrpmfind lilo mandr i586

.fi


.SH zzsecurity

.nf
Mostra os últimos 5 avisos de segurança de sistemas de Linux/UNIX.
Suportados:
 Debian, Ubuntu, FreeBSD, NetBSD, Gentoo, Arch, Mageia,
 Slackware, Suse, OpenSuse, Fedora.
Uso: zzsecurity [distros]
Ex.: zzsecurity
   zzsecurity mageia
   zzsecurity debian gentoo

.fi


.SH zzsemacento

.nf
Tira os acentos de todas as letras (áéíóú vira aeiou).
Uso: zzsemacento texto
Ex.: zzsemacento AÇÃO 1ª bênção           # Retorna: ACAO 1a bencao
   echo AÇÃO 1ª bênção | zzsemacento    # Retorna: ACAO 1a bencao

.fi


.SH zzsenha

.nf
Gera uma senha aleatória de N caracteres.
Obs.: Sem opções, a senha é gerada usando letras e números.

Opções: -p, --pro   Usa letras, números e símbolos para compor a senha
      -n, --num   Usa somente números para compor a senha
      -u, --uniq  Gera senhas com caracteres únicos (não repetidos)

Uso: zzsenha [--pro|--num] [n]     (padrão n=8)
Ex.: zzsenha
   zzsenha 10
   zzsenha --num 9
   zzsenha --pro 30
   zzsenha --uniq 10

.fi


.SH zzseq

.nf
Mostra uma seqüência numérica, um número por linha, ou outro formato.
É uma emulação do comando seq, presente no Linux.
Opções:
-f    Formato de saída (printf) para cada número, o padrão é '%d\en'
Uso: zzseq [-f formato] [número-inicial [passo]] número-final
Ex.: zzseq 10                   # de 1 até 10
   zzseq 5 10                 # de 5 até 10
   zzseq 10 5                 # de 10 até 5 (regressivo)
   zzseq 0 2 10               # de 0 até 10, indo de 2 em 2
   zzseq 10 -2 0              # de 10 até 0, indo de 2 em 2
   zzseq -f '%d:' 5           # 1:2:3:4:5:
   zzseq -f '%0.4d:' 5        # 0001:0002:0003:0004:0005:
   zzseq -f '(%d)' 5          # (1)(2)(3)(4)(5)
   zzseq -f 'Z' 5             # ZZZZZ

.fi


.SH zzsextapaixao

.nf
Mostra a data da sexta-feira da paixão para qualquer ano.
Obs.: Se o ano não for informado, usa o atual.
Regra: 2 dias antes do domingo de Páscoa.
Uso: zzsextapaixao [ano]
Ex.: zzsextapaixao
   zzsextapaixao 2008

.fi


.SH zzsheldon

.nf
Exibe aleatoriamente uma frase do Sheldon, do seriado The Big Bang Theory.
Com a opção -t ou --traduzir mostra os diálogos traduzidos.

Uso: zzsheldon [-t|--traduzir]
Ex.: zzsheldon

.fi


.SH zzshuffle

.nf
Desordena as linhas de um texto (ordem aleatória).
Uso: zzshuffle [arquivo(s)]
Ex.: zzshuffle /etc/passwd         # desordena o arquivo de usuários
   cat /etc/passwd | zzshuffle   # o arquivo pode vir da entrada padrão

.fi


.SH zzsigla

.nf
http://www.acronymfinder.com
Dicionário de siglas, sobre qualquer assunto (como DVD, IMHO, WYSIWYG).
Obs.: Há um limite diário de consultas por IP, pode parar temporariamente.
Uso: zzsigla sigla
Ex.: zzsigla RTFM

.fi


.SH zzsplit

.nf
Separa um arquivo linha a linha alternadamente em 2 ou mais arquivos.
Usa o mesmo nome do arquivo, colocando sufixo numérico sequencial.

Opção:
 -p <relação de linhas> - numero de linhas de cada arquivo de destino.
 Obs1.: A relação são números de linhas de cada arquivo correspondente na
        sequência, justapostos separados por vírgula (,).
 Obs2.: Se a quantidade de linhas na relação for menor que a quantidade de
        arquivos, os arquivos excedentes adotam a último valor na relação.
 Obs3.: Os números negativos na relação, saltam as linha informadas
        sem repassar ao arquivo destino.

Uso: zzsplit -p <relação> [<numero>] | <numero> <arquivo>
Ex.: zzsplit 3 arq.txt  # Separa em 3: arq.txt.1, arq.txt.2, arq.txt.3
   zzsplit -p 3,5,4 5 arq.txt  # Separa em 5 arquivos
   # 3 linhas no arq.txt.1, 5 linhas no arq.txt.2 e 4 linhas nos demais.
   zzsplit -p 3,4,2 arq.txt    # Separa em 3 arquivos
   # 3 linhas no arq.txt.1, 4 linhas no arq.txt.2 e 2 linhas no arq.txt.3
   zzsplit -p 2,-3,4 arq.txt   # Separa em 2 arquivos
   # 2 linhas no arq.txt.1, pula 3 linhas e 4 linhas no arq.txt.3

.fi


.SH zzsqueeze

.nf
Reduz vários espaços consecutivos vertical ou horizontalmente em apenas um.

Opções:
 -l ou --linha: Apenas linhas vazias consecutivas, se reduzem a uma.
 -c ou --coluna: Espaços consecutivos em cada linha, são unidos em um.

Obs.: Linhas inteiras com espaços ou tabulações,
     tornam-se linhas de comprimento zero (sem nenhum caractere).

Uso: zzsqueeze [-l|--linha] [-c|--coluna] arquivo
Ex.: zzsqueeze arquivo.txt
   zzsqueeze -l arq.txt   # Apenas retira linhas consecutivas em branco.
   zzsqueeze -c arq.txt   # Transforma em 1 espaço, vários espaços juntos.
   cat arquivo | zzsqueeze

.fi


.SH zzss

.nf
Protetor de tela (Screen Saver) para console, com cores e temas.
Temas: mosaico, espaco, olho, aviao, jacare, alien, rosa, peixe, siri.
Obs.: Aperte Ctrl+C para sair.
Uso: zzss [--rapido|--fundo] [--tema <tema>] [texto]
Ex.: zzss
   zzss fui ao banheiro
   zzss --rapido /
   zzss --fundo --tema peixe

.fi


.SH zzstr2hexa

.nf
Converte string em bytes em hexadecimal equivalente.
Uso: zzstr2hexa [string]
Ex.: zzstr2hexa @MenteBrilhante    # 40 4d 65 6e 74 65 42 72 69 6c 68 61 6e…
   zzstr2hexa bin                # 62 69 6e
   echo bin | zzstr2hexa         # 62 69 6e

.fi


.SH zzsubway

.nf
Mostra uma sugestão de sanduíche para pedir na lanchonete Subway.
Obs.: Se não gostar da sugestão, chame a função novamente para ter outra.
Uso: zzsubway
Ex.: zzsubway

.fi


.SH zztabuada

.nf
Exibe a tabela de tabuada de um número.
Com 1 argumento:
 Tabuada de qualquer número inteiro de 1 a 10.

Com 2 argumentos:
 Tabuada de qualquer número inteiro de 1 ao segundo argumento.
 O segundo argumento só pode ser um número positivo de 1 até 99, inclusive.

Se não for informado nenhum argumento será impressa a tabuada de 1 a 9.

Uso: zztabuada [número [número]]
Ex.: zztabuada
   zztabuada 2
   zztabuada -176
   zztabuada 5 15  # Tabuada do 5, mas multiplicado de 1 até o 15.

.fi


.SH zztac

.nf
Inverte a ordem das linhas, mostrando da última até a primeira.
É uma emulação (portável) do comando tac, presente no Linux.

Uso: zztac [arquivos]
Ex.: zztac /etc/passwd
   zztac arquivo.txt outro.txt
   cat /etc/passwd | zztac

.fi


.SH zztempo

.nf
Mostra previsão do tempo obtida em http://wttr.in/ por meio do comando curl.
Mostra as condições do tempo (clima) em um determinado local.
Se nenhum parâmetro for passado, é apresentada a previsão de Brasília.
As siglas de aeroporto também podem ser utilizadas.

Opções:

-l, --lang, --lingua
 Exibe a previsão em uma das línguas disponíveis: az be bg bs ca cy cs
 da de el eo es et fi fr hi hr hu hy is it  ja jv ka kk ko ky lt lv mk
 ml nl nn pt pl ro ru sk sl sr sr-lat sv sw th tr uk uz vi zh zu

-u, --us
 Retorna leitura em unidades USCS - United States customary units -
 Unidades Usuais nos Estados Unidos. Isto é: "°F" para temperatura,
 "mph" para velocidade do vento,  "mi" para visibilidade e "in" para
 precipitação.

-v, --vento
 Retorna vento em m/s ao invés de km/h ou mph.

-m, --monocromatico
 Nao utiliza comandos de cores no terminal

-s, --simples
 Retorna versão curta, com previsão de meio-dia e noite apenas.
 Utiliza 63 caracteres de largura contra os 125 da resposta completa.

-c, --completo
 Retorna versão completa, com 4 horários ao longo do dia.
 Utiliza 125 caracteres de largura.

-d, --dias
Determina o número de dias (entre 0 e 3) de previsão apresentados.
 -d 0 = apenas tempo atual. Também pode se chamado com -0
 -d 1 = tempo atual mais 1 dia. Também pode se chamado com -1
 -d 2 = tempo atual mais 2 dias. Também pode se chamado com -2
 -d 3 = tempo atual mais 3 dias. Padrão.

Uso: zztempo [parametros] <localidade>
Ex.: zztempo 'São Paulo'
   zztempo cwb
   zztempo -d 0 Curitiba
   zztempo -2 -l fr -s Miami

.fi


.SH zztestar

.nf
Testa a validade do número no tipo de categoria selecionada.
Nada é ecoado na saída padrão, apenas deve-se analisar o código de retorno.
Pode-se ecoar a saída de erro usando a opção -e antes da categoria.

 Categorias:
ano                      =>  Ano válido
ano_bissexto | bissexto  =>  Ano Bissexto
exp | exponencial        =>  Número em notação científica
numero | numero_natural  =>  Número Natural ( inteiro positivo )
numero_sinal | inteiro   =>  Número Inteiro ( positivo ou negativo )
numero_fracionario       =>  Número Fracionário ( casas decimais )
numero_real              =>  Número Real ( casas decimais possíveis )
complexo                 =>  Número Complexo ( a+bi )
dinheiro                 =>  Formato Monetário ( 2 casas decimais )
bin | binario            =>  Número Binário ( apenas 0 e 1 )
octal | octadecimal      =>  Número Octal ( de 0 a 7 )
hexa | hexadecimal       =>  Número Hexadecimal ( de 0 a 9 e A até F )
ip                       =>  Endereço de rede IPV4
ip6 | ipv6               =>  Endereço de rede IPV6
mac                      =>  Código MAC Address válido
data                     =>  Data com formatação válida ( dd/mm/aaa )
hora                     =>  Hora com formatação válida ( hh:mm )

Obs.: ano, ano_bissextto e os
      números naturais, inteiros e reais sem separador de milhar.

Uso: zztestar [-e] categoria número
Ex.: zztestar ano 1999
   zztestar ip 192.168.1.1
   zztestar hexa 4ca9
   zztestar numero_real -45,678

.fi


.SH zztimer

.nf
Mostra um cronômetro regressivo.
Opções:
-n: Os números são ampliados para um formato de 5 linhas e 6 colunas.
-x char: Igual a -n, mas os números são compostos pelo caracter "char".
-y nums chars: Troca os nums por chars, igual ao comando 'y' no sed.
   Obs.: nums e chars tem que ter a mesma quantidade de caracteres.
-c: Apenas converte o tempo em segundos.
-s: Aguarda o tempo como sleep, sem mostrar o cronômetro.
-p: Usa uma temporização mais precisa, porém usa mais recursos.
--teste: Desabilita centralização (usar depois das opções -n,-x,-y).

Obs: Máximo de 99 horas.
   Opções -n, -x, -y sempre centralizada na tela, exceto se usar --teste.

Uso: zztimer [-c|-s|-n|-x char|-y nums chars] [-p] [[hh:]mm:]ss
Ex.: zztimer 90           # Cronomêtro regressivo a partir de 1:30
   zztimer 2:56         # Cronometragem regressiva simples.
   zztimer -c 2:22      # Exibe o tempo em segundos (no caso 142)
   zztimer -s 5:34      # Exibe o tempo em segundos e aguarda o tempo.
   zztimer --centro 20  # Centralizado horizontal e verticalmente
   zztimer -n 1:7:23    # Formato ampliado do número
   zztimer -x H 65      # Com números feito pela letra 'H'
   zztimer -y 0123456789 9876543210 60  # Troca os números

.fi


.SH zztool

.nf
.fi


.SH zztop

.nf
Lista os 10 computadores mais rápidos do mundo.
Sem argumentos usa a listagem mais recente.
Definindo categoria, quantifica os 500 computadores mais rápidos.

Argumentos de ajuda:
 -c: Exibe categorias possíveis
 -l: Exibe as listas disponíveis

Argumentos de listagem:
 [categoria]: Seleciona a categoria desejada.
 [lista]:     Seleciona a lista, se omitida mostra mais recente.
Obs: Podem ser usadas em conjunto

Uso: zztop [-c|-l] [categoria] [lista]
Ex.: zztop             # Lista os 10 mais rápidos.
   zztop osfam 23    # Famílias de OS em Junho de 2004 ( Virada Linux! )
   zztop country     # Quantifica por pais entre os 500 mais velozes
   zztop -c          # Lista as categorias possíveis da listagem
   zztop -l          # Exibe todas as listas disponíveis

.fi


.SH zztradutor

.nf
http://translate.google.com
Google Tradutor, para traduzir frases para vários idiomas.
Caso não especificado o idioma, a tradução será português -> inglês.
Use a opção -l ou --lista para ver todos os idiomas disponíveis.
Use a opção -a ou --audio para ouvir a frase na voz feminina do google.

Alguns idiomas populares são:
   pt = português         fr = francês
   en = inglês            it = italiano
   es = espanhol          de = alemão

Uso: zztradutor [de-para] palavras
Ex.: zztradutor o livro está na mesa    # the book is on the table
   zztradutor pt-en livro             # book
   zztradutor pt-es livro             # libro
   zztradutor pt-de livro             # Buch
   zztradutor de-pt Buch              # livro
   zztradutor de-es Buch              # Libro
   cat arquivo | zztradutor           # Traduz o conteúdo do arquivo
   zztradutor --lista                 # Lista todos os idiomas
   zztradutor --lista eslo            # Procura por "eslo" nos idiomas
   zztradutor --audio                 # Gera um arquivo OUT.WAV
   echo "teste" | zztradutor          # test

.fi


.SH zztranspor

.nf
Trocar linhas e colunas de um arquivo, fazendo uma simples transposição.
Opções:
-d <sep>                        define o separador de campos na entrada.
-D, --output-delimiter <sep>  define o separador de campos na saída.

O separador na entrada pode ser 1 ou mais caracteres ou uma ER.
Se não for declarado assume-se espaços em branco como separador.
Conforme padrão do awk, o default seria FS = "[ \et]+".

Se o separador de saída não for declarado, assume o mesmo da entrada.
Caso a entrada também não seja declarada assume-se como um espaço.
Conforme padrão do awk, o default é OFS = " ".

Se o separador da entrada é uma ER, é bom declarar o separador de saída.

Uso: zztranspor [-d <sep>] [-D | --output-delimiter <sep>] <arquivo>
Ex.: zztranspor -d ":" --output-delimiter "-" num.txt
   sed -n '2,5p' num.txt | zztranspor -d '[\et:]' -D '\et'

.fi


.SH zztrim

.nf
Apaga brancos (" " \et \en) ao redor do texto: direita, esquerda, cima, baixo.
Obs.: Linhas que só possuem espaços e tabs são consideradas em branco.

Opções:
-t, --top         Apaga as linhas em branco do início do texto
-b, --bottom      Apaga as linhas em branco do final do texto
-l, --left        Apaga os brancos do início de todas as linhas
-r, --right       Apaga os brancos do final de todas as linhas
-V, --vertical    Apaga as linhas em branco do início e final (-t -b)
-H, --horizontal  Apaga os brancos do início e final das linhas (-l -r)

Uso: zztrim [opções] [texto]
Ex.: zztrim "   foo bar   "           # "foo bar"
   zztrim -l "   foo bar   "        # "foo bar   "
   zztrim -r "   foo bar   "        # "   foo bar"
   echo "   foo bar   " | zztrim    # "foo bar"

.fi


.SH zztrocaarquivos

.nf
Troca o conteúdo de dois arquivos, mantendo suas permissões originais.
Uso: zztrocaarquivos arquivo1 arquivo2
Ex.: zztrocaarquivos /etc/fstab.bak /etc/fstab

.fi


.SH zztrocaextensao

.nf
Troca a extensão dos arquivos especificados.
Com a opção -n, apenas mostra o que será feito, mas não executa.
Uso: zztrocaextensao [-n] antiga nova arquivo(s)
Ex.: zztrocaextensao -n .doc .txt *          # tire o -n para renomear!

.fi


.SH zztrocapalavra

.nf
Troca uma palavra por outra, nos arquivos especificados.
Obs.: Além de palavras, é possível usar expressões regulares.
Uso: zztrocapalavra antiga nova arquivo(s)
Ex.: zztrocapalavra excessão exceção *.txt

.fi


.SH zztv

.nf
Mostra a programação da TV, diária ou semanal, com escolha de emissora.

Opções:
 canais - lista os canais com seus códigos para consulta.

 <código canal> - Programação do canal escolhido.
 Obs.: Seguido de "semana" ou "s": toda programação das próximas semanas.
     Se for seguido de uma data, mostra a programação da data informada.

 cod <número> - mostra um resumo do programa.
Obs: número obtido pelas listagens da programação do canal consultado.

Programação corrente:
 doc ou documentario, esportes ou futebol, filmes, infantil, variedades
 series ou seriados, aberta, todos ou agora (padrão).

Uso: zztv [<código canal> [s | <DATA>]]  ou  zztv [cod <número> | canais]
Ex.: zztv CUL          # Programação da TV Cultura
   zztv fox 31/5     # Programação da Fox na data, se disponível
   zztv cod 3235238  # Detalhes do programa identificado pelo código

.fi


.SH zztweets

.nf
Busca as mensagens mais recentes de um usuário do Twitter.
Use a opção -n para informar o número de mensagens (padrão é 5, máx 20).

Uso: zztweets [-n N] username
Ex.: zztweets oreio
   zztweets -n 10 oreio

.fi


.SH zzunescape

.nf
Restaura caracteres codificados como entidades HTML e XML (&lt; &#62; ...).
Entende entidades (&gt;), códigos decimais (&#62;) e hexadecimais (&#x3E;).

Opções: --html  Restaura caracteres HTML
      --xml   Restaura caracteres XML

Uso: zzunescape [--html] [--xml] [arquivo(s)]
Ex.: zzunescape --xml arquivo.xml
   zzunescape --html arquivo.html
   cat arquivo.html | zzunescape --html

.fi


.SH zzunicode2ascii

.nf
Converte caracteres Unicode (UTF-8) para seus similares ASCII (128).

Uso: zzunicode2ascii [arquivo(s)]
Ex.: zzunicode2ascii arquivo.txt
   cat arquivo.txt | zzunicode2ascii

.fi


.SH zzuniq

.nf
Retira as linhas repetidas, consecutivas ou não.
Obs.: Não altera a ordem original das linhas, diferente do sort|uniq.

Uso: zzuniq [arquivo(s)]
Ex.: zzuniq /etc/inittab
   cat /etc/inittab | zzuniq

.fi


.SH zzunix2dos

.nf
Converte arquivos texto no formato Unix (LF) para o Windows/DOS (CR+LF).
Uso: zzunix2dos arquivo(s)
Ex.: zzunix2dos frases.txt
   cat arquivo.txt | zzunix2dos

.fi


.SH zzurldecode

.nf
http://en.wikipedia.org/wiki/Percent-encoding
Decodifica textos no formato %HH, geralmente usados em URLs (%40 → @).

Uso: zzurldecode [texto]
Ex.: zzurldecode '%73%65%67%72%65%64%6F'
   echo 'http%3A%2F%2F' | zzurldecode

.fi


.SH zzurlencode

.nf
http://en.wikipedia.org/wiki/Percent-encoding
Codifica o texto como %HH, para ser usado numa URL (a/b → a%2Fb).
Obs.: Por padrão, letras, números e _.~- não são codificados (RFC 3986)

Opções:
-t, --todos  Codifica todos os caracteres, sem exceção
-n STRING    Informa caracteres adicionais que não devem ser codificados

Uso: zzurlencode [texto]
Ex.: zzurlencode http://www            # http%3A%2F%2Fwww
   zzurlencode -n : http://www       # http:%2F%2Fwww
   zzurlencode -t http://www         # %68%74%74%70%3A%2F%2F%77%77%77
   zzurlencode -t -n w/ http://www   # %68%74%74%70%3A//www

.fi


.SH zzutf8

.nf
Converte o texto para UTF-8, se necessário.
Obs.: Caso o texto já seja UTF-8, não há conversão.

Uso: zzutf8 [arquivo]
Ex.: zzutf8 /etc/passwd
   zzutf8 index-iso.html
   echo Bênção | zzutf8        # Bênção
   printf '\e341\en' | zzutf8    # á

.fi


.SH zzvdp

.nf
https://vidadeprogramador.com.br
Mostra o texto das últimas tirinhas de Vida de Programador.
Sem opção mostra a tirinha mais recente.
Se a opção for um número, mostra a tirinha que ocupa essa ordem
Se a opção for 0, mostra todas mais recentes

Uso: zzvdp [número]
Ex.: zzvdp    # Mostra a tirinha mais recente
   zzvdp 5  # Mostra a quinta tirinha mais recente
   zzvdp 0  # Mostra todas as tirinhas mais recentes

.fi


.SH zzvira

.nf
Vira um texto, de trás pra frente (rev) ou de ponta-cabeça.
Ideia original de: http://www.revfad.com/flip.html (valeu @andersonrizada)

Uso: zzvira [-X|-E] texto
Ex.: zzvira Inverte tudo             # odut etrevnI
   zzvira -X De pernas pro ar      # ɹɐ oɹd sɐuɹǝd ǝp
   zzvira -E De pernas pro ar      # pǝ dǝɹuɐs dɹo ɐɹ

.fi


.SH zzwc

.nf
Contabiliza total de bytes, caracteres, palavras ou linhas de um arquivo.
Ou exibe tamanho da maior linha em bytes, caracteres ou palavras.
Opcionalmente exibe as maiores linhas, desse arquivo.
Também aceita receber dados pela entrada padrão (stdin).
É uma emulação do comando wc, que não contabiliza '\er' e '\en'.

Opções:
-c  total de bytes
-m  total de caracteres
-l  total de linhas
-w  total de palavras
-C, -L, -W  maior linha em bytes, caracteres ou palavras respectivamente
-p Exibe a maior linha em bytes, caracteres ou palavras,
   usado junto com as opções -C, -L e -W.

 Se as opções forem omitidas adota -l -w -c por padrão.

Uso: zzwc [-c|-C|-m|-l|-L|-w|-W] [-p] arquivo
Ex.: echo "12345"       | zzwc -c     # 5
   printf "abcde"     | zzwc -m     # 5
   printf "abc\e123"   | zzwc -l     # 2
   printf "xz\en789\en" | zzwc -L     # 3
   printf "wk\en456"   | zzwc -M -p  # 456

.fi


.SH zzwikipedia

.nf
http://www.wikipedia.org
Procura na Wikipédia, a enciclopédia livre.
Obs.: Se nenhum idioma for especificado, é utilizado o português.

Idiomas: de (alemão)    eo (esperanto)  es (espanhol)  fr (francês)
       it (italiano)  ja (japonês)    la (latin)     pt (português)

Uso: zzwikipedia [-idioma] palavra(s)
Ex.: zzwikipedia sed
   zzwikipedia Linus Torvalds
   zzwikipedia -pt Linus Torvalds

.fi


.SH zzxml

.nf
Parser simples (e limitado) para arquivos XML/HTML.
Obs.: Este parser é usado pelas Funções ZZ, não serve como parser genérico.
Obs.: Necessário pois não há ferramenta portável para lidar com XML no Unix.

Opções: --tidy        Reorganiza o código, deixando uma tag por linha
      --tag NOME    Extrai (grep) todas as tags NOME e seu conteúdo
      --notag NOME  Exclui (grep -v) todas as tags NOME e seu conteúdo
      --list        Lista sem repetição as tags existentes no arquivo
      --indent      Promove a indentação das tags
      --untag       Remove todas as tags, deixando apenas texto
      --untag=NOME  Remove apenas a tag NOME, deixando o seu conteúdo
      --unescape    Converte as entidades &foo; para caracteres normais
Obs.: --notag tem precedência sobre --tag e --untag.
    --untag tem precedência sobre --tag.

Uso: zzxml <opções> [arquivo(s)]
Ex.: zzxml --tidy arquivo.xml
   zzxml --untag --unescape arq.xml                   # xml -> txt
   zzxml --untag=item arq.xml                         # Apaga tags "item"
   zzxml --tag title --untag --unescape arq.xml       # títulos
   cat arq.xml | zzxml --tag item | zzxml --tag title # aninhado
   zzxml --tag item --tag title arq.xml               # tags múltiplas
   zzxml --notag link arq.xml                         # Sem tag e conteúdo
   zzxml --indent arq.xml                             # tags indentadas

.fi


.SH zzzz

.nf
Mostra informações sobre as funções, como versão e localidade.
Opções: --atualiza  baixa a versão mais nova das funções
      --teste     testa se a codificação e os pré-requisitos estão OK
      --bashrc    instala as funções no ~/.bashrc
      --tcshrc    instala as funções no ~/.tcshrc
      --zshrc     instala as funções no ~/.zshrc
Uso: zzzz [--atualiza|--teste|--bashrc|--tcshrc|--zshrc]
Ex.: zzzz
   zzzz --teste

.fi


.\" man code generated by txt2tags 2.6 (http://txt2tags.org)
.\" cmdline: txt2tags manpage.t2t
