/*
 * Decompiled with CFR 0.152.
 */
package friendless.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public final class HCodeLayout
implements LayoutManager {
    private int hgap;
    private String usual;
    private Hashtable codes;
    private boolean debug;

    public HCodeLayout() {
        this("", 4, false);
    }

    public HCodeLayout(String string, int n) {
        this(string, n, false);
    }

    public HCodeLayout(String string, int n, boolean bl) {
        if (string == null) {
            string = "";
        }
        this.usual = string;
        this.hgap = n;
        this.codes = new Hashtable();
        this.debug = bl;
    }

    public void addLayoutComponent(String string, Component component) {
        this.codes.put(component, string);
    }

    private boolean hasCode(StringBuffer stringBuffer, char c) {
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == c) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private int getExpansion(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == 'x') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private StringBuffer getCode(Component component) {
        String string = (String)this.codes.get(component);
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.usual + string);
        Vector<Character> vector = new Vector<Character>();
        boolean bl = false;
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (c == '-') {
                bl = true;
            } else if (c == '+') {
                bl = false;
            } else {
                Character c2 = new Character(c);
                if (bl) {
                    vector.removeElement(c2);
                } else {
                    vector.addElement(c2);
                }
            }
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer(vector.size());
        int n2 = 0;
        while (n2 < vector.size()) {
            Character c = (Character)vector.elementAt(n2);
            stringBuffer2.append(c.charValue());
            ++n2;
        }
        return stringBuffer2;
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        boolean bl;
        Serializable serializable;
        Rectangle rectangle = container.getBounds();
        Insets insets = container.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.debug) {
            System.out.println("HCodeLayout: Bounds: " + rectangle);
            System.out.println("HCodeLayout: Insets: " + insets);
        }
        int n3 = rectangle.height - insets.top - insets.bottom;
        int n4 = rectangle.width - insets.left - insets.right;
        int n5 = 0;
        int n6 = 0;
        Component[] componentArray = container.getComponents();
        n5 = 0;
        int n7 = 0;
        while (n7 < componentArray.length) {
            Dimension dimension = componentArray[n7].getPreferredSize();
            serializable = this.getCode(componentArray[n7]);
            int n8 = this.getExpansion((StringBuffer)serializable);
            if (n8 > 0) {
                n6 += n8;
            } else {
                n5 += dimension.width;
            }
            n5 += this.hgap;
            ++n7;
        }
        if ((n5 -= this.hgap) >= n4) {
            bl = true;
            n5 = 0;
            int n9 = 0;
            while (n9 < componentArray.length) {
                serializable = componentArray[n9].getMinimumSize();
                StringBuffer stringBuffer = this.getCode(componentArray[n9]);
                n2 = this.getExpansion(stringBuffer);
                if (n2 > 0) {
                    n6 += n2;
                } else {
                    n5 += ((Dimension)serializable).width;
                }
                n5 += this.hgap;
                ++n9;
            }
            n = 0;
            if (n6 > 0 && (n5 -= this.hgap) < n4) {
                n = (n4 - n5) / n6;
            }
        } else if (n6 == 0) {
            bl = false;
            n = 0;
        } else {
            bl = false;
            n = (n4 - n5) / n6;
        }
        n5 = insets.left;
        int n10 = 0;
        while (n10 < componentArray.length) {
            int n11;
            serializable = null;
            int n12 = 0;
            serializable = bl ? componentArray[n10].getMinimumSize() : componentArray[n10].getPreferredSize();
            StringBuffer stringBuffer = this.getCode(componentArray[n10]);
            n2 = this.getExpansion(stringBuffer);
            if (n2 > 0) {
                n12 = n * n2;
                n11 = 0;
            } else {
                n12 = ((Dimension)serializable).width;
                n11 = ((Dimension)serializable).height;
            }
            int n13 = insets.top;
            if (this.hasCode(stringBuffer, 'f')) {
                n11 = n3;
            } else if (n11 == 0 || n11 > n3) {
                n11 = n3;
            }
            n13 = this.hasCode(stringBuffer, 'b') ? n3 + insets.top - n11 : (this.hasCode(stringBuffer, 't') ? insets.top : insets.top + (n3 - n11) / 2);
            componentArray[n10].setBounds(n5, n13, n12, n11);
            n5 += n12;
            n5 += this.hgap;
            ++n10;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        int n3 = 0;
        while (n3 < componentArray.length) {
            dimension = componentArray[n3].getMinimumSize();
            n2 += dimension.width;
            n2 += this.hgap;
            if (dimension.height > n) {
                n = dimension.height;
                if (this.debug) {
                    System.out.println("HCodeLayout: calc min: " + componentArray[n3]);
                }
            }
            ++n3;
        }
        dimension = new Dimension(n2 - this.hgap, n);
        Insets insets = container.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        if (this.debug) {
            System.out.println("HCodeLayout: Minimum = " + dimension);
        }
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        int n3 = 0;
        while (n3 < componentArray.length) {
            dimension = componentArray[n3].getPreferredSize();
            n2 += dimension.width;
            n2 += this.hgap;
            if (dimension.height > n) {
                n = dimension.height;
                if (this.debug) {
                    System.out.println("HCodeLayout: calc pref: " + componentArray[n3]);
                }
            }
            ++n3;
        }
        dimension = new Dimension(n2 - this.hgap, n);
        Insets insets = container.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
    }

    public String toString() {
        return this.getClass().getName();
    }
}

