// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file extensibility_struct.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__EXTENSIBILITY_STRUCT_HPP
#define FAST_DDS_GENERATED__EXTENSIBILITY_STRUCT_HPP

#include <cstdint>
#include <utility>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(EXTENSIBILITY_STRUCT_SOURCE)
#define EXTENSIBILITY_STRUCT_DllAPI __declspec( dllexport )
#else
#define EXTENSIBILITY_STRUCT_DllAPI __declspec( dllimport )
#endif // EXTENSIBILITY_STRUCT_SOURCE
#else
#define EXTENSIBILITY_STRUCT_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define EXTENSIBILITY_STRUCT_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure FinalStruct defined by the user in the IDL file.
 * @ingroup extensibility_struct
 */
class FinalStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport FinalStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~FinalStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object FinalStruct that will be copied.
     */
    eProsima_user_DllExport FinalStruct(
            const FinalStruct& x)
    {
                    m_my_value = x.m_my_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object FinalStruct that will be copied.
     */
    eProsima_user_DllExport FinalStruct(
            FinalStruct&& x) noexcept
    {
        m_my_value = x.m_my_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object FinalStruct that will be copied.
     */
    eProsima_user_DllExport FinalStruct& operator =(
            const FinalStruct& x)
    {

                    m_my_value = x.m_my_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object FinalStruct that will be copied.
     */
    eProsima_user_DllExport FinalStruct& operator =(
            FinalStruct&& x) noexcept
    {

        m_my_value = x.m_my_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const FinalStruct& x) const
    {
        return (m_my_value == x.m_my_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x FinalStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const FinalStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member my_value
     * @param _my_value New value for member my_value
     */
    eProsima_user_DllExport void my_value(
            uint8_t _my_value)
    {
        m_my_value = _my_value;
    }

    /*!
     * @brief This function returns the value of member my_value
     * @return Value of member my_value
     */
    eProsima_user_DllExport uint8_t my_value() const
    {
        return m_my_value;
    }

    /*!
     * @brief This function returns a reference to member my_value
     * @return Reference to member my_value
     */
    eProsima_user_DllExport uint8_t& my_value()
    {
        return m_my_value;
    }



private:

    uint8_t m_my_value{0};

};
/*!
 * @brief This class represents the structure MutableStruct defined by the user in the IDL file.
 * @ingroup extensibility_struct
 */
class MutableStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MutableStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MutableStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MutableStruct that will be copied.
     */
    eProsima_user_DllExport MutableStruct(
            const MutableStruct& x)
    {
                    m_my_value = x.m_my_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MutableStruct that will be copied.
     */
    eProsima_user_DllExport MutableStruct(
            MutableStruct&& x) noexcept
    {
        m_my_value = x.m_my_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MutableStruct that will be copied.
     */
    eProsima_user_DllExport MutableStruct& operator =(
            const MutableStruct& x)
    {

                    m_my_value = x.m_my_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MutableStruct that will be copied.
     */
    eProsima_user_DllExport MutableStruct& operator =(
            MutableStruct&& x) noexcept
    {

        m_my_value = x.m_my_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MutableStruct& x) const
    {
        return (m_my_value == x.m_my_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x MutableStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MutableStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member my_value
     * @param _my_value New value for member my_value
     */
    eProsima_user_DllExport void my_value(
            uint8_t _my_value)
    {
        m_my_value = _my_value;
    }

    /*!
     * @brief This function returns the value of member my_value
     * @return Value of member my_value
     */
    eProsima_user_DllExport uint8_t my_value() const
    {
        return m_my_value;
    }

    /*!
     * @brief This function returns a reference to member my_value
     * @return Reference to member my_value
     */
    eProsima_user_DllExport uint8_t& my_value()
    {
        return m_my_value;
    }



private:

    uint8_t m_my_value{0};

};
/*!
 * @brief This class represents the structure AppendableStruct defined by the user in the IDL file.
 * @ingroup extensibility_struct
 */
class AppendableStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport AppendableStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~AppendableStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object AppendableStruct that will be copied.
     */
    eProsima_user_DllExport AppendableStruct(
            const AppendableStruct& x)
    {
                    m_my_value = x.m_my_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object AppendableStruct that will be copied.
     */
    eProsima_user_DllExport AppendableStruct(
            AppendableStruct&& x) noexcept
    {
        m_my_value = x.m_my_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object AppendableStruct that will be copied.
     */
    eProsima_user_DllExport AppendableStruct& operator =(
            const AppendableStruct& x)
    {

                    m_my_value = x.m_my_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object AppendableStruct that will be copied.
     */
    eProsima_user_DllExport AppendableStruct& operator =(
            AppendableStruct&& x) noexcept
    {

        m_my_value = x.m_my_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const AppendableStruct& x) const
    {
        return (m_my_value == x.m_my_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x AppendableStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const AppendableStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member my_value
     * @param _my_value New value for member my_value
     */
    eProsima_user_DllExport void my_value(
            uint8_t _my_value)
    {
        m_my_value = _my_value;
    }

    /*!
     * @brief This function returns the value of member my_value
     * @return Value of member my_value
     */
    eProsima_user_DllExport uint8_t my_value() const
    {
        return m_my_value;
    }

    /*!
     * @brief This function returns a reference to member my_value
     * @return Reference to member my_value
     */
    eProsima_user_DllExport uint8_t& my_value()
    {
        return m_my_value;
    }



private:

    uint8_t m_my_value{0};

};
/*!
 * @brief This class represents the structure ExtensibilityStruct defined by the user in the IDL file.
 * @ingroup extensibility_struct
 */
class ExtensibilityStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ExtensibilityStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ExtensibilityStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ExtensibilityStruct that will be copied.
     */
    eProsima_user_DllExport ExtensibilityStruct(
            const ExtensibilityStruct& x)
    {
                    m_my_final_struct = x.m_my_final_struct;

                    m_my_mutable_struct = x.m_my_mutable_struct;

                    m_my_appendable_struct = x.m_my_appendable_struct;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ExtensibilityStruct that will be copied.
     */
    eProsima_user_DllExport ExtensibilityStruct(
            ExtensibilityStruct&& x) noexcept
    {
        m_my_final_struct = std::move(x.m_my_final_struct);
        m_my_mutable_struct = std::move(x.m_my_mutable_struct);
        m_my_appendable_struct = std::move(x.m_my_appendable_struct);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ExtensibilityStruct that will be copied.
     */
    eProsima_user_DllExport ExtensibilityStruct& operator =(
            const ExtensibilityStruct& x)
    {

                    m_my_final_struct = x.m_my_final_struct;

                    m_my_mutable_struct = x.m_my_mutable_struct;

                    m_my_appendable_struct = x.m_my_appendable_struct;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ExtensibilityStruct that will be copied.
     */
    eProsima_user_DllExport ExtensibilityStruct& operator =(
            ExtensibilityStruct&& x) noexcept
    {

        m_my_final_struct = std::move(x.m_my_final_struct);
        m_my_mutable_struct = std::move(x.m_my_mutable_struct);
        m_my_appendable_struct = std::move(x.m_my_appendable_struct);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ExtensibilityStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ExtensibilityStruct& x) const
    {
        return (m_my_final_struct == x.m_my_final_struct &&
           m_my_mutable_struct == x.m_my_mutable_struct &&
           m_my_appendable_struct == x.m_my_appendable_struct);
    }

    /*!
     * @brief Comparison operator.
     * @param x ExtensibilityStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ExtensibilityStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member my_final_struct
     * @param _my_final_struct New value to be copied in member my_final_struct
     */
    eProsima_user_DllExport void my_final_struct(
            const FinalStruct& _my_final_struct)
    {
        m_my_final_struct = _my_final_struct;
    }

    /*!
     * @brief This function moves the value in member my_final_struct
     * @param _my_final_struct New value to be moved in member my_final_struct
     */
    eProsima_user_DllExport void my_final_struct(
            FinalStruct&& _my_final_struct)
    {
        m_my_final_struct = std::move(_my_final_struct);
    }

    /*!
     * @brief This function returns a constant reference to member my_final_struct
     * @return Constant reference to member my_final_struct
     */
    eProsima_user_DllExport const FinalStruct& my_final_struct() const
    {
        return m_my_final_struct;
    }

    /*!
     * @brief This function returns a reference to member my_final_struct
     * @return Reference to member my_final_struct
     */
    eProsima_user_DllExport FinalStruct& my_final_struct()
    {
        return m_my_final_struct;
    }


    /*!
     * @brief This function copies the value in member my_mutable_struct
     * @param _my_mutable_struct New value to be copied in member my_mutable_struct
     */
    eProsima_user_DllExport void my_mutable_struct(
            const MutableStruct& _my_mutable_struct)
    {
        m_my_mutable_struct = _my_mutable_struct;
    }

    /*!
     * @brief This function moves the value in member my_mutable_struct
     * @param _my_mutable_struct New value to be moved in member my_mutable_struct
     */
    eProsima_user_DllExport void my_mutable_struct(
            MutableStruct&& _my_mutable_struct)
    {
        m_my_mutable_struct = std::move(_my_mutable_struct);
    }

    /*!
     * @brief This function returns a constant reference to member my_mutable_struct
     * @return Constant reference to member my_mutable_struct
     */
    eProsima_user_DllExport const MutableStruct& my_mutable_struct() const
    {
        return m_my_mutable_struct;
    }

    /*!
     * @brief This function returns a reference to member my_mutable_struct
     * @return Reference to member my_mutable_struct
     */
    eProsima_user_DllExport MutableStruct& my_mutable_struct()
    {
        return m_my_mutable_struct;
    }


    /*!
     * @brief This function copies the value in member my_appendable_struct
     * @param _my_appendable_struct New value to be copied in member my_appendable_struct
     */
    eProsima_user_DllExport void my_appendable_struct(
            const AppendableStruct& _my_appendable_struct)
    {
        m_my_appendable_struct = _my_appendable_struct;
    }

    /*!
     * @brief This function moves the value in member my_appendable_struct
     * @param _my_appendable_struct New value to be moved in member my_appendable_struct
     */
    eProsima_user_DllExport void my_appendable_struct(
            AppendableStruct&& _my_appendable_struct)
    {
        m_my_appendable_struct = std::move(_my_appendable_struct);
    }

    /*!
     * @brief This function returns a constant reference to member my_appendable_struct
     * @return Constant reference to member my_appendable_struct
     */
    eProsima_user_DllExport const AppendableStruct& my_appendable_struct() const
    {
        return m_my_appendable_struct;
    }

    /*!
     * @brief This function returns a reference to member my_appendable_struct
     * @return Reference to member my_appendable_struct
     */
    eProsima_user_DllExport AppendableStruct& my_appendable_struct()
    {
        return m_my_appendable_struct;
    }



private:

    FinalStruct m_my_final_struct;
    MutableStruct m_my_mutable_struct;
    AppendableStruct m_my_appendable_struct;

};

#endif // _FAST_DDS_GENERATED_EXTENSIBILITY_STRUCT_HPP_


