# Contributing to Eclipse EMF

Thanks for your interest in this project.

## Project description

Eclipse EMF is a modeling framework and code generation facility for building
tools and other applications based on a structured data model. From a model
specification described in XMI, EMF provides tools and runtime support to
produce a set of Java classes for the model, a set of adapter classes that
enable viewing and command-based editing of the model, and a basic editor.
Models can be specified using annotated Java, XML documents, or modeling tools
like Rational Rose, then imported into EMF. Most important of all, EMF provides
the foundation for interoperability with other EMF-based tools and applications.
For more detailed information see the EMF Overviews and Project Plan.

* https://www.eclipse.org/modeling/emf/
* https://projects.eclipse.org/projects/modeling.emf.emf

## Developer resources

Information regarding source code management, builds, coding standards, and
more.

* https://projects.eclipse.org/projects/modeling.emf.emf/developer

The project maintains the following source code repositories

* http://git.eclipse.org/c/emf/org.eclipse.emf.git

This project uses Bugzilla to track ongoing development and issues.

* Search for issues: https://bugs.eclipse.org/bugs/buglist.cgi?product=EMF
* Create a new report: https://bugs.eclipse.org/bugs/enter_bug.cgi?product=EMF

Be sure to search for existing bugs before you create another one. Remember that
contributions are always welcome!

This project is built, along with XSD, using Maven/Tycho.
Instructions for setting up a development environment and for replicating the build locally are provided here:

* https://ci.eclipse.org/emf/

## Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Contact

Ask questions via the project's forum:

* https://www.eclipse.org/forums/index.php/f/108/

Contact the project developers via the project's "dev" list.

* https://dev.eclipse.org/mailman/listinfo/emf-dev