//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_27.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot27(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[27] = {2.263732176449042e-02,2.038488635891013e-01,5.668767469899755e-01,1.112941744910869e+00,1.843903453122593e+00,
    2.762295863481947e+00,3.871377342395919e+00,5.175197479643673e+00,6.678684287340594e+00,8.387756591898460e+00,1.030946834886564e+01,1.245219429240160e+01,
    1.482587023797262e+01,1.744230719122206e+01,2.031560736029375e+01,2.346272427950778e+01,2.690423223934055e+01,3.066540906177898e+01,3.477780474783739e+01,
    3.928159547665958e+01,4.422927233419712e+01,4.969174367338356e+01,5.576916124966562e+01,6.261201291367177e+01,7.046806044069685e+01,7.981078721503174e+01,
    9.185622924233597e+01};
  constexpr double aw[27] = {2.941990845272923e-01,2.456424705042449e-01,1.711465279960141e-01,9.938278716047312e-02,4.801030616129554e-02,
    1.924644137053955e-02,6.382059417046439e-03,1.743525421965474e-03,3.905161726631575e-04,7.129434727248519e-05,1.053544444182569e-05,1.249810028411287e-06,
    1.178618846581908e-07,8.733444835833852e-09,5.014739870473486e-10,2.194398467681038e-11,7.171344997855355e-13,1.707340673346895e-14,2.870989263205070e-16,
    3.278251969789967e-18,2.414691999972660e-20,1.070649058642177e-22,2.592337155745628e-25,2.962627587149390e-28,1.258780869112919e-31,1.265320076017024e-35,
    9.616569769829973e-41};
  constexpr double x[10368] = {  1.630976633131293e-03, -1.481519821598573e-05,  1.008489656509862e-07, -6.095687018757674e-10,  3.449474602480023e-12,
 -1.870898433159756e-14,  9.846378924071529e-17, -5.065119031630056e-19,  2.558375315163007e-21, -1.272646715417766e-23,  6.247304154418891e-26, -3.030458924534935e-28,
  1.464800640953668e-02, -1.322059533619503e-04,  8.883833504645183e-07, -5.254085867147650e-09,  2.876157518653370e-11, -1.487388080138116e-13,  7.329216292286241e-16,
 -3.448933006380475e-18,  1.545708092433097e-20, -6.542403620710513e-23,  2.568364192598408e-25, -8.982713988249669e-28,  4.051824952143713e-02, -3.610174041649359e-04,
  2.363161826579354e-06, -1.335958095149494e-08,  6.807681527610824e-11, -3.153690124993437e-13,  1.310654787409029e-15, -4.662968976851979e-18,  1.210376608887523e-20,
 -2.020220009726740e-24, -2.601600643783434e-25,  2.374644013210813e-27,  7.891580566004633e-02, -6.895996385970351e-04,  4.335927564245473e-06, -2.280689062430020e-08,
  1.026685369889473e-10, -3.805654077313371e-13,  9.684460543429689e-16,  3.509973853282251e-19, -2.533631012699606e-20,  2.080652077961681e-22, -1.170698523422488e-24,
  4.924335877426189e-27,  1.293561524569335e-01, -1.101190727518758e-03,  6.549894164951418e-06, -3.098832502778586e-08,  1.129459099885814e-10, -2.364876849348852e-13,
 -6.314000716790141e-16,  1.051837999495252e-17, -6.919146147491660e-20,  2.956758320597757e-22, -6.085382807780481e-25, -3.013958050645279e-27,  1.912013292391168e-01,
 -1.574737415888462e-03,  8.709993230799238e-06, -3.536559156709749e-08,  8.558186826556810e-11,  1.293178250960308e-13, -2.897284308812974e-15,  1.829132540700580e-17,
 -6.264353442887268e-20, -1.831152106487561e-23,  1.922087026650800e-24, -1.469018560938408e-26,  2.636668302753483e-01, -2.085932475630862e-03,  1.051676526124044e-05,
 -3.402719947298797e-08,  1.890249111401079e-11,  6.107072219351038e-13, -4.506706393967855e-15,  1.483332644386222e-17,  2.092502234254318e-20, -5.763657048862752e-22,
  3.525722608020414e-24, -7.990919679051222e-27,  3.458301880886298e-01, -2.608422272860404e-03,  1.170117949874355e-05, -2.613224225926076e-08, -7.528725834883863e-11,
  1.015994713991780e-12, -4.146549637152374e-15, -2.262290935968708e-18,  1.335407135803532e-19, -7.817637764906685e-22,  8.857267792461774e-25,  1.927429173199685e-26,
  4.366412180872458e-01, -3.115129418871012e-03,  1.205650193394885e-05, -1.214771511470124e-08, -1.741976312249305e-10,  1.146187508386857e-12, -1.379490213531182e-15,
 -2.495278349886218e-17,  1.765993417246924e-19, -1.977337549935593e-22, -4.594693756934069e-24,  3.264157956577478e-26,  5.349338835927890e-01, -3.579628663241540e-03,
  1.146357417173345e-05,  6.174494067139449e-09, -2.502848790504881e-10,  8.857358243258022e-13,  2.901231085121972e-15, -3.848706234017548e-17,  8.472983276114890e-20,
  8.460197601638373e-22, -6.764993805917391e-24,  3.004335064933902e-27,  6.394397249021340e-01, -3.977509839961851e-03,  9.906509697374532e-06,  2.608404686613976e-08,
 -2.794292250122048e-10,  2.652077634037480e-13,  6.764275100407741e-15, -3.122890755213777e-17, -1.022796306283679e-19,  1.393936075624030e-21, -1.607067449195822e-24,
 -4.287407893835157e-26,  7.488027770099112e-01, -4.287660055587792e-03,  7.476807846082696e-06,  4.433210830955944e-08, -2.485764292173295e-10, -5.347212229497938e-13,
  8.189874109447670e-15, -3.808505030872802e-18, -2.524055431578344e-19,  7.674703235408182e-22,  6.764532691640003e-24, -4.497311501799831e-26,  8.615958778941530e-01,
 -4.493398718844072e-03,  4.365139519265662e-06,  5.778999192784584e-08, -1.604162806165512e-10, -1.244201241116941e-12,  6.180650130947117e-15,  2.947753512632037e-17,
 -2.414269758914190e-19, -6.511056004784390e-22,  9.405153989050008e-24,  9.620913738305769e-27,  9.763382428887609e-01, -4.583403673162814e-03,  8.414482797686285e-07,
  6.406426467936918e-08, -3.349625044942730e-11, -1.607693705338281e-12,  1.399032040149905e-15,  4.896000058094267e-17, -6.009632243400285e-20, -1.647903664112703e-21,
  2.626406890971310e-24,  5.895055772825093e-26,  1.091514150941333e+00, -4.552374702292509e-03, -2.774612730997603e-06,  6.198255911186537e-08,  1.024621439726023e-10,
 -1.487457137314703e-12, -4.071486799485716e-15,  4.242187120383163e-17,  1.674119678275882e-19, -1.304576734145478e-21, -7.009131744962323e-24,  4.133886587418438e-26,
  1.205592556088166e+00, -4.401391966090858e-03, -6.149682846835135e-06,  5.184663670818632e-08,  2.147721119684842e-10, -9.223119508968834e-13, -7.756956802628974e-15,
  1.353234975899714e-17,  2.774336519057452e-19,  8.676003186785212e-23, -9.561630592581824e-24, -2.242089667358320e-26,  1.317047403204654e+00, -4.137941221505326e-03,
 -8.975029604768428e-06,  3.539406579783550e-08,  2.770798226492318e-10, -1.147647395342732e-13, -8.066545494715348e-15, -2.032521179446330e-17,  1.972182390497707e-19,
  1.286163997386701e-21, -2.841115528352839e-24, -5.488389976031694e-26,  1.424378392291753e+00, -3.775594498347355e-03, -1.100268420884831e-05,  1.546896190924179e-08,
  2.768877999610762e-10,  6.497414274900645e-13, -5.099118445013870e-15, -3.955157188382614e-17,  2.603875499605300e-22,  1.304046999477527e-21,  5.451771625684380e-24,
 -2.268342150858788e-26,  1.526131901862906e+00, -3.333353497032870e-03, -1.207494757890892e-05, -4.536278670078611e-09,  2.189213912828278e-10,  1.117545984560763e-12,
 -5.268312641123889e-16, -3.507180623361394e-17, -1.603942195064094e-19,  3.068981588146615e-22,  6.943044172226841e-24,  2.600459602047608e-26,  1.620921751336549e+00,
 -2.834682391166691e-03, -1.214349736964653e-05, -2.135562400665325e-08,  1.232332357967260e-10,  1.165861014974788e-12,  3.368893386171619e-15, -1.332767127849254e-17,
 -1.798381570845044e-19, -6.703092022140310e-22,  1.710030170541187e-24,  3.292245214726412e-26,  1.707449456918472e+00, -2.306275790641583e-03, -1.127549148620177e-05,
 -3.249956152058534e-08,  1.862324649944474e-11,  8.432074013537295e-13,  4.939660309408421e-15,  9.654928535710313e-18, -7.719922244379223e-20, -8.205282285330554e-22,
 -3.305777344255404e-24,  3.025463224831030e-27,  1.784523617757118e+00, -1.776625056985110e-03, -9.645613731470643e-06, -3.674149446388300e-08, -6.650815093321402e-11,
  3.346666895044681e-13,  3.967932839726601e-15,  2.017184578260025e-17,  4.074401850222314e-20, -2.721850939738419e-22, -3.304063934317980e-24, -1.732861723815921e-26,
  1.851078062339818e+00, -1.274460623577084e-03, -7.514759664614866e-06, -3.433360742203484e-08, -1.128852842655752e-10, -1.301065223489960e-13,  1.583891837383511e-15,
  1.561461812355802e-17,  8.364208277648122e-20,  2.554547419181799e-22, -2.506166946958527e-25, -9.510170008124535e-27,  1.906188395629965e+00, -8.271581665676989e-04,
 -5.197791032715164e-06, -2.690282273898455e-08, -1.157930059135470e-10, -3.819321445451817e-13, -5.855500328791937e-16,  4.004879073347641e-18,  4.806799095000311e-20,
  3.095941335986130e-22,  1.419457835299159e-24,  4.062559504134748e-27,  1.949086642674932e+00, -4.592011152448069e-04, -3.024257097376029e-06, -1.704763885038106e-08,
 -8.545520187441159e-11, -3.807775465056179e-13, -1.456289946874032e-15, -4.224264783533965e-18, -3.688173543471778e-21,  6.727367401197682e-23,  6.921426269875406e-25,
  4.574512814213741e-27,  1.979173998696399e+00, -1.907883952114185e-04, -1.296962851024718e-06, -7.723789716771055e-09, -4.231207556103631e-11, -2.171568076598279e-13,
 -1.049800839000901e-15, -4.765675225061055e-18, -2.006019525000969e-20, -7.596158784602368e-23, -2.389259946911767e-25, -4.440798363798675e-28,  1.996035802986341e+00,
 -3.663144627574750e-05, -2.533722066476604e-07, -1.553683227546771e-09, -8.902069890524021e-12, -4.876805237735125e-14, -2.585009926902064e-16, -1.334736960593432e-18,
 -6.739951253807957e-21, -3.336110546719890e-23, -1.620506548458028e-25, -7.726892866562908e-28,  1.573284384624265e-03, -1.403675515812910e-05,  9.385334598547686e-08,
 -5.572468097607831e-10,  3.097823531551618e-12, -1.650719701813078e-14,  8.536202573033334e-17, -4.315169490148186e-19,  2.142167555309310e-21, -1.047490357539484e-23,
  5.055539576565914e-26, -2.411626469395124e-28,  1.413300817317044e-02, -1.253434795641036e-04,  8.280002721719353e-07, -4.816774999096747e-09,  2.595515791626455e-11,
 -1.322537448496414e-13,  6.429359012117104e-16, -2.990083104226288e-18,  1.327752971375813e-20, -5.590634298447930e-23,  2.198922981793123e-25, -7.824314896367884e-28,
  3.911100068907029e-02, -3.427353210184469e-04,  2.209179502684663e-06, -1.231914546080340e-08,  6.207364222559832e-11, -2.854364221341415e-13,  1.185490013851022e-15,
 -4.278628408437274e-18,  1.186705773610675e-20, -1.053707997053898e-23, -1.703122550778842e-25,  1.738336765036218e-27,  7.622508729541166e-02, -6.559795932355279e-04,
  4.071853979201306e-06, -2.122381986529784e-08,  9.529000669055429e-11, -3.572897751526376e-13,  9.679873286298145e-16, -3.485439375439175e-19, -1.863831930826383e-20,
  1.653868246459186e-22, -9.678014386504862e-25,  4.296265293932802e-27,  1.250538756319503e-01, -1.050248656844175e-03,  6.188718586110569e-06, -2.921975608533153e-08,
  1.080872240143629e-10, -2.483476456876893e-13, -3.663178365241369e-16,  8.469639291101899e-18, -5.901210700611711e-20,  2.692365374846339e-22, -7.008452151364772e-25,
 -1.284097686740281e-27,  1.850390847750015e-01, -1.506731567303861e-03,  8.293895568959712e-06, -3.397919882632574e-08,  8.751318982618914e-11,  6.570225902540331e-14,
 -2.413191885758477e-15,  1.628980950585369e-17, -6.206696343422244e-20,  4.648339126234857e-23,  1.338111464699059e-24, -1.188463278205089e-26,  2.554887909850235e-01,
 -2.003425626838111e-03,  1.011063792575488e-05, -3.363278086634364e-08,  3.006898117889123e-11,  5.075877141730220e-13, -4.084928258046308e-15,  1.519743207759140e-17,
  2.623788607736267e-21, -4.429910010770857e-22,  3.130186882411254e-24, -9.758562436777071e-27,  3.355817049001608e-01, -2.516086153523563e-03,  1.138101801766196e-05,
 -2.717969951903706e-08, -5.596528058387920e-11,  9.161745547230912e-13, -4.154240726944752e-15,  1.569083614585088e-18,  1.062197941713148e-19, -7.315029032317000e-22,
  1.576616120907077e-24,  1.231706334979771e-26,  4.243726166053208e-01, -3.019306146095684e-03,  1.189475641514085e-05, -1.475351222598665e-08, -1.516582836403869e-10,
  1.105326414614832e-12, -2.000358560379462e-15, -1.944819392635707e-17,  1.665136901089304e-19, -3.533959850001644e-22, -3.206857446826606e-24,  3.012403588272148e-26,
  5.207991610825128e-01, -3.487690402537337e-03,  1.151423660548803e-05,  2.315076397054973e-09, -2.319594596788304e-10,  9.427663850510625e-13,  1.865761001743172e-15,
 -3.534018839061829e-17,  1.103746020803081e-19,  5.809859203255112e-22, -6.419833300413332e-24,  1.218302019699131e-26,  6.236900653860192e-01, -3.897081273960724e-03,
  1.019289583653058e-05,  2.166412975847739e-08, -2.725741874213288e-10,  4.167334461662486e-13,  5.851479498372371e-15, -3.371485594009211e-17, -5.368077335335820e-20,
  1.295115597590029e-21, -3.252709857336524e-24, -3.174193894259643e-26,  7.317750385155036e-01, -4.225786008046170e-03,  7.984611348767129e-06,  4.027995730928741e-08,
 -2.573185237155040e-10, -3.403293018771212e-13,  7.974661269263773e-15, -1.139516108143714e-17, -2.203968071654512e-19,  9.970336765755490e-22,  4.686825387094869e-24,
 -4.865999420157311e-26,  8.436964532648222e-01, -4.455749153800607e-03,  5.042425122114230e-06,  5.503258347527439e-08, -1.837546885488302e-10, -1.086853233706512e-12,
  6.894859008160680e-15,  2.144996742630398e-17, -2.580391258973781e-19, -2.714785662434871e-22,  9.453476753937216e-24, -7.200885276157073e-27,  9.580229441860535e-01,
 -4.573608542746259e-03,  1.605949910163866e-06,  6.327337951277590e-08, -6.520466823795055e-11, -1.557937651871207e-12,  2.734243838099877e-15,  4.611296041698442e-17,
 -1.169226167518298e-19, -1.493008636491649e-21,  5.058726281536458e-24,  5.078179368143580e-26,  1.073265005326602e+00, -4.571570864981171e-03, -2.021983447058772e-06,
  6.337906522802184e-08,  7.183499489562640e-11, -1.570358947557336e-12, -2.816098204952889e-15,  4.697730492803946e-17,  1.158751329726479e-19, -1.544648330403535e-21,
 -4.904625752706252e-24,  5.364680465220738e-26,  1.187892614184905e+00, -4.448043839207248e-03, -5.507546179381527e-06,  5.512545240326518e-08,  1.945000818630989e-10,
 -1.102928640471653e-12, -7.253827310658053e-15,  2.238472599240764e-17,  2.734763903555837e-19, -3.108319185174948e-22, -1.019842288455201e-23, -6.031740624905508e-27,
  1.300354833875427e+00, -4.207967421162258e-03, -8.523811466671350e-06,  3.979828170006013e-08,  2.728063232883353e-10, -3.144360804818858e-13, -8.540520899465769e-15,
 -1.330009998156395e-17,  2.408860566809974e-19,  1.123577846333425e-21, -5.295169108225071e-24, -5.582618461958528e-26,  1.409101254562429e+00, -3.862797205824992e-03,
 -1.079006917400862e-05,  1.999610014242409e-08,  2.885693313701692e-10,  5.141190278140236e-13, -6.199100773597548e-15, -3.875222354124473e-17,  5.085264331294238e-20,
  1.497954908904352e-21,  4.138711689940172e-24, -3.706415653319210e-26,  1.512605030254016e+00, -3.430109579914794e-03, -1.210763205145490e-05, -8.557602082136519e-10,
  2.410633816398780e-10,  1.092550100421358e-12, -1.578642898011850e-15, -3.997191064817635e-17, -1.440868444230069e-19,  6.057239797743485e-22,  7.947112703284115e-24,
  1.897703291451514e-26,  1.609387152479618e+00, -2.932820120664452e-03, -1.238715114407057e-05, -1.919310029386255e-08,  1.473253098684026e-10,  1.241564311174108e-12,
  2.911634520223621e-15, -1.945243241814404e-17, -2.023702952318038e-19, -5.708987875596296e-22,  3.309252275946961e-24,  3.960056441393911e-26,  1.698041484819812e+00,
 -2.398033312002395e-03, -1.166312077250162e-05, -3.206014854112502e-08,  3.669324856111727e-11,  9.646959544796566e-13,  5.170792484607957e-15,  6.686785410431824e-18,
 -1.090684204512957e-19, -9.481012285076655e-22, -3.019628100063935e-24,  1.033807456738724e-26,  1.777259970530957e+00, -1.855571105514763e-03, -1.009265827614423e-05,
 -3.774670946265597e-08, -5.881604395328333e-11,  4.368121449029894e-13,  4.549334159083927e-15,  2.129185221029066e-17,  2.837897738873745e-20, -4.199900817258180e-22,
 -4.094201832771564e-24, -1.842042248647405e-26,  1.845857330745859e+00, -1.336257602430278e-03, -7.937678701412136e-06, -3.615836941834383e-08, -1.150702678760916e-10,
 -8.653574995776964e-14,  2.059936470596557e-15,  1.843548927976687e-17,  9.254732931951290e-20,  2.359689975230073e-22, -7.522355430125150e-25, -1.343305226727936e-26,
  1.902794508456733e+00, -8.700639113136819e-04, -5.531995470730950e-06, -2.881734214460971e-08, -1.235621542963908e-10, -3.944551934028733e-13, -4.501233027679821e-16,
  5.732684760116261e-18,  6.027781035108201e-20,  3.698691565192633e-22,  1.591566037571347e-24,  3.684911974292047e-27,  1.947200120886180e+00, -4.842372938236269e-04,
 -3.237290037902667e-06, -1.847778591422787e-08, -9.342990172453600e-11, -4.171587556701033e-13, -1.575817098372252e-15, -4.297778551247834e-18, -7.162373193182255e-22,
  9.934381396871180e-23,  9.207298307397216e-25,  5.861054250825997e-27,  1.978389490007414e+00, -2.015466880134940e-04, -1.393858171909903e-06, -8.436943662545877e-09,
 -4.691835831750810e-11, -2.440284259894702e-13, -1.192651181700654e-15, -5.453236618132715e-18, -2.297132065861180e-20, -8.588343523795784e-23, -2.563930101227845e-25,
 -3.373832398205889e-28,  1.995885101647042e+00, -3.873549846923792e-05, -2.729043187171096e-07, -1.704269479304524e-09, -9.942629193440265e-12, -5.544607564045941e-14,
 -2.990829960774602e-16, -1.570952118175116e-18, -8.066309952612803e-21, -4.057742222215705e-23, -2.001917656800599e-25, -9.687473101055907e-28,  1.518597824140560e-03,
 -1.331185801670991e-05,  8.745323024793329e-08, -5.102154457070798e-10,  2.787226400368496e-12, -1.459608699781913e-14,  7.418521895979456e-17, -3.686306762800661e-19,
  1.799053038643888e-21, -8.649771407187929e-24,  4.105433774848646e-26, -1.926308910503797e-28,  1.364452589280615e-02, -1.189438185003668e-04,  7.726060198829092e-07,
 -4.421842308238669e-09,  2.345784658180988e-11, -1.177817402043247e-13,  5.648710648257711e-16, -2.595772048487714e-18,  1.141521951236883e-20, -4.776720486540843e-23,
  1.878370756716855e-25, -6.763912255608065e-28,  3.777449329865715e-02, -3.256367439673995e-04,  2.067125336832010e-06, -1.137013109919847e-08,  5.663994758144406e-11,
 -2.583797636475484e-13,  1.070939280324019e-15, -3.906126388644499e-18,  1.138213351125920e-20, -1.597134881528405e-23, -1.048998535244189e-25,  1.257409262750558e-27,
  7.366474146148556e-02, -6.243981207744628e-04,  3.826084247150269e-06, -1.975508832956621e-08,  8.837541173722092e-11, -3.342373429334403e-13,  9.507220243256084e-16,
 -8.568200561201292e-19, -1.333733030742815e-20,  1.302716310956452e-22, -7.924587144693844e-25,  3.678847364046671e-27,  1.209497208048549e-01, -1.002112436929211e-03,
  5.848292641136204e-06, -2.753049689821928e-08,  1.030504984358402e-10, -2.544981025903176e-13, -1.541873497335795e-16,  6.730834698791963e-18, -4.983426462667094e-20,
  2.404558088730103e-22, -7.295899063913892e-25, -1.010306622032908e-28,  1.791423121276766e-01, -1.441987520531741e-03,  7.894580033496054e-06, -3.257147116549056e-08,
  8.828386216207326e-11,  1.303648671423368e-14, -1.984563695459930e-15,  1.433979522083590e-17, -5.954906089225622e-20,  9.032334705499165e-23,  8.725045573288561e-25,
 -9.329631374930417e-27,  2.476343151141134e-01, -1.924145980506608e-03,  9.710249326037782e-06, -3.307564520981450e-08,  3.927481003745246e-11,  4.146513679771297e-13,
 -3.660454829593498e-15,  1.504953964483675e-17, -1.117598252948371e-20, -3.266142332665003e-22,  2.684485088011484e-24, -1.033646587469621e-26,  3.256973712183203e-01,
 -2.426356500023747e-03,  1.105007614096953e-05, -2.793395166877379e-08, -3.863336513926414e-11,  8.173602068247484e-13, -4.066586429898326e-15,  4.559894515732391e-18,
  8.113508293710136e-20, -6.593802586646539e-22,  1.987736597987367e-24,  6.581575674389996e-27,  4.124845308125276e-01, -2.924895852141193e-03,  1.170387565896444e-05,
 -1.700597547828440e-08, -1.300728910026442e-10,  1.051372752051342e-12, -2.472384238886791e-15, -1.434554050903394e-17,  1.517920567549484e-19, -4.562629201072620e-22,
 -1.965845779428874e-24,  2.610561662706106e-26,  5.070327160386392e-01, -3.395527031828122e-03,  1.152037861943414e-05, -1.243328411590225e-09, -2.127343625571423e-10,
  9.760870426588587e-13,  9.284811917356640e-16, -3.152194038675822e-17,  1.268158351453923e-19,  3.369392372264314e-22, -5.737760249376686e-24,  1.832957243198783e-26,
  6.082663693245578e-01, -3.814571687816272e-03,  1.042699714815137e-05,  1.737692652509776e-08, -2.629124525611664e-10,  5.456887719414338e-13,  4.890229865213087e-15,
 -3.471429218509036e-17, -9.704013753777038e-21,  1.140494296267992e-21, -4.393870981238927e-24, -2.016101591693180e-26,  7.150026101337030e-01, -4.160046120278148e-03,
  8.443076995856033e-06,  3.611868481637936e-08, -2.622410089355310e-10, -1.535288053665523e-13,  7.562488593028669e-15, -1.784158151745371e-17, -1.816459820942842e-19,
  1.141648161402816e-21,  2.550788284931056e-24, -4.772759095469961e-26,  8.259582452627999e-01, -4.412819762750527e-03,  5.684487991811615e-06,  5.192779016375483e-08,
 -2.037931896525704e-10, -9.151089396057933e-13,  7.378902701750371e-15,  1.310843034537602e-17, -2.611237497138171e-19,  9.579937265323441e-23,  8.803428187501563e-24,
 -2.187025357927507e-26,  9.397589858615724e-01, -4.557743899672390e-03,  2.357955306582576e-06,  6.198483101801965e-08, -9.560500893386597e-11, -1.477292799846863e-12,
  3.965248007829117e-15,  4.155468812137880e-17, -1.665208274477793e-19, -1.249395888885153e-21,  7.030288357540680e-24,  3.822711483889338e-26,  1.054951211350808e+00,
 -4.584687406863041e-03, -1.255585598257236e-06,  6.427394961461482e-08,  3.986043978816303e-11, -1.621794543040138e-12, -1.457423640996776e-15,  4.976250841621138e-17,
  5.732974955519771e-20, -1.691016122545412e-21, -2.358680221952322e-24,  6.119446373377778e-26,  1.170016580025314e+00, -4.489407019680930e-03, -4.828126690997554e-06,
  5.805175687354461e-08,  1.707564156328402e-10, -1.268523498718434e-12, -6.506782547765476e-15,  3.087799890058802e-17,  2.549282094117231e-19, -7.187183475481990e-22,
 -1.006078025390939e-23,  1.248831736672425e-26,  1.283389711912385e+00, -4.274173942915577e-03, -8.020286589432007e-06,  4.410162577803261e-08,  2.644423666107360e-10,
 -5.229705766670428e-13, -8.799244996976654e-15, -4.990201886588755e-18,  2.769379465396457e-19,  8.635584505399510e-22, -7.672852969879131e-24, -5.129623530063042e-26,
  1.393479056108502e+00, -3.948078728425850e-03, -1.052210118157617e-05,  2.468701989717664e-08,  2.972772033694743e-10,  3.525546319311054e-13, -7.253066039721599e-15,
 -3.623360839911615e-17,  1.073275390001889e-19,  1.626692005827245e-21,  2.196350087049045e-24, -5.101092721382869e-26,  1.498690899522372e+00, -3.526944498201071e-03,
 -1.209404573614467e-05,  3.173613737323014e-09,  2.624422539756979e-10,  1.040733470438154e-12, -2.758683095095440e-15, -4.417098009688567e-17, -1.163842027334900e-19,
  9.373301772537112e-22,  8.551947957673764e-24,  7.821956756463987e-27,  1.597456277993934e+00, -3.032796615275403e-03, -1.260249392486082e-05, -1.663364686087847e-08,
  1.728074113820323e-10,  1.304157760669814e-12,  2.273417200116631e-15, -2.622806234054384e-17, -2.201047694511244e-19, -4.020286266834494e-22,  5.171375877391020e-24,
  4.467633413494659e-26,  1.688260321147144e+00, -2.492865674318171e-03, -1.204366130641777e-05, -3.131190634726892e-08,  5.724114841938238e-11,  1.090614996382045e-12,
  5.303868409726454e-15,  2.628222686733176e-18, -1.452408347461424e-19, -1.057150829692959e-21, -2.363639169278279e-24,  1.983905741120327e-26,  1.769673313166357e+00,
 -1.938139508232481e-03, -1.055095705963790e-05, -3.861173953664691e-08, -4.893920411632295e-11,  5.532377054956319e-13,  5.155712261154407e-15,  2.192486740966913e-17,
  1.011551017891583e-20, -6.000199774972980e-22, -4.905751610752897e-24, -1.819751913740130e-26,  1.840382505103515e+00, -1.401526046072945e-03, -8.382673798319267e-06,
 -3.801047164233199e-08, -1.162630244522947e-10, -3.056068755634564e-14,  2.618819949944331e-15,  2.152587908914140e-17,  1.003459900853078e-19,  1.927094554317201e-22,
 -1.445710934435960e-24, -1.823387466814234e-26,  1.899223502523135e+00, -9.157373195063405e-04, -5.889927626115928e-06, -3.085797774655327e-08, -1.315451057226282e-10,
 -4.031012557922416e-13, -2.605125639028326e-16,  7.887210508853644e-18,  7.477609508604264e-20,  4.365448773457402e-22,  1.735338633331001e-24,  2.735776216855883e-27,
  1.945209934028416e+00, -5.110486084187958e-04, -3.468274832277519e-06, -2.004150552475369e-08, -1.021610186982246e-10, -4.564214378693776e-13, -1.695884397294112e-15,
 -4.255837581994758e-18,  3.589207018284535e-21,  1.417733991590530e-22,  1.212260974387168e-24,  7.442169743509417e-27,  1.977560341798159e+00, -2.131156697693267e-04,
 -1.499771900307020e-06, -9.228290607446571e-09, -5.209797273244939e-11, -2.745703344092275e-13, -1.356112025799133e-15, -6.239793227734015e-18, -2.625085483832547e-20,
 -9.638510528298968e-23, -2.672316357909621e-25, -1.363404889298677e-28,  1.995725659727217e+00, -4.100332923743073e-05, -2.943479447735390e-07, -1.872628420800263e-09,
 -1.112705022375830e-11, -6.318248239532888e-14, -3.469144885334518e-16, -1.854079542196377e-18, -9.682129573541540e-21, -4.950669624083167e-23, -2.480880425987913e-25,
 -1.218343941140725e-27,  1.466711909199205e-03, -1.263598596505462e-05,  8.158888925993180e-08, -4.678618555968715e-10,  2.512305498309505e-12, -1.293327306587842e-14,
  6.462489041682089e-17, -3.157421605169385e-19,  1.515287375751750e-21, -7.165204679944370e-24,  3.345201822681203e-26, -1.544224300817258e-28,  1.318078503276809e-02,
 -1.129690126002258e-04,  7.217204497458308e-07, -4.064649238466288e-09,  2.123210039153432e-11, -1.050572751159908e-13,  4.970549596451770e-16, -2.256605307239773e-18,
  9.823933765863346e-21, -4.082017930470438e-23,  1.602057123501295e-25, -5.814486981679119e-28,  3.650417744136766e-02, -3.096304853456421e-04,  1.935955091773950e-06,
 -1.050387264817226e-08,  5.172072899878825e-11, -2.339490792661965e-13,  9.665753189496661e-16, -3.551806193497471e-18,  1.074391934483799e-20, -1.917473788271136e-23,
 -5.789564582410326e-26,  8.964106339567584e-28,  7.122689821606830e-02, -5.947141529551659e-04,  3.597290621666301e-06, -1.839332894631145e-08,  8.191666326521131e-11,
 -3.117520113976412e-13,  9.214191344165999e-16, -1.214389754478624e-18, -9.180692834858433e-21,  1.016376961720476e-22, -6.434256389130351e-25,  3.104135570997757e-27,
  1.170327904817363e-01, -9.566199177537439e-04,  5.527651073669929e-06, -2.592254874397854e-08,  9.793789885901740e-11, -2.561094419989606e-13,  1.321148862009657e-17,
  5.269015271914278e-18, -4.170188618190499e-20,  2.114356172292905e-22, -7.158334687751401e-25,  6.676868050542427e-28,  1.734982338010337e-01, -1.380370294004810e-03,
  7.512198215331258e-06, -3.115929872256560e-08,  8.809971997705912e-11, -2.998697397027921e-14, -1.609195003629131e-15,  1.249222546754661e-17, -5.576191654321558e-20,
  1.176929257383041e-22,  5.121546958821825e-25, -7.108444476000808e-27,  2.400905973065549e-01, -1.848040334153454e-03,  9.317370562854343e-06, -3.238553485092184e-08,
  4.672320826095646e-11,  3.318065394501825e-13, -3.245699593655239e-15,  1.452361345129940e-17, -2.111074970770930e-20, -2.283073039923123e-22,  2.232683261539931e-24,
 -1.009110997307144e-26,  3.161666102158202e-01, -2.339306020680018e-03,  1.071168232908272e-05, -2.842656229350404e-08, -2.325037468964307e-11,  7.215662689577828e-13,
 -3.906017170276078e-15,  6.792240153894566e-18,  5.888541669590571e-20, -5.754819476063252e-22,  2.174744336771236e-24,  2.127033834372988e-27,  4.009708690921656e-01,
 -2.832114937016856e-03,  1.148800006853563e-05, -1.892227297687170e-08, -1.096685733803010e-10,  9.877486432036449e-13, -2.808621411925291e-15, -9.764012930982636e-18,
  1.342156067402132e-19, -5.132927408639340e-22, -9.203524783526641e-25,  2.134984838232285e-26,  4.936347597504941e-01, -3.303480056320516e-03,  1.148568351923642e-05,
 -4.489985256639718e-09, -1.930588661210820e-10,  9.882474500870960e-13,  1.041975690878621e-16, -2.731240072720688e-17,  1.350198471086701e-19,  1.247310360771709e-22,
 -4.848433881744680e-24,  2.166162363452623e-26,  5.931761353594445e-01, -3.730392261109641e-03,  1.061066057845490e-05,  1.326368370963602e-08, -2.509037788748063e-10,
  6.513918821792602e-13,  3.919803726967961e-15, -3.440335384240301e-17,  2.800642487414048e-20,  9.502794951402592e-22, -5.037674789426718e-24, -9.300837058512456e-27,
  6.985001589759746e-01, -4.090839307178475e-03,  8.851256200266445e-06,  3.190794437311616e-08, -2.635402836973767e-10,  2.135789685964139e-14,  6.987842422862329e-15,
 -2.298101512591258e-17, -1.392061535669265e-19,  1.202829782915477e-21,  5.428263801988326e-25, -4.300408675424173e-26,  8.084017845206773e-01, -4.364908084536509e-03,
  6.287484824373781e-06,  4.853041165695941e-08, -2.202995595471622e-10, -7.345494998715824e-13,  7.629946328401643e-15,  4.873510987091171e-18, -2.516015759690882e-19,
  4.251023703125333e-22,  7.579812707867617e-24, -3.310485712913747e-26,  9.215704087667846e-01, -4.535933199866516e-03,  3.091637987620950e-06,  6.022433896537854e-08,
 -1.241082403617548e-10, -1.368806154546400e-12,  5.047820946754415e-15,  3.556367419410922e-17, -2.060715396570840e-19, -9.389284363907130e-22,  8.380779120252199e-24,
  2.283697283656624e-26,  1.036597269217617e+00, -4.591638575138371e-03, -4.815468394004587e-07,  6.465080578691330e-08,  7.188459356918521e-12, -1.639901972493195e-12,
 -4.764043680020814e-17,  5.061015926477771e-17, -4.586546838400539e-21, -1.730538444730444e-21,  3.960059704635915e-25,  6.303659831210985e-26,  1.151986176813817e+00,
 -4.525201084889480e-03, -4.115976860373337e-06,  6.057272112940705e-08,  1.438990017860808e-10, -1.413416103356334e-12, -5.532426324508528e-15,  3.854545898258849e-17,
  2.219937212336637e-19, -1.104598568071638e-21, -9.096855089106137e-24,  3.117779172882847e-26,  1.266168143682582e+00, -4.336148298893921e-03, -7.466063027167606e-06,
  4.823752499205006e-08,  2.518651077558897e-10, -7.348012557989742e-13, -8.810676032007910e-15,  4.305722237105244e-18,  3.019808606211659e-19,  5.141354161535520e-22,
 -9.722693034778385e-24, -4.092166024260829e-26,  1.377520378570915e+00, -4.030989228770775e-03, -1.019711720635806e-05,  2.949006863046311e-08,  3.025076195345051e-10,
  1.667492545623122e-13, -8.210626325503144e-15, -3.184981065395339e-17,  1.668951063834236e-19,  1.665985887600829e-21, -3.170097169497573e-25, -6.269818599922355e-26,
  1.484389960823868e+00, -3.623471589911434e-03, -1.203009384978586e-05,  7.535182176806201e-09,  2.824926256176481e-10,  9.592963334985821e-13, -4.042064432827741e-15,
 -4.728892413119742e-17, -7.643771954545434e-20,  1.282089308214072e-21,  8.574954532580805e-24, -7.415289841211064e-27,  1.585122256467132e+00, -3.134365977825879e-03,
 -1.278463854572096e-05, -1.365736266780799e-08,  1.993725369196620e-10,  1.349099396263976e-12,  1.438555934862412e-15, -3.345915694830483e-17, -2.303720441926494e-19,
 -1.549596598921473e-22,  7.198092939058880e-24,  4.685291170525864e-26,  1.678093804386986e+00, -2.590700663928384e-03, -1.241316677827459e-05, -3.021461821323200e-08,
  8.032947186105162e-11,  1.218229958540787e-12,  5.306550188208813e-15, -2.644750165632093e-18, -1.847602468930514e-19, -1.130974407867033e-21, -1.243322310660326e-24,
  3.139408184122186e-26,  1.761748987700589e+00, -2.024412954032357e-03, -1.101860861175004e-05, -3.929931660723435e-08, -3.658725417711052e-11,  6.843567814810956e-13,
  5.770614029081739e-15,  2.186353965907507e-17, -1.520617643002621e-20, -8.117768609619011e-22, -5.665843210646748e-24, -1.595310963049219e-26,  1.834639344665580e+00,
 -1.470443585862399e-03, -8.849969240716186e-06, -3.987194327002814e-08, -1.161949998371787e-10,  3.989250837799918e-14,  3.267453385846078e-15,  2.483512639854230e-17,
  1.060347691410583e-19,  1.172315454421605e-22, -2.369305740621171e-24, -2.387701026294035e-26,  1.895463917873346e+00, -9.643743182436306e-04, -6.273118619169750e-06,
 -3.302745520583407e-08, -1.396503048619926e-10, -4.064180586774777e-13, -3.711647325161464e-18,  1.054510170294847e-17,  9.176613694026240e-20,  5.079101271146388e-22,
  1.819898908070050e-24,  9.417865296520364e-28,  1.943108683880163e+00, -5.397852954673874e-04, -3.718888867936348e-06, -2.175136090550280e-08, -1.117060235919835e-10,
 -4.985345792746610e-13, -1.812602019426747e-15, -4.049290616876668e-18,  9.649645495544966e-21,  1.973505746073114e-22,  1.580515715391450e-24,  9.353436680351196e-27,
  1.976683160847890e+00, -2.255714027074115e-04, -1.615699904128271e-06, -1.010761894714592e-08, -5.792950260846830e-11, -3.093117967547999e-13, -1.543123007040285e-15,
 -7.137408084485488e-18, -2.991378508215005e-20, -1.071057505787289e-22, -2.663125731102322e-25,  2.063325917160024e-28,  1.995556790120174e+00, -4.345112458417599e-05,
 -3.179308982418426e-07, -2.061241100557881e-09, -1.247835258713681e-11, -7.216812938281862e-14, -4.034485273740547e-16, -2.194448814018252e-18, -1.165670650463794e-20,
 -6.059053031988928e-23, -3.084224577855206e-25, -1.537034447701353e-27,  1.417438769545098e-03, -1.200506799855447e-05,  7.620745735365839e-08, -4.296529307084545e-10,
  2.268461246347707e-12, -1.148311521140923e-14,  5.642594763217331e-17, -2.711345899915587e-19,  1.279874520242664e-21, -5.953613224957670e-24,  2.734726801575101e-26,
 -1.242279130429898e-28,  1.274015554399031e-02, -1.073847326145272e-04,  6.749156450829924e-07, -3.741117497294509e-09,  1.924530808348361e-11, -9.385196695816901e-14,
  4.380587500237139e-16, -1.964563565526320e-18,  8.463822807268555e-21, -3.489818690363690e-23,  1.365033954509765e-25, -4.977576193470226e-28,  3.529585188917216e-02,
 -2.946333100391121e-04,  1.814723395676483e-06, -9.712545545207707e-09,  4.726586801697451e-11, -2.119064804751033e-13,  8.718314822294282e-16, -3.219420436685902e-18,
  1.002066429645276e-20, -2.078677327038996e-23, -2.466335915736465e-26,  6.273363315499540e-28,  6.890423120220272e-02, -5.667968925553220e-04,  3.384232776795520e-06,
 -1.713135324198467e-08,  7.589985154556719e-11, -2.900759747889848e-13,  8.838194207480282e-16, -1.454338153241062e-18, -5.953518320923720e-21,  7.847588102337057e-23,
 -5.184235884253559e-25,  2.588183472396887e-27,  1.132928202095373e-01, -9.136167413317066e-04,  5.225813681325717e-06, -2.439645510896115e-08,  9.283008070906183e-11,
 -2.541659339377168e-13,  1.431667422143210e-16,  4.050882737032991e-18, -3.459707461901921e-20,  1.835451691628869e-22, -6.753236077551453e-25,  1.131121265731148e-27,
  1.680946134434847e-01, -1.321744450134432e-03,  7.146717931462760e-06, -2.975648415930412e-08,  8.714108106641546e-11, -6.460785959442517e-14, -1.283732257412685e-15,
  1.077901218159671e-17, -5.122632397564328e-20,  1.324977865508238e-22,  2.416484187855722e-25, -5.246444694298723e-27,  2.328450711711421e-01, -1.775042689081898e-03,
  8.933435229399039e-06, -3.158897006466339e-08,  5.261288613374806e-11,  2.587063473721929e-13, -2.849613721208718e-15,  1.373294346298917e-17, -2.782754987215079e-20,
 -1.476832923867713e-22,  1.804135935795091e-24, -9.323365651745881e-27,  3.069786051082300e-01, -2.254982297114656e-03,  1.036879146569005e-05, -2.868814287815342e-08,
 -9.740067215575703e-12,  6.302984399855298e-13, -3.692447845206119e-15,  8.362004154010515e-18,  3.974682660126351e-20, -4.876594483469442e-22,  2.192743794089995e-24,
 -1.120793207734920e-27,  3.898247390886697e-01, -2.741147558266913e-03,  1.125104442681249e-05, -2.052267725304443e-08, -9.060737945273142e-11,  9.175290603088720e-13,
 -3.024703562247511e-15, -5.770124469419022e-18,  1.152876250398081e-19, -5.327663089994370e-22, -8.902706108727108e-26,  1.645480079217715e-26,  4.806041970680643e-01,
 -3.211861117706715e-03,  1.141392203924188e-05, -7.420922838769969e-09, -1.733283180934298e-10,  9.820623144413609e-13, -5.996416277660165e-16, -2.295545696670606e-17,
  1.362532486904120e-19, -4.970765595647075e-23, -3.866585793372272e-24,  2.261993781855760e-26,  5.784252499224213e-01, -3.644937543784831e-03,  1.074618360643338e-05,
  9.358232065937663e-09, -2.370125627398091e-10,  7.340391190476109e-13,  2.973918561118571e-15, -3.299930410904479e-17,  5.851712970985329e-20,  7.434615899367344e-22,
 -5.235342594619493e-24,  1.136987290751128e-29,  6.822807457667779e-01, -4.018569268659769e-03,  9.208894659904139e-06,  2.770360192167997e-08, -2.614905959623107e-10,
  1.808811957384660e-13,  6.288528373829316e-15, -2.674217451086265e-17, -9.595130752390165e-20,  1.188725278657431e-21, -1.193959387946935e-24, -3.559645963883101e-26,
  7.910463542655686e-01, -4.312339719371962e-03,  6.848248520566668e-06,  4.489807046292557e-08, -2.331529438436424e-10, -5.506869202601076e-13,  7.656387732330441e-15,
 -2.877362954892555e-18, -2.312138534314212e-19,  6.967650805228012e-22,  5.951742814904034e-24, -4.018470990028701e-26,  9.034806688800836e-01, -4.508345121331692e-03,
  3.801534466047862e-06,  5.802650527644300e-08, -1.501962030470163e-10, -1.236483087978653e-12,  5.946673541606335e-15,  2.849493931791581e-17, -2.336404728251930e-19,
 -5.884202947195191e-22,  9.024880096901224e-24,  6.424677787490084e-27,  1.018227923105281e+00, -4.592388246581196e-03,  2.938716997541797e-07,  6.450385547315351e-08,
 -2.550655911680143e-11, -1.624114236055365e-12,  1.358076615900351e-15,  4.947504352594572e-17, -6.593870506626709e-20, -1.660005016040335e-21,  3.100917665834850e-24,
  5.896121545905511e-26,  1.133824172739277e+00, -4.555184462014202e-03, -3.376245089911155e-06,  6.264212519766850e-08,  1.143943022867183e-10, -1.532479513590524e-12,
 -4.360161989793544e-15,  4.494577582445059e-17,  1.760561342114435e-19, -1.435903364408575e-21, -7.346500141996845e-24,  4.787965376475859e-26,  1.248707854680447e+00,
 -4.393494085860315e-03, -6.863555702326195e-06,  5.213837022182737e-08,  2.350699917208820e-10, -9.437044591001135e-13, -8.552600200759275e-15,  1.418692044394224e-17,
  3.130938916504496e-19,  9.351040097015366e-23, -1.119312268357242e-23, -2.509195573709985e-26,  1.361235625433434e+00, -4.111068178615214e-03, -9.814121079289855e-06,
  3.434587212211924e-08,  3.038031722787680e-10, -4.034862769706005e-14, -9.018685199902135e-15, -2.555756326168503e-17,  2.259534825177032e-19,  1.595562522323210e-21,
 -3.258719261198773e-24, -7.015996592825531e-26,  1.469704275990185e+00, -3.719272392338300e-03, -1.191193755051666e-05,  1.220282615398132e-08,  3.005999666023237e-10,
  8.461663024650651e-13, -5.392992996260986e-15, -4.893119892078314e-17, -2.423484198224275e-20,  1.613282887782306e-21,  7.848729998834570e-24, -2.606496693294782e-26,
  1.572379279655535e+00, -3.237242349093583e-03, -1.292849155864947e-05, -1.025000386072678e-08,  2.266195733919902e-10,  1.371546368531624e-12,  3.980737229838462e-16,
 -4.086072698530973e-17, -2.302729759187633e-19,  1.739245419361020e-22,  9.230621810763507e-24,  4.470324638682428e-26,  1.667530128096105e+00, -2.691432553721342e-03,
 -1.276720421968147e-05, -2.872754781103424e-08,  1.059580313180644e-10,  1.343992541066129e-12,  5.143552073505180e-15, -9.215192093572680e-18, -2.260034613751854e-19,
 -1.149311379724112e-21,  4.219421381161070e-25,  4.448574177365746e-26,  1.753472038783393e+00, -2.114457051717600e-03, -1.149323617134162e-05, -3.976748391812396e-08,
 -2.146598923389736e-11,  8.301140824900699e-13,  6.371267980408988e-15,  2.086431650470276e-17, -4.866761704003455e-20, -1.051185630102889e-21, -6.267554298867478e-24,
 -1.085293197484996e-26,  1.828612896043990e+00, -1.543188708584591e-03, -9.339546486449816e-06, -4.172017633516221e-08, -1.145546392159746e-10,  1.270426066076827e-13,
  4.010832120424084e-15,  2.827531041364783e-17,  1.082795383726217e-19, -3.697674757202001e-25, -3.556701432525594e-24, -3.017839377104616e-26,  1.891503486176288e+00,
 -1.016183187193268e-03, -6.683122473350561e-06, -3.532678523238461e-08, -1.477538520866359e-10, -4.026147590668555e-13,  3.355116578967101e-16,  1.378826012287341e-17,
  1.113642798645233e-19,  5.807542421308143e-22,  1.800537253587479e-24, -2.054318779731968e-27,  1.940888343459227e+00, -5.706116290902143e-04, -3.990965769946972e-06,
 -2.362082428165438e-08, -1.221207136084977e-10, -5.433556747393507e-13, -1.920499214964095e-15, -3.613783640256972e-18,  1.799720326863285e-20,  2.694422165955193e-22,
  2.040535365178621e-24,  1.161445604997785e-26,  1.975754232977875e+00, -2.389984080472866e-04, -1.742763418125896e-06, -1.108606304930375e-08, -6.450285012006810e-11,
 -3.488567219665043e-13, -1.756965979972010e-15, -8.158371975203590e-18, -3.395786424452455e-20, -1.174322197123254e-22, -2.460012556776452e-25,  7.583667325673717e-28,
  1.995377737132393e+00, -4.609701867530456e-05, -3.439131073944789e-07, -2.272989415698510e-09, -1.402374654545156e-11, -8.263248349898385e-14, -4.704609887265902e-16,
 -2.604883490157967e-18, -1.407734322122635e-20, -7.439283699680013e-23, -3.846620015699687e-25, -1.945113156123187e-27,  1.370606011909705e-03, -1.141543164772002e-05,
  7.126204709426584e-08, -3.951237701669593e-10,  2.051749340869216e-12, -1.021555641341467e-14,  4.937678745365480e-17, -2.334070032133020e-19,  1.083985746397453e-21,
 -4.961591795207281e-24,  2.242807558057176e-26, -1.002789331471475e-28,  1.232113814560705e-02, -1.021598854043581e-04,  6.318096429450014e-07, -3.447655820589705e-09,
  1.746910059386014e-11, -8.396916934537736e-14,  3.866611654747442e-16, -1.712810279300966e-18,  7.300696009731826e-21, -2.985385378194666e-23,  1.162444396753928e-25,
 -4.248129743421416e-28,  3.414563380443959e-02, -2.805691836050095e-04,  1.702574114608998e-06, -8.989089831449409e-09,  4.322986062895848e-11, -1.920287124399401e-13,
  7.860634057329397e-16, -2.910872632273300e-18,  9.260653014012234e-21, -2.128428468799020e-23, -1.660008476213286e-27,  4.282857012058806e-28,  6.668991794714109e-02,
 -5.405251240349152e-04,  3.185755168057543e-06, -1.596222947323991e-08,  7.030704958602552e-11, -2.693720215391809e-13,  8.408282027873640e-16, -1.603436439407317e-18,
 -3.475467758202752e-21,  5.987894093923471e-23, -4.147112350107560e-25,  2.136753391703297e-27,  1.097201472716766e-01, -8.729563968811034e-04,  4.941800863106542e-06,
 -2.295161728757794e-08,  8.778968813808664e-11, -2.494880169828127e-13,  2.420487367225145e-16,  3.044387600173786e-18, -2.846288451261194e-20,  1.576130396812234e-22,
 -6.195065774447116e-25,  1.376067354049331e-27,  1.629197549566606e-01, -1.265975424131931e-03,  6.797957874146655e-06, -2.837413876601018e-08,  8.556433652613019e-11,
 -9.197645661160565e-14, -1.004141405132439e-15,  9.217531139861007e-18, -4.633372702565210e-20,  1.380168337216400e-22,  4.532710035856810e-26, -3.732439473326420e-27,
  2.258854553089272e-01, -1.705076797371543e-03,  8.559577487848405e-06, -3.070935789814322e-08,  5.713371296667724e-11,  1.948248285165411e-13, -2.478262571066878e-15,
  1.277053926448646e-17, -3.194136173366314e-20, -8.342564128936909e-23,  1.416467986181668e-24, -8.265910122386035e-27,  2.981223937683837e-01, -2.173410718369339e-03,
  1.002399932806589e-05, -2.874786916497150e-08,  1.999355273372084e-12,  5.446174301150607e-13, -3.443024452886637e-15,  9.369798040857461e-18,  2.375132994563625e-20,
 -4.016519710191318e-22,  2.091677009384262e-24, -3.314176707650357e-27,  3.790385728558774e-01, -2.652147567791933e-03,  1.099666665164764e-05, -2.182958254644922e-08,
 -7.299373443285089e-11,  8.433965800508223e-13, -3.137498632267892e-15, -2.387148653570767e-18,  9.620572938369282e-20, -5.232358230402522e-22,  5.319396668211596e-25,
  1.184406951971997e-26,  4.679387467620288e-01, -3.120951604386078e-03,  1.130887649903533e-05, -1.003803759376752e-08, -1.538805132191446e-10,  9.604479010056751e-13,
 -1.181823554107290e-15, -1.865189411453904e-17,  1.319186096248484e-19, -1.846075669364314e-22, -2.884784468230032e-24,  2.175379124486975e-26,  5.640180603986678e-01,
 -3.558582207819925e-03,  1.083622536430114e-05,  5.687045267012908e-09, -2.216916890685487e-10,  7.945602844325061e-13,  2.079889882367079e-15, -3.073879719314515e-17,
  8.153365723495929e-20,  5.363602019789283e-22, -5.066585270873046e-24,  7.305423756961440e-27,  6.663558164960823e-01, -3.943639137002113e-03,  9.516380020538292e-06,
  2.355663329346987e-08, -2.564260032684211e-10,  3.225126852822429e-13,  5.503111964146376e-15, -2.914004037991504e-17, -5.437122391652582e-20,  1.112193242497348e-21,
 -2.567680383131929e-24, -2.669501368714734e-26,  7.739098890649296e-01, -4.255462813801144e-03,  7.364311460350320e-06,  4.108945526170672e-08, -2.423398919215138e-10,
 -3.687117450461114e-13,  7.476315840659357e-15, -9.832453860192393e-18, -2.022819667660004e-19,  8.983470258408738e-22,  4.107101120586648e-24, -4.297164397221804e-26,
  8.855124628723912e-01, -4.475190254507089e-03,  4.482643437906476e-06,  5.543353904188221e-08, -1.734384768658561e-10, -1.085050541161025e-12,  6.637174913477552e-15,
  2.074945501180525e-17, -2.483006728304329e-19, -2.264867503207738e-22,  8.957741584506000e-24, -9.210389449229948e-27,  9.998679613272458e-01, -4.586950480534008e-03,
  1.064404431970449e-06,  6.383812919634905e-08, -5.755215911891398e-11, -1.575189456374163e-12,  2.705052744457082e-15,  4.643771766462226e-17, -1.228624088767156e-19,
 -1.486505127393883e-21,  5.505185219377113e-24,  4.952222503888435e-26,  1.115554216583731e+00, -4.579158849613284e-03, -2.614586392995052e-06,  6.422199036737801e-08,
  8.280329056530221e-11, -1.621434686549594e-12, -3.030957469968734e-15,  4.970014855497272e-17,  1.196196566538414e-19, -1.683542822248092e-21, -4.942904755476112e-24,
  6.056363369769420e-26,  1.231028112247242e+00, -4.445837456805633e-03, -6.215987093497140e-06,  5.573750022248351e-08,  2.141813073186279e-10, -1.143067937359870e-12,
 -8.015221232334191e-15,  2.417154994030518e-17,  3.081861750696415e-19, -3.706385740672231e-22, -1.186793996534106e-23, -5.024882260651413e-27,  1.344637053549898e+00,
 -4.187850049806945e-03, -9.372870862260124e-06,  3.918827879396062e-08,  3.007781948042199e-10, -2.645153413625114e-13, -9.624649284649775e-15, -1.743926706270060e-17,
  2.802943338479478e-19,  1.402561793171385e-21, -6.401863406488404e-24, -7.158658589100708e-26,  1.454637639900537e+00, -3.813899155729418e-03, -1.173611162516968e-05,
  1.714031307155344e-08,  3.161177808886714e-10,  7.002617229663566e-13, -6.764775438512342e-15, -4.871947096587699e-17,  3.916360315244417e-20,  1.898297046934679e-21,
  6.251275114049433e-24, -4.672208698849713e-26,  1.559222765166246e+00, -3.341098555092918e-03, -1.302883032258415e-05, -6.404528054266669e-09,  2.540490971167441e-10,
  1.366546693129988e-12, -8.477178014879097e-16, -4.805427635236705e-17, -2.169076971597213e-19,  5.806351525568630e-22,  1.104793815730138e-23,  3.686435943128803e-26,
  1.656557982755604e+00, -2.794918203241328e-03, -1.310085433713054e-05, -2.681057623066332e-08,  1.340470495389296e-10,  1.463486242765873e-12,  4.778103649405559e-15,
 -1.710198010509111e-17, -2.665666098686058e-19, -1.089272623078841e-21,  2.679261868734128e-24,  5.808916570107685e-26,  1.744827289958791e+00, -2.208316302343024e-03,
 -1.197193139170619e-05, -3.996961836200525e-08, -3.288347248274170e-12,  9.898222249945179e-13,  6.927626999782119e-15,  1.865228248170575e-17, -9.111757572456099e-20,
 -1.309135364696330e-21, -6.565559134617249e-24, -2.000919922814576e-27,  1.822287494042546e+00, -1.619938579352629e-03, -9.851084305527226e-06, -4.352721740560598e-08,
 -1.109850392836667e-10,  2.331935601904458e-13,  4.850836673114388e-15,  3.170987226659787e-17,  1.053678299436264e-19, -1.711242479969014e-22, -5.028799507835007e-24,
 -3.672665653387819e-26,  1.887329081092356e+00, -1.071384650168985e-03, -7.121492197828782e-06, -3.775468895863143e-08, -1.556921877514624e-10, -3.895071211386899e-13,
  7.747149118114006e-16,  1.770008371606543e-17,  1.335350619869490e-19,  6.497370641565765e-22,  1.614819029938761e-24, -6.701547557479946e-27,  1.938540198303965e+00,
 -6.037072139861361e-04, -4.286506067688445e-06, -2.566423005020584e-08, -1.334565664778195e-10, -5.905872578269351e-13, -2.012045872652821e-15, -2.865877967681901e-18,
  2.929617862150001e-20,  3.620259149907748e-22,  2.607575137402166e-24,  1.421183685844824e-26,  1.974769487102770e+00, -2.534907367358718e-04, -1.882226332834005e-06,
 -1.217629673791976e-08, -7.192081100444666e-11, -3.938918824168839e-13, -2.001262159910561e-15, -9.314485384450706e-18, -3.835248737619312e-20, -1.263786433393487e-22,
 -1.950885588053213e-25,  1.616068957644639e-27,  1.995187668144888e+00, -4.896137119954492e-05, -3.725918547517347e-07, -2.511229785988918e-09, -1.579548870733411e-11,
 -9.485227682765613e-14, -5.501291731327592e-16, -3.101354231815382e-18, -1.705436984102634e-20, -9.163577687025546e-23, -4.812973412929497e-25, -2.469095071538170e-27,
  1.326055216579403e-03, -1.086375825619129e-05,  6.671099018318772e-08, -3.638680359777637e-10,  1.858778853549547e-12, -9.105177634185678e-15,  4.330135108039331e-17,
 -2.014124608907368e-19,  9.205078347415863e-22, -4.146788038999026e-24,  1.845083420533147e-26, -8.121587052689811e-29,  1.192235208032478e-02, -9.726626858123734e-05,
  5.920609769225241e-07, -3.181096915432976e-09,  1.587876356830498e-11, -7.523936816890950e-14,  3.418178124888601e-16, -1.495521815679281e-18,  6.305324996971323e-21,
 -2.555866876889213e-23,  9.897391250857008e-26, -3.617622636971459e-28,  3.304993130869105e-02, -2.673685938372339e-04,  1.598731610346490e-06, -8.327138746806530e-09,
  3.957150979820142e-11, -1.741084649844572e-13,  7.085926621038244e-16, -2.626770279562912e-18,  8.497337036180800e-21, -2.102012844772736e-23,  1.380585409208632e-26,
  2.822712267563140e-28,  6.457760287121581e-02, -5.157865485862771e-04,  3.000783615063628e-06, -1.487933522972843e-08,  6.511771443020944e-11, -2.497415848378314e-13,
  7.946772417405788e-16, -1.683185996126168e-18, -1.596847634140296e-21,  4.505225769800034e-23, -3.294443958175348e-25,  1.749297325687370e-27,  1.063056793890642e-01,
 -8.345001658454325e-04,  4.674645700915803e-06, -2.158655753215662e-08,  8.286441388681456e-11, -2.427537800289566e-13,  3.153598192559299e-16,  2.219698621319296e-18,
 -2.321991775273648e-20,  1.340803245761605e-22, -5.564534611580225e-25,  1.469642248642022e-27,  1.579624968137581e-01, -1.212930594187672e-03,  6.465617671945018e-06,
 -2.702105021957494e-08,  8.350387243568382e-11, -1.131417066550384e-13, -7.660603488278453e-16,  7.814401088349101e-18, -4.136861808228532e-20,  1.369195732827449e-22,
 -9.146941961482312e-26, -2.534411112953162e-27,  2.191997897520988e-01, -1.638058410545006e-03,  8.196668472836129e-06, -2.976715870678791e-08,  6.046378277498332e-11,
  1.395195266865364e-13, -2.135374759176113e-15,  1.171060664729936e-17, -3.400937102951839e-20, -3.369851570746965e-23,  1.078475673988670e-24, -7.088702560507455e-27,
  2.895869518690674e-01, -2.094597278542353e-03,  9.679561987445814e-06, -2.863313981551702e-08,  1.208701795647149e-11,  4.652061893785359e-13, -3.172089916937565e-15,
  9.914323722638544e-18,  1.075855267095386e-20, -3.213480480688278e-22,  1.913881652326100e-24, -4.640490872558538e-27,  3.686042438298436e-01, -2.565240653543010e-03,
  1.072824760402220e-05, -2.286664683094472e-08, -5.688249190997843e-11,  7.676251765944142e-13, -3.164035568659511e-15,  3.951016097296043e-19,  7.786644692915276e-20,
 -4.927770206140675e-22,  9.613962341998016e-25,  7.781455526281611e-27,  4.556350622985862e-01, -3.031002824676495e-03,  1.117427595753277e-05, -1.234816430905878e-08,
 -1.349950588634416e-10,  9.262872257550508e-13, -1.646124236285459e-15, -1.455726245869757e-17,  1.234214748980224e-19, -2.814083162270381e-22, -1.970793692680282e-24,
  1.962832753680758e-26,  5.499574598717991e-01, -3.471678502950209e-03,  1.088371991425973e-05,  2.269532949632495e-09, -2.053694310258733e-10,  8.344606920146299e-13,
  1.258358706353747e-15, -2.785915927726499e-17,  9.728759363850643e-20,  3.417909809483620e-22, -4.624556112497111e-24,  1.243115930050102e-26,  6.507352145682977e-01,
 -3.866446590860980e-03,  9.774678061776833e-06,  1.951231484486847e-08, -2.487219541551428e-10,  4.446359459415090e-13,  4.668697888415256e-15, -3.026125230494822e-17,
 -1.643913049883136e-20,  9.887340117323097e-22, -3.537534281515627e-24, -1.740795962444379e-26,  7.570088958734323e-01, -4.194642442335694e-03,  7.833908237488231e-06,
  3.716266585609398e-08, -2.479457606311378e-10, -1.932843963865434e-13,  7.115451288316579e-15, -1.576002137744275e-17, -1.674398680677280e-19,  1.024886678452297e-21,
  2.228229479173372e-24, -4.183764240088835e-26,  8.676875683954693e-01, -4.436717064527377e-03,  5.130508215386633e-06,  5.249375151049675e-08, -1.935041692313522e-10,
 -9.196894673302656e-13,  7.106182409481764e-15,  1.274148698911429e-17, -2.501402770698790e-19,  1.195848623604143e-22,  8.248677055752238e-24, -2.253323835219312e-26,
  9.815420163486347e-01, -4.575389038274650e-03,  1.823909963499122e-06,  6.266922520281725e-08, -8.830391486369952e-11, -1.495157213945841e-12,  3.942548134275312e-15,
  4.169643642973460e-17, -1.719213977628218e-19, -1.226467498926236e-21,  7.397586580674323e-24,  3.594175945377338e-26,  1.097200657191918e+00, -4.596972850605468e-03,
 -1.837055032406312e-06,  6.528394129588423e-08,  4.976188024446859e-11, -1.677103104800711e-12, -1.595116108870598e-15,  5.252546997693839e-17,  5.611927379754125e-20,
 -1.825430787355270e-21, -2.099778030638269e-24,  6.765008563061478e-26,  1.213149622547405e+00, -4.492833500372333e-03, -5.527363289852677e-06,  5.897130839354276e-08,
  1.894568116728601e-10, -1.326212813111742e-12, -7.203010144477314e-15,  3.372835302876216e-17,  2.863038800037868e-19, -8.432888334592289e-22, -1.160159785038968e-23,
  1.731135649459734e-26,  1.327738780591172e+00, -4.260870652005446e-03, -8.873952453142475e-06,  4.394570970548980e-08,  2.931438490877341e-10, -5.003082373015985e-13,
 -9.980173998817172e-15, -7.717496295879967e-18,  3.254278626431155e-19,  1.084670314895235e-21, -9.449686300569317e-24, -6.567145919441533e-26,  1.439195690872977e+00,
 -3.906878324869766e-03, -1.149964822238011e-05,  2.230095773751872e-08,  3.283899792711984e-10,  5.217437497626078e-13, -8.100782780279775e-15, -4.632894639589025e-17,
  1.114517741690089e-19,  2.101096199753084e-21,  3.738903239907408e-24, -6.724267762025532e-26,  1.545649523198110e+00, -3.445565446024269e-03, -1.308039888921062e-05,
 -2.122671763483992e-09,  2.810636313444762e-10,  1.329293329024508e-12, -2.286644384970922e-15, -5.457263013103417e-17, -1.876928594038461e-19,  1.051220746765342e-21,
  1.237541332807077e-23,  2.231434619018996e-26,  1.645166713126265e+00, -2.900973220701116e-03, -1.340872713911203e-05, -2.442561560040741e-08,  1.644195997295690e-10,
  1.571415194186938e-12,  4.174108784496718e-15, -2.623361799404929e-17, -3.032003200155175e-19, -9.271583458825748e-22,  5.517685747640446e-24,  7.057971881321432e-26,
  1.735799436952010e+00, -2.306009625512350e-03, -1.245119947876074e-05, -3.985465566987838e-08,  1.821113690823349e-11,  1.161977599054429e-12,  7.401623845335240e-15,
  1.493180836416049e-17, -1.429627348615724e-19, -1.569920943704398e-21, -6.375932689160565e-24,  1.143471686506007e-26,  1.815646772210417e+00, -1.700866351086222e-03,
 -1.038389023933105e-05, -4.525903292785891e-08, -1.050831096423642e-10,  3.606420068938580e-13,  5.784696115928415e-15,  3.494098012534225e-17,  9.518020272767146e-20,
 -4.064480665326831e-22, -6.781668500677554e-24, -4.278759947112954e-26,  1.882926668703112e+00, -1.130211745711302e-03, -7.589748235720773e-06, -4.030689740070016e-08,
 -1.632536660164225e-10, -3.644618300041080e-13,  1.333742360977469e-15,  2.235923746715916e-17,  1.580008168400586e-19,  7.065991797768182e-22,  1.178573196346721e-24,
 -1.353683540688372e-26,  1.936054782416968e+00, -6.392683606219738e-04, -4.607687014752619e-06, -2.789667799865221e-08, -1.457571011445698e-10, -6.397205654534083e-13,
 -2.077055636981618e-15, -1.698470531204742e-18,  4.436476978135898e-20,  4.796624152619040e-22,  3.295102649535327e-24,  1.707224559264285e-26,  1.973724454707092e+00,
 -2.691531882234736e-04, -2.035514961932433e-06, -1.339275328433068e-08, -8.030081157835916e-11, -4.451947778369685e-13, -2.279943461184780e-15, -1.061590612838555e-17,
 -4.302237014964875e-20, -1.324152918791404e-22, -9.730244877634931e-26,  2.915368149839787e-27,  1.994985664075344e+00, -5.206709042759817e-05, -4.043079887790236e-07,
 -2.779882012805902e-09, -1.783193126517182e-11, -1.091622870818506e-13, -6.451311568987465e-16, -3.703815309718240e-18, -2.072764885951512e-20, -1.132467133531304e-22,
 -6.041573109276357e-25, -3.143654644666433e-27,  1.283640601401926e-03, -1.034704389490784e-05,  6.251718491032478e-08, -3.355297970605712e-10,  1.686627456775075e-12,
 -8.130424252676316e-15,  3.805272374044030e-17, -1.742090213915429e-19,  7.836903717086680e-22, -3.475494922022545e-24,  1.522462834190580e-26, -6.598929715177617e-29,
  1.154252416849416e-02, -9.267826593112183e-05,  5.553639231580531e-07, -2.938643104613878e-09,  1.445273495965947e-11, -6.751625956232902e-14,  3.026349358706548e-16,
 -1.307739262516370e-18,  5.452789813530172e-21, -2.190151187798815e-23,  8.427828607616419e-26, -3.076009283039504e-28,  3.200541863052266e-02, -2.549679389272508e-04,
  1.502492824817698e-06, -7.720952402564395e-09,  3.625360106924302e-11, -1.579548043773330e-13,  6.387370306714377e-16, -2.366834283816077e-18,  7.753233970281185e-21,
 -2.025323655476620e-23,  2.376738404579891e-26,  1.762058760308601e-28,  6.256136289833783e-02, -4.924771486930853e-04,  2.828321376169888e-06, -1.387639030278278e-08,
  6.030976400366072e-11, -2.312392444283621e-13,  7.470591781959076e-16, -1.710733880736213e-18, -1.945401195921187e-22,  3.331327605404557e-23, -2.598902591721955e-25,
  1.421661825973978e-27,  1.030408638154674e-01, -7.981169820941191e-04,  4.423403163072150e-06, -2.029913660899679e-08,  7.808964336251469e-11, -2.345189792510685e-13,
  3.678046074648357e-16,  1.549722529047389e-18, -1.877804309661626e-20,  1.131192400433304e-22, -4.916575528494046e-25,  1.462432206736935e-27,  1.532122025509550e-01,
 -1.162480128276195e-03,  6.149303728614900e-06, -2.570401811650286e-08,  8.107415300243802e-11, -1.290465810080618e-13, -5.650554606801850e-16,  6.568564457207918e-18,
 -3.652956954796752e-20,  1.313208325640761e-22, -1.817436861613902e-25, -1.610502303437384e-27,  2.127764639769875e-01, -1.573897245708079e-03,  7.845350453830210e-06,
 -2.878009032589290e-08,  6.276760373506118e-11,  9.208148041650343e-14, -1.822840418644558e-15,  1.061063317766438e-17, -3.451799147161905e-20,  3.552633005119789e-24,
  7.926862239207792e-25, -5.908475196105317e-27,  2.813612651684809e-01, -2.018531204974612e-03,  9.337418559848433e-06, -2.836935599068265e-08,  2.065248343695372e-11,
  3.924359758233438e-13, -2.891305204177159e-15,  1.008786183443836e-17,  5.165971053728139e-22, -2.491108116288894e-22,  1.693256024113371e-24, -5.291962675211695e-27,
  3.585131749739006e-01, -2.480526603773432e-03,  1.044888041257707e-05, -2.365806395577820e-08, -4.228707419802661e-11,  6.920865311764898e-13, -3.120698984656067e-15,
  2.611016367587395e-18,  6.089156808058982e-20, -4.485206875699948e-22,  1.226779420780216e-24,  4.398708918039423e-27,  4.436888509545223e-01, -2.942236654204316e-03,
  1.101374249690690e-05, -1.436215652148296e-08, -1.168951351070630e-10,  8.823254321897764e-13, -2.000056666451425e-15, -1.078343912972304e-17,  1.120726756228861e-19,
 -3.437734632764098e-22, -1.168408175227412e-24,  1.675949406953660e-26,  5.362449806853832e-01, -3.384554388789283e-03,  1.089179419449719e-05, -8.814820930711826e-10,
 -1.884395338725605e-10,  8.556625360279067e-13,  5.234888465901850e-16, -2.458365116632315e-17,  1.064039607522469e-19,  1.687909460385722e-22, -4.003200285389855e-24,
  1.548990301142725e-26,  6.354272114196674e-01, -3.787379513659073e-03,  9.985260923789728e-06,  1.560970456653763e-08, -2.387775515788979e-10,  5.464893493064113e-13,
  3.819166522735173e-15, -3.024644237168994e-17,  1.644784242881735e-20,  8.345565922682505e-22, -4.107439296319669e-24, -8.645223769577697e-27,  7.403583974749575e-01,
 -4.130255044019356e-03,  8.255959487496995e-06,  3.317372624462258e-08, -2.501424664698347e-10, -2.837977645801649e-14,  6.604806391316786e-15, -2.051410128978349e-17,
 -1.293739100931398e-19,  1.078267170381337e-21,  4.722832603135670e-25, -3.752985098724418e-26,  8.500267017217552e-01, -4.393207269053859e-03,  5.741280147145560e-06,
  4.925990604860491e-08, -2.101682267224139e-10, -7.457582542292275e-13,  7.351970197997974e-15,  4.867423236241367e-18, -2.401646672557104e-19,  4.265094305204126e-22,
  7.025222781249868e-24, -3.245515601786357e-26,  9.632743687554908e-01, -4.557815891735900e-03,  2.566494396252865e-06,  6.102266375723472e-08, -1.171696583946785e-10,
 -1.387186407704062e-12,  5.026813667035866e-15,  3.554843604616014e-17, -2.104085345076171e-19, -9.035404500013107e-22,  8.631735364158428e-24,  1.990381123744979e-26,
  1.078788350222182e+00, -4.608524686666959e-03, -1.049982848797003e-06,  6.581021776281701e-08,  1.595690749139380e-11, -1.697595561747236e-12, -1.092223431911362e-16,
  5.325949953609809e-17, -1.038381394226094e-20, -1.849225810113105e-21,  9.145448786998768e-25,  6.827015869545638e-26,  1.195094402571562e+00, -4.534172326834426e-03,
 -4.802424539848487e-06,  6.178136993435043e-08,  1.612855487705901e-10, -1.486748264185166e-12, -6.135543967981212e-15,  4.231666586782674e-17,  2.478362873224939e-19,
 -1.285502647533885e-21, -1.034770009448531e-23,  3.942755304396506e-26,  1.310556766075609e+00, -4.329673987735575e-03, -8.318834635683990e-06,  4.854289596187819e-08,
  2.807311640645798e-10, -7.412154089890948e-13, -1.004515386796757e-14,  3.242559203048108e-18,  3.570065096043624e-19,  6.523707218366270e-22, -1.206524450089294e-23,
 -5.194429637135260e-26,  1.423386005132971e+00, -3.997715020339482e-03, -1.120020234403417e-05,  2.762768008813301e-08,  3.367779750203797e-10,  3.122322199755686e-13,
 -9.336521133515839e-15, -4.152951581812609e-17,  1.890195915130599e-19,  2.185974733310810e-21,  3.761347180438162e-25, -8.489035310544395e-26,  1.531657924273465e+00,
 -3.550232077548720e-03, -1.307802261484391e-05,  2.583520226098869e-09,  3.069735859043568e-10,  1.255437187548733e-12, -3.892384618019395e-15, -5.987618043962636e-17,
 -1.407543970893171e-19,  1.560019248662353e-21,  1.290707268544459e-23,  7.082293232975707e-28,  1.633346490591629e+00, -3.009368322638902e-03, -1.368499620998118e-05,
 -2.153830238365513e-08,  1.967844008355824e-10,  1.661653772839602e-12,  3.299055756443859e-15, -3.642121394758095e-17, -3.318288153784774e-19, -6.413203039853115e-22,
  8.841083873540627e-24,  7.971645182573832e-26,  1.726373159705952e+00, -2.407525461807257e-03, -1.292690854345849e-05, -3.936757718160658e-08,  4.325804434738248e-11,
  1.344062753835323e-12,  7.746826981213917e-15,  9.404785402554006e-18, -2.039036708607689e-19, -1.809809137654705e-21, -5.483122116491551e-24,  3.001978894855381e-26,
  1.808673685310330e+00, -1.786137890327496e-03, -1.093682323133567e-05, -4.687477807938225e-08, -9.640098205435424e-11,  5.115435698477552e-13,  6.803089551811034e-15,
  3.769650478331051e-17,  7.519791042755480e-20, -7.168360653294954e-22, -8.770069118122133e-24, -4.720096313158651e-26,  1.878281259020077e+00, -1.192909409252385e-03,
 -8.089337660531239e-06, -4.297530730692498e-08, -1.701690401555936e-10, -3.243441806058152e-13,  2.034466870056449e-15,  2.783004628614130e-17,  1.841200451683795e-19,
  7.392206900759934e-22,  3.824916911376009e-25, -2.315897335305805e-26,  1.933421808559739e+00, -6.775095332553321e-04, -4.956870858270752e-06, -3.033386845767355e-08,
 -1.590529577093881e-10, -6.899632615245469e-13, -2.101951333574589e-15,  2.444722588634305e-20,  6.419404846702348e-20,  6.273604493206814e-22,  4.111315477856438e-24,
  2.002124322405937e-26,  1.972614224112918e+00, -2.861026984223881e-04, -2.204240621292612e-06, -1.475187439922115e-08, -8.977679321036776e-11, -5.036403590182309e-13,
 -2.597183243117907e-15, -1.206936361863024e-17, -4.782386808037334e-20, -1.332271409733057e-22,  7.074552029465736e-26,  4.846601897788879e-27,  1.994770708441452e+00,
 -5.544001053268341e-05, -4.394533101760842e-07, -3.083536788725051e-09, -2.017881271097142e-11, -1.259688087173369e-13, -7.587717521439491e-16, -4.437278910656258e-18,
 -2.527501870416957e-20, -1.404196149928274e-22, -7.608210490995901e-25, -4.014148302000670e-27,  1.243227832284156e-03, -9.862565127109866e-06,  5.864753382420380e-08,
 -3.097966138073544e-10,  1.532770689240721e-12, -7.272970832786075e-15,  3.350796125744890e-17, -1.510207291517626e-19,  6.688693814944423e-22, -2.920792759781605e-24,
  1.259928688753066e-26, -5.378611349442584e-29,  1.118047900836793e-02, -8.837257839216118e-05,  5.214443528745981e-07, -2.717819414880764e-09,  1.317217509323189e-11,
 -6.067341011564674e-14,  2.683470449519540e-16, -1.145240245991444e-18,  4.721883897306266e-21, -1.878690387030930e-23,  7.178928487986857e-26, -2.612915045143623e-28,
  3.100901357915213e-02, -2.433089758543113e-04,  1.413220129173332e-06, -7.165356677497563e-09,  3.324257594749163e-11, -1.433930030625900e-13,  5.758308976354454e-16,
 -2.130199503702320e-18,  7.042873780191235e-21, -1.917177464777715e-23,  2.975203770518247e-26,  1.000660464947271e-28,  6.063567554334116e-02, -4.705005853978773e-04,
  2.667444923057010e-06, -1.294747447799635e-08,  5.586039418846323e-11, -2.138842948571330e-13,  6.992381460764489e-16, -1.699659832467868e-18,  8.319181833401412e-22,
  2.408445816704761e-23, -2.035439440406024e-25,  1.147874003535821e-27,  9.991765712377360e-02, -7.636832282481391e-04,  4.187156938080461e-06, -1.908673215605340e-08,
  7.349071621314783e-11, -2.252352331095932e-13,  4.033701398450172e-16,  1.010311140361649e-18, -1.504438654810903e-20,  9.472262654345886e-23, -4.286917670487039e-25,
  1.391642691160860e-27,  1.486587482603336e-01, -1.114497639784207e-03,  5.848551237629091e-06, -2.442815574205525e-08,  7.837184125501707e-11, -1.405286504180901e-13,
 -3.968009342096411e-16,  5.473730802631498e-18, -3.194792642523879e-20,  1.228533585406163e-22, -2.365784317750295e-25, -9.162382230741224e-28,  2.066042375829902e-01,
 -1.512498688611726e-03,  7.506068404582657e-06, -2.776335384198166e-08,  6.419517274554182e-11,  5.177399080281346e-14, -1.541146739939440e-15,  9.513734876946169e-18,
 -3.387896890732580e-20,  3.039400081725997e-23,  5.574640160480513e-25, -4.799494005755956e-27,  2.734343916612051e-01, -1.945187395623762e-03,  8.999215983504906e-06,
 -2.797980079311637e-08,  2.783014513117084e-11,  3.264282100668508e-13, -2.609871292341645e-15,  9.973516438818129e-18, -7.289112182503818e-21, -1.861134792183707e-22,
  1.455502421692470e-24, -5.446561120993538e-27,  3.487564377481172e-01, -2.398081623955066e-03,  1.016136775830650e-05, -2.422796405887426e-08, -2.918731365487655e-11,
  6.182726683850194e-13, -3.022669035700120e-15,  4.310996835161779e-18,  4.566703365882089e-20, -3.964158959753603e-22,  1.359012777906877e-24,  1.727967583747080e-27,
  4.320949895522768e-01, -2.854846569509238e-03,  1.083074830895189e-05, -1.609401020461656e-08, -9.975105207706803e-11,  8.310943683699991e-13, -2.253701131257573e-15,
 -7.402759944040765e-18,  9.902488113091639e-20, -3.766880813080127e-22, -5.005468731363421e-25,  1.357600756780318e-26,  5.228808942028693e-01, -3.297512298018524e-03,
  1.086369253994855e-05, -3.759153052632022e-09, -1.712543931624823e-10,  8.603554616379125e-13, -1.164833708142528e-16, -2.111104070267177e-17,  1.097670691366393e-19,
  2.278465514165366e-23, -3.287952779315059e-24,  1.675368728915520e-26,  6.204385533209653e-01, -3.706812246347822e-03,  1.015003076532512e-05,  1.188139569847169e-08,
 -2.269993425591386e-10,  6.280726278251824e-13,  2.983921705646242e-15, -2.927171865496300e-17,  4.346428485001195e-20,  6.649862782441626e-22, -4.315767030449875e-24,
 -1.057248368252878e-27,  7.239718978115599e-01, -4.062683056194022e-03,  8.630039140831174e-06,  2.917531543361329e-08, -2.491736997599308e-10,  1.228109426085217e-13,
  5.978295423291798e-15, -2.403246373087513e-17, -9.059812216758403e-20,  1.065926029542264e-21, -1.041710601245647e-24, -3.100658166000703e-26,  8.325493947603213e-01,
 -4.344970789243400e-03,  6.311761813671375e-06,  4.578751098339009e-08, -2.233123008046664e-10, -5.685278958599511e-13,  7.383342398329456e-15, -2.520863591406710e-18,
 -2.201155184311944e-19,  6.769067935998818e-22,  5.451174905338575e-24, -3.842345084627494e-26,  9.450887591038895e-01, -4.534388783165487e-03,  3.286624655307652e-06,
  5.893287873426468e-08, -1.436303782731098e-10, -1.255387078399689e-12,  5.923500458898883e-15,  2.836297952499961e-17, -2.365548257143751e-19, -5.456689437149974e-22,
  9.140575877177252e-24,  3.283078869011406e-27,  1.060342456053852e+00, -4.613763897484681e-03, -2.598478649020968e-07,  6.579427613762386e-08, -1.790087825833056e-11,
 -1.682420369919335e-12,  1.367467733660885e-15,  5.187493200165448e-17, -7.558430526859956e-20, -1.753838920417993e-21,  3.812003430484967e-24,  6.240773228499089e-26,
  1.176885628746945e+00, -4.569584657501238e-03, -4.046570720042511e-06,  6.411647664601884e-08,  1.301784671296838e-10, -1.618932269934635e-12, -4.847151905868670e-15,
  4.943084846981089e-17,  1.945806847343194e-19, -1.658755054100437e-21, -8.174509753349067e-24,  5.866687805997643e-26,  1.293108764239058e+00, -4.393819458439766e-03,
 -7.709901184496661e-06,  5.290295557978653e-08,  2.635101244373157e-10, -9.799004007057047e-13, -9.791581015625348e-15,  1.494524943168723e-17,  3.713049295765612e-19,
  1.297327667137792e-22, -1.391399565178921e-23, -3.101269199064286e-26,  1.407218171364282e+00, -4.085898513254024e-03, -1.083617391020690e-05,  3.305352788674471e-08,
  3.406915061491710e-10,  7.495792281135095e-14, -1.040285915088679e-14, -3.422641813336545e-17,  2.670480917452595e-19,  2.122325525556462e-21, -3.644607093531705e-24,
 -9.665403287065316e-26,  1.517248064297692e+00, -3.654646880257771e-03, -1.301674033879436e-05,  7.690313402378720e-09,  3.310099609122670e-10,  1.141448040215133e-12,
 -5.622824306708763e-15, -6.338250639375058e-17, -7.536356596863227e-20,  2.069102343225561e-21,  1.234300534366277e-23, -2.728050447914376e-26,  1.621088499378900e+00,
 -3.119826053622766e-03, -1.392345490930422e-05, -1.811995396322341e-08,  2.307203640573803e-10,  1.727374969168834e-12,  2.127658464684165e-15, -4.733392683628504e-17,
 -3.476914569646112e-19, -2.160896615933273e-22,  1.244291591279766e-23,  8.275328202948251e-26,  1.716533254773902e+00, -2.512816498677168e-03, -1.339424668237291e-05,
 -3.845022108593420e-08,  7.201579665085632e-11,  1.532347649838861e-12,  7.908732520614485e-15,  1.798061651806253e-18, -2.726265864315070e-19, -1.996085115347174e-21,
 -3.657591235673027e-24,  5.377100615837395e-26,  1.801350546176138e+00, -1.875907849610689e-03, -1.150820771593696e-05, -4.832611215944005e-08, -8.445057852149959e-11,
  6.877292934700051e-13,  7.887894380233776e-15,  3.961812988769657e-17,  4.257059262290704e-20, -1.109805853059025e-21, -1.088660700956618e-23, -4.828931795587686e-26,
  1.873376859885621e+00, -1.259733685668336e-03, -8.621582296202021e-06, -4.574697683783028e-08, -1.761009877786420e-10, -2.654756602376683e-13,  2.900203099470856e-15,
  3.414843020049672e-17,  2.107298176597298e-19,  7.305767220937133e-22, -9.093577246543933e-25, -3.616466691332915e-26,  1.930630092637551e+00, -7.186648547447715e-04,
 -5.336610606802360e-06, -3.299184615972038e-08, -1.733553433266977e-10, -7.401477067137597e-13, -2.068876088736398e-15,  2.473529011724762e-18,  8.995907562014590e-20,
  8.102607066088987e-22,  5.053438167552729e-24,  2.272255134380816e-26,  1.971433388814822e+00, -3.044699207716060e-04, -2.390225380931629e-06, -1.627239034302614e-08,
 -1.005012101173203e-10, -5.702053951502967e-13, -2.957265018995640e-15, -1.367545907289487e-17, -5.251095709241830e-20, -1.253759882155050e-22,  3.423627637961489e-25,
  7.673917945102256e-27,  1.994541674788095e+00, -5.910933353452805e-05, -4.784793816422829e-07, -3.427586188997425e-09, -2.289085080832555e-11, -1.457665407481023e-13,
 -8.951426864544644e-16, -5.333198416282601e-18, -3.092327309730156e-20, -1.746953670274332e-22, -9.611566443003322e-25, -5.139867781355715e-27,  1.204692962132265e-03,
 -9.407848958353068e-06,  5.507245799531222e-08, -2.863936591456455e-10,  1.395022768122247e-12, -6.517197886837680e-15,  2.956389456180285e-17, -1.312064629025581e-19,
  5.722499729162799e-22, -2.461109906498220e-24,  1.045626397889810e-26, -4.397398760840004e-29,  1.083513018949472e-02, -8.432798607250874e-05,  4.900561086846345e-07,
 -2.516433037774211e-09,  1.202059843791995e-11, -5.460141308365475e-14,  2.382978719710887e-16, -1.004428760367915e-18,  4.094583725203124e-21, -1.613319055482703e-23,
  6.118366213288712e-26, -2.218330868418682e-28,  3.005785711450845e-02, -2.323383231385610e-04,  1.330334874936573e-06, -6.655687288740269e-09,  3.050821295074793e-11,
 -1.302639708456856e-13,  5.192384435238540e-16, -1.915633247614218e-18,  6.375012821506150e-21, -1.791088453725936e-23,  3.290090804241503e-26,  4.621354891427295e-29,
  5.879538934159009e-02, -4.497676300214072e-04,  2.517299573050518e-06, -1.208703396852865e-08,  5.174668936747961e-11, -1.976699095059939e-13,  6.521400633791088e-16,
 -1.660642617216141e-18,  1.563936948051086e-21,  1.688293984641440e-23, -1.581815515716421e-25,  9.212808592475511e-28,  9.692849590356850e-02, -7.310824853084655e-04,
  3.965024333555806e-06, -1.794638366063030e-08,  6.908484356989754e-11, -2.152662502469552e-13,  4.254086954722987e-16,  5.802595346496931e-19, -1.192854013558229e-20,
  7.876985871514121e-23, -3.697330231346152e-25,  1.283963173154432e-27,  1.442925077904010e-01, -1.068860680932769e-03,  5.562842777980768e-06, -2.319715821126692e-08,
  7.547787049898669e-11, -1.483242034622976e-13, -2.571976893735308e-16,  4.520265359969165e-18, -2.770376491578799e-20,  1.127454415460359e-22, -2.651270397812816e-25,
 -4.089364511039560e-28,  2.006722546469165e-01, -1.453765255191868e-03,  7.179098798289260e-06, -2.672986851376793e-08,  6.488172618323754e-11,  1.786173261266926e-14,
 -1.289747068782844e-15,  8.451023632209942e-18, -3.243153742555709e-20,  4.877117215748083e-23,  3.686478401328783e-25, -3.803910052051650e-27,  2.657955143832433e-01,
 -1.874528653865069e-03,  8.666334744566740e-06, -2.748559883132817e-08,  3.375479909342187e-11,  2.671102424170291e-13, -2.334808196810358e-15,  9.643832908063944e-18,
 -1.299870771344648e-20, -1.326510610554281e-22,  1.219008489190275e-24, -5.257700367689759e-27,  3.393248418102555e-01, -2.317960648731105e-03,  9.868225618624668e-06,
 -2.459993516439500e-08, -1.753672467005558e-11,  5.473294301356340e-13, -2.883572226854418e-15,  5.554607790655798e-18,  3.238701724595444e-20, -3.411687326585420e-22,
  1.388825726187784e-24, -2.668437332018693e-28,  4.208476354390689e-01, -2.768998983967806e-03,  1.062858291074162e-05, -1.756005495890080e-08, -8.368504544851935e-11,
  7.748636474259941e-13, -2.418674959993014e-15, -4.453688506039309e-18,  8.523907297892528e-20, -3.857064612917298e-22,  2.649919122350834e-26,  1.040399954334301e-26,
  5.098643143558426e-01, -3.210828472455729e-03,  1.080270909220604e-05, -6.361912198706077e-09, -1.541210684255921e-10,  8.508633549891465e-13, -6.584661469853921e-16,
 -1.760930733368913e-17,  1.083981915967583e-19, -9.394871909836262e-23, -2.549973780940616e-24,  1.658730562694707e-26,  6.057745219349747e-01, -3.625102458473757e-03,
  1.027124195482629e-05,  8.353513304318404e-09, -2.137872352629997e-10,  6.900295469677709e-13,  2.187146993859312e-15, -2.753112237452400e-17,  6.430270472821866e-20,
  4.933214715815603e-22, -4.223513690920932e-24,  4.976330974214335e-27,  7.078613681628112e-01, -3.992309867010382e-03,  8.956327920063066e-06,  2.521574745325166e-08,
 -2.453387395227266e-10,  2.579226279320613e-13,  5.270495125483204e-15, -2.632820910887076e-17, -5.328350050937453e-20,  9.991926891258680e-22, -2.238548999506704e-24,
 -2.327675556295762e-26,  8.152738928305295e-01, -4.292340436939630e-03,  6.839429824035166e-06,  4.213313956968623e-08, -2.329205866217733e-10, -3.929466879704438e-13,
  7.218090475861875e-15, -9.135942945199290e-18, -1.922378561334981e-19,  8.602753038617169e-22,  3.702783790562401e-24, -4.041676968859755e-26,  9.270082112594101e-01,
 -4.505307931933822e-03,  3.979227849472971e-06,  5.644190941253848e-08, -1.672566410590560e-10, -1.104564115015426e-12,  6.609237505318920e-15,  2.054948500519886e-17,
 -2.496257260689508e-19, -1.818374746747787e-22,  8.938522700196949e-24, -1.213628695730283e-26,  1.041888233035110e+00, -4.612691967452670e-03,  5.268616791020357e-07,
  6.524094620059589e-08, -5.110509688805519e-11, -1.632501637711333e-12,  2.776852362845122e-15,  4.848064914692976e-17, -1.353429426121437e-19, -1.549462918132369e-21,
  6.322753855666313e-24,  5.089340951826906e-26,  1.158547464533013e+00, -4.598846723296440e-03, -3.265763522430431e-06,  6.593446478338241e-08,  9.675200881966935e-11,
 -1.718008849608239e-12, -3.385312471590415e-15,  5.464421073472372e-17,  1.296442684589388e-19, -1.929547112234666e-21, -5.263249883339419e-24,  7.262139931970059e-26,
  1.275414247731621e+00, -4.452889222892392e-03, -7.050456392547142e-06,  5.694973173650597e-08,  2.416029758883901e-10, -1.208533685623873e-12, -9.206846444328137e-15,
  2.679208750630871e-17,  3.656956128426819e-19, -4.466677285766415e-22, -1.471360669414960e-23, -4.637922970360631e-27,  1.390703841459672e+00, -4.170908642848432e-03,
 -1.040682050694929e-05,  3.850271235461624e-08,  3.396216387331097e-10, -1.851757444210173e-13, -1.123032462499765e-14, -2.449498457314082e-17,  3.397868178148055e-19,
  1.889868578565599e-21, -8.000813928691664e-24, -9.971973815254940e-26,  1.502421922726666e+00, -3.758319948863449e-03, -1.289195167533971e-05,  1.316116491055714e-08,
  3.523445882207023e-10,  9.850033851493232e-13, -7.419436329505721e-15, -6.450994993080045e-17,  7.637442563225726e-21,  2.529501102239470e-21,  1.044045950937230e-23,
 -5.969497381340247e-26,  1.608385134847507e+00, -3.232018053442207e-03, -1.411759743303597e-05, -1.414974697194278e-08,  2.656646330395876e-10,  1.761273742531396e-12,
  6.460991594791615e-16, -5.848138663471798e-17, -3.456422356908407e-19,  3.534326802700210e-22,  1.598963131542212e-23,  7.672723557729132e-26,  1.706264789424780e+00,
 -2.621794098270412e-03, -1.384769106078885e-05, -3.704248120606570e-08,  1.045595435691889e-10,  1.721708277287486e-12,  7.825966531374922e-15, -8.098869838713641e-18,
 -3.464766247608461e-19, -2.087075680701337e-21, -6.875082017538149e-25,  8.180531460293946e-26,  1.793659079705378e+00, -1.970315021222405e-03, -1.209574006146792e-05,
 -4.955661948357706e-08, -6.871241645161593e-11,  8.904643618994555e-13,  9.009644291362273e-15,  4.025298067704969e-17, -5.726138207080547e-21, -1.586938602279626e-21,
 -1.293775774723238e-23, -4.381430193717217e-26,  1.868196434934163e+00, -1.330950475676583e-03, -9.187613754616629e-06, -4.860294777267269e-08, -1.806329635326447e-10,
 -1.836109454492356e-13,  3.954650566525081e-15,  4.130218973765102e-17,  2.359503231302208e-19,  6.577054005699489e-22, -2.856990936814158e-24, -5.302542298981650e-26,
  1.927667471994941e+00, -7.629896432783533e-04, -5.749652030885979e-06, -3.588662334081407e-08, -1.886474169922141e-10, -7.886159386113797e-13, -1.954640815145923e-15,
  5.859937348768767e-18,  1.230138260532284e-19,  1.033031137299368e-21,  6.098804887856499e-24,  2.459165493494082e-26,  1.970175989056453e+00, -3.244010273112400e-04,
 -2.595531372331553e-06, -1.797563250058047e-08, -1.126470761882089e-10, -6.459686479744941e-13, -3.364358337232128e-15, -1.542465908668144e-17, -5.668681285296120e-20,
 -1.038318633353308e-22,  7.645473948248616e-25,  1.176001617686755e-26,  1.994297312195227e+00, -6.310814844545469e-05, -5.219080683252818e-07, -3.818382575421259e-09,
 -2.603371511816512e-11, -1.691598261839090e-13, -1.059326899084588e-15, -6.431253734054955e-18, -3.796245621267313e-20, -2.180667415297273e-22, -1.218021879962160e-24,
 -6.598180268074456e-27,  1.167921482645082e-03, -8.980646405565803e-06,  5.176547647303366e-08, -2.650787080771301e-10,  1.271486925846369e-12, -5.849759604267243e-15,
  2.613371639121478e-17, -1.142349760358107e-19,  4.907347851481646e-22, -2.079103615364793e-24,  8.701650707689787e-27, -3.605939596042191e-29,  1.050547240300783e-02,
 -8.052513740777286e-05,  4.609778338183325e-07, -2.332538250930999e-09,  1.098355792338798e-11, -4.920546643351883e-14,  2.119241874029776e-16, -8.822409303075597e-19,
  3.555583023476648e-21, -1.387078671172159e-23,  5.218067406264051e-26, -1.882988731912195e-28,  2.914929480725691e-02, -2.220070125861353e-04,  1.253311586109845e-06,
 -6.187738859569134e-09,  2.802332274543391e-11, -1.184234355480692e-13,  4.683616148621808e-16, -1.721692275093945e-18,  5.754288262745311e-21, -1.656620797188173e-23,
  3.406132532094603e-26,  8.854589952919528e-30,  5.703569648155434e-02, -4.301956309793680e-04,  2.377095097169955e-06, -1.128987943432291e-08,  4.794606991222810e-11,
 -1.825703488752487e-13,  6.064258200002897e-16, -1.602017428047227e-18,  2.067073009163738e-21,  1.130892380350669e-23, -1.218734982875044e-25,  7.352435477772368e-28,
  9.406626852826948e-02, -7.002052495545289e-04,  3.756159609108977e-06, -1.687490924998942e-08,  6.488272051582083e-11, -2.049020871052026e-13,  4.367185583124919e-16,
  2.411717023617188e-19, -9.345746153957938e-21,  6.507418527513092e-23, -3.159693587661390e-25,  1.158021950765285e-27,  1.401043362508613e-01, -1.025451099747565e-03,
  5.291623887982012e-06, -2.201353826368885e-08,  7.245940886393828e-11, -1.530746392120655e-13, -1.424461290083974e-16,  3.696611366455645e-18, -2.383909052580136e-20,
  1.018956809233460e-22, -2.747514664723253e-25, -5.012091815705475e-29,  1.949700526740051e-01, -1.397597834050661e-03,  6.864575577485771e-06, -2.569050648220370e-08,
  6.494798960966808e-11, -1.036820927240993e-14, -1.067365313223684e-15,  7.443841198348333e-18, -3.044826472683858e-20,  6.043358060743957e-23,  2.207591218869140e-25,
 -2.940814568337636e-27,  2.584339856909511e-01, -1.806507716667827e-03,  8.339914698536797e-06, -2.690573808658411e-08,  3.855826173279590e-11,  2.142640830826778e-13,
 -2.071257700508658e-15,  9.160431688769756e-18, -1.695125508490485e-20, -8.840979996660645e-23,  9.960328346023101e-25, -4.850318431486040e-27,  3.302090155624587e-01,
 -2.240199602877402e-03,  9.571692077547327e-06, -2.479665538322447e-08, -7.269037068059220e-12,  4.800961899647170e-13, -2.715304059912179e-15,  6.405150120358615e-18,
  2.109788618687762e-20, -2.863017477496973e-22,  1.344366463517076e-24, -1.662976971413993e-27,  4.099403316573194e-01, -2.684834808539080e-03,  1.041032957753767e-05,
 -1.877822847250827e-08, -6.877681685773924e-11,  7.156144318902796e-13, -2.507272195618061e-15, -1.947158604424778e-18,  7.147492998453367e-20, -3.763778799811914e-22,
  4.185328892096405e-25,  7.468322120080879e-27,  4.971933028207997e-01, -3.124752805504261e-03,  1.071212887052796e-05, -8.692730431879859e-09, -1.372997610763242e-10,
  8.295316141940489e-13, -1.103604973161200e-15, -1.421295411698848e-17,  1.033534034064313e-19, -1.816431369261259e-22, -1.843562192633276e-24,  1.538295626347501e-26,
  5.914390061496646e-01, -3.542588638233655e-03,  1.035142449226925e-05,  5.045916593101879e-09, -1.995229025130291e-10,  7.335183926217494e-13,  1.447523480299574e-15,
 -2.522137365138463e-17,  7.908709540051992e-20,  3.301614424206769e-22, -3.902858427582884e-24,  9.320071421587098e-27,  6.920372526998125e-01, -3.919515184472238e-03,
  9.235556169735745e-06,  2.133821427525301e-08, -2.389759376346263e-10,  3.754081318437380e-13,  4.514707776144243e-15, -2.747688944304173e-17, -1.914960557137598e-20,
  8.915326688230918e-22, -3.086028718043507e-24, -1.526732249832053e-26,  7.982170739260385e-01, -4.235666498656161e-03,  7.322438000024443e-06,  3.835285199906952e-08,
 -2.390713666487390e-10, -2.234477732809777e-13,  6.881001014326468e-15, -1.476692008480598e-17, -1.590289279452101e-19,  9.730420010403997e-22,  1.946962023204873e-24,
 -3.886211708823224e-26,  9.090548703939244e-01, -4.470812013331501e-03,  4.639773525304281e-06,  5.359787068086782e-08, -1.877197819106370e-10, -9.399440464745629e-13,
  7.072291382367290e-15,  1.252444123269625e-17, -2.499015535209633e-19,  1.610340487438191e-22,  8.111978726947306e-24, -2.489997230041226e-26,  1.023450830400569e+00,
 -4.605361864812186e-03,  1.303782461029896e-06,  6.416613749263439e-08, -8.298147227641958e-11, -1.550106775410385e-12,  4.065663327395361e-15,  4.331011967169802e-17,
 -1.860708595122287e-19, -1.256133316637530e-21,  8.229583844139888e-24,  3.525341979455019e-26,  1.140104870119732e+00, -4.621784298059639e-03, -2.466408497695559e-06,
  6.720372887311865e-08,  6.170543554638279e-11, -1.780492579703706e-12, -1.807889311126217e-15,  5.764719123526401e-17,  5.718562608573945e-20, -2.073583883802400e-21,
 -1.888175698786025e-24,  7.952983491392254e-26,  1.257494301974426e+00, -4.506495484509437e-03, -6.344701494284809e-06,  6.061028685445574e-08,  2.152901797586021e-10,
 -1.419192423171564e-12, -8.296063398641721e-15,  3.812358269191136e-17,  3.390494723521134e-19, -1.030828106670035e-21, -1.428248955655212e-23,  2.440343992692431e-26,
  1.373856753888771e+00, -4.252223077300935e-03, -9.912354516498171e-06,  4.389217580657245e-08,  3.331738992882607e-10, -4.616447361427913e-13, -1.175422147786038e-14,
 -1.260352038620148e-17,  4.010156998105701e-19,  1.483519027329027e-21, -1.226076443116113e-23, -9.203209328707931e-26,  1.487183509144318e+00, -3.860726557317934e-03,
 -1.269957552783869e-05,  1.894599138565483e-08,  3.701181924739167e-10,  7.853760718520417e-13, -9.208061727240946e-15, -6.273369060385821e-17,  1.054932143097095e-19,
  2.884663890496050e-21,  7.073068602673243e-24, -9.320738524607989e-26,  1.595230211242269e+00, -3.345563080225852e-03, -1.426072699706429e-05, -9.617045564943693e-09,
  3.009061430178303e-10,  1.755896863196373e-12, -1.143397451295414e-15, -6.920855763221743e-17, -3.206300717266213e-19,  1.056235002178246e-21,  1.902123264265292e-23,
  5.895209220974611e-26,  1.695553278430261e+00, -2.734322542838017e-03, -1.428099400160355e-05, -3.508395065537132e-08,  1.408468031860601e-10,  1.905487964090399e-12,
  7.432686917739407e-15, -2.038601782391362e-17, -4.211586619629899e-19, -2.033759651826933e-21,  3.573421996375650e-24,  1.119675415171846e-25,  1.785580496973813e+00,
 -2.069476917492554e-03, -1.269638907941758e-05, -5.050141314870134e-08, -4.864986513659195e-11,  1.120143671499205e-12,  1.012484081355598e-14,  3.905218742944065e-17,
 -7.260907459453286e-20, -2.139947611177789e-21, -1.461996733240754e-23, -3.103439791543187e-26,  1.862721867700997e+00, -1.406833702942125e-03, -9.788293259269496e-06,
 -5.151688725779425e-08, -1.832578939148960e-10, -7.394762969002462e-14,  5.220191757246744e-15,  4.920447395511969e-17,  2.569556053551972e-19,  4.909089042091966e-22,
 -5.634771653172316e-24, -7.387898873665936e-26,  1.924520717564483e+00, -8.107619444881171e-04, -6.198930233241095e-06, -3.903364516808410e-08, -2.048731082210081e-10,
 -8.330774624619516e-13, -1.729513597806909e-15,  1.044061971874390e-17,  1.648569272405915e-19,  1.298820656722263e-21,  7.191467919320964e-24,  2.467801638081951e-26,
  1.968835445709371e+00, -3.460597597739882e-04, -2.822494042205662e-06, -1.988587839906232e-08, -1.264099514410031e-10, -7.321041291536138e-13, -3.822158033665199e-15,
 -1.729143849055078e-17, -5.973552792232336e-20, -6.133015714270294e-23,  1.402970726958231e-24,  1.759638446142910e-26,  1.994036228527646e+00, -6.747404293807329e-05,
 -5.703441894083957e-07, -4.263432743310976e-09, -2.968647767618053e-11, -1.968894498334494e-13, -1.257659839471042e-15, -7.781660319408004e-18, -4.676448784512684e-20,
 -2.731153333431152e-22, -1.548169228432727e-24, -8.489690045622597e-27,  1.132807475465101e-03, -8.578909202827706e-06,  4.870284137195488e-08, -2.456378568885388e-10,
  1.160513626648868e-12, -5.259225698019095e-15,  2.314419569687242e-17, -9.966483261615858e-20,  4.217881062901885e-22, -1.760786709633107e-24,  7.260799033027689e-27,
 -2.965581540982650e-29,  1.019057434710116e-02, -7.694636208318187e-05,  4.340101935230927e-07, -2.164406023038098e-09,  1.004837401724305e-11, -4.440330928723717e-14,
  1.887420546188398e-16, -7.760646892728839e-19,  3.091888041753537e-21, -1.194054746805919e-23,  4.453837890037253e-26, -1.598536138610103e-28,  2.828086000267309e-02,
 -2.122700851342694e-04,  1.181672733771869e-06, -5.757718724908403e-09,  2.576346125595052e-11, -1.077409795371801e-13,  4.226443726303731e-16, -1.546833976015607e-18,
  5.182446910176657e-21, -1.520414724347856e-23,  3.385824599267821e-26, -1.638705703598387e-29,  5.535210750015458e-02, -4.117080155282863e-04,  2.246101390443972e-06,
 -1.055117790450902e-08,  4.443661186416477e-11, -1.685465884593700e-13,  5.625502291110153e-16, -1.530237592019766e-18,  2.393810267062101e-21,  7.034053470231455e-24,
 -9.297432945094242e-26,  5.835323577016466e-28,  9.132428809970673e-02, -6.709486279679460e-04,  3.559756053468871e-06, -1.586899885983067e-08,  6.088987242765413e-11,
 -1.943715223890389e-13,  4.396198281356933e-16, -2.275137363181440e-20, -7.218645434999953e-21,  5.341581566482414e-23, -2.679086684672572e-25,  1.026403890640150e-27,
  1.360855523215077e-01, -9.841552832328439e-04,  5.034315993630447e-06, -2.087883173036486e-08,  6.937168152531985e-11, -1.553341734316491e-13, -4.908458701578022e-17,
  2.990331864090056e-18, -2.036846544921262e-20,  9.094054703576105e-23, -2.712347213418333e-25,  1.934094586367638e-28,  1.894875669768283e-01, -1.343896732347272e-03,
  6.562513344050708e-06, -2.465432049548020e-08,  6.450078009672884e-11, -3.359188189301588e-14, -8.722407640704323e-16,  6.505771213909041e-18, -2.814283872897487e-20,
  6.689980271993027e-23,  1.078473714791489e-25, -2.213649101847759e-27,  2.513393638375375e-01, -1.741069078098429e-03,  8.020880335475989e-06, -2.625713849612315e-08,
  4.236688910915148e-11,  1.675678314546475e-13, -1.822785802266788e-15,  8.574348242350769e-18, -1.946694640934540e-20, -5.268711715828375e-23,  7.939635571451401e-25,
 -4.321159280662166e-27,  3.213994778205808e-01, -2.164817575843453e-03,  9.273739949087110e-06, -2.483962311119193e-08,  1.696095840346955e-12,  4.171481565494344e-13,
 -2.527984394839807e-15,  6.925589674210566e-18,  1.173857549338426e-20, -2.342867478863541e-22,  1.249879487782566e-24, -2.557616412960188e-27,  3.993661055479854e-01,
 -2.602471167761016e-03,  1.017884993645317e-05, -1.976744276223220e-08, -5.506940663769210e-11,  6.550317179687447e-13, -2.531782300470399e-15,  1.270717992232093e-19,
  5.829866783767660e-20, -3.538490525221338e-22,  6.892275254461076e-25,  4.904403202774277e-27,  4.848649739399068e-01, -3.039509120242204e-03,  1.059517780382017e-05,
 -1.075836931739868e-08, -1.210043248866801e-10,  7.986367493806049e-13, -1.456342364354140e-15, -1.102321003037520e-17,  9.564539690817208e-20, -2.423626120740137e-22,
 -1.206075101135626e-24,  1.351207357195578e-26,  5.774345827454636e-01, -3.459588182487849e-03,  1.039331088583675e-05,  1.972565834181470e-09, -1.845608103728982e-10,
  7.600804797374022e-13,  7.783329850210708e-16, -2.252968477470570e-17,  8.827018386629950e-20,  1.831603895013421e-22, -3.427460061234073e-24,  1.203274510029776e-26,
  6.765084915970752e-01, -3.844670894717646e-03,  9.468939173602215e-06,  1.758028929853929e-08, -2.304467979388725e-10,  4.744884128214769e-13,  3.741424032510740e-15,
 -2.760115507998479e-17,  1.058252529870953e-20,  7.569297161622784e-22, -3.589177723009579e-24, -7.732434096898789e-27,  7.813943895775068e-01, -4.175311367255021e-03,
  7.759602554524645e-06,  3.450078080656518e-08, -2.419252061340157e-10, -6.380765972820251e-14,  6.401636488737320e-15, -1.928362479544812e-17, -1.229999194517853e-19,
  1.017831228003359e-21,  3.243661704220100e-25, -3.450144478518259e-26,  8.912498582632500e-01, -4.431173555389333e-03,  5.264336671541821e-06,  5.045328845604828e-08,
 -2.047975469317781e-10, -7.668969459474805e-13,  7.312324519808053e-15,  4.680645168136575e-18, -2.385553296973016e-19,  4.606259890439232e-22,  6.800979899065895e-24,
 -3.404288787317288e-26,  1.005055085161671e+00, -4.591876521206703e-03,  2.064805088813983e-06,  6.259611817218405e-08, -1.129132673396120e-10, -1.438690930671933e-12,
  5.188657765792333e-15,  3.669857936570970e-17, -2.250392792325109e-19, -9.010816813046075e-22,  9.393068542384988e-24,  1.744772606307805e-26,  1.121583397985748e+00,
 -4.638275722105320e-03, -1.655221284493859e-06,  6.790433117585932e-08,  2.579320898345016e-11, -1.804375010433550e-12, -1.794351574065343e-16,  5.827504366116132e-17,
 -1.797583420849185e-20, -2.078829712000872e-21,  1.618885920552780e-24,  7.857309585509393e-26,  1.239371490935415e+00, -4.554287469332725e-03, -5.597680860612686e-06,
  6.381742539256334e-08,  1.850079168523718e-10, -1.604300588142880e-12, -7.083059188077412e-15,  4.827175974566190e-17,  2.919926996141868e-19, -1.572152135353649e-21,
 -1.257737485564619e-23,  5.267561073887725e-26,  1.356692726600268e+00, -4.329325267463007e-03, -9.354018311576219e-06,  4.913367423279070e-08,  3.210990972732733e-10,
 -7.464849892081140e-13, -1.192015560010569e-14,  9.811877977023127e-19,  4.446611545717117e-19,  9.169226532286757e-22, -1.592914125535218e-23, -7.283674245555441e-26,
  1.471538993199380e+00, -3.961311968977695e-03, -1.243621444396888e-05,  2.498094620886343e-08,  3.834758841704272e-10,  5.437832324390792e-13, -1.090139223542300e-14,
 -5.765032137760285e-17,  2.133602150801793e-19,  3.076285973262854e-21,  2.288212838582429e-24, -1.233051544333497e-25,  1.581619175444436e+00, -3.460026011996281e-03,
 -1.434609234127348e-05, -4.523773990762832e-09,  3.355868765440215e-10,  1.704082352368179e-12, -3.218088968221805e-15, -7.870888208125102e-17, -2.683580121348803e-19,
  1.860769473839415e-21,  2.097788599821349e-23,  2.770099432899443e-26,  1.684384883956415e+00, -2.850213255918188e-03, -1.468719169674176e-05, -3.251605383492974e-08,
  1.806860185382591e-10,  2.075433422027796e-12,  6.662447705603307e-15, -3.499679335604694e-17, -4.905343679465269e-19, -1.783607508695212e-21,  9.142809932434727e-24,
  1.405251672686110e-25,  1.777095592644668e+00, -2.173483540503031e-03, -1.330629335972037e-05, -5.108701910957490e-08, -2.373013342575381e-11,  1.375923553365238e-12,
  1.117337335497147e-14,  3.538090224168749e-17, -1.604480696942347e-19, -2.745887261559074e-21, -1.550184117544364e-23, -6.937227438954608e-27,  1.856933934453053e+00,
 -1.487662771532562e-03, -1.042411409895326e-05, -5.445355271547519e-08, -1.833675396521937e-10,  6.881343656217458e-14,  6.715340958101203e-15,  5.765954680728256e-17,
  2.697250414068689e-19,  1.935588540156138e-22, -9.410106519104972e-24, -9.820774788291955e-26,  1.921175439987204e+00, -8.622840071987234e-04, -6.687558631591045e-06,
 -4.244705188651548e-08, -2.219227898289117e-10, -8.704363770303569e-13, -1.355883158239138e-15,  1.652177156349211e-17,  2.170487492385114e-19,  1.607563487976222e-21,
  8.222870867433621e-24,  2.151305375320133e-26,  1.967404485388478e+00, -3.696297637943039e-04, -3.073759731042238e-06, -2.203072689951993e-08, -1.420096923913947e-10,
 -8.298634619602764e-13, -4.333325124180088e-15, -1.922582670823197e-17, -6.072676442567780e-20,  1.249856829881093e-23,  2.348391843955875e-24,  2.583776346661746e-26,
  1.993756871019915e+00, -7.224982625437155e-05, -6.244907535799959e-07, -4.771635930941167e-09, -3.394466794315435e-11, -2.298665552680778e-13, -1.498064556018083e-15,
 -9.448160528155196e-18, -5.780742748212706e-20, -3.431895541624843e-22, -1.973401565175637e-24, -1.094446782005591e-26,  1.099252850977743e-03, -8.200769231823363e-06,
  4.586322054154818e-08, -2.278818570429193e-10,  1.060665320746149e-12, -4.735783827408805e-15,  2.053339741205293e-17, -8.712822747399151e-20,  3.633278761538946e-22,
 -1.494843704842637e-24,  6.074169971690811e-27, -2.445952383850891e-29,  9.889572338568926e-03, -7.357550479625798e-05,  4.089734365009572e-07, -2.010497640567545e-09,
  9.203901949312136e-12, -4.012346267457760e-14,  1.683351608363744e-16, -6.836715008933907e-19,  2.692468645752251e-21, -1.029229899208629e-23,  3.804946112665332e-26,
 -1.357587761054850e-28,  2.745025852093239e-02, -2.030862263588366e-04,  1.114984038118292e-06, -5.362205168372955e-09,  2.370666283249539e-11, -9.809900752873578e-14,
  3.815743264108876e-16, -1.389493621340243e-18,  4.659251789850166e-21, -1.386961702203901e-23,  3.274897915933535e-26, -3.280390611970111e-29,  5.374042790257550e-02,
 -3.942338256822958e-04,  2.123644266369008e-06, -9.866440412713149e-09,  4.119726720995294e-11, -1.555506772542215e-13,  5.208092339553323e-16, -1.450253908065083e-18,
  2.585931978204995e-21,  3.790477861907176e-24, -7.009977822631001e-26,  4.605255749918907e-28,  8.869626663765572e-02, -6.432160211633271e-04,  3.375047064979256e-06,
 -1.492528774447763e-08,  5.710777151404833e-11, -1.838526885737796e-13,  4.360236775244553e-16, -2.249627407061132e-19, -5.478036528128675e-21,  4.356430875134318e-23,
 -2.256078590250229e-25,  8.972570977950500e-28,  1.322279197803412e-01, -9.448643064971856e-04,  4.790327041082458e-06, -1.979377511913247e-08,  6.625963174825018e-11,
 -1.555781537293683e-13,  2.599698636978740e-17,  2.388848627154752e-18, -1.728736541040057e-20,  8.031278584182745e-23, -2.590200481093365e-25,  3.493670469945570e-28,
  1.842151312246254e-01, -1.292562546915595e-03,  6.272827882890640e-06, -2.362875998415476e-08,  6.363384336836410e-11, -5.243923499406953e-14, -7.023202121238622e-16,
  5.644387973645738e-18, -2.567856892889326e-20,  6.945064435037461e-23,  2.404647611349687e-26, -1.615955026984828e-27,  2.445014426537122e-01, -1.678150614608092e-03,
  7.709965010141010e-06, -2.555475398904151e-08,  4.529985330108207e-11,  1.266300182644940e-13, -1.591668790982165e-15,  7.926825746096748e-18, -2.083631646292210e-20,
 -2.456230064891866e-23,  6.165046952324667e-25, -3.741518923084176e-27,  3.128867010057254e-01, -2.091818883843815e-03,  8.976092118306445e-06, -2.474897176553466e-08,
  9.448237491697978e-12,  3.588385219017139e-13, -2.330009497151986e-15,  7.175693110297347e-18,  4.175438179880166e-21, -1.867135590102971e-22,  1.125186397716920e-24,
 -3.052553216023658e-27,  3.891175602893119e-01, -2.522003210180740e-03,  9.936775599064966e-06, -2.054704478407259e-08, -4.257507156969411e-11,  5.945108763685640e-13,
 -2.503981335926374e-15,  1.794514972532618e-18,  4.610229317424003e-20, -3.226231896205762e-22,  8.565585722713665e-25,  2.775409237508630e-27,  4.728755977863906e-01,
 -2.955295811621618e-03,  1.045498163349831e-05, -1.256865453107144e-08, -1.054043606182209e-10,  7.603182210848921e-13, -1.723514605944930e-15, -8.110343967629092e-18,
  8.618948237305618e-20, -2.793520152010550e-22, -6.595731767788843e-25,  1.129486614153350e-26,  5.637626035635751e-01, -3.376396051906447e-03,  1.039976820677988e-05,
 -8.579879799627778e-10, -1.692218261004230e-10,  7.715148551330155e-13,  1.878556187985674e-16, -1.962493281852573e-17,  9.252824595796562e-20,  5.712191762114543e-23,
 -2.865208640167971e-24,  1.330782063673898e-26,  6.612825596446158e-01, -3.768137457352460e-03,  9.658108003090061e-06,  1.397367573257815e-08, -2.201213863772890e-10,
  5.550710415577144e-13,  2.977228362863011e-15, -2.685477494739460e-17,  3.518421759077931e-20,  6.085653048086285e-22, -3.781484353933231e-24, -1.207563611783213e-27,
  7.648198268487207e-01, -4.111644356691568e-03,  8.150371511950220e-06,  3.062792486875963e-08, -2.417108566872465e-10,  8.294142536311529e-14,  5.812100685138313e-15,
 -2.263371490876757e-17, -8.647469132793036e-20,  1.002181726356800e-21, -1.061124022334652e-24, -2.823937809551816e-26,  8.736131477774732e-01, -4.386693912678287e-03,
  5.849640388640988e-06,  4.706338871931524e-08, -2.183742987682661e-10, -5.906739520672830e-13,  7.339359496257040e-15, -2.638344497540962e-18, -2.174539871413928e-19,
  7.009082747491585e-22,  5.175940566940494e-24, -3.915148296060168e-26,  9.867253270788306e-01, -4.572386320410743e-03,  2.804192132666364e-06,  6.056641572773750e-08,
 -1.403628988939105e-10, -1.302673513406015e-12,  6.111047856315393e-15,  2.905199574004252e-17, -2.505787938019802e-19, -5.153337887708896e-22,  9.763775404150911e-24,
 -4.464126044248467e-28,  1.103008978576003e+00, -4.648253810155675e-03, -8.390832966481950e-07,  6.802864126357941e-08, -1.020581507446126e-11, -1.789234578016534e-12,
  1.433090011063414e-15,  5.652156171655239e-17, -9.083218396528972e-20, -1.946930234286648e-21,  4.913528427316871e-24,  7.000419239995633e-26,  1.221069696043946e+00,
 -4.595957853833733e-03, -4.815198453269504e-06,  6.651210549907399e-08,  1.513366738199077e-10, -1.757074498590843e-12, -5.609809428441171e-15,  5.661785763648861e-17,
  2.269668529731372e-19, -2.021418162872660e-21, -9.711258833238177e-24,  7.660694787482219e-26,  1.339229617075755e+00, -4.401712894117639e-03, -8.734131642351357e-06,
  5.413631692304167e-08,  3.033192082485238e-10, -1.030605192513357e-12, -1.168942252156610e-14,  1.560971931194196e-17,  4.655011699725075e-19,  2.237245434025852e-22,
 -1.851363850335155e-23, -4.306935487704549e-26,  1.455496812669169e+00, -4.059497562140850e-03, -1.209931801844730e-05,  3.118881662116905e-08,  3.916088866951420e-10,
  2.636535114577355e-13, -1.240330470627578e-14, -4.904424212765976e-17,  3.243802214639733e-19,  3.052174287187946e-21, -3.651010076093100e-24, -1.448089124043238e-25,
  1.567549322353549e+00, -3.574918053094152e-03, -1.436705227542669e-05,  1.113306905365132e-09,  3.687129393180571e-10,  1.599499382890687e-12, -5.530926623708811e-15,
 -8.606091563747312e-17, -1.860821666145844e-19,  2.712031542114122e-21,  2.125931531712286e-23, -1.700644576279839e-26,  1.672746638257030e+00, -2.969219204162356e-03,
 -1.505864154550542e-05, -2.928468617327578e-08,  2.237048930065758e-10,  2.221742973289270e-12,  5.453700635627941e-15, -5.163813894902286e-17, -5.466057770810040e-19,
 -1.287167244579372e-21,  1.583688897341666e-23,  1.620654821957898e-25,  1.768184868941654e+00, -2.282390331204071e-03, -1.392065948340701e-05, -5.123165822071580e-08,
  6.546789481829447e-12,  1.655296694856835e-12,  1.207644331510031e-14,  2.854524791445381e-17, -2.704444799682764e-19, -3.361923823872964e-21, -1.502192774374880e-23,
  3.127014168049065e-26,  1.850812288871174e+00, -1.573719166539832e-03, -1.109508469067075e-05, -5.736709987409080e-08, -1.802437594530603e-10,  2.503341766127597e-13,
  8.451123499078908e-15,  6.632068314251780e-17,  2.688069101009851e-19, -2.769248392287677e-22, -1.430510545233396e-23, -1.243840926075789e-25,  1.917615990068207e+00,
 -9.178836314504892e-04, -7.218807592016028e-06, -4.613868230069810e-08, -2.396151664178455e-10, -8.965856219164270e-13, -7.868728176191258e-16,  2.445850660437834e-17,
  2.810518369891151e-19,  1.953367263168393e-21,  9.005148372416349e-24,  1.292885316522194e-26,  1.965875055600219e+00, -3.953172421992375e-04, -3.352327907743442e-06,
 -2.444149775602224e-08, -1.596916943853088e-10, -9.405416083980451e-13, -4.898643199872590e-15, -2.114134924968131e-17, -5.828409113048096e-20,  1.322861294792072e-22,
  3.724611386642096e-24,  3.733657092385715e-26,  1.993457503706554e+00, -7.748438630850120e-05, -6.851673677738680e-07, -5.353576602001117e-09, -3.892409378004160e-11,
 -2.692157030030560e-13, -1.790482443160166e-15, -1.151190341953385e-17, -7.170704697637733e-20, -4.326346233080390e-22, -2.522022804302970e-24, -1.412916703330864e-26,
  1.067166664577175e-03, -7.844520324118462e-06,  4.322742103273265e-08, -2.116429682179550e-10,  9.706866375642936e-13, -4.270991678956523e-15,  1.824881035952951e-17,
 -7.631789837534399e-20,  3.136395593100099e-22, -1.272093512154042e-24,  5.094114680369217e-27, -2.023113004180413e-29,  9.601664552196057e-03, -7.039777732281169e-05,
  3.857052515922688e-07, -1.869441792031860e-09,  8.440331468827394e-12, -3.630372861552412e-14,  1.503449112814436e-16, -6.031584315757135e-19,  2.347959266191682e-21,
 -8.883538354476699e-24,  3.253700079298078e-26, -1.153705530497815e-28,  2.665535474327578e-02, -1.944174376319377e-04,  1.052850246728173e-06, -4.998109762023272e-09,
  2.183319429572646e-11, -8.939169809095720e-14,  3.446825725641369e-16, -1.248136673137489e-18,  4.183145739415947e-21, -1.259187778249855e-23,  3.106492179007752e-26,
 -4.286425109917590e-29,  5.219673657213923e-02, -3.777072871270629e-04,  2.009101418203950e-06, -9.231506747227981e-09,  3.820800749869546e-11, -1.435290825374843e-13,
  4.813774981423550e-16, -1.365824178538664e-18,  2.676517625448056e-21,  1.360968086953729e-24, -5.209802927894890e-26,  3.612837125591390e-28,  8.617629054975560e-02,
 -6.169168009154876e-04,  3.201306450430090e-06, -1.404041373561168e-08,  5.353475676476023e-11, -1.734821276491369e-13,  4.274943494572424e-16, -3.768335345162949e-19,
 -4.062977852939235e-21,  3.529309902741630e-23, -1.888394437412617e-25,  7.755393409538514e-28,  1.285236285924305e-01, -9.074740049045004e-04,  4.559060152035162e-06,
 -1.875845796497736e-08,  6.315941387156260e-11, -1.542114832174285e-13,  8.556058828481673e-17,  1.879945457501903e-18, -1.457860683707289e-20,  7.029023749386112e-23,
 -2.414473957405704e-25,  4.402642241578686e-28,  1.791434748204603e-01, -1.243496881323913e-03,  5.995354178413475e-06, -2.261987249976309e-08,  6.242883322534794e-11,
 -6.748894586214836e-14, -5.554049179170638e-16,  4.862733002531319e-18, -2.317679291795929e-20,  6.913987477664891e-23, -3.608831213165530e-26, -1.135628936992940e-27,
  2.379102751065131e-01, -1.617685021796214e-03,  7.407733803702374e-06, -2.481169697040647e-08,  4.746803893570874e-11,  9.101738194852039e-14, -1.379153152954797e-15,
  7.250363456838654e-18, -2.131478252683286e-20, -3.022579289395007e-24,  4.647119040303678e-25, -3.161178248958147e-27,  3.046611663451731e-01, -2.021195001586810e-03,
  8.680238666524076e-06, -2.454335562685492e-08,  1.608213290704424e-11,  3.053385183615985e-13, -2.128169603454654e-15,  7.210178955595261e-18, -1.769205995118061e-21,
 -1.444676867522437e-22,  9.857217570766740e-25, -3.244134416705082e-27,  3.791869590987376e-01, -2.443505961417994e-03,  9.686505708750378e-06, -2.113636943269096e-08,
 -3.128092270521530e-11,  5.351744972233390e-13, -2.434778756619576e-15,  3.090776701145115e-18,  3.512915071337205e-20, -2.864460416197495e-22,  9.400323553892174e-25,
  1.090770493548769e-27,  4.612207000578648e-01, -2.872286783236103e-03,  1.029453329267505e-05, -1.413579257257267e-08, -9.062846327287999e-11,  7.165310050431223e-13,
 -1.913534074634154e-15, -5.517347802887466e-18,  7.577149623991266e-20, -2.964757068564096e-22, -2.134534388051940e-25,  8.985391339072769e-27,  5.504232870060088e-01,
 -3.293283944620896e-03,  1.037373655306598e-05, -3.442030650068593e-09, -1.537892185541935e-10,  7.697651324946454e-13, -3.200317289160869e-16, -1.665209294750068e-17,
  9.266390684843331e-20, -4.566918074240253e-23, -2.273597980211401e-24,  1.341535186299115e-26,  6.463655181585986e-01, -3.690260862237706e-03,  9.805038688997622e-06,
  1.054417410345664e-08, -2.083655977473401e-10,  6.176477428953449e-13,  2.244142507056389e-15, -2.540754363351708e-17,  5.437214969436420e-20,  4.578770224227355e-22,
 -3.715014575908182e-24,  3.996509931604451e-27,  7.485058904983783e-01, -4.045036815335336e-03,  8.494781058421623e-06,  2.678118009404398e-08, -2.387099331099079e-10,
  2.145472069120727e-13,  5.144967941269589e-15, -2.483414649737548e-17, -5.144066628689222e-20,  9.369759800150928e-22, -2.146340977696962e-24, -2.100021929307153e-26,
  8.561634582291862e-01, -4.337697980546327e-03,  6.393078175232193e-06,  4.348442367969500e-08, -2.284362752069236e-10, -4.161774621726403e-13,  7.172124931816162e-15,
 -9.156602605598624e-18, -1.889159070168915e-19,  8.728729645831294e-22,  3.413749665260019e-24, -4.033323248680414e-26,  9.684851954758065e-01, -4.547085701087700e-03,
  3.516681047684775e-06,  5.812041046992138e-08, -1.648885735137762e-10, -1.147167440867356e-12,  6.809991157733285e-15,  2.081168197528526e-17, -2.621507701800952e-19,
 -1.300999495031352e-22,  9.380517196147815e-24, -1.654195034915671e-26,  1.084407700693230e+00, -4.651706582580733e-03, -2.489274694885908e-08,  6.758147080044578e-08,
 -4.552034101535840e-11, -1.736240883716826e-12,  2.964768346961439e-15,  5.253722650621686e-17, -1.566772047789793e-19, -1.692776505473238e-21,  7.685263224806488e-24,
  5.508596738436878e-26,  1.202613930908945e+00, -4.631248412367311e-03, -4.003706725239359e-06,  6.864559805038013e-08,  1.149811858904383e-10, -1.871935363790599e-12,
 -3.934262816644181e-15,  6.264842179899326e-17,  1.480669962143680e-19, -2.336975862379082e-21, -5.946379152929010e-24,  9.308245427364737e-26,  1.321487248038633e+00,
 -4.468906565911230e-03, -8.056106291784053e-06,  5.880946334990685e-08,  2.799457578301994e-10, -1.304220963342901e-12, -1.104363245164044e-14,  3.048861683522505e-17,
  4.598646399152350e-19, -5.440945808013318e-22, -1.960292691172332e-23, -5.464772918147707e-27,  1.439067754453460e+00, -4.154688232028727e-03, -1.168733736823738e-05,
  3.748012495033978e-08,  3.938004196268201e-10, -4.923150113082831e-14, -1.361497706480346e-14, -3.694689970671369e-17,  4.300607164882282e-19,  2.775237783200541e-21,
 -1.025379399459624e-23, -1.527070221840200e-25,  1.553020006643216e+00, -3.689698362378121e-03, -1.431726610855072e-05,  7.260591314255078e-09,  3.991772449491545e-10,
  1.437263830654094e-12, -8.008162465088200e-15, -9.029168466936975e-17, -7.346467829974747e-20,  3.531704653760315e-21,  1.931824449685214e-23, -7.267727196541878e-26,
  1.660626687949608e+00, -3.091029733065565e-03, -1.538709415298119e-05, -2.534334504153481e-08,  2.693211457107751e-10,  2.333266752001523e-12,  3.756940832043049e-15,
 -6.973448996459074e-17, -5.797885230559059e-19, -5.075519487031607e-22,  2.320082589796531e-23,  1.697640428375439e-25,  1.758828689420694e+00, -2.396210326303975e-03,
 -1.453366668659151e-05, -5.084606175127689e-08,  4.261026693485449e-11,  1.953628715590993e-12,  1.273554937394640e-14,  1.784213812108743e-17, -4.018257992388658e-19,
 -3.920542110233070e-21, -1.251513771820136e-23,  8.534072823077424e-26,  1.844335462332536e+00, -1.665282035850788e-03, -1.180059060507396e-05, -6.019927759052359e-08,
 -1.730534218557456e-10,  4.764034624698172e-13,  1.042617780945994e-14,  7.464140019873462e-17,  2.471499856162210e-19, -9.661220345706962e-22, -2.033532684022448e-23,
 -1.490875796265325e-25,  1.913825354265201e+00, -9.779152925056133e-04, -7.796069223766470e-06, -5.011675275922700e-08, -2.576747192850949e-10, -9.061687423986066e-13,
  3.494912553474396e-17,  3.464769449519023e-17,  3.579561216324573e-19,  2.320668932750891e-21,  9.236157310170106e-24, -4.130807348118218e-27,  1.964238228571098e+00,
 -4.233539656332930e-04, -3.661598291719046e-06, -2.715364434453060e-08, -1.797272160278448e-10, -1.065417781283306e-12, -5.515771479905369e-15, -2.289802497663803e-17,
 -5.040557330175262e-20,  3.184307426727418e-22,  5.697768527427850e-24,  5.316716327498905e-26,  1.993136181105459e+00, -8.323370922163974e-05, -7.533325564565953e-07,
 -6.021885853745543e-09, -4.476563638936569e-11, -3.163296924550595e-13, -2.147428095615221e-15, -1.407647918020285e-17, -8.925780415953264e-20, -5.470869821646468e-22,
 -3.230610070677615e-24, -1.825434773737141e-26,  1.036464501526691e-03, -7.508602132395136e-06,  4.077814762257206e-08, -1.967722509075494e-10,  8.894791161956149e-13,
 -3.857569874344735e-15,  1.624580577282133e-17, -6.697650811519984e-20,  2.713072264727594e-22, -1.085066008610287e-24,  4.282368478827441e-27, -1.678144087321105e-29,
  9.326105819259150e-03, -6.739962668177715e-05,  3.640588811751803e-07, -1.740014628362352e-09,  7.749014368531163e-12, -3.288990851852284e-14,  1.344620181466840e-16,
 -5.328990762754061e-19,  2.050403640075656e-21, -7.678299548112914e-24,  2.785042383225614e-26, -9.813407087713402e-29,  2.589415894876724e-02, -1.862287393109764e-04,
  9.949113418317744e-07, -4.662643474314676e-09,  2.012532980548206e-11, -8.152397439225801e-14,  3.115423356152246e-16, -1.121292918744335e-18,  3.751732462747478e-21,
 -1.138890988338356e-23,  2.904321723877455e-26, -4.841308091172064e-29,  5.071736584111144e-02, -3.620674096770795e-04,  1.901898574993503e-06, -8.642528392275412e-09,
  3.544990891916279e-11, -1.324252295846955e-13,  4.443381717741598e-16, -1.279764307151958e-18,  2.691605224187243e-21, -4.297766799474287e-25, -3.801953541993492e-26,
  2.815474943886356e-28,  8.375879739208432e-02, -5.919659878074517e-04,  3.037848119377365e-06, -1.321106115240803e-08,  5.016678706548700e-11, -1.633624475741156e-13,
  4.153037855424675e-16, -4.879131233093559e-19, -2.920474494314558e-21,  2.838836282923196e-23, -1.572101440451311e-25,  6.639628247895441e-28,  1.249652758376318e-01,
 -8.718849839014464e-04,  4.339920588698162e-06, -1.777245263138818e-08,  6.009971970195970e-11, -1.515768112169278e-13,  1.320351911988943e-16,  1.452092134852963e-18,
 -1.221718290567092e-20,  6.103554116224346e-23, -2.209707510201785e-25,  4.839622403685877e-28,  1.742637176834792e-01, -1.196602928198734e-03,  5.729862110595096e-06,
 -2.163248883274217e-08,  6.095636239417599e-11, -7.926630526422563e-14, -4.292599288664022e-16,  4.160531062927083e-18, -2.072469541126664e-20,  6.681508184421639e-23,
 -7.740222644793262e-26, -7.579306973372397e-28,  2.315561914670363e-01, -1.559601074515300e-03,  7.114604802982514e-06, -2.403937634530971e-08,  4.897343533093895e-11,
  6.027677531345420e-14, -1.185684306207588e-15,  6.569874828268381e-18, -2.112102032918030e-20,  1.294862384668890e-23,  3.378454837967201e-25, -2.612660517375991e-27,
  2.967134116276029e-01, -1.952926352559752e-03,  8.387455004939685e-06, -2.423989400368807e-08,  2.169444276845044e-11,  2.566741301263357e-13, -1.927806422366922e-15,
  7.077680954534238e-18, -6.294797456981412e-21, -1.078990329559435e-22,  8.429133047281086e-25, -3.217483523997935e-27,  3.695663020151489e-01, -2.367036176898998e-03,
  9.430209323278737e-06, -2.155437963782444e-08, -2.115415276972071e-11,  4.778960680255224e-13, -2.333997234069918e-15,  4.057242914272983e-18,  2.550177218734682e-20,
 -2.482867120180177e-22,  9.587097211253586e-25, -1.765347826448499e-28,  4.498951577512501e-01, -2.790632613205721e-03,  1.011666814509803e-05, -1.547374599505604e-08,
 -7.676823068137867e-11,  6.690164456466018e-13, -2.035686175380219e-15, -3.264344420021226e-18,  6.503389990255245e-20, -2.977708039167420e-22,  1.325392770739972e-25,
  6.768630912340322e-27,  5.374158119012483e-01, -3.210499933765972e-03,  1.031817469476058e-05, -5.780065572083339e-09, -1.385067674032097e-10,  7.568222222146498e-13,
 -7.451425580627947e-16, -1.372956015762615e-17,  8.952361999472251e-20, -1.249790421391823e-22, -1.697484910472608e-24,  1.265247548382239e-26,  6.317620779337833e-01,
 -3.611370151160251e-03,  9.911982155643222e-06,  7.311836382676319e-09, -1.955305959606913e-10,  6.631810534574946e-13,  1.559365926394133e-15, -2.343215893085093e-17,
  6.823453543463884e-20,  3.140079615192187e-22, -3.450961841948285e-24,  7.769913146009958e-27,  7.324636039224586e-01, -3.975857630811316e-03,  8.793401746289632e-06,
  2.300261838098522e-08, -2.332413518680325e-10,  3.295266876616094e-13,  4.431509376661762e-15, -2.595879564919046e-17, -1.945764290600120e-20,  8.348304822206874e-22,
 -2.907062269212743e-24, -1.361423990692113e-26,  8.389181718964103e-01, -4.284528809783575e-03,  6.892716727960950e-06,  3.977210825279322e-08, -2.350626857350646e-10,
 -2.477763103301155e-13,  6.835997607652668e-15, -1.467623253700051e-17, -1.554587583949410e-19,  9.743605715013188e-22,  1.676885749406284e-24, -3.811443481832990e-26,
  9.503574711770716e-01, -4.516209007781665e-03,  4.197568805386513e-06,  5.530770777405038e-08, -1.861552316942825e-10, -9.776846435369973e-13,  7.275077440818597e-15,
  1.241866594857246e-17, -2.602931924911325e-19,  2.265096316783489e-22,  8.356317404522119e-24, -2.938531683534003e-26,  1.065805591346115e+00, -4.648676807020003e-03,
  7.805828946486390e-07,  6.657970212292810e-08, -7.941761869949124e-11, -1.648054555853107e-12,  4.356906885471884e-15,  4.661226793035315e-17, -2.115486068151999e-19,
 -1.342318226631149e-21,  9.697287102028331e-24,  3.585375855384490e-26,  1.184030135380407e+00, -4.659954678256441e-03, -3.170171799858518e-06,  7.018126212325970e-08,
  7.674277402900508e-11, -1.944851568021545e-12, -2.126700692051550e-15,  6.600275248207914e-17,  6.066804811973257e-20, -2.490147534024896e-21, -1.661868415404801e-24,
  9.998125263157612e-26,  1.303487298363089e+00, -4.530458491174543e-03, -7.324424508497438e-06,  6.306583910801556e-08,  2.512885124021811e-10, -1.557384604149170e-12,
 -9.987954610723754e-15,  4.473979897124278e-17,  4.262144382058110e-19, -1.320994490730342e-21, -1.894169150987793e-23,  3.569222167953462e-26,  1.422265003590363e+00,
 -4.246280963069449e-03, -1.119986192219562e-05,  4.375497808953234e-08,  3.894728169032044e-10, -3.867608485647630e-13, -1.444244369202209e-14, -2.167866064852318e-17,
  5.209780516817176e-19,  2.232151532767980e-21, -1.683141713464184e-23, -1.431930734445769e-25,  1.538032844814563e+00, -3.803777294138518e-03, -1.419090558640050e-05,
  1.386608400183297e-08,  4.257949255058472e-10,  1.214586913297270e-12, -1.054910640245118e-14, -9.046647505252590e-17,  6.665291627977460e-20,  4.222614474097679e-21,
  1.478029570816474e-23, -1.339117750554162e-25,  1.648014557547754e+00, -3.215266136555185e-03, -1.566380554318963e-05, -2.065668672055391e-08,  3.167191064780183e-10,
  2.397895908663358e-12,  1.543244136664439e-15, -8.838645066869076e-17, -5.795726364331254e-19,  5.676684218014815e-22,  3.046211194304354e-23,  1.561890275805902e-25,
  1.749007465562023e+00, -2.514905602625725e-03, -1.513838525459807e-05, -4.983496771595046e-08,  8.477176440348872e-11,  2.263690192447055e-12,  1.303325259759130e-14,
  2.637349421566010e-18, -5.508964071803930e-19, -4.326635479919971e-21, -7.283058154904110e-24,  1.548166522425371e-25,  1.837480884212199e+00, -1.762622580491080e-03,
 -1.253923461893459e-05, -6.287758585487398e-08, -1.608493223562458e-10,  7.525668603024965e-13,  1.262043615606208e-14,  8.182352521725244e-17,  1.960919455582591e-19,
 -1.916669849270912e-21, -2.732098018754815e-23, -1.666516576119027e-25,  1.909785046353820e+00, -1.042760913296551e-03, -8.422803994151008e-06, -5.438413554615632e-08,
 -2.757040990786052e-10, -8.923142414444195e-13,  1.178512545300572e-15,  4.750950520232894e-17,  4.480386269530465e-19,  2.678833566549813e-21,  8.456910803533193e-24,
 -3.375459328964020e-26,  1.962484092248380e+00, -4.540006799580351e-04, -4.005422914134827e-06, -3.020716032834359e-08, -2.024121804497281e-10, -1.205660015289269e-12,
 -6.177432750368188e-15, -2.427868245732024e-17, -3.422332820348878e-20,  5.989871583625873e-22,  8.486125609907032e-24,  7.461904293260412e-26,  1.992790717436657e+00,
 -8.956209615124608e-05, -8.301109167909764e-07, -6.791689089974437e-09, -5.164128708796307e-11, -3.729395504267411e-13, -2.584705177191293e-15, -1.727444858520517e-17,
 -1.114857668690900e-19, -6.938457757672019e-22, -4.146084249785582e-24, -2.358030986068471e-26,  1.007067922667012e-03, -7.191585810105722e-06,  3.849979153231283e-08,
 -1.831372321146918e-10,  8.160797305919630e-13, -3.489228542036835e-15,  1.448636440369546e-17, -5.888800630419559e-20,  2.351582153471750e-22, -9.276674474381755e-25,
  3.608090769169512e-27, -1.396063551802519e-29,  9.062202924634130e-03, -6.456861748078389e-05,  3.439014580945031e-07, -1.621122388362411e-09,  7.122315728852279e-12,
 -2.983470784118002e-14,  1.204193551898890e-16, -4.715020301014703e-19,  1.793037526627065e-21, -6.646175797425723e-24,  2.386174878961405e-26, -8.357600363394990e-29,
  2.516481578010251e-02, -1.784879027024587e-04,  9.408391333431004e-07, -4.353286217533760e-09,  1.856714591946679e-11, -7.441051742240976e-14,  2.817668473708238e-16,
 -1.007577502663368e-18,  3.362120912627150e-21, -1.027068386776081e-23,  2.685061618635209e-26, -5.082757207847988e-29,  4.929888309949914e-02, -3.472576176464271e-04,
  1.801505868907048e-06, -8.095950477859005e-09,  3.290519318694901e-11, -1.221814056371134e-13,  4.097063261483250e-16, -1.194150978957101e-18,  2.651562214679218e-21,
 -1.722632603420405e-24, -2.708799249207614e-26,  2.176913597047468e-28,  8.143855391118800e-02, -5.682839332379248e-04,  2.884025319011135e-06, -1.243399381808465e-08,
  4.699805371136331e-11, -1.535687536661137e-13,  4.004791524318240e-16, -5.661749616590302e-19, -2.004921887802138e-21,  2.265389586366076e-23, -1.302435058102052e-25,
  5.636939858772511e-28,  1.215458467010666e-01, -8.380025790070675e-04,  4.132321283148201e-06, -1.683492417753557e-08,  5.710294535051213e-11, -1.479622706696416e-13,
  1.675388781435180e-16,  1.094634855573763e-18, -1.017382050056603e-20,  5.262766848210089e-23, -1.993486477014571e-25,  4.943208542689953e-28,  1.695673629393483e-01,
 -1.151785934577582e-03,  5.476070031476370e-06, -2.067039110999357e-08,  5.927707203595161e-11, -8.824334595639696e-14, -3.216927298799130e-16,  3.535169100629439e-18,
 -1.838227728022954e-20,  6.314331431875988e-23, -1.040726154734594e-25, -4.675082220768635e-28,  2.254298127675328e-01, -1.503824723501064e-03,  6.830868678573433e-06,
 -2.324764205075196e-08,  4.990891452013313e-11,  3.395197486917732e-14, -1.011102612737253e-15,  5.903852984375782e-18, -2.043794784861844e-20,  2.431384349936875e-23,
  2.340391245377239e-25, -2.115286623163561e-27,  2.890340720903718e-01, -1.886983952398974e-03,  8.098820388295769e-06, -2.385416199187400e-08,  2.638117196757189e-11,
  2.127587514857926e-13, -1.732990572941493e-15,  6.820330345431160e-18, -9.606011895300132e-21, -7.697133445999749e-23,  7.047423869499917e-25, -3.043914253343793e-27,
  3.602473953337149e-01, -2.292634159638398e-03,  9.169831630864716e-06, -2.181938606283071e-08, -1.214674642698839e-11,  4.233275873284798e-13, -2.210260775002829e-15,
  4.737654716164821e-18,  1.724916989653801e-20, -2.103830336336954e-22,  9.299345781499402e-25, -1.075381356897481e-27,  4.388932898238685e-01, -2.710461889290322e-03,
  9.924046320124464e-06, -1.659767656152226e-08, -6.388269648458437e-11,  6.192884655713438e-13, -2.099553679571020e-15, -1.353206597304557e-18,  5.447578644818645e-20,
 -2.871208076660317e-22,  3.853649364239618e-25,  4.765705387278870e-27,  5.247384119976747e-01, -3.128268509764609e-03,  1.023601327017109e-05, -7.876178899869912e-09,
 -1.235786420599761e-10,  7.346447867758926e-13, -1.090227272386852e-15, -1.094882894952545e-17,  8.393310927373425e-20, -1.821073449774316e-22, -1.168765829226762e-24,
  1.130608202278393e-26,  6.174756710037768e-01, -3.531775489933720e-03,  9.981396942722144e-06,  4.291270718492839e-09, -1.819445551273824e-10,  6.929888765305119e-13,
  9.353481385179708e-16, -2.109370816716189e-17,  7.714397889917329e-20,  1.836070210094888e-22, -3.051682913347024e-24,  1.016185847950040e-26,  7.167025271676356e-01,
 -3.904469195612954e-03,  9.047277525864009e-06,  1.932901166332450e-08, -2.256463792049088e-10,  4.271173392655361e-13,  3.700298003284624e-15, -2.612406672338473e-17,
  8.377817096300911e-21,  7.086455509597737e-22, -3.352088185153800e-24, -6.743362286551734e-27,  8.218932721165964e-01, -4.227542271252971e-03,  7.347280946862563e-06,
  3.598022579998756e-08, -2.384136244599508e-10, -8.917292670253052e-14,  6.360764459413627e-15, -1.907994363804947e-17, -1.195674071770383e-19,  1.009155420096984e-21,
  9.805422204175684e-26, -3.329675380555986e-26,  9.323639262680068e-01, -4.480025745516058e-03,  4.842776137020489e-06,  5.218238263564309e-08, -2.039395646426059e-10,
 -7.998415583223828e-13,  7.507859005920467e-15,  4.281556592216327e-18, -2.464606937941189e-19,  5.320216547534746e-22,  6.855782493569803e-24, -3.809990378754552e-26,
  1.047228399751758e+00, -4.639260385739128e-03,  1.570847094450700e-06,  6.505144234267366e-08, -1.112314684628391e-10, -1.528633933045283e-12,  5.560561793641779e-15,
  3.914711874180616e-17, -2.525657831558723e-19, -9.290354261331015e-22,  1.081291704281848e-23,  1.475827021619552e-26,  1.165344953247369e+00, -4.681929449098760e-03,
 -2.321920209247516e-06,  7.109582826854533e-08,  3.748581002661616e-11, -1.973579161936036e-12, -2.649626348247989e-16,  6.650557866636008e-17, -2.911470641557334e-20,
 -2.468905916060656e-21,  2.698806477319769e-24,  9.654066561796893e-26,  1.285253159879935e+00, -4.585960826107428e-03, -6.544579575779831e-06,  6.682470251428627e-08,
  2.178529409494527e-10, -1.780570831197496e-12, -8.552466614488719e-15,  5.747532881489467e-17,  3.655081557774048e-19, -2.035325724314451e-21, -1.648670166636117e-23,
  7.517151084912330e-26,  1.405104155952946e+00, -4.333674394009198e-03, -1.063772954207803e-05,  4.990565689245222e-08,  3.782322794811556e-10, -7.387103639443702e-13,
 -1.480496350085651e-14, -3.863512735235577e-18,  5.877598890704986e-19,  1.439900242828057e-21, -2.257343370990908e-23, -1.146961780696233e-25,  1.522591900792529e+00,
 -3.916521398029646e-03, -1.398288153636611e-05,  2.085852561312702e-08,  4.473515558068134e-10,  9.313968762898275e-13, -1.302871292659482e-14, -8.579984818912528e-17,
  2.277263251875708e-19,  4.678216671823133e-21,  7.571764617581911e-24, -1.925190374164833e-25,  1.634901428641366e+00, -3.341478300719714e-03, -1.587969400882627e-05,
 -1.520438409790733e-08,  3.648362235145236e-10,  2.403167799479382e-12, -1.186400993465148e-15, -1.063577452197778e-16, -5.356348200273188e-19,  1.913601290130178e-21,
  3.653307147728441e-23,  1.147344373125982e-25,  1.738701878757755e+00, -2.638378153993517e-03, -1.572671771154986e-05, -4.809944628496653e-08,  1.331686183171875e-10,
  2.575236786587976e-12,  1.283656409279909e-14, -1.752500359353881e-17, -7.100474224563193e-19, -4.458527082147670e-21,  1.277888619864642e-24,  2.355986344350713e-25,
  1.830224927321269e+00, -1.865997077841263e-03, -1.330865502412276e-05, -6.531351644263068e-08, -1.425801393166978e-10,  1.083587445989248e-12,  1.498738345450802e-14,
  8.676905648955035e-17,  1.056325174363052e-19, -3.158201911086620e-21, -3.477037809830557e-23, -1.684903750283175e-25,  1.905474996999315e+00, -1.112830119236306e-03,
 -9.102463855059581e-06, -5.893615202815176e-08, -2.931510300281466e-10, -8.463552810002898e-13,  2.724442992410661e-15,  6.345141375375429e-17,  5.500968510812748e-19,
  2.974957791257935e-21,  6.005456395660753e-24, -8.105814792559125e-26,  1.960601626807983e+00, -4.875509491739793e-04, -4.388162872775115e-06, -3.364694927030221e-08,
 -2.280635746154906e-10, -1.362177355828027e-12, -6.868819681986942e-15, -2.495641938425991e-17, -5.688212369908358e-21,  1.011925105230835e-21,  1.236818637861934e-23,
  1.031191886266326e-25,  1.992418650502772e+00, -9.654362060469920e-05, -9.168262748001042e-07, -7.681162479794742e-09, -5.976177151034949e-11, -4.412040986545856e-13,
 -3.122330951491089e-15, -2.127579642474167e-17, -1.397164529923777e-19, -8.823311297160695e-22, -5.327941871360572e-24, -3.041774260312127e-26,  9.789039641949456e-04,
 -6.892161274923401e-06,  3.637824520482853e-08, -1.706198884737706e-10,  7.496425964340785e-13, -3.160521725371409e-15,  1.293802241577304e-17, -5.187058353335628e-20,
  2.042185328926724e-22, -7.949155427135995e-25,  3.046322843306522e-27, -1.164999077383101e-29,  8.809310349177972e-03, -6.189332677117511e-05,  3.251125374983473e-07,
 -1.511786237935666e-09,  6.553485444232116e-12, -2.709679904125537e-14,  1.079858828726125e-16, -4.177757781919870e-19,  1.570103997273024e-21, -5.761485383694792e-24,
  2.046216477452916e-26, -7.129711694647265e-29,  2.446559372928898e-02, -1.711652078740720e-04,  8.903341982906541e-07, -4.067759519356006e-09,  1.714433583679888e-11,
 -6.797483603884818e-14,  2.550067749665644e-16, -9.057026504189426e-19,  3.011167573981895e-21, -9.241602284780195e-24,  2.460129044703517e-26, -5.113812428500015e-29,
  4.793807382562668e-02, -3.332254084060082e-04,  1.707434421941746e-06, -7.588493351341438e-09,  3.055723554151003e-11, -1.127401648217401e-13,  3.774472885439853e-16,
 -1.110484574190635e-18,  2.572206558494256e-21, -2.630442874342112e-24, -1.867395738670959e-26,  1.666522737029283e-28,  7.921063534355183e-02, -5.457960089773974e-04,
  2.739229527575967e-06, -1.170607924558554e-08,  4.402147515242581e-11, -1.441540198104589e-13,  3.838437557385078e-16, -6.182424139518181e-19, -1.277426536681291e-21,
  1.791324110908277e-23, -1.074361859900803e-25,  4.748579425599169e-28,  1.182586957041938e-01, -8.057367765354054e-04,  3.935687155285196e-06, -1.594472276359413e-08,
  5.418620900308328e-11, -1.436086321811106e-13,  1.939048772085938e-16,  7.978895976681661e-19, -8.417532182957175e-21,  4.508641416813413e-23, -1.778057996422561e-25,
  4.818484914309788e-28,  1.650462879541381e-01, -1.108953566428402e-03,  5.233656426769604e-06, -1.973646389454905e-08,  5.744268190263911e-11, -9.484055421356841e-14,
 -2.306074640019950e-16,  2.982467319741399e-18, -1.618837154671924e-20,  5.863791089944603e-23, -1.196126206637977e-25, -2.496858753205634e-28,  2.195220601741961e-01,
 -1.450280042351545e-03,  6.556706517558416e-06, -2.244493069423132e-08,  5.035830103787337e-11,  1.159617216089070e-14, -8.548074765042104e-16,  5.265476211794350e-18,
 -1.941535201378585e-20,  3.194703315655194e-23,  1.508001150330894e-25, -1.678751361017706e-27,  2.816139150293113e-01, -1.823330904358326e-03,  7.815236313364221e-06,
 -2.340021738617703e-08,  3.023570807462340e-11,  1.734215011232092e-13, -1.546704093027076e-15,  6.473785362564631e-18, -1.190119084550389e-20, -5.138762485086478e-23,
  5.763663103410303e-25, -2.780553087542972e-27,  3.512219138886024e-01, -2.220325516076746e-03,  8.907103096266568e-06, -2.194883763422858e-08, -4.199618683135312e-12,
  3.719288096827160e-13, -2.070966819827796e-15,  5.175522059681831e-18,  1.033172756800031e-20, -1.743258953069775e-22,  8.686340877173017e-25, -1.665148412319470e-27,
  4.282089422720413e-01, -2.631882659816660e-03,  9.719141297463260e-06, -1.752346082852508e-08, -5.200291119579376e-11,  5.686320494266150e-13, -2.114568781748832e-15,
  2.279901089320031e-19,  4.446258492486427e-20, -2.680409420960604e-22,  5.560838193702008e-25,  3.043719141968401e-27,  5.123884695871325e-01, -3.046790966652991e-03,
  1.013011556234248e-05, -9.737414516365172e-09, -1.091706910762142e-10,  7.050976712028583e-13, -1.360236846213490e-15, -8.375941326164549e-18,  7.665130876019865e-20,
 -2.193860305248992e-22, -7.074120647116342e-25,  9.628291562780817e-27,  6.035085290625315e-01, -3.451766762025431e-03,  1.001588630116705e-05,  1.492060027371377e-09,
 -1.679066699860162e-10,  7.086339859229529e-13,  3.801157298083518e-16, -1.854200050701853e-17,  8.166840390904370e-20,  7.090815808480071e-23, -2.574765937763989e-24,
  1.133172517136286e-26,  7.012307900762056e-01, -3.831223879325558e-03,  9.257860463336028e-06,  1.579158569553608e-08, -2.162749570977567e-10,  5.071997339734152e-13,
  2.976225270581870e-15, -2.547414491310280e-17,  3.142073701246005e-20,  5.704453707574893e-22, -3.514947405067396e-24, -8.471756501852984e-28,  8.051033023611075e-01,
 -4.167101903931871e-03,  7.756123448156713e-06,  3.215944558718694e-08, -2.387158649876137e-10,  5.667573013107925e-14,  5.778410711288818e-15, -2.232682871613405e-17,
 -8.350388243317729e-20,  9.855977578369647e-22, -1.228542616774949e-24, -2.680411672135186e-26,  9.145251937298340e-01, -4.438835405629468e-03,  5.448890421515470e-06,
  4.880119017140810e-08, -2.181293232124539e-10, -6.190860347253210e-13,  7.520565346103947e-15, -3.249194657321809e-18, -2.227907803262450e-19,  7.711377098474733e-22,
  5.068595395617121e-24, -4.241920675448129e-26,  1.028701389957182e+00, -4.623603669342765e-03,  2.339801748944388e-06,  6.303476427394618e-08, -1.403856667657426e-10,
 -1.382968190355330e-12,  6.539104385494685e-15,  3.061426490384676e-17, -2.781254762709850e-19, -4.896853725957442e-22,  1.100508782895355e-23, -5.733539870345910e-27,
  1.146585498451065e+00, -4.697085013828615e-03, -1.466473590605481e-06,  7.138011324797695e-08, -1.899418822130257e-12, -1.957778847775250e-12,  1.570984264275726e-15,
  6.418078287755187e-17, -1.150564377962578e-19, -2.279199883735091e-21,  6.691033862408731e-24,  8.346653155020896e-26,  1.266809761979101e+00, -4.635053397107260e-03,
 -5.722979015334926e-06,  7.001487585327212e-08,  1.803258136793801e-10, -1.965268723683203e-12, -6.791291807234387e-15,  6.787905925110245e-17,  2.812574684591218e-19,
 -2.618404626356392e-21, -1.243009446799483e-23,  1.076597290746276e-25,  1.387603191136946e+00, -4.416279127927736e-03, -1.000310145278252e-05,  5.581987604055786e-08,
  3.599072823821941e-10, -1.093160853437367e-12, -1.464332880001991e-14,  1.559076704202445e-17,  6.222379471143355e-19,  4.484285814396989e-22, -2.666412666990843e-23,
 -6.863475788343916e-26,  1.506703847849384e+00, -4.027260260112062e-03, -1.368907598277368e-05,  2.814738457506927e-08,  4.626629305223693e-10,  5.908597543213853e-13,
 -1.530345247875845e-14, -7.577697546178513e-17,  3.994155879809305e-19,  4.796884817856576e-21, -1.973597654614145e-24, -2.383780134170143e-25,  1.621280429695258e+00,
 -3.469142790175640e-03, -1.602554410963397e-05, -8.985091196649530e-09,  4.123639215251608e-10,  2.337095079698349e-12, -4.391963239099643e-15, -1.221050186211044e-16,
 -4.393952539366355e-19,  3.456704731509519e-21,  4.008942106738640e-23,  4.161452627648688e-26,  1.727893139533753e+00, -2.766460425154618e-03, -1.628937357287488e-05,
 -4.554018654904940e-08,  1.877004869906166e-10,  2.874710965780932e-12,  1.200382824765773e-14, -4.278301108631890e-17, -8.669110237643169e-19, -4.175399969259647e-21,
  1.348421796737910e-23,  3.185271868458889e-25,  1.822542984287977e+00, -1.975638370471365e-03, -1.410532416993874e-05, -6.740104966129985e-08, -1.171131339816879e-10,
  1.472706013118494e-12,  1.744515168759602e-14,  8.804750474178346e-17, -3.484189607344083e-20, -4.692203114605973e-21, -4.174492098553314e-23, -1.428932974140508e-25,
  1.900873443719953e+00, -1.188559762684081e-03, -9.838385525274788e-06, -6.375779155323525e-08, -3.092696559582172e-10, -7.575594001026498e-13,  4.763911224829057e-15,
  8.280637698032881e-17,  6.604906378183905e-19,  3.124914823137100e-21,  9.774999325266589e-25, -1.518442970506560e-25,  1.958578564856220e+00, -5.243354688951083e-04,
 -4.814749067176361e-06, -3.752310927070353e-08, -2.570121899046219e-10, -1.535397648587048e-12, -7.563936130283677e-15, -2.445061712979927e-17,  4.083150592934023e-20,
  1.607608789000262e-21,  1.768459794931841e-23,  1.400118165266699e-25,  1.992017199164322e+00, -1.042638799304466e-04, -1.015042314210861e-06, -8.712227025122870e-09,
 -6.938620755750703e-11, -5.238248116132106e-13, -3.785730503461663e-15, -2.629883689872977e-17, -1.756607561513880e-19, -1.124629269942325e-21, -6.850273795690200e-24,
 -3.911569203699997e-26,  9.519046855712250e-04, -6.609125861926184e-06,  3.440073962027080e-08, -1.591149000785404e-10,  6.894233520359376e-13, -2.866724874671329e-15,
  1.157299593451332e-17, -4.577091130678472e-20,  1.776767661568624e-22, -6.827295846132511e-25,  2.576763916264362e-27, -9.755617966577850e-30,  8.566826410304420e-03,
 -5.936324995418582e-05,  3.075827988642281e-07, -1.411129022564135e-09,  6.036547108756281e-12, -2.464001916841931e-14,  9.696147816202620e-17, -3.706990416154159e-19,
  1.376696368987250e-21, -5.002568040305020e-24,  1.755891675969049e-26, -6.096594551413151e-29,  2.379487554511543e-02, -1.642332246886866e-04,  8.431231309595232e-07,
 -3.804002021164717e-09,  1.584404160097348e-11, -6.214840187951859e-14,  2.309474168967755e-16, -8.144829182407891e-19,  2.695642458181267e-21, -8.302327453117303e-24,
  2.236990435203789e-26, -5.012435762221151e-29,  4.663192592927109e-02, -3.199220373623988e-04,  1.619233153680559e-06, -7.117134223428624e-09,  2.839054869573604e-11,
 -1.040453439271354e-13,  3.474908844948159e-16, -1.029819691387221e-18,  2.465715931440400e-21, -3.243421364195883e-24, -1.227192842602954e-26,  1.258446880136743e-28,
  7.707040593748297e-02, -5.244323066110546e-04,  2.602889101680827e-06, -1.102430571548320e-08,  4.122909363500105e-11, -1.351535511000444e-13,  3.660519438717027e-16,
 -6.495920092067597e-19, -7.050857460729062e-22,  1.400996088546183e-23, -8.829558847111161e-26,  3.968874797513585e-28,  1.150975283154320e-01, -7.750021039437336e-04,
  3.749458415020735e-06, -1.510046088170281e-08,  5.136223202553110e-11, -1.387158103216793e-13,  2.127091909439199e-16,  5.531667367206371e-19, -6.917396103378829e-21,
  3.839097909191725e-23, -1.571672878462787e-25,  4.542918906915817e-28,  1.606927340856321e-01, -1.068016186846283e-03,  5.002269863744525e-06, -1.883282882032408e-08,
  5.549699488991442e-11, -9.942964443842218e-14, -1.540401137219410e-16,  2.497273070300146e-18, -1.416570828808529e-20,  5.368421619961258e-23, -1.269193583033037e-25,
 -9.123166379161839e-29,  2.138241608463393e-01, -1.398890038798480e-03,  6.292205922849563e-06, -2.163840828078999e-08,  5.039665460263002e-11, -7.219112321478480e-15,
 -7.158918255257582e-16,  4.663613067078878e-18, -1.817343505678291e-20,  3.661605541692812e-23,  8.536484826645268e-26, -1.306118961702291e-27,  2.744438687182818e-01,
 -1.761923749373587e-03,  7.537444424105485e-06, -2.289065468312347e-08,  3.334738255739307e-11,  1.384312039616450e-13, -1.371017583172943e-15,  6.067563501878333e-18,
 -1.336484112199148e-20, -3.069093451927562e-23,  4.607238771915449e-25, -2.471365185687926e-27,  3.424814564730671e-01, -2.150122829775683e-03,  8.643550742599122e-06,
 -2.195917359316974e-08,  2.753832891286453e-12,  3.239963782331966e-13, -1.922320096674498e-15,  5.412280871261156e-18,  4.662663107797161e-21, -1.411625407036446e-22,
  7.870463036710934e-25, -2.007601273049377e-27,  4.178355672583918e-01, -2.554983953920349e-03,  9.504233865907862e-06, -1.826727872704764e-08, -4.113645597369277e-11,
  5.181110234073199e-13, -2.089684466027743e-15,  1.500929449292853e-18,  3.524172842272037e-20, -2.435582941836157e-22,  6.577341124764473e-25,  1.627431315500846e-27,
  5.003626070025097e-01, -2.966246072630434e-03,  1.000324561454703e-05, -1.137317854259014e-08, -9.541279028485088e-11,  6.699073687696515e-13, -1.561645025376927e-15,
 -6.054129871627740e-18,  6.834137528108744e-20, -2.397375046956019e-22, -3.233250846204314e-25,  7.823372818422012e-27,  5.898617665387657e-01, -3.371612643859725e-03,
  1.001814081574401e-05, -1.080740767148439e-09, -1.536832820311871e-10,  7.118236365586721e-13, -1.022251093314731e-16, -1.590666229339729e-17,  8.248858693456818e-20,
 -2.199623038518941e-23, -2.069245129899720e-24,  1.150156910821229e-26,  6.860551384839794e-01, -3.756461031330531e-03,  9.426943761999435e-06,  1.241597910089020e-08,
 -2.054737795356576e-10,  5.702014501668274e-13,  2.279919511259919e-15, -2.416722350029435e-17,  4.943054820784011e-20,  4.305689622392659e-22, -3.444896829197934e-24,
  3.816521564194119e-27,  7.885613453454571e-01, -4.103574059647774e-03,  8.119181293218793e-06,  2.835637734403389e-08, -2.362475918715520e-10,  1.875862137434568e-13,
  5.121103459087824e-15, -2.444291426312761e-17, -4.917199549180589e-20,  9.149781333927261e-22, -2.249484406360479e-24, -1.954623224249322e-26,  8.968606583222085e-01,
 -4.392962033812828e-03,  6.013187339963488e-06,  4.522182896697353e-08, -2.287175272586086e-10, -4.404628481074618e-13,  7.334208719628287e-15, -9.898871346451688e-18,
 -1.918338456396960e-19,  9.362131727356556e-22,  3.183780717148322e-24, -4.262231047392787e-26,  1.010249146141776e+00, -4.601899816906946e-03,  3.081857510779772e-06,
  6.057611886250460e-08, -1.664114680935635e-10, -1.216762263626184e-12,  7.269654631089727e-15,  2.151632360397878e-17, -2.879416853947519e-19, -6.001511507368689e-23,
  1.034885019096610e-23, -2.349981055713634e-26,  1.127779115074566e+00, -4.705394033274220e-03, -6.113784246666979e-07,  7.103912905916322e-08, -4.053486215452379e-11,
 -1.899000323085389e-12,  3.304574155164714e-15,  5.924466855220428e-17, -1.914553940779972e-19, -1.943736952634461e-21,  9.931023273857725e-24,  6.276939223889058e-26,
  1.248183367095224e+00, -4.677430508033370e-03, -4.866813183538171e-06,  7.257745339071689e-08,  1.395493536833142e-10, -2.104525627766338e-12, -4.779473882983438e-15,
  7.528484782391735e-17,  1.792535566031429e-19, -3.013722626845010e-21, -7.182213096333860e-24,  1.287027829102726e-25,  1.369782403171092e+00, -4.493528475480288e-03,
 -9.299494677507685e-06,  6.138458094351788e-08,  3.345766907204872e-10, -1.437104805764217e-12, -1.392709483309011e-14,  3.554990317180533e-17,  6.186055687872395e-19,
 -6.618893263166866e-22, -2.842119847482688e-23, -9.636747966722100e-27,  1.490378099473536e+00, -4.135295184210482e-03, -1.330656830500600e-05,  3.562387994368842e-08,
  4.706435725695967e-10,  1.997186181164593e-13, -1.722053910539604e-14, -6.026897994798795e-17,  5.680721328457151e-19,  4.499476546642342e-21, -1.306319038035551e-23,
 -2.610823617845239e-25,  1.607146929939115e+00, -3.597662755149505e-03, -1.609225757800212e-05, -2.020249802940876e-09,  4.577671347711661e-10,  2.189197929644159e-12,
 -7.986825994832349e-15, -1.338631946320826e-16, -2.859034385736784e-19,  5.068463693119380e-21,  3.974370579801602e-23, -6.189263455591820e-26,  1.716563284765058e+00,
 -2.898905819159618e-03, -1.681588980373896e-05, -4.206183743930266e-08,  2.479618188152581e-10,  3.145158536954500e-12,  1.039583816561932e-14, -7.279632930041882e-17,
 -1.003934807601745e-18, -3.333558179861815e-21,  2.911977888140630e-23,  3.884778641645866e-25,  1.814409581310687e+00, -2.091745678533624e-03, -1.492433167220703e-05,
 -6.901564453384247e-08, -8.327384192771017e-11,  1.920679735267730e-12,  1.986711395850436e-14,  8.389619465770928e-17, -2.351907692320279e-19, -6.471487416983478e-21,
 -4.673126625781635e-23, -7.564709512661438e-26,  1.895956824686783e+00, -1.270412449264782e-03, -1.063364651702568e-05, -6.882027079565000e-08, -3.230769161973121e-10,
 -6.129103893217680e-13,  7.395272027261518e-15,  1.057349264105741e-16,  7.718383289451963e-19,  3.003282771865477e-21, -7.785498158879844e-24, -2.516356183319710e-25,
  1.956401233387526e+00, -5.647268770215710e-04, -5.290745489188892e-06, -4.189106068398654e-08, -2.895899327862946e-10, -1.724941207494815e-12, -8.220513653074851e-15,
 -2.206869271026951e-17,  1.130391789067947e-19,  2.451091686785767e-21,  2.482508919480425e-23,  1.860726952913365e-25,  1.991583213102296e+00, -1.128221079673435e-04,
 -1.126612542418712e-06, -9.911417199528170e-09, -8.083437353301728e-11, -6.241933292144245e-13, -4.607277860197631e-15, -3.262419679844501e-17, -2.215217634557741e-19,
 -1.436101168883180e-21, -8.802725442470861e-24, -5.002222347400471e-26,  9.260067603396132e-04, -6.341374198508782e-06,  3.255570114365302e-08, -1.485281357033715e-10,
  6.347657917167474e-13, -2.603731538612475e-15,  1.036745178263499e-17, -4.045942487487044e-20,  1.548547294541133e-22, -5.877645099899314e-25,  2.182785244086248e-27,
 -8.203861936600259e-30,  8.334189759133116e-03, -5.696871646407721e-05,  2.912128968369531e-07, -1.318363675700498e-09,  5.566201773520066e-12, -2.243268212238371e-14,
  8.717252792113816e-17, -3.293957676642630e-19,  1.208624286531391e-21, -4.351200977135488e-24,  1.507242132550949e-26, -5.231488294090768e-29,  2.315114947428757e-02,
 -1.576666147054908e-04,  7.989560715041201e-07, -3.560147526404913e-09,  1.465470292256625e-11, -5.686985279205476e-14,  2.093058171999436e-16, -7.328360907359266e-19,
  2.412337741788248e-21, -7.451165425280523e-24,  2.020085159786767e-26, -4.839488426458881e-29,  4.537761530519308e-02, -3.073022275994405e-04,  1.536485807144113e-06,
 -6.679089216098558e-09,  2.639074960837760e-11, -9.604277710640813e-14,  3.197424047068724e-16, -9.528695193902750e-19,  2.341357957069040e-21, -3.633717417924209e-24,
 -7.481397734145203e-27,  9.306496434415294e-29,  7.501350065442439e-02, -5.041273485215567e-04,  2.474467753948618e-06, -1.038579367801484e-08,  3.861239051970235e-11,
 -1.265886744727135e-13,  3.476186429784524e-16, -6.647337535605410e-19, -2.602813185881465e-22,  1.080667151690595e-23, -7.236502479702618e-26,  3.287446297098961e-28,
  1.120563830466808e-01, -7.457174972403653e-04,  3.573093018104063e-06, -1.430057749409532e-08,  4.864009659900352e-11, -1.334487044047664e-13,  2.252982110785461e-16,
  3.527484217555224e-19, -5.643757525481529e-21,  3.249367793143906e-23, -1.379688686435847e-25,  4.171264654514440e-28,  1.564992954711612e-01, -1.028887060860813e-03,
  4.781537417969116e-06, -1.796096363850429e-08,  5.347683891018330e-11, -1.023369960496278e-13, -9.017918633139009e-17,  2.073907040296647e-18, -1.232509555185517e-20,
  4.856280624794343e-23, -1.283477989417819e-25,  1.921404052834821e-29,  2.083276507973530e-01, -1.349577343945522e-03,  6.037375432278998e-06, -2.083410715694600e-08,
  5.009070101308895e-11, -2.289801840218660e-14, -5.932501163696286e-16,  4.103706412083857e-18, -1.680676545595516e-20,  3.897692695667167e-23,  3.493516683031226e-26,
 -9.962541460161011e-28,  2.675150462103422e-01, -1.702713675834104e-03,  7.266043645760186e-06, -2.233667849462525e-08,  3.580047000278355e-11,  1.075162571349804e-13,
 -1.207255199096322e-15,  5.625560370926708e-18, -1.416333690409596e-20, -1.434194557491498e-23,  3.590762572573200e-25, -2.148986864802772e-27,  3.340175947552116e-01,
 -2.082027238679382e-03,  8.380510886555655e-06, -2.186572778158668e-08,  8.784746672824586e-12,  2.796915997281100e-13, -1.769409030876560e-15,  5.486076026638961e-18,
  1.256545132890729e-22, -1.115044978003592e-22,  6.947399827890732e-25, -2.161656776107330e-27,  4.077662960910732e-01, -2.479837331583164e-03,  9.281410592196602e-06,
 -1.884527272783969e-08, -3.127173078052935e-11,  4.685824254949281e-13, -2.033151377115182e-15,  2.493571609928572e-18,  2.696123354999949e-20, -2.161665146559945e-22,
  7.037248629781643e-25,  5.107419036472509e-28,  4.886567749672406e-01, -2.886790967802557e-03,  9.858043239641772e-06, -1.279468768543368e-08, -8.240192543187133e-11,
  6.306327751519199e-13, -1.701855237489766e-15, -4.007149226335629e-18,  5.955615750138114e-20, -2.463157137465927e-22, -1.855943460876039e-26,  6.043656299037388e-27,
  5.765354664902128e-01, -3.291560114367498e-03,  9.990887302387376e-06, -3.426060879172266e-09, -1.395058831958873e-10,  7.043225957200698e-13, -5.108839993243419e-16,
 -1.329468863455732e-17,  8.032776891774187e-20, -9.477055808846285e-23, -1.573766771511316e-24,  1.091557433045408e-26,  6.711809913369681e-01, -3.680504518212615e-03,
  9.556595371196819e-06,  9.222377193335238e-09, -1.935764000100113e-10,  6.169914532071641e-13,  1.627525002823589e-15, -2.236363783940913e-17,  6.250118725653505e-20,
  2.972125676177001e-22, -3.198533126844324e-24,  7.166179546651616e-27,  7.722790208023130e-01, -4.037323435184394e-03,  8.436922848297556e-06,  2.461287207509236e-08,
 -2.313230314560634e-10,  3.021318473262806e-13,  4.419491748153335e-15, -2.550830969596810e-17, -1.804003547723588e-20,  8.099516838587189e-22, -2.949105696157595e-24,
 -1.231589442029477e-26,  8.793883694108217e-01, -4.342748706355369e-03,  6.533632392522522e-06,  4.150133197285000e-08, -2.357924746973787e-10, -2.684295999923180e-13,
  6.976319720908908e-15, -1.547734581729048e-17, -1.562835787441071e-19,  1.026786152395602e-21,  1.368442691086685e-24, -3.940075960463452e-26,  9.918953941176896e-01,
 -4.574384353983893e-03,  3.792023594708641e-06,  5.772851914557973e-08, -1.889585765315465e-10, -1.036101459891661e-12,  7.743345589307144e-15,  1.234522626859923e-17,
 -2.829402296495807e-19,  3.289338069358328e-22,  8.999998708079676e-24, -3.702476055175721e-26,  1.108953136528116e+00, -4.706889063696598e-03,  2.359619049224256e-07,
  7.009159113150508e-08, -7.759124580852041e-11, -1.800538426960934e-12,  4.867709147177780e-15,  5.208014459218523e-17, -2.536794872072565e-19, -1.498504204139773e-21,
  1.214523711645486e-23,  3.737066663199371e-26,  1.229401341261477e+00, -4.712846574084266e-03, -3.983894196762949e-06,  7.446801358742672e-08,  9.648543159212649e-11,
 -2.193391063809334e-12, -2.607832933493093e-15,  7.924089298996932e-17,  6.698315551856212e-20, -3.184663118528356e-21, -1.315114968571633e-24,  1.355160378006940e-25,
  1.351664288033586e+00, -4.564889268702372e-03, -8.531766640264870e-06,  6.649008861453750e-08,  3.025841575221650e-10, -1.757203297894000e-12, -1.265970796921642e-14,
  5.474491891504821e-17,  5.743837796762939e-19, -1.788324707698484e-21, -2.742924069027735e-23,  5.493141791952974e-26,  1.473626901998993e+00, -4.239909614373516e-03,
 -1.283384236263299e-05,  4.316314157347929e-08,  4.703795618330164e-10, -2.316250413078134e-13, -1.863007246228636e-14, -3.962233106464435e-17,  7.178759649215058e-19,
  3.747313110196619e-21, -2.448055256430791e-23, -2.521665177245933e-25,  1.592498829334986e+00, -3.726370021581563e-03, -1.607114731831594e-05,  5.642590489257023e-09,
  4.993260652928737e-10,  1.951681641723390e-12, -1.183350339276905e-14, -1.397932931003537e-16, -7.580338367825677e-20,  6.567929408193408e-21,  3.431257051260809e-23,
 -1.875417805331864e-25,  1.704695512178579e+00, -3.035379595167966e-03, -1.729470985547920e-05, -3.757842646692866e-08,  3.131756885416860e-10,  3.366466852571413e-12,
  7.891537779066619e-15, -1.065832444664106e-16, -1.098725294891372e-18, -1.813002897042276e-21,  4.717457367318462e-23,  4.246895311396478e-25,  1.805798536189471e+00,
 -2.214472641693369e-03, -1.575915998892264e-05, -7.001403002378605e-08, -3.990721943562287e-11,  2.424600847780843e-12,  2.207321729068740e-14,  7.227705732742107e-17,
 -5.023310921802381e-19, -8.375484678886846e-21, -4.757007643034631e-23,  4.790530476715961e-26,  1.890699681000326e+00, -1.358873735085668e-03, -1.149087555976230e-05,
 -7.407686561936769e-08, -3.333056135051853e-10, -3.970087810021693e-13,  1.071732290333488e-14,  1.320797438077251e-16,  8.713544495548921e-19,  2.433921024748985e-21,
 -2.164443292663823e-23, -3.836644628846607e-25,  1.954054375482724e+00, -6.091450728738009e-04, -5.822412589518134e-06, -4.681141137695802e-08, -3.261092472649189e-10,
 -1.929151067855263e-12, -8.773066571230369e-15, -1.683102937426175e-17,  2.212658129602068e-19,  3.623342166199961e-21,  3.418469341849509e-23,  2.405576393737708e-25,
  1.991113113259636e+00, -1.223337326912733e-04, -1.253741962108801e-06, -1.131097162923808e-08, -9.450233019880402e-11, -7.465810614210289e-13, -5.628279818713353e-15,
 -4.061257069791024e-17, -2.801236395077628e-19, -1.835981413827253e-21, -1.128864906260000e-23, -6.338998616774462e-26,  9.011511052661066e-04, -6.087889155289070e-06,
  3.083262533180438e-08, -1.387753362690609e-10,  5.850904004945167e-13, -2.367966073857442e-15,  9.300897992051604e-18, -3.582645702443307e-20,  1.351834198614707e-22,
 -5.072808082102529e-25,  1.850613228220138e-27, -6.938216755161899e-30,  8.110876197364928e-03, -5.470081411333952e-05,  2.759124423624352e-07, -1.232783062520431e-09,
  5.137744455543871e-12, -2.044698873201615e-14,  7.846816557900520e-17, -2.931140911396364e-19,  1.062298782904603e-21, -3.792127933233161e-24,  1.293346802977318e-26,
 -4.514061902859950e-29,  2.253300125702863e-02, -1.514419518384779e-04,  7.576044839811972e-07, -3.334505344087763e-09,  1.356592124056584e-11, -5.208426547494041e-14,
  1.898278961590141e-16, -6.597813346658667e-19,  2.158132413003560e-21, -6.685147994770943e-24,  1.811416333098293e-26, -4.646067823082409e-29,  4.417249250186543e-02,
 -2.953239024613535e-04,  1.458808186449579e-06, -6.271796043170972e-09,  2.454451437077706e-11, -8.868077994947263e-14,  2.940909529942525e-16, -8.800893333811048e-19,
  2.206068702332945e-21, -3.859310709491711e-24, -3.992413467658925e-27,  6.638030207336169e-29,  7.303580800122748e-02, -4.848198115175224e-04,  2.353462921796173e-06,
 -9.787802663690028e-09,  3.616253447915541e-11, -1.184697785796587e-13,  3.289441530514231e-16, -6.673695742654239e-19,  7.997592101916037e-23,  8.183232518465369e-24,
 -5.924166014887652e-26,  2.690275308766604e-28,  1.091296141149084e-01, -7.178061516270506e-04,  3.406068421284462e-06, -1.354339094786870e-08,  4.602589309526283e-11,
 -1.279423880317609e-13,  2.328152298300017e-16,  1.898345864347398e-19, -4.569011423358378e-21,  2.732962963558454e-23, -1.205484875129473e-25,  3.739142487286513e-28,
  1.524589071223451e-01, -9.914824982929216e-04,  4.571071759568876e-06, -1.712180676685421e-08,  5.141293600038156e-11, -1.038474512649567e-13, -3.737565751858215e-17,
  1.706488433088591e-18, -1.066882129299291e-20,  4.346944508188894e-23, -1.257990421921527e-25,  9.088702895348495e-29,  2.030243752191851e-01, -1.302264792601576e-03,
  5.792157339262200e-06, -2.003705523124596e-08,  4.949935926878815e-11, -3.581664496836681e-14, -4.856633749847588e-16,  3.588529328575615e-18, -1.538829031996954e-20,
  3.957552449422054e-23, -3.181540213926497e-27, -7.457885949300851e-28,  2.608187645680513e-01, -1.645647596048954e-03,  7.001506354331246e-06, -2.174819000546630e-08,
  3.767354630622131e-11,  8.038072357663372e-14, -1.056143582343509e-15,  5.166665351541234e-18, -1.444304876308215e-20, -1.776769441827456e-24,  2.714569306219352e-25,
 -1.836980460401748e-27,  3.258219160946451e-01, -2.016029906669392e-03,  8.119142753952834e-06, -2.168267629827785e-08,  1.396635021256090e-11,  2.390660369407737e-13,
 -1.616308915364687e-15,  5.431046746504151e-18, -3.411356760603877e-21, -8.563085576544108e-23,  5.988097815747345e-25, -2.180569221457165e-27,  3.979940060026369e-01,
 -2.406498430702206e-03,  9.052565978565024e-06, -1.927327305902638e-08, -2.238190913239512e-11,  4.207151287798771e-13, -1.952383725791278e-15,  3.237279538643293e-18,
  1.968887223524532e-20, -1.878350565442263e-22,  7.067052432182984e-25, -3.333094127478079e-28,  4.772663369946745e-01, -2.808562236248363e-03,  9.697005336434276e-06,
 -1.401447084600668e-08, -7.020572516253007e-11,  5.886490161321935e-13, -1.788705474637761e-15, -2.242883198921846e-18,  5.073496121074543e-20, -2.422377120943541e-22,
  2.104204825265847e-25,  4.391611961090785e-27,  5.635287676839643e-01, -3.211834346835981e-03,  9.936844368651827e-06, -5.546250971813391e-09, -1.255707095151408e-10,
  6.878812656991588e-13, -8.477426008256821e-16, -1.079001496824675e-17,  7.589603304355000e-20, -1.484109129823073e-22, -1.116334135236190e-24,  9.809042444126914e-27,
  6.566125066099371e-01, -3.603660783343229e-03,  9.649094080464915e-06,  6.225787000608588e-09, -1.808954788638436e-10,  6.487728950058079e-13,  1.030779931873834e-15,
 -2.021643757363860e-17,  7.098044065376278e-20,  1.762800656804560e-22, -2.832885888508503e-24,  9.256354907768924e-27,  7.562665002285446e-01, -3.968709058929839e-03,
  8.710287711520413e-06,  2.096556400874116e-08, -2.242777951814687e-10,  3.995897287095696e-13,  3.701392737404141e-15, -2.564276472263681e-17,  8.882610367768211e-21,
  6.831520045179452e-22, -3.342843805314430e-24, -5.727335610186707e-27,  8.621249757961793e-01, -4.288552068514507e-03,  7.008864176953148e-06,  3.769464369155692e-08,
 -2.395246271652830e-10, -1.067289859401306e-13,  6.478552072554719e-15, -1.987972930897501e-17, -1.187381109804410e-19,  1.048385341266511e-21, -2.467912795451174e-25,
 -3.369294662772869e-26,  9.736628418935438e-01, -4.541330101803363e-03,  4.465974959203936e-06,  5.454960229360142e-08, -2.077994361880728e-10, -8.471229381406234e-13,
  7.964510904242778e-15,  3.546718834717861e-18, -2.650380928103297e-19,  6.534741167446150e-22,  7.165093162321294e-24, -4.552618931984434e-26,  1.090134649276284e+00,
 -4.701660770088572e-03,  1.068445758399348e-06,  6.856887123770835e-08, -1.123205862300113e-10, -1.667178207008334e-12,  6.204879662825795e-15,  4.319576780414956e-17,
 -2.985566685402761e-19, -9.877064815702873e-22,  1.319910450833047e-23,  1.057313151992259e-26,  1.210491904858626e+00, -4.741120371258538e-03, -3.082472017128853e-06,
  7.565819468155632e-08,  5.217225061006172e-11, -2.229217912808083e-12, -3.763199640548151e-16,  7.955144018147360e-17, -4.718467016847854e-20, -3.119328720831803e-21,
  4.523062636597611e-24,  1.274725165661531e-25,  1.333273388478375e+00, -4.629872350145849e-03, -7.706049214384043e-06,  7.103433205168807e-08,  2.645363776448415e-10,
 -2.040631944364656e-12, -1.088068152628848e-14,  7.188921901980393e-17,  4.910074451760409e-19, -2.818586192499714e-21, -2.363717215270574e-23,  1.161127851695252e-25,
  1.456465382423160e+00, -4.340381090819967e-03, -1.227096070665752e-05,  5.062753196508096e-08,  4.611998984813083e-10, -6.893466774439786e-13, -1.939907916558330e-14,
 -1.470195999110043e-17,  8.325705555932539e-19,  2.556724081085937e-21, -3.472300043142022e-23, -2.074501085123282e-25,  1.577336835246468e+00, -3.854529679409411e-03,
 -1.595426644689874e-05,  1.392731283204407e-08,  5.352021496911606e-10,  1.620660412143915e-12, -1.574434628640180e-14, -1.381894586465546e-16,  1.830028653016246e-19,
  7.736351931236426e-21,  2.314588611474031e-23, -3.193510547188931e-25,  1.692274549563400e+00, -3.175450676138337e-03, -1.771333385093056e-05, -3.201977697707124e-08,
  3.821365253061448e-10,  3.516032417286323e-12,  4.407974393225413e-15, -1.423859935050226e-16, -1.125527914373199e-18,  4.463750201515409e-22,  6.563991759990981e-23,
  4.031209495756341e-25,  1.796683167770678e+00, -2.343913574141411e-03, -1.660146417508745e-05, -7.023517422152801e-08,  1.403567688992214e-11,  2.976535148851062e-12,
  2.382402248315816e-14,  5.101802471543495e-17, -8.371349662283702e-19, -1.018505782091086e-20, -4.151892282768353e-23,  2.387314196046822e-25,  1.885074573546543e+00,
 -1.454447594420302e-03, -1.241200846766376e-05, -7.945798639395706e-08, -3.383574718697779e-10, -9.218929886086417e-14,  1.481769914127565e-14,  1.611622124333368e-16,
  9.389105453167600e-19,  1.184807638396039e-21, -4.199016761086545e-23, -5.453223044847194e-25,  1.951520949736042e+00, -6.580630304177166e-04, -6.416766710510297e-06,
 -5.234940777922772e-08, -3.668312948325255e-10, -2.144429300551187e-12, -9.123592289742434e-15, -7.377839565728338e-18,  3.790268282237898e-19,  5.219679487561774e-21,
  4.606242328917699e-23,  2.994770467693186e-25,  1.990602820976094e+00, -1.329334841425044e-04, -1.399063464767759e-06, -1.295020682834721e-08, -1.108823538011256e-10,
 -8.963828556984703e-13, -6.901517744126204e-15, -5.072692148513029e-17, -3.550595039791273e-19, -2.347793489631754e-21, -1.441699797856219e-23, -7.917481105036169e-26,
  8.772825437512487e-04, -5.847733746356159e-06,  2.922196549319878e-08, -1.297809685465641e-10,  5.398844966466004e-13, -2.156309766193159e-15,  8.355672458255493e-18,
 -3.177907242725695e-20,  1.181830964394512e-22, -4.390448544002799e-25,  1.568612872795243e-27, -5.917906349665407e-30,  7.896395781215570e-03, -5.255132112316825e-05,
  2.615990980553150e-07, -1.153751069859322e-09,  4.746991587538645e-12, -1.865852048609193e-14,  7.071704778602005e-17, -2.612087241926309e-19,  9.346322565629894e-22,
 -3.312702566382584e-24,  1.108024287435573e-26, -3.931264637658727e-29,  2.193910680593765e-02, -1.455375598830521e-04,  7.188591576786894e-07, -3.125542694656520e-09,
  1.256833764749907e-11, -4.774249616228893e-14,  1.722856560901739e-16, -5.944358680141674e-19,  1.930021434811614e-21, -6.000943926543053e-24,  1.610808439844313e-26,
 -4.481609062514840e-29,  4.301407041696968e-02, -2.839479394161867e-04,  1.385845597685537e-06, -5.892897480014013e-09,  2.283952523656526e-11, -8.191045929349258e-14,
  2.704156951502031e-16, -8.117436210236011e-19,  2.064900107019812e-21, -3.967434216677405e-24, -1.576663109468779e-27,  4.398440330247960e-29,  7.113345394137556e-02,
 -4.664522637803902e-04,  2.239404075208331e-06, -9.227734678246194e-09,  3.387057450204747e-11, -1.107988094792178e-13,  3.103347905129165e-16, -6.605319629253886e-19,
  3.346243066882558e-22,  6.034276831602933e-24, -4.859242791396066e-26,  2.159512693905110e-28,  1.063118747254692e-01, -6.911953604715653e-04,  3.247882761329808e-06,
 -1.282714232806425e-08,  4.352326988803274e-11, -1.223066830378103e-13,  2.362251364959260e-16,  5.846882033289837e-20, -3.668098752501372e-21,  2.282305360441737e-23,
 -1.051257963655433e-25,  3.264802385520105e-28,  1.485648325541655e-01, -9.557219447094601e-04,  4.370477065788133e-06, -1.631584855103011e-08,  4.933069376430382e-11,
 -1.042082539334932e-13,  5.854768964481841e-18,  1.389162075920480e-18, -9.193402926011037e-21,  3.853130553209382e-23, -1.208187398052547e-25,  1.306596868454467e-28,
  1.979064866810059e-01, -1.256875907103097e-03,  5.556439015520926e-06, -1.925139627264425e-08,  4.867432394578045e-11, -4.632115012878913e-14, -3.918648534763603e-16,
  3.118814537779131e-18, -1.397320540091558e-20,  3.885326430913005e-23, -3.151166460221285e-26, -5.508019922842796e-28,  2.543465600398311e-01, -1.590669097658539e-03,
  6.744193456971293e-06, -2.113388131303039e-08,  3.903913441305009e-11,  5.671706309788304e-14, -9.179430032761977e-16,  4.705407128328680e-18, -1.433025337241670e-20,
  7.551209138885140e-24,  1.970165754483632e-25, -1.552347140519609e-27,  3.178860606938614e-01, -1.952113384310152e-03,  7.860442504951163e-06, -2.142302034904901e-08,
  1.837199917395956e-11,  2.020844314317936e-13, -1.466199453046266e-15,  5.276995924044818e-18, -6.085915687790477e-21, -6.358187490871697e-23,  5.041497484737665e-25,
 -2.111132469383495e-27,  3.885113807945493e-01, -2.335008484755465e-03,  8.819407550816906e-06, -1.956658307124770e-08, -1.442849436195785e-11,  3.750107862245149e-13,
 -1.853897175718718e-15,  3.764545541984271e-18,  1.343029722417556e-20, -1.600554703111497e-22,  6.778257962473835e-25, -9.448285296190042e-28,  4.661861492367310e-01,
 -2.731677104615109e-03,  9.522472838905015e-06, -1.504592923215159e-08, -5.886620683104059e-11,  5.451419427463227e-13, -1.830074294406915e-15, -7.569179403926117e-19,
  4.220838652110689e-20, -2.304024811398151e-22,  3.706592683777558e-25,  2.925312207373315e-27,  5.508399514411613e-01, -3.132638929259107e-03,  9.858684720719510e-06,
 -7.446524627430745e-09, -1.120396178393869e-10,  6.641792139166147e-13, -1.116721466405480e-15, -8.454624183235822e-18,  6.984986884804240e-20, -1.848340925962000e-22,
 -7.152002470301925e-25,  8.387086122842581e-27,  6.423526539877987e-01, -3.526217402562680e-03,  9.706869588021252e-06,  3.436419363815060e-09, -1.677171360778067e-10,
  6.669806576655371e-13,  4.973217526493747e-16, -1.786457625882833e-17,  7.538843059718088e-20,  7.147213286572620e-23, -2.400426957310031e-24,  1.023206131808205e-26,
  7.405325366952061e-01, -3.898080776199608e-03,  8.940622510179934e-06,  1.744563699918822e-08, -2.154555651053534e-10,  4.798610964297811e-13,  2.990885622773395e-15,
 -2.499122103651155e-17,  3.102426856929137e-20,  5.461132840597779e-22, -3.468769420494864e-24, -1.945481083908140e-28,  8.450856820184893e-01, -4.230737071211461e-03,
  7.438161926582624e-06,  3.385342451680406e-08, -2.401515130776492e-10,  4.168205352769884e-14,  5.874369051009069e-15, -2.308016341195823e-17, -8.151278505117941e-20,
  1.010903050018232e-21, -1.574970713721938e-24, -2.652053810515020e-26,  9.555730414479536e-01, -4.503041662719184e-03,  5.100096033203393e-06,  5.109967418616971e-08,
 -2.228272222808316e-10, -6.557177405799450e-13,  7.948989796204174e-15, -4.506791303554479e-18, -2.368499801192963e-19,  8.986506385830821e-22,  5.068869996404238e-24,
 -4.894906834851374e-26,  1.071350266158761e+00, -4.689854928983189e-03,  1.879416384774936e-06,  6.651347592392004e-08, -1.440827167818773e-10, -1.504856096005212e-12,
  7.275991797365617e-15,  3.317538400738140e-17, -3.245681645296119e-19, -4.580361454451474e-22,  1.310159281677667e-23, -1.448752251520354e-26,  1.191483869411454e+00,
 -4.762137751055220e-03, -2.171035959258320e-06,  7.613653804963868e-08,  7.676681535613794e-12, -2.211793174619862e-12,  1.813410831400591e-15,  7.629038000226839e-17,
 -1.549198108395052e-19, -2.831636655985338e-21,  9.705888335373577e-24,  1.061570608683538e-25,  1.314636098280314e+00, -4.688042332446267e-03, -6.829632570459653e-06,
  7.492693963985182e-08,  2.212841751156766e-10, -2.275938056799402e-12, -8.664304651974983e-15,  8.580641769894381e-17,  3.738944116000742e-19, -3.646340540076097e-21,
 -1.739382649652790e-23,  1.649731849379546e-25,  1.438911545892705e+00, -4.435994421193866e-03, -1.161969229319931e-05,  5.787105366592255e-08,  4.427397255984458e-10,
 -1.156778818023782e-12, -1.942591414761282e-14,  1.312826011755879e-17,  8.975982502330732e-19,  1.006128485879875e-21, -4.223334091196130e-23, -1.288567459672083e-25,
  1.561664715330968e+00, -3.981347401437624e-03, -1.573475971340668e-05,  2.272802196001886e-08,  5.635278340781187e-10,  1.197289190748267e-12, -1.948869275244449e-14,
 -1.277282165449581e-16,  4.744590114729568e-19,  8.345140280822718e-21,  6.449988167179398e-24, -4.347515438305768e-25,  1.679287053839220e+00, -3.318584980418062e-03,
 -1.805855074677133e-05, -2.533870774911371e-08,  4.531712538993408e-10,  3.569946001656456e-12, -7.684654247689197e-17, -1.776056260553506e-16, -1.058125744542383e-18,
  3.403220920804503e-21,  8.146313840195136e-23,  3.013965914292481e-25,  1.787036563785656e+00, -2.480088029855373e-03, -1.744087250860388e-05, -6.950286445801738e-08,
  7.938273220921722e-11,  3.562076994704592e-12,  2.482022344854240e-14,  1.806732291674780e-17, -1.230516165882893e-18, -1.156418227728224e-20, -2.555030681123374e-23,
  4.975429292048799e-25,  1.879052022280116e+00, -1.557649685466426e-03, -1.339798053662068e-05, -8.486553822462782e-08, -3.362618266704811e-10,  3.210076872212570e-13,
  1.975468704856174e-14,  1.915156106417598e-16,  9.450769552290721e-19, -1.026546799597373e-21, -6.987271793716568e-23, -7.226411589435146e-25,  1.948781905533695e+00,
 -7.120130508554396e-04, -7.081629396996436e-06, -5.857375757446013e-08, -4.119184074781911e-10, -2.364316910670774e-12, -9.129429344947930e-15,  8.139938320700278e-18,
  6.034284084427067e-19,  7.342318032999728e-21,  6.045919912267754e-23,  3.526591918234903e-25,  1.990047673356501e+00, -1.447791852552124e-04, -1.565732794746571e-06,
 -1.487725238485998e-08, -1.305884056404446e-10, -1.080429672822514e-12, -8.494478918939198e-15, -6.355956939858316e-17, -4.508458416599572e-19, -2.999213010012234e-21,
 -1.828136425659119e-23, -9.663189453356699e-26,  8.543494999418845e-04, -5.620043868590720e-06,  2.771503410370426e-08, -1.214772253970543e-10,  4.986937359453181e-13,
 -1.966038229218013e-15,  7.516511808926104e-18, -2.823848749057682e-20,  1.034464411208520e-22, -3.812572696069691e-25,  1.326586033699492e-27, -5.118807652880837e-30,
  7.690290183403494e-03, -5.051264498230711e-05,  2.481977738434850e-07, -1.080694779991623e-09,  4.390217857571457e-12, -1.704580505796961e-14,  6.380458110427611e-17,
 -2.331263654181399e-19,  8.229490190328095e-22, -2.902662292706943e-24,  9.454667215512092e-27, -3.479770651468930e-29,  2.136822550405417e-02, -1.399333652197103e-04,
  6.825284082784139e-07, -2.931868967170455e-09,  1.165352333822291e-11, -4.380058717482481e-14,  1.564744886308042e-16, -5.360112081751513e-19,  1.725113037993352e-21,
 -5.395745628151583e-24,  1.415749030201141e-26, -4.405246057606503e-29,  4.190001293772828e-02, -2.731379436136416e-04,  1.317270482885451e-06, -5.540225722808284e-09,
  2.126441281052264e-11, -7.568589410862440e-14,  2.485904106234228e-16, -7.479608070868359e-19,  1.921348918972365e-21, -3.997785501489280e-24, -8.635133190846929e-29,
  2.397743811968853e-29,  6.930278683115552e-02, -4.489709154631713e-04,  2.131851000737471e-06, -8.703134883215783e-09,  3.172758763351789e-11, -1.035713154887158e-13,
  2.920198935481818e-16, -6.467056667613711e-19,  5.190285186375891e-22,  4.266040421494383e-24, -4.017445854839489e-26,  1.671473509018977e-28,  1.035981010153036e-01,
 -6.658163467862960e-04,  3.098055563673551e-06, -1.215003071412929e-08,  4.113389743602324e-11, -1.166301672333879e-13,  2.363368458777765e-16, -4.654861675805055e-20,
 -2.918832090449427e-21,  1.889046719880123e-23, -9.187962253482634e-26,  2.748050819722736e-28,  1.448106511381832e-01, -9.215280292485606e-04,  4.179353911790382e-06,
 -1.554321049398574e-08,  4.725091796185555e-11, -1.036329757219199e-13,  4.083461111415331e-17,  1.116246103337244e-18, -7.891826683857311e-21,  3.381900027149871e-23,
 -1.147096652950359e-25,  1.425923631435912e-28,  1.929664415648313e-01, -1.213335296168158e-03,  5.330062847125984e-06, -1.848050066677061e-08,  4.766067116754704e-11,
 -5.472722944209550e-14, -3.105897636506106e-16,  2.693763576515538e-18, -1.260259452702560e-20,  3.715375284366947e-23, -5.242757109667545e-26, -4.085166605249440e-28,
  2.480901996646878e-01, -1.537719279009488e-03,  6.494368314149847e-06, -2.050133356307026e-08,  3.996357466734274e-11,  3.621593195642743e-14, -7.925605975637824e-16,
  4.252580445611593e-18, -1.393232869818285e-20,  1.414098496041904e-23,  1.342504521183015e-25, -1.308398712229318e-27,  3.102017535316332e-01, -1.890252857069114e-03,
  7.605257291437224e-06, -2.109859696200263e-08,  2.207364594444137e-11,  1.686447282153185e-13, -1.321487457289685e-15,  5.049335684184200e-18, -8.033973100349457e-21,
 -4.524149876880343e-23,  4.137213105030675e-25, -1.994731205355874e-27,  3.793109655074429e-01, -2.265395790395393e-03,  8.583463194641946e-06, -1.973981809132914e-08,
 -7.364446903344822e-12,  3.318255660927395e-13, -1.743302552907216e-15,  4.107266145788069e-18,  8.145043623955860e-21, -1.339112625743592e-22,  6.262781030769399e-25,
 -1.372225784349022e-27,  4.554106353613512e-01, -2.656234725028867e-03,  9.336622582420940e-06, -1.590295680453927e-08, -4.840354583762264e-11,  5.011109047746492e-13,
 -1.833583833848597e-15,  4.641284645315072e-19,  3.420825119719547e-20, -2.133877720322409e-22,  4.708961206990928e-25,  1.664670522689772e-27,  5.384665270392033e-01,
 -3.054156359741402e-03,  9.759004053969345e-06, -9.134422067834686e-09, -9.904194319952770e-11,  6.347833937728347e-13, -1.323193841766446e-15, -6.330719544974887e-18,
  6.276568566678170e-20, -2.065185690500613e-22, -3.805132587799975e-25,  6.811310126135972e-27,  6.284032923963786e-01, -3.448442099590496e-03,  9.732447630411427e-06,
  8.601454571818959e-10, -1.542972659574190e-10,  6.731882235036100e-13,  3.114745212496699e-17, -1.542862349956934e-17,  7.634241823433847e-20, -1.546523570628573e-23,
 -1.946086376011880e-24,  1.028398636874609e-26,  7.250845076761764e-01, -3.825776255900475e-03,  9.129615117020364e-06,  1.407879017292556e-08, -2.051965573315488e-10,
  5.433746944928038e-13,  2.307795261348328e-15, -2.371059626702280e-17,  4.819721988867715e-20,  4.085398429698245e-22, -3.378930436310410e-24,  4.056838619745550e-27,
  8.282842251114192e-01, -4.169672020620091e-03,  7.821400186822659e-06,  3.002510501326263e-08, -2.379617516193840e-10,  1.746503635533048e-13,  5.196978509232086e-15,
 -2.512059914994374e-17, -4.651500411907488e-20,  9.268172819969355e-22, -2.573382158510981e-24, -1.885387062249902e-26,  9.376462731136336e-01, -4.459849648718425e-03,
  5.691501359460958e-06,  4.743983135644546e-08, -2.340483355877810e-10, -4.672815295586163e-13,  7.721808906478009e-15, -1.153345347222212e-17, -2.013683533917464e-19,
  1.058354368494508e-21,  2.924421975409604e-24, -4.785238946468280e-26,  1.052625913865118e+00, -4.671668365816997e-03,  2.662784495590284e-06,  6.397715792798770e-08,
 -1.723644760353482e-10, -1.320270660536583e-12,  8.057729054884044e-15,  2.262487531942243e-17, -3.318377860900745e-19,  4.677656280625595e-23,  1.198725381738792e-23,
 -3.530274063480960e-26,  1.172406366747884e+00, -4.775852739847188e-03, -1.258110707255659e-06,  7.590855776170372e-08, -3.595422116081661e-11, -2.143289232642996e-12,
  3.865397251038930e-15,  6.978548598588615e-17, -2.488220596315753e-19, -2.358587417918282e-21,  1.371898635618106e-23,  7.498287246602494e-26,  1.295780429601548e+00,
 -4.739026239292624e-03, -5.910802444038976e-06,  7.809287770291226e-08,  1.738870461383210e-10, -2.453824138939064e-12, -6.114826178065387e-15,  9.555130738153372e-17,
  2.319479731595462e-19, -4.186678421088343e-21, -9.408907807308999e-24,  1.943109905065699e-25,  1.420986218818914e+00, -4.526055645779487e-03, -1.088358168186799e-05,
  6.474465695995186e-08,  4.149885778272625e-10, -1.615322378976901e-12, -1.865313404940953e-14,  4.209551758208238e-17,  9.023071513479288e-19, -7.674507922684842e-22,
 -4.568794781008725e-23, -2.506314357084614e-26,  1.545489515478347e+00, -4.105979605647757e-03, -1.540722012757005e-05,  3.190943877918800e-08,  5.825166921047454e-10,
  6.886379442008274e-13, -2.280723092188869e-14, -1.077279464526403e-16,  7.746792189903253e-19,  8.195058146866334e-21, -1.449106998955980e-23, -5.080989962194660e-25,
  1.665722032524363e+00, -3.464140964784456e-03, -1.831675974159506e-05, -1.751863450207157e-08,  5.241297111383021e-10,  3.504736290849655e-12, -5.500806234231547e-15,
 -2.088534505250342e-16, -8.742080584535828e-19,  6.876448882500459e-21,  9.077622232367343e-23,  1.062067124614578e-25,  1.776831913375285e+00, -2.622923930169571e-03,
 -1.826483006198303e-05, -6.763035589022515e-08,  1.565974521916665e-10,  4.158992864831401e-12,  2.471111925631395e-14, -2.811935837048023e-17, -1.659147477902270e-18,
 -1.205998455896980e-20,  3.013683974252177e-24,  8.062312614931653e-25,  1.872600477809670e+00, -1.668997874218265e-03, -1.444834769345452e-05, -9.016672203717796e-08,
 -3.246487492963920e-10,  8.628317910075682e-13,  2.553074196129289e-14,  2.205621346935168e-16,  8.496905197165613e-19, -4.507392352815131e-21, -1.053430169503703e-22,
 -8.828144429685043e-25,  1.945815932642828e+00, -7.715933387524919e-04, -7.825657353472440e-06, -6.555452752912895e-08, -4.613649708384750e-10, -2.578244511760312e-12,
 -8.587931587567094e-15,  3.217661146162163e-17,  9.151245559261949e-19,  1.008176903001759e-20,  7.671000840074262e-23,  3.790580231898468e-25,  1.989442321813992e+00,
 -1.580563931201216e-04, -1.757547001378478e-06, -1.715124816947029e-08, -1.543886949613999e-10, -1.307388464040234e-12, -1.049341343980391e-14, -7.986394146048923e-17,
 -5.730517812640051e-19, -3.820642724678669e-21, -2.291380772940702e-23, -1.135361175534966e-25,  8.323037203811254e-04, -5.404021783890073e-06,  2.630391544341860e-08,
 -1.138031524667003e-10,  4.611147699947823e-13, -1.794768341956042e-15,  6.770185321152569e-18, -2.513799334940196e-20,  9.062377460978408e-23, -3.325111792091156e-25,
  1.114949084140850e-27, -4.538406953242468e-30,  7.492130287404088e-03, -4.857776738161811e-05,  2.356399107392741e-07, -1.013097588942716e-09,  4.064101104091781e-12,
 -1.558994380416080e-14,  5.763051817676370e-17, -2.083938719710525e-19,  7.249010194570947e-22, -2.554078018834854e-24,  7.997029378901396e-27, -3.171672563057317e-29,
  2.081919406448240e-02, -1.346107631816859e-04,  6.484364577960450e-07, -2.752221637832402e-09,  1.081388128977676e-11, -4.021923687532635e-14,  1.422105809178495e-16,
 -4.838100405552672e-19,  1.540591582255762e-21, -4.868338321838359e-24,  1.220575877374664e-26, -4.505291882585656e-29,  4.082812445031539e-02, -2.628600396363193e-04,
  1.252780236038570e-06, -5.211787696296385e-09,  1.980869559370577e-11, -6.996422444859228e-14,  2.284866418296899e-16, -6.887793143604687e-19,  1.777568146769878e-21,
 -3.985926898480370e-24,  5.340259659346455e-28,  3.978996665784598e-30,  6.754036332597960e-02, -4.323253830126594e-04,  2.030392090238435e-06, -8.211690218777344e-09,
  2.972478963224413e-11, -9.677812318267060e-14,  2.741656154586320e-16, -6.279361155588573e-19,  6.453250927109408e-22,  2.792117934456952e-24, -3.387066928883398e-26,
  1.191421095466105e-28,  1.009834966790513e-01, -6.416040906096357e-04,  2.956128069983454e-06, -1.151024162389072e-08,  3.885785739094895e-11, -1.109836741837806e-13,
  2.338231581707111e-16, -1.297569737507932e-19, -2.302164199388311e-21,  1.544056353531838e-23, -8.104013292589265e-26,  2.164135664284107e-28,  1.411902453369497e-01,
 -8.888265769337134e-04,  3.997303276539001e-06, -1.480371370702799e-08,  4.519044757721273e-11, -1.023053296131667e-13,  6.873074904637294e-17,  8.823139958151476e-19,
 -6.755440848423143e-21,  2.935357922397505e-23, -1.086750189451572e-25,  1.269045071132888e-28,  1.881969950565232e-01, -1.171568979413259e-03,  5.112834899784982e-06,
 -1.772706645341876e-08,  4.649746416300792e-11, -6.132062961296317e-14, -2.406123496430097e-16,  2.311443096566220e-18, -1.130685728040963e-20,  3.472734859600222e-23,
 -6.824372904744589e-26, -3.195324511912290e-28,  2.420416897506973e-01, -1.486737477884029e-03,  6.252209477750245e-06, -1.985711573374849e-08,  4.050706537039978e-11,
  1.857347006463486e-14, -6.796467421342253e-16,  3.815818635650323e-18, -1.333991013542132e-20,  1.841995608485966e-23,  8.108344398554926e-26, -1.118479108576004e-27,
  3.027608315270802e-01, -1.830417281979285e-03,  7.354299051506735e-06, -2.072011116118905e-08,  2.514067928963024e-11,  1.385951602513302e-13, -1.183928337153192e-15,
  4.769213937864728e-18, -9.385599058837480e-21, -3.041066216468807e-23,  3.287298659829128e-25, -1.870549735987127e-27,  3.703852153494660e-01, -2.197677109434513e-03,
  8.346090139799582e-06, -1.980679084205215e-08, -1.136878982578029e-12,  2.913915141256203e-13, -1.625341091677298e-15,  4.295485570566056e-18,  3.759726403540894e-21,
 -1.101629124839931e-22,  5.589706088832857e-25, -1.671041695606912e-27,  4.449338561955711e-01, -2.582317505875469e-03,  9.141463365739527e-06, -1.659962023214316e-08,
 -3.881972557236392e-11,  4.573775719817287e-13, -1.806391144897600e-15,  1.439639883781832e-18,  2.687998459670732e-20, -1.934143843302191e-22,  5.199938359535662e-25,
  5.958029073267506e-28,  5.264053146745572e-01, -2.976548765599732e-03,  9.640296175438339e-06, -1.061930953485525e-08, -8.667705644148399e-11,  6.011196198537812e-13,
 -1.473470328433178e-15, -4.443552129720257e-18,  5.512494119438458e-20, -2.162213127923254e-22, -1.164294725811828e-25,  5.191209945657160e-27,  6.147652506295443e-01,
 -3.370582177620705e-03,  9.728400884761834e-06, -1.501001991750966e-09, -1.408595955988448e-10,  6.690267692440738e-13, -3.668383256473332e-16, -1.300872099212881e-17,
  7.449223633899977e-20, -8.441123859741820e-23, -1.506160760671891e-24,  9.607398689681181e-27,  7.099284687992231e-01, -3.752118522125775e-03,  9.279229496166715e-06,
  1.088537214735993e-08, -1.938280131992332e-10,  5.909819683709861e-13,  1.667518275436817e-15, -2.195864367129303e-17,  6.052367529016390e-20,  2.779034139135359e-22,
 -3.131805810394580e-24,  6.952279534767364e-27,  8.117328703665971e-01, -4.105724031382200e-03,  8.158993680228885e-06,  2.625219611886181e-08, -2.332791841805856e-10,
  2.907992098634477e-13,  4.477628563230469e-15, -2.609658879499101e-17, -1.518217552100132e-20,  8.094972111420079e-22, -3.239155399703765e-24, -1.152340647752894e-26,
  9.199014532383823e-01, -4.412104832530402e-03,  6.238034576087530e-06,  4.363023974041192e-08, -2.415705010781900e-10, -2.865255927009998e-13,  7.314524416707830e-15,
 -1.734910641095765e-17, -1.616594249211623e-19,  1.134365177695072e-21,  9.099030373306590e-25, -4.323393018797593e-26,  1.033986638471193e+00, -4.647344006973707e-03,
  3.413126594895970e-06,  6.101878413697409e-08, -1.967909040466205e-10, -1.120478346832962e-12,  8.543456086000663e-15,  1.212221285797770e-17, -3.219424675486009e-19,
  4.903336338597023e-22,  1.008137180532161e-23, -5.029127577598549e-26,  1.153288577011188e+00, -4.782287016103594e-03, -3.520560886251642e-07,  7.499605162798945e-08,
 -7.773900563491439e-11, -2.028046037089844e-12,  5.695943308855350e-15,  6.057637304108354e-17, -3.231537595620120e-19, -1.754366262322021e-21,  1.622558625225087e-23,
  3.847147847316558e-26,  1.276735748659455e+00, -4.782520680484990e-03, -4.958637590264249e-06,  8.047540777790510e-08,  1.235634510011371e-10, -2.567777447849097e-12,
 -3.358554960062176e-15,  1.005064432795069e-16,  7.654825869541965e-20, -4.388580746730052e-21, -6.444773164835418e-25,  2.000364094187261e-25,  1.402712935444964e+00,
 -4.609906289900055e-03, -1.006795056315209e-05,  7.110215793665443e-08,  3.783175587050571e-10, -2.045628914917816e-12, -1.707689674726961e-14,  7.017442476704822e-17,
  8.418222598911858e-19, -2.583519348514156e-21, -4.427948016527759e-23,  8.942930879212489e-26,  1.528821731468153e+00, -4.227546420434825e-03, -1.496802976985305e-05,
  4.130917556546384e-08,  5.905870044835230e-10,  1.081365588486977e-13, -2.543325925118471e-14, -7.837402356319373e-17,  1.053799770180181e-18,  7.160509858428537e-21,
 -3.729776747803570e-23, -5.163004697311205e-25,  1.651571277311436e+00, -3.611368103386851e-03, -1.847438257551625e-05, -8.581016349381152e-09,  5.924152890221390e-10,
  3.299634982168997e-12, -1.169810561507978e-14, -2.321618824478630e-16, -5.608688027069204e-19,  1.052311233862397e-20,  8.948262095452748e-23, -1.781419383327729e-25,
  1.766042909196165e+00, -2.772239704004624e-03, -1.905851266464198e-05, -6.442751524614362e-08,  2.456115037864434e-10,  4.736213636246956e-12,  2.311580605444258e-14,
 -8.806032742297495e-17, -2.081729638900693e-18, -1.113593675494341e-20,  4.547715142704194e-23,  1.119186552749212e-24,  1.865686337428255e+00, -1.788999424441160e-03,
 -1.556083146146175e-05, -9.518760404363730e-08, -3.007493697819823e-10,  1.552570025649841e-12,  3.205650043565689e-14,  2.442646459737689e-16,  6.019047015322301e-19,
 -9.530735310448785e-21, -1.464398575431064e-22, -9.658705723006106e-25,  1.942599184205630e+00, -8.374746960841759e-04, -8.658339647724797e-06, -7.335971448244214e-08,
 -5.148993834452035e-10, -2.769877100192728e-12, -7.218037824482123e-15,  6.789233626208343e-17,  1.337284269904595e-18,  1.347876298076178e-20,  9.286125550816032e-23,
  3.397983229457454e-25,  1.988780609972588e+00, -1.729841028309337e-04, -1.979092665539440e-06, -1.984513213103834e-08, -1.832472872114731e-10, -1.588270487051210e-12,
 -1.300832732556765e-14, -1.005892036373049e-16, -7.283340341983374e-19, -4.841081359729743e-21, -2.819074184802160e-23, -1.247153677348202e-25,  8.111000203952589e-04,
 -5.198930260299216e-06,  2.498138804189455e-08, -1.067038843166186e-10,  4.267888823949717e-13, -1.640413326893474e-15,  6.105180549252103e-18, -2.242133478825609e-20,
  7.940911382571748e-23, -2.917895981922378e-25,  9.235449352790907e-28, -4.208201516307634e-30,  7.301513991008509e-03, -4.674019456260339e-05,  2.238628421368045e-07,
 -9.504931499076092e-10,  3.765674109318958e-12, -1.427429328535745e-14,  5.210684726573172e-17, -1.866091467896964e-19,  6.383807693425890e-22, -2.261584676149907e-24,
  6.636847386323417e-27, -3.046598381459711e-29,  2.029092089965725e-02, -1.295524967331216e-04,  6.164219743989721e-07, -2.585453680186972e-09,  1.004255792585618e-11,
 -3.696333099619796e-14,  1.293283864647896e-16, -4.372249733554455e-19,  1.373633638613054e-21, -4.420707984114219e-24,  1.014471544816593e-26, -4.935891221063961e-29,
  3.979634014841188e-02, -2.530826800342045e-04,  1.192095189557599e-06, -4.905751339362058e-09,  1.846271840438783e-11, -6.470567964690286e-14,  2.099756292227857e-16,
 -6.341889455705706e-19,  1.634442781107499e-21, -3.967581836116739e-24,  2.121660293160621e-28, -1.960160837584604e-29,  6.584293520218192e-02, -4.164684670879938e-04,
  1.934642655701664e-06, -7.751226507278095e-09,  2.785361517787410e-11, -9.040671768488740e-14,  2.568858116179023e-16, -6.059295652823952e-19,  7.225826445305856e-22,
  1.527184503966106e-24, -2.976024499265160e-26,  6.623109109563966e-29,  9.846351828886224e-02, -6.184971550314585e-04,  2.821663259528498e-06, -1.090596976680108e-08,
  3.669396625306394e-11, -1.054233496695065e-13,  2.292377994239557e-16, -1.951406290738134e-19, -1.802535905338902e-21,  1.236962940978976e-23, -7.302644673802974e-26,
  1.448273789842479e-28,  1.376977879482920e-01, -8.575465920594525e-04,  3.823929785742712e-06, -1.409693780127445e-08,  4.316271524221617e-11, -1.003828151263829e-13,
  9.056204366914558e-17,  6.822188535412399e-19, -5.775713831535073e-21,  2.510658545800424e-23, -1.040311542733154e-25,  7.771014445684964e-29,  1.835911949699178e-01,
 -1.131504647234005e-03,  4.904532429327912e-06, -1.699321080208963e-08,  4.521834048845981e-11, -6.635843104913696e-14, -1.807733815730609e-16,  1.969073152258090e-18,
 -1.010906837910486e-20,  3.172956512345103e-23, -8.143912180269809e-26, -2.915247776206206e-28,  2.361932816349063e-01, -1.437661903044905e-03,  6.017822252068695e-06,
 -1.920688172516323e-08,  4.072382720805897e-11,  3.496458965390994e-15, -5.786764933435753e-16,  3.400083650328745e-18, -1.262989209686681e-20,  2.071960828106472e-23,
  3.475406713088745e-26, -1.001617656840172e-27,  2.955552663749414e-01, -1.772570415780908e-03,  7.108157817237139e-06, -2.029718412923475e-08,  2.763907689792919e-11,
  1.117484729176337e-13, -1.054742507543137e-15,  4.453736921578408e-18, -1.026324969849192e-20, -1.887720357010789e-23,  2.485944462194489e-25, -1.782027147037029e-27,
  3.617265391681507e-01, -2.131858994158550e-03,  8.108485074494738e-06, -1.978043661612492e-08,  4.310666860986331e-12,  2.538366924273693e-13, -1.503949428588791e-15,
  4.356510075933135e-18,  1.779440373754348e-22, -8.934619979398992e-23,  4.801497193393287e-25, -1.907937627583653e-27,  4.347495740054067e-01, -2.509992459701024e-03,
  8.938835509780749e-06, -1.714989559073836e-08, -3.010196734682607e-11,  4.145988122710173e-13, -1.755056919788261e-15,  2.192441384377174e-18,  2.029521196375507e-20,
 -1.723706753617784e-22,  5.254615606572133e-25, -3.296664066429165e-28,  5.146525251881308e-01, -2.899958798190445e-03,  9.504933871457960e-06, -1.191192351280038e-08,
 -7.501737532842579e-11,  5.644554162579381e-13, -1.574367964884340e-15, -2.804578058204276e-18,  4.730785590062418e-20, -2.167863324546773e-22,  7.641329887072225e-26,
  3.575465740561406e-27,  6.014384095030699e-01, -3.292864319230681e-03,  9.697306021022766e-06, -3.648308632167597e-09, -1.275952264445992e-10,  6.561178796633556e-13,
 -6.982450274692497e-16, -1.068440998506268e-17,  7.046794285042135e-20, -1.365323161781485e-22, -1.108963100060180e-24,  8.363546737107695e-27,  6.950692164418625e-01,
 -3.677413998114627e-03,  9.391643002895951e-06,  7.880650496105333e-09, -1.816568044537955e-10,  6.238515515710038e-13,  1.081126137948895e-15, -1.988535787579911e-17,
  6.835223725863798e-20,  1.593035348342760e-22, -2.786833605707610e-24,  8.512084333145581e-27,  7.954424243566899e-01, -4.039254949751762e-03,  8.451835392487868e-06,
  2.257184678186855e-08, -2.264479289793127e-10,  3.894649535307197e-13,  3.744320019642488e-15, -2.614202731507931e-17,  1.152330326237408e-20,  6.717466596295220e-22,
 -3.602155210841936e-24, -5.185740690895598e-27,  9.023560650994407e-01, -4.360172386001723e-03,  6.738247998985043e-06,  3.972863057274811e-08, -2.455877351906902e-10,
 -1.173529723641260e-13,  6.762494274373079e-15, -2.186539844349639e-17, -1.206084584306877e-19,  1.134623869640343e-21, -8.466291860336962e-25, -3.634402755224025e-26,
  1.015456432175039e+00, -4.617165249960105e-03,  4.125756915014361e-06,  5.770208849797578e-08, -2.171284858130656e-10, -9.125074989372146e-13,  8.741830378670360e-15,
  2.175797692393871e-18, -2.975932704167167e-19,  8.463347628744224e-22,  7.655909500200901e-24, -5.891810932790098e-26,  1.134159461897470e+00, -4.781527830942693e-03,
  5.391206592127507e-07,  7.343572264312813e-08, -1.168017829668279e-10, -1.872212069414897e-12,  7.238723220575793e-15,  4.935284879128484e-17, -3.743211392156791e-19,
 -1.082519137471580e-21,  1.709602927875458e-23,  1.365135652079767e-27,  1.257532486139567e+00, -4.818297279086422e-03, -3.982776903000567e-06,  8.203815897993905e-08,
  7.163060924291292e-11, -2.614481539986852e-12, -5.337685659724002e-16,  1.004402177220591e-16, -7.981402781844384e-20, -4.242012411943583e-21,  7.840118215124894e-24,
  1.818610602750202e-25,  1.384117767836918e+00, -4.686937338944800e-03, -9.179826475599780e-06,  7.680639158348908e-08,  3.334810042889960e-10, -2.428949733284432e-12,
 -1.475124130896119e-14,  9.529246696306733e-17,  7.181824910779418e-19, -4.243260377315430e-21, -3.792367933149610e-23,  1.967692628828427e-25,  1.511675423533957e+00,
 -4.345147233019852e-03, -1.441566123779013e-05,  5.074202989252080e-08,  5.864886643157471e-10, -5.245579892208831e-13, -2.711918348594484e-14, -4.085957127069687e-17,
  1.279374288633726e-18,  5.229183011871173e-21, -5.875231065195964e-23, -4.454277831449688e-25,  1.636829796580998e+00, -3.759409010583095e-03, -1.851836067423828e-05,
  1.408073595004384e-09,  6.550649924661070e-10,  2.939220205275132e-12, -1.838814872810196e-14, -2.433787329693847e-16, -1.203900868030198e-19,  1.384705973106892e-20,
  7.419869355841465e-23, -5.227029285606292e-25,  1.754644221733487e+00, -2.927726129570891e-03, -1.980484322777576e-05, -5.971077235715253e-08,  3.456434275379310e-10,
  5.253521779586504e-12,  1.966031941409337e-14, -1.606376938692700e-16, -2.437278562205085e-18, -8.252913453353081e-21,  1.004283092245940e-22,  1.358328974841738e-24,
  1.858274020149147e+00, -1.918134241777831e-03, -1.673078810822708e-05, -9.970702099575061e-08, -2.614406676989745e-10,  2.405815940151658e-12,  3.910544298338231e-14,
  2.568225296400277e-16,  1.431787353875110e-19, -1.622885257074113e-20, -1.878457444472748e-22, -8.787119123837423e-25,  1.939104973303758e+00, -9.104069999748871e-04,
 -9.589943181708380e-06, -8.204995794241878e-08, -5.718482853577384e-10, -2.914987886870786e-12, -4.639731285199840e-15,  1.191932909983314e-16,  1.892659404538489e-18,
  1.745443814428015e-20,  1.046897190620114e-22,  1.689083747275238e-25,  1.988055426153862e+00, -1.898217830914495e-04, -2.235931931628503e-06, -2.304918199570534e-08,
 -2.183771554751444e-10, -1.937071052483660e-12, -1.617893262286807e-14, -1.269127608627364e-16, -9.242370298095723e-19, -6.078624131586490e-21, -3.364967162282262e-23,
 -1.193474437678978e-25,  7.906960527309537e-04, -5.004087298579578e-06,  2.374085570723791e-08, -1.001299755821042e-10,  3.953964513108758e-13, -1.501144878952408e-15,
  5.511428038167852e-18, -2.004154424844452e-20,  6.952530703935348e-23, -2.585245811824482e-25,  7.396497958044211e-28, -4.218862030513697e-30,  7.118064198711592e-03,
 -4.499391249747788e-05,  2.128092233619934e-07, -8.924600396898722e-10,  3.492282274696182e-12, -1.308419470198878e-14,  4.715589611993918e-17, -1.674350276662101e-19,
  5.614178438746305e-22, -2.023113239121602e-24,  5.276109271259098e-27, -3.195119563529973e-29,  1.978238095345861e-02, -1.247425462477244e-04,  5.863367551202276e-07,
 -2.430522316991933e-09,  9.333363548751600e-12, -3.400153461093373e-14,  1.176780832986998e-16, -3.957410948381919e-19,  1.221247150349658e-21, -4.060854092280098e-24,
  7.772194971515132e-27, -5.984589785874688e-29,  3.880271707642470e-02, -2.437764693258949e-04,  1.134956759396323e-06, -4.620432878253310e-09,  1.721759060640517e-11,
 -5.987357385630774e-14,  1.929290959806241e-16, -5.841726629619315e-19,  1.491476132462278e-21, -3.985152650081695e-24, -1.332060010279849e-27, -5.290716130325721e-29,
  6.420743704042658e-02, -4.013559438017214e-04,  1.844243285676380e-06, -7.319704481033541e-09,  2.610577286038895e-11, -8.444239497346417e-14,  2.402501556932222e-16,
 -5.821523873807211e-19,  7.566709771537657e-22,  3.766351879538259e-25, -2.825989778568063e-26, -1.692657692591169e-30,  9.603386130883586e-02, -5.964375130562866e-04,
  2.694245626629678e-06, -1.033543708653946e-08,  3.464004174035238e-11, -9.999333611634020e-14,  2.230293155080644e-16, -2.462497024766974e-19, -1.408508140482027e-21,
  9.549678125505152e-24, -6.868497262902153e-26,  4.641274493707773e-29,  1.343277294636727e-01, -8.276202183133089e-04,  3.658844299530889e-06, -1.342227138552097e-08,
  4.117823660582270e-11, -9.800017895227667e-14,  1.072068347060300e-16,  5.110595737480507e-19, -4.946172515071392e-21,  2.098903444308811e-23, -1.025648403414113e-25,
 -2.146402649439196e-29,  1.791423746448716e-01, -1.093071864835155e-03,  4.704910349903886e-06, -1.628055233051970e-08,  4.385206759047574e-11, -7.007090567220605e-14,
 -1.300011050778181e-16,  1.663204991358980e-18, -9.028600311058152e-21,  2.820659808883081e-23, -9.509927610366022e-26, -3.457754122922548e-28,  2.305374750947216e-01,
 -1.390430177900697e-03,  5.791249108596575e-06, -1.855546409449711e-08,  4.066235234406890e-11, -9.294321765077303e-15, -4.890187900271446e-16,  3.008044600806299e-18,
 -1.186945671076173e-20,  2.124064767823892e-23, -8.623759813853520e-27, -9.918379306514412e-28,  2.885771834772464e-01, -1.716671739122634e-03,  6.867314372055347e-06,
 -1.983841280293943e-08,  2.963081500325958e-11,  8.789343332929037e-14, -9.347251754498049e-16,  4.116206059562142e-18, -1.078265341083891e-20, -1.049404234102265e-23,
  1.705268884975815e-25, -1.788519219923892e-27,  3.533273377877112e-01, -2.067939028722642e-03,  7.871694951923415e-06, -1.967277177685649e-08,  9.036324594513232e-12,
  2.192034933423104e-13, -1.382345513464366e-15,  4.314279197910025e-18, -2.713690990235119e-21, -7.189123811841573e-23,  3.906881529260359e-25, -2.172276938865142e-27,
  4.248513113957972e-01, -2.439312542916164e-03,  8.730413255733048e-06, -1.756745773219380e-08, -2.222587683422702e-11,  3.732819042942456e-13, -1.685480494760849e-15,
  2.746615459812503e-18,  1.446236452792012e-20, -1.518991225017994e-22,  4.917636842263511e-25, -1.204314911786579e-27,  5.032038359386730e-01, -2.824510659759673e-03,
  9.355154945972358e-06, -1.302396534129040e-08, -6.411162250953093e-11,  5.258921290831387e-13, -1.632869630810167e-15, -1.414726504193377e-18,  3.959213512534031e-20,
 -2.110611935977935e-22,  1.979241264528955e-25,  1.936923673977100e-27,  5.884217841612753e-01, -3.215494704881370e-03,  9.641706997091889e-06, -5.585861098301373e-09,
 -1.146633833259890e-10,  6.360200189538858e-13, -9.666347850780020e-16, -8.515947512810041e-18,  6.483876179810717e-20, -1.740044321891846e-22, -7.772024577343964e-25,
  6.638589225634659e-27,  6.805103571712872e-01, -3.601951037026387e-03,  9.469187557902212e-06,  5.075182860152941e-09, -1.689641060298505e-10,  6.433688085869716e-13,
  5.556709878327921e-16, -1.762709715859274e-17,  7.217263430528391e-20,  5.549246552043511e-23, -2.401775667704503e-24,  8.778820565632301e-27,  7.794222632472587e-01,
 -3.970617789325970e-03,  8.701230737968276e-06,  1.901562905795727e-08, -2.178189767046830e-10,  4.706079225672177e-13,  3.020940809623382e-15, -2.541451553349926e-17,
  3.307194919571703e-20,  5.246449936003277e-22, -3.717636847276052e-24, -3.469436708585020e-28,  8.850261124293487e-01, -4.304426349754632e-03,  7.191365668491872e-06,
  3.578905310221392e-08, -2.463634816009755e-10,  3.720142965920932e-14,  6.102307063741575e-15, -2.508085395856420e-17, -8.073627877499460e-20,  1.071054127453888e-21,
 -2.274831980078624e-24, -2.853630627342142e-26,  9.970580835318872e-01, -4.581449866265320e-03,  4.796772323712404e-06,  5.409343260559600e-08, -2.332810964628800e-10,
 -7.030184606088972e-13,  8.674402903308464e-15, -6.805744779997047e-18, -2.622493624344974e-19,  1.099524563463664e-21,  4.983768585922339e-24, -6.166022824053871e-26,
  1.115047509095346e+00, -4.773724503270722e-03,  1.407932500398143e-06,  7.127722455203671e-08, -1.524039294779234e-10, -1.683284999044433e-12,  8.447987110159792e-15,
  3.688251949620738e-17, -4.010622468878463e-19, -4.077376381789484e-22,  1.639792304303502e-23, -3.224597177754827e-26,  1.238201829759648e+00, -4.846206152967793e-03,
 -2.993167672952595e-06,  8.276618486285955e-08,  1.943859115034751e-11, -2.593971245186846e-12,  2.220362446632326e-15,  9.551836980528231e-17, -2.250425523376364e-19,
 -3.778457745577191e-21,  1.505469407948616e-23,  1.431131986140852e-25,  1.365229101580664e+00, -4.756602349409458e-03, -8.227798429178349e-06,  8.173517207561860e-08,
  2.815906207762511e-10, -2.748515473102484e-12, -1.178625214436765e-14,  1.155559883870336e-16,  5.404529582561393e-19, -5.560426815776198e-21, -2.733235919897998e-23,
  2.792346817980521e-25,  1.494068264285418e+00, -4.457878409238417e-03, -1.375091558496192e-05,  6.000625213705111e-08,  5.694208160635595e-10, -1.184364173387540e-12,
 -2.766523653233007e-14,  2.602716286276673e-18,  1.420941498077953e-18,  2.525690572083766e-21, -7.533508807307896e-23, -2.964517907870456e-25,  1.621496231006349e+00,
 -3.907305830449944e-03, -1.843672167438660e-05,  1.233309185403986e-08,  7.088840333128175e-10,  2.416173908684776e-12, -2.517795536121039e-14, -2.387337801620384e-16,
  4.250273955743618e-19,  1.625018260956015e-20,  4.340417420193267e-23, -8.720420137623710e-25,  1.742612045159772e+00, -3.088928833786306e-03, -2.048464492473875e-05,
 -5.331596802608338e-08,  4.550214111018379e-10,  5.662338115940973e-12,  1.403211509888604e-14, -2.424897118731175e-16, -2.647329518875821e-18, -3.006013898433025e-21,
  1.623608468324069e-22,  1.417419676306033e-24,  1.850326117698896e+00, -2.056833595220855e-03, -1.795061095761534e-05, -1.034517008025598e-07, -2.033563787761583e-10,
  3.430563202674745e-12,  4.626203272274108e-14,  2.505353232606527e-16, -5.848858467361752e-19, -2.442978011683419e-20, -2.194429396848548e-22, -4.978889781780017e-25,
  1.935303444942750e+00, -9.912249500724413e-04, -1.063138018897637e-05, -9.167071320916730e-08, -6.309533082913612e-10, -2.978838874055851e-12, -3.541244416010197e-16,
  1.906294070972553e-16,  2.597330265706351e-18,  2.169267532248942e-20,  1.042836662048107e-22, -2.368918189459613e-25,  1.987258524453763e+00, -2.088780855343732e-04,
 -2.534836581045310e-06, -2.687551619913366e-08, -2.613075232925486e-10, -2.371561897294752e-12, -2.018135497343141e-14, -1.602592104966101e-16, -1.168485533445959e-18,
 -7.520697530782252e-21, -3.814331880793293e-23, -7.607062475671690e-26,  7.710520962314343e-04, -4.818861379891508e-06,  2.257628607356156e-08, -9.403681502026269e-11,
  3.666521057495182e-13, -1.375361565897347e-15,  4.980051581429199e-18, -1.796030342162931e-20,  6.070529378969452e-23, -2.327630937626281e-25,  5.445077325510597e-28,
 -4.762015337639788e-30,  6.941426984641895e-03, -4.333334638794779e-05,  2.024265213328372e-07, -8.386170614644723e-10,  3.241546264364979e-12, -1.200674718746440e-14,
  4.270855556719591e-17, -1.505970620039167e-19,  4.920340905133785e-22, -1.841542344517551e-24,  3.758958451371332e-27, -3.796989457060846e-29,  1.929261095395950e-02,
 -1.201660293068444e-04,  5.580445361698900e-07, -2.286478983244712e-09,  8.680700312560361e-12, -3.130594665797286e-14,  1.071228705082249e-16, -3.589456904125150e-19,
  1.079970536306033e-21, -3.808013737121558e-24,  4.710890356910612e-27, -8.180844256412904e-29,  3.784542584796660e-02, -2.349140022447946e-04,  1.081125736963618e-06,
 -4.354285086823231e-09,  1.606512451714861e-11, -5.543429744675072e-14,  1.772187715266499e-16, -5.387565064958135e-19,  1.346367554243922e-21, -4.098855624597068e-24,
 -4.743422016074630e-27, -1.067837696351831e-28,  6.263097471817482e-02, -3.869463689055376e-04,  1.758858253910299e-06, -6.915215105041132e-09,  2.447327884200401e-11,
 -7.886925361968072e-14,  2.242893520820504e-16, -5.579418153760523e-19,  7.496288610877227e-22, -7.817364368796490e-25, -3.039076178359374e-26, -1.026810007372717e-28,
  9.369044679717314e-02, -5.753703770444136e-04,  2.573480765454742e-06, -9.796906954291533e-09,  3.269311851637349e-11, -9.472816684906828e-14,  2.155512267052405e-16,
 -2.863498750772678e-19, -1.114031759458050e-21,  6.803663807415295e-24, -6.971246791975850e-26, -1.048693569400434e-28,  1.310747856238092e-01, -7.989826804923476e-04,
  3.501665938880381e-06, -1.277895527857605e-08,  3.924503217549328e-11, -9.527271448502168e-14,  1.194085415192844e-16,  3.640754588959131e-19, -4.265049822689578e-21,
  1.682130357710019e-23, -1.071521958568025e-25, -2.051035144492127e-28,  1.748441451266299e-01, -1.056202228318285e-03,  4.513706766378954e-06, -1.559028485732156e-08,
  4.242305651769554e-11, -7.266383149744598e-14, -8.732894187530359e-17,  1.389770544788614e-18, -8.085664602836709e-21,  2.405630628330304e-23, -1.137300216605321e-25,
 -5.275636250100180e-28,  2.250670197442535e-01, -1.344979805279891e-03,  5.572479001825978e-06, -1.790696335556317e-08,  4.036570481059572e-11, -2.006228766823139e-14,
 -4.099970801754322e-16,  2.640303025929417e-18, -1.112178499638280e-20,  1.999097107326069e-23, -5.501734732430025e-26, -1.152445501065271e-27,  2.818188773759656e-01,
 -1.662677282508340e-03,  6.632152143420464e-06, -1.935143721441678e-08,  3.117348235459037e-11,  6.680377842604146e-14, -8.243503436888036e-16,  3.766277069811885e-18,
 -1.105695577693568e-20, -5.286409867828660e-24,  8.845038391084436e-26, -1.983684933556124e-27,  3.451800375561241e-01, -2.005906982591086e-03,  7.636628124773641e-06,
 -1.949487973716738e-08,  1.309835583949642e-11,  1.874646978257124e-13, -1.263130114050017e-15,  4.188854745792842e-18, -5.044466939596561e-21, -5.828291147478386e-23,
  2.866572659088765e-25, -2.597097547172023e-27,  4.152324049049320e-01, -2.370317967037424e-03,  8.517709398929172e-06, -1.786551749817550e-08, -1.515827542683625e-11,
  3.338006112197792e-13, -1.602891813464649e-15,  3.125593826549586e-18,  9.332821712665039e-21, -1.335625149356466e-22,  4.179418429775581e-25, -2.186531527096026e-27,
  4.920544623749333e-01, -2.750311223423950e-03,  9.193052806885326e-06, -1.396774880462525e-08, -5.398816692306957e-11,  4.863641124608344e-13, -1.655875248245577e-15,
 -2.676849271871309e-19,  3.215236949936853e-20, -2.019487666538465e-22,  2.446854890616464e-25,  1.462577970258793e-28,  5.757136053613181e-01, -3.138659400502149e-03,
  9.564084457731778e-06, -7.320049450038374e-09, -1.021931030568695e-10,  6.101878935972442e-13, -1.177014907239328e-15, -6.546798576814551e-18,  5.807985501374780e-20,
 -1.998687424229374e-22, -5.323310882899030e-25,  4.394811079084505e-27,  6.662543821500369e-01, -3.525998904208483e-03,  9.514295721438596e-06,  2.475257670593884e-09,
 -1.560019928366127e-10,  6.510443854134051e-13,  9.461806497955439e-17, -1.530340606242683e-17,  7.253243703539293e-20, -3.306307134979943e-23, -2.033623876246160e-24,
  7.729494527198717e-27,  7.636803743009681e-01, -3.900153700263360e-03,  8.908830371147376e-06,  1.560952242387656e-08, -2.077387442107358e-10,  5.347072390954242e-13,
  2.326785510156219e-15, -2.408268429009000e-17,  4.928826011162346e-20,  3.766447710354089e-22, -3.661147667570703e-24,  2.560185540185065e-27,  8.679260943836915e-01,
 -4.245244453685055e-03,  7.597233076508674e-06,  3.186090346128540e-08, -2.442131427783853e-10,  1.749726312478846e-13,  5.369531081049617e-15, -2.706736984208338e-17,
 -4.409826587710377e-20,  9.571918198454214e-22, -3.364612949755550e-24, -2.118953349906931e-26,  9.788130526281938e-01, -4.540543650856602e-03,  5.423070961159112e-06,
  5.025968215915553e-08, -2.452797855323116e-10, -4.980299959886934e-13,  8.372548573772182e-15, -1.453122033500415e-17, -2.197301646317280e-19,  1.244872531843040e-21,
  2.296845739949545e-24, -5.987905055330301e-26,  1.095980493267079e+00, -4.759083675742933e-03,  2.247554030278884e-06,  6.858077715594399e-08, -1.839659993706307e-10,
 -1.469600138404342e-12,  9.299698980782835e-15,  2.393696497099296e-17, -4.043551492325959e-19,  2.112331052389172e-22,  1.435103422081188e-23, -5.963335368807156e-26,
  1.218775406990283e+00, -4.866177349756929e-03, -1.999807546104440e-06,  8.266595540266131e-08, -3.169603398156550e-11, -2.509523370485420e-12,  4.774504403465993e-15,
  8.626828198841052e-17, -3.488440321036047e-19, -3.065216199433618e-21,  2.021769813379074e-23,  8.972329614251555e-26,  1.346077361785047e+00, -4.818429127935060e-03,
 -7.221804384845927e-06,  8.578662307430114e-08,  2.240629813776451e-10, -2.990796326232801e-12, -8.340014678773516e-15,  1.294617205993274e-16,  3.237104995095947e-19,
 -6.391993889132624e-21, -1.392787015629847e-23,  3.227885308432865e-25,  1.476021512463752e+00, -4.564852585465430e-03, -1.297707440712870e-05,  6.889152954372279e-08,
  5.391266122781622e-10, -1.842254561105726e-12, -2.694638724162206e-14,  4.892394349870022e-17,  1.455003394068136e-18, -6.905653483842294e-22, -8.395560051184570e-23,
 -8.802967830898919e-26,  1.605573234223926e+00, -4.054011350849111e-03, -1.821918950990815e-05,  2.402675408841938e-08,  7.506336280512340e-10,  1.733775893615391e-12,
 -3.158221596534821e-14, -2.155182888190410e-16,  1.031206080878435e-18,  1.712898937992454e-20, -1.504603527338888e-24, -1.150948407444042e-24,  1.729924709702749e+00,
 -3.255232680355190e-03, -2.107696479487250e-05, -4.511383501543235e-08,  5.710361895994846e-10,  5.908007396217124e-12,  6.049763683208318e-15, -3.275625038812155e-16,
 -2.623977642534059e-18,  4.691312546495060e-21,  2.207968085170498e-22,  1.181344033873880e-24,  1.841803640507347e+00, -2.205453859418574e-03, -1.920908759566751e-05,
 -1.060938510227247e-07, -1.230886149187385e-10,  4.622042854510495e-12,  5.287050813705657e-14,  2.160219421277825e-16, -1.625853007925103e-18, -3.344313753331413e-20,
 -2.253591920967551e-22,  3.090641396440661e-25,  1.931161227837630e+00, -1.080852326224222e-03, -1.179396240841800e-05, -1.022410488577404e-07, -6.901310245710574e-10,
 -2.913144773058006e-12,  6.270070806154397e-15,  2.870123783748643e-16,  3.449089929995689e-18,  2.545727821786779e-20,  7.823033034576374e-23, -1.024689894840800e-24,
  1.986380306867408e+00, -2.305216622518417e-04, -2.884083133426088e-06, -3.146380795522830e-08, -3.139686913550599e-10, -2.914247585899329e-12, -2.523492625849865e-14,
 -2.022821284251957e-16, -1.467256257974666e-18, -9.085187704128714e-21, -3.920276327999814e-23,  4.568480492829427e-26,  7.521308625814186e-04, -4.642667178242983e-06,
  2.148215573468469e-08, -8.838411232216095e-11,  3.403004549612526e-13, -1.261663082377743e-15,  4.503126848521754e-18, -1.614803064459308e-20,  5.266442230267664e-23,
 -2.155115800038366e-25,  3.078241726958034e-28, -6.176297788354758e-30,  6.771269909674261e-03, -4.175332403107083e-05,  1.926665571424705e-07, -7.886191112774020e-10,
  3.011328758511673e-12, -1.103062357524147e-14,  3.870248973917762e-17, -1.358871352002697e-19,  4.280132040998907e-22, -1.727928487435738e-24,  1.822752705662184e-27,
 -5.163122981930076e-29,  1.882070504868278e-02, -1.158091095523755e-04,  5.314199169918895e-07, -2.152460390001190e-09,  8.079496428604847e-12, -2.885182389898118e-14,
  9.753582460273191e-17, -3.265513229770074e-19,  9.453129802139242e-22, -3.702167986750801e-24,  2.744999274475558e-28, -1.241468683461196e-28,  3.692274298489037e-02,
 -2.264697151032334e-04,  1.030380716004038e-06, -4.105886531995846e-09,  1.499777375039015e-11, -5.135733855674680e-14,  1.627142581392129e-16, -4.980808455363933e-19,
  1.194051980359780e-21, -4.406182822769223e-24, -1.129263192601873e-26, -1.991349694016382e-28,  6.111081466031403e-02, -3.732008944747122e-04,  1.678173986712790e-06,
 -6.535974514088726e-09,  2.294847166940872e-11, -7.367110161639279e-14,  2.089968485031051e-16, -5.346498597678838e-19,  6.981397851285058e-22, -2.130127269063304e-24,
 -3.821798408198792e-26, -2.666312264067870e-28,  9.142940878292002e-02, -5.552440321008277e-04,  2.458994803662018e-06, -9.288695281743801e-09,  3.084961810264919e-11,
 -8.965497251925594e-14,  2.070672582717613e-16, -3.186308669059412e-19, -9.209741162551762e-22,  3.858730080525633e-24, -7.933618311937456e-26, -3.532854939501214e-28,
  1.279339252367206e-01, -7.715722119727166e-04,  3.352023631833870e-06, -1.216611949394485e-08,  3.736898421870844e-11, -9.229947310871916e-14,  1.277769259179136e-16,
  2.364333008404411e-19, -3.739546568842264e-21,  1.227113255549495e-23, -1.227411923732505e-25, -5.339429874636901e-28,  1.706903868039507e-01, -1.020829479914322e-03,
  4.330647669416712e-06, -1.492324332849338e-08,  4.095182511385949e-11, -7.432123336558518e-14, -5.191410051649738e-17,  1.143956890469563e-18, -7.307961666054050e-21,
  1.894671349240687e-23, -1.445766279120942e-25, -9.175868350960875e-28,  2.197749147139472e-01, -1.301248561880933e-03,  5.361455643239558e-06, -1.726483226032021e-08,
  3.987184287966581e-11, -2.905464491508106e-14, -3.409465945316793e-16,  2.295390989799534e-18, -1.045485142663144e-20,  1.667178940065855e-23, -1.141222484049138e-25,
 -1.591609279309628e-27,  2.752728240669067e-01, -1.610540360427140e-03,  6.402968255823708e-06, -1.884301271145359e-08,  3.232004845335493e-11,  4.824470153506099e-14,
 -7.238728661008300e-16,  3.409914642255002e-18, -1.120571203260177e-20, -3.619891178612476e-24, -8.976012328993692e-27, -2.515798631984398e-27,  3.372771194571036e-01,
 -1.945745874625825e-03,  7.404065509444969e-06, -1.925691928812462e-08,  1.655389666295693e-11,  1.585369241519001e-13, -1.148403100560152e-15,  3.995839155716698e-18,
 -6.965533033595980e-21, -4.929885497434232e-23,  1.568506080994340e-25, -3.383368448996152e-27,  4.058860534390707e-01, -2.303037465789590e-03,  8.302081614941054e-06,
 -1.805670167112971e-08, -8.859712428247114e-12,  2.964108221991885e-13, -1.511895110318774e-15,  3.350329651335843e-18,  4.799103418807194e-21, -1.191269233553070e-22,
  2.941152530721547e-25, -3.526939532190929e-27,  4.811992250027790e-01, -2.677451212452470e-03,  9.020570960988265e-06, -1.475590102074926e-08, -4.465832924057675e-11,
  4.466427769069588e-13, -1.650045745096723e-15,  6.467343566034361e-19,  2.505447870684268e-20, -1.926396932754168e-22,  2.047564264481796e-25, -2.058467368720637e-27,
  5.633113987546196e-01, -3.062524966518382e-03,  9.466830917348511e-06, -8.859102497009265e-09, -9.028562022561591e-11,  5.799430413957886e-13, -1.335414522209860e-15,
 -4.807146364804651e-18,  5.054062711342742e-20, -2.181055385059802e-22, -4.011125676715888e-25,  1.422376699382827e-27,  6.523027447844072e-01, -3.449807168925968e-03,
  9.529452324379828e-06,  8.337527960624409e-11, -1.429917560915390e-10,  6.484339065563434e-13, -3.016699596125063e-16, -1.301648225183201e-17,  6.995438967858088e-20,
 -1.082359127193343e-22, -1.743487687738019e-24,  5.187815604380827e-27,  7.482234084328925e-01, -3.828189473813424e-03,  9.076563837519847e-06,  1.237406389298408e-08,
 -1.965398198308903e-10,  5.826480599009577e-13,  1.676389781409400e-15, -2.231653227625957e-17,  6.024203608196738e-20,  2.327935638866121e-22, -3.527634695848351e-24,
  3.069996388273684e-27,  8.510690003553684e-01, -4.183003381522189e-03,  7.956256909061566e-06,  2.798823051444521e-08, -2.394870840053256e-10,  2.946181498834505e-13,
  4.596873822752962e-15, -2.795485945080387e-17, -1.226989701898213e-20,  8.057592913448546e-22, -4.166849027442652e-24, -1.569715897728528e-26,  9.607413717989479e-01,
 -4.494814021341719e-03,  6.002346542276114e-06,  4.626628649817380e-08, -2.532678592970068e-10, -3.027239475361408e-13,  7.874069434125277e-15, -2.083289434825481e-17,
 -1.738857252182143e-19,  1.285202574717316e-21, -2.492213733109762e-25, -5.564684535862227e-26,  1.076985258080133e+00, -4.737863558929261e-03,  3.051932525643731e-06,
  6.541451365333524e-08, -2.110792981244086e-10, -1.239815837891567e-12,  9.790684277118966e-15,  1.122453110972142e-17, -3.871101677569885e-19,  7.263303947468727e-22,
  1.125656839210938e-23, -7.986759439739851e-26,  1.199284966138577e+00, -4.878220235632757e-03, -1.012492831810395e-06,  8.176431840345899e-08, -8.055189485914401e-11,
 -2.367306751273940e-12,  7.018297585441178e-15,  7.350246211943417e-17, -4.438436746171877e-19, -2.195201712261259e-21,  2.283753508436448e-23,  2.866133858070629e-26,
  1.326694696151679e+00, -4.872029470447500e-03, -6.172860603293871e-06,  8.888347876464817e-08,  1.625442059757922e-10, -3.146502778195351e-12, -4.605262177611507e-15,
  1.360591473540228e-16,  8.702326371452223e-20, -6.662465618315998e-21,  3.819501582068518e-25,  3.197186293383254e-25,  1.457559907736065e+00, -4.665218770687482e-03,
 -1.209994810800364e-05,  7.718821641140323e-08,  4.959523564695813e-10, -2.467314373620286e-12, -2.493305746247387e-14,  9.443464317825360e-17,  1.369381780088374e-18,
 -4.057984524210612e-21, -8.271171644758840e-23,  1.451579101067742e-25,  1.589067799190371e+00, -4.198405052498970e-03, -1.785780217243223e-05,  3.627113569564096e-08,
  7.772622980513298e-10,  9.076842540065758e-13, -3.706271881040165e-14, -1.727673892862203e-16,  1.634070613237094e-18,  1.600449537115140e-20, -5.567385551080300e-23,
 -1.280929848308364e-24,  1.716563350055564e+00, -3.425849525692897e-03, -2.155959542765960e-05, -3.502737239136925e-08,  6.898572239740274e-10,  5.933871777599840e-12,
 -4.259438884574873e-15, -4.070299413869684e-16, -2.284927185855822e-18,  1.441017595392104e-20,  2.606432599850174e-22,  5.628184423328794e-25,  1.832666379108122e+00,
 -2.364245061983077e-03, -2.049075110943120e-05, -1.072528629545106e-07, -1.750422609472592e-11,  5.956465710817407e-12,  5.799759500048751e-14,  1.430384877943788e-16,
 -2.985660246215931e-18, -4.183455306705551e-20, -1.845690929206994e-22,  1.632568173962821e-24,  1.926641074050813e+00, -1.180303671820462e-03, -1.308899573386136e-05,
 -1.137381044633074e-07, -7.461700383764296e-10, -2.652889149939701e-12,  1.599308179302613e-14,  4.125422874705649e-16,  4.407900879841847e-18,  2.733417761469737e-20,
  5.785918472252927e-24, -2.377118914664158e-24,  1.985409556953290e+00, -2.551946429938970e-04, -3.293825319199570e-06, -3.698851812949571e-08, -3.787975426572889e-10,
 -3.593471076063494e-12, -3.160744273233543e-14, -2.547624000855579e-16, -1.821485099285833e-18, -1.054682813256827e-20, -3.189133682111198e-23,  3.206911545146738e-25,
  7.338973193618100e-04, -4.474961688360237e-06,  2.045340114207469e-08, -8.313544945274874e-11,  3.161122740607690e-13, -1.158830439449826e-15,  4.073422974911329e-18,
 -1.458509857230420e-20,  4.505599457469643e-23, -2.093305853622290e-25, -1.877476142266542e-29, -8.928747488312814e-30,  6.607280478062008e-03, -4.024904265482243e-05,
  1.834850951664517e-07, -7.421535493994081e-10,  2.799704448783278e-12, -1.014593129462557e-14,  3.508012110752534e-17, -1.231767425691926e-19,  3.665150957475280e-22,
 -1.706966258687078e-24, -9.603825806881845e-28, -7.719186869701769e-29,  1.836581078788545e-02, -1.116589137357705e-04,  5.063473854069170e-07, -2.027680601100988e-09,
  7.525145072921130e-12, -2.661739045890311e-14,  8.879579952342367e-17, -2.984434222659628e-19,  8.107456861822893e-22, -3.819675448171048e-24, -6.693291280441240e-27,
 -1.989235370980939e-28,  3.603304382649024e-02, -2.184197492421486e-04,  9.825166425884587e-07, -3.873931812726746e-09,  1.400857043349563e-11, -4.761538398383449e-14,
  1.492783514600767e-16, -4.625157698572205e-19,  1.024829974156522e-21, -5.073353694334606e-24, -2.319189695894705e-26, -3.540634607923835e-28,  5.964437379891557e-02,
 -3.600830976079340e-04,  1.601897591899433e-06, -6.180318857210823e-09,  2.152400900053778e-11, -6.883237717767617e-14,  1.943256348702241e-16, -5.138583424076467e-19,
  5.904908478584876e-22, -3.963245478679406e-24, -5.538012819657810e-26, -5.338501113697114e-28,  8.924708229930986e-02, -5.360096744855138e-04,  2.350433717559866e-06,
 -8.809179263858312e-09,  2.910547539046770e-11, -8.479564293831390e-14,  1.977493086546395e-16, -3.465283828231959e-19, -8.438696391978357e-22,  2.684543398407898e-25,
 -1.031274240119214e-25, -7.591289164002658e-28,  1.249003583079554e-01, -7.453299714925167e-04,  3.209557248044189e-06, -1.158281502858153e-08,  3.555412916949808e-11,
 -8.916653447667116e-14,  1.327810906944747e-16,  1.228341685597866e-19, -3.393105242235486e-21,  6.746944405005073e-24, -1.575233124372643e-25, -1.091872152119375e-27,
  1.666752406565818e-01, -9.868895886982526e-04,  4.155450882015454e-06, -1.427996279729156e-08,  3.945540150773498e-11, -7.520863965602323e-14, -2.306320009554835e-17,
  9.198099326161265e-19, -6.741315355475649e-21,  1.217423205257943e-23, -1.992104933895704e-25, -1.628034418916304e-27,  2.146544068785161e-01, -1.259174830488058e-03,
  5.158084794893324e-06, -1.663195493305525e-08,  3.921393559221074e-11, -3.650339709793557e-14, -2.812763274162004e-16,  1.969408262125149e-18, -9.955642746332408e-21,
  1.048748599957129e-23, -2.013869709623037e-25, -2.457847261372031e-27,  2.689316905483741e-01, -1.560212220580025e-03,  6.179983698742112e-06, -1.831908498239378e-08,
  3.311873673219762e-11,  3.197683568897637e-14, -6.334368277818833e-16,  3.048945763981057e-18, -1.137153376758625e-20, -6.461186125961008e-24, -1.408389450608537e-25,
 -3.582649228952157e-27,  3.296111441432621e-01, -1.887432948582402e-03,  7.174671538386183e-06, -1.896815098469295e-08,  1.945794396771658e-11,  1.322910601603014e-13,
 -1.039900121788147e-15,  3.745445066605802e-18, -8.666428101951537e-21, -4.636285162325901e-23, -2.029219511398618e-26, -4.793220484615606e-27,  3.968053617483616e-01,
 -2.237489506496938e-03,  8.084739995183180e-06, -1.815297069231924e-08, -3.286679123125588e-12,  2.612645143342194e-13, -1.416566317368262e-15,  3.437219918502061e-18,
  6.801210820800132e-22, -1.110020496787889e-22,  9.737295417312129e-26, -5.557592159018871e-27,  4.706326115685765e-01, -2.606006410124376e-03,  8.839500784140242e-06,
 -1.540111539863985e-08, -3.611957667270336e-11,  4.073432220625447e-13, -1.621745329593948e-15,  1.338873507718164e-18,  1.823777994412783e-20, -1.870721272246695e-22,
  5.182860142609266e-26, -5.056286353072080e-27,  5.512120613694484e-01, -2.987239243802538e-03,  9.352231272125761e-06, -1.021266548457874e-08, -7.901724817149449e-11,
  5.464532826752963e-13, -1.448574489141796e-15, -3.318513661727648e-18,  4.240521044839183e-20, -2.340030915707208e-22, -4.233772257900685e-25, -2.649111069096784e-27,
  6.386559400690941e-01, -3.373605459608277e-03,  9.517151983535404e-06, -2.101256187148174e-09, -1.301237098233602e-10,  6.370691728528352e-13, -6.354713633305490e-16,
 -1.085336452899434e-17,  6.484745184891067e-20, -1.745522303663297e-22, -1.604168793981213e-24,  8.109116631708375e-28,  7.330567417008546e-01, -3.755035568088506e-03,
  9.206575839455837e-06,  9.324628032927638e-09, -1.845339838432423e-10,  6.156076711272133e-13,  1.079582442878656e-15, -2.028169171528207e-17,  6.611126674307345e-20,
  9.390692593627356e-23, -3.434300505520413e-24,  6.464289634391584e-28,  8.344663227201625e-01, -4.118074546230892e-03,  8.269338051986819e-06,  2.420930380101886e-08,
 -2.325549927663170e-10,  3.955315413298076e-13,  3.812764755228484e-15, -2.791683616239360e-17,  1.357993510704536e-20,  6.262174704070598e-22, -4.793545277440034e-24,
 -1.342160983919631e-26,  9.428615717172936e-01, -4.444643750569303e-03,  6.533061160080188e-06,  4.217562360878524e-08, -2.574828793785085e-10, -1.213323393021681e-13,
  7.219762044030352e-15, -2.566359376111867e-17, -1.283758059031174e-19,  1.227585080087045e-21, -2.600942757029390e-24, -5.146863845905972e-26,  1.058087522833835e+00,
 -4.710367416781839e-03,  3.815866386343357e-06,  6.185172341381284e-08, -2.335075144565135e-10, -1.002440670990858e-12,  9.936055067317103e-15, -6.648785960578105e-19,
 -3.537462116820113e-19,  1.101804889107942e-21,  7.415687264045698e-24, -9.383337551572365e-26,  1.179762063801917e+00, -4.882420936612834e-03, -4.058492952094247e-08,
  8.010654086138333e-08, -1.260555162028615e-10, -2.175842397844255e-12,  8.866909962700552e-15,  5.821269628555537e-17, -5.062919721807104e-19, -1.274916986948098e-21,
  2.272236369212578e-23, -3.363848426309991e-26,  1.307114623714715e+00, -4.917106551525280e-03, -5.092747212188295e-06,  9.097603846649134e-08,  9.881815802682020e-11,
 -3.211219365258997e-12, -7.924994664669153e-16,  1.350361553671183e-16, -1.492585249250616e-19, -6.377280434627730e-21,  1.351273628558517e-23,  2.697775604721657e-25,
  1.438711485029021e+00, -4.758182378855021e-03, -1.112780916289647e-05,  8.469715726262100e-08,  4.408612492455181e-10, -3.029183458601357e-12, -2.170182665010823e-14,
  1.352954105126275e-16,  1.165885526074248e-18, -7.172836956538253e-21, -7.146923911393713e-23,  3.588619053498668e-25,  1.571991510634702e+00, -4.339313982045999e-03,
 -1.734749306837110e-05,  4.880270036572907e-08,  7.861618260572550e-10, -3.344776458561300e-14, -4.108522855969655e-14, -1.117985042981942e-16,  2.156594858862162e-18,
  1.265681154143749e-20, -1.111495752409710e-22, -1.203670880729162e-24,  1.702512613072698e+00, -3.599810998242973e-03, -2.190981017001469e-05, -2.304980835228769e-08,
  8.065488486859348e-10,  5.687173081216705e-12, -1.658738682825086e-14, -4.698024427484721e-16, -1.574949477819452e-18,  2.506005578088454e-20,  2.644716093831929e-22,
 -4.485848393046751e-25,  1.822873401466169e+00, -2.533314418338037e-03, -2.177528640808553e-05, -1.065031179936707e-07,  1.158070482345281e-10,  7.384234264292592e-12,
  6.042948695766407e-14,  2.214567298382133e-17, -4.602775000637730e-18, -4.727950045547845e-20, -7.452316014447434e-23,  3.434546929556003e-24,  1.921701499686051e+00,
 -1.290681901150679e-03, -1.452715721644283e-05, -1.260762065836546e-07, -7.943676148063985e-10, -2.113596819786560e-12,  2.966591440233660e-14,  5.691474215926553e-16,
  5.365916707111535e-18,  2.491638447823194e-20, -1.418943633804350e-22, -4.467818287148034e-24,  1.984333113036669e+00, -2.834294697418363e-04, -3.776564223703508e-06,
 -4.366799869912235e-08, -4.588661096694958e-10, -4.444595166485098e-12, -3.961545237543214e-14, -3.193356908720560e-16, -2.219516504772713e-18, -1.140189385122559e-20,
 -6.792697645863475e-24,  8.830085902663043e-25,  7.163185278399457e-04, -4.315240725848811e-06,  1.948537453247368e-08, -7.825789020288938e-11,  2.938810201565855e-13,
 -1.065812947316088e-15,  3.684086587309472e-18, -1.326486271612785e-20,  3.740138424456011e-23, -2.191168959687356e-25, -5.026396377714499e-28, -1.332622583074613e-29,
  6.449164720417077e-03, -3.881603887459623e-05,  1.748414729162500e-07, -6.989370322778234e-10,  2.604932294061680e-12, -9.344127676436948e-15,  3.178603859020270e-17,
 -1.124461557858815e-19,  3.034577830613785e-22, -1.824121161439839e-24, -5.191255544484090e-27, -1.174564257082967e-28,  1.792712542462833e-02, -1.077034562019608e-04,
  4.827204320767243e-07, -1.911424062771499e-09,  7.013445989803523e-12, -2.458376596555795e-14,  8.078144935548003e-17, -2.747702860999155e-19,  6.660314628788287e-22,
 -4.293502682867085e-24, -1.783885982638319e-26, -3.141236268931821e-28,  3.517479596242187e-02, -2.107418256295887e-04,  9.373434761203613e-07, -3.657222826967230e-09,
  1.309105898235464e-11, -4.418457904473387e-14,  1.367581058906645e-16, -4.328566441459705e-19,  8.211718051946714e-22, -6.375767398684105e-24, -4.363320037183825e-26,
 -5.876096822741879e-28,  5.822921019504486e-02, -3.475588206504603e-04,  1.529755448661486e-06, -5.846699348287402e-09,  2.019284459462568e-11, -6.433923149933840e-14,
  1.801773473381823e-16, -4.977252064893220e-19,  4.013155665182978e-22, -6.755969752228948e-24, -8.715638650254905e-26, -9.312829489201639e-28,  8.713999205188694e-02,
 -5.176212558910408e-04,  2.247462553053398e-06, -8.356804449410516e-09,  2.745622059768663e-11, -8.016916582486013e-14,  1.876638123033937e-16, -3.742485705338151e-19,
 -9.179707977198693e-22, -4.688313275260920e-24, -1.491163514022475e-25, -1.362813921302977e-27,  1.219695245195308e-01, -7.201999523096942e-04,  3.073918377725204e-06,
 -1.102804150977682e-08,  3.380288190510928e-11, -8.595060710292962e-14,  1.347275718639456e-16,  1.681775307255331e-20, -3.277248411924058e-21, -7.427936367557521e-25,
 -2.231176632200930e-25, -1.935155607456939e-27,  1.627930992386893e-01, -9.543208024580035e-04,  3.987829334752092e-06, -1.366073150728129e-08,  3.794765519995078e-11,
 -7.547713072014960e-14, -2.746043826493989e-19,  7.094049368398151e-19, -6.466395106954405e-21,  2.475649792445245e-24, -2.937912769213847e-25, -2.734145195155421e-27,
  2.096989878668143e-01, -1.218697877552888e-03,  4.962240642837901e-06, -1.601072118647627e-08,  3.842064315848758e-11, -4.262801974181243e-14, -2.305486801784250e-16,
  1.655080695921939e-18, -9.752478507153531e-21, -1.035133517933977e-25, -3.383316803271557e-25, -3.851069174222564e-27,  2.627883419298637e-01, -1.511642615393449e-03,
  5.963352584275478e-06, -1.778486661961245e-08,  3.361295002546771e-11,  1.775741621461546e-14, -5.532054293697995e-16,  2.679912659073804e-18, -1.174766052423517e-20,
 -1.571069193945387e-23, -3.343079715026853e-25, -5.318817172894402e-27,  3.221747732401488e-01, -1.830940562514775e-03,  6.949004704778270e-06, -1.863697826839938e-08,
  2.186251525338350e-11,  1.085590303214192e-13, -9.391648091906453e-16,  3.440810780548828e-18, -1.040623209059082e-20, -5.198678254926597e-23, -2.770746056885580e-25,
 -7.009047983189845e-27,  3.879833791830939e-01, -2.173683437822041e-03,  7.866755366095488e-06, -1.816556971901652e-08,  1.606427960916085e-12,  2.284206097364068e-13,
 -1.320617847411493e-15,  3.395273266405274e-18, -3.311970764518783e-21, -1.128015032320078e-22, -2.089352411735454e-25, -8.516751034730735e-27,  4.603488343850287e-01,
 -2.536038876425150e-03,  8.651481953779420e-06, -1.591595461287565e-08, -2.835858011024921e-11,  3.689309230299385e-13, -1.577098767987667e-15,  1.814628362324704e-18,
  1.147682346010213e-20, -1.905690800445153e-22, -2.563730078478524e-25, -9.127493058243558e-27,  5.394119346688471e-01, -2.912932276069619e-03,  9.222448090974122e-06,
 -1.139142680565309e-08, -6.844260779517517e-11,  5.107179035972511e-13, -1.523786815682569e-15, -2.099917275249233e-18,  3.363465553629590e-20, -2.547741980833945e-22,
 -6.548926027031212e-25, -8.093827805867571e-27,  6.253135842687222e-01, -3.297603535220730e-03,  9.479862542236489e-06, -4.082232315342533e-09, -1.175582693064981e-10,
  6.183993688399653e-13, -9.113469745128331e-16, -8.891204438535380e-18,  5.740149499218050e-20, -2.397559395060417e-22, -1.702973391359874e-24, -5.625051528002618e-27,
  7.181845436966637e-01, -3.680984628542017e-03,  9.301166457475917e-06,  6.471800544250462e-09, -1.720074842202958e-10,  6.349442354177341e-13,  5.416320504639491e-16,
 -1.813857945472714e-17,  6.701340463646302e-20, -4.433342359587286e-23, -3.519006843459574e-24, -5.008766677124220e-27,  8.181280853817740e-01, -4.050820417995882e-03,
  8.537800850738616e-06,  2.055641617733929e-08, -2.237922765175776e-10,  4.777264222857297e-13,  3.040295682194690e-15, -2.715974665719771e-17,  3.252845181307457e-20,
  4.224240113397435e-22, -5.409764045773779e-24, -1.528365796679518e-26,  9.251906319999283e-01, -4.390424991203053e-03,  7.014400017355557e-06,  3.804564678015769e-08,
 -2.582372170756883e-10,  4.289478312789193e-14,  6.450144188873146e-15, -2.908898909295559e-17, -8.659377605101068e-20,  1.079029124718168e-21, -4.812940245638365e-24,
 -4.956481446977018e-26,  1.039311716189982e+00, -4.676936556665927e-03,  4.535050633342587e-06,  5.796814043585570e-08, -2.511796310879939e-10, -7.654394011647474e-13,
  9.765283578383685e-15, -1.130113399972067e-17, -3.097654912600532e-19,  1.312776758681980e-21,  3.063149742295460e-24, -1.034260471551084e-25,  1.160237766125813e+00,
 -4.878938018732156e-03,  9.071950629822340e-07,  7.775360103437146e-08, -1.673218983678523e-10, -1.945344073197853e-12,  1.026437544563524e-14,  4.144846043375073e-17,
 -5.363467162715238e-19, -4.132418397313426e-22,  1.993603846271358e-23, -9.195875451454420e-26,  1.287371659242298e+00, -4.953459682271308e-03, -3.993667476379975e-06,
  9.204357363549765e-08,  3.470615867797326e-11, -3.185614777440832e-12,  2.888002730239834e-15,  1.267127260392619e-16, -3.664636310251168e-19, -5.623257568218934e-21,
  2.353423615643665e-23,  1.801985552119017e-25,  1.419507310547730e+00, -4.843024255875064e-03, -1.007120783057194e-05,  9.123932933253268e-08,  3.753966980417592e-10,
 -3.500609698469999e-12, -1.743379718328989e-14,  1.679544484040615e-16,  8.604781843517438e-19, -9.665567930327876e-21, -5.206475788433596e-23,  5.097556781951450e-25,
  1.554360705197558e+00, -4.475537964569844e-03, -1.668658730745206e-05,  6.132144385069557e-08,  7.754208261494245e-10, -1.048871455416797e-12, -4.318763172061604e-14,
 -3.645476756212031e-17,  2.520082446156197e-18,  7.224306303497948e-21, -1.582865155692294e-22, -9.037200903419720e-25,  1.687761381238880e+00, -3.775968007724022e-03,
 -2.210530815408185e-05, -9.261272629860759e-09,  9.152201918671088e-10,  5.126432400695185e-12, -3.029758055386072e-14, -5.037847553711386e-16, -4.904351430808975e-19,
  3.487749540139915e-20,  2.169618654390592e-22, -1.740377038852860e-24,  1.812383704885883e+00, -2.712585623994524e-03, -2.303707768763562e-05, -1.033900365806602e-07,
  2.779522968935550e-10,  8.823753957848849e-12,  5.872942943673826e-14, -1.526205655616747e-16, -6.316699325922400e-18, -4.664690430995994e-20,  1.208251478807868e-22,
  5.439526895703468e-24,  1.916296446852594e+00, -1.413169817773527e-03, -1.611758498430262e-05, -1.390798020419851e-07, -8.281252858122140e-10, -1.190198899826588e-12,
  4.813055667667845e-14,  7.536822254680060e-16,  6.106238567042480e-18,  1.451530836258258e-20, -3.991510023993074e-22, -7.345728463888801e-24,  1.983135465808771e+00,
 -3.158699661540419e-04, -4.347740787862014e-06, -5.177583955790520e-08, -5.580330626545032e-10, -5.511067577199017e-12, -4.961276168286033e-14, -3.968888358446051e-16,
 -2.623131325948933e-18, -1.062632816998509e-20,  5.341395501628526e-23,  1.965938643546630e-24,  6.993634940824007e-04, -4.163035762122773e-06,  1.857380421361539e-08,
 -7.372164384629552e-11,  2.734195247082873e-13, -9.817240772246721e-16,  3.328205629085516e-18, -1.219934948514348e-20,  2.899587467781882e-23, -2.524992520589063e-25,
 -1.204704148854399e-27, -1.851164269092982e-29,  6.296645891172101e-03, -3.745016146625155e-05,  1.666982662899529e-07, -6.587127785456275e-10,  2.425428769376870e-12,
 -8.618009731487707e-15,  2.876327475830671e-17, -1.038372289180915e-19,  2.326777195566965e-22, -2.149264020004596e-24, -1.141430509099979e-26, -1.647262873218402e-28,
  1.750389250324881e-02, -1.039315701388119e-04,  4.604407430266737e-07, -1.803039564845922e-09,  6.540546859854480e-12, -2.273507408365829e-14,  7.336187680690411e-17,
 -2.560974845893293e-19,  4.949251734857254e-22, -5.323648004097545e-24, -3.465800391650837e-26, -4.484130637300880e-28,  3.434655314644212e-02, -2.034151297704739e-04,
  8.946849485660794e-07, -3.454661153544558e-09,  1.223922202593263e-11, -4.104508044629755e-14,  1.249687809918192e-16, -4.106438374537112e-19,  5.532615752607894e-22,
 -8.719074502673219e-24, -7.552395431779386e-26, -8.579662247742431e-28,  5.686301427748192e-02, -3.355960224687551e-04,  1.461491853848679e-06, -5.533677875919282e-09,
  1.894818013892949e-11, -6.018101059724722e-14,  1.663789661423139e-16, -4.895357289430489e-19,  8.422580160480951e-23, -1.119883445491052e-23, -1.383619569005059e-25,
 -1.389491390892036e-27,  8.510484169654406e-02, -5.000353342733663e-04,  2.149764567996412e-06, -7.930090897759993e-09,  2.589700982364796e-11, -7.579450147420431e-14,
  1.767392805341516e-16, -4.076050076679945e-19, -1.210459763505301e-21, -1.206054434197413e-23, -2.246261755307993e-25, -2.059453813435350e-27,  1.191370820826803e-01,
 -6.961288864000686e-04,  2.944770797881591e-06, -1.050077186573334e-08,  3.211618093439475e-11, -8.272343587930976e-14,  1.337129109421807e-16, -9.038852401787330e-20,
 -3.487815114448269e-21, -1.166306624267435e-23, -3.301124600667721e-25, -2.914875466122090e-27,  1.590385975032981e-01, -9.230636758258652e-04,  3.827493732938662e-06,
 -1.306563939001470e-08,  3.643953480102532e-11, -7.526874864206764e-14,  1.668754042736135e-17,  5.013797636867960e-19, -6.621318804692160e-21, -1.206977466191261e-23,
 -4.430575520025105e-25, -4.034127410243832e-27,  2.049023900578103e-01, -1.179758083284349e-03,  4.773771303535314e-06, -1.540309689369665e-08,  3.751632216639140e-11,
 -4.764045148817630e-14, -1.885967770775550e-16,  1.339968972315571e-18, -1.004512718126106e-20, -1.751947561925983e-23, -5.446831394851379e-25, -5.508786866239125e-27,
  2.568358463969809e-01, -1.464780303166530e-03,  5.753170479051039e-06, -1.724491487167079e-08,  3.384118495614954e-11,  5.337830138399079e-15, -4.835370854206063e-16,
  2.291862704626838e-18, -1.261596557445605e-20, -3.438189220373730e-23, -6.145611077648729e-25, -7.395780027383350e-27,  3.149607872579481e-01, -1.776236996016364e-03,
  6.727527536772250e-06, -1.827100119389544e-08,  2.381589792541349e-11,  8.713573683060126e-14, -8.477844244960574e-16,  3.075078106593547e-18, -1.255868062250048e-20,
 -7.001973074117136e-23, -6.439106770237479e-25, -9.633069595087403e-27,  3.794131339950887e-01, -2.111620569120902e-03,  7.649068013557044e-06, -1.810500960099000e-08,
  5.865514263561242e-12,  1.978507879629644e-13, -1.227660484434571e-15,  3.221909713487238e-18, -7.622842585380999e-21, -1.296732832387137e-22, -6.597937782891937e-25,
 -1.193043619187637e-26,  4.503418828109578e-01, -2.467598152647786e-03,  8.458004956298924e-06, -1.631270154389133e-08, -2.135416252268456e-11,  3.317253371151124e-13,
 -1.522197978371146e-15,  2.069272499669041e-18,  4.322521610528539e-21, -2.102230281623994e-22, -7.599419045365999e-25, -1.369697645144524e-26,  5.279068737107315e-01,
 -2.839717332926873e-03,  9.079511066702493e-06, -1.240679859734266e-08, -5.859812928951957e-11,  4.735543959203008e-13, -1.568935623890168e-15, -1.176219030476213e-18,
  2.388892026315726e-20, -2.899074739453260e-22, -1.146478316539162e-24, -1.417594312822859e-26,  6.122744937655353e-01, -3.221991626042554e-03,  9.419994232131869e-06,
 -5.865490138503351e-09, -1.054281333366337e-10,  5.937387008675026e-13, -1.135979573180740e-15, -7.206219473187266e-18,  4.746430661780008e-20, -3.150474422764337e-22,
 -2.116860642517005e-24, -1.314343973909027e-26,  7.036098509289669e-01, -3.606310467627539e-03,  9.362736235184386e-06,  3.821809814411683e-09, -1.592185036081374e-10,
  6.420887033434752e-13,  6.333707330575332e-17, -1.604741563435967e-17,  6.281051799675678e-20, -1.917242405832278e-22, -3.907141367971002e-24, -1.269778389421669e-26,
  8.020628858630531e-01, -3.981591424085631e-03,  8.763321226946194e-06,  1.705588424660205e-08, -2.135690134410579e-10,  5.416979910608936e-13,  2.296375930941666e-15,
 -2.591867661874811e-17,  4.366656404942509e-20,  1.912285724019833e-22, -6.186910318470711e-24, -2.025501497282823e-26,  9.077439548945531e-01, -4.332553722092300e-03,
  7.446211792595308e-06,  3.392884334543613e-08, -2.558987317662643e-10,  1.876456790514875e-13,  5.602408582034897e-15, -3.127989051297534e-17, -5.173973403276198e-20,
  8.428611449159624e-22, -6.998445351895108e-24, -4.987822959828759e-26,  1.020680838468675e+00, -4.637943083068348e-03,  5.206090791298528e-06,  5.383940279092897e-08,
 -2.641759832535729e-10, -5.359455974588650e-13,  9.317298042721009e-15, -2.044285102786430e-17, -2.614157465967347e-19,  1.342269868408040e-21, -1.629702610228779e-24,
 -1.089888614962670e-25,  1.140742370407254e+00, -4.867996665081353e-03,  1.822935796667803e-06,  7.477893992743984e-08, -2.036813868378155e-10, -1.687020266388423e-12,
  1.118345938550489e-14,  2.419239860402602e-17, -5.379853385012423e-19,  2.879906439845874e-22,  1.477024200299187e-23, -1.405692139325527e-25,  1.267500924126378e+00,
 -4.980986302255987e-03, -2.887899874784098e-06,  9.209411990108434e-08, -2.803324919034701e-11, -3.075232576042869e-12,  6.242726038321448e-15,  1.119421678669805e-16,
 -5.503388305500764e-19, -4.555782797637517e-21,  2.900774024595161e-23,  6.643003354391667e-26,  1.399981145348959e+00, -4.919117783284843e-03, -8.942677343995090e-06,
  9.666449593373580e-08,  3.015959809556310e-10, -3.859811415747901e-12, -1.240049192814283e-14,  1.895659204256440e-16,  4.806726889384260e-19, -1.127502072845645e-20,
 -2.797595297037977e-23,  5.690674823570059e-25,  1.536196523569554e+00, -4.605878280477934e-03, -1.587716480942313e-05,  7.350386049583813e-08,  7.440436361597879e-10,
 -2.088315966182093e-12, -4.304939563569725e-14,  4.705696805971576e-17,  2.657785315959738e-18,  2.291726864165229e-22, -1.879285818899971e-22, -4.187558719757808e-25,
  1.672303481786263e+00, -3.952998562541688e-03, -2.212533996652065e-05,  6.158159055874871e-09,  1.009330799493842e-09,  4.229461274080666e-12, -4.442355506313831e-14,
 -4.978879600853859e-16,  8.992853747670254e-19,  4.162731893453838e-20,  1.108992626586916e-22, -3.056470243969179e-24,  1.801157036536507e+00, -2.901755463515261e-03,
 -2.424500795711708e-05, -9.745629935634371e-08,  4.680518252825381e-10,  1.015763245615788e-11,  5.138324229377119e-14, -3.801900325797280e-16, -7.846403043135486e-18,
 -3.649706204336963e-20,  3.985131901588707e-22,  7.051554283546023e-24,  1.910374996330551e+00, -1.549012942310695e-03, -1.786660429191456e-05, -1.524498989200181e-07,
 -8.385528713709555e-10,  2.406077947770807e-13,  7.202189535742486e-14,  9.536710235688655e-16,  6.254655222143641e-18, -8.891236833336411e-21, -7.957534235144635e-22,
 -1.070456563054286e-23,  1.981798261245685e+00, -3.532977343576306e-04, -5.026479649672020e-06, -6.165478779159599e-08, -6.811120732466590e-10, -6.844947774672860e-12,
 -6.195426285819607e-14, -4.863396071139010e-16, -2.941929263110271e-18, -6.256352685953546e-21,  1.795427259168658e-22,  3.960800298553147e-24,  6.830030321169419e-04,
 -4.017911061801105e-06,  1.771475856925102e-08, -6.949978168578072e-11,  2.545566492813304e-13, -9.058500468753615e-16,  2.998171591902939e-18, -1.142788237768685e-20,
  1.883236712101456e-23, -3.179738509646529e-25, -2.081531433771171e-27, -2.004092432694040e-29,  6.149463269791768e-03, -3.614754669321874e-05,  1.590209850522746e-07,
 -6.212482668250685e-10,  2.259740290113688e-12, -7.961814090150494e-15,  2.594772666238119e-17, -9.773243289225113e-20,  1.452491244398568e-22, -2.759910302556651e-24,
 -1.923389850094946e-26, -1.789448380055291e-28,  1.709539871035227e-02, -1.003328450127376e-04,  4.394174588894889e-07, -1.701935171274075e-09,  6.102879859199181e-12,
 -2.105883578713044e-14,  6.638192210600678e-17, -2.436342189004981e-19,  2.733081256744048e-22, -7.130634423388513e-24, -5.602978410358403e-26, -4.901623258604865e-28,
  3.354694965120669e-02, -1.964202061979872e-04,  8.543774075495009e-07, -3.265241731980914e-09,  1.144739061081350e-11, -3.818211821188275e-14,  1.136668245380034e-16,
 -3.986221120536529e-19,  1.753794486462298e-22, -1.254791756312498e-23, -1.166210604369716e-25, -9.451547886792196e-28,  5.554360065499573e-02, -3.241646403597185e-04,
  1.396867715216916e-06, -5.239923657290763e-09,  1.778338045608753e-11, -5.635250863972146e-14,  1.526407520197656e-16, -4.944848553026913e-19, -4.341737403733955e-22,
 -1.804632569093821e-23, -2.052358830152511e-25, -1.541915354579868e-27,  8.313850370005216e-02, -4.832109318357272e-04,  2.057040301537412e-06, -7.527639357725501e-09,
  2.442258820938330e-11, -7.169455879482451e-14,  1.647053458183449e-16, -4.552072367583255e-19, -1.829562540501820e-21, -2.299585835472591e-23, -3.240293811712954e-25,
 -2.295465692859073e-27,  1.163988969794407e-01, -6.730661460773776e-04,  2.821790653287998e-06, -9.999975452203832e-09,  3.049353113507672e-11, -7.955779403814021e-14,
  1.295366821731619e-16, -2.115289527451156e-19, -4.178183945447332e-21, -2.762707154605823e-23, -4.707496806842726e-25, -3.247118442038931e-27,  1.554066035532757e-01,
 -8.930610793448059e-04,  3.674154660704613e-06, -1.249462373646220e-08,  3.493917605021835e-11, -7.472425946825884e-14,  2.766801691966128e-17,  2.787604108434559e-19,
 -7.420140706759382e-21, -3.359968054198825e-23, -6.369201297134898e-25, -4.467279308458915e-27,  2.002585817390231e-01, -1.142297131017966e-03,  4.592503501670836e-06,
 -1.481069204749619e-08,  3.652109817684833e-11, -5.175361301406329e-14, -1.557055151920612e-16,  1.003732524221108e-18, -1.112963316399200e-20, -4.448145881429075e-23,
 -8.077441556118230e-25, -6.044160806924899e-27,  2.510674782991291e-01, -1.419573486323746e-03,  5.549481792458625e-06, -1.670321141056149e-08,  3.383684931254949e-11,
 -5.543942971695464e-15, -4.252406086447411e-16,  1.862939301491895e-18, -1.437864031051433e-20, -6.588022741367380e-23, -9.656588276952648e-25, -8.048777910598602e-27,
  3.079621004294306e-01, -1.723287180449454e-03,  6.510615855144450e-06, -1.787708219409994e-08,  2.536187338158157e-11,  6.777419663433422e-14, -7.677278921339601e-16,
  2.627034025339835e-18, -1.565023346696248e-20, -1.047687544275385e-22, -1.100303012093380e-24, -1.046759074457780e-26,  3.710876634620243e-01, -2.051295179570887e-03,
  7.432496466086595e-06, -1.798107599653800e-08,  9.535037290211401e-12,  1.694374119355076e-13, -1.141606330524629e-15,  2.897120818732236e-18, -1.289931464332488e-20,
 -1.672441728239386e-22, -1.228146325383203e-24, -1.310469943308904e-26,  4.406055709630046e-01, -2.400722439578631e-03,  8.260415101431090e-06, -1.660325714765320e-08,
 -1.508023994157465e-11,  2.958962584375991e-13, -1.463508554359701e-15,  2.079396795272914e-18, -3.947044378271960e-21, -2.536129267645249e-22, -1.423639171867064e-24,
 -1.548994631380611e-26,  5.166923120699147e-01, -2.767692002956154e-03,  8.925309954708936e-06, -1.327065562502657e-08, -4.950584932621036e-11,  4.355811219273482e-13,
 -1.592807096883151e-15, -5.889165561605941e-19,  1.246389452526049e-20, -3.495441492466824e-22, -1.856544884242919e-24, -1.691442346126949e-26,  5.995367620847538e-01,
 -3.146940999634146e-03,  9.339874138514555e-06, -7.458889052668041e-09, -9.384149780471157e-11,  5.642144381999841e-13, -1.318318357300370e-15, -5.886411711611973e-18,
  3.444293678947564e-20, -4.129712277869762e-22, -2.808089714364337e-24, -1.688596052034822e-26,  6.893346434423765e-01, -3.531267462538719e-03,  9.393736614902158e-06,
  1.376981763072824e-09, -1.463967814635321e-10,  6.384364990944216e-13, -3.591110240153846e-16, -1.417928424134402e-17,  5.294353232522956e-20, -3.609654894172334e-22,
 -4.584734723613198e-24, -1.654263725868931e-26,  7.862779486516334e-01, -3.910723420975288e-03,  8.947855765966312e-06,  1.372820234364554e-08, -2.022418702836173e-10,
  5.882648451253341e-13,  1.590899530892504e-15, -2.446078015652498e-17,  4.587056722481831e-20, -7.516124363410059e-23, -7.144275049796731e-24, -2.156529015878188e-26,
  8.905353601558600e-01, -4.271424716531856e-03,  7.828938324201379e-06,  2.987149167533068e-08, -2.508730382311585e-10,  3.114323501701116e-13,  4.707543822949666e-15,
 -3.250837781969299e-17, -2.696128114763119e-20,  5.195124200395333e-22, -9.138776550580562e-24, -4.539031754466372e-26,  1.002216352964238e+00, -4.593782658005915e-03,
  5.826487791106211e-06,  4.953877446286985e-08, -2.727098063138451e-10, -3.201005547339515e-13,  8.634904257736885e-15, -2.805697149231343e-17, -2.154223237113677e-19,
  1.181480982924556e-21, -6.371552372985379e-24, -1.033657607913004e-25,  1.121305152445244e+00, -4.849881659451427e-03,  2.699664013601023e-06,  7.126489319916458e-08,
 -2.346928929251944e-10, -1.412420605499884e-12,  1.162212739473620e-14,  7.244035693589295e-18, -5.185692327565467e-19,  7.450112696327523e-22,  7.885774927972474e-24,
 -1.668606436328344e-25,  1.247537754817829e+00, -4.999681224869008e-03, -1.787462090541759e-06,  9.116271924193152e-08, -8.779665992968779e-11, -2.889928041596754e-12,
  9.107518635915888e-15,  9.193479929211301e-17, -6.930679596222898e-19, -3.370925826453244e-21,  2.943199077486784e-23, -4.301242448229570e-26,  1.380169045836519e+00,
 -4.985943235025735e-03, -7.756345038182092e-06,  1.008581226298788e-07,  2.218609371447223e-10, -4.092372522005710e-12, -6.939581577669779e-15,  1.982859551412936e-16,
  6.064437617815163e-20, -1.189653949459356e-20, -3.320303115885007e-24,  5.396713642151199e-25,  1.517524843175984e+00, -4.729168569810121e-03, -1.492524878413616e-05,
  8.501891217764232e-08,  6.921016968837287e-10, -3.096124723017369e-12, -4.055037554919452e-14,  1.307612972786183e-16,  2.527821357986021e-18, -7.486780621374365e-21,
 -1.935361189637366e-22,  1.749452986566717e-25,  1.656138345673162e+00, -4.129425123469088e-03, -2.195195527277560e-05,  2.292157392598186e-08,  1.082151933050984e-09,
  3.000665825117130e-12, -5.773177013633153e-14, -4.445604555528686e-16,  2.442294499929316e-18,  4.304990403686366e-20, -4.684061574414913e-23, -4.020252045896934e-24,
  1.789154888488105e+00, -3.100250264617562e-03, -2.536264064376487e-05, -8.827938942226952e-08,  6.825228461111969e-10,  1.123362511579087e-11,  3.705073979853307e-14,
 -6.485981513559802e-16, -8.796338089622911e-18, -1.412621523611704e-20,  7.225991313565102e-22,  7.389111494956765e-24,  1.903881172003713e+00, -1.699490435575203e-03,
 -1.977601535952905e-05, -1.657248513440670e-07, -8.141777792318959e-10,  2.311644320049379e-12,  1.014292358065188e-13,  1.141577484842615e-15,  5.239578681101124e-18,
 -5.106412499959344e-20, -1.333580175769648e-21, -1.351051992900812e-23,  1.980299684915540e+00, -3.966652168213116e-04, -5.836516338633054e-06, -7.373338441515670e-08,
 -8.340387215920601e-10, -8.506047393782007e-12, -7.691150955771624e-14, -5.823066180569429e-16, -2.987916619752186e-18,  5.311524586694953e-21,  4.244586913009033e-22,
  7.491341786940817e-24,  6.672096379892104e-04, -3.879461095386611e-06,  1.690461313597812e-08, -6.556800939872928e-11,  2.371335959194449e-13, -8.376767917021337e-16,
  2.684782889734811e-18, -1.102607711871816e-20,  5.693602019704916e-24, -4.164147487712751e-25, -2.737041307702563e-27, -5.421906337118589e-30,  6.007371055967569e-03,
 -3.490459596696262e-05,  1.517777932019771e-07, -5.863333987962965e-10,  2.106512109875324e-12, -7.371479005416152e-15,  2.326021048061266e-17, -9.483701008248029e-20,
  3.032136132321823e-23, -3.664694300295114e-24, -2.507469894493400e-26, -4.745431241248883e-29,  1.670097096456895e-02, -9.689756970501789e-05,  4.195664885647406e-07,
 -1.607574250041296e-09,  5.697086283850266e-12, -1.954679612735023e-14,  5.964070003500796e-17, -2.394674560730714e-19, -2.845083806128174e-23, -9.742224073066499e-24,
 -7.196666788654420e-26, -1.251361754462288e-28,  3.277469502703505e-02, -1.897388619431282e-04,  8.162687258411897e-07, -3.088048188732446e-09,  1.071012559233308e-11,
 -3.558786878522019e-14,  1.025092018041562e-16, -4.012136190711545e-19, -3.693942818685479e-22, -1.792557259022246e-23, -1.471972374263465e-25, -2.293301746374611e-28,
  5.426890046029036e-02, -3.132364622802043e-04,  1.335659275003563e-06, -4.964211671845497e-09,  1.669183169447364e-11, -5.285750754970461e-14,  1.384909769957414e-16,
 -5.204809890252551e-19, -1.246411037251153e-21, -2.741633121809968e-23, -2.548674794675472e-25, -3.548601025973349e-28,  8.123800975327153e-02, -4.671094007709866e-04,
  1.969006562868786e-06, -7.148138763320159e-09,  2.302715612876068e-11, -6.790205485990854e-14,  1.509965300533215e-16, -5.296840830589265e-19, -2.912730838938650e-21,
 -3.768244000153139e-23, -3.976647410744270e-25, -5.090569604188178e-28,  1.137510325989004e-01, -6.509636452738694e-04,  2.704666359684412e-06, -9.524641583924340e-09,
  2.893290183414616e-11, -7.653615122538840e-14,  1.215650882204094e-16, -3.650381113020051e-19, -5.542841980386136e-21, -4.889777703292631e-23, -5.749112062866881e-25,
 -7.198141934904248e-28,  1.518922093862689e-01, -8.642581938779450e-04,  3.527524141680546e-06, -1.194751456711724e-08,  3.345181933345832e-11, -7.399469733229949e-14,
  3.193008305029360e-17,  1.668766058276267e-20, -9.131205099551070e-21, -6.244086211507212e-23, -7.808930720970383e-25, -1.039255920621941e-27,  1.957617615771624e-01,
 -1.106258162424377e-03,  4.418246431761316e-06, -1.423482928449286e-08,  3.545071793705658e-11, -5.519525088185352e-14, -1.328751231404746e-16,  6.152422846620788e-19,
 -1.337071128113667e-20, -8.136153271406707e-23, -1.004377753070685e-24, -1.537001978571864e-27,  2.454767195962508e-01, -1.375970194454057e-03,  5.352286183987388e-06,
 -1.616324659723751e-08,  3.362785882210920e-11, -1.517823751390009e-14, -3.799334362788455e-16,  1.356773688867960e-18, -1.752333055380866e-20, -1.106273466229608e-22,
 -1.230850841061099e-24, -2.274741164031903e-27,  3.011717727698003e-01, -1.672053358491603e-03,  6.298567162526756e-06, -1.746142552226623e-08,  2.653875229773746e-11,
  5.017100931188807e-14, -7.018147713038905e-16,  2.056541196105474e-18, -2.031562538301040e-20, -1.567923476239750e-22, -1.449844291622785e-24, -3.252989169866681e-27,
  3.630000401144086e-01, -1.992695457953445e-03,  7.217745997431896e-06, -1.780286740201606e-08,  1.265610468828660e-11,  1.429597196632095e-13, -1.067244786410172e-15,
  2.377468598689364e-18, -1.993195834403716e-20, -2.264593676172261e-22, -1.670545153032310e-24, -4.326047824984454e-27,  4.311335807854333e-01, -2.335439739475215e-03,
  8.059917475522376e-06, -1.679908657359553e-08, -9.508951849230332e-12,  2.614475970524939e-13, -1.408512003573941e-15,  1.794763291243976e-18, -1.425340631717927e-20,
 -3.225274719738915e-22, -1.948722325979791e-24, -5.103361693944514e-27,  5.057633222931673e-01, -2.696939331815531e-03,  8.761590267493993e-06, -1.399513820504071e-08,
 -4.117765464735567e-11,  3.971887706859920e-13, -1.605714912887280e-15, -4.071150553752227e-19, -1.621600935750195e-21, -4.368482520766640e-22, -2.424055613528290e-24,
 -4.918292499590777e-27,  5.870978342780178e-01, -3.072604711920558e-03,  9.241725350922633e-06, -8.871851776301045e-09, -8.288637338679447e-11,  5.307069622189524e-13,
 -1.470105027743490e-15, -5.045151858301527e-18,  1.739055317808623e-20, -5.381138011549289e-22, -3.351896523235130e-24, -3.089893614525074e-27,  6.753599230871031e-01,
 -3.456090327695097e-03,  9.396625795341636e-06, -8.638168902192392e-10, -1.337454630051178e-10,  6.252317327313703e-13, -7.346259199280096e-16, -1.272971461323434e-17,
  3.649142552551892e-20, -5.564148623851200e-22, -5.071026240263592e-24,  3.303490576411859e-29,  7.707791875369530e-01, -3.838535724427280e-03,  9.093573320100510e-06,
  1.058829939312045e-08, -1.901493952446261e-10,  6.183889646393728e-13,  9.257377754772397e-16, -2.309304691404286e-17,  3.782185597270523e-20, -3.761872305608085e-22,
 -7.751140722287443e-24,  4.986664633017160e-28,  8.735770988735088e-01, -4.207427104087653e-03,  8.163536993252722e-06,  2.591317983887072e-08, -2.435887497137519e-10,
  4.134077623576894e-13,  3.787518054077418e-15, -3.314604164592565e-17, -1.526895937610947e-20,  1.201795063045470e-22, -1.060037781430840e-23, -1.337243583598479e-26,
  9.839381058121530e-01, -4.544867486349411e-03,  6.394597388229537e-06,  4.513518075570710e-08, -2.771069397303753e-10, -1.230316327411719e-13,  7.758793853010786e-15,
 -3.432760531166476e-17, -1.785029597422695e-19,  8.440094368949035e-22, -1.019984644886069e-23, -6.096229583861440e-26,  1.101954143735264e+00, -4.824929517146068e-03,
  3.531429216486857e-06,  6.729901043270989e-08, -2.601451440648591e-10, -1.132904094994116e-12,  1.159702441943043e-14, -8.874473706800085e-18, -4.878253599354045e-19,
  9.162625301215490e-22,  8.770772850778296e-25, -1.382594665602631e-25,  1.227517319488504e+00, -5.009633303135623e-03, -7.038045414472519e-07,  8.930828917459330e-08,
 -1.432143068347099e-10, -2.643067761332035e-12,  1.135454648542897e-14,  6.803706208390974e-17, -7.938961837569182e-19, -2.253372301890415e-21,  2.606366612785427e-23,
 -9.390673549299388e-26,  1.360108913523977e+00, -5.043098729098228e-03, -6.527474039064466e-06,  1.037459553659216e-07,  1.387971540330982e-10, -4.192474622690112e-12,
 -1.424709552550236e-15,  1.933938400785762e-16, -3.644733165737819e-19, -1.157361441047172e-20,  1.900316856180448e-23,  4.781768695600267e-25,  1.498376085491502e+00,
 -4.844306443453962e-03, -1.384079101297807e-05,  9.554568727037075e-08,  6.207896692861166e-10, -4.016559219856607e-12, -3.580762455539006e-14,  2.058711865555341e-16,
  2.122487003350572e-18, -1.488934451093183e-20, -1.719715683985046e-22,  8.094255583879462e-25,  1.639271576853326e+00, -4.303642133171791e-03, -2.157128436143044e-05,
  4.063677397219620e-08,  1.127353004764599e-09,  1.475972710226066e-12, -6.885695558453876e-14, -3.423266333721950e-16,  3.914481845625899e-18,  3.751398897379740e-20,
 -2.313147955194033e-22, -4.200393463654422e-24,  1.776341660901941e+00, -3.307185798235875e-03, -2.634891868656471e-05, -7.552008054706236e-08,  9.144509016249440e-10,
  1.187285132282133e-11,  1.491615168097722e-14, -9.320213605933493e-16, -8.709210321038815e-18,  2.092118506138132e-20,  1.016438859598533e-21,  5.551480448560717e-24,
  1.896753892065011e+00, -1.865870379411446e-03, -2.184089006005281e-05, -1.782383859119564e-07, -7.409235039827541e-10,  5.146366378079611e-12,  1.353841177585992e-13,
  1.268348952064781e-15,  2.294459676684663e-18, -1.166133046077606e-19, -1.944555380079477e-21, -1.354413759791693e-23,  1.978613697877350e+00, -4.471370176007718e-04,
 -6.807339141757635e-06, -8.854499854304096e-08, -1.023993708860165e-09, -1.055807154832179e-11, -9.449840848362515e-14, -6.708503192489034e-16, -2.397939025873736e-18,
  3.042824614961426e-20,  8.748281684863730e-22,  1.347630201269261e-23,  };
  constexpr double w[10368] = {  1.141029027335057e-01, -5.630980392362554e-04,  2.970824440623628e-06, -1.638360096318181e-08,  9.258451346530860e-11,
 -5.287829441187923e-13,  3.026731170264823e-15, -1.728437747029296e-17,  9.824631244399729e-20, -5.553242009241246e-22,  3.120418937385393e-24, -1.743162255431679e-26,
  1.130172129021143e-01, -9.090713806597601e-04,  8.383456050268183e-06, -7.511863252926600e-08,  6.423916790555062e-10, -5.278402336231045e-12,  4.198239051494675e-14,
 -3.249881225150638e-16,  2.458170074550060e-18, -1.822108955234336e-20,  1.326603740391616e-22, -9.503418318570050e-25,  1.108890900944287e-01, -1.577251050610969e-03,
  2.190367266191478e-05, -2.706789704998212e-07,  3.076163784551792e-09, -3.283633363164040e-11,  3.334531598080652e-13, -3.249074391692798e-15,  3.056289412161195e-17,
 -2.788324574696846e-19,  2.476067950120926e-21, -2.146155387197724e-23,  1.078013434939873e-01, -2.522495295430225e-03,  4.835200248934829e-05, -7.851218830002140e-07,
  1.140927073975667e-08, -1.526240655822430e-10,  1.911997878572325e-12, -2.269151689449254e-14,  2.572362104914528e-16, -2.802625781335035e-18,  2.948659290789721e-20,
 -3.006791465819987e-22,  1.038694287132124e-01, -3.682717321857681e-03,  9.365316529236654e-05, -1.941985024505567e-06,  3.514800460761875e-08, -5.749947348957002e-10,
  8.685368746020778e-12, -1.228725249502822e-13,  1.644580377603708e-15, -2.098234867999805e-17,  2.566636842490345e-19, -3.023561131101856e-21,  9.923225072090283e-02,
 -4.984714374791636e-03,  1.635687696223173e-04, -4.232372361314041e-06,  9.346698908044088e-08, -1.835430146875255e-09,  3.285822703363066e-11, -5.452341730560289e-13,
  8.485253705899509e-15, -1.249347920834918e-16,  1.752087408903786e-18, -2.352434073663939e-20,  9.404182462990598e-02, -6.350599609885522e-03,  2.624300040999334e-04,
 -8.306478121292527e-06,  2.200241353419237e-07, -5.107420033174561e-09,  1.068487526275097e-10, -2.052438575786938e-12,  3.668139713788016e-14, -6.159712966763100e-16,
  9.792484120061971e-18, -1.482338462518172e-19,  8.845298242477441e-02, -7.704028152932250e-03,  3.921008839145576e-04, -1.491615106543474e-05,  4.668452960824189e-07,
 -1.264056051546816e-08,  3.052913892912862e-10, -6.712366277293862e-12,  1.363142866785645e-13, -2.584576379171997e-15,  4.613390488959564e-17, -7.801437334595377e-19,
  8.261416631584609e-02, -8.975530801192285e-03,  5.513404814379281e-04, -2.480854407627947e-05,  9.051162854703505e-07, -2.824634938584331e-08,  7.790602246384855e-10,
 -1.941020553297642e-11,  4.437140845628249e-13, -9.415171782974027e-15,  1.871066624512662e-16, -3.506164359208279e-18,  7.666006578628551e-02, -1.010648506426843e-02,
  7.356429369406700e-04, -3.858611313254659e-05,  1.620805366110523e-06, -5.766185265877005e-08,  1.798205910135349e-09, -5.030545159088593e-11,  1.283449423297662e-12,
 -3.023283189090646e-14,  6.638142265107071e-16, -1.368370208324553e-17,  7.070650593605714e-02, -1.105150959981570e-02,  9.375404232806334e-04, -5.655935701746120e-05,
  2.703992932083629e-06, -1.085514274847246e-07,  3.792401770543004e-09, -1.181158702181567e-10,  3.336681583115794e-12, -8.660567245542874e-14,  2.086160968619888e-15,
 -4.698815688652826e-17,  6.484765069453322e-02, -1.177931139982728e-02,  1.147277443563091e-03, -7.862257337840062e-05,  4.232427320056020e-06, -1.899069244861951e-07,
  7.368438243122765e-09, -2.534601093624416e-10,  7.868949254504335e-12, -2.234764072980211e-13,  5.866537013456778e-15, -1.434688861922649e-16,  5.915530204995222e-02,
 -1.227220513775280e-02,  1.353718034337410e-03, -1.041789413581844e-04,  6.251665847848540e-06, -3.107079900191870e-07,  1.327917124663274e-08, -5.006626707245642e-10,
  1.696186596586356e-11, -5.235717759442670e-13,  1.488452203530888e-14, -3.928597737800537e-16,  5.367988777269635e-02, -1.252463998723468e-02,  1.545334306367678e-03,
 -1.321311915824649e-04,  8.755593356218976e-06, -4.778989728969514e-07,  2.232220140200528e-08, -9.157970136720939e-10,  3.362811220310955e-11, -1.121035408883337e-12,
  3.430529031667790e-14, -9.716088051107271e-16,  4.845264221635325e-02, -1.254110939970636e-02,  1.711140657127615e-03, -1.609412008596616e-04,  1.167165376561928e-05,
 -6.939775868013442e-07,  3.516213039182359e-08, -1.558832405819929e-09,  6.163710101900647e-11, -2.205465638977962e-12,  7.222582167751550e-14, -2.182925896438001e-15,
  4.348848466329774e-02, -1.233379690393835e-02,  1.841473134080350e-03, -1.887494986247562e-04,  1.485459286239950e-05, -9.546957562825355e-07,  5.209547845077564e-08,
 -2.478961170103325e-09,  1.048845023135044e-10, -4.004255293624331e-12,  1.395430226145396e-13, -4.476417304178102e-15,  3.878916256925093e-02, -1.192024694375115e-02,
  1.928556495307111e-03, -2.135365605844747e-04,  1.809103784512813e-05, -1.247469424274649e-06,  7.280510153141093e-08, -3.694503180614755e-09,  1.662407372325930e-10,
 -6.732599667964011e-12,  2.482967281010414e-13, -8.409846608177689e-15,  3.434632483473034e-02, -1.132126630862522e-02,  1.966842673372479e-03, -2.333032312451012e-04,
  2.111523117981142e-05, -1.551036468749083e-06,  9.617104974882541e-08, -5.171617897986295e-09,  2.460139549542344e-10, -1.050954414353600e-11,  4.079769810708373e-13,
 -1.451494354052075e-14,  3.014429789179512e-02, -1.055917746429114e-02,  1.953136992935658e-03, -2.462476474942817e-04,  2.363419501747347e-05, -1.836692390707896e-06,
  1.202079334442219e-07, -6.808328956873939e-09,  3.404081356184754e-10, -1.525456221608667e-11,  6.200445898027140e-13, -2.305551153865900e-14,  2.616243669571109e-02,
 -9.656472685535076e-03,  1.886549647513261e-03, -2.509196182379430e-04,  2.535897458309425e-05, -2.071120065794929e-06,  1.421804442819278e-07, -8.430925693113439e-09,
  4.405438488367757e-10, -2.059715996075271e-11,  8.720655280044382e-13, -3.372235244788774e-14,  2.237700312162714e-02, -8.634863672069185e-03,  1.768319686854891e-03,
 -2.463390567012449e-04,  2.603767814801776e-05, -2.220489535902294e-06,  1.589111523296053e-07, -9.807929473014615e-09,  5.326245582280922e-10, -2.584282490224723e-11,
  1.133916877769572e-12, -4.537759533050185e-14,  1.876258206483678e-02, -7.514686479997632e-03,  1.601559178803495e-03, -2.320712700132598e-04,  2.548588125192991e-05,
 -2.255218179233891e-06,  1.672471236887631e-07, -1.068262289101431e-08,  5.996084694362032e-10, -3.003330910177504e-11,  1.358792956332297e-12, -5.600217177213315e-14,
  1.529308211246450e-02, -6.314603985231482e-03,  1.390959264670701e-03, -2.082575256263047e-04,  2.361050471886705e-05, -2.154614593509754e-06,  1.646071794424297e-07,
 -1.081968985138568e-08,  6.243111718573333e-10, -3.211424728684983e-11,  1.490699403482228e-12, -6.297292088102741e-14,  1.194238851944086e-02, -5.051544446680014e-03,
  1.142490639283209e-03, -1.756036702976932e-04,  2.042431403418020e-05, -1.910613785210529e-06,  1.495024808679806e-07, -1.005649143393912e-08,  5.933462095130367e-10,
 -3.118417196274686e-11,  1.477821018836957e-12, -6.368481369335672e-14,  8.684757588010052e-03, -3.740825649349652e-03,  8.631221342986014e-04, -1.353326288786791e-04,
  1.604950829750500e-05, -1.529946533935955e-06,  1.219184755590462e-07, -8.346661905883610e-09,  5.009008267078376e-10, -2.676050379400696e-11,  1.288385924982616e-12,
 -5.637182996553771e-14,  5.495185170662759e-03, -2.396487137426931e-03,  5.605863836896413e-04, -8.911042768503519e-05,  1.071049157300430e-05, -1.034363716891348e-06,
  8.347028904544033e-08, -5.784354615004921e-09,  3.512290488013270e-10, -1.897802326952280e-11,  9.237351500730186e-13, -4.084397870805411e-14,  2.353029504058676e-03,
 -1.033207041645920e-03,  2.435305453531768e-04, -3.900662452048484e-05,  4.723307423986125e-06, -4.594550952011451e-07,  3.733651630225345e-08, -2.604874071908673e-09,
  1.592030110510154e-10, -8.656498895404953e-12,  4.239098497376630e-13, -1.885336514562263e-14,  1.118968331380448e-01, -5.400934524692120e-04,  2.782772695812633e-06,
 -1.498306554550833e-08,  8.269782975665482e-11, -4.616113349331939e-13,  2.583940978557611e-15, -1.443769484719918e-17,  8.032825673650521e-20, -4.445728836117559e-22,
  2.446558391872645e-24, -1.338786840516732e-26,  1.095095901907440e-01, -8.454423783157039e-04,  7.540387564316160e-06, -6.563310638724043e-08,  5.462058263761467e-10,
 -4.371703646488838e-12,  3.389222505905387e-14, -2.558743450554213e-16,  1.888451760062327e-18, -1.366425075848153e-20,  9.714758290327037e-23, -6.798226665965264e-25,
  1.049110918762213e-01, -1.414224775444205e-03,  1.893049329031139e-05, -2.263083957136992e-07,  2.492631119487697e-09, -2.582326608874417e-11,  2.547885061385261e-13,
 -2.414258038155272e-15,  2.210160349626966e-17, -1.963619434958647e-19,  1.699047380615478e-21, -1.435659751604969e-23,  9.842941956378902e-02, -2.170478602833472e-03,
  3.993262186019459e-05, -6.247005637075017e-07,  8.768643884524549e-09, -1.135159852825241e-10,  1.378193978078337e-12, -1.587019532924084e-14,  1.747308688970425e-16,
 -1.850477571026468e-18,  1.893831193605217e-20, -1.879755723662895e-22,  9.050184984531752e-02, -3.017952834969349e-03,  7.337778711320423e-05, -1.461361434831888e-06,
  2.548193435491830e-08, -4.025173116377550e-10,  5.880904662305020e-12, -8.058411449567713e-14,  1.045908566789357e-15, -1.295299752814578e-17,  1.539351000948268e-19,
 -1.763149832651127e-21,  8.162136806742230e-02, -3.856430248425618e-03,  1.206675804500632e-04, -2.992409686597604e-06,  6.355031910141937e-08, -1.203066723230893e-09,
  2.080277305231132e-11, -3.339364311102092e-13,  5.034074911333782e-15, -7.187927328767364e-17,  9.785264168549831e-19, -1.276492734816399e-20,  7.228230048213441e-02,
 -4.596970169255292e-03,  1.809068486287249e-04, -5.481339424522244e-06,  1.394719736151854e-07, -3.118101688526783e-09,  6.295321709815566e-11, -1.168982594706585e-12,
  2.022510254975148e-14, -3.291901000879722e-16,  5.077981960771198e-18, -7.465905708162115e-20,  6.293370342354083e-02, -5.173126347891553e-03,  2.507155728929454e-04,
 -9.127037705636020e-06,  2.743045215238215e-07, -7.150735747621885e-09,  1.666230120146308e-10, -3.540703654453444e-12,  6.959772329059240e-14, -1.278925526989568e-15,
  2.215010521996942e-17, -3.638156317801394e-19,  5.394632082971954e-02, -5.546572385911999e-03,  3.247340350274360e-04, -1.398968097953228e-05,  4.902710814697369e-07,
 -1.473441109066941e-08,  3.921820544614170e-10, -9.446185089295393e-12,  2.090721753818184e-13, -4.300943762432002e-15,  8.296197631562415e-17, -1.510579938414837e-18,
  4.559535119549215e-02, -5.707105893446743e-03,  3.966132765124356e-04, -1.994096170530322e-05,  8.053466360003689e-07, -2.761452660627948e-08,  8.316980079044800e-10,
 -2.250963320346050e-11,  5.564304538153261e-13, -1.271642153292578e-14,  2.712069342054668e-16, -5.436239636480529e-18,  3.805798210887719e-02, -5.668232056322953e-03,
  4.601662992316530e-04, -2.665774119652107e-05,  1.227199385279934e-06, -4.754688166207059e-08,  1.606245196095149e-09, -4.845480248817971e-11,  1.327719628933412e-12,
 -3.347056852826798e-14,  7.839623766707943e-16, -1.718836265447966e-17,  3.142237364399909e-02, -5.460176670591247e-03,  5.103649069646794e-04, -3.366284467111861e-05,
  1.748419241051050e-06, -7.584870134704256e-08,  2.850415963024979e-09, -9.511415392329616e-11,  2.868503914780735e-12, -7.923404087316445e-14,  2.025305002702971e-15,
 -4.827800809681062e-17,  2.570376584204789e-02, -5.122221090539486e-03,  5.439713914344892e-04, -4.040082852040489e-05,  2.344728860471986e-06, -1.129118815748272e-07,
  4.683316343947171e-09, -1.716121064368893e-10,  5.657910527324064e-12, -1.701547067257115e-13,  4.717895168313334e-15, -1.215709227033951e-16,  2.086350856052932e-02,
 -4.695847054069550e-03,  5.597358215251495e-04, -4.632676571320299e-05,  2.976930365864985e-06, -1.578272009799887e-07,  7.170934996445281e-09, -2.865477177706795e-10,
  1.026055774373515e-11, -3.339062520102533e-13,  9.984585601289903e-15, -2.765853823496745e-16,  1.682768099493329e-02, -4.219567911028212e-03,  5.582137922531527e-04,
 -5.098517158248663e-05,  3.596128869400784e-06, -2.082495974875764e-07,  1.028971617831035e-08, -4.453694355056848e-10,  1.721136862970012e-11, -6.024863598390527e-13,
  1.931975970241108e-14, -5.722455053247714e-16,  1.350314601120499e-02, -3.725723343360052e-03,  5.413336892794923e-04, -5.406268577083812e-05,  4.150811343273796e-06,
 -2.605641516171894e-07,  1.390287271150967e-08, -6.475425449052972e-10,  2.684161409639020e-11, -1.004827981880656e-12,  3.436350939682775e-14, -1.082615146388013e-15,
  1.079001766929025e-02, -3.239066195741000e-03,  5.118610030106771e-04, -5.540809373771413e-05,  4.593983023765420e-06, -3.103208297742060e-07,  1.775831514355778e-08,
 -8.843633225938743e-10,  3.908373984328113e-11, -1.555787922885277e-12,  5.643526971556528e-14, -1.881372308243476e-15,  8.590400366620649e-03, -2.776720330647559e-03,
  4.728835377066588e-04, -5.502258494025747e-05,  4.888808439053892e-06, -3.528309701013880e-07,  2.151101831899519e-08, -1.138228906291989e-09,  5.331437435263442e-11,
 -2.244016075103471e-12,  8.588041325325380e-14, -3.014007810691488e-15,  6.813816125557816e-03, -2.349016194807112e-03,  4.273967875944792e-04, -5.302914529381725e-05,
  5.011857906609316e-06, -3.837857008391879e-07,  2.476568265765569e-08, -1.383819890782566e-09,  6.829730425754308e-11, -3.022711385828506e-12,  1.214027834580528e-13,
 -4.462750326233211e-15,  5.380001953926935e-03, -1.960759896971093e-03,  3.780224830066713e-04, -4.963196591680515e-05,  4.953815396354759e-06, -3.997704639458685e-07,
  2.713033349669268e-08, -1.591125431998513e-09,  8.226711216666629e-11, -3.807468233641584e-12,  1.596408180120585e-13, -6.115785053667715e-15,  4.219809331903748e-03,
 -1.612600969070299e-03,  3.268573653712011e-04, -4.507551976268620e-05,  4.718104637968018e-06, -3.985965941226224e-07,  2.826963454453676e-08, -1.729738767818128e-09,
  9.315613627822708e-11, -4.483941707614130e-12,  1.952389275013271e-13, -7.755827153266343e-15,  3.274858616134924e-03, -1.302285566753292e-03,  2.754279386838860e-04,
 -3.960998063665523e-05,  4.318211380856811e-06, -3.794282995261770e-07,  2.794821510366940e-08, -1.773545125964643e-09,  9.892622943045745e-11, -4.925290916903183e-12,
  2.215479743720188e-13, -9.080446132415788e-15,  2.496463838645038e-03, -1.025686693898411e-03,  2.247190111560784e-04, -3.346633542900983e-05,  3.774523616709135e-06,
 -3.427317397292270e-07,  2.605804341305393e-08, -1.704886063359049e-09,  9.793679287680721e-11, -5.016264555423728e-12,  2.318895695910090e-13, -9.757202245212349e-15,
  1.844196653466054e-03, -7.775793145841844e-04,  1.752453435021497e-04, -2.684180419388673e-05,  3.111361690896403e-06, -2.901012990278300e-07,  2.262818119814066e-08,
 -1.517478478335639e-09,  8.927050626911741e-11, -4.678482822988298e-12,  2.211103139064804e-13, -9.503550942415835e-15,  1.284330387499420e-03, -5.521763809885157e-04,
  1.271424610290906e-04, -1.989444927951037e-05,  2.354635044263962e-06, -2.240254318546476e-07,  1.781877893030254e-08, -1.217689938268697e-09,  7.294888179053391e-11,
 -3.890727455965877e-12,  1.870155799833996e-13, -8.169882124814791e-15,  7.883233338562549e-04, -3.434748115446299e-04,  8.026290731439724e-05, -1.274537434929525e-05,
  1.530361401635747e-06, -1.476488666358492e-07,  1.190347034323796e-08, -8.241270270583163e-10,  4.999652180440755e-11, -2.699122981076535e-12,  1.312663240917050e-13,
 -5.799365376279668e-15,  3.318552305500032e-04, -1.456573116503158e-04,  3.431624946143344e-05, -5.493938662738226e-06,  6.649557622549966e-07, -6.465381904554878e-08,
  5.251622044079239e-09, -3.662343901603218e-10,  2.237384249644068e-11, -1.216053344891219e-12,  5.952631039015586e-14, -2.646390357801241e-15,  1.097798758359853e-01,
 -5.185286446590797e-04,  2.610620788635184e-06, -1.373052102795214e-08,  7.405444499182857e-11, -4.041714903775751e-13,  2.213394828723923e-15, -1.210547067430192e-17,
  6.595204783599373e-20, -3.575316382982259e-22,  1.927695710537012e-24, -1.033689957336184e-26,  1.062436800920913e-01, -7.881274683917247e-04,  6.802477511103272e-06,
 -5.755140892456474e-08,  4.663590202309732e-10, -3.637864476485383e-12,  2.750484547337774e-14, -2.026192920630384e-16,  1.459838240251649e-18, -1.031585353213972e-20,
  7.165186527277306e-23, -4.900129737377331e-25,  9.954078923613813e-02, -1.273002837792667e-03,  1.643805848815313e-05, -1.902474013355310e-07,  2.032226433497184e-09,
 -2.044570491946079e-11,  1.961149112062447e-13, -1.808136648826205e-15,  1.611769750530989e-17, -1.395204221826720e-19,  1.176854475608543e-21, -9.698760416688520e-24,
  9.034210337801535e-02, -1.878779758623037e-03,  3.320851877591765e-05, -5.009081112020825e-07,  6.796119119011492e-09, -8.519658981748126e-11,  1.003048832095450e-12,
 -1.121324338536489e-14,  1.199679140978074e-16, -1.235595244878238e-18,  1.230656354310351e-20, -1.189525922159998e-22,  7.950205647321414e-02, -2.494710354429782e-03,
  5.804495149905316e-05, -1.111088802198129e-06,  1.867810147537738e-08, -2.850617122389294e-10,  4.030683331971812e-12, -5.352428933056229e-14,  6.739888750063340e-16,
 -8.106018776405296e-18,  9.363135867405202e-20, -1.043155057956403e-21,  6.792110183171084e-02, -3.019106555205744e-03,  9.014538188752617e-05, -2.143848187756751e-06,
  4.380911566709251e-08, -7.999454083132182e-10,  1.336691007153351e-11, -2.076708878578004e-13,  3.033822733096584e-15, -4.202540017524066e-17,  5.555692920492827e-19,
 -7.043988237231880e-21,  5.642026645365299e-02, -3.379139825936123e-03,  1.267005316301838e-04, -3.676533706733733e-06,  8.990359466317880e-08, -1.936561421384814e-09,
  3.774719138735566e-11, -6.778253395931790e-13,  1.135663356220155e-14, -1.792167241732309e-16,  2.683221119779270e-18, -3.832628350221197e-20,  4.565158921449047e-02,
 -3.540496916401956e-03,  1.634264047364427e-04, -5.694676826187298e-06,  1.643891309389353e-07, -4.126918124449207e-09,  9.280046892236063e-11, -1.906314907367527e-12,
  3.627673796779430e-14, -6.461914398778368e-16,  1.086086263194930e-17, -1.732950963292543e-19,  3.605499644188118e-02, -3.506321762156666e-03,  1.956391922239490e-04,
 -8.069400780941304e-06,  2.716567344537476e-07, -7.862978169327520e-09,  2.019855754228601e-10, -4.703581543703362e-12,  1.008002377541109e-13, -2.010451853618613e-15,
  3.764270403950009e-17, -6.660079729711832e-19,  2.785887452696233e-02, -3.308173168643230e-03,  2.194136430370476e-04, -1.057206263274304e-05,  4.104548301986180e-07,
 -1.356326364457418e-08,  3.944793335991710e-10, -1.032791210445508e-11,  2.473394586466549e-13, -5.483537326815132e-15,  1.135855609308043e-16, -2.213695667016209e-18,
  2.111240267031408e-02, -2.993321268028299e-03,  2.324085882221683e-04, -1.292281350129537e-05,  5.726372787007475e-07, -2.140553395018792e-08,  6.990426405747322e-10,
 -2.041952882593545e-11,  5.425881858404166e-13, -1.328153238244595e-14,  3.024193225494860e-16, -6.452786495067239e-18,  1.573424177793305e-02, -2.612485253109204e-03,
  2.341502005603741e-04, -1.485484183848632e-05,  7.439958460541087e-07, -3.118945361840561e-08,  1.134739733167215e-09, -3.671579676686293e-11,  1.075211576219254e-12,
 -2.887534337859466e-14,  7.184158044323833e-16, -1.668644686132964e-17,  1.156367593658204e-02, -2.210706305826518e-03,  2.258022080302405e-04, -1.617117772386826e-05,
  9.070111653028131e-07, -4.229256073392343e-08,  1.701416644015352e-09, -6.055930368001868e-11,  1.941952190573715e-12, -5.687126766880820e-14,  1.537210884171924e-15,
 -3.865375991085761e-17,  8.404661007370215e-03, -1.822320311404415e-03,  2.096137208885774e-04, -1.677697135499929e-05,  1.044554423202655e-06, -5.374833067237460e-08,
  2.373756120142607e-09, -9.232541282405490e-11,  3.221722193020847e-12, -1.022856436117074e-13,  2.986979331703960e-15, -8.088327119812348e-17,  6.058212167316024e-03,
 -1.469620502281457e-03,  1.882793906912321e-04, -1.668203206149457e-05,  1.143275845695782e-06, -6.442496309715375e-08,  3.101762063345967e-09, -1.309743691797368e-10,
  4.943340011904952e-12, -1.691722503831462e-13,  5.308392777119030e-15, -1.539952032642096e-16,  4.342604016529242e-03, -1.164073140305887e-03,  1.643966665361330e-04,
 -1.597943778740689e-05,  1.195697140229318e-06, -7.324478462730768e-08,  3.818078884972066e-09, -1.739198390109727e-10,  7.057555567505992e-12, -2.588769644585831e-13,
  8.681947463779685e-15, -2.684478685519468e-16,  3.103325124134099e-03, -9.088233197938584e-04,  1.401136768965467e-04, -1.481186920236799e-05,  1.200642090033730e-06,
 -7.937484285835124e-08,  4.449908157600048e-09, -2.172978834447884e-10,  9.424650065403485e-12, -3.684734652851982e-13,  1.313747005306783e-14, -4.307749079710757e-16,
  2.215707640158705e-03, -7.014797154203191e-04,  1.169765199268561e-04, -1.333736444917283e-05,  1.162247216466362e-06, -8.233908223013892e-08,  4.931761787219697e-09,
 -2.565712785411744e-10,  1.182424728628407e-11, -4.900030404257658e-13,  1.847500606838084e-14, -6.391763472031994e-16,  1.583092149484972e-03, -5.365550092515071e-04,
  9.593178364089617e-05, -1.170245700437736e-05,  1.088150859809175e-06, -8.203687461473256e-08,  5.215448597975777e-09, -2.872881591283916e-10,  1.398614969095947e-11,
 -6.109305803415113e-13,  2.423003147844849e-14, -8.800039872120229e-16,  1.132796006672281e-03, -4.072937773748055e-04,  7.742179932796314e-05, -1.002588953238071e-05,
  9.875089016901896e-07, -7.868403965931723e-08,  5.275162309995242e-09, -3.057806087087715e-10,  1.563382983081191e-11, -7.158242989981760e-13,  2.970514261750018e-14,
 -1.126790060769141e-15,  8.114208744500538e-04, -3.068652371245409e-04,  6.151625207799896e-05, -8.392290636015865e-06,  8.693180429942366e-07, -7.270975653909183e-08,
  5.107434101249391e-09, -3.096392941888916e-10,  1.652882116812314e-11, -7.888585324130617e-13,  3.406907711505816e-14, -1.342836781274838e-15,  5.803878748778730e-04,
 -2.290276149226724e-04,  4.804108601804459e-05, -6.853144372352521e-06,  7.412817893607089e-07, -6.464432644310616e-08,  4.727201365524178e-09, -2.978971707439549e-10,
  1.650553552877766e-11, -8.165045638310792e-13,  3.650162388651828e-14, -1.487234330460506e-15,  4.121142023254179e-04, -1.684124317159967e-04,  3.668398485122633e-05,
 -5.431908235683713e-06,  6.092405074479950e-07, -5.502366705364947e-08,  4.161919346544648e-09, -2.709507556720059e-10,  1.549057815787143e-11, -7.897854182317100e-13,
  3.634908406903254e-14, -1.522996999525750e-15,  2.869448363088485e-04, -1.205670825818563e-04,  2.706978941457494e-05, -4.130646700426387e-06,  4.770566890308612e-07,
 -4.432370984161156e-08,  3.445551003285218e-09, -2.303081260428923e-10,  1.350597401146355e-11, -7.056765184697717e-13,  3.325383615402133e-14, -1.425283792803129e-15,
  1.907900011114411e-04, -8.186239264135046e-05,  1.880773781946296e-05, -2.936442086653031e-06,  3.468011722509974e-07, -3.292692546132649e-08,  2.613723333869454e-09,
 -1.782694951537768e-10,  1.065976660828883e-11, -5.675154705456320e-13,  2.723143428245449e-14, -1.187635683202806e-15,  1.133499924677827e-04, -4.933790532999925e-05,
  1.151652674136563e-05, -1.826752088019302e-06,  2.191044660696254e-07, -2.111691382126121e-08,  1.700712243507100e-09, -1.176311219172008e-10,  7.129390607207479e-12,
 -3.845325807623636e-13,  1.868420042748779e-14, -8.247567329816022e-16,  4.684994305290833e-05, -2.055449849599373e-05,  4.840223361921381e-06, -7.745296289445582e-07,
  9.369963953091118e-08, -9.106134683351505e-09,  7.393198873082592e-10, -5.153491747627050e-11,  3.146959020859134e-12, -1.709683192555734e-13,  8.365441101847673e-15,
 -3.717538088867508e-16,  1.077465153202601e-01, -4.982831966943271e-04,  2.452706054334021e-06, -1.260754218044487e-08,  6.647595864898987e-11, -3.548903521016304e-13,
  1.902154373560556e-15, -1.018690671414528e-17,  5.436594755901453e-20, -2.887926724756444e-22,  1.526090676019638e-24, -8.022090173694742e-27,  1.031958080255040e-01,
 -7.363485720163021e-04,  6.154341208738915e-06, -5.063769477137083e-08,  3.997692471770955e-10, -3.040873857236148e-12,  2.243339592657595e-14, -1.613327855940014e-16,
  1.135257420756180e-18, -7.838113169768248e-21,  5.321087685923592e-23, -3.557805375945353e-25,  9.469806941360975e-02, -1.150106976945897e-03,  1.433747300121812e-05,
 -1.607635786531563e-07,  1.666561693033761e-09, -1.629253506842338e-11,  1.520129744146480e-13, -1.364421756244243e-15,  1.184872941183784e-17, -9.998116577777682e-20,
  8.225117915811044e-22, -6.614205612936908e-24,  8.332270069729282e-02, -1.635428154356551e-03,  2.779778202991675e-05, -4.045931243503362e-07,  5.309566556928382e-09,
 -6.449520487745332e-11,  7.367589927493508e-13, -8.000330638267577e-15,  8.321682810086897e-17, -8.339319443423564e-19,  8.087151302533375e-21, -7.615556922878228e-23,
  7.037413278747659e-02, -2.079004070152166e-03,  4.633257471336882e-05, -8.530619616624911e-07,  1.383437686785190e-08, -2.041181849679926e-10,  2.794757097621378e-12,
 -3.598397318586549e-14,  4.398252580558723e-16, -5.139402130302570e-18,  5.772458273901821e-20, -6.258096627380871e-22,  5.713942043870844e-02, -2.390043877874404e-03,
  6.814841353994636e-05, -1.555259318147090e-06,  3.059854601160962e-08, -5.392050464195359e-10,  8.711230226880831e-12, -1.310467783329275e-13,  1.856035180245726e-15,
 -2.495283213341056e-17,  3.204549602697874e-19, -3.950344412832395e-21,  4.468250826603250e-02, -2.520208472967272e-03,  9.007817970367683e-05, -2.504487434343066e-06,
  5.888377553972905e-08, -1.222607621746658e-09,  2.301648518879868e-11, -3.998299706135277e-13,  6.489402284483185e-15, -9.932169203935331e-17,  1.443720751310882e-18,
 -2.003966412405893e-20,  3.372737456050377e-02, -2.467284421316931e-03,  1.084954103177946e-04, -3.619782440598806e-06,  1.003959216390362e-07, -2.427881243449610e-09,
  5.269965803969251e-11, -1.046766114145562e-12,  1.928902739734735e-14, -3.331322549722618e-16,  5.434693270960590e-18, -8.425353272496012e-20,  2.463713386055993e-02,
 -2.265087703458399e-03,  1.204408047510485e-04, -4.756565422635663e-06,  1.538396798554827e-07, -4.288982680626280e-09,  1.063443258746546e-10, -2.394458662771783e-12,
  4.969056853245520e-14, -9.609622453269930e-16,  1.746609021862121e-17, -3.002984788674620e-19,  1.746744121956488e-02, -1.966383502363955e-03,  1.244326267660087e-04,
 -5.744799049625689e-06,  2.143897795127752e-07, -6.826764053364696e-09,  1.917259943195507e-10, -4.855469109060683e-12,  1.126489165769310e-13, -2.422608303526701e-15,
  4.873550466193367e-17, -9.234384956257660e-19,  1.205895085598434e-02, -1.626043557637259e-03,  1.206760509488065e-04, -6.437981547537991e-06,  2.745153923218756e-07,
 -9.897769562471826e-09,  3.123921550622076e-10, -8.834144554885770e-12,  2.275906139857070e-13, -5.408370676997079e-15,  1.196938369046016e-16, -2.484981679688567e-18,
  8.135215003954711e-03, -1.289232353821523e-03,  1.107137467038283e-04, -6.751708163117545e-06,  3.259126639039628e-07, -1.319707433351110e-08,  4.646408901223935e-10,
 -1.457235432869325e-11,  4.142347894171214e-13, -1.081206907862738e-14,  2.617489868697766e-16, -5.921928000842286e-18,  5.383407215722303e-03, -9.860906073985974e-04,
  9.677814490496804e-05, -6.677981916885764e-06,  3.617308275865176e-07, -1.632199578608241e-08,  6.365135552780870e-10, -2.199508544175987e-11,  6.856747809558021e-13,
 -1.954496826019531e-14,  5.147735680110745e-16, -1.262590942625255e-17,  3.508419730626878e-03, -7.318156957148842e-04,  8.114210320772777e-05, -6.274461932684914e-06,
  3.781920693206365e-07, -1.887289222881248e-08,  8.096251504502089e-10, -3.063026390864340e-11,  1.040984953338473e-12, -3.222491112531032e-14,  9.185026445129152e-16,
 -2.429980847818728e-17,  2.261135774616421e-03, -5.298965089931897e-04,  6.566561568629249e-05, -5.638107893160063e-06,  3.750916934155724e-07, -2.055041400461991e-08,
  9.633034931893601e-10, -3.965312117456191e-11,  1.460646037357227e-12, -4.883605628513083e-14,  1.498572348766677e-15, -4.255209071007872e-17,  1.447151853881991e-03,
 -3.763457812779759e-04,  5.159706795132361e-05, -4.875859058988425e-06,  3.552211890961757e-07, -2.121414654843424e-08,  1.079436480026266e-09, -4.804963379819817e-11,
  1.907340853742741e-12, -6.850288281025442e-14,  2.251391918517525e-15, -6.827694344556431e-17,  9.235269857831050e-04, -2.634927772597795e-04,  3.958311200518666e-05,
 -4.081928184720191e-06,  3.231560906119627e-07, -2.088895540477568e-08,  1.146241845828761e-09, -5.483947065212240e-11,  2.332407848639064e-12, -8.949670804523408e-14,
  3.134069005556436e-15, -1.010105329217446e-16,  5.899330038776213e-04, -1.827028445571257e-04,  2.979796009183458e-05, -3.325650299343918e-06,  2.839478838908957e-07,
 -1.972811076550779e-08,  1.159854936997411e-09, -5.927738736801997e-11,  2.685757360133581e-12, -1.095000979020691e-13,  4.064549805983394e-15, -1.385298244706680e-16,
  3.784785924486379e-04, -1.259729766569605e-04,  2.210892020742246e-05, -2.648998916417838e-06,  2.421128497683565e-07, -1.795512926515798e-08,  1.123660070379167e-09,
 -6.097058875992651e-11,  2.925753462563317e-12, -1.260458695971127e-13,  4.933240218925207e-15, -1.769069198938670e-16,  2.445092459825895e-04, -8.664663548086247e-05,
  1.622427576616371e-05, -2.070420774667024e-06,  2.010742249385963e-07, -1.580655558392652e-08,  1.046093360304188e-09, -5.989158874418765e-11,  3.025986757741775e-12,
 -1.369826744097820e-13,  5.622742343825703e-15, -2.110644079129415e-16,  1.592754698357617e-04, -5.956357475771962e-05,  1.180039046373263e-05, -1.591377204947536e-06,
  1.630187304506260e-07, -1.348996017488252e-08,  9.379305756444776e-10, -5.630638141561434e-11,  2.977502075762601e-12, -1.408263772589797e-13,  6.029443643555463e-15,
 -2.356835605814215e-16,  1.045435934899454e-04, -4.091315771675193e-05,  8.506389395729716e-06, -1.202947696699086e-06,  1.290299825346527e-07, -1.116162807333056e-08,
  8.098990355196243e-10, -5.065923645718085e-11,  2.786875837695313e-12, -1.369198924645629e-13,  6.080764407470356e-15, -2.461967764016122e-16,  6.885150875815471e-05,
 -2.797373022305490e-05,  6.055290058286858e-06, -8.911057865629261e-07,  9.934982241012224e-08, -8.921219118607479e-09,  6.710597273678652e-10, -4.345554861724152e-11,
  2.471729906879622e-12, -1.254031118333249e-13,  5.744362373811059e-15, -2.395968098504539e-16,  4.500988137237688e-05, -1.884121019102355e-05,  4.212979144926998e-06,
 -6.402706657462623e-07,  7.365580504545223e-08, -6.817479769414825e-09,  5.280296902347146e-10, -3.517071337713001e-11,  2.055552623931766e-12, -1.070521513092954e-13,
  5.028893257982393e-15, -2.148958091227949e-16,  2.848013878646184e-05, -1.219351448338427e-05,  2.794763991909315e-06, -4.353111200213223e-07,  5.129266213831257e-08,
 -4.859087965679930e-09,  3.848806612212359e-10, -2.619631606840699e-11,  1.563293636472513e-12, -8.306767803387029e-14,  3.978478028597365e-15, -1.732021328178962e-16,
  1.633820262875076e-05, -7.103957217226264e-06,  1.656255096761225e-06, -2.624045892752313e-07,  3.143693010125232e-08, -3.026430144676904e-09,  2.434767615759855e-10,
 -1.682250401039850e-11,  1.018538639918646e-12, -5.488194313490107e-14,  2.664134375872250e-15, -1.174917584119781e-16,  6.621127700580110e-06, -2.903579735289233e-06,
  6.833952764098668e-07, -1.093004620052072e-07,  1.321605545489245e-08, -1.283754876411635e-09,  1.041763697172731e-10, -7.258252507217842e-12,  4.430167068890396e-13,
 -2.405736123814729e-14,  1.176601010666199e-15, -5.226475746297084e-17,  1.057916924924436e-01, -4.792491526093716e-04,  2.307570790538604e-06, -1.159832245063654e-08,
  5.981254145898883e-11, -3.124740621757822e-13,  1.639794148739983e-15, -8.602416092848219e-18,  4.498824145219712e-20, -2.342541490842102e-22,  1.213680225431082e-24,
 -6.256352035323537e-27,  1.003451823799115e-01, -6.894401538691664e-04,  5.583150475325011e-06, -4.470013871883868e-08,  3.439900427382597e-10, -2.552821843673031e-12,
  1.838501403380501e-14, -1.291372602414667e-16,  8.879065503354487e-19, -5.992264620710841e-21,  3.977687158499066e-23, -2.601317900104331e-25,  9.031543189853103e-02,
 -1.042694078229183e-03,  1.255815528518081e-05, -1.365194311907820e-07,  1.374307696728759e-09, -1.306293646498520e-11,  1.186184759311736e-13, -1.037029858734291e-15,
  8.777666562305560e-18, -7.223397377589896e-20,  5.798303318885772e-22, -4.551640964865480e-24,  7.719692056650376e-02, -1.431114314182382e-03,  2.341273235637361e-05,
 -3.290696424449587e-07,  4.179784945679612e-09, -4.922584793373148e-11,  5.459274980602015e-13, -5.761312380476187e-15,  5.829240519832200e-17, -5.686521971005260e-19,
  5.371719309292176e-21, -4.930339283860596e-23,  6.273953622293842e-02, -1.745815670247148e-03,  3.730014678840447e-05, -6.610424751600229e-07,  1.034869122590435e-08,
 -1.477004841337243e-10,  1.959323582132815e-12, -2.447300270722964e-14,  2.904938757057903e-16, -3.299471093136262e-18,  3.605069284292783e-20, -3.804746655146623e-22,
  4.856217506793042e-02, -1.911937740278411e-03,  5.210054336202822e-05, -1.141732587985101e-06,  2.163938657146013e-08, -3.682051396281040e-10,  5.754226793366360e-12,
 -8.385663681119286e-14,  1.151941414487913e-15, -1.503667423006187e-17,  1.876655841005036e-19, -2.250064635712873e-21,  3.587296994028807e-02, -1.905462731992734e-03,
  6.495800442304842e-05, -1.731373666910800e-06,  3.915734410350755e-08, -7.840334180281662e-10,  1.426144807650404e-11, -2.397556067229050e-13,  3.770937992250184e-15,
 -5.599408137862423e-17,  7.904514302066901e-19, -1.066529166682555e-20,  2.535325415836905e-02, -1.749051742636500e-03,  7.329174110717204e-05, -2.342027177092660e-06,
  6.243053523752034e-08, -1.454796911681997e-09,  3.049056147279395e-11, -5.857632866409354e-13,  1.045486279224668e-14, -1.751046946987491e-16,  2.773338116475298e-18,
 -4.178210840950750e-20,  1.719382729783157e-02, -1.493751650041369e-03,  7.569378943747826e-05, -2.862623997383667e-06,  8.896070151249759e-08, -2.389291578466770e-09,
  5.718990895580868e-11, -1.245249227061482e-12,  2.502709959071053e-14, -4.693440655427779e-16,  8.281812495821622e-18, -1.383815064325446e-19,  1.122666728715322e-02,
 -1.197314146559823e-03,  7.226997208874128e-05, -3.196643716451405e-06,  1.146630764625644e-07, -3.518311052489890e-09,  9.541109123866000e-11, -2.337246604747906e-12,
  5.253007068580634e-14, -1.095831065930536e-15,  2.140887307628385e-17, -3.943743167898210e-19,  7.084773603666184e-03, -9.077526201282414e-04,  6.436217046252396e-05,
 -3.293331012050001e-06,  1.350932944543950e-07, -4.697155595883940e-09,  1.432519269666856e-10, -3.921130937963282e-12,  9.792516920657051e-14, -2.258762383599976e-15,
  4.857921770242262e-17, -9.811735302764774e-19,  4.339511870295603e-03, -6.556726189086788e-04,  5.391046601496935e-05, -3.158511121110936e-06,  1.468774302568213e-07,
 -5.742440899869514e-09,  1.955827543555482e-10, -5.943649634980710e-12,  1.639490680948377e-13, -4.157853552340499e-15,  9.791431007891819e-17, -2.157200533260339e-18,
  2.591875278612429e-03, -4.543182702856960e-04,  4.280417177812982e-05, -2.843698212202346e-06,  1.486666180274154e-07, -6.487668984898269e-09,  2.451228404517999e-10,
 -8.219375361484926e-12,  2.489819283489851e-13, -6.904915215003052e-15,  1.771329640551361e-16, -4.236029325960514e-18,  1.517130334469736e-03, -3.040261793189211e-04,
  3.245940345225904e-05, -2.422773001965169e-06,  1.412601209168867e-07, -6.831624460654378e-09,  2.844825041939722e-10, -1.046249604058547e-11,  3.461012160506266e-13,
 -1.044073877129779e-14,  2.903099804081038e-16, -7.499980205382013e-18,  8.749379496383576e-04, -1.978011481405988e-04,  2.368175063264735e-05, -1.968394067084720e-06,
  1.270041933361328e-07, -6.759524124488751e-09,  3.082544753744527e-10, -1.236074685777274e-11,  4.440673065793826e-13, -1.449605618513885e-14,  4.347323226302249e-16,
 -1.207555796396859e-17,  4.998986603321861e-04, -1.259433373698084e-04,  1.674178582698309e-05, -1.536410001936210e-06,  1.088700236922785e-07, -6.332953502812619e-09,
  3.142747407778669e-10, -1.365975953942405e-11,  5.300124797296807e-13, -1.862503117559329e-14,  5.994620505011507e-16, -1.781894216729712e-17,  2.845659254186236e-04,
 -7.898837253911866e-05,  1.154794929146782e-05, -1.160371125494858e-06,  8.962677339395364e-08, -5.659273695045258e-09,  3.036845970240456e-10, -1.422286597574269e-11,
  5.927276284879949e-13, -2.230450630104948e-14,  7.666185363890342e-16, -2.426947777938220e-17,  1.622900229057568e-04, -4.910286164173448e-05,  7.823203398101047e-06,
 -8.537169563965991e-07,  7.134528191412432e-08, -4.856655398126208e-09,  2.800202207819048e-10, -1.404716724468644e-11,  6.252207057881103e-13, -2.505971097903460e-14,
  9.151129553805523e-16, -3.070460785605465e-17,  9.321398791730084e-05, -3.043224530333517e-05,  5.237009362261042e-06, -6.156693207625147e-07,  5.525703456410089e-08,
 -4.027313027050151e-09,  2.478879990612481e-10, -1.323887505634023e-11,  6.257125075525214e-13, -2.656742068258259e-14,  1.025407354927171e-15, -3.628332465765577e-17,
  5.416666844330744e-05, -1.889939165937868e-05,  3.482505731377397e-06, -4.375379071155605e-07,  4.186144609154517e-08, -3.243945809768534e-09,  2.117650815696027e-10,
 -1.196610767206355e-11,  5.970331679276771e-13, -2.670352106624208e-14,  1.083518464491854e-15, -4.022534205437680e-17,  3.195269985510470e-05, -1.180611762938105e-05,
  2.309593248655868e-06, -3.076486757989255e-07,  3.114303918713032e-08, -2.547924476531109e-09,  1.752291548093077e-10, -1.041003277387031e-11,  5.449975057592255e-13,
 -2.553015855510220e-14,  1.083036740350057e-15, -4.196241285000299e-17,  1.915941069763319e-05, -7.431253499884767e-06,  1.530434749377243e-06, -2.144199970518129e-07,
  2.279280855252761e-08, -1.954683104792332e-09,  1.406611003704940e-10, -8.728587930138643e-12,  4.765261170325300e-13, -2.324095935914736e-14,  1.024924775711492e-15,
 -4.121837511047090e-17,  1.165143069834694e-05, -4.704275031568877e-06,  1.011457216324564e-06, -1.478614874099629e-07,  1.637942095188906e-08, -1.461725304450570e-09,
  1.092996155205088e-10, -7.037557163895302e-12,  3.981038898297954e-13, -2.009173931406699e-14,  9.157048491605727e-16, -3.800938248555898e-17,  7.121953647142642e-06,
 -2.969180225424655e-06,  6.609969017410444e-07, -1.000176037718877e-07,  1.145720379891718e-08, -1.056135969504567e-09,  8.147903318770936e-11, -5.406627426558546e-12,
  3.148441808333346e-13, -1.633976410944993e-14,  7.650061728547600e-16, -3.258535729014290e-17,  4.273637218421519e-06, -1.825432110329653e-06,  4.173145324714056e-07,
 -6.483462476213163e-08,  7.620458081027078e-09, -7.201702411557908e-10,  5.691130060805037e-11, -3.864931542411056e-12,  2.301481346361115e-13, -1.220391394129705e-14,
  5.833344705956588e-16, -2.534672454743636e-17,  2.361184818219955e-06, -1.025481651738695e-06,  2.387826443209835e-07, -3.778291978624264e-08,  4.520901681809384e-09,
 -4.347025038636320e-10,  3.493109808812164e-11, -2.410767495856222e-12,  1.458037051413591e-13, -7.848068629005835e-15,  3.805809340508058e-16, -1.676763626124243e-17,
  9.367908924367623e-07, -4.106173973744013e-07,  9.659241594760252e-08, -1.544039043804883e-08,  1.865976860723294e-09, -1.811586830317701e-10,  1.469345789402258e-11,
 -1.023222028276148e-12,  6.242322405398960e-14, -3.388188359116199e-15,  1.656331643523876e-16, -7.354125549320752e-18,  1.039107579009843e-01, -4.613294982146896e-04,
  2.173933401788604e-06, -1.068925841052292e-08,  5.393790938379994e-11, -2.758542070257927e-13,  1.417877257315586e-15, -7.288865660821924e-18,  3.736651287016374e-20,
 -1.907879941810268e-22,  9.694767754818714e-25, -4.902457612738782e-27,  9.767348212685091e-02, -6.468307218422996e-04,  5.078161425257638e-06, -3.958194954392600e-08,
  2.970689115512112e-10, -2.151949833460758e-12,  1.513658903266549e-14, -1.038897641500462e-16,  6.982679928159495e-19, -4.608249995223244e-21,  2.992296903401363e-23,
 -1.914794618225013e-25,  8.633571335821186e-02, -9.484268544763245e-04,  1.104370949146071e-05, -1.164752301431305e-07,  1.139319811819684e-09, -1.053504696703715e-11,
  9.315288647139067e-14, -7.936390351092861e-16,  6.550621573013402e-18, -5.259681879393583e-20,  4.121406427278635e-22, -3.159572385863183e-24,  7.182356963498696e-02,
 -1.258541352554513e-03,  1.983483170493684e-05, -2.694086134279565e-07,  3.314238109974883e-09, -3.786613520126054e-11,  4.079209990764846e-13, -4.185927302333964e-15,
  4.121758974682522e-17, -3.915931687488545e-19,  3.604927109736802e-21, -3.226280178172603e-23,  5.630653415362880e-02, -1.476538680619447e-03,  3.027131132752729e-05,
 -5.167559336017726e-07,  7.814411234273355e-09, -1.079497786349254e-10,  1.388173581834692e-12, -1.682911053621640e-14,  1.940869848858641e-16, -2.143748445271341e-18,
  2.279549050353772e-20, -2.342971264355839e-22,  4.166888967971157e-02, -1.544565246292026e-03,  4.025640998260288e-05, -8.476410204881622e-07,  1.548569061661040e-08,
 -2.545669080980901e-10,  3.850239001125612e-12, -5.438054488233680e-14,  7.248665484559596e-16, -9.190599111387926e-18,  1.115137234999457e-19, -1.300879787518824e-21,
  2.917246737882074e-02, -1.459335155064886e-03,  4.747770973911322e-05, -1.213763609413047e-06,  2.641895209575859e-08, -5.103460013071349e-10,  8.973343421546646e-12,
 -1.460489361781875e-13,  2.226837028192271e-15, -3.209088573274875e-17,  4.400945129947421e-19, -5.773797717865437e-21,  1.937307354000455e-02, -1.260132149060922e-03,
  5.033562411495659e-05, -1.541110469496790e-06,  3.949700999100633e-08, -8.871748307059944e-10,  1.795937000510914e-11, -3.338020783631923e-13,  5.772149682259298e-15,
 -9.377734936549354e-17,  1.442277975480562e-18, -2.112039209999825e-20,  1.224228037238401e-02, -1.004610060579783e-03,  4.851829946250239e-05, -1.757370021077365e-06,
  5.248514429648018e-08, -1.358229849001426e-09,  3.138998630940219e-11, -6.610646660707610e-13,  1.286920940291953e-14, -2.340673995640918e-16,  4.010266583495486e-18,
 -6.512807839633802e-20,  7.388663599646193e-03, -7.460424706541075e-04,  4.294535100119462e-05, -1.819796213016766e-06,  6.274073557834136e-08, -1.855098081916337e-09,
  4.857803690041501e-11, -1.151094360784737e-12,  2.506282033026879e-14, -5.071659747727872e-16,  9.622545711376079e-18, -1.723276077476481e-19,  4.277057534565518e-03,
 -5.202782510554643e-04,  3.522760491171593e-05, -1.728386648364639e-06,  6.819156329817044e-08, -2.286071545591552e-09,  6.735895237589198e-11, -1.784412330572220e-12,
  4.319331231826829e-14, -9.669477212566028e-16,  2.020708556553801e-17, -3.969975719274963e-19,  2.386025013560166e-03, -3.433613302829320e-04,  2.701237434913873e-05,
 -1.519678757518151e-06,  6.805066332933284e-08, -2.567948153697877e-09,  8.458195223424090e-11, -2.489914236765247e-12,  6.662847998187753e-14, -1.641360353079278e-15,
  3.758987824853559e-17, -8.062555356100195e-19,  1.289644690896205e-03, -2.160612862111069e-04,  1.952494555576263e-05, -1.247994192509144e-06,  6.293224173991909e-08,
 -2.654647201408861e-09,  9.713023377017183e-11, -3.159028469585552e-12,  9.294744937490410e-14, -2.506853305380342e-15,  6.261289409355544e-17, -1.459404459572762e-18,
  6.793248826635209e-04, -1.306116406829946e-04,  1.341360356227200e-05, -9.655640708395257e-07,  5.441614624901135e-08, -2.548666374534851e-09,  1.029574749587649e-10,
 -3.678722022783367e-12,  1.183859898241804e-13, -3.478426479472818e-15,  9.430598003237938e-17, -2.377961606034084e-18,  3.509624514349662e-04, -7.643308816703814e-05,
  8.830787351779276e-06, -7.098451147411568e-07,  4.437946942577468e-08, -2.292667175168349e-09,  1.016385200068038e-10, -3.967436647760103e-12,  1.389196821593886e-13,
 -4.424849456431730e-15,  1.296123594162275e-16, -3.519860530702012e-18,  1.790476701052651e-04, -4.363652324030077e-05,  5.617294140800386e-06, -5.000751318187695e-07,
  3.443174941207990e-08, -1.949095344207572e-09,  9.425432439422830e-11, -3.996984429089885e-12,  1.514806668189503e-13, -5.204660526062518e-15,  1.639412316343603e-16,
 -4.773393192183526e-18,  9.084220908085942e-05, -2.449662940435300e-05,  3.480963832989134e-06, -3.404341257507485e-07,  2.562801268336213e-08, -1.579202540885529e-09,
  8.279657290372889e-11, -3.792784622995960e-12,  1.547526085209344e-13, -5.706678262658799e-15,  1.923731269767531e-16, -5.977945298149886e-18,  4.617065640056767e-05,
 -1.362895889117215e-05,  2.118555624103372e-06, -2.257960927086812e-07,  1.845026892369307e-08, -1.229354889096209e-09,  6.944929901841833e-11, -3.416719872740009e-12,
  1.492690406561463e-13, -5.877257047318259e-15,  2.109879910857742e-16, -6.964393081675338e-18,  2.367574644248187e-05, -7.572428056941075e-06,  1.276261787061489e-06,
 -1.470571525869458e-07,  1.294776254501152e-08, -9.265575227994822e-10,  5.604330951559269e-11, -2.943534176378707e-12,  1.369173540185550e-13, -5.725239390994801e-15,
  2.177594521010137e-16, -7.597899053814324e-18,  1.233071682841555e-05, -4.231494645082046e-06,  7.665073631519346e-07, -9.472102916963934e-08,  8.919649639360933e-09,
 -6.807878727880400e-10,  4.380139523858893e-11, -2.440939869455066e-12,  1.201799920929901e-13, -5.307317187915067e-15,  2.127375795453885e-16, -7.806103527605170e-18,
  6.559147049697016e-06, -2.392350246560108e-06,  4.617222274077122e-07, -6.069845773578006e-08,  6.067088402323639e-09, -4.903802157320058e-10,  3.333536601714640e-11,
 -1.958479394148743e-12,  1.014457461422613e-13, -4.703902972675284e-15,  1.976040539449581e-16, -7.584763102370344e-18,  3.576432943696782e-06, -1.373848884118992e-06,
  2.800612245102853e-07, -3.884689155602558e-08,  4.089747931037782e-09, -3.474966823249773e-10,  2.478510410919497e-11, -1.524980329773747e-12,  8.257797523494188e-14,
 -3.996086649836033e-15,  1.749099982469185e-16, -6.983833890903629e-18,  1.998975897789569e-06, -8.016319005219787e-07,  1.711077436020519e-07, -2.483521800307772e-08,
  2.732153221997540e-09, -2.422038286025934e-10,  1.799528271402787e-11, -1.151595179101427e-12,  6.476207916155199e-14, -3.250064683178575e-15,  1.473257774327755e-16,
 -6.083622245166852e-18,  1.137517182790205e-06, -4.721550882087687e-07,  1.046103151205106e-07, -1.575444633035444e-08,  1.796468287546285e-09, -1.648721763631920e-10,
  1.266584091955596e-11, -8.370432643127131e-13,  4.855351058369374e-14, -2.510392007906144e-15,  1.171104818491017e-16, -4.971112907056283e-18,  6.449093546888969e-07,
 -2.747662812990673e-07,  6.264006271140694e-08, -9.705006828554667e-09,  1.137636028928242e-09, -1.072335489011366e-10,  8.452954966381844e-12, -5.726737278391815e-13,
  3.402264091189186e-14, -1.800085032759023e-15,  8.585813901073828e-17, -3.723000545977245e-18,  3.422025713286434e-07, -1.484378021569845e-07,  3.451639951792457e-08,
 -5.454131575343826e-09,  6.517428583475041e-10, -6.258667392107228e-11,  5.022950016485679e-12, -3.462399839810976e-13,  2.091624464132871e-14, -1.124575495653642e-15,
  5.447538230416582e-17, -2.397562455392965e-18,  1.326992827603999e-07, -5.813586194256190e-08,  1.366796933448275e-08, -2.183590936712463e-09,  2.637391205251899e-10,
 -2.559102680782694e-11,  2.074523599055434e-12, -1.443895552250241e-13,  8.804188434281148e-15, -4.776321152136050e-16,  2.333788941796448e-17, -1.035713244212695e-18,
  1.020994306329833e-01, -4.444368519137745e-04,  2.050664081581767e-06, -9.868606659376843e-09,  4.874525695418974e-11, -2.441451832656359e-13,  1.229547686783283e-15,
 -6.195948746289580e-18,  3.114719417963548e-20, -1.559963180347677e-22,  7.776971094000549e-25, -3.859158606086874e-27,  9.516451151183761e-02, -6.080277087332991e-04,
  4.630337699148688e-06, -3.515436630953603e-08,  2.574395018316348e-10, -1.821199140195528e-12,  1.251711614745912e-14, -8.398404700395663e-17,  5.520308510443581e-19,
 -3.564061222334997e-21,  2.264724475550038e-23, -1.418586579948869e-25,  8.271027051161663e-02, -8.653733545371435e-04,  9.748802113471076e-06, -9.981739993158865e-08,
  9.492909791812853e-10, -8.543995567388220e-12,  7.360222042287499e-14, -6.113862955927793e-16,  4.923203306063605e-18, -3.858620859941787e-20,  2.952774891784268e-22,
 -2.211608675658330e-24,  6.708748738554647e-02, -1.111947127716697e-03,  1.689672383675834e-05, -2.219447824613408e-07,  2.646041175487872e-09, -2.934555557059675e-11,
  3.072446408065707e-13, -3.067247860738766e-15,  2.940683119750789e-17, -2.722177700211982e-19,  2.443214958297732e-21, -2.132997299032523e-23,  5.084824526627162e-02,
 -1.257200025136836e-03,  2.475463115539924e-05, -4.073355818875988e-07,  5.953754798400735e-09, -7.965185838875411e-11,  9.934543702142313e-13, -1.169549502452767e-14,
  1.311122877279149e-16, -1.408910929379631e-18,  1.458636584503925e-20, -1.460644207684348e-22,  3.607578505872137e-02, -1.259345341494909e-03,  3.141828428561702e-05,
 -6.360541436913992e-07,  1.120742752060801e-08, -1.780894152730322e-10,  2.608129686082366e-12, -3.571840899774055e-14,  4.621858992048122e-16, -5.694344404622327e-18,
  6.719645471841812e-20, -7.629754281977667e-22,  2.401173421980719e-02, -1.131294237769862e-03,  3.514636298458886e-05, -8.622725816696420e-07,  1.807188661890216e-08,
 -3.369632198563653e-10,  5.729540695305041e-12, -9.031849736207568e-14,  1.335481620874772e-15, -1.868454599515356e-17,  2.490111788182285e-19, -3.177488631894645e-21,
  1.503435357869648e-02, -9.218880053699841e-04,  3.511647761437234e-05, -1.030525916111975e-06,  2.540264889183271e-08, -5.501974815518097e-10,  1.076127696359081e-11,
 -1.935695796632583e-13,  3.243861403788729e-15, -5.113503587303978e-17,  7.638742457073062e-19, -1.087522470993777e-20,  8.884305777038042e-03, -6.883682002714420e-04,
  3.168921487988299e-05, -1.099537912233735e-06,  3.156593485114172e-08, -7.872565680465418e-10,  1.757081324950299e-11, -3.579682856832417e-13,  6.751237426572331e-15,
 -1.191107978757389e-16,  1.981734483650023e-18, -3.128526626891806e-20,  4.974148822355327e-03, -4.752210581245956e-04,  2.608529482500417e-05, -1.058934920090983e-06,
  3.509221499407255e-08, -9.999064977999010e-10,  2.528525355967476e-11, -5.796004181833360e-13,  1.222603381769642e-14, -2.399987751657027e-16,  4.422351751347221e-18,
 -7.699781480649163e-20,  2.650461200705084e-03, -3.058502355686530e-04,  1.976862057373957e-05, -9.297978082109490e-07,  3.527782674485480e-08, -1.140163310092712e-09,
  3.245404372634369e-11, -8.319898234582458e-13,  1.951818618396656e-14, -4.240314842884904e-16,  8.609551354359466e-18, -1.645177411392117e-19,  1.351044982855022e-03,
 -1.849860682608528e-04,  1.391584477029665e-05, -7.514238489897937e-07,  3.239061595155296e-08, -1.179381616132537e-09,  3.755661839870886e-11, -1.070704714590750e-12,
  2.778840057921851e-14, -6.648043792938842e-16,  1.480320867805942e-17, -3.090446821438303e-19,  6.626771261284783e-04, -1.059880507884731e-04,  9.179075501317751e-06,
 -5.641111766017650e-07,  2.742321814754126e-08, -1.117639512191110e-09,  3.958339505769380e-11, -1.248192263746608e-12,  3.565791786540358e-14, -9.349572776007393e-16,
  2.272845057218817e-17, -5.161640328478656e-19,  3.148201400482773e-04, -5.799746777997816e-05,  5.723621637656514e-06, -3.970168240392326e-07,  2.161136253103830e-08,
 -9.796433507856667e-10,  3.836809210515284e-11, -1.331162010239581e-12,  4.165299981336495e-14, -1.191437011421727e-15,  3.148112704098288e-17, -7.744400647326056e-19,
  1.459148295355841e-04, -3.056834042415647e-05,  3.404287827147092e-06, -2.643813099276610e-07,  1.600238516617972e-08, -8.017944185258934e-10,  3.452949155464003e-11,
 -1.311189574858483e-12,  4.471916341469612e-14, -1.388996539766524e-15,  3.971697655839915e-17, -1.053926663732458e-18,  6.650389458364679e-05, -1.565586792717928e-05,
  1.949247446466604e-06, -1.681532936043879e-07,  1.123897638205116e-08, -6.185688412615851e-10,  2.912470099485501e-11, -1.204076550760374e-12,  4.453937817302129e-14,
 -1.495216148631549e-15,  4.606230269744452e-17, -1.312897209587265e-18,  3.005994076522920e-05, -7.863335476356709e-06,  1.084663237706409e-06, -1.031267242804379e-07,
  7.558569974628971e-09, -4.540917939063041e-10,  2.324026463895842e-11, -1.040407332871978e-12,  4.152895815490287e-14, -1.499611455796855e-15,  4.954552423270903e-17,
 -1.510229409560699e-18,  1.359521697434007e-05, -3.909770673159767e-06,  5.922099015246674e-07, -6.157386496819796e-08,  4.914220093064584e-09, -3.201858135838295e-10,
  1.770638398517142e-11, -8.535651204970986e-13,  3.657271746271603e-14, -1.413473410769289e-15,  4.984654597348876e-17, -1.617530284438213e-18,  6.208350435282556e-06,
 -1.942767073259538e-06,  3.202991379797458e-07, -3.613262123214809e-08,  3.117642839263076e-09, -2.188435494341084e-10,  1.299578565889623e-11, -6.706977097509957e-13,
  3.067832775314063e-14, -1.262395977615907e-15,  4.728245812404081e-17, -1.625632765453681e-18,  2.887979789100898e-06, -9.736221055949508e-07,  1.731869033569974e-07,
 -2.102837358510494e-08,  1.947121501525991e-09, -1.462415498596946e-10,  9.265621905674895e-12, -5.088238189812364e-13,  2.470267733026890e-14, -1.076338158056596e-15,
  4.259159383316138e-17, -1.543689066190056e-18,  1.379465100352566e-06, -4.961892143382315e-07,  9.438874968955797e-08, -1.223505613091185e-08,  1.206534185267506e-09,
 -9.626642795132694e-11,  6.463603276778906e-12, -3.752748374702415e-13,  1.921967136302666e-14, -8.815769664363069e-16,  3.665081041038201e-17, -1.392867469078412e-18,
  6.807761483153089e-07, -2.588041057954304e-07,  5.218111035056065e-08, -7.160630033915327e-09,  7.461015642861053e-10, -6.276866342713336e-11,  4.434616488232506e-12,
 -2.703822066095512e-13,  1.451422014604471e-14, -6.965276497550270e-16,  3.024419274912811e-17, -1.198380553312767e-18,  3.480315695705214e-07, -1.385469598571115e-07,
  2.934141909348482e-08, -4.225994459526230e-09,  4.614557376381524e-10, -4.061598917702227e-11,  2.997044339463222e-12, -1.905357889432576e-13,  1.064776251634224e-14,
 -5.311331840909738e-16,  2.393709401840410e-17, -9.829787330608755e-19,  1.835245263017943e-07, -7.581381988732464e-08,  1.671071743226650e-08, -2.503861154921104e-09,
  2.841077762783893e-10, -2.595060751907420e-11,  1.984505612186248e-12, -1.305762599249012e-13,  7.542441876559699e-15, -3.884021131931015e-16,  1.804906845398250e-17,
 -7.633132118768439e-19,  9.791249942353088e-08, -4.160125386767496e-08,  9.455540927625139e-09, -1.460605065016563e-09,  1.707183848815694e-10, -1.604692436393749e-11,
  1.261535428808345e-12, -8.524579265705591e-14,  5.051869984521305e-15, -2.666475323939233e-16,  1.268897605427502e-17, -5.490093506598953e-19,  4.974587349563902e-08,
 -2.154959774835813e-08,  5.003572227476951e-09, -7.894822750956774e-10,  9.420426786756052e-11, -9.033851970974797e-12,  7.240474604478796e-13, -4.984512803549818e-14,
  3.007366036696578e-15, -1.614980840219432e-16,  7.814003292149523e-18, -3.435237493992418e-19,  1.882086095885629e-08, -8.241054260155433e-09,  1.936343602912474e-09,
 -3.091629428482675e-10,  3.731917952154335e-11, -3.619029141044474e-12,  2.932078828446202e-13, -2.039633595303001e-14,  1.242999672318644e-15, -6.739793393352762e-17,
  3.291485369695114e-18, -1.460002272886158e-19,  1.003537620782133e-01, -4.284923346396696e-04,  1.936764247693305e-06, -9.126199470779225e-09,  4.414395313698257e-11,
 -2.166102316548553e-13,  1.069211769773260e-15, -5.283405298558801e-18,  2.605267484828279e-20, -1.280317560733709e-22,  6.264082526663753e-25, -3.051328631122446e-27,
  9.280390968424732e-02, -5.726050591848115e-04,  4.232048275141555e-06, -3.131116889764188e-08,  2.238389861778478e-10, -1.547123442189138e-12,  1.039476322022107e-14,
 -6.820862861111602e-17,  4.386322699999135e-19, -2.771548041155518e-21,  1.724095284112211e-23, -1.057517987243018e-25,  7.939751996219133e-02, -7.919283566455132e-04,
  8.636781940304114e-06, -8.590532204697649e-08,  7.947758170994517e-10, -6.966372273923678e-12,  5.849538414821461e-14, -4.739673524961219e-16,  3.725187023891662e-18,
 -2.851196127026043e-20,  2.131660901852892e-22, -1.560506361845474e-24,  6.289413903487059e-02, -9.867491032330069e-04,  1.446926071447977e-05, -1.839301623284910e-07,
  2.126425706718490e-09, -2.290436785483054e-11,  2.331872683656801e-13, -2.265858065580671e-15,  2.116136434453031e-17, -1.909506238290598e-19,  1.671610176582545e-21,
 -1.424176477242050e-23,  4.618669834657721e-02, -1.077208836902496e-03,  2.038950583361988e-05, -3.236277124258507e-07,  4.574886367118303e-09, -5.930766837541896e-11,
  7.178292969934425e-13, -8.210293709935007e-15,  8.951049457509966e-17, -9.361960465187200e-19,  9.440588384186606e-21, -9.213976659533267e-23,  3.149672879900946e-02,
 -1.035731419638254e-03,  2.475416365428970e-05, -4.821408357552114e-07,  8.198477190566549e-09, -1.259967984879778e-10,  1.787605944648762e-12, -2.374886086820443e-14,
  2.984458664950540e-16, -3.574461427731409e-18,  4.103910928641277e-20, -4.537060994549522e-22,  1.998968702099011e-02, -8.870644497583062e-04,  2.633364265306959e-05,
 -6.203454756209368e-07,  1.252541981641057e-08, -2.255311607824835e-10,  3.710067460786706e-12, -5.666673514805441e-14,  8.128776850946861e-16, -1.104523423466440e-17,
  1.430958715849496e-19, -1.776545687224529e-21,  1.183910187831897e-02, -6.842654001610463e-04,  2.486657540857965e-05, -6.997340585032046e-07,  1.659649257589047e-08,
 -3.467475910208175e-10,  6.555016081167726e-12, -1.141467043802092e-13,  1.854368207396149e-15, -2.837065985414997e-17,  4.117536662266265e-19, -5.700608033567319e-21,
  6.565008010170278e-03, -4.801094331934842e-04,  2.107136446666261e-05, -7.005461692154892e-07,  1.933707732083560e-08, -4.648970540692656e-10,  1.002286259382904e-11,
 -1.975782041712421e-13,  3.610739490063097e-15, -6.180487421199311e-17,  9.987393726765931e-19, -1.532893473246701e-20,  3.421861761297169e-03, -3.091526201051036e-04,
  1.618043198743247e-05, -6.292864041763409e-07,  2.004658414600556e-08, -5.505057595849333e-10,  1.344455503459180e-11, -2.981519616228364e-13,  6.093520046388661e-15,
 -1.160449943623750e-16,  2.076834684859474e-18, -3.515678423899236e-20,  1.684259233438137e-03, -1.842288236779914e-04,  1.136335942773987e-05, -5.122692117756016e-07,
  1.868912567561556e-08, -5.822750171107230e-10,  1.601034674615805e-11, -3.971701320349358e-13,  9.029756029448504e-15, -1.903635672675003e-16,  3.755115861426474e-18,
 -6.978731207296576e-20,  7.870673445724258e-04, -1.024360253481164e-04,  7.364459743543858e-06, -3.815342753753099e-07,  1.582668692952659e-08, -5.558997960399197e-10,
  1.711088149212883e-11, -4.723274922875165e-13,  1.188697523057142e-14, -2.761257395874642e-16,  5.977016519644101e-18, -1.214323634716088e-19,  3.513687375385196e-04,
 -5.358791918609889e-05,  4.444285240251510e-06, -2.624526940048398e-07,  1.229368783141803e-08, -4.838685680673025e-10,  1.658185776508451e-11, -5.067744926053357e-13,
  1.405182931834581e-14, -3.580740632950938e-16,  8.469525314100988e-18, -1.873490112437034e-19,  1.509145462431201e-04, -2.660445967733569e-05,  2.520552434282281e-06,
 -1.683425452375434e-07,  8.845032334623006e-09, -3.878146714726904e-10,  1.471788572481375e-11, -4.955720532099683e-13,  1.507046287403001e-14, -4.194657876222407e-16,
  1.079716635500029e-17, -2.590222805632081e-19,  6.286013910734742e-05, -1.264981129790215e-05,  1.356402482411506e-06, -1.016765926679313e-07,  5.953159969103114e-09,
 -2.890800079833899e-10,  1.208522461745349e-11, -4.461432364088147e-13,  1.481202175122342e-14, -4.483795587429820e-16,  1.250865435311536e-17, -3.241694894858228e-19,
  2.561811417233261e-05, -5.816750333296895e-06,  6.995972166844316e-07, -5.841851673080643e-08,  3.786623642526958e-09, -2.024512328059505e-10,  9.273590572722675e-12,
 -3.734860179862274e-13,  1.347477474419753e-14, -4.416865608063787e-16,  1.329915285852430e-17, -3.708424157069052e-19,  1.031500205175224e-05, -2.613579398065318e-06,
  3.495076023551444e-07, -3.226823159716193e-08,  2.300256055172830e-09, -1.345997045969011e-10,  6.718574761165154e-12, -2.936930684519830e-13,  1.145956210708952e-14,
 -4.049068583016932e-16,  1.310202665736242e-17, -3.914848444525615e-19,  4.146517777654867e-06, -1.160065526836083e-06,  1.709969557474570e-07, -1.732370467027455e-08,
  1.348965501368696e-09, -8.585907749449146e-11,  4.643501832564865e-12, -2.191478684483510e-13,  9.201516533317357e-15, -3.487994699846189e-16,  1.207438746804196e-17,
 -3.849169441000383e-19,  1.682482783633563e-06, -5.144171087235885e-07,  8.285825983858485e-08, -9.140618412152805e-09,  7.720703846508266e-10, -5.310826110859595e-11,
  3.093456408899288e-12, -1.567354286731821e-13,  7.044152793489267e-15, -2.850242331348197e-16,  1.050472654907316e-17, -3.556363721091860e-19,  6.967558594108960e-07,
 -2.304827388648644e-07,  4.021275983869724e-08, -4.792345268463686e-09,  4.358989661874966e-10, -3.218619072109373e-11,  2.006402853390765e-12, -1.084860675449646e-13,
  5.189328917126795e-15, -2.229229869596511e-16,  8.702207270113746e-18, -3.113291952594446e-19,  2.976153736954488e-07, -1.054634852525996e-07,  1.975397814636743e-08,
 -2.522417358982506e-09,  2.451853083448800e-10, -1.929515563076908e-11,  1.278594399217605e-12, -7.330690157926982e-14,  3.709512993574043e-15, -1.682018558071501e-16,
  6.916151731933565e-18, -2.600813370263170e-19,  1.323041338580006e-07, -4.973471339737701e-08,  9.909945351977890e-09, -1.344318777498852e-09,  1.385264540271849e-10,
 -1.153091794274543e-11,  8.064222723480580e-13, -4.869239011500318e-14,  2.589612219479231e-15, -1.231711948494532e-16,  5.302794621198672e-18, -2.084063768806299e-19,
  6.155478652106455e-08, -2.431003469643065e-08,  5.104896549601053e-09, -7.291597152649088e-10,  7.898405166880178e-11, -6.898618923062334e-12,  5.053055191694870e-13,
 -3.189838853013793e-14,  1.770563324916519e-15, -8.774870825070057e-17,  3.930156614912635e-18, -1.604356574012972e-19,  2.993252723360922e-08, -1.230119625570700e-08,
  2.696277703930179e-09, -4.017776687944759e-10,  4.534641557647857e-11, -4.120789546559631e-12,  3.135799320239208e-13, -2.053577268376041e-14,  1.180848607801639e-15,
 -6.054524206101396e-17,  2.801859299935940e-18, -1.180225628779914e-19,  1.496329662574049e-08, -6.338640950933070e-09,  1.436010127236582e-09, -2.211055246125206e-10,
  2.576229322390217e-11, -2.414251576762546e-12,  1.892461689427530e-13, -1.275226116429544e-14,  7.537044420035642e-16, -3.967959814687404e-17,  1.883567293324146e-18,
 -8.130252317980961e-20,  7.255268994654451e-09, -3.138409123746394e-09,  7.275448901466866e-10, -1.146130956770652e-10,  1.365500994575654e-11, -1.307511153510290e-12,
  1.046436500158585e-13, -7.193898243194370e-15,  4.334563251146094e-16, -2.324689179339254e-17,  1.123387860635930e-18, -4.932786186993780e-20,  2.672931253840439e-09,
 -1.169727021781975e-09,  2.746681046541328e-10, -4.382635787925182e-11,  5.286963380074631e-12, -5.123875416097023e-13,  4.148785812781859e-14, -2.884318390125310e-15,
  1.756768183776797e-16, -9.520264552731949e-18,  4.646861803612839e-19, -2.060125225181917e-20,  9.867010390476316e-02, -4.134245915096730e-04,  1.831349093675147e-06,
 -8.453208261534250e-09,  4.005684597471958e-11, -1.926342591222114e-13,  9.322881275769876e-16, -4.518880749726741e-18,  2.186399847687234e-20, -1.054642014122638e-22,
  5.065415727883701e-25, -2.422918947183879e-27,  9.057890553194488e-02, -5.401929915616040e-04,  3.876823889015712e-06, -2.796435204447261e-08,  1.952443859090383e-10,
 -1.319068779734068e-12,  8.667328025648639e-15, -5.564429532936194e-17,  3.502260392022612e-19, -2.166591564466436e-21,  1.319916071700389e-23, -7.930799590828807e-26,
  7.636175807355500e-02, -7.267514923298675e-04,  7.677854062149413e-06, -7.423153197341007e-08,  6.684781015696823e-10, -5.709158553776550e-12,  4.674987421500877e-14,
 -3.696640129547612e-16,  2.837028471135894e-18, -2.121384135428957e-20,  1.550167493210666e-22, -1.109596734108462e-24,  5.916544511248683e-02, -8.792782183649443e-04,
  1.245204794033978e-05, -1.532882450189416e-07,  1.719534425322872e-09, -1.799860123732756e-11,  1.782754773011312e-13, -1.686909622525207e-15,  1.535368604023691e-17,
 -1.351102176279159e-19,  1.154121654127149e-21, -9.599616749975145e-24,  4.218114450409659e-02, -9.284669832564735e-04,  1.690885105593070e-05, -2.590554215979179e-07,
  3.543940601704998e-09, -4.454347350001893e-11,  5.234521420054762e-13, -5.819574311894014e-15,  6.172976891013841e-17, -6.286765817630710e-19,  6.177403026412113e-21,
 -5.878599048384928e-23,  2.771614054980968e-02, -8.587883038412093e-04,  1.967934626727295e-05, -3.690017424760769e-07,  6.058815374653331e-09, -9.010316299334613e-11,
  1.239047841383119e-12, -1.597596342823495e-14,  1.950631875123016e-16, -2.272032355591920e-18,  2.538941554369286e-20, -2.734002786216534e-22,  1.682001561100426e-02,
 -7.030788316026912e-04,  1.995740175557066e-05, -4.516767465193122e-07,  8.790457132898321e-09, -1.529215919719898e-10,  2.434862461052568e-12, -3.604866412072428e-14,
  5.018671778669003e-16, -6.625209352461708e-18,  8.346681647459746e-20, -1.008519465705671e-21,  9.452467781403443e-03, -5.148822518531566e-04,  1.785916190292020e-05,
 -4.820991488650405e-07,  1.100688756217095e-08, -2.219162432500827e-10,  4.056229816032308e-12, -6.840302761911418e-14,  1.077585498448415e-15, -1.600549631107050e-17,
  2.257458324963020e-19, -3.040045467425017e-21,  4.935060999029289e-03, -3.405352465396123e-04,  1.425204799161881e-05, -4.541365520931177e-07,  1.205617730079008e-08,
 -2.794878937256462e-10,  5.821964705787688e-12, -1.110748729338063e-13,  1.967378027797883e-15, -3.267850029703679e-17,  5.129892093668016e-19, -7.656102220954601e-21,
  2.403035132306672e-03, -2.051977450571997e-04,  1.024002442285053e-05, -3.815766137646995e-07,  1.168631838925581e-08, -3.093351923761190e-10,  7.297039785576825e-12,
 -1.565743439422593e-13,  3.100795733756832e-15, -5.729403545457526e-17,  9.959886912642170e-19, -1.639368131345564e-20,  1.096385491085363e-03, -1.135934861736333e-04,
  6.684535618866307e-06, -2.887953138332540e-07,  1.013054962195077e-08, -3.042516744214821e-10,  8.081062377064568e-12, -1.939834012500773e-13,  4.274005883907796e-15,
 -8.743464222515992e-17,  1.675595541612399e-18, -3.028511241367271e-20,  4.712801177473021e-04, -5.824868559379625e-05,  4.000140776638958e-06, -1.987651678995965e-07,
  7.932499717423354e-09, -2.687193453278693e-10,  7.993574921186813e-12, -2.136135098229532e-13,  5.212237196828945e-15, -1.175438525431510e-16,  2.473026929431144e-18,
 -4.888761346647050e-20,  1.920819512361834e-04, -2.790318914936111e-05,  2.214461943321921e-06, -1.255926469957321e-07,  5.666038229909431e-09, -2.152880500340820e-10,
  7.136262554825419e-12, -2.113138220096716e-13,  5.685389794925706e-15, -1.407605184558716e-16,  3.238588475603479e-18, -6.975988140118601e-20,  7.478343901693684e-05,
 -1.259940472069697e-05,  1.144906748040172e-06, -7.357094908252218e-08,  3.728808062259396e-09, -1.580489116897395e-10,  5.809139421833259e-12, -1.897450084779908e-13,
  5.605359038079719e-15, -1.517528933694173e-16,  3.803735280513434e-18, -8.895270341748945e-20,  2.804985876771883e-05, -5.414569980580028e-06,  5.583989856459471e-07,
 -4.036524932025841e-08,  2.284334826955084e-09, -1.074263874672060e-10,  4.356844539122173e-12, -1.562683967584575e-13,  5.047476758154122e-15, -1.488312331508734e-16,
  4.048775596150374e-18, -1.024227487800877e-19,  1.023423936261374e-05, -2.237910368322512e-06,  2.596916618723831e-07, -2.096846099484019e-08,  1.316863888423023e-09,
 -6.833547333584819e-11,  3.042894679784427e-12, -1.192970259678352e-13,  4.195033525060277e-15, -1.341771077192127e-16,  3.946275166665382e-18, -1.075909275481979e-19,
  3.671766676489776e-06, -8.997554341187640e-07,  1.164964202636747e-07, -1.043213817395164e-08,  7.225293973639658e-10, -4.114090050449578e-11,  2.001056743795139e-12,
 -8.534385356085193e-14,  3.252644078515569e-15, -1.123736386197993e-16,  3.558791700271510e-18, -1.041664527703884e-19,  1.310860688355492e-06, -3.562331352357330e-07,
  5.103217019666934e-08, -5.031619840778712e-09,  3.818515508196500e-10, -2.371806178946437e-11,  1.253320168220602e-12, -5.785703060215807e-14,  2.378590910171317e-15,
 -8.836522978714169e-17,  3.000467539617879e-18, -9.390032324302057e-20,  4.716928006696970e-07, -1.407098569567692e-07,  2.211392806128327e-08, -2.382787406591972e-09,
  1.968088672975798e-10, -1.325272396842238e-11,  7.564613644489865e-13, -3.759417823566573e-14,  1.658719115346546e-15, -6.594297612221665e-17,  2.389687891151951e-18,
 -7.960655034151405e-20,  1.733707149098024e-07, -5.619978336386586e-08,  9.605829957183052e-09, -1.122340594849467e-09,  1.001748831109437e-10, -7.264816310672143e-12,
  4.451643948721999e-13, -2.367909675477516e-14,  1.115089846679766e-15, -4.719088967011691e-17,  1.815996121593077e-18, -6.408530119518346e-20,  6.595566025374104e-08,
 -2.300000600140205e-08,  4.237356581783412e-09, -5.324728276996002e-10,  5.096942611987172e-11, -3.952741139946197e-12,  2.582893731059588e-13, -1.461219709094187e-14,
  7.300311561369225e-16, -3.270018878089890e-17,  1.328939882111312e-18, -4.941901997577539e-20,  2.628517741006108e-08, -9.761763143861128e-09,  1.920541242394578e-09,
 -2.573247300089890e-10,  2.620296629329928e-11, -2.156465671783784e-12,  1.491831648213671e-13, -8.914667441300933e-15,  4.694212038667592e-16, -2.211602995552239e-17,
  9.435141702112111e-19, -3.675990288308100e-20,  1.107176273627705e-08, -4.335066501710280e-09,  9.020250048909258e-10, -1.276905262017152e-10,  1.371267734298852e-11,
 -1.187809045372619e-12,  8.631653691192068e-14, -5.407701755841854e-15,  2.979896396028200e-16, -1.466596436551346e-17,  6.525102269990912e-19, -2.646751845235406e-20,
  4.939349041871489e-09, -2.018494615698366e-09,  4.397554138053286e-10, -6.513898641456214e-11,  7.309614174104898e-12, -6.605819126446089e-13,  5.000214091794160e-14,
 -3.257933671906481e-15,  1.864271448922322e-16, -9.514090198097112e-18,  4.383188150726817e-19, -1.838442954796959e-20,  2.303019306961176e-09, -9.724183911939030e-10,
  2.195203595040969e-10, -3.368175233251582e-11,  3.911148461005677e-12, -3.653268349557910e-13,  2.854705288976026e-14, -1.917835666261484e-15,  1.130233748066410e-16,
 -5.933736174474571e-18,  2.809210806717536e-19, -1.209479725694864e-20,  1.061903708277675e-09, -4.586307375669332e-10,  1.061369270944155e-10, -1.669160939118053e-11,
  1.985330288727259e-12, -1.897958645863656e-13,  1.516630044414956e-14, -1.041072923797176e-15,  6.263776749864660e-17, -3.354694561329063e-18,  1.618963770218757e-19,
 -7.099728852503250e-21,  3.801445841322762e-10, -1.662583053039022e-10,  3.901341405964103e-11, -6.220800382783888e-12,  7.499408199259777e-13, -7.263328286422956e-14,
  5.877353399214079e-15, -4.083523604088189e-16,  2.485677273040732e-17, -1.346247402172086e-18,  6.567319556794992e-20, -2.909926134760037e-21,  9.704507968588086e-02,
 -3.991689424084046e-04,  1.733632736907935e-06, -7.841946144635262e-09,  3.641805532190187e-11, -1.717020011145682e-13,  8.150104841152685e-16, -3.876268853099839e-18,
  1.840771645128726e-20, -8.718140754359947e-23,  4.111707833695600e-25, -1.931893672228147e-27,  8.847810987699521e-02, -5.104695169701234e-04,  3.559159756412506e-06,
 -2.504069851681947e-08,  1.708232197194376e-10, -1.128551561375664e-12,  7.255152245429500e-15, -4.558956908430998e-17,  2.809481034055344e-19, -1.702249331080583e-21,
  1.015966806138652e-23, -5.982019210836004e-26,  7.357220190570550e-02, -6.687182459321955e-04,  6.847669812734589e-06, -6.439172915159732e-08,  5.647266747953826e-10,
 -4.701775105987962e-12,  3.756347101751258e-14, -2.899908395894870e-16,  2.174109522806751e-18, -1.588877404599321e-20,  1.135242309293120e-22, -7.948391460202775e-25,
  5.583654114141990e-02, -7.865778806276457e-04,  1.076649666876655e-05, -1.284381143034791e-07,  1.398791559756408e-09, -1.423546755167292e-11,  1.372482850347049e-13,
 -1.265270049490895e-15,  1.122812864652167e-17, -9.639744491904289e-20,  8.038129959850332e-22, -6.529807097666779e-24,  3.871940685328055e-02, -8.047304142231776e-04,
  1.411307439998471e-05, -2.088483846091452e-07,  2.766571544952502e-09, -3.373210880602365e-11,  3.850694081124246e-13, -4.163284511141900e-15,  4.298550160936329e-17,
 -4.264601583584021e-19,  4.084872443168723e-21, -3.791691643664978e-23,  2.456997112073788e-02, -7.175447858669036e-04,  1.577835028402803e-05, -2.850017887413125e-07,
  4.521238507288701e-09, -6.509770040665989e-11,  8.680850335487910e-13, -1.086795121125203e-14,  1.289815141313129e-16, -1.461625116419857e-18,  1.590342121776637e-20,
 -1.668641227454725e-22,  1.429578441512395e-02, -5.629224900741546e-04,  1.528965645580396e-05, -3.326349723254839e-07,  6.243155093184088e-09, -1.049818154601151e-10,
  1.618616767228466e-12, -2.323846914888606e-14,  3.141073711198412e-16, -4.030024513896190e-18,  4.938919903224633e-20, -5.809818392833851e-22,  7.645867413054785e-03,
 -3.924617608990560e-04,  1.299967783951803e-05, -3.367935707062470e-07,  7.405006130318282e-09, -1.441296106730213e-10,  2.548139682239468e-12, -4.162852383138866e-14,
  6.361396479029057e-16, -9.175828148128727e-18,  1.258058656860143e-19, -1.648358945003238e-21,  3.770564178636728e-03, -2.454184092587292e-04,  9.797323382218477e-06,
 -2.993060291503444e-07,  7.644394383561065e-09, -1.709280513994370e-10,  3.441225036227341e-12, -6.355818683658778e-14,  1.091347848556813e-15, -1.759470716478869e-17,
  2.683700320156466e-19, -3.895425653279058e-21,  1.721022094166308e-03, -1.388295757819387e-04,  6.606017590055738e-06, -2.358846336430032e-07,  6.946552993669678e-09,
 -1.772649835529352e-10,  4.039639743893372e-12, -8.388113622597385e-14,  1.609899475278642e-15, -2.886472735956617e-17,  4.874506768890719e-19, -7.802082340020159e-21,
  7.303723524109484e-04, -7.162602252514498e-05,  4.020403361497123e-06, -1.664509239170089e-07,  5.614045134187555e-09, -1.625330298107585e-10,  4.170121610801113e-12,
 -9.686662558328864e-14,  2.068347164473911e-15, -4.105987135904614e-17,  7.644542012502720e-19, -1.343744576130939e-20,  2.897634953739702e-04, -3.398025392582857e-05,
  2.228051425352603e-06, -1.061552718772117e-07,  4.075097030043856e-09, -1.331191782903627e-10,  3.826400626204794e-12, -9.897871403862074e-14,  2.341284431597048e-15,
 -5.125317411368250e-17,  1.047976724520728e-18, -2.015538634785690e-20,  1.081654182501887e-04, -1.495022740772197e-05,  1.134621843957438e-06, -6.177051088519841e-08,
  2.682933446060825e-09, -9.837845660943203e-11,  3.153308856756619e-12, -9.044407698309977e-14,  2.360558554113566e-15, -5.676869208191608e-17,  1.270189862531946e-18,
 -2.663631951272466e-20,  3.828066078605239e-05, -6.156023611580971e-06,  5.360658498350116e-07, -3.312010062925709e-08,  1.618304611618407e-09, -6.627599270480204e-11,
  2.358168356321189e-12, -7.468700614687455e-14,  2.142482410979699e-15, -5.639607165767662e-17,  1.376015513248571e-18, -3.135738001918935e-20,  1.295896001210523e-05,
 -2.396191035093709e-06,  2.374205517433048e-07, -1.653603494009830e-08,  9.038145744274707e-10, -4.113550415877927e-11,  1.617460500112229e-12, -5.633303791359834e-14,
  1.769276226913075e-15, -5.079044870159136e-17,  1.346681377272147e-18, -3.323878169070051e-20,  4.239511420564660e-06, -8.914670130935373e-07,  9.968850243888935e-08,
 -7.775211207011267e-09,  4.726759340689013e-10, -2.378745668973926e-11,  1.028899898870655e-12, -3.923974630110740e-14,  1.344012633487691e-15, -4.192033400658347e-17,
  1.203576944693983e-18, -3.206542121009659e-20,  1.356144701561178e-06, -3.208951993434580e-07,  4.017459582883357e-08, -3.485436275734185e-09,  2.343008047061068e-10,
 -1.296983693902235e-11,  6.141800638989956e-13, -2.553601592818176e-14,  9.498975236746428e-16, -3.206510725973739e-17,  9.931807287182106e-19, -2.845892434652836e-20,
  4.298004358284071e-07, -1.132789592469179e-07,  1.574980428386063e-08, -1.509469601389392e-09,  1.115216923633489e-10, -6.753096117208149e-12,  3.483375128634164e-13,
 -1.571499582533459e-14,  6.320614648120011e-16, -2.299459388125035e-17,  7.652937636413335e-19, -2.349494773292551e-20,  1.369337223532836e-07, -3.979512764353695e-08,
  6.094100627260041e-09, -6.405873943471129e-10,  5.168070270376286e-11, -3.403240202074840e-12,  1.901746756457372e-13, -9.261945107954939e-15,  4.008417905784813e-16,
 -1.564441820637150e-17,  5.570161089445678e-19, -1.824500140371992e-20,  4.454512556746180e-08, -1.413084777164034e-08,  2.363156669919573e-09, -2.703829296160768e-10,
  2.365583368182469e-11, -1.683242172014823e-12,  1.012927093080349e-13, -5.295720996250269e-15,  2.453085203926097e-16, -1.021928691493774e-17,  3.873756341705074e-19,
 -1.347466804813193e-20,  1.503425121239063e-08, -5.153143915835519e-09,  9.327401079979070e-10, -1.152236765161525e-10,  1.085069737309504e-11, -8.284709199694670e-13,
  5.333715642150527e-14, -2.974942881511411e-15,  1.466294413612561e-16, -6.483447064312553e-18,  2.602434768414404e-19, -9.563694938555394e-21,  5.345577683887861e-09,
 -1.959400102906942e-09,  3.802662517218034e-10, -5.027828097038689e-11,  5.054974558128962e-12, -4.109841398219709e-13,  2.810310000321539e-14, -1.660802811378232e-15,
  8.653030688591753e-17, -4.035589762066394e-18,  1.705031625363957e-19, -6.581581675064447e-21,  2.027657235414861e-09, -7.865235496783229e-10,  1.620446149863851e-10,
 -2.271809398116886e-11,  2.417083707317114e-12, -2.075120548349513e-13,  1.495158324836260e-14, -9.291058256982726e-16,  5.080048056881560e-17, -2.481636870757676e-18,
  1.096262712702604e-19, -4.416502718780887e-21,  8.254054692794367e-10, -3.352458962583397e-10,  7.255868742078815e-11, -1.067853953095620e-11,  1.190847796225564e-12,
 -1.069765918704781e-13,  8.051202825917134e-15, -5.217123712567636e-16,  2.969729689587087e-17, -1.507964603862456e-18,  6.913889218978931e-20, -2.886579516863172e-21,
  3.571928877867711e-10, -1.502861542792540e-10,  3.379614675483074e-11, -5.165768291760310e-12,  5.976476168948099e-13, -5.562677816060711e-14,  4.331985810103199e-15,
 -2.900823208111385e-16,  1.704200837301359e-17, -8.920297207705991e-19,  4.211020262036868e-20, -1.808037530702270e-21,  1.560184649783202e-10, -6.726952731244386e-11,
  1.553863036831626e-11, -2.439163660864272e-12,  2.895969659923955e-13, -2.763713676087850e-14,  2.204746099585909e-15, -1.510984432422099e-16,  9.076982626214242e-18,
 -4.854115263386701e-19,  2.339216838948411e-20, -1.024415962657769e-21,  5.414534693136859e-11, -2.366553629284404e-11,  5.549260141881045e-12, -8.842070903637843e-13,
  1.065188732774253e-13, -1.030942388990381e-14,  8.336574741191753e-16, -5.788367968284590e-17,  3.521186471464026e-18, -1.905900348288794e-19,  9.291847048534732e-21,
 -4.114740964838778e-22,  9.547555970105326e-02, -3.856666424777789e-04,  1.642915537741190e-06, -7.285702546595760e-09,  3.317115853570965e-11, -1.533804040240952e-13,
  7.142714914547531e-16, -3.334423117317397e-18,  1.554584962600909e-20, -7.231446155911644e-23,  3.349802232646086e-25, -1.546566830893493e-27,  8.649133868151430e-02,
 -4.831533845475412e-04,  3.274355061630294e-06, -2.247905096654132e-08,  1.498950477806400e-10, -9.687840360892145e-13,  6.095827239689520e-15, -3.750616154702509e-17,
  2.263899057430351e-19, -1.343938624975353e-21,  7.860940827858315e-24, -4.537216911925824e-26,  7.100220568507358e-02, -6.168809263887776e-04,  6.126231103293242e-06,
 -5.606202935341503e-08,  4.790872023540544e-10, -3.890325946678236e-12,  3.033761224114185e-14, -2.287589161530944e-16,  1.676077864719931e-18, -1.197645278921659e-20,
  8.370108675771339e-23, -5.734379475235414e-25,  5.285324227217372e-02, -7.062509975743515e-04,  9.350676375819175e-06, -1.081675062979789e-07,  1.144349154252869e-09,
 -1.132903638907874e-11,  1.063704119729700e-13, -9.558104901334995e-16,  8.273474287792898e-18, -6.932801039073195e-20,  5.645428246670803e-22, -4.480752647621779e-24,
  3.571142055623683e-02, -7.011462305364882e-04,  1.185174605558261e-05, -1.695152560039683e-07,  2.175650673649695e-09, -2.574700512425481e-11,  2.856542033890479e-13,
 -3.004849745512323e-15,  3.021217230307929e-17, -2.921077930565151e-19,  2.728580153157574e-21, -2.471394351743685e-23,  2.193219982173593e-02, -6.038603682905543e-04,
  1.275280625019804e-05, -2.220412758897426e-07,  3.405195396087121e-09, -4.749345496779340e-11,  6.144544769607957e-13, -7.472710850913619e-15,  8.624104643513844e-17,
 -9.511867287099737e-19,  1.008094373140982e-20, -1.030992695928916e-22,  1.226565171513607e-02, -4.550204592822661e-04,  1.183436993449409e-05, -2.476332928284436e-07,
  4.484629073036328e-09, -7.292889211743307e-11,  1.089303183748328e-12, -1.517198165690185e-14,  1.991834855786837e-16, -2.484622682951610e-18,  2.963084664491435e-20,
 -3.394495153758174e-22,  6.260998570153837e-03, -3.028155691370174e-04,  9.583682270060443e-06, -2.384099488610352e-07,  5.050262919038765e-09, -9.493487763984800e-11,
  1.624053227807927e-12, -2.571219248361022e-14,  3.812684672075523e-16, -5.342377112867154e-18,  7.122322147705248e-20, -9.081989262955271e-22,  2.925526742202104e-03,
 -1.795606325494919e-04,  6.839738746754533e-06, -2.003977537266524e-07,  4.925734187365850e-09, -1.062666165403769e-10,  2.068329442970752e-12, -3.699229398988977e-14,
  6.159349835638859e-16, -9.640557475821394e-18,  1.429078303352903e-19, -2.017840102557529e-21,  1.255823815270486e-03, -9.565323221300592e-05,  4.340385431043391e-06,
 -1.485394036128123e-07,  4.206977169527148e-09, -1.035168565249781e-10,  2.279369841361086e-12, -4.581004742835169e-14,  8.522120728771782e-16, -1.482905001516503e-17,
  2.433062285908697e-19, -3.787417010691994e-21,  4.974140302380527e-04, -4.614122744802249e-05,  2.470053242211298e-06, -9.799688560168691e-08,  3.178063040425708e-09,
 -8.869846890361880e-11,  2.198463399075913e-12, -4.941942463160863e-14,  1.022696913972946e-15, -1.970175288313776e-17,  3.563701776277333e-19, -6.092310491712759e-21,
  1.827573561329164e-04, -2.031692059847760e-05,  1.271451064409250e-06, -5.807242435914320e-08,  2.144015131237387e-09, -6.752982310347720e-11,  1.875481978297619e-12,
 -4.695608837213979e-14,  1.076680355989610e-15, -2.287757201856377e-17,  4.545771825201337e-19, -8.505106114514337e-21,  6.268609015208112e-05, -8.235025345834315e-06,
  5.972975755406216e-07, -3.120081559978439e-08,  1.304247374343074e-09, -4.613976433208542e-11,  1.429709120636740e-12, -3.971159197427100e-14,  1.005216595912413e-15,
 -2.347666816256890e-17,  5.107314846913590e-19, -1.042476840539109e-20,  2.022655420633286e-05, -3.100881173275949e-06,  2.585476071282305e-07, -1.534873681882796e-08,
  7.226279109836046e-10, -2.858141158047787e-11,  9.840546105494110e-13, -3.020883663166406e-14,  8.411791501832244e-16, -2.152131946653733e-17,  5.109766564807667e-19,
 -1.134346324397906e-20,  6.195310202048328e-06, -1.095801991829980e-06,  1.042080085774661e-07, -6.987181063748443e-09,  3.685825572845205e-10, -1.622491231436688e-11,
  6.181641520697870e-13, -2.089446253940035e-14,  6.377858021705230e-16, -1.781644803556525e-17,  4.602136178232230e-19, -1.107788349261545e-20,  1.820660037235960e-06,
 -3.675942526792727e-07,  3.956570214571016e-08, -2.977896076099270e-09,  1.750877311829165e-10, -8.538379797170311e-12,  3.584839836726097e-13, -1.329047169024322e-14,
  4.431125771011381e-16, -1.346957130015213e-17,  3.773073972965933e-19, -9.817381616064022e-21,  5.197785551706853e-07, -1.185766958122274e-07,  1.433579436310918e-08,
 -1.203593745400149e-09,  7.844967558770196e-11, -4.217879801721781e-12,  1.942951761080530e-13, -7.869013025519316e-15,  2.854830237345953e-16, -9.409334942849571e-18,
  2.848535781213456e-19, -7.985450124346093e-21,  1.462299354312177e-07, -3.731913235224613e-08,  5.028956708273235e-09, -4.679322788137586e-10,  3.361914978082311e-11,
 -1.982664747752895e-12,  9.973631423982475e-14, -4.393456163000762e-15,  1.727327029367742e-16, -6.149037929580885e-18,  2.004393640247348e-19, -6.032413116337171e-21,
  4.119874341172974e-08, -1.164623583145755e-08,  1.735418365522790e-09, -1.777378142407922e-10,  1.399019531616190e-11, -8.999795381466114e-13,  4.918626734213401e-14,
 -2.345356336594719e-15,  9.947671774319156e-17, -3.808399596148788e-18,  1.331216663282221e-19, -4.284223285301712e-21,  1.183212736228534e-08, -3.667887760030557e-09,
  5.993622852343377e-10, -6.707254022544833e-11,  5.745663106219295e-12, -4.007162672401272e-13,  2.365810798350793e-14, -1.214593061741175e-15,  5.529499484942859e-17,
 -2.265680288994103e-18,  8.453351024471110e-20, -2.896259509499231e-21,  3.529655383603006e-09, -1.187648538239693e-09,  2.109479584529625e-10, -2.558871643729798e-11,
  2.368179869007988e-12, -1.778449657993546e-13,  1.127045095468474e-14, -6.192359719477845e-16,  3.008589575873052e-17, -1.312170874207428e-18,  5.198370790864011e-20,
 -1.886560034806522e-21,  1.114359680424617e-09, -4.027272305310517e-10,  7.701941946644340e-11, -1.003941376873471e-11,  9.956875948044650e-13, -7.990497630967502e-14,
  5.396442504138960e-15, -3.151538609162938e-16,  1.623515520768685e-17, -7.490266628283552e-19,  3.132059478728975e-20, -1.197119273502082e-21,  3.785633432928080e-10,
 -1.453608710919685e-10,  2.962930207681526e-11, -4.110770928812124e-12,  4.329973863712943e-13, -3.681868196430929e-14,  2.628630545058784e-15, -1.619211233551239e-16,
  8.779535402731249e-18, -4.254685722439357e-19,  1.865179345895793e-20, -7.459527212893032e-22,  1.398179971416439e-10, -5.641046707167360e-11,  1.212222228056870e-11,
 -1.771580639660517e-12,  1.962329440692609e-13, -1.751429079703907e-14,  1.310008772402531e-15, -8.438628071849133e-17,  4.776362999498672e-18, -2.412226346539816e-19,
  1.100264401466859e-20, -4.570957716040589e-22,  5.586263433246541e-11, -2.341306271056826e-11,  5.243064355123054e-12, -7.981002366980971e-13,  9.196693336024491e-14,
 -8.527117617000625e-15,  6.616160846359430e-16, -4.414771556047608e-17,  2.584879949691616e-18, -1.348631530688146e-19,  6.346794695595175e-21, -2.716983187854350e-22,
  2.301776782165998e-11, -9.906172313527634e-12,  2.283612319501828e-12, -3.577501539674741e-13,  4.239230192763372e-14, -4.038032419151425e-15,  3.215509124353508e-16,
 -2.199863922390421e-17,  1.319323512892062e-18, -7.044042853238845e-20,  3.389310738896535e-21, -1.482086990936227e-22,  7.724441054677779e-12, -3.373837090422182e-12,
  7.905154777010022e-13, -1.258622703481983e-13,  1.515096621697806e-14, -1.465306423647103e-15,  1.184051963457059e-16, -8.215560208413707e-18,  4.994324628377907e-19,
 -2.701488652572814e-20,  1.316219955239186e-21, -5.825069413496002e-23,  9.395863850413831e-02, -3.728642365834652e-04,  1.558573240051736e-06, -6.778604226924320e-09,
  3.026769378118226e-11, -1.373043568037519e-13,  6.274985138052738e-16, -2.876150348381057e-18,  1.316818602820426e-20, -6.018162138963988e-23,  2.738711147032944e-25,
 -1.242938340206591e-27,  8.460946209765409e-02, -4.579981896705831e-04,  3.018381784565504e-06, -2.022812957169759e-08,  1.319013502932096e-10, -8.343102546156924e-13,
  5.140215076532336e-15, -3.097880354946405e-17,  1.832182477693092e-19, -1.066028369460139e-21,  6.112928721770980e-24, -3.459841471396085e-26,  6.862861744729987e-02,
 -5.704374099138070e-04,  5.497033954743418e-06, -4.898159965127170e-08,  4.080725974990084e-10, -3.233401998213193e-12,  2.462276520391807e-14, -1.814229638520682e-16,
  1.299572985343691e-18, -9.082942273098483e-21,  6.211484323601430e-23, -4.165542081661692e-25,  5.017004618268694e-02, -6.363427259528558e-04,  8.155472335300930e-06,
 -9.154044778785740e-08,  9.412749139966192e-10, -9.069541286081398e-12,  8.296800659266190e-14, -7.269921237937652e-16,  6.140755215947095e-18, -5.024362676792315e-20,
  3.997019842085598e-22, -3.100709612889334e-24,  3.308436714874021e-02, -6.139140672315080e-04,  1.001056534009261e-05, -1.384786310906696e-07,  1.722978535526748e-09,
 -1.980069957056224e-11,  2.136112847752838e-13, -2.187205933893434e-15,  2.142443534553717e-17, -2.019542277362096e-19,  1.840387523777489e-21, -1.627147803612238e-23,
  1.970514668213708e-02, -5.116370025094862e-04,  1.038627776655641e-05, -1.744217629484162e-07,  2.587334139144461e-09, -3.497459339322838e-11,  4.392141426307277e-13,
 -5.191135398307483e-15,  5.828233495298032e-17, -6.258990625800419e-19,  6.463737798143047e-21, -6.445771522024028e-23,  1.061768642406985e-02, -3.711143700004369e-04,
  9.249397341450204e-06, -1.862598617550081e-07,  3.256473175677489e-09, -5.123829320067970e-11,  7.417511543962787e-13, -1.002682770855284e-14,  1.279042338496447e-16,
 -1.551776176147873e-18,  1.801449571693123e-20, -2.010458967962543e-22,  5.186721066694371e-03, -2.363477809211644e-04,  7.151177385284107e-06, -1.708996305553877e-07,
  3.489459752446112e-09, -6.337805602595010e-11,  1.049516822430670e-12, -1.610863953341351e-14,  2.318620219241355e-16, -3.157060427640903e-18,  4.093843010068018e-20,
 -5.081832160677139e-22,  2.303188445952322e-03, -1.332676162576537e-04,  4.845562816371284e-06, -1.362074112403883e-07,  3.223183109785968e-09, -6.711405031563417e-11,
  1.263271846188629e-12, -2.188514009121373e-14,  3.534464125544858e-16, -5.372166217158455e-18,  7.741183380279444e-20, -1.063511746781882e-21,  9.327980200061594e-04,
 -6.705573723600063e-05,  2.902018613722618e-06, -9.520455428312645e-08,  2.593845448580000e-09, -6.155595130429085e-11,  1.309938112089604e-12, -2.548636415161311e-14,
  4.596504320680535e-16, -7.763616215589531e-18,  1.237792938844970e-19, -1.874169384413126e-21,  3.459857381131285e-04, -3.033850716980892e-05,  1.548788105513130e-06,
 -5.888429684034676e-08,  1.836293239856667e-09, -4.941079302962713e-11,  1.183205433719811e-12, -2.574120856108910e-14,  5.163120898353623e-16, -9.653041284038967e-18,
  1.696481659109478e-19, -2.820762389600043e-21,  1.181249705905965e-04, -1.243833788659116e-05,  7.426879425850831e-07, -3.251294642353159e-08,  1.154334344197057e-09,
 -3.505378454114368e-11,  9.405829196146482e-13, -2.279208701422155e-14,  5.065734617488982e-16, -1.044725819030419e-17,  2.017183842899779e-19, -3.671355215550403e-21,
  3.735310406781718e-05, -4.659190829408343e-06,  3.227874974105791e-07, -1.617231262975756e-08,  6.504379625293366e-10, -2.219438402958990e-11,  6.647079346975442e-13,
 -1.787615322510734e-14,  4.387797262272474e-16, -9.950188453701761e-18,  2.104314424600179e-19, -4.180032214728676e-21,  1.102249174389765e-05, -1.609025347615560e-06,
  1.283563657438340e-07, -7.317326387924726e-09,  3.317865168581529e-10, -1.266835356176007e-11,  4.219015645323202e-13, -1.254937085427787e-14,  3.390934214847021e-16,
 -8.429771442490102e-18,  1.947052790500731e-19, -4.209454438541843e-21,  3.062992114996038e-06, -5.175349880579500e-07,  4.719046014159296e-08, -3.043690461290541e-09,
  1.548556243681993e-10, -6.589125271482199e-12,  2.431201956249646e-13, -7.971338196068396e-15,  2.363656510824977e-16, -6.422427962459559e-18,  1.615511715963587e-19,
 -3.790948601808235e-21,  8.103159414695768e-07, -1.568533344659484e-07,  1.623122631850113e-08, -1.177727919473401e-09,  6.691437481988809e-11, -3.159700658403281e-12,
  1.286794645762079e-13, -4.634672971194657e-15,  1.503239604718922e-16, -4.450810803270450e-18,  1.215731307368042e-19, -3.087800391424289e-21,  2.067392817239652e-07,
 -4.539801529847113e-08,  5.293349107333253e-09, -4.295919830945070e-10,  2.712259438180329e-11, -1.415096987221137e-12,  6.335801610948343e-14, -2.497621290729609e-15,
  8.830991565245836e-17, -2.839974165626960e-18,  8.397740429977325e-20, -2.301750462790175e-21,  5.164686678688480e-08, -1.274219702571940e-08,  1.661917638834722e-09,
 -1.499476633308489e-10,  1.046487005733432e-11, -6.004514800288317e-13,  2.942958219002018e-14, -1.264732284894748e-15,  4.856635451197387e-17, -1.690437892561719e-18,
  5.392999338570434e-20, -1.589999226711304e-21,  1.285662160758881e-08, -3.529503688250824e-09,  5.110418524660876e-10, -5.093146265655045e-11,  3.906787950794020e-12,
 -2.452498548208916e-13,  1.309602419030219e-14, -6.108240748047034e-16,  2.536827183892968e-17, -9.518924248859017e-19,  3.264012380123752e-20, -1.031332570388480e-21,
  3.252788520402279e-09, -9.838710349978160e-10,  1.568780296643254e-10, -1.714900326098464e-11,  1.436701931331742e-12, -9.810350041556451e-14,  5.676791258081134e-15,
 -2.859228065276505e-16,  1.278163725062045e-17, -5.146838861956592e-19,  1.888621259032428e-20, -6.368674739526677e-22,  8.546616127473073e-10, -2.819222768598289e-10,
  4.907542032633009e-11, -5.838719187692812e-12,  5.304673006283545e-13, -3.914257850245579e-14,  2.439390074154913e-15, -1.319083803519316e-16,  6.312131311443818e-18,
 -2.713307603969473e-19,  1.060108003893466e-20, -3.796638883521507e-22,  2.384652293573764e-10, -8.487457007621291e-11,  1.597772626450894e-11, -2.051119883236156e-12,
  2.004763339415243e-13, -1.586594775214981e-14,  1.057391479608071e-15, -6.097549518055133e-17,  3.103456992822969e-18, -1.415401171715777e-19,  5.853652574748497e-21,
 -2.213945058743788e-22,  7.214814853076682e-11, -2.739980506034423e-11,  5.520692836477682e-12, -7.573560925471347e-13,  7.891604671309153e-14, -6.641415926845280e-15,
  4.695039091267413e-16, -2.865009914874195e-17,  1.539545107969954e-18, -7.397098587745677e-20,  3.216267908691487e-21, -1.276273245826610e-22,  2.403358858349775e-11,
 -9.626168103938016e-12,  2.052593081126692e-12, -2.977001063628418e-13,  3.273493322255295e-14, -2.901274472892677e-15,  2.155568084201149e-16, -1.379686891523479e-17,
  7.761595102996973e-19, -3.897033015992450e-20,  1.767610378490853e-21, -7.304339568854500e-23,  8.815746768674055e-12, -3.679265226400948e-12,  8.201686444997242e-13,
 -1.242858230305463e-13,  1.425965991888422e-14, -1.316645451717446e-15,  1.017509277442601e-16, -6.763646744745884e-18,  3.945708754629871e-19, -2.051436886417834e-20,
  9.621977188418897e-22, -4.105887269862111e-23,  3.411131651242705e-12, -1.465109533812461e-12,  3.370017946705014e-13, -5.267982431747504e-14,  6.229228572042642e-15,
 -5.921517835229802e-16,  4.706121187581752e-17, -3.213608079718637e-18,  1.923820813399970e-19, -1.025374860469626e-20,  4.925486570883954e-22, -2.150397525987786e-23,
  1.103857430508216e-12, -4.817826097743383e-13,  1.127930355443071e-13, -1.794367651533719e-14,  2.158275404441093e-15, -2.085713387796658e-16,  1.684093690882086e-17,
 -1.167647460224438e-18,  7.093163848044689e-20, -3.834108205545992e-21,  1.866795257158581e-22, -8.256306625512697e-24,  9.249161490989548e-02, -3.607129943722360e-04,
  1.480047644803198e-06, -6.315498114649467e-09,  2.766592103850351e-11, -1.231650916835217e-13,  5.525544252517552e-16, -2.487421139815978e-18,  1.118634306738370e-20,
 -5.024578647782761e-23,  2.246684265904597e-25, -1.002746207273181e-27,  8.282427514096506e-02, -4.347874344672063e-04,  2.787777048747796e-06, -1.824477820417657e-08,
  1.163818163147977e-10, -7.207252975620952e-13,  4.349440985937403e-15, -2.568548203972329e-17,  1.488991495935895e-19, -8.494114483272785e-22,  4.776677416058702e-24,
 -2.651955909875213e-26,  6.643124822219940e-02, -5.287059737239185e-04,  4.946395165761310e-06, -4.293932063454706e-08,  3.489256179074917e-10, -2.699000330797432e-12,
  2.007919603371247e-14, -1.446225353106644e-16,  1.013222655826138e-18, -6.929225994487048e-21,  4.638486547198828e-23, -3.045966598683893e-25,  4.774854988180144e-02,
 -5.752499775946886e-04,  7.141695919753066e-06, -7.782952733183986e-08,  7.782556394763249e-10, -7.301940752802427e-12,  6.511191317454374e-14, -5.565908226040463e-16,
  4.589690977256176e-18, -3.668195142249285e-20,  2.851933942889369e-22, -2.163182700065402e-24,  3.077897965246669e-02, -5.400362539896864e-04,  8.502007822215136e-06,
 -1.138200470570163e-07,  1.373644286477240e-09, -1.533770162883452e-11,  1.609684186147164e-13, -1.605032269651847e-15,  1.532313387938767e-17, -1.408795220069828e-19,
  1.252948373346156e-21, -1.081738100420614e-23,  1.781245091504172e-02, -4.362649413025037e-04,  8.520246244597641e-06, -1.380934945615134e-07,  1.982487082776673e-09,
 -2.598609065532126e-11,  3.169115131514241e-13, -3.641780845821849e-15,  3.979310064232285e-17, -4.162567607369535e-19,  4.190312378810439e-21, -4.075940751256491e-23,
  9.268218732029319e-03, -3.052459442884256e-04,  7.295974171385765e-06, -1.414749242381765e-07,  2.389174795281571e-09, -3.638982101789192e-11,  5.108024707179616e-13,
 -6.704274298768396e-15,  8.312918549648356e-17, -9.812834151134990e-19,  1.109295911433339e-20, -1.206436577994102e-22,  4.343983692107293e-03, -1.864805586429582e-04,
  5.397588164024804e-06, -1.239797057445505e-07,  2.441173592920344e-09, -4.285845473078606e-11,  6.872861037267581e-13, -1.023057298291976e-14,  1.429884880137781e-16,
 -1.892541780030384e-18,  2.387742587666341e-20, -2.886227182479701e-22,  1.838410751441970e-03, -1.002566229246399e-04,  3.481021720634268e-06, -9.391487115787172e-08,
  2.140369841925630e-09, -4.303027040749393e-11,  7.835411805545201e-13, -1.315252623062480e-14,  2.060907590790561e-16, -3.042696590055786e-18,  4.263125468675325e-20,
 -5.699896302921387e-22,  7.046571443861422e-04, -4.778744190354906e-05,  1.972881813569767e-06, -6.205954813272950e-08,  1.626915245695862e-09, -3.724645324903467e-11,
  7.662065274866497e-13, -1.443478951406960e-14,  2.524366118958175e-16, -4.139441232716318e-18,  6.414240015048261e-20, -9.448127764184381e-22,  2.455545208039598e-04,
 -2.034135031496991e-05,  9.902505798649139e-07, -3.608159499917572e-08,  1.082104886263845e-09, -2.807558169817270e-11,  6.496138805127908e-13, -1.367932025925289e-14,
  2.659671819131413e-16, -4.826311693677340e-18,  8.241867076719922e-20, -1.332941849865684e-21,  7.816552618493771e-05, -7.789747310326756e-06,  4.436639563879085e-07,
 -1.861366729911800e-08,  6.354784113782537e-10, -1.860494732054806e-11,  4.823139308418242e-13, -1.131151575825820e-14,  2.436902890860157e-16, -4.877855112127795e-18,
  9.151857354688783e-20, -1.620271207603151e-21,  2.286332172918589e-05, -2.705088910269631e-06,  1.789167247017544e-07, -8.594995074687633e-09,  3.325184754236947e-10,
 -1.094187830575145e-11,  3.166822944521043e-13, -8.244720498988180e-15,  1.962084064415172e-16, -4.319676380452870e-18,  8.879637803874032e-20, -1.716328985149682e-21,
  6.189867071712690e-06, -8.593562785923481e-07,  6.554073143999808e-08, -3.586055621292200e-09,  1.565311862174087e-10, -5.767606215526031e-12,  1.857378338620121e-13,
 -5.351522178058131e-15,  1.402800144657682e-16, -3.387599141308500e-18,  7.609766951553561e-20, -1.601817303477897e-21,  1.565038780183731e-06, -2.522661026075493e-07,
  2.203490305810049e-08, -1.366096453298600e-09,  6.699330939426966e-11, -2.753903159283914e-12,  9.835582350172400e-14, -3.126770766337883e-15,  9.002724951960897e-17,
 -2.378385343951080e-18,  5.823683225691444e-20, -1.331722175090994e-21,  3.736047451117047e-07, -6.923136694582778e-08,  6.879835981274184e-09, -4.808066906446568e-10,
  2.637690234259990e-11, -1.205162446903919e-12,  4.757668326486872e-14, -1.663721085422481e-15,  5.246610434850822e-17, -1.512265035751122e-18,  4.025881908862440e-20,
 -9.976319838223977e-22,  8.532681058490028e-08, -1.800678486813759e-08,  2.022291456500174e-09, -1.584752321764719e-10,  9.682349880834466e-12, -4.897890446328549e-13,
  2.129730405873639e-14, -8.165706696971977e-16,  2.811880732858592e-17, -8.817430755021317e-19,  2.545091328531189e-20, -6.816429936978214e-22,  1.894192081409264e-08,
 -4.510320636829272e-09,  5.685729809881666e-10, -4.968346345020246e-11,  3.364508380403297e-12, -1.876352733381670e-13,  8.952071114936212e-15, -3.749968214098414e-16,
  1.405348175028925e-17, -4.779130963090312e-19,  1.491153139486618e-20, -4.303765964721412e-22,  4.164366196532893e-09, -1.108409430720759e-09,  1.557181547714298e-10,
 -1.508210100149295e-11,  1.126096969489889e-12, -6.890911276385323e-14,  3.591640038772439e-15, -1.637102164763623e-16,  6.651685680517253e-18, -2.444246106401699e-19,
  8.215338877337490e-21, -2.546663227891530e-22,  9.265086587843646e-10, -2.730065239810447e-10,  4.241568723078793e-11, -4.523348299890819e-12,  3.701706667202454e-13,
 -2.472074037246066e-14,  1.400583261756612e-15, -6.914042092191650e-17,  3.032210599883185e-18, -1.198901915507754e-19,  4.323251071318787e-21, -1.433760162240423e-22,
  2.137255678576099e-10, -6.901577339879661e-11,  1.175841612839265e-11, -1.370396018811523e-12,  1.220857339797144e-13, -8.842136007885670e-15,  5.413634664657039e-16,
 -2.878398319335171e-17,  1.355407033277612e-18, -5.737569327076884e-20,  2.209083423989028e-21, -7.801601048491675e-23,  5.246072493358070e-11, -1.836644532562514e-11,
  3.399390506625551e-12, -4.293073629862173e-13,  4.130976496662611e-14, -3.221007253296745e-15,  2.116447386791992e-16, -1.204106343282533e-17,  6.050153867684881e-19,
 -2.725631147532370e-20,  1.114090748616835e-21, -4.166782780852257e-23,  1.405607335435346e-11, -5.274561313638770e-12,  1.049527469498688e-12, -1.422381299123554e-13,
  1.464936714707739e-14, -1.219223512887436e-15,  8.528180840139068e-17, -5.151723086497517e-18,  2.741767645299872e-19, -1.305275519957869e-20,  5.625678247149580e-22,
 -2.213732966913950e-23,  4.196941259128642e-12, -1.667694076413829e-12,  3.526115679245109e-13, -5.072088259809411e-14,  5.533156236404650e-15, -4.866924373707977e-16,
  3.589888670042940e-17, -2.281900549540860e-18,  1.275265323940276e-19, -6.362769184713942e-21,  2.868686534108577e-22, -1.178645663522743e-23,  1.404920210131473e-12,
 -5.836410472123873e-13,  1.294558397725013e-13, -1.952140953844757e-14,  2.229183051453331e-15, -2.048977844041459e-16,  1.576609053963206e-17, -1.043678379004008e-18,
  6.064434436621586e-20, -3.141076028037775e-21,  1.467949838151033e-22, -6.242409958924084e-24,  5.079840114539116e-13, -2.177062675448646e-13,  4.995666970940894e-14,
 -7.790715419638474e-15,  9.191172880557937e-16, -8.717873963045505e-17,  6.913845184946587e-18, -4.711572448366133e-19,  2.815075779162170e-20, -1.497597707947380e-21,
  7.180944389061354e-23, -3.129712520541056e-24,  1.580337997197375e-13, -6.892016250080493e-14,  1.612120117502102e-14, -2.562394249570391e-15,  3.079416119326079e-16,
 -2.973398612376184e-17,  2.398901576163506e-18, -1.661943842740493e-19,  1.008819734790961e-20, -5.449004186935117e-22,  2.651175783576771e-23, -1.171728658305868e-24,
  9.107197409951445e-02, -3.491684146371718e-04,  1.406838577880038e-06, -5.891852235055146e-09,  2.532979297278222e-11, -1.107007205990744e-13,  4.876580685870680e-16,
 -2.156747980691469e-18,  9.529168878155755e-21, -4.208214416527828e-23,  1.849014688036176e-25, -8.120354291223259e-28,  8.112838652399908e-02, -4.133303714068501e-04,
  2.579554412429874e-06, -1.649254870804870e-08,  1.029555888805348e-10, -6.244576072881503e-13,  3.692607561707393e-15, -2.137525941573828e-17,  1.214960196563267e-19,
 -6.797641858076964e-22,  3.749987990857460e-24, -2.042879636400584e-26,  6.439243204648615e-02, -4.911049309673787e-04,  4.462920042331151e-06, -3.776348125075419e-08,
  2.994546160533712e-10, -2.262247295657572e-12,  1.644859678810497e-14, -1.158571967222894e-16,  7.941743876707609e-19, -5.316271857773207e-21,  3.484768851540875e-23,
 -2.241523463098201e-25,  4.555618694331900e-02, -5.216511144825098e-04,  6.277896093117118e-06, -6.646585673221534e-08,  6.466622023852581e-10, -5.910818874904865e-12,
  5.139971075646538e-14, -4.288212684712491e-16,  3.453455927054038e-18, -2.697117556625219e-20,  2.050119854382406e-22, -1.520955407977363e-24,  2.874671481068421e-02,
 -4.771319440169702e-04,  7.258554681730622e-06, -9.410020775467402e-08,  1.102150123035646e-09, -1.196270407672219e-11,  1.221937637886027e-13, -1.187025277303706e-15,
  1.104963297238295e-17, -9.912331276389636e-20,  8.607028714424013e-22, -7.258877449734259e-24,  1.619393236711209e-02, -3.742291987757317e-04,  7.037542020806380e-06,
 -1.101504707235727e-07,  1.531253318942311e-09, -1.947273188599633e-11,  2.307279826478397e-13, -2.579024264280666e-15,  2.743766637781551e-17, -2.796761478254423e-19,
  2.745403079026492e-21, -2.605732836204843e-23,  8.154068054763007e-03, -2.530703730179418e-04,  5.805613980482746e-06, -1.084632189745872e-07,  1.770191054312481e-09,
 -2.611242107631975e-11,  3.555692481465897e-13, -4.533124601036356e-15,  5.465746955888718e-17, -6.279814741226086e-19,  6.915287936473478e-21, -7.331512345119132e-23,
  3.675858719883517e-03, -1.486466505255776e-04,  4.118555514309589e-06, -9.097089879976721e-08,  1.728177411035493e-09, -2.934094411283658e-11,  4.558296092987937e-13,
 -6.582977378662334e-15,  8.937321239997343e-17, -1.150234978146367e-18,  1.412397980771155e-20, -1.662954593998030e-22,  1.486686410329619e-03, -7.639352159054667e-05,
  2.534116010381421e-06, -6.564505345089255e-08,  1.441445563645182e-09, -2.798986229378874e-11,  4.932219654079997e-13, -8.024605703613017e-15,  1.220330806041089e-16,
 -1.750541712843487e-18,  2.385424704951256e-20, -3.104651177809931e-22,  5.409144715715014e-04, -3.459146924829428e-05,  1.362665427065715e-06, -4.111180436236705e-08,
  1.037329417393154e-09, -2.291658987155261e-11,  4.558306629512448e-13, -8.317264783431728e-15,  1.410723181262139e-16, -2.246332770121141e-18,  3.383607630168680e-20,
 -4.849491440875194e-22,  1.776564127730404e-04, -1.389468384468626e-05,  6.450493447804531e-07, -2.252769098988154e-08,  6.498395633492749e-10, -1.625970789269910e-11,
  3.635743922007319e-13, -7.411479601167544e-15,  1.397030238791747e-16, -2.460824157588286e-18,  4.083784422635947e-20, -6.424774964472430e-22,  5.290182529515546e-05,
 -4.985711687029648e-06,  2.708037521798533e-07, -1.088755380258925e-08,  3.574278256609741e-10, -1.008896715178872e-11,  2.526955547767310e-13, -5.735925053185498e-15,
  1.197814311933243e-16, -2.327116397177635e-18,  4.242675837401849e-20, -7.306619672557956e-22,  1.436113311691317e-05, -1.610162139173350e-06,  1.016272699357959e-07,
 -4.679797100898404e-09,  1.741213823276705e-10, -5.524643151734066e-12,  1.544996470617533e-13, -3.893509061901640e-15,  8.982707364050328e-17, -1.919755000180237e-18,
  3.835398584438573e-20, -7.212848809549294e-22,  3.578815818119773e-06, -4.719981240441913e-07,  3.439298036486641e-08, -1.805252944030507e-09,  7.582904390085956e-11,
 -2.695415172923403e-12,  8.391169897995489e-14, -2.341285112543326e-15,  5.952363141269113e-17, -1.396000429827799e-18,  3.049196831972566e-20, -6.247774635074239e-22,
  8.258102456235372e-07, -1.268170790763465e-07,  1.060181713364840e-08, -6.313572972786315e-10,  2.982637717444057e-11, -1.183908849340265e-12,  4.091040923851328e-14,
 -1.260483097543657e-15,  3.522674572698648e-17, -9.045140159302211e-19,  2.155177701294878e-20, -4.800973855984276e-22,  1.783550089261086e-07, -3.159237692642502e-08,
  3.011621043499826e-09, -2.025375055504019e-10,  1.072029779594065e-11, -4.736208317460472e-13,  1.811333795145929e-14, -6.146322990835355e-16,  1.883529522413315e-17,
 -5.282525006209512e-19,  1.369938727561046e-20, -3.310609009192612e-22,  3.653645665732110e-08, -7.398000323634419e-09,  7.992567147371258e-10, -6.041327744630954e-11,
  3.568534752857416e-12, -1.748745562741598e-13,  7.379187319834068e-15, -2.749870098122434e-16,  9.216060797940891e-18, -2.816154408615101e-19,  7.929943299408233e-21,
 -2.074109364661996e-22,  7.215453726569724e-09, -1.655372084851589e-09,  2.014103062920277e-10, -1.702459404594272e-11,  1.117463282326852e-12, -6.051306963221000e-14,
  2.807819549370832e-15, -1.145508358303039e-16,  4.186317041091769e-18, -1.389874250272943e-19,  4.238229040953529e-21, -1.196680373909129e-22,  1.400937865246787e-09,
 -3.609040314792985e-10,  4.912332173546602e-11, -4.617810993797464e-12,  3.352106758882213e-13, -1.997382606266683e-14,  1.015146081017772e-15, -4.517651652922200e-17,
  1.794194753017508e-18, -6.451193717039134e-20,  2.123718555758495e-21, -6.453841256025691e-23,  2.737077167880572e-10, -7.843904992900103e-11,  1.185695138126450e-11,
 -1.231920880859674e-12,  9.835768313988367e-14, -6.416819936355286e-15,  3.555833348922783e-16, -1.718764409906370e-17,  7.388115449543926e-19, -2.865834025114647e-20,
  1.014712901001738e-21, -3.306983116467307e-23,  5.527153346746751e-11, -1.744572505402517e-11,  2.904987966020346e-12, -3.312257902636882e-13,  2.890033005836245e-14,
 -2.052181470155874e-15,  1.233101900922054e-16, -6.440380785332104e-18,  2.981607276755128e-19, -1.241855385230927e-20,  4.707989839787613e-22, -1.638306934632320e-23,
  1.188254007768404e-11, -4.086666567453613e-12,  7.427449886651582e-13, -9.217039761145952e-14,  8.722008488682319e-15, -6.693472278127050e-16,  4.332128848677179e-17,
 -2.429461286951389e-18,  1.204089850093753e-19, -5.354058748048476e-21,  2.161315350975776e-22, -7.987883852682713e-24,  2.803480927073273e-12, -1.038410119983125e-12,
  2.038414833298945e-13, -2.726531388386853e-14,  2.773047224292916e-15, -2.280456805481573e-16,  1.577041658098872e-17, -9.423731475880156e-19,  4.963708341375069e-20,
 -2.339866388881955e-21,  9.990155584672518e-23, -3.896038023885020e-24,  7.454942162639142e-13, -2.936680578399141e-13,  6.152370781187172e-14, -8.770749236266535e-15,
  9.486017784365664e-16, -8.275507988951934e-17,  6.056414007664226e-18, -3.821065025524500e-19,  2.120273445996998e-20, -1.050710763680663e-21,  4.706518137991666e-23,
 -1.921818324999356e-24,  2.262913779303740e-13, -9.353229449785996e-14,  2.063335917206367e-14, -3.094829734511921e-15,  3.515884075916147e-16, -3.215766158860994e-17,
  2.462775728594281e-18, -1.622980988111491e-19,  9.390118147398221e-21, -4.843695588603022e-22,  2.254791684784950e-23, -9.552640413351956e-25,  7.605095995945821e-14,
 -3.251514723430412e-14,  7.441725634908101e-15, -1.157542573893011e-15,  1.362216859952622e-16, -1.288971854619211e-17,  1.019888475572527e-18, -6.934910075531152e-20,
  4.134729893765052e-21, -2.195192764467326e-22,  1.050548188292199e-23, -4.570172971844443e-25,  2.266910682240422e-14, -9.877874797566388e-15,  2.308378277615234e-15,
 -3.665623409428924e-16,  4.401200986108225e-17, -4.245883040934334e-18,  3.422561295040456e-19, -2.369141132106359e-20,  1.436929820167146e-21, -7.755285171338362e-23,
  3.770410323780506e-24, -1.665167421728973e-25,  8.969737158732116e-02, -3.381897894508612e-04,  1.338496953929727e-06, -5.503671686415513e-09,  2.322809731424654e-11,
 -9.968848726291380e-14,  4.313202306207475e-16, -1.874693462944289e-18,  8.139164495459097e-21, -3.535345207735949e-23,  1.526387695439103e-25, -6.601021516817359e-28,
  7.951512279701457e-02, -3.934584933961681e-04,  2.391130482421249e-06, -1.494055321104214e-08,  9.130636166011565e-11, -5.425994018927878e-13,  3.145048285728388e-15,
 -1.785165050903733e-17,  9.952125888883567e-20, -5.462906702374596e-22,  2.957263552487340e-24, -1.581295617465807e-26,  6.249665964485146e-02, -4.571360706102029e-04,
  4.037079412058711e-06, -3.331377145964300e-08,  2.579086939063772e-10, -1.903704934971821e-12,  1.353342563644343e-14, -9.325492187753058e-17,  6.256729233900379e-19,
 -4.101126991313896e-21,  2.633258927222912e-23, -1.659690512112835e-25,  4.356521441563840e-02, -4.744509831216304e-04,  5.538690718019719e-06, -5.700183596042473e-08,
  5.398701159883254e-10, -4.809665727771601e-12,  4.080446460538555e-14, -3.323855160252882e-16,  2.615293106624917e-18, -1.996670112691207e-20,  1.484345028992832e-22,
 -1.077473182952992e-24,  2.694757278507909e-02, -4.232977331104279e-04,  6.227750128143551e-06, -7.823111941700916e-08,  8.897236930900131e-10, -9.392013031692659e-12,
  9.341482384068490e-14, -8.844651625885680e-16,  8.030987341771839e-18, -7.032215265464184e-20,  5.963782712452796e-22, -4.914942839392595e-24,  1.480179610835896e-02,
 -3.228273431639894e-04,  5.850796248283248e-06, -8.848806487807747e-08,  1.191800038251987e-09, -1.471119525727758e-11,  1.694328190226451e-13, -1.842972927407533e-15,
  1.909784778028483e-17, -1.897640048802765e-19,  1.817138915920377e-21, -1.683466824515930e-23,  7.227064155369675e-03, -2.113870829027687e-04,  4.658151516527293e-06,
 -8.389433667389299e-08,  1.323937401137515e-09, -1.892337336832413e-11,  2.500766336912269e-13, -3.098144286724224e-15,  3.633897753997333e-17, -4.065233797950502e-19,
  4.362241707926181e-21, -4.509842721530258e-23,  3.140864550059833e-03, -1.196357708604909e-04,  3.175211924359826e-06, -6.747751950392230e-08,  1.237348421993693e-09,
 -2.032443053414085e-11,  3.060220634999060e-13, -4.289395692290962e-15,  5.658745342919168e-17, -7.084015288426192e-19,  8.468665607785706e-21, -9.715090431090283e-23,
  1.217171416256979e-03, -5.891819833198410e-05,  1.868173072584353e-06, -4.648628217842643e-08,  9.838772485524381e-10, -1.845978298015990e-11,  3.149027700423194e-13,
 -4.967470655470964e-15,  7.333772420964984e-17, -1.022449176877728e-18,  1.355423705412829e-20, -1.717666537057733e-22,  4.215835800133491e-04, -2.541268915699281e-05,
  9.555117048234843e-07, -2.765766044051599e-08,  6.718836592462509e-10, -1.432745907216510e-11,  2.756360838015505e-13, -4.872344608483083e-15,  8.017208380384052e-17,
 -1.239924344573450e-18,  1.815904620310072e-20, -2.532837359011767e-22,  1.309068093144704e-04, -9.660813161381667e-06,  4.277329898265573e-07, -1.432012657937449e-08,
  3.973944731347052e-10, -9.590831616061928e-12,  2.072852965928380e-13, -4.091244635967270e-15,  7.477581039815885e-17, -1.278748374296573e-18,  2.062506582361686e-20,
 -3.156822511468294e-22,  3.658381870840545e-05, -3.258100854528268e-06,  1.687424485409137e-07, -6.501129431852845e-09,  2.052344502220654e-10, -5.585503403506333e-12,
  1.351724793496398e-13, -2.969846027106786e-15,  6.011893053571815e-17, -1.133697898294250e-18,  2.008521415230174e-20, -3.364830497455406e-22,  9.248097223218024e-06,
 -9.816646035856546e-07,  5.910289320203353e-08, -2.608277624687942e-09,  9.331978588044963e-11, -2.854687091665142e-12,  7.713265569265638e-14, -1.881407057399997e-15,
  4.207692487852078e-17, -8.728874983884037e-19,  1.694780469302140e-20, -3.100764440282929e-22,  2.128405668128430e-06, -2.663638242920895e-07,  1.853227356603965e-08,
 -9.327719746386661e-10,  3.769168823018053e-11, -1.292154112613016e-12,  3.887775539628698e-14, -1.050255304555740e-15,  2.589163280846957e-17, -5.896194980982232e-19,
  1.252018536270287e-20, -2.496710339425300e-22,  4.496422752278994e-07, -6.569931396540295e-08,  5.252279867448080e-09, -3.002556938527622e-10,  1.365733464502910e-11,
 -5.232264025877215e-13,  1.748619874891477e-14, -5.219707380015729e-16,  1.415434112588773e-17, -3.531220229334805e-19,  8.184801689863012e-21, -1.775627603322974e-22,
  8.810905480695383e-08, -1.489649049757408e-08,  1.360776955024324e-09, -8.799104906643750e-11,  4.490320714128936e-12, -1.917034149836908e-13,  7.098541976597763e-15,
 -2.336082840607581e-16,  6.953288784390544e-18, -1.896605454456672e-19,  4.789273456596884e-21, -1.128203468246338e-22,  1.622640281942840e-08, -3.147356746065539e-09,
  3.266952965910186e-10, -2.379402879653722e-11,  1.357603361541461e-12, -6.439744022328649e-14,  2.635106319758782e-15, -9.537645489015177e-17,  3.109051797616432e-18,
 -9.252174943954921e-20,  2.540160198863125e-21, -6.484736624597329e-23,  2.854973372754899e-09, -6.299955746537466e-10,  7.387981734447414e-11, -6.033516708807298e-12,
  3.834539994201843e-13, -2.014353901180427e-14,  9.082059817351896e-16, -3.605647396735402e-17,  1.283990230280267e-18, -4.158811538637230e-20,  1.238555073711715e-21,
 -3.418940230363452e-23,  4.897346944099814e-10, -1.218965927601835e-10,  1.605078729298673e-11, -1.462514048344089e-12,  1.030947212327086e-13, -5.975222662190351e-15,
  2.958286101861798e-16, -1.284171200772062e-17,  4.980844350310316e-19, -1.750952689636937e-20,  5.641178023663574e-22, -1.679364074149385e-23,  8.394201795410741e-11,
 -2.335587545842381e-11,  3.429747452265397e-12, -3.466999042992303e-13,  2.697252224974302e-14, -1.717067848468657e-15,  9.296542352984822e-17, -4.395590916905655e-18,
  1.850205409321337e-19, -7.034751799198304e-21,  2.443683690820938e-22, -7.820121261707969e-24,  1.480128856365574e-11, -4.559138539786442e-12,  7.408883794009724e-13,
 -8.253351201277517e-14,  7.044187892829040e-15, -4.898539322589871e-16,  2.885609672649039e-17, -1.478995890603640e-18,  6.725403180326069e-20, -2.753702279796997e-21,
  1.027065971699040e-22, -3.518858816965615e-24,  2.775351947477618e-12, -9.363435040429733e-13,  1.668863712568878e-13, -2.032449237606082e-14,  1.889238589717522e-15,
 -1.425455250060388e-16,  9.078287917017056e-18, -5.013688249055730e-19,  2.448901946032302e-20, -1.073887846257193e-21,  4.277943212272757e-23, -1.561205074138340e-24,
  5.733248475673962e-13, -2.093770497576887e-13,  4.050299760929407e-14, -5.341312921776712e-15,  5.359390328550289e-16, -4.350950431511406e-17,  2.972231941662595e-18,
 -1.755487498126023e-19,  9.144471599659799e-21, -4.265282455511114e-22,  1.802792830655111e-23, -6.963409693967996e-25,  1.348754267856812e-13, -5.262849699968002e-14,
  1.091579600984692e-14, -1.541040595635944e-15,  1.651212502191201e-16, -1.427719053032907e-17,  1.036039620292872e-18, -6.483856995317278e-20,  3.570220685448039e-21,
 -1.756292935368713e-22,  7.812162171307025e-24, -3.168742997647713e-25,  3.687343541977988e-14, -1.515624080137894e-14,  3.323600902806768e-15, -4.956079552038361e-16,
  5.598814695083221e-17, -5.093460067618384e-18,  3.880848445621662e-19, -2.545021160310752e-20,  1.465625767276641e-21, -7.526545788572365e-23,  3.488829763232790e-24,
 -1.472104314343973e-25,  1.145170802825624e-14, -4.883278061702131e-15,  1.114444652159748e-15, -1.728615103498907e-16,  2.028734914790397e-17, -1.914640990630818e-18,
  1.511155975075472e-19, -1.025077715325386e-20,  6.097716757364486e-22, -3.230275722757619e-23,  1.542660162483744e-24, -6.697536492862598e-26,  3.258581684448796e-15,
 -1.418607748738826e-15,  3.311826483955319e-16, -5.253766643877144e-17,  6.301824012241003e-18, -6.073620983554211e-19,  4.891348926834907e-20, -3.382822685210007e-21,
  2.049970346429288e-22, -1.105467300087827e-23,  5.370129412219839e-25, -2.369814880797336e-26,  8.836561882604357e-02, -3.277398199767635e-04,  1.274618771008047e-06,
 -5.147427178007000e-09,  2.133373988294285e-11, -8.993840274440868e-14,  3.822919100004765e-16, -1.633479930959027e-18,  6.969687367858180e-21, -2.979108330906792e-23,
  1.263630603781463e-25, -5.387125513661442e-28,  7.797844543594384e-02, -3.750225596850278e-04,  2.220263974423313e-06, -1.356252988404125e-08,  8.117048327631262e-11,
 -4.727739167584630e-13,  2.686986289242067e-15, -1.496009702717263e-17,  8.182652502312539e-20, -4.408113892861067e-22,  2.342274711595203e-24, -1.229729120642726e-26,
  6.073027214753089e-02, -4.263711284035162e-04,  3.660871777655239e-06, -2.947502632120917e-08,  2.228822542488055e-10, -1.608103430336890e-12,  1.118176468496100e-14,
 -7.540580976710652e-17,  4.953560598055748e-19, -3.180436039972650e-21,  2.000989969582158e-23, -1.236182280046278e-25,  4.175189548376117e-02, -4.327376808757291e-04,
  4.903485942087081e-06, -4.908325388983557e-08,  4.527622209075074e-10, -3.933208596288413e-12,  3.256892455943004e-14, -2.591376869349517e-16,  1.992855217438540e-18,
 -1.487854962440919e-20,  1.082159894063494e-22, -7.688553987424535e-25,  2.534840407027766e-02, -3.770023452029579e-04,  5.368564214032972e-06, -6.538437554705613e-08,
  7.224377473292648e-10, -7.420381985271280e-12,  7.189762718446488e-14, -6.637669347621784e-16,  5.881346312023629e-18, -5.028742374721065e-20,  4.166757578920550e-22,
 -3.356801254815383e-24,  1.359780426039670e-02, -2.799652385901821e-04,  4.894313453242734e-06, -7.156849396867932e-08,  9.343919788409254e-10, -1.120083310316331e-11,
  1.254506217438334e-13, -1.328447860918223e-15,  1.341396329358136e-17, -1.299785775703020e-19,  1.214578674778893e-21, -1.098710533023591e-23,  6.450143248996257e-03,
 -1.778154702327516e-04,  3.767009110821696e-06, -6.544027040504457e-08,  9.990875487807072e-10, -1.384351700289214e-11,  1.776277073329874e-13, -2.139309061038137e-15,
  2.441922774637375e-17, -2.660839239112862e-19,  2.783256997480066e-21, -2.806823613689695e-23,  2.708434012879808e-03, -9.716492691146171e-05,  2.472042322949341e-06,
 -5.057023492719635e-08,  8.955421596425299e-10, -1.423793604221027e-11,  2.078580936554738e-13, -2.828792242553862e-15,  3.627608408597511e-17, -4.418821101641087e-19,
  5.144517859637920e-21, -5.751945704959637e-23,  1.008200345889120e-03, -4.596214851172677e-05,  1.393817984691937e-06, -3.333009906075101e-08,  6.802307745144633e-10,
 -1.233660304719128e-11,  2.038037420012654e-13, -3.118142133455464e-15,  4.470577411395700e-17, -6.059342844901117e-19,  7.816616249285315e-21, -9.647419710648256e-23,
  3.333510035927158e-04, -1.893306421208336e-05,  6.797135298541117e-07, -1.888213788953964e-08,  4.417765497328236e-10, -9.096122828532604e-12,  1.693030179969556e-13,
 -2.900086479677768e-15,  4.630532929038760e-17, -6.957379524239262e-19,  9.909026078882796e-21, -1.345338431292694e-22,  9.815433219443619e-05, -6.831221311388707e-06,
  2.884911681965747e-07, -9.260625823388197e-09,  2.472830332898429e-10, -5.757704326936316e-12,  1.203044910715950e-13, -2.299466421935324e-15,  4.075814343010623e-17,
 -6.767966618193061e-19,  1.061111582336587e-20, -1.580279921815076e-22,  2.582611384030473e-05, -2.171862500317510e-06,  1.072471483566016e-07, -3.959589400016145e-09,
  1.202117416269676e-10, -3.154651406018719e-12,  7.377211248347130e-14, -1.568974115015362e-15,  3.079068719439128e-17, -5.636300746549922e-19,  9.704154842910296e-21,
 -1.581528462917461e-22,  6.099696609486430e-06, -6.124204284884371e-07,  3.516089858791235e-08, -1.486834296912129e-09,  5.114909792485100e-11, -1.508449736136404e-12,
  3.937762616377856e-14, -9.296297754282956e-16,  2.015357623255644e-17, -4.058139411720200e-19,  7.656949173996838e-21, -1.362858389126979e-22,  1.300821816831115e-06,
 -1.543048307692979e-07,  1.024505857041815e-08, -4.942880806615776e-10,  1.920898511135294e-11, -6.349740660082306e-13,  1.846078735720179e-14, -4.827596389602782e-16,
  1.153864033663419e-17, -2.551029763953331e-19,  5.265346005318905e-21, -1.021727978777607e-22,  2.524183770412211e-07, -3.504710709198311e-08,  2.677198516915497e-09,
 -1.468318111464055e-10,  6.427490192902109e-12, -2.375735737555101e-13,  7.676096630751801e-15, -2.219208048062946e-16,  5.837377524734152e-18, -1.414555148928223e-19,
  3.188584492823319e-21, -6.734745096817228e-23,  4.501250569334005e-08, -7.253178036074665e-09,  6.342741341602754e-10, -3.940305679442701e-11,  1.937389494044242e-12,
 -7.988126019502779e-14,  2.862383438086048e-15, -9.131437508459347e-17,  2.638698049178279e-18, -6.996935875891463e-20,  1.719711337463181e-21, -3.947412408555421e-23,
  7.471485839293980e-09, -1.386004054227535e-09,  1.380572774144251e-10, -9.678993356384787e-12,  5.329776928074445e-13, -2.445296712619729e-14,  9.696314078221616e-16,
 -3.406511705740538e-17,  1.079416252489659e-18, -3.126529757215133e-20,  8.364658648129635e-22, -2.083163661534648e-23,  1.173356099024559e-09, -2.486077927637106e-10,
  2.806106829722200e-11, -2.211503064686600e-12,  1.359461392076342e-13, -6.921353081527654e-15,  3.029683971366632e-16, -1.169559026905173e-17,  4.055301385828367e-19,
 -1.280532990148953e-20,  3.722076188179171e-22, -1.003848131824297e-23,  1.779718605896249e-10, -4.272254073343424e-11,  5.433954906279717e-12, -4.792958546641856e-13,
  3.277055345192892e-14, -1.845486789367639e-15,  8.891761111562627e-17, -3.761586171843215e-18,  1.423643235896067e-19, -4.889018487192521e-21,  1.540359246289533e-22,
 -4.488830231704140e-24,  2.674853145339429e-11, -7.212868401461458e-12,  1.027352725845951e-12, -1.008989812330248e-13,  7.639196197105135e-15, -4.739845295473892e-16,
  2.504634858965979e-17, -1.157248042160094e-18,  4.765481873516690e-20, -1.774446252352490e-21,  6.042259653597341e-23, -1.897152143172246e-24,  4.109629567260242e-12,
 -1.233225860491703e-12,  1.952804116836693e-13, -2.122397258568454e-14,  1.769672111772424e-15, -1.203753100265497e-16,  6.944144358074220e-18, -3.489143471780177e-19,
  1.556911533816805e-20, -6.261035068592285e-22,  2.295468688091056e-23, -7.736869165316086e-25,  6.694772240271067e-13, -2.212349141399615e-13,  3.861346485333875e-14,
 -4.609103854029668e-15,  4.203394154232422e-16, -3.114659896724582e-17,  1.949872830693366e-18, -1.059444798191684e-19,  5.095154780172645e-21, -2.201563707153736e-22,
  8.647537316698589e-24, -3.113810356307259e-25,  1.204145789894452e-13, -4.330402920595272e-14,  8.245180886140147e-15, -1.070820392087869e-15,  1.058888515912333e-16,
 -8.478110491855148e-18,  5.715815623008127e-19, -3.333931335963578e-20,  1.716111713301185e-21, -7.914254189512930e-23,  3.309133761388828e-24, -1.265093397445232e-25,
  2.488984619811195e-14, -9.611600838688961e-15,  1.971909547558310e-15, -2.754474458451967e-16,  2.921599218588403e-17, -2.501858300166611e-18,  1.798881648167284e-19,
 -1.115989545990276e-20,  6.094041784607518e-22, -2.974152196359699e-23,  1.312970765650856e-24, -5.287467237410449e-26,  6.084628189059788e-15, -2.485741154383994e-15,
  5.415440313858911e-16, -8.023939614498956e-17,  9.009084796403047e-18, -8.148034815751722e-19,  6.173638790650667e-20, -4.027125348995163e-21,  2.307411350708765e-22,
 -1.179230832695337e-23,  5.441031390540136e-25, -2.285782124415749e-26,  1.735314989662415e-15, -7.378486407216275e-16,  1.678627741740304e-16, -2.595706307334013e-17,
  3.037322916035962e-18, -2.858345086251938e-19,  2.249841820107633e-20, -1.522183953857333e-21,  9.032236657158415e-23, -4.773456496394043e-24,  2.274437825349162e-25,
 -9.853138631295399e-27,  4.694634217694982e-16, -2.041778722158558e-16,  4.761477355831129e-17, -7.545256501222972e-18,  9.040860069439440e-19, -8.704530947185359e-20,
  7.003178591352386e-21, -4.838706166937334e-22,  2.929511828135258e-23, -1.578355847404020e-24,  7.660696224535561e-26, -3.377815782960529e-27,  8.707467025791450e-02,
 -3.177842770789968e-04,  1.214839897930349e-06, -4.819994085334793e-09,  1.962314332172023e-11, -8.128800097886428e-14,  3.395223580918246e-16, -1.426678602572374e-18,
  5.982754923361420e-21, -2.518044906351800e-23,  1.048759393007741e-25, -4.415251571388457e-28,  7.651287891838834e-02, -3.578900674909170e-04,  2.065004924529619e-06,
 -1.233607942663753e-08,  7.232742137426615e-11, -4.130309956113963e-13,  2.302499228179643e-15, -1.257848001415174e-17,  6.752113400648360e-20, -3.570979112101730e-22,
  1.862973038226358e-24, -9.606608033091695e-27,  5.908120395964198e-02, -3.984406844954837e-04,  3.327552154988181e-06, -2.615231272101356e-08,  1.932416163644360e-10,
 -1.363386745786850e-12,  9.276151710248967e-15, -6.124190725154913e-17,  3.940474355652504e-19, -2.478994755211618e-21,  1.528770471583495e-23, -9.260189767540175e-26,
  4.009583651982258e-02, -3.957483524972827e-04,  4.355487280223119e-06, -4.242824525415710e-08,  3.813621126166459e-10, -3.231885115646941e-12,  2.613093978332699e-14,
 -2.031628498800506e-16,  1.527630946051001e-18, -1.115724690497621e-20,  7.942180185385090e-23, -5.524820669326588e-25,  2.392158578080398e-02, -3.370064782030282e-04,
  4.648695585263101e-06, -5.492483499334891e-08,  5.898833239057977e-10, -5.898162192963562e-12,  5.569620441771415e-14, -5.015807337657318e-16,  4.338542803945254e-18,
 -3.623653484313839e-20,  2.934597906139162e-22, -2.311820340616958e-24,  1.255115074205315e-02, -2.440078859314469e-04,  4.118297939780695e-06, -5.825859441346652e-08,
  7.377040287543672e-10, -8.591882139331661e-12,  9.362184222255126e-14, -9.655620269610927e-16,  9.504092150176900e-18, -8.984051484470630e-20,  8.195198984850280e-22,
 -7.241106455790250e-24,  5.794537740099009e-03, -1.505684108284824e-04,  3.069199792390811e-06, -5.145708967649868e-08,  7.604173094658467e-10, -1.021909856885458e-11,
  1.273670787562763e-13, -1.491873851829766e-15,  1.657848128574207e-17, -1.760202721273596e-19,  1.795381427406032e-21, -1.766728533547883e-23,  2.355801065842731e-03,
 -7.959237755499852e-05,  1.942584220115767e-06, -3.827332852291194e-08,  6.548740363637892e-10, -1.008203407603920e-11,  1.427689914387893e-13, -1.887237563588570e-15,
  2.353413285007436e-17, -2.790347086997228e-19,  3.164739293315669e-21, -3.449665405594343e-23,  8.443582465115656e-04, -3.624358802967982e-05,  1.051803028005383e-06,
 -2.418151787576543e-08,  4.760968388241574e-10, -8.349540349874952e-12,  1.336311257397651e-13, -1.983658214087653e-15,  2.762806868860907e-17, -3.641591345445822e-19,
  4.572641698849653e-21, -5.497978907492915e-23,  2.672121874255568e-04, -1.429405293023710e-05,  4.901813369352836e-07, -1.307318963124028e-08,  2.946856781289389e-10,
 -5.860509077518546e-12,  1.055649902034746e-13, -1.752814335939553e-15,  2.716485916670816e-17, -3.966188251755507e-19,  5.494735851530078e-21, -7.263185568350489e-23,
  7.482607943565469e-05, -4.908372344588322e-06,  1.977569043034871e-07, -6.087954300611920e-09,  1.564626640932132e-10, -3.515524843055801e-12,  7.102993713827060e-14,
 -1.315034282038712e-15,  2.260952735438709e-17, -3.646145219832770e-19,  5.557785743847170e-21, -8.054876890304680e-23,  1.859423447537687e-05, -1.475484864718121e-06,
  6.946548056717796e-08, -2.457896686988417e-09,  7.177021417792940e-11, -1.816329479489329e-12,  4.104909178703617e-14, -8.451921679359170e-16,  1.608169749149531e-17,
 -2.857836777208817e-19,  4.782145891527196e-21, -7.582407294410027e-23,  4.116580552884363e-06, -3.905871237136859e-07,  2.137858999690165e-08, -8.661454404126634e-10,
  2.864853575379469e-11, -8.145108332069327e-13,  2.054250323026876e-14, -4.693862293643581e-16,  9.864004751589903e-18, -1.927910726026401e-19,  3.534965666676957e-21,
 -6.120861763932675e-23,  8.162337239540337e-07, -9.167421353658449e-08,  5.805597830336624e-09, -2.684084726492660e-10,  1.002948636546888e-11, -3.196228833633840e-13,
  8.977920549344599e-15, -2.272407711809006e-16,  5.265204108713133e-18, -1.129984007343706e-19,  2.266753167820601e-21, -4.279676226176548e-23,  1.459687144109328e-07,
 -1.923438074732806e-08,  1.402906688836903e-09, -7.377967203725922e-11,  3.106884124561769e-12, -1.107550808049411e-13,  3.458670460113546e-15, -9.681706200754747e-17,
  2.469641861352879e-18, -5.811581744049824e-20,  1.273684821217258e-21, -2.618554791954343e-23,  2.376343115413952e-08, -3.644240767474556e-09,  3.047771251390391e-10,
 -1.817666339041696e-11,  8.605624578347607e-13, -3.424949320220134e-14,  1.187060393972686e-15, -3.669318852237595e-17,  1.028977539131362e-18, -2.651466913732816e-20,
  6.340546023079316e-22, -1.417639351963357e-23,  3.565119371515276e-09, -6.314864191834401e-10,  6.028984486177981e-11, -4.064862905318479e-12,  2.158461318867239e-13,
 -9.571505049312035e-15,  3.675503927486984e-16, -1.252616691451119e-17,  3.856065325196717e-19, -1.086535613726733e-20,  2.831242633921785e-22, -6.875177893854712e-24,
  5.008284441126515e-10, -1.017096572044067e-10,  1.103464063004220e-11, -8.382635340062871e-13,  4.979205271310473e-14, -2.454677997946510e-15,  1.042320594965307e-16,
 -3.909500263034450e-18,  1.318970756353215e-19, -4.057613906946218e-21,  1.150365824994592e-22, -3.029422410977419e-24,  6.725375493283170e-11, -1.554165327216870e-11,
  1.906566738572429e-12, -1.625751887613468e-13,  1.076891422597794e-14, -5.886402639931755e-16,  2.757377460399093e-17, -1.135765427861405e-18,  4.190853512577095e-20,
 -1.404839074134055e-21,  4.325181405339933e-23, -1.232933232094254e-24,  8.862975353661212e-12, -2.311905754307175e-12,  3.188834954743546e-13, -3.038501651038055e-14,
  2.235931235201074e-15, -1.350573783715847e-16,  6.957871734797432e-18, -3.138402127538699e-19,  1.263158895220055e-20, -4.602101294110557e-22,  1.534859512100146e-23,
 -4.724540343703228e-25,  1.184510241090105e-12, -3.456663568392365e-13,  5.325045007991945e-14, -5.638369385173554e-15,  4.586822532209119e-16, -3.048159602302930e-17,
  1.720045209675995e-18, -8.463576726731969e-20,  3.702239610553848e-21, -1.460921810159562e-22,  5.260353831879572e-24, -1.742762224110256e-25,  1.670473246525358e-13,
 -5.398277616917423e-14,  9.212707037556692e-15, -1.076328429032423e-15,  9.618178266533771e-17, -6.990939982290463e-18,  4.297346724302566e-19, -2.294806310060533e-20,
  1.085606613714305e-21, -4.617848286044374e-23,  1.786960581673166e-24, -6.343644334208215e-26,  2.601756529838639e-14, -9.201387704391992e-15,  1.722175004435438e-15,
 -2.200015856307453e-16,  2.141603251874270e-17, -1.689331024780115e-18,  1.122926491086451e-19, -6.462446882855598e-21,  3.284294171344149e-22, -1.496345484492658e-23,
  6.184614650768007e-25, -2.338524520713810e-26,  4.692252308275955e-15, -1.791467421545087e-15,  3.631842992875523e-16, -5.014941635453163e-17,  5.260906381966516e-18,
 -4.458094791410369e-19,  3.173675549406841e-20, -1.950331327653946e-21,  1.055466014145125e-22, -5.107192150146288e-24,  2.236309697080940e-25, -8.936283530642095e-27,
  1.017932475104085e-15, -4.130625982898822e-16,  8.934652177498781e-17, -1.314594402190376e-17,  1.466125144683615e-18, -1.317543247257523e-19,  9.922210333653060e-21,
 -6.434956914382105e-22,  3.666740702876541e-23, -1.864117047074177e-24,  8.558202209731736e-26, -3.578242491065240e-27,  2.647813194361314e-16, -1.122270200713809e-16,
  2.544432469168210e-17, -3.921249542257697e-18,  4.573472843493049e-19, -4.290582424488283e-20,  3.367135191169397e-21, -2.271649729767069e-22,  1.344284694638225e-23,
 -7.086043676965084e-25,  3.367985042581581e-26, -1.455613990176202e-27,  6.780017448239995e-17, -2.945613869307413e-17,  6.861179457760530e-18, -1.085983280094968e-18,
  1.299761620754559e-19, -1.250028349992522e-20,  1.004631052489306e-21, -6.934158953980438e-23,  4.194002760049718e-24, -2.257472408317923e-25,  1.094672842693493e-26,
 -4.822426144545165e-28,  8.582261164434381e-02, -3.082917008638808e-04,  1.158831538530344e-06, -4.518600338405080e-09,  1.807574131483689e-11, -7.359800432267968e-14,
  3.021249143860788e-16, -1.248961268642650e-18,  5.147309958595661e-21, -2.134977464520689e-23,  8.722442223421174e-26, -3.636668986805612e-28,  7.511344815506445e-02,
 -3.419430957260669e-04,  1.923652212222358e-06, -1.124203868666112e-08,  6.459208652143048e-11, -3.617646110427097e-13,  1.978716586941924e-15, -1.060989716076532e-17,
  5.591105705931365e-20, -2.903844613597719e-22,  1.487750441361325e-24, -7.537736663933543e-27,  5.753876604851228e-02, -3.730250131008003e-04,  3.031413411182121e-06,
 -2.326705104061912e-08,  1.680682900026084e-10, -1.159989940871329e-12,  7.725292705167144e-15, -4.994979588372606e-17,  3.148956022851763e-19, -1.941744568391856e-21,
  1.174097453540109e-23, -6.975153843433955e-26,  3.857944659365438e-02, -3.628419798316556e-04,  3.880931377509385e-06, -3.681131760081408e-08,  3.225621121686208e-10,
 -2.667831699786997e-12,  2.107048645850886e-14, -1.601366459203293e-16,  1.177746969905946e-18, -8.417732463154418e-21,  5.866456798983041e-23, -3.996864000059416e-25,
  2.264397997196469e-02, -3.023013732964713e-04,  4.042556438335458e-06, -4.636228739034182e-08,  4.842258275697872e-10, -4.715425280941335e-12,  4.341456821078701e-14,
 -3.815390037215407e-16,  3.222918200968798e-18, -2.630446392936906e-20,  2.082789457796996e-22, -1.604993486562340e-24,  1.163685131873253e-02, -2.136695691974720e-04,
  3.484715502983098e-06, -4.771655823318975e-08,  5.863114411168757e-10, -6.637796746037267e-12,  7.039946093168496e-14, -7.074268735516679e-16,  6.790439208032885e-18,
 -6.264198539874425e-20,  5.580045803552429e-22, -4.817431023096517e-24,  5.237733354032781e-03, -1.282924396395509e-04,  2.518471806804305e-06, -4.077257633611813e-08,
  5.835065300704631e-10, -7.609005288601148e-12,  9.215981126477164e-14, -1.050279042997259e-15,  1.136676962739609e-17, -1.176365620735702e-19,  1.170424979392353e-21,
 -1.124212066480027e-23,  2.065836819228122e-03, -6.572489634664168e-05,  1.540075450720872e-06, -2.923884493363920e-08,  4.836210362612258e-10, -7.213067230906724e-12,
  9.911788115296047e-14, -1.273125731932535e-15,  1.544374006660608e-17, -1.782929847134442e-19,  1.970582590827123e-21, -2.094758593148041e-23,  7.145423560837172e-04,
 -2.887202446113697e-05,  8.023362839278866e-07, -1.774287058483990e-08,  3.371477211497688e-10, -5.719958675304011e-12,  8.872193884535985e-14, -1.278258838805844e-15,
  1.730060579350713e-17, -2.218269885604711e-19,  2.712053733258611e-21, -3.177569943534830e-23,  2.169877630054138e-04, -1.092805067192806e-05,  3.581291761665775e-07,
 -9.173318249622932e-09,  1.992924464497301e-10, -3.829484907875426e-12,  6.677925426607409e-14, -1.075122770734546e-15,  1.617717865123057e-17, -2.295794724969399e-19,
  3.094569486269679e-21, -3.983440596137070e-23,  5.794774132594118e-05, -3.580779581019889e-06,  1.376706756976228e-07, -4.065602371686051e-09,  1.005929940098947e-10,
 -2.181652120962580e-12,  4.263469056015402e-14, -7.647326419808872e-16,  1.275628966740075e-17, -1.998258833875073e-19,  2.961856947893391e-21, -4.178094055243500e-23,
  1.364125636816357e-05, -1.020667700430114e-06,  4.581556640694309e-08, -1.553767936436160e-09,  4.364303942639319e-11, -1.065316214528155e-12,  2.327132853700977e-14,
 -4.639416360414840e-16,  8.559922518626216e-18, -1.476924548086907e-19,  2.402218970002392e-21, -3.705984068322910e-23,  2.840026180876588e-06, -2.544248409687125e-07,
  1.327347194397599e-08, -5.152035102184125e-10,  1.638425137198698e-11, -4.490899318114687e-13,  1.094314642640272e-14, -2.420196532340851e-16,  4.930237800768025e-18,
 -9.353438441105769e-20,  1.666659835089204e-21, -2.807443452422000e-23,  5.253223861346101e-07, -5.580428251923159e-08,  3.369318171910800e-09, -1.492325886628110e-10,
  5.360809268634918e-12, -1.646804113141906e-13,  4.468669306074751e-15, -1.094657555384650e-16,  2.458524849047060e-18, -5.121422147675217e-20,  9.984016615321657e-22,
 -1.833880728680720e-23,  8.687355210390874e-08, -1.085052486138776e-08,  7.551431145404320e-10, -3.806296696578798e-11,  1.541352711998624e-12, -5.297771486935863e-14,
  1.598559842204509e-15, -4.331655336387670e-17,  1.071277503299147e-18, -2.447532784177377e-20,  5.214302664505890e-22, -1.043239761624972e-23,  1.295413246171954e-08,
 -1.887930038868538e-09,  1.508657340810467e-10, -8.631823203027493e-12,  3.932857659325373e-13, -1.510129138883644e-14,  5.060359420630027e-16, -1.515038713666217e-17,
  4.121484272338985e-19, -1.031677198409627e-20,  2.399556231477959e-22, -5.224086634850166e-24,  1.761890716600369e-09, -2.975099007876355e-10,  2.719386944459678e-11,
 -1.761606201282424e-12,  9.013490964480469e-14, -3.860549955822507e-15,  1.434771005760758e-16, -4.740652202646648e-18,  1.417044153988757e-19, -3.882337634626288e-21,
  9.848456041207643e-23, -2.330819774942666e-24,  2.219594879329525e-10, -4.312890378486193e-11,  4.491438327387290e-12, -3.285195304877670e-13,  1.883735239753036e-14,
 -8.984404249156207e-16,  3.697896165524679e-17, -1.346646989868145e-18,  4.417586770615535e-20, -1.323151714843491e-21,  3.656625688654141e-23, -9.397053475220690e-25,
  2.643204191184089e-11, -5.869090002813629e-12,  6.933653149004196e-13, -5.708402597616384e-14,  3.659074154321241e-15, -1.939323456018692e-16,  8.823759099475088e-18,
 -3.535680365899617e-19,  1.270904181951102e-20, -4.155308860556219e-22,  1.249219461467648e-23, -3.480913765788042e-25,  3.055638727442810e-12, -7.695539662561804e-13,
  1.026226170360227e-13, -9.473466562808973e-15,  6.766874974787395e-16, -3.974507434876754e-17,  1.994119384208731e-18, -8.771993377313887e-20,  3.447539599342780e-21,
 -1.227908122408893e-22,  4.007662076208342e-24, -1.208440125337085e-25,  3.548175056650227e-13, -1.005042280422579e-13,  1.503761023322025e-14, -1.548902712064726e-15,
  1.227684763838690e-16, -7.960751444592894e-18,  4.389120867842214e-19, -2.112711500444953e-20,  9.050660126604205e-22, -3.501165282383494e-23,  1.237016981513044e-24,
 -4.024953267684477e-26,  4.318191705166949e-14, -1.362274489665250e-14,  2.269625234789586e-15, -2.591564777949997e-16,  2.266190708888509e-17, -1.613754185187218e-18,
  9.729156709455805e-20, -5.100717604378686e-21,  2.371215511785001e-22, -9.920263980678111e-24,  3.778570207323829e-25, -1.321330671352341e-26,  5.793260231460044e-15,
 -2.011930416808912e-15,  3.696443825754823e-16, -4.638778381872539e-17,  4.439933815769050e-18, -3.446641351898699e-19,  2.256523607386591e-20, -1.280064483071535e-21,
  6.417094447324746e-23, -2.885909421013981e-24,  1.178122410401708e-25, -4.402620434789489e-27,  9.051607043765247e-16, -3.412956105472316e-16,  6.829742125311465e-17,
 -9.312936816560939e-18,  9.653392589249723e-19, -8.087769607928633e-20,  5.695791389587248e-21, -3.464575888552807e-22,  1.856775105187865e-23, -8.901832732374868e-25,
  3.863728639671756e-26, -1.531087909873091e-27,  1.728646385239358e-16, -6.962686803334635e-17,  1.494219698616315e-17, -2.181702013057148e-18,  2.415378185290039e-19,
 -2.155470943169941e-20,  1.612496701113669e-21, -1.039183872092722e-22,  5.885978867004977e-24, -2.975300452707944e-25,  1.358560667788702e-26, -5.650972050296533e-28,
  4.070861602742756e-17, -1.719390329501462e-17,  3.883505522399012e-18, -5.962729591909477e-19,  6.929725948464084e-20, -6.478938670974708e-21,  5.067971503737693e-22,
 -3.408528991961807e-23,  2.011091372666932e-24, -1.057106782697488e-25,  5.010901969003026e-27, -2.160124178654123e-28,  9.817516844017724e-18, -4.260350973000510e-18,
  9.910963432118065e-19, -1.566718623658898e-19,  1.872823952640825e-20, -1.799020807152853e-21,  1.444190068805648e-22, -9.957059723933663e-24,  6.015935162501316e-25,
 -3.234825348944703e-26,  1.567049657958827e-27, -6.896845853915470e-29,  8.460764952862719e-02, -2.992331341373099e-04,  1.106296275427239e-06, -4.240781751283478e-09,
  1.667355182820367e-11, -6.674873154818158e-14,  2.693490741162616e-16, -1.095901567954865e-18,  4.437841360131243e-21, -1.816147779334665e-23,  7.264339436260651e-26,
 -3.014302461748858e-28,  7.377562391152302e-02, -3.270764604433469e-04,  1.794717914253462e-06, -1.026396488232271e-08,  5.780862835640552e-11, -3.176474282315214e-13,
  1.705194338587079e-15, -8.977137541374798e-18,  4.645307618033300e-20, -2.370074338283163e-22,  1.192725475559434e-24, -5.939919332417932e-27,  5.609346260807398e-02,
 -3.498465097028474e-04,  2.767609141088246e-06, -2.075393884214235e-08,  1.466148973184925e-10, -9.902888769820871e-13,  6.457876002848050e-15, -4.090661656730070e-17,
  2.527560583427574e-19, -1.528135641516696e-21,  9.062602723759490e-24, -5.282051445112399e-26,  3.718749464973870e-02, -3.334776190264350e-04,  3.468485773333467e-06,
 -3.205115227857107e-08,  2.739200828737799e-10, -2.211951832287014e-12,  1.707177444814152e-14, -1.268767358017783e-16,  9.130294356231549e-19, -6.388208409976129e-21,
  4.360146489244535e-23, -2.910351222537844e-25,  2.149610878325860e-02, -2.720614190164039e-04,  3.529756428325579e-06, -3.931596284559272e-08,  3.995282035898491e-10,
 -3.790839423249114e-12,  3.404369470076576e-14, -2.920776462848649e-16,  2.410337634315842e-18, -1.923043892819022e-20,  1.489248064745764e-22, -1.122945294352533e-24,
  1.083451458558034e-02, -1.879322880135873e-04,  2.964301730518416e-06, -3.931213995342334e-08,  4.689655196827955e-10, -5.163290264113890e-12,  5.332307574300050e-14,
 -5.222895963383168e-16,  4.890786890736614e-18, -4.404624854426151e-20,  3.832793700265833e-22, -3.234207090362022e-24,  4.761970173027535e-03, -1.099538667851441e-04,
  2.080559214171701e-06, -3.254304260834149e-08,  4.512596670336163e-10, -5.712573777323698e-12,  6.726688350068396e-14, -7.461512164328449e-16,  7.867608851345863e-18,
 -7.939441758869581e-20,  7.708059651668351e-22, -7.229038055462906e-24,  1.825528533312325e-03, -5.468639285225722e-05,  1.231264127008354e-06, -2.253693578808042e-08,
  3.605258256364949e-10, -5.211592113518864e-12,  6.952308129029455e-14, -8.680460687611799e-16,  1.024685888425350e-17, -1.152237690136173e-19,  1.241430968663081e-21,
 -1.287341994838935e-23,  6.106620608020484e-04, -2.322128663422791e-05,  6.183568738743439e-07, -1.315913819316701e-08,  2.414372466278844e-10, -3.964260954128588e-12,
  5.961563682792800e-14, -8.339339280343016e-16,  1.097179780252293e-17, -1.368922439280901e-19,  1.630038776017801e-21, -1.861552012531303e-23,  1.783779643885139e-04,
 -8.454430912490077e-06,  2.649104172386353e-07, -6.519549330774564e-09,  1.365641613797460e-10, -2.536387797843617e-12,  4.283304390909321e-14, -6.688538913766511e-16,
  9.774064069770196e-18, -1.348612912281980e-19,  1.769121892566263e-21, -2.218174655428098e-23,  4.555303833009214e-05, -2.650189751890210e-06,  9.726250788820261e-08,
 -2.756111303246779e-09,  6.567076062768198e-11, -1.375153470926084e-12,  2.599985282214354e-14, -4.519352668214228e-16,  7.315627749205591e-18, -1.113414263020378e-19,
  1.605090640322992e-21, -2.204194234184899e-23,  1.018839637167572e-05, -7.182951156499289e-07,  3.074441958359649e-08, -9.995009189250741e-10,  2.701091745648430e-11,
 -6.360570987921762e-13,  1.343227683067254e-14, -2.593310822016713e-16,  4.640430265089894e-18, -7.774835508554082e-20,  1.229335255146357e-21, -1.845517692229044e-23,
  2.001042718600417e-06, -1.691104858565265e-07,  8.408140482819313e-09, -3.126590608543956e-10,  9.560341788712309e-12, -2.526501035833759e-13,  5.948537244743676e-15,
 -1.273440568164993e-16,  2.514875226534952e-18, -4.631403559239300e-20,  8.020196482999327e-22, -1.314319309409281e-23,  3.464432756559960e-07, -3.477180943264043e-08,
  2.000846300784523e-09, -8.488292509009249e-11,  2.931019825383122e-12, -8.678546791534343e-14,  2.274857408492964e-15, -5.392871423317476e-17,  1.173981356270918e-18,
 -2.373630862677581e-20,  4.496623921574668e-22, -8.034987961298043e-24,  5.316153164502262e-08, -6.285934149011329e-09,  4.171652131928397e-10, -2.014508778585343e-11,
  7.842365586731814e-13, -2.598263556099659e-14,  7.573837204323371e-16, -1.986273200877808e-17,  4.761832959499449e-19, -1.056065973629454e-20,  2.186677651812188e-22,
 -4.256838483411867e-24,  7.285645344152938e-09, -1.007645445155267e-09,  7.687195815493441e-11, -4.216828687821243e-12,  1.848030940089460e-13, -6.843243408792794e-15,
  2.216214193112315e-16, -6.424390016900325e-18,  1.694842159057413e-19, -4.119972643122716e-21,  9.317474473407980e-23, -1.974656300182066e-24,  9.012428786383175e-10,
 -1.448434920133389e-10,  1.266137208562935e-11, -7.873754028876291e-13,  3.879183396799405e-14, -1.603779866834412e-15,  5.765412594937559e-17, -1.845930253388306e-18,
  5.355124826126810e-20, -1.425906614904170e-21,  3.519798267050997e-23, -8.115381291819932e-25,  1.021014115799854e-10, -1.894858775304547e-11,  1.891651058933174e-12,
 -1.330763594867991e-13,  7.359285435278127e-15, -3.392987938601603e-16,  1.352638573790962e-17, -4.779256840787980e-19,  1.523453133472116e-20, -4.439952876231232e-22,
  1.195372937453807e-23, -2.996132600357378e-25,  1.080475719460105e-11, -2.300833398300842e-12,  2.613699973530421e-13, -2.074923013517422e-14,  1.285610454697328e-15,
 -6.600105233242555e-17,  2.914141130910051e-18, -1.134973728020762e-19,  3.971043399596044e-21, -1.265419520231980e-22,  3.712081268278077e-24, -1.010404812100801e-25,
  1.096730605900782e-12, -2.661471888969674e-13,  3.425701075756800e-14, -3.059345213300000e-15,  2.118508794496574e-16, -1.208522205247039e-17,  5.898845990396430e-19,
 -2.528118266725303e-20,  9.693173344923723e-22, -3.372101978406962e-23,  1.076164782480191e-24, -3.176243753772837e-26,  1.105760666877288e-13, -3.034210157591806e-14,
  4.401723451584543e-15, -4.403716553493492e-16,  3.396144563744809e-17, -2.146078387263880e-18,  1.154737228989709e-19, -5.431534260509857e-21,  2.276409480014824e-22,
 -8.624564855808204e-24,  2.987327734018985e-25, -9.538019485134241e-27,  1.158202566381074e-14, -3.560362820394414e-15,  5.781161457102366e-16, -6.441905843783272e-17,
  5.504683867864110e-18, -3.835448184919009e-19,  2.265228432514923e-20, -1.164658375171251e-21,  5.314986962478021e-23, -2.184826936123940e-24,  8.183742696670968e-26,
 -2.816565346716688e-27,  1.331769299603830e-15, -4.534547468419353e-16,  8.165869394569630e-17, -1.005293966259603e-17,  9.448690798564707e-19, -7.209774742381382e-20,
  4.644030979383527e-21, -2.594104849054889e-22,  1.281557452299640e-23, -5.683876609055199e-25,  2.289866273241676e-26, -8.450347955776840e-28,  1.789854664078369e-16,
 -6.656927222589112e-17,  1.313367832320905e-17, -1.766559783679484e-18,  1.807464086139835e-19, -1.495749730840447e-20,  1.041129805997685e-21, -6.263039251212565e-23,
  3.321429374443773e-24, -1.576542567349029e-25,  6.778099447598116e-27, -2.661862917623363e-28,  2.983911064576397e-17, -1.192044626135921e-17,  2.536077539754421e-18,
 -3.671845454104744e-19,  4.032542145903038e-20, -3.571193195394151e-21,  2.652258680521374e-22, -1.697523096031050e-23,  9.552111976459677e-25, -4.798559114989157e-26,
  2.178168142254932e-27, -9.009457299315715e-29,  6.311010946095544e-18, -2.655235798216588e-18,  5.972261756140935e-19, -9.132397998318701e-20,  1.057186155053587e-20,
 -9.847198443673707e-22,  7.675270868644016e-23, -5.144601216903695e-24,  3.025606557316256e-25, -1.585485465003468e-26,  7.493505539546755e-28, -3.221336343176133e-29,
  1.425641884974795e-18, -6.178863185044781e-19,  1.435420176951985e-19, -2.265993726384869e-20,  2.705116347202666e-21, -2.595174076911766e-22,  2.080734220413097e-23,
 -1.432866132155833e-24,  8.647279606862028e-26, -4.644594416496279e-27,  2.247595681755575e-28, -9.881950339606534e-30,  8.342810170476384e-02, -2.905818854786533e-04,
  1.056964611126925e-06, -3.984343639706915e-09,  1.540081591205226e-11, -6.063711415999571e-14,  2.405575458935832e-16, -9.638158530666722e-19,  3.833276695327096e-21,
 -1.550561380411008e-23,  6.050906127192503e-26, -2.520747332936754e-28,  7.249527507468918e-02, -3.131961322868049e-04,  1.676897292973672e-06, -9.387709381848303e-09,
  5.184540210459276e-11, -2.795786748267600e-13,  1.473425584889594e-15, -7.618435104642243e-18,  3.872015484547981e-20, -1.941379744767995e-22,  9.597629785606422e-25,
 -4.700769570872194e-27,  5.473683539838765e-02, -3.286633987832768e-04,  2.532009566682471e-06, -1.855849925003707e-08,  1.282707503732391e-10, -8.481789487407258e-13,
  5.417928864084079e-15, -3.363296774087539e-17,  2.037448941685055e-19, -1.208131564794727e-21,  7.029346899714016e-24, -4.020575531459795e-26,  3.590674498614820e-02,
 -3.071969051858757e-04,  3.108777333872886e-06, -2.800123272830851e-08,  2.335067185320959e-10, -1.841759369118010e-12,  1.389595232673212e-14, -1.010263251176545e-16,
  7.115899579359424e-19, -4.875482434740704e-21,  3.260029576362141e-23, -2.132542880099243e-25,  2.046149736606622e-02, -2.456073489879267e-04,  3.093954191126058e-06,
 -3.348828449700647e-08,  3.312619419976104e-10, -3.063813905888276e-12,  2.684894627557050e-14, -2.249639607885820e-16,  1.814346834229793e-18, -1.415509856698519e-20,
  1.072501540977696e-22, -7.915730436469741e-25,  1.012739681453393e-02, -1.659847181693590e-04,  2.534381347251475e-06, -3.256995658900007e-08,  3.773982456219191e-10,
 -4.042706531756811e-12,  4.067124848880856e-14, -3.884535663939043e-16,  3.549931189699484e-18, -3.122240730402327e-20,  2.654936708823707e-22, -2.190388670413735e-24,
  4.353132895005852e-03, -9.475686301338601e-05,  1.729859220957636e-06, -2.615580709742233e-08,  3.515965234508090e-10, -4.322868776218397e-12,  4.950873238112091e-14,
 -5.347390291382772e-16,  5.495451552082912e-18, -5.409355146155563e-20,  5.126248816855675e-22, -4.695738152123075e-24,  1.624899073661914e-03, -4.582736083062399e-05,
  9.922643159153795e-07, -1.751936232306442e-08,  2.711871881789911e-10, -3.801164709880309e-12,  4.924720177339057e-14, -5.979393837397233e-16,  6.871140308779137e-18,
 -7.528305815555906e-20,  7.909285005069925e-22, -8.003360581693710e-24,  5.267558886555739e-04, -1.884595666438689e-05,  4.812405025211269e-07, -9.859964672549342e-09,
  1.747556554391907e-10, -2.778153829736927e-12,  4.052121360465601e-14, -5.505467470705715e-16,  7.043529319138361e-18, -8.554141919427130e-20,  9.923378491290746e-22,
 -1.104939086056465e-23,  1.483511008069699e-04, -6.614462134572313e-06,  1.982769116936153e-07, -4.690275140346766e-09,  9.476463387249607e-11, -1.701827792322506e-12,
  2.784137719466788e-14, -4.218112285900913e-16,  5.988127344451986e-18, -8.035373939559987e-20,  1.026107622441079e-21, -1.253477053390366e-23,  3.632173030214700e-05,
 -1.988410126741776e-06,  6.968508191189544e-08, -1.895369805090818e-09,  4.350513890739909e-11, -8.798574119932042e-13,  1.609893707978904e-14, -2.712539444073608e-16,
  4.262051001381785e-18, -6.303773024356227e-20,  8.840270000465177e-22, -1.182052521851214e-23,  7.740391826254545e-06, -5.138329786842176e-07,  2.097431178861753e-08,
 -6.537767064681578e-10,  1.700222478279615e-11, -3.863203897640338e-13,  7.888598246314003e-15, -1.475196228627157e-16,  2.560512497415296e-18, -4.166529750941850e-20,
  6.405346604651668e-22, -9.358486092905898e-24,  1.438590656496862e-06, -1.145916328661354e-07,  5.429444435950817e-09, -1.934271829201264e-10,  5.687357255038599e-12,
 -1.449233696230397e-13,  3.297268568163693e-15, -6.833203574016746e-17,  1.308340674331430e-18, -2.339074386645701e-20,  3.936798011703622e-22, -6.276770319046933e-24,
  2.338915713883194e-07, -2.215709379811225e-08,  1.214720910658800e-09, -4.935191155270853e-11,  1.637957192432324e-12, -4.674449395816702e-14,  1.183581408769465e-15,
 -2.715325353435676e-17,  5.729278886678823e-19, -1.124291380108643e-20,  2.069664150562825e-22, -3.597639186804281e-24,  3.341756090498860e-08, -3.736168335723771e-09,
  2.363106782003826e-10, -1.092898165005562e-11,  4.089092495459364e-13, -1.305634617569213e-14,  3.676021862970969e-16, -9.328956655384785e-18,  2.167671102280481e-19,
 -4.665957579932360e-21,  9.388613091869046e-23, -1.778111193668370e-24,  4.223828317342221e-09, -5.535995375114103e-10,  4.028675318158494e-11, -2.117570337824169e-12,
  8.922430816343247e-14, -3.185065356816970e-15,  9.965648697082319e-17, -2.796219984687990e-18,  7.151753726825264e-20, -1.687853849346457e-21,  3.710580985970457e-23,
 -7.653110568227876e-25,  4.768159987351814e-10, -7.281940432974540e-11,  6.081133639356310e-12, -3.627434285779436e-13,  1.719666088970684e-14, -6.858787308014355e-16,
  2.383755671499776e-17, -7.392154183504733e-19,  2.080380841006496e-20, -5.381391180012771e-22,  1.292110325793217e-23, -2.901173510125081e-25,  4.872661880272035e-11,
 -8.621591229389211e-12,  8.240226105015920e-13, -5.569711585029368e-14,  2.967974861405728e-15, -1.321740037878093e-16,  5.100041666783419e-18, -1.747230289134115e-19,
  5.408702714636326e-21, -1.532916891416197e-22,  4.018475346292434e-24, -9.818346292233405e-26,  4.593429917036082e-12, -9.362591362270139e-13,  1.021159229985745e-13,
 -7.807068401445390e-15,  4.670584425102758e-16, -2.320333603716934e-17,  9.932977688323299e-19, -3.757100718484161e-20,  1.278546148217413e-21, -3.967990938216087e-23,
  1.135016582449539e-24, -3.015908293477793e-26,  4.099693515268514e-13, -9.566930647201474e-14,  1.186582752570642e-14, -1.023681490604581e-15,  6.863328384372243e-17,
 -3.798282134073195e-18,  1.801709565882809e-19, -7.515752490347721e-21,  2.808669358987861e-22, -9.535396905938058e-24,  2.973138095030596e-25, -8.582501414638050e-27,
  3.588584949997068e-14, -9.519621324699209e-15,  1.336632603009028e-15, -1.296827760283294e-16,  9.717253668043093e-18, -5.976393836005329e-19,  3.134574783670417e-20,
 -1.439192193516334e-21,  5.895076254470721e-23, -2.185305991662939e-24,  7.413877044663496e-26, -2.320792582180177e-27,  3.227975301568663e-15, -9.650213174230585e-16,
  1.524498118865648e-16, -1.655123153863871e-17,  1.380085742134773e-18, -9.396316589390446e-20,  5.429746929974734e-21, -2.734648054064464e-22,  1.223786981583840e-23,
 -4.937967912316013e-25,  1.817204364378477e-26, -6.149900039148992e-28,  3.166513172882648e-16, -1.055251244161036e-16,  1.859624239529624e-17, -2.242578013692861e-18,
  2.067013988972665e-19, -1.548388954328052e-20,  9.801175159421366e-22, -5.385181232354042e-23,  2.619114812576351e-24, -1.144485324150433e-25,  4.546160053597863e-27,
 -1.655337878404338e-28,  3.634687752481322e-17, -1.331659043398559e-17,  2.586898411219663e-18, -3.428101943958789e-19,  3.458228444683631e-20, -2.823765936858219e-21,
  1.940760485623628e-22, -1.153563084454916e-23,  6.048425171169717e-25, -2.840122464898832e-26,  1.208617538269857e-27, -4.700511682174342e-29,  5.243306695280506e-18,
 -2.075718963626688e-18,  4.374093005906582e-19, -6.274636157413324e-20,  6.830447364044623e-21, -5.998531106020416e-22,  4.419756475079353e-23, -2.807558409864476e-24,
  1.568599534380805e-25, -7.826746531651395e-27,  3.529941643688400e-28, -1.451193744864018e-29,  9.873885351807578e-19, -4.136416758496755e-19,  9.260929079026919e-20,
 -1.409749154446768e-20,  1.624917903835610e-21, -1.507315623194715e-22,  1.170265661227124e-23, -7.814943648986756e-25,  4.579833692080448e-26, -2.391871143076354e-27,
  1.126858665056159e-28, -4.829467646606544e-30,  2.076659013487656e-19, -8.988095636732985e-20,  2.084896807883594e-20, -3.286372504555304e-21,  3.917562330617235e-22,
 -3.753107957940138e-23,  3.005100759889001e-24, -2.066753678751890e-25,  1.245733745569208e-26, -6.683086781499507e-28,  3.230360495834620e-29, -1.418728226986499e-30,
  8.228238858142004e-02, -2.823133182373892e-04,  1.010591936913178e-06, -3.747327768934694e-09,  1.424369101220963e-11, -5.517421365787602e-14,  2.152073019838974e-16,
 -8.496360617263083e-19,  3.316079091615483e-21, -1.329503848261167e-23,  5.029882778568114e-26, -2.137358631083413e-28,  7.126862679997246e-02, -3.002178748708226e-04,
  1.569043448535583e-06, -8.601064277887316e-09,  4.659086926960889e-11, -2.466424454827658e-13,  1.276455929609142e-15, -6.484190427154062e-18,  3.237514708332405e-20,
 -1.595826834498099e-22,  7.750197330257655e-25, -3.736183323541376e-27,  5.346133112253996e-02, -3.092644854385525e-04,  2.321083810904531e-06, -1.663511832392224e-08,
  1.125348386043327e-10, -7.287509210378313e-13,  4.561312826753338e-15, -2.775802633572471e-17,  1.649144365376775e-19, -9.593596001099149e-22,  5.477979109150814e-24,
 -3.075638218217822e-26,  3.472565582744468e-02, -2.836099181999899e-04,  2.794019800614163e-06, -2.454260387851867e-08,  1.997900733577565e-10, -1.539781863351432e-12,
  1.136131484414261e-14, -8.082930968938444e-17,  5.574482434359362e-19, -3.741307107459116e-21,  2.451593398906136e-23, -1.572104753288546e-25,  1.952614746636805e-02,
 -2.223774895728198e-04,  2.721981636145860e-06, -2.864532199904889e-08,  2.759512037806848e-10, -2.488909263315386e-12,  2.129170627901173e-14, -1.742938199855115e-16,
  1.374271754910150e-18, -1.048800230116922e-20,  7.777283297925636e-23, -5.620260833994478e-25,  9.501669958776398e-03, -1.471761907979318e-04,  2.177266132656846e-06,
 -2.712886214629164e-08,  3.054863884159193e-10, -3.185250126762127e-12,  3.122953183299038e-14, -2.909648974034044e-16,  2.595939282696150e-18, -2.230530023121577e-20,
  1.854052037387628e-22, -1.496032377237537e-24,  3.999922198364222e-03, -8.208400895249457e-05,  1.447085736903092e-06, -2.116211727277661e-08,  2.759040037955028e-10,
 -3.296127232868662e-12,  3.673128389908542e-14, -3.864564351378782e-16,  3.872289059531316e-18, -3.719254607683147e-20,  3.441540980835566e-22, -3.080082770530942e-24,
  1.456231399348893e-03, -3.866179987841807e-05,  8.057506461445317e-07, -1.372961074351391e-08,  2.057456205435588e-10, -2.797595281017981e-12,  3.521558363954500e-14,
 -4.159478390149639e-16,  4.654686886370333e-18, -4.970763063316885e-20,  5.094030605325078e-22, -5.031437303550610e-24,  4.583844942655005e-04, -1.542568118718085e-05,
  3.780217572689444e-07, -7.460356043584010e-09,  1.277895115621030e-10, -1.967752388733164e-12,  2.784802108936065e-14, -3.676241881922864e-16,  4.575068390636159e-18,
 -5.410121379856273e-20,  6.116234786998437e-22, -6.641816539801663e-24,  1.247424756694486e-04, -5.229973438711823e-06,  1.500753066621169e-07, -3.413686016157333e-09,
  6.655485600713185e-11, -1.156124504814729e-12,  1.832925874591251e-14, -2.695194037749821e-16,  3.718132295911411e-18, -4.853633610097320e-20,  6.035126147376896e-22,
 -7.184622809752391e-24,  2.935410315447423e-05, -1.511286598288189e-06,  5.059799109462224e-08, -1.321401463675774e-09,  2.922809651156505e-11, -5.710885780513370e-13,
  1.011540265104349e-14, -1.652556104417832e-16,  2.521031162001833e-18, -3.624442112420989e-20,  4.945670970740393e-22, -6.440316931702580e-24,  5.976792963154662e-06,
 -3.733218885207974e-07,  1.453608307823636e-08, -4.345196095400309e-10,  1.087706068215629e-11, -2.385290572370744e-13,  4.710746059840268e-15, -8.534455627358228e-17,
  1.437179168764942e-18, -2.271700890417531e-20,  3.396096499457071e-22, -4.829737271907926e-24,  1.054319913800917e-06, -7.908888562740926e-08,  3.570990441800362e-09,
 -1.218919679367733e-10,  3.446762375350935e-12, -8.469896804354130e-14,  1.862411584167638e-15, -3.736807335094772e-17,  6.937536518420211e-19, -1.204204536584239e-20,
  1.969999376018366e-22, -3.056126937998326e-24,  1.614945139602169e-07, -1.442486530945755e-08,  7.532639334174280e-10, -2.930583571952532e-11,  9.348489318461827e-13,
 -2.571402009407360e-14,  6.289325619129809e-16, -1.396344991624244e-17,  2.855708755570444e-19, -5.439059976747222e-21,  9.729574284696958e-23, -1.645237769238857e-24,
  2.155755837557373e-08, -2.276171885906341e-09,  1.371411561972869e-10, -6.072565786241663e-12,  2.183245619060762e-13, -6.717234352684230e-15,  1.826485926717479e-16,
 -4.484922637304305e-18,  1.009938606073260e-19, -2.109737924900095e-21,  4.124883222026163e-23, -7.599387883199737e-25,  2.521884413125016e-09, -3.127923726757068e-10,
  2.169732527651469e-11, -1.092237190136298e-12,  4.422964801288212e-14, -1.521561091341379e-15,  4.598225395749658e-17, -1.248501470486393e-18,  3.095058693301292e-20,
 -7.090027495997423e-22,  1.514819211867868e-23, -3.039931854409615e-25,  2.607145505062088e-10, -3.777525477729008e-11,  3.010693488938395e-12, -1.721357635075789e-13,
  7.847621880090733e-15, -3.017961301676100e-16,  1.013573173018770e-17, -3.043014910803115e-19,  8.304642677231647e-21, -2.086120598359549e-22,  4.870416093681328e-24,
 -1.064562689751045e-25,  2.411228838016440e-11, -4.060306291843852e-12,  3.710693839292890e-13, -2.407426450575409e-14,  1.235127520022596e-15, -5.309088060431059e-17,
  1.981482648232474e-18, -6.578121720397621e-20,  1.976395693029772e-21, -5.444324850327159e-23,  1.388940498828738e-24, -3.306495614761299e-26,  2.030540029248172e-12,
 -3.953734737893342e-13,  4.134160906925449e-14, -3.040175170626770e-15,  1.754279107664423e-16, -8.425725304671825e-18,  3.494094400569666e-19, -1.282518949130528e-20,
  4.241821486937421e-22, -1.281237622108459e-23,  3.571278449907033e-25, -9.257723037022965e-27,  1.596529246523184e-13, -3.575113212948743e-14,  4.265630893429223e-15,
 -3.549897195233975e-16,  2.301473567298048e-17, -1.234222354591325e-18,  5.683622265289006e-20, -2.305435420726536e-21,  8.389785771098868e-23, -2.777318291951448e-24,
  8.453818716018449e-26, -2.384981513818267e-27,  1.213829312828730e-14, -3.106249501667465e-15,  4.213643584639801e-16, -3.958342214944128e-17,  2.877750297505155e-18,
 -1.720384003632166e-19,  8.785211275682592e-21, -3.932927657209546e-22,  1.572836125087770e-23, -5.699322867316885e-25,  1.892117291488850e-26, -5.802022325822314e-28,
  9.361708979837609e-16, -2.716177502269756e-16,  4.166969567616813e-17, -4.400624983484935e-18,  3.575205108740593e-19, -2.375351771426489e-20,  1.341309402567498e-21,
 -6.609639483558708e-23,  2.897396034458711e-24, -1.146388879660385e-25,  4.140834216316975e-27, -1.376738750929963e-28,  7.801646096205378e-17, -2.539947797406663e-17,
  4.372710115915081e-18, -5.157335686060070e-19,  4.654958304584380e-20, -3.418731443894769e-21,  2.124006587056700e-22, -1.146602092370001e-23,  5.484133457795255e-25,
 -2.358734851709312e-26,  9.229428127509751e-28, -3.312913735322102e-29,  7.595022799329359e-18, -2.737057367981729e-18,  5.227889511512494e-19, -6.816473786979551e-20,
  6.771545762994843e-21, -5.449503526688862e-22,  3.694372025844795e-23, -2.167571810118304e-24,  1.122633074239633e-25, -5.210438006696390e-27,  2.192936838132117e-28,
 -8.439811103523933e-30,  9.394481944421858e-19, -3.681854323577931e-19,  7.677295747182815e-20, -1.090146642463753e-20,  1.175266112538168e-21, -1.022689650886468e-22,
  7.470035594051254e-24, -4.706306152691338e-25,  2.609032051900798e-26, -1.292233492020364e-27,  5.787410736825958e-29, -2.363523750335197e-30,  1.560491495084250e-19,
 -6.506092670559339e-20,  1.449198318329338e-20, -2.195073852225267e-21,  2.518065698777106e-22, -2.325248914096108e-23,  1.797541887290518e-24, -1.195487473963771e-25,
  6.978845228377827e-27, -3.631373943577584e-28,  1.704831212866495e-29, -7.282293814034710e-31,  3.035202170572242e-20, -1.311709697050913e-20,  3.037669248243407e-21,
 -4.780427118126952e-22,  5.689605165446645e-23, -5.442512534614777e-24,  4.351469240152636e-25, -2.988545029900017e-26,  1.798933815639541e-27, -9.638499081224670e-29,
  4.653159350524545e-30, -2.041189369281675e-31,  8.116902534380763e-02, -2.744046622719061e-04,  9.669558704842629e-07, -3.527983834938207e-09,  1.318998966027513e-11,
 -5.028315399340013e-14,  1.928338075908819e-16, -7.508090061105710e-19,  2.871489989419220e-21, -1.146213369225802e-23,  4.155225541835091e-26, -1.854768919680311e-28,
  7.009222372466155e-02, -2.880660700319622e-04,  1.470145844645849e-06, -7.893468351557289e-09,  4.195024689404608e-11, -2.180742247651513e-13,  1.108579867629878e-15,
 -5.534429395895389e-18,  2.715073277081848e-20, -1.316345162167879e-22,  6.278682166597811e-25, -2.983092709353454e-27,  5.226018805285770e-02, -2.914647614824791e-04,
  2.131803329823203e-06, -1.494546702377531e-08,  9.899453186266720e-11, -6.280402426004264e-13,  3.853064556863739e-15, -2.299357547639053e-17,  1.340161655643659e-19,
 -7.650655030059223e-22,  4.288478594105182e-24, -2.364123354490560e-26,  3.363412898398402e-02, -2.623837097750331e-04,  2.517718116698154e-06, -2.157824740796903e-08,
  1.715477438710676e-10, -1.292371226780793e-12,  9.328857939651098e-15, -6.496943429133764e-17,  4.388648800586064e-19, -2.886107373521183e-21,  1.853951376436200e-23,
 -1.165744957237293e-25,  1.867811336486676e-02, -2.019051638605383e-04,  2.403172015922227e-06, -2.460213797448033e-08,  2.309120060749533e-10, -2.031830215116300e-12,
  1.697440808688243e-14, -1.358030202056284e-16,  1.047215520480111e-18, -7.820343058793223e-21,  5.677439386100431e-23, -4.018327889707685e-25,  8.945850901009024e-03,
 -1.309817449234550e-04,  1.879068946844990e-06, -2.271260677055377e-08,  2.486621061266089e-10, -2.524812456202881e-12,  2.413428421146625e-14, -2.194308303750051e-16,
  1.911972831331017e-18, -1.605499057688395e-20,  1.304946719563411e-22, -1.030144970018623e-24,  3.693230926012174e-03, -7.145277501795573e-05,  1.217597344100756e-06,
 -1.723057808554404e-08,  2.179879254153338e-10, -2.531571937833452e-12,  2.746151418721538e-14, -2.815533050071666e-16,  2.751640845067248e-18, -2.579734426901183e-20,
  2.331616555509857e-22, -2.039419804453233e-24,  1.313506512926830e-03, -3.282282571362857e-05,  6.590391002806373e-07, -1.084305182215692e-08,  1.573825351243288e-10,
 -2.076871293574933e-12,  2.541104167326501e-14, -2.920924076274211e-16,  3.184250577062491e-18, -3.315509158229764e-20,  3.315322249574822e-22, -3.197294953610253e-24,
  4.022085357293211e-04, -1.272761676902929e-05,  2.995752980191484e-07, -5.697474063028469e-09,  9.436265152589093e-11, -1.408022114003001e-12,  1.934199906774296e-14,
 -2.481803498607199e-16,  3.005428589631319e-18, -3.461609533782072e-20,  3.814873401683125e-22, -4.041384149111258e-24,  1.059877680435390e-04, -4.176738840429323e-06,
  1.148082507721231e-07, -2.512229979750609e-09,  4.728331207302059e-11, -7.947981077426908e-13,  1.221571006529338e-14, -1.743921522098732e-16,  2.338617764004333e-18,
 -2.970675499202521e-20,  3.597707519705202e-22, -4.174926710887465e-24,  2.402827639767156e-05, -1.162769448840626e-06,  3.720894479592200e-08, -9.333590330799915e-10,
  1.990167508465937e-11, -3.758104498878255e-13,  6.445828184087106e-15, -1.021343607283351e-16,  1.513179540102810e-18, -2.115161167899441e-20,  2.808976508294434e-22,
 -3.563159223327549e-24,  4.686803797464948e-06, -2.752579443822479e-07,  1.022650028815686e-08, -2.932362904067744e-10,  7.067459465493208e-12, -1.496213616692822e-13,
  2.858541969986689e-15, -5.018410023685813e-17,  8.200707709282447e-19, -1.259416556846915e-20,  1.831207527380573e-22, -2.535324989441112e-24,  7.870081700412374e-07,
 -5.554882044991623e-08,  2.390267943172711e-09, -7.818227471854228e-11,  2.126454986776102e-12, -5.040021493194652e-14,  1.071223769381939e-15, -2.081252934002389e-17,
  3.747117243535187e-19, -6.315658039721881e-21,  1.004385617201849e-22, -1.516218795318722e-24,  1.139334717425308e-07, -9.585503869484220e-09,  4.767016928480350e-10,
 -1.775880057793503e-11,  5.444998305910136e-13, -1.443593831956576e-14,  3.410884220025906e-16, -7.328951424594753e-18,  1.452865830593218e-19, -2.685857652899106e-21,
  4.668906194282319e-23, -7.680267811515108e-25,  1.425770885467767e-08, -1.419992413992353e-09,  8.146505443487366e-11, -3.452881293553831e-12,  1.192700930046632e-13,
 -3.535636130725086e-15,  9.283828287289261e-17, -2.205556329282673e-18,  4.812917175166133e-20, -9.756603336852922e-22,  1.853420460486156e-23, -3.321377120585248e-25,
  1.549224485497963e-09, -1.815856704527096e-10,  1.199830994578148e-11, -5.781895329966572e-13,  2.249426440270314e-14, -7.455375858588865e-16,  2.175610587939110e-17,
 -5.715048087343668e-19,  1.372938912704795e-20, -3.052133288207778e-22,  6.336373730169798e-24, -1.237001160535701e-25,  1.472039204527213e-10, -2.020299161432541e-11,
  1.535278645833654e-12, -8.407814948836655e-14,  3.684122543266971e-15, -1.365461416271986e-16,  4.429639029031490e-18, -1.287042788928626e-19,  3.404879400026185e-21,
 -8.303124403815636e-23,  1.884300206489964e-24, -4.008210001718133e-26,  1.236431857725871e-11, -1.977929553511435e-12,  1.726347166119880e-13, -1.074049223712138e-14,
  5.301224693326409e-16, -2.197922926835779e-17,  7.929784300994996e-19, -2.549563159310589e-20,  7.430884746926276e-22, -1.988572514668263e-23,  4.934849035824459e-25,
 -1.144112966960674e-26,  9.330417247672161e-13, -1.732099952300322e-13,  1.733811691420258e-14, -1.224941229707960e-15,  6.810700775069278e-17, -3.159658658233567e-18,
  1.268273503113733e-19, -4.514116067355940e-21,  1.450049713518281e-22, -4.259877958981322e-24,  1.156330268861747e-25, -2.922582685960798e-27,  6.477951970050659e-14,
 -1.389038743004462e-14,  1.591642601982981e-15, -1.275934706338013e-16,  7.989158225155043e-18, -4.147070538088538e-19,  1.852114863341954e-20, -7.298432503031954e-22,
  2.584152542484043e-23, -8.334370627201332e-25,  2.474646714274054e-26, -6.817997035841561e-28,  4.282280821463425e-15, -1.054803527933229e-15,  1.379812808080124e-16,
 -1.253041518584099e-17,  8.826023936870770e-19, -5.122170313854564e-20,  2.543634434809444e-21, -1.109088974494249e-22,  4.326002152939342e-24, -1.530827481931550e-25,
  4.968767342483785e-27, -1.491236871805172e-28,  2.829048749239370e-16, -7.948558189789083e-17,  1.181932782907274e-17, -1.212104282935452e-18,  9.580146433693308e-20,
 -6.202506861705612e-21,  3.418125124451365e-22, -1.646055839973841e-23,  7.060178561474834e-25, -2.736318995776356e-26,  9.691579432825076e-28, -3.162662466604325e-29,
  1.995501483698917e-17, -6.334114462060312e-18,  1.063348323037765e-18, -1.224569524671329e-19,  1.080716662590923e-20, -7.770879100734419e-22,  4.732557213787031e-23,
 -2.507084233093491e-24,  1.177934943770369e-25, -4.981434354403897e-27,  1.918161190192149e-28, -6.781294775427684e-30,  1.636449409073091e-18, -5.791352603105624e-19,
  1.085938009910150e-19, -1.391153957583870e-20,  1.359119494408174e-21, -1.076689741632564e-22,  7.191557419648980e-24, -4.160655942633528e-25,  2.126486775505994e-26,
 -9.746337229671204e-28,  4.053395372973188e-29, -1.542498089555082e-30,  1.719344123421722e-19, -6.663583584161374e-20,  1.373393720738064e-20, -1.928415138210354e-21,
  2.056963842938987e-22, -1.771984813035898e-23,  1.282050699027123e-24, -8.004892513410429e-26,  4.400063541541618e-27, -2.161830459235206e-28,  9.608362623751478e-30,
 -3.895720714855039e-31,  2.493890024955364e-20, -1.034236282228871e-20,  2.290646405951217e-21, -3.450474947189577e-22,  3.937363551220348e-23, -3.617701073653982e-24,
  2.783432085055679e-25, -1.842863769194532e-26,  1.071224001460467e-27, -5.551518550384293e-29,  2.596305219537903e-30, -1.105004105870915e-31,  4.452618045699519e-21,
 -1.921093719344529e-21,  4.440874523284690e-22, -6.976256429864424e-23,  8.288795658742912e-24, -7.915746367338655e-25,  6.318898547171181e-26, -4.333186439491491e-27,
  2.604549847468475e-28, -1.393552122280592e-29,  6.718665687144872e-31, -2.943505496261680e-32,  8.008661482808042e-02, -2.668348456863717e-04,  9.258539120299779e-07,
 -3.324744815395091e-09,  1.222895594437478e-11, -4.589740132528516e-14,  1.730377463237282e-16, -6.652183172020499e-19,  2.486860580643818e-21, -9.957200665601233e-24,
  3.382498659035811e-26, -1.675798790455559e-28,  6.896289755784751e-02, -2.766727016240431e-04,  1.379312061953411e-06, -7.255761664941254e-09,  3.784275890425951e-11,
 -1.932339107113420e-13,  9.651000931014911e-16, -4.736825805780522e-18,  2.283401632151467e-20, -1.089610199625300e-22,  5.100908011981950e-25, -2.394322735743744e-27,
  5.112733879985442e-02, -2.751017137788301e-04,  1.961562391571845e-06, -1.345722705157276e-08,  8.730871372975209e-11, -5.428322460746504e-13,  3.265367916313791e-15,
 -1.911455996267989e-17,  1.093264417525361e-19, -6.126369962926985e-22,  3.372114592024511e-24, -1.825655759188434e-26,  3.262330106831642e-02, -2.432329480597587e-04,
  2.274432547459813e-06, -1.902868921092451e-08,  1.477997065465310e-10, -1.088812554826603e-12,  7.691670789403470e-15, -5.245448733988261e-17,  3.471641797646877e-19,
 -2.237709276190492e-21,  1.409594725138507e-23, -8.693001447605279e-26,  1.790715847125693e-02, -1.838008330180441e-04,  2.128841229291173e-06, -2.121173198478204e-08,
  1.940597793707966e-10, -1.666532785126941e-12,  1.360168789701202e-14, -1.063907119830455e-16,  8.026330170137211e-19, -5.866960343360777e-21,  4.171315491344902e-23,
 -2.892351066633455e-25,  8.450353538364984e-03, -1.169754055188146e-04,  1.628819372133196e-06, -1.910848305753268e-08,  2.034940052239991e-10, -2.012904813927286e-12,
  1.876659516253855e-14, -1.665703445113698e-16,  1.417968426943796e-18, -1.164002340299265e-20,  9.254370569546626e-23, -7.149396775617752e-25,  3.425670771271152e-03,
 -6.248339924957384e-05,  1.030195492264647e-06, -1.411452474174855e-08,  1.733566895012341e-10, -1.957945433717339e-12,  2.068302565286234e-14, -2.067219620413953e-16,
  1.971232474132238e-18, -1.804525365050689e-20,  1.593569640501343e-22, -1.362678226601000e-24,  1.191992291882406e-03, -2.803112592188929e-05,  5.427606746362071e-07,
 -8.626681510660501e-09,  1.213364334941516e-10, -1.554652833761454e-12,  1.849633257977049e-14, -2.069861548793772e-16,  2.198963656624817e-18, -2.233143558986415e-20,
  2.179551013625096e-22, -2.052961210209572e-24,  3.556918719786942e-04, -1.058081381103252e-05,  2.394108146067574e-07, -4.389914142754267e-09,  7.033305265674839e-11,
 -1.017389290487911e-12,  1.357118061786381e-14, -1.693161991732752e-16,  1.995866757735355e-18, -2.239777055683426e-20,  2.406928508209287e-22, -2.488194869788335e-24,
  9.094350023540483e-05, -3.367111079752338e-06,  8.872352556373524e-08, -1.868455216212988e-09,  3.396344469187742e-11, -5.526574748211515e-13,  8.237556643265775e-15,
 -1.142134695797744e-16,  1.489309316864712e-18, -1.841465305184521e-20,  2.172732863033629e-22, -2.458374859498279e-24,  1.990855889734724e-05, -9.050069478629183e-07,
  2.769595151058603e-08, -6.675387268536945e-10,  1.372637646868598e-11, -2.505890874590744e-13,  4.163347227424150e-15, -6.400095135626136e-17,  9.211346159254787e-19,
 -1.252216235225987e-20,  1.618863029284747e-22, -2.000785941558647e-24,  3.729551981714883e-06, -2.058043143975899e-07,  7.298277552775912e-09, -2.007981286900417e-10,
  4.660980581222220e-12, -9.528614820650266e-14,  1.761561082099254e-15, -2.997514508536806e-17,  4.754398114474729e-19, -7.095501668414788e-21,  1.003633967021869e-22,
 -1.353013420184475e-24,  5.978412196212406e-07, -3.966945651048842e-08,  1.626992972857896e-09, -5.100235337946821e-11,  1.334544156952134e-12, -3.051417992184985e-14,
  6.270175204938538e-16, -1.179828491991856e-17,  2.060290636757825e-19, -3.372405345176623e-21,  5.214295309792636e-23, -7.660643811246057e-25,  8.205243200394093e-08,
 -6.495573354473781e-09,  3.076109559996180e-10, -1.097312345837850e-11,  3.233983705878311e-13, -8.264910689669739e-15,  1.886618378054637e-16, -3.923556140026126e-18,
  7.539766564293832e-20, -1.352979415390087e-21,  2.285650350769111e-23, -3.657777433020683e-25,  9.658352665731735e-09, -9.062492874474361e-10,  4.948838801088510e-11,
 -2.007436754974934e-12,  6.661465629789236e-14, -1.902516823282155e-15,  4.823962756805549e-17, -1.108747588030205e-18,  2.344547087736949e-20, -4.612016865109401e-22,
  8.512194946579062e-24, -1.483691987371846e-25,  9.782591882031879e-10, -1.082065363737966e-10,  6.806359391522868e-12, -3.138596269644650e-13,  1.172791041137987e-14,
 -3.744068705050220e-16,  1.054833614881290e-17, -2.680331927077066e-19,  6.238814139581117e-21, -1.345738667532269e-22,  2.714292758128934e-24, -5.154023739776036e-26,
  8.574833667556329e-11, -1.112974690468096e-11,  8.057242971556660e-13, -4.223794666007513e-14,  1.777973179419738e-15, -6.348364601983050e-17,  1.988570810566733e-18,
 -5.589824753699941e-20,  1.433062343418087e-21, -3.391556392943060e-23,  7.479401615370924e-25, -1.547899097583657e-26,  6.565195885997073e-12, -9.959269511406288e-13,
  8.292088416770614e-14, -4.942845962562576e-15,  2.345359394755628e-16, -9.373536468425927e-18,  3.267302469701671e-19, -1.016869271170095e-20,  2.873664427970737e-22,
 -7.467449924959563e-24,  1.801817479312173e-25, -4.066644770380650e-27,  4.454697689767772e-13, -7.868584029396480e-14,  7.529316558757464e-15, -5.104769890593899e-16,
  2.732183954463471e-17, -1.223289671257815e-18,  4.749136020473631e-20, -1.637943357864594e-21,  5.106754643091017e-23, -1.458232832509280e-24,  3.852531168216166e-26,
 -9.488334960181572e-28,  2.738639819359401e-14, -5.610849131496952e-15,  6.164106691812278e-16, -4.753337083434360e-17,  2.870971749946768e-18, -1.440968536987298e-19,
  6.235198827168865e-21, -2.384808168079372e-22,  8.208551354433038e-24, -2.577249953401607e-25,  7.459051800284856e-27, -2.005522486104120e-28,  1.576616918308953e-15,
 -3.729430023660264e-16,  4.695739538952296e-17, -4.115666321237715e-18,  2.804671627146480e-19, -1.578086318692996e-20,  7.611951262148445e-22, -3.229123109633144e-23,
  1.227208479408445e-24, -4.236866915754504e-26,  1.343305911969004e-27, -3.942479680694227e-29,  8.919152609600224e-17, -2.421110427050353e-17,  3.482576381574418e-18,
 -3.462124727248066e-19,  2.657907795493461e-20, -1.674496141113322e-21,  8.994056543856251e-23, -4.227589948048761e-24,  1.772202264742892e-25, -6.720941619034409e-27,
  2.331822611388350e-28, -7.461700453317749e-30,  5.308600265737462e-18, -1.639362725060271e-18,  2.678470695613986e-19, -3.006559249437919e-20,  2.590281977888377e-21,
 -1.820887077669571e-22,  1.085577918023441e-23, -5.636501738226564e-25,  2.598454243627850e-26, -1.079290330432007e-27,  4.085645411494899e-29, -1.421225705883713e-30,
  3.643562876350041e-19, -1.264006181832023e-19,  2.322862832640282e-20, -2.919154097143333e-21,  2.800755510256262e-22, -2.181231019295268e-23,  1.433689162878654e-24,
 -8.169767581139821e-26,  4.116142534354920e-27, -1.861164130216387e-28,  7.641663878706227e-30, -2.872881072321582e-31,  3.220468889809666e-20, -1.232753796780067e-20,
  2.508287727986113e-21, -3.478683253276857e-22,  3.667376235047762e-23, -3.124554100731015e-24,  2.237196224740890e-25, -1.383182695052817e-26,  7.532598691231932e-28,
 -3.668505452127198e-29,  1.616972930955705e-30, -6.504664156837054e-32,  4.035076685325093e-21, -1.663429642258261e-21,  3.660942370695877e-22, -5.480842895250895e-23,
  6.217766809897633e-24, -5.681399829013124e-25,  4.348373625399904e-26, -2.864746072043185e-27,  1.657431128804510e-28, -8.551403367939559e-30,  3.982471478676043e-31,
 -1.688227013860336e-32,  6.558506922745608e-22, -2.824536767039821e-22,  6.516376134780488e-23, -1.021674418770999e-23,  1.211613278338794e-24, -1.154997053806052e-25,
  9.204090733044575e-27, -6.301303378017827e-28,  3.781557048444297e-29, -2.020253905906875e-30,  9.726097883118013e-32, -4.255214757228525e-33,  7.903384103307123e-02,
 -2.595843441941264e-04,  8.871013757191884e-07, -3.136205638522027e-09,  1.135107336363565e-11, -4.195933851431427e-14,  1.554736376905318e-16, -5.911272447283179e-19,
  2.151003849712350e-21, -8.749063322676903e-24,  2.662111420162640e-26, -1.622792909593758e-28,  6.787773846086829e-02, -2.659764742151326e-04,  1.295752249293739e-06,
 -6.679980111831913e-09,  3.419937342982661e-11, -1.715840027739651e-13,  8.421358379855831e-16, -4.065158232505826e-18,  1.925461853358213e-20, -9.052078620229003e-23,
  4.152627380574154e-25, -1.935099925918024e-27,  5.005732666623840e-02, -2.600322118908372e-04,  1.808112346464465e-06, -1.214305786191977e-08,  7.719436516992656e-11,
 -4.705100692826916e-13,  2.775999781223322e-15, -1.594445260927681e-17,  8.951770430374505e-20, -4.925315676102271e-22,  2.662947076506502e-24, -1.416126377738083e-26,
  3.168536866873173e-02, -2.259122554639520e-04,  2.059589610004983e-06, -1.682855167433182e-08,  1.277566751957326e-10, -9.206525398874878e-13,  6.367098810851379e-15,
 -4.253239267745399e-17,  2.758975705929307e-19, -1.743478517083865e-21,  1.077379334654594e-23, -6.517438046502554e-26,  1.720447582571484e-02, -1.677379047800574e-04,
  1.891885079213141e-06, -1.835664717391634e-08,  1.637664461076920e-10, -1.373121466378386e-12,  1.095273501966285e-14, -8.378712786020508e-17,  6.186243410828156e-19,
 -4.427506906189840e-21,  3.083882489721771e-23, -2.095398130915613e-25,  8.007135080472726e-03, -1.048096154984289e-04,  1.417799631764956e-06, -1.615167032582568e-08,
  1.673870545278666e-10, -1.613709886618073e-12,  1.467963791884762e-14, -1.272428357715364e-16,  1.058619432010405e-18, -8.498179330771999e-21,  6.611052590574703e-23,
 -4.999587585515805e-25,  3.191210452921072e-03, -5.487498960509569e-05,  8.762534741822478e-07, -1.162896534359827e-08,  1.387273040890618e-10, -1.524442431072197e-12,
  1.568839788272052e-14, -1.529147165282484e-16,  1.423229835292431e-18, -1.272583083387980e-20,  1.098398500390447e-22, -9.185118049732937e-25,  1.087939994979732e-03,
 -2.407233333209623e-05,  4.499357923817847e-07, -6.911760218292406e-09,  9.425119985381292e-11, -1.173023522854709e-12,  1.357604381306307e-14, -1.479616454015486e-16,
  1.532388969423726e-18, -1.518332968194139e-20,  1.446869842274122e-22, -1.331462859790128e-24,  3.168906610026931e-04, -8.858551545863255e-06,  1.928655544176029e-07,
 -3.411161743117801e-09,  5.289270415712559e-11, -7.420376904942836e-13,  9.615361863410627e-15, -1.166862737120368e-16,  1.339354162683978e-18, -1.464905569643405e-20,
  1.535522324621646e-22, -1.549432599467090e-24,  7.876464593379513e-05, -2.738545949686911e-06,  6.922984147667468e-08, -1.403721241759412e-09,  2.465370817831562e-11,
 -3.885039246508437e-13,  5.617965917088777e-15, -7.567597704850382e-17,  9.598434490819171e-19, -1.155559253669060e-20,  1.328708752803914e-22, -1.466241386364173e-24,
  1.668574314723276e-05, -7.120960426399639e-07,  2.085388475824222e-08, -4.831362435385349e-10,  9.584240477185886e-12, -1.692180273818158e-13,  2.724222241085241e-15,
 -4.064166410233099e-17,  5.683966544353674e-19, -7.516708936705669e-21,  9.462234621191392e-23, -1.139696992579166e-24,  3.009462580355254e-06, -1.559198292868993e-07,
  5.279994776639077e-09, -1.394283525082300e-10,  3.118024424376595e-12, -6.157209727131164e-14,  1.101768786433907e-15, -1.817645630765563e-17,  2.798966045416041e-19,
 -4.060244423233496e-21,  5.588032090359912e-23, -7.336684767446591e-25,  4.617764878484724e-07, -2.878020692932086e-08,  1.125312630635363e-09, -3.381450831112487e-11,
  8.514080925163531e-13, -1.878424941795769e-14,  3.732435103466372e-16, -6.803155653974386e-18,  1.152485246496423e-19, -1.832350428764917e-21,  2.754889751917737e-23,
 -3.939507364917704e-25,  6.026738744979087e-08, -4.484562946841557e-09,  2.022303893510323e-10, -6.908087466661934e-12,  1.957191182027931e-13, -4.822101141414853e-15,
  1.063545293152489e-16, -2.141016770832001e-18,  3.988742843139242e-20, -6.948393206450803e-22,  1.140838437048822e-23, -1.776264891635036e-25,  6.694829481015901e-09,
 -5.911099279442786e-10,  3.071670149162789e-11, -1.192306159428159e-12,  3.800787740489798e-14, -1.045799864248639e-15,  2.560585416058009e-17, -5.693858775458756e-19,
  1.166727511536404e-20, -2.227110043902022e-22,  3.993593660689515e-24, -6.770441464851784e-26,  6.343335453394515e-10, -6.612186338851912e-11,  3.957264112840106e-12,
 -1.745596898731361e-13,  6.263481845526190e-15, -1.925706574519934e-16,  5.237171144471514e-18, -1.287098753488093e-19,  2.902387808796686e-21, -6.073931418342427e-23,
  1.190074172216350e-24, -2.197721858710809e-26,  5.148477336459468e-11, -6.309721205853238e-12,  4.347973978201000e-13, -2.180623938611337e-14,  8.814315154562865e-16,
 -3.030835581588367e-17,  9.164254997583479e-19, -2.491520171254172e-20,  6.188353225515235e-22, -1.421000183231438e-23,  3.044497385083768e-25, -6.128625783333579e-27,
  3.606822994670901e-12, -5.179168371185786e-13,  4.109018037508467e-14, -2.344845161475393e-15,  1.068907677302037e-16, -4.115728260244184e-18,  1.385323396161811e-19,
 -4.171561567068896e-21,  1.142561160028740e-22, -2.881871615647042e-24,  6.758497019324806e-26, -1.484370580060258e-27,  2.208656292566226e-13, -3.704551689102906e-14,
  3.383941254896958e-15, -2.199269743258850e-16,  1.132071129913925e-17, -4.887853772355592e-19,  1.834023680988288e-20, -6.125308672716560e-22,  1.852437654441710e-23,
 -5.138563190611842e-25,  1.320554072552999e-26, -3.167591410616901e-28,  1.206171516585584e-14, -2.355894313353083e-15,  2.477348207341810e-16, -1.835145161072647e-17,
  1.067948974751769e-18, -5.177387262574715e-20,  2.168539056354462e-21, -8.043323327242984e-23,  2.689194574433693e-24, -8.213293863106268e-26,  2.315357270508531e-27,
 -6.071044073739300e-29,  6.060333256927301e-16, -1.373419342418504e-16,  1.661326647772865e-17, -1.403085011610281e-18,  9.237520769026465e-20, -5.032850983646742e-21,
  2.355278181291727e-22, -9.710563659822096e-24,  3.592193188894277e-25, -1.208836180695057e-26,  3.740433339161450e-28, -1.072627560812541e-29,  2.936906299682409e-17,
 -7.683738147155124e-18,  1.066969317742242e-18, -1.026391911071462e-19,  7.641583953372453e-21, -4.677885488964567e-22,  2.445663838624716e-23, -1.120682461936680e-24,
  4.586236428472216e-26, -1.700098956125686e-27,  5.772171497370367e-29, -1.809470452187991e-30,  1.471480805350052e-18, -4.410716922646068e-19,  6.999281242179659e-20,
 -7.643908669761213e-21,  6.418326171831341e-22, -4.404310637130400e-23,  2.566864562730802e-24, -1.304567138925899e-25,  5.893897705741417e-27, -2.401746822413583e-28,
  8.928579306297675e-30, -3.053005357275358e-31,  8.401815330057803e-20, -2.851596111301219e-20,  5.126438677297161e-21, -6.309365857820926e-22,  5.935736939789559e-23,
 -4.538198087603842e-24,  2.931523513986648e-25, -1.643389957693844e-26,  8.152938088687204e-28, -3.633032133559850e-29,  1.471202657076471e-30, -5.459177821960421e-32,
  6.186696866176397e-21, -2.335724905153710e-21,  4.685366819900766e-22, -6.410057585112338e-23,  6.671259368069028e-24, -5.615252697926711e-25,  3.974850742481906e-26,
 -2.431182790582197e-27,  1.310597227511886e-28, -6.321866994673272e-30,  2.761328580272830e-31, -1.101333695429725e-32,  6.618603117755640e-22, -2.710288144142310e-22,
  5.922898504060021e-23, -8.806846834638158e-24,  9.926287213611224e-25, -9.014479071912267e-26,  6.859518385752714e-27, -4.494431911307498e-28,  2.586887106022733e-29,
 -1.328174728184876e-30,  6.156876359336698e-32, -2.598601472576262e-33,  9.703634453517370e-23, -4.170623590906575e-23,  9.600843381810007e-24, -1.502043000659897e-24,
  1.777606268536788e-25, -1.691193027717077e-26,  1.345156939307386e-27, -9.192630849791225e-29,  5.507229573904402e-30, -2.937347277685481e-31,  1.411908439021868e-32,
 -6.167932062831291e-34,  7.800946320302916e-02, -2.526350460554724e-04,  8.505295596095282e-07, -2.961104712495975e-09,  1.054789857842201e-11, -3.841909596272818e-14,
  1.398397584985370e-16, -5.271431360816499e-19,  1.853466635044210e-21, -7.829224077937399e-24,  1.927749819917989e-26, -1.752775420593723e-28,  6.683406971897192e-02,
 -2.559220468968658e-04,  1.218765836731554e-06, -6.159182917412108e-09,  3.096093365385819e-11, -1.526719115925036e-13,  7.364695031202548e-16, -3.498104331857785e-18,
  1.627536497144837e-20, -7.550194259733200e-23,  3.382568055894569e-25, -1.580991872127434e-27,  4.904523347228896e-02, -2.461298754168562e-04,  1.669507099183395e-06,
 -1.097975589693061e-08,  6.841584767915839e-11, -4.089353922259859e-13,  2.367133264970655e-15, -1.334418506870564e-17,  7.356277926433199e-20, -3.974933669200462e-22,
  2.111732915599899e-24, -1.103117824979997e-26,  3.081344138986678e-02, -2.102099066382733e-04,  1.869329829972005e-06, -1.492383425490756e-08,  1.107801849166729e-10,
 -7.811905612480966e-13,  5.290920262450893e-15, -3.463003833875791e-17,  2.202452779597091e-19, -1.364799686768821e-21,  8.276951868538008e-24, -4.911269525893117e-26,
  1.656245950950290e-02, -1.534413968933846e-04,  1.686464809594096e-06, -1.594256031853090e-08,  1.387536094827125e-10, -1.136310545830877e-12,  8.861475899357289e-15,
 -6.632023886004006e-17,  4.793835753445919e-19, -3.360238374678801e-21,  2.293744856330255e-23, -1.527487012550677e-25,  7.609415078043873e-03, -9.419930356060041e-05,
  1.239042551748213e-06, -1.371367471879854e-08,  1.383660302372979e-10, -1.300589648620749e-12,  1.154851186951488e-14, -9.779169510521759e-17,  7.954230831994302e-19,
 -6.246210319878639e-21,  4.756171604879643e-23, -3.521874807673768e-25,  2.984897124064471e-03, -4.838760943108589e-05,  7.490800810527868e-07, -9.634149893100437e-09,
  1.116817658017232e-10, -1.194548670008682e-12,  1.198113749783979e-14, -1.139266399140346e-16,  1.035329524162563e-18, -9.045159502975279e-21,  7.633005851437440e-23,
 -6.243782738175163e-25,  9.983583190880841e-04, -2.078064974637323e-05,  3.753223124731304e-07, -5.575036624265867e-09,  7.374003377590031e-11, -8.918402520726632e-13,
  1.004480183767658e-14, -1.066590991388272e-16,  1.077241697648685e-18, -1.041723774761111e-20,  9.695356738718143e-23, -8.719196435947590e-25,  2.843019754401767e-04,
 -7.466027676257011e-06,  1.565573451959261e-07, -2.672095644602742e-09,  4.011809913378564e-11, -5.460804746527286e-13,  6.876633709999156e-15, -8.120096312464446e-17,
  9.078790559775462e-19, -9.681043561404858e-21,  9.901220728651024e-23, -9.754940092273970e-25,  6.882020112322243e-05, -2.245926298616464e-06,  5.451743203335780e-08,
 -1.064759288891361e-09,  1.807673896172889e-11, -2.759796867638020e-13,  3.873151757999311e-15, -5.070538298315408e-17,  6.257662019827482e-19, -7.337512517056507e-21,
  8.224419904306123e-23, -8.853832956117620e-25,  1.413767091105650e-05, -5.660845037409329e-07,  1.587518547781073e-08, -3.536637891898747e-10,  6.771166989692871e-12,
 -1.156631277962620e-13,  1.804907149432275e-15, -2.614007555756183e-17,  3.553519752579158e-19, -4.572721933049456e-21,  5.606451989576066e-23, -6.582543309915160e-25,
  2.460751347813984e-06, -1.196093754690623e-07,  3.869768715436029e-09, -9.811121143402643e-11,  2.114491887188318e-12, -4.034589704008336e-14,  6.989925594508632e-16,
 -1.118318384640926e-17,  1.672317085150512e-19, -2.358537854529876e-21,  3.159071416100330e-23, -4.040201626199159e-25,  3.623836811714184e-07, -2.119490281603760e-08,
  7.902922043686346e-10, -2.276872970006645e-11,  5.517923195334975e-13, -1.174963710308418e-14,  2.258099771587623e-16, -3.987799074196411e-18,  6.554805776524503e-20,
 -1.012451900146334e-21,  1.480413533130550e-23, -2.060893627493588e-25,  4.510632296709274e-08, -3.151592583827921e-09,  1.353389956104817e-10, -4.427486850616368e-12,
  1.206040496633059e-13, -2.865046653085131e-15,  6.106436814555316e-17, -1.190088576068091e-18,  2.149748630855541e-20, -3.635805086474715e-22,  5.802376853728522e-24,
 -8.790321660604016e-26,  4.743984737876303e-09, -3.936656801281434e-10,  1.946254415718908e-11, -7.228646858931880e-13,  2.213611354500634e-14, -5.868190940802012e-16,
  1.387477163305476e-17, -2.985024496786720e-19,  5.927361858195892e-21, -1.097957783751340e-22,  1.912880346667737e-24, -3.154252854435886e-26,  4.219643381451963e-10,
 -4.139268405660711e-11,  2.355923205801139e-12, -9.938549973180965e-14,  3.423803007407873e-15, -1.013634689071358e-16,  2.660799940085574e-18, -6.324125102941371e-20,
  1.381461690936417e-21, -2.804620385903235e-23,  5.337657605366959e-25, -9.585636030279584e-27,  3.183162134867818e-11, -3.677629733200956e-12,  2.410445150572192e-13,
 -1.155990808288709e-14,  4.485265000341538e-16, -1.484804386881105e-17,  4.332586662135730e-19, -1.138997796081353e-20,  2.740199695279299e-22, -6.103728543581861e-24,
  1.270227754518293e-25, -2.486640391988017e-27,  2.048457966842820e-12, -2.779266765788288e-13,  2.098936284500233e-14, -1.145810213820697e-15,  5.015026866918530e-17,
 -1.859398359962948e-18,  6.040891416885230e-20, -1.759311391273274e-21,  4.668396441379454e-23, -1.142522213906264e-24,  2.603312113007358e-26, -5.562097172622127e-28,
  1.136452737172971e-13, -1.806354365912498e-14,  1.573030108939959e-15, -9.789957160609344e-17,  4.842474062611906e-18, -2.014724459885868e-19,  7.301565144420836e-21,
 -2.360010090141290e-22,  6.919152759407033e-24, -1.863523518735676e-25,  4.656107546076228e-27, -1.087206170826727e-28,  5.532752475230686e-15, -1.027923620718758e-15,
  1.032931820535001e-16, -7.340693537646224e-18,  4.111297677892151e-19, -1.923282605056839e-20,  7.790608523106057e-22, -2.799928201460529e-23,  9.086019447252123e-25,
 -2.697490162857157e-26,  7.401778416538984e-28, -1.891463990948566e-29,  2.432787053806093e-16, -5.269163755674913e-17,  6.111630087054924e-18, -4.965762445752320e-19,
  3.154158131053837e-20, -1.661930323849408e-21,  7.537256255048490e-23, -3.017010207700640e-24,  1.085305647422482e-25, -3.556683729600002e-27,  1.073123838925555e-28,
 -3.004371296281878e-30,  1.011032807290776e-17, -2.542955742809088e-18,  3.401723761730216e-19, -3.160754803769714e-20,  2.278423713435533e-21, -1.353291251811937e-22,
  6.877596601625692e-24, -3.068580819780531e-25,  1.224526013754663e-26, -4.432217247741091e-28,  1.471116244271697e-29, -4.513507934559455e-31,  4.257282783238233e-19,
 -1.235594458408801e-19,  1.900272344390106e-20, -2.015236163481381e-21,  1.646316291292402e-22, -1.101054434852593e-23,  6.264054506503598e-25, -3.112113205956186e-26,
  1.376207714796405e-27, -5.495493282030388e-29,  2.004111835035940e-30, -6.729224707460064e-32,  2.011144190085600e-20, -6.663684758931273e-21,  1.169591126998651e-21,
 -1.407209948215571e-22,  1.296004565615296e-23, -9.712816712952007e-25,  6.157587404990712e-26, -3.391516258291786e-27,  1.654790353419180e-28, -7.258993479143871e-30,
  2.896197774996438e-31, -1.059704997434992e-32,  1.221728860459817e-21, -4.542142736100198e-22,  8.968979873772240e-23, -1.208735280423850e-23,  1.240281193949768e-24,
 -1.030131314514893e-25,  7.201140811981944e-27, -4.352878468933900e-28,  2.320616623357372e-29, -1.107716713138157e-30,  4.790753355455441e-32, -1.892999824749385e-33,
  1.102240826307328e-22, -4.479828206380660e-23,  9.712818905975574e-24, -1.433242443931039e-24,  1.603786695208105e-25, -1.446566041877562e-26,  1.093703721884584e-27,
 -7.122783868089938e-29,  4.076345522854221e-30, -2.081643711374096e-31,  9.600603058104122e-33, -4.032645250634900e-34,  1.442805175788366e-23, -6.187293372281263e-24,
  1.420874679523793e-24, -2.217670801402972e-25,  2.618543187820355e-26, -2.485833106317330e-27,  1.973109491750537e-28, -1.345737971511566e-29,  8.047056436802865e-31,
 -4.284307774077520e-32,  2.055840268382658e-33, -8.966347370361809e-35,  7.701231042266662e-02, -2.459701308131227e-04,  8.159841219739508e-07, -2.798307940659742e-09,
  9.811916191163537e-12, -3.523361521088625e-14,  1.258687030247482e-16, -4.722086448556046e-19,  1.583549905782479e-21, -7.222293417872808e-24,  1.075759610145911e-26,
 -2.183715931807193e-28,  6.582942527757746e-02, -2.464593655921745e-04,  1.147730150226678e-06, -5.687307402989481e-09,  2.807660822804268e-11, -1.361155762615456e-13,
  6.454231838265488e-16, -3.018301352785186e-18,  1.378485021133701e-20, -6.327904211405723e-23,  2.748092358298372e-25, -1.317154965175457e-27,  4.808661709945479e-02,
 -2.332828399351501e-04,  1.544057715262703e-06, -9.947567669774760e-09,  6.077630788862601e-11, -3.563544990539853e-13,  2.024411932497752e-15, -1.120373309399896e-17,
  6.066343775750538e-20, -3.219778261282653e-22,  1.681538044415929e-24, -8.626448765721938e-27,  3.000141785781099e-02, -1.959426239979263e-04,  1.700384612212387e-06,
 -1.326975833548286e-08,  9.635158491722415e-11, -6.650909754531286e-13,  4.412995000387017e-15, -2.830841210818619e-17,  1.765858915198454e-19, -1.073172168454407e-21,
  6.391201591244798e-24, -3.718048529341747e-26,  1.597451681941124e-02, -1.406788354604343e-04,  1.507760245145988e-06, -1.389335844324955e-08,  1.180122449341569e-10,
 -9.442910281815002e-13,  7.202277718526785e-15, -5.275073457395612e-17,  3.734301440745444e-19, -2.564186912448361e-21,  1.716132268537532e-23, -1.120065584491240e-25,
  7.251450949374645e-03, -8.490946745089114e-05,  1.086949561025702e-06, -1.169373508689422e-08,  1.149181172272201e-10, -1.053602482677496e-12,  9.135341707131647e-15,
 -7.559708631772406e-17,  6.013735324372778e-19, -4.620816735540718e-21,  3.445173435666125e-23, -2.498415260225363e-25,  2.802640385775504e-03, -4.282874987087121e-05,
  6.434511287253310e-07, -8.023766907843126e-09,  9.042602389646507e-11, -9.418180371042823e-13,  9.209976209989671e-15, -8.546665281484711e-17,  7.586301663171649e-19,
 -6.477831633320251e-21,  5.346348375947812e-23, -4.279092106709192e-25,  9.208438046169254e-04, -1.802689098414690e-05,  3.149521160079857e-07, -4.525741605168837e-09,
  5.809083117480843e-11, -6.830286645348971e-13,  7.489504537208354e-15, -7.750828547581333e-17,  7.636779704424886e-19, -7.209920783516001e-21,  6.555829480382659e-23,
 -5.763374914187880e-25,  2.567540829716495e-04, -6.331692777699473e-06,  1.280101902581900e-07, -2.109329645621598e-09,  3.067841108121004e-11, -4.053385433856967e-13,
  4.962342086612569e-15, -5.703744820545191e-17,  6.213931276762420e-19, -6.462176073756063e-21,  6.450564172006363e-23, -6.206916164473508e-25,  6.063428013681062e-05,
 -1.856367332416931e-06,  4.330867375971864e-08, -8.150825478634224e-10,  1.338243740978266e-11, -1.980214105758251e-13,  2.698154410519402e-15, -3.434142712238514e-17,
  4.125095405806700e-19, -4.712466031208513e-21,  5.150492632775954e-23, -5.410563475806320e-25,  1.210284361485544e-05, -4.543787890843902e-07,  1.221191003291254e-08,
 -2.617051610710126e-10,  4.837843960883987e-12, -7.998139677379189e-14,  1.210221227147464e-15, -1.702081816565963e-17,  2.249756241807725e-19, -2.817823382523522e-21,
  3.365806946421818e-23, -3.853115440570620e-25,  2.037511668984782e-06, -9.284131362204408e-08,  2.871482912742736e-09, -6.991970842892142e-11,  1.452790194288835e-12,
 -2.679344030409025e-14,  4.495749872264970e-16, -6.977395797791524e-18,  1.013506938530473e-19, -1.390041958065475e-21,  1.812400909916337e-23, -2.258360358332468e-25,
  2.887088627208313e-07, -1.583149562691772e-08,  5.631442397890989e-10, -1.555963227158027e-11,  3.630452733927049e-13, -7.463068449824263e-15,  1.387601788018768e-16,
 -2.374804813686031e-18,  3.788346078812404e-20, -5.685806574148957e-22,  8.087111515904587e-24, -1.096160056011015e-25,  3.437004723988896e-08, -2.252484281916705e-09,
  9.212624848429396e-11, -2.886673212422519e-12,  7.561514948610812e-14, -1.732298595453455e-15,  3.568536231861621e-17, -6.734088766872391e-19,  1.179625800971966e-20,
 -1.937228048470713e-22,  3.005419699544187e-24, -4.430645518961269e-26,  3.433241849711003e-09, -2.674289171485524e-10,  1.257761234673247e-11, -4.469834301113786e-13,
  1.314967224564915e-14, -3.358725790092367e-16,  7.669344199422131e-18, -1.596485593903535e-19,  3.072251505634992e-21, -5.522768830331795e-23,  9.348868426132793e-25,
 -1.499474398519204e-26,  2.876718252382709e-10, -2.651871966997588e-11,  1.434869509473315e-12, -5.787595563857036e-14,  1.914029759730398e-15, -5.456171500594158e-17,
  1.382354530199943e-18, -3.177319058188287e-20,  6.723182293565847e-22, -1.324070306009433e-23,  2.447589877086351e-25, -4.274215535730616e-27,  2.024578438210042e-11,
 -2.201522471499297e-12,  1.371561236105781e-13, -6.287101420135458e-15,  2.340870262653806e-16, -7.458648471029658e-18,  2.099863604894322e-19, -5.336956837992593e-21,
  1.243441550834839e-22, -2.686326729002249e-24,  5.429226360848391e-26, -1.033429922523312e-27,  1.201587180632778e-12, -1.537566077656857e-13,  1.104264253822387e-14,
 -5.762725255246245e-16,  2.420428089034315e-17, -8.637548362273395e-19,  2.707527565476541e-20, -7.623487157845356e-22,  1.959196930300022e-23, -4.650922147620244e-25,
  1.029328621620294e-26, -2.138735075117581e-28,  6.064118713295023e-14, -9.115276404028840e-15,  7.557766237402544e-16, -4.499932009370030e-17,  2.137180162029241e-18,
 -8.562454169585952e-20,  2.995358298314339e-21, -9.364411257853882e-23,  2.660224088558963e-24, -6.952989436076780e-26,  1.688225146890192e-27, -3.835653932857770e-29,
  2.642133243223263e-15, -4.658556964677010e-16,  4.466282104142538e-17, -3.041181052630694e-18,  1.637498453341054e-19, -7.384844561162590e-21,  2.890506815573713e-22,
 -1.005817967867363e-23,  3.165715626060717e-25, -9.129628219854068e-27,  2.436820712164180e-28, -6.065029450039491e-30,  1.019992707352446e-16, -2.106093993735863e-17,
  2.337921848827481e-18, -1.824633731159875e-19,  1.116629741814391e-20, -5.683090691428895e-22,  2.495062366229564e-23, -9.686522496973538e-25,  3.385283697674854e-26,
 -1.079419486419433e-27,  3.173089129656475e-29, -8.665978014770030e-31,  3.641722166847735e-18, -8.782609916047477e-19,  1.129359614741562e-19, -1.011712940303737e-20,
  7.049727169420142e-22, -4.056845442491348e-23,  2.001503183793044e-24, -8.684422633075595e-26,  3.375464779303503e-27, -1.191676998250766e-28,  3.862858705941925e-30,
 -1.158824528702656e-31,  1.287748594093113e-19, -3.609297079187222e-20,  5.367554668118052e-21, -5.516597385701280e-22,  4.376903216962130e-23, -2.848400227917073e-24,
  1.579528097625397e-25, -7.660735531860501e-27,  3.311616759813049e-28, -1.294331139716907e-29,  4.625268087576932e-31, -1.523428827763367e-32,  5.009036925753211e-21,
 -1.616436860879747e-21,  2.764018594307682e-22, -3.244767009348783e-23,  2.920321552672711e-24, -2.141932415049970e-25,  1.330727734779722e-26, -7.191500625812997e-28,
  3.446650557963144e-29, -1.486617605122886e-30,  5.837446895075967e-32, -2.103949004187782e-33,  2.486205022625027e-22, -9.086116169430094e-23,  1.763136503111127e-23,
 -2.337049169289954e-24,  2.360914010288677e-25, -1.932388160062975e-26,  1.332403911187866e-27, -7.950692945653257e-29,  4.187529684485494e-30, -1.976127605870285e-31,
  8.454805194656393e-33, -3.306997763110366e-34,  1.866902141250865e-23, -7.523610535100978e-24,  1.616804149436125e-24, -2.365531405157581e-25,  2.625755715162354e-26,
 -2.350443847387116e-27,  1.764458372876332e-28, -1.141419676026037e-29,  6.491143260087533e-31, -3.295106578252376e-32,  1.511196803936488e-33, -6.314131237937013e-35,
  2.157044466788287e-24, -9.227097155814877e-25,  2.113236965403558e-25, -3.289612955944723e-26,  3.874459980152942e-27, -3.669269265196854e-28,  2.905806558041785e-29,
 -1.977576659892441e-30,  1.180086323930735e-31, -6.270540989689799e-33,  3.003324394606618e-34, -1.307547064725436e-35,  7.604127667244642e-02, -2.395739602879249e-04,
  7.833236360819903e-07, -2.646794922704386e-09,  9.136409989622776e-12, -3.236594008836010e-14,  1.133176812379072e-16, -4.256321340529809e-19,  1.328774547916185e-21,
 -7.007264491959838e-24, -6.897543156103405e-28, -3.127407832928251e-28,  6.486152977760995e-02, -2.375430798750234e-04,  1.082090629357286e-06, -5.259046395386581e-09,
  2.550260170592109e-11, -1.215917548890922e-13,  5.667583796331273e-16, -2.611623068620790e-18,  1.169124660188616e-20, -5.338696377098662e-23,  2.210969384635660e-25,
 -1.138420474833002e-27,  4.717745729296071e-02, -2.213918553274403e-04,  1.430294503707801e-06, -9.029626476011038e-09,  5.411075656690050e-11, -3.113239718768258e-13,
  1.736230509156229e-15, -9.435687767934102e-18,  5.019682717325450e-20, -2.617260395708523e-22,  1.344570782655649e-24, -6.768097424743767e-27,  2.924388072566532e-02,
 -1.829512627134700e-04,  1.549976235118151e-06, -1.182905143596968e-08,  8.404783546060231e-11, -5.680861973246167e-13,  3.693996022585435e-15, -2.322949835682174e-17,
  1.421850690392526e-19, -8.474283664034045e-22,  4.960918619405359e-24, -2.825275153139835e-26,  1.543491324452890e-02, -1.292529120767867e-04,  1.351774993719671e-06,
 -1.214733625944859e-08,  1.007419655820326e-10, -7.878910727734763e-13,  5.879568041592089e-15, -4.215452201611766e-17,  2.923743162889775e-19, -1.966944481502043e-21,
  1.291477054754408e-23, -8.257658064376354e-26,  6.928357659135769e-03, -7.674544002081910e-05,  9.569982129148498e-07, -1.001239156336012e-08,  9.587771459671264e-11,
 -8.577250400125796e-13,  7.264809423818630e-15, -5.876885132531743e-17,  4.573918765189550e-19, -3.439725274302308e-21,  2.512186188445269e-23, -1.784278504263020e-25,
  2.641043727847835e-03, -3.804304315885643e-05,  5.552620170661297e-07, -6.716398513126482e-09,  7.361953291992289e-11, -7.469537815167591e-13,  7.124460606467652e-15,
 -6.454317235320835e-17,  5.597806692662604e-19, -4.673107992986890e-21,  3.773409886039335e-23, -2.955716727999065e-25,  8.534525319537576e-04, -1.570968717126439e-05,
  2.657988703777783e-07, -3.696497678849233e-09,  4.606526622616512e-11, -5.267847719751312e-13,  5.625720379931238e-15, -5.676313242863412e-17,  5.457917197290514e-19,
 -5.032260518123151e-21,  4.471839887490654e-23, -3.844036497869062e-25,  2.333261839192532e-04, -5.401091165123579e-06,  1.053954074519577e-07, -1.677363500342877e-09,
  2.364400262924587e-11, -3.033583501032042e-13,  3.611967748627266e-15, -4.042600311154901e-17,  4.292943219520745e-19, -4.355340975239368e-21,  4.244501987023806e-23,
 -3.989952458829392e-25,  5.384457227239590e-05, -1.545661536132314e-06,  3.469226724719477e-08, -6.294305523568717e-10,  9.998771977825608e-12, -1.434564024601175e-13,
  1.898481121043305e-15, -2.350019337563331e-17,  2.748448420686985e-19, -3.059934116512035e-21,  3.261994572621372e-23, -3.344737575423308e-25,  1.046253887692775e-05,
 -3.680415306611551e-07,  9.487795413121139e-09, -1.956670701554510e-10,  3.493903864179806e-12, -5.592677209326850e-14,  8.208540683733709e-16, -1.121471388394546e-17,
  1.441717002181371e-19, -1.758105780174500e-21,  2.046443143422388e-23, -2.284803998324869e-25,  1.707284846032059e-06, -7.286765953945162e-08,  2.155962780747319e-09,
 -5.043614792077468e-11,  1.010709262375550e-12, -1.802323979258364e-14,  2.929853587402209e-16, -4.412290236505448e-18,  6.227265843649613e-20, -8.307815330055249e-22,
  1.054694893498863e-23, -1.280730436871517e-25,  2.333364643848871e-07, -1.198472704351439e-08,  4.068851683835778e-10, -1.078442118669406e-11,  2.423354338798804e-13,
 -4.810666356424992e-15,  8.655612486949088e-17, -1.435958295472406e-18,  2.223611636998805e-20, -3.243559960945523e-22,  4.488505329124989e-24, -5.924739442874808e-26,
  2.664065304192935e-08, -1.635827029951906e-09,  6.373680788282197e-11, -1.913183388997186e-12,  4.820221943062182e-14, -1.065160031770734e-15,  2.121188146746275e-17,
 -3.876548715776173e-19,  6.586302148148471e-21, -1.050435744321118e-22,  1.584436071593017e-24, -2.273293086469267e-26,  2.535247149055453e-09, -1.851388723142526e-10,
  8.283180816896510e-12, -2.816686729731578e-13,  7.961245154922785e-15, -1.959487489828523e-16,  4.321494781698186e-18, -8.705001704862928e-20,  1.623598283144371e-21,
 -2.832631334675973e-23,  4.659327378983469e-25, -7.269435200500954e-27,  2.007950438979472e-10, -1.736975770666727e-11,  8.932009426134518e-13, -3.444254879794459e-14,
  1.093413833658871e-15, -3.001089386380987e-17,  7.338474743940023e-19, -1.631161751093859e-20,  3.343359069239019e-22, -6.387260701522516e-24,  1.146793733704680e-25,
 -1.947329956489995e-27,  1.323328338499130e-11, -1.352163781881997e-12,  8.002595339464793e-14, -3.505001997944985e-15,  1.251993578827013e-16, -3.838881140835292e-18,
  1.042605174181055e-19, -2.561462014348868e-21,  5.778752386303290e-23, -1.210686502230415e-24,  2.376005879250505e-26, -4.396887544395227e-28,  7.272602555566572e-13,
 -8.760797691050033e-14,  5.978126774826857e-15, -2.980550887358855e-16,  1.200777590179691e-17, -4.122806379312991e-19,  1.246473863166861e-20, -3.392113943001115e-22,
  8.440541207515640e-24, -1.943019160270656e-25,  4.175716295249882e-27, -8.435525953695484e-29,  3.352894515134243e-14, -4.756304011404948e-15,  3.750185163372606e-16,
 -2.134246256852410e-17,  9.725567323326406e-19, -3.749843591254102e-20,  1.265540466104601e-21, -3.824936109043152e-23,  1.052344420368538e-24, -2.668030067890987e-26,
  6.292691213397498e-28, -1.390553804436320e-29,  1.312857448079720e-15, -2.191694727587435e-16,  2.001620471878317e-17, -1.304313963674428e-18,  6.744948216385684e-20,
 -2.929900513101420e-21,  1.107252038870267e-22, -3.727750510063379e-24,  1.137186529503484e-25, -3.183693912548197e-27,  8.261006338211007e-29, -2.001415421763036e-30,
  4.466350236283686e-17, -8.769229666468634e-18,  9.298843039194683e-19, -6.960217909577658e-20,  4.098451796333686e-21, -2.012495663700875e-22,  8.544174674577227e-24,
 -3.214093108563072e-25,  1.090298699945530e-26, -3.379669756585453e-28,  9.671746634091515e-30, -2.574775622740841e-31,  1.373404259383308e-18, -3.167119738563027e-19,
  3.906374294657339e-20, -3.367687538418661e-21,  2.264739155531212e-22, -1.260861300038853e-23,  6.030975643392732e-25, -2.541739030901140e-26,  9.611637768589720e-28,
 -3.306257403826974e-29,  1.045634179359134e-30, -3.064230743756695e-32,  4.078649214425037e-20, -1.100891768799750e-20,  1.579387956016239e-21, -1.569917389126652e-22,
  1.207501197601436e-23, -7.633848410832186e-25,  4.119973510975780e-26, -1.947944651268578e-27,  8.221024582372852e-29, -3.141155718348461e-30,  1.098663859429694e-31,
 -3.545915719986304e-33,  1.301158347218860e-21, -4.078986540615939e-22,  6.779515345539239e-23, -7.749369110664269e-24,  6.803111207476944e-25, -4.875126243950418e-26,
  2.963568480274489e-27, -1.569176794285286e-28,  7.377392925844893e-30, -3.124911094026656e-31,  1.206236054341009e-32, -4.277902873368178e-34,  5.227469460155197e-23,
 -1.874240857037213e-23,  3.567319408764990e-24, -4.642706807810489e-25,  4.610261736195297e-26, -3.713279934046218e-27,  2.522078983353032e-28, -1.483859415765316e-29,
  7.712271680080901e-31, -3.594321574756947e-32,  1.519834647587197e-33, -5.879176863624712e-35,  3.222071209396620e-24, -1.286113429520379e-24,  2.736393916566972e-25,
 -3.965523860140458e-26,  4.362280233236276e-27, -3.871993898402552e-28,  2.883685717889507e-29, -1.851588218267525e-30,  1.045629820219911e-31, -5.273078417184305e-33,
  2.403368209062322e-34, -9.983380956212292e-36,  3.244584541279401e-25, -1.384031023260777e-25,  3.160235175018017e-26, -4.905019680390837e-27,  5.760883780987196e-28,
 -5.441275630673594e-29,  4.298243353913551e-30, -2.918218340935892e-31,  1.737448480000054e-32, -9.212275728393314e-34,  4.403262953626168e-35, -1.913312976799141e-36,
  7.509531629776321e-02, -2.334319805080195e-04,  7.524182986319934e-07, -2.505647115593932e-09,  8.515345937720158e-12, -2.978475727950014e-14,  1.019571429197205e-16,
 -3.871823285875233e-19,  1.072303691732824e-21, -7.354931701335276e-24, -1.797648875416888e-26, -4.893916080465792e-28,  6.392828077588422e-02, -2.291320324977940e-04,
  1.021352399654527e-06, -4.869744520175603e-09,  2.320107662280635e-11, -1.088265008065753e-13,  4.985932941961707e-16, -2.266643063430058e-18,  9.916747907334213e-21,
 -4.551169159432811e-23,  1.733246074180180e-25, -1.048186842801221e-27,  4.631410850473601e-02, -2.103686621790143e-04,  1.326935240826254e-06, -8.211488831962390e-09,
  4.828047475240512e-11, -2.726516678721635e-13,  1.493173736524921e-15, -7.970318333409886e-18,  4.167517411011573e-20, -2.134472540756525e-22,  1.079895316414200e-24,
 -5.321147879480802e-27,  2.853600746071521e-02, -1.710972195472567e-04,  1.415736293899707e-06, -1.057057513221340e-08,  7.352252839203595e-11, -4.867481404150294e-13,
  3.102942303529086e-15, -1.913169852788653e-17,  1.149694696083241e-19, -6.717342366605714e-22,  3.872809013201196e-24, -2.151278910381716e-26,  1.493864396495273e-02,
 -1.189955321535223e-04,  1.215181961993683e-06, -1.065424351966411e-08,  8.630483268355406e-11, -6.599501656990067e-13,  4.820251742992442e-15, -3.383849209187315e-17,
  2.300500950599691e-19, -1.516225389453670e-21,  9.776902805787772e-24, -6.116017703826972e-26,  6.635962101143130e-03, -6.954521523045574e-05,  8.455169026542677e-07,
 -8.606641948242387e-09,  8.034156658634226e-11, -7.015698658291989e-13,  5.806876005805145e-15, -4.593402137947240e-17,  3.499060542596380e-19, -2.575809180467810e-21,
  1.843882871366445e-23, -1.282263871089228e-25,  2.497272146684729e-03, -3.390438755860041e-05,  4.812682189165807e-07, -5.649288221989285e-09,  6.025378146294969e-11,
 -5.957746937776815e-13,  5.544681054065182e-15, -4.905424645476136e-17,  4.158516156260332e-19, -3.394872769902543e-21,  2.683062041163611e-23, -2.057005934678618e-25,
  7.946023216865321e-04, -1.374895394190128e-05,  2.255378533897723e-07, -3.036909950105820e-09,  3.676053676563623e-11, -4.090221348250935e-13,  4.255914972176999e-15,
 -4.188171120084746e-17,  3.931308043976397e-19, -3.540921612789184e-21,  3.076199309197985e-23, -2.586220104431934e-25,  2.132891738639050e-04, -4.632442492288697e-06,
  8.735092198153330e-08, -1.343245462464342e-09,  1.835946966399836e-11, -2.288358907759358e-13,  2.650943791436340e-15, -2.890108343293728e-17,  2.992579504294843e-19,
 -2.962787687194220e-21,  2.819858257065444e-23, -2.590273252891120e-25,  4.817273671138193e-05, -1.295819410856254e-06,  2.801174976674658e-08, -4.901346677211310e-10,
  7.536715966280517e-12, -1.048885282698081e-13,  1.348687289136379e-15, -1.624206584374346e-17,  1.850128237388998e-19, -2.008022855485227e-21,  2.088520435462416e-23,
 -2.090830358275948e-25,  9.128544521735542e-06, -3.006593936920823e-07,  7.441490292054897e-09, -1.477405801181266e-10,  2.549403647930044e-12, -3.952637794161058e-14,
  5.629380299845726e-16, -7.473669519059866e-18,  9.347560481338117e-20, -1.110134911060916e-21,  1.259589629244444e-23, -1.371877386285969e-25,  1.446831349611862e-06,
 -5.779108586336091e-08,  1.636993588148571e-09, -3.680474632563561e-11,  7.116101457440496e-13, -1.227391819161674e-14,  1.933655527131197e-16, -2.826549739007146e-18,
  3.877158211863343e-20, -5.032755939020540e-22,  6.222530021923926e-24, -7.365285101301688e-26,  1.911723665712803e-07, -9.188024024086438e-09,  2.978927405072150e-10,
 -7.576242346014004e-12,  1.640127236717370e-13, -3.145061564362153e-15,  5.477601009860564e-17, -8.811091790866661e-19,  1.324794273784325e-20, -1.878582472550845e-22,
  2.529762533809425e-24, -3.252508094109847e-26,  2.098831291866659e-08, -1.206110427264930e-09,  4.478347176856938e-11, -1.288015994747400e-12,  3.122037602360598e-14,
 -6.656116958360528e-16,  1.281676024232111e-17, -2.268876597203016e-19,  3.739562444504817e-21, -5.793163834300252e-23,  8.497112771103940e-25, -1.186681237996086e-26,
  1.908521738592119e-09, -1.304930175120078e-10,  5.554330018406487e-12, -1.807393293791706e-13,  4.908765799726378e-15, -1.164383542032055e-16,  2.480588969670253e-18,
 -4.835858245683317e-20,  8.742839372254516e-22, -1.480544944988108e-23,  2.366611319146611e-25, -3.592011229184261e-27,  1.433563102064938e-10, -1.162007454777097e-11,
  5.677733607549347e-13, -2.092870953940216e-14,  6.377742743262921e-16, -1.685482078466669e-17,  3.977943598384599e-19, -8.550907613257720e-21,  1.697778685975162e-22,
 -3.146417990623062e-24,  5.487002658308113e-26, -9.059976286539609e-28,  8.880028131858618e-12, -8.512012392881082e-13,  4.783321549896777e-14, -2.001161301143854e-15,
  6.856508170858567e-17, -2.022864077252796e-18,  5.299300785124747e-20, -1.258374185974809e-21,  2.748719512369667e-23, -5.584091872023505e-25,  1.064056485611188e-26,
 -1.914146446053703e-28,  4.537267942273767e-13, -5.135861604674328e-14,  3.327096088211723e-15, -1.583944735737262e-16,  6.118362601843502e-18, -2.020491914629105e-19,
  5.890246841274891e-21, -1.548876942993757e-22,  3.730688157672666e-24, -8.326118512887346e-26,  1.737156758605262e-27, -3.411167646120144e-29,  1.919190481123829e-14,
 -2.563899232019991e-15,  1.920191905265412e-16, -1.043658113486136e-17,  4.560170206025520e-19, -1.691145781886055e-20,  5.503572469035494e-22, -1.607371345208806e-23,
  4.281202277527833e-25, -1.052463660050164e-26,  2.410324790870376e-28, -5.178569602216124e-30,  6.783378309609876e-16, -1.069662819753550e-16,  9.291834791672817e-18,
 -5.787728007403432e-19,  2.871787094485074e-20, -1.200563939412381e-21,  4.377461293953237e-23, -1.424907835525028e-24,  4.210493656341256e-26, -1.143655682215766e-27,
  2.883263932381574e-29, -6.795936477141167e-31,  2.042105346308155e-17, -3.802534822077666e-18,  3.844539036295282e-19, -2.755732235868485e-20,  1.559361802613587e-21,
 -7.379338606959812e-23,  3.026594059873304e-24, -1.102156531677023e-25,  3.625908996689557e-27, -1.091762759062201e-28,  3.039239333880338e-30, -7.880994848168186e-32,
  5.425554266969562e-19, -1.192946403597296e-19,  1.408229225167046e-20, -1.166181648939731e-21,  7.556691215199324e-23, -4.064405953730801e-24,  1.882392308162482e-25,
 -7.696572672958035e-27,  2.828518111796139e-28, -9.470303382739386e-30,  2.919285885182034e-31, -8.349294063361218e-33,  1.354536978442687e-20, -3.510539802733133e-21,
  4.846708532446123e-22, -4.649574828846453e-23,  3.460433079679056e-24, -2.121683568229831e-25,  1.112737061125011e-26, -5.121565457477690e-28,  2.107485072848302e-29,
 -7.862420196841917e-31,  2.688548177502276e-32, -8.493576022017499e-34,  3.533356857329008e-22, -1.073036029029686e-22,  1.729246282258617e-23, -1.920449618560456e-24,
  1.641301559138377e-25, -1.147094004532924e-26,  6.811904192661911e-28, -3.528599604405739e-29,  1.625117877205612e-30, -6.751373699375225e-32,  2.558787731862656e-33,
 -8.919261142737721e-35,  1.138829112738110e-23, -3.996835813874810e-24,  7.446238664122775e-25, -9.497115984841554e-26,  9.254250009891251e-27, -7.323347886789409e-28,
  4.892662606100148e-29, -2.834451901230381e-30,  1.451990454551610e-31, -6.675489714587458e-33,  2.786732014756233e-34, -1.065071979118475e-35,  5.678799618692301e-25,
 -2.242248227753736e-25,  4.717388831620704e-26, -6.763395576834293e-27,  7.365419798534090e-28, -6.476125884298003e-29,  4.780644673770496e-30, -3.044269982035528e-31,
  1.705848081659006e-32, -8.539962034007429e-34,  3.865723305997713e-35, -1.595468902344532e-36,  4.913842377742756e-26, -2.089458392554127e-26,  4.754857080365781e-27,
 -7.355836292903458e-28,  8.612349483687972e-29, -8.110474813684096e-30,  6.388801422003703e-31, -4.326085010109557e-32,  2.569211604517477e-33, -1.359011396899783e-34,
  6.481157138927877e-36, -2.810204848538681e-37,  7.417343985059874e-02, -2.275306334334947e-04,  7.231487692716464e-07, -2.374037809047443e-09,  7.943261356267822e-12,
 -2.746425240026005e-14,  9.155537017293388e-17, -3.572903328300507e-19,  7.887169890785049e-22, -8.580591024734892e-24, -4.539125514766913e-26, -7.753572489846164e-28,
  6.302773288002252e-02, -2.211888116414600e-04,  9.650729918874763e-07, -4.515310320918070e-09,  2.113924731781050e-11, -9.758746314030835e-14,  4.393327020562393e-16,
 -1.974273524210006e-18,  8.392071947244579e-21, -3.949513992082073e-23,  1.274875519258463e-25, -1.050013761336720e-27,  4.549325875551889e-02, -2.001346015735780e-04,
  1.232858456494047e-06, -7.480751658530838e-09,  4.316847615619413e-11, -2.393496407128743e-13,  1.287577016334323e-15, -6.751757942158151e-18,  3.471543538405403e-20,
 -1.745796017623457e-22,  8.717665678837008e-25, -4.183207794695116e-27,  2.787349428877325e-02, -1.602594331185551e-04,  1.295638927841797e-06, -9.468223073974875e-09,
  6.449093852507112e-11, -4.183113658813818e-13,  2.615328564488146e-15, -1.581144921707224e-17,  9.336221663541934e-20, -5.341391754532054e-22,  3.044375233706166e-24,
 -1.636693582015016e-26,  1.448132689330013e-02, -1.097629690598301e-04,  1.095200251792112e-06, -9.372980411685342e-09,  7.419003866417224e-11, -5.548498579265634e-13,
  3.968139737105333e-15, -2.727971596748889e-17,  1.819027660129444e-19, -1.173994258530511e-21,  7.448906170229357e-24, -4.544811360990949e-26,  6.370684910520879e-03,
 -6.317336518920651e-05,  7.495103394649380e-07, -7.426271472884755e-09,  6.760583429656321e-11, -5.764542652511314e-13,  4.664495447938766e-15, -3.608868412280281e-17,
  2.691981952446148e-19, -1.939741600660294e-21,  1.362300547461413e-23, -9.267083774391382e-26,  2.368947542038764e-03, -3.030987942979649e-05,  4.188901188188783e-07,
 -4.773762725106961e-09,  4.956507386236084e-11, -4.777867929671381e-13,  4.340470885559309e-15, -3.751179311801877e-17,  3.109564176835828e-19, -2.482865741732405e-21,
  1.921676243177133e-23, -1.441786815546211e-25,  7.429976459060294e-04, -1.208101146454229e-05,  1.923709369025618e-07, -2.509009757909471e-09,  2.951340218523928e-11,
 -3.196406840603462e-13,  3.241758668888211e-15, -3.112420625761990e-17,  2.853141203326668e-19, -2.511054206083182e-21,  2.133542728216004e-23, -1.754542229360744e-25,
  1.960615501551068e-04, -3.993443785717733e-06,  7.285394390140989e-08, -1.082907719332090e-09,  1.435863168452483e-11, -1.739331763137106e-13,  1.961178301477522e-15,
 -2.083418795295278e-17,  2.104250675337785e-19, -2.033602840591349e-21,  1.890862531661973e-23, -1.697686974275478e-25,  4.340309424387221e-05, -1.093350616103186e-06,
  2.278973364020863e-08, -3.847140789871030e-10,  5.728987065059160e-12, -7.736980745256664e-14,  9.669808885492629e-16, -1.133346202811390e-17,  1.257804801324052e-19,
 -1.331226820081830e-21,  1.351303531273953e-23, -1.321133561717932e-25,  8.034647872253185e-06, -2.475812223745632e-07,  5.889455788230438e-09, -1.126057801771027e-10,
  1.878632884617146e-12, -2.822273275021956e-14,  3.901747330655103e-16, -5.035340049071359e-18,  6.129199258013399e-20, -7.091203298512125e-22,  7.845017433740393e-24,
 -8.337345233207064e-26,  1.239312316295272e-06, -4.628534923115948e-08,  1.256299307974730e-09, -2.715524734917880e-11,  5.067882074649661e-13, -8.457835917666703e-15,
  1.291770772204524e-16, -1.833402651547185e-18,  2.444924168416363e-20, -3.088716135548498e-22,  3.720241365077465e-24, -4.293264577667104e-26,  1.586679757429107e-07,
 -7.128285105868737e-09,  2.208576805963340e-10, -5.391420684626684e-12,  1.124827759488924e-13, -2.084199670486897e-15,  3.514788989766358e-17, -5.483449035489576e-19,
  8.007294309094648e-21, -1.104052198519844e-22,  1.447121372016981e-24, -1.812606098156749e-26,  1.679329706925340e-08, -9.020884395311772e-10,  3.193390448533197e-11,
 -8.802140454024739e-13,  2.053207020018114e-14, -4.224369793156503e-16,  7.867154030528557e-18, -1.349318370289539e-19,  2.157884811808634e-21, -3.247682715861732e-23,
  4.632933389514364e-25, -6.298985408189829e-27,  1.463358320792770e-09, -9.355672634769989e-11,  3.789194716800822e-12, -1.180037430411560e-13,  3.080126940803862e-15,
 -7.042537627045923e-17,  1.449530650834271e-18, -2.735252169161770e-20,  4.794104441820905e-22, -7.881166012552997e-24,  1.224386915624492e-25, -1.808038500873033e-27,
  1.045847330277834e-10, -7.931603862749188e-12,  3.682127889529644e-13, -1.297393383939124e-14,  3.795332435751378e-16, -9.658192341295290e-18,  2.200222596128576e-19,
 -4.574146918379192e-21,  8.798054749715633e-23, -1.581783125160543e-24,  2.679359770691829e-26, -4.302029652680536e-28,  6.111242327798213e-12, -5.486203116508282e-13,
  2.926138526140908e-14, -1.169078852584660e-15,  3.841650316672263e-17, -1.090452201264792e-18,  2.755293934740527e-20, -6.323517127233586e-22,  1.337306512031797e-23,
 -2.634231899252547e-25,  4.873457194857454e-27, -8.521820839351172e-29,  2.914874108402319e-13, -3.094424519503732e-14,  1.901739576660826e-15, -8.641076666806446e-17,
  3.199256807940117e-18, -1.015894088561550e-19,  2.855046969965156e-21, -7.252780750105011e-23,  1.690697252337285e-24, -3.657516967825406e-26,  7.407073767133859e-28,
 -1.413562355546577e-29,  1.136172031110484e-14, -1.426368146200930e-15,  1.013613207181243e-16, -5.257554247192811e-18,  2.201444828927649e-19, -7.848729694110988e-21,
  2.461948102356793e-22, -6.945529810998309e-24,  1.790248705946414e-25, -4.265928607698481e-27,  9.483321749525457e-29, -1.980326266884927e-30,  3.641736106432534e-16,
 -5.411313935299343e-17,  4.464613013358840e-18, -2.655401062823753e-19,  1.263114972273357e-20, -5.078192582269056e-22,  1.785251585197444e-23, -5.615165807265769e-25,
  1.606285814243345e-26, -4.230717002098956e-28,  1.035779372692691e-29, -2.373982388301458e-31,  9.745657974229607e-18, -1.716424093787763e-18,  1.651592973720536e-19,
 -1.132059301665629e-20,  6.148472295280328e-22, -2.801137297643676e-23,  1.108817831864933e-24, -3.905456002212259e-26,  1.245030121013828e-27, -3.638668715285887e-29,
  9.846245962123105e-31, -2.485236917948752e-32,  2.245766686905521e-19, -4.694292380482108e-20,  5.291805328100704e-21, -4.201865050675121e-22,  2.619434157526969e-23,
 -1.359211912943839e-24,  6.087629741859105e-26, -2.412007962420479e-27,  8.605383922387506e-29, -2.801590383857877e-30,  8.409596671922588e-32, -2.345247163859435e-33,
  4.722609690695555e-21, -1.171568613958836e-21,  1.552655170734360e-22, -1.434456985915137e-23,  1.031081231789057e-24, -6.120740794537024e-26,  3.114656061074983e-27,
 -1.393589599589477e-28,  5.583931189211362e-30, -2.031554177529838e-31,  6.783858576432958e-33, -2.095499637225721e-34,  1.005355781638730e-22, -2.948743602292111e-23,
  4.595565837971997e-24, -4.947262794683773e-25,  4.107746133058843e-26, -2.794739005663306e-27,  1.618513267832560e-28, -8.189381276146918e-30,  3.689430884671158e-31,
 -1.501264155799713e-32,  5.579597182580425e-34, -1.909342968855426e-35,  2.578256285629826e-24, -8.835311727321672e-25,  1.607483216917476e-25, -2.005049125674257e-26,
  1.913612998792605e-27, -1.485310118337053e-28,  9.745611130845009e-30, -5.551360368332230e-31,  2.799136959447436e-32, -1.267931437140640e-33,  5.219703672248531e-35,
 -1.968942803874552e-36,  1.024572708580957e-25, -3.995834081177008e-26,  8.300663062803952e-27, -1.175804504875185e-27,  1.266063843339895e-28, -1.101498475038757e-29,
  8.051334625254986e-31, -5.079912873914507e-32,  2.822027410919350e-33, -1.401391668403501e-34,  6.295536890837135e-36, -2.579850693363599e-37,  7.499126144597864e-27,
 -3.177359293530553e-27,  7.202983976068289e-28, -1.110206048078101e-28,  1.295301632997782e-29, -1.215788120012462e-30,  9.547178530127660e-32, -6.445722765835532e-33,
  3.817411651774135e-34, -2.013961816330859e-35,  9.580789556240918e-37, -4.144452607912856e-38,  7.327471026643034e-02, -2.218572775137651e-04,  6.954051197980097e-07,
 -2.251223873413872e-09,  7.415152739687926e-12, -2.538442078696518e-14,  8.185523257956813e-17, -3.374171885818716e-19,  4.379599062616072e-22, -1.118383506131138e-23,
 -8.744449008957714e-26, -1.139238854673158e-27,  6.215808356422553e-02, -2.136793574285633e-04,  9.128560337180377e-07, -4.192141733718697e-09,  1.928861162810099e-11,
 -8.767776929670184e-14,  3.876054327062222e-16, -1.727583567298374e-18,  7.050750075369463e-21, -3.533719629300659e-23,  7.990023253165222e-26, -1.118146908043731e-27,
  4.471189365780314e-02, -1.906194213890158e-04,  1.147080907917437e-06, -6.826735072481853e-09,  3.867581380645280e-11, -2.105964271721899e-13,  1.113181465547041e-15,
 -5.735034725389688e-18,  2.901646950630033e-20, -1.431090962429389e-22,  7.083368371735421e-25, -3.279314348241766e-27,  2.725249114744336e-02, -1.503318692677153e-04,
  1.187945945552287e-06, -8.500032158451453e-09,  5.671820200421808e-11, -3.605354902938674e-13,  2.211703276868274e-15, -1.310935263795231e-17,  7.616304837107676e-20,
 -4.255250527561655e-22,  2.415167503739567e-24, -1.240414534424865e-26,  1.405911329246506e-02, -1.014319014114054e-04,  9.894966089149942e-07, -8.269789665815295e-09,
  6.398676551717159e-11, -4.681598168398808e-13,  3.279834917603917e-15, -2.208122911074259e-17,  1.445541621994383e-19, -9.123599307016585e-22,  5.717245144096477e-24,
 -3.383873517335894e-26,  6.129444071770752e-03, -5.751619304746438e-05,  6.665235865845092e-07, -6.431055146748156e-09,  5.711914881789528e-11, -4.757197034039342e-13,
  3.764821275793451e-15, -2.849394250530499e-17,  2.082681610797462e-19, -1.468285362148316e-21,  1.013417270494854e-23, -6.731057119553719e-26,  2.254065580010618e-03,
 -2.717510854773406e-05,  3.660652788078952e-07, -4.051845346796013e-09,  4.097145332363230e-11, -3.851726134100477e-13,  3.417001861166684e-15, -2.885453431972060e-17,
  2.340067257423066e-19, -1.827437737527517e-21,  1.386304497745421e-23, -1.017390945213245e-25,  6.975715757711800e-04, -1.065490858118335e-05,  1.648980696109814e-07,
 -2.083989334857768e-09,  2.383301868716337e-11, -2.513425055583457e-13,  2.485604126706290e-15, -2.328980446377801e-17,  2.085837004285763e-19, -1.794081008090391e-21,
  1.491613255425968e-23, -1.199879504163474e-25,  1.811763220723414e-04, -3.458934952510633e-06,  6.113045725487048e-08, -8.786270139384981e-10,  1.130706228578404e-11,
 -1.331670540525861e-13,  1.462047467804343e-15, -1.513941738658159e-17,  1.492035429637891e-19, -1.407901662839604e-21,  1.279372413826094e-23, -1.122939881111756e-25,
  3.936714383349705e-05, -9.280506524314894e-07,  1.867589162943377e-08, -3.042687564370515e-10,  4.390137442158698e-12, -5.755630262075382e-14,  6.994717451279071e-16,
 -7.981348380679198e-18,  8.633095470532363e-20, -8.912528080742191e-22,  8.832259841226578e-24, -8.435007496849252e-26,  7.130664964626077e-06, -2.053994811499213e-07,
  4.701434278155024e-09, -8.659873458808666e-11,  1.397452692362086e-12, -2.035036967627289e-14,  2.731997858079485e-16, -3.428398885057964e-18,  4.062727407423298e-20,
 -4.580337405862195e-22,  4.942173616772262e-24, -5.126361313066496e-26,  1.072386846776275e-06, -3.741240239222573e-08,  9.740073503448830e-10, -2.024742846813298e-11,
  3.648926038505442e-13, -5.894532967337747e-15,  8.730863592996393e-17, -1.203544514329536e-18,  1.560813183932163e-20, -1.919564716980004e-22,  2.252901811478331e-24,
 -2.535460856101814e-26,  1.333181727243875e-07, -5.592510702959097e-09,  1.657187669637289e-10, -3.884078085481453e-12,  7.812602523553054e-14, -1.399248413050473e-15,
  2.285543040167112e-17, -3.459264825325751e-19,  4.907335424922364e-21, -6.580801733716509e-23,  8.397709227992638e-25, -1.024971692973100e-26,  1.363610407546716e-08,
 -6.838640601736965e-10,  2.309363737984027e-11, -6.101889159508985e-13,  1.370159032735426e-14, -2.721241536868312e-16,  4.902699942694711e-18, -8.148944618265189e-20,
  1.264785076953465e-21, -1.849703296709268e-23,  2.566814353903300e-25, -3.398105195112001e-27,  1.141845913982656e-09, -6.816549674655830e-11,  2.627840930529496e-12,
 -7.833184539050378e-14,  1.965429727419174e-15, -4.332539499465293e-17,  8.617164382773612e-19, -1.574213091247157e-20,  2.675326128156073e-22, -4.270110340692223e-24,
  6.448366058542522e-26, -9.265530034537628e-28,  7.789219861450717e-11, -5.518428840564732e-12,  2.434092004078624e-13, -8.198233780498383e-15,  2.302457282865805e-16,
 -5.642478832117730e-18,  1.240855736822486e-19, -2.495147990217028e-21,  4.649630387955264e-23, -8.110302473857230e-25,  1.334489812348082e-26, -2.083684110162990e-28,
  4.308921318627700e-12, -3.616464915975416e-13,  1.830253335717845e-14, -6.982084290948010e-16,  2.200309497091680e-17, -6.008739881041730e-19,  1.464355492181335e-20,
 -3.248111920681150e-22,  6.650411645388887e-24, -1.270176993167076e-25,  2.281432181391889e-27, -3.877692614307096e-29,  1.926227385750129e-13, -1.914110529909939e-14,
  1.115297560193044e-15, -4.834824527049804e-17,  1.715277725047021e-18, -5.236283213865986e-20,  1.418411602995210e-21, -3.480444289832895e-23,  7.850950538894839e-25,
 -1.646069415287373e-26,  3.235274289115286e-28, -5.999587575083288e-30,  6.949538214893565e-15, -8.180917734505175e-16,  5.510817081071876e-17, -2.726066163386914e-18,
  1.093309478262052e-19, -3.745808221672969e-21,  1.132095335309133e-22, -3.084045361354035e-24,  7.690467540612289e-26, -1.775756411611933e-27,  3.830754302438722e-29,
 -7.772851122143167e-31,  2.029690742603333e-16, -2.834997187840921e-17,  2.218536405540047e-18, -1.258694627382718e-19,  5.735299320709750e-21, -2.215955593170020e-22,
  7.506596550671865e-24, -2.280163666167010e-25,  6.311279545405476e-27, -1.611114577082673e-28,  3.828615932957749e-30, -8.529072913597271e-32,  4.852031257919735e-18,
 -8.060467352777476e-19,  7.368360812572981e-20, -4.822960018833455e-21,  2.511336620585487e-22, -1.100369814531092e-23,  4.200181731663731e-25, -1.429713257868070e-26,
  4.413293629421268e-28, -1.251028189325005e-29,  3.288458840171058e-31, -8.073992649939320e-33,  9.740802929728379e-20, -1.929763864316810e-20,  2.072811455371858e-21,
 -1.575319522614491e-22,  9.433516588058850e-24, -4.716125128438529e-25,  2.040181821425754e-26, -7.824568160056525e-28,  2.707283004648598e-29, -8.562036202178203e-31,
  2.500391426128110e-32, -6.793346987188778e-34,  1.730339939438835e-21, -4.095416945355009e-22,  5.196587042690736e-23, -4.613538183159941e-24,  3.196731991256601e-25,
 -1.834195198792156e-26,  9.042345842653079e-28, -3.927443594139060e-29,  1.530355247042898e-30, -5.423106684030170e-32,  1.766387718241262e-33, -5.329239802416467e-35,
  3.003862861382099e-23, -8.481424556161113e-24,  1.274755725770085e-24, -1.327048288231043e-25,  1.068195104980465e-26, -7.061223788842375e-28,  3.981071962609037e-29,
 -1.964434023940581e-30,  8.644216857602367e-32, -3.440433253507253e-33,  1.252279273431434e-34, -4.201870732442666e-36,  6.084721607868270e-25, -2.030298988262669e-25,
  3.598213715367846e-26, -4.379292625932631e-27,  4.085320137067051e-28, -3.104418583271769e-29,  1.997081315479234e-30, -1.116813207163695e-31,  5.534980108257625e-33,
 -2.466988075388733e-34,  1.000284028477133e-35, -3.719800729674660e-37,  1.897495513508398e-26, -7.296806735228644e-27,  1.494169904441372e-27, -2.087934090873173e-28,
  2.219832059216390e-29, -1.908569862047354e-30,  1.379754932330221e-31, -8.616316999069515e-33,  4.740801833026283e-34, -2.333156431278670e-35,  1.039337659335510e-36,
 -4.225630841832806e-38,  1.154395840814236e-27, -4.871212680632303e-28,  1.099523327380905e-28, -1.687660440871031e-29,  1.961278755356762e-30, -1.834059770877006e-31,
  1.435204832364727e-32, -9.657920967549403e-34,  5.702136465539665e-35, -2.999532157840915e-36,  1.423011670327351e-37, -6.139711673294564e-39,  7.239823934268018e-02,
 -2.164001162864511e-04,  6.690858712996149e-07, -2.136539386422444e-09,  6.926350827477053e-12, -2.353208240721818e-14,  7.253782123650402e-17, -3.306231603341519e-19,
 -4.054159451017558e-23, -1.577274324409895e-23, -1.436176559503416e-25, -1.350735556212019e-27,  6.131766046343874e-02, -2.065726155259320e-04,  8.643457656811710e-07,
 -3.897062956030422e-09,  1.762429023542443e-11, -7.893136728474790e-14,  3.422044189696942e-16, -1.521794233646272e-18,  5.824133838799078e-21, -3.313959168838658e-23,
  2.989860820235082e-26, -1.123737535247031e-27,  4.396726487594377e-02, -1.817602485270960e-04,  1.068738528844862e-06, -6.240218660228943e-09,  3.471856450530382e-11,
 -1.857066917222497e-13,  9.648627845628955e-16, -4.883738802936302e-18,  2.434182566929346e-20, -1.174383092249820e-22,  5.803960713410186e-25, -2.566295011096215e-27,
  2.666954588320480e-02, -1.412214057724395e-04,  1.091161566398798e-06, -7.647462564863074e-09,  5.000993458837245e-11, -3.115974619618388e-13,  1.876586542027331e-15,
 -1.089960187330980e-17,  6.246029485205617e-20, -3.388849937212489e-22,  1.938635951799867e-24, -9.411840782380785e-27,  1.366861279504699e-02, -9.389615886674141e-05,
  8.961061784018441e-07, -7.316831266411390e-09,  5.536322749980710e-11, -3.963692036901970e-13,  2.721681707135554e-15, -1.793962410690199e-17,  1.154918583493954e-19,
 -7.107351623324444e-22,  4.426167466877711e-24, -2.529427133058605e-26,  5.909575935785107e-03, -5.247785108553804e-05,  5.945355808311839e-07, -5.588612903622314e-09,
  4.844738219666756e-11, -3.942310405285905e-13,  3.052874652208341e-15, -2.260229554807695e-17,  1.620462528066682e-19, -1.116364049076988e-21,  7.593850632292983e-24,
 -4.916309784354737e-26,  2.150929246060358e-03, -2.443048847669122e-05,  3.211358981133246e-07, -3.453734155529501e-09,  3.402676785061611e-11, -3.120706914597700e-13,
  2.704735008276947e-15, -2.232007486108452e-17,  1.772090587784064e-19, -1.352991847654234e-21,  1.007336985397179e-23, -7.227804242020749e-26,  6.574406008063980e-04,
 -9.429634962050220e-06,  1.420222057862483e-07, -1.739843484080555e-09,  1.935355126738770e-11, -1.988149452794764e-13,  1.917990387955554e-15, -1.754294764945118e-17,
  1.535757784369890e-19, -1.290974604638634e-21,  1.051007177191960e-23, -8.270043437600675e-26,  1.682559837455633e-04, -3.009180575764434e-06,  5.159032481743599e-08,
 -7.172492236839122e-10,  8.962878110941751e-12, -1.026687655359451e-13,  1.098019322814632e-15, -1.108600041045573e-17,  1.066527334746760e-19, -9.828088527464304e-22,
  8.732148912938497e-24, -7.494129783325121e-26,  3.593220856479299e-05, -7.921362176457273e-07,  1.541089228198719e-08, -2.423941778041324e-10,  3.390278790186530e-12,
 -4.316591824078218e-14,  5.102939016237120e-16, -5.670584670865316e-18,  5.980205022422409e-20, -6.023602564867499e-22,  5.829745337103552e-24, -5.439859198530056e-26,
  6.378207054382523e-06, -1.715934090103933e-07,  3.784044456163096e-09, -6.716947599284549e-11,  1.048936864899030e-12, -1.481258232781560e-14,  1.931752002006681e-16,
 -2.358013227641452e-18,  2.721258725305344e-20, -2.990428654159770e-22,  3.147982047149735e-24, -3.187798670611199e-26,  9.369117233602316e-07, -3.050124240591661e-08,
  7.625172694713044e-10, -1.524894003117141e-11,  2.654930693571028e-13, -4.152891120483075e-15,  5.967537882986452e-17, -7.992288881245625e-19,  1.008267808530943e-20,
 -1.207496608379697e-22,  1.381306939980297e-24, -1.516383634097245e-26,  1.133318619639375e-07, -4.433894407005484e-09,  1.257746791383654e-10, -2.831137835112629e-12,
  5.492499694879304e-14, -9.511818183649444e-16,  1.505339193755852e-17, -2.211041618223146e-19,  3.047968255917669e-21, -3.976335933871603e-23,  4.941252203475225e-25,
 -5.878100471361520e-27,  1.122853574258416e-08, -5.250528323025675e-10,  1.692589260085095e-11, -4.288109496593662e-13,  9.272199012523410e-15, -1.778174080323748e-16,
  3.100110321006838e-18, -4.994869279939170e-20,  7.525674072246282e-22, -1.069710227225992e-23,  1.444300232832086e-25, -1.862126547574782e-27,  9.059524289037127e-10,
 -5.042733430782787e-11,  1.851213937951850e-12, -5.282747395684416e-14,  1.274486507581184e-15, -2.709219449889028e-17,  5.208167085647735e-19, -9.212995639298943e-21,
  1.518442349532865e-22, -2.353498746288248e-24,  3.455211408146787e-26, -4.831565987017685e-28,  5.916826530699977e-11, -3.909675679588562e-12,  1.638757771310897e-13,
 -5.276332658537461e-15,  1.422842474723635e-16, -3.358359074020053e-18,  7.130468781639181e-20, -1.387009442605208e-21,  2.504362839491820e-23, -4.238566436449198e-25,
  6.775336924747763e-27, -1.028858880292513e-28,  3.109496531210034e-12, -2.435584212009800e-13,  1.169409264343302e-14, -4.259116282730651e-16,  1.287180312137613e-17,
 -3.381865922367126e-19,  7.949365288327549e-21, -1.704204677555262e-22,  3.378266526009531e-24, -6.256171520353751e-26,  1.090975592926153e-27, -1.802396189979796e-29,
  1.307956959726540e-13, -1.214191926409667e-14,  6.704210907865417e-16, -2.771873620565115e-17,  9.421400598258408e-19, -2.764591029362573e-20,  7.217274554016305e-22,
 -1.710412759096072e-23,  3.733112196257349e-25, -7.585057049477147e-27,  1.446705191991664e-28, -2.606669386208743e-30,  4.387249190969776e-15, -4.832018700387760e-16,
  3.082746941233509e-17, -1.453496487242277e-18,  5.581076788863316e-20, -1.836877509663864e-21,  5.347423528632067e-23, -1.406288930742259e-24,  3.391710788780635e-26,
 -7.587043892477205e-28,  1.587898734865773e-29, -3.129932300601796e-31,  1.173266759389832e-16, -1.536596244068458e-17,  1.139072341019929e-18, -6.159102420618540e-20,
  2.686368452855906e-21, -9.968893622683064e-23,  3.252287345484184e-24, -9.535863115946580e-26,  2.552730195845525e-27, -6.313121258906977e-29,  1.455597383056167e-30,
 -3.150473583977560e-32,  2.518399401500136e-18, -3.935140745748881e-19,  3.411579426138506e-20, -2.129664630990698e-21,  1.062023496477715e-22, -4.471322492023132e-24,
  1.644421111014024e-25, -5.405519146469523e-27,  1.614557850764136e-28, -4.436221364041644e-30,  1.132043039297621e-31, -2.702063770446046e-33,  4.426726381490478e-20,
 -8.285687322022003e-21,  8.461670201895983e-22, -6.144435761517069e-23,  3.529317259054624e-24, -1.697761972005828e-25,  7.085671087284671e-27, -2.627685512521307e-28,
  8.808477163964639e-30, -2.703657995955133e-31,  7.674730146156553e-33, -2.029734073761441e-34,  6.667839151425229e-22, -1.500522127539246e-22,  1.818167569790633e-23,
 -1.547773672688916e-24,  1.031879629266810e-25, -5.713087998037848e-27,  2.724452835982299e-28, -1.147122312710715e-29,  4.341208098620345e-31, -1.496621381394533e-32,
  4.749503443044822e-34, -1.398078162364861e-35,  9.444144245168794e-24, -2.557976035305747e-24,  3.696961460958842e-25, -3.712360583999150e-26,  2.890549381192134e-27,
 -1.852856896765084e-28,  1.015140861047007e-29, -4.876973073425308e-31,  2.092939966145219e-32, -8.136144346762845e-34,  2.896502455336690e-35, -9.517795994288118e-37,
  1.501738565968006e-25, -4.863870930257435e-26,  8.373426411640207e-27, -9.919443842685130e-28,  9.024930389829593e-29, -6.700754664632318e-30,  4.218668471035852e-31,
 -2.312245121654805e-32,  1.124648699057383e-33, -4.925316238372697e-35,  1.964390267424537e-36, -7.192907329755339e-38,  3.618254641596552e-27, -1.369196758226928e-27,
  2.758422930356511e-28, -3.795885999000387e-29,  3.978432666825034e-30, -3.375483960565841e-31,  2.410307088451922e-32, -1.488007946936721e-33,  8.100016867391430e-35,
 -3.946714593249095e-36,  1.741752759031673e-37, -7.019795449077684e-39,  1.794551877903211e-28, -7.537143044190608e-29,  1.692908376279087e-29, -2.586185221028753e-30,
  2.992106575016822e-31, -2.786338199693204e-32,  2.171852999523664e-33, -1.456136507379721e-34,  8.567528045607153e-36, -4.492217247510998e-37,  2.124651097522974e-38,
 -9.140678505016774e-40,  7.154318448779726e-02, -2.111481344090641e-04,  6.440970949453407e-07, -2.029391474349886e-09,  6.472365265553984e-12, -2.190297780571161e-14,
  6.316828594902036e-17, -3.422269123215262e-19, -7.254366977383942e-22, -2.261750722604884e-23, -1.940971247598991e-25, -7.052484975925949e-28,  6.050490996991633e-02,
 -1.998402317623866e-04,  8.192222541369772e-07, -3.627271219108152e-09,  1.612444470703052e-11, -7.120982046155766e-14,  3.020251431400485e-16, -1.354372629714392e-18,
  4.641319394092165e-21, -3.285787678829265e-23, -1.276389766590541e-26, -6.923507569738734e-28,  4.325686241147431e-02, -1.735007016668991e-04,  9.970702729487119e-07,
 -5.713221475858175e-09,  3.122536030882481e-11, -1.641066526385776e-13,  8.384183767480839e-16, -4.168174728431743e-18,  2.050627241121464e-20, -9.631315680889698e-23,
  4.796213454757546e-25, -2.051469202521636e-27,  2.612155623681394e-02, -1.328460469709969e-04,  1.003994967674170e-06, -6.894811976570569e-09,  4.420476713086928e-11,
 -2.700065516339954e-13,  1.597648070735904e-15, -9.081872907598152e-18,  5.156260035759741e-20, -2.689624271544226e-22,  1.571734656460238e-24, -7.464285539384334e-27,
  1.330683027246076e-02, -8.706403878393597e-05,  8.133685165580845e-07, -6.491053189033310e-09,  4.805042223762599e-11, -3.366814097610835e-13,  2.267497685924653e-15,
 -1.462115543303276e-17,  9.284199463539895e-20, -5.540078816719981e-22,  3.453689887496920e-24, -1.932471176980313e-26,  5.708770211238173e-03, -4.797721656458285e-05,
  5.318753139833367e-07, -4.872755893978205e-09,  4.124706734485456e-11, -3.280055997355882e-13,  2.486960047812227e-15, -1.800519468957088e-17,  1.268414909032769e-19,
 -8.517579326338492e-22,  5.729721879542732e-24, -3.634226565758548e-26,  2.058095451248909e-03, -2.201837769336657e-05,  2.827625620625031e-07, -2.955911714950273e-09,
  2.838699884524969e-11, -2.540581805062208e-13,  2.152360591734951e-15, -1.735675774839389e-17,  1.350486327462648e-19, -1.007086119896373e-21,  7.370724955117439e-24,
 -5.180735090234652e-26,  6.218692409884961e-04, -8.371992376952833e-06,  1.228784752052337e-07, -1.459653536225710e-09,  1.580048046939677e-11, -1.581624853204122e-13,
  1.489142784799152e-15, -1.329760193850498e-17,  1.138664660129560e-19, -9.352059371554323e-22,  7.461595314899775e-24, -5.748152090243282e-26,  1.569934428066805e-04,
 -2.628595288393908e-06,  4.378037454562573e-08, -5.889373557394498e-10,  7.149747075679063e-12, -7.968597414286853e-14,  8.305184724471959e-16, -8.177756770281146e-18,
  7.683794515665472e-20, -6.915139862627392e-22,  6.010382141230152e-24, -5.046059249052538e-26,  3.299303651264789e-05, -6.796233861384670e-07,  1.280115622004316e-08,
 -1.944411759942036e-10,  2.637608137384804e-12, -3.262647340021714e-14,  3.753445369470207e-16, -4.063169936064017e-18,  4.179540558156816e-20, -4.108286124686048e-22,
  3.884536396739322e-24, -3.542847722077421e-26,  5.747648290549811e-06, -1.442808606032536e-07,  3.069691014288592e-09, -5.252539617937165e-11,  7.941685883600642e-13,
 -1.087941112143262e-14,  1.378822278846700e-16, -1.637657605391081e-18,  1.841193988554163e-20, -1.972683732373038e-22,  2.026614947730125e-24, -2.004122424835217e-26,
  8.260423313216702e-07, -2.506668136010517e-08,  6.025091687388535e-10, -1.159469746378313e-11,  1.951173585110482e-13, -2.956429317823875e-15,  4.122959712072885e-17,
 -5.366523142553574e-19,  6.588014301017398e-21, -7.684917218567027e-23,  8.570972204226407e-25, -9.180509239410401e-27,  9.741284655902448e-08, -3.549979954785253e-09,
  9.650432188435894e-11, -2.086819667736151e-12,  3.906451718880309e-14, -6.543678169302657e-16,  1.003728916356295e-17, -1.431124795347737e-19,  1.917651734610872e-21,
 -2.434411228665164e-23,  2.946652955919508e-25, -3.417271281149934e-27,  9.369783666466164e-09, -4.079527739208107e-10,  1.256483706874379e-11, -3.052947542286680e-13,
  6.359281080409747e-15, -1.177958390251651e-16,  1.987912983794220e-18, -3.105576794266936e-20,  4.543393790158004e-22, -6.278222198877762e-24,  8.249381000428342e-26,
 -1.036023501822713e-27,  7.302878079233096e-10, -3.784384754099427e-11,  1.323736154765577e-12, -3.617004180714377e-14,  8.392806937292343e-16, -1.720877862935306e-17,
  3.198271807217688e-19, -5.479543776643428e-21,  8.760237136208533e-23, -1.318761653031541e-24,  1.882574620287109e-26, -2.562280293949488e-28,  4.579916897326880e-11,
 -2.817792241473677e-12,  1.122712301017263e-13, -3.455879727801912e-15,  8.949880537833384e-17, -2.034951184432105e-18,  4.172126285776788e-20, -7.851850790985721e-22,
  1.373874955682193e-23, -2.256458736604471e-25,  3.504472186491015e-27, -5.176062504478703e-29,  2.294340069498936e-12, -1.674022508245039e-13,  7.625264533133140e-15,
 -2.651332595642169e-16,  7.684692037793822e-18, -1.942616411924816e-19,  4.404586001235600e-21, -9.126964892986383e-23,  1.751771076814439e-24, -3.145656262561011e-26,
  5.325944402588077e-28, -8.552881672195496e-30,  9.116133389922889e-14, -7.889414998408179e-15,  4.126511925675596e-16, -1.626813248214052e-17,  5.296794025224556e-19,
 -1.493885578284220e-20,  3.758322032749467e-22, -8.601839224127658e-24,  1.816431046505550e-25, -3.576369926791143e-27,  6.619019626605961e-29, -1.158681736105455e-30,
  2.855464844074083e-15, -2.935669470265102e-16,  1.772498504669283e-17, -7.961604784847688e-19,  2.925836848297998e-20, -9.248056323445327e-22,  2.592611412117632e-23,
 -6.580590670903694e-25,  1.534730327958562e-26, -3.325236168412594e-28,  6.750512318612398e-30, -1.292348155259570e-31,  7.026877353444125e-17, -8.606949687311570e-18,
  6.036820625188140e-19, -3.108354181743485e-20,  1.296932196246331e-21, -4.620042758488948e-23,  1.450929502481748e-24, -4.104702340717946e-26,  1.062302048833227e-27,
 -2.544213110292395e-29,  5.689500092198632e-31, -1.195992908422803e-32,  1.361649932487420e-18, -1.995464053606933e-19,  1.637987016170783e-20, -9.739861416932268e-22,
  4.647103594038407e-23, -1.878399999942344e-24,  6.651021632858232e-26, -2.109888547227357e-27,  6.093985705742888e-29, -1.622015031628327e-30,  4.015866419937983e-32,
 -9.313390635746403e-34,  2.107128318635293e-20, -3.714172941050642e-21,  3.598560575225612e-22, -2.492562146145842e-23,  1.371363571127216e-24, -6.339935801514656e-26,
  2.549972798346028e-27, -9.134705008321872e-29,  2.963960158099297e-30, -8.821678396609984e-32,  2.432109562782836e-33, -6.256273103595789e-35,  2.703872024228732e-22,
 -5.764680122298789e-23,  6.652502479790181e-24, -5.418459579309171e-25,  3.469296281228214e-26, -1.850436046017689e-27,  8.523400184249125e-29, -3.474210376053727e-30,
  1.275350889001359e-31, -4.272341118950597e-33,  1.319531430530367e-34, -3.785747595042127e-36,  3.130280744348021e-24, -8.102642478870013e-25,  1.122645167664896e-25,
 -1.084601125192540e-26,  8.150499004639570e-28, -5.055926120584067e-29,  2.686921604157990e-30, -1.254694271562912e-31,  5.243125264583136e-33, -1.987930649043666e-34,
  6.912561467448705e-36, -2.221639747052969e-37,  3.888714915478824e-26, -1.218302178231801e-26,  2.031196005738808e-27, -2.335850440376535e-28,  2.067787702143363e-29,
 -1.496873737660063e-30,  9.205186179973720e-32, -4.936244203869128e-33,  2.352453569543653e-34, -1.010769946501620e-35,  3.959847136843228e-37, -1.425847814579659e-38,
  7.128183871820349e-28, -2.648158112025916e-28,  5.237315498969618e-29, -7.083225629062404e-30,  7.305428626431250e-31, -6.106624780721157e-32,  4.300716216919599e-33,
 -2.621227166454378e-34,  1.409950221899020e-35, -6.793966871931026e-37,  2.967314184920001e-38, -1.184381697044031e-39,  2.821033505725428e-29, -1.178466541229983e-29,
  2.632033138341891e-30, -3.999209892330345e-31,  4.603531723934198e-32, -4.266684365427584e-33,  3.311042321368148e-34, -2.210746317457565e-35,  1.295715296555684e-36,
 -6.769197055210187e-38,  3.190676042728668e-39, -1.368309039171802e-40,  };
  int offset = -27;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 27;
    if (std::isnan(t)) {
      fill_n(rr+offset, 27, 0.5);
      fill_n(ww+offset, 27, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 27; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=27; ++j) {
        const int boxof = it*324+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
