// -*- C++ -*-

//=============================================================================
/**
 *  @file    Shared_Memory_SV.h
 *
 *  @author Douglas C. Schmidt <d.schmidt@vanderbilt.edu>
 */
//=============================================================================

#ifndef ACE_SHARED_MALLOC_SV_H
#define ACE_SHARED_MALLOC_SV_H
#include /**/ "ace/pre.h"

#include "ace/Shared_Memory.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "ace/SV_Shared_Memory.h"

ACE_BEGIN_VERSIONED_NAMESPACE_DECL

/**
 * @class ACE_Shared_Memory_SV
 *
 * @brief Shared memory wrapper based on System V shared memory.
 *
 * This class provides a very simple-minded shared memory manager.  We
 * strongly recommend that you do NOT use this class.  Instead, please
 * use @c ACE_Malloc, which has much more powerful capabilities.
 */
class ACE_Export ACE_Shared_Memory_SV : public ACE_Shared_Memory
{
public:
  enum
    {
      ACE_CREATE = IPC_CREAT,
      ACE_OPEN = 0
    };

  ACE_Shared_Memory_SV ();
  ACE_Shared_Memory_SV (key_t id,
                        size_t length,
                        int create = ACE_Shared_Memory_SV::ACE_OPEN,
                        int perms = ACE_DEFAULT_FILE_PERMS,
                        void *addr = 0,
                        int flags = 0);

  int open (key_t id,
            size_t length,
            int create = ACE_Shared_Memory_SV::ACE_OPEN,
            int perms = ACE_DEFAULT_FILE_PERMS,
            void *addr = 0,
            int flags = 0);

  /// Close down the shared memory segment.
  virtual int close ();

  /// Remove the underlying shared memory segment.
  virtual int remove ();

  // = Allocation and deallocation methods.
  /// Create a new chuck of memory containing @a size bytes.
  virtual void *malloc (size_t = 0);

  /// Free a chuck of memory allocated by <ACE_Shared_Memory_SV::malloc>.
  virtual int free (void *p);

  /// Return the size of the shared memory segment.
  virtual size_t get_segment_size () const;

  /// Return the ID of the shared memory segment (i.e., a System V
  /// shared memory internal id).
  virtual ACE_HANDLE get_id () const;

  /// Dump the state of an object.
  void dump () const;

  /// Declare the dynamic allocation hooks.
  ACE_ALLOC_HOOK_DECLARE;

private:
   /// This version is implemented with System V shared memory
   /// segments.
   ACE_SV_Shared_Memory shared_memory_;
};

ACE_END_VERSIONED_NAMESPACE_DECL

#if defined (__ACE_INLINE__)
#include "ace/Shared_Memory_SV.inl"
#endif /* __ACE_INLINE__ */

#include /**/ "ace/post.h"
#endif /* ACE_SHARED_MALLOC_SV_H */
