use super::structs::*;
use crate::queries;

pub fn get_scenario() -> Scenario {
    Scenario::new(
        "browser",
        vec![
            FileSource::new("toolkit", "toolkit/{locale}/", vec!["en-US", "pl"]),
            FileSource::new("browser", "browser/{locale}/", vec!["en-US", "pl"]),
        ],
        vec!["en-US"],
        vec![
            "branding/brand.ftl",
            "browser/branding/sync-brand.ftl",
            "browser/branding/brandings.ftl",
            "toolkit/global/textActions.ftl",
            "browser/browser.ftl",
            "browser/browserContext.ftl",
            "browser/browserSets.ftl",
            "browser/menubar.ftl",
            "browser/protectionsPanel.ftl",
            "browser/appmenu.ftl",
            "preview/interventions.ftl",
            "browser/sidebarMenu.ftl",
            "browser/allTabsMenu.ftl",
            "browser/places.ftl",
            "toolkit/printing/printUI.ftl",
            "browser/downloads.ftl",
        ],
        queries![
            (L10nKey::new("browser-main-window", Some(vec![L10nArgument::new("content-title", "CONTENTTITLE")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("data-title-default", "Nightly"), L10nAttribute::new("data-title-private", "Nightly (Private Browsing)"), L10nAttribute::new("data-content-title-default", "CONTENTTITLE \\u2014 Nightly"), L10nAttribute::new("data-content-title-private", "CONTENTTITLE \\u2014 Nightly (Private Browsing)")]))),
            ("browser-main-window-title", "Nightly"),
            ("window-new-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "N")]))),
            ("tab-new-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "T")]))),
            ("location-open-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "L")]))),
            ("location-open-shortcut-alt", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "D")]))),
            ("search-focus-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "K")]))),
            ("search-focus-shortcut-alt", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "J")]))),
            ("downloads-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "Y")]))),
            ("addons-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "A")]))),
            ("file-open-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "O")]))),
            ("save-page-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "S")]))),
            ("print-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "P")]))),
            ("close-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "W")]))),
            ("close-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "W")]))),
            ("mute-toggle-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "M")]))),
            ("text-action-undo-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "Z")]))),
            ("text-action-undo-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "Z")]))),
            ("text-action-cut-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "X")]))),
            ("text-action-copy-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "C")]))),
            ("text-action-paste-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "V")]))),
            ("text-action-select-all-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "A")]))),
            ("nav-back-shortcut-alt", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "[")]))),
            ("nav-fwd-shortcut-alt", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "]")]))),
            ("history-show-all-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "H")]))),
            ("reader-mode-toggle-shortcut-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "R")]))),
            ("picture-in-picture-toggle-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "]")]))),
            ("picture-in-picture-toggle-shortcut-alt", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "}")]))),
            ("nav-reload-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "R")]))),
            ("nav-reload-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "R")]))),
            ("page-source-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "U")]))),
            ("page-info-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "I")]))),
            ("find-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "F")]))),
            ("search-find-again-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "G")]))),
            ("search-find-again-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "G")]))),
            ("search-find-again-shortcut-alt", L10nMessage::new(None, Some(vec![L10nAttribute::new("keycode", "VK_F3")]))),
            ("search-find-again-shortcut-alt", L10nMessage::new(None, Some(vec![L10nAttribute::new("keycode", "VK_F3")]))),
            ("bookmark-this-page-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "D")]))),
            ("bookmark-this-page-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "D")]))),
            ("bookmark-show-library-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "O")]))),
            ("bookmark-show-sidebar-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "B")]))),
            ("bookmark-show-toolbar-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "B")]))),
            ("history-sidebar-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "H")]))),
            ("full-zoom-reduce-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "-")]))),
            ("full-zoom-reduce-shortcut-alt-a", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "_")]))),
            ("full-zoom-reduce-shortcut-alt-b", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "")]))),
            ("full-zoom-enlarge-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "+")]))),
            ("full-zoom-enlarge-shortcut-alt", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "=")]))),
            ("full-zoom-enlarge-shortcut-alt2", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "")]))),
            ("full-zoom-reset-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "0")]))),
            ("full-zoom-reset-shortcut-alt", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "")]))),
            ("bidi-switch-direction-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "X")]))),
            ("private-browsing-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "P")]))),
            ("quit-app-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "Q")]))),
            ("tab-new-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "T")]))),
            ("window-new-shortcut", L10nMessage::new(None, Some(vec![L10nAttribute::new("key", "N")]))),
            ("sidebar-menu-bookmarks", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmarks")]))),
            ("sidebar-menu-history", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "History")]))),
            ("sidebar-menu-synced-tabs", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Synced Tabs")]))),
            ("sidebar-menu-close", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Close Sidebar")]))),
            ("full-screen-autohide", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Hide Toolbars"), L10nAttribute::new("accesskey", "H")]))),
            ("full-screen-exit", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Exit Full Screen Mode"), L10nAttribute::new("accesskey", "F")]))),
            ("main-context-menu-back", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Go back one page"), L10nAttribute::new("aria-label", "Back"), L10nAttribute::new("accesskey", "B")]))),
            ("main-context-menu-forward", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Go forward one page"), L10nAttribute::new("aria-label", "Forward"), L10nAttribute::new("accesskey", "F")]))),
            ("main-context-menu-reload", L10nMessage::new(None, Some(vec![L10nAttribute::new("aria-label", "Reload"), L10nAttribute::new("accesskey", "R")]))),
            ("main-context-menu-stop", L10nMessage::new(None, Some(vec![L10nAttribute::new("aria-label", "Stop"), L10nAttribute::new("accesskey", "S")]))),
            ("main-context-menu-bookmark-add", L10nMessage::new(None, Some(vec![L10nAttribute::new("aria-label", "Bookmark This Page"), L10nAttribute::new("accesskey", "m"), L10nAttribute::new("tooltiptext", "Bookmark this page")]))),
            ("main-context-menu-open-link", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open Link"), L10nAttribute::new("accesskey", "O")]))),
            ("main-context-menu-open-link-new-tab", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open Link in New Tab"), L10nAttribute::new("accesskey", "T")]))),
            ("main-context-menu-open-link-container-tab", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open Link in New Container Tab"), L10nAttribute::new("accesskey", "b")]))),
            ("main-context-menu-open-link-new-window", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open Link in New Window"), L10nAttribute::new("accesskey", "W")]))),
            ("main-context-menu-open-link-new-private-window", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open Link in New Private Window"), L10nAttribute::new("accesskey", "P")]))),
            ("main-context-menu-bookmark-this-link", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmark This Link"), L10nAttribute::new("accesskey", "L")]))),
            ("main-context-menu-save-link", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save Link As…"), L10nAttribute::new("accesskey", "k")]))),
            ("main-context-menu-save-link-to-pocket", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save Link to Pocket"), L10nAttribute::new("accesskey", "o")]))),
            ("main-context-menu-copy-email", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy Email Address"), L10nAttribute::new("accesskey", "A")]))),
            ("main-context-menu-copy-link", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy Link Location"), L10nAttribute::new("accesskey", "a")]))),
            ("main-context-menu-media-play", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Play"), L10nAttribute::new("accesskey", "P")]))),
            ("main-context-menu-media-pause", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Pause"), L10nAttribute::new("accesskey", "P")]))),
            ("main-context-menu-media-mute", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Mute"), L10nAttribute::new("accesskey", "M")]))),
            ("main-context-menu-media-unmute", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Unmute"), L10nAttribute::new("accesskey", "m")]))),
            ("main-context-menu-media-play-speed", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Play Speed"), L10nAttribute::new("accesskey", "d")]))),
            ("main-context-menu-media-play-speed-slow", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Slow (0.5)"), L10nAttribute::new("accesskey", "S")]))),
            ("main-context-menu-media-play-speed-normal", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Normal"), L10nAttribute::new("accesskey", "N")]))),
            ("main-context-menu-media-play-speed-fast", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Fast (1.25)"), L10nAttribute::new("accesskey", "F")]))),
            ("main-context-menu-media-play-speed-faster", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Faster (1.5)"), L10nAttribute::new("accesskey", "a")]))),
            ("main-context-menu-media-play-speed-fastest", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Ludicrous (2)"), L10nAttribute::new("accesskey", "L")]))),
            ("main-context-menu-media-loop", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Loop"), L10nAttribute::new("accesskey", "L")]))),
            ("main-context-menu-media-show-controls", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show Controls"), L10nAttribute::new("accesskey", "C")]))),
            ("main-context-menu-media-hide-controls", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Hide Controls"), L10nAttribute::new("accesskey", "C")]))),
            ("main-context-menu-media-video-fullscreen", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Full Screen"), L10nAttribute::new("accesskey", "F")]))),
            ("main-context-menu-media-video-leave-fullscreen", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Exit Full Screen"), L10nAttribute::new("accesskey", "u")]))),
            ("main-context-menu-media-pip", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Picture-in-Picture"), L10nAttribute::new("accesskey", "u")]))),
            ("main-context-menu-image-reload", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Reload Image"), L10nAttribute::new("accesskey", "R")]))),
            ("main-context-menu-image-view", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View Image"), L10nAttribute::new("accesskey", "I")]))),
            ("main-context-menu-video-view", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View Video"), L10nAttribute::new("accesskey", "i")]))),
            ("main-context-menu-image-copy", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy Image"), L10nAttribute::new("accesskey", "y")]))),
            ("main-context-menu-image-copy-location", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy Image Location"), L10nAttribute::new("accesskey", "o")]))),
            ("main-context-menu-video-copy-location", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy Video Location"), L10nAttribute::new("accesskey", "o")]))),
            ("main-context-menu-audio-copy-location", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy Audio Location"), L10nAttribute::new("accesskey", "o")]))),
            ("main-context-menu-image-save-as", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save Image As…"), L10nAttribute::new("accesskey", "v")]))),
            ("main-context-menu-image-email", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Email Image…"), L10nAttribute::new("accesskey", "g")]))),
            ("main-context-menu-image-set-as-background", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Set As Desktop Background…"), L10nAttribute::new("accesskey", "S")]))),
            ("main-context-menu-image-info", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View Image Info"), L10nAttribute::new("accesskey", "f")]))),
            ("main-context-menu-image-desc", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View Description"), L10nAttribute::new("accesskey", "D")]))),
            ("main-context-menu-video-save-as", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save Video As…"), L10nAttribute::new("accesskey", "v")]))),
            ("main-context-menu-audio-save-as", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save Audio As…"), L10nAttribute::new("accesskey", "v")]))),
            ("main-context-menu-video-image-save-as", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save Snapshot As…"), L10nAttribute::new("accesskey", "S")]))),
            ("main-context-menu-video-email", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Email Video…"), L10nAttribute::new("accesskey", "a")]))),
            ("main-context-menu-audio-email", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Email Audio…"), L10nAttribute::new("accesskey", "a")]))),
            ("main-context-menu-plugin-play", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Activate this plugin"), L10nAttribute::new("accesskey", "c")]))),
            ("main-context-menu-plugin-hide", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Hide this plugin"), L10nAttribute::new("accesskey", "H")]))),
            ("main-context-menu-page-save", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save Page As…"), L10nAttribute::new("accesskey", "P")]))),
            ("main-context-menu-save-to-pocket", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save Page to Pocket"), L10nAttribute::new("accesskey", "k")]))),
            ("main-context-menu-send-to-device", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Send Page to Device"), L10nAttribute::new("accesskey", "n")]))),
            ("main-context-menu-view-background-image", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View Background Image"), L10nAttribute::new("accesskey", "w")]))),
            ("main-context-menu-generate-new-password", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Use Generated Password…"), L10nAttribute::new("accesskey", "G")]))),
            ("text-action-undo", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Undo"), L10nAttribute::new("accesskey", "U")]))),
            ("text-action-cut", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cut"), L10nAttribute::new("accesskey", "t")]))),
            ("text-action-copy", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy"), L10nAttribute::new("accesskey", "C")]))),
            ("text-action-paste", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Paste"), L10nAttribute::new("accesskey", "P")]))),
            ("text-action-delete", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Delete"), L10nAttribute::new("accesskey", "D")]))),
            ("text-action-select-all", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Select All"), L10nAttribute::new("accesskey", "A")]))),
            ("main-context-menu-keyword", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Add a Keyword for this Search…"), L10nAttribute::new("accesskey", "K")]))),
            ("main-context-menu-link-send-to-device", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Send Link to Device"), L10nAttribute::new("accesskey", "n")]))),
            ("main-context-menu-frame", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "This Frame"), L10nAttribute::new("accesskey", "h")]))),
            ("main-context-menu-frame-show-this", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show Only This Frame"), L10nAttribute::new("accesskey", "S")]))),
            ("main-context-menu-frame-open-tab", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open Frame in New Tab"), L10nAttribute::new("accesskey", "T")]))),
            ("main-context-menu-frame-open-window", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open Frame in New Window"), L10nAttribute::new("accesskey", "W")]))),
            ("main-context-menu-frame-reload", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Reload Frame"), L10nAttribute::new("accesskey", "R")]))),
            ("main-context-menu-frame-bookmark", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmark This Frame"), L10nAttribute::new("accesskey", "m")]))),
            ("main-context-menu-frame-save-as", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save Frame As…"), L10nAttribute::new("accesskey", "F")]))),
            ("main-context-menu-frame-print", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Print Frame…"), L10nAttribute::new("accesskey", "P")]))),
            ("main-context-menu-frame-view-source", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View Frame Source"), L10nAttribute::new("accesskey", "V")]))),
            ("main-context-menu-frame-view-info", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View Frame Info"), L10nAttribute::new("accesskey", "I")]))),
            ("main-context-menu-print-selection", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Print Selection"), L10nAttribute::new("accesskey", "r")]))),
            ("main-context-menu-view-selection-source", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View Selection Source"), L10nAttribute::new("accesskey", "e")]))),
            ("main-context-menu-view-page-source", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View Page Source"), L10nAttribute::new("accesskey", "V")]))),
            ("main-context-menu-view-page-info", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View Page Info"), L10nAttribute::new("accesskey", "I")]))),
            ("main-context-menu-bidi-switch-text", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Switch Text Direction"), L10nAttribute::new("accesskey", "w")]))),
            ("main-context-menu-bidi-switch-page", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Switch Page Direction"), L10nAttribute::new("accesskey", "D")]))),
            ("main-context-menu-inspect-a11y-properties", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Inspect Accessibility Properties")]))),
            ("main-context-menu-inspect-element", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Inspect Element"), L10nAttribute::new("accesskey", "Q")]))),
            ("main-context-menu-eme-learn-more", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Learn more about DRM…"), L10nAttribute::new("accesskey", "D")]))),
            ("places-open", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open"), L10nAttribute::new("accesskey", "O")]))),
            ("places-open-tab", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in a New Tab"), L10nAttribute::new("accesskey", "w")]))),
            ("places-open-all-in-tabs", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open All in Tabs"), L10nAttribute::new("accesskey", "O")]))),
            ("places-open-all-in-tabs", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open All in Tabs"), L10nAttribute::new("accesskey", "O")]))),
            ("places-open-window", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in a New Window"), L10nAttribute::new("accesskey", "N")]))),
            ("places-open-private-window", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open in a New Private Window"), L10nAttribute::new("accesskey", "P")]))),
            ("places-new-bookmark", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "New Bookmark…"), L10nAttribute::new("accesskey", "B")]))),
            ("places-new-folder-contextmenu", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "New Folder…"), L10nAttribute::new("accesskey", "F")]))),
            ("places-new-separator", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "New Separator"), L10nAttribute::new("accesskey", "S")]))),
            ("text-action-cut", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cut"), L10nAttribute::new("accesskey", "t")]))),
            ("text-action-copy", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy"), L10nAttribute::new("accesskey", "C")]))),
            ("text-action-paste", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Paste"), L10nAttribute::new("accesskey", "P")]))),
            ("text-action-delete", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Delete"), L10nAttribute::new("accesskey", "D")]))),
            ("places-delete-domain-data", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Forget About This Site"), L10nAttribute::new("accesskey", "F")]))),
            ("places-sortby-name", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Sort By Name"), L10nAttribute::new("accesskey", "r")]))),
            ("places-properties", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Properties"), L10nAttribute::new("accesskey", "i")]))),
            ("page-action-add-to-urlbar", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Add to Address Bar")]))),
            ("page-action-remove-from-urlbar", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remove from Address Bar")]))),
            ("page-action-add-to-urlbar", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Add to Address Bar")]))),
            ("page-action-remove-from-urlbar", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remove from Address Bar")]))),
            ("page-action-manage-extension", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Manage Extension…")]))),
            ("page-action-remove-extension", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remove Extension")]))),
            ("navbar-tooltip-back", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Go back one page")]))),
            ("navbar-tooltip-instruction", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Right-click or pull down to show history")]))),
            ("navbar-tooltip-forward", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Go forward one page")]))),
            ("navbar-tooltip-instruction", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Right-click or pull down to show history")]))),
            ("popup-select-camera", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Camera to share:"), L10nAttribute::new("accesskey", "C")]))),
            ("popup-all-windows-shared", "All visible windows on your screen will be shared."),
            ("popup-select-microphone", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Microphone to share:"), L10nAttribute::new("accesskey", "M")]))),
            ("downloads-panel", L10nMessage::new(None, Some(vec![L10nAttribute::new("aria-label", "Downloads")]))),
            ("downloads-cmd-pause", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Pause"), L10nAttribute::new("accesskey", "P")]))),
            ("downloads-cmd-resume", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Resume"), L10nAttribute::new("accesskey", "R")]))),
            ("downloads-cmd-unblock", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Allow Download"), L10nAttribute::new("accesskey", "o")]))),
            ("downloads-cmd-use-system-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open In System Viewer"), L10nAttribute::new("accesskey", "V")]))),
            ("downloads-cmd-always-use-system-default", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Always Open In System Viewer"), L10nAttribute::new("accesskey", "w")]))),
            ("downloads-cmd-show-menuitem", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open Containing Folder"), L10nAttribute::new("accesskey", "F")]))),
            ("downloads-cmd-go-to-download-page", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Go To Download Page"), L10nAttribute::new("accesskey", "G")]))),
            ("downloads-cmd-copy-download-link", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy Download Link"), L10nAttribute::new("accesskey", "L")]))),
            ("downloads-cmd-remove-from-history", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Remove From History"), L10nAttribute::new("accesskey", "e")]))),
            ("downloads-cmd-clear-list", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Clear Preview Panel"), L10nAttribute::new("accesskey", "a")]))),
            ("downloads-cmd-clear-downloads", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Clear Downloads"), L10nAttribute::new("accesskey", "D")]))),
            ("downloads-panel-list", L10nMessage::new(None, Some(vec![L10nAttribute::new("style", "width: 70ch")]))),
            ("downloads-panel-empty", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "No downloads for this session.")]))),
            ("downloads-history", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show All Downloads"), L10nAttribute::new("accesskey", "S")]))),
            ("downloads-details", L10nMessage::new(None, Some(vec![L10nAttribute::new("title", "Download Details")]))),
            ("downloads-cmd-show-downloads", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show Downloads Folder")]))),
            ("downloads-history", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show All Downloads"), L10nAttribute::new("accesskey", "S")]))),
            ("text-action-undo", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Undo"), L10nAttribute::new("accesskey", "U")]))),
            ("text-action-cut", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cut"), L10nAttribute::new("accesskey", "t")]))),
            ("text-action-copy", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy"), L10nAttribute::new("accesskey", "C")]))),
            ("text-action-paste", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Paste"), L10nAttribute::new("accesskey", "P")]))),
            ("text-action-delete", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Delete"), L10nAttribute::new("accesskey", "D")]))),
            ("text-action-select-all", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Select All"), L10nAttribute::new("accesskey", "A")]))),
            ("menu-file", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "File"), L10nAttribute::new("accesskey", "F")]))),
            ("menu-file-new-tab", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "New Tab"), L10nAttribute::new("accesskey", "T")]))),
            ("menu-file-new-container-tab", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "New Container Tab"), L10nAttribute::new("accesskey", "b")]))),
            ("menu-file-new-window", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "New Window"), L10nAttribute::new("accesskey", "N")]))),
            ("menu-file-new-private-window", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "New Private Window"), L10nAttribute::new("accesskey", "W")]))),
            ("menu-file-open-location", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open Location…")]))),
            ("menu-file-open-file", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Open File…"), L10nAttribute::new("accesskey", "O")]))),
            ("menu-file-close", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Close"), L10nAttribute::new("accesskey", "C")]))),
            ("menu-file-close-window", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Close Window"), L10nAttribute::new("accesskey", "d")]))),
            ("menu-file-save-page", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Save Page As…"), L10nAttribute::new("accesskey", "A")]))),
            ("menu-file-email-link", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Email Link…"), L10nAttribute::new("accesskey", "E")]))),
            ("menu-file-print-preview", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Print Preview"), L10nAttribute::new("accesskey", "v")]))),
            ("menu-file-print", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Print…"), L10nAttribute::new("accesskey", "P")]))),
            ("menu-file-import-from-another-browser", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Import From Another Browser…"), L10nAttribute::new("accesskey", "I")]))),
            ("menu-file-go-offline", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Work Offline"), L10nAttribute::new("accesskey", "k")]))),
            ("menu-edit", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Edit"), L10nAttribute::new("accesskey", "E")]))),
            ("text-action-undo", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Undo"), L10nAttribute::new("accesskey", "U")]))),
            ("text-action-redo", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Redo"), L10nAttribute::new("accesskey", "R")]))),
            ("text-action-cut", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cut"), L10nAttribute::new("accesskey", "t")]))),
            ("text-action-copy", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy"), L10nAttribute::new("accesskey", "C")]))),
            ("text-action-paste", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Paste"), L10nAttribute::new("accesskey", "P")]))),
            ("text-action-delete", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Delete"), L10nAttribute::new("accesskey", "D")]))),
            ("text-action-select-all", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Select All"), L10nAttribute::new("accesskey", "A")]))),
            ("menu-edit-find-on", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Find in This Page…"), L10nAttribute::new("accesskey", "F")]))),
            ("menu-edit-find-again", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Find Again"), L10nAttribute::new("accesskey", "g")]))),
            ("menu-edit-bidi-switch-text-direction", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Switch Text Direction"), L10nAttribute::new("accesskey", "w")]))),
            ("menu-preferences", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Preferences"), L10nAttribute::new("accesskey", "n")]))),
            ("menu-view", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "View"), L10nAttribute::new("accesskey", "V")]))),
            ("menu-view-toolbars-menu", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Toolbars"), L10nAttribute::new("accesskey", "T")]))),
            ("menu-view-customize-toolbar", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Customize…"), L10nAttribute::new("accesskey", "C")]))),
            ("menu-view-sidebar", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Sidebar"), L10nAttribute::new("accesskey", "e")]))),
            ("menu-view-bookmarks", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmarks")]))),
            ("menu-view-history-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "History")]))),
            ("menu-view-synced-tabs-sidebar", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Synced Tabs")]))),
            ("menu-view-full-zoom", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Zoom"), L10nAttribute::new("accesskey", "Z")]))),
            ("menu-view-full-zoom-enlarge", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Zoom In"), L10nAttribute::new("accesskey", "I")]))),
            ("menu-view-full-zoom-reduce", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Zoom Out"), L10nAttribute::new("accesskey", "O")]))),
            ("menu-view-full-zoom-actual-size", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Actual Size"), L10nAttribute::new("accesskey", "A")]))),
            ("menu-view-full-zoom-toggle", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Zoom Text Only"), L10nAttribute::new("accesskey", "T")]))),
            ("menu-view-page-style-menu", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Page Style"), L10nAttribute::new("accesskey", "y")]))),
            ("menu-view-page-style-no-style", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "No Style"), L10nAttribute::new("accesskey", "n")]))),
            ("menu-view-page-basic-style", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Basic Page Style"), L10nAttribute::new("accesskey", "B")]))),
            ("menu-view-charset", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Text Encoding"), L10nAttribute::new("accesskey", "c")]))),
            ("menu-view-full-screen", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Full Screen"), L10nAttribute::new("accesskey", "F")]))),
            ("menu-view-show-all-tabs", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show All Tabs"), L10nAttribute::new("accesskey", "A")]))),
            ("menu-view-bidi-switch-page-direction", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Switch Page Direction"), L10nAttribute::new("accesskey", "D")]))),
            ("menu-history", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "History"), L10nAttribute::new("accesskey", "s")]))),
            ("menu-history-show-all-history", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show All History")]))),
            ("menu-history-clear-recent-history", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Clear Recent History…")]))),
            ("menu-history-synced-tabs", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Synced Tabs")]))),
            ("menu-history-restore-last-session", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Restore Previous Session")]))),
            ("menu-history-hidden-tabs", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Hidden Tabs")]))),
            ("menu-history-undo-menu", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Recently Closed Tabs")]))),
            ("menu-history-undo-window-menu", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Recently Closed Windows")]))),
            ("menu-bookmarks-menu", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmarks"), L10nAttribute::new("accesskey", "B")]))),
            ("menu-bookmarks-show-all", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Show All Bookmarks")]))),
            ("menu-bookmark-this-page", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmark This Page")]))),
            ("menu-bookmarks-all-tabs", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmark All Tabs…")]))),
            ("menu-bookmarks-toolbar", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmarks Toolbar")]))),
            ("menu-bookmarks-other", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Other Bookmarks")]))),
            ("menu-bookmarks-mobile", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Mobile Bookmarks")]))),
            ("menu-tools", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Tools"), L10nAttribute::new("accesskey", "T")]))),
            ("menu-tools-downloads", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Downloads"), L10nAttribute::new("accesskey", "D")]))),
            ("menu-tools-addons", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Add-ons"), L10nAttribute::new("accesskey", "A")]))),
            ("menu-tools-fxa-sign-in", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Sign In To Firefox…"), L10nAttribute::new("accesskey", "g")]))),
            ("menu-tools-turn-on-sync", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Turn on Sync…"), L10nAttribute::new("accesskey", "n")]))),
            ("menu-tools-fxa-sign-in", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Sign In To Firefox…"), L10nAttribute::new("accesskey", "g")]))),
            ("menu-tools-sync-now", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Sync Now"), L10nAttribute::new("accesskey", "S")]))),
            ("menu-tools-fxa-re-auth", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Reconnect to Firefox…"), L10nAttribute::new("accesskey", "R")]))),
            ("menu-tools-web-developer", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Web Developer"), L10nAttribute::new("accesskey", "W")]))),
            ("menu-tools-page-source", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Page Source"), L10nAttribute::new("accesskey", "o")]))),
            ("menu-tools-page-info", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Page Info"), L10nAttribute::new("accesskey", "I")]))),
            ("menu-help", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Help"), L10nAttribute::new("accesskey", "H")]))),
            ("menu-help-product", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Nightly Help"), L10nAttribute::new("accesskey", "H")]))),
            ("menu-help-show-tour", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Nightly Tour"), L10nAttribute::new("accesskey", "o")]))),
            ("menu-help-import-from-another-browser", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Import From Another Browser…"), L10nAttribute::new("accesskey", "I")]))),
            ("menu-help-keyboard-shortcuts", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Keyboard Shortcuts"), L10nAttribute::new("accesskey", "K")]))),
            ("menu-help-troubleshooting-info", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Troubleshooting Information"), L10nAttribute::new("accesskey", "T")]))),
            ("menu-help-feedback-page", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Submit Feedback…"), L10nAttribute::new("accesskey", "S")]))),
            ("menu-help-safe-mode-without-addons", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Restart With Add-ons Disabled…"), L10nAttribute::new("accesskey", "R")]))),
            ("menu-help-report-deceptive-site", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Report Deceptive Site…"), L10nAttribute::new("accesskey", "D")]))),
            ("menu-help-not-deceptive", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "This Isn\\u2019t a Deceptive Site…"), L10nAttribute::new("accesskey", "D")]))),
            ("browser-window-minimize-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Minimize")]))),
            ("browser-window-maximize-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Maximize")]))),
            ("browser-window-restore-down-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Restore Down")]))),
            ("browser-window-close-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Close")]))),
            ("browser-window-minimize-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Minimize")]))),
            ("browser-window-maximize-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Maximize")]))),
            ("browser-window-restore-down-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Restore Down")]))),
            ("browser-window-close-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Close")]))),
            ("toolbar-button-back", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Back")]))),
            ("toolbar-button-forward", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Forward")]))),
            ("toolbar-button-stop-reload", L10nMessage::new(None, Some(vec![L10nAttribute::new("title", "Reload")]))),
            ("toolbar-button-reload", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Reload")]))),
            ("toolbar-button-stop", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Stop")]))),
            ("urlbar-identity-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("aria-label", "View site information")]))),
            ("urlbar-permissions-granted", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have granted this website additional permissions.")]))),
            ("urlbar-geolocation-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked location information for this website.")]))),
            ("urlbar-xr-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked virtual reality device access for this website.")]))),
            ("urlbar-web-notifications-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked notifications for this website.")]))),
            ("urlbar-camera-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked your camera for this website.")]))),
            ("urlbar-microphone-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked your microphone for this website.")]))),
            ("urlbar-screen-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked this website from sharing your screen.")]))),
            ("urlbar-persistent-storage-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked persistent storage for this website.")]))),
            ("urlbar-popup-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked pop-ups for this website.")]))),
            ("urlbar-autoplay-media-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked autoplay media with sound for this website.")]))),
            ("urlbar-canvas-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked canvas data extraction for this website.")]))),
            ("urlbar-midi-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked MIDI access for this website.")]))),
            ("urlbar-install-blocked", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "You have blocked add-on installation for this website.")]))),
            ("urlbar-default-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Open message panel")]))),
            ("urlbar-geolocation-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Open location request panel")]))),
            ("urlbar-xr-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Open virtual reality permission panel")]))),
            ("urlbar-autoplay-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Open autoplay panel")]))),
            ("urlbar-addons-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Open add-on installation message panel")]))),
            ("urlbar-canvas-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Manage canvas extraction permission")]))),
            ("urlbar-indexed-db-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Open offline storage message panel")]))),
            ("urlbar-password-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Open save password message panel")]))),
            ("urlbar-plugins-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Manage plug-in use")]))),
            ("urlbar-web-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Change whether you can receive notifications from the site")]))),
            ("urlbar-web-rtc-share-devices-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Manage sharing your camera and/or microphone with the site")]))),
            ("urlbar-web-rtc-share-microphone-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Manage sharing your microphone with the site")]))),
            ("urlbar-web-rtc-share-screen-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Manage sharing your windows or screen with the site")]))),
            ("urlbar-services-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Open install message panel")]))),
            ("urlbar-translate-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Translate this page")]))),
            ("urlbar-translated-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Manage page translation")]))),
            ("urlbar-eme-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Manage use of DRM software")]))),
            ("urlbar-persistent-storage-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Store data in Persistent Storage")]))),
            ("urlbar-midi-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Open MIDI panel")]))),
            ("urlbar-web-authn-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Open Web Authentication panel")]))),
            ("urlbar-storage-access-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Open browsing activity permission panel")]))),
            ("urlbar-remote-control-notification-anchor", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Browser is under remote control")]))),
            ("urlbar-switch-to-tab", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Switch to tab:")]))),
            ("urlbar-extension", L10nMessage::new(None, Some(vec![L10nAttribute::new("value", "Extension:")]))),
            ("urlbar-placeholder", L10nMessage::new(None, Some(vec![L10nAttribute::new("placeholder", "Search or enter address")]))),
            ("urlbar-go-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Go to the address in the Location Bar")]))),
            ("urlbar-page-action-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Page actions")]))),
            ("urlbar-pocket-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Save to Pocket")]))),
            ("browser-window-minimize-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Minimize")]))),
            ("browser-window-restore-down-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Restore Down")]))),
            ("browser-window-close-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Close")]))),
            ("bookmarks-toolbar", L10nMessage::new(None, Some(vec![L10nAttribute::new("toolbarname", "Bookmarks Toolbar"), L10nAttribute::new("accesskey", "B"), L10nAttribute::new("aria-label", "Bookmarks")]))),
            ("bookmarks-toolbar-empty-message", "For quick access, place your bookmarks here on the bookmarks toolbar. <a data-l10n-name=\"manage-bookmarks\">Manage bookmarks…</a>"),
            ("bookmarks-toolbar-placeholder", L10nMessage::new(None, Some(vec![L10nAttribute::new("title", "Bookmarks Toolbar Items")]))),
            ("bookmarks-toolbar-placeholder-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmarks Toolbar Items")]))),
            ("bookmarks-toolbar-placeholder-button", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmarks Toolbar Items")]))),
            ("bookmarks-toolbar-chevron", L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Show more bookmarks")]))),
            ("fullscreen-warning-no-domain", "This document is now full screen"),
            ("fullscreen-exit-button", "Exit Full Screen (Esc)"),
            ("pointerlock-warning-no-domain", "This document has control of your pointer. Press Esc to take back control."),
            ("text-action-undo", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Undo"), L10nAttribute::new("accesskey", "U")]))),
            ("text-action-cut", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Cut"), L10nAttribute::new("accesskey", "t")]))),
            ("text-action-copy", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Copy"), L10nAttribute::new("accesskey", "C")]))),
            ("text-action-paste", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Paste"), L10nAttribute::new("accesskey", "P")]))),
            ("text-action-delete", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Delete"), L10nAttribute::new("accesskey", "D")]))),
            ("text-action-select-all", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Select All"), L10nAttribute::new("accesskey", "A")]))),
            (L10nKey::new("urlbar-pocket-button", Some(vec![L10nArgument::new("tabCount", "1")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Save to Pocket")]))),
            ("menu-bookmark-this-page", L10nMessage::new(None, Some(vec![L10nAttribute::new("label", "Bookmark This Page")]))),
            (L10nKey::new("urlbar-star-add-bookmark", Some(vec![L10nArgument::new("shortcut", "Ctrl+D")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("tooltiptext", "Bookmark this page (Ctrl+D)")]))),
            (L10nKey::new("main-context-menu-bookmark-add-with-shortcut", Some(vec![L10nArgument::new("shortcut", "Ctrl+D")])), L10nMessage::new(None, Some(vec![L10nAttribute::new("aria-label", "Bookmark This Page"), L10nAttribute::new("accesskey", "m"), L10nAttribute::new("tooltiptext", "Bookmark this page (Ctrl+D)")])))
        ],
    )
}
