/**
 * ICMP send and receive prototypes
 *
 * Authors:
 * Jaakko Laine <medved@iki.fi>
 *
 * $Id: s.mipv6_icmp.h 1.6 02/11/25 11:18:16+02:00 vnuorval@amber.hut.mediapoli.com $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef _MIPV6_ICMP
#define _MIPV6_ICMP

#include <linux/config.h>
#include <linux/in6.h>

/**
 * mipv6_icmpv6_send - generic icmpv6 message send
 * @daddr: destination address
 * @saddr: source address
 * @type: icmp type
 * @code: icmp code
 * @id: packet identifier. If null, uses internal counter to get new id
 * @data: packet data
 * @datalen: length of data in bytes
 */
void mipv6_icmpv6_send(struct in6_addr *daddr, struct in6_addr *saddr, int type,
		       int code,  __u16 *id, void *data, int datalen);

/*
 * Send DHAAD request to home subnet's Home Agents anycast address 
 */
void mipv6_icmpv6_send_dhaad_req(struct in6_addr *home_addr, int plen, __u16 dhaad_id);

/*
 * Send DHAAD reply in response to DHAAD request
 */
void mipv6_icmpv6_send_dhaad_rep(int ifindex, __u16 id, struct in6_addr *daddr);

#ifdef CONFIG_IPV6_MOBILITY_MN

/* Receive DHAAD Reply message */
int mipv6_icmpv6_rcv_dhaad_rep(struct sk_buff *skb);
/* Receive Parameter Problem message */
int mipv6_icmpv6_rcv_paramprob(struct sk_buff *skb);
/* Receive prefix advertisements */
int mipv6_icmpv6_rcv_pfx_adv(struct sk_buff *skb);

#else
static inline int mipv6_icmpv6_rcv_dhaad_rep(struct sk_buff *skb) { return 0; }
static inline int mipv6_icmpv6_rcv_paramprob(struct sk_buff *skb) { return 0; }
static inline int mipv6_icmpv6_rcv_pfx_adv(struct sk_buff *skb) { return 0; }
#endif

#ifdef CONFIG_IPV6_MOBILITY_HA

/* Receive DHAAD Request message */
int mipv6_icmpv6_rcv_dhaad_req(struct sk_buff *skb);
/* Receive prefix solicitations */
int mipv6_icmpv6_rcv_pfx_sol(struct sk_buff *skb);

#else
static inline int mipv6_icmpv6_rcv_dhaad_req(struct sk_buff *skb) { return 0; }
static inline int mipv6_icmpv6_rcv_pfx_sol(struct sk_buff *skb) { return 0; }
#endif

int mipv6_initialize_icmpv6(void);
void mipv6_shutdown_icmpv6(void);

#endif
