/******************************************************************************
 *
 * Name:	skgiauto.h
 * Project:	SysKonnect 9Dxx Gigabit Ethernet
 * Version:	$Revision: 1.1 $
 * Date:	$Date: 2001/08/09 10:56:40 $
 * Purpose:	defines and structures for IEEE 802.3z auto-negotation
 *
 ******************************************************************************/

/******************************************************************************
 *
 *	(C)Copyright 2001 SysKonnect GmbH.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	The information in this file is provided "AS IS" without warranty.
 *
 ******************************************************************************/

/******************************************************************************
 *
 * History:
 *
 *	$Log: skgiauto.h,v $
 *	Revision 1.1  2001/08/09 10:56:40  rschmidt
 *	First public version.
 *	
 *
 ******************************************************************************/

/******************************************************************************
 *
 * Description:
 *
 ******************************************************************************/

#ifndef __SKGIAUTO_H
#define __SKGIAUTO_H


/******************************************************************************/
/* Constants */
/******************************************************************************/

#define AN_LINK_TIMER_INTERVAL_US           10000       /* 10ms */
#define AN_NO_RX_CONFIG_TIME_OUT            1000        /* 1ms */

/* time to receive three configurations */
#define AN_THREE_RX_CONFIG_TIME             5           /* 5us */


/******************************************************************************/
/* Main data structure for keeping track of 802.3z auto-negotation state */
/* variables as shown in Figure 37-6 of the IEEE 802.3z specification */
/******************************************************************************/

typedef struct
{
    /* Current auto-negotiation state */
    SK_U32 State;
    #define AN_STATE_UNKNOWN                        0
    #define AN_STATE_AN_ENABLE                      1
    #define AN_STATE_AN_RESTART_INIT                2
    #define AN_STATE_AN_RESTART                     3
    #define AN_STATE_DISABLE_LINK_OK                4
    #define AN_STATE_ABILITY_DETECT_INIT            5
    #define AN_STATE_ABILITY_DETECT                 6
    #define AN_STATE_ACK_DETECT_INIT                7
    #define AN_STATE_ACK_DETECT                     8
    #define AN_STATE_COMPLETE_ACK_INIT              9
    #define AN_STATE_COMPLETE_ACK                   10
    #define AN_STATE_IDLE_DETECT_INIT               11
    #define AN_STATE_IDLE_DETECT                    12
    #define AN_STATE_LINK_OK                        13
    #define AN_STATE_NEXT_PAGE_WAIT_INIT            14
    #define AN_STATE_NEXT_PAGE_WAIT                 16

    /* Link timer */
    SK_U32	LinkTime_us;

    /* time a new Config was received */
    SK_U32	RxConfigTime_us;

    /* time an IDLE was received */
    SK_U32	IdleTime_us;

    /* time a new Config was received with the ACK bit set */
    SK_U32	AckTime_us;

    /* value for consistency check */
    SK_U16	AbilityMatchConfig;

    /* Set when receiving configs, otherwise receive IDLEs */
    SK_BOOL	ReceivingConfigs;

    /* Tx config data */
    union
    {
        /* The TxConfig register is arranged as follows:                      */
        /*                                                                    */
        /* MSB                                                           LSB  */
        /* +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+  */
        /* | D7| D6| D5| D4| D3| D2| D1| D0|D15|D14|D13|D12|D11|D10| D9| D8|  */
        /* +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+  */
        struct
        {
            SK_U16 D8:1;        /* PS2 */
            SK_U16 D9:1;
            SK_U16 D10:1;
            SK_U16 D11:1;
            SK_U16 D12:1;       /* RF1 */
            SK_U16 D13:1;       /* RF2 */
            SK_U16 D14:1;       /* ACK */
            SK_U16 D15:1;       /* NP */
            SK_U16 D0:1;
            SK_U16 D1:1;
            SK_U16 D2:1;
            SK_U16 D3:1;
            SK_U16 D4:1;
            SK_U16 D5:1;        /* FD */
            SK_U16 D6:1;        /* HD */
            SK_U16 D7:1;        /* PS1 */
        } bits;

        SK_U16 AsUSHORT;

        #define D8_PS2                      bits.D8
        #define D12_RF1                     bits.D12
        #define D13_RF2                     bits.D13
        #define D14_ACK                     bits.D14
        #define D15_NP                      bits.D15
        #define D5_FD                       bits.D5
        #define D6_HD                       bits.D6
        #define D7_PS1                      bits.D7
    } TxConfig;

    /* Rx config data */
    union
    {
        /* The RxConfig register is arranged as follows:                      */
        /*                                                                    */
        /* MSB                                                           LSB  */
        /* +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+  */
        /* | D7| D6| D5| D4| D3| D2| D1| D0|D15|D14|D13|D12|D11|D10| D9| D8|  */
        /* +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+  */
        struct
        {
            SK_U16 D8:1;        /* PS2 */
            SK_U16 D9:1;
            SK_U16 D10:1;
            SK_U16 D11:1;
            SK_U16 D12:1;       /* RF1 */
            SK_U16 D13:1;       /* RF2 */
            SK_U16 D14:1;       /* ACK */
            SK_U16 D15:1;       /* NP */
            SK_U16 D0:1;
            SK_U16 D1:1;
            SK_U16 D2:1;
            SK_U16 D3:1;
            SK_U16 D4:1;
            SK_U16 D5:1;        /* FD */
            SK_U16 D6:1;        /* HD */
            SK_U16 D7:1;        /* PS1 */
        } bits;

        SK_U16 AsUSHORT;
    } RxConfig;

    #define AN_CONFIG_NP                    0x0080
    #define AN_CONFIG_ACK                   0x0040
    #define AN_CONFIG_RF2                   0x0020
    #define AN_CONFIG_RF1                   0x0010
    #define AN_CONFIG_PS2                   0x0001
    #define AN_CONFIG_PS1                   0x8000
    #define AN_CONFIG_HD                    0x4000
    #define AN_CONFIG_FD                    0x2000


    /* Management registers */

    /* Control register */
    union
    {
        struct
        {
            SK_U16 an_enable:1;
            SK_U16 loopback:1;
            SK_U16 reset:1;
            SK_U16 restart_an:1;
        } bits;

        SK_U16 AsUSHORT;

        #define mr_an_enable                Mr0.bits.an_enable
        #define mr_loopback                 Mr0.bits.loopback
        #define mr_main_reset               Mr0.bits.reset
        #define mr_restart_an               Mr0.bits.restart_an
    } Mr0;

    /* Status register */
    union
    {
        struct
        {
            SK_U16 an_complete:1;
            SK_U16 link_ok:1;
        } bits;

        SK_U16 AsUSHORT;

        #define mr_an_complete              Mr1.bits.an_complete
        #define mr_link_ok                  Mr1.bits.link_ok
    } Mr1;

    /* Advertisement register */
    union
    {
        struct
        {
            SK_U16 reserved_4:5;
            SK_U16 full_duplex:1;
            SK_U16 half_duplex:1;
            SK_U16 sym_pause:1;
            SK_U16 asym_pause:1;
            SK_U16 reserved_11:3;
            SK_U16 remote_fault1:1;
            SK_U16 remote_fault2:1;
            SK_U16 reserved_14:1;
            SK_U16 next_page:1;
        } bits;

        SK_U16 AsUSHORT;

        #define mr_adv_full_duplex          Mr4.bits.full_duplex
        #define mr_adv_half_duplex          Mr4.bits.half_duplex
        #define mr_adv_sym_pause            Mr4.bits.sym_pause
        #define mr_adv_asym_pause           Mr4.bits.asym_pause
        #define mr_adv_remote_fault1        Mr4.bits.remote_fault1
        #define mr_adv_remote_fault2        Mr4.bits.remote_fault2
        #define mr_adv_next_page            Mr4.bits.next_page
    } Mr4;

    /* Link partner advertisement register */
    union
    {
        struct
        {
            SK_U16 reserved_4:5;
            SK_U16 lp_full_duplex:1;
            SK_U16 lp_half_duplex:1;
            SK_U16 lp_sym_pause:1;
            SK_U16 lp_asym_pause:1;
            SK_U16 reserved_11:3;
            SK_U16 lp_remote_fault1:1;
            SK_U16 lp_remote_fault2:1;
            SK_U16 lp_ack:1;
            SK_U16 lp_next_page:1;
        } bits;

        SK_U16 AsUSHORT;

        #define mr_lp_adv_full_duplex       Mr5.bits.lp_full_duplex
        #define mr_lp_adv_half_duplex       Mr5.bits.lp_half_duplex
        #define mr_lp_adv_sym_pause         Mr5.bits.lp_sym_pause
        #define mr_lp_adv_asym_pause        Mr5.bits.lp_asym_pause
        #define mr_lp_adv_remote_fault1     Mr5.bits.lp_remote_fault1
        #define mr_lp_adv_remote_fault2     Mr5.bits.lp_remote_fault2
        #define mr_lp_adv_next_page         Mr5.bits.lp_next_page
    } Mr5;

    /* Auto-negotiation expansion register */
    union
    {
        struct
        {
            SK_U16 reserved_0:1;
            SK_U16 page_received:1;
            SK_U16 next_pageable:1;
            SK_U16 reserved_15:13;
        } bits;

        SK_U16 AsUSHORT;
    } Mr6;

    /* Auto-negotiation next page transmit register */
    union
    {
        struct
        {
            SK_U16 code_field:11;
            SK_U16 toggle:1;
            SK_U16 ack2:1;
            SK_U16 message_page:1;
            SK_U16 reserved_14:1;
            SK_U16 next_page:1;
        } bits;

        SK_U16 AsUSHORT;

        #define mr_np_tx                    Mr7.AsUSHORT
    } Mr7;

    /* Auto-negotiation link partner ability register */
    union
    {
        struct
        {
            SK_U16 code_field:11;
            SK_U16 toggle:1;
            SK_U16 ack2:1;
            SK_U16 message_page:1;
            SK_U16 ack:1;
            SK_U16 next_page:1;
        } bits;

        SK_U16 AsUSHORT;

        #define mr_lp_np_rx                 Mr8.AsUSHORT
    } Mr8;

    /* Extended status register */
    union
    {
        struct
        {
            SK_U16 reserved_11:12;
            SK_U16 base1000_t_hd:1;
            SK_U16 base1000_t_fd:1;
            SK_U16 base1000_x_hd:1;
            SK_U16 base1000_x_fd:1;
        } bits;

        SK_U16 AsUSHORT;
    } Mr15;

    /* Miscellaneous state variables */
    union
    {
        struct
        {
            SK_U16 toggle_tx:1;
            SK_U16 toggle_rx:1;
            SK_U16 np_rx:1;
            SK_U16 page_rx:1;
            SK_U16 np_loaded:1;
        } bits;

        SK_U16 AsUSHORT;

        #define mr_toggle_tx                MrMisc.bits.toggle_tx
        #define mr_toggle_rx                MrMisc.bits.toggle_rx
        #define mr_np_rx                    MrMisc.bits.np_rx
        #define mr_page_rx                  MrMisc.bits.page_rx
        #define mr_np_loaded                MrMisc.bits.np_loaded
    } MrMisc;
} AUTO_NEG_STATE, *P_AUTO_NEG_STATE;



/******************************************************************************/
/* Return code of AutoNeg8023z */
/******************************************************************************/

#define AUTONEG_STATUS_OK               0
#define AUTONEG_STATUS_DONE             1
#define AUTONEG_STATUS_TIMER_ENABLED    2
#define AUTONEG_STATUS_FAILED           -1


/******************************************************************************/
/* Function prototypes */
/******************************************************************************/

#if 0
extern int AutoNeg8023z(
	SK_AC *pAC,
	SK_IOC IoC);
extern void AutoNegTxConfig(
	SK_AC *pAC,
	SK_IOC IoC);
extern SK_BOOL AutoNegRxConfig(
	SK_AC *pAC,
	SK_IOC IoC,
	SK_U32 *p);
#endif /* 0 */

#endif /* __SKGIAUTO_H */

