/*
 * Defines some debug macros for smbfs.
 */

/* This makes a dentry parent/child name pair. Useful for debugging printk's */
#define DENTRY_PATH(dentry) \
	(dentry)->d_parent->d_name.name,(dentry)->d_name.name

/*
 * safety checks that should never happen ??? 
 * these are normally enabled.
 */
#ifdef SMBFS_PARANOIA
#define PARANOIA(fmt,args...) printk(KERN_NOTICE "%s: " fmt, __FUNCTION__, args)
#else
#define PARANOIA(x...) do { ; } while(0)
#endif

/* lots of debug messages */
#ifdef SMBFS_DEBUG_VERBOSE
#define VERBOSE(fmt, args...) printk(KERN_DEBUG "%s: " fmt, __FUNCTION__, args)
#else
#define VERBOSE(x...) do { ; } while(0)
#endif

/*
 * "normal" debug messages, but not with a normal DEBUG define ... way
 * too common name.
 */
#ifdef SMBFS_TRACE
#define TRACE() printk(KERN_DEBUG "%s--trace--\n", __FUNCTION__)
#else
#define TRACE() do { ; } while(0)
#endif

#ifdef SMBFS_DEBUG
#define DEBUG1(fmt, args...) printk(KERN_DEBUG "%s: " fmt, __FUNCTION__, args)
#else
#define DEBUG1(x...) do { ; } while(0)
#endif

#ifdef SMBFS_DEBUG2
#define DEBUG2(fmt, args...) printk(KERN_DEBUG "%s: " fmt, __FUNCTION__, args)
#else
#define DEBUG2(x...) do { ; } while(0)
#endif

#define PRINT_INODE(inode) printk("imode_%d uid_%d gid_%d\n",\
	 inode->i_mode, inode->i_uid, inode->i_gid) 

#define PRINT_DENTRY(x) do { ; } while(0)
