#*******************************************************************
# * This file is part of the Emulex Linux Device Driver for         *
# * Enterprise Fibre Channel Host Bus Adapters.                     *
# * Refer to the README file included with this package for         *
# * driver version and adapter support.                             *
# * Copyright (C) 2003 Emulex Corporation.                          *
# * www.emulex.com                                                  *
# *                                                                 *
# * This program is free software; you can redistribute it and/or   *
# * modify it under the terms of the GNU General Public License     *
# * as published by the Free Software Foundation; either version 2  *
# * of the License, or (at your option) any later version.          *
# *                                                                 *
# * This program is distributed in the hope that it will be useful, *
# * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
# * GNU General Public License for more details, a copy of which    *
# * can be found in the file COPYING included with this package.    *
# *******************************************************************
%define    rel     1
%define    ver     LPFC_DRIVER_VERSION
%define    tarName lpfcdriver.tar

Summary:   Emulex Driver Kit for Linux
Name:      lpfcdriver
Version:   %ver
Release:   %rel
Copyright: Emulex Corp.
Group:     System Environment/Kernel
Source:    %tarName 
URL:       http://www.emulex.com
Vendor:    Emulex Corp.
Packager:  Regis.Goupil
BuildRoot: /tmp/lpfc-%{ver}
Requires:  kernel >= 2.2.0
Requires:  rpm >= 3.0.4

%description
Emulex Open Source Fibre Channel driver for Linux version %ver

%prep

%build
rm -rf %{buildroot}
mkdir -p %{buildroot}/lpfc-%{ver}
cd lpfc-%{ver}
find . -print | cpio -pdumv %{buildroot}/

%install
cd %{buildroot}/lpfc-%{ver}
tar -xf /usr/src/redhat/SOURCES/lpfc-%{ver}/lpfcdriver.tar
if [ -e /usr/src/linux-2.4/drivers/scsi ]; then dirval="linux-2.4"; \
else if [ -e /usr/src/linux/drivers/scsi ]; then dirval="linux"; \
else echo "Cannot find the kernel sources directory"; exit 1; fi fi
if [ -e /usr/src/$dirval/drivers/scsi/lpfc/ ]; then \
rm -fr /usr/src/$dirval/drivers/scsi/lpfc; 
fi
mkdir -p /usr/src/$dirval/drivers/scsi/lpfc; 
cp * /usr/src/$dirval/drivers/scsi/lpfc; 

# post install (on client machine) section
%post
if [ -e /usr/src/linux-2.4/drivers/scsi ]; then dirval="linux-2.4"; \
else if [ -e /usr/src/linux/drivers/scsi ]; then dirval="linux"; \
else echo "Cannot find the kernel sources directory"; exit 1; fi fi
rm -fr lpfc-%{ver}/lpfc;
rm -fr /usr/src/$dirval/drivers/scsi/lpfc;
mkdir /usr/src/$dirval/drivers/scsi/lpfc;
cp lpfc-%{ver}/* /usr/src/$dirval/drivers/scsi/lpfc;

echo "  "
echo "The Emulex Open Source Driver has been installed on your system." 
echo "Source files have been installed under a temporary directory /lpfc-%{ver}"
echo "and under /usr/src/$dirval/drivers/scsi/lpfc."
echo "Please refer to the Emulex documentation for the next step."
echo "  "

%preun
if [ -e /usr/src/linux-2.4/drivers/scsi/lpfc ]; then dirval="linux-2.4"; \
else if [ -e /usr/src/linux/drivers/scsi/lpfc ]; then dirval="linux"; fi fi
echo "  "
echo "The lpfcdriver rpm is about to be removed from your system."
echo "All the source files under /usr/src/$dirval/drivers/scsi/lpfc"
echo "and /lpfc-%{ver} will be removed."
echo "  "

%postun
if [ -e /usr/src/linux-2.4/drivers/scsi/lpfc ]; then dirval="linux-2.4"; \
else if [ -e /usr/src/linux/drivers/scsi/lpfc ]; then dirval="linux"; fi fi
rm -fr /usr/src/$dirval/drivers/scsi/lpfc;
echo "  "
echo "The Emulex Open Source Driver has been removed from your system."
echo "Remove the appropriate entry in modules.conf if this file was modified."
echo "  "
rm -fr lpfc-%{ver};

%files
/lpfc-%{ver}/COPYING
/lpfc-%{ver}/dfcdd.c
/lpfc-%{ver}/dfc.h
/lpfc-%{ver}/fcclockb.c
/lpfc-%{ver}/fc_crtn.h
/lpfc-%{ver}/fcdds.h
/lpfc-%{ver}/fcdiag.h
/lpfc-%{ver}/fcelsb.c
/lpfc-%{ver}/fc_ertn.h
/lpfc-%{ver}/fcfgparm.h
/lpfc-%{ver}/fc.h
/lpfc-%{ver}/fc_hw.h
/lpfc-%{ver}/fcLINUXfcp.c
/lpfc-%{ver}/fcLINUXlan.c
/lpfc-%{ver}/fcmboxb.c
/lpfc-%{ver}/fcmemb.c
/lpfc-%{ver}/fcmsgcom.c
/lpfc-%{ver}/fcmsg.h
/lpfc-%{ver}/fc_os.h
/lpfc-%{ver}/fcrpib.c
/lpfc-%{ver}/fcscsib.c
/lpfc-%{ver}/fcstratb.c
/lpfc-%{ver}/fcxmitb.c
/lpfc-%{ver}/hbaapi.h
/lpfc-%{ver}/lp6000.c
/lpfc-%{ver}/lpfc.conf.c
/lpfc-%{ver}/lpfc.conf.defs
/lpfc-%{ver}/Makefile
/lpfc-%{ver}/README
/lpfc-%{ver}/lpfc.spec
