/******************************************************************************/
/*                                                                            */
/* Broadcom BCM5700 Linux Network Driver, Copyright (c) 2000 - 2003 Broadcom  */
/* Corporation.                                                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This program is free software; you can redistribute it and/or modify       */
/* it under the terms of the GNU General Public License as published by       */
/* the Free Software Foundation, located in the file LICENSE.                 */
/*                                                                            */
/*                                                                            */
/*  Name: F W _ S T K O F F L D . H                                           */
/*  Author : Kevin Tran                                                       */
/*                                                                            */
/* Module Description:  This file contains firmware binary code of for TCP/IP */
/* stack offload support.  Currently, this firmware supports the following    */
/* features:                                                                  */
/*     1. TCP segmentation (aka Large Send Offload -- LSO)                    */
/*     2. UDP Checksum offload support for IP fragmented UDP frames.          */
/*                                                                            */
/* History:                                                                   */
/*    07/17/01 Kevin Tran       Incarnation.                                  */
/*    10/10/01 Kevin Tran       Added UDP checksum offload support.           */
/*    10/20/01 Kevin Tran       Fixed a problem where pseudo checksum is not  */
/*                              calculated correctly in case of IP            */
/*                              fragmentation case.                           */
/*    10/30/01 Kevin Tran       Fixed a problem where checksum is incorrectly */
/*                              computed if bit BD_FLAG_TCP_UDP_CKSUM is set  */
/*                              in Send BDs.                                  */
/*    05/30/02 Kevin Tran       Fixed a problem where UDP checksum is         */
/*                              incorrectly computed if the length of data is */
/*                              less than 6 bytes in the last packetst of     */
/*                              of a chain of fragmented IP/UDP packets.      */
/*    12/01/02 Kevin Tran       Fixed a problem where firmware might lockup   */
/*                              in a certain test scenario with BCM5704.      */
/*    12/10/02 Kevin Tran       Fixed a problem where IP checksum might be    */
/*                              incorrectly calculated in some corner cases.  */
/*                              This problem should ONLY happen with BCM5702/ */
/*                              BCM5703/BCM5704 ASICs.                        */
/*    06/20/03 Kevin Tran       Optimized performance so that pre-DMA code    */
/*                              doesn't have to wait until the first packet   */
/*                              is completely DMAed before it can setup DMAs  */
/*                              for subsequent packets.  This requires host   */
/*                              driver to pass IP/TCP option lengths if any   */
/*                              to F/W via bit 15..12 of Send BD flag.        */
/*                                                                            */
/******************************************************************************/

#ifndef __FW_STKOFFLD_H__ 
#define __FW_STKOFFLD_H__ 

typedef LM_UINT32 U32;

int t3StkOffLdFwReleaseMajor = 0x1;
int t3StkOffLdFwReleaseMinor = 0x4;
int t3StkOffLdFwReleaseFix = 0x0;
U32 t3StkOffLdFwStartAddr = 0x08000000;
U32 t3StkOffLdFwTextAddr = 0x08000000;
int t3StkOffLdFwTextLen = 0x1a90;
U32 t3StkOffLdFwRodataAddr = 0x08001a90;
int t3StkOffLdFwRodataLen = 0x60;
U32 t3StkOffLdFwDataAddr = 0x08001b20;
int t3StkOffLdFwDataLen = 0x20;
U32 t3StkOffLdFwSbssAddr = 0x08001b40;
int t3StkOffLdFwSbssLen = 0x2c;
U32 t3StkOffLdFwBssAddr = 0x08001b70;
int t3StkOffLdFwBssLen = 0x894;
U32 t3StkOffLdFwText[(0x1a90/4) + 1] = {
0x0, 0x10000003, 0x0, 
0xd, 0xd, 0x3c1d0800, 0x37bd4000, 
0x3a0f021, 0x3c100800, 0x26100000, 0xe000010, 
0x0, 0xd, 0x0, 0x0, 
0x0, 0x27bdffe0, 0x3c04fefe, 0xafbf0018, 
0xe0005d4, 0x34840002, 0xe000664, 0x0, 
0x3c030800, 0x90631b58, 0x24020002, 0x3c040800, 
0x24841a9c, 0x14620003, 0x24050001, 0x3c040800, 
0x24841a90, 0x24060003, 0x3821, 0xafa00010, 
0xe000678, 0xafa00014, 0x8f625c50, 0x34420001, 
0xaf625c50, 0x8f625c90, 0x34420001, 0xaf625c90, 
0x2402ffff, 0xe000034, 0xaf625404, 0x8fbf0018, 
0x3e00008, 0x27bd0020, 0x0, 0x0, 
0x0, 0x27bdffe0, 0xafbf001c, 0xafb20018, 
0xafb10014, 0xe00005b, 0xafb00010, 0x24120002, 
0x24110001, 0x8f706820, 0x32020100, 0x10400003, 
0x0, 0xe0000bb, 0x0, 0x8f706820, 
0x32022000, 0x10400004, 0x32020001, 0xe0001ef, 
0x24040001, 0x32020001, 0x10400003, 0x0, 
0xe0000a3, 0x0, 0x3c020800, 0x90421b88, 
0x14520003, 0x0, 0xe0004bf, 0x0, 
0xa00003c, 0xaf715028, 0x8fbf001c, 0x8fb20018, 
0x8fb10014, 0x8fb00010, 0x3e00008, 0x27bd0020, 
0x27bdffe0, 0x3c040800, 0x24841ab0, 0x2821, 
0x3021, 0x3821, 0xafbf0018, 0xafa00010, 
0xe000678, 0xafa00014, 0x3c040800, 0x248423c8, 
0xa4800000, 0x3c010800, 0xa0201b88, 0x3c010800, 
0xac201b8c, 0x3c010800, 0xac201b90, 0x3c010800, 
0xac201b94, 0x3c010800, 0xac201b9c, 0x3c010800, 
0xac201ba8, 0x3c010800, 0xac201bac, 0x8f624434, 
0x3c010800, 0xac221b78, 0x8f624438, 0x3c010800, 
0xac221b7c, 0x8f624410, 0xac80f7a8, 0x3c010800, 
0xac201b74, 0x3c010800, 0xac2023d0, 0x3c010800, 
0xac2023b8, 0x3c010800, 0xac2023bc, 0x3c010800, 
0xac2023f0, 0x3c010800, 0xac221b80, 0x8f620068, 
0x24030007, 0x21702, 0x10430005, 0x0, 
0x8f620068, 0x21702, 0x14400004, 0x24020001, 
0x3c010800, 0xa000097, 0xac2023fc, 0xac820034, 
0x3c040800, 0x24841abc, 0x3c050800, 0x8ca523fc, 
0x3021, 0x3821, 0xafa00010, 0xe000678, 
0xafa00014, 0x8fbf0018, 0x3e00008, 0x27bd0020, 
0x27bdffe0, 0x3c040800, 0x24841ac8, 0x2821, 
0x3021, 0x3821, 0xafbf0018, 0xafa00010, 
0xe000678, 0xafa00014, 0xe00005b, 0x0, 
0xe0000b4, 0x2021, 0x8fbf0018, 0x3e00008, 
0x27bd0020, 0x24020001, 0x8f636820, 0x821004, 
0x21027, 0x621824, 0x3e00008, 0xaf636820, 
0x27bdffd0, 0xafbf002c, 0xafb60028, 0xafb50024, 
0xafb40020, 0xafb3001c, 0xafb20018, 0xafb10014, 
0xafb00010, 0x8f675c5c, 0x3c030800, 0x24631bac, 
0x8c620000, 0x14470005, 0x3c0200ff, 0x3c020800, 
0x90421b88, 0x14400118, 0x3c0200ff, 0x3442fff8, 
0xe28824, 0xac670000, 0x111902, 0x306300ff, 
0x30e20003, 0x211c0, 0x622825, 0xa04021, 
0x71602, 0x3c030800, 0x90631b88, 0x3044000f, 
0x14600036, 0x804821, 0x24020001, 0x3c010800, 
0xa0221b88, 0x51100, 0x821025, 0x3c010800, 
0xac201b8c, 0x3c010800, 0xac201b90, 0x3c010800, 
0xac201b94, 0x3c010800, 0xac201b9c, 0x3c010800, 
0xac201ba8, 0x3c010800, 0xac201ba0, 0x3c010800, 
0xac201ba4, 0x3c010800, 0xa42223c8, 0x9622000c, 
0x30437fff, 0x3c010800, 0xa4222400, 0x30428000, 
0x3c010800, 0xa4231bb6, 0x10400005, 0x24020001, 
0x3c010800, 0xac2223e4, 0xa000102, 0x2406003e, 
0x24060036, 0x3c010800, 0xac2023e4, 0x9622000a, 
0x3c030800, 0x94631bb6, 0x3c010800, 0xac2023e0, 
0x3c010800, 0xac2023e8, 0x21302, 0x21080, 
0xc21021, 0x621821, 0x3c010800, 0xa42223c0, 
0x3c010800, 0xa000115, 0xa4231b86, 0x9622000c, 
0x3c010800, 0xa42223dc, 0x3c040800, 0x24841b8c, 
0x8c820000, 0x21100, 0x3c010800, 0x220821, 
0xac311bb8, 0x8c820000, 0x21100, 0x3c010800, 
0x220821, 0xac271bbc, 0x8c820000, 0x25030001, 
0x306601ff, 0x21100, 0x3c010800, 0x220821, 
0xac261bc0, 0x8c820000, 0x21100, 0x3c010800, 
0x220821, 0xac291bc4, 0x96230008, 0x3c020800, 
0x8c421b9c, 0x432821, 0x3c010800, 0xac251b9c, 
0x9622000a, 0x30420004, 0x14400018, 0x61100, 
0x8f630c14, 0x3063000f, 0x2c620002, 0x1440000b, 
0x3c02c000, 0x8f630c14, 0x3c020800, 0x8c421b30, 
0x3063000f, 0x24420001, 0x3c010800, 0xac221b30, 
0x2c620002, 0x1040fff7, 0x3c02c000, 0xe21825, 
0xaf635c5c, 0x8f625c50, 0x30420002, 0x10400014, 
0x0, 0xa000147, 0x0, 0x3c030800, 
0x8c631b70, 0x3c040800, 0x94841b84, 0x1221025, 
0x3c010800, 0xa42223ca, 0x24020001, 0x3c010800, 
0xac221ba8, 0x24630001, 0x85202a, 0x3c010800, 
0x10800003, 0xac231b70, 0x3c010800, 0xa4251b84, 
0x3c060800, 0x24c61b8c, 0x8cc20000, 0x24420001, 
0xacc20000, 0x28420080, 0x14400005, 0x0, 
0xe000652, 0x24040002, 0xa0001e5, 0x0, 
0x3c020800, 0x8c421ba8, 0x10400077, 0x24020001, 
0x3c050800, 0x90a51b88, 0x14a20071, 0x0, 
0x3c150800, 0x96b51b86, 0x3c040800, 0x8c841b9c, 
0x32a3ffff, 0x83102a, 0x1440006b, 0x0, 
0x14830003, 0x0, 0x3c010800, 0xac2523e0, 
0x1060005b, 0x9021, 0x24d60004, 0x60a021, 
0x24d30014, 0x8ec20000, 0x28100, 0x3c110800, 
0x2308821, 0xe000621, 0x8e311bb8, 0x402821, 
0x10a00053, 0x0, 0x9628000a, 0x31020040, 
0x10400004, 0x2407180c, 0x8e22000c, 0x2407188c, 
0xaca20018, 0x3c030800, 0x701821, 0x8c631bc0, 
0x3c020800, 0x501021, 0x8c421bc4, 0x31d00, 
0x21400, 0x621825, 0xaca30014, 0x8ec30004, 
0x96220008, 0x432023, 0x3242ffff, 0x3083ffff, 
0x431021, 0x282102a, 0x14400002, 0x2b23023, 
0x803021, 0x8e620000, 0x30c4ffff, 0x441021, 
0xae620000, 0x8e220000, 0xaca20000, 0x8e220004, 
0x8e63fff4, 0x431021, 0xaca20004, 0xa4a6000e, 
0x8e62fff4, 0x441021, 0xae62fff4, 0x96230008, 
0x43102a, 0x14400005, 0x2469021, 0x8e62fff0, 
0xae60fff4, 0x24420001, 0xae62fff0, 0xaca00008, 
0x3242ffff, 0x14540008, 0x24020305, 0x31020080, 
0x54400001, 0x34e70010, 0x24020905, 0xa4a2000c, 
0xa0001ca, 0x34e70020, 0xa4a2000c, 0x3c020800, 
0x8c4223e0, 0x10400003, 0x3c024b65, 0xa0001d2, 
0x34427654, 0x3c02b49a, 0x344289ab, 0xaca2001c, 
0x30e2ffff, 0xaca20010, 0xe00059f, 0xa02021, 
0x3242ffff, 0x54102b, 0x1440ffaa, 0x0, 
0x24020002, 0x3c010800, 0xa0001e5, 0xa0221b88, 
0x8ec2083c, 0x24420001, 0xa0001e5, 0xaec2083c, 
0xe0004bf, 0x0, 0x8fbf002c, 0x8fb60028, 
0x8fb50024, 0x8fb40020, 0x8fb3001c, 0x8fb20018, 
0x8fb10014, 0x8fb00010, 0x3e00008, 0x27bd0030, 
0x27bdffd0, 0xafbf0028, 0xafb30024, 0xafb20020, 
0xafb1001c, 0xafb00018, 0x8f725c9c, 0x3c0200ff, 
0x3442fff8, 0x3c060800, 0x24c61ba4, 0x2428824, 
0x9623000e, 0x8cc20000, 0x431021, 0xacc20000, 
0x8e220010, 0x30420020, 0x14400011, 0x809821, 
0xe000637, 0x2202021, 0x3c02c000, 0x2421825, 
0xaf635c9c, 0x8f625c90, 0x30420002, 0x10400121, 
0x0, 0xaf635c9c, 0x8f625c90, 0x30420002, 
0x1040011c, 0x0, 0xa00020c, 0x0, 
0x8e240008, 0x8e230014, 0x41402, 0x241c0, 
0x31502, 0x304201ff, 0x2442ffff, 0x3042007f, 
0x31942, 0x30637800, 0x21100, 0x24424000, 
0x625021, 0x9542000a, 0x3084ffff, 0x30420008, 
0x104000b3, 0x429c0, 0x3c020800, 0x8c4223f0, 
0x1440002d, 0x25050008, 0x95020014, 0x3c010800, 
0xa42223c0, 0x8d070010, 0x71402, 0x3c010800, 
0xa42223c2, 0x3c010800, 0xa42723c4, 0x9502000e, 
0x30e3ffff, 0x431023, 0x3c010800, 0xac2223f8, 
0x8f626800, 0x3c030010, 0x431024, 0x10400005, 
0x0, 0x9503001a, 0x9502001c, 0xa000241, 
0x431021, 0x9502001a, 0x3c010800, 0xac2223ec, 
0x3c02c000, 0x2421825, 0x3c010800, 0xac2823f0, 
0x3c010800, 0xac3223f4, 0xaf635c9c, 0x8f625c90, 
0x30420002, 0x104000df, 0x0, 0xaf635c9c, 
0x8f625c90, 0x30420002, 0x104000da, 0x0, 
0xa00024e, 0x0, 0x9502000e, 0x3c030800, 
0x946323c4, 0x434823, 0x3123ffff, 0x2c620008, 
0x1040001c, 0x0, 0x95020014, 0x24420028, 
0xa22821, 0x31042, 0x1840000b, 0x2021, 
0x24c60848, 0x403821, 0x94a30000, 0x8cc20000, 
0x24840001, 0x431021, 0xacc20000, 0x87102a, 
0x1440fff9, 0x24a50002, 0x31220001, 0x1040001f, 
0x3c024000, 0x3c040800, 0x248423ec, 0xa0a00001, 
0x94a30000, 0x8c820000, 0x431021, 0xa00028d, 
0xac820000, 0x8f626800, 0x3c030010, 0x431024, 
0x10400009, 0x0, 0x9502001a, 0x3c030800, 
0x8c6323ec, 0x431021, 0x3c010800, 0xac2223ec, 
0xa00028e, 0x3c024000, 0x9502001a, 0x9504001c, 
0x3c030800, 0x8c6323ec, 0x441023, 0x621821, 
0x3c010800, 0xac2323ec, 0x3c024000, 0x2421825, 
0xaf635c9c, 0x8f625c90, 0x30420002, 0x1440fffc, 
0x0, 0x9542000a, 0x30420010, 0x10400095, 
0x0, 0x3c060800, 0x24c623f0, 0x3c020800, 
0x944223c4, 0x8cc50000, 0x3c040800, 0x8c8423f8, 
0x24420030, 0xa22821, 0x94a20004, 0x3c030800, 
0x8c6323ec, 0x441023, 0x621821, 0x603821, 
0x32402, 0x30e2ffff, 0x823821, 0x71402, 
0xe23821, 0x71027, 0x3c010800, 0xac2323ec, 
0xa4a20006, 0x3c030800, 0x8c6323f4, 0x3c0200ff, 
0x3442fff8, 0x628824, 0x96220008, 0x24040001, 
0x24034000, 0x241c0, 0xe01021, 0xa502001a, 
0xa500001c, 0xacc00000, 0x3c010800, 0xac241b50, 
0xaf635cb8, 0x8f625cb0, 0x30420002, 0x10400003, 
0x0, 0x3c010800, 0xac201b50, 0x8e220008, 
0xaf625cb8, 0x8f625cb0, 0x30420002, 0x10400003, 
0x0, 0x3c010800, 0xac201b50, 0x3c020800, 
0x8c421b50, 0x1040ffec, 0x0, 0x3c040800, 
0xe000637, 0x8c8423f4, 0xa00032c, 0x0, 
0x3c030800, 0x90631b88, 0x24020002, 0x14620003, 
0x3c034b65, 0xa0002e3, 0x8021, 0x8e22001c, 
0x34637654, 0x10430002, 0x24100002, 0x24100001, 
0x1002021, 0xe000352, 0x2003021, 0x24020003, 
0x3c010800, 0xa0221b88, 0x24020002, 0x1202000a, 
0x24020001, 0x3c030800, 0x8c6323e0, 0x10620006, 
0x0, 0x3c020800, 0x944223c8, 0x21400, 
0xa000321, 0xae220014, 0x3c040800, 0x248423ca, 
0x94820000, 0x21400, 0xae220014, 0x3c020800, 
0x8c421bac, 0x3c03c000, 0x3c010800, 0xa0201b88, 
0x431025, 0xaf625c5c, 0x8f625c50, 0x30420002, 
0x10400009, 0x0, 0x2484f7e2, 0x8c820000, 
0x431025, 0xaf625c5c, 0x8f625c50, 0x30420002, 
0x1440fffa, 0x0, 0x3c020800, 0x24421b74, 
0x8c430000, 0x24630001, 0xac430000, 0x8f630c14, 
0x3063000f, 0x2c620002, 0x1440000c, 0x3c024000, 
0x8f630c14, 0x3c020800, 0x8c421b30, 0x3063000f, 
0x24420001, 0x3c010800, 0xac221b30, 0x2c620002, 
0x1040fff7, 0x0, 0x3c024000, 0x2421825, 
0xaf635c9c, 0x8f625c90, 0x30420002, 0x1440fffc, 
0x0, 0x12600003, 0x0, 0xe0004bf, 
0x0, 0x8fbf0028, 0x8fb30024, 0x8fb20020, 
0x8fb1001c, 0x8fb00018, 0x3e00008, 0x27bd0030, 
0x8f634450, 0x3c040800, 0x24841b78, 0x8c820000, 
0x31c02, 0x43102b, 0x14400007, 0x3c038000, 
0x8c840004, 0x8f624450, 0x21c02, 0x83102b, 
0x1040fffc, 0x3c038000, 0xaf634444, 0x8f624444, 
0x431024, 0x1440fffd, 0x0, 0x8f624448, 
0x3e00008, 0x3042ffff, 0x3c024000, 0x822025, 
0xaf645c38, 0x8f625c30, 0x30420002, 0x1440fffc, 
0x0, 0x3e00008, 0x0, 0x27bdffe0, 
0x805821, 0x14c00011, 0x256e0008, 0x3c020800, 
0x8c4223e4, 0x10400007, 0x24020016, 0x3c010800, 
0xa42223c2, 0x2402002a, 0x3c010800, 0xa000366, 
0xa42223c4, 0x8d670010, 0x71402, 0x3c010800, 
0xa42223c2, 0x3c010800, 0xa42723c4, 0x3c040800, 
0x948423c4, 0x3c030800, 0x946323c2, 0x95cf0006, 
0x3c020800, 0x944223c0, 0x832023, 0x1e2c023, 
0x3065ffff, 0x24a20028, 0x1c24821, 0x3082ffff, 
0x14c0001a, 0x1226021, 0x9582000c, 0x3042003f, 
0x3c010800, 0xa42223c6, 0x95820004, 0x95830006, 
0x3c010800, 0xac2023d4, 0x3c010800, 0xac2023d8, 
0x21400, 0x431025, 0x3c010800, 0xac221bb0, 
0x95220004, 0x3c010800, 0xa4221bb4, 0x95230002, 
0x1e51023, 0x43102a, 0x10400010, 0x24020001, 
0x3c010800, 0xa00039a, 0xac2223e8, 0x3c030800, 
0x8c6323d8, 0x3c020800, 0x94421bb4, 0x431021, 
0xa5220004, 0x3c020800, 0x94421bb0, 0xa5820004, 
0x3c020800, 0x8c421bb0, 0xa5820006, 0x3c020800, 
0x8c4223e0, 0x3c0d0800, 0x8dad23d4, 0x3c0a0800, 
0x144000e5, 0x8d4a23d8, 0x3c020800, 0x94421bb4, 
0x4a1821, 0x3063ffff, 0x62182b, 0x24020002, 
0x10c2000d, 0x1435023, 0x3c020800, 0x944223c6, 
0x30420009, 0x10400008, 0x0, 0x9582000c, 
0x3042fff6, 0xa582000c, 0x3c020800, 0x944223c6, 
0x30420009, 0x1a26823, 0x3c020800, 0x8c4223e8, 
0x1040004a, 0x1203821, 0x3c020800, 0x944223c2, 
0x4021, 0xa520000a, 0x1e21023, 0xa5220002, 
0x3082ffff, 0x21042, 0x18400008, 0x3021, 
0x401821, 0x94e20000, 0x25080001, 0xc23021, 
0x103102a, 0x1440fffb, 0x24e70002, 0x61c02, 
0x30c2ffff, 0x623021, 0x61402, 0xc23021, 
0xc02821, 0x61027, 0xa522000a, 0x3021, 
0x2527000c, 0x4021, 0x94e20000, 0x25080001, 
0xc23021, 0x2d020004, 0x1440fffb, 0x24e70002, 
0x95220002, 0x4021, 0x91230009, 0x442023, 
0x1803821, 0x3082ffff, 0xa4e00010, 0x621821, 
0x21042, 0x18400010, 0xc33021, 0x404821, 
0x94e20000, 0x24e70002, 0xc23021, 0x30e2007f, 
0x14400006, 0x25080001, 0x8d630000, 0x3c02007f, 
0x3442ff80, 0x625824, 0x25670008, 0x109102a, 
0x1440fff3, 0x0, 0x30820001, 0x10400005, 
0x61c02, 0xa0e00001, 0x94e20000, 0xc23021, 
0x61c02, 0x30c2ffff, 0x623021, 0x61402, 
0xc23021, 0xa00047f, 0x30c6ffff, 0x24020002, 
0x14c20081, 0x0, 0x3c020800, 0x8c4223fc, 
0x14400007, 0x0, 0x3c020800, 0x944223c2, 
0x95230002, 0x1e21023, 0x10620077, 0x0, 
0x3c020800, 0x944223c2, 0x1e21023, 0xa5220002, 
0x3c020800, 0x8c4223fc, 0x1040001a, 0x31e3ffff, 
0x8dc70010, 0x3c020800, 0x94421b86, 0xe04021, 
0x72c02, 0xaa2021, 0x431023, 0x823823, 
0x72402, 0x30e2ffff, 0x823821, 0x71027, 
0xa522000a, 0x3102ffff, 0x3c040800, 0x948423c4, 
0x453023, 0xe02821, 0x641823, 0x6d1821, 
0xc33021, 0x61c02, 0x30c2ffff, 0xa00047f, 
0x623021, 0x1203821, 0x4021, 0x3082ffff, 
0x21042, 0x18400008, 0x3021, 0x401821, 
0x94e20000, 0x25080001, 0xc23021, 0x103102a, 
0x1440fffb, 0x24e70002, 0x61c02, 0x30c2ffff, 
0x623021, 0x61402, 0xc23021, 0xc02821, 
0x61027, 0xa522000a, 0x3021, 0x2527000c, 
0x4021, 0x94e20000, 0x25080001, 0xc23021, 
0x2d020004, 0x1440fffb, 0x24e70002, 0x95220002, 
0x4021, 0x91230009, 0x442023, 0x1803821, 
0x3082ffff, 0xa4e00010, 0x3c040800, 0x948423c4, 
0x621821, 0xc33021, 0x61c02, 0x30c2ffff, 
0x623021, 0x61c02, 0x3c020800, 0x944223c0, 
0xc34821, 0x441023, 0x21fc2, 0x431021, 
0x21043, 0x18400010, 0x3021, 0x402021, 
0x94e20000, 0x24e70002, 0xc23021, 0x30e2007f, 
0x14400006, 0x25080001, 0x8d630000, 0x3c02007f, 
0x3442ff80, 0x625824, 0x25670008, 0x104102a, 
0x1440fff3, 0x0, 0x3c020800, 0x944223dc, 
0xc23021, 0x3122ffff, 0xc23021, 0x61c02, 
0x30c2ffff, 0x623021, 0x61402, 0xc23021, 
0xc04021, 0x61027, 0xa5820010, 0xadc00014, 
0xa00049f, 0xadc00000, 0x8dc70010, 0xe04021, 
0x11400007, 0x72c02, 0xaa3021, 0x61402, 
0x30c3ffff, 0x433021, 0x61402, 0xc22821, 
0x51027, 0xa522000a, 0x3c030800, 0x946323c4, 
0x3102ffff, 0x1e21021, 0x433023, 0xcd3021, 
0x61c02, 0x30c2ffff, 0x623021, 0x61402, 
0xc23021, 0xc04021, 0x61027, 0xa5820010, 
0x3102ffff, 0x51c00, 0x431025, 0xadc20010, 
0x3c020800, 0x8c4223e4, 0x10400002, 0x25e2fff2, 
0xa5c20034, 0x3c020800, 0x8c4223d8, 0x3c040800, 
0x8c8423d4, 0x24420001, 0x3c010800, 0xac2223d8, 
0x3c020800, 0x8c421bb0, 0x3303ffff, 0x832021, 
0x3c010800, 0xac2423d4, 0x431821, 0x62102b, 
0x10400003, 0x2482ffff, 0x3c010800, 0xac2223d4, 
0x3c010800, 0xac231bb0, 0x3e00008, 0x27bd0020, 
0x27bdffb8, 0x3c050800, 0x24a51b86, 0xafbf0044, 
0xafbe0040, 0xafb7003c, 0xafb60038, 0xafb50034, 
0xafb40030, 0xafb3002c, 0xafb20028, 0xafb10024, 
0xafb00020, 0x94a90000, 0x3c020800, 0x944223c0, 
0x3c030800, 0x8c631ba0, 0x3c040800, 0x8c841b9c, 
0x1221023, 0x64182a, 0xa7a9001e, 0x106000bc, 
0xa7a20016, 0x24be0022, 0x97b6001e, 0x24b3001a, 
0x24b70016, 0x8fc20000, 0x14400008, 0x0, 
0x8fc2fff8, 0x97a30016, 0x8fc4fff4, 0x431021, 
0x82202a, 0x148000ae, 0x0, 0x97d50818, 
0x32a2ffff, 0x104000a1, 0x9021, 0x40a021, 
0x8821, 0xe000621, 0x0, 0x403021, 
0x14c00007, 0x0, 0x3c020800, 0x8c4223cc, 
0x24420001, 0x3c010800, 0xa000593, 0xac2223cc, 
0x3c100800, 0x2118021, 0x8e101bb8, 0x9608000a, 
0x31020040, 0x10400004, 0x2407180c, 0x8e02000c, 
0x2407188c, 0xacc20018, 0x31020080, 0x54400001, 
0x34e70010, 0x3c020800, 0x511021, 0x8c421bc0, 
0x3c030800, 0x711821, 0x8c631bc4, 0x21500, 
0x31c00, 0x431025, 0xacc20014, 0x96040008, 
0x3242ffff, 0x821021, 0x282102a, 0x14400002, 
0x2b22823, 0x802821, 0x8e020000, 0x2459021, 
0xacc20000, 0x8e020004, 0xc02021, 0x26310010, 
0xac820004, 0x30e2ffff, 0xac800008, 0xa485000e, 
0xac820010, 0x24020305, 0xe00059f, 0xa482000c, 
0x3242ffff, 0x54102b, 0x1440ffc6, 0x3242ffff, 
0xa00058b, 0x0, 0x8e620000, 0x8e63fffc, 
0x43102a, 0x10400066, 0x0, 0x8e62fff0, 
0x28900, 0x3c100800, 0x2118021, 0xe000621, 
0x8e101bb8, 0x403021, 0x14c00005, 0x0, 
0x8e62082c, 0x24420001, 0xa000593, 0xae62082c, 
0x9608000a, 0x31020040, 0x10400004, 0x2407180c, 
0x8e02000c, 0x2407188c, 0xacc20018, 0x3c020800, 
0x511021, 0x8c421bc0, 0x3c030800, 0x711821, 
0x8c631bc4, 0x21500, 0x31c00, 0x431025, 
0xacc20014, 0x8e63fff4, 0x96020008, 0x432023, 
0x3242ffff, 0x3083ffff, 0x431021, 0x2c2102a, 
0x10400003, 0x802821, 0x97a9001e, 0x1322823, 
0x8e620000, 0x30a4ffff, 0x441021, 0xae620000, 
0xa4c5000e, 0x8e020000, 0xacc20000, 0x8e020004, 
0x8e63fff4, 0x431021, 0xacc20004, 0x8e63fff4, 
0x96020008, 0x641821, 0x62102a, 0x14400006, 
0x2459021, 0x8e62fff0, 0xae60fff4, 0x24420001, 
0xa00056e, 0xae62fff0, 0xae63fff4, 0xacc00008, 
0x3242ffff, 0x10560003, 0x31020004, 0x10400006, 
0x24020305, 0x31020080, 0x54400001, 0x34e70010, 
0x34e70020, 0x24020905, 0xa4c2000c, 0x8ee30000, 
0x8ee20004, 0x14620007, 0x3c02b49a, 0x8ee20860, 
0x54400001, 0x34e70400, 0x3c024b65, 0xa000585, 
0x34427654, 0x344289ab, 0xacc2001c, 0x30e2ffff, 
0xacc20010, 0xe00059f, 0xc02021, 0x3242ffff, 
0x56102b, 0x1440ff9c, 0x0, 0x8e620000, 
0x8e63fffc, 0x43102a, 0x1440ff4a, 0x0, 
0x8fbf0044, 0x8fbe0040, 0x8fb7003c, 0x8fb60038, 
0x8fb50034, 0x8fb40030, 0x8fb3002c, 0x8fb20028, 
0x8fb10024, 0x8fb00020, 0x3e00008, 0x27bd0048, 
0x27bdffe8, 0xafbf0014, 0xafb00010, 0x8f624450, 
0x8f634410, 0xa0005ae, 0x808021, 0x8f626820, 
0x30422000, 0x10400003, 0x0, 0xe0001ef, 
0x2021, 0x8f624450, 0x8f634410, 0x3042ffff, 
0x43102b, 0x1440fff5, 0x0, 0x8f630c14, 
0x3063000f, 0x2c620002, 0x1440000b, 0x0, 
0x8f630c14, 0x3c020800, 0x8c421b30, 0x3063000f, 
0x24420001, 0x3c010800, 0xac221b30, 0x2c620002, 
0x1040fff7, 0x0, 0xaf705c18, 0x8f625c10, 
0x30420002, 0x10400009, 0x0, 0x8f626820, 
0x30422000, 0x1040fff8, 0x0, 0xe0001ef, 
0x2021, 0xa0005c1, 0x0, 0x8fbf0014, 
0x8fb00010, 0x3e00008, 0x27bd0018, 0x0, 
0x0, 0x27bdffe8, 0x3c1bc000, 0xafbf0014, 
0xafb00010, 0xaf60680c, 0x8f626804, 0x34420082, 
0xaf626804, 0x8f634000, 0x24020b50, 0x3c010800, 
0xac221b44, 0x24020b78, 0x3c010800, 0xac221b54, 
0x34630002, 0xaf634000, 0xe000601, 0x808021, 
0x3c010800, 0xa0221b58, 0x304200ff, 0x24030002, 
0x14430005, 0x0, 0x3c020800, 0x8c421b44, 
0xa0005f4, 0xac5000c0, 0x3c020800, 0x8c421b44, 
0xac5000bc, 0x8f624434, 0x8f634438, 0x8f644410, 
0x3c010800, 0xac221b4c, 0x3c010800, 0xac231b5c, 
0x3c010800, 0xac241b48, 0x8fbf0014, 0x8fb00010, 
0x3e00008, 0x27bd0018, 0x3c040800, 0x8c870000, 
0x3c03aa55, 0x3463aa55, 0x3c06c003, 0xac830000, 
0x8cc20000, 0x14430007, 0x24050002, 0x3c0355aa, 
0x346355aa, 0xac830000, 0x8cc20000, 0x50430001, 
0x24050001, 0x3c020800, 0xac470000, 0x3e00008, 
0xa01021, 0x27bdfff8, 0x18800009, 0x2821, 
0x8f63680c, 0x8f62680c, 0x1043fffe, 0x0, 
0x24a50001, 0xa4102a, 0x1440fff9, 0x0, 
0x3e00008, 0x27bd0008, 0x8f634450, 0x3c020800, 
0x8c421b4c, 0x31c02, 0x43102b, 0x14400008, 
0x3c038000, 0x3c040800, 0x8c841b5c, 0x8f624450, 
0x21c02, 0x83102b, 0x1040fffc, 0x3c038000, 
0xaf634444, 0x8f624444, 0x431024, 0x1440fffd, 
0x0, 0x8f624448, 0x3e00008, 0x3042ffff, 
0x3082ffff, 0x2442e000, 0x2c422001, 0x14400003, 
0x3c024000, 0xa000644, 0x2402ffff, 0x822025, 
0xaf645c38, 0x8f625c30, 0x30420002, 0x1440fffc, 
0x1021, 0x3e00008, 0x0, 0x8f624450, 
0x3c030800, 0x8c631b48, 0xa00064d, 0x3042ffff, 
0x8f624450, 0x3042ffff, 0x43102b, 0x1440fffc, 
0x0, 0x3e00008, 0x0, 0x27bdffe0, 
0x802821, 0x3c040800, 0x24841ae0, 0x3021, 
0x3821, 0xafbf0018, 0xafa00010, 0xe000678, 
0xafa00014, 0xa00065c, 0x0, 0x8fbf0018, 
0x3e00008, 0x27bd0020, 0x0, 0x0, 
0x0, 0x3c020800, 0x34423000, 0x3c030800, 
0x34633000, 0x3c040800, 0x348437ff, 0x3c010800, 
0xac221b64, 0x24020040, 0x3c010800, 0xac221b68, 
0x3c010800, 0xac201b60, 0xac600000, 0x24630004, 
0x83102b, 0x5040fffd, 0xac600000, 0x3e00008, 
0x0, 0x804821, 0x8faa0010, 0x3c020800, 
0x8c421b60, 0x3c040800, 0x8c841b68, 0x8fab0014, 
0x24430001, 0x44102b, 0x3c010800, 0xac231b60, 
0x14400003, 0x4021, 0x3c010800, 0xac201b60, 
0x3c020800, 0x8c421b60, 0x3c030800, 0x8c631b64, 
0x91240000, 0x21140, 0x431021, 0x481021, 
0x25080001, 0xa0440000, 0x29020008, 0x1440fff4, 
0x25290001, 0x3c020800, 0x8c421b60, 0x3c030800, 
0x8c631b64, 0x8f64680c, 0x21140, 0x431021, 
0xac440008, 0xac45000c, 0xac460010, 0xac470014, 
0xac4a0018, 0x3e00008, 0xac4b001c, 0x0, 
0x0, 0x0 };
U32 t3StkOffLdFwRodata[(0x60/4) + 1] = {
0x4d61696e, 
0x43707542, 0x0, 0x4d61696e, 0x43707541, 
0x0, 0x0, 0x0, 0x73746b6f, 
0x66666c64, 0x496e0000, 0x73746b6f, 0x66662a2a, 
0x0, 0x53774576, 0x656e7430, 0x0, 
0x0, 0x0, 0x0, 0x66617461, 
0x6c457272, 0x0, 0x0, 0x0 };
U32 t3StkOffLdFwData[(0x20/4) + 1] = {
0x0, 
0x0, 0x0, 0x0, 0x0, 
0x0, 0x0, 0x0, 0x0 };

#endif /* __FW_STKOFFLD_H__  */
