#ifndef CENATEK_H
#define CENATEK_H

#include <linux/config.h>
#include <linux/pci.h>
#include <linux/ide.h>

static unsigned int init_chipset_cenatek(struct pci_dev *, const char *);
static void init_hwif_cenatek(ide_hwif_t *);
static void init_dma_cenatek(ide_hwif_t *, unsigned long);

static ide_pci_device_t cenatek_chipsets[] __devinitdata = {
	{
		vendor:		PCI_VENDOR_ID_CENATEK,
		device:		PCI_DEVICE_ID_CENATEK_IDE,
		name:		"cenatek",
		init_chipset:	init_chipset_cenatek,
		init_iops:	NULL,
		init_hwif:	init_hwif_cenatek,
		init_dma:	init_dma_cenatek,
		channels:	2,
		autodma:	AUTODMA,
		bootable:	EOL,
		extra:		0,
	},
};


#endif /* CENATEK_H */
