.TH SR 1 "7 October 2002"
.SH NAME
sr \- invoke sysrq commands from kdb
.SH SYNOPSIS
sr \fIx\fP
.SH DESCRIPTION
.hy 0
The
.B sr 
command invokes the existing sysrq handler code in the kernel.
This command takes a single character which is passed to sysrq
processing, as if you had entered the sysrq key sequence followed by
that character.
.P
.B Caveats:
.P
kdb will always call the sysrq code but sysrq may be disabled.
If you expect to use sysrq functions during debugging then
.IP ""
echo "1" > /proc/sys/kernel/sysrq
.P
before starting the debug session.
Alternatively issue
.IP ""
mm4 sysrq_enabled 1
.P
during debugging.
.P
The sysrq code prints a heading using console loglevel 7 then reverts
to the original loglevel for the rest of the sysrq processing.
If the rest of the sysrq output is printed at a level below your
current loglevel then you will not see the output on the kdb console,
the output will only appear in the printk buffer.
It is the user's responsibility to set the loglevel correctly if they
want to see the sysrq output on the console.
Issue
.IP ""
sr 7
.P
before any other
.B sr
commands if you want to see the output on the console.
You may even have to adjust the default message loglevel in order to
see any output from
.BR sr .
See Documentation/sysctl/kernel.txt for details on setting console
loglevels via /proc.
You can also adjust the loglevel variables via kdb
.BR mm ;
on older kernels there are variables such as default_message_level, on
newer kernels all the loglevel variables are in array console_printk,
see kernel/printk.c for your kernel.
.P
Operations that require interrupt driven I/O can be invoked from kdb
.BR sr ,
but they will not do anything until you type 'go' to exit from kdb
(interrupts are disabled while in kdb).
There is no guarantee that these operations will work, if the machine
entered kdb because of an error then interrupt driven I/O may already
be dead.
Do not assume that
.B sr\ s
does anything useful.
.P
The sysrq handler uses locks and calls printk which also uses locks.
If the sysrq handler or any of the sysrq functions have to wait for a
lock then they will never return and kdb will appear to hang.
Invoking sysrq code from kdb is inherently unsafe.
