/* osdtest.c 
 *   by Nathan Laredo (laredo@gnu.org)
 *
 * Stradis 4:2:2 MPEG-2 Decoder Driver
 * Copyright (C) 1999 Nathan Laredo <laredo@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <linux/types.h>
#include <linux/videodev.h>

int videofd;
int f;

unsigned char osdbuf[131072];

void writeosd(char *buf, int length)
{
	int mode = VID_WRITE_OSD;

	ioctl(videofd, VIDIOCSWRITEMODE, &mode);
	write(videofd, buf, length);
}

int main(int argc, char **argv)
{
	int d = 0, size;
	char outf[25];
	struct stat st;

	if (argc < 2) {
		fprintf(stderr,
			"usage: %s osdfile device\n", argv[0]);
		exit(1);
	}
	if ((f = open(argv[1], O_RDONLY)) < 0) {
		perror(argv[1]);
		exit(1);
	}
	d = atoi(argv[2]);
	size = read(f, osdbuf, 524288);
	sprintf(outf, "/dev/video%d", d);
	if ((videofd = open(outf, O_RDWR)) < 0) {
		perror(outf);
		exit(1);
	}
	writeosd(osdbuf, size);
	close(f);
	exit(0);
}				/* main */
